/*
 * @cmnLASCurveStruct.java Version 1.1 02/25/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

/** Class cmnLASCurveStruct
 *  <p> This class will hold the LAS Curve data.
 *
 *  @version 1.1 02/25/2004
 *  @author  John R. Victorine
 */

public class cmnLASCurveStruct
{
  public String sKID              = "0";  // Primary KEY of LAS File
  public String sToolKID          = "0";  // Primary KEY of Tool KID
  public String sMnemonic         = "";   // Mnemonic Name of Curve
  public int    iCurveNumber      = 0;    // Curve Column Number in LAS File
  public String sCurveName        = "";   // Curve Name
  public String sCurveUnits       = "";   // Curve Units
  public String sCurveDescription = "";   // Description of the Curve
  public double dMinimumValue     = 0.0;  // Minimum Value of Curve
  public double dMaximumValue     = 0.0;  // Maximum Value of Curve
  public int    iOrder            = 0;    // Order of Curve (initial sorting)
  public int    iTrack            = 0;    // Track the Curve should reside
  public double dToolMinimumValue = 0.0;  // Minimum Curve Tool Value
  public double dToolMaximumValue = 0.0;  // Maximum Curve Tool Value

  public int    iAssoc            = 0;    // Total Number of Associations
  public String sAssoc[]          = null; // Associations with Curve

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKID              = null; // Primary KEY of LAS File
    sToolKID          = null; // Primary KEY of Tool KID
    sMnemonic         = null; // Mnemonic Name of Curve
    iCurveNumber      = 0;    // Curve Column Number in LAS File
    sCurveName        = null; // Curve Name
    sCurveUnits       = null; // Curve Units
    sCurveDescription = null; // Description of the Curve
    dMinimumValue     = 0.0;  // Minimum Value of Curve
    dMaximumValue     = 0.0;  // Maximum Value of Curve
    iOrder            = 0;    // Order of Curve (initial sorting)
    iTrack            = 0;    // Track the Curve should reside
    dToolMinimumValue = 0.0;  // Minimum Curve Tool Value
    dToolMaximumValue = 0.0;  // Maximum Curve Tool Value

    iAssoc            = 0;    // Total Number of Associations
    sAssoc            = null; // Associations with Curve
  }
}
