/*
 * @brinePlotStruct.java Version 1.1 06/08/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.plot;

/** CLASS brinePlotStruct
 *  <p> This Class holds the Brine Plot Data.
 *
 *  @version 1.1 06/08/2011
 *  @author  John R. Victorine
 */

public class brinePlotStruct
{
  public double depthStart = 0.0;
  public double depthEnd   = 0.0;

  // common brine chemical data
  // -- mg/l

  public double mgl_cations[] = null;
  public double mgl_anions[]  = null;

  // -- milli-equivalents/l

  public double meql_cations[] = null;
  public double meql_anions[]  = null;

  // -- percent milli-equivalents/l

  public double per_meql_cations[] = null;
  public double per_meql_anions[]  = null;

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    // common brine chemical data
    // -- mg/l

    mgl_cations = null;
    mgl_anions  = null;

    // -- milli-equivalents/l

    meql_cations = null;
    meql_anions  = null;

    // -- percent milli-equivalents/l

    per_meql_cations = null;
    per_meql_anions  = null;
  }
}