/*
 * @brineDiamondPlot.java Version 1.1 06/16/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.plot;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** CLASS brineDiamondPlot
 *  <p> This Class will create the Ternary Plot.
 *
 *  @version 1.1 06/16/2011
 *  @author  John R. Victorine
 */

public class brineDiamondPlot extends Canvas
{
  private double dRLower     = 0.0;   // Lower Right-Axis Value
  private double dRUpper     = 100.0; // Upper Right-Axis Value
  private double dRIncrement = 20.0;  // Increment Right-Axis for Linear

  private double dLLower     = 0.0;   // Lower Left-Axis Value
  private double dLUpper     = 100.0; // Upper Left-Axis Value
  private double dLIncrement = 20.0;  // Increment Left-Axis for Linear

  private String sULTitle    = "";    // Upper Left Axis Title
  private String sLLTitle    = "";    // Lower Left Axis Title
  private String sURTitle    = "";    // Upper Right Axis Title
  private String sLRTitle    = "";    // Lower Right Axis Title

  private int    iXBegin     = 10;    // Starting X Position
  private int    iYBegin     = 10;    // Starting Y Position

  private int    iWidth      = 254;   // Width of Drawing Area
  private int    iHeight     = 440;   // Height of Drawing Area

  /** CONSTRUCTOR brineDiamondPlot()
   *  <p> This is the constructor for this class.
   */

  public brineDiamondPlot()
  {
	this.setBackground(Color.white);
  }

  /** Method close()
   * <p> This method will set object to null to force JAVA
   *     to reallocate memory
   */

  public void close()
  {
    sULTitle = null;  // Upper Left Axis Title
    sLLTitle = null;  // Lower Left Axis Title
    sURTitle = null;  // Upper Right Axis Title
    sLRTitle = null;  // Lower Right Axis Title
  }

  /* =============================================================== *
   * ------------------------ SET METHODS -------------------------- *
   * =============================================================== */

  /** Method setUpperLeftTitle()
   *  <p> This method will set the Title of Plot
   *  @param sTitle = The Title of the Plot
   */

  public void setUpperLeftTitle(String sTitle)
  {
    this.sULTitle = new String(sTitle);
  }

  /** Method setLowerLeftTitle()
   *  <p> This method will set the Title of Plot
   *  @param sTitle = The Title of the Plot
   */

  public void setLowerLeftTitle(String sTitle)
  {
    this.sLLTitle = new String(sTitle);
  }

  /** Method setUpperRightTitle()
   *  <p> This method will set the Title of Plot
   *  @param sTitle = The Title of the Plot
   */

  public void setUpperRightTitle(String sTitle)
  {
    this.sURTitle = new String(sTitle);
  }

  /** Method setLowerRightTitle()
   *  <p> This method will set the Title of Plot
   *  @param sTitle = The Title of the Plot
   */

  public void setLowerRightTitle(String sTitle)
  {
    this.sLRTitle = new String(sTitle);
  }

  /* =============================================================== *
   * ------------------------ DRAW METHODS ------------------------- *
   * =============================================================== */

  /** Method drawLabels()
   *  <p> This method will draw the Labels
   *  @param g = Graphics pointer.
   *  @param X = Starting X Point on plot
   *  @param Y = Starting Y Point on plot
   */

  public void drawAxisLabels(Graphics g, int X, int Y)
  {
    g.drawString( sULTitle, X+iXBegin+iWidth/16,
                            Y+iYBegin+(iHeight/4) ); //Y+iYBegin+(iHeight/4)-20 );
    g.drawString( sLLTitle, X+iXBegin-25, //X+iXBegin-15,
                            Y+iYBegin+(iHeight/2)+20 );
    g.drawString( sURTitle, X+iXBegin+3*iWidth/4 + 10,  //X+iXBegin+3*iWidth/4,
                            Y+iYBegin+(iHeight/4) ); //Y+iYBegin+(iHeight/4)-20 );
    g.drawString( sLRTitle, X+iXBegin+iWidth, //X+iXBegin+iWidth-15,
                            Y+iYBegin+(iHeight/2)+20 );
  }

  /** Method drawGrid()
   * <p> This method will draw the grid
   *  @param g = Graphics pointer.
   *  @param X = Starting X Point on plot
   *  @param Y = Starting Y Point on plot
   */

  public void drawGrid(Graphics g, int X, int Y)
  {
	drawRightGrid( g, X, Y);
	drawLeftGrid( g, X, Y);
  }

  /** Method drawRightGrid()
   * <p> This method will draw a Right Linear Grid
   *  @param g = Graphics pointer.
   *  @param X = Starting X Point on plot
   *  @param Y = Starting Y Point on plot
   */

  public void drawRightGrid(Graphics g, int X, int Y)
  {
	int    iTotal = 0;
	int    iX1    = 0;
	int    iX2    = 0;
	int    iY1    = 0;
	int    iY2    = 0;
    int    istr   = 0;
	double dX     = 0.0;
	double dY     = 0.0;
    double ratio  = 0.0;

    Font        fsb  = new Font("Monospaced", Font.BOLD, 11);
    FontMetrics fsbm = g.getFontMetrics(fsb);
    g.setFont( fsb );

    // Build the Right Linear Grid

    iTotal = (int) (1.0 + Math.abs(Math.ceil((dRUpper-dRLower)/dRIncrement)));

    for (int i=0; i<iTotal; i++)
    {
      dX = (double) (iWidth * i) * dRIncrement /
                   (2.0 * Math.abs(dRUpper-dRLower));
      dY = (((double) iWidth/2.0)-dX)*Math.tan(Math.PI/3.0);

      iX1 = X + iXBegin + (int) dX;
      iY1 = Y + iYBegin + (int) dY;
      iX2 = X + iXBegin + iWidth/2  + (int) dX;
      iY2 = Y + iYBegin + iHeight/2 + (int) dY;

      g.setColor(Color.lightGray);
      g.drawLine(iX1, iY1, iX2, iY2);

      g.setColor(Color.black);

      istr = (int) (dRUpper - i * dRIncrement);

      if ((i!=0) && (i<iTotal-1))
        g.drawString( ""+istr, iX2, iY2+10 );
//        g.drawString( ""+istr, iX2, iY2 );

      istr = (int) (dRLower + i * dRIncrement);

      if ((i!=0) && (i<iTotal-1))
        g.drawString( ""+istr, iX1-15, iY1-5 );
//        g.drawString( ""+istr, iX1-15, iY1-15 );
    }
  }

  /** Method drawLeftGrid()
   * <p> This method will draw a Left Linear Grid
   *  @param g = Graphics pointer.
   *  @param X = Starting X Point on plot
   *  @param Y = Starting Y Point on plot
   */

  public void drawLeftGrid(Graphics g, int X, int Y)
  {
	int    iTotal = 0;
	int    iX1    = 0;
	int    iX2    = 0;
	int    iY1    = 0;
	int    iY2    = 0;
    int    istr   = 0;
	double dX     = 0.0;
	double dY     = 0.0;
    double ratio  = 0.0;

    Font        fsb  = new Font("Monospaced", Font.BOLD, 11);
    FontMetrics fsbm = g.getFontMetrics(fsb);
    g.setFont( fsb );

    // Build the Right Linear Grid

    iTotal = (int) (1.0 + Math.abs(Math.ceil((dLUpper-dLLower)/dLIncrement)));

    for (int i=0; i<iTotal; i++)
    {
      dX = (double) (iWidth * i) * dLIncrement /
                   (2.0 * Math.abs(dLUpper-dLLower));
      dY = (((double) iWidth/2.0)-dX)*Math.tan(Math.PI/3.0);

      iX1 = X + iXBegin + (int) dX;
      iY1 = Y + iYBegin + iHeight   - (int) dY;
      iX2 = X + iXBegin + iWidth/2  + (int) dX;
      iY2 = Y + iYBegin + iHeight/2 - (int) dY;

      g.setColor(Color.lightGray);
      g.drawLine(iX1, iY1, iX2, iY2);

      g.setColor(Color.black);

      istr = (int) (dLUpper - i * dLIncrement);

      if ((i!=0) && (i<iTotal-1))
        g.drawString( ""+istr, iX2+10, iY2 );
//        g.drawString( ""+istr, iX2+10, iY2-10 );

      istr = (int) (dLLower + i * dLIncrement);

      if ((i!=0) && (i<iTotal-1))
        g.drawString( ""+istr, iX1-15, iY1 );
//        g.drawString( ""+istr, iX1-15, iY1 );
    }
  }

  /** Method drawPoint()
   * <p> This method will draw the point
   *  @param g  = Graphics pointer.
   *  @param X  = Starting X Point on plot
   *  @param Y  = Starting Y Point on plot
   *  @param dX = X data Point on plot
   *  @param dY = Y data Point on plot
   */

  public void drawPoint(Graphics g, int X, int Y,
                        double dX, double dY)
  {
    int    iX  = 0;
    int    iY  = 0;
    double dXv = 0.0;
    double dYv = 0.0;
    double dXr = 0.0;
    double dYr = 0.0;

    dXv = iWidth * (dX-dLLower) / (dLUpper-dLLower);
    dYv = iWidth * (dY-dRLower) / (dRUpper-dRLower);

    dXr = dXv - dYv * Math.sin(Math.PI/6.0);
    dYr = dYv * Math.cos(Math.PI/6.0);

    iX = (int) (dYr*Math.sin(Math.PI/3) + dXr*Math.cos(Math.PI/3));              ;
    iY = (int) (dYr*Math.cos(Math.PI/3) - dXr*Math.sin(Math.PI/3));

    g.setColor(Color.red);
    g.fillRect(X+iXBegin+iX-3, Y+(iYBegin+iHeight/2)-iY-3, 6, 6);
  }

  /** Method draw()
   * <p> This method will draw Diamond Plot
   *  @param g = Graphics pointer.
   *  @param X = Starting X Point on plot
   *  @param Y = Starting Y Point on plot
   */

  public void draw(Graphics g, int X, int Y)
  {
    drawAxisLabels( g, X, Y );
    drawGrid( g, X, Y );
  }

  /** Method paint( Graphics g )
   * <p> This method will paint the stiff diagram Plot
   * @param g = Graphics Parameter.
   */

  public void paint( Graphics g )
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);
  }
}

/*
 *  @version 1.1 06/16/2011
 *  @author  John Victorine
 */
