/*
 * @brineStiffPlotFrame.java Version 1.1 06/10/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import brine.plot.brinePlotStruct;     // Common Brine Data Sample
import brine.gui.brineStiffPlotPanel;  // Brine Stiff Plot Panel

/** Class brineStiffPlotFrame
 *  <p> This Class will create the Stiff Frame.
 *
 *  @version 1.1 06/10/2011
 *  @author  John R. Victorine
 */

public class brineStiffPlotFrame extends JFrame implements ActionListener
{
  // Variables passed to this panel

  private brinePlotStruct     st   = null;
  private brineStiffPlotPanel plot = null;

  /** Constructor brineStiffPlotFrame()
   *  <p> This is the Constructor for this class.
   *  @param st  = Brine Plot Data Structure
   */

  public brineStiffPlotFrame( brinePlotStruct st )
  {
    try
    {
      this.st = st;

      jbInit();

      addWindowListener( new brineStiffPlotFrame_WindowListener() );
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    this.setTitle("Stiff Diagram");
    this.getContentPane().setLayout(new BorderLayout());

    plot = new brineStiffPlotPanel( st );

    this.getContentPane().add(plot, BorderLayout.CENTER);

    // Display the Frame

    this.setSize(new Dimension(350, 250));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
//    this.setLocation((d.width  - this.getSize().width) / 2,
//                     (d.height - this.getSize().height) / 2);
    this.setLocation( 10, 10 );

    this.setResizable(false);
    this.setVisible(false);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    st = null;

    if (plot != null)
      plot.close();
    plot = null;

    dispose();
  }

  /** METHOD brineStiffPlotFrame_WindowListener()
   *  <p> This Class will handle Frame Close Action using the X Button on Frame
   */

  public class brineStiffPlotFrame_WindowListener extends WindowAdapter
  {
    public void windowClosing(WindowEvent e)
    {
      setVisible(false);
    }
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)  { }

  /* ======================================================================= *
   * ----------------------------- GET METHODS ----------------------------- *
   * ======================================================================= */

  /** Method getPlotWidth()
   * <p> This method will return the Plot Width
   * @return iWidth = The Plot Width
   */

  public int  getPlotWidth()  { return ( plot.getPlotWidth() ); }

  /** Method getPlotHeight()
   * <p> This method will return the Plot Height
   * @return iHeight = The Plot Height
   */

  public int getPlotHeight() { return ( plot.getPlotHeight() ); }

  /** Method getImage()
   * <p> This method will convert this plot to a buffered image
   * @return image = profile plot buffered image
   */

  public BufferedImage getImage()
  {
    BufferedImage image = null;

    if (plot != null) image = plot.getImage();

    return (image);

  }

  /* ======================================================================= *
   * ----------------------------- SET METHODS ----------------------------- *
   * ======================================================================= */


  /** Method setData()
   *  <p> This method will set the Brine Plot Data Structure
   *  @param st = Brine Plot Data Structure
   */

  public void setData( brinePlotStruct st )
  {
    if (plot != null) plot.setData( st );
  }
}

/*
 *  @version 1.1 06/10/2011
 *  @author  John Victorine
 */
