/*
 * @brineSamplePlotPanel.java Version 1.1 06/13/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.gui;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

import brine.brineListStruct;       // Common Brine Data Sample
import brine.plot.brineSamplePlot;  // Stiff Plot

/** Class brineSamplePlotPanel
 *  <p> This Class will create the Stiff Plot.
 *
 *  @version 1.1 06/13/2011
 *  @author  John R. Victorine
 */

public class brineSamplePlotPanel extends JPanel
{
  // Input Variables

  private brineListStruct st = null;

  // Global Variables

  private int iWidth   = 0;
  private int iHeight  = 0;

  private brineSamplePlot plot = null;

  // Panel Widgets

  private ScrollPane scroll = new ScrollPane();
  private Panel      panel  = new Panel();

  /** Constructor brineSamplePlotPanel()
   *  <p> This is the Constructor for this class.
   *  @param st  = Brine Data Structure
   */

  public brineSamplePlotPanel( brineListStruct st )
  {
    try
    {
      this.st = st;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new brineSamplePlot( st );
    iWidth  = 50 + plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout( new BorderLayout() );
    panel.setPreferredSize( new Dimension( iWidth, iHeight ) );

    this.add(pnlCenter,   BorderLayout.CENTER);
//    pnlCenter.add(scroll, BorderLayout.CENTER);
//    scroll.add(panel,     null);
    pnlCenter.add(panel,  BorderLayout.CENTER);
    panel.add(plot,       BorderLayout.CENTER);
  }


  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    st  = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* ======================================================================= *
   * ----------------------------- GET METHODS ----------------------------- *
   * ======================================================================= */

  /** Method getPlotWidth()
   * <p> This method will return the Plot Width
   * @return iWidth = The Plot Width
   */

  public int  getPlotWidth()  { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Plot Height
   * @return iHeight = The Plot Height
   */

  public int getPlotHeight() { return (iHeight); }

  /** Method getImage()
   * <p> This method will convert this plot to a buffered image
   * @return image = profile plot buffered image
   */

  public BufferedImage getImage()
  {
    BufferedImage image = null;

    if (plot != null) image = plot.getImage();

    return (image);
  }

  /* ======================================================================= *
   * ----------------------------- SET METHODS ----------------------------- *
   * ======================================================================= */

  /** Method setRow()
   * <p> This method will set the plot data to plot
   */

  public void setRow(int iRow)
  {
	if (plot != null) plot.setRow(iRow);
  }
}

/*
 *  @version 1.1 06/13/2011
 *  @author  John Victorine
 */
