/*
 * @brineMapCSVFrame.java Version 1.1 06/15/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.gui;

import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Observable;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import brine.io.brineCSVFile;
import brine.brineListStruct;

/** Class brineMapCSVFrame
 *  <p> This Class will allow the user to load data files from
 *      their PC or the KGS Database
 *
 *  @version 1.1 06/15/2011
 *  @author  John R. Victorine
 */

public class brineMapCSVFrame extends JFrame implements ActionListener
{
  // Input Variables

  private Observable notifier    = null;
  private String     sReadMethod = null;
  private String     sDirectory  = null;
  private String     sFilename   = null;

  // Global Frame Variables

  private String     sLine1 = "";
  private String     sLine2 = "";

  private int iRow = 3;
  private int iColumn[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, };
  private int iUnit[]   = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, };

  public static final String CURVES[][] =
  {
    // Mnemonic     Description
    { "KEY",       "Fluid Primary Key",     "",    "",     ""  },
    { "FORM",      "Formation",             "",    "",     ""  },
    { "AGE",       "Formation Age",         "",    "",     ""  },
    // Depth Range of Sample
    { "TOP",       "Depth Top",             "",    "",     ""  },
    { "BASE",      "Depth Base",            "",    "",     ""  },

    // Other Measured Well Data
    { "SPGR",      "Specific Gravity",      "",    "",     ""  },
    { "SIGMA",     "Specific Conductivity", "",    "",     ""  },
    { "PH",        "PH",                    "",    "",     ""  },
    { "DEG",       "Temperature (F)",       "",    "",     ""  },
    { "OHM",       "Resistivity (Rw)",      "",    "",     ""  },
    { "OHM75",     "Resistivity at 75 deg", "",    "",     ""  },
    { "OHME",      "Estimated Rw",          "",    "",     ""  },

    // Common Cations

    // .. Alkali Metal
    { "Li",        "Lithium",               "",    "",     ""  },
    { "Na",        "Sodium",                "",    "",     ""  },
    { "K",         "Potassium",             "",    "",     ""  },
    { "Rb",        "Rubidium",              "",    "",     ""  },
    { "Cs",        "Cesium",                "",    "",     ""  },
    { "Na_K",      "Sodium Potassium",      "",    "",     ""  },
    // ..  Alkali Earth Metal
    { "Be",        "Beryllium",             "",    "",     ""  },
    { "Mg",        "Magnesium",             "",    "",     ""  },
    { "Ca",        "Calcium",               "",    "",     ""  },
    { "Sr",        "Strontium",             "",    "",     ""  },
    { "Ba",        "Barium",                "",    "",     ""  },
    // ..  VIB
    { "CrII",      "Chromium(II)",    "chromous",  "Cr",   "" },
    { "CrIII",     "Chromium(III)",   "chromic",   "",     "" },
    // ..  VIIB
    { "MnII",      "Manganese(II)",   "manganous", "Mn",   "" },
    { "MnIII",     "Manganese(III)",  "manganic",  "",     "" },
    // ..  VIIIB
    { "FeII",      "Iron(II)",        "ferrous",   "Fe",   "" },
    { "FeIII",     "Iron(III)",       "ferric",    "",     "" },
    { "CoII",      "Cobalt(II)",      "cobaltous", "Co",   "" },
    { "CoIII",     "Cobalt(III)",     "cobaltic",  "",     "" },
    { "NiII",      "Nickel(II)",      "nickelous", "Ni",   "" },
    { "NiIII",     "Nickel(III)",     "nickelic",  "",     "" },
    // ..  IB
    { "Cu",        "Copper(I)",       "cuprous",   "",    "" },
    { "CuII",      "Copper(II)",      "cupric",    "",     "" },
    { "Ag",        "Silver",          "",     "",     "" },
    { "Au",        "Gold",            "aurous",    "",     "" },
    { "AuIII",     "Gold(III)",       "auric",     "",     "" },
    // ..  IIB
    { "Zn",        "Zinc",                  "",    "",     ""  },
    { "Cd",        "Cadmium",               "",    "",     ""  },
    { "Hg",        "Mercury(I)",      "mercurous", "",     "" },
    { "HgII",      "Mercury(II)",     "mercuric",  "",     "" },
    // ..  IIIA
    { "Al",        "Aluminum",              "",    "",     ""  },
    //.. VA
    { "SbIII",     "Antimony(III)",   "antimonous", "Sb",   "" },
    { "SbV",       "Antimony(V)",     "antimonic",  "",     "" },
    { "BiIII",     "Bismuth(III)",    "bismuthous", "Bi",   "" },
    { "BiV",       "Bismuth(V)",      "bismuthic",  "",     "" },
    // ..  IVA
    { "SnII",      "Tin(II)",         "stannous",   "Sn",   "" },
    { "SnIV",      "Tin(IV)",         "stannic",    "",     "" },
    { "PbII",      "Lead(II)",        "plumbous",   "Pb",   "" },
    { "PbIV",      "Lead(IV)",        "plumbic",    "",     "" },
    // .. Other
    { "NH4",       "Ammonium",         "",    "",     ""  },

    // Common Anions

    // ..Halogen
    { "F",         "Floride",               "",    "",     ""  },
    { "Cl",        "Chloride",              "",    "",     ""  },
    { "Br",        "Bromide",               "",    "",     ""  },
    { "I",         "Iodine",                "",    "",     ""  },

    { "OH",        "Hydroxide",             "",    "",     ""  },

    { "BO3",       "Borate",                "",    "",     ""  },
    { "CO3",       "Carbonate",             "",    "",     ""  },
    { "HCO3",      "Bicarbonate",           "",    "",     ""  },

    { "ClO",       "Hypochlorite",          "",    "",     ""  },
    { "ClO2",      "Chlorite",              "",    "",     ""  },
    { "ClO3",      "Chlorate",              "",    "",     ""  },
    { "ClO4",      "Per chlorate",          "",    "",     ""  },

    { "CN",        "Cyanide",               "",    "",     ""  },
    { "NCO",       "Cyanate",               "",    "",     ""  },
    { "OCN",       "Isocyanate",            "",    "",     ""  },
    { "SCN",       "Thicyanite",            "",    "",     ""  },

    { "N",         "Nitride",               "",    "",     ""  },
    { "N3",        "Azide",                 "",    "",     ""  },
    { "NO2",       "Nitrite",               "",    "",     ""  },
    { "NO3",       "Nitrate",               "",    "",     ""  },

    { "CrO4",      "Chromate",              "",    "",     ""  },
    { "Cr2O7",     "Dichromate",            "",    "",     ""  },

    { "MnO4",      "Permanganate",          "",    "",     ""  },

    { "P",         "Phosphide",             "",    "",     ""  },
    { "PO3",       "Phosphite",             "",    "",     ""  },
    { "PO4",       "Phosphate",             "",    "",     ""  },
    { "HPO4",      "Monohydrogen Phosphate","",    "",     ""  },
    { "H2PO4",     "Dihydrogen Phosphate",  "",    "",     ""  },

    { "As",        "Arsinide",              "",    "",     ""  },
    { "Se",        "Selenide",              "",    "",     ""  },

    { "S",         "Sulfide",               "",    "",     ""  },
    { "HS",        "Hydrogen Sulfide",      "",    "",     ""  },
    { "SO3",       "Sulphite",              "",    "",     ""  },
    { "HSO3",      "Hydrogen Sulphite",     "",    "",     ""  },
    { "S2O3",      "Thiosulphate",          "",    "",     ""  },
    { "SO4",       "Sulfate",               "",    "",     ""  },
    { "HSO4",      "Bisulfate",             "",    "",     ""  },

    // -- Totals
    { "SOLID",     "Total Solids",          "",    "",     ""  },
    { "TDS",       "Total Solids Computed", "",    "",     ""  },

    // -- Well ID
    { "NAME",      "Well Name",             "",    "",     ""  },
    { "API",       "API-Number",            "",    "",     ""  },
    // -- Other Info
    {  "FIELD",     "Field",                "",    "",     ""  },
    // -- Location
    {  "COUNTY",    "County",               "",    "",     ""  },
    {  "STATE",     "State",                "",    "",     ""  },
    {  "LOC",       "Location",             "",    "",     ""  },
    {  "LAT",       "Latitude",             "",    "",     ""  },
    {  "LONG",      "Longitude",            "",    "",     ""  },
    // -- Depth Information
    { "KB",        "Kelly Bushing",         "",    "",     ""  },
    { "GL",        "Ground Level",          "",    "",     ""  },
    { "DF",        "Derrick Floor",         "",    "",     ""  },
    { "TGT",       "TGT",                   "",    "",     ""  },
    { "SRC",       "source",                "",    "",     ""  },
    { "DATE",      "Recovery date",         "",    "",     ""  },
  };

  private brineCSVFile pFILE = new brineCSVFile();
  private brineListStruct stList = null;

  // Global Frame Widgets

  private JButton btnLoad   = new JButton();
  private JButton btnCancel = new JButton();
  private JButton btnHelp   = new JButton();

  private JTextField txtStart = new JTextField();

  private JPanel       pnl[]    = null;
  private JPanel       pnl1a[]  = null;
  private JPanel       pnl2a[]  = null;
  private JLabel       lbl[]    = null;
  private JTextField   txt[]    = null;
  private JRadioButton rb[][]   = null;
  private ButtonGroup  group[]  = null;

  /** Constructor brineMapCSVFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier    = Observable
   *  @param sReadMethod = File Read Method
   *  @param sDirectory  = The Directory Path to the File
   *  @param sFilename   = The Filename
   */

  public brineMapCSVFrame( Observable notifier,
                           String     sReadMethod,
                           String     sDirectory,
                           String     sFilename )
  {
    try
    {
      this.notifier    = notifier;
      this.sReadMethod = sReadMethod;
      this.sDirectory  = sDirectory;
      this.sFilename   = sFilename;

      jbInit();

      if (sLine1 != null) { mapColumns( sLine1 ); }

      if (sLine2 != null)
      {
		mapColumns( sLine2 );
		mapUnits( sLine1 );
		mapUnits( sLine2 );
	  }
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	String str        = "";
    JPanel pnlTop     = new JPanel();
    JPanel pnlButtons = new JPanel();
    JPanel pnlCenter  = new JPanel();
    JPanel pnlLine1   = new JPanel();
    JPanel pnlLine2   = new JPanel();
    JPanel pnlCHeader = new JPanel();
    JPanel pnlColumns = new JPanel();
    JPanel pnlStart   = new JPanel();
    JPanel pnl1       = new JPanel();
    JPanel pnlMap     = new JPanel();

    JLabel lblStart         = new JLabel();
    JLabel lblNote          = new JLabel();
    JLabel lblRockDataColumn = new JLabel();
    JLabel lblFileColumn    = new JLabel();

    JTextArea txtLine1 = new JTextArea();
    JTextArea txtLine2 = new JTextArea();

    JScrollPane scrollLine1   = new JScrollPane();
    JScrollPane scrollLine2   = new JScrollPane();
    JScrollPane scrollColumns = new JScrollPane();

    TitledBorder titledBorder1st = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "1st Line of Comma Delimited File:");

    TitledBorder titledBorder2nd = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "2nd Line of Comma Delimited File:");

    TitledBorder titledBorderRock = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(165, 163, 151)),
        "Brine Data Columns:");

    titledBorder1st.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorder2nd.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderRock.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    this.setTitle("Map File Column Number to Brine Data Column");
    this.getContentPane().setLayout(new BorderLayout());

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnLoad.setFont(new java.awt.Font("Dialog", 1, 11));
    btnLoad.setPreferredSize(new Dimension(90, 25));
    btnLoad.setText("Load Data");
    btnLoad.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
    btnCancel.setPreferredSize(new Dimension(90, 25));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    btnHelp.setFont(new java.awt.Font("Dialog", 1, 11));
    btnHelp.setPreferredSize(new Dimension(90, 25));
    btnHelp.setText("Help");
    btnHelp.addActionListener(this);

    pnlTop.setLayout(new GridLayout(2,1));

    pnlLine1.setBorder(titledBorder1st);
    pnlLine1.setLayout(new BorderLayout());

    txtLine1.setEditable(false);
    txtLine1.setLineWrap(true);
    txtLine1.setText("");
    txtLine1.setRows(3);
    txtLine1.setWrapStyleWord(true);

    pnlLine2.setBorder(titledBorder2nd);
    pnlLine2.setLayout(new BorderLayout());

    txtLine2.setEditable(false);
    txtLine2.setLineWrap(true);
    txtLine2.setText("");
    txtLine2.setRows(3);
    txtLine2.setWrapStyleWord(true);

    pnlCenter.setLayout(new BorderLayout());
    pnlCenter.setBorder(titledBorderRock);

    pnlCHeader.setLayout(new BorderLayout());

    lblStart.setFont(new java.awt.Font("Dialog", 1, 11));
    lblStart.setText("Start Reading Data at Row");

    txtStart.setText("3");
    txtStart.setColumns(4);
    txtStart.setHorizontalAlignment(SwingConstants.TRAILING);
    txtStart.addFocusListener(new brineMapCSVFrameFocusAdapter(this));

    lblNote.setFont(new java.awt.Font("Dialog", 1, 11));
    lblNote.setText("Assume Row & Column Count is 1,2,3 ...");

    pnlColumns.setLayout(new BorderLayout());

    // Build Map Panel

    pnlMap.setLayout(new GridLayout(brine.brineStandardTools.TOTAL_A+1,1));

    // .. Add Header to Map Panel

    pnl1.setLayout(new BorderLayout());

    lblRockDataColumn.setFont(new java.awt.Font("Dialog", 1, 11));
    lblRockDataColumn.setText("Brine Data Column Name");

    lblFileColumn.setFont(new java.awt.Font("Dialog", 1, 11));
    lblFileColumn.setText("File Column Number");

    pnlMap.add(pnl1, null);
    pnl1.add(lblRockDataColumn, BorderLayout.WEST);
    pnl1.add(lblFileColumn, BorderLayout.EAST);

    // .. Add the Regions Columns to Map Panel

    pnl   = new JPanel[brine.brineStandardTools.TOTAL_A];
    pnl1a = new JPanel[brine.brineStandardTools.TOTAL_A];
    pnl2a = new JPanel[brine.brineStandardTools.TOTAL_A];
    lbl   = new JLabel[brine.brineStandardTools.TOTAL_A];
    txt   = new JTextField[brine.brineStandardTools.TOTAL_A];
    rb    = new JRadioButton[brine.brineStandardTools.TOTAL_A][2];
    group = new ButtonGroup[brine.brineStandardTools.TOTAL_A];

    for (int i=0; i<brine.brineStandardTools.TOTAL_A; i++)
    {
      pnl[i] = new JPanel();
      pnl[i].setLayout(new BorderLayout());
      pnl[i].setBorder(BorderFactory.createEtchedBorder());

      pnl1a[i] = new JPanel();
      pnl1a[i].setLayout(new BorderLayout());

      pnl2a[i] = new JPanel();
      pnl2a[i].setLayout(new GridLayout());

      str = new String( brine.brineStandardTools.CURVES[i][2] );
      if ((i >= brine.brineStandardTools._LI) &&
          (i <= brine.brineStandardTools._HSO4))
      {
        str = new String( str + " ( " +
                          brine.brineStandardTools.CURVES[i][1] +
                          " )" );
	  }

      lbl[i] = new JLabel();
      lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lbl[i].setText("  " + str);

      txt[i] = new JTextField();
      txt[i].setText("0");
      txt[i].setColumns(4);
      txt[i].setHorizontalAlignment(SwingConstants.TRAILING);
      txt[i].addFocusListener(new brineMapCSVFrameFocusAdapter(this));

      group[i] = new ButtonGroup();

      for (int j=0; j<2; j++)
      {
        rb[i][j] = new JRadioButton();
        rb[i][j].setFont(new java.awt.Font("Dialog", 1, 11));
        switch (j)
        {
		  case 0:
            rb[i][j].setSelected(true);
            rb[i][j].setText("mg/l");
            break;
          case 1:
            rb[i][j].setSelected(false);
            rb[i][j].setText("ug/l");
            break;
	    }
        rb[i][j].addActionListener(this);

        group[i].add(rb[i][j]);
      }

      pnlMap.add(pnl[i],     null);
      pnl[i].add(pnl1a[i],   BorderLayout.CENTER);
      pnl1a[i].add(lbl[i],   BorderLayout.CENTER);
      if ((i >= brine.brineStandardTools._LI) &&
          (i < brine.brineStandardTools.TOTAL))
        pnl1a[i].add(pnl2a[i], BorderLayout.EAST);
      pnl2a[i].add(rb[i][0], null);
      pnl2a[i].add(rb[i][1], null);
      pnl[i].add(txt[i],     BorderLayout.EAST);
    }

    // Add 1st & 2nd Line to Frame

    pFILE.Open(util.utilFileIO.DIRECTORY, sDirectory, sFilename);
    pFILE.get2Rows();
    pFILE.Close();

    sLine1 = new String( pFILE.getLine1() );
    sLine2 = new String( pFILE.getLine2() );

    txtLine1.setText( sLine1 );
    txtLine2.setText( sLine2 );

//    mapColumns( sLine1 );
//    mapColumns( sLine2 );

//    txtLine1.setText(pFILE.getLine1());
//    txtLine2.setText(pFILE.getLine2());

    // Attach Widgets to Frame

    this.getContentPane().add(pnlTop, BorderLayout.NORTH);
    pnlTop.add(pnlLine1, null);
    pnlLine1.add(scrollLine1,  BorderLayout.CENTER);
    scrollLine1.getViewport().add(txtLine1, null);

    pnlTop.add(pnlLine2, null);
    pnlLine2.add(scrollLine2, BorderLayout.CENTER);
    scrollLine2.getViewport().add(txtLine2, null);

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnLoad,   null);
    pnlButtons.add(btnCancel, null);
    pnlButtons.add(btnHelp,   null);

    this.getContentPane().add(pnlCenter, BorderLayout.CENTER);
    pnlCenter.add(pnlCHeader, BorderLayout.NORTH);
    pnlCHeader.add(pnlStart,  BorderLayout.WEST);
    pnlStart.add(lblStart,    null);
    pnlStart.add(txtStart,    null);
    pnlCHeader.add(lblNote,   BorderLayout.EAST);

    pnlCenter.add(pnlColumns,     BorderLayout.CENTER);
    pnlColumns.add(scrollColumns, BorderLayout.CENTER);
    scrollColumns.getViewport().add(pnlMap, null);

    // Display the Frame

//    this.setSize(new Dimension(500, 450));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setSize(new Dimension(550, d.height-50));

    this.setLocation((d.width  - this.getSize().width) / 2, 5 );
//                     (d.height - this.getSize().height) / 2);

    this.setResizable(true);
    this.setVisible(true);
  }

  /* ====================================================================== *
   * ----------------------------- GET METHODS ---------------------------- *
   * ====================================================================== */

  /** Method getData()
   * <p> This method will return tops list
   * @return stList = brine data list structure
   */

  public brineListStruct getData() { return (stList); }

  /** Method mapUnits()
   *  <p> This method will try to parse and map the columns of the text
   *      file to the brine units.
   *  @param sData = Line
   */

  private void mapUnits( String sData )
  {
	int i, j, k;
    int    iCount   = 0;
    int    iFound   = 0;
    int    iNext    = 0;
    int    iColumns = 0;
    String sTemp    = "";
    String sCol     = "";
    StringTokenizer stToken = null;
    String sTokens[] = null;
    int    iCol     = 0;
    String sDelimiter = new String("[,]+");

    sTemp    = new String(sData.replace('\t', ' '));
//    sTokens  = las3.las3Parse.splitDataLine( sTemp, "," );
    sTokens = sTemp.split( sDelimiter );

    iColumns = 0;
    if (sTokens != null)
      iColumns = sTokens.length;

    for  (j=0; j<brine.brineStandardTools.TOTAL_A; j++)
    {
      iCol = cmn.cmnString.stringToInt(txt[j].getText())-1;

      if (iCol > 0)
      {
	    if ((iCol > -1) && (iCol < iColumns))
	    {
          sTemp = sTokens[iCol];

          sTemp = new String(sTemp.trim());
          sTemp = Mu_to_u(sTemp);

          sTemp = new String(sTemp.toUpperCase());
          sTemp = new String(sTemp.trim());
          if (sTemp.length() > 4)
            sTemp = new String(sTemp.substring(0,4));

          if (sTemp.equals("UG/L"))
          {
//System.out.println(j+" "+sTemp);
			iUnit[j] = 1;
			rb[j][1].setSelected(true);
		  }
		}
	  }
	}
  }

  /** Method Mu_to_u()
   * <p> This method will convert the '' character to a 'u'.
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String Mu_to_u(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
		if ((c[i] == '') || (c[i] == '\u03BC'))
		  sNew = new String(sNew + 'u');
		else
		  sNew = new String(sNew + c[i]);
      }
    }

    return (sNew);
  }

  /** Method mapColumns()
   *  <p> This method will try to parse and map the columns of the text
   *      file to the brine columns.
   *  @param sData = Line
   */

  private void mapColumns( String sData )
  {
	int i, j, k;
    int    iCount   = 0;
    int    iFound   = 0;
    int    iNext    = 0;
    int    iColumns = 0;
    String sTemp    = "";
    String sCol     = "";
    StringTokenizer stToken = null;
    String sTokens[] = null;
    String sDelimiter = new String("[,]+");

    sTemp    = new String(sData.replace('\t', ' '));
//    sTokens  = las3.las3Parse.splitDataLine( sTemp, "," );
    sTokens = sTemp.split( sDelimiter );

    iColumns = 0;
    if (sTokens != null)
      iColumns = sTokens.length;

    for (i=0; i<iColumns; i++)
    {
      sTemp = sTokens[i];
      sTemp = new String(sTemp.toUpperCase());
      sTemp = new String(sTemp.trim());

      for  (j=0; j<brine.brineStandardTools.TOTAL_A; j++)
      {
//+		for (k=1; k<3; k++)
		for (k=0; k<5; k++)
		{
//+          sCol = new String( brine.brineStandardTools.CURVES[j][k] );
          sCol = new String( CURVES[j][k] );
          sCol = new String( sCol.toUpperCase() );

          if ((sTemp.length() > 0) && (sCol.length() > 0))
          {
		    if (sTemp.equals(sCol))
		    {
              iNext      = i+1;
			  txt[j].setText(""+iNext);
		    }
		  }

		  if (j==brine.brineStandardTools._TOP)
		  {
		    if (txt[j].getText().equals("0"))
		    {
			  if ((sTemp.equals("START")) ||
			      (sTemp.equals("BEGIN")) ||
			      (sTemp.equals("DEPTH")) ||
			      (sTemp.equals("STARTING DEPTH")) ||
			      (sTemp.equals("BEGIN DEPTH")))
			  {
                iNext      = i+1;
  			    txt[j].setText(""+iNext);
			  }
			}
		  }

		  if (j==brine.brineStandardTools._BASE)
		  {
		    if (txt[j].getText().equals("0"))
		    {
			  if ((sTemp.equals("END")) ||
			      (sTemp.equals("ENDING DEPTH")) ||
			      (sTemp.equals("END DEPTH")))
			  {
                iNext      = i+1;
  			    txt[j].setText(""+iNext);
			  }
			}
		  }
		}
      }
    }

    for (i=0; i<brine.brineStandardTools.TOTAL_A; i++)
    {
      iColumn[i] = cmn.cmnString.stringToInt(txt[i].getText());
    }
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method load()
   * <p> This method will load the read and parse the regions file
   */

  private void load()
  {
    pFILE.Open(util.utilFileIO.DIRECTORY, sDirectory, sFilename);
    pFILE.getData(iRow, iColumn, iUnit);
    pFILE.Close();

    stList = pFILE.getRock();

    notifier.notifyObservers(new String("Brine CSV File Loaded"));
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force JAVA
   *     to free unwanted memory.
   */

  public void close()
  {
    notifier    = null;
    sReadMethod = null;
    sDirectory  = null;
    sFilename   = null;

    sLine1      = null;
    sLine2      = null;

    iColumn     = null;
    iUnit       = null;

    if (pFILE != null)
      pFILE.delete();
    pFILE = null;

    stList = null;

    btnLoad     = null;
    btnCancel   = null;
    btnHelp     = null;
    txtStart    = null;

    pnl      = null;
    pnl1a    = null;
    pnl2a    = null;
    lbl      = null;
    txt      = null;
    rb       = null;
    group    = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnLoad) { load(); }
    if (event.getSource() == btnHelp)
    {
//      util.BrowserControl.displayURL( cmn.cmnStruct.PC_CORE );
    }

    if (rb != null)
    {
      for (int i=0; i<brine.brineStandardTools.TOTAL_A; i++)
      {
	    if ((event.getSource() == rb[i][0]) || (event.getSource() == rb[i][1]))
	    {
          if (rb[i][0].isSelected())
          {
	        iUnit[i] = 0;
	      }
	      else if (rb[i][1].isSelected())
	      {
	        iUnit[i] = 1;
	  	  }
        }
  	  }
    }

    if (event.getSource() == btnCancel) { close(); }
  }

  /** METHOD focusLost()
   *  <p> This Method will handle the lost focus event for the text fields.
   *  @param e      = Focus Lost Event
   */

  protected void focusLost(FocusEvent e)
  {
    int    i        = 0;
    int    iNumeric = 0;
    String sMessage = new String("");
    String sTemp    = new String("");

    if (e.getSource() == txtStart)
    {
      iNumeric = 1;
      sTemp    = txtStart.getText();
      sMessage = new String("Starting Row Number is a Numeric Field");
    }

    for (i=0; i<brine.brineStandardTools.TOTAL_A; i++)
    {
      if (e.getSource() == txt[i])
      {
        iNumeric = 1;
        sTemp    = txt[i].getText();
        sMessage = new String("Column Number is a Numeric Field");
      }
    }

    if (iNumeric == 1)
    {
      if (!cmn.cmnString.isNumeric(sTemp))
      {
        JOptionPane.showMessageDialog((Component) null,
                                       sMessage,
                                       "ERROR",
                                       JOptionPane.ERROR_MESSAGE);
      }
      else
      {
        if (e.getSource() == txtStart)
        {
          iRow = cmn.cmnString.stringToInt(txtStart.getText());
        }

        for (i=0; i<brine.brineStandardTools.TOTAL_A; i++)
        {
          if (e.getSource() == txt[i])
          {
            iColumn[i] = cmn.cmnString.stringToInt(txt[i].getText());
          }
        }
      }
    }
  }
}

/** CLASS brineMapCSVFrameFocusAdapter()
  *  <p> This Method will handle Actions when focus is lost on a textfield
  */

class brineMapCSVFrameFocusAdapter extends java.awt.event.FocusAdapter
{
  brineMapCSVFrame adaptee;

  brineMapCSVFrameFocusAdapter(brineMapCSVFrame adaptee)
  {
    this.adaptee = adaptee;
  }

  public void focusLost(FocusEvent e) { adaptee.focusLost(e); }
}

/*
 *  @version 1.1 06/15/2011
 *  @author  John Victorine
 */
