/*
 * @brineAveragePlotPanel.java Version 1.1 05/19/2014
 *
 * Copyright (c) 2014 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine.gui;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

import brine.brineListStruct;       // Common Brine Data Sample
import brine.plot.brineAveragePlot;  // Stiff Plot

/** Class brineAveragePlotPanel
 *  <p> This Class will create the Stiff Plot.
 *
 *  @version 1.1 05/19/2014
 *  @author  John R. Victorine
 */

public class brineAveragePlotPanel extends JPanel
{
  // Input Variables

  private brineListStruct st = null;
  private double data[][] = null;

  // Global Variables

  private int iWidth   = 0;
  private int iHeight  = 0;

  private brineAveragePlot plot = null;

  // Panel Widgets

  private ScrollPane scroll = new ScrollPane();
  private Panel      panel  = new Panel();

  /** Constructor brineAveragePlotPanel()
   *  <p> This is the Constructor for this class.
   *  @param st  = Brine Data Structure
   */

  public brineAveragePlotPanel( double data[][], brineListStruct st )
  {
    try
    {
      this.st = st;
	  this.data  = data;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new brineAveragePlot( data, st );
    iWidth  = 50 + plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout( new BorderLayout() );
    panel.setPreferredSize( new Dimension( iWidth, iHeight ) );

    this.add(pnlCenter,   BorderLayout.CENTER);
//    pnlCenter.add(scroll, BorderLayout.CENTER);
//    scroll.add(panel,     null);
    pnlCenter.add(panel,  BorderLayout.CENTER);
    panel.add(plot,       BorderLayout.CENTER);
  }


  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    st   = null;
    data = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* ======================================================================= *
   * ----------------------------- GET METHODS ----------------------------- *
   * ======================================================================= */

  /** Method getPlotWidth()
   * <p> This method will return the Plot Width
   * @return iWidth = The Plot Width
   */

  public int  getPlotWidth()  { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Plot Height
   * @return iHeight = The Plot Height
   */

  public int getPlotHeight() { return (iHeight); }

  /** Method getImage()
   * <p> This method will convert this plot to a buffered image
   * @return image = profile plot buffered image
   */

  public BufferedImage getImage()
  {
    BufferedImage image = null;

    if (plot != null) image = plot.getImage();

    return (image);
  }
}

/*
 *  @version 1.1 05/19/2014
 *  @author  John Victorine
 */
