/*
 * @brineStruct.java Version 1.1 05/27/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package brine;

import brine.brineStruct;
import las3.las3Struct;

/** CLASS brineStruct
 *  <p> This Class holds the Brine Data Information.
 *
 *  List composed from,
 *  Common Cations, Anions, Acids, Salts and Hydrate Nomenclature
 *  Missouri University of Science and Technology
 *  http://web.mst.edu/~tbone/subjects/tbone/chem1/Chem%201%20Compound%20Sheet%20FS08.pdf
 *
 *  @version 1.1 05/27/2011
 *  @author  John R. Victorine
 */

public class brineStruct
{
  public static final double dNULL = -999.95; // Null Value for an empty data set

  public  String sKID    = "";  // KID
  public  String sKEY    = "";  // KEY

  // Location
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public String sField     = "";   // Field
  public String sCounty    = "";   // County
  public String state      = "";   // State
  public String sLocation  = "";   // Location

  public double dKB        = 0.0;  // Kelly Bushing
  public double dGL        = 0.0;  // Ground Level
  public double dDF        = 0.0;  // Derrick Floor
  public double dTGT       = 0.0;  // TGT

  public String source     = "";   // Sample Source {S}
  public String sRecovery  = "";   // Recovery Date (Date Core Cut) {D}

  // AGE
  public  String sFORM   = "";  // Primary Formation
  public  String sAGE    = "";  // Age of Formation

  // Depth
  public  double dTOP    = dNULL;  // Top Depth
  public  double dBASE   = dNULL;  // Base Depth

  // Other Measured Well Data
  public  double dSPGR   = dNULL;  // Specific Gravity
  public  double dSIGMA  = dNULL;  // Specific Conductivity
  public  double dPH     = dNULL;  // PH
  public  double dDEG    = dNULL;  // Degree F
  public  double dOHM    = dNULL;  // Resistivity (Rw)
  public  double dOHM75  = dNULL; // Resistivity at 75 deg
  public  double dOHME   = dNULL; // Estimated Rw

  // .. Alkali Metal
  public  double dLI     = dNULL; // Lithium                  (Li+)
  public  double dNA     = dNULL; // Sodium                   (Na+)
  public  double dK      = dNULL; // Potassium                (K+)
  public  double dRB     = dNULL; // Rubidium                 (Rb+)
  public  double dCS     = dNULL; // Cesium                   (Ce+)
  public  double dNA_K   = dNULL; // Sodium/Potasium          (Na+|K+)

  // ..  Alkali Earth Metal
  public  double dBE     = dNULL; // Beryllium                (Be++)
  public  double dMG     = dNULL; // Magnesium                (Mg++)
  public  double dCA     = dNULL; // Calcium                  (Ca++)
  public  double dSR     = dNULL; // Strontium                (Sr++)
  public  double dBA     = dNULL; // Barium                   (Ba++)

  // ..  VIB
  public  double dCR_II  = dNULL; // Chromium (II)            (Cr++)
  public  double dCR_III = dNULL; // Chromium (III)           (Cr+++)

  // ..  VIIB
  public  double dMN_II  = dNULL; // Manganese (II)           (Mn++)
  public  double dMN_III = dNULL; // Manganese (IV)

  // ..  VIIIB
  public  double dFE_II  = dNULL; // Iron (II)                (Fe++)
  public  double dFE_III = dNULL; // Iron (III)               (Fe+++)
  public  double dCO_II  = dNULL; // Cobalt (II)
  public  double dCO_III = dNULL; // Cobalt (III)
  public  double dNI_II  = dNULL; // Nickel (II)
  public  double dNI_III = dNULL; // Nickel (III)

  // ..  IB
  public  double dCU_I   = dNULL; // Copper (I)               (Cu+)
  public  double dCU_II  = dNULL; // Copper (II)              (Cu++)
  public  double dAG     = dNULL; // Silver                   (Ag+)
  public  double dAU     = dNULL; // Gold                     (Au+)
  public  double dAU_III = dNULL; // Gold (III)               (Au+++)

  // ..  IIB
  public  double dZN     = dNULL; // Zinc                     (Zn++)
  public  double dCD     = dNULL; // Cadmium                  (Cd++)
  public  double dHG     = dNULL; // Mercury (I)              (Hg2++)
  public  double dHG_II  = dNULL; // Mercury (II)             (Hg++)

  // ..  IIIA
  public  double dAL     = dNULL; // Aluminium                (Al+++)

  // ..
  public  double dSB_III = dNULL; // Antimonous(III)          (Sb+++)
  public  double dSB_V   = dNULL; // Antimonic(V)             (Sb++++)
  public  double dBI_III = dNULL; // Bismuthous(III)          (Bi+++)
  public  double dBI_V   = dNULL; // Bismuth(V)               (Bi++++)

  // ..  IVA
  public  double dSN_II  = dNULL; // Tin (II)                 (Sn++)
  public  double dSN_IV  = dNULL; // Tin (IV)                 (Sn++++)
  public  double dPB_II  = dNULL; // Lead (II)                (PB++)
  public  double dPB_IV  = dNULL; // Lead (IV)                (PB++++)

  // .. Other
  public  double dNH4    = dNULL; // Ammonium                 (NH4+)

  // Common Anions

  // ..Halogen
  public  double dF      = dNULL; // Flouride                 (F-)
  public  double dCL     = dNULL; // Chloride                 (Cl-)
  public  double dBR     = dNULL; // Bromide                  (Br-)
  public  double dI      = dNULL; // Iodide                   (I-)

  public  double dOH     = dNULL; // Hydroxide                (OH-)

  public  double dBO3    = dNULL; // Borate                   (BO3---)
  public  double dCO3    = dNULL; // Carbonate                (CO3--)
  public  double dHCO3   = dNULL; // Bicarbonate              (HCO3-)

  public  double dCLO    = dNULL; // Hypochlorite             (OCl-)
  public  double dCLO2   = dNULL; // Chlorite                 (ClO2-)
  public  double dCLO3   = dNULL; // Chlorate                 (ClO3-)
  public  double dCLO4   = dNULL; // Per chlorate             (ClO4-)

  public  double dCN     = dNULL; // Cyanide                  (CN-)
  public  double dNCO    = dNULL; // Cyanate                  (NCO-)
  public  double dOCN    = dNULL; // Isocyanate               (OCN-)
  public  double dSCN    = dNULL; // Thiocyanate              (SCN-)

  public  double dN      = dNULL; // Nitride                  (N---)
  public  double dN3     = dNULL; // Azide                    (N3-)
  public  double dNO2    = dNULL; // Nitrite                  (NO2-)
  public  double dNO3    = dNULL; // Nitrate                  (NO3-)

  public  double dCRO4   = dNULL; // Chromium (II)            (CrO4--)
  public  double dCR2O7  = dNULL; // Chromium (III)           (Cr2O7--)

  public  double dMNO4   = dNULL; // Permanganate             (MnO4-)

  public  double dP      = dNULL; // Phosphide                (P---)
  public  double dPO3    = dNULL; // Phosphite                (PO3---)
  public  double dPO4    = dNULL; // Phosphate                (PO4---)
  public  double dHPO4   = dNULL; // Monohydrogen Phosphate   (HPO4--)
  public  double dH2PO4  = dNULL; // Dihydrogen Phosphate     (H2PO4-)

  public  double dAS     = dNULL; // Arsinide                 (As---)
  public  double dSE     = dNULL; // Selenide                 (Se--)

  public  double dS      = dNULL; // Sulfide                  (S--)
  public  double dHS     = dNULL; // Hydrogen Sulfide         (HS-)
  public  double dSO3    = dNULL; // Sulphite                 (SO3--)
  public  double dHSO3   = dNULL; // Hydrogen Sulphite        (HSO3-)
  public  double dS2O3   = dNULL; // Thiosulphate             (S2O3--)
  public  double dSO4    = dNULL; // Sulfate                  (SO4--)
  public  double dHSO4   = dNULL; // Bisulfate                (HSO4-)

  public  double dSOLID  = dNULL; // Total Solids
  public  double dTDS    = dNULL; // Total Solids Computed

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID       = null;  // Primary KEY of Record
    sKEY       = null;  // User defined primary key

    // Location
    sAPI       = null;  // API-Number OR UWI
    sName      = null;  // Well Name or Outcrop Name
    sField     = null;  // Field
    sCounty    = null;  // County
    state      = null;  // State
    sLocation  = null;  // Location

    source     = null;  // Sample Source {S}
    sRecovery  = null;  // Recovery Date (Date Core Cut) {D}

    // AGE
    sFORM      = null;  // Primary Formation
    sAGE       = null;  // Age of Formation
  }
}