~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                                    VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                         0.0  : START DEPTH                    {F}
 STOP  .F                                      5249.0  : END DEPTH                      {F}
 STEP  .F                                         0.5  : STEP LENGTH                    {F}
 NULL  .                                      -999.25  : NULL VALUE                     {F}
 COMP  .                                  BEREXCO INC  : Company                        {S}
 WELL  .                         WELLINGTON KGS #1-32  : Well Name                      {S}
 FLD   .                                   WELLINGTON  : Field                          {S}
 SEC   .                                           32  : Section                        {I}
 TOWN  .                                          31S  : Township (e.g. 42S)            {S}
 RANG  .                                           1E  : Range  (e.g. 25E)              {S}
 LOC   .                  Location: T31S R1W, Sec. 32  : Location (Sec Town Range)      {S}
 LOC1  .                                  NE SW NE NE  : Location 1 (quarter calls)     {S}
 LOC2  .          955 South, 877 West, from NE corner  : Location 2 (footages)          {S}
 COUN  .                                       SUMNER  : County                         {S}
 STAT  .                                       KANSAS  : State                          {S}
 CTRY  .                                          USA  : Country                        {S}
 PROV  .                                       KANSAS  : Province                       {S}
 SRVC  .                                  Halliburton  : Service Company                {S}
 LIC   .                                               : License Number                 {S}
 DATE  .                                               : Completion Date                {D/M/YYY}
 API   .                                 15-191-22591  : API-Number                     {S}
 UWI   .                                   1043234370  : Unique Well ID Number          {S}
 LATI  .DEG                                 37.315444  : Latitude                       {F}
 LONG  .DEG                                -97.442414  : Longitude                      {F}
 GDAT  .                                        NAD27  : Geodetic Datum                 {S}
 X     .                                    638021.21  : X or East-West coordinate      {F}
 Y     .                                   4130799.97  : Y or North South coordinate    {F}
 HZCS  .                                          UTM  : Horizontal Co-ordinate System  {S}
 UTM   .                                         14.0  : UTM Location                   {F}
 STUS  .                                        OTHER  : Well Status                    {S}

~Parameter
#MNEM .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                                         GL  : Permanent Data                 {S}
 APD   .F                                      13.0  : Above Permanent Data           {F}
 DREF  .                                         KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F                                    1272.0  : Elevation of Depth Reference   {F}
 RUN   .                                          1  : Run Number                     {F}
 TDL   .F                                    5240.0  : Total Depth Logger             {F}
 TDD   .F                                    5240.0  : Total Depth Driller            {F}
 CSGL  .F                                     607.0  : Casing Bottom Logger           {F}
 CSGD  .F                                     607.0  : Casing Bottom Driller          {F}
 CSGS  .IN                                    9.625  : Casing Size                    {F}
 CSGW  .LB                                           : Casing Weight                  {F}
 BS    .IN                                    7.875  : Bit Size                       {F}
 MUD   .                            Water Based Mud  : Mud type                       {S}
 MUDS  .                                  Flow Line  : Mud Source                     {S}
 MUDD  .gm/cc                                   9.0  : Mud Density                    {F}
 MUDV  .s/qt                                   48.0  : Mud Viscosity (Funnel)         {F}
 FL    .cc                                      9.2  : Fluid Loss                     {F}
 PH    .                                       10.0  : PH                             {F}
 RM    .OHM-M                                 0.650  : Resistivity of Mud             {F}
 RMT   .DEG-F                                  58.0  : Temperature of Mud             {F}
 RMF   .OHM-M                                 0.550  : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEG-F                                  58.0  : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M                                 0.750  : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F                                  58.0  : Temperature of Mud Cake        {F}
 TMAX  .DEG-F                                 125.0  : Maximum Recorded Temp.         {F}
 TIMC  .DATE                                         : Date/Time Circulation Stopped  {D/M/YYY}
 TIML  .DATE                                         : Date/Time Logger Tagged Bottom {D/M/YYY}
 UNIT  .                                   10546686  : Logging Unit Number            {S}
 BASE  .                                Liberal, KS  : Home Base of Logging Unit      {S}
 ENG   .                                    J. Bosh  : Recording Engineer             {S}
 WIT   .          L.Watney,K.Crisler,G.Koralegedara  : Witnessed By                   {S}

~Curve
#MNEM       .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT        .F                     : Depth                          
 GR          .api                   : Gamma API                      
 CALA        .in                    : Caliper                        
 VPVSXX      .                      : WAVE VP/VXX                    
 VPVSYY      .                      : WAVE VP/VYY                    
 VPVS        .                      : WAVE VP/VS                     
 BSZ         .in                    : Bit Size                       
 ITTT        .us                    : WL FE Int Trav Time Tot        
 TENS        .lbs                   : Tension                        
 AZI1C       .deg                   : Azimuth of Pad 1               
 RAD1        .in                    : Radius1                        
 RAD2        .in                    : Radius2                        
 RAD3        .in                    : Radius3                        
 RAD4        .in                    : Radius4                        
 RAD5        .in                    : Radius5                        
 RAD6        .in                    : Radius6                        
 TPUL        .                      : Tension Pull                   
 DTXX        .uspf                  : WAVE XX Flexural               
 DTC         .uspf                  : WAVE DTC                       
 DTYY        .uspf                  : WAVE YYFlexural                
 SPHW        .pu                    : AcouPorWylie                   
 DTRS        .uspf                  : WAVE Refracted Shear           
 DTST        .uspf                  : WAVE Stoneley                  
 YXRYY       .                      : YXRYY                          
 XYRXX       .                      : XYRXX                          
 XYENG       .                      : XYENG                          
 YXENG       .                      : YXENG                          
 AniAzi+     .deg                   : WAVE AniAzi+ Uncert            
 AniAzi-     .deg                   : WAVE AniAzi- Uncert            
 AniAzi      .deg                   : WAVE Aniso Azimuth             
 FastShear   .uspf                  : WAVE Fast Shear                
 SlowShear   .uspf                  : WAVE Slow Shear                
 AROSE       .                      : AROSE                          
 AROSE180    .                      : AROSE180                       
 %Anisotropy .%                     : WAVE %Anisotropy               
 TENS        .lbs                   : Tension                        
 SP          .mV                    : SP                             
 RXRT        .NONE                  : RXRT                           
 RXO         .ohmm                  : RXO                            
 RT90        .ohmm                  : 90in Resistivity 2ft Res       
 RT60        .ohmm                  : 60in Resistivity 2ft Res       
 RT30        .ohmm                  : 30in Resistivity 2ft Res       
 RT20        .ohmm                  : 20in Resistivity 2ft Res       
 RT10        .ohmm                  : 10in Resistivity 2ft Res       
 RT          .ohmm                  : RT                             
 RMUD        .ohmm                  : RMUD                           
 RHOB        .g/cc                  : Density                        
 QN          .NONE                  : NearQuality                    
 QF          .NONE                  : FarQuality                     
 PE          .                      : Pe                             
 NPHS        .%                     : Neutron Porosity Sand          
 NPHL        .%                     : Neu Por Lime                   
 NPHI        .%                     : Neutron Porosity               
 NPHD        .%                     : Neutron Porosity Dolo          
 DRHO        .g/cc                  : DensityCorr                    
 DPHS        .%                     : DenPhiSand                     
 DPHI        .%                     : DensityPorosity                
 DPHD        .%                     : DenPhiDolo                     
 DLIM        .%                     : DenPhiLime                     
 CT90        .mmo/m                 : 90in Conductivity 2ft Res      
 CALI        .in                    : Caliper                        
 MINV        .ohmm                  : MicrologLateral                
 MNOR        .ohmm                  : MicrologNormal                 
 GR          .api                   : Gamma API                      
 GRTO        .api                   : GammaTotal                     
 GRTC        .api                   : GammaKT                        
 POTA        .%                     : Potassium                      
 URAN        .ppm                   : Uranium                        
 THOR        .ppm                   : Thorium                        
 TURT        .NONE                  : RatioThorUran                  
 UKRT        .NONE                  : RatioUranPota                  
 TKRT        .NONE                  : RatioThorPota                  
 NOIS        .cps                   : SpectralNoise                  

~Core_Parameter
#MNEM .UNIT                     VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 C_SRS .          Comma Delimited File  : Core Source                    {S}
 C_TY  .                    Whole Core  : Core Type                      {S}
 C_DT  .                                : Recovery Date (Date Core Cut)  {D/M/YYY}
 C_TP  .F                      3627.55  : Core Top Depth                 {F}
 C_BS  .F                       5176.8  : Core Base Depth                {F}
 C_RC  .F                      1549.25  : Recovered Amount (Length)      {F}
 C_FM  .                                : Primary Formation Cored        {S}
 C_DI  .IN                         4.0  : Core Diameter                  {F}
 C_AC  .                      WH,SB,JR  : Analyzing Company              {S}
 C_AD  .                   12 Aug 2011  : Analysis Date                  {D/M/YYY}

~Core_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOP   .F                     : Depth Top                      {F}
 BASE  .F                     : Depth Bottom                   {F}
 PCORE .PU                    : Whole Core Porosity            {F}
 KMAX  .MD                    : Whole Core Permeability Maximum {F}
 K90   .MD                    : Whole Core Permeability 90 deg {F}
 KVRT  .MD                    : Whole Core Permeability Vertical {F}
 SOIL  .PU                    : Oil Saturation                 {F}
 SW    .PU                    : Water Saturation               {F}
 GMCC  .GMCC                  : Grain Density (gm/cc)          {F}

~Core_Data | Core_Definition 
# TOP BASE PCORE KMAX K90 KVRT SOIL SW GMCC
 3627.55,3628.0,0.3,0.02,-999.95,-999.95,0.0,90.9,2.69
 3638.4,3638.9,0.6,0.01,-999.95,-999.95,0.0,80.5,2.7
 3660.4,3660.75,4.7,2.0,0.08,2.29,0.0,82.5,2.62
 3661.7,3662.0,6.8,2.72,1.74,0.02,0.0,75.1,2.61
 3662.5,3663.0,11.1,3.7,2.96,4.55,22.5,45.5,2.59
 3663.0,3663.5,14.1,25.36,9.94,29.36,29.2,41.2,2.6
 3664.3,3664.75,8.0,12.42,8.97,3.84,0.0,97.6,2.62
 3665.0,3665.6,7.4,4.2,3.4,3.38,0.0,98.6,2.61
 3666.0,3666.25,5.5,8.64,0.4,-999.95,10.7,46.0,2.58
 3667.2,3667.7,5.8,6.56,5.97,1.93,0.0,93.9,2.6
 3668.5,3669.0,12.0,21.77,10.68,5.78,0.0,82.4,2.59
 3669.3,3669.8,11.8,20.3,20.03,10.96,0.0,70.4,2.6
 3670.0,3670.6,13.1,64.64,60.27,35.99,0.0,75.8,2.61
 3671.0,3671.5,19.7,9.68,8.11,2.41,23.9,50.2,2.79
 3672.3,3672.8,22.7,14.08,13.6,7.96,27.1,48.0,2.77
 3673.4,3673.9,24.3,13.37,12.95,8.2,24.4,50.1,2.79
 3674.0,3674.5,22.9,21.85,21.24,9.3,28.2,52.8,2.77
 3675.3,3675.8,26.4,22.31,19.92,11.61,25.2,58.8,2.78
 3676.0,3676.5,23.9,18.54,17.7,10.44,22.0,54.4,2.78
 3677.0,3677.5,23.8,19.75,8.23,16.59,21.9,52.7,2.75
 3679.2,3679.7,21.2,38.14,24.39,11.27,20.7,51.2,2.73
 3680.0,3680.5,21.3,39.26,25.78,10.74,19.8,54.4,2.74
 3681.4,3681.9,25.6,21.64,20.63,10.05,18.7,37.9,2.76
 3682.2,3682.7,22.7,12.97,12.51,6.46,20.5,62.5,2.75
 3683.0,3683.5,23.9,20.38,17.34,15.43,32.9,49.4,2.77
 3684.3,3684.8,24.9,17.41,17.39,12.79,19.1,43.6,2.77
 3685.0,3685.5,24.2,18.06,16.43,8.95,29.8,55.0,2.76
 3686.3,3686.9,27.3,33.99,33.32,11.74,18.9,34.1,2.77
 3687.2,3687.7,23.7,15.43,14.63,8.07,21.1,59.3,2.76
 3688.0,3688.5,23.9,17.23,16.13,8.96,26.0,57.7,2.74
 3689.3,3689.9,20.6,15.56,12.78,5.9,22.7,30.2,2.78
 3690.25,3690.75,20.1,20.67,17.7,3.01,20.5,56.1,2.72
 3691.25,3691.45,23.5,9.74,9.36,6.47,18.4,32.5,2.79
 3693.15,3693.6,21.9,6.01,5.64,3.95,0.0,79.5,2.76
 3699.15,3699.65,20.6,1.82,1.64,0.06,0.0,83.5,2.79
 3705.8,3706.3,14.0,0.21,0.21,-999.95,0.0,85.7,2.77
 3709.3,3709.6,12.8,0.13,0.13,-999.95,0.0,88.9,2.77
 3717.35,3717.8,7.1,0.04,0.02,-999.95,0.0,83.3,2.74
 3732.0,3732.6,2.6,0.01,-999.95,-999.95,0.0,81.9,2.7
 3733.0,3733.55,2.6,-999.95,-999.95,-999.95,0.0,85.0,2.7
 3746.0,3746.35,1.4,0.13,0.1,0.03,0.0,81.6,2.66
 3754.0,3754.6,1.9,0.03,0.01,-999.95,0.0,91.2,2.67
 3762.0,3762.45,2.4,-999.95,-999.95,-999.95,0.0,92.6,2.7
 3767.0,3767.6,3.4,0.39,0.19,-999.95,0.0,77.4,2.68
 3777.6,3778.0,1.6,0.1,0.05,-999.95,0.0,80.7,2.69
 3789.25,3789.8,1.2,0.01,0.01,-999.95,0.0,97.3,2.66
 3795.9,3796.45,0.7,0.01,0.01,-999.95,0.0,83.5,2.66
 3804.35,3804.8,7.7,0.03,0.02,-999.95,0.0,74.4,2.73
 3893.2,3893.55,17.5,9.57,8.94,5.21,0.0,67.0,2.76
 3896.2,3896.55,18.8,14.64,14.28,10.49,0.0,79.1,2.76
 3900.8,3901.3,19.3,14.52,13.15,8.58,0.0,69.3,2.75
 3925.2,3925.8,4.8,0.01,0.01,-999.95,0.0,76.2,2.71
 3930.15,3930.6,7.2,0.05,0.04,-999.95,0.0,66.1,2.73
 3937.55,3937.95,4.4,0.02,0.02,-999.95,0.0,70.3,2.68
 3940.35,3940.9,5.7,0.01,0.01,-999.95,0.0,69.5,2.68
 3945.2,3945.7,6.0,0.02,0.02,-999.95,0.0,74.8,2.71
 4029.1,4029.6,10.3,0.03,0.02,-999.95,0.0,70.6,2.74
 4036.0,4036.45,13.9,6.12,4.85,0.01,0.0,55.5,2.68
 4066.3,4066.7,2.0,1.15,0.31,0.06,0.0,42.3,2.61
 4072.2,4072.65,6.0,0.17,0.16,-999.95,0.0,95.1,2.63
 4077.4,4077.85,5.6,0.14,0.12,-999.95,0.0,55.5,2.71
 4083.8,4084.2,8.8,1.0,0.86,0.02,0.0,61.7,2.74
 4094.2,4094.6,5.5,0.32,0.16,-999.95,0.0,67.2,2.76
 4098.3,4098.9,10.8,0.97,0.81,1.25,0.0,48.7,2.8
 4111.0,4111.5,8.2,0.58,0.45,-999.95,0.0,67.4,2.69
 4119.2,4119.7,9.4,0.79,0.65,-999.95,0.0,75.4,2.69
 4121.3,4121.85,6.9,0.91,0.69,-999.95,0.0,77.1,2.71
 4123.65,4124.1,6.2,22.79,19.47,20.45,0.0,14.7,2.66
 4136.65,4136.95,12.2,0.74,0.68,-999.95,0.0,70.1,2.69
 4152.6,4153.0,9.5,2.31,2.06,-999.95,0.0,73.7,2.69
 4157.3,4157.7,7.5,1.55,1.32,0.57,0.0,91.0,2.73
 4164.1,4164.9,15.8,24.79,21.29,9.22,0.0,29.5,2.65
 4166.3,4166.9,9.9,0.85,0.68,0.08,0.0,66.2,2.79
 4168.1,4168.9,9.1,2.31,2.04,0.2,0.0,85.8,2.77
 4170.1,4170.9,11.5,3.01,2.88,0.2,0.0,66.6,2.79
 4172.4,4172.9,7.8,4.7,3.63,3.51,0.0,40.7,2.78
 4174.5,4175.0,7.5,73.99,58.84,0.09,0.0,55.3,2.8
 4176.2,4176.8,6.4,0.54,0.27,-999.95,0.0,67.8,2.78
 4178.3,4178.9,3.7,0.83,0.65,10.49,0.0,65.0,2.83
 4180.2,4180.6,2.7,3.22,0.47,-999.95,0.0,20.5,2.81
 4182.55,4182.9,1.1,0.78,0.27,8.57,0.0,78.6,2.83
 4184.4,4184.75,5.9,8.99,1.62,-999.95,0.0,31.3,2.83
 4186.0,4186.6,4.8,1.99,1.48,0.55,0.0,14.5,2.82
 4187.3,4187.6,3.2,0.69,0.61,0.02,0.0,15.5,2.83
 4188.8,4189.0,4.8,5.12,4.0,0.61,0.0,5.4,2.84
 4190.4,4191.0,5.4,1.68,1.33,0.23,0.0,12.3,2.82
 4192.3,4192.9,5.5,0.06,0.05,-999.95,0.0,30.1,2.81
 4193.5,4193.9,5.3,13.38,11.31,10.47,0.0,17.6,2.82
 4194.0,4194.55,4.5,2.23,2.14,0.01,0.0,8.7,2.83
 4195.3,4196.0,5.1,7.95,4.81,1.11,0.0,26.7,2.82
 4196.7,4197.0,4.9,1.12,0.85,-999.95,0.0,29.2,2.81
 4198.0,4198.6,6.1,0.46,0.41,-999.95,0.0,17.2,2.81
 4200.0,4200.6,5.8,0.22,0.17,0.01,0.0,24.4,2.82
 4202.4,4203.0,7.7,27.85,27.6,1.97,0.0,20.2,2.82
 4204.4,4205.0,5.8,0.64,0.57,-999.95,0.0,42.1,2.81
 4206.0,4206.4,4.8,2.77,1.42,0.43,0.0,18.6,2.81
 4207.2,4207.85,8.3,10.18,7.22,2.18,0.0,33.7,2.82
 4208.0,4208.6,7.6,3.52,2.49,0.04,0.0,28.4,2.81
 4210.0,4210.6,5.4,17.1,7.64,3.97,0.0,17.5,2.82
 4212.05,4212.55,9.5,20.31,10.6,4.67,0.0,17.8,2.82
 4213.1,4213.75,5.2,57.63,51.56,60.69,0.0,49.7,2.62
 4216.0,4216.6,3.6,8.42,4.38,0.01,0.0,16.3,2.82
 4218.0,4218.5,6.8,2.31,1.26,1.33,0.0,30.9,2.8
 4220.6,4221.0,6.7,6.62,2.61,0.14,0.0,7.3,2.81
 4221.2,4221.8,6.5,7.72,7.4,0.06,0.0,21.4,2.8
 4222.2,4222.8,7.5,1.77,1.67,0.01,0.0,24.2,2.8
 4224.3,4225.0,2.7,62.51,62.48,3.11,0.0,27.6,2.62
 4225.0,4225.3,4.5,317.43,124.62,70.71,0.0,23.9,2.61
 4226.5,4226.8,6.7,21.04,15.55,4.66,0.0,10.9,2.81
 4228.0,4228.4,4.8,305.51,242.41,0.79,0.0,39.3,2.8
 4230.5,4231.0,2.6,219.72,66.64,-999.95,0.0,29.0,2.81
 4231.0,4231.45,5.0,138.27,92.37,4.04,0.0,33.6,2.77
 4232.5,4233.0,7.0,1.8,0.49,0.14,0.0,18.6,2.78
 4234.1,4234.5,10.2,1.3,1.3,0.01,0.0,40.8,2.8
 4236.05,4236.6,8.0,2.2,2.03,0.04,0.0,30.7,2.79
 4238.45,4238.9,5.4,1.8,1.42,-999.95,0.0,49.3,2.78
 4240.0,4240.4,6.5,22.5,18.41,0.78,0.0,11.6,2.83
 4242.1,4242.7,11.1,224.7,194.23,53.76,0.0,32.5,2.78
 4244.0,4244.2,3.5,50.63,12.52,2.7,0.0,29.8,2.83
 4246.3,4246.75,8.4,430.6,399.15,99.62,0.0,22.4,2.81
 4248.65,4249.0,6.7,0.37,0.35,-999.95,0.0,38.3,2.75
 4250.1,4250.3,4.8,4.3,2.24,3.57,0.0,32.3,2.63
 4252.65,4253.0,12.7,198.86,126.66,239.13,0.0,24.6,2.79
 4253.0,4253.2,6.2,73.26,45.35,11.92,0.0,37.8,2.81
 4254.0,4254.6,6.3,1.78,0.61,0.01,0.0,24.8,2.8
 4256.5,4257.0,5.2,12.02,0.19,-999.95,0.0,33.8,2.8
 4258.0,4258.5,5.5,0.82,0.77,0.05,0.0,24.7,2.82
 4260.4,4260.9,2.6,0.27,0.16,-999.95,0.0,29.5,2.81
 4262.8,4263.0,8.5,0.27,0.27,-999.95,0.0,44.0,2.75
 4263.0,4263.75,4.7,103.56,25.73,3.11,0.0,38.9,2.79
 4268.4,4269.0,0.3,1.73,0.38,2.17,0.0,80.8,2.65
 4270.55,4271.0,3.0,57.5,4.68,63.25,0.0,20.1,2.83
 4272.15,4272.75,3.4,209.89,63.6,28.94,0.0,11.9,2.81
 4274.2,4274.6,4.5,1.64,0.94,-999.95,0.0,25.7,2.79
 4276.75,4277.0,1.3,7.0,6.25,-999.95,0.0,24.0,2.82
 4278.3,4278.5,2.1,5.33,2.02,2.38,0.0,23.8,2.81
 4280.45,4280.75,12.9,167.69,160.09,167.72,0.0,19.9,2.82
 4294.4,4295.0,8.1,96.44,56.07,3.15,0.0,20.0,2.82
 4296.0,4296.6,2.8,0.05,0.05,-999.95,0.0,57.3,2.82
 4298.35,4299.0,8.9,0.24,0.12,-999.95,0.0,49.2,2.82
 4300.4,4301.0,6.7,2.94,0.96,5.21,0.0,28.5,2.83
 4302.4,4303.0,5.5,0.11,0.09,0.03,0.0,39.5,2.82
 4304.15,4304.65,5.8,0.07,0.04,-999.95,0.0,50.7,2.82
 4306.4,4307.0,10.7,0.19,0.19,-999.95,0.0,41.5,2.82
 4307.35,4308.0,5.9,0.13,0.1,-999.95,0.0,45.1,2.83
 4308.7,4309.0,3.2,0.07,0.07,-999.95,0.0,18.2,2.82
 4310.4,4311.0,5.0,0.14,0.12,-999.95,0.0,53.6,2.82
 4312.4,4313.0,6.2,0.06,0.06,-999.95,0.0,54.8,2.82
 4314.3,4314.8,8.5,0.11,0.11,-999.95,0.0,38.8,2.82
 4316.0,4316.6,8.3,0.08,0.08,-999.95,0.0,53.4,2.8
 4318.5,4319.0,9.1,0.1,0.08,-999.95,0.0,54.4,2.83
 4320.3,4320.9,5.4,0.39,0.1,0.01,0.0,31.4,2.81
 4322.7,4323.0,3.0,0.1,0.06,-999.95,0.0,38.5,2.81
 4324.0,4324.6,4.7,0.07,0.06,-999.95,0.0,34.4,2.82
 4326.6,4327.0,7.1,4.37,0.28,4.25,0.0,50.6,2.78
 4328.0,4328.4,7.5,0.07,0.06,-999.95,0.0,85.7,2.8
 4330.4,4331.0,6.0,0.16,0.15,-999.95,0.0,49.0,2.82
 4332.4,4333.0,8.4,1.05,0.88,0.01,0.0,35.9,2.82
 4334.0,4334.6,4.6,0.06,0.01,-999.95,0.0,51.9,2.8
 4336.7,4337.0,0.7,0.02,0.01,-999.95,0.0,73.4,2.82
 4338.0,4338.6,2.8,0.02,0.01,-999.95,0.0,55.7,2.81
 4340.0,4340.6,5.3,0.03,0.02,-999.95,0.0,44.8,2.82
 4342.7,4343.0,3.9,0.06,0.05,-999.95,0.0,63.1,2.82
 4343.0,4343.3,4.4,0.05,0.05,-999.95,0.0,78.8,2.82
 4344.4,4345.0,11.1,0.28,0.28,-999.95,0.0,46.5,2.79
 4346.0,4346.6,8.9,0.09,0.08,-999.95,0.0,72.9,2.8
 4348.0,4348.4,4.9,12.03,11.02,-999.95,0.0,67.4,2.81
 4350.5,4351.0,2.8,0.08,0.06,-999.95,0.0,51.7,2.82
 4352.0,4352.6,4.3,0.04,0.04,-999.95,0.0,45.3,2.81
 4354.0,4354.6,7.1,0.09,0.05,-999.95,0.0,76.2,2.79
 4356.0,4356.6,6.2,0.04,0.03,-999.95,0.0,51.3,2.8
 4358.0,4358.6,4.3,0.07,0.04,-999.95,0.0,56.8,2.81
 4360.2,4360.8,2.9,0.08,0.07,-999.95,0.0,26.8,2.82
 4362.3,4362.8,5.2,1.01,0.85,0.01,0.0,22.0,2.81
 4364.3,4364.75,4.2,0.28,0.15,-999.95,0.0,67.3,2.78
 4366.05,4366.35,5.6,10.19,4.44,3.76,0.0,15.4,2.83
 4368.3,4368.8,3.9,0.81,0.39,-999.95,0.0,88.4,2.78
 4370.0,4370.4,3.7,0.08,0.08,-999.95,0.0,84.5,2.82
 4372.2,4372.8,4.0,0.06,0.06,-999.95,0.0,33.1,2.78
 4374.0,4374.6,10.1,0.07,0.06,-999.95,0.0,56.1,2.81
 4376.0,4376.6,6.7,0.06,0.05,-999.95,0.0,73.5,2.81
 4378.1,4378.75,4.4,10.17,1.48,-999.95,0.0,34.1,2.82
 4380.35,4380.75,2.2,0.18,0.07,0.01,0.0,24.4,2.82
 4382.65,4383.0,3.7,0.12,0.09,-999.95,0.0,48.3,2.8
 4384.0,4384.35,6.5,0.09,0.09,-999.95,0.0,35.6,2.8
 4386.4,4386.7,4.2,1.25,0.17,0.01,0.0,23.9,2.81
 4388.0,4388.45,5.0,48.12,17.55,1.22,0.0,27.9,2.8
 4390.3,4390.7,4.9,1.33,0.47,1.19,0.0,56.5,2.82
 4392.1,4392.45,1.7,0.96,0.16,0.01,0.0,87.2,2.68
 4394.85,4395.45,2.4,2.49,0.44,-999.95,0.0,60.8,2.64
 4396.4,4397.0,4.5,2.33,1.62,-999.95,0.0,32.4,2.8
 4398.15,4398.6,3.3,0.8,0.55,-999.95,0.0,31.1,2.77
 4399.1,4399.75,5.1,0.83,0.78,-999.95,0.0,37.5,2.8
 4400.65,4401.0,5.3,1.91,1.27,-999.95,0.0,35.4,2.79
 4402.0,4402.45,3.5,1.01,0.52,-999.95,0.0,33.5,2.81
 4404.0,4404.35,8.1,29.83,13.85,-999.95,0.0,33.5,2.79
 4405.85,4406.4,1.2,13.31,2.49,-999.95,0.0,83.1,2.82
 4408.0,4408.6,3.3,12.39,7.84,-999.95,0.0,56.1,2.79
 4410.0,4410.5,1.2,0.03,0.03,-999.95,0.0,25.0,2.83
 4411.15,4411.75,4.0,1.5,0.91,-999.95,0.0,31.5,2.8
 4412.55,4412.95,1.5,0.05,0.02,-999.95,0.0,37.9,2.84
 4414.8,4415.0,2.2,0.34,0.2,0.75,0.0,34.7,2.81
 4416.4,4417.0,1.5,3.26,0.43,-999.95,0.0,26.5,2.81
 4418.5,4418.95,2.1,4.19,3.64,-999.95,0.0,46.4,2.8
 4420.35,4420.7,3.6,1.07,0.14,-999.95,0.0,34.1,2.79
 4422.0,4422.6,1.7,0.02,0.02,-999.95,0.0,34.5,2.81
 4424.2,4424.65,0.9,6.31,5.09,-999.95,0.0,36.9,2.81
 4426.05,4426.55,3.6,43.19,43.1,-999.95,0.0,40.2,2.8
 4427.8,4428.0,5.2,38.76,2.65,32.27,0.0,13.4,2.82
 4428.0,4428.6,1.7,19.88,1.91,9.08,0.0,29.5,2.79
 4430.5,4431.0,2.3,0.99,0.8,-999.95,0.0,24.6,2.78
 4432.75,4433.0,2.6,0.37,0.19,2.8,0.0,23.8,2.81
 4434.5,4435.0,2.0,17.23,13.66,0.01,0.0,50.8,2.81
 4436.6,4437.0,1.6,0.02,0.02,-999.95,0.0,15.7,2.82
 4438.4,4439.0,1.5,14.7,13.55,-999.95,0.0,70.7,2.74
 4440.45,4440.8,4.0,6.38,4.48,2.35,0.0,24.1,2.82
 4442.65,4443.0,2.9,12.57,6.32,-999.95,0.0,34.1,2.82
 4443.9,4444.5,4.7,185.99,-999.95,293.49,0.0,39.2,2.82
 4446.1,4446.5,5.3,3.3,1.54,0.01,0.0,38.2,2.81
 4448.0,4448.5,5.3,2.46,1.84,0.01,0.0,22.1,2.8
 4450.0,4450.5,2.9,7.52,6.97,-999.95,0.0,18.1,2.83
 4452.0,4452.55,9.7,0.96,0.94,0.01,0.0,42.9,2.79
 4454.0,4454.4,5.0,0.19,0.18,-999.95,0.0,24.4,2.8
 4456.4,4456.6,7.4,0.15,0.11,-999.95,0.0,49.7,2.68
 4458.0,4458.6,6.5,0.07,0.06,-999.95,0.0,56.5,2.76
 4460.9,4461.4,2.1,4.56,0.14,0.01,0.0,40.7,2.81
 4462.4,4463.0,3.6,0.16,0.09,-999.95,0.0,20.9,2.81
 4464.4,4465.0,2.7,3.04,0.29,-999.95,0.0,6.1,2.82
 4466.0,4466.55,2.4,46.93,12.63,11.34,0.0,27.9,2.82
 4468.4,4469.0,1.6,4.72,0.49,0.04,0.0,42.0,2.82
 4470.6,4471.0,3.2,1.63,0.94,-999.95,0.0,13.0,2.8
 4472.0,4472.5,3.3,223.55,67.83,4.46,0.0,30.3,2.81
 4474.45,4475.0,5.3,202.61,196.35,-999.95,0.0,34.5,2.81
 4476.4,4477.0,4.8,7.35,4.24,-999.95,0.0,10.9,2.82
 4478.0,4478.6,1.7,38.15,2.68,-999.95,0.0,14.8,2.83
 4482.25,4482.55,2.2,0.65,0.56,-999.95,0.0,37.6,2.81
 4484.5,4485.0,3.1,4.99,3.9,-999.95,0.0,23.4,2.81
 4486.0,4486.45,1.2,206.69,4.36,3.99,0.0,50.4,2.77
 4488.3,4488.75,1.0,4.44,2.08,3.25,0.0,24.7,2.82
 4491.2,4491.55,0.8,1.02,0.01,4.6,0.0,25.2,2.79
 4494.6,4495.0,0.9,1.11,0.17,2.5,0.0,21.8,2.82
 4496.2,4496.75,2.9,14.49,5.08,0.01,0.0,26.1,2.83
 4500.1,4500.6,1.0,3.95,0.16,0.01,0.0,25.7,2.82
 4502.0,4502.5,2.1,38.76,3.71,16.35,0.0,25.0,2.83
 4503.0,4503.5,8.1,40.51,12.22,-999.95,0.0,35.4,2.81
 4504.1,4504.75,3.0,8.09,6.21,11.3,0.0,60.3,2.81
 4506.4,4507.0,0.7,4.44,1.24,-999.95,0.0,49.7,2.76
 4507.25,4507.75,1.8,5.08,2.41,0.53,0.0,56.4,2.81
 4508.4,4508.8,1.7,19.53,4.07,11.0,0.0,27.9,2.78
 4510.0,4510.5,4.5,12.16,9.34,1.45,0.0,27.8,2.78
 4512.2,4512.4,0.8,0.03,0.01,-999.95,0.0,35.4,2.78
 4514.4,4514.95,3.9,0.24,0.11,-999.95,0.0,34.5,2.79
 4518.4,4518.9,1.9,0.04,0.02,-999.95,0.0,33.7,2.83
 4522.25,4523.0,1.8,36.52,32.13,8.63,0.0,33.3,2.81
 4524.65,4525.0,1.0,2.08,0.02,2.32,0.0,27.3,2.82
 4526.2,4526.8,0.8,0.23,0.12,-999.95,0.0,32.0,2.82
 4534.0,4534.55,2.4,1.7,0.76,-999.95,0.0,55.5,2.82
 4536.0,4536.45,0.5,0.2,0.07,-999.95,0.0,53.9,2.82
 4538.0,4538.6,1.1,20.3,11.69,22.9,0.0,25.2,2.82
 4540.75,4541.0,2.4,0.28,0.01,1.32,0.0,41.3,2.82
 4542.6,4543.1,3.1,2.88,0.29,1.37,0.0,28.2,2.81
 4550.5,4550.8,1.6,2.95,2.05,0.16,0.0,10.2,2.82
 4551.0,4551.65,0.8,2.74,0.56,4.37,0.0,31.1,2.8
 4552.0,4552.8,1.0,79.41,18.22,-999.95,0.0,11.0,2.82
 4554.4,4555.0,1.0,0.07,0.01,-999.95,0.0,20.5,2.81
 4555.15,4556.0,1.3,171.3,2.99,5.06,0.0,34.4,2.81
 4557.25,4557.65,1.7,78.44,3.57,297.16,0.0,15.5,2.81
 4558.4,4558.7,0.7,0.93,0.22,1.42,0.0,25.5,2.82
 4560.0,4560.35,0.8,4.7,0.53,27.71,0.0,47.1,2.82
 4562.1,4562.4,0.5,242.74,0.09,19.62,0.0,57.1,2.82
 4564.2,4564.6,2.2,50.35,3.97,2.76,0.0,14.9,2.82
 4566.3,4566.8,1.0,154.04,60.88,21.04,0.0,67.6,2.82
 4569.4,4569.95,1.8,93.4,69.82,0.02,0.0,29.7,2.77
 4570.2,4570.6,3.4,0.02,0.02,-999.95,0.0,37.4,2.8
 4571.55,4571.95,2.2,22.65,0.01,10.14,0.0,54.0,2.82
 4572.5,4573.0,3.5,15.48,3.83,-999.95,0.0,20.1,2.79
 4574.3,4574.55,1.0,0.03,0.02,-999.95,0.0,46.3,2.81
 4579.15,4579.45,4.5,11.48,0.28,8.1,0.0,19.4,2.82
 4580.6,4581.3,2.3,-999.95,-999.95,-999.95,0.0,35.7,2.83
 4582.0,4582.5,0.9,0.06,0.03,-999.95,0.0,31.5,2.8
 4586.15,4586.4,1.4,0.06,-999.95,-999.95,0.0,21.7,2.82
 4592.7,4592.95,0.8,0.01,0.01,-999.95,0.0,21.6,2.82
 4594.0,4594.6,0.9,180.3,6.25,1.19,0.0,16.1,2.82
 4596.7,4597.0,0.6,1.39,0.06,4.24,0.0,34.1,2.81
 4598.4,4598.85,2.1,51.53,27.79,-999.95,0.0,23.5,2.71
 4600.0,4600.3,2.9,3.48,2.91,0.05,0.0,28.4,2.79
 4602.0,4602.5,1.4,93.4,33.56,40.18,0.0,43.6,2.68
 4604.3,4604.55,4.0,213.51,184.55,676.52,0.0,52.3,2.79
 4606.0,4606.45,1.9,168.61,140.57,26.16,0.0,15.1,2.82
 4608.35,4608.8,0.9,65.75,57.07,-999.95,0.0,13.9,2.83
 4609.0,4609.6,1.7,68.17,1.55,-999.95,0.0,23.4,2.82
 4610.0,4610.3,1.4,0.46,0.19,0.82,0.0,24.2,2.77
 4612.0,4612.6,2.8,1.69,0.03,-999.95,0.0,37.5,2.78
 4614.4,4614.7,0.3,5.14,4.91,0.31,0.0,39.8,2.8
 4616.4,4617.0,2.2,222.64,2.86,-999.95,0.0,33.7,2.75
 4618.6,4619.0,0.9,0.02,0.02,-999.95,0.0,34.4,2.8
 4622.4,4622.7,0.7,0.12,0.11,3.62,0.0,22.3,2.81
 4623.85,4624.6,1.4,72.14,0.19,-999.95,0.0,26.4,2.8
 4626.35,4626.85,8.6,0.29,0.16,-999.95,0.0,45.1,2.74
 4627.9,4628.5,5.9,14.51,0.37,0.84,0.0,37.1,2.73
 4630.0,4630.5,1.1,15.34,7.4,1.8,0.0,22.9,2.83
 4632.4,4632.85,2.8,31.39,7.69,6.33,0.0,19.3,2.81
 4634.5,4634.95,1.6,0.13,0.02,0.06,0.0,24.1,2.81
 4636.0,4636.3,0.5,0.33,-999.95,5.74,0.0,25.9,2.81
 4637.6,4638.1,2.8,107.17,77.6,37.44,0.0,26.3,2.8
 4640.0,4640.5,1.2,8.69,0.02,6.92,0.0,34.4,2.8
 4642.0,4642.3,2.9,11.75,0.24,-999.95,0.0,15.2,2.81
 4644.5,4644.85,1.6,314.41,2.86,-999.95,0.0,32.3,2.81
 4645.3,4645.8,4.0,96.91,93.09,13.56,0.0,30.7,2.79
 4646.0,4646.6,1.2,0.01,0.01,-999.95,0.0,26.3,2.82
 4648.4,4649.0,3.5,1.17,0.03,-999.95,0.0,12.6,2.82
 4650.0,4650.3,0.3,0.01,0.01,-999.95,0.0,66.0,2.81
 4654.0,4654.5,1.2,0.01,-999.95,-999.95,0.0,15.7,2.81
 4680.05,4680.4,2.8,0.16,0.13,-999.95,0.0,33.5,2.79
 4683.5,4683.85,4.6,0.47,0.43,0.02,0.0,20.5,2.79
 4684.6,4684.9,2.0,28.92,0.22,0.01,0.0,10.0,2.82
 4686.4,4686.8,3.3,132.52,1.93,5.64,0.0,17.7,2.72
 4728.7,4729.15,4.5,69.86,23.91,331.78,0.0,58.8,2.71
 4730.5,4731.0,0.7,0.7,0.43,-999.95,0.0,26.6,2.8
 4731.7,4732.3,4.6,322.9,84.48,301.33,0.0,85.9,2.75
 4734.0,4734.6,2.0,0.29,0.16,-999.95,0.0,35.7,2.81
 4736.25,4736.55,0.6,0.66,0.07,-999.95,0.0,28.5,2.83
 4738.0,4738.6,1.8,6.48,0.42,-999.95,0.0,44.8,2.78
 4742.5,4742.9,1.6,170.43,15.54,52.53,0.0,53.9,2.82
 4743.2,4743.65,7.2,1.99,1.22,-999.95,0.0,65.7,2.8
 4744.2,4744.4,2.1,9.91,0.01,0.74,0.0,42.0,2.8
 4746.3,4746.7,2.9,0.42,0.22,-999.95,0.0,40.6,2.79
 4747.65,4748.15,2.7,0.08,0.06,-999.95,0.0,39.7,2.78
 4750.0,4750.5,2.7,18.69,14.1,-999.95,0.0,29.5,2.82
 4752.4,4753.0,1.6,0.59,0.22,-999.95,0.0,34.3,2.8
 4755.0,4755.5,2.9,11.15,1.61,2.44,0.0,49.1,2.82
 4756.2,4756.6,4.5,0.15,0.15,-999.95,0.0,37.8,2.82
 4758.2,4758.8,1.8,5.73,1.21,0.03,0.0,24.2,2.82
 4760.2,4760.55,3.9,0.02,0.02,-999.95,0.0,42.0,2.83
 4762.0,4762.6,4.0,0.1,0.03,-999.95,0.0,45.6,2.82
 4764.0,4764.6,5.4,0.44,0.25,-999.95,0.0,44.4,2.79
 4766.0,4766.3,7.3,0.12,0.12,-999.95,0.0,51.7,2.77
 4770.3,4770.65,5.7,1.08,0.29,0.69,0.0,45.1,2.81
 4772.4,4772.65,1.5,5.5,0.84,2.44,0.0,22.4,2.83
 4774.4,4774.65,4.3,2.14,0.67,0.67,0.0,27.1,2.83
 4776.1,4776.55,6.3,0.31,0.27,-999.95,0.0,34.8,2.78
 4778.3,4778.6,3.5,1.34,0.93,-999.95,0.0,23.0,2.81
 4780.0,4780.2,3.3,5.72,4.04,-999.95,0.0,77.4,2.8
 4782.4,4783.0,7.6,94.67,89.72,1.05,0.0,13.5,2.81
 4784.0,4784.5,1.6,7.59,3.68,-999.95,0.0,30.1,2.79
 4785.55,4786.15,7.9,119.17,101.03,0.83,0.0,26.8,2.81
 4788.0,4788.6,1.3,2.99,1.08,0.01,0.0,64.5,2.81
 4789.45,4790.0,1.5,0.36,0.13,-999.95,0.0,58.9,2.81
 4790.3,4790.6,2.9,4.78,0.29,1.08,0.0,23.9,2.83
 4792.3,4792.8,8.7,94.77,47.5,12.21,0.0,17.3,2.82
 4794.15,4794.65,15.3,82.5,79.09,103.6,0.0,8.4,2.82
 4800.45,4801.0,5.3,0.77,0.3,-999.95,0.0,54.8,2.79
 4802.55,4803.0,4.0,2.33,0.5,5.61,0.0,21.3,2.77
 4804.1,4804.6,4.4,0.09,0.06,-999.95,0.0,52.8,2.78
 4806.7,4807.0,2.1,73.2,0.14,6.86,0.0,54.8,2.74
 4808.0,4808.3,4.8,31.1,2.87,-999.95,0.0,17.0,2.79
 4810.0,4810.6,2.1,249.8,210.24,0.01,0.0,22.3,2.81
 4812.5,4813.0,2.0,147.01,95.46,-999.95,0.0,22.3,2.8
 4814.65,4815.4,2.2,2.94,2.16,-999.95,0.0,39.5,2.8
 4900.3,4900.8,1.8,0.94,0.48,-999.95,0.0,30.7,2.81
 4902.5,4903.0,5.4,1.05,0.99,0.01,0.0,24.4,2.81
 4903.95,4904.65,3.4,0.06,0.06,-999.95,0.0,58.3,2.81
 4906.45,4906.95,6.9,6.88,4.6,1.16,0.0,40.5,2.81
 4908.1,4908.4,8.6,0.13,0.12,-999.95,0.0,56.1,2.69
 4910.0,4910.6,2.3,3.34,0.48,-999.95,0.0,26.1,2.81
 4912.0,4912.5,2.8,0.17,0.14,-999.95,0.0,6.6,2.81
 4913.45,4913.95,2.1,7.79,4.01,-999.95,0.0,79.0,2.78
 4914.4,4914.8,2.3,0.67,0.33,-999.95,0.0,9.4,2.82
 4915.8,4916.5,3.8,1.48,0.55,-999.95,0.0,38.5,2.82
 4918.2,4918.55,7.6,214.97,44.78,9.96,0.0,23.3,2.82
 4920.0,4920.3,6.5,41.46,4.93,4.12,0.0,24.0,2.81
 4923.0,4923.6,2.8,66.95,12.82,-999.95,0.0,45.3,2.82
 4924.5,4924.9,3.9,267.72,5.7,1.94,0.0,18.0,2.82
 4925.0,4925.6,5.2,93.23,74.14,0.02,0.0,55.1,2.82
 4926.1,4926.35,2.6,1.25,0.75,-999.95,0.0,27.0,2.82
 4929.2,4929.75,5.3,1.91,1.48,10.4,0.0,47.8,2.82
 4930.1,4930.6,3.7,195.75,125.15,1.25,0.0,23.7,2.82
 4931.9,4932.75,2.7,277.85,1.77,1.06,0.0,37.4,2.83
 4934.0,4934.5,4.6,10.9,3.98,0.05,0.0,40.4,2.81
 4935.85,4936.35,5.0,14.8,2.86,1.09,0.0,37.2,2.83
 4937.15,4937.7,1.8,1.06,0.08,-999.95,0.0,64.8,2.82
 4938.2,4938.7,1.5,0.77,0.04,-999.95,0.0,10.8,2.82
 4940.0,4940.6,3.3,4.88,0.51,12.49,0.0,27.2,2.81
 4942.3,4942.7,3.8,65.08,3.35,0.08,0.0,18.1,2.82
 4944.6,4945.0,3.8,13.4,7.44,6.32,0.0,53.8,2.82
 4946.0,4946.5,4.7,42.62,34.16,0.01,0.0,39.7,2.82
 4947.2,4947.8,3.1,47.4,0.02,-999.95,0.0,71.7,2.8
 4948.0,4948.4,3.4,0.59,0.09,1.45,0.0,19.5,2.83
 4950.75,4951.3,1.6,175.51,0.04,9.24,0.0,39.1,2.82
 4952.0,4952.6,4.9,82.63,78.62,1.45,0.0,17.8,2.78
 4954.8,4955.25,3.4,1.09,0.26,3.2,0.0,32.0,2.8
 4956.4,4957.0,3.4,180.63,1.36,-999.95,0.0,30.2,2.82
 4958.0,4958.6,5.4,188.05,180.19,-999.95,0.0,55.2,2.81
 4960.5,4960.75,4.8,2.26,0.09,-999.95,0.0,21.0,2.8
 4962.0,4962.5,4.7,1.81,0.74,-999.95,0.0,33.5,2.81
 4964.45,4964.7,5.5,11.89,5.48,0.01,0.0,25.0,2.81
 4966.4,4966.9,5.2,310.37,18.15,13.23,0.0,56.0,2.61
 4968.1,4968.2,3.5,-999.95,-999.95,-999.95,0.0,47.1,2.84
 4970.0,4970.3,5.3,13.94,0.16,0.08,0.0,57.3,2.82
 4972.5,4973.1,2.6,0.1,0.07,-999.95,0.0,31.1,2.82
 4974.0,4974.5,3.3,242.54,82.29,2.89,0.0,43.9,2.82
 4976.15,4976.55,2.9,13.94,0.22,14.14,0.0,37.7,2.82
 4976.9,4977.5,8.8,4.6,4.16,4.45,0.0,60.4,2.67
 4978.1,4978.5,3.8,280.28,15.79,56.63,0.0,72.3,2.73
 4980.5,4981.0,6.4,106.98,43.12,5.55,0.0,36.9,2.72
 4982.1,4982.3,1.9,0.85,0.28,0.06,0.0,55.1,2.82
 4984.5,4985.0,3.3,9.92,6.18,2.03,0.0,26.5,2.77
 4985.1,4985.65,4.7,3.5,3.23,2.74,0.0,50.0,2.7
 4986.65,4987.0,2.5,4.67,3.38,28.39,0.0,42.9,2.66
 4988.2,4988.55,3.4,14.16,5.94,20.42,0.0,42.7,2.67
 4990.2,4990.9,2.2,88.9,0.04,-999.95,0.0,18.6,2.81
 4992.5,4993.0,4.1,0.03,0.01,-999.95,0.0,21.2,2.81
 4993.0,4993.25,3.9,1.36,0.14,0.68,0.0,24.0,2.81
 4995.0,4995.75,4.8,0.29,0.07,-999.95,0.0,51.2,2.79
 4997.0,4997.3,3.5,0.8,0.32,0.15,0.0,28.9,2.81
 5051.0,5051.4,4.4,125.3,67.28,29.58,0.0,44.3,2.83
 5055.0,5055.6,2.3,107.85,0.1,-999.95,0.0,77.1,2.83
 5057.25,5057.85,8.5,284.45,4.26,1.24,0.0,82.6,2.69
 5058.1,5058.8,4.5,3.15,2.3,-999.95,0.0,16.9,2.79
 5059.0,5059.6,3.2,1.16,0.16,-999.95,0.0,29.0,2.81
 5061.0,5061.3,2.2,72.18,3.9,1.67,0.0,17.9,2.83
 5062.5,5063.15,1.9,123.16,0.08,-999.95,0.0,34.3,2.82
 5065.0,5065.6,2.6,17.98,9.92,0.01,0.0,10.0,2.82
 5067.0,5067.6,3.1,3.62,2.62,0.03,0.0,18.8,2.82
 5069.6,5070.25,2.5,14.08,0.48,22.62,0.0,40.9,2.82
 5071.0,5071.6,2.7,0.02,0.02,-999.95,0.0,11.4,2.82
 5073.0,5073.6,2.0,0.67,0.02,-999.95,0.0,22.1,2.82
 5074.15,5074.7,11.8,5.8,4.62,0.1,0.0,55.7,2.8
 5075.2,5075.8,9.2,2.61,1.51,-999.95,0.0,17.5,2.81
 5077.35,5077.65,4.2,0.19,0.15,-999.95,0.0,32.3,2.81
 5078.2,5078.8,8.3,0.17,0.1,-999.95,0.0,83.3,2.81
 5079.35,5079.8,8.8,0.04,0.03,-999.95,0.0,35.7,2.82
 5081.0,5081.6,4.3,0.07,0.05,-999.95,0.0,21.4,2.83
 5084.3,5084.7,5.3,1.31,0.08,0.85,0.0,66.1,2.79
 5085.1,5085.55,4.8,75.6,26.48,1.31,0.0,47.5,2.81
 5086.3,5086.8,1.9,104.8,0.02,-999.95,0.0,52.0,2.81
 5088.1,5088.6,3.4,14.13,0.03,10.22,0.0,23.6,2.81
 5090.2,5090.6,2.1,3.66,0.02,3.04,0.0,24.7,2.81
 5092.3,5092.6,1.6,5.21,0.85,-999.95,0.0,29.5,2.83
 5096.15,5097.0,1.8,0.01,0.01,-999.95,0.0,39.0,2.8
 5097.45,5098.0,1.7,175.34,24.81,2.53,0.0,28.9,2.81
 5098.0,5098.5,2.0,9.28,4.41,7.69,0.0,44.2,2.8
 5100.0,5100.6,1.5,33.91,5.63,9.13,0.0,31.5,2.77
 5102.1,5102.5,1.9,5.24,0.04,8.98,0.0,43.7,2.81
 5104.0,5104.45,8.5,6.38,5.81,0.48,0.0,47.0,2.83
 5105.0,5105.6,8.0,13.49,10.13,0.03,0.0,52.5,2.82
 5106.0,5106.6,6.7,2.19,2.15,0.01,0.0,40.1,2.82
 5108.15,5108.7,3.2,0.05,0.02,-999.95,0.0,65.5,2.82
 5110.5,5111.0,3.3,0.03,0.02,-999.95,0.0,30.1,2.82
 5114.45,5115.0,4.2,0.08,0.05,-999.95,0.0,33.0,2.83
 5116.3,5116.8,1.9,0.23,0.14,-999.95,0.0,31.8,2.83
 5117.15,5117.75,5.7,40.14,24.78,2.17,0.0,46.8,2.82
 5118.0,5118.6,1.5,105.47,53.37,4.59,0.0,35.3,2.82
 5120.0,5120.6,2.0,0.17,0.07,-999.95,0.0,33.3,2.83
 5122.4,5123.0,1.8,175.31,2.06,-999.95,0.0,34.7,2.83
 5124.0,5124.5,2.1,0.21,0.02,0.17,0.0,49.8,2.83
 5126.0,5126.5,2.5,0.73,0.08,-999.95,0.0,59.4,2.82
 5127.1,5127.65,2.2,0.76,0.04,7.38,0.0,70.8,2.83
 5128.4,5129.0,3.5,0.55,0.33,-999.95,0.0,30.4,2.8
 5130.0,5130.6,4.9,22.17,7.97,-999.95,0.0,28.9,2.8
 5132.0,5132.6,4.6,3.58,0.6,5.12,0.0,52.0,2.76
 5134.4,5135.0,4.5,0.7,0.38,-999.95,0.0,31.2,2.76
 5136.0,5136.6,2.2,0.09,0.08,-999.95,0.0,26.1,2.79
 5138.0,5138.6,2.5,0.4,0.31,-999.95,0.0,29.2,2.82
 5140.4,5141.0,4.4,2.88,2.11,-999.95,0.0,6.4,2.7
 5141.0,5141.6,4.7,0.42,0.37,-999.95,0.0,42.2,2.75
 5142.2,5142.55,6.3,28.5,27.72,19.55,0.0,6.7,2.68
 5144.0,5144.6,3.5,0.13,0.11,-999.95,0.0,23.6,2.75
 5146.0,5146.5,1.8,1.66,1.01,-999.95,0.0,41.2,2.82
 5148.0,5148.6,5.0,1.86,0.11,-999.95,0.0,19.1,2.73
 5150.3,5150.8,3.7,0.33,0.07,-999.95,0.0,20.4,2.8
 5152.2,5152.6,2.4,0.23,0.19,-999.95,0.0,39.5,2.83
 5154.6,5155.0,1.9,0.54,0.3,10.79,0.0,52.2,2.83
 5156.0,5156.6,1.8,6.18,1.83,-999.95,0.0,37.0,2.82
 5158.0,5158.4,2.9,0.01,0.01,-999.95,0.0,36.4,2.79
 5160.65,5161.0,3.3,0.09,0.03,-999.95,0.0,52.3,2.75
 5162.1,5162.7,4.5,0.09,0.06,-999.95,0.0,39.6,2.77
 5170.2,5170.8,5.0,0.04,0.04,-999.95,0.0,75.9,2.66
 5176.25,5176.8,0.4,4.85,3.02,3.97,0.0,84.4,2.69

~Tops_Parameter
#MNEM .UNIT             VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                        : Profile Web App Saved Data Indicator {S}
 TOPS  .          Paul Gerlach  : Formation Source               {S}
 TOPDR .                   LOG  : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 TOPA  .                      : Alternate Name                 {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 SSYS  .                      : Subsystem                      {S}
 STG   .                      : Stage                          {S}
 GRP   .                      : Group                          {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
# TOPT TOPB RANK LVL TOPN TOPA EON ERA SYS SER SSYS STG GRP FORM
 620.0,0.0,"GROUP","Poor","Chase","Chase","Phanerozoic","Paleozoic","Permian","Wolfcampian","-999.25","-999.25","-999.25","-999.25"
 748.0,0.0,"MEMBER","Poor","Towanda Limestone","Towanda Limestone","Phanerozoic","Paleozoic","Permian","Wolfcampian","-999.25","-999.25","-999.25","-999.25"
 1595.0,0.0,"GROUP","Poor","Wabaunsee","Wabaunsee","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 1622.0,0.0,"FORMATION","Poor","Root Shale","Root Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 1662.0,0.0,"FORMATION","Poor","Stotler Limestone","Stotler Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 1920.0,0.0,"FORMATION","Poor","Severy Shale","Severy Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 1980.0,0.0,"FORMATION","Poor","Topeka Limestone","Topeka Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 2312.0,0.0,"FORMATION","Poor","Lecompton Limestone","Lecompton Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 2402.0,0.0,"MEMBER","Poor","Heebner Shale","Heebner Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 2703.0,0.0,"BED","Poor","Stalnaker Sandstone","Stalnaker Sandstone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 3039.0,3273.0,"GROUP","Poor","Kansas City","Kansas City","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","Kansas City","-999.25"
 3169.0,0.0,"MEMBER","Poor","Stark Shale","Stark Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 3273.0,0.0,"BED","Poor","B-KCTY","B-KCTY","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","-999.25","-999.25","-999.25"
 3273.0,3364.0,"GROUP","Poor","Pleasanton","Pleasanton","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Missourian","Pleasanton","-999.25"
 3364.0,3497.0,"GROUP","Poor","Marmaton","Marmaton","Phanerozoic","Paleozoic","Carboniferous","Middle","Pennsylvanian","-999.25","Marmaton","-999.25"
 3452.0,0.0,"FORMATION","Poor","Pawnee Limestone","Pawnee Limestone","Phanerozoic","Paleozoic","Carboniferous","Middle","Pennsylvanian","-999.25","-999.25","-999.25"
 3497.0,3656.0,"GROUP","Poor","Cherokee","Cherokee","Phanerozoic","Paleozoic","Carboniferous","Middle","Pennsylvanian","-999.25","Cherokee","-999.25"
 3656.0,3909.0,"SUBSYSTEM","Poor","Mississippian","Mississippian","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","-999.25","-999.25","-999.25"
 3909.0,0.0,"BED","Poor","B MISS","B MISS","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","-999.25","-999.25","-999.25"
 3911.0,4045.0,"STAGE","Poor","Kinderhookian","Kinderhookian","Phanerozoic","Paleozoic","Carboniferous","Lower","Mississippian","Kinderhookian","-999.25","-999.25"
 4045.0,4064.0,"FORMATION","Poor","Chattanooga Shale","Chattanooga Shale","Phanerozoic","Paleozoic","Devonian","-999.25","-999.25","-999.25","-999.25","Chattanooga Shale"
 4064.0,4160.0,"GROUP","Poor","Simpson","Simpson","Phanerozoic","Paleozoic","Ordovician","Middle","-999.25","-999.25","Simpson","-999.25"
 4160.0,5140.0,"GROUP","Poor","Arbuckle","Arbuckle","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","Arbuckle","-999.25"
 4171.0,0.0,"FORMATION","Poor","Cotter and Jefferson City Dolomite","Cotter and Jefferson City Dolomite","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4393.0,0.0,"BED","Poor","JCC 3","JCC 3","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4394.0,0.0,"BED","Poor","JCC Upr SH Zn","JCC Upr SH Zn","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4497.0,0.0,"BED","Poor","JCC 2","JCC 2","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4600.0,0.0,"BED","Poor","JCC 1","JCC 1","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4602.0,0.0,"BED","Poor","JCC Lwr SH Zn","JCC Lwr SH Zn","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4648.0,0.0,"BED","Poor","JCC ROU 1","JCC ROU 1","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4650.0,0.0,"BED","Poor","JCC ROU 1H","JCC ROU 1H","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4793.0,0.0,"FORMATION","Poor","Roubidoux","Roubidoux","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4845.0,0.0,"BED","Poor","JCC ROU 1F","JCC ROU 1F","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 4908.0,0.0,"FORMATION","Poor","Gasconade and Van Buren Dolomite","Gasconade and Van Buren Dolomite","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5033.0,0.0,"BED","Poor","JCC ROU 1E","JCC ROU 1E","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5040.0,0.0,"BED","Poor","JCC ROU 1D","JCC ROU 1D","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5044.0,0.0,"BED","Poor","JCC ROU 1C","JCC ROU 1C","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5108.0,0.0,"BED","Poor","JCC ROU 1B","JCC ROU 1B","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5121.0,0.0,"BED","Poor","JCC ROU 1A","JCC ROU 1A","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5124.0,0.0,"BED","Poor","JCC ROU 1 Base","JCC ROU 1 Base","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5130.0,5140.0,"MEMBER","Poor","Gunter Sandstone","Gunter Sandstone","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","-999.25"
 5140.0,5159.0,"FORMATION","Poor","Lamotte (Reagan) Sandstone","Lamotte (Reagan) Sandstone","Phanerozoic","Paleozoic","Cambrian","Upper","-999.25","-999.25","-999.25","Lamotte (Reagan) Sandstone"
 5159.0,5249.0,"SYSTEM","Poor","Precambrian","Precambrian","-999.25","-999.25","Precambrian","-999.25","-999.25","-999.25","-999.25","-999.25"

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F             3550.0  : Starting Display Depth         {F}
 IQSTOP  .F             5250.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN            100  : Plot Scale Feet/Inch           {F}
 IQGRP   .                 ALL  : LAS, ROCK or HORIZON           {S}
 IQORDR  .            MODIFIED  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                NPHI  : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                MNOR  : Micro Normal Resistivity       {S}
 IQOHM_L .MMHO/M           0.0  : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M         500.0  : Conductivity Image Track Maximum Value {F}
 IQPHI   .                NPHI  : Neutron porosity               {S}
 IQPHI_L .PU               0.0  : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU               0.3  : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
# IQ_SRC IQ_TYPE IQ_DESC
 "LAS","LITH","Lithology - Gamma Ray"
 "LAS","LAS","LAS - Reference - GR,SP,CAL Logs"
 "LAS","LITH","Colorlith - Resistivity Imager"
 "LAS","LITH","Colorlith - Resistivity Imager Nonlinear"
 "LAS","LAS","LAS - Micro Resistivity Logs"
 "LAS","LAS","LAS - AHT Resistivity Logs"
 "LAS","LITH","Colorlith - Porosity Imager"
 "LAS","LITH","Colorlith - Porosity Imager Nonlinear"
 "LAS","LAS","LAS - Litho-Density - NPHI,RHOB,PE Logs"
 "LAS","LAS","LAS - Sonic - SPHI,DT Logs"
 "LAS","LITH","Colorlith - Hall K-Th-U (RGB) Track"
 "LAS","LAS","LAS - Spectral Gamma Ray - Th,U,K Logs"
 "LAS","LITH","Colorlith - Th/U - Th/K Track"
 "LAS","LAS","LAS - Spectral Gamma Ray Ratios"
 "LAS","LITH","Colorlith - Rhomaa-Umaa Track"
 "LAS","ROCK","Lithology - Rhomaa-Umaa Track"
 "LAS","PHI","Thin Porosity Track"
 "TOPS","STRAT","Horizons - Stratigraphic Units"
 "ROCK","LAS","Data - Core Density & Porosity"
 "ROCK","LAS","Data - Whole Core Permeability"
 "ROCK","LAS","Data - Saturation"
 "ROCK","COLOR","Color - Rock RGB Values"
 "ROCK","ROCK","Lithology - Measured Sections"
 "ROCK","SIZE","Lithology - Grainsize"
 "ROCK","ICON","Sedimentary Structures"
 "ROCK","ICON","Fossils"
 "ROCK","PHI","Porosity Track"
 "ROCK","PHI","Porosity Type"
 "ROCK","DESC","Description"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                 YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F             2340.0  : Starting Display Depth         {F}
 GEOSTOP .F             5178.5  : Ending Display Depth           {F}
 GEOSRC  .            L.Watney  : Source                         {S}
 GEOREF  .                 LOG  : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
# GEOTOP GEOBASE GEOBED GEODES
 2340.0,2344.0,4.0,"2340; 2344; Sh, gy, drk gy, frm "
 2344.0,2352.0,8.0,"2344; 2352; LS, tan-buff, f-crypto xln, hard, dns, few pcs of drk frs, chrt. "
 2352.0,2362.0,10.0,"2352; 2362; LS, tan, fxln,scrt foss, scrtd vuggy por, ns "
 2362.0,2374.0,12.0,"2362; 2374; Sh, grn, gy drk gy, grn, silty, pyritic, gy silty, scrtd foss "
 2374.0,2380.0,6.0,"2374; 2380; LS, buff, fxln,hrd dns, with LS, wht-tan,fxln, chlky-sub chalky, dns "
 2380.0,2394.0,14.0,"2380; 2394; Sh, grn, lt gn, gy, lt grn, soft, sticky, strngers of gy siltstone "
 2394.0,2406.0,12.0,"2394; 2406; LS, tan, f-med xln, scrtd foss, sub chalky, hrd with LS, buff, fxln, hrd, dns "
 2406.0,2406.0,-999.25,"2406; Heebner Shale "
 2406.0,2418.0,12.0,"2406; 2418; Sh, blk, carb, firm, pyritic "
 2418.0,2422.0,4.0,"2418; 2422; LS, buff, f-med xln, foss, hrd, dns, ns "
 2422.0,2434.0,12.0,"2422; 2434; SS, wht-clr, f grn, rndd-sub rndd, calc cement, tight, some clr ss with int xln, & vuggy poro, ns, sringers of Siltstone, gy, with LS, wht, fxln, soft, chalky "
 2434.0,2450.0,16.0,"2434; 2450; LS, wht-tan,fxln,foss,pp & vuggy poro, ns, LS, wht, fxln, hrd, dns, styolite, stringers of pyrite "
 2450.0,2462.0,12.0,"2450; 2462; Sh, grn, gy, grn, silty, pyritic "
 2462.0,2466.0,4.0,"2462; 2466; LS, tan, fxln, hrd, sctrd vuggy poro, ns "
 2466.0,2474.0,8.0,"2466; 2474; Sh, grn, gy, with Siltstone grn "
 2474.0,2478.0,4.0,"2474; 2478; LS, buff, f-crypt xln, hrd, dns "
 2478.0,2488.0,10.0,"2478; 2488; Sh, gy-drk gy, frm "
 2488.0,2502.0,14.0,"2488; 2502; LS, wht-tan, f-med xln, v foss, partly oolit, intxln, omoldic and vuggy poro, ns "
 2502.0,2520.0,18.0,"2502; 2520; Sh, gy, drk gy, sctrd red, some stringers of grn-gy siltstone "
 2520.0,2540.0,20.0,"2520; 2540; Sh, gy, grn, and lt grn, intrbdd with Ls, tan, f-med xln, foss, pp & vuggy pror, ns "
 2540.0,2558.0,18.0,"2540; 2558; Sh, gy, drk gy, frm, stringers of lt grn-clr, vf grn SS with calc cement, tight "
 2558.0,2562.0,4.0,"2558; 2562; LS, tan-buff, fxln,foss, hrd, dns,some drk fresh, chrt "
 2562.0,2580.0,18.0,"2562; 2580; Sh, drk gy, gy, intr bdd with some grn, siltstone "
 2580.0,2590.0,10.0,"2580; 2590; Sh, grn, gy sctrd red, with clr-lt grn siltstone, pyritic "
 2590.0,2610.0,20.0,"2590; 2610; Sh, gy, scrtd grn with some intrbdd siltstone "
 2610.0,2650.0,40.0,"2610; 2650; Sh, gy, drk gy and scrtd grn and red, some pcs of blk sh, gy Sh, with thin lyrs of blk sh, pyritic, few pcs of LS, wht, f-med xln, foss, chalky, ns "
 2650.0,2678.0,28.0,"2650; 2678; Sh, g, drk gy, AA, some lt grn siltstone "
 2680.0,2680.0,-999.25,"2680; Iatan Limestone "
 2678.0,2684.0,6.0,"2678; 2684; LS, buff-brwn, f-med xln, foss, hrd, dns, ns "
 2684.0,2686.0,2.0,"2684; 2686; sh "
 2686.0,2688.0,2.0,"2686; 2688; LS, tan, fxln, hrd, dns with gy "
 2688.0,2691.0,3.0,"2688; 2691; Sh "
 2691.0,2691.0,-999.25,"2691; Stalnaker Sandstone "
 2691.0,2696.0,5.0,"2691; 2696; SS, wht, clr, lt grn, f grn, calc cement, tight "
 2696.0,2704.0,8.0,"2696; 2704; Sh, grn gy, few pcs of blk, hrd, frm "
 2704.0,2730.0,26.0,"2704; 2730; SS, wht-clr, f-med grain, sub rndd-ang, poorly srtd, int xln & vuggy poro, partl glauc, some with wht calc cement, tight, ns "
 2730.0,2746.0,16.0,"2730; 2746; SS, wht-clr, f-med grn, ang-sub rndd, int xln and vuggy poro, Sh, grn, lt grn, soft "
 2746.0,2750.0,4.0,"2746; 2750; LS, tan, fxln, hrd, dns, sctrd foss, ns "
 2750.0,2778.0,28.0,"2750; 2778; SS, clr-lt grn, f grn, poorly srtd, tight, with some stringrs of gy sh, SS, clr, med grn, well srtd, sub rndd-ang, int xln & vugy poro, ns "
 2778.0,2780.0,2.0,"2778; 2780; LS, wht, fxln, hrd, dns, sctrd foss, sub chalky "
 2780.0,2808.0,28.0,"2780; 2808; SS, clr, med grn, rndd-sub rndd, well srtd, int xln poro, partly glauc, ns "
 2808.0,2816.0,8.0,"2808; 2816; SS, clr-wht, f grn, prly srtd, with gy sh strngrs, tight "
 2816.0,2824.0,8.0,"2816; 2824; SS, clr, med grn, rndd-sub rndd, well srtd, int xln poro, partly glauc, ns "
 2824.0,2850.0,26.0,"2824; 2850; Sh, lt gy, silty, Siltstone, lt grn "
 2850.0,2866.0,16.0,"2850; 2866; Sh, gy, pyritic "
 2866.0,2868.0,2.0,"2866; 2868; LS, buff, f-med xln, hrd, dns "
 2868.0,2920.0,52.0,"2868; 2920; Sh, gy, pyritic, partly silty "
 2920.0,2930.0,10.0,"2920; 2930; Sh, gy, LS, tan, fxln, scrtd pp poro, ns "
 2930.0,2950.0,20.0,"2930; 2950; Sh, gy, pyritic "
 2950.0,3014.0,64.0,"2950; 3014; Sh, drk gy, gy, argl, pyritic, few pcs of grn and red Sh, Siltstone, lt gy-clr, stringrs of blk sh "
 3014.0,3041.0,27.0,"3014; 3041; Sh, blk, carb "
 3041.0,3041.0,-999.25,"3041; Lansing KC "
 3041.0,3054.0,13.0,"3041; 3054; LS< LS, tan, sucro-med xln, foss, pp & vuggy poro, ns, LS, wht, f xln, soft chalky "
 3054.0,3070.0,16.0,"3054; 3070; LS, tan-buff, f xln, hrd, dns, scrtd foss, ns, pcs of drk fresh chrt "
 3070.0,3090.0,20.0,"3070; 3090; LS, off wht-tan sucro-med xln, foss, partly oolit, vuggy and pp poro, partly chalky, ns "
 3090.0,3098.0,8.0,"3090; 3098; LS, wht, f-crypto xln, hrd, dns, with fresh lt chrt "
 3098.0,3110.0,12.0,"3098; 3110; LS, tan, mix xln, foss, vuggy, int xln and intra xln poro, ns "
 3110.0,3120.0,10.0,"3110; 3120; LS, wht-tan, crypto xln, hrd, sctrd foss, sctrd vuggy poro, dns, ns "
 3120.0,3136.0,16.0,"3120; 3136; LS, tan, off wht, sucro-f xln, foss, vuggy & pp poro, sub chalky - chalky, ns "
 3136.0,3146.0,10.0,"3136; 3146; LS, tan-wht, f-crypto xln, hrd, dns, mostly fress, wht-lt tan chert "
 3146.0,3152.0,6.0,"3146; 3152; LS, brwn-buff, sucro-f xln, foss, vuggy poro, ns "
 3152.0,3160.0,8.0,"3152; 3160; LS, tan, f-crypto xln, hrd, dns "
 3160.0,3168.0,8.0,"3160; 3168; LS, tan, sucro-f xln, pp & scrtd vuggy poro, ns "
 3168.0,3168.0,-999.25,"3168; Stark Shale "
 3168.0,3172.0,4.0,"3168; 3172; Sh, gy, drk gy, pyritic "
 3172.0,3186.0,14.0,"3172; 3186; LS, tan-buff, f-med xln, hrd, dns, sctrd vuggy poro, LS, wht-tan, fxln, sub chalky, ns "
 3186.0,3196.0,10.0,"3186; 3196; LS, tan, f-med xln, foss, oolit, ( packstone ), tight, no visi poro, ns "
 3196.0,3208.0,12.0,"3196; 3208; LS, tan-buff, f xln, hrd, dns, partly cherty, some fresh, lt, chrt "
 3208.0,3212.0,4.0,"3208; 3212; Sh, blk, carb, pyritic "
 3212.0,3216.0,4.0,"3212; 3216; SS, clr-wht, f grn, sub rndd-angular, prly srtd, calc cement, tight, ns "
 3216.0,3226.0,10.0,"3216; 3226; LS, buff, f-med xln, scrtd foss, hrd, dns "
 3226.0,3236.0,10.0,"3226; 3236; LS, tan, sucro, foss, pp poro, ns "
 3236.0,3250.0,14.0,"3236; 3250; LS, tan, buff, f-med xln, scrtd foss, scrtd vuggy poro, hrd, dns, ns "
 3250.0,3284.0,34.0,"3250; 3284; LS, buff, f-crypto xln, hrd, dns, few fractured, some stylolite, few pcs of wht chalky LS "
 3284.0,3284.0,-999.25,"3284; BKC "
 3284.0,3290.0,6.0,"3284; 3290; Sh, grn, gy drk gy, mostly blk carb, pyritic "
 3290.0,3292.0,2.0,"3290; 3292; LS, tan, f-med xln, hrd, dns "
 3292.0,3302.0,10.0,"3292; 3302; Sh, gy, drk gy, pyritic "
 3302.0,3304.0,2.0,"3302; 3304; LS, tan, med xln, hrd, dns "
 3304.0,3312.0,8.0,"3304; 3312; Sh, blk, carb,pyritic "
 3312.0,3326.0,14.0,"3312; 3326; LS, tan, f xln, scrtd foss, hrd, dns "
 3326.0,3348.0,22.0,"3326; 3348; Sh, grn-lt grn, with lt grn siltstone "
 3348.0,3350.0,2.0,"3348; 3350; LS, lt grn-lt tan, f-crypto xln, hrd, dns "
 3350.0,3366.0,16.0,"3350; 3366; Sh, grn, gy, and some drk gy, grn, silty "
 3366.0,3380.0,14.0,"3366; 3380; LS, tan,sucro-f xln, pp & scrtd vuggy poro, ns, LS, tan-lt grn, f-crypto xln, hrd, dns "
 3380.0,3384.0,4.0,"3380; 3384; Sh, blk, carb, pyritic, sh, grn, gy, lt grn, silty "
 3384.0,3392.0,8.0,"3384; 3392; LS, tan-buff, f-med xln, scrtd foss, sctrd vuggy poro, ns, LS, tan, f-crypto xln, hrd, dns "
 3392.0,3404.0,12.0,"3392; 3404; Sh, gy, drk gy, pyritic, with gy-grn siltstone "
 3404.0,3420.0,16.0,"3404; 3420; LS, buff-drk gy, f-crypto xln, hrd, dns "
 3420.0,3440.0,20.0,"3420; 3440; LS, tan, sucro-med xln, foss, pp & scrtd vuggy poro, ns LS, buff, crypto-f xln hrd, dns, cherty "
 3440.0,3450.0,10.0,"3440; 3450; Sh, gy, drk gy, blk "
 3450.0,3450.0,-999.25,"3450; Pawnee Limestone "
 3450.0,3464.0,14.0,"3450; 3464; LS, tan sucro-f xln, foss, vuggy and pp poro, ns "
 3464.0,3480.0,16.0,"3464; 3480; LS, tan-buff, f-crypto xln, hrd, dns, partly cherty, with fresh lt & crk chert "
 3480.0,3490.0,10.0,"3480; 3490; Sh, blk, crb, gy & drk gy, pyritic some clr-lt grn siltstone "
 3490.0,3490.0,-999.25,"3490; FTSC "
 3490.0,3504.0,14.0,"3490; 3504; LS, tan-buff, f-crypto xln, hrd, dns, LS, tan sucro-f xln, scrtd vuggy & pp poro, ns "
 3504.0,3504.0,-999.25,"3504; Cherokee "
 3504.0,3508.0,4.0,"3504; 3508; Sh, blk, carb "
 3508.0,3518.0,10.0,"3508; 3518; LS, buff, f-med xln, foss, oolit, ( packstone ) hrd, dns, no visi poro "
 3518.0,3526.0,8.0,"3518; 3526; Sh, grn, gy, drk gy "
 3526.0,3530.0,4.0,"3526; 3530; LS, buff, f-crypto xln, hrd, dns "
 3530.0,3540.0,10.0,"3530.0; 3540.0; LS, tan sucro-med xln, foss, vuggy & pp poro, ns "
 3540.0,3600.0,60.0,"3540; 3600; Core 1   LOWER FT. SCOTT LS. "
 3540.0,3542.3,2.3,"3540; 3542.3; grayish black; N2; lime mudstone; very argillaceous; slight to moderately silty; scattered fine skeletal debris in wackestone fabric; considerably mottled; grayish black N2 and grayish orange 10YR7/4; bioturbated; gradational contact "
 3542.3,3545.3,3.0,"3542.3; 3545.3; grayish black; N2; shale; calcareous; very firm; zones of bivalves and brachiopods; sharp contact "
 3545.3,3554.7,9.4,"3545.3; 3554.7; grayish black; N2; firm; shale; varying amounts of calcareous material; cm-thick layers; calcareous layers are olive gray 5Y4/1; gradational contacts several cm-thick; contain horizontal lenticular bedding with darker shale at 3643.7-43.5, 3650.7; 3649.3-3649.5, 3647-3647.3; cm to several cm-thick skeletal ( crinoid, bivalves, brachiopods ) lags at 3650.7-3650.5, 3647.3-3647.5, 3646-3646.3; slightly water reactive but firm; sharp contact "
 3554.7,3555.0,0.3,"3554.7; 3555;  grayish black; N2; lime wackestone; bioclastic; sharp contact "
 3555.0,3563.1,8.1,"3555;  3563.1; greenish black; 5GY2/1; mottled with olive gray 5Y4/1; mudstone; blocky; soft; clotted; cm-size and smaller granular structures; sharp contact "
 3563.1,3563.5,0.4,"3563.1; 3563.5; medium dark gray; N4; shale; with grayish orange 10YR7/4 lithoclasts and thin bed; carbonate is skeletal slightly sandy wackestone to packstone; sharp contact "
 3563.5,3573.0,9.5,"3563.5; 3573; dark gray; N3; grades upward to dark greenish gray 5G4/1; shale; calcareous; bottom 6 is soft and water reactive; less water reactive up to 3571.5; moderately firm above 3571.5; sharp contact "
 3573.0,3575.5,2.5,"3573; 3575.5; medium dark gray; N4; shale; very soft; flakey; bottom 4 water reactive; dusky red 5R3/4 and moderate yellowish brown 10YR5/4; 10% mottling; sharp contact "
 3575.5,3580.0,4.5,"3575.5; 3580; greenish black; 5GY2/1; shale; soft; claystone; dusky red 5R3/4 mottles at bottom 6; silty faintly laminated greenish black 5GY2/1 shale which grades upward to olive gray 5Y4/1; top 4 has dark 10YR6/6 mottles; sharp contact "
 3580.0,3580.5,0.5,"3580; 3580.5; dark greenish gray; 5G4/1; skeletal wackestone; argillaceous; sharp contact "
 3580.5,3582.9,2.4,"3580.5; 3582.9; grayish black; N2; shale; ranges to greenish black 5G2/1; soft to moderately firm; firming upwards; sharp contact "
 3582.9,3585.0,2.1,"3582.9; 3585; olive gray; 5Y4/1; very argillaceous skeletal lime wackestone; firm; very sharp contact "
 3585.0,3590.0,5.0,"3585; 3590; medium dark gray; N4; shale; very soft; flakey; top inch is dark grayish black N2 chert; sharp contact "
 3590.0,3593.2,3.2,"3590; 3593.2; dusky yellow green; 5GY5/2; shale; limestone interclasts of skeletal wackestone to packstone; clasts are pinkish gray 5YR8/1; moderately soft ; intervals range from firm to soft water reactive; blocky mudstone; sharp contact "
 3593.2,3595.2,2.0,"3593.2; 3595.2; olive gray; 5Y4/1; shale; light olive gray 5Y 6/1 lithoclasts of skeletal wackestone; moderately firm; sharp contact "
 3595.2,3599.3,4.1,"3595.2; 3599.3; medium dark gray; N4; shale; soft; water reactive; sharp contact contact "
 3599.3,3602.0,2.7,"3599.3; 3602; brownish gray 5YR4/1; shale; moderately firm; autoclastic breccia appearance; clasts varying from brownish gray 5YR4/1 to dusky red 5R3/4; more dominantly red above 3600; flecks of gleyed material at sharp contact; vertical mottling "
 3602.0,3607.5,5.5,"3602; 3607.5; brownish gray 5YR4/1; grades up to medium dark gray N4; shale; indistinct bedding; moderately firm; water reactive; gradational contact "
 3607.5,3610.1,2.6,"3607.5; 3610.1; olive black; 5Y2/1; olive gray 5Y4/1; mottled; grayish red purple 5RP4/2; sandstone; very fine silty; thin wispy wavy bedding; low angle cross stratification; wavy; mm-size beds; alternating colors; small scale ripple cross laminations; upper 6 has mottled brecciated and disrupted fabric;  upper 4 inches are light olive gray 5Y 6/1; gradational contact "
 3610.1,3613.4,3.3,"3610.1; 3613.4; dark reddish brown 10R3/4; greenish gray 5GY 6/1; alternating bedding; shale; slightly firmer; more silt grading upwards towards silty shale; 50/50 uniformly bedded; heterolithic bedding with ripple laminations; (tidal); gradational contact "
 3613.4,3618.9,5.5,"3613.4; 3618.9; dark reddish brown 10R3/4; greenish gray 5GY6/1; 50/50 variegated color; shale; variegated; blocky; silty mudstone; ped structures; gradational contact "
 3618.9,3620.4,1.5,"3618.9; 3620.4; 5GY5/2; dusky yellow green; shale; blocky mudstone; water reactive; soft; gradational contact "
 3620.4,3622.3,1.9,"3620.4; 3622.3; dusky red 10YR2/2; shale; soft; variegated; dusky red 10YR2/2 with dark yellowish orange 10YR6/6; blocky mudstone; distinct patches partially; clotted with dark yellowish orange 10YR6/6; gradational contact "
 3622.3,3623.0,0.7,"3622.3; 3623; autoclastic breccia; lime mudstone; sharp contact "
 3623.0,3624.8,1.8,"3623; 3624.8; 5GY5/2; dusky yellow green; shale; soft; grades to dark green 5GY4/1; sharp contact "
 3624.8,3625.5,0.7,"3624.8; 3625.5; very pale orange; 10YR8/2; autoclastic lime mudstone breccia; 5GY5/2 dusky yellow green matrix between clasts; sharp contact "
 3625.5,3627.0,1.5,"3625.5; 3627; grayish black; N2; shale; soft; sharp contact "
 3627.0,3627.2,0.2,"3627; 3627.2; greenish gray 5GY6/1; shale; lime packstone; lithoclasts of the limestone below 3627.2-3627; sharp contact "
 3627.2,3628.4,1.2,"3627.2; 3628.4; yellowish gray; 5Y8/1; lime packstone; interclastic skeletal packstone to grainstone; lithoclastic; 3628-3628.2 shale bed; sharp contact "
 3628.4,3630.9,2.5,"3628.4; 3630.9; greenish gray 5GY6/1; shale; moderately firm; poorly bedded; sharp contact "
 3630.9,3637.2,6.3,"3630.9; 3637.2; dark gray; N3; claystone; very soft; water reactive; occasional cm-size clasts of carbonate to 3636.5; grades up to a medium dark gray N4 soft shale at 3632.5; 3632.5-3630.9 is a moderately firm medium dark gray N4 shale mottled from brownish gray 5YR4/1 to greenish gray 5GY6/1;  gradational contact "
 3637.2,3637.8,0.6,"3637.2; 3637.8; dusky yellow green; 5GY5/2; shale; basal clasts; cm-size clasts incorporated in green shale; gradational contact "
 3637.8,3639.2,1.4,"3637.8; 3639.2; 5Y6/1; light olive gray; variegated; pale yellow orange 10YR 8/2; shale; bioturbated; mottled; subaerial surface; grades up to calcareous silty packstone; bioclasts; clasts from underlying unit; sharp contact "
 3639.2,3645.0,5.8,"3639.2; 3645; 5GY4/1; dark greenish gray; claystone; very soft; blocky; variegated;  brownish gray 5YR4/1; gradational contact "
 3645.0,3646.7,1.7,"3645; 3646.7; softer; N3; dark gray; claystone; gradational contact "
 3646.7,3648.7,2.0,"3646.7; 3648.7; 5GY4/1; dark greenish gray; claystone; blocky; mottled; very dusky red 10R2/2; slight to non-calcareous; moderately firm; gradational contact "
 3648.7,3650.0,1.3,"3648.7; 3650; 5GY6/1; claystone; greenish gray; blocky; variegated; gradational contact "
 3650.0,3651.0,1.0,"3650; 3651; 5GY6/1; claystone; greenish gray; laminated; blocky; moderately firm; variegated; mottled; dark greenish gray 5YR4/1; gradational contact "
 3651.0,3653.7,2.7,"3651; 3653.7; greenish gray 5GY 6/1; shale; very soft; blocky; gradational contact "
 3653.7,3657.7,4.0,"3653.7; 3657.7; N2; grayish black; claystone; soft; fissile; water reactive; variegated; alternates with medium dark gray; N4; mottled; gradational contact   REWORKED MISSISSIPPIAN "
 3657.7,3658.3,0.6,"3657.7; 3658.3; 10YR6/2; light brownish gray; chert conglomerate; siltstone matrix; isolated chert clasts; calcareous sharp contact "
 3658.3,3662.1,3.8,"3658.3; 3662.1; grayish yellow green; 5GY7/2; chert; massive; several-cm- sized brick like rectangular chert with corroded edges in matrix; peloidal crinoidal peloid packstone to grainstone; autoclastic breccia; chert is rimmed with 10YR 6/2; light brownish gray and grades out to N3 dark gray; matrix is mortar-like silt sized quartz and chert grains; 3660-3658.6 grades up from incipient to autoclastic breccia; sharp contact "
 3662.1,3662.2,0.1,"3662.1; 3662.2; grayish yellow green; 5GY7/2; shale; thinly bedded with chert; opaque very pale orange 10YR8/2 chert; module of pelleted silicified wackestone to packstone; bioclasts within chert; sharp contact "
 3662.2,3664.2,2.0,"3662.2; 3664.2; 10YR6/2; pale yellowish brown; siliceous autoclastic breccia; clasts of tripolite; nodules and lenses of porcelain gray-green chert in a matrix of tripolitic chert; oil stained; incipient autoclastic breccia; subvertical fractures common; tripolitic chert is incipient autoclastic breccia; matrix is a more broadly distributed tripolite in which autoclasts have formed; oil staining in tripolites; sharp contact "
 3664.2,3665.0,0.8,"3664.2; 3665; 10YR6/2; pale yellowish brown; chert; multi-cm chert clasts infilled with grayish yellow green 5GY7/2 clay; chert clasts are corroded; transported chert; bed of grayish yellow green 5GY 7/2 shale "
 3665.0,3670.4,5.4,"3665; 3670.4; 10YR6/2; pale yellowish brown; chert; composed of cm-size clasts and fine breccia clasts all silicified together; scattered cavities subhorizontal lenses of grayish yellow green 5GY 7/2 shale; few fractures; clasts of oil stained tripolite giving a brown mottled appearance; shale laminae increase upwards; sharp contact "
 3670.4,3691.0,20.6,"3670.4; 3691; 10YR6/2; pale yellowish brown; chert (tripolite); dolomitic; microporous brecciated chert clasts; gray nonporous porcelain chert clasts; angular infilled with tripolite; massive; fresh chert surrounded by interclast porosity; same chert seen in nodules below; interclast porosity; coarse breccia;  pore space/vugs in chert bands; (cave fill?); very porous and permeable; fractures; tripolite looks dissolved; preserving more porcelain chert; 3668-3667.4 is infilled between chert with grayish yellow green 5GY 7/2 clay; 3667.4-3667 is breccia with cm-size chert clasts partially silicified less connected porosity a brickwork with grayish yellow green 5GY 7/2 shale fill; sharp contact "
 3691.0,3698.4,7.4,"3691; 3698.4; 10YR6/2; pale yellowish brown; dolomite; chert (tripolite); fine microporous alternating cm-size bedding with darker bands with increased gray banded chert; irregular complex bands; pore space/vugs in chert bands; fractures concentrated in the chert bands; lenticular dolomite has associated vuggy porosity; tripolite is uniformly porous and oil stained; discontinuous chert nodules; gradational contact "
 3698.4,3709.0,10.6,"3698.4; 3709; 10YR6/2; pale yellowish brown; dolo siltite; microcrystallized chert tripolite; oil stained; microcrystalline porosity increasing upward;  massive; scattered vugs; pinpoint to sum-cm vugs; no body fossils or skeletal debris; no black chert or chert nodules; gradational contact   REGRESSION "
 3709.0,3722.6,13.6,"3709; 3722.6; 5Y4/1; olive gray; lime mudstone; argillaceous; uniform; wispy shale laminations; indistinct cm-scale bedding; bioturbation; sub-cm mottling; "
 3722.6,3740.2,17.6,"3722.6; 3740.2; 5Y4/1; olive gray; lime mudstone; bioturbated; thinly bedded; laminated; mottled; few cm-thick beds of crinoidal packstone; intervals with scattered crinoids; wispy shale beds; rare chert; isolated bands of black chert of 3732.3 to 3732.4 and 3728.2-3728.7; gradational contact "
 3740.2,3740.5,0.3,"3740.2; 3740.5; 5Y4/1; olive gray; lime packstone; crinoidal; with sharp contacts above and below   ABRUPT SHALLOWING "
 3740.5,3795.3,54.8,"3740.5; 3795.3; 5Y4/1; olive gray; lime wackestone; nodular to laminated; abundant phycosiphon; dense; horizontal to subhorizontal bedding; wispy shale laminations scattered; scattered intervals with crinoids but crinoids are infrequent; argillaceous content is low; chert starts at scattered light gray chert nodules; areas with occasional black chert following bedding, replace matrix; increase of dark shale laminations and chert above 3791; mudstone cm beds lenticular beds of lime mud that are microlaminated and pencil-point burrows, phycosiphon; chert also crosscuts bedding; lighter beds substantially decrease after 3777; sharp contact   ABRUPT DEEPENING "
 3795.3,3798.0,2.7,"3795.3; 3798; 5Y4/1; olive gray; packstone to grainstone; medium grained; crinoidal; broken fossil fragments; scattered mud clasts at bottom; scattered to abundant irregular chert nodules replacing dolomite; articulated brachiopods; crinoidal; sharp contact   DEEPENING "
 3798.0,3805.5,7.5,"3798; 3805.5; 5Y4/1; olive gray; dolopackstone; peloidal; moderately argillaceous; silty; becomes cm-scale rhythmically bedded alternating light and dark; lighter layers are microlaminated ; increasing chert nodules above 3805; irregular nodules from cm to multi-cm in size; irregular cm-relief abrupt contact   ABRUPT FALL "
 3805.5,3815.0,9.5,"3805.5; 3815; 5Y4/1; olive gray; dolo packstone; peloidal; moderately argillaceous; silty; mm laminated; alternating lighter and darker beds; pencil-point horizontal occasional elongated burrows, phycosiphon; dark shale beds alternating with olive gray beds;   DEEPENING "
 3815.0,3844.0,29.0,"3815; 3844; 5Y4/1; olive gray; dolo packstone; peloidal; moderately argillaceous; silty; laminated; abundant dark phycosiphon burrows; wavy bedding; 3848.7-3851 more abundant shale with lenses of cleaner dolomite and chert; scattered to increasingly abundant dolomite nodules cm-size increasing upward; milky translucent chert in filled vugs; cm laminae with phycosiphon scattered through the interval; gradational contact "
 3844.0,3849.0,5.0,"3844; 3849; 5Y4/1; olive gray; packstone; peloidal; abundant coarse quartz nodules cm-size increasing upward; milky translucent chert in filled vugs;  moderately argillaceous; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly gradational contact "
 3849.0,3858.0,9.0,"3849; 3858; 5Y4/1; brown; dolo packstone; fine; peloidal; scattered to increasingly abundant silica nodules cm-size increasing upward; milky translucent chert in filled vugs;  moderately argillaceous; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; gradational contact "
 3858.0,3869.0,11.0,"3858; 3869; 5Y4/1; dark gray; dolo packstone; fined grained; moderately argillaceous; silty; laminated; few phycosiphon; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly abundant silica nodules cm-size increasing upward distorting bedding; occasional phycosiphon; milky translucent chert in filled vugs;  occasional phycosiphon burrows; 3956.5 has increasing lamination with phycosiphon; gradational contact "
 3869.0,3873.0,4.0,"3869; 3873; 5Y4/1; dark gray; dolo packstone; silty; peloidal; laminated; 20% silt; wispy silty laminations; thin wavy bedded; some discontinuities; packstone beds limited to subhorizontal lenses and vertical burrowing 3868.3-3869; finger sized discontinuous vertical burrowing filled with packstone; sharp contact   DEEPENING "
 3873.0,3884.7,11.7,"3873; 3884.7; 10YR7/4; grayish orange; lime packstone; silty peloidal; rods, elongated grains, silica with calcite cement and discontinuous horizontal bedding; scattered gray silty wisps; scattered cm silica replacement nodules; scattered cm-thick beds of medium peloidal (skeletal? Spiculitic?) packstone to grainstone at 3882.5-3882.5, 3880.3-3880.4, 3879.3-3879.4, 3871.4-3871.5 with sharp contacts; gradational contact at top; microporosity soaks up water; fining upward to top; cm-sized irregular subvertical burrows; sharp contact "
 3884.7,3891.0,6.3,"3884.7; 3891; 5Y4/1; dark gray; lime packstone; slightly argillaceous; lighter and more laminated; very fine interparticle porosity; compaction around chert nodules; occasional horizontal pencil-sized burrow; occasional discontinuity surface; chert nodules and chert replacement; occasional dark shale laminae sub-mm-size; finely wispy laminated mm to cm bedded; INTERBEDDED with  5Y 4/1; dark gray; medium grained peloidal (skeletal? spiculitic?) packstone; silty; sharp contact; at 3986.1-3886.2, 3885.8-3885.9, 3885.5-3885.1, 3884.7-3884.4. "
 3891.0,3891.4,0.4,"3891; 3891.4; 5Y5/1; gray; peloidal dolo packstone; medium sized peloids (skeletal?); rounded peloids; poorly sorted; thin laminations of shale; abrupt change to calcite above and dolomite below; darker below; low angle sharp contact (erosional?) "
 3891.4,3905.8,14.4,"3891.4; 3905.8; 5Y4/1; olive gray; dolo siltite; laminated mm-scale; scattered nodular bedding; occasional cm-size nodules of dolomite; pinpoint porosity lining laminae; interparticle porosity; increasing amounts of coarse crystalline; cm-size nodules are anhedral dolomite filled with clear translucent bluish chert; cm-sized nodules replacive chert preserved textures; very sharp contact "
 3905.8,3906.0,0.2,"3905.8; 3906; N4; medium dark gray; dolo packstone; silty; peloidal; medium grained; intercrystalline porosity; few silica sub-cm; cm-bedded; sharp contact "
 3906.0,3907.0,1.0,"3906; 3907; 5Y4/1; olive gray; siltstone; distinct lenticular bedding; scattered coarse dolomite nodules; sharp contact "
 3907.0,3907.8,0.8,"3907; 3907.8; olive gray  5Y4/1; dolo packstone; silty; medium grained peloidal; laminated with bioclastic?; medium peloidal silty packstone; intercrystalline microporous; sharp contact "
 3907.8,3908.3,0.5,"3907.8; 3908.3; laminated silty w/skeletal packstone, silicified elongated rods - spicules; lenses of silica replacement "
 3908.3,3911.6,3.3,"3908.3; 3911.6; lighter; siltstone; dolomitic; heavily bioturbated; porous with sharp upper contact   REGRESSION "
 3911.6,3913.9,2.3,"3911.6; 3913.9; 5Y4/1; olive gray; siltstone; argillaceous; dolomitic; distinct lenticular bedding; alternating olive gray; 5Y4/1 and medium dark gray; wispy shale laminations; few vague dolomitic silt lenses; sharp contact "
 3913.9,3914.2,0.3,"3913.9; 3914.2; N2; grayish black; shale; 30% shale in thin mm-size beds; gradational contact "
 3914.2,3920.6,6.4,"3914.2; 3920.6; olive gray; 5Y4/1;  siltstone; argillaceous; dolomitic; distinct lenticular bedding; alternating olive gray  5Y4/1 and medium dark gray; wispy shale laminations; dolomitic siliceous nodules; gradational contact "
 3920.6,3920.8,0.2,"3920.6; 3920.8; N2; grayish black; shale; 30% shale in thin mm-size beds; gradational contact "
 3920.8,3926.0,5.2,"3920.8; 3926; 5Y4/1; olive gray;  siltstone; argillaceous; dolomitic; distinct lenticular bedding; alternating olive gray  5Y4/1 and medium dark gray; wispy shale laminations; dolomitic silt lenses and pink calcite nodules; 3922  bryozoa and dark black flecks;  gradational contact "
 3926.0,3927.0,1.0,"3926; 3927; N2; grayish black; shale; 30% shale in thin mm-size beds; finely bioturbated; abrupt contact   DEEPENING (MAXIMUM FLOODING SUFACE) "
 3927.0,3932.2,5.2,"3927; 3932.2; olive gray;  5Y4/1;  siltstone; argillaceous; dolomitic; Finely bioturbated (shallowing); 50% silt; wispy shale laminations; indistinct bedding; faint discontinuous laminations; abrupt contact "
 3932.2,3936.7,4.5,"3932.2; 3936.7; lighter; siltstone; argillaceous; dolomitic; phycosiphon lithofacies, shallowing; 50% silt; wispy shale laminations; indistinct bedding; faint discontinuous laminations; gradational contact "
 3936.7,3942.2,5.5,"3936.7; 3942.2; siltstone; darker more uniform argillaceous with burrows; sharp top; 3936.7-3932.2; phycosiphon lithofacies; lighter shallowing; from 3942-3941; gradational contact   DEEPENING "
 3942.2,3946.0,3.8,"3942.2; 3946; siltstone; more frequent black shale laminations; dolomite replacement crystal at 3940; 3942.4 boundary darker beds and lenticular beds above "
 3939.0,3975.6,36.6,"3939; 3975.6; N4; medium dark gray; siltstone; dolomitic; very argillaceous; faintly laminated irregular; 30% silt; 3972-3973 cm-sized irregular calcareous nodules/coarse dolomite with partial silica replacement; 56.2 more lenticular beds upward, faint lenticular bedding alternating olive gray  5Y 4/1 and medium dark gray; increasing quartz silt and dolomite mud as you go up the unit; scattered black shale seams; wispy laminations; indistinctly bedded; bioturbated cm lenses with millimeter smaller burrows ( phycosiphon ?); "
 3975.6,3993.0,17.4,"3975.6; 3993; 5GY3/1; very dark greenish gray; shale; tight; dolomitic; around 20% silt; scattered black shale laminae; uniform; (potential caprock); scattered pyrite; 3981.3 starts increasing silt and cm thick nodular beds;  3982, 3979  shallowing; gradational contact "
 3993.0,4014.0,21.0,"3993;  4014; 5Y2/1; olive black; shale; dolomitic; tight; around 10% silt; uniform; alternating millimeter to cm laminations; 4010.2-4000.3 more silt , claystone; (potential caprock); tight, 4001.00 pico to nanodarcy permeability, gradational contact   DEEPENING "
 4014.0,4027.5,13.5,"4014; 4027.5; 10Y3/1; very dark greenish gray; shale; silty; dolomitic; tight; uniform; 10% silt; rare silica nodules; wavy to horizontal bedded; indistinct bedding; bedding with mm-scale laminations; some alternating light and dark lenticular bedding with more bioturbation in lighter intervals; several crinoids; gradational contact "
 4027.5,4029.0,1.5,"4027.5; 4029;  dolomitic siltstone, much greater bioturbation, occasional siliceous nodules, top with phosphatized lithoclasts with packstone of skeletal debris   TRANSGRESSION "
 4029.0,4041.0,12.0,"4029; 4041; 5Y4/1; olive gray; dark; siltstone; faintly laminated irregular; scattered phycosiphon burrows and nodules, lenses of silty dolomite with partial silicification; lenses have sub-cm vugs; scattered sub-cm scale fractures; gradational contact with fewer light colored nodules "
 4041.0,4047.0,6.0,"4041; 4047; 5Y4/1; olive gray; siltstone; irregular lenses of porous dolomite, intercrystalline silica forming nodules; matrix 5GY 2/1 greenish black silty dolomite; mottled; lenticular dolomite; micritic; silty; vertical discontinuous fractures and vugs in nodules; scattered fine fractures; micro-pinpoint porosity that soaks up water around the silt; poor porosity; gradational contact "
 4047.0,4048.3,1.3,"4047; 4048.3;  5Y4/1;  olive gray; silty dolomitic, few chert nodules, silty shale; overlain by gray lenticular silty shale with skeletal debris and spicules, sharp contact   REGRESSION "
 4048.3,4050.5,2.2,"4048.3; 4050.5; 5Y4/1; olive gray; nodular; siltstone; dolomitic in a mudstone; discontinuous lenses; wispy dark shale laminations; mottled; gradational contact "
 4050.5,4059.6,9.1,"4050.5; 4059.6; 5Y4/1;  olive gray; shale; silty; lenticular silt beds; increasing amount of black wispy shale 4052.5 to 4050.5; gradational contact "
 4059.6,4059.7,0.1,"4059.6; 4059.7; 5Y2/1; olive black; shale; sharp contact "
 4059.7,4059.8,0.1,"4059.7; 4059.8; 5Y6/1; light olive gray; siltstone; sharp contact "
 4059.8,4065.0,5.2,"4059.8; 4065; 5Y4/1; dark olive gray; shale; with quartz silt; dolomitic; slightly water reactive; indistinct subhorizontal bedding; occasional crinoid; sharp contact "
 4065.0,4065.4,0.4,"4065; 4065.4; lithoclasts, phosphates, irregular contact below lithoclasts, cm relief "
 4065.3,4065.9,0.6,"4065.3; 4065.9; N2; grayish black; shale; uniform; massive; at 4065.5 becomes sandy shale with sand size black flecks (erosion surface?); sharp contact   Transgression   SUBAERIAL EXPOSURE (BASE KASKASKIA CRATONIC SEQUENCE) "
 4065.9,4099.6,33.7,"4065.9; 4099.6; 5Y8/1; yellowish gray; sandstone; fine-grained quartz; calcareous; porosity is good 4098 to 4099.6; bioturbated; some shale laminations but dominantly sand; coarser towards the top; common chert (quartzite) beds above 4084 with carbonate cement; patches of porosity; mottled; hydrocarbon odor; patchy hydrocarbon staining; 4069 to 4065.9 clean 10YR 8/2 very pale orange sand with faint low-angle crossbedding; sharp contact "
 4099.6,4100.3,0.7,"4099.6; 4100.3; N5; medium gray; shale; claystone; massive; sharp contact "
 4100.3,4106.3,6.0,"4100.3; 4106.3; 5Y8/1; yellowish gray; sandstone; lithoclasts; 4104 to 4102.3 is 60% cm-size lithoclasts of sand in matrix of dark clasts and sand; black matrix of sand and dark clasts; sharp contact "
 4106.3,4109.3,3.0,"4106.3; 4109.3; N5; medium gray; shale; claystone; massive; sharp contact "
 4109.3,4112.7,3.4,"4109.3; 4112.7; 5Y8/1; yellowish gray; basal lag of cm-size sand with dark lithoclasts; thin beds of mottled shale;  interclastic interval; bioturbated; sandy shale; sharp contact "
 4112.7,4117.7,5.0,"4112.7; 4117.7; N5; medium gray; shale; waxy; claystone; sharp contact "
 4117.7,4123.5,5.8,"4117.7; 4123.5; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; pencil size vertical and horizontal burrows; cm-size circular burrows; sharp contact "
 4123.5,4128.8,5.3,"4123.5; 4128.8; N4; medium dark gray; massive; sand; oil stained; not vuggy; interparticle porosity; calcareous; hard; dissolution of cement; subhorizontal bedding with faint bioturbation; sharp contact "
 4128.8,4131.3,2.5,"4128.8; 4131.3; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges 60% sand; burrows; some vertical pencil sized burrows; sharp contact "
 4131.3,4135.7,4.4,"4131.3; 4135.7; N5; medium gray; shale; intervals of silt; faint evidence of bioturbated; some sandier beds; sharp contact "
 4135.7,4136.1,0.4,"4135.7; 4136.1; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges from 50%/50% up to 60% sand; sharp contact "
 4136.1,4136.5,0.4,"4136.1; 4136.5; N4; medium dark gray; shale; flakes; claystone; sharp contact "
 4136.5,4142.4,5.9,"4136.5; 4142.4; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges from 50%/50% up to 60% sand; sharp contact "
 4142.4,4143.5,1.1,"4142.4; 4143.5; 10BG3/1; very dark greenish gray; shale; waxy; claystone; transitional contact "
 4143.5,4144.1,0.6,"4143.5; 4144.1; 5Y8/1; yellowish gray; interbedded shale and sandstone; laminated sand and shale; heterolithic; mm-thick shale laminae; 50% sand and 50% shales; cm beds with mm laminations; sharp contact "
 4144.1,4144.4,0.3,"4144.1; 4144.4; 5B 5/1; medium bluish gray; shale; claystone; sharp boundary "
 4144.4,4151.8,7.4,"4144.4; 4151.8; 5Y8/1; yellowish gray; sandstone; fine to medium grained quartz sand; cm-bedded wavy bedded; thinly laminated; mm shale laminae; numerous reactivation surfaces; common ripple cross stratification; above 46 becomes increasingly shaly with alternating thin mm-thick shale and sand; some vertical pencil sized burrows; sharp contact "
 4151.8,4153.3,1.5,"4151.8; 4153.3; 5Y8/1; yellowish gray; sandstone; medium grained; 60% sand; heterolithic; well sorted; heavily bioturbated; cm rounded burrows; pencil type burrows; thin shale 5B5/1; medium bluish gray at 4152-4151.8; sharp contact "
 4153.3,4154.0,0.7,"4153.3; 4154; 5B5/1; medium bluish gray; shale; claystone;  sharp boundary "
 4154.0,4154.3,0.3,"4154; 4154.3; 5Y8/1; yellowish gray ; sandstone lag; filled with basal sandy 0 .2 sand with brown lithoclasts ( darkened to phosphate ?); sharp contact "
 4154.3,4157.0,2.7,"4154.3; 4157; 5Y8/1; yellowish gray; sandstone; medium grained; well sorted; ranging from bioturbated at base to 4155.7, 20% shale (5B5/1; medium bluish gray); 4155.7 to 4154 is mainly sandstone; irregular mulitple cm-relief; sharp boundary "
 4157.0,4158.1,1.1,"4157; 4158.1; 5B5/1; medium bluish gray; shale; 20% sand; heterolithic; bioturbated; sharp boundary "
 4158.1,4161.8,3.7,"4158.1; 4161.8; 5B5/1; medium bluish gray; claystone;  intermixed with multi-cm thick sands; horizontal bedded; sand is mm-bedded; 4158.1 to 4159 is 40% sand and 60% shale (5B5/1; medium bluish gray) heavily heterolithic bioturbated; distinct beds of sand up to 4157.1; 4158.1 has a sharp surface overlain by a couple inches of sand with darkened lithoclasts; sharp contact "
 4161.8,4165.8,4.0,"4161.8; 4165.8; 5Y8/1; yellowish gray; sandstone; fine grain quartz; rounded; frosted grains; 30% silt to shale; interbedded with 5GY5/2; dusky yellow green; heterolithic; heavily bioturbated; burrows are cm size; irregular mm size traces; occasional cm-size beds of sand subhorizontal; horizontal laminations; microlaminations in the thin preserved beds of sand; abrupt contact "
 4165.8,4179.3,13.5,"4165.8; 4179.3; 5YR4/1; brownish gray; dolo mudstone; mottled dark clasts in lighter dolo grainstone and peloidal matrix; 4177.7 medium bluish gray 5B 5/1 claystone layer; lenses of sheet cracks filled with quart silt; 4174.6 to 4173.4 olive colored mixed with clasts and grades into a brown dolomudstone with floating darkened micritic clasts and darker brown angular clasts (cave fill, collapsed breccia); quartz sand; frosted quartz grains; brown dolomudstone goes to the top of the Arbuckle at 4165.8; unit with clasts from incipient autoclastic brecciation at 4169 to 4173; sharp irregular contact "
 4179.3,4209.0,29.7,"4179.3; 4209; 5YR4/1; brownish gray; peloidal dolo grainstone and dolo packstone; medium to coarse; some bioturbation; poorly bedded in lower portion of unit; pinpoint vugs; locally tight when more argillaceous 4199; 4195 has a autoclastic incipient brecciation; around 4193 cm to several cm sets of fining upward dolopackstone to dolograinstone; 4193 argillaceous 1/4 thick bed;  4194 occasional cm vugs and around clasts; thinly bedded medium peloidal dolograinstone and dolopackstone; with medium bluish gray 5B 5/1 claystone @4179.3; another shale seam at 4190.2; incipient autoclastic breccia at 4190.5; N8; very light gray uniform dolomudstone at 4190; dolomicrite at 4189; 4187 oolitic dolograinstone with oomoldic porosity and vuggy irregular fine pinpoint vugs; another mud layers 4185.7 to 4185.8 with incipient autoclastic brecciation in the lower part of the oolite 4185 to 4187; another shale at 4187; another shale seam at 4183.2; fine peloidal wackestone from 4183.2 to 4180.8; 4180.8 to 4179.3 medium to coarse grained peloidal grainstone and packstone with highly disturbed bedding with large clasts and high angle contacts with lots of debris with scattered pinpoing to cm-scale and larger vugs; sharp angular contact; upper contact of shale is irregular and has broken clasts "
 4209.0,4223.0,14.0,"4209; 4223; 5YR4/1; brownish gray; peloidal dolo grainstone and dolo packstone; medium; varying beds; argillaceous; interparticle porosity; moderate porosity; pinpoint vugs; sharp contact over basal lithoclastic lag with darkened grains with some silicification; tight argillaceous zone around 4213.2 "
 4223.0,4224.0,1.0,"4223; 4224; N8; very light gray; dolo wackestone; very fine; argillaceous bundle of silty beds and medium bluish gray 5B 5/1 claystone at 4223.3; sharp contact   Transgressive   Subaerial exposure "
 4224.0,4238.3,14.3,"4224; 4238.3; 5YR4/1; brownish gray; peloidal dolo grainstone and dolopackstone; medium varying beds; more argillaceous; tight; pinpoint vugs; interparticle porosity; enhanced interparticle cm-size subparallel to bedding; some sub-cm size vugs scattered throghout;4232.5 to 4233 has couplets with vugs developed along boundaries with vugs filled with white chalky substance cementing around peloids (maybe anhydrite?); (tidal); 4224-4226 is partially silicified and incipient autoclastic brecciation of the grainstone packstone; sharp contact "
 4238.3,4239.4,1.1,"4238.3; 4239.4; 5YR4/1; brownish gray; sharp contact peloidal dolo grainstone; medium; alternating; poorly sorted wackestone; gradational contact "
 4239.4,4244.5,5.1,"4239.4; 4244.5; 5Y6/1; light olive gray ; peloidal dolo grainstone; medium alternating with muddier intervals at cm-scale (bundles);  horizontal beds; intervals with fist size vugs lined with dolomite; solution vugs along bedding planes; discontinuities between beds; finer grained intervals with mud are tight; sharp contact with bluish green shale interbedded with tight argillaceous peloidal mudstone "
 4244.5,4245.5,1.0,"4244.5; 4245.5; 5Y6/1; light olive gray; dolo mudstone; argillaceous; bands of medium grained pellet packstone; sharp contact "
 4245.5,4248.2,2.7,"4245.5; 4248.2; 5YR4/1; brownish gray; medium-grained peloidal dolo grainstone to packstone; disrupted autoclastic brecciation; clasts are subhorizontal cm-thick bundles; loose grains supporting interstiticies; porous; interparticle porosity and pinpoint vugs mm to cm-size; small discontinuous solution enhanced vertical fractures; good porosity; sharp contact "
 4248.2,4250.0,1.8,"4248.2; 4250; 5YR4/1; brownish gray; peloidal dolo packstone; medium-size;  poorly sorted; argillaceous; with medium bluish gray 5B 5/1 claystone with slickensides; autoclastic brecciation at top 5 with some solution enhancement around clasts with silty matrix; sharp contact "
 4250.0,4258.6,8.6,"4250; 4258.6; 5YR4/1; brownish gray; peloidal dolo packstone; medium to coarse; argillaceous; cm-size beds; variable grain sizes; small scale pinpoint vugs; scattered vugs; occasional (@4252.8) larger cavities cm-size with baroque dolomite lining cavities; scattered partial fractures; oblique 4253 fracture; upper few inches has silification and coarser grained going through autoclastic incipient brecciation has solution enhancement; sharp contact "
 4258.6,4262.2,3.6,"4258.6; 4262.2; 5Y6/1; light olive gray; peloidal dolo mudstone; argillaceous; silt-size peloids; 4259.2 to 4259.5 medium bluish gray 5B 5/1 claystone with slickensides; sharp contact "
 4262.2,4269.2,7.0,"4262.2; 4269.2; 5Y6/1; light olive gray; peloidal dolo grainstone to dolo packstone; medium to coarse; occasional vug; low angle cross stratification; autoclastic brecciation; mottled 5B5/1 medium bluish gray chert silicification of oomoldic peloidal dolograinstone some areas are more dolomitic; blotchy silicification;  enhanced solutino around clasts; small discontinuous solution enhanced vertical fractures; 4269.5 there is a sharp boundary with nearly vertical relief highly irregular contact with decreasing ooids upward; sharp contact (photo) "
 4269.3,4270.5,1.2,"4269.3; 4270.5; 5Y6/1; light olive gray; dolo mudstone; silt-size peloidal, packstone,   Transgressive   Subaerial exposure "
 4270.5,4275.9,5.4,"4270.5; 4275.9; 5Y6/1; light olive gray; peloidal dolo packstone to grainstone; fine to medium grained; disrupted bedding; autoclastic incipient brecciation; dense; scattered cm-size irregular vugs; discontinuous vertical fractures mostly confined to bedding but some cross cutting; solution enhancement along fractures; coarse dolomite lining fractures and vugs; sharp boundary "
 4275.9,4277.8,1.9,"4275.9; 4277.8; 5Y6/1; light olive gray; peloidal dolo packstone; medium-grained; crossbedded coarse packstone with large cm-size lithoclasts; vugs; angular bedding; moderately porous; 6-thick bed of N7 light gray uniform color dolomudstone/dolomicrite  4275.6 to 4275.9 "
 4277.8,4281.0,3.2,"4277.8; 4281; 5YR4/1; brownish gray; pelleted dolo packstone to grainstone; medium-grained pinpoint molds and enhanced intercrystalline porosity; vuggy; mm to cm-size vugs; fair porosity; uniform; sharp contact "
 4281.0,4294.0,13.0,"4281; 4294; NO RECOVERY (DST 4 conducted 4280-4390 interval) "
 4281.0,4294.0,13.0,"4281.0; 4294.0; Dolo, lt brown, fxln, oolitic, vuggy and oomoldic poro, ns "
 4294.0,4295.7,1.7,"4294; 4295.7; 5YR4/1; brownish gray; pelleted dolo packstone to grainstone; pinpoint molds and enhanced intercrystalline porosity; fair porosity; sharp contact "
 4295.7,4308.2,12.5,"4295.7; 4308.2; 5YR4/1; brownish gray; medium to coarse grain dolo peloidal packstone and grainstone; intervals of oomoldic porosity; fair porosity; bioturbated; mottled texture; 4307-438.2 has vuggy porosity from solution vugs with sub-cm size that may be conductive; fining upward to the top; occasional reactivation surface; sharp contact "
 4308.2,4312.0,3.8,"4308.2; 4312; 5YR 4/1; brownish gray; dolo mudstone; argillaceous; silty; mottled; bioturbated; some laminations; wispy shale; gradational with dolomite; good aquitard-ish; no porosity; sharp contact "
 4312.0,4315.3,3.3,"4312; 4315.3; 5YR4/1; brownish gray; dolo packstone and dolomitic mudstone; fine to medium grained; scattered argillaceous seams; bioturbation cm-size circular burrows; moldic grains or oomolds ?; porosity is poor; sharp contact "
 4315.3,4330.3,15.0,"4315.3; 4330.3; 5YR4/1; brownish gray; fine to coarse poorly sorted dolo peloidal packstone; scattered argillaceous seams; some muddier intervals with higher dispersed clay; poor porosity; few scattered molds; some wavy bedding to wispy laminated beds of shale cm-thick; occasional discontinuity; more argillaceous as you go up; fining upward succession; sharp contact "
 4330.3,4334.0,3.7,"4330.3; 4334; 5Y6/1; light olive gray; dolo packstone to grainstone; medium grained; reactivation surfaces abundant; low-angle bedding to indistinct bedding; cm-beds alternating with muddier to more grainstone facies including crinoids; upper portion has oolite molds; interparticle permeability; fair porosity; sharp contact "
 4334.0,4362.2,28.2,"4334; 4362.2; 5Y6/1; light olive gray; dolo packstone; mm-size laminations; shale wisps; small bioturbation with rounded horizontal burrow traces; bioturbation scattered between 4351.6-4355.6 basically no porosity; could be aquitard; no fractures seen; increasingly argillaceous from 4348 to 4334 5Y 5YR 4/1; brownish gray; discontinuity surfaces with shaly dolomite cm's-thick; sharp irregular contact "
 4362.2,4365.5,3.3,"4362.2; 4365.5; 5Y6/1; light olive gray; argillaceous laminated; tight; soft sediment deformation at 4364.5 of dolomite into more argillaceous material 4365-4363.7 is more argillaceous gray and brown; sub-cm laminations of dolomite and clay drapes; argillaceous silt sized dolomite up to upper contact; 4363.7-4362.2 is a fine to medium dolopackstone to grainstone with muddy birdseye with pinpoint interparticle porosity and small mm-size vugs; sharp contact   transgressive "
 4365.5,4367.2,1.7,"4365.5; 4367.2; 5Y6/1; light olive gray; dolo packstone; coarse; crinoid? coated grain; wavy bedded with mud chip conglomerate at base from reworking of bottom lithology; occasional darkened lithoclast within the grainstone; pinpoint interparticle porosity abundant; coated grains; small vug sub-cm to cm-scale; no fractures; good porosity; sharp boundary "
 4367.2,4374.8,7.6,"4367.2; 4374.8; 5Y6/1; light olive gray; faintly mm-laminated silt quartz 80% dolo mudstone 10% thin mm-scale shale drapes; grades up to more argillaceous 4370.5, scattered reactivation surfaces 4371.4 above 70.5 grades to a buff fine silty dolomite; sharp contact "
 4374.8,4376.8,2.0,"4374.8; 4376.8; 5Y6/1; light olive gray; faintly cm-laminated fine-grained dolomitic packstone; clay laminae; irregular laminations with shale concentrations as birdseye;  tight; clay filled vugs but may still have porosity; sharp contact "
 4376.8,4377.8,1.0,"4376.8; 4377.8; 5YR4/1; brownish gray; muddy pelleted dolo packstone; common broken fossil debris?; shale seam at cm-thick at top; sharp contact "
 4377.8,4380.0,2.2,"4377.8; 4380; 5YR 4/1; brownish gray; medium pelleted dolo packstone; coarse grainstone ; vugs; indistinct bedding; very porous; matrix porosity; scattered bioclasts; crinoids; sharp contact "
 4380.0,4381.5,1.5,"4380; 4381.5; 5Y6/1; light olive gray dolo packstone; fine grained; argillaceous; finely laminated; dense; 4380 flat truncation surface; sharp contact "
 4381.5,4392.3,10.8,"4381.5; 4392.3; 5Y6/1; light olive gray; medium grained sandy dolo packstone; tight; low-angle cross stratification; lenticular wavy bedding; medium laminations of packstone and grainstone with shale clay drapes; clay varies from clay rick gradational to clay top; occasional discontinuities 4383 with skeletal lag with crinoid and bivalve; skeletal lag  reactivation surface at 4388.9 and 86.8 in darker shale;  4388.1 stromatolitic 1 wide on a reactivation surface and below has 6 of autoclastic breccia with sharp angular clasts infilled with coarse dolomite cement (the cement has vugs); sharp contact "
 4392.3,4393.9,1.6,"4392.3; 4393.9; 5Y6/1; light olive gray; dolo mudstone; argillaceous; distinct even sub-cm laminations slightly irregular; occasional vertical and horizontal burrows;  reactivation at 4393 about 3 inches vertical relief and has a very scoured boundary; no vugs; tight; clasts of angular lithoclasts or grainstone and packstone; edges of lithoclasts are darkened borings; sharp boundary "
 4393.9,4394.1,0.2,"4393.9; 4394.1; N2; grayish black; claystone; sharp boundary   Transgressive   Subaerial exposure "
 4394.1,4395.7,1.6,"4394.1; 4395.7; 5B5/1; medium bluish gray; reworked autoclastic breccia; argillaceous mix with grain and packstone; clasts have rims of alteration or discoloration; infill greenish gray silty micritic dolomite contains crinoids, bryozoa; flooding surface and part of transgression followed by deepening; sharp contact "
 4395.7,4431.6,35.9,"4395.7; 4431.6; 5YR4/1; brownish gray; peloidal dolo packstone; cross stratified laminations highlighted by thin clay layers (macrotidal); steeply dipping bedding ~45 degrees at 4431 to 4428.7; grades rapidly up to a medium grained peloidal dolopackstone; increased shale as you go up; mud drape and cm lenses of grainstone; 4404 to 4395.7 is even coarser with reactivation surfaces and mud drapes; lithoclasts present and are darkened at 4396 and 4396 and 4398; sharp boundary "
 4431.6,4432.0,0.4,"4431.6; 4432; N4 medium dark gray; shale; dolo mudstone lenses; sharp contact "
 4432.0,4442.5,10.5,"4432; 4442.5; 5YR4/1; brownish gray; dolo mudstone; interbedded argillaceous; no substantial porosity; becomes cleaner upward; tight; sharp boundary   Transgressive   Subaerial exposure "
 4442.5,4460.5,18.0,"4442.5; 4460.5; 5Y6/1; light olive gray; peloidal medium sized dolo packstone; no bedding; some pinpoint vugs but no apparent fractures; grades up to a cross-bedded grainstone with reactivation surfaces; argillaceous seams and laminations; pinpoint porosity in molds and interparticle porosity; moderate to fair porosity; around 4445.2 has larger vugs and large vertical fracture and incipient brecciation; sharp boundary "
 4460.5,4463.2,2.7,"4460.5; 4463.2; 5Y6/1; light olive gray; peloidal sandy dolo packstone; argillaceous; no bedding; some occasional bedding and lenses in patches; surface with clasts at 4461 with sharp irregular boundary with dark rounded clasts "
 4463.2,4470.3,7.1,"4463.2; 4470.3; 5YR4/1; brownish gray; dolo mudstone; argillaceous; dense; no bedding; gray black chert associated; scattered vugs; 5N grayish black mud at 4466; sharp contact "
 4470.3,4473.3,3.0,"4470.3; 4473.3; 5YR4/1; brownish gray; incipient autoclastic dolomitic breccia; peloidal  dolo packstone to dolo mudstone; scattered larger vugs and small discontinuous fractures; less matrix porosity; moderate porosity; sharp boundary "
 4473.3,4479.4,6.1,"4473.3; 4479.4; 5YR4/1; brownish gray; silty to medium crystalline dolomite or dolomitized grains that look crystalline; good matrix porosity; moderate pinpoint vugs; good porosity (flow unit!); small discontinuous fractures ~1 dissolution enhanced; alternating laminated bedding up to nondescript bedding; uniform composition; dolomite; disrupted bedding; incipient brecciation; occasional pinpoint vugs; molds; interpartical vugs; small discontinuous fractures scattered abundant small and dissolution enhanced; sharp contact "
 4479.4,4480.0,0.6,"4479.4; 4480; 5N grayish black shale; laminated lenses; small white flecks; sharp contact "
 4480.0,4488.0,8.0,"4480; 4488; 5Y6/1; light olive gray; dolo mudstone; argillaceous; dense; few vugs; two directions of fracture with cement; sharp contact   Transgressive   Subaerial exposure "
 4488.0,4493.2,5.2,"4488; 4493.2; 5YR 4/1; brownish gray; disrupted bedding and autoclastic breccia; dolo mudstone; black 5N grayish black chert; small scattered pinpoing vugs; long open fractures with dolospar lining;  greatly diminishing porosity and vugs; sharp contact "
 4493.2,4507.0,13.8,"4493.2; 4507; 5YR4/1; brownish gray; dolo mudstone; matrix porosity; abundant pinpoint vugs; occasional fissures and partial small discontinuous vertical fractures dissolution enhanced, vuggy from 4504 to 4502; large natural fracture at 4500 to 4497, poor to moderate porosity; sharp boundary "
 4507.0,4509.0,2.0,"4507; 4509; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; mottled; disrupted bedding; irregular surfaces; scattered vugs; poor porosity; sharp boundary "
 4509.0,4514.0,5.0,"4509; 4514; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; laminated; no vugs or apparent fractures; some faint argillaceous bands anastomozing; beautiful mud; solution voids rounded dark gray chert cm-size at 4510 to 4511, and at 4511.5 reactivation surface with disruption feature overlain with rounded clast of dolomite mud and darker argillaceous dolomite; sharp boundary with desiccation feature? "
 4514.0,4521.0,7.0,"4514; 4521; N2 2; grayish black; dolo mudstone; argillaceous; tidal bundles; tight; varved continuous to lenticular with some disrupted and offset clay laminae (stromatolitic); no vugs or apparent fractures; wavy stromatolite;  discontinuity surface covered by 5708 with gray black shale bed cm-thick grades into a silty dolomite and wavy to laminated bedding and intervals of bioturbation up to laminated; more bioturbated as you go up the section; 4514-4515 is an incipient brecciations with indistinct clasts;  sharp boundary "
 4521.0,4522.0,1.0,"4521; 4522; 5B5/1; medium bluish gray; dolo mudstone; autoclastic breccia with vugs; very irregular cm-size angular to rounded and mixed clasts of dolomite from light brown to gray; moderate porosity; sharp contact "
 4521.0,4528.0,7.0,"4521; 4528; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; wavy and wispy clay laminae; occasional vugs; no apparent fractures; "
 4528.0,4529.0,1.0,"4528; 4529; 5B5/1; medium bluish gray; massive chert; fractures; few scattered vugs; low porosity; grades to dolomite clasts mixed with chert and porosity along boundaries between clasts; gradational contact "
 4529.0,4530.0,1.0,"4529; 4530; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; wavy and wispy clay laminae; no vugs; few tight vertical fractures; sharp contact "
 4530.0,4530.2,0.2,"4530; 4530.2;  N2 2; grayish black shale; claystone; no vugs or fractures; a several-centimeter-size coated grain and oolitic clast embedded in shale; sharp contact   Transgressive "
 4530.2,4532.0,1.8,"4530.2; 4532; 5Y6/1; light olive gray; peloidal dolo packstone; silt to very fine; cm-thick planar cross stratification at 30 degree; tight cemented; no porosity; no vugs; no fractures; sharp contact parallel to cross-stratification "
 4532.0,4542.0,10.0,"4532; 4542; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; wavy and wispy clay laminae; nodular scattered lenticular chert cm-sized at 4541; truncation surface at 4540; sharp contact "
 4542.0,4564.0,22.0,"4542; 4564; 5YR4/1; brownish gray; dolo mudstone; dense; slightly argillaceous; tight matrix with discontinuous vertical fractures; several splayed fractures up to 6 inches; scattered 1-cm vugs; no clasts; 4543.2 to 4542 is autoclastic breccia with vugs; very sharp boundary "
 4564.0,4565.0,1.0,"4564; 4565; 5YR4/1; brownish gray; dolo mudstone; brecciated; discontinuous vertical fracture; scattered vugs; solution enhancement along brecciated boundaries; fair to poor porosity; sharp contact "
 4565.0,4566.2,1.2,"4565; 4566.2; 5YR4/1; brownish gray; dense; dolo mudstone; argillaceous; tight; no vugs; no clasts; sharp boundary "
 4566.2,4575.8,9.6,"4566.2; 4575.8; 10YR6/2; pale yellowish brown; dolo mudstone;  large cm's-big vugs/cavities lined; autoclastic breccia; tight to moderate porosity; gets more clay towards the bottom; interbedded with argillaceous dolomite and clean light brown breccia; clast have halos of color change; discontinuous fractures and dissolution enhanced vugs around clasts; moderate porosity; sharp contact "
 4575.8,4579.0,3.2,"4575.8; 4579; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; very few occasional vugs; massive; mottling along wavy disruptive bedding; solution cavity filled with dark gray argillaceous dolomite and clasts of micritic host rock; sharp contact "
 4579.0,4585.0,6.0,"4579; 4585; 5Y6/1; light olive gray; dolo mudstone; argillaceous; tight; very few occasional vugs; massive; mottling along wavy disruptive bedding; abundant small incipient brecciation and disrupted bedding with <1cm clasts  at 4579, tidal flat; sharp contact   transgressive   Subaerial Exposure "
 4585.0,4588.2,3.2,"4585; 4588.2; 10YR6/2; pale yellowish brown; dolo mudstone;  silty; large cm-sized vugs/cavities lined with megaquartz and lipid dolomite crystals around 4588; tight to moderate porosity; top boundary has incipient brecciation; sharp boundary "
 4588.2,4595.2,7.0,"4588.2; 4595.2; 5B5/1; light bluish gray; dolo mudstone; dispersed argillaceous; incipient brecciation of tightly fitted clasts; occasional shale wisps; scattered vugs cm-sized; large cavity at 4593.75 with subvertical exposed clasts dolomite; vertical unconnected fractures with solution enhancement; tight; sharp boundary "
 4595.2,4597.55,2.35,"4595.2; 4597.55; 5Y6/1; light olive gray; brecciated dolo mudstone; discontinuous vertical fractures and vugs; solution enhancement along brecciated boundaries; fair porosity; sharp contact on spin out "
 4597.55,4601.5,3.95,"4597.55; 4601.5; 5Y6/1; light olive gray; dolo mudstone; argillaceous laminae; very few vugs;  areas of silicified chert above 4695 in breccia fabric; mottled with darker gray to brown along bedding; tight; sharp contact "
 4601.5,4610.8,9.3,"4601.5; 4610.8; 5Y6/1; light olive gray; dolo mudstone; moderate brecciation; scattered vugs; discontinuous vertical fractures solution enhanced; some brecciation in intervals with cm-size clasts with according variation in clasts and vugs; 4602.5-4601.6 has significant brecciation; partially silicified solution vugs and partial fractures; sharp contact "
 4610.8,4611.0,0.2,"4610.8; 4611; 5Y6/1; light olive gray; laminated dark; dolo mudstone; argillaceous; tight; no vugs; no clasts; partial fractures truncate at bottom; no flow; sharp contact   Transgressive   Subaerial exposure "
 4611.0,4616.5,5.5,"4611; 4616.5; 5Y6/1; light olive gray; finely crystalline micritic dolomite; uniform; occasional wisps of shale; brecciated 4613.3 to 4612 with discontinuous vugs and clast boundaries solution enlarged; sharp contact "
 4616.5,4619.0,2.5,"4616.5; 4619; 5Y6/1; light olive gray; dolomite packstone; peloidal; laminated; wavy mm laminated bedding; some large cm-size vugs and partial discontinuous fractures significantly solution enlarged; sharp contact with autoclastic brecciation from 4616.5 to 4617 "
 4619.0,4623.5,4.5,"4619; 4623.5; 5Y6/1; light olive gray; dolo mudstone; few dark gray silica nodules; chert nodule with gastropod; scattered vugs; long vertical fractures with dolomite partial filling; sharp contact "
 4623.5,4626.0,2.5,"4623.5; 4626; 5Y6/1; light olive gray; dolo mudstone; varying alternating light and dark mottling; moderately porous; subvertical fractures;  intervals of brecciation with large vugs and silicified clasts; sharp contact "
 4626.0,4628.0,2.0,"4626; 4628; 5GY4/1; dark greenish gray; dolo mudstone, argillaceous; tight; occasional vug and stylolite; no solution enhancement; sharp contact "
 4628.0,4643.0,15.0,"4628; 4643; 5Y6/1; light olive gray; dolo mudstone; varying alternating light and dark mottling; moderately porous; intervals of brecciation with large vugs and silicified clasts (4643-4641, 4638.7-4631.5); partial irregular vertical fractures scattered solution enhanced;  sharp contact "
 4643.0,4644.0,1.0,"4643; 4644; 5Y6/1; light olive gray; dense light brown greenish brown; dolo mudstone; faint laminations with shale; sharp contact   Subaerial exposure "
 4644.0,4656.0,12.0,"4644; 4656; 5Y6/1; light olive gray; dolo mudstone; varying alternating light and dark mottling; large discontinuous vugs from 4652-4653 in a brecciated zone; subhorizontal vugs along bedding from 4646-4649 cm's apart; 4645-4646 brecciated zone with discontinuous vugs; sharp contact "
 4656.0,4680.0,24.0,"4656; 4680; NO RECOVERY "
 4656.0,4660.0,4.0,"4656.0; 4660.0; Dolo, tan, f-med xln, hrd, vuggy poro, fractured, fresh euthedral dolo cryst in frac planes and vuggs, stylolites & thin lays of gy sh "
 4660.0,4668.0,8.0,"4660.0; 4668.0; Dolo, tan, f-med xln, AA, some fresh wht chert "
 4668.0,4680.0,12.0,"4668.0; 4680.0; Dolo, wht-tan, f-med xln, hrd, dns, oolitic, ( packstone ), no visi poro, pcs of fresh, wht & drk chert "
 4680.0,4685.5,5.5,"4680; 4685.5; 5Y6/1; light olive gray; dolo mudstone; common bedding plane solution enhanced vugs; subhorizontal laminations; 4680 to 4682.5 brecciated with cm-size vugs and discontinuous vertical fractures in brecciated zone; good to moderate porosity; sharp contact "
 4685.5,4687.95,2.45,"4685.5; 4687.95; 5Y6/1; light olive gray; dolo mudstone; brecciated; clasts extensively silicified with porcelain mottled gray to dark gray chert; common solution enhanced vugs; moderate porosity; broken core due to drilling; sharp contact "
 4687.95,4726.5,38.55,"4687.95; 4726.5; NO RECOVERY "
 4687.95,4714.0,26.05,"4687.95; 4714.0; Dolo, wht-tan, f-med xln, hrd, dns, oolitic, ( packstone ), no visi poro, abnd fresh, wht & drk chert, sm opaq oolt, sm tranl, sharp vit "
 4714.0,4726.5,12.5,"4714.0; 4726.5; Dolo, wht-tan, sucro-med xln, unif, int xln poro, scrtd vuggy poro, ns "
 4726.5,4728.0,1.5,"4726.5; 4728; 5GY4/1; dolo mudstone; dark greenish gray; finely crystalline; argilliceous; tight; sharp contact   transgressive   Subaerial exposure "
 4728.0,4732.5,4.5,"4728; 4732.5; 5Y6/1; light olive gray; dolomudstone; breccia; low porosity, with solution enhanced boundaries around the clasts; early solution enhanced pipes with small clasts of carbonate infilling; at the top breccia clasts fill by cement with cm-scale vugs filled with druzy quartz with local solution enhancement of the quart, locally high porosity; overall low porosity; sharp contact "
 4732.5,4734.0,1.5,"4732.5; 4734; 5G2/1; greenish black to dark greenish gray 5GY4/1; dolo mudstone; dense; thin mm-scale laminated bedding; bedding slightly disrupted at the top; sharp contact "
 4734.0,4739.0,5.0,"4734; 4739; 5Y6/1; light olive gray; finely crystalline; dolomudstone; grading upwards to slightly darker micritic dolomite with disruption of bedding from 4735-4735.5; partial discontinuous subvertical fractures; poor porosity; sharp contact   transgressive   Sequence boundary? "
 4739.0,4742.0,3.0,"4739; 4742; 10YR4/2; dark yellowish brown; dolomitic breccia with cm-sized dolomite clasts; extremely vuggy; large vugs; looks like concrete aggregate; associated solution enhanced features with cm-size vugs with baroque dolomite crystals; discontinuous solution enhanced fractures sub-vertical; extremely porous and permeable; (Flow unit!); sharp contact "
 4742.0,4743.7,1.7,"4742; 4743.7; 10YR4/2; dark yellowish brown; dolomicrite; finely crystalline; 10YR 4/2 very pale orange;  micritic dolomite clasts; sharp; inter-formational conglomerate; disruptive bedding; 4743 to 4742.3 is a dark gray dolomitic shale bed; sharp contact "
 4743.7,4745.7,2.0,"4743.7; 4745.7; 5Y6/1; light olive gray; dolomite; shaly,faintly horizontally laminated; tight; partial healed fractures; no vugs; sharp contact "
 4745.7,4746.5,0.8,"4745.7; 4746.5; 10YR4/2; dark yellowish brown; dolomitic oolitic band from 4746.5 to 4746.3; sharp contact with dark yellowish brown; lithoclastic with oolitic grainstone; sharp contact   Transgressive "
 4746.5,4747.5,1.0,"4746.5; 4747.5; 10BG5/1; greenish gray; shale; dolomitic; laminated mm to cm; wavy bedded; very tight; partial discontinuous vertical fractures; flooding surface; sharp irregular contact "
 4747.5,4749.3,1.8,"4747.5; 4749.3; 10YR4/2; dark yellowish brown; micritic dolomite; clasts of chert; angular fragments; discontinuous angular fractures; tight; scattered pinpoint vugs "
 4749.3,4750.0,0.7,"4749.3; 4750; 10YR4/2; dark yellowish brown; dolo mudstone; discontinuous wavy bedding; sharp contact "
 4750.0,4751.0,1.0,"4750;  4751; 10BG5/1; greenish gray; dolo mudstone; abundant vugs; several  discontinuous fracture with solution along fracture; salt staining; sharp contact "
 4751.0,4751.5,0.5,"4751; 4751.5; 10YR6/2; light yellowish brown; dolomitic oolite; medium grained; estimated 10% intergranular porosity; sharp contact "
 4751.5,4753.0,1.5,"4751.5; 4753; 10YR6/2; light yellowish brown; finely crystalline; dolo mudstone; mottled with light blue gray fine; anastamosing shale laminae; tight; sharp irregular contact "
 4753.0,4756.0,3.0,"4753; 4756; 5B5/1; medium bluish gray; dolo mudstone; mottled; abundant mm to cm irregular vugs; discontinuous angular fractures with partial cement; sharp contact "
 4756.0,4757.0,1.0,"4756; 4757; 10YR6/2; light yellowish brown; dolomudstone; horizontal laminations and wisps of 5B5/1 medium bluish gray shale; stromatolite;  sheet cracks and curved upturned mudcracks; very sharp irregular contact with 1 bluish gray shale "
 4757.0,4758.3,1.3,"4757; 4758.3; 10YR6/2; light yellowish brown; dolomite breccia with large clasts; clasts are angular and fitted; some boundaries are highlighted by solution enhanced margins; stylolites are 5B 5/1 bluish green; chert lens at 4758; bluish green stylolite at sharp irregular contact "
 4758.3,4760.6,2.3,"4758.3; 4760.6; 10YR7/2; light gray; dense; dolo mudstone; sharp contact "
 4760.6,4761.0,0.4,"4760.6; 4761; 5N medium gray; chert; dolo micrite; faint wispy horizontal lenses; fine speckled lighter gray "
 4761.0,4771.0,10.0,"4761; 4771; 10YR6/2; light yellowish brown; dolo packstone; medium to coarse peloids; faint laminations of dark gray argillaceous; scattered irregular vugs; some low angle laminations and wavy bedded enhanced by stylolites; 5B 5/1 medium blueish green;  inclined bedding; disrupted laminated bedding at 64-65; brecciation at 4764.5 to 4766.7; wavy bedding ; sharp contact stylolite enhanced irregular contact "
 4771.0,4774.0,3.0,"4771; 4774.0; 5B5/1; medium bluish gray; dolo mudstone;  centimeter-thick lenses of alternating beds with moldic pores; darker gray and brown; thin stratiform vugs of mm-size within these various lenses; disrupted; cm-thick intervals with rounded clasts; common vertical fractures that are bedding constrained; 4773 to 4772.7 is a cm-size angular  dolomite breccia with pinkish coarse dolomite clasts in gray micrite with scattered discontinuous fractures which are dissolution enhanced open; 5B 5/1 medium bluish gray stylolitic contact "
 4774.0,4775.6,1.6,"4774.0; 4775.6; 10YR7/2; light gray; dense; finely crystalline dolo mudstone; subhorizontal mm scale bedding; distinguished by alternations with mud and fine pellet dolo mudstone; distinct irregular fractures limited to bedding; sharp contact "
 4775.6,4778.7,3.1,"4775.6; 4778.7; 5GY6/1; greenish gray; dolo mudstone; scattered mm to cm sub-horizontal vugs; disrupted crinkly bedding disrupted with cm relief ( stromatolite ); sharp irregular contact with brecciation and clay stylolite "
 4778.7,4779.0,0.3,"4778.7; 4779.0; 5GY6/1; greenish gray; dolo mudstone; argillaceous finely crystalline; dense; sharp boundary "
 4779.0,4779.5,0.5,"4779.0; 4779.5; 5GY 6/1; greenish gray; dolomitic mudstone; finely crystalline; dense; creamy brown; autoclastic breccia clasts are angular but fitted; sharp boundary "
 4779.5,4781.0,1.5,"4779.5; 4781.0; 5GY6/1; greenish gray; argillaceous mudstone; increased gamma ray on log; dense,  non-porous, occasional mm sub-horizontal; poorly bedded at mm-to-cm-scale; disrupted crinkly bedding ( stromatolite ); sharp irregular stylolitic contact   transgressive "
 4781.0,4783.0,2.0,"4781.0; 4783.0; 10YR6/2; light yellowish brown; medium crystalline dolo mudstone; scattered mm to cm sub-horizontal vugs; disrupted crinkly bedding  ( stromatolite ) for 6 inches with disrupted with cm relief; algal structure; gradational contact "
 4783.0,4785.0,2.0,"4783.0; 4785.0; 10YR6/2; light yellowish brown; dolo mudstone; dense,  non-porous, occasional mm sub-horizontal; poorly bedded at mm-to-cm-scale; top has clasts a cm below contact with cm-size rounded clasts; thin greenish gray mudstone layer at sharp contact "
 4785.0,4788.0,3.0,"4785.0; 4788.0; 10YR6/2; light yellowish brown; medium crystalline dolo mudstone; common mm to cm sub-horizontal vugs dissolution enhanced and inter-crystalline porosity; micritic; irregular bedded at mm-to-cm-scale; disrupted crinkly bedding ( stromatolite ) disrupted with cm relief; algal structure; greenish gray stylolite coating at sharp contact "
 4788.0,4790.2,2.2,"4788.0; 4790.2; 5GY6/1; greenish gray; peloidal dolo packstone; distinctly bedded; mm-to-cm-scale alternating laminated low-angle bedding; some beds separated by shale seams; occasional fine peloid molds in some intervals; sharp horizontal contact "
 4790.2,4792.2,2.0,"4790.2; 4792.20; 5GY6/1; greenish gray; poorly bedded; many small pin-point vugs ( peloidal dolo packstone ); few faint sub-horizontal cm-thick discontinuous greenish shale carbon, large vug partially filled with interlocking dolomite, sharp horizontal contact "
 4792.2,4793.5,1.3,"4792.2; 4793.5; 5Y6/1; light olive gray; very finely crystalline dolo micrite; muddy lithology that has been dolomitized; @ 4793' large (fist-sized) vug filled with cm-size baroque dolomite rhombs; cm relief at contact with greenish gray stylolite coating at sharp irregular contact "
 4793.5,4795.0,1.5,"4793.5; 4795.0; 10YR6/2; light yellowish brown; finely crystalline peloidal dolo packstone; cm-scale faint inclined bedding; intermediate with many small pin-point vugs (peloidal packstone); sharp contact "
 4795.0,4797.8,2.8,"4795.0; 4797.8; 10YR6/2; light yellowish brown; finely crystalline dolo micrite;  centimeters-thick lenses of darker gray and brown; thin stratiform vugs of mm-size within these various lenses (fenistrate vugs, solution enhanced); common vertical fractures that are bedding constrained; vugs partially filled with clear rhombs; stylolitic contact "
 4797.8,4798.3,0.5,"4797.8; 4798.30; 5Y6/1; light olive gray; very finely crystalline dolomite; micritic; scattered pyrite; muddy lithology that has been dolomitized; gray wispy shale; common small discontinuous vertical fractures; tight; occasional horizontal vug 0.1 x 1.5; top irregular sharp stylolitic contact   Transgressive "
 4800.1,4801.3,1.2,"4800.1; 4801.3; 10YR7/2; light gray; fine grained pellet dolo packstone; dominated by pinpoint vugs to cm-size dominant; cm-sized and through-going vugs; very few small vugs; vugs are filled with baroque dolomite; sharp contact "
 4801.3,4807.0,5.7,"4801.3; 4807; 10YR7/2; light gray; dolo packstone; dense; isolated large subvertical cavernous fist sized vugs at 4807.4, 4806.5, 4806.,7 4805.4; very few small vugs; vugs are filled with druzy quartz; sharp contact "
 4807.0,4808.4,1.4,"4807; 4808.4; 10YR7/2; light gray; micritic dolo mudstone; pyrite clusters mm-sized; fossil fragments ( crinoids ?); sharp contact "
 4808.4,4816.0,7.6,"4808.4; 4816; 10YR7/2; light gray; dolo packstone; dense; has bedding with vugs cm-sized subhorizontal along bedding and occasional discontinuous vertical fracture; darkened grains and darkened clasts;  early cavities are filled with the darkened clasts and fine debris ( crinoid and skeletal debris ?); sharp contacts "
 4816.0,4818.6,2.6,"4816; 4818.6; 10YR7/2; light gray; micritic dolo mudstone; clean; dense; indistinct bedding; high angle to horizontal bedding; bedding alternates; sharp contacts; "
 4818.6,4900.0,81.4,"4818.6; 4900; NO RECOVERY  === large vugs on MRIL "
 4818.6,4830.0,11.4,"4818.6; 4830.0; Dolo, tan, f-med xln, with lots of up hole sh from tripping in-out "
 4830.0,4850.0,20.0,"4830.0; 4850.0; Dolo, tan, f-med xln, hrd, dns, scrtd vuggy poro, fract, lots of uphole, blk & grn sh "
 4850.0,4864.0,14.0,"4850.0; 4864.0; Dolo, lt crm, f xln, oolitic, fractured, qrtz filling, rexln, qrtz & euhedral dolo, (fracture filling), ns "
 4864.0,4884.0,20.0,"4864.0; 4884.0; Dolo, wht-crm, vf xln, hrd, fractured, scrtd qrts grains, med-coarse grain, clr, fractured,ns "
 4884.0,4900.0,16.0,"4884.0; 4900.0; Dolo, tan-lt tan, f-med xln, soft, scrtd vuggy poro., few well rndd qrtz grains, fair-gd poro, ns "
 4900.0,4900.7,0.7,"4900; 4900.7; 10YR 7/2; light gray; tight; argillaceous dolo wackestone; wispy shale laminae sub horizontal;  sharp boundary "
 4900.7,4902.0,1.3,"4900.7; 4902; 10YR7/2; light gray; fine grained pellet dolo packstone; dominated by pinpoint vugs to cm-size dominant; packstone alternating with more argillaceous sub horizontal cm-scaled bedding; poor to fair porosity; occasional short discontinuous fractures solution enhanced; sharp contact "
 4902.0,4902.4,0.4,"4902; 4902.4; 10YR7/2; light gray; tight; argillaceous wackestone; wispy shale laminae sub horizontal;  sharp boundary "
 4902.4,4903.3,0.9,"4902.4; 4903.3; 10YR7/2; light gray; grained pellet dolo packstone; dominated by pinpoint vugs to cm-size dominant; packstone alternating with more argillaceous sub horizontal cm-scaled bedding; fracture through core at 4903.1; poor to fair porosity; sharp contact "
 4903.3,4903.4,0.1,"4903.3; 4903.4; 10YR7/2; light gray; tight; argillaceous wackestone; indistinct bedding; sharp boundary "
 4903.4,4907.0,3.6,"4903.4; 4907; 10YR7/2; light gray; medium- grained pellet dolo packstone; pinpoint vugs to cm-size dominant; cm-bedded; packstone alternating with more argilliceous subhorizontal cm-scaled bedding; reactivation surfaces with cross-stratification; pinpoint vugs along bedding; porosity is fair to poor; sharp contact "
 4907.0,4908.6,1.6,"4907; 4908.6; 5Y6/1; light olive gray; sandy dolomite; quartz sand mixed with carbonate mud; dolomite cement; tight; many wisps of clay; siliciclastic mix; gradational contact   Gasconade Dolomite   Transgressive  -- "
 4908.6,4909.3,0.7,"4908.6; 4909.3; 5Y6/1; light olive gray; autoclastic chert breccia; porcelain displacing fabric; replacement; pinpoint vugs; mottled; abruptly sharp irregular contact "
 4909.3,4913.8,4.5,"4909.3; 4913.8; 10YR7/2; light gray; medium- grained pellet dolo packstone; low angle cross bedding to horizontal;  more argillaceous interbeds; pinpoint and cm vugs but overall poor porosity; "
 4913.8,4923.0,9.2,"4913.8; 4923; 10YR7/2; light gray; dolo wackstone to dolo packstone; medium grained; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; subhorizontal bedding; 4923 to 4921 has significant irregular large vugs crosscutting the core regular to subhorizontal; no visible autoclasts; scattered vertical fractures (solution enhanced?); above 4918.5 has pinpoint and scattered cm-size vugs subhorizontal;  4918-4918.5 has large irregular vug in addition to others and also has some discontinuous vertical fractures; sharp contact "
 4923.0,4924.3,1.3,"4923; 4924.3; 10YR7/2; light gray; dolo wackstone; more argillaceous; fine tight; isolated cm-size vug; sharp contact "
 4924.3,4928.0,3.7,"4924.3; 4928; 10YR7/2; light gray; medium dolo wackestone to dolo packstone; cm-size low angle bedding; alternating beds of coarser and finer; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; subhorizontal bedding; occasional large vug at 4926.4; sharp contact "
 4928.0,4928.3,0.3,"4928; 4928.3; 10YR7/2; light gray; more argillaceous; fine wackestone dolomitic; tight; isolated cm vugs; sharp contact "
 4928.3,4929.8,1.5,"4928.3; 4929.8; 10YR7/2; light gray; medium to fine wackstone to packstone dolomitic; cm-size low angle bedding; alternating beds of coarser and finer; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; sharp contact "
 4929.8,4931.2,1.4,"4929.8; 4931.2; 10YR7/2; light gray; fine argillaceous wackestone; low angle bedding; cm-size bedding with shaly boundaries; fewer vugs; sharp contact "
 4931.2,4932.3,1.1,"4931.2; 4932.3; 10YR7/2; light gray; ; medium to fine wackestone to packstone dolomitic; more vuggy; sharp contact "
 4932.3,4934.3,2.0,"4932.3; 4934.3; 10YR7/2; light gray; medium to fine dolo wackestone to packstone; wispy clay; cm-size bedding horizontal; scattered vugs; sub-cm beads of vugs following bedding; sharp contact "
 4934.3,4936.5,2.2,"4934.3; 4936.5; 10YR7/2; light gray ; medium to coarse-grained dolo packstone; peloids; cm sized vugs; cm-size vugs along bedding; fracture cross cutting core at 45 with significant solution enhancement;  sharp contact "
 4936.5,4938.3,1.8,"4936.5; 4938.3; 10YR7/2; light gray; fine-grained dolo wackestone; more argillaceous; tight; wispy shale laminations "
 4938.3,4942.2,3.9,"4938.3; 4942.2; 10YR7/2; light gray; dolo packstone; medium-grained; alternating cm-thick bedding, undulating bedding; interbedding with dolomicrite "
 4942.2,4944.3,2.1,"4942.2; 4944.3; 5Y6/1; light olive gray; dolo wackestone; argillaceous; less porous; slight incipient brecciation "
 4944.3,4950.5,6.2,"4944.3; 4950.5; 10YR7/2; light gray; dolo packstone; peloids; medium to coarse-grained cm-thick bedding; cross to planar bedding; pinpoint vugs; enhanced interpartical porosity; up to cm-scale vugs; irregular and subhorizontal vugs tied to bedding; 4946.5-4945 is all pinpoint and enhanced interparticle vugs; 4949-4946.9 is particularly large cm-sized vugs; large vug at 4948.5; sharp contact "
 4950.5,4952.2,1.7,"4950.5; 4952.2; 10YR7/2; light gray; peloidal dolo packstone; medium-grained with scattered argillaceous seams; tight; low-angle cross stratification; sharp contact "
 4952.2,4954.5,2.3,"4952.2; 4954.5; 10YR7/2; light gray; dolo micrite; vertical irregular fracture cross cuts core; significant solution enhancement along cm-size vugs extending along and intercepting fracture; scattered sub-cm vugs up to cm-size; cm-scale interbedding dipping slightly; vugs limited to more peloid rich intervals; "
 4954.5,4955.7,1.2,"4954.5; 4955.7; 10YR7/2; light gray; [ dolomitic packstone;  ] cross stratification; cm-bedding; high angle truncation; no brecciation; more argillaceous 54.7-55 argillaceous with limited vugs; 4955-4954.7 poor porosity scattered vugs; sharp contact "
 4955.7,4956.6,0.9,"4955.7; 4956.6; 10YR7/2; light gray; nodular dolomitic packstone; diminished vugs; more argillaceous; tight "
 4956.6,4959.3,2.7,"4956.6; 4959.3; 5Y6/1; light olive gray; medium grained peloidal packstone; alternating units with finer more argillaceous units; more uniform; cm-size and pinpoint vugs; less vugs more evenly distributed in bands related to bedding; pinpoint and interparticle porespace; 4959 has a large vug lined by medium crystals of baroque dolomite; good porosity "
 4959.3,4960.3,1.0,"4959.3; 4960.3; 5Y6/1; dolo mudstone; brecciation and solution vugs; solution enhancement around clasts discontinuous subvertical fractures; 4959 to 4959.3 argillaceous and no vugs; gradational contact "
 4959.7,4967.3,7.6,"4959.7; 4967.3; 5Y6/1; light olive gray; medium grained dolomitic packstone;  incipient breccia; more argillaceous which limits extent of solution cavities; scattered subvertical fractures; 4964 is more argillaceous and no vugs with angular cross stratification and packstone intervals; 4963.3 large vug cross cuts core "
 4967.3,4969.8,2.5,"4967.3; 4969.8; 5Y6/1; light olive gray; dolo packstone; medium grained; less vugs than below; more intact; more argillaceous than below; argillaceous seams; less solution activity; vugs are irregular cm-size subhorizontal; 4968.5 is a vertical pipe cm-sized vug; gradational contact "
 4969.8,4979.3,9.5,"4969.8; 4979.3; 5Y6/1; light olive gray; with blue gray clasts of darker medium grained wackestone to packstone dolomite; cm-size alternating bedding; overall pinpoint vugs; some incipient brecciation; gradational contact "
 4979.3,4986.5,7.2,"4979.3; 4986.5; 5Y6/1; light olive gray; autoclastic breccia; recrystallized cavities; mottled; light gray coarse dolomite with gray matrix fill of irregular vugs; extensively solution altered; baroque dolomite lines cavities and fills cavities; very high permeability (flow unit); many discontinuous oblique subvertical fractures; decreased argillaceous content; gradational contact "
 4986.5,4988.5,2.0,"4986.5; 4988.5; 5Y6/1; incipient autoclastic brecciation with disruptive subhorizontal vugs with pelleted packstone on reactivated surfaces and gradational contact; "
 4988.5,4995.0,6.5,"4988.5; 4995; 5Y6/1; autoclastic breccia of dolomudstone clast; subhorizontal to irregular vugs cm-sized open; clasts selectively dissolved; subhorizontal solution vugs crosscut the core at 4993, 4993.5, 4993.7; 4992; several-cm size vug cuts across core at 4991 and 4989.1; 4989.5 to 4988.5 argillaceous micritic dolomite with cm-size vugs with chalky white filling "
 4995.0,4997.7,2.7,"4995; 4997.7; 5Y6/1; light olive gray; dolo mudstone; argillaceous; finely crystalline; silty; tight; small sub-cm vugs "
 4997.7,5049.7,52.0,"4997.7; 5049.7; NO RECOVERY    large vugs;porosity on MRIL "
 4997.7,5030.0,32.3,"4997.7; 5030.0; Dolo. f-crs xln, hrd, dns, fractured, intervals of 1 thick fresh wht chert, fracture filled f grain qrtz xln and thin lyrs of qrtz, & euhedral dolo, ns "
 5030.0,5049.7,19.7,"5030.0; 5049.7; Dolo, off wht-lt tan, f-crs xln, hrd, dns, fresh, euhedrel dolo xln & some clr well rndd qrtz grains, vuggy poro, fractured, thin lyrs of lt grn sh "
 5049.7,5052.9,3.2,"5049.7; 5052.9; 5Y6/1; light olive gray; argillaceous finely crystalline dolomite; silty; tight; small sub-cm vugs; soft chalky white material and quartz along a subhorizontal solution zone at 5050 smaller vugs lined with quartz   Transgressive "
 5052.9,5057.0,4.1,"5052.9; 5057; 5Y4/1; olive gray; very finely argillaceous crystalline dolomite; massive; vuggy; extensive dissolution around clasts and filling with coarse dolomite and coarse dogtooth calcite; darkened clasts in a autoclastic breccia; sharp boundary "
 5057.0,5058.0,1.0,"5057; 5058; 5Y4/1; olive gray; extensive dissolution with what appear to be clasts of autoclastic breccia; crinkly thin ablated laminations; vugs and silicified area looks stromatolitic; sharp contact "
 5058.0,5080.0,22.0,"5058; 5080; 5Y4/1; olive gray; solid argillaceous finely crystalline micritic dolomite; stylolites; occasional cm-bedded with shale; contact at 5075.6 is transitional with clasts from below being incorporated into overlying packstone; 5074 to 5075 packstone has a moderate amount of vugs and pinpoint and interparticle porosity resulting in fair porosity; 5073.8 to 5073.5 is more of a pelleted packstone with vugs subhorizontal with good porosity; 5072-5072.6 subhorizontal vugs in mottled micritic dolomite; 5070.25 scattered vugs subhorizontal cuts through core and lined with fine to crystalline pink saddle dolomite;  scattered vugs to 5069 following subparallel bedding; 5067-5067.8 is vuggy subparallel to bedding including inclined bedding and has some darker and lighter bands; incipient autoclastic brecciation 5067.5 to 5066.5, vugs moderately abundant at 5066.7-5066.8 and have some white fine grained material partially occluding them; 5056-5058 have varying amounts of brecciation in intervals of incipient brecciation alternating with vuggy cleaner dolomite subhorizontal vugs with some vugs cutting through the entire core with filling between clasts of micritic dolomite; intervals with more shale have fewer vugs; sharp boundary   Trangressive "
 5080.0,5083.25,3.25,"5080; 5083.25; N8; very light gray; sandy dolomite; massive; tightly cemented; grades up to argillaceous dolomite with gray wispy shale laminations up to 5080; 80-80.5 is an autoclastic breccia with large vugs and cm-sized coarse dolomite fill; very low porosity other than vugged area; sharp contact "
 5083.25,5092.0,8.75,"5083.25; 5092; 5Y4/1; olive gray; medium sandstone mixed with dolomitic packstone; medium sized peloids; massively bedded; shaly wispy laminations every ~5 cm; uniform and clean; subhorizontal vugs abundant; at 5085 is vuggy cm-sized vertical and horizontal and lined with dolomite and at 5084 is vuggy cm-sized vug filled with euhedral clear quartz; appears these zones are less argillaceous; sharp boundary "
 5092.0,5098.7,6.7,"5092; 5098.7; 5Y4/1; olive gray; dolomite wackestone to packstone; medium sized peloids; clean; uniform; indistinct bedding; occasional shale lens; scattered subhorizontal oriented cm-size vugs; dolomite lining the vugs; baroque dolomite; poor to fair porosity; top foot is incipient autoclastic breccia with substantial dissolution along fragment boundaries and dolomite crystals lining the vugs at 5092; sharp contact "
 5098.7,5100.8,2.1,"5098.7; 5100.8; 5Y4/1; olive gray; dolomite cemented sandstone; poorly sorted; dark gray matrix of dolomitic mud; increasing mud dolostone to wackestone as you go upwards; scattered shaly argillaceous intervals; discontinuous; cleaner sandstone at the bottom has numerous sub-cm vugs; subvertical discontinuous fractures; moderate porosity from 5097-5098.5; gradational contact   transgressive "
 5100.8,5101.3,0.5,"5100.8; 5101.3; 5Y4/1; olive gray; incipient autoclastic breccia; silicified; cm-size vugs; disrupted bedding; vugs formed in spaces around clast edges; selective silicification of clasts; sharp contact "
 5101.3,5103.2,1.9,"5101.3; 5103.2; 5B7/1; light bluish gray; dolomitic mudstone; scattered vugs sub-cm-scale and subparallel to bedding; few vertical fractures discontinuous; poor porosity; sharp contact "
 5103.2,5108.8,5.6,"5103.2; 5108.8; 5Y4/1; olive gray;  dolomitic mudstone; chert nodules along subhorizontal beds; voids filled with dolomite; mottled with anastamozing clay; gradational contact "
 5108.2,5112.5,4.3,"5108.2; 5112.5; 5Y4/1; olive gray; dolomitic packstone to mudstone; fine pelleted; interparticle porosity; pinpoint vugs; poor porosity; bioturbated; muddier upwards; dolomite; silty peloid argillaceous "
 5112.5,5116.0,3.5,"5112.5; 5116; N3; dark gray; gray dolomitic mudstone; silty;  irregular vugs cm-sized; discontinuous vertical fractures with no dissolution enhancement; moderate porosity; gradational contact "
 5116.0,5119.0,3.0,"5116; 5119; N3; dark gray; packstone with peloids; scattered vugs; pinpoint interparticle to cm size vugs subhorizontal following faint cm-scale bedding following peloidal; solution dissolution; some vugs are mostly occluded with coarse dolomite larger ones being rimmed; gradational contact "
 5119.0,5128.0,9.0,"5119; 5128; N3; dark gray; wackestone to packstone; grainstone; fine to medium; possible bivalves; occasional/sparse  vug filled with dolomite; tight; no fractures; gradational contact "
 5128.0,5143.4,15.4,"5128; 5143.4; 5Y4/1; olive gray; sandstone with micritic dolomite matrix; frosted grains; medium grade; rounded; increasing amounts of dolomite mudstone towards the top; bivalves; bioturbated; cm-scale mottling; scattered black lithoclasts; patchy vugs filled with pink dolomite; porous towards the bottom couple feet; gradational contact   Transgressive "
 5143.4,5147.7,4.3,"5143.4; 5147.7; 5Y4/1; olive gray; dolo wackestone; fine-grained peloids; argillaceous; some stratification, clay seams horizontal; cm-size bedding and variations in color; sharp contact "
 5147.8,5149.7,1.9,"5147.8; 5149.7; olive gray; 5Y4/1; dolo packstone; fine to medium; micro porosity; some interparticle pore space; some small vugs; scattered; bioturbated; sharp boundary "
 5149.7,5154.0,4.3,"5149.7; 5154; greenish gray 5G6/1; wackestone to packstone; fine; argillaceous; grades up to poorly sorted medium to fine grained bioclastic wackestone to packstone; cm-size alternating beds; wispy dispersed argillaceous clay; sharp boundary "
 5154.0,5163.7,9.7,"5154; 5163.7; light olive gray; wackestone to mudstone; fine to medium; peloidal grainstone; cm-scale alternating beds of fine pellet and coarser peloids; low angle planar cross stratification; tight; partial discontinuous fractures with no solution enhancement; no vugs; gradational contact to skeletal packstone to wackestone cm-thick beds with shaly clay rich intervals and darkened shell fragments ( brachiopods ?); grading upwards to coarse grained packstone with blackened carbonate grains peppered with small white bivalve fragments; cm-scale bedded from fine to coarse distinguished by changes in grain-size; no porosity   TRANSGRESSION "
 5165.8,5173.0,7.2,"5165.8; 5173; granite; grayish orange pink mixed with N3 dark gray; weathered; patches of orthoclase and alteration around it; top of C horizon; sharp boundary "
 5173.0,5178.75,5.75,"5173; 5178.75; 5R5/4; granite; moderate red; epidote dark yellowish green 10GY 4/4 along natural fractures; unweathered; sharp boundary "

~IQ_Las_Parameter
#MNEM             .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT              .F           SELECTED  : Depth                          
 GR                .API         SELECTED  : Gamma Ray                      
 CALA              .IN          SELECTED  : Caliper                        
 ? ( VPVSXX )      .                      : WAVE VP/VXX                    
 ? ( VPVSYY )      .                      : WAVE VP/VYY                    
 ? ( VPVS )        .                      : WAVE VP/VS                     
 ? ( BSZ )         .in                    : Bit Size                       
 ITTT              .USEC/FT               : Acoustic transit time          
 TENS              .LB                    : Tension                        
 ? ( AZI1C )       .deg                   : Azimuth of Pad 1               
 ? ( RAD1 )        .in                    : Radius1                        
 ? ( RAD2 )        .in                    : Radius2                        
 ? ( RAD3 )        .in                    : Radius3                        
 ? ( RAD4 )        .in                    : Radius4                        
 ? ( RAD5 )        .in                    : Radius5                        
 ? ( RAD6 )        .in                    : Radius6                        
 ? ( TPUL )        .                      : Tension Pull                   
 ? ( DTXX )        .uspf                  : WAVE XX Flexural               
 ? ( DTC )         .uspf                  : WAVE DTC                       
 ? ( DTYY )        .uspf                  : WAVE YYFlexural                
 ? ( SPHW )        .pu                    : AcouPorWylie                   
 ? ( DTRS )        .uspf                  : WAVE Refracted Shear           
 DTST              .USEC/FT     SELECTED  : Acoustic transit time          
 ? ( YXRYY )       .                      : YXRYY                          
 ? ( XYRXX )       .                      : XYRXX                          
 ? ( XYENG )       .                      : XYENG                          
 ? ( YXENG )       .                      : YXENG                          
 ? ( AniAzi+ )     .deg                   : WAVE AniAzi+ Uncert            
 ? ( AniAzi- )     .deg                   : WAVE AniAzi- Uncert            
 ? ( AniAzi )      .deg                   : WAVE Aniso Azimuth             
 ? ( FastShear )   .uspf                  : WAVE Fast Shear                
 ? ( SlowShear )   .uspf                  : WAVE Slow Shear                
 ? ( AROSE )       .                      : AROSE                          
 ? ( AROSE180 )    .                      : AROSE180                       
 ? ( %Anisotropy ) .%                     : WAVE %Anisotropy               
 TENS              .LB                    : Tension                        
 SP                .MV          SELECTED  : Spontaneous Potential          
 RXRT              .RATIO       SELECTED  : Rxo/Rt ratio                   
 RXO               .RATIO                 : Rxo/Rt ratio                   
 AHT90             .OHM-M       SELECTED  : Array Induction Resistivity-90 
 AHT60             .OHM-M       SELECTED  : Array Induction Resistivity-60 
 AHT30             .OHM-M       SELECTED  : Array Induction Resistivity-30 
 AHT20             .OHM-M       SELECTED  : Array Induction Resistivity-20 
 AHT10             .OHM-M       SELECTED  : Array Induction Resistivity-10 
 RT                .OHM-M       SELECTED  : Deep Resistivity               
 ? ( RMUD )        .ohmm                  : RMUD                           
 RHOB              .GM/CC       SELECTED  : Bulk Density                   
 ? ( QN )          .NONE                  : NearQuality                    
 ? ( QF )          .NONE                  : FarQuality                     
 PE                .BARNS/E     SELECTED  : Photoelectric factor           
 NPHS              .PU                    : Neutron porosity               
 ? ( NPHL )        .%                     : Neu Por Lime                   
 NPHI              .PU          SELECTED  : Neutron porosity               
 NPHD              .PU                    : Neutron porosity               
 DRHO              .GM/CC       SELECTED  : Bulk Density Correction        
 DPHS              .PU                    : Density porosity               
 DPHI              .PU                    : Density porosity               
 DPHD              .PU                    : Density porosity               
 ? ( DLIM )        .%                     : DenPhiLime                     
 ? ( CT90 )        .mmo/m                 : 90in Conductivity 2ft Res      
 CALI              .IN                    : Caliper                        
 MINV              .OHM-M       SELECTED  : Micro Inverse Resistivity      
 MNOR              .OHM-M       SELECTED  : Micro Normal Resistivity       
 GR                .API                   : Gamma Ray                      
 GRTO              .API                   : Gamma Ray                      
 ? ( GRTC )        .api                   : GammaKT                        
 POTA              .%           SELECTED  : Potassium Concentration        
 URAN              .PPM         SELECTED  : Uranium Concentration          
 THOR              .PPM         SELECTED  : Thorium Concentration          
 ? ( TURT )        .NONE                  : RatioThorUran                  
 ? ( UKRT )        .NONE                  : RatioUranPota                  
 ? ( TKRT )        .NONE                  : RatioThorPota                  
 ? ( NOIS )        .cps                   : SpectralNoise                  

~ASCII
# DEPT GR CALA VPVSXX VPVSYY VPVS BSZ ITTT TENS AZI1C RAD1 RAD2 RAD3 RAD4 RAD5 RAD6 TPUL DTXX DTC DTYY SPHW DTRS DTST YXRYY XYRXX XYENG YXENG AniAzi+ AniAzi- AniAzi FastShear SlowShear AROSE AROSE180 %Anisotropy TENS SP RXRT RXO RT90 RT60 RT30 RT20 RT10 RT RMUD RHOB QN QF PE NPHS NPHL NPHI NPHD DRHO DPHS DPHI DPHD DLIM CT90 CALI MINV MNOR GR GRTO GRTC POTA URAN THOR TURT UKRT TKRT NOIS
 0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 0.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 1.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 1.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 2.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 2.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 3.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 3.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 4.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 4.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 5.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 5.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 6.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 6.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 7.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 7.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 8.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 8.5,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 9.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 9.5,12.945,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 10.0,14.7556,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 10.5,15.7974,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 11.0,18.4987,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 11.5,26.3761,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 12.0,41.1984,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 12.5,51.7422,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 13.0,51.4083,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 13.5,46.7009,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 14.0,42.8588,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 14.5,39.4122,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 15.0,36.3062,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 15.5,35.2986,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 16.0,34.1578,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 16.5,36.0522,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 17.0,40.4406,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 17.5,39.9993,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 18.0,38.4921,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 18.5,38.4613,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 19.0,38.7535,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 19.5,39.3323,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 20.0,42.5399,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 20.5,47.0965,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 21.0,46.8925,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 21.5,42.6098,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 22.0,41.1026,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 22.5,44.879,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 23.0,46.2696,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 23.5,43.9047,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 24.0,41.1692,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 24.5,38.6511,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 25.0,37.8034,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 25.5,39.4655,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 26.0,40.8628,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 26.5,41.2109,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 27.0,44.8432,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 27.5,49.9543,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 28.0,51.8446,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 28.5,47.9933,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 29.0,42.5973,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 29.5,41.8812,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 30.0,45.3328,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 30.5,46.7026,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 31.0,46.5277,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 31.5,47.3105,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 32.0,46.9441,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 32.5,46.2446,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 33.0,44.5667,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 33.5,41.7396,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 34.0,41.2067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 34.5,42.7039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 35.0,45.4169,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 35.5,46.4878,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 36.0,44.0246,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 36.5,40.0451,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 37.0,39.3956,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 37.5,40.4698,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 38.0,40.1408,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 38.5,40.8695,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 39.0,43.938,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 39.5,48.0974,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 40.0,48.7028,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 40.5,47.074,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,189.8519,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 41.0,45.287,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,293.1607,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 41.5,45.6151,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,351.8817,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 42.0,51.922,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,358.1096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 42.5,61.4274,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,358.5715,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 43.0,61.37,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,355.0038,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 43.5,52.8039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,349.759,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 44.0,48.3356,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,343.5417,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 44.5,47.577,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,330.3232,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 45.0,45.8341,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,328.6552,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 45.5,41.4773,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,338.153,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 46.0,37.5228,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,342.5337,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 46.5,38.0591,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,343.7068,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 47.0,41.31,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,336.5163,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 47.5,41.2608,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,327.1111,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 48.0,42.4433,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,334.6498,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 48.5,44.9997,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,333.8383,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 49.0,43.4051,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,315.709,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 49.5,42.4974,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,307.0951,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 50.0,42.9221,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,297.7063,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 50.5,43.9172,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,297.0823,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 51.0,46.9857,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,274.2935,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 51.5,54.8923,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,243.5306,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 52.0,65.327,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,253.5265,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 52.5,70.1726,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,238.9161,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 53.0,60.9578,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,236.4201,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 53.5,47.706,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,234.3231,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 54.0,39.891,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,239.256,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 54.5,32.9837,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,235.6304,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 55.0,30.7645,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,243.3756,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 55.5,34.2702,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,251.1756,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 56.0,36.9799,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,260.6748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 56.5,36.7559,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,162.4966,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 57.0,35.5784,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,164.8415,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 57.5,36.2188,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,181.4813,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 58.0,37.7601,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,209.8897,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 58.5,38.846,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,190.7955,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 59.0,38.3622,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,96.2698,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 59.5,37.6552,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,120.5191,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 60.0,38.6753,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,153.1451,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 60.5,38.6669,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,152.1258,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 61.0,36.8225,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,149.4483,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 61.5,34.9239,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,156.0329,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 62.0,32.7072,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,148.6617,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 62.5,31.7721,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,148.3049,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 63.0,33.6099,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,159.1833,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 63.5,37.965,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,56.7242,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 64.0,42.1768,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,351.3285,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 64.5,44.6916,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,335.8265,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 65.0,46.5127,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,342.7934,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 65.5,46.9641,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,347.4156,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 66.0,45.7725,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,349.8681,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 66.5,45.6043,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,353.8636,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 67.0,48.8926,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,355.5961,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 67.5,50.3166,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,350.9182,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 68.0,47.7452,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,338.7882,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 68.5,46.5802,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,329.5316,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 69.0,46.8425,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,331.1025,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 69.5,43.8689,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,328.7277,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 70.0,39.8827,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,319.105,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 70.5,38.5504,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,314.7618,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 71.0,39.5579,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,313.3192,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 71.5,40.3032,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,315.3704,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 72.0,42.6739,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,317.9133,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 72.5,49.045,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,315.0296,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 73.0,53.4959,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,311.0621,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 73.5,51.4049,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,313.6682,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 74.0,45.5618,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,286.3394,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 74.5,41.9936,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,253.1422,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 75.0,40.9569,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,302.8594,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 75.5,37.7718,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,323.9697,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 76.0,35.8815,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,138.5081,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 76.5,40.573,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,297.5243,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 77.0,50.2516,6.3811,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,332.5031,3.4674,3.534,2.7861,2.4468,3.3941,3.5151,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 77.5,55.5427,6.3784,-999.25,-999.25,-999.25,7.875,-999.25,1958.1134,344.9392,3.4681,3.5317,2.7869,2.4489,3.3901,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 78.0,56.4187,6.3818,-999.25,-999.25,-999.25,7.875,-999.25,1951.2527,182.1189,3.476,3.5427,2.7917,2.4523,3.3821,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 78.5,57.9026,6.3772,-999.25,-999.25,-999.25,7.875,-999.25,1946.6874,292.7182,3.4713,3.534,2.7853,2.4502,3.3901,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 79.0,57.5945,6.3789,-999.25,-999.25,-999.25,7.875,-999.25,1901.3273,325.3962,3.4705,3.534,2.7933,2.4536,3.3853,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 79.5,53.918,6.3759,-999.25,-999.25,-999.25,7.875,-999.25,1887.8242,243.6862,3.4705,3.5324,2.7861,2.4495,3.3877,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 80.0,50.9661,6.3768,-999.25,-999.25,-999.25,7.875,-999.25,1904.3555,193.303,3.4697,3.5332,2.7861,2.4475,3.3933,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 80.5,51.9912,6.3778,-999.25,-999.25,-999.25,7.875,-999.25,1888.5021,186.0762,3.4697,3.5324,2.7877,2.4509,3.3933,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 81.0,53.1145,6.3822,-999.25,-999.25,-999.25,7.875,-999.25,1875.7103,355.5497,3.4681,3.534,2.7853,2.4468,3.3972,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 81.5,51.6397,6.3758,-999.25,-999.25,-999.25,7.875,-999.25,1847.7532,317.4401,3.4674,3.5301,2.7885,2.4489,3.3933,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 82.0,46.6318,6.3786,-999.25,-999.25,-999.25,7.875,-999.25,1832.9091,321.7051,3.4721,3.5348,2.7861,2.4455,3.3933,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 82.5,40.8561,6.3774,-999.25,-999.25,-999.25,7.875,-999.25,1833.0581,38.3795,3.4705,3.5324,2.7845,2.4461,3.3933,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 83.0,41.8521,6.379,-999.25,-999.25,-999.25,7.875,-999.25,1843.1532,26.4184,3.4721,3.534,2.7893,2.4468,3.3933,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 83.5,48.2165,6.3738,-999.25,-999.25,-999.25,7.875,-999.25,1859.8098,334.4823,3.4697,3.5332,2.7829,2.4468,3.3901,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 84.0,49.9827,6.3763,-999.25,-999.25,-999.25,7.875,-999.25,1836.373,346.1279,3.4697,3.5317,2.7861,2.4468,3.3933,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 84.5,47.5794,6.3784,-999.25,-999.25,-999.25,7.875,-999.25,1833.4939,345.6839,3.4697,3.5332,2.7861,2.4482,3.3933,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 85.0,46.1996,6.3824,-999.25,-999.25,-999.25,7.875,-999.25,1842.0283,337.7986,3.4736,3.534,2.7933,2.4509,3.3941,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 85.5,44.9581,6.3753,-999.25,-999.25,-999.25,7.875,-999.25,1848.0399,337.7836,3.4689,3.5317,2.7837,2.4455,3.3949,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 86.0,46.9358,6.3785,-999.25,-999.25,-999.25,7.875,-999.25,1868.9303,336.5567,3.4713,3.5269,2.7861,2.4489,3.3988,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 86.5,46.8483,6.3787,-999.25,-999.25,-999.25,7.875,-999.25,1845.2986,335.6247,3.4713,3.5261,2.7861,2.4468,3.3988,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 87.0,43.1469,6.3816,-999.25,-999.25,-999.25,7.875,-999.25,1846.8356,334.2948,3.476,3.5364,2.7845,2.4455,3.4012,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 87.5,42.1393,6.3826,-999.25,-999.25,-999.25,7.875,-999.25,1863.5618,331.1758,3.4705,3.5277,2.7861,2.4482,3.4044,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 88.0,40.1533,6.3786,-999.25,-999.25,-999.25,7.875,-999.25,1859.5925,329.1565,3.4689,3.5285,2.7845,2.4475,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 88.5,37.2971,6.3777,-999.25,-999.25,-999.25,7.875,-999.25,1883.1436,329.1068,3.4705,3.5269,2.7845,2.4455,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 89.0,37.0157,6.3814,-999.25,-999.25,-999.25,7.875,-999.25,1877.3853,325.2818,3.4705,3.5261,2.7869,2.4495,3.4044,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 89.5,39.3331,6.3797,-999.25,-999.25,-999.25,7.875,-999.25,1884.2336,326.0885,3.4705,3.5285,2.7861,2.4468,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 90.0,42.1793,6.3802,-999.25,-999.25,-999.25,7.875,-999.25,1855.7611,325.5146,3.4705,3.5277,2.7861,2.4495,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 90.5,44.117,6.381,-999.25,-999.25,-999.25,7.875,-999.25,1860.304,324.5215,3.4713,3.5285,2.7861,2.4455,3.4068,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 91.0,43.1761,6.3769,-999.25,-999.25,-999.25,7.875,-999.25,1868.3567,322.9496,3.4697,3.5269,2.7845,2.4455,3.4036,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 91.5,38.8793,6.3765,-999.25,-999.25,-999.25,7.875,-999.25,1872.5209,323.3481,3.4697,3.5261,2.7812,2.4434,3.4076,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 92.0,36.4353,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1882.3986,322.5716,3.4697,3.5285,2.7804,2.4441,3.4123,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 92.5,37.4054,6.3822,-999.25,-999.25,-999.25,7.875,-999.25,1870.25,323.6951,3.476,3.5348,2.7877,2.4482,3.402,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 93.0,41.6147,6.378,-999.25,-999.25,-999.25,7.875,-999.25,1848.0287,320.6985,3.4674,3.5253,2.7869,2.4489,3.4036,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 93.5,44.8582,6.3789,-999.25,-999.25,-999.25,7.875,-999.25,1818.121,316.9453,3.4713,3.5277,2.7845,2.4475,3.4036,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 94.0,43.0179,6.3793,-999.25,-999.25,-999.25,7.875,-999.25,1819.3712,314.5429,3.4705,3.5293,2.7853,2.4475,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 94.5,44.6991,6.3759,-999.25,-999.25,-999.25,7.875,-999.25,1818.9354,313.5114,3.4728,3.5301,2.7796,2.4421,3.4044,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 95.0,50.1001,6.3763,-999.25,-999.25,-999.25,7.875,-999.25,1808.1749,316.8213,3.4705,3.5301,2.7869,2.4475,3.3988,3.4952,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 95.5,51.3325,6.3802,-999.25,-999.25,-999.25,7.875,-999.25,1835.6393,318.5883,3.4705,3.5317,2.7837,2.4482,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 96.0,44.1295,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1831.865,319.071,3.4721,3.534,2.7861,2.4475,3.4068,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 96.5,37.4762,6.3767,-999.25,-999.25,-999.25,7.875,-999.25,1838.002,318.4098,3.4705,3.5166,2.7861,2.4482,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 97.0,38.3039,6.3788,-999.25,-999.25,-999.25,7.875,-999.25,1827.3098,317.7814,3.4705,3.5182,2.7861,2.4475,3.4052,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 97.5,42.8646,6.3813,-999.25,-999.25,-999.25,7.875,-999.25,1821.5739,328.5975,3.4713,3.5261,2.7861,2.4489,3.402,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 98.0,47.2838,6.3777,-999.25,-999.25,-999.25,7.875,-999.25,1816.9391,342.8473,3.4705,3.5214,2.7845,2.4489,3.4044,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 98.5,50.5622,6.3762,-999.25,-999.25,-999.25,7.875,-999.25,1828.1243,324.7182,3.4697,3.5214,2.7837,2.4468,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 99.0,51.3308,6.3796,-999.25,-999.25,-999.25,7.875,-999.25,1851.7,34.2003,3.4721,3.5253,2.7853,2.4482,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 99.5,51.2484,6.3882,-999.25,-999.25,-999.25,7.875,-999.25,1812.0411,26.5696,3.4768,3.5324,2.7974,2.4502,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 100.0,52.7456,6.3792,-999.25,-999.25,-999.25,7.875,-999.25,1822.228,22.9497,3.4713,3.523,2.7869,2.4482,3.4068,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 100.5,51.6597,6.3789,-999.25,-999.25,-999.25,7.875,-999.25,1841.9253,8.6013,3.4744,3.523,2.7861,2.4461,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 101.0,47.4004,6.3768,-999.25,-999.25,-999.25,7.875,-999.25,1854.866,8.6013,3.4744,3.519,2.7837,2.4468,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 101.5,42.6948,6.3756,-999.25,-999.25,-999.25,7.875,-999.25,1862.0818,8.6013,3.4689,3.5206,2.7845,2.4461,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 102.0,40.9003,6.3762,-999.25,-999.25,-999.25,7.875,-999.25,1859.8446,3.9449,3.4697,3.5222,2.7837,2.4482,3.402,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 102.5,44.9531,6.3774,-999.25,-999.25,-999.25,7.875,-999.25,1885.438,16.8815,3.4705,3.5238,2.7861,2.4468,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 103.0,50.3024,6.3786,-999.25,-999.25,-999.25,7.875,-999.25,1871.9932,21.9991,3.4736,3.523,2.7853,2.4468,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 103.5,51.4374,6.3768,-999.25,-999.25,-999.25,7.875,-999.25,1868.667,17.6486,3.4689,3.5222,2.7853,2.4475,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 104.0,50.3624,6.381,-999.25,-999.25,-999.25,7.875,-999.25,1861.0377,24.6147,3.4705,3.5214,2.7901,2.4543,3.4068,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 104.5,50.0043,6.3791,-999.25,-999.25,-999.25,7.875,-999.25,1876.5024,34.2239,3.4713,3.5253,2.7861,2.4475,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 105.0,47.1606,6.378,-999.25,-999.25,-999.25,7.875,-999.25,1873.0261,37.2437,3.4697,3.5261,2.7861,2.4468,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 105.5,42.131,6.3806,-999.25,-999.25,-999.25,7.875,-999.25,1862.9994,37.996,3.4728,3.5293,2.7869,2.4468,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 106.0,35.4402,6.3807,-999.25,-999.25,-999.25,7.875,-999.25,1865.4315,39.4403,3.4713,3.5324,2.7845,2.4475,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 106.5,31.235,6.3796,-999.25,-999.25,-999.25,7.875,-999.25,1827.2415,42.8672,3.4705,3.5317,2.7845,2.4455,3.4068,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 107.0,33.0853,6.3835,-999.25,-999.25,-999.25,7.875,-999.25,1828.5376,41.0043,3.4713,3.5309,2.795,2.4536,3.4012,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 107.5,34.6766,6.3785,-999.25,-999.25,-999.25,7.875,-999.25,1836.9242,30.3627,3.4705,3.5309,2.7845,2.4468,3.4036,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 108.0,35.5526,6.3779,-999.25,-999.25,-999.25,7.875,-999.25,1846.7202,30.863,3.4689,3.5277,2.7845,2.4461,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 108.5,38.7602,6.3784,-999.25,-999.25,-999.25,7.875,-999.25,1823.0885,42.3884,3.4713,3.5309,2.7853,2.4441,3.4052,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 109.0,39.2373,6.3785,-999.25,-999.25,-999.25,7.875,-999.25,1819.7499,49.1877,3.4697,3.5293,2.7845,2.4455,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 109.5,36.9957,6.3802,-999.25,-999.25,-999.25,7.875,-999.25,1848.5328,49.9167,3.4721,3.5317,2.7869,2.4448,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 110.0,36.5077,6.3829,-999.25,-999.25,-999.25,7.875,-999.25,1825.394,56.8699,3.4721,3.5317,2.7837,2.4448,3.4076,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 110.5,35.1462,6.3801,-999.25,-999.25,-999.25,7.875,-999.25,1830.6483,53.3883,3.4721,3.5301,2.7861,2.4441,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 111.0,32.6964,6.3806,-999.25,-999.25,-999.25,7.875,-999.25,1824.7174,66.2736,3.4736,3.5293,2.7861,2.4434,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 111.5,33.7423,6.3793,-999.25,-999.25,-999.25,7.875,-999.25,1816.8361,68.387,3.4713,3.5277,2.7845,2.4448,3.4076,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 112.0,36.6085,6.3795,-999.25,-999.25,-999.25,7.875,-999.25,1827.2067,52.9551,3.4721,3.5285,2.7837,2.4455,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 112.5,40.6072,6.3804,-999.25,-999.25,-999.25,7.875,-999.25,1836.969,53.5887,3.4736,3.5285,2.7861,2.4448,3.4068,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 113.0,43.9805,6.3824,-999.25,-999.25,-999.25,7.875,-999.25,1885.5299,52.7249,3.4728,3.5317,2.7885,2.4427,3.406,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 113.5,43.9505,6.385,-999.25,-999.25,-999.25,7.875,-999.25,1857.7563,53.6746,3.4721,3.5309,2.7853,2.4434,3.4084,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 114.0,42.893,6.3795,-999.25,-999.25,-999.25,7.875,-999.25,1862.1501,46.9269,3.4705,3.5293,2.7853,2.4441,3.406,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 114.5,42.4308,6.3801,-999.25,-999.25,-999.25,7.875,-999.25,1860.8652,35.8224,3.476,3.5317,2.7845,2.4421,3.406,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 115.0,43.0137,6.3812,-999.25,-999.25,-999.25,7.875,-999.25,1870.4908,38.5261,3.4721,3.5317,2.7837,2.4427,3.4068,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 115.5,45.9423,6.3802,-999.25,-999.25,-999.25,7.875,-999.25,1856.0591,64.7289,3.4728,3.5332,2.7853,2.4427,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 116.0,50.479,6.3832,-999.25,-999.25,-999.25,7.875,-999.25,1838.7021,45.5688,3.4713,3.5324,2.7853,2.4434,3.4084,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 116.5,50.4906,6.3798,-999.25,-999.25,-999.25,7.875,-999.25,1851.4355,33.917,3.4728,3.5348,2.7837,2.4414,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 117.0,46.1971,6.3795,-999.25,-999.25,-999.25,7.875,-999.25,1849.7147,26.9751,3.4728,3.5332,2.7845,2.4421,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 117.5,44.2344,6.3806,-999.25,-999.25,-999.25,7.875,-999.25,1843.7379,20.0825,3.4721,3.5317,2.7853,2.4427,3.406,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,278.667,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 118.0,43.9147,6.3819,-999.25,-999.25,-999.25,7.875,-999.25,1829.0653,28.4852,3.4728,3.5332,2.7861,2.4441,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,275.9646,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 118.5,47.0965,6.3805,-999.25,-999.25,-999.25,7.875,-999.25,1831.0729,30.3562,3.4713,3.5332,2.7845,2.4427,3.4044,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,273.3631,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 119.0,51.489,6.3775,-999.25,-999.25,-999.25,7.875,-999.25,1836.2465,21.0332,3.4721,3.5317,2.7845,2.4414,3.4028,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,274.1947,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 119.5,53.8514,6.3797,-999.25,-999.25,-999.25,7.875,-999.25,1818.5232,16.2786,3.4713,3.5309,2.7837,2.4414,3.4044,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,272.5107,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 120.0,53.8306,6.3829,-999.25,-999.25,-999.25,7.875,-999.25,1844.5177,12.7203,3.4744,3.5332,2.7861,2.4434,3.406,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,274.4832,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 120.5,52.032,6.3868,-999.25,-999.25,-999.25,7.875,-999.25,1859.0302,12.2372,3.4885,3.534,2.7845,2.4421,3.406,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,277.2841,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 121.0,50.6163,6.3839,-999.25,-999.25,-999.25,7.875,-999.25,1860.7969,10.9379,3.4768,3.5348,2.7893,2.4427,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,275.884,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 121.5,51.9195,6.3904,-999.25,-999.25,-999.25,7.875,-999.25,1855.2211,12.1781,3.4916,3.5372,2.7869,2.4427,3.4044,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,274.3604,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 122.0,58.9018,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1839.0685,15.9911,3.4752,3.5317,2.7877,2.4421,3.4076,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.9375,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 122.5,67.7244,6.3837,-999.25,-999.25,-999.25,7.875,-999.25,1858.7322,17.2944,3.4752,3.534,2.7861,2.4421,3.4076,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.0937,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 123.0,69.777,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1845.6078,18.4766,3.4728,3.5332,2.7869,2.4427,3.4076,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,270.392,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 123.5,66.1756,6.3796,-999.25,-999.25,-999.25,7.875,-999.25,1864.1577,21.2905,3.4713,3.5309,2.7861,2.4441,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,268.5293,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 124.0,62.8114,6.3836,-999.25,-999.25,-999.25,7.875,-999.25,1838.1857,12.9007,3.4744,3.5324,2.7853,2.4421,3.4076,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,267.306,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 124.5,62.2776,6.3819,-999.25,-999.25,-999.25,7.875,-999.25,1841.5925,12.7543,3.4744,3.5324,2.7845,2.4441,3.4076,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.9587,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 125.0,63.5317,6.381,-999.25,-999.25,-999.25,7.875,-999.25,1847.3745,12.5549,3.4721,3.5301,2.7893,2.4434,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.3941,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 125.5,63.7732,6.3823,-999.25,-999.25,-999.25,7.875,-999.25,1854.5096,13.0329,3.4768,3.5317,2.7853,2.4421,3.4076,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.0526,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 126.0,61.9296,6.3784,-999.25,-999.25,-999.25,7.875,-999.25,1874.2305,15.8414,3.4713,3.5309,2.7837,2.4414,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.1589,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 126.5,58.9684,6.3793,-999.25,-999.25,-999.25,7.875,-999.25,1871.6268,15.0635,3.4728,3.5285,2.7837,2.4421,3.406,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.5491,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 127.0,59.5963,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1857.3665,14.3892,3.4736,3.5332,2.7853,2.4427,3.4092,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.4235,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 127.5,59.8261,6.3878,-999.25,-999.25,-999.25,7.875,-999.25,1828.3651,10.1574,3.4775,3.534,2.7853,2.4434,3.4108,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.1864,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 128.0,57.4696,6.3863,-999.25,-999.25,-999.25,7.875,-999.25,1838.2888,7.6422,3.4752,3.534,2.7869,2.4448,3.4084,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,265.8323,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 128.5,57.3238,6.3808,-999.25,-999.25,-999.25,7.875,-999.25,1824.3734,4.1498,3.476,3.5332,2.782,2.44,3.4084,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.8449,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 129.0,58.926,6.3878,-999.25,-999.25,-999.25,7.875,-999.25,1831.9904,358.886,3.4799,3.534,2.7869,2.4448,3.4084,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,263.6966,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 129.5,58.941,6.3846,-999.25,-999.25,-999.25,7.875,-999.25,1836.6139,358.8984,3.476,3.5332,2.7853,2.4421,3.4076,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,262.682,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 130.0,60.5223,6.3906,-999.25,-999.25,-999.25,7.875,-999.25,1837.9796,2.3207,3.4885,3.5388,2.7853,2.4427,3.4084,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.756,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 130.5,61.9271,6.382,-999.25,-999.25,-999.25,7.875,-999.25,1855.4048,4.5749,3.476,3.5332,2.7853,2.4441,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.3026,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 131.0,62.241,6.3838,-999.25,-999.25,-999.25,7.875,-999.25,1819.0968,4.599,3.476,3.5356,2.7861,2.4434,3.4084,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.9462,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 131.5,60.1426,6.3847,-999.25,-999.25,-999.25,7.875,-999.25,1807.4288,1.8092,3.4752,3.5324,2.7877,2.4448,3.4084,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.151,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 132.0,58.5946,6.3845,-999.25,-999.25,-999.25,7.875,-999.25,1815.4939,4.7698,3.4736,3.5324,2.7869,2.4434,3.4076,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.1463,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 132.5,60.5131,6.3784,-999.25,-999.25,-999.25,7.875,-999.25,1825.3481,1.305,3.4728,3.5317,2.7837,2.4421,3.4036,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.9382,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 133.0,60.1625,6.3848,-999.25,-999.25,-999.25,7.875,-999.25,1849.4055,357.6158,3.4752,3.5348,2.7893,2.4455,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4309,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 133.5,60.3174,6.3851,-999.25,-999.25,-999.25,7.875,-999.25,1850.4261,354.2589,3.4744,3.5324,2.7853,2.4434,3.4076,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 134.0,58.3481,6.3837,-999.25,-999.25,-999.25,7.875,-999.25,1851.9061,356.1965,3.4752,3.5364,2.7853,2.4448,3.406,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.7361,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 134.5,52.823,6.3845,-999.25,-999.25,-999.25,7.875,-999.25,1823.3181,357.288,3.4744,3.5317,2.7861,2.4441,3.4084,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.4974,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 135.0,48.5179,6.3853,-999.25,-999.25,-999.25,7.875,-999.25,1810.5265,356.4484,3.476,3.5332,2.7812,2.4427,3.4076,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.4436,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 135.5,45.9906,6.3799,-999.25,-999.25,-999.25,7.875,-999.25,1822.2852,354.3326,3.476,3.5317,2.7837,2.4414,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.9472,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 136.0,46.9791,6.3799,-999.25,-999.25,-999.25,7.875,-999.25,1828.3315,349.8206,3.476,3.5317,2.7837,2.4414,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.5048,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 136.5,52.1319,6.3812,-999.25,-999.25,-999.25,7.875,-999.25,1814.7825,352.4862,3.4721,3.5332,2.7853,2.4441,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.9073,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 137.0,59.0134,6.3806,-999.25,-999.25,-999.25,7.875,-999.25,1791.8051,352.2911,3.4728,3.5324,2.7853,2.4441,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3141,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 137.5,61.9287,6.3806,-999.25,-999.25,-999.25,7.875,-999.25,1832.2548,348.7067,3.4728,3.5324,2.7853,2.4441,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2611,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 138.0,62.7947,6.3848,-999.25,-999.25,-999.25,7.875,-999.25,1857.4818,347.877,3.4744,3.5348,2.7853,2.4448,3.4068,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.331,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 138.5,60.5797,6.3848,-999.25,-999.25,-999.25,7.875,-999.25,1881.8015,353.4774,3.4744,3.5348,2.7853,2.4448,3.4068,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.8972,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 139.0,56.7618,6.3792,-999.25,-999.25,-999.25,7.875,-999.25,1874.4142,353.8295,3.4728,3.5317,2.7845,2.4414,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.5205,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 139.5,62.8239,6.3809,-999.25,-999.25,-999.25,7.875,-999.25,1853.0298,355.5635,3.4736,3.5309,2.7869,2.4448,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.0562,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 140.0,71.2967,6.3813,-999.25,-999.25,-999.25,7.875,-999.25,1849.0841,356.3805,3.4752,3.5324,2.7869,2.4427,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.3849,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 140.5,73.4493,6.3854,-999.25,-999.25,-999.25,7.875,-999.25,1848.0399,354.6343,3.4838,3.5348,2.7861,2.4434,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.7081,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 141.0,73.3161,6.3828,-999.25,-999.25,-999.25,7.875,-999.25,1891.9548,348.1073,3.4744,3.5332,2.7853,2.4434,3.406,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.6829,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 141.5,71.405,6.3824,-999.25,-999.25,-999.25,7.875,-999.25,1869.5498,345.4468,3.4752,3.5324,2.7853,2.4427,3.4068,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.4949,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 142.0,70.3141,6.3833,-999.25,-999.25,-999.25,7.875,-999.25,1833.5162,343.3678,3.4736,3.5309,2.7853,2.4434,3.4052,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.8665,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 142.5,71.5882,6.3814,-999.25,-999.25,-999.25,7.875,-999.25,1835.6045,342.4091,3.4744,3.5348,2.7829,2.4421,3.4068,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.3152,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 143.0,68.5821,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1832.4845,345.1309,3.4744,3.5332,2.7861,2.4448,3.4108,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.3896,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 143.5,61.4624,6.386,-999.25,-999.25,-999.25,7.875,-999.25,1840.9618,348.2715,3.4744,3.5317,2.7901,2.4482,3.4068,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.6395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 144.0,57.1698,6.3844,-999.25,-999.25,-999.25,7.875,-999.25,1844.53,348.4602,3.4775,3.5332,2.7861,2.4455,3.406,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5532,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 144.5,52.2068,6.3857,-999.25,-999.25,-999.25,7.875,-999.25,1863.0912,348.2476,3.4744,3.5332,2.7861,2.4455,3.4084,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.2769,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 145.0,50.4914,6.3823,-999.25,-999.25,-999.25,7.875,-999.25,1854.9343,340.1996,3.4768,3.534,2.7869,2.4441,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.2559,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 145.5,55.2712,6.3832,-999.25,-999.25,-999.25,7.875,-999.25,1845.0117,331.7383,3.476,3.5309,2.7845,2.4455,3.4068,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4742,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 146.0,58.4938,6.3841,-999.25,-999.25,-999.25,7.875,-999.25,1841.8905,328.2219,3.4744,3.5332,2.7869,2.4448,3.4068,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.2003,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 146.5,58.8935,6.3824,-999.25,-999.25,-999.25,7.875,-999.25,1834.6299,332.3066,3.4768,3.5324,2.7853,2.4461,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.164,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 147.0,61.4749,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1843.3246,333.9336,3.476,3.5348,2.7869,2.4455,3.4076,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.7748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 147.5,65.0331,6.3799,-999.25,-999.25,-999.25,7.875,-999.25,1816.9279,334.9697,3.4736,3.5317,2.7829,2.4434,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0242,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 148.0,68.07,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1816.8932,335.9031,3.4775,3.5324,2.7837,2.4441,3.41,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.758,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 148.5,70.9428,6.3822,-999.25,-999.25,-999.25,7.875,-999.25,1824.2592,336.6798,3.4752,3.534,2.7845,2.4448,3.4068,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0696,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 149.0,73.5534,6.3884,-999.25,-999.25,-999.25,7.875,-999.25,1845.8599,333.8646,3.4885,3.5388,2.7837,2.4434,3.406,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0487,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 149.5,75.3437,6.3839,-999.25,-999.25,-999.25,7.875,-999.25,1830.683,334.3981,3.4799,3.5324,2.7837,2.4455,3.4068,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0412,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 150.0,76.7843,6.3844,-999.25,-999.25,-999.25,7.875,-999.25,1824.9358,336.591,3.4775,3.5301,2.7845,2.4448,3.4068,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.2004,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 150.5,77.0616,6.3854,-999.25,-999.25,-999.25,7.875,-999.25,1844.6218,334.2577,3.4799,3.5317,2.7861,2.4407,3.4068,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.3067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 151.0,76.7551,6.3851,-999.25,-999.25,-999.25,7.875,-999.25,1840.1238,333.9594,3.4862,3.5348,2.7845,2.4427,3.4036,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.1911,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 151.5,79.6588,6.388,-999.25,-999.25,-999.25,7.875,-999.25,1848.4645,338.0154,3.4893,3.5324,2.7869,2.4434,3.4052,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.4793,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 152.0,81.7722,6.384,-999.25,-999.25,-999.25,7.875,-999.25,1837.36,339.2458,3.4838,3.5309,2.7845,2.4448,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.0905,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 152.5,79.389,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1872.3954,340.9249,3.4916,3.5309,2.7853,2.4441,3.4076,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.6493,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 153.0,73.2011,6.3862,-999.25,-999.25,-999.25,7.875,-999.25,1866.6471,339.4306,3.4885,3.5309,2.7837,2.4441,3.406,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.0154,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 153.5,69.095,6.3865,-999.25,-999.25,-999.25,7.875,-999.25,1847.696,337.4009,3.4916,3.5317,2.7853,2.4414,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.7085,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 154.0,69.205,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1853.4431,341.151,3.4916,3.5332,2.7845,2.4441,3.4036,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9953,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 154.5,66.8534,6.3903,-999.25,-999.25,-999.25,7.875,-999.25,1836.6598,346.5781,3.4916,3.534,2.7861,2.4421,3.4076,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2202,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 155.0,63.8523,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1830.2584,348.2583,3.4893,3.5317,2.7829,2.4441,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.7159,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 155.5,65.9982,6.3857,-999.25,-999.25,-999.25,7.875,-999.25,1822.6067,350.7081,3.4901,3.5324,2.7837,2.4434,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.1682,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 156.0,71.4508,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1834.4797,352.2207,3.4916,3.5332,2.7845,2.4441,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0055,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 156.5,73.0995,6.3865,-999.25,-999.25,-999.25,7.875,-999.25,1837.9796,354.1512,3.4916,3.5317,2.7853,2.4434,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.1976,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 157.0,70.7013,6.3857,-999.25,-999.25,-999.25,7.875,-999.25,1834.9391,0.1895,3.4916,3.534,2.7837,2.4427,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.5465,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 157.5,68.2948,6.3872,-999.25,-999.25,-999.25,7.875,-999.25,1850.2201,20.8276,3.4916,3.5332,2.7845,2.4434,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.2722,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 158.0,68.6029,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1836.6946,12.4527,3.4916,3.5309,2.7837,2.4427,3.406,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.16,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 158.5,70.9387,6.3862,-999.25,-999.25,-999.25,7.875,-999.25,1830.9351,338.9229,3.4916,3.5317,2.7812,2.4421,3.4052,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.1606,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 159.0,73.9572,6.3838,-999.25,-999.25,-999.25,7.875,-999.25,1815.2766,340.8688,3.4893,3.5317,2.7837,2.4421,3.4028,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.7732,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 159.5,74.9948,6.3876,-999.25,-999.25,-999.25,7.875,-999.25,1822.2628,354.2302,3.4916,3.5301,2.7829,2.4434,3.4052,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.3008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 160.0,72.0403,6.3862,-999.25,-999.25,-999.25,7.875,-999.25,1835.0533,348.2965,3.4916,3.5317,2.7845,2.4427,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2094,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 160.5,72.3551,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1822.423,309.8835,3.4916,3.5317,2.7829,2.4427,3.406,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2073,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 161.0,74.8915,6.3854,-999.25,-999.25,-999.25,7.875,-999.25,1822.3771,318.0336,3.4916,3.5324,2.7829,2.4434,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.276,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 161.5,75.0381,6.3863,-999.25,-999.25,-999.25,7.875,-999.25,1799.5486,319.4705,3.4901,3.5324,2.7853,2.4468,3.4036,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2642,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 162.0,73.4493,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1814.3579,326.1526,3.4909,3.5324,2.7845,2.4434,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.9008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 162.5,69.4356,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1805.9836,328.2954,3.4916,3.5309,2.7845,2.4441,3.406,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.1885,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 163.0,63.3318,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1827.1956,329.8425,3.4916,3.5324,2.7845,2.4427,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3286,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 163.5,60.0252,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1828.2161,329.4255,3.4916,3.5317,2.7853,2.4434,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3867,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 164.0,62.9621,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1815.6429,322.3914,3.4916,3.5324,2.7853,2.4448,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3621,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 164.5,68.4039,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1818.2936,318.623,3.4916,3.5317,2.7861,2.4448,3.406,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.7535,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 165.0,74.6809,6.3853,-999.25,-999.25,-999.25,7.875,-999.25,1822.8016,315.9202,3.4893,3.5324,2.7837,2.4441,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.8922,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 165.5,79.449,6.3868,-999.25,-999.25,-999.25,7.875,-999.25,1830.1554,317.5289,3.4916,3.5324,2.7829,2.4448,3.4052,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.713,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 166.0,79.3366,6.3852,-999.25,-999.25,-999.25,7.875,-999.25,1803.0472,308.7627,3.4916,3.5324,2.7845,2.4421,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.8398,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 166.5,75.9433,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1818.764,342.598,3.4916,3.5324,2.7845,2.4441,3.4052,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0399,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 167.0,70.3225,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1834.9391,9.158,3.4916,3.5324,2.7853,2.4448,3.4076,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2704,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 167.5,68.9068,6.3883,-999.25,-999.25,-999.25,7.875,-999.25,1823.6161,358.0692,3.4916,3.5317,2.7845,2.4441,3.4084,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.5778,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 168.0,74.3653,6.3863,-999.25,-999.25,-999.25,7.875,-999.25,1830.0063,336.5187,3.4901,3.5293,2.7861,2.4455,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2403,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 168.5,79.7238,6.3876,-999.25,-999.25,-999.25,7.875,-999.25,1836.0179,334.4106,3.4916,3.5332,2.7861,2.4468,3.4036,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.4957,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 169.0,82.1519,6.3889,-999.25,-999.25,-999.25,7.875,-999.25,1853.6268,339.0488,3.4916,3.5324,2.7845,2.4468,3.4044,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.8221,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 169.5,83.1903,6.3869,-999.25,-999.25,-999.25,7.875,-999.25,1837.0957,349.3243,3.4916,3.5324,2.7845,2.4434,3.4052,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.8524,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 170.0,81.3809,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1831.7383,353.5836,3.4916,3.5317,2.7829,2.4441,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.4504,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 170.5,78.2349,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1840.3535,330.0308,3.4916,3.5332,2.7837,2.4427,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.5927,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 171.0,79.9977,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1825.2103,282.4082,3.4916,3.5317,2.7829,2.4441,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2406,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 171.5,83.396,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1838.9767,308.1948,3.4916,3.5317,2.7845,2.4441,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.0726,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 172.0,81.6765,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1819.3376,311.0673,3.4916,3.534,2.7837,2.4441,3.406,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1975,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 172.5,76.2389,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1846.0436,348.5806,3.4916,3.5309,2.7853,2.4441,3.406,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.8936,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 173.0,70.5973,6.3868,-999.25,-999.25,-999.25,7.875,-999.25,1813.3373,353.7009,3.4916,3.5317,2.7837,2.4455,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.9149,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 173.5,70.1726,6.3878,-999.25,-999.25,-999.25,7.875,-999.25,1830.1665,356.3397,3.4916,3.534,2.7845,2.4461,3.4044,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.9092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 174.0,75.1147,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1835.6393,351.6005,3.4916,3.5332,2.7861,2.4455,3.4068,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.8457,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 174.5,78.7828,6.3855,-999.25,-999.25,-999.25,7.875,-999.25,1826.0371,344.7742,3.4916,3.5301,2.7837,2.4434,3.4044,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.491,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 175.0,80.4049,6.3882,-999.25,-999.25,-999.25,7.875,-999.25,1826.427,333.5564,3.4916,3.5317,2.7845,2.4441,3.4044,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.1157,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 175.5,83.3311,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1801.4642,339.6497,3.4916,3.5317,2.7853,2.4461,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.3307,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 176.0,84.0081,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1830.0983,333.1832,3.4916,3.5324,2.7861,2.4461,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.9184,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 176.5,82.799,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1802.9442,327.6621,3.4901,3.5324,2.7845,2.4455,3.4044,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.2314,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 177.0,81.4625,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1821.5055,324.177,3.4916,3.5332,2.7837,2.4448,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.5334,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 177.5,80.0102,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1806.947,330.3175,3.4916,3.5324,2.7853,2.4461,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.8409,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 178.0,79.0884,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1809.7692,332.062,3.4916,3.5324,2.7845,2.4441,3.4076,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0957,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 178.5,78.8161,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1831.865,341.3126,3.4916,3.5332,2.7845,2.4461,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.7304,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 179.0,81.012,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1807.6249,331.3207,3.4916,3.534,2.7845,2.4448,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.8244,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 179.5,82.2977,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1805.8582,305.2649,3.4916,3.5301,2.7845,2.4427,3.406,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0573,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 180.0,78.6704,6.3848,-999.25,-999.25,-999.25,7.875,-999.25,1809.46,317.8312,3.4916,3.5317,2.7845,2.4421,3.4052,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.8502,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 180.5,74.914,6.385,-999.25,-999.25,-999.25,7.875,-999.25,1835.0074,315.098,3.4901,3.5324,2.7845,2.4414,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.2939,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 181.0,72.0412,6.3826,-999.25,-999.25,-999.25,7.875,-999.25,1823.6509,304.2388,3.483,3.5309,2.7845,2.4421,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.2797,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 181.5,72.7581,6.3933,-999.25,-999.25,-999.25,7.875,-999.25,1803.4259,302.6888,3.4924,3.5514,2.7845,2.4421,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.1636,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 182.0,79.4581,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1833.4244,300.2931,3.4916,3.5309,2.7829,2.4441,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.0891,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 182.5,85.0115,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1829.6389,270.8564,3.4916,3.5317,2.7837,2.4448,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.7573,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 183.0,86.8584,6.3857,-999.25,-999.25,-999.25,7.875,-999.25,1848.2236,283.0499,3.4916,3.5317,2.7845,2.4434,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.2433,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 183.5,85.8833,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1824.4194,337.5284,3.4885,3.5332,2.7853,2.4448,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.5073,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 184.0,82.5816,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1827.6201,334.0824,3.4916,3.5301,2.7829,2.4434,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.5575,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 184.5,76.5203,6.3873,-999.25,-999.25,-999.25,7.875,-999.25,1808.6678,311.6327,3.4916,3.5293,2.7837,2.4448,3.4084,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.3044,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 185.0,69.4648,6.3845,-999.25,-999.25,-999.25,7.875,-999.25,1790.3015,306.7561,3.4854,3.5301,2.7853,2.4455,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.0653,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 185.5,63.998,6.3839,-999.25,-999.25,-999.25,7.875,-999.25,1816.6063,313.4075,3.4916,3.5309,2.782,2.4434,3.4036,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.9514,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 186.0,61.0835,6.3842,-999.25,-999.25,-999.25,7.875,-999.25,1823.4324,316.8016,3.4838,3.5293,2.7837,2.4448,3.4076,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3296,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 186.5,64.8307,6.3833,-999.25,-999.25,-999.25,7.875,-999.25,1826.1055,311.5149,3.4901,3.5301,2.7829,2.4427,3.4036,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.9538,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 187.0,73.5034,6.3852,-999.25,-999.25,-999.25,7.875,-999.25,1812.7749,310.6747,3.4916,3.5301,2.7845,2.4434,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.5795,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 187.5,79.4115,6.3841,-999.25,-999.25,-999.25,7.875,-999.25,1837.0273,323.5961,3.4862,3.5301,2.7853,2.4434,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4462,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 188.0,83.4876,6.3843,-999.25,-999.25,-999.25,7.875,-999.25,1835.0198,324.8956,3.4846,3.5293,2.7837,2.4434,3.4052,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5477,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 188.5,82.7007,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1823.903,331.2267,3.4862,3.5301,2.7845,2.4421,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.6034,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 189.0,75.2854,6.387,-999.25,-999.25,-999.25,7.875,-999.25,1827.1956,328.9816,3.4916,3.5324,2.7829,2.4427,3.4044,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.926,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 189.5,66.0798,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1834.2164,326.6644,3.4901,3.5317,2.7845,2.4441,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2309,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 190.0,63.4568,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1818.0067,328.5763,3.4916,3.5317,2.7837,2.4434,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.9154,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 190.5,69.2524,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1790.1873,332.9586,3.4932,3.5324,2.7845,2.4421,3.4052,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.2853,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 191.0,74.2778,6.3841,-999.25,-999.25,-999.25,7.875,-999.25,1807.98,326.5186,3.4924,3.5324,2.7837,2.4414,3.4036,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.9936,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 191.5,72.9871,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1814.7601,329.4578,3.494,3.5301,2.7853,2.4421,3.4068,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.9814,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 192.0,69.7812,6.3834,-999.25,-999.25,-999.25,7.875,-999.25,1801.5786,339.7181,3.4932,3.5317,2.7837,2.4394,3.4036,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.2342,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 192.5,70.5473,6.384,-999.25,-999.25,-999.25,7.875,-999.25,1805.2386,340.9257,3.4924,3.5317,2.7837,2.4434,3.4028,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.2061,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 193.0,74.3861,6.3836,-999.25,-999.25,-999.25,7.875,-999.25,1805.559,336.736,3.494,3.5309,2.7837,2.4394,3.4036,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.4962,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 193.5,72.5516,6.3873,-999.25,-999.25,-999.25,7.875,-999.25,1816.4574,333.7408,3.4956,3.534,2.7845,2.4427,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1271,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 194.0,62.9663,6.3855,-999.25,-999.25,-999.25,7.875,-999.25,1804.8477,336.8015,3.4932,3.5301,2.7853,2.4427,3.4044,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 194.5,59.1725,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1833.3673,337.34,3.4956,3.5332,2.7845,2.4421,3.4044,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.019,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 195.0,66.0998,6.3843,-999.25,-999.25,-999.25,7.875,-999.25,1844.5759,337.0756,3.494,3.5324,2.7837,2.4407,3.4028,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.2171,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 195.5,74.6925,6.3857,-999.25,-999.25,-999.25,7.875,-999.25,1831.9109,335.6819,3.494,3.5332,2.7837,2.4407,3.4068,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.419,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 196.0,80.2817,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1835.5698,338.1759,3.4963,3.5317,2.7845,2.4414,3.4044,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.0001,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 196.5,81.639,6.384,-999.25,-999.25,-999.25,7.875,-999.25,1811.4216,340.6198,3.4932,3.5301,2.7829,2.4421,3.4052,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.7298,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 197.0,82.4384,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1815.0693,335.0448,3.4963,3.5317,2.7837,2.4427,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3387,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 197.5,85.8042,6.3867,-999.25,-999.25,-999.25,7.875,-999.25,1821.1044,335.6776,3.4956,3.5317,2.7837,2.4414,3.4052,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.8274,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 198.0,88.384,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1825.3145,324.7377,3.4963,3.5317,2.7837,2.4414,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.2538,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 198.5,86.8293,6.3878,-999.25,-999.25,-999.25,7.875,-999.25,1818.1904,320.7144,3.4956,3.5317,2.7845,2.4421,3.4068,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.9966,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 199.0,81.4733,6.3875,-999.25,-999.25,-999.25,7.875,-999.25,1807.1768,347.7365,3.4963,3.5324,2.7837,2.4441,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.8629,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 199.5,76.8301,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1835.0421,13.7601,3.4956,3.5317,2.7845,2.4421,3.4052,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.6399,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 200.0,76.4554,6.3872,-999.25,-999.25,-999.25,7.875,-999.25,1835.5015,52.7825,3.4956,3.5309,2.7853,2.4434,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.2181,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 200.5,78.787,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1811.984,340.2096,3.4948,3.5309,2.7861,2.4414,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.9632,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 201.0,78.5788,6.3845,-999.25,-999.25,-999.25,7.875,-999.25,1791.265,337.8491,3.4932,3.5309,2.7845,2.4427,3.4044,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.1539,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 201.5,74.7433,6.3853,-999.25,-999.25,-999.25,7.875,-999.25,1812.3738,354.2869,3.4956,3.5317,2.7845,2.4427,3.4036,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.1663,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 202.0,70.5356,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1825.8298,9.5747,3.4948,3.5301,2.7845,2.4434,3.4052,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.6431,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 202.5,69.7246,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1822.6527,43.3583,3.494,3.5317,2.7845,2.4427,3.406,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1928,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 203.0,68.2299,6.3875,-999.25,-999.25,-999.25,7.875,-999.25,1836.8088,19.455,3.4948,3.5309,2.7853,2.4448,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.6088,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 203.5,66.268,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1832.5763,14.82,3.4956,3.5317,2.7861,2.4434,3.4068,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.0033,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 204.0,67.0307,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1828.1477,330.3158,3.4956,3.5324,2.7837,2.4441,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.275,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 204.5,67.2106,6.3884,-999.25,-999.25,-999.25,7.875,-999.25,1824.0519,324.7587,3.4963,3.5309,2.7853,2.4448,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.4534,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 205.0,68.3031,6.3877,-999.25,-999.25,-999.25,7.875,-999.25,1839.0001,1.1021,3.4956,3.5324,2.7837,2.4448,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.535,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 205.5,72.4217,6.388,-999.25,-999.25,-999.25,7.875,-999.25,1840.0667,86.2037,3.4963,3.5301,2.7837,2.4468,3.4052,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.5464,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 206.0,76.8218,6.3915,-999.25,-999.25,-999.25,7.875,-999.25,1814.0599,313.5454,3.4948,3.5317,2.7877,2.4455,3.4068,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.2258,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 206.5,76.9375,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1840.1932,319.6094,3.4948,3.5301,2.7853,2.4468,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.9881,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 207.0,73.1453,6.3923,-999.25,-999.25,-999.25,7.875,-999.25,1822.5608,324.7534,3.4963,3.534,2.7853,2.4468,3.4068,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.9829,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 207.5,71.4158,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1843.8757,325.0668,3.4948,3.5324,2.7837,2.4455,3.4068,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.8476,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 208.0,75.0872,6.3847,-999.25,-999.25,-999.25,7.875,-999.25,1855.4283,325.4287,3.4932,3.5309,2.7837,2.4427,3.4044,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.5093,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 208.5,75.9033,6.3865,-999.25,-999.25,-999.25,7.875,-999.25,1845.1831,324.1241,3.4948,3.5309,2.7853,2.4427,3.4044,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.1596,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 209.0,69.2508,6.3853,-999.25,-999.25,-999.25,7.875,-999.25,1822.572,325.699,3.4948,3.5309,2.7837,2.4421,3.4044,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.4992,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 209.5,63.9622,6.3876,-999.25,-999.25,-999.25,7.875,-999.25,1801.6816,327.5553,3.4956,3.5317,2.7869,2.4434,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.5561,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 210.0,64.2104,6.3877,-999.25,-999.25,-999.25,7.875,-999.25,1820.1174,325.8133,3.4956,3.5324,2.7845,2.4441,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.1156,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 210.5,66.9858,6.3877,-999.25,-999.25,-999.25,7.875,-999.25,1803.4259,323.7728,3.4963,3.5324,2.7837,2.4455,3.406,3.4993,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.0163,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 211.0,71.3509,6.3872,-999.25,-999.25,-999.25,7.875,-999.25,1802.7828,320.0349,3.4948,3.5317,2.7853,2.4448,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.2874,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 211.5,69.4564,6.387,-999.25,-999.25,-999.25,7.875,-999.25,1799.0085,318.7011,3.4956,3.5317,2.7853,2.4448,3.4036,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.0617,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 212.0,62.918,6.3885,-999.25,-999.25,-999.25,7.875,-999.25,1806.8899,320.1923,3.4979,3.5317,2.7845,2.4455,3.4052,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.9677,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 212.5,61.4216,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1817.9496,321.2147,3.4971,3.5309,2.7845,2.4455,3.4044,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.1861,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 213.0,62.8972,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1816.0675,321.3557,3.4963,3.5317,2.7861,2.4448,3.406,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.8685,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 213.5,64.8457,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1832.61,321.9027,3.4956,3.5317,2.7861,2.4461,3.406,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.5359,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 214.0,68.5146,6.3897,-999.25,-999.25,-999.25,7.875,-999.25,1821.0808,320.5756,3.4979,3.5324,2.7853,2.4455,3.4068,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.4817,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 214.5,75.0656,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1833.505,321.0887,3.4963,3.5332,2.7853,2.4455,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.6024,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 215.0,81.0178,6.39,-999.25,-999.25,-999.25,7.875,-999.25,1816.2859,320.5832,3.4979,3.5317,2.7853,2.4461,3.4076,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.0788,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 215.5,82.8131,6.389,-999.25,-999.25,-999.25,7.875,-999.25,1810.6877,319.4177,3.4963,3.5332,2.7861,2.4448,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.9765,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 216.0,81.0819,6.3893,-999.25,-999.25,-999.25,7.875,-999.25,1822.8016,320.4656,3.4971,3.5324,2.7853,2.4468,3.4036,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.6428,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 216.5,76.1939,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1814.1865,323.6279,3.4963,3.5372,2.7853,2.4455,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.3438,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 217.0,72.7873,6.3894,-999.25,-999.25,-999.25,7.875,-999.25,1838.3123,322.7347,3.4956,3.5356,2.7845,2.4461,3.4044,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1048,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 217.5,69.7512,6.3896,-999.25,-999.25,-999.25,7.875,-999.25,1829.9492,322.2772,3.4963,3.5364,2.7869,2.4441,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2721,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 218.0,61.4766,6.3916,-999.25,-999.25,-999.25,7.875,-999.25,1837.0609,319.5741,3.4948,3.5467,2.7853,2.4427,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.2237,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 218.5,56.5935,6.394,-999.25,-999.25,-999.25,7.875,-999.25,1830.6259,319.477,3.4963,3.553,2.7853,2.4427,3.406,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.2246,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 219.0,63.9472,6.3948,-999.25,-999.25,-999.25,7.875,-999.25,1840.3994,320.4587,3.4956,3.5569,2.7853,2.4434,3.406,3.4973,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.6378,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 219.5,71.4133,6.3937,-999.25,-999.25,-999.25,7.875,-999.25,1835.8801,323.6895,3.4971,3.5522,2.7845,2.4434,3.4052,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.0737,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 220.0,70.937,6.3951,-999.25,-999.25,-999.25,7.875,-999.25,1818.856,327.2556,3.4971,3.5546,2.7869,2.4434,3.4052,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.8913,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 220.5,72.8847,6.3929,-999.25,-999.25,-999.25,7.875,-999.25,1855.5885,342.8197,3.4963,3.5514,2.7845,2.4427,3.4052,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.4026,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 221.0,76.9725,6.3946,-999.25,-999.25,-999.25,7.875,-999.25,1834.2971,332.6232,3.4956,3.5522,2.7845,2.4427,3.4068,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.8918,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 221.5,75.0697,6.3947,-999.25,-999.25,-999.25,7.875,-999.25,1830.58,286.096,3.4971,3.5538,2.7853,2.4448,3.4052,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.0188,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 222.0,69.9927,6.3957,-999.25,-999.25,-999.25,7.875,-999.25,1821.4136,291.4244,3.4963,3.5546,2.7869,2.4434,3.406,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.507,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 222.5,66.4379,6.395,-999.25,-999.25,-999.25,7.875,-999.25,1831.6117,321.9419,3.4963,3.5538,2.7861,2.4434,3.4068,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.5057,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 223.0,61.8546,6.3947,-999.25,-999.25,-999.25,7.875,-999.25,1824.4194,329.5831,3.4963,3.5546,2.7845,2.4434,3.4068,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.2681,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 223.5,58.423,6.3953,-999.25,-999.25,-999.25,7.875,-999.25,1815.4591,320.8168,3.4956,3.5562,2.7853,2.4414,3.4068,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.1283,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 224.0,62.4325,6.3835,-999.25,-999.25,-999.25,7.875,-999.25,1834.5839,316.2701,3.4956,3.5562,2.7853,2.4455,3.3702,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.9484,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 224.5,71.3384,6.3985,-999.25,-999.25,-999.25,7.875,-999.25,1828.1243,314.8167,3.4971,3.5609,2.7869,2.4455,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.7277,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 225.0,80.5606,6.396,-999.25,-999.25,-999.25,7.875,-999.25,1845.4934,311.4731,3.4963,3.5562,2.7861,2.4427,3.4068,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.4217,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 225.5,86.9892,6.3929,-999.25,-999.25,-999.25,7.875,-999.25,1835.7076,309.7868,3.4971,3.5506,2.7845,2.4441,3.4044,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.6317,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 226.0,85.1655,6.3934,-999.25,-999.25,-999.25,7.875,-999.25,1844.0819,308.1401,3.4948,3.5538,2.7853,2.4421,3.4044,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3204,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 226.5,78.7395,6.3969,-999.25,-999.25,-999.25,7.875,-999.25,1829.9033,314.0203,3.4963,3.5641,2.7861,2.4414,3.4028,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.2226,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 227.0,71.7797,6.3933,-999.25,-999.25,-999.25,7.875,-999.25,1831.5322,312.8998,3.4963,3.5522,2.7861,2.4407,3.406,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.7773,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 227.5,67.6811,6.3972,-999.25,-999.25,-999.25,7.875,-999.25,1847.2367,316.1624,3.4963,3.5641,2.7853,2.4421,3.406,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.0417,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 228.0,67.2614,6.3933,-999.25,-999.25,-999.25,7.875,-999.25,1836.9242,317.1489,3.4971,3.553,2.7861,2.4407,3.4044,3.4986,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.0111,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 228.5,68.3023,6.3938,-999.25,-999.25,-999.25,7.875,-999.25,1831.1995,315.2564,3.4956,3.5554,2.7861,2.4414,3.4052,3.498,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3964,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 229.0,69.5347,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1822.423,317.317,3.4963,3.5419,2.7861,2.4421,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.7739,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 229.5,66.2363,6.3884,-999.25,-999.25,-999.25,7.875,-999.25,1827.9293,309.0457,3.494,3.5348,2.7869,2.4427,3.4068,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0244,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 230.0,60.2691,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1837.3937,304.0719,3.4956,3.534,2.7845,2.4434,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.5067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 230.5,57.049,6.3904,-999.25,-999.25,-999.25,7.875,-999.25,1827.0353,294.7767,3.4963,3.5332,2.7861,2.4427,3.406,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.8375,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 231.0,55.5085,6.3878,-999.25,-999.25,-999.25,7.875,-999.25,1849.9445,299.1526,3.4956,3.5332,2.7853,2.4427,3.406,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.7233,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 231.5,56.895,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1841.9253,299.7662,3.4963,3.5324,2.7845,2.4407,3.406,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.9795,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 232.0,60.0052,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1849.8873,306.508,3.4956,3.5317,2.7853,2.4421,3.4052,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.219,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 232.5,61.8121,6.3876,-999.25,-999.25,-999.25,7.875,-999.25,1844.139,314.6548,3.4963,3.5324,2.7853,2.4421,3.4052,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.5594,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 233.0,64.406,6.3902,-999.25,-999.25,-999.25,7.875,-999.25,1852.1582,312.76,3.4963,3.5317,2.7861,2.4461,3.4076,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.2625,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 233.5,63.8623,6.3917,-999.25,-999.25,-999.25,7.875,-999.25,1856.3683,307.9561,3.4979,3.5309,2.7885,2.4434,3.4068,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.4879,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 234.0,58.9043,6.3897,-999.25,-999.25,-999.25,7.875,-999.25,1835.5586,305.1815,3.4971,3.5309,2.7877,2.4455,3.4044,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.3923,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 234.5,57.114,6.3829,-999.25,-999.25,-999.25,7.875,-999.25,1836.3618,312.4004,3.4956,3.5332,2.7845,2.4407,3.3933,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.5137,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 235.0,63.5001,6.3839,-999.25,-999.25,-999.25,7.875,-999.25,1822.1597,324.6192,3.4956,3.5309,2.7845,2.4414,3.3933,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.7517,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 235.5,68.742,6.3788,-999.25,-999.25,-999.25,7.875,-999.25,1833.7235,320.8415,3.4963,3.5293,2.7853,2.4427,3.3678,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.8883,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 236.0,65.4594,6.3767,-999.25,-999.25,-999.25,7.875,-999.25,1836.2811,313.3994,3.4956,3.5309,2.7845,2.44,3.3766,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.1032,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 236.5,59.7495,6.3831,-999.25,-999.25,-999.25,7.875,-999.25,1860.1313,302.1414,3.4979,3.5309,2.7845,2.4407,3.3933,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.9908,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 237.0,56.5411,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1859.4435,315.7368,3.4924,3.5309,2.782,2.4421,3.4084,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.3432,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 237.5,58.7977,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1832.3467,338.2976,3.494,3.5324,2.7812,2.4421,3.4092,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.8869,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 238.0,67.9867,6.388,-999.25,-999.25,-999.25,7.875,-999.25,1843.589,266.9639,3.494,3.5324,2.7853,2.4394,3.4108,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3765,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 238.5,75.0772,6.388,-999.25,-999.25,-999.25,7.875,-999.25,1855.2559,279.8577,3.4932,3.5309,2.7837,2.44,3.4116,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4736,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 239.0,76.1015,6.3885,-999.25,-999.25,-999.25,7.875,-999.25,1879.255,10.9322,3.4932,3.5324,2.7837,2.4427,3.4108,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 239.5,72.042,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1872.7965,25.7968,3.4932,3.5301,2.7837,2.44,3.4116,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.2568,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 240.0,68.8277,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1860.0631,46.7443,3.4924,3.5301,2.7837,2.4414,3.41,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9714,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 240.5,65.4469,6.3883,-999.25,-999.25,-999.25,7.875,-999.25,1840.0208,45.5191,3.4932,3.5317,2.7845,2.4427,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.5267,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 241.0,58.5604,6.387,-999.25,-999.25,-999.25,7.875,-999.25,1835.0074,39.8067,3.494,3.5317,2.7837,2.4414,3.4076,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2287,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 241.5,50.9952,6.3861,-999.25,-999.25,-999.25,7.875,-999.25,1855.7611,37.3602,3.4932,3.5309,2.7853,2.4414,3.4068,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.0545,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 242.0,46.0223,6.3875,-999.25,-999.25,-999.25,7.875,-999.25,1846.3191,33.4709,3.4932,3.5324,2.7845,2.4407,3.4084,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.5457,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 242.5,40.603,6.3864,-999.25,-999.25,-999.25,7.875,-999.25,1842.4877,24.8165,3.4924,3.5309,2.7853,2.4394,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.0104,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 243.0,35.1612,6.3859,-999.25,-999.25,-999.25,7.875,-999.25,1836.6139,17.2191,3.4924,3.5309,2.7845,2.4407,3.4092,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.5535,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 243.5,31.1892,6.3875,-999.25,-999.25,-999.25,7.875,-999.25,1845.6996,20.7635,3.4916,3.5317,2.7853,2.4421,3.4092,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5614,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 244.0,27.2921,6.3856,-999.25,-999.25,-999.25,7.875,-999.25,1856.0703,25.8447,3.4924,3.5309,2.7829,2.4394,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.6755,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 244.5,25.5018,6.3875,-999.25,-999.25,-999.25,7.875,-999.25,1853.9249,19.3887,3.4924,3.5317,2.7845,2.44,3.4084,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.257,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 245.0,26.755,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1876.3064,42.0758,3.494,3.5317,2.7861,2.44,3.4084,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.4833,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 245.5,27.3795,6.3872,-999.25,-999.25,-999.25,7.875,-999.25,1854.5791,53.4658,3.4932,3.5317,2.7837,2.44,3.4084,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.7621,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 246.0,28.5453,6.386,-999.25,-999.25,-999.25,7.875,-999.25,1846.4794,41.2558,3.4924,3.5301,2.7837,2.44,3.4084,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,263.5841,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 246.5,29.7569,6.389,-999.25,-999.25,-999.25,7.875,-999.25,1846.1466,38.4951,3.4924,3.5324,2.7845,2.4407,3.41,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.0142,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 247.0,30.3815,6.3867,-999.25,-999.25,-999.25,7.875,-999.25,1846.8704,42.7926,3.4948,3.5317,2.7837,2.4407,3.4092,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,262.1503,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 247.5,31.5847,6.3858,-999.25,-999.25,-999.25,7.875,-999.25,1844.828,44.878,3.4924,3.5309,2.7845,2.44,3.4084,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.192,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 248.0,31.6472,6.3868,-999.25,-999.25,-999.25,7.875,-999.25,1842.2356,42.6005,3.4932,3.5301,2.7845,2.44,3.4084,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,263.3388,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 248.5,31.2808,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1865.9021,36.2868,3.4924,3.5309,2.7869,2.4387,3.41,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.9747,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 249.0,30.7429,6.3884,-999.25,-999.25,-999.25,7.875,-999.25,1847.1224,38.0025,3.4924,3.5309,2.7861,2.4407,3.4084,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.567,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 249.5,30.5322,6.3866,-999.25,-999.25,-999.25,7.875,-999.25,1859.569,47.2332,3.4924,3.5301,2.7845,2.4407,3.41,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,263.4321,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 250.0,32.539,6.3886,-999.25,-999.25,-999.25,7.875,-999.25,1867.4615,41.4392,3.4916,3.5301,2.7853,2.4414,3.41,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.4069,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 250.5,34.0029,6.388,-999.25,-999.25,-999.25,7.875,-999.25,1861.1296,31.3185,3.4932,3.5324,2.7845,2.4421,3.4092,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.9159,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 251.0,34.52,6.3886,-999.25,-999.25,-999.25,7.875,-999.25,1859.0077,18.783,3.4932,3.5332,2.7845,2.4414,3.41,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.1203,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 251.5,34.5242,6.3874,-999.25,-999.25,-999.25,7.875,-999.25,1842.1438,104.6267,3.4948,3.5301,2.7853,2.4394,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.2401,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 252.0,31.5348,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1856.896,96.3624,3.4924,3.5324,2.7853,2.44,3.4108,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.2691,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 252.5,29.2198,6.39,-999.25,-999.25,-999.25,7.875,-999.25,1837.5203,32.8376,3.4956,3.5317,2.7853,2.44,3.4108,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,265.1686,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 253.0,29.8027,6.3916,-999.25,-999.25,-999.25,7.875,-999.25,1849.1647,29.3106,3.4932,3.5324,2.7853,2.4407,3.4116,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,267.9788,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 253.5,30.1775,6.3887,-999.25,-999.25,-999.25,7.875,-999.25,1853.0533,32.2382,3.4932,3.5317,2.7845,2.4407,3.4092,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,269.4893,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 254.0,32.534,6.3927,-999.25,-999.25,-999.25,7.875,-999.25,1835.6616,41.8961,3.4932,3.5324,2.7845,2.4421,3.4108,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,269.9337,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 254.5,39.3706,6.3903,-999.25,-999.25,-999.25,7.875,-999.25,1845.4934,29.0134,3.494,3.534,2.7861,2.4414,3.41,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.7766,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 255.0,49.8886,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1846.0559,15.0721,3.494,3.5317,2.7861,2.4421,3.4116,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,269.451,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 255.5,56.7934,6.3871,-999.25,-999.25,-999.25,7.875,-999.25,1864.1354,22.2128,3.4924,3.5317,2.7845,2.4407,3.4092,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.0819,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 256.0,56.7984,6.3879,-999.25,-999.25,-999.25,7.875,-999.25,1851.309,27.6166,3.494,3.5317,2.7845,2.44,3.4108,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.087,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 256.5,59.528,6.3898,-999.25,-999.25,-999.25,7.875,-999.25,1862.8157,26.4375,3.494,3.5317,2.7861,2.4421,3.4116,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,271.317,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 257.0,66.1464,6.3887,-999.25,-999.25,-999.25,7.875,-999.25,1851.309,30.74,3.4948,3.5317,2.7853,2.4394,3.4123,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,268.0443,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 257.5,71.0844,6.3889,-999.25,-999.25,-999.25,7.875,-999.25,1847.5358,22.0914,3.4932,3.5309,2.7861,2.4421,3.4123,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,264.2143,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 258.0,70.8221,6.3907,-999.25,-999.25,-999.25,7.875,-999.25,1869.3549,26.0345,3.494,3.5324,2.7853,2.4407,3.4116,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.7289,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 258.5,68.8902,6.3895,-999.25,-999.25,-999.25,7.875,-999.25,1860.1313,33.9411,3.494,3.5317,2.7861,2.4441,3.4108,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.9917,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 259.0,71.5715,6.3884,-999.25,-999.25,-999.25,7.875,-999.25,1876.8004,24.4911,3.4932,3.5332,2.7845,2.4421,3.4108,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.2474,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 259.5,76.9217,6.3896,-999.25,-999.25,-999.25,7.875,-999.25,1855.4619,18.5837,3.4948,3.5324,2.7845,2.4427,3.4123,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.7178,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 260.0,77.9276,6.3898,-999.25,-999.25,-999.25,7.875,-999.25,1866.7513,19.7732,3.4956,3.5317,2.7853,2.4427,3.4116,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.5705,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 260.5,74.1438,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1877.0873,44.6837,3.4932,3.5309,2.7845,2.4427,3.4116,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.7969,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 261.0,73.4601,6.3898,-999.25,-999.25,-999.25,7.875,-999.25,1870.0663,33.2244,3.4948,3.5309,2.7853,2.4407,3.4123,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0289,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 261.5,72.7048,6.3918,-999.25,-999.25,-999.25,7.875,-999.25,1867.9893,358.3286,3.4948,3.5324,2.7869,2.4414,3.4123,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.3089,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 262.0,68.2232,6.3881,-999.25,-999.25,-999.25,7.875,-999.25,1878.6243,13.2682,3.494,3.5317,2.782,2.4414,3.4123,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.9237,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 262.5,62.5824,6.3907,-999.25,-999.25,-999.25,7.875,-999.25,1898.7573,21.4062,3.494,3.5309,2.7853,2.4421,3.4123,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.1431,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 263.0,49.538,6.3894,-999.25,-999.25,-999.25,7.875,-999.25,1862.9423,37.4689,3.4948,3.5309,2.7853,2.4421,3.4123,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.4412,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 263.5,35.7025,6.3904,-999.25,-999.25,-999.25,7.875,-999.25,1873.7711,57.4208,3.4963,3.5317,2.7845,2.4421,3.4139,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.6292,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 264.0,32.6872,6.3886,-999.25,-999.25,-999.25,7.875,-999.25,1875.5614,63.3481,3.4948,3.5317,2.7853,2.4421,3.4108,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.8835,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 264.5,35.9356,6.3882,-999.25,-999.25,-999.25,7.875,-999.25,1869.6641,47.6533,3.4956,3.5317,2.7845,2.44,3.4116,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.8189,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 265.0,37.8642,6.3904,-999.25,-999.25,-999.25,7.875,-999.25,1859.1108,65.5258,3.4963,3.5332,2.7853,2.4421,3.4123,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.0574,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 265.5,35.8607,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1856.6215,79.2987,3.4971,3.5317,2.7853,2.4407,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.0504,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 266.0,30.6604,6.3893,-999.25,-999.25,-999.25,7.875,-999.25,1881.9965,77.7924,3.4971,3.5317,2.7845,2.4421,3.4092,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.5148,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 266.5,27.8417,6.3909,-999.25,-999.25,-999.25,7.875,-999.25,1863.0453,77.6074,3.4971,3.5324,2.7837,2.4427,3.4147,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.772,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 267.0,27.5211,6.3894,-999.25,-999.25,-999.25,7.875,-999.25,1863.2056,62.0456,3.4971,3.5324,2.782,2.4421,3.4139,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.7583,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 267.5,27.1797,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1866.4869,63.1935,3.4971,3.5301,2.7845,2.4414,3.4139,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.0396,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 268.0,26.5851,6.39,-999.25,-999.25,-999.25,7.875,-999.25,1866.9003,111.112,3.4987,3.5309,2.7845,2.4414,3.4131,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3227,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 268.5,26.9424,6.3954,-999.25,-999.25,-999.25,7.875,-999.25,1871.7411,102.3563,3.4987,3.5317,2.7853,2.4427,3.4259,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.932,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 269.0,26.8541,6.3929,-999.25,-999.25,-999.25,7.875,-999.25,1873.2782,27.4071,3.4971,3.5309,2.7845,2.4421,3.4235,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.1235,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 269.5,24.923,6.3952,-999.25,-999.25,-999.25,7.875,-999.25,1895.0637,79.6656,3.4987,3.5324,2.7837,2.4407,3.4259,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.12,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 270.0,25.1729,6.3913,-999.25,-999.25,-999.25,7.875,-999.25,1875.3429,78.9316,3.4979,3.5309,2.7845,2.4407,3.4187,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.8458,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 270.5,27.0256,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1890.5432,76.7758,3.4979,3.5301,2.7829,2.4414,3.4179,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2723,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 271.0,28.8326,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1888.306,78.4888,3.4963,3.5309,2.7837,2.4414,3.4179,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.9546,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 271.5,29.9151,6.3912,-999.25,-999.25,-999.25,7.875,-999.25,1883.9592,78.8484,3.4979,3.5309,2.7829,2.4427,3.4171,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.5485,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 272.0,33.6041,6.3915,-999.25,-999.25,-999.25,7.875,-999.25,1883.752,81.9955,3.4971,3.5301,2.7853,2.4434,3.4179,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3513,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 272.5,43.4767,6.3918,-999.25,-999.25,-999.25,7.875,-999.25,1869.011,71.9665,3.4979,3.5317,2.7837,2.4421,3.4187,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.6299,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 273.0,56.6552,6.3959,-999.25,-999.25,-999.25,7.875,-999.25,1885.4615,72.6445,3.5003,3.5348,2.7861,2.4427,3.4219,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.7464,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 273.5,66.0923,6.3946,-999.25,-999.25,-999.25,7.875,-999.25,1880.8268,71.5644,3.4987,3.5324,2.7845,2.4427,3.4219,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.7805,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 274.0,70.8954,6.3947,-999.25,-999.25,-999.25,7.875,-999.25,1887.3549,71.6252,3.4979,3.5317,2.7853,2.4427,3.4211,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.3415,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 274.5,73.137,6.3929,-999.25,-999.25,-999.25,7.875,-999.25,1898.1837,65.4838,3.4971,3.5285,2.7861,2.4448,3.4195,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2083,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 275.0,72.7998,6.3942,-999.25,-999.25,-999.25,7.875,-999.25,1898.7461,65.2771,3.4987,3.5324,2.7853,2.4455,3.4195,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2931,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 275.5,71.2967,6.3982,-999.25,-999.25,-999.25,7.875,-999.25,1899.2738,61.0466,3.4979,3.5317,2.7869,2.4427,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.5364,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 276.0,64.4185,6.3948,-999.25,-999.25,-999.25,7.875,-999.25,1879.5071,59.8858,3.5003,3.5332,2.7829,2.4421,3.4211,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.7911,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 276.5,54.1845,6.3969,-999.25,-999.25,-999.25,7.875,-999.25,1897.0018,60.8225,3.4995,3.5324,2.7837,2.4448,3.4187,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.8492,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 277.0,45.0205,6.3925,-999.25,-999.25,-999.25,7.875,-999.25,1871.684,59.0737,3.4987,3.5317,2.7829,2.4414,3.4203,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.651,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 277.5,37.855,6.3923,-999.25,-999.25,-999.25,7.875,-999.25,1867.4392,59.9935,3.4979,3.5301,2.7845,2.4414,3.4203,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3284,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 278.0,35.2445,6.3936,-999.25,-999.25,-999.25,7.875,-999.25,1878.5325,56.4958,3.4987,3.5317,2.7861,2.4414,3.4195,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.5575,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 278.5,33.3617,6.3949,-999.25,-999.25,-999.25,7.875,-999.25,1870.8113,55.3555,3.4979,3.5301,2.7853,2.4441,3.4211,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.6742,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 279.0,31.7163,6.3913,-999.25,-999.25,-999.25,7.875,-999.25,1863.229,51.8681,3.4987,3.5293,2.782,2.4414,3.4203,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.6593,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 279.5,32.5931,6.3944,-999.25,-999.25,-999.25,7.875,-999.25,1859.9824,46.5178,3.4995,3.5317,2.7853,2.4414,3.4187,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,262.3817,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 280.0,32.977,6.3909,-999.25,-999.25,-999.25,7.875,-999.25,1868.9874,51.3423,3.4987,3.5317,2.7837,2.4427,3.4139,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.7359,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 280.5,31.693,6.3928,-999.25,-999.25,-999.25,7.875,-999.25,1847.0305,45.2968,3.4995,3.5324,2.7877,2.4414,3.4147,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.5796,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 281.0,31.0851,6.3918,-999.25,-999.25,-999.25,7.875,-999.25,1833.5162,49.7881,3.4979,3.5309,2.7845,2.4427,3.4195,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.442,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 281.5,33.4375,6.3903,-999.25,-999.25,-999.25,7.875,-999.25,1843.589,44.7651,3.4987,3.5309,2.7837,2.4407,3.4163,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.8537,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 282.0,36.0606,6.3911,-999.25,-999.25,-999.25,7.875,-999.25,1846.3539,44.0637,3.4995,3.5309,2.7837,2.4407,3.4171,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.4494,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 282.5,36.4619,6.3911,-999.25,-999.25,-999.25,7.875,-999.25,1861.6001,54.5953,3.4987,3.5301,2.7829,2.4414,3.4195,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.0573,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 283.0,34.8906,6.3946,-999.25,-999.25,-999.25,7.875,-999.25,1871.5115,51.4049,3.5003,3.5309,2.7853,2.4448,3.4219,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.8024,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 283.5,34.0204,6.3905,-999.25,-999.25,-999.25,7.875,-999.25,1900.0647,46.9541,3.4995,3.5324,2.7853,2.4434,3.4108,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.4708,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 284.0,36.0148,6.3911,-999.25,-999.25,-999.25,7.875,-999.25,1881.1024,43.0431,3.5003,3.5309,2.7845,2.4455,3.4108,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.459,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 284.5,39.2407,6.3894,-999.25,-999.25,-999.25,7.875,-999.25,1877.2474,18.1031,3.5003,3.5324,2.7829,2.4427,3.4092,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.6075,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 285.0,39.4755,6.3899,-999.25,-999.25,-999.25,7.875,-999.25,1882.2036,63.623,3.4995,3.5317,2.7845,2.4434,3.4108,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.3975,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 285.5,35.0405,6.3896,-999.25,-999.25,-999.25,7.875,-999.25,1864.0659,64.9861,3.5003,3.5309,2.7845,2.4441,3.4092,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.1855,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 286.0,31.0152,6.3901,-999.25,-999.25,-999.25,7.875,-999.25,1875.0337,41.1133,3.5003,3.5309,2.7853,2.4427,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.7831,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 286.5,30.1741,6.3914,-999.25,-999.25,-999.25,7.875,-999.25,1853.7075,39.3966,3.5003,3.5332,2.7845,2.4448,3.4108,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3805,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 287.0,29.1016,6.39,-999.25,-999.25,-999.25,7.875,-999.25,1885.8625,18.3977,3.4995,3.5332,2.7845,2.4427,3.41,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2365,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 287.5,25.7016,6.3917,-999.25,-999.25,-999.25,7.875,-999.25,1889.3165,8.2592,3.501,3.5348,2.7845,2.4441,3.41,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.7162,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 288.0,24.296,6.3932,-999.25,-999.25,-999.25,7.875,-999.25,1901.0629,36.8948,3.501,3.5356,2.7861,2.4448,3.4108,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.3287,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 288.5,24.107,6.3945,-999.25,-999.25,-999.25,7.875,-999.25,1889.3501,36.8194,3.5026,3.5419,2.7837,2.4441,3.41,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.7305,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 289.0,22.9728,6.3981,-999.25,-999.25,-999.25,7.875,-999.25,1887.6069,33.2751,3.5018,3.5538,2.7845,2.4434,3.4108,3.5,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.173,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 289.5,22.1543,6.3975,-999.25,-999.25,-999.25,7.875,-999.25,1885.932,27.9059,3.501,3.5522,2.7837,2.4427,3.4108,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.0155,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 290.0,22.6373,6.3983,-999.25,-999.25,-999.25,7.875,-999.25,1863.4464,27.4666,3.501,3.5554,2.7845,2.4441,3.4092,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.5748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 290.5,23.579,6.3962,-999.25,-999.25,-999.25,7.875,-999.25,1870.399,23.5099,3.5003,3.5498,2.7845,2.4441,3.4092,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.6747,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 291.0,24.2635,6.3963,-999.25,-999.25,-999.25,7.875,-999.25,1856.002,25.4717,3.5003,3.5498,2.7853,2.4427,3.41,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.9031,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 291.5,24.6682,6.3967,-999.25,-999.25,-999.25,7.875,-999.25,1882.616,32.334,3.5003,3.5514,2.7837,2.4434,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.6935,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 292.0,24.7831,6.3982,-999.25,-999.25,-999.25,7.875,-999.25,1896.4518,21.364,3.501,3.5538,2.7837,2.4427,3.41,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.0754,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 292.5,23.9904,6.3971,-999.25,-999.25,-999.25,7.875,-999.25,1853.7075,13.1927,3.4995,3.549,2.7853,2.4455,3.4108,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.6069,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 293.0,23.9155,6.4004,-999.25,-999.25,-999.25,7.875,-999.25,1854.9467,12.4639,3.5018,3.553,2.7853,2.4434,3.4116,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.6968,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 293.5,26.3162,6.399,-999.25,-999.25,-999.25,7.875,-999.25,1852.2736,42.5385,3.5018,3.5506,2.7861,2.4434,3.4116,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3719,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 294.0,28.8168,6.3974,-999.25,-999.25,-999.25,7.875,-999.25,1857.0797,42.2723,3.5003,3.5498,2.7861,2.4448,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0908,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 294.5,33.7173,6.3935,-999.25,-999.25,-999.25,7.875,-999.25,1868.9191,11.5583,3.501,3.5396,2.7845,2.4441,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.6105,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 295.0,42.9346,6.3916,-999.25,-999.25,-999.25,7.875,-999.25,1910.4813,10.3115,3.4995,3.5324,2.7853,2.4448,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.0811,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 295.5,55.79,6.3925,-999.25,-999.25,-999.25,7.875,-999.25,1913.4535,19.3097,3.4995,3.5332,2.7861,2.4455,3.41,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.0234,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 296.0,65.6426,6.3927,-999.25,-999.25,-999.25,7.875,-999.25,1872.5555,16.7147,3.4995,3.534,2.7845,2.4461,3.41,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.4052,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 296.5,68.9093,6.392,-999.25,-999.25,-999.25,7.875,-999.25,1862.4258,19.6058,3.4995,3.534,2.7853,2.4461,3.4092,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0405,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 297.0,67.5345,6.3929,-999.25,-999.25,-999.25,7.875,-999.25,1857.3206,14.7548,3.5003,3.5324,2.7853,2.4461,3.4092,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.3478,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 297.5,62.0953,6.392,-999.25,-999.25,-999.25,7.875,-999.25,1885.7708,19.2852,3.5003,3.534,2.7845,2.4448,3.4092,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.4025,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 298.0,54.5018,6.3927,-999.25,-999.25,-999.25,7.875,-999.25,1904.1841,2.7021,3.5003,3.5356,2.7845,2.4441,3.4116,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1549,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 298.5,46.1405,6.399,-999.25,-999.25,-999.25,7.875,-999.25,1901.8438,353.2787,3.5003,3.5506,2.7861,2.4448,3.4076,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.1192,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 299.0,37.7418,6.3973,-999.25,-999.25,-999.25,7.875,-999.25,1905.2618,351.9615,3.5003,3.5498,2.7845,2.4448,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.6962,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 299.5,32.3825,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1892.0007,1.838,3.5003,3.5514,2.7853,2.4475,3.4123,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.861,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 300.0,30.0084,6.3991,-999.25,-999.25,-999.25,7.875,-999.25,1898.6431,3.2733,3.501,3.549,2.7845,2.4468,3.4076,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.5373,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 300.5,29.2257,6.3974,-999.25,-999.25,-999.25,7.875,-999.25,1888.2836,351.4914,3.4979,3.5514,2.7853,2.4461,3.41,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2762,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 301.0,29.6429,6.3963,-999.25,-999.25,-999.25,7.875,-999.25,1904.2412,347.1812,3.4995,3.549,2.7837,2.4448,3.4092,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.0895,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 301.5,30.1933,6.3977,-999.25,-999.25,-999.25,7.875,-999.25,1865.0989,344.9035,3.5003,3.553,2.7845,2.4448,3.4092,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.7056,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 302.0,30.6604,6.3959,-999.25,-999.25,-999.25,7.875,-999.25,1870.2612,343.6803,3.4995,3.5498,2.7845,2.4434,3.4092,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9276,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 302.5,31.265,6.3962,-999.25,-999.25,-999.25,7.875,-999.25,1880.3215,351.2224,3.5018,3.549,2.7837,2.4434,3.41,3.5007,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4155,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 303.0,28.7202,6.3974,-999.25,-999.25,-999.25,7.875,-999.25,1892.3794,0.659,3.5003,3.5514,2.7845,2.4427,3.4092,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.9619,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 303.5,25.9723,6.3975,-999.25,-999.25,-999.25,7.875,-999.25,1901.0752,10.8744,3.5018,3.5514,2.7837,2.4421,3.4116,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.9433,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 304.0,26.934,6.4,-999.25,-999.25,-999.25,7.875,-999.25,1878.2915,355.8833,3.501,3.553,2.7861,2.4421,3.4116,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.7635,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 304.5,27.3912,6.3907,-999.25,-999.25,-999.25,7.875,-999.25,1886.6659,354.0739,3.501,3.5317,2.7853,2.4407,3.4108,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5342,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 305.0,28.5378,6.3916,-999.25,-999.25,-999.25,7.875,-999.25,1880.4594,353.8504,3.5003,3.5324,2.7853,2.4414,3.4108,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.3403,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 305.5,31.6022,6.3911,-999.25,-999.25,-999.25,7.875,-999.25,1887.515,353.7608,3.4995,3.5332,2.7845,2.4414,3.4108,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9035,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 306.0,35.3394,6.3892,-999.25,-999.25,-999.25,7.875,-999.25,1907.7971,353.0362,3.4987,3.5309,2.7845,2.4394,3.4108,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.207,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 306.5,36.5144,6.3911,-999.25,-999.25,-999.25,7.875,-999.25,1907.6134,352.7445,3.5018,3.5317,2.7837,2.44,3.41,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.5954,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 307.0,33.1252,6.3895,-999.25,-999.25,-999.25,7.875,-999.25,1904.3331,356.2953,3.4995,3.5317,2.7845,2.438,3.4116,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.1492,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 307.5,29.9485,6.3917,-999.25,-999.25,-999.25,7.875,-999.25,1898.1949,354.6979,3.501,3.5332,2.7845,2.4407,3.4116,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.0211,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 308.0,28.4546,6.3967,-999.25,-999.25,-999.25,7.875,-999.25,1915.5978,354.5491,3.5018,3.5419,2.7837,2.4394,3.4084,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.0265,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 308.5,26.8633,6.3934,-999.25,-999.25,-999.25,7.875,-999.25,1904.5392,353.1131,3.501,3.5427,2.7845,2.44,3.4092,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.1701,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 309.0,24.6982,6.3991,-999.25,-999.25,-999.25,7.875,-999.25,1895.5342,352.0454,3.5026,3.5419,2.7853,2.44,3.4123,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.2037,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 309.5,23.445,6.395,-999.25,-999.25,-999.25,7.875,-999.25,1915.6897,354.9914,3.4987,3.5443,2.7837,2.4407,3.4163,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.7442,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 310.0,25.0063,6.3962,-999.25,-999.25,-999.25,7.875,-999.25,1902.6011,3.7465,3.5003,3.5443,2.7845,2.44,3.4147,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.7016,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 310.5,27.7043,6.3962,-999.25,-999.25,-999.25,7.875,-999.25,1912.4553,20.4935,3.5003,3.5435,2.7861,2.44,3.4139,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.2327,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 311.0,27.8917,6.3955,-999.25,-999.25,-999.25,7.875,-999.25,1879.4041,4.3407,3.5003,3.5427,2.7837,2.44,3.4163,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.9937,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 311.5,28.9034,6.3952,-999.25,-999.25,-999.25,7.875,-999.25,1896.3711,312.9419,3.4995,3.5419,2.7837,2.4407,3.4171,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,266.1373,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 312.0,33.4833,6.3961,-999.25,-999.25,-999.25,7.875,-999.25,1901.017,324.9871,3.5003,3.5443,2.7845,2.4394,3.4171,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,261.477,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 312.5,38.7918,6.3953,-999.25,-999.25,-999.25,7.875,-999.25,1883.7979,349.6727,3.5003,3.5427,2.7837,2.44,3.4171,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.3762,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 313.0,43.1969,6.3973,-999.25,-999.25,-999.25,7.875,-999.25,1881.3892,348.1354,3.501,3.5443,2.7829,2.4407,3.4195,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.2426,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 313.5,45.7283,6.3958,-999.25,-999.25,-999.25,7.875,-999.25,1892.8152,343.7911,3.4995,3.5443,2.7837,2.44,3.4187,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.6797,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 314.0,43.7548,6.3965,-999.25,-999.25,-999.25,7.875,-999.25,1907.3848,346.5244,3.501,3.5435,2.7837,2.4387,3.4171,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.402,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 314.5,36.3811,6.3967,-999.25,-999.25,-999.25,7.875,-999.25,1891.7935,350.6864,3.501,3.5451,2.7845,2.4394,3.4187,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.8042,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 315.0,32.0177,6.3986,-999.25,-999.25,-999.25,7.875,-999.25,1898.6431,6.0508,3.501,3.5467,2.7861,2.4414,3.4171,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5871,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 315.5,31.3224,6.3976,-999.25,-999.25,-999.25,7.875,-999.25,1900.7302,357.093,3.4995,3.5443,2.7861,2.44,3.4203,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.4195,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 316.0,29.1241,6.3984,-999.25,-999.25,-999.25,7.875,-999.25,1886.9874,337.6617,3.5018,3.5467,2.7837,2.4407,3.4195,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.8147,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 316.5,27.2297,6.3996,-999.25,-999.25,-999.25,7.875,-999.25,1897.7367,351.1794,3.5003,3.5459,2.7853,2.4427,3.4211,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.9254,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 317.0,28.2789,6.3966,-999.25,-999.25,-999.25,7.875,-999.25,1900.8802,0.8872,3.5003,3.5467,2.7845,2.4407,3.4155,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.8745,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 317.5,30.5397,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,1915.0129,8.804,3.501,3.5467,2.7845,2.4407,3.4155,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,260.2255,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 318.0,31.6514,6.3989,-999.25,-999.25,-999.25,7.875,-999.25,1900.5812,6.265,3.5018,3.5467,2.7845,2.4407,3.4163,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5572,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 318.5,32.151,6.3989,-999.25,-999.25,-999.25,7.875,-999.25,1917.7207,358.3228,3.5026,3.5467,2.7845,2.4407,3.4155,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.3153,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 319.0,32.126,6.3972,-999.25,-999.25,-999.25,7.875,-999.25,1910.8835,355.8642,3.5003,3.5459,2.7845,2.4427,3.4155,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.063,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 319.5,30.7554,6.3978,-999.25,-999.25,-999.25,7.875,-999.25,1906.7529,3.3524,3.5018,3.5483,2.7845,2.4421,3.4139,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.5977,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 320.0,27.9341,6.397,-999.25,-999.25,-999.25,7.875,-999.25,1912.2604,5.4883,3.4995,3.5467,2.7861,2.4414,3.4147,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,259.9675,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 320.5,26.5069,6.4025,-999.25,-999.25,-999.25,7.875,-999.25,1909.2086,7.5052,3.501,3.5601,2.7853,2.4414,3.4155,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,258.9019,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 321.0,26.8441,6.4002,-999.25,-999.25,-999.25,7.875,-999.25,1935.2267,6.4704,3.501,3.549,2.7861,2.4407,3.4147,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 321.5,25.9306,6.3991,-999.25,-999.25,-999.25,7.875,-999.25,1904.1382,1.8181,3.5018,3.5506,2.7853,2.4407,3.4147,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.7544,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 322.0,25.8823,6.3987,-999.25,-999.25,-999.25,7.875,-999.25,1909.0361,8.959,3.5003,3.5498,2.7837,2.4407,3.4155,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.8154,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 322.5,28.965,6.3997,-999.25,-999.25,-999.25,7.875,-999.25,1920.3367,5.9602,3.5003,3.5522,2.7845,2.4407,3.4147,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.2224,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 323.0,33.9413,6.3983,-999.25,-999.25,-999.25,7.875,-999.25,1919.958,9.9663,3.5018,3.549,2.7845,2.4407,3.4147,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.6395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 323.5,42.4558,6.398,-999.25,-999.25,-999.25,7.875,-999.25,1898.8492,20.0117,3.501,3.5498,2.7845,2.4427,3.4131,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.5482,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 324.0,52.1818,6.3988,-999.25,-999.25,-999.25,7.875,-999.25,1876.0779,24.7461,3.5018,3.549,2.7853,2.44,3.4147,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.3328,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 324.5,56.0348,6.3971,-999.25,-999.25,-999.25,7.875,-999.25,1909.0709,21.5074,3.501,3.5506,2.7845,2.44,3.4123,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2547,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 325.0,53.5042,6.4041,-999.25,-999.25,-999.25,7.875,-999.25,1891.7935,21.8073,3.5018,3.5641,2.7837,2.4414,3.4139,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.7956,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 325.5,42.9338,6.3987,-999.25,-999.25,-999.25,7.875,-999.25,1896.8651,25.5348,3.5003,3.549,2.7845,2.44,3.4155,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.9542,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 326.0,32.4841,6.3982,-999.25,-999.25,-999.25,7.875,-999.25,1889.0062,41.7745,3.5003,3.5483,2.7845,2.44,3.4139,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.5588,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 326.5,30.6829,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,1888.9031,68.4194,3.5018,3.549,2.7845,2.4407,3.4259,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.965,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 327.0,34.0762,6.4017,-999.25,-999.25,-999.25,7.875,-999.25,1909.92,49.5376,3.5003,3.5506,2.7853,2.4414,3.4235,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.6107,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 327.5,44.6683,6.4006,-999.25,-999.25,-999.25,7.875,-999.25,1897.8398,6.1333,3.5003,3.549,2.7837,2.4394,3.4227,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.4057,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 328.0,56.7992,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,1915.8969,13.7465,3.5018,3.549,2.7853,2.44,3.4227,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.3025,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 328.5,62.953,6.4006,-999.25,-999.25,-999.25,7.875,-999.25,1904.1718,51.5017,3.501,3.5514,2.7845,2.4387,3.4227,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.3398,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 329.0,62.8114,6.4017,-999.25,-999.25,-999.25,7.875,-999.25,1904.6534,43.4907,3.5003,3.5498,2.7853,2.44,3.4243,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.9204,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 329.5,59.8753,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1912.9707,52.1868,3.5026,3.5483,2.7829,2.4394,3.4251,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.3801,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 330.0,62.1128,6.4002,-999.25,-999.25,-999.25,7.875,-999.25,1926.9442,44.863,3.5003,3.5483,2.7853,2.4394,3.4235,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.7303,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 330.5,64.6983,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,1931.4983,48.6998,3.5003,3.5475,2.7853,2.4421,3.4243,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0031,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 331.0,63.7057,6.403,-999.25,-999.25,-999.25,7.875,-999.25,1919.3497,49.2673,3.501,3.5506,2.7861,2.44,3.4259,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.101,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 331.5,65.4086,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,1929.3529,46.2789,3.5018,3.5475,2.7861,2.44,3.4243,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.0085,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 332.0,67.3538,6.3973,-999.25,-999.25,-999.25,7.875,-999.25,1941.7424,47.944,3.5018,3.5388,2.7845,2.44,3.4235,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.2372,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 332.5,66.8675,6.3976,-999.25,-999.25,-999.25,7.875,-999.25,1954.7065,44.7218,3.501,3.5388,2.7837,2.4407,3.4219,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.1143,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 333.0,64.1812,6.3971,-999.25,-999.25,-999.25,7.875,-999.25,1935.5594,48.1088,3.5026,3.5364,2.7845,2.4394,3.4251,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.5282,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 333.5,57.2655,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,1922.9291,46.1932,3.501,3.549,2.7845,2.4414,3.4235,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.0211,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 334.0,49.2715,6.398,-999.25,-999.25,-999.25,7.875,-999.25,1947.5479,52.1917,3.5003,3.5403,2.7845,2.4394,3.4235,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 334.5,46.5152,6.4029,-999.25,-999.25,-999.25,7.875,-999.25,1926.9554,56.2491,3.5003,3.5546,2.7853,2.4407,3.4211,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.1689,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 335.0,49.13,6.4024,-999.25,-999.25,-999.25,7.875,-999.25,1932.6567,63.2939,3.4987,3.5577,2.7853,2.4414,3.4187,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.6988,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 335.5,53.5342,6.4011,-999.25,-999.25,-999.25,7.875,-999.25,1920.2784,52.5984,3.501,3.549,2.7845,2.4414,3.4219,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.0426,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 336.0,61.1518,6.404,-999.25,-999.25,-999.25,7.875,-999.25,1938.0599,15.0005,3.4995,3.5601,2.7845,2.4394,3.4219,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.0792,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 336.5,69.3498,6.4035,-999.25,-999.25,-999.25,7.875,-999.25,1925.005,25.8017,3.5018,3.5514,2.7845,2.4407,3.4259,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.2156,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 337.0,72.1494,6.405,-999.25,-999.25,-999.25,7.875,-999.25,1924.7294,74.0392,3.5018,3.5569,2.7853,2.4414,3.4227,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.3559,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 337.5,69.8844,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,1933.7703,77.3077,3.5018,3.5475,2.7853,2.4421,3.4211,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.08,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 338.0,67.7485,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,1887.8242,72.4522,3.5018,3.5483,2.7853,2.4421,3.4235,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.9891,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 338.5,70.0102,6.4011,-999.25,-999.25,-999.25,7.875,-999.25,1911.9388,57.955,3.5003,3.549,2.7869,2.4394,3.4243,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.9521,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 339.0,71.7172,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,1919.6018,57.7833,3.5026,3.549,2.7837,2.4394,3.4251,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.818,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 339.5,68.9485,6.4046,-999.25,-999.25,-999.25,7.875,-999.25,1927.2422,67.8708,3.5003,3.5514,2.7853,2.44,3.4251,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.4675,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 340.0,64.0438,6.4007,-999.25,-999.25,-999.25,7.875,-999.25,1911.595,87.3848,3.5018,3.5475,2.7837,2.44,3.4243,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.831,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 340.5,57.6611,6.4038,-999.25,-999.25,-999.25,7.875,-999.25,1932.2097,74.0294,3.501,3.5483,2.7861,2.4407,3.4243,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.7098,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 341.0,55.0089,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,1945.8954,85.1258,3.5026,3.549,2.7853,2.4427,3.4235,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.713,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 341.5,54.1962,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1927.2534,87.933,3.5018,3.5483,2.7861,2.4407,3.4227,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.854,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 342.0,53.9888,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1932.7721,69.8791,3.5026,3.5459,2.7861,2.4421,3.4235,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.3157,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 342.5,61.1343,6.4002,-999.25,-999.25,-999.25,7.875,-999.25,1937.5099,67.3825,3.5018,3.5459,2.7845,2.4414,3.4235,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.5861,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 343.0,69.4856,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,1951.3793,67.1469,3.501,3.5451,2.7861,2.4434,3.4211,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.1333,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 343.5,72.7581,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,1939.0245,71.6469,3.5042,3.5451,2.7845,2.4421,3.4267,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.2448,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 344.0,73.2245,6.3996,-999.25,-999.25,-999.25,7.875,-999.25,1920.405,35.8395,3.5026,3.5388,2.7845,2.4414,3.4267,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.0881,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 344.5,66.0365,6.3988,-999.25,-999.25,-999.25,7.875,-999.25,1950.0371,26.8842,3.5034,3.538,2.7853,2.4421,3.4251,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,255.3695,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 345.0,49.6021,6.3978,-999.25,-999.25,-999.25,7.875,-999.25,1950.9199,42.6728,3.501,3.5356,2.7853,2.4407,3.4259,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.6673,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 345.5,33.699,6.3967,-999.25,-999.25,-999.25,7.875,-999.25,1967.8298,44.3673,3.501,3.5348,2.7837,2.4414,3.4243,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,252.9957,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 346.0,26.6834,6.3969,-999.25,-999.25,-999.25,7.875,-999.25,1956.6682,44.7015,3.501,3.5356,2.7845,2.44,3.4282,3.5014,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.2115,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 346.5,25.232,6.4004,-999.25,-999.25,-999.25,7.875,-999.25,1950.6332,51.925,3.5018,3.5372,2.7853,2.4421,3.4306,3.5041,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0375,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 347.0,24.1936,6.397,-999.25,-999.25,-999.25,7.875,-999.25,1958.2277,63.8662,3.501,3.534,2.7853,2.4421,3.4251,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.4412,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 347.5,22.6722,6.3967,-999.25,-999.25,-999.25,7.875,-999.25,1939.5398,74.6197,3.5026,3.5324,2.7853,2.4421,3.4251,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.3047,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 348.0,21.5506,6.3973,-999.25,-999.25,-999.25,7.875,-999.25,1936.0983,42.4298,3.501,3.534,2.7853,2.4414,3.4267,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.4485,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 348.5,19.8277,6.3991,-999.25,-999.25,-999.25,7.875,-999.25,1944.0144,35.1649,3.505,3.5332,2.7845,2.4407,3.4243,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.7712,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 349.0,17.372,6.401,-999.25,-999.25,-999.25,7.875,-999.25,1956.1282,39.1484,3.5018,3.5332,2.7853,2.4434,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.9799,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 349.5,17.7925,6.3993,-999.25,-999.25,-999.25,7.875,-999.25,1931.3381,38.9538,3.5026,3.5348,2.7845,2.4407,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.2745,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 350.0,21.5023,6.4065,-999.25,-999.25,-999.25,7.875,-999.25,1933.3221,134.6852,3.4995,3.5562,2.7845,2.4394,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.2752,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 350.5,29.1715,6.3953,-999.25,-999.25,-999.25,7.875,-999.25,1937.9803,142.2417,3.5018,3.5554,2.7853,2.4427,3.3933,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.1432,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 351.0,35.67,6.4046,-999.25,-999.25,-999.25,7.875,-999.25,1940.9626,148.5359,3.501,3.5577,2.7853,2.4421,3.4243,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.584,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 351.5,34.9256,6.403,-999.25,-999.25,-999.25,7.875,-999.25,1963.3564,96.118,3.5026,3.5506,2.7869,2.4421,3.4235,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.482,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 352.0,33.0461,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,1931.0513,251.981,3.5018,3.5506,2.7845,2.4427,3.4227,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.87,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 352.5,35.5884,6.4023,-999.25,-999.25,-999.25,7.875,-999.25,1922.6993,311.0535,3.5026,3.5475,2.7845,2.4434,3.4235,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.022,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 353.0,41.2767,6.4035,-999.25,-999.25,-999.25,7.875,-999.25,1933.2538,327.5666,3.5018,3.5467,2.7861,2.4427,3.4251,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.2301,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 353.5,51.2101,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,1935.3868,211.5468,3.501,3.5483,2.7853,2.4448,3.4227,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.9295,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 354.0,59.9352,6.4029,-999.25,-999.25,-999.25,7.875,-999.25,1932.4158,261.1294,3.505,3.5435,2.7845,2.4427,3.4235,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.4479,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 354.5,64.9406,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1923.7087,271.7668,3.5042,3.5427,2.7853,2.4421,3.4219,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.7545,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 355.0,67.2164,6.4032,-999.25,-999.25,-999.25,7.875,-999.25,1944.5184,292.7158,3.5034,3.5435,2.7869,2.4427,3.4235,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.9245,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 355.5,60.3691,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,1952.4805,195.464,3.5026,3.5419,2.7853,2.4421,3.4251,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.0853,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 356.0,49.6221,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,1953.6277,199.0229,3.5026,3.5435,2.7845,2.4421,3.4251,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.6192,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 356.5,43.9155,6.4008,-999.25,-999.25,-999.25,7.875,-999.25,1961.3824,211.6839,3.5026,3.5435,2.7853,2.4421,3.4235,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.1924,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 357.0,41.897,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,1984.4753,213.0784,3.5042,3.5419,2.7845,2.4414,3.4227,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.2266,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 357.5,44.625,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1984.3152,203.6343,3.5034,3.5427,2.7845,2.4427,3.4219,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.2511,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 358.0,50.9453,6.3983,-999.25,-999.25,-999.25,7.875,-999.25,1953.0428,193.5166,3.5034,3.5427,2.782,2.4421,3.4227,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.8742,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 358.5,56.7992,6.3968,-999.25,-999.25,-999.25,7.875,-999.25,1949.785,188.7472,3.5026,3.5411,2.7845,2.4407,3.4179,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.4565,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 359.0,61.8163,6.3975,-999.25,-999.25,-999.25,7.875,-999.25,1916.0223,173.0087,3.5026,3.5419,2.7853,2.4421,3.4171,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.9572,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 359.5,64.0413,6.3978,-999.25,-999.25,-999.25,7.875,-999.25,1925.4531,170.3333,3.5042,3.5419,2.7869,2.4414,3.4163,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.5657,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 360.0,63.4967,6.3949,-999.25,-999.25,-999.25,7.875,-999.25,1922.8596,185.5841,3.5018,3.5411,2.7837,2.4407,3.4147,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0841,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 360.5,62.0062,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1937.6129,181.6277,3.5026,3.5419,2.7829,2.4421,3.4203,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.6691,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 361.0,59.6488,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1939.1388,192.6434,3.5034,3.5483,2.7845,2.4414,3.4147,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.1166,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 361.5,54.1679,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,1920.6346,228.4138,3.5018,3.5554,2.7853,2.4407,3.4171,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.0562,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 362.0,44.8165,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1916.1489,209.0071,3.5018,3.5498,2.7837,2.4414,3.4171,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.6206,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 362.5,32.4174,6.4011,-999.25,-999.25,-999.25,7.875,-999.25,1906.8572,170.1148,3.5018,3.5514,2.7853,2.4421,3.4171,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.5937,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 363.0,24.3318,6.4007,-999.25,-999.25,-999.25,7.875,-999.25,1929.7775,150.73,3.5026,3.5538,2.7845,2.4421,3.4131,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.5882,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 363.5,23.4242,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,1946.7222,140.4949,3.5042,3.5506,2.7853,2.4434,3.4123,3.5034,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.4078,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 364.0,29.7528,6.4003,-999.25,-999.25,-999.25,7.875,-999.25,1950.129,136.302,3.5026,3.5522,2.7853,2.4414,3.4131,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.0423,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 364.5,38.2481,6.4022,-999.25,-999.25,-999.25,7.875,-999.25,1946.8711,130.7231,3.5034,3.5546,2.7845,2.4421,3.4131,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.1442,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 365.0,39.5313,6.4011,-999.25,-999.25,-999.25,7.875,-999.25,1903.1052,129.9608,3.5034,3.5546,2.7853,2.4434,3.4139,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.8679,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 365.5,32.7455,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,1915.9764,128.9801,3.5026,3.5546,2.7861,2.4427,3.4131,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.6472,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 366.0,24.0279,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1932.6107,132.3339,3.5026,3.5506,2.7861,2.4441,3.4139,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.6458,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 366.5,19.9926,6.4001,-999.25,-999.25,-999.25,7.875,-999.25,1959.5934,130.1281,3.5026,3.5522,2.7853,2.4434,3.4108,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.1987,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 367.0,18.7418,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,1957.7919,128.8356,3.5018,3.5585,2.7877,2.4434,3.41,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.2285,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 367.5,17.6035,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,1967.9677,130.1034,3.5034,3.5601,2.7853,2.4427,3.4108,3.5021,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.4985,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 368.0,18.2405,6.3997,-999.25,-999.25,-999.25,7.875,-999.25,1989.8326,133.5857,3.5042,3.5498,2.7837,2.4427,3.4131,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.7582,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 368.5,21.2283,6.3953,-999.25,-999.25,-999.25,7.875,-999.25,1974.2313,125.5726,3.5034,3.538,2.7853,2.4441,3.4123,3.5027,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.4525,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 369.0,24.2036,6.3964,-999.25,-999.25,-999.25,7.875,-999.25,1962.4838,113.225,3.5026,3.5396,2.7853,2.4434,3.4108,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.1421,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 369.5,22.2809,6.3959,-999.25,-999.25,-999.25,7.875,-999.25,1965.3977,144.4716,3.5042,3.5396,2.7837,2.4434,3.4108,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.6483,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 370.0,20.5963,6.3951,-999.25,-999.25,-999.25,7.875,-999.25,2003.6908,161.5509,3.5026,3.5372,2.7837,2.4441,3.4123,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.5402,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 370.5,24.2061,6.3968,-999.25,-999.25,-999.25,7.875,-999.25,1990.3615,120.5151,3.5042,3.5372,2.7845,2.4441,3.4116,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.8837,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 371.0,31.7946,6.3989,-999.25,-999.25,-999.25,7.875,-999.25,1974.8967,133.8256,3.501,3.538,2.7853,2.4434,3.4179,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.4688,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 371.5,38.0849,6.398,-999.25,-999.25,-999.25,7.875,-999.25,1966.1202,139.1134,3.5042,3.5372,2.7837,2.4414,3.4227,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.8805,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 372.0,39.3523,6.4019,-999.25,-999.25,-999.25,7.875,-999.25,1941.7659,129.7759,3.5042,3.5388,2.7845,2.4448,3.4219,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.5451,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 372.5,39.4997,6.399,-999.25,-999.25,-999.25,7.875,-999.25,1962.542,131.6518,3.5026,3.5388,2.7845,2.4427,3.4235,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.7471,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 373.0,45.6242,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,1950.0483,131.2842,3.5042,3.5403,2.7845,2.4448,3.4227,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.6781,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 373.5,55.2004,6.3981,-999.25,-999.25,-999.25,7.875,-999.25,1982.7893,127.1496,3.5034,3.538,2.7829,2.4427,3.4227,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.5225,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 374.0,64.0063,6.4006,-999.25,-999.25,-999.25,7.875,-999.25,1971.6613,132.6561,3.5034,3.5388,2.7845,2.4427,3.4235,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.1855,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 374.5,68.7253,6.3996,-999.25,-999.25,-999.25,7.875,-999.25,1979.3253,130.2733,3.5042,3.5332,2.7853,2.4448,3.4211,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.0781,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 375.0,62.1685,6.3984,-999.25,-999.25,-999.25,7.875,-999.25,1956.9774,121.5214,3.5042,3.5317,2.7845,2.4427,3.4227,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.1852,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 375.5,47.7502,6.3983,-999.25,-999.25,-999.25,7.875,-999.25,1948.1213,120.9351,3.5034,3.5309,2.7837,2.4441,3.4227,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.6601,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 376.0,31.7613,6.3984,-999.25,-999.25,-999.25,7.875,-999.25,1997.2782,112.1347,3.5026,3.5324,2.7845,2.4434,3.4227,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.4343,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 376.5,20.9219,6.3985,-999.25,-999.25,-999.25,7.875,-999.25,1988.3987,119.4481,3.505,3.5324,2.7853,2.4455,3.4219,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.9004,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 377.0,18.4654,6.3988,-999.25,-999.25,-999.25,7.875,-999.25,1965.4211,135.2924,3.5026,3.5324,2.7861,2.4434,3.4251,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.919,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 377.5,19.2481,6.4035,-999.25,-999.25,-999.25,7.875,-999.25,1944.6339,103.9162,3.5042,3.5324,2.7845,2.4441,3.433,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.9572,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 378.0,20.747,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1941.7546,107.1176,3.5034,3.5317,2.7845,2.4448,3.4259,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.9447,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 378.5,25.7982,6.3985,-999.25,-999.25,-999.25,7.875,-999.25,1968.7137,111.7687,3.5034,3.5324,2.7845,2.4434,3.4243,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.7857,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 379.0,35.8307,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1963.8147,90.5258,3.5042,3.5317,2.7853,2.4434,3.4243,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.7626,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 379.5,46.9949,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1980.1162,96.0528,3.5034,3.534,2.7853,2.4434,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.5534,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 380.0,56.0073,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,1976.5828,93.1964,3.5034,3.5317,2.7853,2.4427,3.4267,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.7146,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 380.5,61.8646,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1990.7278,96.426,3.501,3.5317,2.7861,2.4427,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.5219,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 381.0,62.9671,6.4002,-999.25,-999.25,-999.25,7.875,-999.25,1977.9373,97.5215,3.5034,3.5309,2.7845,2.4455,3.4235,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.4815,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 381.5,58.0608,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,1964.228,96.8503,3.5034,3.534,2.7853,2.4448,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.6152,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 382.0,51.2867,6.3999,-999.25,-999.25,-999.25,7.875,-999.25,1989.1101,89.8029,3.5026,3.5324,2.7845,2.4427,3.4259,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.6077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 382.5,45.7908,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1981.585,70.5518,3.5034,3.5324,2.7845,2.4427,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.5902,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 383.0,43.784,6.3999,-999.25,-999.25,-999.25,7.875,-999.25,1975.5387,69.4743,3.5042,3.5324,2.7837,2.4427,3.4251,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.1245,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 383.5,49.3448,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1948.1213,62.8701,3.5034,3.5332,2.7845,2.4434,3.4251,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.9212,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 384.0,55.6884,6.4004,-999.25,-999.25,-999.25,7.875,-999.25,1957.4132,70.8221,3.5026,3.5332,2.7845,2.4441,3.4267,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.8298,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 384.5,55.3603,6.3983,-999.25,-999.25,-999.25,7.875,-999.25,1953.146,73.9044,3.5034,3.5317,2.7861,2.4414,3.4243,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.7437,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 385.0,52.9013,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,1953.2144,61.384,3.5018,3.5309,2.7861,2.4448,3.4227,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.4994,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 385.5,49.2882,6.3999,-999.25,-999.25,-999.25,7.875,-999.25,1966.6826,71.0813,3.5042,3.5301,2.7853,2.4434,3.4259,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.0484,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 386.0,43.0761,6.4003,-999.25,-999.25,-999.25,7.875,-999.25,1961.4519,59.518,3.5026,3.5324,2.7845,2.4448,3.4243,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.5821,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 386.5,36.3978,6.4004,-999.25,-999.25,-999.25,7.875,-999.25,1988.9152,54.9215,3.5034,3.5324,2.7845,2.4427,3.4259,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.0713,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 387.0,33.0461,6.3976,-999.25,-999.25,-999.25,7.875,-999.25,1987.8486,51.7777,3.5042,3.5317,2.7845,2.4434,3.4235,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.0189,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 387.5,35.1462,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,1969.1036,44.8261,3.5042,3.5317,2.7853,2.4448,3.4274,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.2739,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 388.0,41.2142,6.4034,-999.25,-999.25,-999.25,7.875,-999.25,1970.514,38.1804,3.505,3.534,2.7861,2.4448,3.4274,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3954,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 388.5,47.9109,6.4006,-999.25,-999.25,-999.25,7.875,-999.25,1971.5123,43.5851,3.5057,3.5324,2.7853,2.4434,3.4274,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.46,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 389.0,51.2392,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1984.8888,46.2956,3.5034,3.5332,2.7861,2.4448,3.4267,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.984,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 389.5,52.8222,6.4024,-999.25,-999.25,-999.25,7.875,-999.25,1975.0692,36.2404,3.5042,3.5324,2.7861,2.4455,3.4267,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.8898,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 390.0,60.7779,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,1971.5929,36.5311,3.5042,3.5324,2.7853,2.4441,3.4259,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.4447,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 390.5,70.6181,6.4004,-999.25,-999.25,-999.25,7.875,-999.25,1979.1987,38.5237,3.505,3.5317,2.7845,2.4448,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.1502,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 391.0,72.8248,6.4033,-999.25,-999.25,-999.25,7.875,-999.25,1990.5787,35.216,3.505,3.5332,2.7845,2.4455,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.4885,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 391.5,72.1211,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,1981.1379,50.3581,3.505,3.5332,2.7853,2.4448,3.4274,3.5137,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.2226,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 392.0,69.0193,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,1967.9564,57.3434,3.5026,3.5324,2.7861,2.4482,3.4251,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.9341,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 392.5,61.2784,6.4034,-999.25,-999.25,-999.25,7.875,-999.25,2001.4659,62.5995,3.505,3.5332,2.7853,2.4482,3.4235,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.3944,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 393.0,57.8859,6.3933,-999.25,-999.25,-999.25,7.875,-999.25,2005.7108,45.2583,3.5026,3.5324,2.7861,2.4482,3.4052,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.2845,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 393.5,59.3348,6.4034,-999.25,-999.25,-999.25,7.875,-999.25,2004.1389,48.0421,3.5042,3.5324,2.7829,2.4482,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.4669,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 394.0,61.7206,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,1966.304,53.3492,3.505,3.5324,2.7853,2.4482,3.4267,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.6675,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 394.5,67.5995,6.4032,-999.25,-999.25,-999.25,7.875,-999.25,2000.8923,45.3402,3.505,3.5324,2.7861,2.4502,3.4235,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.5809,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 395.0,72.221,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,2036.0879,55.4948,3.5018,3.5317,2.7845,2.4495,3.4259,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.6575,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 395.5,64.7933,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,2032.3136,55.0619,3.5018,3.5324,2.7861,2.4516,3.4243,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.8367,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 396.0,49.6421,6.4,-999.25,-999.25,-999.25,7.875,-999.25,2032.5657,52.7166,3.5018,3.5301,2.7853,2.4482,3.4251,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.7893,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 396.5,36.8924,6.4039,-999.25,-999.25,-999.25,7.875,-999.25,2001.1219,38.8115,3.5034,3.5317,2.7853,2.4516,3.4267,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.6752,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 397.0,30.0359,6.4034,-999.25,-999.25,-999.25,7.875,-999.25,1975.9061,46.0528,3.505,3.5309,2.7829,2.4543,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.8936,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 397.5,30.9261,6.4017,-999.25,-999.25,-999.25,7.875,-999.25,1964.7904,61.9919,3.5026,3.5309,2.7845,2.4502,3.4274,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.4139,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 398.0,42.0977,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,1994.9838,54.9907,3.5042,3.5317,2.7845,2.4509,3.4251,3.5082,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.6867,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 398.5,53.8639,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,2017.1827,49.2689,3.5042,3.5317,2.7845,2.4509,3.4259,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.8136,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 399.0,57.7402,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,2019.4076,53.7539,3.5034,3.5309,2.7845,2.4502,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.787,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 399.5,53.2727,6.4003,-999.25,-999.25,-999.25,7.875,-999.25,2032.5085,49.4655,3.5026,3.5301,2.7853,2.4523,3.4259,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.0111,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 400.0,40.4473,6.3995,-999.25,-999.25,-999.25,7.875,-999.25,2018.4677,40.1794,3.5034,3.5301,2.7837,2.4495,3.4243,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.2872,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 400.5,27.0831,6.4005,-999.25,-999.25,-999.25,7.875,-999.25,2025.7061,25.0045,3.5042,3.5317,2.7837,2.4502,3.4251,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.9348,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 401.0,19.4954,6.3981,-999.25,-999.25,-999.25,7.875,-999.25,1999.6073,45.5587,3.5026,3.5293,2.7829,2.4468,3.4251,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.7333,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 401.5,17.0589,6.4011,-999.25,-999.25,-999.25,7.875,-999.25,2021.1979,52.9659,3.5026,3.5309,2.7853,2.4482,3.4267,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.8727,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 402.0,18.1906,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,2012.5815,52.6093,3.505,3.5317,2.7853,2.4468,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.6555,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 402.5,20.1924,6.4007,-999.25,-999.25,-999.25,7.875,-999.25,1983.4895,40.2933,3.5034,3.5324,2.7845,2.4495,3.4274,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.8205,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 403.0,19.5104,6.3992,-999.25,-999.25,-999.25,7.875,-999.25,1994.7542,45.6064,3.5034,3.5309,2.7853,2.4482,3.4251,3.5048,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.4503,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 403.5,19.1773,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,1999.3889,47.4316,3.5042,3.5317,2.7845,2.4489,3.4274,3.5075,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.7771,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 404.0,19.876,6.3998,-999.25,-999.25,-999.25,7.875,-999.25,2000.1462,52.655,3.5057,3.5317,2.7853,2.4461,3.4251,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3898,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 404.5,19.0991,6.4032,-999.25,-999.25,-999.25,7.875,-999.25,1995.9932,45.3741,3.5057,3.5301,2.7869,2.4468,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.3942,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 405.0,18.004,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,2017.5491,39.5241,3.5057,3.5301,2.7861,2.4461,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.6482,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 405.5,17.8733,6.4035,-999.25,-999.25,-999.25,7.875,-999.25,2031.0409,35.6259,3.5065,3.534,2.7845,2.4448,3.4282,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,253.5656,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 406.0,19.0233,6.402,-999.25,-999.25,-999.25,7.875,-999.25,1999.6992,39.2878,3.505,3.5324,2.7861,2.4468,3.4235,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,256.3822,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 406.5,22.3874,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,1992.7925,37.9132,3.5042,3.5324,2.7861,2.4441,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,257.8503,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 407.0,28.8076,6.4007,-999.25,-999.25,-999.25,7.875,-999.25,2027.8861,33.3747,3.505,3.5324,2.7845,2.4448,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,254.0153,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 407.5,42.0019,6.4032,-999.25,-999.25,-999.25,7.875,-999.25,2042.8904,39.8513,3.5057,3.534,2.7861,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,251.6357,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 408.0,58.4971,6.4007,-999.25,-999.25,-999.25,7.875,-999.25,2010.3679,34.3969,3.5034,3.5332,2.7845,2.4441,3.4267,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.4669,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 408.5,69.1858,6.4003,-999.25,-999.25,-999.25,7.875,-999.25,2013.3737,39.1063,3.505,3.5332,2.7853,2.4414,3.4259,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.0441,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 409.0,74.6909,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,2031.0745,44.9233,3.505,3.534,2.7845,2.4441,3.4274,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.1797,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 409.5,75.148,6.404,-999.25,-999.25,-999.25,7.875,-999.25,2019.1208,36.3982,3.505,3.5372,2.7853,2.4421,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.3544,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 410.0,71.33,6.4037,-999.25,-999.25,-999.25,7.875,-999.25,1999.8829,44.6215,3.505,3.5411,2.7853,2.4434,3.4267,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.1215,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 410.5,66.6127,6.4049,-999.25,-999.25,-999.25,7.875,-999.25,1988.262,72.0636,3.5042,3.5427,2.7861,2.4434,3.4259,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.521,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 411.0,59.0434,6.4051,-999.25,-999.25,-999.25,7.875,-999.25,1979.0497,25.5248,3.5042,3.5443,2.7853,2.4434,3.4251,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.0785,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 411.5,47.9642,6.4061,-999.25,-999.25,-999.25,7.875,-999.25,2008.693,347.4931,3.5057,3.5443,2.7853,2.4455,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.45,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 412.0,35.8732,6.4052,-999.25,-999.25,-999.25,7.875,-999.25,2018.3523,5.5127,3.5065,3.5451,2.7837,2.4448,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 412.5,25.5268,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,2030.0427,11.2927,3.505,3.5451,2.7829,2.4434,3.4267,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.6549,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 413.0,20.7928,6.4064,-999.25,-999.25,-999.25,7.875,-999.25,2018.6738,19.3806,3.5057,3.5467,2.7837,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.4629,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 413.5,23.0794,6.4015,-999.25,-999.25,-999.25,7.875,-999.25,2017.5491,29.0942,3.505,3.5403,2.7845,2.4427,3.4251,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.0383,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 414.0,32.7489,6.4045,-999.25,-999.25,-999.25,7.875,-999.25,2022.7573,38.3372,3.505,3.5411,2.7853,2.4448,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.9218,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 414.5,44.1029,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,2040.3787,61.5365,3.5065,3.5403,2.7853,2.4441,3.4259,3.5062,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.4344,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 415.0,49.5938,6.4034,-999.25,-999.25,-999.25,7.875,-999.25,2047.6293,52.5784,3.5042,3.5396,2.7829,2.4455,3.4259,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.9585,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 415.5,52.6074,6.4035,-999.25,-999.25,-999.25,7.875,-999.25,2037.4412,43.8112,3.5034,3.538,2.7845,2.4461,3.4274,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.9062,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 416.0,53.7432,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,2027.8625,49.6365,3.5042,3.5396,2.7861,2.4441,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.7987,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 416.5,48.7552,6.4053,-999.25,-999.25,-999.25,7.875,-999.25,2004.5288,52.8622,3.5042,3.5396,2.7845,2.4468,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.1266,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 417.0,39.0442,6.4052,-999.25,-999.25,-999.25,7.875,-999.25,2012.2029,53.9928,3.505,3.5396,2.7861,2.4434,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.5929,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 417.5,27.3879,6.404,-999.25,-999.25,-999.25,7.875,-999.25,2008.2684,56.8867,3.505,3.5348,2.7845,2.4461,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.8106,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 418.0,19.2023,6.4033,-999.25,-999.25,-999.25,7.875,-999.25,2027.2207,60.9197,3.5057,3.5364,2.7861,2.4448,3.4259,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.7186,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 418.5,17.3037,6.4047,-999.25,-999.25,-999.25,7.875,-999.25,2045.3461,58.2985,3.505,3.5356,2.7845,2.4468,3.4298,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.2095,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 419.0,19.7935,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,1999.6757,63.9671,3.505,3.5348,2.7853,2.4455,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.3891,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 419.5,26.5676,6.4024,-999.25,-999.25,-999.25,7.875,-999.25,2001.0066,54.379,3.5057,3.5348,2.7845,2.4455,3.4259,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.8017,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 420.0,37.1806,6.4059,-999.25,-999.25,-999.25,7.875,-999.25,2027.7483,67.0343,3.5057,3.5372,2.7861,2.4455,3.4282,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.9612,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 420.5,46.3196,6.403,-999.25,-999.25,-999.25,7.875,-999.25,2062.4622,111.5344,3.5057,3.5364,2.7845,2.4461,3.4259,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.5452,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 421.0,47.7435,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,2023.3197,93.6772,3.505,3.5348,2.7861,2.4461,3.4251,3.5068,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.0836,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 421.5,40.6779,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,2003.6797,61.6642,3.505,3.534,2.7845,2.4468,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.5538,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 422.0,33.0861,6.4025,-999.25,-999.25,-999.25,7.875,-999.25,2019.0984,75.619,3.5065,3.534,2.7845,2.4461,3.4274,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.8442,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 422.5,29.8818,6.4027,-999.25,-999.25,-999.25,7.875,-999.25,2010.0464,77.5088,3.5065,3.5348,2.7853,2.4461,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.3877,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 423.0,31.6805,6.4029,-999.25,-999.25,-999.25,7.875,-999.25,2016.8041,80.598,3.5057,3.5348,2.7861,2.4468,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.8086,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 423.5,34.3951,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,2005.6414,89.824,3.5065,3.5348,2.7861,2.4468,3.4243,3.5055,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.9937,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 424.0,37.1972,6.4001,-999.25,-999.25,-999.25,7.875,-999.25,2015.0026,89.0763,3.505,3.5324,2.7853,2.4421,3.4259,3.5096,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.1409,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 424.5,39.2748,6.401,-999.25,-999.25,-999.25,7.875,-999.25,1997.0261,87.323,3.5057,3.534,2.7853,2.4427,3.4251,3.5103,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.8411,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 425.0,38.7386,6.4031,-999.25,-999.25,-999.25,7.875,-999.25,1989.8326,100.1825,3.5065,3.5332,2.7845,2.4434,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.7116,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 425.5,35.1279,6.4023,-999.25,-999.25,-999.25,7.875,-999.25,2009.2443,88.382,3.505,3.5356,2.7877,2.4427,3.4243,3.5116,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.2493,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 426.0,29.8394,6.4013,-999.25,-999.25,-999.25,7.875,-999.25,2004.2533,79.852,3.5065,3.5348,2.7845,2.4421,3.4251,3.511,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.8391,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 426.5,26.3278,6.403,-999.25,-999.25,-999.25,7.875,-999.25,2024.9722,89.368,3.505,3.5348,2.7869,2.4407,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.619,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 427.0,28.2581,6.3996,-999.25,-999.25,-999.25,7.875,-999.25,1982.9047,140.0869,3.5073,3.5332,2.7837,2.4414,3.4243,3.5089,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.5926,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 427.5,34.9447,6.4012,-999.25,-999.25,-999.25,7.875,-999.25,1960.7058,106.701,3.505,3.5332,2.7845,2.4421,3.4259,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.9709,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 428.0,37.965,6.4022,-999.25,-999.25,-999.25,7.875,-999.25,1986.7585,88.1418,3.5065,3.5332,2.7853,2.4414,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.5534,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 428.5,32.8238,6.3993,-999.25,-999.25,-999.25,7.875,-999.25,2007.2478,105.5652,3.5042,3.5332,2.7845,2.4387,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.7989,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 429.0,26.9199,6.4009,-999.25,-999.25,-999.25,7.875,-999.25,2022.7238,112.2188,3.505,3.534,2.7837,2.44,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.6576,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 429.5,30.1999,6.4014,-999.25,-999.25,-999.25,7.875,-999.25,2003.1979,94.563,3.5042,3.5332,2.7845,2.4414,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.0418,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 430.0,41.0693,6.4016,-999.25,-999.25,-999.25,7.875,-999.25,1991.7831,68.3093,3.505,3.534,2.7837,2.4421,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3566,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 430.5,49.1841,6.4027,-999.25,-999.25,-999.25,7.875,-999.25,1971.7878,74.9939,3.5057,3.534,2.7861,2.4421,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.2666,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 431.0,50.5997,6.4045,-999.25,-999.25,-999.25,7.875,-999.25,2002.0742,112.8737,3.5034,3.534,2.7861,2.4421,3.433,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.5442,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 431.5,42.8896,6.4017,-999.25,-999.25,-999.25,7.875,-999.25,2035.4336,165.2743,3.5057,3.5332,2.7853,2.4421,3.4259,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.2998,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 432.0,34.5092,6.4051,-999.25,-999.25,-999.25,7.875,-999.25,2027.4839,150.0413,3.505,3.5332,2.7861,2.4421,3.4338,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3169,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 432.5,39.9427,6.402,-999.25,-999.25,-999.25,7.875,-999.25,2033.0249,125.2976,3.5065,3.5324,2.7845,2.4407,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.6783,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 433.0,55.367,6.4026,-999.25,-999.25,-999.25,7.875,-999.25,2015.9313,116.7515,3.5057,3.5324,2.7861,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.1561,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 433.5,67.1806,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,2031.0173,164.8169,3.505,3.5317,2.7853,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.1395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 434.0,70.0085,6.4029,-999.25,-999.25,-999.25,7.875,-999.25,2009.829,210.9496,3.5065,3.5332,2.7861,2.4427,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.1605,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 434.5,66.238,6.4106,-999.25,-999.25,-999.25,7.875,-999.25,2020.1426,163.6353,3.5065,3.5577,2.7845,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,250.1022,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 435.0,61.5165,6.4018,-999.25,-999.25,-999.25,7.875,-999.25,2023.5718,184.621,3.5073,3.5577,2.7869,2.4434,3.3949,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.1054,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 435.5,58.4438,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,2014.1534,204.7441,3.505,3.5348,2.7845,2.4448,3.4243,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.8953,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 436.0,48.7636,6.404,-999.25,-999.25,-999.25,7.875,-999.25,2026.4286,232.0254,3.5057,3.5348,2.7877,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 436.5,36.4061,6.4021,-999.25,-999.25,-999.25,7.875,-999.25,2037.7404,267.4362,3.5042,3.534,2.7845,2.4434,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.1432,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 437.0,30.4273,6.4037,-999.25,-999.25,-999.25,7.875,-999.25,2045.0706,120.1625,3.5057,3.5356,2.7861,2.4434,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.2306,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 437.5,27.8542,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,2038.5884,116.5671,3.505,3.5348,2.7861,2.4448,3.4227,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.0426,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 438.0,28.816,6.4032,-999.25,-999.25,-999.25,7.875,-999.25,2052.5967,267.494,3.5065,3.5348,2.7853,2.4414,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,233.7554,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 438.5,31.0976,6.4028,-999.25,-999.25,-999.25,7.875,-999.25,2048.0527,250.4592,3.5057,3.5364,2.7845,2.4427,3.4267,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,233.8916,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 439.0,29.2032,6.4045,-999.25,-999.25,-999.25,7.875,-999.25,2020.8763,245.7115,3.5073,3.538,2.7853,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.2337,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 439.5,24.2236,6.4043,-999.25,-999.25,-999.25,7.875,-999.25,2024.6506,244.9395,3.5073,3.5396,2.7853,2.4434,3.4251,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.4075,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 440.0,20.6554,6.4056,-999.25,-999.25,-999.25,7.875,-999.25,2046.7913,244.102,3.5065,3.5411,2.7861,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.2636,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 440.5,20.6762,6.4043,-999.25,-999.25,-999.25,7.875,-999.25,2064.825,246.8987,3.5057,3.5419,2.7861,2.4434,3.4235,3.5123,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.1915,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 441.0,21.5256,6.405,-999.25,-999.25,-999.25,7.875,-999.25,2046.8944,252.3976,3.505,3.5419,2.7845,2.4434,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,234.6817,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 441.5,19.2689,6.4102,-999.25,-999.25,-999.25,7.875,-999.25,2014.8301,253.9932,3.5065,3.5538,2.7861,2.4441,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.8024,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 442.0,15.5884,6.4071,-999.25,-999.25,-999.25,7.875,-999.25,2016.4365,261.3467,3.5065,3.5443,2.7853,2.4434,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.7325,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 442.5,14.102,6.4061,-999.25,-999.25,-999.25,7.875,-999.25,2002.8304,267.0801,3.5057,3.5435,2.7853,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.7994,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 443.0,13.7056,6.4057,-999.25,-999.25,-999.25,7.875,-999.25,2023.0105,257.9947,3.5073,3.5443,2.7845,2.4421,3.4259,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.3653,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 443.5,13.5898,6.4073,-999.25,-999.25,-999.25,7.875,-999.25,2007.2242,246.0119,3.5057,3.5451,2.7845,2.4441,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.851,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 444.0,15.4893,6.4104,-999.25,-999.25,-999.25,7.875,-999.25,2021.1979,245.4045,3.5081,3.5506,2.7861,2.4448,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.2343,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 444.5,17.7576,6.4103,-999.25,-999.25,-999.25,7.875,-999.25,2024.0883,250.6925,3.5081,3.5546,2.7861,2.4427,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.528,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 445.0,17.1214,6.4087,-999.25,-999.25,-999.25,7.875,-999.25,2029.8701,240.7917,3.5073,3.549,2.7861,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.6912,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 445.5,13.8871,6.4117,-999.25,-999.25,-999.25,7.875,-999.25,2058.344,236.7265,3.5065,3.5577,2.7861,2.4448,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.4996,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 446.0,11.9278,6.4089,-999.25,-999.25,-999.25,7.875,-999.25,2044.0039,243.7391,3.5073,3.5498,2.7861,2.4441,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.3422,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 446.5,14.4709,6.4091,-999.25,-999.25,-999.25,7.875,-999.25,2051.7588,245.4397,3.505,3.5514,2.7861,2.4448,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.2337,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 447.0,20.0234,6.411,-999.25,-999.25,-999.25,7.875,-999.25,2028.8373,232.0862,3.5081,3.553,2.7861,2.4448,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.0228,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 447.5,26.1488,6.4098,-999.25,-999.25,-999.25,7.875,-999.25,2031.8889,222.1595,3.5065,3.5554,2.7853,2.4434,3.4259,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.0692,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 448.0,30.4514,6.4091,-999.25,-999.25,-999.25,7.875,-999.25,2036.6851,219.2504,3.5065,3.5506,2.7853,2.4448,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,235.4815,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 448.5,32.7489,6.4126,-999.25,-999.25,-999.25,7.875,-999.25,2045.4144,218.6396,3.5081,3.5569,2.7877,2.4455,3.4267,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.6244,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 449.0,35.8757,6.4109,-999.25,-999.25,-999.25,7.875,-999.25,2071.5132,224.7653,3.5089,3.5506,2.7861,2.4461,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.243,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 449.5,40.1833,6.4094,-999.25,-999.25,-999.25,7.875,-999.25,2045.9084,218.7929,3.5065,3.5506,2.7861,2.4441,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.8309,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 450.0,46.4203,6.4103,-999.25,-999.25,-999.25,7.875,-999.25,2068.3472,225.8522,3.5073,3.5522,2.7845,2.4461,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.9579,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 450.5,52.1519,6.4099,-999.25,-999.25,-999.25,7.875,-999.25,2038.52,230.7104,3.5073,3.5522,2.7853,2.4448,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3775,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 451.0,48.5479,6.4118,-999.25,-999.25,-999.25,7.875,-999.25,2040.1378,236.1383,3.5089,3.5554,2.7861,2.4441,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.4174,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 451.5,36.7475,6.4094,-999.25,-999.25,-999.25,7.875,-999.25,2043.2007,238.3531,3.5073,3.553,2.7845,2.4448,3.4235,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3972,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 452.0,28.6727,6.4097,-999.25,-999.25,-999.25,7.875,-999.25,2044.3131,237.043,3.5065,3.5514,2.7869,2.4441,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.6903,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 452.5,32.3258,6.4115,-999.25,-999.25,-999.25,7.875,-999.25,2043.4069,243.3439,3.5081,3.5554,2.7861,2.4441,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.956,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 453.0,42.6864,6.4099,-999.25,-999.25,-999.25,7.875,-999.25,1999.4348,248.1323,3.5081,3.5514,2.7845,2.4448,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.1367,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 453.5,47.7726,6.4116,-999.25,-999.25,-999.25,7.875,-999.25,1971.9144,232.5604,3.5104,3.5562,2.7861,2.4448,3.4243,3.513,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.199,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 454.0,46.7609,6.4117,-999.25,-999.25,-999.25,7.875,-999.25,1974.1282,38.6674,3.5081,3.5538,2.7861,2.4448,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.5488,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 454.5,43.3926,6.4131,-999.25,-999.25,-999.25,7.875,-999.25,2022.1726,4.8338,3.5089,3.5577,2.7869,2.4448,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.6661,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 455.0,39.6287,6.4109,-999.25,-999.25,-999.25,7.875,-999.25,2029.0905,197.5708,3.5073,3.5522,2.7877,2.4455,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.6075,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 455.5,37.8742,6.4124,-999.25,-999.25,-999.25,7.875,-999.25,1999.9625,197.5708,3.5089,3.5514,2.7877,2.4468,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.4664,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 456.0,32.0086,6.4135,-999.25,-999.25,-999.25,7.875,-999.25,2004.7014,197.5708,3.5073,3.5577,2.7869,2.4468,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.5803,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 456.5,23.8505,6.4114,-999.25,-999.25,-999.25,7.875,-999.25,2012.2723,197.5708,3.5089,3.5514,2.7861,2.4468,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.0438,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 457.0,20.6104,6.4104,-999.25,-999.25,-999.25,7.875,-999.25,2049.8655,197.5708,3.5057,3.5506,2.7869,2.4461,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.4323,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 457.5,20.4306,6.4105,-999.25,-999.25,-999.25,7.875,-999.25,2036.2716,191.4302,3.5089,3.5483,2.7861,2.4475,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.6395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 458.0,20.6471,6.4101,-999.25,-999.25,-999.25,7.875,-999.25,2042.8456,184.4663,3.5073,3.5483,2.7877,2.4461,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,237.3675,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 458.5,20.9169,6.4096,-999.25,-999.25,-999.25,7.875,-999.25,2050.7493,174.6153,3.5081,3.5467,2.7877,2.4468,3.4259,3.5137,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.9377,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 459.0,24.734,6.4101,-999.25,-999.25,-999.25,7.875,-999.25,2058.6531,171.4575,3.5081,3.549,2.7861,2.4468,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.3643,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 459.5,36.4777,6.4092,-999.25,-999.25,-999.25,7.875,-999.25,2064.7454,168.4379,3.5073,3.5483,2.7861,2.4475,3.4235,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.1906,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 460.0,51.9329,6.4103,-999.25,-999.25,-999.25,7.875,-999.25,2028.6547,163.4187,3.5073,3.5475,2.7869,2.4475,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,236.9405,0.344,15.0804,1060.5494,93.8344,-36.3209,-43.431,-39.876,-5.8219,39.8273,129.8728,309.8728,268.0978,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 460.5,57.0465,6.4084,-999.25,-999.25,-999.25,7.875,-999.25,2043.7507,163.1982,3.5073,3.5451,2.7861,2.4482,3.4235,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.845,0.2115,22.6188,1160.9758,61.0897,-35.2751,-42.1335,-38.7043,-7.0163,41.6746,124.0066,304.0066,281.8291,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 461.0,53.5442,6.4088,-999.25,-999.25,-999.25,7.875,-999.25,2031.293,172.0984,3.5081,3.5451,2.7869,2.4461,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.8258,0.1305,27.9965,1282.5541,38.1577,-31.2796,-37.8883,-34.584,-7.0479,43.6728,112.317,292.317,278.9803,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 461.5,52.3842,6.4079,-999.25,-999.25,-999.25,7.875,-999.25,2053.6855,221.5739,3.5065,3.5435,2.7861,2.4482,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.7513,0.1097,32.5051,1531.3521,32.6125,-25.5338,-32.2233,-28.8785,-6.3929,44.6916,84.9982,264.9981,271.7332,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 462.0,54.7008,6.4082,-999.25,-999.25,-999.25,7.875,-999.25,2070.5149,139.4708,3.5089,3.5427,2.7869,2.4461,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.7042,0.1234,41.802,1811.4651,31.7723,-44.2356,-51.3023,-47.769,-3.0984,43.3652,102.6413,282.6413,242.4832,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 462.5,62.1627,6.4076,-999.25,-999.25,-999.25,7.875,-999.25,2072.5459,149.1011,3.5073,3.5396,2.7877,2.4482,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.4935,0.0831,49.7758,2012.8101,25.4639,-47.6103,-55.2291,-51.4197,1.6555,45.066,115.5758,295.5758,195.9522,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 463.0,66.6585,6.4072,-999.25,-999.25,-999.25,7.875,-999.25,2053.0549,180.1479,3.5089,3.538,2.7877,2.4461,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.6536,0.0662,63.466,2391.667,23.854,-41.1671,-49.2217,-45.1944,4.4466,49.3506,128.0911,308.0911,176.0607,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 463.5,68.6187,6.408,-999.25,-999.25,-999.25,7.875,-999.25,1983.0302,182.8573,3.5081,3.5411,2.7869,2.4461,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.5512,0.0501,82.7152,2847.3516,19.784,-31.562,-39.778,-35.67,8.4762,54.6104,141.024,321.024,153.3576,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 464.0,70.8221,6.4093,-999.25,-999.25,-999.25,7.875,-999.25,1972.8892,171.6541,3.5081,3.5419,2.7885,2.4468,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.7778,0.0444,96.6342,3421.864,18.066,-29.3375,-37.7914,-33.5645,13.1728,56.7218,143.1295,323.1295,129.6351,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 464.5,71.5057,6.4079,-999.25,-999.25,-999.25,7.875,-999.25,2018.3871,173.0767,3.5065,3.5403,2.7877,2.4475,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.3338,0.0478,98.5667,3698.4138,18.2109,-33.3497,-42.4042,-37.877,17.9942,57.6352,132.2368,312.2368,109.6199,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 465.0,71.191,6.4076,-999.25,-999.25,-999.25,7.875,-999.25,2062.5427,170.5552,3.5081,3.5396,2.7861,2.4475,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.5366,0.0527,93.5278,3770.0352,17.1175,-35.3759,-45.0617,-40.2188,23.6123,63.8936,120.6337,300.6337,97.2284,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 465.5,68.0858,6.4081,-999.25,-999.25,-999.25,7.875,-999.25,2088.0791,168.7367,3.5097,3.538,2.7877,2.4482,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.3431,0.0735,94.1793,3740.4419,58.1202,-18.6891,-29.9172,-24.3032,32.7491,75.3727,112.4707,292.4707,85.9277,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 466.0,62.7131,6.4081,-999.25,-999.25,-999.25,7.875,-999.25,2062.302,152.5936,3.5097,3.5372,2.7869,2.4482,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.8849,0.0741,82.2936,3967.5537,253.4492,-3.0643,-13.6704,-8.3674,47.639,82.7147,73.8113,253.8113,60.1726,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 466.5,52.5274,6.4079,-999.25,-999.25,-999.25,7.875,-999.25,2056.6802,150.3331,3.5073,3.5372,2.7893,2.4489,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,242.0507,0.0945,62.9387,3691.7415,534.8376,7.9459,-2.0649,2.9405,54.7156,87.2287,77.3972,257.3972,48.8737,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 467.0,43.0653,6.4072,-999.25,-999.25,-999.25,7.875,-999.25,2055.8198,155.7844,3.5089,3.538,2.7869,2.4468,3.4267,3.5144,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.6554,0.1348,46.152,4137.5645,1051.2878,7.0584,-2.708,2.1752,54.2767,87.8365,112.138,292.138,46.9184,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 467.5,42.181,6.4071,-999.25,-999.25,-999.25,7.875,-999.25,2078.4421,158.6102,3.5089,3.5364,2.7877,2.4489,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.5415,0.2345,27.0177,4149.9912,1965.2397,14.611,3.2318,8.9214,57.4527,95.7149,90.3916,270.3916,47.3067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 468.0,47.0923,6.4061,-999.25,-999.25,-999.25,7.875,-999.25,2068.29,160.468,3.5065,3.5356,2.7869,2.4482,3.4274,3.5137,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.4936,0.2299,16.7158,4627.374,1960.3187,23.4413,12.0006,17.721,58.0588,101.4707,59.0442,239.0442,47.708,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 468.5,50.8453,6.4074,-999.25,-999.25,-999.25,7.875,-999.25,2047.0669,153.4771,3.5089,3.5372,2.7877,2.4475,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.3449,0.1495,14.4959,4759.0537,1128.7284,31.8721,22.5926,27.2323,58.9665,105.9321,50.2503,230.2503,42.5838,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 469.0,43.7431,6.4079,-999.25,-999.25,-999.25,7.875,-999.25,2047.7212,155.7758,3.5089,3.5372,2.7869,2.4482,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.0424,0.132,13.8316,5075.4165,655.7303,42.4464,34.7664,38.6064,62.4337,110.0667,48.8958,228.8958,41.9776,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 469.5,29.5971,6.4075,-999.25,-999.25,-999.25,7.875,-999.25,2059.7085,157.1798,3.5081,3.5364,2.7869,2.4495,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,240.5231,0.1311,13.3872,5837.3022,458.94,52.8883,46.0588,49.4736,64.9552,112.7073,49.4736,229.4736,48.576,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 470.0,20.0633,6.4053,-999.25,-999.25,-999.25,7.875,-999.25,2091.6238,147.8581,3.5081,3.5324,2.7869,2.4468,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.3825,0.1191,16.857,5685.1221,386.0491,60.3922,53.8545,57.1234,69.2789,118.8086,57.1234,237.1234,49.3872,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 470.5,19.2581,6.4074,-999.25,-999.25,-999.25,7.875,-999.25,2082.481,148.5104,3.5081,3.5356,2.7901,2.4482,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.4521,0.1491,12.8796,5111.4707,529.3203,57.4545,49.6388,53.5466,78.466,122.236,53.5466,233.5466,41.1742,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 471.0,25.366,6.4042,-999.25,-999.25,-999.25,7.875,-999.25,2085.7734,148.6286,3.5073,3.5317,2.7861,2.4475,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.5733,0.0917,13.4773,5315.0771,326.5962,44.7951,36.3163,40.5557,81.1964,122.8636,40.5557,220.5557,37.2685,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 471.5,36.1955,6.4059,-999.25,-999.25,-999.25,7.875,-999.25,2064.687,137.9868,3.5081,3.5348,2.7869,2.4461,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.1497,0.0585,19.2829,6781.1719,169.6241,37.0393,25.9491,31.4942,92.548,124.9899,31.4942,211.4942,24.1313,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 472.0,43.3426,6.4041,-999.25,-999.25,-999.25,7.875,-999.25,2057.5405,137.2739,3.5065,3.5317,2.7869,2.4455,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.5052,0.0487,21.7807,6514.4243,107.1821,42.22,31.4903,36.8551,95.7778,128.9337,36.8551,216.8551,22.7784,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 472.5,41.2542,6.4045,-999.25,-999.25,-999.25,7.875,-999.25,2071.7886,130.4066,3.5065,3.5324,2.7877,2.4468,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,238.3284,0.0417,24.7636,5547.4224,68.5661,41.2402,31.036,36.1381,99.6176,135.9221,36.1381,216.1381,26.9989,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 473.0,39.4589,6.4083,-999.25,-999.25,-999.25,7.875,-999.25,2072.8674,119.6731,3.5081,3.5324,2.7893,2.4461,3.4338,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,239.2608,0.0346,30.5786,5386.2998,37.2403,33.3508,21.9631,27.6569,107.2303,144.0141,31.3118,211.3118,27.4893,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 473.5,46.6035,6.4051,-999.25,-999.25,-999.25,7.875,-999.25,2104.4949,115.9479,3.5065,3.5332,2.7877,2.4461,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,241.2028,0.0369,43.5093,5879.501,34.0327,26.1057,12.3894,19.2475,108.8256,148.1714,26.7465,206.7465,28.1708,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 474.0,64.7425,6.4023,-999.25,-999.25,-999.25,7.875,-999.25,2109.0378,108.3092,3.5081,3.5301,2.7853,2.4434,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,243.6824,0.0401,64.7431,5892.7388,37.5243,22.8049,6.0724,14.4386,103.9925,149.6403,29.7913,209.7913,30.5418,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 474.5,79.2908,6.4052,-999.25,-999.25,-999.25,7.875,-999.25,2111.229,106.8834,3.5089,3.5332,2.7869,2.4448,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,246.8083,0.0341,94.0285,6706.54,32.8244,12.1328,-16.4093,-2.1383,106.2344,142.649,42.7031,222.7031,18.6137,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 475.0,79.1284,6.4046,-999.25,-999.25,-999.25,7.875,-999.25,2122.7009,114.5072,3.5089,3.534,2.7869,2.4448,3.4243,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.176,0.0363,78.9452,8028.4902,35.8052,-0.4288,-41.4768,-20.9528,108.8106,133.9575,60.4909,240.4909,16.0776,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 475.5,75.4586,6.4046,-999.25,-999.25,-999.25,7.875,-999.25,2111.7681,123.2565,3.5073,3.5332,2.7877,2.4441,3.4259,3.5157,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.8167,0.0294,89.824,9950.7773,31.7897,3.1172,-24.8289,-10.8558,111.5671,141.0942,36.1581,216.1581,20.1029,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 476.0,67.3014,6.405,-999.25,-999.25,-999.25,7.875,-999.25,2132.1431,104.8619,3.5089,3.534,2.7877,2.4434,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.3474,0.0239,122.7694,13905.5615,31.3758,-4.1713,-19.1461,-11.6587,115.5065,158.5972,35.0201,215.0201,29.216,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 476.5,48.9851,6.406,-999.25,-999.25,-999.25,7.875,-999.25,2126.0742,97.1905,3.5065,3.5348,2.7877,2.4441,3.4298,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.9723,0.018,132.589,16337.4111,37.3908,-20.1992,-31.3127,-25.756,119.3411,162.4908,58.1515,238.1515,28.8075,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 477.0,30.0592,6.4137,-999.25,-999.25,-999.25,7.875,-999.25,2126.0742,91.1358,3.5136,3.5522,2.7893,2.4461,3.4235,3.5164,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.9454,0.0165,126.996,14006.3574,48.4533,-34.088,-43.935,-39.0115,123.3539,163.966,81.8261,261.8261,26.6614,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 477.5,19.3222,6.4043,-999.25,-999.25,-999.25,7.875,-999.25,2100.5369,99.2578,3.5104,3.5324,2.7869,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,249.1492,0.0207,93.8723,11103.4111,57.7399,-34.7553,-43.3739,-39.0646,127.6487,171.6925,86.4004,266.4004,26.0371,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 478.0,15.5384,6.404,-999.25,-999.25,-999.25,7.875,-999.25,2084.4885,112.8716,3.5097,3.5317,2.7877,2.4427,3.4251,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.911,0.0426,63.6303,10925.9395,75.9802,-9.6308,-18.4988,-14.0648,131.2337,179.509,81.3669,261.3669,23.8935,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 478.5,14.9263,6.4037,-999.25,-999.25,-999.25,7.875,-999.25,2073.1768,94.2347,3.5081,3.5324,2.7877,2.4421,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,248.0716,0.069,43.5631,11981.6621,145.1285,21.4055,9.2219,15.3137,134.3543,178.3839,73.252,253.252,15.3569,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 479.0,15.451,6.4047,-999.25,-999.25,-999.25,7.875,-999.25,2070.366,91.0421,3.5081,3.5324,2.7885,2.4434,3.4267,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,247.0077,0.1304,26.1212,14389.0459,327.7892,40.1693,20.5269,30.3481,137.9481,169.9625,56.5619,236.5619,10.9344,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 479.5,15.1054,6.404,-999.25,-999.25,-999.25,7.875,-999.25,2093.4934,112.3086,3.5097,3.5317,2.7861,2.4421,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.8885,0.2454,14.1061,11343.6738,735.7452,47.4102,28.2661,37.8381,140.6006,172.9355,54.7589,234.7589,5.5019,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 480.0,17.4828,6.4049,-999.25,-999.25,-999.25,7.875,-999.25,2079.0505,101.2241,3.5081,3.534,2.7861,2.4441,3.4274,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,245.3289,0.3905,9.7574,7609.7881,1269.9623,51.4957,27.819,39.6574,153.161,175.583,64.667,244.667,3.3381,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 480.5,25.9098,6.4042,-999.25,-999.25,-999.25,7.875,-999.25,2076.4692,92.3332,3.5089,3.5332,2.7869,2.4427,3.4259,3.5151,0.0,-999.25,-999.25,-999.25,-999.25,-999.25,244.1298,0.2677,9.8885,7438.4414,1954.8923,48.83,24.2019,36.516,168.9205,185.2009,78.6049,258.6049,3.6252,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 481.0,36.3187,6.4032,-999.25,-999.25,-999.25,7.875,243758.4688,2032.4625,83.5547,3.5081,3.5332,2.7869,2.4414,3.4251,3.5151,0.0,-999.25,103.8192,-999.25,39.759,-999.25,242.8991,0.1998,9.4632,5930.9336,2169.2803,38.353,15.7874,27.0702,172.1593,192.0041,87.2195,267.2195,8.924,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 481.5,43.5583,6.4024,-999.25,-999.25,-999.25,7.875,243706.3438,2058.1143,85.8622,3.5104,3.5332,2.7853,2.4434,3.4267,3.5082,0.0,-999.25,103.8941,-999.25,39.8119,-999.25,243.3278,0.1492,9.4467,4242.5166,1896.7208,23.7378,-3.304,10.2169,177.9973,193.3411,99.4947,279.4947,14.3052,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 482.0,49.8719,6.4022,1.8285,-999.25,-999.25,7.875,243655.2031,2107.4089,82.3835,3.5073,3.5317,2.7869,2.4427,3.4251,3.513,0.0,190.1817,104.0283,-999.25,39.9069,-999.25,244.5321,0.0989,12.5889,3423.5659,1099.8436,14.2285,-9.4546,2.3869,180.4485,202.2996,106.5608,286.5608,18.1067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 482.5,54.0438,6.4036,1.8256,-999.25,-999.25,7.875,243601.9531,2105.8831,90.2004,3.5073,3.5317,2.7877,2.4448,3.4243,3.5151,0.0,188.7589,103.5795,-999.25,39.5894,-999.25,247.0907,0.0529,20.8821,3088.9368,530.6324,-6.223,-20.1036,-13.1633,174.352,213.1546,110.8616,290.8615,22.7849,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 483.0,53.2594,6.4048,1.8286,-999.25,-999.25,7.875,243523.4219,2129.0217,107.7766,3.5089,3.5332,2.7877,2.4427,3.4267,3.5151,0.0,185.5073,101.8695,-999.25,38.3801,-999.25,249.8804,0.0311,30.7659,2985.3491,216.5163,-34.3808,-43.5447,-38.9628,167.0579,216.1884,114.9921,294.9921,27.1741,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 483.5,50.6455,6.4041,1.8605,-999.25,-999.25,7.875,243471.4063,2107.7527,94.0028,3.5097,3.5317,2.7861,2.4455,3.4243,3.5151,0.0,179.188,97.4799,-999.25,35.2757,-999.25,250.0325,0.0225,44.5223,3743.1138,74.5424,-41.6882,-50.0293,-45.8588,162.8698,211.1508,113.557,293.557,26.8821,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 484.0,45.974,6.4019,2.0091,-999.25,-999.25,7.875,243427.25,2115.3596,87.3991,3.5081,3.5324,2.7869,2.4421,3.4259,3.5103,0.0,173.9093,88.3927,-999.25,28.8491,-999.25,250.0477,0.0179,63.7585,4589.5146,38.1746,-41.61,-50.0662,-45.8381,158.4936,202.2287,101.1477,281.1477,24.8572,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 484.5,40.3898,6.4034,2.2166,-999.25,-999.25,7.875,243389.0625,2091.4636,90.0233,3.5089,3.5317,2.7861,2.4448,3.4259,3.513,0.0,170.696,78.98,-999.25,22.1923,-999.25,249.9221,0.019,66.2161,5188.0723,37.3405,-23.0077,-33.6584,-28.3331,155.5985,187.1449,88.0975,268.0975,20.066,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 485.0,33.505,6.4027,2.4192,-999.25,-999.25,7.875,243350.6406,2099.5623,69.4919,3.5081,3.5324,2.7861,2.4434,3.4259,3.5123,0.0,169.1502,71.7137,-999.25,17.0536,-999.25,247.8863,0.0286,66.4307,5429.5508,43.4644,1.6917,-9.9002,-4.1042,154.982,180.4231,45.4755,225.4755,19.1654,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 485.5,25.1953,6.4067,2.6337,-999.25,-999.25,7.875,243335.0469,2112.1926,56.2909,3.5089,3.5317,2.7853,2.4455,3.4338,3.5151,0.0,164.314,63.8155,-999.25,11.4678,-999.25,245.7303,0.0591,40.449,4573.2734,67.183,14.4549,1.554,8.0044,146.6702,166.7925,32.5376,212.5376,17.7816,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 486.0,18.8059,6.4036,2.7554,-999.25,-999.25,7.875,243307.3438,2115.7261,72.0177,3.5073,3.534,2.7853,2.4441,3.4251,3.5151,0.0,157.8896,58.0179,-999.25,7.3677,-999.25,243.3182,0.0923,21.5609,4126.1392,93.6589,21.6698,8.9484,15.3091,136.2763,158.1576,26.2396,206.2396,17.3982,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 486.5,15.7199,6.4034,2.758,-999.25,-999.25,7.875,243280.8438,2130.4558,89.0158,3.5089,3.5309,2.7853,2.4427,3.4274,3.5151,0.0,150.0511,54.6548,-999.25,4.9893,-999.25,241.3356,0.1384,10.8839,4539.1997,129.0116,31.2194,18.133,24.6762,126.3332,147.2638,28.4381,208.4381,16.5545,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 487.0,14.2477,6.4033,2.6564,-999.25,-999.25,7.875,243255.0156,2106.1362,97.3439,3.5081,3.5317,2.7853,2.4448,3.4251,3.5151,0.0,140.9426,53.1192,-999.25,3.9032,-999.25,239.652,0.185,5.5039,4606.7988,145.0314,38.9776,24.9585,31.968,116.6007,135.587,31.968,211.968,15.6359,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 487.5,13.773,6.4033,2.4285,1.8839,-999.25,7.875,243215.75,2134.8496,113.6339,3.5073,3.5301,2.7869,2.4455,3.4251,3.5151,0.0,127.3646,52.459,98.9168,3.4364,-999.25,238.6717,0.177,2.2037,4219.7764,132.4862,42.4742,26.8332,34.6537,106.2988,123.0341,34.6537,214.6537,14.6761,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 488.0,14.5017,6.4038,2.2791,2.0431,-999.25,7.875,243189.6875,2161.9353,125.8698,3.5089,3.5309,2.7861,2.4455,3.4251,3.5151,0.0,119.3812,52.3895,107.1065,3.3872,-999.25,237.0161,0.1508,1.8912,4063.3721,134.4197,43.467,24.9047,34.1859,106.2969,117.8083,34.1859,214.1859,10.3053,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 488.5,15.1553,6.4043,2.218,2.0903,-999.25,7.875,243163.7344,2137.293,136.339,3.5057,3.5324,2.7869,2.4461,3.4267,3.5151,0.0,116.6156,52.5835,109.9798,3.5244,-999.25,236.3779,0.1218,1.4249,3079.4243,119.3898,38.5743,16.6583,27.6163,104.7015,116.2161,35.4022,215.4022,10.5135,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 489.0,13.5649,6.4042,2.2083,2.0907,-999.25,7.875,243136.8438,2115.634,139.1073,3.5089,3.5324,2.7861,2.4434,3.4267,3.5151,0.0,117.3743,53.1527,111.1493,3.9269,-999.25,235.451,0.0929,0.9647,2056.2026,132.8348,42.3694,16.464,29.4167,106.4509,116.1432,55.3433,235.3433,8.7882,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 489.5,12.449,6.4052,2.231,2.1137,-999.25,7.875,243109.8594,2081.1265,138.1896,3.5089,3.5324,2.7877,2.4448,3.4267,3.5151,0.0,118.9175,53.3002,112.6326,4.0313,-999.25,234.0352,0.0982,0.7606,1324.3876,164.3687,42.7836,14.4626,28.6231,106.3164,116.4899,68.8855,248.8855,9.1717,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 490.0,14.6391,6.4052,2.2075,2.1437,-999.25,7.875,243096.6875,2112.1589,144.3628,3.5089,3.5324,2.7877,2.4448,3.4267,3.5151,0.0,117.4197,53.2011,114.027,3.9612,-999.25,234.7644,0.096,0.803,1047.967,140.0567,13.0722,-18.159,-2.5434,107.8304,117.2775,85.6432,265.6432,8.397,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 490.5,16.471,6.4067,2.1689,2.1382,-999.25,7.875,243069.6406,2118.8809,145.9334,3.5151,3.5324,2.7877,2.4448,3.4251,3.5151,0.0,115.1309,53.1077,113.4933,3.8951,-999.25,235.9887,0.067,0.9363,763.8627,90.9811,-21.9664,-55.8445,-38.9055,107.7246,116.4887,93.5722,273.5722,7.8425,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 491.0,16.0921,6.4067,2.15,2.1239,-999.25,7.875,243043.5156,2112.0322,144.4578,3.5151,3.5324,2.7877,2.4448,3.4251,3.5151,0.0,113.9088,53.0361,112.4785,3.8445,-999.25,236.4406,0.0435,1.0652,532.8765,52.8093,-38.6102,-71.7174,-55.1638,107.2797,116.077,92.9442,272.9442,7.9262,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 491.5,15.9839,6.4067,2.1262,2.0961,-999.25,7.875,243017.4531,2073.3828,132.4612,3.5151,3.5324,2.7877,2.4448,3.4251,3.5151,0.0,113.3908,53.4515,111.7163,4.1383,-999.25,237.1577,0.0303,0.9859,390.094,33.3793,-36.4204,-67.013,-51.7167,106.6407,115.7478,90.3374,270.3374,8.2931,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 492.0,18.7826,6.4067,2.0684,2.0371,-999.25,7.875,242978.25,2063.8154,146.2549,3.5151,3.5324,2.7877,2.4448,3.4251,3.5151,0.0,112.6627,54.6421,110.8208,4.9803,-999.25,237.5867,0.0235,0.9223,345.2707,22.2284,-25.3068,-53.4935,-39.4001,104.9246,115.2459,87.3582,267.3582,9.5453,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 492.5,22.8662,6.4067,1.9991,1.9247,-999.25,7.875,242948.3594,2095.4551,161.8292,3.5151,3.5324,2.7877,2.4448,3.4251,3.5151,0.0,113.8165,57.1317,109.3948,6.7409,-999.25,237.0812,0.031,1.0984,407.1759,22.3666,0.9675,-26.8973,-12.9649,102.8398,114.6349,56.3151,236.3151,11.1315,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 493.0,28.2031,6.4088,1.9788,1.9299,-999.25,7.875,242918.0781,2087.333,150.5269,3.5175,3.5332,2.7877,2.4461,3.4267,3.5151,0.0,115.2176,58.3671,112.3073,7.6147,-999.25,240.0173,0.0416,0.7583,426.3915,30.1408,18.431,-14.3804,2.0253,107.2047,116.9122,61.7936,241.7935,8.8831,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 493.5,28.5262,6.4088,1.9887,1.9758,-999.25,7.875,242888.5625,2093.9182,131.6224,3.5175,3.5332,2.7877,2.4461,3.4267,3.5151,0.0,115.6815,58.2891,114.9471,7.5594,-999.25,240.7519,0.0709,0.5956,308.3184,43.8319,7.9856,-27.5721,-9.7932,110.4718,118.382,92.0217,272.0217,7.0791,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 494.0,21.7288,6.4088,2.0599,2.0298,-999.25,7.875,242859.5156,2073.3828,145.0161,3.5175,3.5332,2.7877,2.4461,3.4267,3.5151,0.0,119.6115,58.403,117.9578,7.64,-999.25,243.4147,0.1328,0.3698,182.5737,75.3763,16.3918,-19.8709,-1.7395,115.2713,121.4979,78.2271,258.2271,5.369,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 494.5,16.3511,6.4107,2.0453,2.0359,-999.25,7.875,242845.8906,2099.6194,159.6309,3.5253,3.5332,2.7885,2.4434,3.4267,3.5151,0.0,121.3997,60.2222,121.0255,8.9266,-999.25,245.6731,0.1348,0.3065,187.943,118.8367,32.1577,-5.3939,13.3819,118.1544,124.1899,48.6735,228.6735,5.0317,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 495.0,13.8988,6.4131,1.9298,1.9575,-999.25,7.875,242816.4688,2103.6233,165.5042,3.5285,3.5324,2.7909,2.4482,3.4243,3.5151,0.0,121.0264,64.3427,122.887,11.8407,-999.25,246.0102,0.1208,0.2743,209.3631,152.3641,36.4078,-1.557,17.4254,119.3116,125.2569,36.4767,216.4767,4.8739,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 495.5,14.4117,6.4146,1.7368,1.7755,-999.25,7.875,242786.7188,2103.6008,166.6598,3.5347,3.534,2.7901,2.4448,3.4251,3.5151,0.0,120.7339,71.7914,123.3538,17.1085,-999.25,244.3987,0.1362,0.2954,256.8507,198.2227,29.4226,-7.0912,11.1657,120.0555,125.6187,23.9847,203.9847,4.541,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 496.0,19.9892,6.4129,1.6047,1.6281,-999.25,7.875,242743.8281,2105.436,353.8746,3.5269,3.538,2.7885,2.4461,3.4243,3.5151,0.0,123.8351,78.6364,125.447,21.9494,-999.25,243.2045,0.123,0.2445,357.3946,264.7642,23.8877,-10.8734,6.5072,123.6447,128.9195,6.5072,186.5072,4.1972,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 496.5,29.8111,6.4219,1.5756,1.5816,-999.25,7.875,242683.8906,2113.3979,215.2577,3.5371,3.5522,2.7917,2.4455,3.4243,3.5151,0.0,130.6601,83.2326,130.9417,25.1998,-999.25,243.5284,0.0737,0.1571,470.4182,313.8256,21.4092,-12.9172,4.246,129.7387,134.8702,4.246,184.246,3.7851,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 497.0,39.2124,6.4186,1.6142,1.605,-999.25,7.875,242637.9375,2123.7563,197.1248,3.5261,3.5498,2.7942,2.4448,3.4259,3.5151,0.0,143.417,88.6267,142.494,29.0147,-999.25,244.331,0.0381,0.0949,324.9879,187.5693,18.6952,-15.1552,1.77,140.9831,146.4447,1.77,181.77,3.6113,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 497.5,45.1413,6.4226,1.7249,1.7094,-999.25,7.875,242591.9063,2129.1372,203.511,3.5339,3.5546,2.7942,2.4434,3.4259,3.5157,0.0,160.0198,92.3296,158.7284,31.6334,-999.25,245.2146,0.0201,0.0663,302.3274,145.8796,18.6952,-15.1552,1.77,155.9909,163.4873,1.77,181.77,4.4456,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 498.0,53.2918,6.4207,1.8391,1.8589,-999.25,7.875,242544.1563,2129.126,203.3159,3.5269,3.5538,2.795,2.4448,3.4267,3.5151,0.0,176.1251,95.4269,178.2696,33.8239,-999.25,247.7072,0.0095,0.0718,426.6354,161.8495,18.6952,-15.1552,1.77,172.724,182.0091,1.77,181.77,4.9778,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 498.5,63.0112,6.4248,1.9287,2.023,-999.25,7.875,242494.6094,2144.6926,209.6193,3.53,3.553,2.7933,2.4475,3.4354,3.5151,0.0,189.5312,98.1306,198.9776,35.7359,-999.25,247.97,0.0077,0.1027,457.7964,114.7897,6.8842,-26.7804,-9.9481,187.9255,200.5832,26.0519,206.0519,6.2914,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 499.0,70.6555,6.4222,2.0158,2.0697,-999.25,7.875,242469.0156,2158.6079,202.5721,3.5245,3.5506,2.7966,2.4461,3.4338,3.5151,0.0,197.9416,98.2709,203.3261,35.8352,-999.25,245.5361,0.007,0.0843,328.0598,74.4801,-16.7379,-50.0308,-33.3843,196.9955,204.2723,74.6157,254.6157,3.6088,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 499.5,75.5411,6.4243,2.1148,2.1433,-999.25,7.875,242418.625,2194.1487,196.2361,3.5261,3.5641,2.7974,2.4461,3.4243,3.5151,0.0,202.7584,96.1215,205.5806,34.3151,-999.25,242.0737,0.0075,0.0731,198.4816,48.044,-40.3599,-73.2812,-56.8205,201.7428,206.1599,123.1795,303.1795,2.209,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 500.0,70.9212,6.4227,2.1875,2.2028,-999.25,7.875,242370.6563,2165.6289,207.6732,3.5261,3.5522,2.7942,2.4468,3.4338,3.5151,0.0,201.2823,92.2918,202.6657,31.6066,-999.25,239.1947,0.0078,0.088,142.8154,28.7896,-36.3081,-66.7578,-51.533,199.6169,203.0415,128.467,308.467,1.7904,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 500.5,56.6735,6.4232,2.2272,2.2455,-999.25,7.875,242324.4688,2149.8438,203.416,3.5245,3.5609,2.795,2.4475,3.4267,3.5151,0.0,194.0733,87.3728,195.4422,28.1278,-999.25,236.7589,0.0081,0.1534,133.6811,16.5129,-36.3081,-66.7578,-51.533,191.4489,195.4474,128.467,308.467,2.2404,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 501.0,41.3508,6.4237,2.2556,2.2938,-999.25,7.875,242260.7188,2135.0681,185.8814,3.5261,3.5641,2.7925,2.4468,3.4267,3.5151,0.0,183.2952,81.4016,186.0338,23.905,-999.25,234.5856,0.008,0.2757,158.0032,11.7591,-29.8574,-59.5376,-44.6975,179.4552,184.9585,123.278,303.278,3.283,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 501.5,32.4749,6.4221,2.2734,2.3391,-999.25,7.875,242225.0313,2144.1538,197.1074,3.5269,3.5546,2.7966,2.4482,3.4251,3.5151,0.0,172.6445,76.0702,177.3492,20.1345,-999.25,232.9748,0.0093,0.3996,169.9908,14.1333,-25.307,-54.3666,-39.8368,165.0715,173.9199,120.765,300.765,5.5307,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 502.0,31.4682,6.4204,2.1946,2.3205,-999.25,7.875,242190.3594,2184.2249,212.9471,3.5245,3.5514,2.7982,2.4461,3.4259,3.5151,0.0,160.8771,73.4085,169.9052,18.2521,-999.25,231.9662,0.0119,0.7315,257.9229,19.7878,-11.9167,-37.5412,-24.729,154.3716,166.4216,118.6173,298.6173,7.7339,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 502.5,31.1184,6.4235,2.0889,2.2583,-999.25,7.875,242155.375,2161.3965,198.4254,3.53,3.5577,2.7958,2.4461,3.4259,3.5151,0.0,152.9502,73.3903,165.2849,18.2392,-999.25,232.3953,0.0131,1.3445,368.6475,20.3307,20.3138,-1.9613,9.1762,150.4189,164.7506,93.0544,273.0544,9.1907,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 503.0,30.1691,6.4224,1.9982,2.1724,-999.25,7.875,242117.7969,2155.74,215.9513,3.5253,3.5538,2.7998,2.4475,3.4259,3.5151,0.0,150.3768,75.4743,163.5323,19.7131,-999.25,233.7023,0.0133,1.5679,404.5025,19.1755,49.8747,30.6716,40.2732,150.1953,165.4637,69.6088,249.6088,9.6983,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 503.5,32.0635,6.4233,1.9832,2.1232,-999.25,7.875,242097.7031,2109.3481,248.303,3.5277,3.5546,2.7998,2.4461,3.4267,3.5151,0.0,151.5267,76.5933,162.272,20.5044,-999.25,234.743,0.0135,1.2495,336.031,19.0737,47.6327,28.0018,37.8172,151.3462,163.8392,72.5646,252.5646,7.9456,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 504.0,37.9133,6.4236,2.0211,2.1124,-999.25,7.875,242058.1094,2105.7339,266.518,3.5316,3.5546,2.7982,2.4455,3.4259,3.5151,0.0,153.6771,76.1624,160.6539,20.1997,-999.25,235.4486,0.0115,1.2,368.1764,17.3923,29.024,6.0538,17.5389,153.5642,161.6377,78.8309,258.8309,5.156,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 504.5,44.9747,6.4256,2.062,2.1292,-999.25,7.875,242020.0781,2115.5881,167.2997,3.5347,3.5577,2.7974,2.4468,3.4251,3.5151,0.0,154.3061,74.9121,159.3442,19.3155,-999.25,235.9193,0.0115,1.2321,478.4242,20.5959,-1.5767,-30.2355,-15.9061,154.0511,160.3522,86.6191,266.6191,4.0566,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 505.0,43.6632,6.4221,2.0717,2.1393,-999.25,7.875,241982.875,2106.1475,93.6066,3.5277,3.5522,2.7982,2.4482,3.4251,3.5151,0.0,152.8441,73.9187,157.745,18.6129,-999.25,236.2404,0.0145,1.5159,610.6432,26.7121,-18.379,-49.6448,-34.0119,151.995,159.4063,91.7189,271.7189,4.8089,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 505.5,32.0969,6.4214,2.0737,2.1429,-999.25,7.875,241929.4531,2107.7305,120.8596,3.5277,3.553,2.7982,2.4468,3.4235,3.5151,0.0,151.6466,73.3447,156.4954,18.207,-999.25,236.0058,0.0193,2.4261,876.5242,30.5864,-13.1489,-43.4832,-28.3161,149.0869,158.6662,94.8822,274.8822,6.2239,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 506.0,24.0154,6.4238,2.046,2.0836,-999.25,7.875,241893.9844,2128.4146,190.3383,3.5269,3.5554,2.8014,2.4468,3.4259,3.5151,0.0,154.1331,75.7343,156.5569,19.897,-999.25,236.6068,0.0214,3.8069,1370.6489,32.1853,15.5495,-11.0867,2.2314,150.1865,161.9345,64.7566,244.7566,7.4428,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 506.5,27.89,6.4265,1.9935,1.9948,-999.25,7.875,241855.7344,2147.9629,170.2844,3.5277,3.5601,2.803,2.4461,3.4274,3.5151,0.0,161.2492,81.5078,160.8078,23.98,-999.25,236.9934,0.0256,5.9658,1878.5292,51.905,22.5233,-1.5562,10.4836,156.3219,170.7399,51.7291,231.7291,8.5956,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 507.0,40.4281,6.4246,1.9292,1.9,-999.25,7.875,241805.3281,2097.8875,160.829,3.5269,3.5554,2.8038,2.4468,3.4259,3.5151,0.0,172.4858,90.1285,169.3721,30.0767,-999.25,238.034,0.0199,10.1332,2534.1448,64.5058,26.8091,8.0462,17.4277,163.6975,183.0362,62.9409,242.9409,10.9224,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 507.5,55.1255,6.4228,2.0132,1.9743,-999.25,7.875,241758.7188,2071.3528,162.0357,3.5277,3.5538,2.8022,2.4461,3.4235,3.5151,0.0,185.0503,92.1675,181.2495,31.5187,-999.25,238.7369,0.0231,17.3463,3835.3193,98.7855,27.1008,12.2246,19.6627,171.3884,195.0008,98.3596,278.3596,12.7257,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 508.0,64.5368,6.4219,2.0484,2.012,-999.25,7.875,241735.4063,2089.4436,179.4193,3.5261,3.5546,2.7974,2.4468,3.4259,3.5151,0.0,189.3878,92.633,185.8675,31.848,-999.25,239.025,0.0295,25.6504,4616.3496,114.0971,49.2026,36.3682,42.7854,175.6645,199.9202,83.9449,263.9449,12.8024,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 508.5,65.1438,6.4211,2.0753,2.0799,-999.25,7.875,241687.0469,2093.6885,246.5303,3.5277,3.5514,2.8006,2.4468,3.4267,3.5103,0.0,189.4438,91.4909,189.6792,31.0402,-999.25,238.8465,0.0448,23.8546,3508.8972,105.6924,61.8551,49.6805,55.7678,175.9362,200.6288,73.7562,253.7562,13.0416,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 509.0,60.1509,6.4272,2.1226,2.1569,-999.25,7.875,241641.7969,2108.0979,295.2308,3.5371,3.5546,2.803,2.4461,3.4259,3.5151,0.0,187.5715,88.6026,190.4135,28.9976,-999.25,238.1034,0.0658,15.7816,1853.1351,67.8506,63.2105,50.976,57.0932,172.7444,196.2793,65.7842,245.7842,12.7395,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 509.5,54.914,6.427,2.1826,2.2307,-999.25,7.875,241597.3594,2091.6809,335.5725,3.5261,3.5546,2.8135,2.4475,3.4243,3.5151,0.0,184.3904,84.6495,188.2469,26.2019,-999.25,237.0641,0.0762,10.6185,997.1594,39.4322,60.2982,46.5558,53.427,170.2662,189.6755,57.9984,237.9984,10.8005,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 510.0,50.1609,6.4255,2.2145,2.2772,-999.25,7.875,241535.6563,2114.3726,98.0997,3.5324,3.5514,2.8038,2.4489,3.4251,3.5151,0.0,178.1181,80.4994,182.9817,23.2669,-999.25,236.1041,0.0708,6.8199,501.9441,22.9836,57.558,40.5808,49.0694,164.6938,180.0758,53.184,233.184,8.9898,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 510.5,43.2036,6.4235,2.2187,2.2987,-999.25,7.875,241498.4844,2138.9915,142.7839,3.523,3.5538,2.8055,2.4475,3.4259,3.5151,0.0,166.7515,75.1225,172.6445,19.4643,-999.25,234.8561,0.0437,4.6429,376.4933,20.8444,43.3171,24.8195,34.0683,155.7478,170.4695,49.318,229.318,9.0911,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 511.0,36.5235,6.4235,2.18,2.286,-999.25,7.875,241463.6719,2157.7139,225.7075,3.5238,3.5538,2.8038,2.4482,3.4259,3.5151,0.0,152.4464,69.8291,159.8958,15.7207,-999.25,233.5897,0.0322,4.3065,474.4116,28.8027,26.2272,4.7534,15.4903,144.1081,157.5816,55.6077,235.6077,8.9682,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 511.5,31.9261,6.4219,2.1662,2.2478,-999.25,7.875,241431.5469,2174.4165,263.7707,3.5238,3.5506,2.8022,2.4475,3.4267,3.5151,0.0,140.4159,64.7382,145.9831,12.1203,-999.25,232.4077,0.0211,3.8025,561.6833,31.6434,10.8738,-12.8665,-0.9964,130.3582,142.2742,61.9565,241.9565,8.77,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 512.0,27.4953,6.423,2.1592,2.1784,-999.25,7.875,241402.3125,2149.2815,215.0563,3.5238,3.5522,2.8038,2.4482,3.4259,3.5151,0.0,130.9509,60.5923,132.4126,9.1883,-999.25,231.4783,0.016,4.8298,787.3915,34.5836,-6.801,-32.7794,-19.7902,120.9415,132.0204,92.2007,272.2007,8.6878,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 512.5,25.9556,6.4251,2.1005,2.1042,-999.25,7.875,241387.75,2174.9219,119.138,3.523,3.5506,2.8047,2.4482,3.4338,3.5151,0.0,122.9002,58.4153,123.2648,7.6487,-999.25,231.1306,0.0119,3.8667,854.4612,29.68,7.6727,-24.0018,-8.1646,116.0505,124.8439,83.6604,263.6604,7.1444,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 513.0,26.1804,6.4209,2.0425,2.0548,-999.25,7.875,241359.5156,2159.8359,96.4243,3.5222,3.5506,2.8022,2.4482,3.4259,3.5137,0.0,116.3239,56.8851,117.0784,6.5666,-999.25,231.2911,0.0084,2.688,850.9292,22.1284,30.3993,-6.3236,12.0378,112.3692,118.6643,74.7598,254.7598,5.3045,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 513.5,23.5574,6.4178,2.0021,2.014,-999.25,7.875,241332.0156,2175.5291,100.1829,3.5191,3.5396,2.8038,2.4468,3.429,3.5151,0.0,112.5945,56.2046,113.2735,6.0853,-999.25,231.5731,0.0074,2.3154,856.4424,19.0895,37.9993,0.0394,19.0194,109.7884,114.8343,69.5112,249.5112,4.3954,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 514.0,19.0033,6.4185,1.9816,1.9953,-999.25,7.875,241303.9531,2156.8076,99.192,3.5175,3.5451,2.8047,2.4475,3.4251,3.5157,0.0,111.0758,56.0439,111.8701,5.9716,-999.25,231.868,0.0066,1.9554,874.0624,17.6019,25.4235,-12.4877,6.4679,109.2984,113.3843,73.6455,253.6455,3.5688,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 514.5,16.8541,6.4182,1.9717,2.0033,-999.25,7.875,241262.5313,2166.9375,105.4242,3.5183,3.549,2.799,2.4475,3.4259,3.5151,0.0,111.3251,56.4791,113.1793,6.2795,-999.25,232.1192,0.005,1.3971,893.6979,15.1239,-12.1936,-47.6502,-29.9219,110.6889,114.3032,85.6128,265.6128,3.0581,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 515.0,16.924,6.4144,1.9747,2.0487,-999.25,7.875,241233.6875,2160.9482,107.2464,3.5167,3.5396,2.7958,2.4502,3.4259,3.5151,0.0,114.7954,58.21,119.1878,7.5035,-999.25,232.4149,0.0049,1.377,777.9441,14.3683,-38.8518,-71.7495,-55.3006,114.3648,120.8524,95.2845,275.2845,5.342,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 515.5,19.4355,6.4124,1.981,2.0711,-999.25,7.875,241203.5781,2137.9932,107.6839,3.5159,3.5364,2.7974,2.4475,3.4251,3.5151,0.0,119.6716,60.6006,125.1423,9.1942,-999.25,232.9857,0.0049,1.11,537.8057,15.5889,-33.0281,-64.4285,-48.7283,119.6183,128.2365,97.5131,277.5131,6.8729,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 516.0,23.9654,6.4151,2.0213,2.108,-999.25,7.875,241175.2344,2120.6934,96.8369,3.5206,3.5348,2.8006,2.4475,3.4267,3.5151,0.0,126.8741,63.2468,132.272,11.0656,-999.25,233.9699,0.0053,0.7443,416.8728,21.4501,-20.6643,-52.0772,-36.3708,127.0547,135.6361,86.0716,266.0716,6.5162,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 516.5,30.493,6.417,1.9302,2.0059,-999.25,7.875,241138.7813,2081.895,53.3616,3.5245,3.5348,2.803,2.4468,3.4267,3.5151,0.0,132.8419,69.2603,137.9812,15.3185,-999.25,235.3244,0.0063,0.4722,325.4259,29.7342,23.1157,-6.9752,8.0702,132.3555,141.2319,66.0085,246.0085,6.4993,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 517.0,36.1905,6.4219,1.9098,1.9712,-999.25,7.875,241120.0938,2083.0198,69.8652,3.5277,3.5498,2.8014,2.4482,3.4235,3.5151,0.0,134.69,70.845,138.953,16.4392,-999.25,237.3708,0.0095,0.3543,274.9126,33.3256,35.62,4.2626,19.9413,134.2581,140.863,60.9586,240.9586,4.8472,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 517.5,35.3577,6.4232,1.8949,1.9366,-999.25,7.875,241082.9219,2071.9377,71.7803,3.5277,3.5506,2.803,2.4475,3.4259,3.5151,0.0,132.6729,70.3331,135.5862,16.0772,-999.25,239.3197,0.0119,0.2922,238.7215,27.8629,40.9245,8.1272,24.5258,132.115,136.7439,52.1415,232.1415,3.5469,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 518.0,30.2391,6.4267,1.8722,1.9068,-999.25,7.875,241046.9688,2088.916,82.1483,3.5261,3.5554,2.8022,2.4468,3.4346,3.5151,0.0,125.9807,67.8406,128.3777,14.3144,-999.25,240.4934,0.0195,0.3046,222.3532,29.388,44.4126,9.2943,26.8535,124.9087,129.4295,44.5729,224.5729,3.7728,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 518.5,26.7175,6.4231,1.9088,1.9416,-999.25,7.875,241009.7656,2118.5828,91.2015,3.5277,3.5522,2.803,2.4455,3.4259,3.5151,0.0,117.5713,62.3576,119.7419,10.4368,-999.25,241.3811,0.0337,0.3609,201.0985,34.8453,46.1229,9.597,27.86,115.4801,121.2221,39.6407,219.6407,5.1212,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 519.0,24.8689,6.4224,1.9751,1.9863,-999.25,7.875,240969.1563,2135.3313,91.9985,3.5269,3.5522,2.8047,2.4461,3.4251,3.5123,0.0,110.1079,56.172,110.9319,6.0622,-999.25,242.3738,0.0391,0.3978,190.9029,44.8526,40.1581,2.057,21.1075,107.5489,114.1995,37.6182,217.6182,6.2389,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 519.5,23.4616,6.4246,1.9981,1.9674,-999.25,7.875,240944.5781,2185.7966,85.4182,3.5355,3.5483,2.8038,2.4461,3.4251,3.5151,0.0,103.8697,52.2218,102.5078,3.2686,-999.25,242.6324,0.0444,0.3689,214.9396,75.9339,29.9283,-3.4798,13.2243,100.6005,108.2603,49.0279,229.0279,7.5628,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 520.0,24.1628,6.4247,2.0445,1.9918,-999.25,7.875,240920.6406,2179.8657,66.7964,3.5339,3.5506,2.8038,2.4455,3.4251,3.5151,0.0,102.0073,50.0012,99.5157,1.6982,-999.25,243.3203,0.0535,0.2946,176.0081,96.2685,21.1104,-9.9573,5.5766,98.6595,106.1719,89.5153,269.5153,7.4913,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 520.5,21.6671,6.4236,2.162,2.115,-999.25,7.875,240896.0781,2172.4551,199.7927,3.5277,3.5506,2.8071,2.4441,3.429,3.5123,0.0,106.2769,49.1748,103.9975,1.1137,-999.25,246.3219,0.0495,0.2586,192.0506,130.7374,34.4187,3.3454,18.8821,104.1325,110.0397,81.2844,261.2844,5.4516,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 521.0,17.1497,6.4226,2.3628,2.3036,-999.25,7.875,240871.5,2142.6167,91.5763,3.5285,3.5498,2.8038,2.4441,3.4267,3.5151,0.0,115.4696,48.9185,112.5388,0.9325,-999.25,249.8327,0.0439,0.1389,188.1059,186.9599,45.6864,15.0545,30.3704,113.4272,120.9062,69.1508,249.1508,6.266,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 521.5,15.9572,6.4224,2.5791,2.508,-999.25,7.875,240859.2188,2141.9277,47.1452,3.5269,3.5514,2.803,2.4434,3.4274,3.5151,0.0,125.1968,48.6048,121.6413,0.7106,-999.25,253.9029,0.0329,0.121,258.1266,180.0289,48.7165,21.7994,35.2579,122.8295,131.7879,86.0317,266.0316,6.8683,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 522.0,17.3146,6.4227,2.7761,2.7523,-999.25,7.875,240834.6563,2169.2542,63.5925,3.5285,3.5506,2.8038,2.4455,3.4274,3.5123,0.0,133.2558,48.0691,131.949,0.3318,-999.25,257.9297,0.0266,0.109,334.492,205.057,34.0908,9.0067,21.5487,131.3752,142.0687,100.2801,280.2801,7.72,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 522.5,22.4124,6.4279,2.9327,3.0107,-999.25,7.875,240811.3438,2140.0244,167.2022,3.5418,3.553,2.8047,2.4441,3.4251,3.5151,0.0,139.9471,47.7476,143.5177,0.1044,-999.25,260.8291,0.0248,0.1045,416.5493,210.1869,9.7427,-14.3661,-2.3117,138.7739,149.911,89.3608,269.3608,7.7179,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 523.0,33.4417,6.424,3.0296,3.132,-999.25,7.875,240776.1563,2164.5164,49.3609,3.5285,3.5569,2.803,2.4427,3.4259,3.5151,0.0,145.9747,48.2046,150.7847,0.4276,-999.25,260.9755,0.0283,0.1317,501.0528,178.1469,-18.1722,-42.1113,-30.1418,145.7496,155.9039,77.5009,257.5009,6.8218,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 523.5,48.3072,6.4259,3.0649,3.1413,-999.25,7.875,240751.7031,2143.6484,336.0067,3.5371,3.553,2.8055,2.4414,3.4251,3.5157,0.0,152.1902,49.8188,155.8854,1.5692,-999.25,259.3971,0.0486,0.2088,674.3356,217.5099,-19.8737,-43.5664,-31.7201,151.9464,158.5495,78.3976,258.3976,4.3558,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 524.0,57.353,6.4254,3.0608,3.109,-999.25,7.875,240726.9063,2155.2246,314.0151,3.5269,3.5577,2.8087,2.4427,3.4251,3.5151,0.0,158.8332,52.3956,161.33,3.3915,-999.25,254.8284,0.0553,0.2213,788.2231,248.0401,-28.8959,-52.574,-40.7349,158.3676,162.7269,77.7762,257.7762,2.7846,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 524.5,54.6167,6.4238,2.9188,2.975,-999.25,7.875,240699.9531,2172.054,338.2376,3.5308,3.5554,2.8022,2.4427,3.4251,3.5151,0.0,163.227,56.9036,166.4013,6.5797,-999.25,251.8301,0.0422,0.1315,464.6942,201.1902,-35.7405,-59.1973,-47.4689,163.0227,166.9229,59.2111,239.2111,2.3867,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 525.0,44.4168,6.4232,2.6284,2.6812,-999.25,7.875,240668.4531,2181.2773,334.1735,3.5285,3.553,2.8038,2.4434,3.4259,3.5151,0.0,161.7236,62.6434,165.0318,10.6389,-999.25,250.6688,0.0453,0.0968,304.4901,227.6674,-75.8848,-100.8148,-88.3498,161.6658,165.3296,91.6502,271.6501,2.2277,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 525.5,30.7612,6.4244,2.3977,2.4461,-999.25,7.875,240651.25,2193.8843,341.3369,3.53,3.5577,2.8022,2.4448,3.4235,3.5151,0.0,157.0376,66.5248,160.249,13.3838,-999.25,250.8829,0.0379,0.0709,204.0142,180.802,-33.7528,-59.1552,-46.454,156.9833,160.3033,88.546,268.546,2.0915,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 526.0,22.6897,6.423,2.2253,2.2718,-999.25,7.875,240616.5,2178.5012,336.6203,3.5316,3.5506,2.7998,2.4427,3.429,3.5151,0.0,153.0767,69.4967,156.302,15.4856,-999.25,247.5708,0.0304,0.0513,185.8592,132.7664,8.3792,-17.4955,-4.5581,152.9273,156.4514,85.4419,265.4419,2.2875,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 526.5,27.8699,6.425,2.1324,2.1785,-999.25,7.875,240579.25,2196.6143,7.642,3.5261,3.5601,2.803,2.4448,3.4259,3.5151,0.0,151.301,71.2196,154.5255,16.7041,-999.25,245.4805,0.0263,0.0509,238.1908,112.6353,50.5112,24.1642,37.3377,150.9399,154.8866,82.3377,262.3377,2.5912,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 527.0,41.6444,6.4287,2.1481,2.1932,-999.25,7.875,240543.9688,2175.2546,357.462,3.5285,3.5641,2.8014,2.4434,3.4338,3.5151,0.0,155.0543,72.0958,158.1685,17.3238,-999.25,244.7577,0.0234,0.068,398.2026,108.0854,92.6433,65.8239,79.2336,154.0986,159.0049,79.2336,259.2336,3.1616,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 527.5,59.4603,6.4273,2.2533,2.2757,-999.25,7.875,240508.6875,2174.4626,335.7237,3.53,3.5641,2.8014,2.4455,3.4259,3.5151,0.0,166.705,73.8134,168.1687,18.5385,-999.25,244.2529,0.0181,0.0885,662.0135,96.4322,92.6433,65.8239,79.2336,164.7531,169.8769,79.2336,259.2336,3.129,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 528.0,69.0948,6.4266,2.3799,2.3603,-999.25,7.875,240454.5313,2146.7698,354.4807,3.5285,3.5641,2.803,2.4448,3.4243,3.5151,0.0,182.377,76.6339,180.7923,20.5332,-999.25,245.3531,0.0132,0.1155,1072.1074,96.3737,92.6433,65.8239,79.2336,178.6903,184.0188,79.2336,259.2336,2.9376,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 528.5,63.7176,6.4241,2.3713,2.3473,-999.25,7.875,240411.0625,2129.9404,350.7163,3.5347,3.5514,2.803,2.4434,3.4267,3.513,0.0,195.5464,82.5406,193.5615,24.7105,-999.25,247.461,0.0127,0.1615,769.0348,79.6226,92.6433,65.8239,79.2336,190.9885,197.0898,79.2336,259.2336,3.1303,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 529.0,53.9288,6.4239,2.3579,2.3517,-999.25,7.875,240367.5938,2134.2996,313.7147,3.5269,3.5569,2.8038,2.4448,3.4243,3.5151,0.0,203.7048,86.5512,203.3218,27.5468,-999.25,250.8022,0.0184,0.2737,546.2275,74.7033,91.1921,64.7007,77.9464,198.8108,206.4509,77.9464,257.9464,3.748,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 529.5,48.415,6.425,2.2919,2.3247,-999.25,7.875,240321.3906,2095.4204,279.6671,3.53,3.5546,2.803,2.4448,3.4274,3.5151,0.0,206.4546,90.2988,209.6126,30.1972,-999.25,251.3026,0.0194,0.4141,442.3444,62.0098,87.3778,61.7485,74.5631,204.4567,211.4671,74.5631,254.5631,3.3458,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 530.0,51.9124,6.4255,2.2515,2.3121,-999.25,7.875,240298.375,2080.6794,269.499,3.5292,3.5601,2.803,2.4441,3.4251,3.5151,0.0,208.4492,92.8571,214.1931,32.0064,-999.25,253.8837,0.0188,0.5872,504.4234,66.9619,79.4792,56.0946,67.7869,207.8737,216.4858,67.7869,247.7869,4.0235,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 530.5,60.8736,6.4239,2.2019,2.2776,-999.25,7.875,240253.3594,2086.8513,270.6802,3.5277,3.5577,2.8022,2.4455,3.4235,3.5151,0.0,211.4705,96.3818,218.7657,34.4992,-999.25,254.9194,0.024,0.723,597.9317,87.7133,74.7379,52.7304,63.7341,212.2871,222.8109,63.7341,243.7341,4.7879,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 531.0,66.166,6.4226,2.1331,2.2086,-999.25,7.875,240204.6406,2114.2461,272.1137,3.5285,3.5514,2.803,2.4448,3.4251,3.5151,0.0,215.3913,101.3406,222.9952,38.0061,-999.25,255.0988,0.0254,0.7031,719.4696,139.5889,74.9917,53.5492,64.2704,216.6585,227.6987,64.2704,244.2704,4.9287,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 531.5,69.7859,6.4244,2.0759,2.1526,-999.25,7.875,240151.3281,2125.6038,265.3723,3.5285,3.5546,2.8006,2.4448,3.4298,3.5151,0.0,218.7401,105.6105,226.8108,41.0258,-999.25,254.9402,0.0227,0.7021,934.2173,227.6026,75.785,55.3314,65.5582,219.7513,231.5497,65.5582,245.5582,5.1851,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 532.0,72.2389,6.4221,2.0551,2.1375,-999.25,7.875,240069.1094,2098.4038,262.2926,3.5269,3.5546,2.8006,2.4434,3.4259,3.5151,0.0,221.3963,107.8706,230.286,42.6242,-999.25,255.5811,0.0219,0.7844,1238.7623,283.2724,77.0864,56.5247,66.8056,222.2925,234.8291,66.8056,246.8056,5.4547,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 532.5,72.0255,6.4238,2.0775,2.1653,-999.25,7.875,240014.2969,2122.6899,274.8233,3.5277,3.5546,2.8022,2.4461,3.4259,3.5151,0.0,223.4619,107.8035,233.0779,42.5768,-999.25,256.6122,0.0202,0.7251,1023.0032,247.9566,74.6983,53.8837,64.291,224.0333,238.5953,70.3136,250.3136,6.2776,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 533.0,71.1825,6.4245,2.1273,2.2214,-999.25,7.875,239959.6406,2119.5115,277.8151,3.5308,3.5569,2.803,2.4434,3.4243,3.5151,0.0,225.1093,106.24,235.459,41.471,-999.25,255.351,0.0181,1.0038,1118.0702,200.3035,65.2381,44.4515,54.8448,224.6378,239.1349,72.3341,252.3341,6.2541,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 533.5,69.7074,6.4262,2.2142,2.2859,-999.25,7.875,239906.4844,2107.8223,262.3302,3.5355,3.5577,2.7982,2.4455,3.4267,3.5151,0.0,225.9739,102.6177,233.9127,38.9093,-999.25,254.6092,0.0199,1.8028,1616.2971,136.3652,39.9049,21.4406,30.6728,222.6878,238.2133,73.4096,253.4096,6.7546,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 534.0,66.5955,6.4247,2.3247,2.3371,-999.25,7.875,239859.0781,2093.126,266.6938,3.5316,3.5562,2.799,2.4448,3.4274,3.5151,0.0,224.8937,97.251,226.7037,35.1139,-999.25,254.7079,0.0249,2.9698,1914.1592,104.9082,5.0737,-11.432,-3.1791,216.3386,230.8431,99.7101,279.7101,6.6234,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 534.5,63.8749,6.4223,2.294,2.2925,-999.25,7.875,239836.7656,2109.4858,277.4775,3.5308,3.5506,2.7982,2.4455,3.4267,3.5151,0.0,217.9482,95.3646,218.2421,33.7798,-999.25,252.9363,0.0378,2.9835,2669.6887,124.3999,-14.6474,-30.7852,-22.7163,204.1466,223.1215,107.2645,287.2645,9.0619,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 535.0,63.0279,6.422,2.1997,2.2015,-999.25,7.875,239789.5313,2121.7375,269.0822,3.5285,3.5554,2.7998,2.4441,3.4259,3.5123,0.0,209.149,95.2699,209.5082,33.7128,-999.25,251.1359,0.0501,3.2755,3944.0171,155.814,-13.7233,-30.6259,-22.1746,193.5613,215.1103,104.3819,284.3818,10.7038,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 535.5,60.462,6.4227,2.1433,2.1177,-999.25,7.875,239740.8125,2108.7285,270.2908,3.5292,3.553,2.803,2.4475,3.4243,3.511,0.0,203.2093,94.9037,200.8376,33.4538,-999.25,249.7915,0.05,4.4469,7070.9819,201.6299,3.887,-11.4891,-3.8011,184.745,212.8253,87.4295,267.4295,14.2343,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 536.0,58.4071,6.4284,2.1207,2.082,-999.25,7.875,239692.7344,2123.3901,279.5319,3.5418,3.5577,2.8022,2.4455,3.4243,3.5137,0.0,198.5055,93.6256,194.8174,32.5499,-999.25,249.303,0.038,5.8518,11547.5674,214.1745,17.7336,4.1406,10.9371,179.1864,213.022,67.9372,247.9372,17.2276,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 536.5,59.1653,6.4249,2.0891,2.0725,-999.25,7.875,239623.3125,2105.9177,272.593,3.5292,3.5577,2.8038,2.4455,3.4235,3.5151,0.0,192.9559,92.2965,191.233,31.61,-999.25,249.8037,0.0265,6.2575,11451.209,156.115,21.2768,6.1167,13.6967,178.3642,208.3974,67.3917,247.3917,15.4209,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 537.0,55.5525,6.431,2.0216,2.0827,-999.25,7.875,239579.0625,2132.4521,275.1123,3.5418,3.5617,2.8038,2.4461,3.4259,3.5137,0.0,182.8106,90.2748,187.9862,30.1802,-999.25,249.2876,0.0238,4.8216,6053.5479,114.9799,4.1277,-14.4966,-5.1844,172.722,195.0483,90.8276,270.8276,12.0341,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 537.5,42.9182,6.4281,1.9076,2.0346,-999.25,7.875,239533.7656,2134.8384,263.7939,3.5277,3.5625,2.8079,2.4461,3.4251,3.5151,0.0,170.1412,88.9221,180.9904,29.2236,-999.25,246.6311,0.0216,5.12,3237.3123,83.4044,24.3087,2.7219,13.5153,162.1142,180.2254,106.7495,286.7495,10.7159,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 538.0,29.9559,6.4306,1.7623,1.9858,-999.25,7.875,239489.1094,2140.0244,222.3446,3.5355,3.5641,2.8038,2.4468,3.4259,3.5157,0.0,153.0471,86.5515,171.9003,27.547,-999.25,242.8649,0.0243,7.3885,1922.2957,66.3111,53.3797,33.3915,43.3856,144.5318,162.6338,91.114,271.114,12.1714,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 538.5,22.6735,6.4315,1.6731,1.9587,-999.25,7.875,239447.5313,2146.7002,292.214,3.5292,3.5712,2.803,2.4482,3.4259,3.5171,0.0,139.4304,83.1447,162.7639,25.1377,-999.25,239.3507,0.0287,9.8236,1051.828,55.5044,57.4003,38.671,48.0356,127.667,147.2852,76.1209,256.1209,14.6495,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 539.0,19.6834,6.4301,1.6704,1.969,-999.25,7.875,239427.6875,2128.7932,302.9976,3.5277,3.5712,2.8022,2.4475,3.4259,3.5157,0.0,135.1658,80.8634,158.9242,23.5243,-999.25,237.8649,0.033,6.3365,1037.5101,63.5148,40.7275,20.2363,30.4819,119.6422,137.1377,68.8368,248.8369,13.9283,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 539.5,20.3698,6.4316,1.6703,1.9433,-999.25,7.875,239389.2656,2144.2222,224.4401,3.5269,3.5712,2.803,2.4482,3.4298,3.5157,0.0,133.6981,80.0331,154.976,22.9372,-999.25,236.983,0.0427,4.2109,1138.3621,90.1247,15.5554,-7.3062,4.1246,117.6402,133.9385,73.5562,253.5562,13.3885,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 540.0,25.8321,6.4319,1.6673,1.8538,-999.25,7.875,239351.4063,2125.0984,203.4084,3.5308,3.572,2.8038,2.4468,3.4259,3.5164,0.0,135.7662,81.4318,150.1917,23.9263,-999.25,236.1175,0.0696,2.3835,1025.207,138.6736,2.8708,-24.4013,-10.7652,124.4997,138.9506,81.5514,261.5514,11.4675,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 540.5,34.7617,6.4345,1.6975,1.8118,-999.25,7.875,239308.8906,2127.106,248.7,3.5308,3.5704,2.803,2.4475,3.4346,3.5171,0.0,141.6929,83.4596,150.7359,25.3604,-999.25,234.1821,0.0894,1.5731,987.5952,174.8012,-12.4497,-41.0033,-26.7265,135.2296,148.7319,91.9332,271.9331,9.7785,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 541.0,44.4574,6.4354,1.7308,1.8264,-999.25,7.875,239245.8906,2103.7959,281.6336,3.5347,3.5704,2.8119,2.4461,3.4274,3.5157,0.0,147.9083,85.4475,155.8381,26.7663,-999.25,233.4358,0.0991,1.432,834.5276,145.8044,-36.7051,-63.7933,-50.2492,142.0118,156.2483,106.6074,286.6074,9.637,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 541.5,51.91,6.4327,1.7468,1.8568,-999.25,7.875,239201.9375,2094.3191,283.4238,3.5316,3.5727,2.8038,2.4475,3.4267,3.5157,0.0,151.6537,86.7945,161.1224,27.7189,-999.25,235.4939,0.0729,1.8759,605.5333,88.2062,-38.4461,-61.6804,-50.0632,143.6346,162.1212,115.9033,295.9033,12.0775,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 542.0,49.3524,6.4333,1.7192,1.8766,-999.25,7.875,239157.8594,2116.8271,279.4274,3.5347,3.5712,2.8063,2.4468,3.4259,3.5151,0.0,151.0262,87.8438,164.8994,28.4609,-999.25,236.06,0.0722,2.6089,601.1749,67.2857,-40.2945,-56.2296,-48.262,143.6754,170.235,112.853,292.853,16.9476,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 542.5,43.0993,6.4328,1.7082,1.9406,-999.25,7.875,239115.0469,2079.8875,275.0094,3.5339,3.5704,2.8063,2.4461,3.4267,3.5151,0.0,151.2896,88.5116,171.8485,28.9332,-999.25,237.5624,0.0569,3.2726,840.8106,58.4648,-37.963,-49.7765,-43.8698,152.0544,181.5795,101.9191,281.9191,17.7316,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 543.0,44.5732,6.4328,1.7383,1.9779,-999.25,7.875,239070.7031,2066.2588,259.8869,3.5332,3.5727,2.8055,2.4461,3.4259,3.5151,0.0,157.758,90.6986,179.5333,30.4799,-999.25,238.3027,0.0499,3.0684,1251.8036,59.1686,-7.6723,-18.6527,-13.1625,158.4781,189.3692,94.6994,274.6994,17.8584,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 543.5,52.4287,6.4335,1.7791,2.0255,-999.25,7.875,239047.9219,2046.7566,259.7958,3.5339,3.5712,2.8063,2.4475,3.4267,3.5151,0.0,166.8286,93.8067,189.9455,32.678,-999.25,239.5985,0.0426,1.9341,1028.9817,70.7227,38.4627,27.3132,32.8879,167.5765,197.419,89.5315,269.5315,16.5337,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 544.0,59.1939,6.4333,1.849,2.0515,-999.25,7.875,238996.7031,2106.0442,259.9594,3.5324,3.5727,2.8071,2.4468,3.4259,3.5151,0.0,176.6425,95.6493,196.073,33.9811,-999.25,240.0326,0.0401,1.1261,633.1254,78.4653,61.0823,48.1122,54.5972,176.547,202.8175,82.3694,262.3694,14.0592,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 544.5,60.4367,6.4319,1.9507,2.0988,-999.25,7.875,238947.9375,2142.3064,248.9059,3.5316,3.5712,2.8055,2.4475,3.4251,3.5151,0.0,185.1084,95.0176,199.3049,33.5344,-999.25,240.5004,0.0437,0.6771,413.2479,91.7384,70.1667,53.9414,62.054,184.1067,204.1465,74.9685,254.9685,10.4396,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 545.0,58.4694,6.4345,2.0192,2.1132,-999.25,7.875,238900.75,2133.4739,241.2425,3.5363,3.5727,2.8038,2.4482,3.4274,3.5151,0.0,189.266,93.8481,198.2464,32.7073,-999.25,240.6733,0.0561,0.4794,335.5263,109.5164,69.4785,50.4749,59.9767,187.6315,201.8945,70.7361,250.7361,7.3653,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 545.5,54.6903,6.4327,2.0371,2.08,-999.25,7.875,238831.8438,2153.6294,245.0759,3.5285,3.5727,2.8055,2.4489,3.4274,3.5151,0.0,189.651,93.1718,193.7627,32.229,-999.25,240.529,0.0756,0.5255,356.6724,115.9075,58.0892,35.8322,46.9607,187.2167,197.8924,66.8971,246.8971,5.5351,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 546.0,51.251,6.4332,2.0058,2.0622,-999.25,7.875,238785.2188,2124.8464,242.5526,3.5292,3.5735,2.8047,2.4489,3.4282,3.5151,0.0,186.9471,93.2206,192.2454,32.2635,-999.25,239.7217,0.1153,0.8937,404.2433,108.8019,44.2536,20.2048,32.2292,184.6924,197.0474,66.6123,246.6123,6.4763,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 546.5,54.3344,6.4311,1.9983,2.0751,-999.25,7.875,238738.5,2124.0432,232.0683,3.5269,3.572,2.8055,2.4489,3.4251,3.5151,0.0,186.6834,93.425,193.8826,32.4081,-999.25,239.6442,0.0802,1.2802,408.5245,95.3486,20.1607,-1.8131,9.1738,183.8442,198.0072,73.0064,253.0063,7.4279,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 547.0,58.9857,6.4312,2.0107,2.1092,-999.25,7.875,238691.6563,2108.5562,273.8417,3.5292,3.572,2.8038,2.4475,3.4259,3.5151,0.0,188.3834,93.6944,197.6326,32.5985,-999.25,239.8452,0.065,1.7169,438.4781,91.7627,-26.8313,-48.1661,-37.4987,184.8296,199.6829,92.2752,272.2751,7.7478,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 547.5,57.1781,6.4322,2.033,2.1337,-999.25,7.875,238644.4844,2141.9277,281.2699,3.5292,3.5727,2.8055,2.4482,3.4259,3.5151,0.0,190.9662,93.9397,200.4481,32.7721,-999.25,240.083,0.0552,2.8617,634.4479,111.7701,-35.1319,-57.3909,-46.2614,187.5911,201.1077,109.9722,289.9722,6.9857,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 548.0,53.4088,6.4336,2.0602,2.1474,-999.25,7.875,238620.8281,2145.8511,238.3973,3.5339,3.5727,2.803,2.4502,3.4259,3.5151,0.0,193.0021,93.6982,201.2105,32.6013,-999.25,240.0843,0.0508,3.0565,698.8234,159.2445,-35.8183,-56.5539,-46.1861,189.9926,201.3509,115.6513,295.6513,5.8476,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 548.5,53.6296,6.4324,2.0941,2.1547,-999.25,7.875,238573.9688,2135.3201,233.4575,3.5308,3.5727,2.8038,2.4489,3.4259,3.5151,0.0,194.8601,93.073,200.5429,32.1591,-999.25,240.2739,0.042,1.7793,501.3938,153.3569,-39.3822,-59.8653,-49.6237,193.274,200.6757,117.6279,297.6279,3.7877,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 549.0,55.536,6.4319,2.1183,2.1522,-999.25,7.875,238527.7188,2153.6528,223.7625,3.5292,3.5727,2.8047,2.4489,3.4259,3.5144,0.0,195.3275,92.2303,198.5135,31.5632,-999.25,240.5134,0.0379,1.2806,462.0648,97.0972,-47.1104,-67.6296,-57.37,194.3133,198.8275,122.63,302.63,2.3048,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 549.5,55.332,6.4336,2.1253,2.154,-999.25,7.875,238458.4375,2149.3049,220.3335,3.5339,3.5727,2.8047,2.4502,3.4243,3.5151,0.0,193.6842,91.1537,196.3203,30.8018,-999.25,240.7577,0.0416,1.4134,644.4337,58.8834,-21.8833,-40.8764,-31.3798,192.862,196.7027,96.5216,276.5216,2.0023,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 550.0,53.9045,6.4326,2.1334,2.1557,-999.25,7.875,238413.2969,2143.1443,236.7333,3.5292,3.5735,2.8055,2.4509,3.4235,3.5151,0.0,188.868,88.5605,190.764,28.9678,-999.25,240.5065,0.0525,1.8447,981.4149,49.1256,23.3736,7.7494,15.5615,187.7747,191.1684,15.5615,195.5615,1.9301,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 550.5,53.9582,6.4371,2.1316,2.1495,-999.25,7.875,238369.2188,2122.9307,249.6538,3.5418,3.5735,2.8047,2.4489,3.4267,3.5157,0.0,180.0857,84.5224,181.3588,26.112,-999.25,239.0979,0.0634,3.5614,1350.7744,41.9682,21.1507,5.9074,13.5291,177.6201,182.224,13.5291,193.5291,2.9612,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 551.0,50.5016,6.4337,2.1507,2.178,-999.25,7.875,238329.4375,2163.3457,257.0034,3.5308,3.5751,2.8047,2.4489,3.4267,3.5151,0.0,168.2029,78.2511,169.9968,21.6769,-999.25,236.4315,0.0561,6.6509,1765.8497,31.4945,20.5297,5.5233,13.0265,163.1768,171.6488,13.0265,193.0265,5.7266,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 551.5,40.0,6.4337,2.1525,2.2228,-999.25,7.875,238293.625,2169.2778,247.5268,3.5308,3.5743,2.8047,2.4495,3.4267,3.5151,0.0,154.5875,71.836,159.3996,17.14,-999.25,234.376,0.0665,12.0347,2628.6306,31.6498,20.4158,5.5447,12.9803,146.0774,161.2852,12.9803,192.9803,10.5581,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 552.0,27.6309,6.4334,2.1342,2.188,-999.25,7.875,238277.5625,2151.2207,233.8699,3.5285,3.5743,2.8055,2.4495,3.4274,3.5151,0.0,145.5822,68.3019,149.1803,14.6407,-999.25,232.7869,0.0478,16.4789,3570.2859,25.7863,16.9531,2.6821,9.8176,134.9338,153.8316,9.8176,189.8176,13.6567,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 552.5,20.0931,6.4355,2.1339,2.1479,-999.25,7.875,238245.9688,2145.9888,228.1993,3.5378,3.5751,2.8038,2.4502,3.4243,3.5151,0.0,142.5493,67.0951,143.5376,13.7872,-999.25,231.753,0.0325,18.9625,4957.7012,22.0625,15.083,2.0701,8.5765,129.7131,152.1746,8.5765,188.5766,16.2662,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 553.0,19.3403,6.4377,2.1112,2.1019,-999.25,7.875,238215.0313,2127.2551,229.9684,3.5277,3.5759,2.8063,2.4495,3.4386,3.5151,0.0,143.8402,68.7087,143.2723,14.9284,-999.25,231.5156,0.0242,18.0824,6026.8457,19.9104,16.3403,4.2692,10.3048,130.3052,153.8431,10.3048,190.3047,16.7057,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 553.5,24.9238,6.4336,2.0104,2.0039,-999.25,7.875,238182.5313,2129.3545,234.1848,3.5292,3.5751,2.8038,2.4509,3.4259,3.5157,0.0,146.0216,73.3837,145.5769,18.2346,-999.25,232.1207,0.0245,17.7764,6853.7012,20.3603,20.3342,8.6934,14.5138,132.8585,154.7677,14.5138,194.5138,15.3034,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 554.0,33.1655,6.4359,1.9256,1.9125,-999.25,7.875,238121.375,2139.1975,244.2654,3.5277,3.5735,2.8038,2.4516,3.4346,3.5164,0.0,149.0728,77.8722,148.0319,21.4089,-999.25,233.195,0.0242,19.9539,8751.0576,17.5778,25.9448,14.6287,20.2868,132.9967,156.5318,20.2868,200.2868,16.2871,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 554.5,40.8787,6.4357,1.9148,1.9012,-999.25,7.875,238080.3906,2141.9165,243.0272,3.5332,3.5735,2.8079,2.4516,3.4259,3.5151,0.0,149.7337,78.413,148.5714,21.7914,-999.25,234.2653,0.0224,30.3042,13775.6797,12.4519,33.7207,22.3883,28.0545,129.9134,155.0792,28.0545,208.0545,17.6612,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 555.0,44.8981,6.4345,1.9099,1.9204,-999.25,7.875,238042.0781,2134.219,240.6241,3.53,3.5743,2.8047,2.4529,3.4267,3.5151,0.0,146.4659,76.7008,147.0684,20.5805,-999.25,234.6147,0.0261,21.2074,8151.4561,10.7906,48.3577,35.2596,41.8086,127.691,149.6811,41.8086,221.8087,15.8953,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 555.5,38.0818,6.4322,1.8496,1.9257,-999.25,7.875,238005.5313,2115.9556,241.8497,3.5277,3.5743,2.8038,2.4516,3.4235,3.5157,0.0,138.3573,74.7395,143.8446,19.1934,-999.25,234.2664,0.0244,17.5303,4365.4526,10.0676,67.7953,53.2158,60.5055,122.1749,142.3196,60.5055,240.5055,15.3464,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 556.0,25.2766,6.4317,1.7975,1.898,-999.25,7.875,237969.0,2158.7917,237.7499,3.5253,3.5735,2.8038,2.4516,3.4259,3.5151,0.0,132.4257,73.6289,139.7242,18.408,-999.25,233.4646,0.0291,12.0339,2289.9202,13.0067,69.3797,55.1549,62.2673,119.782,138.1042,68.0682,248.0682,14.461,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 556.5,17.6603,6.4332,1.7651,1.8695,-999.25,7.875,237951.0469,2145.2664,236.8593,3.5285,3.572,2.8038,2.4529,3.4267,3.5157,0.0,130.2267,73.7699,137.861,18.5077,-999.25,232.574,0.0276,6.9915,1378.1702,14.3912,57.9537,42.1754,50.0646,122.9002,137.598,66.3854,246.3854,11.5315,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 557.0,17.2117,6.4343,1.7394,1.8395,-999.25,7.875,237914.5156,2108.2927,240.2537,3.53,3.5743,2.8055,2.4516,3.4259,3.5157,0.0,130.1029,74.7787,137.49,19.2211,-999.25,232.003,0.0261,3.8234,672.6237,13.5806,38.5941,20.1029,29.3485,125.5503,137.8502,71.382,251.382,9.5639,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 557.5,22.1274,6.4363,1.744,1.8175,-999.25,7.875,237877.9844,2053.1008,249.3539,3.5347,3.5759,2.8055,2.4536,3.4235,3.5157,0.0,134.5056,77.0758,140.0618,20.8457,-999.25,232.1422,0.025,2.5851,554.7711,11.6484,0.8654,-23.2917,-11.2132,130.8917,140.5528,90.4472,270.4472,7.3021,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 558.0,31.8581,6.4353,1.7556,1.8176,-999.25,7.875,237838.7813,2094.6519,245.0987,3.5308,3.5759,2.8055,2.4536,3.4251,3.5151,0.0,140.8386,80.1526,145.7656,23.0216,-999.25,232.5746,0.0238,1.7276,439.3177,9.009,-12.9945,-39.6261,-26.3103,138.2059,146.3595,97.9197,277.9197,5.881,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 558.5,44.8242,6.437,1.7743,1.8362,-999.25,7.875,237776.5938,2165.7207,240.1476,3.5347,3.5759,2.8038,2.4563,3.4251,3.5151,0.0,146.7811,82.6373,151.8712,24.7788,-999.25,232.9701,0.0283,1.4743,368.4535,8.5414,7.124,-19.539,-6.2075,145.5642,152.5598,94.3868,274.3868,4.7495,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 559.0,51.7262,6.4342,1.8322,1.8827,-999.25,7.875,237734.2188,2162.165,241.8255,3.5277,3.5751,2.8047,2.4543,3.4259,3.5151,0.0,155.0005,84.5182,159.281,26.1091,-999.25,233.6318,0.0473,2.0872,465.0583,11.4122,39.8731,13.8079,26.8405,153.8947,160.4135,90.5451,270.5451,4.1307,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 559.5,46.4893,6.4357,1.8869,1.9389,-999.25,7.875,237690.0469,2150.647,239.3083,3.5292,3.5767,2.8038,2.4563,3.4259,3.5151,0.0,162.7183,86.2219,167.2265,27.314,-999.25,234.6242,0.0757,1.2093,277.636,14.6992,57.8347,32.6791,45.2569,161.0376,169.5514,86.3219,266.3219,5.1195,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 560.0,39.762,6.4345,1.9331,1.9935,-999.25,7.875,237645.375,2141.0796,237.4586,3.5308,3.5735,2.8038,2.4543,3.4259,3.5151,0.0,167.2065,86.5721,172.4824,27.5616,-999.25,235.5158,0.0659,0.7554,162.2475,14.5691,14.1308,-13.3314,0.3997,166.693,174.5497,90.3997,270.3997,4.601,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 560.5,39.9618,6.4359,2.0084,2.056,-999.25,7.875,237603.0,2151.2778,231.4801,3.5285,3.5759,2.8055,2.4556,3.4259,3.5164,0.0,170.8465,85.1625,174.9406,26.5647,-999.25,236.5596,0.0512,0.4473,100.3982,14.5691,-36.1013,-66.2007,-51.151,170.9586,177.8053,96.0124,276.0124,3.9329,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 561.0,40.8611,6.4355,2.0547,2.0979,-999.25,7.875,237582.125,2131.9133,236.9612,3.5277,3.5727,2.8071,2.4563,3.4243,3.5185,0.0,173.0078,84.306,176.6948,25.9589,-999.25,237.3922,0.0347,0.3313,93.7534,10.8397,-999.25,-999.25,-999.25,172.8969,178.3495,-999.25,-999.25,3.1187,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 561.5,39.5954,6.4296,2.0635,2.1022,-999.25,7.875,237541.2656,2138.2913,249.4953,3.5355,3.5538,2.8038,2.4543,3.4251,3.5164,0.0,173.5511,84.2043,176.8813,25.887,-999.25,237.9908,0.023,0.2745,109.558,8.6824,-999.25,-999.25,-999.25,173.1824,177.9996,-999.25,-999.25,2.7588,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 562.0,38.708,6.4178,2.0603,2.0881,-999.25,7.875,237497.5625,2150.9797,256.0936,3.5425,3.5641,2.803,2.4523,3.3766,3.5151,0.0,172.6249,83.8565,175.0574,25.6411,-999.25,238.0697,0.0161,0.3778,179.6487,8.0637,-999.25,-999.25,-999.25,171.8577,176.1671,-999.25,-999.25,2.4928,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 562.5,36.7725,6.4244,2.0744,2.0823,-999.25,7.875,237434.6875,2149.3508,233.3654,3.5355,3.572,2.8038,2.455,3.3933,3.5137,0.0,171.0467,82.4921,171.8053,24.6762,-999.25,237.5289,0.0138,0.6183,316.02,8.7273,-999.25,-999.25,-999.25,169.4525,173.5468,-999.25,-999.25,2.4163,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 563.0,33.387,6.4264,2.0781,2.0446,-999.25,7.875,237395.2344,2147.5842,205.4626,3.5418,3.5712,2.803,2.455,3.3933,3.5151,0.0,167.9797,80.8634,165.4079,23.5243,-999.25,236.6831,0.0151,0.7584,288.2157,8.7668,-999.25,-999.25,-999.25,164.2172,169.1704,-999.25,-999.25,3.0116,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 563.5,28.4621,6.4254,2.0613,2.037,-999.25,7.875,237355.6875,2127.1868,247.3542,3.5355,3.572,2.8055,2.455,3.3933,3.5151,0.0,165.4661,80.2979,163.5749,23.1244,-999.25,236.036,0.0168,0.7068,242.4543,9.6218,-999.25,-999.25,-999.25,162.9615,166.0795,-999.25,-999.25,1.9024,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 564.0,25.7113,6.4279,2.0257,2.0097,-999.25,7.875,237315.7031,2138.28,289.116,3.5418,3.5712,2.8055,2.4563,3.3933,3.5157,0.0,162.9482,80.462,161.6797,23.2404,-999.25,235.1254,0.0113,0.3651,144.8454,9.597,-999.25,-999.25,-999.25,161.2973,163.3306,-999.25,-999.25,1.2525,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 564.5,26.4288,6.4279,1.9886,1.9689,-999.25,7.875,237274.9531,2150.8767,215.8311,3.5355,3.572,2.8135,2.4543,3.3933,3.5151,0.0,161.1406,81.0561,159.551,23.6606,-999.25,234.3681,0.0099,0.2055,101.2665,10.2261,-999.25,-999.25,-999.25,159.4047,161.2869,-999.25,-999.25,1.1724,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 565.0,28.9919,6.4218,1.9627,1.9463,-999.25,7.875,237234.3125,2173.3042,212.2853,3.5277,3.5727,2.803,2.4536,3.3933,3.5151,0.0,159.8877,81.4817,158.5597,23.9616,-999.25,234.3313,0.0109,0.1464,99.0211,12.4076,-999.25,-999.25,-999.25,158.5129,159.9345,-999.25,-999.25,0.8912,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 565.5,32.4498,6.4204,1.9452,1.9344,-999.25,7.875,237213.9844,2163.6326,224.3146,3.5285,3.5712,2.8047,2.4536,3.3877,3.5157,0.0,159.6417,82.0873,158.763,24.3899,-999.25,234.7148,0.0119,0.1938,157.4343,13.1537,-999.25,-999.25,-999.25,158.7268,159.6779,-999.25,-999.25,0.5965,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 566.0,36.0183,6.4217,1.942,1.933,-999.25,7.875,237172.2969,2118.0203,247.7375,3.5285,3.572,2.8047,2.4516,3.3933,3.5151,0.0,160.3209,82.5632,159.578,24.7265,-999.25,235.138,0.012,0.2516,265.414,16.6387,-999.25,-999.25,-999.25,159.5521,160.3467,-999.25,-999.25,0.4956,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 566.5,38.0299,6.4219,1.9539,1.9427,-999.25,7.875,237130.8281,2147.8474,262.298,3.5292,3.5712,2.8047,2.4523,3.3933,3.5151,0.0,161.4647,82.6432,160.543,24.783,-999.25,235.4459,0.0123,0.2744,349.9126,23.8028,-999.25,-999.25,-999.25,160.5358,161.472,-999.25,-999.25,0.5806,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 567.0,38.6558,6.4227,1.9657,1.9504,-999.25,7.875,237068.7344,2148.3875,265.811,3.5292,3.5712,2.8087,2.4529,3.3909,3.5151,0.0,162.3069,82.576,161.044,24.7355,-999.25,235.5341,0.0129,0.2512,323.1776,27.4145,-999.25,-999.25,-999.25,161.0409,162.3101,-999.25,-999.25,0.7844,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 567.5,38.2696,6.4229,1.9808,1.9675,-999.25,7.875,237027.2813,2165.1819,261.5209,3.5292,3.5727,2.8055,2.4529,3.3933,3.5151,0.0,162.6514,82.124,161.5562,24.4159,-999.25,235.4263,0.0098,0.2414,276.086,20.0923,-999.25,-999.25,-999.25,161.5503,162.6573,-999.25,-999.25,0.6827,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 568.0,38.1785,6.4239,1.9915,1.9797,-999.25,7.875,236986.7188,2176.459,247.5099,3.5285,3.572,2.8087,2.4536,3.3933,3.5157,0.0,161.3694,81.0388,160.411,23.6484,-999.25,234.813,0.009,0.1988,221.1593,18.3398,-999.25,-999.25,-999.25,160.4016,161.3788,-999.25,-999.25,0.6076,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 568.5,38.9768,6.4239,2.0,1.9879,-999.25,7.875,236946.875,2150.842,238.8321,3.5316,3.5727,2.8055,2.4536,3.3933,3.5151,0.0,159.5048,79.7615,158.5322,22.745,-999.25,233.9929,0.008,0.2867,278.247,16.8257,-999.25,-999.25,-999.25,158.4116,159.6255,-999.25,-999.25,0.7646,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 569.0,38.8086,6.4248,2.0046,2.0012,-999.25,7.875,236907.75,2162.3945,259.4709,3.5324,3.5727,2.8055,2.4556,3.3933,3.5151,0.0,157.5557,78.5984,157.275,21.9225,-999.25,233.3275,0.0072,0.4338,364.5754,13.9686,-999.25,-999.25,-999.25,156.9271,157.9036,-999.25,-999.25,0.6216,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 569.5,38.2445,6.4228,2.0019,2.0058,-999.25,7.875,236868.8281,2146.2644,261.5819,3.5316,3.5727,2.8047,2.4543,3.3901,3.5151,0.0,155.8286,77.841,156.13,21.3869,-999.25,232.9286,0.0076,0.7309,568.5458,13.6767,-999.25,-999.25,-999.25,155.3793,156.5793,-999.25,-999.25,0.7705,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 570.0,37.7044,6.4229,1.9957,2.0062,-999.25,7.875,236830.5469,2187.782,263.2888,3.5308,3.5712,2.8047,2.4536,3.3933,3.5151,0.0,154.2887,77.3111,155.1154,21.0121,-999.25,232.4986,0.0076,1.0248,766.6818,13.1285,-999.25,-999.25,-999.25,153.7699,155.6342,-999.25,-999.25,1.1994,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 570.5,36.866,6.4228,1.9915,2.0186,-999.25,7.875,236792.0781,2166.1802,279.1982,3.5308,3.572,2.8038,2.4536,3.3933,3.5151,0.0,154.1804,77.4227,156.2935,21.091,-999.25,232.0647,0.0089,0.8411,650.8137,16.3097,-999.25,-999.25,-999.25,153.8249,156.649,-999.25,-999.25,1.8116,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 571.0,37.7825,6.4241,1.9951,2.0305,-999.25,7.875,236753.4063,2160.0654,281.8648,3.5316,3.5712,2.8047,2.4543,3.3957,3.5151,0.0,155.387,77.8908,158.1625,21.4221,-999.25,231.5627,0.0077,0.4879,427.4304,14.8089,-999.25,-999.25,-999.25,155.097,158.4525,-999.25,-999.25,2.1286,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 571.5,40.2625,6.4306,1.9949,2.0287,-999.25,7.875,236713.5156,2137.3054,261.6264,3.5418,3.5712,2.8055,2.455,3.4028,3.5157,0.0,156.5897,78.5007,159.251,21.8534,-999.25,230.9512,0.0046,0.277,338.2789,11.2311,-999.25,-999.25,-999.25,156.2672,159.5735,-999.25,-999.25,2.0826,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 572.0,42.061,6.4255,1.9918,2.012,1.9456,7.875,236674.2031,2125.1445,292.485,3.5316,3.5712,2.8071,2.4563,3.3941,3.5164,0.0,156.586,78.6194,158.1758,21.9374,153.0888,230.5049,0.0037,0.199,358.1166,11.8533,-999.25,-999.25,-999.25,156.0797,158.6821,-999.25,-999.25,1.6433,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 572.5,43.7349,6.4259,1.9834,1.9827,1.9531,7.875,236634.4531,2151.7942,342.5512,3.5324,3.5712,2.8055,2.4577,3.3933,3.5178,0.0,155.4583,78.3794,155.4131,21.7676,153.0014,230.1879,0.0044,0.1828,371.5857,14.7434,-999.25,-999.25,-999.25,154.4163,156.4552,-999.25,-999.25,1.3069,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 573.0,43.9503,6.4272,1.9818,1.9655,1.9649,7.875,236595.2344,2142.8005,291.5174,3.5339,3.572,2.8055,2.459,3.3933,3.5178,0.0,153.7228,77.5626,152.4595,21.19,152.242,230.0632,0.0055,0.1833,304.1783,16.2332,-999.25,-999.25,-999.25,151.9897,154.1925,-999.25,-999.25,1.4329,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 573.5,41.0769,6.4214,1.9768,1.9597,1.9806,7.875,236556.6406,2123.7676,276.261,3.5277,3.5554,2.8055,2.4604,3.3933,3.5219,0.0,150.0591,75.9037,148.7639,20.0168,150.1913,230.407,0.0067,0.156,281.3484,22.3196,-999.25,-999.25,-999.25,148.5148,150.3082,-999.25,-999.25,1.1972,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 574.0,37.6488,6.4202,1.9762,1.9576,1.9981,7.875,236519.3125,2087.0461,297.9789,3.5324,3.5538,2.8014,2.4631,3.3941,3.5157,0.0,145.1524,73.4473,143.7881,18.2795,146.7021,230.92,0.0083,0.1251,237.7277,33.6277,-999.25,-999.25,-999.25,143.5974,145.3431,-999.25,-999.25,1.2096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 574.5,34.6455,6.4204,1.9708,1.9486,1.9979,7.875,236483.9219,2123.3777,300.783,3.5316,3.553,2.8071,2.4597,3.3949,3.5151,0.0,139.2325,70.6416,137.6613,16.2954,141.1432,231.7011,0.0084,0.0971,195.3501,40.9673,-999.25,-999.25,-999.25,137.5814,139.3124,-999.25,-999.25,1.2397,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 575.0,31.8115,6.4233,1.9702,1.9498,1.9826,7.875,236450.5781,2146.8381,324.8139,3.5339,3.5554,2.803,2.459,3.4036,3.5151,0.0,133.5938,67.8069,132.199,14.2906,134.4717,232.6796,0.0065,0.078,194.7816,40.2376,-999.25,-999.25,-999.25,132.1613,133.6315,-999.25,-999.25,1.0949,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 575.5,31.2528,6.4233,1.9674,1.9487,1.9731,7.875,236417.8906,2155.3735,322.1689,3.5292,3.5538,2.8047,2.4604,3.4068,3.5151,0.0,129.9868,66.0821,128.7505,13.0708,130.3809,233.2646,0.0056,0.058,185.7977,40.0495,-999.25,-999.25,-999.25,128.7061,130.0311,-999.25,-999.25,1.0187,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 576.0,32.1705,6.4272,1.9517,1.9367,1.9507,7.875,236385.9063,2170.677,315.1826,3.53,3.5641,2.8055,2.4611,3.406,3.5151,0.0,128.0741,65.6425,127.0959,12.7599,127.9972,233.6014,0.0049,0.0454,157.6517,31.577,-999.25,-999.25,-999.25,126.9962,128.1739,-999.25,-999.25,0.9185,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 576.5,34.0341,6.4234,1.929,1.9187,1.9178,7.875,236353.4531,2161.7976,320.9861,3.5347,3.5506,2.8047,2.4577,3.4076,3.5151,0.0,128.1604,66.4809,127.5065,13.3529,127.3689,233.8607,0.0049,0.0323,111.8694,25.4727,-2.9831,-47.5195,-25.2513,127.2207,128.4675,154.7487,334.7487,0.9686,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 577.0,38.1886,6.4281,1.906,1.9056,1.8808,7.875,236319.875,2151.4614,330.895,3.5324,3.5641,2.8038,2.459,3.41,3.5151,0.0,129.8267,68.181,129.8646,14.5552,128.0532,233.9095,0.0058,0.0257,87.9776,25.9805,-2.9831,-47.5195,-25.2513,129.1854,130.5515,154.7487,334.7487,1.036,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 577.5,41.6532,6.4292,1.8841,1.8977,1.8435,7.875,236285.0156,2109.9788,345.9684,3.5355,3.5609,2.8063,2.4577,3.4116,3.5157,0.0,132.7758,70.5576,133.8104,16.236,129.8702,233.9256,0.006,0.0227,75.9435,25.2304,-2.9831,-47.5195,-25.2513,132.4483,134.2395,154.7487,334.7487,1.3186,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 578.0,44.0714,6.428,1.8549,1.8806,1.8138,7.875,236267.0156,2142.9495,339.2858,3.5386,3.5546,2.8063,2.4604,3.4084,3.5157,0.0,136.4919,73.6819,138.4456,18.4455,133.4648,233.8638,0.0047,0.0235,76.1223,21.1762,-2.9831,-47.5195,-25.2513,136.2765,138.9033,154.7487,334.7487,1.8873,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 578.5,46.7466,6.4327,1.8312,1.8607,1.7932,7.875,236210.0625,2182.1377,342.6483,3.5394,3.5585,2.8047,2.459,3.4187,3.5178,0.0,140.5705,76.8229,142.8495,20.6668,137.677,233.6165,0.0039,0.0251,84.4295,20.4175,-999.25,-999.25,-999.25,140.4429,143.1923,-999.25,-999.25,1.9416,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 579.0,46.9254,6.4391,1.8213,1.8471,1.7899,7.875,236170.4375,2167.1436,354.6633,3.5418,3.5641,2.8071,2.4638,3.4227,3.5178,0.0,144.3344,79.2764,146.3598,22.402,141.8755,233.0713,0.0036,0.0228,85.4062,22.5211,-999.25,-999.25,-999.25,144.2501,146.5406,-999.25,-999.25,1.5879,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 579.5,45.5883,6.4379,1.8185,1.8395,1.7934,7.875,236129.9063,2171.7212,294.9531,3.5425,3.5546,2.8055,2.4624,3.4267,3.5219,0.0,147.5842,81.1777,149.2543,23.7466,145.5696,232.8427,0.0046,0.0252,105.647,33.2664,-999.25,-999.25,-999.25,147.474,149.4095,-999.25,-999.25,1.3176,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25
 580.0,42.4314,6.4369,1.8125,1.824,1.7882,7.875,236088.8281,2140.7693,183.6453,3.5418,3.5585,2.8055,2.4611,3.4267,3.5171,0.0,150.3266,82.9662,151.2416,25.0115,148.2922,232.8233,0.0065,0.033,143.9318,47.7249,-2.9831,-47.5195,-25.2513,150.1044,151.485,154.7487,334.7487,0.9271,1805.8065,-33.5032,-0.3677,2.4798,87.906,54.6849,27.6935,14.6555,6.7422,87.906,0.2535,2.2575,0.1663,-0.4282,7.6823,36.5449,31.7902,31.7902,29.1336,-0.1974,23.7881,26.4622,32.7542,26.4622,11.3758,4.5,0.3179,0.1996,35.7831,27.6872,12.7333,0.42,2.3883,2.1893,0.9167,5.6859,5.212,0.0
 580.5,39.8425,6.4432,1.799,1.8003,1.7664,7.875,236046.625,2158.8264,198.804,3.5418,3.5727,2.8095,2.4631,3.4267,3.5157,0.0,152.8134,84.9805,152.8868,26.436,149.9907,233.1042,0.0062,0.0476,212.4972,46.8673,0.8103,-42.9872,-21.0884,152.3039,153.3963,143.9116,323.9116,0.7196,1801.3383,-33.957,-0.3677,2.6072,99.1564,58.9579,29.2923,14.8604,6.9036,99.1564,0.2535,2.2306,-0.2244,-0.1238,7.6123,38.2083,33.5168,33.5168,30.72,-0.2133,25.4192,28.0361,34.1934,28.0361,10.0851,4.5,0.3171,0.1999,39.3911,30.4092,14.0487,0.4635,2.6093,2.4152,0.9256,5.6297,5.211,0.0
 581.0,39.2945,6.443,1.784,1.7817,1.7364,7.875,236003.0469,2154.6846,212.6173,3.5425,3.5712,2.8079,2.4618,3.4306,3.5151,0.0,155.1669,87.01,154.9505,27.8713,150.935,233.7222,0.0054,0.0332,177.5355,57.9034,8.3972,-33.9227,-12.7627,154.6531,155.4644,122.2373,302.2373,0.5248,1811.3805,-34.2654,-0.3677,3.1475,141.0627,78.1609,37.6383,18.143,8.6243,141.0627,0.2535,2.2028,-0.2051,0.1057,7.5007,39.8988,35.2864,35.2864,32.3404,-0.2289,27.1055,29.6632,35.6813,29.6632,7.089,4.5,0.3165,0.199,42.3487,32.9018,14.9807,0.4979,2.8406,2.5578,0.9004,5.7047,5.1366,1.6
 581.5,38.7344,6.4431,1.7803,1.7766,1.6984,7.875,235981.0313,2164.8257,195.3682,3.5425,3.5712,2.8047,2.4638,3.4322,3.5151,0.0,158.0022,88.7639,157.6542,29.1117,150.5995,235.0197,0.0069,0.0322,228.6472,102.2709,15.9841,-24.8582,-4.437,157.4177,158.2388,100.563,280.563,0.518,1828.4485,-34.2383,-0.3677,3.9566,244.226,123.3665,56.7806,25.6677,12.5092,244.226,0.2535,2.1726,0.1235,0.3942,7.3829,40.0667,35.4631,35.4631,32.5019,-0.2452,28.9318,31.4254,37.2928,31.4254,4.0946,4.5,0.3164,0.2005,46.1798,34.1232,15.3487,0.5098,2.9517,2.6223,0.8884,5.7896,5.1434,1.6
 582.0,38.413,6.4481,1.7818,1.775,1.6651,7.875,235913.0313,2185.5793,186.4808,3.5433,3.572,2.8047,2.4638,3.4449,3.5157,0.0,160.7738,90.2326,160.1502,30.1504,150.165,236.7099,0.0101,0.0393,330.2773,166.2102,23.571,-15.7937,3.8887,159.9437,160.9802,78.8887,258.8887,0.6421,1836.9476,-34.2005,-0.3677,4.9928,545.4106,229.6292,96.4031,38.2942,18.5034,545.4106,0.2535,2.1381,0.0335,0.2252,7.334,40.129,35.5286,35.5286,32.5617,-0.2617,31.0258,33.4459,39.1404,33.4459,1.8335,4.5,0.3168,0.2026,48.1221,33.765,14.9483,0.4923,2.9456,2.5737,0.8737,5.9828,5.2275,1.6
 582.5,39.354,6.4538,1.7833,1.7772,1.6609,7.875,235867.5469,2179.3381,174.5362,3.5457,3.5909,2.8038,2.4611,3.4449,3.5151,0.0,161.9825,90.8313,161.4263,30.5738,150.8251,237.9459,0.016,0.0587,545.6908,281.65,31.1579,-6.7291,12.2144,161.1081,162.3008,57.2144,237.2144,0.7356,1791.1577,-34.3439,-0.3677,7.1161,996.3033,403.0415,162.6398,63.5472,25.219,996.3033,0.2535,2.1135,-0.2969,-0.1665,7.3258,40.2188,35.6231,35.6231,32.6481,-0.2751,32.5145,34.8824,40.4539,34.8824,1.0037,4.5,0.3172,0.2044,46.0611,31.7446,13.9158,0.454,2.7889,2.4166,0.8665,6.1434,5.3234,0.0
 583.0,41.0693,6.461,1.7759,1.7783,1.6755,7.875,235821.6875,2178.7297,297.129,3.5472,3.5917,2.8063,2.4733,3.4481,3.5164,0.0,161.6933,91.0528,161.9182,30.7304,152.5303,239.3274,0.0235,0.0816,768.6498,406.064,38.7448,2.3354,20.5401,161.225,162.3865,35.5401,215.5401,0.7179,1809.7227,-34.3127,-0.3677,8.1323,1183.6014,476.3665,190.2838,74.1174,25.8351,1183.6014,0.2535,2.0981,-0.1464,-0.2162,7.2656,41.5473,37.0266,37.0266,33.9286,-0.2871,33.4513,35.7863,41.2805,35.7863,0.8449,4.5,0.3176,0.2063,42.9376,29.166,12.5818,0.4054,2.5986,2.209,0.8501,6.4101,5.4492,1.0
 583.5,40.6304,6.4529,1.7731,1.7821,1.7041,7.875,235775.8906,2166.1455,359.8276,3.5472,3.5759,2.8047,2.4624,3.4521,3.5164,0.0,160.8506,90.7232,161.66,30.4973,154.5366,240.9129,0.0276,0.0884,735.8912,401.3603,38.9478,5.8037,22.3757,160.4928,161.9811,22.3757,202.3757,0.9263,1824.4176,-34.3339,-0.3677,4.8618,1064.2986,342.7133,133.02,48.5241,16.8107,1064.2986,0.2535,2.0904,0.2479,-0.1798,7.3437,42.7398,38.2943,38.2943,35.0824,-0.2977,33.9129,36.2318,41.6879,36.2318,0.9396,4.5,0.3176,0.2073,40.9034,27.0818,11.5674,0.3707,2.427,2.0405,0.8407,6.5475,5.5047,0.0
 584.0,38.7104,6.4577,1.7811,1.7921,1.745,7.875,235730.7188,2162.8303,13.7332,3.5472,3.5743,2.8063,2.4665,3.4608,3.5178,0.0,160.0003,89.846,160.9709,29.8769,156.6802,242.1988,0.0287,0.0667,473.566,337.1178,38.9478,5.8037,22.3757,159.5562,161.3362,22.3757,202.3757,1.1146,1839.9539,-34.302,-0.3677,2.7082,863.3383,215.6626,82.7477,28.9685,10.453,863.3383,0.2535,2.0916,0.2973,-0.2827,7.6153,42.2529,37.7758,37.7758,34.6108,-0.3064,33.8397,36.1611,41.6233,36.1611,1.1583,4.5,0.3181,0.2086,39.3741,26.4083,11.1278,0.3535,2.3872,1.9778,0.8285,6.7535,5.5952,0.0
 584.5,38.4918,6.4569,1.7941,1.8139,1.7936,7.875,235686.3281,2149.3162,15.9167,3.5496,3.572,2.8055,2.459,3.4648,3.5198,0.0,159.1861,88.749,160.9149,29.1011,159.0628,243.9124,0.02,0.0415,308.5526,231.2958,38.9478,5.8037,22.3757,158.6741,161.2515,22.3757,202.3757,1.6203,1836.7058,-34.1979,-0.3677,1.7874,713.379,145.2916,55.668,19.2474,7.2081,713.379,0.2535,2.0932,-0.0116,-0.249,7.8786,40.6532,36.081,36.081,33.0662,-0.319,33.7425,36.0673,41.5375,36.0673,1.4018,4.5,0.3186,0.2104,38.6069,26.6744,11.2561,0.3593,2.4053,1.9925,0.8284,6.6952,5.5461,0.0
 585.0,40.3297,6.4581,1.8157,1.8502,1.8434,7.875,235664.375,2169.6218,15.8042,3.5472,3.5672,2.8055,2.4658,3.4672,3.5212,0.0,159.0771,87.6493,162.0741,28.3234,161.4613,247.0695,0.0149,0.0341,304.4771,192.5721,38.9478,5.8037,22.3757,158.345,162.388,22.3757,202.3757,2.5426,1825.8224,-34.0931,-0.3677,1.2474,597.0483,103.513,39.7177,13.739,5.2063,597.0483,0.2535,2.0975,-0.1924,0.2722,7.9863,40.4806,35.8989,35.8989,32.9,-0.3326,33.4872,35.8209,41.3122,35.8209,1.6749,4.5,0.3186,0.211,37.8289,27.3734,11.6216,0.379,2.4636,2.0186,0.8194,6.4994,5.3254,2.0
 585.5,43.0461,6.4537,1.8515,1.8896,1.8812,7.875,235599.4063,2166.0188,14.8363,3.5418,3.5727,2.8038,2.457,3.468,3.5178,0.0,160.3881,86.6748,163.6986,27.6342,162.9898,249.9802,0.0125,0.0333,370.7842,192.9214,37.3142,5.3196,21.3169,159.2911,164.0737,21.3169,201.3169,3.0,1845.2162,-34.0825,-0.3677,0.8776,452.3264,74.4842,28.7834,10.0623,3.8209,452.3264,0.2535,2.1009,0.1827,0.492,7.9454,38.0694,33.3721,33.3721,30.5872,-0.3408,33.2785,35.6195,41.128,35.6196,2.2108,4.5,0.3191,0.2122,37.1615,28.351,12.1753,0.4063,2.5366,2.0711,0.8165,6.2429,5.0972,1.6
 586.0,46.0442,6.4564,1.9096,1.932,1.8935,7.875,235556.3125,2136.1917,13.3269,3.5425,3.5712,2.8055,2.4658,3.4656,3.5185,0.0,163.9936,85.9238,165.9345,27.1031,162.6746,251.0743,0.008,0.036,521.718,155.1085,-999.25,-999.25,-999.25,163.1441,166.4602,-999.25,-999.25,2.0493,1847.1057,-34.1341,-0.3677,0.6393,368.2639,57.4046,22.1147,7.708,2.893,368.2639,0.2535,2.0867,0.6148,0.3369,7.996,38.4997,33.8207,33.8207,30.9987,-0.3493,34.1424,36.4532,41.8904,36.4532,2.7154,4.5,0.3195,0.2138,36.8466,28.6819,12.2643,0.4205,2.5659,2.033,0.7923,6.102,4.8349,1.6
 586.5,49.3143,6.454,1.9669,1.9701,1.8981,7.875,235513.7344,2168.7612,11.7328,3.5433,3.568,2.8087,2.4584,3.468,3.5157,0.0,167.81,85.3537,168.1053,26.6999,161.9941,249.9209,0.0063,0.0454,749.7017,167.4911,-999.25,-999.25,-999.25,166.6915,169.0721,-999.25,-999.25,1.4428,1867.5354,-34.1981,-0.3677,0.4727,329.6379,48.8466,18.6842,6.49,2.3872,329.6379,0.2535,2.0601,0.4026,0.3198,8.1104,39.5759,34.9472,34.9472,32.0302,-0.3609,35.7529,38.0072,43.3114,38.0072,3.0336,4.5,0.3195,0.2143,35.9365,28.6711,12.3042,0.4389,2.5543,1.9588,0.7669,5.8197,4.4631,1.6
 587.0,52.5675,6.4532,2.0076,1.9953,1.9075,7.875,235471.0938,2177.0784,10.1485,3.5433,3.5641,2.8055,2.4618,3.4672,3.5178,0.0,170.4613,84.9341,169.4241,26.4032,161.9871,251.3277,0.0054,0.0433,740.9117,166.3507,-999.25,-999.25,-999.25,168.7613,171.0521,-999.25,-999.25,1.3597,1858.7483,-34.3009,-0.3677,0.3955,322.1204,45.2736,17.1718,5.9658,2.145,322.1204,0.2535,2.0339,-0.2005,0.0088,7.9841,41.7453,37.2366,37.2366,34.12,-0.3731,37.3377,39.5363,44.7097,39.5363,3.1044,4.5,0.3195,0.2147,35.4913,28.2892,12.3394,0.4479,2.4783,1.9277,0.7778,5.5333,4.304,0.8
 587.5,51.9503,6.4605,2.0289,2.0111,1.9244,7.875,235429.3594,2199.8958,8.3037,3.5418,3.5893,2.8055,2.459,3.4688,3.5171,0.0,171.1351,84.3765,169.6412,26.0088,162.3376,249.0769,0.0045,0.0342,582.2551,148.4547,-999.25,-999.25,-999.25,169.2823,171.4619,-999.25,-999.25,1.2818,1851.4008,-34.4187,-0.3677,0.3582,324.9902,43.5909,16.4092,5.7192,2.0185,324.9902,0.2535,2.0052,-0.3714,-0.5384,7.7884,43.6192,39.2338,39.2338,35.9358,-0.3861,39.0771,41.2147,46.2445,41.2147,3.077,4.5,0.3194,0.2158,34.691,28.3623,12.8853,0.4737,2.4056,1.9845,0.8249,5.0782,4.1892,1.0
 588.0,50.3543,6.4532,2.0149,1.9985,1.9317,7.875,235386.8906,2173.7166,6.5353,3.5418,3.568,2.8063,2.4577,3.4688,3.5171,0.0,170.0158,84.3839,168.6227,26.0141,162.9746,246.8808,0.0043,0.0296,513.1962,156.3712,-999.25,-999.25,-999.25,168.2956,170.3429,-999.25,-999.25,1.2049,1869.6205,-34.5605,-0.3677,0.3156,321.4405,41.3343,15.4659,5.4113,1.8678,321.4405,0.2535,1.9824,-0.0658,-0.5942,7.9193,44.6542,40.3447,40.3447,36.9431,-0.4,40.4617,42.5508,47.4662,42.5508,3.111,4.5,0.3193,0.2166,34.4519,29.3595,14.0253,0.5046,2.3976,2.2123,0.9227,4.7513,4.384,2.0
 588.5,50.7054,6.4559,1.9873,1.9815,1.9456,7.875,235344.3438,2163.9653,4.5851,3.5425,3.5735,2.8038,2.4624,3.4688,3.5164,0.0,167.0554,84.0542,166.5585,25.7809,163.4966,242.1829,0.0053,0.0339,569.8562,199.2994,-999.25,-999.25,-999.25,165.9797,167.6342,-999.25,-999.25,0.9864,1861.1787,-34.7479,-0.3677,0.2646,307.6968,38.5135,14.3566,5.0506,1.6951,307.6968,0.2535,1.9724,0.0171,-0.2418,8.3277,47.8521,43.7932,43.7932,40.1365,-0.4144,41.0652,43.133,47.9987,43.133,3.25,4.5,0.319,0.2172,37.902,30.16,14.9411,0.526,2.3921,2.4117,1.0082,4.548,4.5853,3.2
 589.0,50.8004,6.4717,1.9601,1.9663,1.9655,7.875,235302.2344,2186.3591,2.6447,3.5425,3.5885,2.8071,2.4556,3.5029,3.5185,0.0,163.3825,83.3431,163.8845,25.278,163.7772,240.6008,0.0056,0.042,662.811,188.1452,-999.25,-999.25,-999.25,162.8933,164.3737,-999.25,-999.25,0.9003,1883.0031,-34.9251,-0.3677,0.2286,309.7895,37.0636,13.7388,4.857,1.5781,309.7895,0.2535,1.9678,-0.0664,-0.0994,8.6699,44.8884,40.5969,40.5969,37.1715,-0.4254,41.3478,43.4057,48.248,43.4057,3.228,4.5,0.3183,0.2178,42.4361,32.1514,16.1926,0.5565,2.522,2.6782,1.0619,4.5323,4.8129,0.0
 589.5,50.8499,6.4623,1.9461,1.9546,1.9808,7.875,235260.8438,2197.5901,0.8438,3.5457,3.5893,2.8047,2.4604,3.4712,3.5157,0.0,160.0836,82.2592,160.7884,24.5115,162.9279,239.4687,0.0063,0.0514,786.5308,200.0332,-999.25,-999.25,-999.25,159.7977,161.0743,-999.25,-999.25,0.7906,1866.1543,-34.9716,-0.3677,0.2205,331.4252,37.4247,13.7739,4.8903,1.5493,331.4252,0.2535,1.9664,-0.0126,0.2135,8.7085,44.3341,40.0006,40.0006,36.6313,-0.4287,41.4305,43.4856,48.321,43.4856,3.0173,4.5,0.3176,0.2179,44.1554,33.4349,16.7334,0.5721,2.6373,2.7814,1.0546,4.6097,4.8616,3.2
 590.0,47.7227,6.4612,1.948,1.9526,1.9806,7.875,235220.1406,2206.6299,358.7603,3.5472,3.5909,2.8055,2.457,3.4672,3.5157,0.0,157.6361,80.9377,158.0231,23.5769,160.3082,238.455,0.0061,0.0499,766.3484,181.5458,-999.25,-999.25,-999.25,157.3577,158.3016,-999.25,-999.25,0.5949,1876.2775,-35.1216,-0.3677,0.2269,354.7941,38.5431,14.0601,5.0026,1.5652,354.7941,0.2535,1.9616,0.13,0.3335,8.6212,42.9605,38.5297,38.5297,35.2964,-0.4293,41.7185,43.7634,48.5751,43.7634,2.8185,4.5,0.3173,0.2185,44.0903,34.0511,16.9233,0.5814,2.698,2.7997,1.0377,4.6403,4.8153,1.0
 590.5,42.8097,6.4609,1.9604,1.9605,1.9741,7.875,235180.125,2174.8984,356.6554,3.5496,3.5909,2.8022,2.457,3.4672,3.5157,0.0,155.7983,79.4973,155.8259,22.5582,156.9605,239.0088,0.0046,0.0489,813.2944,123.7753,-999.25,-999.25,-999.25,155.385,156.2391,-999.25,-999.25,0.5489,1872.0048,-35.4255,-0.3677,0.2216,332.6653,38.9655,14.0979,5.0129,1.5827,332.6653,0.2535,1.953,0.4097,-0.1629,8.6923,41.6136,37.0969,37.0969,33.9927,-0.432,42.2403,44.267,49.0356,44.267,3.006,4.5,0.3161,0.2195,44.7969,33.8928,16.94,0.5849,2.6664,2.7887,1.0459,4.5587,4.7678,1.0
 591.0,40.1741,6.4619,1.9725,1.971,1.9609,7.875,235141.2344,2179.3494,354.5942,3.5472,3.5925,2.8038,2.457,3.4688,3.5164,0.0,153.9895,78.0918,153.8808,21.5642,153.1572,239.4942,0.0037,0.0508,776.2311,88.7505,-999.25,-999.25,-999.25,153.3341,154.5363,-999.25,-999.25,0.7829,1851.1477,-35.8419,-0.3677,0.1971,310.3109,38.7599,13.8678,4.8962,1.5443,310.3109,0.2535,1.9489,0.5701,-0.2331,8.8044,43.7393,39.3625,39.3625,36.0526,-0.4356,42.4884,44.5064,49.2545,44.5064,3.2226,4.5,0.3157,0.2191,45.6275,33.3205,16.949,0.5883,2.5856,2.7757,1.0735,4.3952,4.7183,1.0
 591.5,41.6439,6.468,1.9807,1.9876,1.9421,7.875,235122.2031,2192.2329,352.6464,3.5488,3.5909,2.803,2.4529,3.4926,3.5157,0.0,152.7292,77.1291,153.2658,20.8834,149.8043,238.2557,0.0033,0.0573,656.1069,65.39,-999.25,-999.25,-999.25,152.2318,153.7633,-999.25,-999.25,1.0013,1850.8025,-36.1115,-0.3677,0.2133,308.2825,39.1462,13.8224,4.8208,1.508,308.2825,0.2535,1.9431,0.2165,-0.0023,8.7517,45.6847,41.4556,41.4556,37.9517,-0.4388,42.8428,44.8483,49.5672,44.8483,3.2438,4.5,0.3171,0.2204,47.378,33.4995,17.4929,0.6121,2.5419,2.8411,1.1177,4.1524,4.6412,0.8
 592.0,46.2404,6.4705,1.9831,2.0022,1.9218,7.875,235065.8906,2198.0608,350.4285,3.548,3.5917,2.8055,2.455,3.495,3.5164,0.0,152.2247,76.7762,153.7013,20.6338,147.5212,236.1743,0.0029,0.0621,604.8008,46.3978,-999.25,-999.25,-999.25,152.0151,153.9109,-999.25,-999.25,1.2368,1838.1342,-36.4363,-0.3677,0.1962,314.2571,39.9004,13.8983,4.7949,1.4857,314.2571,0.2535,1.9294,-0.4314,0.0562,8.5387,46.1809,41.9908,41.9908,38.4444,-0.4425,43.6704,45.6468,50.2974,45.6468,3.1821,4.5,0.3172,0.2221,47.2335,33.6189,17.8079,0.631,2.5258,2.855,1.1304,4.0028,4.5246,0.8
 592.5,49.4839,6.4703,1.9801,2.0061,1.9038,7.875,235027.25,2194.4006,348.3604,3.5496,3.5917,2.8038,2.455,3.495,3.5157,0.0,153.0769,77.33,155.1063,21.0255,147.1679,235.732,0.0031,0.0704,727.3118,48.0721,-999.25,-999.25,-999.25,152.9585,155.2247,-999.25,-999.25,1.4672,1852.0115,-36.7888,-0.3677,0.1746,343.4177,41.3319,14.207,4.8497,1.4809,343.4177,0.2535,1.9134,-0.6177,0.3272,8.2471,45.5883,41.3516,41.3516,37.8566,-0.4481,44.6396,46.5821,51.1526,46.5821,2.9119,4.5,0.3173,0.223,45.7292,33.2604,17.8971,0.6386,2.4634,2.8483,1.1563,3.8575,4.4603,0.0
 593.0,50.0876,6.4688,1.9892,2.0126,1.9145,7.875,234987.8594,2182.0337,346.3109,3.548,3.5917,2.8055,2.4475,3.4974,3.5164,0.0,153.7941,77.3385,155.6262,21.0315,148.0041,235.4777,0.0039,0.0946,1058.7168,61.949,-999.25,-999.25,-999.25,153.7012,155.7191,-999.25,-999.25,1.3023,1833.4927,-37.1731,-0.3677,0.1637,391.9002,44.1207,14.9904,5.1067,1.5215,391.9002,0.2535,1.8991,-0.2564,0.4504,8.002,45.2956,41.036,41.036,37.5691,-0.4557,45.5088,47.4208,51.9195,47.4208,2.5517,4.5,0.3174,0.2229,44.3481,31.9077,17.3023,0.6168,2.3538,2.7562,1.171,3.8161,4.4684,2.4
 593.5,47.6144,6.4681,2.0072,2.0207,1.941,7.875,234949.0625,2186.6223,344.2284,3.548,3.5925,2.8038,2.4448,3.4982,3.5171,0.0,153.7151,76.607,154.763,20.5142,148.6307,235.586,0.0051,0.1191,1587.5074,83.1358,-999.25,-999.25,-999.25,153.5965,154.8817,-999.25,-999.25,0.8341,1852.2994,-37.5763,-0.3677,0.1613,570.4072,48.8857,16.4624,5.6466,1.6195,570.4072,0.2535,1.8877,0.1319,0.138,7.979,45.4982,41.2545,41.2545,37.7679,-0.4629,46.1979,48.0856,52.5275,48.0857,1.7531,4.5,0.3175,0.2232,41.0425,30.0633,16.3563,0.5824,2.2256,2.6089,1.1722,3.8216,4.4798,0.8
 594.0,44.8307,6.4678,2.0234,2.03,1.9604,7.875,234910.7813,2202.8792,342.2052,3.5488,3.5917,2.8047,2.4461,3.4958,3.5164,0.0,152.1823,75.2345,152.6864,19.5435,147.4188,236.4205,0.0059,0.1765,2257.1748,86.4543,-999.25,-999.25,-999.25,151.9249,152.9437,-999.25,-999.25,0.6732,1861.1675,-38.0178,-0.3677,0.1722,1012.4303,57.0695,19.0912,6.7113,1.8652,1012.4303,0.2535,1.8839,0.3222,-0.2593,8.1731,41.7823,37.2758,37.2758,34.1557,-0.4666,46.4292,48.3089,52.7317,48.3089,0.9877,4.5,0.3164,0.2237,38.564,29.0946,15.7864,0.5622,2.1786,2.5176,1.1556,3.8753,4.4783,0.8
 594.5,40.6979,6.467,2.0328,2.0394,1.9742,7.875,234874.2188,2213.5591,340.3777,3.548,3.5917,2.8038,2.4461,3.495,3.5164,0.0,148.9549,73.2874,149.4264,18.1665,144.6302,236.3086,0.0071,0.2124,2194.2388,76.7896,-999.25,-999.25,-999.25,148.6276,149.7537,-999.25,-999.25,0.7639,1842.2224,-38.43,-0.3677,0.2048,1738.2188,69.4839,23.1515,8.421,2.3761,1738.2188,0.2535,1.8857,-0.0143,-0.4876,8.3006,40.0001,35.3929,35.3929,32.4378,-0.4685,46.3219,48.2054,52.637,48.2054,0.5753,4.5,0.3161,0.2234,41.3227,29.4884,15.9094,0.569,2.2367,2.5256,1.1292,3.9309,4.4387,1.6
 595.0,35.6534,6.4661,2.0227,2.0393,1.9734,7.875,234839.1563,2231.2598,338.5019,3.5472,3.5917,2.8038,2.4441,3.495,3.5164,0.0,144.5545,71.461,145.7204,16.8748,140.9999,234.8529,0.0094,0.1458,1286.5713,78.1117,-999.25,-999.25,-999.25,144.3999,145.875,-999.25,-999.25,1.0274,1874.0078,-38.8736,-0.3677,0.2362,1772.2617,83.7138,27.8825,10.2351,2.9183,1772.2617,0.2535,1.8873,-0.5158,-0.1826,8.1915,38.6796,34.0086,34.0086,31.1709,-0.47,46.2253,48.1121,52.5517,48.1121,0.5643,4.5,0.3158,0.2237,45.6364,30.9921,16.6344,0.6007,2.3705,2.6135,1.1025,3.9464,4.351,0.0
 595.5,35.3844,6.4679,2.0105,2.0308,1.9646,7.875,234804.4375,2223.9297,336.9466,3.5496,3.5917,2.8047,2.4448,3.4958,3.5171,0.0,142.0756,70.664,143.5038,16.3112,138.8076,234.5127,0.011,0.1397,967.9642,88.2082,-999.25,-999.25,-999.25,142.008,143.5714,-999.25,-999.25,1.0982,1866.9482,-39.2797,-0.3677,0.3035,1835.4924,107.7514,35.8884,13.3553,3.8724,1835.4924,0.2535,1.8835,-0.207,0.1185,8.0111,39.992,35.3845,35.3845,32.43,-0.4716,46.4551,48.3339,52.7545,48.3339,0.5448,4.5,0.3161,0.2246,46.4385,32.6764,17.7064,0.6385,2.4735,2.7862,1.1264,3.8741,4.364,0.0
 596.0,36.7784,6.4692,1.9989,2.0205,1.9429,7.875,234769.4844,2206.8025,335.1653,3.5504,3.5925,2.8055,2.4441,3.4974,3.5178,0.0,141.6966,70.8852,143.2298,16.4676,137.7011,233.5691,0.0086,0.1603,918.3123,66.0191,-999.25,-999.25,-999.25,141.6577,143.2686,-999.25,-999.25,1.1276,1853.5895,-39.9363,-0.3677,0.5071,1880.519,159.4105,53.1343,20.3431,6.1165,1880.519,0.2535,1.8699,0.3668,-0.029,8.0387,39.1512,34.502,34.502,31.6228,-0.4744,47.2785,49.1284,53.481,49.1284,0.5318,4.5,0.3164,0.2258,47.1416,33.3682,18.3228,0.6614,2.4892,2.88,1.157,3.7635,4.3544,0.0
 596.5,37.4953,6.4765,1.9956,2.0217,1.9252,7.875,234733.7969,2165.7444,333.5845,3.5488,3.6146,2.8055,2.4448,3.4966,3.5192,0.0,142.9517,71.6306,144.829,16.9948,137.8857,233.3074,0.0066,0.1589,900.187,48.6627,-54.5212,-89.4833,-72.0022,142.8964,144.8908,107.9978,287.9978,1.3766,1815.7689,-40.3723,-0.3677,1.2483,1947.6954,250.6152,83.8763,33.7447,10.9799,1947.8284,0.2535,1.8551,0.3413,-0.1107,8.4105,39.8836,35.2705,35.2705,32.3258,-0.4793,48.178,49.9963,54.2747,49.9963,0.5134,4.5,0.3165,0.2259,47.6947,32.6883,18.2976,0.654,2.3949,2.9066,1.2136,3.6618,4.4441,0.0
 597.0,38.5629,6.4782,1.9989,2.0291,1.9207,7.875,234697.5313,2175.1504,332.2468,3.548,3.6146,2.8047,2.4455,3.5006,3.5212,0.0,145.0363,72.5476,147.2278,17.6433,139.3439,233.6277,0.0053,0.1455,771.7388,39.2312,-54.5212,-89.4833,-72.0022,144.9296,147.348,107.9978,287.9978,1.6482,1833.5736,-40.7913,-0.3677,2.9716,1955.0607,362.0154,122.3826,52.4309,19.7906,1955.2072,0.2535,1.8456,0.1443,-0.0553,8.9121,40.268,35.6749,35.6749,32.6954,-0.4862,48.753,50.5511,54.7821,50.5511,0.5115,4.5,0.3162,0.2261,44.2821,31.1286,17.8373,0.6267,2.235,2.8852,1.2909,3.5665,4.6041,2.0
 597.5,40.4864,6.4793,2.0089,2.0376,1.9305,7.875,234660.9688,2171.3538,331.0725,3.548,3.6162,2.8055,2.4455,3.4982,3.5246,0.0,148.0055,73.6557,150.1026,18.4269,142.2265,234.3178,0.0056,0.1916,890.7762,39.9744,-54.5212,-89.4833,-72.0022,147.7716,150.366,107.9978,287.9978,1.7392,1821.7915,-41.1857,-0.3677,5.6297,1952.0442,436.1229,149.0511,66.1564,28.2882,1952.2,0.2535,1.8398,-0.0282,0.065,9.094,38.8784,34.2164,34.2164,31.3613,-0.4924,49.104,50.8898,55.0917,50.8898,0.5123,4.5,0.316,0.2255,40.3172,29.7079,17.3918,0.6025,2.0959,2.8535,1.3615,3.4786,4.736,0.0
 598.0,44.9331,6.4807,2.03,2.0471,1.9481,7.875,234624.0,2166.2598,330.0335,3.5496,3.6146,2.8047,2.4455,3.5045,3.5233,0.0,152.7934,75.261,154.0711,19.5622,146.6574,235.3353,0.0062,0.2801,1265.3802,46.2148,-54.5212,-89.4833,-72.0022,152.2582,154.6738,107.9978,287.9978,1.5723,1756.4919,-41.8456,-0.3677,7.6836,1945.2888,461.9061,158.705,71.3296,32.6915,1945.4508,0.2535,1.8375,-0.1863,0.1068,8.8537,36.0443,31.2736,31.2736,28.6578,-0.495,49.2445,51.0254,55.2158,51.0254,0.5141,4.5,0.3156,0.2251,38.407,28.2526,16.7563,0.5741,1.9645,2.7798,1.415,3.4222,4.8425,1.0
 598.5,48.3972,6.4801,2.0393,2.0546,1.9601,7.875,234585.8438,2154.8337,328.185,3.5504,3.6146,2.8038,2.4455,3.5013,3.5246,0.0,158.7125,77.8499,159.9081,21.3931,152.6174,237.1287,0.0085,0.4165,1922.543,62.8437,-54.5212,-89.4833,-72.0022,157.8744,160.8892,107.9978,287.9978,1.9016,1720.03,-42.7326,-0.3677,22.3483,1951.1324,547.2297,190.5468,88.8529,45.3349,1951.2999,0.2535,1.8337,-0.0929,0.1982,8.486,35.3988,30.6093,30.6093,28.0454,-0.4946,49.4726,51.2455,55.417,51.2455,0.5125,4.5,0.3156,0.2252,38.1911,27.6946,16.5649,0.5647,1.9023,2.7612,1.4515,3.3685,4.8895,2.0
 599.0,51.5032,6.4752,2.0281,2.045,1.9607,7.875,234546.3281,2133.2441,327.112,3.5496,3.5925,2.8071,2.4489,3.5037,3.524,0.0,163.9409,80.8839,165.3239,23.5388,158.573,239.3723,0.0114,0.3384,1381.0991,68.0752,-999.25,-999.25,-999.25,163.5745,165.7527,-999.25,-999.25,1.3355,1716.0577,-43.8804,-0.3677,101.428,1996.5718,768.8342,277.1731,145.817,101.428,1996.7487,0.2535,1.8281,-0.0511,0.2015,8.1862,35.4282,30.6395,30.6395,28.0733,-0.4942,49.8098,51.5709,55.7146,51.5709,0.5009,4.5,0.3159,0.2257,38.9771,27.9429,16.7072,0.5648,1.9098,2.8078,1.4702,3.3817,4.9718,0.0
 599.5,55.5543,6.4773,2.013,2.0322,1.9568,7.875,234504.8125,2157.3577,326.1743,3.548,3.5885,2.8127,2.4482,3.5069,3.5274,0.0,169.0735,84.0415,170.7061,25.7719,164.4195,240.6874,0.0142,0.2184,792.2866,66.7347,-999.25,-999.25,-999.25,168.9047,170.9037,-999.25,-999.25,1.1835,1794.5891,-45.1527,-0.3677,140.6871,2000.0,898.9937,335.182,188.5403,140.6871,2000.0,0.2535,1.8246,-0.1167,-0.0619,8.0813,36.9998,32.261,32.261,29.5667,-0.4931,50.0268,51.7803,55.906,51.7803,0.5,4.5,0.3154,0.2256,38.6381,28.3479,16.9709,0.5685,1.9303,2.8766,1.4903,3.3953,5.06,0.0
 600.0,58.1957,6.4824,2.0014,2.0223,1.9532,7.875,234461.2344,2131.7644,325.3924,3.5472,3.6146,2.8119,2.4495,3.5053,3.5185,0.0,174.5269,87.2363,176.3608,28.0314,170.3392,241.3504,0.0094,0.144,444.0216,43.0243,-999.25,-999.25,-999.25,174.43,176.4713,-999.25,-999.25,1.1686,1833.9875,-46.4792,-0.3677,67.5427,1999.0848,746.1724,267.3349,138.8056,89.5084,1999.2559,0.2535,1.8261,-0.094,-0.4057,8.1343,35.6453,30.8627,30.8627,28.2791,-0.4891,49.9331,51.6898,55.8233,51.6898,0.5002,4.5,0.3151,0.2253,37.6567,29.3784,17.5817,0.5783,2.0056,3.0309,1.5112,3.4682,5.2412,1.6
 600.5,62.5949,6.4796,2.0008,2.0202,1.9436,7.875,234416.2031,2183.4451,324.2547,3.5418,3.6146,2.8103,2.4475,3.5053,3.5192,0.0,179.8029,89.8768,181.5264,29.8987,174.6051,241.761,0.0065,0.1048,298.5112,30.9817,-999.25,-999.25,-999.25,179.6749,181.6609,-999.25,-999.25,1.1058,1851.9305,-48.028,-0.3677,20.6279,1994.1814,569.8979,197.292,93.7496,47.5785,1994.344,0.2535,1.8352,-0.0932,-0.4564,8.1156,35.6958,30.9146,30.9146,28.327,-0.4839,49.379,51.1552,55.3344,51.1552,0.5015,4.5,0.3164,0.2257,38.5819,29.8701,17.8692,0.575,2.056,3.1406,1.5275,3.5754,5.4616,0.0
 601.0,66.7451,6.483,1.9987,2.0145,1.9232,7.875,234370.3906,2214.8206,323.6097,3.5418,3.6146,2.8184,2.4475,3.5069,3.5198,0.0,184.7126,92.4127,186.1246,31.6921,177.6032,242.3853,0.0043,0.0681,186.6786,21.8888,-999.25,-999.25,-999.25,184.4502,186.387,-999.25,-999.25,1.0493,1864.9216,-49.841,-0.3677,10.3345,1993.6344,502.4715,172.1031,79.5369,39.4298,1993.7866,0.2535,1.8448,-0.0366,0.0042,8.1019,37.2976,32.5697,32.5697,29.8504,-0.4796,48.8004,50.5968,54.8238,50.5968,0.5016,4.5,0.3157,0.2256,39.9568,30.8132,18.1983,0.5719,2.1724,3.2637,1.5024,3.7985,5.7068,1.0
 601.5,65.511,6.4932,2.0013,2.0063,1.8986,7.875,234346.7969,2201.686,323.1763,3.5418,3.632,2.8248,2.4482,3.5109,3.5219,0.0,190.7141,95.2971,191.1366,33.732,180.7538,242.0663,0.0034,0.0677,232.8092,20.5777,-999.25,-999.25,-999.25,190.0885,191.7623,-999.25,-999.25,0.8833,1872.3962,-51.7211,-0.3677,44.501,1992.7894,500.523,171.4146,79.8228,44.501,1992.9286,0.2535,1.847,-0.0182,0.2421,8.1601,37.8754,33.1701,33.1701,30.4019,-0.4745,48.6675,50.4686,54.7066,50.4686,0.5018,4.5,0.3156,0.2252,41.1898,31.3649,18.1594,0.5558,2.2897,3.3271,1.4531,4.1194,5.9859,0.0
 602.0,63.2294,6.4956,2.0028,1.9969,1.8724,7.875,234274.0,2190.8784,322.5698,3.5394,3.632,2.8248,2.4502,3.5156,3.5246,0.0,196.1729,97.973,195.5616,35.6244,183.2726,241.3303,0.0034,0.0825,333.204,25.4046,-999.25,-999.25,-999.25,195.0345,196.7001,-999.25,-999.25,0.8526,1884.9723,-53.6014,-0.3677,53.4048,1994.594,514.5499,176.5263,83.8103,53.4048,1994.594,0.2535,1.8369,-0.1416,-0.3313,7.8761,40.4614,35.8787,35.8787,32.8816,-0.4696,49.2789,51.0585,55.246,51.0585,0.5014,4.5,0.3171,0.2252,43.968,32.5889,18.5063,0.5612,2.4459,3.4154,1.3963,4.3581,6.0854,0.5
 602.5,59.5388,6.5022,1.9879,1.9788,1.8401,7.875,234224.0156,2179.3616,321.7658,3.5441,3.632,2.8273,2.4502,3.5236,3.5294,0.0,199.4366,100.3715,198.5255,37.3207,184.5376,240.2385,0.0036,0.1149,449.0026,27.8296,-999.25,-999.25,-999.25,198.0375,199.9247,-999.25,-999.25,0.9489,1866.937,-55.8252,-0.3677,31.1384,1988.8331,400.555,135.4844,60.146,31.1384,1988.8331,0.2535,1.817,-0.0506,-0.3484,7.0423,44.4038,40.0755,40.0755,36.6992,-0.4688,50.4829,52.2203,56.3084,52.2203,0.5028,4.5,0.3158,0.2243,45.8506,35.0463,19.569,0.5945,2.6931,3.6068,1.3393,4.5304,6.0674,2.0
 603.0,58.6995,6.5224,1.9644,1.9631,1.8132,7.875,234172.875,2194.7905,320.9061,3.5488,3.6533,2.8329,2.4516,3.545,3.5356,0.0,201.073,102.4169,200.9756,38.7673,185.6003,238.0184,0.0026,0.1633,530.1367,18.3582,-999.25,-999.25,-999.25,200.1736,201.875,-999.25,-999.25,0.8479,1896.6385,-58.7013,-0.3677,0.6063,1975.7516,220.4809,73.5696,29.0238,9.2694,1975.7516,0.2535,1.8078,0.2697,0.6053,6.2399,45.2492,40.9858,40.9858,37.5236,-0.4616,51.043,52.7608,56.8026,52.7608,0.5061,4.5,0.3143,0.2236,48.9991,38.5648,21.3608,0.6638,2.9897,3.8665,1.2933,4.5042,5.8252,2.0
 603.5,65.5527,6.526,1.9381,1.9468,1.7988,7.875,234120.9063,2163.6448,319.9277,3.5488,3.6138,2.845,2.4563,3.5681,3.5458,0.0,201.7864,104.1666,202.728,40.0046,187.3058,234.5176,0.0022,0.2212,684.0728,14.2109,-999.25,-999.25,-999.25,201.3616,203.1529,-999.25,-999.25,0.888,1879.214,-62.7674,-0.3677,0.1983,1943.032,113.6487,37.8506,13.9026,4.0071,1943.032,0.2535,1.817,0.4073,0.5562,6.0655,45.0951,40.8196,40.8196,37.3731,-0.4378,50.4852,52.2225,56.3104,52.2225,0.5147,4.5,0.3139,0.2222,55.554,43.9688,24.2403,0.7814,3.4156,4.2541,1.2455,4.3711,5.4441,0.0
 604.0,75.9241,6.5665,1.917,1.9347,1.8014,7.875,234067.8281,2093.1384,318.6951,3.5496,3.6146,2.8466,2.4543,3.6816,3.5527,0.0,201.3498,105.0761,203.2302,40.6479,189.1976,230.7206,0.0024,0.2658,776.4082,13.8542,-999.25,-999.25,-999.25,201.1479,203.4321,-999.25,-999.25,1.1332,1894.2194,-69.1824,-0.3677,0.1111,1913.1918,70.6434,23.5362,8.4064,2.3351,1913.1918,0.2535,1.8226,0.1549,-0.0445,6.3065,46.6742,42.5229,42.5229,38.9389,-0.4129,50.1476,51.8968,56.0126,51.8968,0.5227,4.5,0.3127,0.2216,63.4615,48.4814,26.707,0.8784,3.7639,4.6043,1.2233,4.2852,5.2419,1.6
 604.5,80.3366,6.6276,1.9057,1.933,1.8343,7.875,234014.4375,2056.0496,317.2958,3.5261,3.7756,2.8038,2.4475,3.6252,3.7044,0.0,199.6604,104.8278,202.5326,40.4723,192.1071,226.3766,0.0027,0.2912,848.9653,15.3113,-999.25,-999.25,-999.25,199.5842,202.6088,-999.25,-999.25,1.5085,1891.663,-80.3485,-0.3677,0.145,1889.1217,72.3874,24.1336,6.4071,1.6887,1889.1217,0.2535,1.8351,-0.3154,-0.2374,6.5264,47.3061,43.2043,43.2043,39.5786,-0.3936,49.3874,51.1633,55.3418,51.1633,0.5293,4.5,0.3127,0.2218,67.678,51.5098,28.6378,0.9519,3.9615,4.8895,1.2343,4.1617,5.1366,0.8
 605.0,78.1982,6.6281,1.9129,1.9476,1.8883,7.875,233987.7188,2095.1226,315.9344,3.5316,3.7772,2.8047,2.4421,3.6236,3.7051,0.0,196.2786,102.7403,199.8575,38.9959,193.6244,218.0038,0.0031,0.2782,909.831,19.7767,-999.25,-999.25,-999.25,196.2786,199.8575,-999.25,-999.25,1.8083,1888.4958,-113.9867,-0.3677,0.4045,1836.4167,228.7576,77.1648,27.3453,8.2145,1836.4167,0.2535,1.8802,-0.223,-0.0719,6.6901,46.5572,42.3967,42.3967,38.8212,-0.3751,46.6527,48.5245,52.9288,48.5245,0.5445,4.5,0.3125,0.2211,66.6056,51.316,28.8742,0.9518,3.9134,4.9676,1.2694,4.1115,5.2191,0.8
 605.5,75.8683,6.6301,1.9394,1.9744,1.9439,7.875,233910.2969,2187.2083,313.7079,3.5324,3.778,2.8047,2.4434,3.6252,3.7065,0.0,192.6888,99.55,196.2321,36.7397,193.0961,215.5322,0.0043,0.2403,873.1649,29.2212,-999.25,-999.25,-999.25,192.6888,196.2321,-999.25,-999.25,1.8118,1897.2144,-156.521,-0.3677,0.35,481.0494,330.7695,213.1028,160.7139,109.4579,481.0494,0.2535,1.9146,0.7134,0.0923,6.793,46.5717,42.4123,42.4123,38.8358,-0.3881,44.5708,46.5156,51.0918,46.5156,2.0788,4.5,0.3132,0.2252,64.7034,49.7302,28.5299,0.9349,3.7235,4.9348,1.3253,3.9829,5.2787,0.0
 606.0,74.4902,6.6295,1.9883,2.0139,1.9888,7.875,233862.1406,2195.1926,311.3858,3.5324,3.7749,2.8063,2.4448,3.6252,3.7051,0.0,189.7022,95.596,192.2115,33.9434,189.7735,219.3082,0.0062,0.1422,554.9471,44.9334,-999.25,-999.25,-999.25,189.7022,192.2115,-999.25,-999.25,1.3017,1894.8076,-140.7889,-0.3677,0.3212,77.004,50.4924,33.0337,28.824,29.2998,77.004,0.2535,1.9078,1.8233,-0.4125,6.7041,46.3164,42.137,42.137,38.5798,-0.3941,44.9816,46.912,51.4543,46.912,12.9863,4.5,0.3151,0.2326,62.5069,49.6177,29.1415,0.9588,3.6138,5.0221,1.3897,3.769,5.2377,0.0
 606.5,72.6699,6.6285,2.0272,2.0504,2.029,7.875,233816.4531,2200.2744,309.7229,3.5324,3.7741,2.8038,2.4441,3.6252,3.7058,0.0,187.2651,92.5022,189.4474,31.7555,187.4464,222.1201,0.0074,0.0911,413.1268,61.1487,-999.25,-999.25,-999.25,187.2617,189.4508,-999.25,-999.25,1.1562,1923.9445,-84.4374,-0.3677,0.3471,12.1983,7.9626,5.2343,4.6574,4.3251,22.6971,0.2535,1.8852,2.4437,-0.1999,5.6655,47.9997,43.9524,43.9524,40.2881,-0.2719,46.3497,48.2321,52.6615,48.2322,81.9787,4.5,0.314,0.2469,65.3182,48.2181,28.7779,0.9539,3.4313,4.9262,1.4357,3.5972,5.1644,0.0
 607.0,72.9538,6.631,2.0517,2.0711,2.0516,7.875,233771.9219,2235.9753,307.8263,3.5386,3.7749,2.8063,2.4427,3.626,3.7044,0.0,186.507,90.9647,188.2784,30.6681,186.476,223.5029,0.0075,0.0609,335.4751,68.3961,-999.25,-999.25,-999.25,186.4782,188.3072,-999.25,-999.25,0.9752,1925.6832,-55.5344,-0.3677,0.5449,1.9788,1.3904,0.9821,1.0321,1.0703,2.1401,0.2535,1.8087,1.8079,0.6115,3.7777,49.4712,45.5392,45.5392,41.8151,-0.067,50.9895,52.7092,56.7555,52.7092,505.3642,4.5,0.3183,0.3405,72.3352,47.3605,28.5237,0.9623,3.3143,4.8027,1.4491,3.4442,4.9908,0.0
 607.5,78.3123,6.6294,2.0632,2.0776,2.0432,7.875,233727.1563,2188.9751,305.9247,3.5324,3.778,2.8047,2.4427,3.6252,3.7051,0.0,187.8576,91.0833,189.1454,30.752,185.9657,223.2467,0.0068,0.0551,371.1107,67.1928,-999.25,-999.25,-999.25,187.7608,189.2423,-999.25,-999.25,0.7893,1907.9595,-63.1258,-0.2055,0.5921,0.7428,0.612,0.4925,0.5395,0.5825,0.7647,0.2535,1.7496,0.1713,0.8458,2.8181,45.9645,41.7574,41.7574,38.2289,0.0752,54.5697,56.1637,59.9144,56.1637,1346.2468,4.5,0.7602,0.7845,74.7486,47.979,28.9092,0.9898,3.3537,4.7988,1.4309,3.3883,4.8482,1.6
 608.0,85.8867,6.6325,2.0636,2.0694,2.0132,7.875,233681.7969,2164.0696,304.0177,3.5418,3.7772,2.8047,2.4421,3.6252,3.7065,0.0,190.614,92.4039,191.1173,31.6859,185.8571,221.0715,0.0055,0.0677,529.3105,58.5168,-999.25,-999.25,-999.25,190.3124,191.4189,-999.25,-999.25,0.5817,1899.8169,-65.7828,-0.1146,0.6985,0.7872,0.6791,0.5638,0.63,0.7135,0.8111,0.2535,1.9583,-0.7718,0.5628,3.1922,43.9349,39.5721,39.5721,36.2428,0.1816,41.9225,43.9603,48.7552,43.9603,1270.2925,10.6624,1.6872,1.1923,76.0753,51.1863,30.7158,1.0678,3.5905,5.0223,1.3988,3.3626,4.7036,6.0
 608.5,87.7444,6.6309,2.0517,2.0487,1.9803,7.875,233658.5,2170.7454,302.1322,3.5316,3.7804,2.8055,2.4434,3.626,3.7058,0.0,194.1975,94.6909,193.8603,33.3033,187.3285,216.1831,0.0035,0.0935,766.0597,38.173,-999.25,-999.25,-999.25,193.4453,194.6125,-999.25,-999.25,0.6002,1905.9789,-67.1574,-0.0378,1.0503,1.0636,0.9428,0.79,0.8805,1.0759,1.1054,0.2535,2.3205,-0.5212,-0.4352,3.8726,40.6375,36.0645,36.0645,33.0512,0.2536,19.9715,22.7795,29.3866,22.7795,940.1649,11.5559,2.0473,1.4954,76.3617,56.6802,34.024,1.2066,3.9605,5.4499,1.3761,3.2822,4.5166,3.0
 609.0,86.3929,6.6313,2.0421,2.0304,1.9618,7.875,233585.4375,2176.1262,300.4691,3.5316,3.7804,2.8055,2.4448,3.6252,3.7065,0.0,197.4655,96.7309,196.3047,34.746,189.6247,206.5386,0.0019,0.116,982.7003,22.5773,-999.25,-999.25,-999.25,196.1626,197.6077,-999.25,-999.25,0.7315,1912.6921,-68.397,-0.0585,1.5343,1.5767,1.4261,1.2019,1.3122,1.5784,1.6597,0.2535,2.5,-0.2312,-0.6715,4.0523,36.1174,31.349,31.349,28.7273,0.1991,9.0908,12.2806,19.786,12.2806,634.2323,11.8522,2.8921,1.7837,72.4708,59.2064,35.8221,1.2944,4.0855,5.6239,1.3766,3.1562,4.3447,1.0
 609.5,86.6669,6.6302,2.0454,2.0261,1.9699,7.875,233535.6406,2142.238,298.8592,3.53,3.7812,2.8063,2.4421,3.6252,3.7058,0.0,198.6904,97.1983,196.7989,35.0766,191.222,202.0145,0.0014,0.1452,1279.8615,18.6564,-999.25,-999.25,-999.25,196.7521,198.7371,-999.25,-999.25,1.0003,1883.2448,-69.2406,-0.1991,1.7679,2.1744,2.0179,1.7499,1.7949,1.813,2.2671,0.2535,2.5194,-0.2599,0.0061,3.7329,34.7429,29.9365,29.9365,27.4243,0.1003,7.9148,11.1459,18.7484,11.1459,459.8993,12.2835,2.1678,1.7485,71.9186,62.3396,38.1364,1.4023,4.229,5.8721,1.3885,3.0157,4.1874,0.0
 610.0,80.4024,6.633,2.0585,2.0355,1.9981,7.875,233486.1875,2164.7573,297.135,3.5355,3.7843,2.8047,2.4441,3.6252,3.7051,0.0,197.2168,95.8967,194.9905,34.1561,191.1808,203.8815,0.0017,0.1747,1465.8184,23.9363,-999.25,-999.25,-999.25,194.9605,197.2468,-999.25,-999.25,1.1613,1907.3488,-69.908,-0.2432,1.8128,2.4314,2.3109,2.0714,2.0094,1.8527,2.4391,0.2535,2.5055,-0.0738,0.369,3.4503,34.2083,29.3899,29.3899,26.9191,0.0575,8.7597,11.9611,19.4938,11.9611,411.2921,12.2753,2.2871,1.9961,72.5476,65.2945,40.3734,1.5031,4.3576,6.1288,1.4065,2.8991,4.0775,2.4
 610.5,67.9484,6.6353,2.0856,2.0645,2.0584,7.875,233438.5938,2158.2642,295.3154,3.5418,3.782,2.8063,2.4448,3.6268,3.7044,0.0,192.7764,92.5759,190.7775,31.8075,189.9186,211.5905,0.0028,0.2029,1423.7496,36.5703,-999.25,-999.25,-999.25,190.6653,192.8886,-999.25,-999.25,1.1548,1864.1849,-70.8555,-0.2595,1.7134,2.3389,2.2524,2.0621,1.9323,1.7557,2.3451,0.2535,2.4825,0.2828,0.4946,3.2889,35.5826,30.7981,30.7981,28.2196,0.0476,10.1518,13.3043,20.7221,13.3043,427.5501,12.2665,2.4397,1.7504,74.9297,67.5193,42.1414,1.5941,4.4216,6.2778,1.4198,2.7738,3.9382,0.0
 611.0,62.3009,6.6337,2.1219,2.106,2.1338,7.875,233394.0781,2151.6106,293.6122,3.5308,3.7827,2.8095,2.4455,3.626,3.7065,0.0,186.8439,88.2077,185.35,28.7183,187.5318,213.2422,0.0045,0.2185,1270.7795,55.5744,-999.25,-999.25,-999.25,185.0293,187.1646,-999.25,-999.25,1.1441,1868.7793,-71.5841,-0.2076,1.6341,2.1105,2.0586,1.9288,1.7809,1.6696,2.1154,0.2535,2.4661,0.2879,0.2128,3.1649,36.7108,31.9618,31.9618,29.2915,0.0472,11.1467,14.2643,21.6,14.2644,473.8143,12.5512,2.2385,1.5215,81.523,70.0557,44.7444,1.7181,4.411,6.544,1.4836,2.5673,3.8088,1.6
 611.5,62.4767,6.6356,2.145,2.1438,2.1958,7.875,233352.5,2148.719,292.1602,3.5355,3.7843,2.8047,2.4475,3.6268,3.7079,0.0,180.1612,84.0947,179.9352,25.8095,184.1889,218.1592,0.0064,0.2197,1185.1063,80.9825,-999.25,-999.25,-999.25,179.1686,180.9278,-999.25,-999.25,0.9771,1845.4243,-71.5348,-0.1538,1.6087,1.9545,1.9229,1.8358,1.6927,1.631,1.9585,0.2535,2.4671,-0.1193,0.1475,3.1271,37.3884,32.664,32.664,29.9371,0.0501,11.0868,14.2066,21.5472,14.2066,511.6411,12.5036,2.144,1.3647,86.0964,70.3276,46.2181,1.8017,4.1934,6.6317,1.5815,2.3275,3.6808,0.8
 612.0,61.8771,6.6351,2.1509,2.1643,2.1831,7.875,233332.3594,2149.3049,290.326,3.5347,3.7843,2.8071,2.4475,3.6252,3.7065,0.0,173.9538,80.9468,174.9199,23.5833,176.5061,221.9634,0.007,0.1774,975.8216,115.8159,-999.25,-999.25,-999.25,173.4187,175.455,-999.25,-999.25,1.1782,1892.9766,-70.8781,-0.1105,1.5972,1.8422,1.8262,1.7738,1.6528,1.6148,1.8455,0.2535,2.4762,-0.3698,0.2194,3.1618,38.3546,33.6693,33.6693,30.8599,0.0532,10.5307,13.67,21.0565,13.67,542.8331,12.5923,1.9494,1.4856,85.3166,70.1602,47.3708,1.8655,3.9742,6.7077,1.6878,2.1304,3.5957,0.8
 612.5,63.8714,6.6349,2.145,2.169,2.1704,7.875,233275.2656,2191.7971,288.5724,3.5316,3.7875,2.8071,2.4468,3.6252,3.7065,0.0,169.3629,79.0315,171.1652,22.2288,171.3344,224.6627,0.0082,0.1286,799.5231,168.7718,-999.25,-999.25,-999.25,169.0126,171.5154,-999.25,-999.25,1.4816,1886.8843,-70.2231,-0.0754,1.5793,1.745,1.7371,1.7087,1.6166,1.5822,1.7459,0.2535,2.4601,-0.1733,-0.0894,3.135,40.4329,35.8487,35.8487,32.8541,0.056,11.5105,14.6153,21.921,14.6153,573.079,12.6649,1.7699,1.4727,83.4957,70.5505,48.9019,1.9298,3.7939,6.9054,1.8202,1.966,3.5784,0.0
 613.0,69.6355,6.6333,2.1187,2.1407,2.1315,7.875,233236.8594,2167.0977,287.0117,3.5285,3.7851,2.8063,2.4468,3.6268,3.7065,0.0,168.7446,79.7623,170.402,22.7456,169.706,225.62,0.0105,0.1142,849.0214,264.5276,-25.8684,-60.8832,-43.3758,168.3047,170.9036,136.6242,316.6242,1.5375,1867.478,-70.0136,-0.0565,1.5683,1.6919,1.6892,1.6759,1.613,1.5705,1.6919,0.2535,2.4472,0.2035,-0.2503,3.0541,40.9845,36.4309,36.4309,33.3856,0.0635,12.2934,15.3708,22.6118,15.3708,591.0588,12.6354,1.8712,1.3327,86.0429,68.3984,48.3345,1.9136,3.5269,6.7956,1.9268,1.843,3.5511,0.0
 613.5,71.4758,6.6378,2.0708,2.0798,2.061,7.875,233196.6406,2177.2622,285.5747,3.5363,3.7867,2.8095,2.4468,3.6268,3.7072,0.0,169.6587,82.0822,170.2949,24.3863,168.7694,226.9036,0.0138,0.1232,997.7571,421.45,-25.8684,-60.8832,-43.3758,168.831,171.252,136.6242,316.6242,1.4261,1881.7592,-70.4734,-0.0552,1.5903,1.7128,1.7107,1.7051,1.6682,1.602,1.7128,0.2535,2.4761,0.3813,-0.0234,3.0275,39.4768,34.8433,34.8433,31.9352,0.0762,10.5405,13.6794,21.0651,13.6794,583.8477,12.6246,1.7363,1.2889,84.2826,64.4728,46.4402,1.8355,3.1921,6.5443,2.0501,1.7391,3.5654,0.8
 614.0,68.9318,6.635,2.0176,2.011,2.0029,7.875,233153.7969,2167.4417,282.4124,3.5378,3.7859,2.8055,2.4461,3.6252,3.7044,0.0,170.5096,84.6516,169.8678,26.2034,169.2426,228.0114,0.0172,0.1725,1075.6449,530.0973,-12.5794,-45.9828,-29.2811,168.9003,171.7666,117.8823,297.8823,1.6812,1873.2363,-71.6241,-0.0424,1.658,1.7558,1.7541,1.7516,1.7352,1.6627,1.7558,0.2535,2.5173,0.2816,0.2147,3.0263,37.5867,32.8699,32.8699,30.1262,0.0926,8.0415,11.2681,18.8601,11.2681,569.5399,12.491,1.8152,1.8376,72.2032,57.8661,42.3128,1.6752,2.7554,5.9491,2.1591,1.6448,3.5513,0.8
 614.5,69.9352,6.6336,1.9779,1.9684,1.9788,7.875,233109.7813,2196.0295,280.703,3.5332,3.7851,2.8047,2.4448,3.626,3.7072,0.0,170.5874,86.3383,169.7181,27.3963,170.6779,228.092,0.017,0.305,1570.4796,378.6656,-12.5794,-45.9828,-29.2811,168.6418,172.2921,117.8823,297.8823,2.1349,1877.6473,-72.9478,-0.0471,1.6961,1.8073,1.8038,1.8009,1.7773,1.698,1.8073,0.2535,2.5319,0.2497,0.2733,2.985,36.1744,31.4077,31.4077,28.7814,0.1148,7.1554,10.413,18.0782,10.4131,553.3202,12.2853,2.7741,2.41,60.6351,52.2076,38.5944,1.5383,2.4141,5.3773,2.2274,1.5693,3.4955,2.0
 615.0,70.2642,6.6364,1.9662,1.9623,1.9489,7.875,233066.3906,2187.2307,278.8788,3.5355,3.7859,2.8063,2.4461,3.6276,3.7079,0.0,171.4823,87.2492,171.132,28.0404,169.9539,227.4295,0.0109,0.4792,2475.6953,214.7755,-2.4979,-34.6787,-18.5883,169.7766,173.5537,103.6639,283.6639,2.1986,1889.1752,-73.6919,-0.0458,1.7004,1.8089,1.8063,1.803,1.7747,1.7017,1.8089,0.2535,2.5314,0.4956,0.3577,2.9795,33.4977,28.6657,28.6657,26.2487,0.1166,7.186,10.4426,18.1053,10.4426,552.8137,11.5413,1.2489,1.292,58.5625,49.6047,37.0266,1.4823,2.2273,5.1282,2.3025,1.5026,3.4597,2.0
 615.5,67.6994,6.6356,1.9615,1.9531,1.9209,7.875,233022.8906,2169.9084,277.0846,3.5308,3.7867,2.8071,2.4468,3.6276,3.7079,0.0,173.5773,88.4895,172.8475,28.9176,169.957,226.7637,0.0083,0.4477,2191.0088,124.1383,23.607,-5.4084,9.0993,171.5426,175.3353,66.8472,246.8471,2.2036,1855.6735,-73.8297,-0.0419,1.704,1.8033,1.8011,1.7969,1.7657,1.7049,1.8033,0.2535,2.5583,0.3399,0.0403,3.1018,30.9439,26.0856,26.0856,23.8522,0.0888,5.5587,8.8725,16.6695,8.8725,554.533,10.7904,2.4757,1.6868,61.0169,51.5675,38.6769,1.5663,2.2708,5.2714,2.3214,1.4498,3.3654,0.0
 616.0,73.8698,6.6367,1.9622,1.9609,1.9086,7.875,232978.6094,2189.1465,274.6101,3.5355,3.7859,2.8071,2.4475,3.6268,3.7072,0.0,177.1357,90.2545,177.0353,30.1659,172.269,226.1846,0.0065,0.2841,1252.5778,65.6723,-999.25,-999.25,-999.25,175.6345,178.8067,-999.25,-999.25,1.8287,1872.7639,-73.7923,-0.0281,1.656,1.7206,1.722,1.7196,1.6977,1.6566,1.7206,0.2535,2.5778,-0.3245,0.0211,3.173,30.6569,25.7979,25.7979,23.5841,0.0598,4.3773,7.7324,15.627,7.7325,581.1816,10.5143,2.8157,1.9909,67.2926,55.7411,42.0849,1.7191,2.4102,5.6661,2.3509,1.402,3.296,0.0
 616.5,94.8525,6.6377,1.9717,1.9725,1.9101,7.875,232932.9219,2161.4424,272.2057,3.5363,3.7867,2.8055,2.4455,3.63,3.7092,0.0,182.3113,92.4359,182.3804,31.7086,176.6105,225.5983,0.0033,0.1763,866.5891,28.3053,-999.25,-999.25,-999.25,181.3911,183.4251,-999.25,-999.25,1.1518,1853.0597,-74.5016,-0.0106,1.5657,1.5887,1.5929,1.5923,1.5839,1.5659,1.5887,0.2535,2.5584,-0.5189,0.6459,3.0822,33.685,28.8564,28.8564,26.4253,0.0392,5.5507,8.8647,16.6624,8.8647,629.4563,10.4375,2.7517,2.0337,75.3401,59.8787,45.1973,1.8617,2.5955,6.0116,2.3161,1.3942,3.229,0.8
 617.0,111.0562,6.6369,1.9878,1.9851,1.9284,7.875,232885.7813,2166.2136,269.7104,3.5363,3.7867,2.8055,2.4475,3.6268,3.7079,0.0,188.4657,94.7952,188.2123,33.3771,182.8642,222.7579,0.002,0.1114,758.1133,27.1518,-999.25,-999.25,-999.25,187.7004,189.0072,-999.25,-999.25,0.7198,1864.3683,-76.0738,0.0093,1.4997,1.4805,1.4884,1.4913,1.4895,1.4997,1.4805,0.2535,2.5414,-0.3989,0.2683,2.9707,32.3615,27.5134,27.5134,25.18,0.0267,6.5789,9.8568,17.5696,9.8568,675.4459,10.4768,2.9278,1.8504,76.1172,61.4271,46.3747,1.9218,2.6656,6.1131,2.2933,1.387,3.1809,0.8
 617.5,104.2654,6.6297,1.9907,1.9891,1.9372,7.875,232837.0781,2182.6306,267.6074,3.53,3.7772,2.8038,2.4441,3.6268,3.7072,0.0,192.7885,96.8445,192.6346,34.8264,187.6354,226.0242,0.0021,0.0785,701.4982,39.6255,46.9775,20.7961,33.8868,192.2539,193.1833,33.8868,213.8868,0.4984,1848.119,-77.5075,0.0244,1.4473,1.3988,1.4089,1.4138,1.4225,1.447,1.3988,0.2535,2.5253,-0.2037,-0.1971,2.9236,31.9623,27.1103,27.1103,24.8056,0.021,7.5561,10.7997,18.4319,10.7998,714.9137,10.3913,2.5867,1.5998,74.2579,60.202,45.4853,1.8966,2.5894,5.9408,2.2943,1.3653,3.1324,0.0
 618.0,85.7093,6.6323,1.9979,1.9951,1.9497,7.875,232787.125,2187.001,265.5813,3.5332,3.7772,2.8063,2.4448,3.6268,3.7085,0.0,195.43,97.8344,195.1469,35.5265,190.7403,219.9933,0.0025,0.0834,662.2901,43.712,47.7151,21.0892,34.4022,194.907,195.67,34.4022,214.4022,0.3937,1872.6841,-78.6267,0.0355,1.3999,1.332,1.3443,1.3516,1.3685,1.3994,1.332,0.2535,2.5083,0.3115,0.2222,2.942,32.9474,28.1067,28.1067,25.7306,0.0172,8.5883,11.7957,19.3426,11.7958,750.7595,10.4247,2.6161,1.5079,75.5204,57.343,43.483,1.8298,2.4161,5.6,2.3177,1.3204,3.0604,0.0
 618.5,71.0178,6.6296,2.0152,2.0127,1.9677,7.875,232762.2188,2194.0791,263.838,3.5316,3.7733,2.8055,2.4455,3.6252,3.7079,0.0,195.7513,97.1785,195.5038,35.0626,191.1734,223.8098,0.0029,0.1199,715.6301,41.0147,49.1903,21.6756,35.433,195.2518,196.0033,35.433,215.433,0.3855,1888.7838,-79.1653,0.0391,1.3897,1.3155,1.3293,1.3381,1.36,1.3885,1.3155,0.2535,2.5133,0.542,0.0431,2.9739,32.5758,27.7303,27.7303,25.3814,0.0164,8.2822,11.5004,19.0725,11.5004,760.1959,10.394,2.6191,1.5983,70.715,55.4212,42.2445,1.7946,2.2878,5.3604,2.343,1.2749,2.987,0.0
 619.0,67.5912,6.6314,2.0353,2.033,1.9863,7.875,232689.1719,2185.3955,262.185,3.5347,3.7749,2.8055,2.4468,3.6252,3.7072,0.0,194.8441,95.7714,194.6165,34.0674,190.1853,229.722,0.0037,0.174,856.5602,42.5089,50.6656,22.2619,36.4637,194.3165,195.1441,36.4637,216.4637,0.4258,1868.2034,-79.3531,0.04,1.4228,1.3451,1.3611,1.3719,1.3987,1.4216,1.3451,0.2535,2.5263,0.271,-0.3999,2.9773,32.483,27.6364,27.6364,25.2942,0.0255,7.4941,10.7399,18.3772,10.7399,743.43,10.3788,3.0992,1.937,67.1944,60.2177,46.0204,1.9699,2.4634,5.7688,2.3418,1.2506,2.9285,6.4
 619.5,70.2767,6.633,2.0551,2.0559,1.9933,7.875,232642.25,2204.3132,260.6594,3.5347,3.7764,2.8071,2.4468,3.6268,3.7072,0.0,193.1146,93.9925,193.1822,32.8094,187.3351,229.8245,0.0051,0.2451,968.4457,50.4005,52.1408,22.8482,37.4945,192.6973,193.5995,37.4945,217.4945,0.4678,1896.8455,-78.1411,0.0406,1.4769,1.3951,1.4124,1.4245,1.4554,1.4759,1.3951,0.2535,2.5099,-0.121,-0.4208,2.9591,32.0797,27.2287,27.2287,24.9156,0.0417,8.4898,11.7006,19.2557,11.7006,716.8022,10.465,3.6913,2.1741,83.2378,70.8073,54.1507,2.3334,2.9111,6.7142,2.3064,1.2475,2.8774,3.0
 620.0,71.1552,6.6359,2.0554,2.0608,1.9906,7.875,232595.9063,2191.051,260.0891,3.5418,3.7764,2.8063,2.4461,3.6284,3.7085,0.0,190.2657,92.5663,190.7569,31.8007,184.2561,228.5709,0.0046,0.2657,871.6415,35.7831,53.6161,23.4345,38.5253,190.0229,190.9998,38.5253,218.5253,0.5125,1855.3169,-75.8702,0.0467,1.5003,1.4049,1.4217,1.4342,1.4688,1.4993,1.4049,0.2535,2.4527,-0.4159,-0.4251,2.9077,34.451,29.6378,29.6378,27.1483,0.0433,11.955,15.0443,22.3132,15.0443,711.8183,10.484,2.793,1.7774,107.3377,81.3671,62.2097,2.6829,3.3695,7.7029,2.286,1.2559,2.8711,2.0
 620.5,67.1498,6.6338,2.0413,2.0475,1.9837,7.875,232549.9219,2208.7405,259.5733,3.5378,3.7772,2.8063,2.4448,3.6268,3.7085,0.0,186.4162,91.3047,186.9801,30.9086,181.1102,228.3768,0.0043,0.2797,939.7519,28.4178,55.0913,24.0208,39.5561,186.1552,187.1678,39.5561,219.5561,0.5467,1825.4073,-74.0933,0.0538,1.4367,1.3315,1.3449,1.3554,1.389,1.4353,1.3315,0.2535,2.4115,-0.2381,-0.3571,2.8495,35.2385,30.4446,30.4446,27.8934,0.0303,14.4566,17.4581,24.5205,17.4581,751.0046,10.6086,2.1841,1.3775,114.1977,83.2278,63.5144,2.751,3.4886,7.8083,2.2383,1.2681,2.8384,2.0
 621.0,60.1925,6.635,2.0214,2.0276,1.9887,7.875,232504.7813,2192.8411,257.645,3.5386,3.7772,2.8063,2.4468,3.6268,3.7092,0.0,181.7109,89.8725,182.2695,29.8957,178.7117,227.4803,0.0054,0.5035,1996.4475,31.9964,47.875,20.1944,34.0347,181.1953,182.487,34.0347,214.0347,0.7323,1806.451,-73.4091,0.0577,1.3802,1.272,1.2819,1.2901,1.3213,1.3785,1.272,0.2535,2.4318,0.3699,0.2509,2.8683,36.993,32.2539,32.2539,29.5602,0.0225,13.2262,16.2709,23.4349,16.2709,786.1395,10.6117,1.8955,1.1639,99.4382,75.573,57.4376,2.4926,3.2222,7.0386,2.1844,1.2927,2.8238,1.0
 621.5,55.8474,6.6337,2.0095,2.0174,1.9945,7.875,232460.4375,2167.9468,256.5791,3.5355,3.7764,2.8063,2.4461,3.6276,3.7092,0.0,177.6437,88.3875,178.3463,28.8455,176.2685,226.9584,0.0063,0.9749,4103.6968,38.4943,45.7688,18.0971,31.9329,176.6968,178.6689,31.9329,211.9329,1.15,1859.8314,-72.4135,0.0535,1.4562,1.3501,1.3569,1.3632,1.3924,1.4542,1.3501,0.2535,2.4792,0.5998,0.8149,2.9579,35.7149,30.9343,30.9343,28.3451,0.0215,10.3528,13.4983,20.8995,13.4983,740.6732,10.5855,2.0145,1.4052,80.8833,65.5156,49.2911,2.1486,2.8588,5.9952,2.0971,1.3306,2.7904,5.0
 622.0,53.6974,6.6354,2.0074,2.0124,2.0027,7.875,232417.0469,2176.8601,255.8003,3.5332,3.7756,2.8127,2.4461,3.63,3.7085,0.0,174.831,87.0881,175.2749,27.9265,174.383,226.5284,0.0063,1.9088,8235.6611,46.0334,45.7688,18.0971,31.9329,172.8707,175.9137,31.9329,211.9329,1.8047,1893.5985,-70.6454,0.0396,1.6369,1.5485,1.5507,1.5541,1.5779,1.6362,1.5485,0.2535,2.5167,0.1982,0.3891,2.9994,32.041,27.1897,27.1897,24.8793,0.0201,8.0785,11.3038,18.8928,11.3038,645.8013,10.5756,2.618,1.7213,71.0219,59.4328,44.338,1.9342,2.6423,5.3854,2.0382,1.3661,2.7843,1.6
 622.5,51.6323,6.6365,1.9986,1.9999,2.0003,7.875,232374.0,2133.1177,254.9271,3.5363,3.778,2.8087,2.4475,3.6284,3.7106,0.0,172.4955,86.311,172.6268,27.3769,172.6283,226.7391,0.0063,3.3225,15181.5947,56.6486,45.7688,18.0971,31.9329,168.3598,173.9649,31.9329,211.9329,3.3495,1869.0334,-68.7311,0.014,1.8108,1.776,1.7686,1.7654,1.7783,1.8131,1.776,0.2535,2.542,-0.2098,0.1093,2.9533,29.7707,24.9123,24.9123,22.7578,0.0208,6.5483,9.8273,17.5426,9.8273,563.0678,10.4832,3.2053,1.9854,69.4187,57.6216,42.3513,1.8605,2.6362,5.0827,1.928,1.417,2.7319,3.2
 623.0,50.877,6.6347,2.0004,1.9905,2.0063,7.875,232331.1563,2147.3198,254.4804,3.5332,3.7772,2.8063,2.4475,3.6308,3.7092,0.0,171.3489,85.6597,170.5136,26.9163,171.8498,227.0879,0.0053,3.6312,18318.084,52.9795,39.818,12.4123,26.1152,166.7314,173.154,26.1152,206.1152,3.8323,1878.1658,-67.0513,-0.0194,1.9845,2.0379,2.0165,2.0027,1.9896,1.992,2.0379,0.2535,2.562,-0.3843,0.1989,2.8858,28.7945,23.9417,23.9417,21.8503,0.0258,5.3325,8.6542,16.4699,8.6542,490.7098,10.446,3.4863,2.0915,69.8621,56.1798,41.0145,1.8073,2.6061,4.8962,1.8787,1.442,2.7092,0.8
 623.5,54.3078,6.6379,2.0085,1.9955,2.024,7.875,232288.5625,2133.5422,254.2184,3.5418,3.778,2.8063,2.4475,3.6308,3.7092,0.0,171.2744,85.2797,170.1761,26.6476,172.5995,227.3716,0.0046,2.3583,11446.7529,42.0644,-999.25,-999.25,-999.25,168.1227,172.4287,-999.25,-999.25,2.56,1846.4253,-66.0246,-0.0591,2.2465,2.4317,2.3899,2.3606,2.3081,2.2647,2.4317,0.2535,2.5828,-0.3174,0.0217,2.8816,25.7015,20.901,20.901,18.9943,0.0302,4.0743,7.4401,15.3597,7.4401,411.2424,10.3501,3.8827,2.3013,67.2506,52.896,38.103,1.6853,2.5155,4.5186,1.7963,1.4926,2.6812,0.0
 624.0,62.0262,6.6375,2.0173,2.0008,2.0301,7.875,232246.0156,2152.6086,253.4312,3.5418,3.7764,2.8079,2.4468,3.6284,3.7113,0.0,171.4687,85.0006,170.0728,26.4502,172.5621,227.2633,0.0036,1.478,6462.7202,32.256,-999.25,-999.25,-999.25,169.1061,172.0108,-999.25,-999.25,1.7191,1875.678,-65.7711,-0.0986,2.5524,2.9055,2.8369,2.7864,2.6825,2.5883,2.9056,0.2535,2.5929,0.105,0.1145,2.9597,23.3399,18.6153,18.6153,16.8334,0.0328,3.4599,6.8473,14.8176,6.8473,344.1749,10.3173,3.6295,2.2573,61.736,49.736,35.3614,1.5646,2.4377,4.1908,1.7191,1.5581,2.6785,3.0
 624.5,66.6544,6.6389,2.0155,1.9974,2.0122,7.875,232203.6719,2136.9951,252.7442,3.5472,3.7756,2.8087,2.4455,3.6284,3.7113,0.0,170.796,84.7418,169.2663,26.2672,170.5179,226.9619,0.0034,0.9905,3849.1987,27.3229,-999.25,-999.25,-999.25,168.785,171.0767,-999.25,-999.25,1.3546,1879.7201,-65.9585,-0.1254,2.6414,3.1081,3.0166,2.9471,2.8015,2.6881,3.1083,0.2535,2.5851,0.2952,0.0504,3.0122,23.6139,18.8789,18.8789,17.0832,0.0359,3.9337,7.3044,15.2356,7.3044,321.7362,10.3679,2.9492,2.0903,58.6794,47.6708,33.7555,1.4862,2.3628,4.0352,1.7078,1.5898,2.7151,2.0
 625.0,60.9045,6.6391,2.0093,1.9901,1.9892,7.875,232161.3906,2153.8242,251.9817,3.5465,3.7756,2.8071,2.4468,3.6292,3.712,0.0,169.9726,84.5934,168.35,26.1622,168.2783,226.5354,0.0036,0.7669,2378.5911,25.4196,-999.25,-999.25,-999.25,168.1943,170.1369,-999.25,-999.25,1.1473,1872.6718,-66.8244,-0.1353,2.5545,3.0417,2.9374,2.8561,2.691,2.5982,3.0419,0.2535,2.5697,-0.2046,-0.4627,2.9265,26.219,21.4061,21.4061,19.4701,0.0347,4.8681,8.2061,16.0601,8.2061,328.7623,10.2881,2.7579,2.0352,58.7275,45.7154,32.2172,1.4095,2.2908,3.8939,1.6998,1.6252,2.7625,0.0
 625.5,54.0763,6.6394,2.0005,1.987,1.9915,7.875,232119.125,2176.7681,250.928,3.548,3.7764,2.8071,2.4448,3.6292,3.7126,0.0,169.0697,84.5129,167.9278,26.1053,168.3064,226.0623,0.004,0.763,1885.9697,26.4066,-999.25,-999.25,-999.25,167.8197,169.1779,-999.25,-999.25,0.8051,1859.647,-68.2528,-0.1362,2.431,2.898,2.788,2.7003,2.5303,2.4643,2.8982,0.2535,2.5536,-0.6972,-0.5159,2.7322,27.632,22.7927,22.7927,20.7735,0.0282,5.8396,9.1435,16.9173,9.1435,345.0647,10.2695,3.1602,1.9218,56.3704,44.3311,31.2417,1.3538,2.2304,3.8377,1.7207,1.6475,2.8347,2.0
 626.0,55.3503,6.642,2.0034,1.9891,1.9803,7.875,232076.9219,2148.272,249.7069,3.5519,3.7772,2.8103,2.4441,3.6284,3.714,0.0,169.1967,84.46,167.9944,26.0679,167.2474,225.6277,0.0042,0.7981,1906.0616,27.556,-999.25,-999.25,-999.25,167.9433,169.2478,-999.25,-999.25,0.7752,1873.3173,-69.79,-0.141,2.3864,2.8611,2.7454,2.6508,2.4768,2.4197,2.8613,0.2535,2.5379,-0.5868,-0.0489,2.593,26.7322,21.9084,21.9084,19.9428,0.0225,6.7968,10.067,17.7618,10.067,349.5171,10.1613,3.0455,1.9964,52.0504,43.1543,30.345,1.3048,2.1754,3.7757,1.7356,1.6672,2.8936,5.0
 626.5,60.638,6.6402,2.0053,1.9957,1.9875,7.875,232035.2188,2137.0061,249.0537,3.5512,3.7772,2.8071,2.4434,3.6284,3.7133,0.0,169.6626,84.6139,168.8453,26.1768,168.1514,225.3042,0.0043,0.6376,1552.9027,28.2219,-999.25,-999.25,-999.25,168.8198,169.6882,-999.25,-999.25,0.5143,1868.5498,-70.6175,-0.1496,2.4172,2.9281,2.806,2.7033,2.5241,2.4619,2.9283,0.2535,2.5223,-0.0764,0.5019,2.5638,25.9594,21.1526,21.1526,19.2313,0.0181,7.7366,10.9739,18.5911,10.9739,341.523,9.9752,3.447,2.1366,51.5186,43.6536,30.6802,1.3053,2.1914,3.8836,1.7722,1.6789,2.9753,3.0
 627.0,65.2388,6.642,1.9994,1.9894,1.9842,7.875,231992.4531,2117.4131,248.2565,3.5512,3.7812,2.8047,2.4441,3.6308,3.714,0.0,170.3388,85.2004,169.4872,26.5915,169.0477,225.3334,0.0042,0.5479,1403.8389,25.3544,-999.25,-999.25,-999.25,169.4708,170.3552,-999.25,-999.25,0.5222,1859.7504,-70.2345,-0.1528,2.4883,3.0254,2.8987,2.7888,2.6073,2.5355,3.0257,0.2535,2.5076,0.3197,0.8636,2.5745,25.2656,20.4768,20.4768,18.5941,0.0146,8.632,11.8379,19.3812,11.8379,330.5302,9.9784,3.5933,2.2666,56.4632,46.5642,33.0062,1.3883,2.2892,4.2535,1.8581,1.6488,3.0637,1.0
 627.5,64.6975,6.645,1.9979,1.9839,1.991,7.875,231949.4375,2163.6101,247.4737,3.5504,3.7875,2.8063,2.4434,3.63,3.7174,0.0,170.6038,85.3932,169.4073,26.7278,170.0289,225.5282,0.0045,0.5358,1304.967,21.744,-999.25,-999.25,-999.25,169.3935,170.6176,-999.25,-999.25,0.7249,1870.3347,-68.9034,-0.1516,2.5955,3.1515,3.022,2.906,2.7242,2.6437,3.1518,0.2535,2.5037,0.2301,0.146,2.5885,25.7656,20.9636,20.9636,19.0532,0.0132,8.8682,12.0658,19.5896,12.0658,317.3077,9.9403,3.6327,2.3291,62.7781,48.813,35.0992,1.4627,2.3272,4.5881,1.9715,1.591,3.1367,1.0
 628.0,63.6857,6.6488,1.9931,1.9753,1.9838,7.875,231906.6563,2194.8936,246.525,3.5512,3.7906,2.8111,2.4421,3.6332,3.7181,0.0,170.0135,85.2997,168.495,26.6617,169.2371,225.5382,0.0075,0.6189,1123.8827,28.1892,-999.25,-999.25,-999.25,168.4538,170.0547,-999.25,-999.25,0.9563,1866.5918,-67.8556,-0.1468,2.6645,3.2167,3.0895,2.972,2.7951,2.7119,3.217,0.2535,2.5119,-0.118,-0.5358,2.6131,24.8286,20.0526,20.0526,18.1936,0.0143,8.3704,11.5854,19.1503,11.5855,310.8762,9.9608,4.0291,2.4528,65.7732,48.6276,35.3112,1.4615,2.2754,4.6634,2.0495,1.5569,3.1909,2.4
 628.5,63.6524,6.6486,1.9892,1.9713,1.9564,7.875,231863.9375,2193.0237,245.7137,3.5504,3.7899,2.8079,2.4448,3.6347,3.7181,0.0,168.9521,84.931,167.4369,26.401,166.18,225.2341,0.0099,0.6309,870.2581,27.4537,-999.25,-999.25,-999.25,167.2964,169.0926,-999.25,-999.25,1.0877,1877.8542,-67.7634,-0.1401,2.7684,3.3158,3.1921,3.0743,2.8997,2.8128,3.316,0.2535,2.5154,-0.1433,-0.1815,2.6594,24.5456,19.7784,19.7784,17.9345,0.0173,8.1582,11.3807,18.9631,11.3807,301.5868,9.9057,3.9681,2.393,60.652,46.7606,34.1321,1.4036,2.1718,4.5509,2.0954,1.5473,3.2423,4.8
 629.0,57.0407,6.6609,1.9781,1.9525,1.9364,7.875,231821.5156,2192.8635,245.0193,3.5707,3.7906,2.8224,2.4475,3.63,3.7215,0.0,166.6795,84.2584,164.5108,25.9253,163.1606,224.6664,0.0094,0.4946,583.6796,20.206,-999.25,-999.25,-999.25,164.2424,166.9479,-999.25,-999.25,1.6571,1915.0652,-67.8672,-0.1332,2.872,3.4114,3.2933,3.1778,3.0034,2.9102,3.4116,0.2535,2.5172,0.2904,-0.0874,2.7521,23.5654,18.8322,18.8322,17.039,0.0203,8.0484,11.2748,18.8662,11.2748,293.1341,9.8,4.0594,2.5686,55.4015,45.7376,32.9768,1.3525,2.1734,4.4141,2.0309,1.607,3.2638,1.0
 629.5,52.8813,6.6617,1.9755,1.9511,1.9344,7.875,231779.5938,2137.6492,244.7231,3.5692,3.7906,2.8224,2.4468,3.6332,3.7229,0.0,164.5915,83.3185,162.5326,25.2606,161.1574,224.0967,0.0103,0.3819,410.7147,18.2263,-999.25,-999.25,-999.25,162.0181,165.106,-999.25,-999.25,1.9,1919.5448,-67.4707,-0.1246,2.9912,3.5165,3.4053,3.2942,3.1179,3.0186,3.5165,0.2535,2.5284,0.4859,-0.2335,2.9205,22.9029,18.1958,18.1958,16.4354,0.0235,7.369,10.6192,18.2667,10.6192,284.375,9.7541,4.9622,2.8654,57.3197,46.0561,32.7565,1.3357,2.2426,4.4211,1.9714,1.679,3.3099,1.0
 630.0,54.6259,6.6652,1.978,1.9728,1.9449,7.875,231738.4531,2170.5393,243.9229,3.5684,3.7914,2.8224,2.4461,3.6443,3.7229,0.0,162.7585,82.2864,162.2852,24.5307,160.0136,223.5288,0.0156,0.2793,285.6107,24.7774,-999.25,-999.25,-999.25,161.2132,163.8305,-999.25,-999.25,1.6153,1880.9178,-66.9452,-0.1148,3.0177,3.5054,3.4057,3.3045,3.1327,3.0399,3.5054,0.2535,2.5388,0.2085,-0.2214,3.0838,22.6465,17.9501,17.9501,16.2022,0.0247,6.7397,10.012,17.7115,10.012,285.274,9.7334,4.9461,2.8561,61.016,48.2379,34.0422,1.3822,2.3684,4.6227,1.9518,1.7134,3.3444,1.0
 630.5,55.6334,6.6671,1.9876,1.9951,1.958,7.875,231698.0781,2196.2246,243.2469,3.57,3.7906,2.8248,2.4482,3.6474,3.7202,0.0,162.2661,81.6395,162.8403,24.0732,159.8164,223.1438,0.0132,0.2395,240.3985,23.1971,-999.25,-999.25,-999.25,161.4623,163.6442,-999.25,-999.25,1.3472,1980.6864,-66.69,-0.1055,2.9314,3.3661,3.2809,3.194,3.0345,2.9615,3.3661,0.2535,2.5379,-0.1071,0.0308,3.1277,22.9099,18.2025,18.2025,16.4418,0.0207,6.7945,10.0649,17.7598,10.0649,297.076,9.7103,4.3315,2.5892,65.8035,50.4393,35.6821,1.4411,2.4518,4.882,1.9912,1.7013,3.3876,0.0
 631.0,49.6129,6.6766,1.9972,2.0032,1.9613,7.875,231657.6563,2184.4658,242.3544,3.5723,3.8151,2.8265,2.4448,3.6474,3.7236,0.0,163.2422,81.7358,163.7174,24.1413,160.2748,223.2773,0.0095,0.2027,220.2293,22.4544,-999.25,-999.25,-999.25,162.623,164.3366,-999.25,-999.25,1.0531,2019.6136,-66.4978,-0.0931,2.9123,3.2927,3.2189,3.144,2.995,2.9429,3.2927,0.2535,2.5332,-0.2639,0.3847,3.098,23.9054,19.1598,19.1598,17.3493,0.0146,7.08,10.3403,18.0117,10.3403,303.7025,9.6936,4.6238,2.7706,72.2532,51.7935,37.2617,1.4941,2.4143,5.1494,2.1329,1.6159,3.4465,6.0
 631.5,44.854,6.6748,2.0061,2.0078,1.9538,7.875,231616.7969,2198.9211,241.4001,3.5723,3.8119,2.824,2.4441,3.649,3.7229,0.0,165.2718,82.383,165.4103,24.599,160.9212,223.8696,0.0077,0.1847,224.3228,24.5272,-999.25,-999.25,-999.25,164.6993,165.9828,-999.25,-999.25,0.7799,1967.8348,-66.5124,-0.0803,2.8932,3.2184,3.1544,3.0905,2.9526,2.9191,3.2184,0.2535,2.5335,-0.2373,0.583,3.1236,23.6458,18.9096,18.9096,17.1123,0.0102,7.0623,10.3233,17.9962,10.3233,310.7087,9.6774,4.1163,2.4322,73.1569,52.3876,38.363,1.5339,2.3368,5.3225,2.2777,1.5235,3.47,1.0
 632.0,47.7143,6.6853,2.0093,2.0134,1.9465,7.875,231575.2188,2209.3254,240.3496,3.5715,3.8317,2.8224,2.4489,3.653,3.7284,0.0,167.653,83.4395,167.9916,25.3462,162.3604,224.692,0.0064,0.2099,292.9763,26.6269,-999.25,-999.25,-999.25,167.2655,168.379,-999.25,-999.25,0.6623,2042.7842,-66.8086,-0.0704,2.991,3.2852,3.2264,3.1695,3.0356,3.0112,3.2852,0.2535,2.5337,-0.2117,0.5017,3.1742,23.021,18.3091,18.3091,16.5429,0.0073,7.0465,10.308,17.9822,10.308,304.3918,9.6802,4.8069,2.8957,65.0407,50.0963,37.1197,1.4854,2.1825,5.1439,2.3569,1.4693,3.4629,6.0
 632.5,54.4427,6.683,2.0081,2.011,1.9296,7.875,231553.8281,2239.3137,239.046,3.5731,3.8309,2.8232,2.4475,3.6514,3.7229,0.0,170.1051,84.7136,170.34,26.2472,163.3977,225.4061,0.0045,0.1943,279.2979,21.6554,-999.25,-999.25,-999.25,169.468,170.977,-999.25,-999.25,0.8802,2006.0354,-67.1649,-0.063,3.1046,3.3776,3.3219,3.2704,3.1392,3.1207,3.3776,0.2535,2.5306,-0.0325,-0.0405,3.1537,22.1003,17.4281,17.4281,15.7061,0.0066,7.2386,10.4933,18.1517,10.4933,296.0703,9.5675,4.6967,2.7844,58.5946,46.91,34.9463,1.4048,2.0366,4.8127,2.3631,1.4498,3.4259,1.0
 633.0,59.1017,6.6899,2.0075,2.0154,1.9212,7.875,231510.1719,2186.7266,237.8815,3.5707,3.8506,2.8232,2.4482,3.6514,3.7256,0.0,171.7296,85.5512,172.4011,26.8396,164.3149,225.9348,0.0032,0.1715,236.267,14.2799,-999.25,-999.25,-999.25,171.0745,173.0562,-999.25,-999.25,1.1453,1988.5985,-67.2109,-0.0582,3.2014,3.4614,3.4077,3.3603,3.2308,3.2136,3.4614,0.2535,2.5298,0.4686,-0.4143,3.1586,21.9523,17.2869,17.2869,15.5718,0.0081,7.2852,10.5384,18.1928,10.5384,288.9012,9.5259,4.6005,2.8203,59.5519,44.4784,33.1583,1.333,1.9484,4.5661,2.3435,1.4617,3.4255,3.0
 633.5,61.5665,6.6873,2.0111,2.0296,1.9208,7.875,231466.6563,2190.4773,236.6313,3.5715,3.8498,2.8224,2.4468,3.649,3.7222,0.0,171.9888,85.5291,173.561,26.824,164.2479,225.921,0.0025,0.1728,226.5268,9.2327,-999.25,-999.25,-999.25,171.6715,173.8783,-999.25,-999.25,1.2746,2021.6403,-66.9811,-0.0586,3.4545,3.737,3.6812,3.6341,3.4957,3.4629,3.737,0.2535,2.5396,0.6531,-0.2314,3.3394,21.348,16.7118,16.7118,15.0242,0.012,6.6895,9.9635,17.6672,9.9635,267.5945,9.5073,5.155,3.3579,60.1301,41.7744,31.3248,1.2554,1.8038,4.3321,2.4016,1.4369,3.4508,2.4
 634.0,61.5124,6.6943,2.0192,2.0431,1.928,7.875,231423.6875,2207.2036,234.5038,3.57,3.8703,2.8224,2.4448,3.6506,3.7249,0.0,171.2437,84.8199,173.265,26.3224,163.4982,225.3511,0.0025,0.19,233.3752,6.9832,-999.25,-999.25,-999.25,171.1014,173.4073,-999.25,-999.25,1.3396,1985.7317,-66.7579,-0.0638,3.9146,4.2635,4.2013,4.1507,3.991,3.9218,4.2635,0.2535,2.5616,0.1827,-0.197,3.6366,19.5996,15.0594,15.0594,13.4464,0.019,5.3596,8.6803,16.4938,8.6803,234.5479,9.5028,7.2149,4.0276,53.2718,38.8478,29.441,1.1704,1.6348,4.1167,2.5182,1.3968,3.5174,1.6
 634.5,55.8832,6.6807,2.027,2.0554,1.9428,7.875,231381.5156,2229.4819,233.2239,3.5715,3.8301,2.8152,2.4448,3.6522,3.7284,0.0,169.8779,83.8187,172.2518,25.6144,162.8033,224.5291,0.0033,0.2288,256.9596,6.8012,-999.25,-999.25,-999.25,169.813,172.3167,-999.25,-999.25,1.4659,1988.6682,-66.3888,-0.0662,4.0927,4.4712,4.4073,4.3572,4.1926,4.1021,4.4712,0.2535,2.5819,-0.1086,-0.353,3.7788,18.7246,14.239,14.239,12.6603,0.026,4.1255,7.4895,15.4048,7.4895,223.6551,9.5112,7.281,4.3535,44.5078,37.0512,28.3977,1.1222,1.5022,4.0024,2.6643,1.3386,3.5665,3.2
 635.0,54.3594,6.6804,2.0259,2.0598,1.9498,7.875,231319.5469,2228.5186,231.5721,3.5715,3.8309,2.8079,2.4461,3.6578,3.727,0.0,168.4684,83.1645,171.293,25.1517,162.1293,223.8341,0.004,0.2761,294.6543,7.8039,-999.25,-999.25,-999.25,168.4684,171.293,-999.25,-999.25,1.6646,1895.7635,-65.4274,-0.0602,3.7914,4.1102,4.0528,4.0091,3.8656,3.7998,4.1102,0.2535,2.5865,0.1298,-0.0935,3.6307,19.2788,14.7581,14.7581,13.1579,0.0299,3.8512,7.2248,15.1628,7.2248,243.2986,9.5222,7.8031,4.731,43.9056,38.5965,29.7238,1.1717,1.5448,4.2031,2.7209,1.3184,3.5871,2.0
 635.5,58.727,6.688,2.025,2.0578,1.9556,7.875,231278.4219,2208.6487,229.6749,3.57,3.8545,2.8071,2.4475,3.6601,3.7249,0.0,167.6791,82.8057,170.39,24.898,161.9147,223.2993,0.0055,0.315,320.1265,10.571,-999.25,-999.25,-999.25,167.6791,170.39,-999.25,-999.25,1.6041,1868.4227,-64.0927,-0.0504,3.4125,3.6523,3.6025,3.5652,3.4463,3.4173,3.6523,0.2535,2.5787,0.1672,-0.1817,3.4063,20.6843,16.0824,16.0824,14.4241,0.0304,4.323,7.68,15.5791,7.68,273.7991,9.5707,5.4729,3.3479,51.8675,43.2448,33.2227,1.3194,1.7467,4.6515,2.663,1.3238,3.5253,1.0
 636.0,60.5048,6.6994,2.0201,2.0508,1.9476,7.875,231236.75,2225.8914,228.074,3.5707,3.8861,2.8071,2.4468,3.6633,3.7243,0.0,167.2151,82.7787,169.7612,24.8788,161.2045,223.3995,0.0072,0.3419,346.4096,14.1004,-999.25,-999.25,-999.25,167.1861,169.7903,-999.25,-999.25,1.5443,1908.4319,-62.9715,-0.0451,3.2425,3.4461,3.3995,3.3645,3.2586,3.2453,3.4461,0.2535,2.5736,-0.0659,-0.2603,3.3184,21.5706,16.9234,16.9234,15.2258,0.0284,4.6288,7.9752,15.849,7.9752,290.1858,9.5385,4.5082,3.3764,59.4368,46.9039,35.6693,1.4235,1.9522,4.9612,2.5414,1.3714,3.4852,1.0
 636.5,61.0294,6.7084,2.0208,2.0429,1.9618,7.875,231195.6406,2128.8503,226.1063,3.57,3.9152,2.8071,2.4482,3.657,3.7277,0.0,166.5276,82.407,168.357,24.616,161.6495,223.2367,0.008,0.3523,354.4172,15.0154,-999.25,-999.25,-999.25,166.4637,168.4208,-999.25,-999.25,1.1676,1964.2415,-62.5325,-0.0476,3.2911,3.5092,3.4614,3.4246,3.3172,3.2945,3.5092,0.2535,2.5704,-0.1265,0.1294,3.4234,21.947,17.2818,17.2818,15.567,0.0247,4.8227,8.1622,16.02,8.1623,284.9653,9.534,5.0091,3.4868,63.689,48.3723,36.3626,1.4592,2.0854,5.0198,2.4072,1.4291,3.4402,0.0
 637.0,62.5866,6.7142,2.0072,2.0282,1.9452,7.875,231154.2813,2172.7192,224.638,3.5707,3.9286,2.8071,2.4495,3.6617,3.7249,0.0,164.8245,82.1195,166.5602,24.4126,159.7092,223.0955,0.0061,0.3801,379.3996,11.8781,-999.25,-999.25,-999.25,164.6893,166.6953,-999.25,-999.25,1.2083,1993.2175,-62.7212,-0.0549,3.4698,3.7356,3.6836,3.6422,3.5248,3.4758,3.7356,0.2535,2.5688,-0.0613,-0.1834,3.6151,21.1455,16.5195,16.5195,14.841,0.0212,4.9195,8.2557,16.1054,8.2557,267.6911,9.5032,5.8609,3.5742,62.3811,48.5904,36.1801,1.4574,2.1566,4.9683,2.3037,1.4798,3.409,0.0
 637.5,60.6255,6.7218,1.9993,2.0166,1.9506,7.875,231113.2031,2163.45,222.9383,3.57,3.9499,2.8063,2.4495,3.6633,3.7263,0.0,162.7936,81.4283,164.2148,23.9238,158.8012,222.6998,0.0056,0.3599,357.8034,10.9842,-999.25,-999.25,-999.25,162.5125,164.4959,-999.25,-999.25,1.209,1968.4568,-63.2775,-0.062,3.5731,3.8821,3.8262,3.7803,3.654,3.5818,3.8821,0.2535,2.5821,0.1004,-0.4278,3.721,19.8848,15.3277,15.3277,13.7031,0.0206,4.1151,7.4794,15.3956,7.4795,257.5898,9.5223,5.7669,3.5653,60.164,48.3979,35.4265,1.4278,2.2389,4.8614,2.1714,1.5681,3.405,1.0
 638.0,59.8719,6.7269,2.002,2.0073,1.9601,7.875,231072.8125,2162.0955,221.237,3.5723,3.9696,2.8063,2.4482,3.6546,3.7297,0.0,160.8591,80.3558,161.2912,23.1654,157.475,222.0344,0.0048,0.3487,346.2766,8.5466,-999.25,-999.25,-999.25,160.285,161.8653,-999.25,-999.25,0.9765,1986.7214,-63.8429,-0.0665,3.6091,3.9444,3.885,3.8351,3.7034,3.6203,3.9444,0.2535,2.5934,0.3174,0.0782,3.7624,19.5715,15.033,15.033,13.4211,0.0184,3.4283,6.8167,14.7896,6.8168,253.5228,9.5334,5.7011,3.4628,62.5872,48.5736,35.0465,1.4168,2.3255,4.7886,2.0591,1.6414,3.3799,0.0
 638.5,59.8844,6.728,2.0069,2.0161,1.973,7.875,231033.8125,2154.7083,219.1122,3.5707,3.9688,2.8063,2.4489,3.657,3.7325,0.0,158.806,79.1382,159.54,22.3043,156.1131,221.2726,0.0052,0.362,331.146,8.5848,-999.25,-999.25,-999.25,158.5356,159.8104,-999.25,-999.25,0.8006,1986.3076,-64.2318,-0.069,3.6369,3.9876,3.9241,3.8705,3.7355,3.6499,3.9876,0.2535,2.5923,0.2581,0.3729,3.791,19.5949,15.055,15.055,13.4422,0.0137,3.4974,6.8834,14.8506,6.8834,250.7788,9.5389,5.8096,3.4103,64.0049,48.619,34.6821,1.3919,2.3867,4.7871,2.0058,1.7147,3.4393,5.6
 639.0,58.0691,6.728,1.9953,2.0142,1.9579,7.875,231014.1875,2161.7976,216.7288,3.57,3.9704,2.8063,2.4489,3.6593,3.729,0.0,157.1487,78.7601,158.6308,22.0368,154.1926,221.0484,0.0061,0.3284,309.8032,10.3302,-999.25,-999.25,-999.25,157.0066,158.7729,-999.25,-999.25,1.123,2019.1874,-64.4178,-0.0702,3.6673,4.027,3.9587,3.9014,3.7644,3.682,4.027,0.2535,2.595,-0.0335,0.4643,3.8061,19.726,15.1783,15.1783,13.5602,0.0135,3.3313,6.7231,14.704,6.7231,248.3248,9.5559,6.1586,3.5058,63.3955,48.8127,34.7103,1.3763,2.4033,4.8703,2.0265,1.7462,3.5387,3.2
 639.5,60.1217,6.7298,1.9835,2.0108,1.9451,7.875,230975.0,2184.6035,214.9046,3.5723,3.9704,2.8071,2.4475,3.6617,3.7304,0.0,155.6682,78.4818,157.8093,21.8401,152.6535,220.9077,0.0061,0.2585,262.1275,10.9,-999.25,-999.25,-999.25,155.5973,157.8802,-999.25,-999.25,1.4647,2007.9924,-64.601,-0.0703,3.6459,4.0041,3.9314,3.8716,3.735,3.659,4.0041,0.2535,2.5988,-0.0875,0.2457,3.8519,19.6712,15.1268,15.1268,13.5109,0.0154,3.1011,6.5011,14.501,6.5011,249.741,9.5738,5.6565,3.2474,64.5866,49.5279,35.2485,1.3854,2.424,5.0039,2.0643,1.7497,3.6119,2.4
 640.0,64.8049,6.732,1.9683,2.0071,1.9499,7.875,230935.7188,2159.3889,213.6637,3.5715,3.9736,2.8063,2.4489,3.6641,3.7318,0.0,153.5292,77.9944,156.5397,21.4954,152.0844,220.7509,0.0053,0.2044,220.8017,10.2582,-999.25,-999.25,-999.25,153.4955,156.5734,-999.25,-999.25,2.0027,2007.141,-64.7434,-0.0723,3.617,3.9827,3.9049,3.8426,3.7049,3.6289,3.9827,0.2535,2.6013,0.0636,-0.138,3.9407,19.8836,15.3267,15.3267,13.7021,0.0157,2.9509,6.3561,14.3684,6.3561,251.0843,9.5528,5.4938,3.1542,66.2657,49.9326,35.2815,1.3782,2.4672,5.0489,2.0465,1.7901,3.6634,0.8
 640.5,65.4428,6.7369,1.9548,2.005,1.9532,7.875,230896.5625,2153.7783,211.9535,3.5707,3.9885,2.8079,2.4475,3.6657,3.7304,0.0,151.0617,77.2666,154.9168,20.9807,150.9389,220.5361,0.005,0.181,211.0377,11.0778,-999.25,-999.25,-999.25,151.0603,154.9182,-999.25,-999.25,2.5403,2009.7783,-65.0423,-0.0784,3.6758,4.0795,3.9936,3.9272,3.7814,3.6908,4.0795,0.2535,2.604,-0.0159,0.0843,3.9702,20.485,15.894,15.894,14.2442,0.0158,2.7855,6.1965,14.2225,6.1965,245.1293,9.5565,5.7033,3.3338,64.9773,50.1987,34.867,1.3628,2.5528,4.9857,1.953,1.8732,3.6583,3.0
 641.0,60.9511,6.7391,1.9473,2.0044,1.9386,7.875,230857.625,2063.0122,210.6196,3.5715,3.9877,2.8103,2.4482,3.6657,3.7338,0.0,148.071,76.0308,152.3972,20.1067,147.4066,220.1606,0.0058,0.1946,237.7434,13.4403,-999.25,-999.25,-999.25,148.071,152.3972,-999.25,-999.25,2.894,1988.748,-65.5042,-0.0884,3.8209,4.2947,4.1977,4.1253,3.9638,3.8438,4.2947,0.2535,2.6004,-0.2446,0.1765,3.911,19.5611,15.0232,15.0232,13.4118,0.0149,3.008,6.4112,14.4188,6.4112,232.8461,9.5411,6.0866,3.4544,63.9594,50.2698,33.6229,1.3272,2.7185,4.7462,1.7459,2.0483,3.5762,2.0
 641.5,54.7549,6.7377,1.9408,2.0039,1.9335,7.875,230819.5156,2006.7885,209.1255,3.5731,3.9885,2.8095,2.4475,3.6641,3.7304,0.0,144.2821,74.331,148.9617,18.9045,143.7032,219.5688,0.0058,0.2134,274.9646,14.1962,72.6949,38.6728,55.6839,144.2477,149.0096,55.6839,235.6839,3.2605,2001.1982,-66.2439,-0.1005,4.0364,4.606,4.4953,4.4159,4.2326,4.0714,4.606,0.2535,2.5971,-0.2795,-0.418,3.8741,19.0319,14.5266,14.5266,12.9361,0.0129,3.2069,6.6031,14.5943,6.6032,217.1104,9.5403,7.1484,4.0121,63.8844,50.4885,32.0106,1.2711,2.9769,4.4829,1.5059,2.342,3.5269,2.0
 642.0,47.3355,6.7378,1.9359,2.0011,1.9408,7.875,230764.8281,2065.9038,207.798,3.5723,3.9877,2.8087,2.4475,3.6633,3.7338,0.0,140.328,72.4824,145.0536,17.5971,140.6501,218.7463,0.0049,0.207,287.4402,12.0314,72.6949,38.6728,55.6839,140.2626,145.1448,55.6839,235.6839,3.4226,1983.3699,-67.1786,-0.1103,4.2462,4.9047,4.7812,4.696,4.492,4.2927,4.9047,0.2535,2.6016,0.0353,-0.6759,3.8821,17.7914,13.3689,13.3689,11.8247,0.0119,2.9335,6.3393,14.3531,6.3393,203.8868,9.518,7.2315,4.3557,63.1368,50.0178,29.7509,1.19,3.2045,4.1255,1.2874,2.693,3.467,2.0
 642.5,42.9629,6.738,1.9264,1.9824,1.938,7.875,230729.5,2113.1111,205.7551,3.5731,3.9877,2.8071,2.4482,3.6641,3.7338,0.0,137.7433,71.4962,141.7566,16.8997,138.5457,218.4851,0.0056,0.2507,352.3476,12.488,72.6949,38.6728,55.6839,137.5943,141.9641,55.6839,235.6839,3.1229,1997.0055,-68.1067,-0.1121,4.2923,4.9691,4.8404,4.7557,4.5454,4.3392,4.9691,0.2535,2.6059,0.4543,-0.3159,3.9268,17.6744,13.2602,13.2602,11.7202,0.0119,2.6716,6.0867,14.122,6.0867,201.2424,9.5462,8.4035,4.8996,63.0841,50.1316,27.785,1.1108,3.4786,3.8554,1.1083,3.1316,3.4708,3.0
 643.0,52.5482,6.7399,1.9245,1.9666,1.9328,7.875,230694.3438,2178.2144,204.4845,3.5747,3.9885,2.8103,2.4495,3.6641,3.7325,0.0,136.6546,71.0097,139.6561,16.5556,137.2322,218.3489,0.0077,0.2457,361.3322,15.8389,72.6949,38.6728,55.6839,136.3277,140.1115,55.6839,235.6839,2.7373,2009.5129,-68.9142,-0.1054,4.1106,4.7195,4.5966,4.5197,4.322,4.1473,4.7195,0.2535,2.6075,0.4253,-0.161,4.0198,18.2298,13.7771,13.7771,12.217,0.0125,2.5733,5.9917,14.0352,5.9918,211.8872,9.5291,7.4383,4.3847,65.0576,50.1242,26.3784,1.0544,3.6437,3.6612,1.0048,3.4558,3.4724,2.4
 643.5,74.8541,6.7368,1.9116,1.9546,1.9145,7.875,230658.875,2145.6101,202.4776,3.5731,3.9877,2.8055,2.4475,3.6649,3.7318,0.0,135.8216,71.0533,138.8813,16.5865,136.0209,218.2876,0.0111,0.2733,381.3706,20.5433,72.6949,38.6728,55.6839,135.1174,139.8621,55.6839,235.6839,3.4643,1970.9209,-69.5614,-0.0963,3.9094,4.4377,4.3245,4.2576,4.0756,3.9353,4.4377,0.2535,2.6086,-0.1001,0.0613,4.043,18.622,14.1431,14.1431,12.5684,0.0127,2.5096,5.9303,13.9791,5.9304,225.3414,9.5415,6.5245,3.762,67.4362,50.8442,25.4185,1.0099,3.8552,3.557,0.9226,3.8175,3.5222,0.0
 644.0,93.0488,6.7377,1.9155,1.9563,1.8969,7.875,230623.2656,2159.3765,200.9344,3.5707,3.9893,2.8071,2.4495,3.6641,3.7325,0.0,136.572,71.2983,139.4775,16.7597,135.2313,218.3834,0.0118,0.2735,321.5305,22.974,-999.25,-999.25,-999.25,136.2393,139.9408,-999.25,-999.25,2.6913,1955.1429,-70.4265,-0.0915,3.8714,4.3683,4.2621,4.2032,4.027,3.8943,4.3683,0.2535,2.6039,-0.4784,0.5401,3.9442,18.4935,14.0231,14.0231,12.4532,0.0112,2.7969,6.2075,14.2325,6.2075,228.9225,9.5738,6.2676,3.6161,68.1553,50.0179,23.8278,0.9437,3.9314,3.3485,0.8517,4.1659,3.5482,4.0
 644.5,95.9233,6.7357,1.9161,1.9495,1.8859,7.875,230587.4688,2168.8408,199.5651,3.5715,3.9885,2.8063,2.4489,3.6593,3.7325,0.0,137.3067,71.6605,139.6982,17.0159,135.1364,218.5245,0.0133,0.2442,292.0097,29.5468,-999.25,-999.25,-999.25,137.1183,139.9472,-999.25,-999.25,2.0484,1969.009,-72.0279,-0.092,3.9926,4.508,4.4071,4.3549,4.1769,4.022,4.508,0.2535,2.5957,-0.3046,0.6097,3.9456,17.6277,13.2168,13.2168,11.6785,0.0093,3.2885,6.6818,14.6663,6.6819,221.8303,9.5515,7.2106,4.1627,63.7256,46.8574,21.301,0.8414,3.806,3.0038,0.7892,4.5232,3.5698,2.4
 645.0,90.4824,6.7367,1.9128,1.9485,1.8772,7.875,230551.4063,2184.2485,197.8648,3.5715,3.9885,2.8047,2.4495,3.6633,3.7325,0.0,137.7063,71.9942,140.2781,17.2519,135.1379,218.5268,0.012,0.1903,270.4064,32.4349,-999.25,-999.25,-999.25,137.5666,140.4455,-999.25,-999.25,2.0748,1990.9828,-74.5373,-0.0908,4.082,4.6018,4.5112,4.4681,4.2965,4.1155,4.6018,0.2535,2.5848,0.1016,0.1339,4.1065,16.555,12.2238,12.2238,10.7219,0.0069,3.9534,7.3234,15.253,7.3234,217.3052,9.576,9.2906,5.1887,53.6706,41.8861,18.1871,0.7189,3.5013,2.5626,0.7319,4.8705,3.5647,7.2
 645.5,83.665,6.7419,1.9176,1.9454,1.8709,7.875,230514.9688,2186.6223,196.559,3.5715,3.9909,2.8135,2.4489,3.6665,3.7345,0.0,138.3944,72.1743,140.4043,17.3793,135.0245,218.6086,0.0108,0.1678,294.3253,34.0434,-999.25,-999.25,-999.25,138.2269,140.5839,-999.25,-999.25,1.6928,1981.2623,-77.5654,-0.0799,3.8713,4.3045,4.2342,4.205,4.0651,3.8932,4.3045,0.2535,2.5662,0.2665,-0.6567,4.2303,15.8553,11.5797,11.5797,10.0999,0.0042,5.0818,8.4122,16.2486,8.4122,232.3163,9.5407,8.6948,4.6818,46.1468,38.3425,16.2723,0.6373,3.2316,2.3208,0.7182,5.0709,3.6417,4.8
 646.0,72.2735,6.7489,1.9247,1.9416,1.8715,7.875,230496.8594,2176.2864,194.924,3.5739,4.013,2.8079,2.4509,3.6665,3.7345,0.0,138.1194,71.7676,139.3418,17.0916,134.3075,218.5028,0.01,0.1327,256.2125,34.0634,-999.25,-999.25,-999.25,137.7408,139.7204,-999.25,-999.25,1.4257,1958.2178,-80.2491,-0.062,3.5823,3.8923,3.8437,3.8279,3.7315,3.5935,3.8923,0.2535,2.5508,0.0853,-0.6988,4.3041,15.6176,11.3615,11.3615,9.889,0.0064,6.0112,9.309,17.0687,9.309,256.9204,9.566,7.4505,4.0404,48.0213,41.9791,17.3646,0.675,3.5767,2.5005,0.6991,5.2985,3.7042,2.0
 646.5,54.5109,6.7482,1.9342,1.9447,1.8767,7.875,230461.0,2185.6936,193.6046,3.5715,4.013,2.8103,2.4495,3.6657,3.7345,0.0,137.2664,70.976,138.0136,16.5318,133.1872,218.3187,0.0089,0.1036,226.3242,33.5509,-999.25,-999.25,-999.25,136.7994,138.4806,-999.25,-999.25,1.2219,1994.0813,-81.9303,-0.0397,3.4587,3.6497,3.6198,3.6154,3.5743,3.4628,3.6497,0.2535,2.5507,-0.092,0.2735,4.3304,16.1349,11.8368,11.8368,10.3483,0.0111,6.0201,9.3176,17.0765,9.3176,273.994,9.5135,8.3837,4.6877,61.3961,52.179,21.1845,0.8093,4.4839,3.1179,0.6954,5.5402,3.8524,4.0
 647.0,39.1033,6.7489,1.9378,1.9509,1.8818,7.875,230425.7656,2143.4658,192.2789,3.5707,4.0185,2.8071,2.4495,3.6665,3.7345,0.0,135.3335,69.8432,136.2469,15.7307,131.4148,218.0174,0.0084,0.0936,236.4807,37.1876,-999.25,-999.25,-999.25,134.9005,136.68,-999.25,-999.25,1.3171,1983.7849,-82.6833,-0.0141,3.3902,3.4564,3.4436,3.4496,3.4283,3.3861,3.4564,0.2535,2.5538,0.0742,0.5046,4.2872,16.0221,11.733,11.733,10.2481,0.0081,5.8305,9.1346,16.9092,9.1347,289.3172,9.4747,9.3062,4.6839,83.6678,64.4246,25.4551,0.9611,5.62,3.8005,0.6762,5.8474,3.9543,0.0
 647.5,31.0601,6.7492,1.9412,1.9503,1.8856,7.875,230390.9375,2167.1089,190.9706,3.5723,4.0153,2.8095,2.4482,3.6665,3.7359,0.0,133.1165,68.5732,133.7386,14.8325,129.2964,217.6779,0.0088,0.0862,239.465,44.5436,-999.25,-999.25,-999.25,132.4417,134.4134,-999.25,-999.25,1.4855,2000.8069,-83.4802,0.0212,3.1149,3.0243,3.0263,3.0398,3.0755,3.0906,3.0243,0.2535,2.5382,0.4046,-0.1646,4.3333,16.3868,12.0687,12.0687,10.5723,0.0018,6.7787,10.0496,17.7459,10.0496,330.6541,9.5077,9.544,4.9869,99.3954,72.372,27.5218,1.0288,6.455,4.1579,0.6441,6.274,4.0413,4.0
 648.0,24.6616,6.751,1.9392,1.9513,1.8876,7.875,230356.9219,2167.8438,190.3942,3.5731,4.0185,2.8095,2.4475,3.6673,3.7372,0.0,130.0949,67.0697,130.8807,13.7693,126.6073,217.1477,0.0092,0.0743,231.3763,54.5157,-999.25,-999.25,-999.25,129.4386,131.537,-999.25,-999.25,1.6148,1955.4545,-84.9536,0.0563,2.7929,2.5792,2.5891,2.6057,2.6753,2.7522,2.5792,0.2535,2.5212,0.3548,-0.4954,4.4948,16.9429,12.5822,12.5822,11.0674,0.0047,7.8057,11.0405,18.652,11.0405,387.7097,9.5428,9.8358,5.512,98.265,73.8403,27.0381,1.0024,6.7305,4.1246,0.6128,6.7146,4.1148,0.0
 648.5,20.8994,6.8209,1.9231,1.9468,1.8812,7.875,230323.8281,2165.3657,189.0719,3.6248,4.0547,2.8281,2.4794,3.6982,3.7775,0.0,126.5453,65.7835,128.092,12.8596,123.7778,216.547,0.0098,0.0685,253.0332,69.9352,-999.25,-999.25,-999.25,126.1891,128.4482,-999.25,-999.25,1.7772,1987.033,-86.3815,0.0804,2.6538,2.3659,2.3805,2.4004,2.4913,2.6289,2.3659,0.2535,2.5276,-0.098,-0.2409,4.6153,17.0776,12.7067,12.7067,11.1874,0.0119,7.4183,10.6668,18.3103,10.6668,422.6785,9.574,8.6566,4.2479,90.8696,70.6442,24.9608,0.9166,6.5493,3.8492,0.5877,7.1452,4.1994,1.6
 649.0,21.3257,6.8102,1.9069,1.9309,1.8678,7.875,230275.0625,2171.8354,188.5463,3.5997,4.0539,2.8353,2.4794,3.6951,3.7673,0.0,123.5575,64.7835,125.1151,12.1524,121.0264,216.0589,0.0105,0.0647,299.2827,93.568,-999.25,-999.25,-999.25,123.2566,125.4161,-999.25,-999.25,1.7308,1953.5188,-87.3827,0.1061,2.7173,2.3311,2.3504,2.3754,2.4876,2.6952,2.3311,0.2535,2.5351,-0.2977,-0.0989,4.565,17.63,13.2189,13.2189,11.6805,0.0158,6.9645,10.2289,17.9099,10.2289,428.9731,9.6242,9.5524,5.5049,88.6927,64.5468,21.8018,0.8025,6.1238,3.3533,0.5476,7.6313,4.1788,0.8
 649.5,22.2417,6.8068,1.9022,1.9142,1.8517,7.875,230243.3281,2152.127,187.7416,3.5966,4.0492,2.8345,2.4794,3.6927,3.768,0.0,121.8433,64.0465,122.6154,11.6312,118.6135,215.7181,0.0115,0.0707,386.9595,120.2287,-999.25,-999.25,-999.25,121.3291,123.1296,-999.25,-999.25,1.4662,1915.1,-88.4218,0.1311,2.8469,2.351,2.3743,2.4056,2.5383,2.8087,2.351,0.2535,2.5164,-0.2478,-0.1768,4.4255,19.3675,14.8413,14.8413,13.2377,0.0193,8.0985,11.3231,18.9104,11.3231,425.3581,9.7221,11.5671,7.4954,82.2742,55.7219,18.0186,0.6589,5.3948,2.792,0.5175,8.1881,4.2377,1.6
 650.0,21.9703,6.8163,1.8977,1.9159,1.8401,7.875,230211.9063,2167.3958,187.2209,3.6005,4.0586,2.8345,2.4794,3.6982,3.7775,0.0,120.9515,63.7341,122.1044,11.4102,117.28,215.5605,0.0119,0.074,453.5149,144.782,-999.25,-999.25,-999.25,120.6679,122.388,-999.25,-999.25,1.4139,1844.4098,-89.6858,0.1527,3.0475,2.4334,2.4609,2.501,2.6594,2.9788,2.4334,0.2535,2.4776,-0.383,-0.0842,4.3894,20.4214,15.8339,15.8339,14.1869,0.0203,10.4461,13.5884,20.9819,13.5884,410.956,9.7838,8.9409,6.6462,63.234,44.4207,13.9426,0.5101,4.3536,2.1591,0.4959,8.5349,4.2328,1.6
 650.5,24.3968,6.8209,1.8939,1.9129,1.8332,7.875,230180.375,2190.4089,186.5765,3.6044,4.0689,2.8378,2.476,3.6982,3.7775,0.0,121.472,64.1418,122.6616,11.6986,117.5768,215.7817,0.0131,0.064,434.8601,178.4108,-999.25,-999.25,-999.25,121.1876,122.946,-999.25,-999.25,1.4446,1875.1595,-90.7283,0.1824,3.5546,2.7085,2.7443,2.8032,3.0144,3.4044,2.7081,0.2535,2.4522,-0.3627,0.1198,4.3776,20.5304,15.9369,15.9369,14.2852,0.0162,11.9899,15.0779,22.344,15.0779,369.2147,9.8384,7.2161,5.8674,42.7654,32.5793,9.9483,0.3683,3.2255,1.52,0.4713,8.7581,4.1273,0.8
 651.0,31.9936,6.8162,1.8924,1.8997,1.8276,7.875,230148.1094,2161.3728,185.7737,3.5966,4.0618,2.8458,2.4794,3.6943,3.7707,0.0,123.7609,65.4097,124.2005,12.5952,119.5303,216.2718,0.0152,0.0612,454.3239,221.2549,-999.25,-999.25,-999.25,123.3028,124.6586,-999.25,-999.25,1.0983,1977.2551,-91.4413,0.2264,4.5551,3.2332,3.2861,3.3859,3.702,4.2153,3.2311,0.2535,2.4575,-0.0634,0.5426,4.3183,18.6837,14.2008,14.2008,12.6237,0.0131,11.6676,14.7669,22.0596,14.767,309.2926,9.8487,9.044,7.3036,29.345,23.4787,6.9764,0.258,2.3495,1.0675,0.4543,9.1082,4.1382,0.0
 651.5,46.4378,6.8208,1.888,1.8814,1.8219,7.875,230114.7031,2172.4326,185.4791,3.5981,4.0689,2.8402,2.4794,3.6982,3.7775,0.0,127.007,67.2834,126.519,13.9203,122.591,216.893,0.0175,0.0582,462.4824,258.0086,-999.25,-999.25,-999.25,126.1192,127.4068,-999.25,-999.25,1.0199,1990.0842,-91.7913,0.2676,5.6546,3.7509,3.8255,3.9867,4.4314,5.0571,3.7446,0.2535,2.4746,0.1991,0.2024,4.3214,16.7775,12.4292,12.4292,10.92,0.0148,10.6329,13.7685,21.1466,13.7685,266.6028,9.8493,10.6669,9.2499,24.4674,17.9082,5.1416,0.1907,1.8148,0.7839,0.4319,9.5163,4.1104,3.0
 652.0,66.0173,6.8213,1.8805,1.8684,1.8261,7.875,230079.8125,2162.1079,184.6301,3.6028,4.0689,2.8458,2.4794,3.6895,3.7775,0.0,130.4512,69.3823,129.5881,15.4048,126.7271,217.6144,0.0198,0.0546,475.4581,315.3505,-999.25,-999.25,-999.25,129.3736,130.6657,-999.25,-999.25,0.9974,2004.308,-91.894,0.2917,6.2766,4.0007,4.0932,4.3143,4.8397,5.4956,3.989,0.2535,2.4903,0.4609,-0.437,4.4521,16.0269,11.7374,11.7374,10.2523,0.0172,9.6777,12.8469,20.3038,12.8469,249.954,9.8536,9.9902,7.65,23.5779,15.6259,4.3474,0.161,1.6007,0.664,0.4148,9.943,4.1247,1.0
 652.5,80.4232,6.8362,1.8798,1.8657,1.8403,7.875,230044.1094,2189.124,184.1238,3.6428,4.0689,2.8491,2.4794,3.6911,3.7775,0.0,133.5691,71.0609,132.5633,16.5919,130.8086,218.2134,0.0211,0.055,519.326,355.8073,-999.25,-999.25,-999.25,132.4313,133.701,-999.25,-999.25,0.959,1996.0157,-91.8492,0.3298,7.1653,4.2808,4.4012,4.7086,5.3411,6.0661,4.2627,0.2535,2.5155,0.4404,-0.2538,4.641,14.8845,10.6907,10.6907,9.2396,0.0177,8.1499,11.3727,18.9558,11.3727,233.6013,9.8557,9.8297,7.8063,22.4315,15.6616,4.2741,0.1579,1.6116,0.6546,0.4062,10.2062,4.1456,2.0
 653.0,89.1459,6.8237,1.8821,1.8727,1.8518,7.875,230025.9219,2164.1726,183.2816,3.5958,4.0752,2.845,2.4794,3.6982,3.7775,0.0,135.5998,72.0461,134.9233,17.2886,133.4401,218.6816,0.0212,0.0543,563.4901,389.9633,-999.25,-999.25,-999.25,134.7581,135.765,-999.25,-999.25,0.7495,1971.2313,-91.5638,0.4187,9.5698,4.8828,5.0677,5.5594,6.4783,7.4455,4.8545,0.2535,2.5474,-0.0106,0.2535,4.6716,13.7672,9.6743,9.6743,8.2531,0.0124,6.2201,9.5106,17.253,9.5106,204.799,9.8424,14.8393,13.7485,20.7434,16.5068,4.4082,0.1641,1.703,0.6694,0.3931,10.3795,4.0798,0.0
 653.5,98.3632,6.83,1.8863,1.8841,1.8632,7.875,229989.3125,2185.4067,182.3243,3.6013,4.0901,2.8466,2.4794,3.6951,3.7775,0.0,136.9228,72.5891,136.7743,17.6726,135.2596,219.0885,0.0203,0.0505,583.5143,420.8206,-999.25,-999.25,-999.25,136.3961,137.3009,-999.25,-999.25,0.6648,1973.7303,-91.128,0.509,12.6975,5.477,5.7571,6.5173,7.8991,9.2543,5.4391,0.2535,2.5763,-0.1984,0.5159,4.5627,12.556,8.5809,8.5809,7.1883,0.004,4.4646,7.8167,15.7041,7.8167,182.5831,9.8371,19.8138,18.1606,21.3992,18.4289,4.8526,0.1808,1.9056,0.7359,0.3862,10.5398,4.0704,0.0
 654.0,107.3157,6.8408,1.8907,1.8925,1.8727,7.875,229952.875,2154.8459,181.3969,3.6005,4.1193,2.8474,2.4794,3.6982,3.7775,0.0,137.6539,72.8061,137.7864,17.8261,136.3445,219.4462,0.0189,0.0463,589.7634,433.8892,-999.25,-999.25,-999.25,137.3326,138.1077,-999.25,-999.25,0.5651,1979.7766,-90.7305,0.5151,12.7366,5.4306,5.7625,6.6517,8.2854,9.8738,5.3926,0.2535,2.603,0.0186,0.0623,4.5458,12.5487,8.5743,8.5743,7.1819,0.0103,2.8502,6.2589,14.2796,6.2589,184.1427,9.8427,19.6589,15.5558,26.035,22.2347,5.7565,0.2165,2.3152,0.8637,0.373,10.6959,3.9899,2.4
 654.5,108.3574,6.8524,1.8941,1.8967,1.875,7.875,229916.4531,2137.6953,180.6534,3.6216,4.135,2.8466,2.4767,3.699,3.7782,0.0,138.1334,72.9327,138.3306,17.9156,136.7432,219.4394,0.0184,0.0444,619.8597,456.2346,-999.25,-999.25,-999.25,137.8948,138.5692,-999.25,-999.25,0.4891,2004.4575,-90.468,0.5102,10.8362,4.659,4.9482,5.6813,7.0411,8.4286,4.631,0.2535,2.5975,-0.0209,-0.3746,4.55,14.2302,10.0947,10.0947,8.6615,0.0244,3.1843,6.5813,14.5744,6.5814,214.6361,9.841,15.2262,12.1565,35.6332,30.2188,7.6776,0.2894,3.1791,1.1484,0.3612,10.9838,3.9675,1.0
 655.0,96.4313,6.8726,1.8886,1.8963,1.8719,7.875,229880.2031,2154.6511,179.5998,3.6216,4.1901,2.8474,2.4794,3.6982,3.781,0.0,138.2251,73.194,138.7952,18.1005,137.0064,219.4634,0.0189,0.042,662.0965,510.3295,-999.25,-999.25,-999.25,138.0931,138.9272,-999.25,-999.25,0.6022,1954.2218,-90.2921,0.5099,8.7543,3.7614,3.9793,4.4929,5.4601,6.5164,3.7433,0.2535,2.5387,-0.2254,-0.474,4.4242,17.2824,12.8964,12.8964,11.3701,0.0261,6.7478,10.0198,17.7187,10.0199,265.8596,9.8611,10.4289,7.4823,51.3723,42.0994,10.732,0.406,4.4477,1.5988,0.3595,10.9563,3.9384,4.0
 655.5,82.6383,9.9423,1.8848,1.8962,1.8701,7.875,229843.2813,2086.3584,178.4261,5.4965,5.1049,4.7992,4.5161,5.1299,4.7803,0.0,138.4473,73.4572,139.2944,18.2865,137.3715,219.609,0.0189,0.0409,715.5396,550.7895,-999.25,-999.25,-999.25,138.3933,139.3484,-999.25,-999.25,0.6863,2002.0046,-90.2378,0.5088,7.2878,3.1351,3.3061,3.6831,4.4155,5.2684,3.1229,0.2535,2.469,-0.0679,-0.4318,4.2913,20.2653,15.6865,15.6865,14.046,0.0223,10.9686,14.0925,21.4429,14.0925,318.9682,9.8939,6.9758,5.5215,68.8896,54.1648,13.9243,0.5259,5.739,2.0783,0.3621,10.9136,3.9522,4.0
 656.0,74.6817,9.8775,1.8913,1.904,1.8726,7.875,229806.6094,2048.3977,177.1155,5.4153,5.0814,4.7578,4.5295,5.0568,4.7918,0.0,139.3892,73.6964,140.3289,18.4557,138.0089,219.5315,0.0179,0.0415,781.2234,563.8469,-999.25,-999.25,-999.25,139.365,140.3531,-999.25,-999.25,0.703,2000.3569,-90.1419,0.5029,6.3594,2.7641,2.9101,3.2149,3.8309,4.5841,2.7559,0.2535,2.4297,0.3767,-0.1277,4.2576,21.9283,17.264,17.264,15.55,0.0251,13.3503,16.3906,23.5444,16.3906,361.7806,9.914,6.6505,5.1208,82.6623,66.2939,17.4209,0.6542,7.0017,2.6179,0.3739,10.7028,4.0017,2.0
 656.5,71.2593,9.7569,1.9012,1.9163,1.879,7.875,229751.5313,2056.4507,175.8506,5.2953,5.0431,4.6971,4.4933,4.9522,4.7898,0.0,140.9788,74.1413,142.0956,18.7704,139.327,219.2493,0.0176,0.0421,861.8867,602.0083,-999.25,-999.25,-999.25,140.9525,142.1219,-999.25,-999.25,0.8224,1966.8901,-90.0191,0.4903,5.6911,2.5312,2.6616,2.922,3.4673,4.1577,2.5259,0.2535,2.4182,0.7321,-0.0201,4.2646,23.7144,18.9757,18.9757,17.175,0.0335,14.0471,17.0629,24.1592,17.063,395.0638,9.9436,5.6774,4.9191,92.9448,75.5738,20.5949,0.7746,7.9191,3.0892,0.3901,10.2238,3.9882,0.0
 657.0,71.0011,9.6709,1.9096,1.9284,1.8889,7.875,229714.0781,2175.0933,175.0044,5.2667,5.0008,4.6373,4.4665,4.8617,4.7796,0.0,143.9003,75.3335,145.3089,19.6135,142.3177,220.0326,0.0183,0.0388,892.1188,703.6527,-999.25,-999.25,-999.25,143.8584,145.3508,-999.25,-999.25,1.0331,1972.049,-89.7539,0.4687,5.124,2.3718,2.4898,2.717,3.2063,3.8439,2.3688,0.2535,2.4151,0.6095,0.1125,4.2594,23.8405,19.0972,19.0972,17.29,0.0429,14.2337,17.243,24.3239,17.2431,421.6125,9.9435,5.8855,4.7029,103.9045,81.8147,22.9414,0.8658,8.5121,3.4272,0.4026,9.832,3.9587,4.0
 657.5,72.983,9.626,1.928,1.9448,1.8984,7.875,229676.0,2216.8169,173.1826,5.2458,4.993,4.5774,4.4699,4.8136,4.7783,0.0,148.561,77.024,149.8364,20.8091,146.2402,220.6523,0.0171,0.0368,895.8463,694.7435,-999.25,-999.25,-999.25,148.4691,149.9283,-999.25,-999.25,0.9858,1952.3447,-89.4035,0.4395,4.6626,2.2776,2.3861,2.5893,3.0353,3.6363,2.276,0.2535,2.4017,0.2188,0.3838,4.2448,23.1562,18.4388,18.4388,16.666,0.0456,15.0493,18.03,25.0435,18.03,439.0577,9.9282,5.6534,4.3854,111.0804,83.3533,24.2169,0.9269,8.5718,3.5563,0.4149,9.2482,3.8369,3.0
 658.0,75.5386,9.5825,1.9398,1.9508,1.8994,7.875,229636.8125,2216.4729,171.7096,5.2171,4.9781,4.5599,4.4605,4.7577,4.7742,0.0,154.1665,79.4368,155.0082,22.5154,150.8919,221.1926,0.0159,0.0354,861.1747,625.7589,-999.25,-999.25,-999.25,153.9685,155.2062,-999.25,-999.25,0.8134,1985.5698,-88.9561,0.4171,4.4425,2.2605,2.3637,2.5533,2.9732,3.563,2.26,0.2535,2.3903,-0.009,0.0699,4.2218,23.2266,18.5064,18.5064,16.7301,0.0431,15.7411,18.6975,25.6539,18.6975,442.3863,9.8697,5.8939,4.5509,108.4047,79.0016,24.0691,0.938,7.9633,3.4548,0.4338,8.4896,3.6831,0.0
 658.5,83.247,9.5024,1.9553,1.958,1.9017,7.875,229595.5781,2251.3594,169.7999,5.1753,4.9828,4.5335,4.3874,4.6757,4.7525,0.0,161.8114,82.7163,162.0162,24.8347,157.3293,222.0476,0.0157,0.0335,779.174,562.8699,-999.25,-999.25,-999.25,161.3837,162.444,-999.25,-999.25,0.6698,1963.136,-88.3069,0.403,4.3667,2.2796,2.3775,2.5552,2.9461,3.5098,2.2796,0.2535,2.3973,-0.1861,-0.3635,4.1987,22.568,17.875,17.875,16.1308,0.038,15.3177,18.289,25.2804,18.2891,438.6771,9.8307,6.0071,4.8215,98.6192,72.2411,23.2285,0.9199,7.121,3.2649,0.4585,7.7415,3.5494,3.2
 659.0,96.5995,9.4709,1.9636,1.9677,1.9049,7.875,229552.2969,2227.8418,167.4465,5.1388,4.9507,4.5319,4.3794,4.6402,4.7715,0.0,169.0732,86.0618,169.4198,27.2007,163.9772,224.2936,0.0157,0.0298,636.8648,498.4787,-999.25,-999.25,-999.25,168.8177,169.6752,-999.25,-999.25,0.5167,2015.0868,-87.2271,0.382,4.2883,2.3253,2.4168,2.5824,2.9358,3.4416,2.3253,0.2535,2.4206,-0.3066,-0.1188,4.1427,20.6936,16.0912,16.0912,14.4325,0.0301,13.9042,16.9251,24.0331,16.9251,430.0571,9.8011,6.6907,5.2953,88.6712,65.6801,22.1974,0.8901,6.3365,3.0672,0.4841,7.1185,3.4458,1.6
 659.5,101.057,9.4285,1.9787,1.9827,1.9154,7.875,229507.4688,2248.4453,165.7455,5.1233,4.9311,4.5136,4.3452,4.6197,4.7525,0.0,175.9581,88.8836,176.3158,29.1963,170.2918,226.4288,0.0139,0.0259,537.8335,415.9464,-999.25,-999.25,-999.25,175.7043,176.5695,-999.25,-999.25,0.4942,2009.2599,-85.713,0.3335,4.0132,2.3722,2.4546,2.6042,2.9032,3.3098,2.3722,0.2535,2.4584,-0.2013,0.3711,4.0323,18.3775,13.9148,13.9148,12.3492,0.0242,11.6113,14.7127,22.01,14.7127,421.5525,9.7694,7.3572,6.1532,83.6661,61.6121,21.6072,0.8756,5.8402,2.9422,0.5038,6.6698,3.3602,1.6
 660.0,87.7136,9.4171,2.0036,2.0047,1.9279,7.875,229461.5938,2238.5789,163.6956,5.1195,4.9233,4.5168,4.3123,4.6095,4.7701,0.0,182.2048,90.9035,182.2995,30.6248,175.2875,228.1567,0.0114,0.0237,495.0437,329.6944,-999.25,-999.25,-999.25,181.8118,182.6926,-999.25,-999.25,0.4829,1986.3525,-83.6839,0.259,3.5534,2.3873,2.4566,2.5839,2.8113,3.0948,2.3873,0.2535,2.4937,0.1918,0.4276,4.012,17.5709,13.164,13.164,11.6277,0.0192,9.474,12.6503,20.1241,12.6503,418.885,9.7535,9.5424,7.2438,82.144,58.1488,21.0172,0.8566,5.4435,2.8387,0.5215,6.3547,3.3138,2.0
 660.5,72.9746,9.3933,2.0325,2.027,1.9378,7.875,229438.3906,2249.0874,161.3188,5.0877,4.9147,4.5184,4.3009,4.5787,4.7796,0.0,186.5601,91.7678,186.0551,31.236,177.8422,229.0589,0.0098,0.0263,509.2226,256.3628,-999.25,-999.25,-999.25,185.7961,186.8191,-999.25,-999.25,0.5458,1951.6654,-81.3807,0.1852,3.1389,2.3807,2.4354,2.5385,2.6946,2.8727,2.3807,0.2535,2.5248,0.4385,0.1952,4.0883,17.8751,13.4468,13.4468,11.8996,0.0179,7.5889,10.8313,18.4608,10.8314,420.0422,9.7181,9.0195,6.1855,79.8243,57.8117,21.6557,0.8805,5.3228,2.9348,0.5514,6.0449,3.333,1.0
 661.0,69.19,9.3956,2.0571,2.0481,1.9517,7.875,229391.8281,2246.7358,158.4585,5.0877,4.9264,4.5184,4.2969,4.5779,4.7796,0.0,188.9709,91.8575,188.1358,31.2995,179.2753,229.4141,0.0083,0.0352,639.3645,196.9231,-999.25,-999.25,-999.25,187.9278,189.1789,-999.25,-999.25,0.6605,1949.1776,-78.8678,0.125,2.8275,2.3568,2.3971,2.4768,2.5739,2.6794,2.3568,0.2535,2.5464,0.0756,-0.0132,4.0209,18.6555,14.1745,14.1745,12.5985,0.0138,6.2787,9.5671,17.3047,9.5672,424.3015,9.6901,6.7704,3.8653,76.392,59.4477,23.0946,0.9349,5.3914,3.1495,0.5842,5.7667,3.3687,2.0
 661.5,66.497,9.436,2.0711,2.0632,1.9654,7.875,229345.8906,2281.4731,155.9448,5.1373,4.9296,4.5367,4.2975,4.6095,4.7973,0.0,189.1244,91.3138,188.3873,30.915,179.4545,228.8535,0.007,0.0446,792.0249,156.5929,-999.25,-999.25,-999.25,188.1324,189.3793,-999.25,-999.25,0.659,1990.3384,-76.4279,0.0784,2.568,2.2959,2.3225,2.3799,2.4345,2.4983,2.2959,0.2535,2.5523,-0.3482,-0.2104,3.7956,20.2145,15.6386,15.6386,14.0002,0.007,5.9206,9.2217,16.9888,9.2217,435.5582,9.6622,5.5255,3.0385,76.3965,62.6571,25.5272,1.0256,5.5512,3.5182,0.6338,5.4127,3.4304,0.0
 662.0,65.6426,9.4766,2.0757,2.0747,1.9711,7.875,229300.125,2276.873,153.7282,5.1373,5.0235,4.5367,4.319,4.589,4.8244,0.0,187.1174,90.1456,187.0022,30.0888,177.6674,227.6345,0.0054,0.0613,1038.4855,122.3531,-999.25,-999.25,-999.25,186.4784,187.6413,-999.25,-999.25,0.6226,1942.2563,-73.9646,0.0479,2.3562,2.2025,2.2173,2.2554,2.2851,2.3333,2.2025,0.2535,2.55,-0.294,-0.0468,3.6483,21.7058,17.052,17.052,15.3483,0.0077,6.0618,9.3578,17.1133,9.3579,454.0374,9.6293,5.2178,2.8523,81.5748,67.0586,29.0431,1.1539,5.7277,4.0642,0.7096,4.9638,3.5222,4.0
 662.5,65.7051,9.4173,2.0722,2.08,1.974,7.875,229255.2813,2265.9749,151.6482,5.1109,4.9499,4.4984,4.2881,4.5732,4.8312,0.0,183.7863,88.6857,184.4491,29.0564,175.0502,226.3128,0.0042,0.0851,1360.0228,98.1831,-999.25,-999.25,-999.25,183.4869,184.7485,-999.25,-999.25,0.6879,1884.5922,-71.5722,0.0325,2.1964,2.0986,2.1041,2.1273,2.1454,2.1948,2.0986,0.2535,2.5402,-0.0613,0.1471,3.5282,23.8449,19.1014,19.1014,17.294,0.0123,6.6525,9.9278,17.6345,9.9278,476.5149,9.6071,4.5989,2.4637,92.9439,71.0706,32.8062,1.2889,5.8178,4.6595,0.8009,4.5137,3.615,0.0
 663.0,59.4681,9.4412,2.0679,2.0803,1.9775,7.875,229210.9531,2273.9705,150.1685,5.1148,4.9734,4.5279,4.3089,4.5598,4.8386,0.0,179.9346,87.0135,181.0002,27.8738,172.0551,225.0913,0.0035,0.1024,1469.3898,78.6807,-999.25,-999.25,-999.25,179.8183,181.1166,-999.25,-999.25,0.7203,1841.9108,-69.196,0.0246,2.0573,1.9879,1.9863,1.9981,2.011,2.0624,1.9879,0.2535,2.534,0.046,0.0653,3.3309,26.2704,21.4564,21.4564,19.5175,0.0171,7.0306,10.2927,17.9682,10.2927,503.0334,9.636,3.2133,1.8064,102.5528,72.4598,35.7018,1.3896,5.6589,5.1329,0.907,4.0723,3.6938,3.0
 663.5,53.2852,9.4673,2.0689,2.0839,1.9813,7.875,229167.9063,2276.6548,149.0907,5.1373,4.9851,4.5351,4.315,4.5629,4.8664,0.0,176.4769,85.3034,177.7447,26.6644,168.9943,224.0439,0.0027,0.1136,1358.5897,52.9563,-999.25,-999.25,-999.25,176.4447,177.7768,-999.25,-999.25,0.7543,1928.4938,-67.1887,0.0177,2.0404,1.9909,1.9818,1.9858,1.9948,2.0416,1.9909,0.2535,2.536,0.1641,-0.077,3.2576,27.1278,22.2967,22.2967,20.3078,0.0203,6.9072,10.1736,17.8593,10.1736,502.2791,9.6801,2.9933,1.6999,97.9768,71.062,37.0967,1.4317,5.3047,5.3914,1.0164,3.7052,3.7658,1.0
 664.0,51.8546,9.4671,2.0647,2.0839,1.978,7.875,229105.3125,2297.9919,147.8506,5.1342,4.9898,4.5351,4.315,4.5606,4.8664,0.0,173.6758,84.118,175.2835,25.8261,166.3793,223.354,0.0023,0.1211,1155.8273,33.7349,-999.25,-999.25,-999.25,173.6758,175.2835,-999.25,-999.25,0.9213,1972.6023,-65.6609,0.0016,2.1027,2.0981,2.08,2.0763,2.0786,2.102,2.0981,0.2535,2.5466,0.1018,-0.3799,3.3853,24.755,19.9812,19.9812,18.1261,0.0231,6.2643,9.5532,17.292,9.5532,476.6322,9.6432,3.4758,2.0272,85.6485,66.3618,36.2883,1.4032,4.7576,5.2609,1.1058,3.3905,3.7492,2.0
 664.5,53.754,9.4941,2.0461,2.061,1.971,7.875,229062.9688,2318.2058,146.8379,5.1373,5.0344,4.5351,4.3237,4.5811,4.8705,0.0,171.2471,83.6949,172.5006,25.5268,164.948,223.4579,0.0029,0.109,930.5614,30.1538,-999.25,-999.25,-999.25,171.2285,172.5192,-999.25,-999.25,0.7476,1980.1455,-64.6181,-0.0098,2.2102,2.2402,2.2115,2.1994,2.1904,2.2111,2.2402,0.2535,2.5549,-0.2011,-0.1837,3.5206,23.3297,18.6055,18.6055,16.8241,0.0239,5.7615,9.0681,16.8483,9.0681,446.3822,9.6597,3.675,2.0684,78.0488,60.4385,34.3577,1.3347,4.1599,4.952,1.1904,3.1168,3.7103,1.0
 665.0,57.7094,9.4974,2.0374,2.0488,1.9775,7.875,229021.5781,2310.8296,145.9837,5.1497,5.0462,4.5367,4.3271,4.5622,4.8705,0.0,168.5139,82.7058,169.4586,24.8273,163.5406,223.3789,0.0051,0.094,664.0037,42.1618,-999.25,-999.25,-999.25,168.4731,169.4995,-999.25,-999.25,0.6049,1986.3188,-64.3308,-0.0292,2.3023,2.3956,2.3553,2.335,2.3096,2.3061,2.3956,0.2535,2.5477,-0.202,0.2268,3.5338,23.5804,18.8467,18.8467,17.0527,0.0186,6.1974,9.4887,17.233,9.4887,417.4366,9.6867,3.2741,1.9841,75.0796,55.6548,32.8356,1.2863,3.664,4.6815,1.2777,2.8484,3.6394,1.0
 665.5,62.3093,9.4669,2.031,2.0419,1.9815,7.875,228980.9375,2324.1826,145.2758,5.135,4.9945,4.5192,4.3224,4.5606,4.8692,0.0,166.0149,81.7388,166.9173,24.1434,161.9633,223.0965,0.0038,0.078,457.211,29.3529,-999.25,-999.25,-999.25,165.9276,167.0045,-999.25,-999.25,0.6453,1955.5005,-64.6328,-0.0508,2.4731,2.6482,2.5935,2.5645,2.5162,2.483,2.6482,0.2535,2.539,-0.1024,-0.1158,3.5338,22.7984,18.0957,18.0957,16.3404,0.0106,6.727,9.9998,17.7003,9.9998,377.6193,9.7152,4.4872,2.5297,71.592,52.9206,32.3971,1.2784,3.326,4.5752,1.3756,2.6017,3.5789,0.8
 666.0,60.5881,9.5037,2.0256,2.0311,1.9684,7.875,228940.4531,2293.6677,144.2177,5.1427,5.0407,4.5519,4.3445,4.5519,4.8793,0.0,164.5428,81.2344,165.0005,23.7867,159.6734,222.6453,0.0029,0.0853,393.6306,19.9136,-999.25,-999.25,-999.25,164.3598,165.1835,-999.25,-999.25,0.4984,1961.2352,-65.0364,-0.0707,2.594,2.8504,2.7817,2.7455,2.6718,2.6101,2.8504,0.2535,2.5405,-0.2937,-0.1158,3.5655,21.8654,17.204,17.204,15.493,0.0043,6.6337,9.9097,17.618,9.9097,350.823,9.7152,4.7238,2.6917,66.5895,50.8574,32.1729,1.2857,3.066,4.4667,1.4569,2.3847,3.4741,3.2
 666.5,55.7084,9.508,2.0168,2.0194,1.9442,7.875,228900.5,2287.3123,143.3929,5.1466,5.0243,4.5886,4.3432,4.5385,4.8827,0.0,163.6253,81.1515,163.8547,23.7281,156.7443,222.7716,0.0025,0.109,417.3744,14.6317,-999.25,-999.25,-999.25,163.2516,164.2284,-999.25,-999.25,0.5959,1979.3976,-65.7507,-0.0866,2.6559,2.9783,2.8974,2.8561,2.7592,2.677,2.9783,0.2535,2.5442,-0.3577,0.3343,3.5531,21.4362,16.7956,16.7956,15.1041,-0.001,6.4135,9.6972,17.4236,9.6972,335.7589,9.7165,4.7796,2.9984,60.1729,49.214,32.0681,1.301,2.8442,4.36,1.5329,2.1862,3.3514,4.0
 667.0,56.183,9.4564,2.0027,2.0115,1.9337,7.875,228860.5625,2271.2168,142.1112,5.1481,4.9812,4.5615,4.3203,4.499,4.859,0.0,163.9742,81.9158,164.7018,24.2686,155.7159,223.9422,0.0027,0.143,475.2641,13.4173,-999.25,-999.25,-999.25,163.798,164.878,-999.25,-999.25,0.6559,1965.5078,-66.629,-0.0989,2.7144,3.0913,2.9997,2.9547,2.8373,2.7413,3.0913,0.2535,2.5434,-0.1578,0.045,3.5293,21.1655,16.5385,16.5385,14.8591,-0.0041,6.4617,9.7437,17.4662,9.7437,323.4906,9.7193,4.9353,3.1159,56.7683,47.3901,31.7967,1.3145,2.6095,4.2065,1.612,1.9851,3.2,3.0
 667.5,68.07,9.4089,1.9833,1.9956,-999.25,7.875,228840.1719,2294.8496,140.6318,5.1388,4.9272,4.5367,4.2747,4.4998,4.8495,0.0,167.0249,84.2872,168.0616,25.9457,-999.25,225.7956,0.0032,0.1781,565.4468,14.3614,-999.25,-999.25,-999.25,166.9106,168.1759,-999.25,-999.25,0.7558,1984.1077,-67.6707,-0.1062,2.7288,3.1362,3.0377,2.9909,2.86,2.7561,3.1362,0.2535,2.5419,-0.0804,-0.2393,3.5438,21.007,16.3881,16.3881,14.7157,-0.0047,6.5498,9.8288,17.544,9.8288,318.8533,9.7143,4.6108,2.9955,57.5427,46.1405,31.8633,1.3424,2.4091,4.0962,1.7003,1.7947,3.0515,2.0
 668.0,83.038,9.4973,1.9627,1.9744,-999.25,7.875,228797.3125,2247.5503,139.1412,5.2094,4.9734,4.5695,4.3364,4.5164,4.8868,0.0,171.8912,87.6554,172.9072,28.3277,-999.25,227.9926,0.004,0.2145,616.967,16.2694,-999.25,-999.25,-999.25,171.7854,173.013,-999.25,-999.25,0.7189,1948.6816,-68.2908,-0.1099,2.6951,3.1117,3.0108,2.964,2.8271,2.7206,3.1117,0.2535,2.5423,-0.1161,0.0562,3.5885,20.7827,16.1756,16.1756,14.513,-0.0038,6.53,9.8097,17.5265,9.8097,321.3664,9.7254,5.2216,3.295,57.3527,46.1932,32.6442,1.3978,2.305,4.0897,1.7743,1.649,2.9258,3.0
 668.5,87.8136,9.5891,1.9497,1.9573,-999.25,7.875,228751.8594,2216.874,137.5166,5.3069,5.0086,4.6206,4.3673,4.5345,4.9295,0.0,177.3761,91.0246,178.0475,30.7104,-999.25,230.3576,0.005,0.2724,642.1903,17.5415,-999.25,-999.25,-999.25,177.2187,178.2049,-999.25,-999.25,0.5643,1987.5852,-68.4709,-0.1092,2.5584,2.9513,2.8553,2.8109,2.6792,2.5803,2.9513,0.2535,2.5364,-0.0181,0.2573,3.5504,20.8937,16.2807,16.2807,14.6133,-0.0018,6.8871,10.1542,17.8415,10.1542,338.831,9.7583,5.1848,3.0677,60.1961,46.7909,34.0116,1.4663,2.2134,4.2136,1.9037,1.5095,2.8736,4.0
 669.0,87.4513,9.6304,1.9476,1.9535,-999.25,7.875,228704.8594,2204.657,136.0406,5.2721,5.0485,4.6493,4.3854,4.5771,4.9586,0.0,182.7178,93.8301,183.2565,32.6946,-999.25,232.8796,0.0047,0.3395,675.8713,15.3241,-999.25,-999.25,-999.25,182.575,183.3992,-999.25,-999.25,0.4568,1944.3168,-68.7492,-0.1099,2.4854,2.8695,2.7785,2.7359,2.6085,2.5061,2.8695,0.2535,2.5288,0.092,0.0712,3.4195,21.7765,17.1194,17.1194,15.4124,0.0,7.3483,10.5992,18.2485,10.5993,348.4964,9.7488,3.9695,2.2904,62.1982,45.1984,33.9391,1.4636,1.9907,4.203,2.1113,1.3602,2.8717,2.0
 669.5,86.9375,9.6814,1.954,1.9598,-999.25,7.875,228656.9688,2278.5132,134.3857,5.286,5.0736,4.6573,4.4511,4.5708,5.0054,0.0,187.5918,95.9919,188.148,34.2234,-999.25,234.903,0.0035,0.3757,656.9236,10.4376,-999.25,-999.25,-999.25,187.5045,188.2354,-999.25,-999.25,0.3924,1973.3165,-69.5427,-0.1205,2.7345,3.1985,3.103,3.0567,2.9154,2.7654,3.1985,0.2535,2.5449,0.0511,-0.038,3.5019,21.3685,16.7312,16.7312,15.0428,0.0036,6.3696,9.6548,17.3849,9.6548,312.646,9.7543,4.4259,2.9705,54.8751,42.9983,33.1979,1.428,1.7802,4.1283,2.319,1.2467,2.891,1.0
 670.0,88.4614,9.7469,1.9641,1.9696,-999.25,7.875,228608.6406,2325.4216,132.628,5.2969,5.1236,4.6788,4.5061,4.6111,5.0244,0.0,191.342,97.4049,191.8772,35.2227,-999.25,236.0967,0.0032,0.4074,620.8882,8.3724,-999.25,-999.25,-999.25,191.2652,191.954,-999.25,-999.25,0.3593,1834.3451,-70.8921,-0.1254,3.0122,3.5443,3.4489,3.4004,3.252,3.0551,3.5443,0.2535,2.5812,-0.0352,-0.0944,3.7482,18.6623,14.1808,14.1808,12.6045,0.0092,4.1715,7.5339,15.4455,7.5339,282.1404,9.7437,8.276,5.1813,49.1133,43.6595,34.4865,1.4773,1.7169,4.3178,2.515,1.1622,2.9229,1.0
 670.5,92.4726,9.7239,1.9723,1.9777,-999.25,7.875,228559.5313,2329.3337,129.947,5.3031,5.0783,4.6796,4.4598,4.6111,5.04,0.0,194.1057,98.4069,194.6376,35.9313,-999.25,237.291,0.004,0.4339,583.8984,9.2451,-999.25,-999.25,-999.25,193.9949,194.7485,-999.25,-999.25,0.3863,1854.4993,-72.3195,-0.1014,2.5501,2.9135,2.8469,2.8112,2.7081,2.5755,2.9135,0.2535,2.5867,-0.0186,-0.2425,3.6646,18.8183,14.3267,14.3267,12.7445,0.012,3.8342,7.2084,15.1478,7.2084,343.2293,9.7802,7.7543,4.4414,56.5354,48.7016,39.1009,1.6724,1.8346,4.9076,2.675,1.097,2.9345,2.0
 671.0,97.8036,9.7536,1.9799,1.9822,-999.25,7.875,228484.6875,2317.1851,127.3383,5.3193,5.0908,4.6963,4.4826,4.6095,5.0623,0.0,195.6134,98.7956,195.8421,36.2063,-999.25,238.339,0.0046,0.4011,475.3042,9.6019,-999.25,-999.25,-999.25,195.3746,196.0808,-999.25,-999.25,0.3615,1912.6123,-73.5044,-0.0621,1.9461,2.1148,2.0766,2.0546,2.0012,1.9547,2.1148,0.2535,2.5475,0.0801,-0.1103,3.2599,23.2091,18.4896,18.4896,16.7142,0.0129,6.2108,9.5017,17.2448,9.5017,472.8517,9.7965,4.6899,2.7021,72.7144,56.6614,46.0831,1.9602,2.0518,5.8352,2.8439,1.0467,2.9768,1.6
 671.5,104.6776,9.7751,1.9854,1.9848,-999.25,7.875,228435.1719,2291.2244,125.3174,5.3356,5.1361,4.6772,4.4819,4.6347,5.0596,0.0,194.6896,98.064,194.6387,35.6888,-999.25,238.1659,0.0049,0.3529,368.8206,9.2965,-999.25,-999.25,-999.25,194.3603,194.968,-999.25,-999.25,0.3144,1901.5331,-74.1857,-0.027,1.6368,1.6981,1.6762,1.662,1.6387,1.6396,1.6981,0.2535,2.5139,0.1309,-0.0765,2.9857,28.2788,23.431,23.431,21.3721,0.0143,8.2457,11.4652,19.0403,11.4652,588.9096,9.8787,3.5008,1.9521,85.7993,63.5925,52.2317,2.2163,2.208,6.6397,3.0071,0.9963,2.9959,1.6
 672.0,104.0264,9.785,1.9863,1.9852,-999.25,7.875,228386.625,2283.5603,123.4978,5.3356,5.1033,4.6987,4.494,4.6347,5.0887,0.0,191.8215,96.5818,191.729,34.6406,-999.25,236.6043,0.0045,0.3061,332.0454,8.8742,-999.25,-999.25,-999.25,191.4312,192.1194,-999.25,-999.25,0.3639,1965.5192,-74.3493,-0.0026,1.4689,1.4743,1.4635,1.4547,1.4487,1.4695,1.4743,0.2535,2.5039,0.0839,-0.2144,2.9911,31.5467,26.6915,26.6915,24.4162,0.0147,8.854,12.0521,19.577,12.0521,678.2976,9.9257,2.4443,1.443,91.942,67.743,55.8257,2.3617,2.3124,7.13,3.0833,0.9791,3.019,4.8
 672.5,90.2451,9.8983,1.9908,1.9867,-999.25,7.875,228339.5938,2281.1057,122.5776,5.3928,5.1791,4.7665,4.5375,4.7017,5.1172,0.0,188.5658,94.728,188.1943,33.3296,-999.25,234.2567,0.0039,0.3261,405.9881,8.9118,-999.25,-999.25,-999.25,187.8903,188.8698,-999.25,-999.25,0.5267,1940.8854,-73.8608,0.0081,1.3994,1.3838,1.38,1.374,1.3769,1.3994,1.3838,0.2535,2.504,0.0577,-0.1458,3.0919,31.8295,26.9764,26.9764,24.6811,0.0138,8.8501,12.0483,19.5736,12.0484,722.6489,9.98,2.2697,1.3726,93.3642,69.5034,57.2916,2.4353,2.3722,7.2623,3.0613,0.9741,2.982,2.0
 673.0,75.6934,9.8718,2.0014,1.9924,-999.25,7.875,228293.6719,2268.2915,121.6621,5.3851,5.1502,4.757,4.5081,4.6939,5.1212,0.0,186.9044,93.4001,186.0851,32.3905,-999.25,231.7428,0.004,0.3588,464.577,10.3989,-999.25,-999.25,-999.25,185.6316,187.358,-999.25,-999.25,0.9342,1939.285,-73.0619,0.0159,1.3784,1.3484,1.3498,1.346,1.3534,1.3784,1.3484,0.2535,2.511,0.0383,-0.1731,3.1862,31.4777,26.622,26.622,24.3515,0.0151,8.4237,11.6369,19.1973,11.6369,741.6469,9.9497,2.379,1.4447,92.5451,70.7204,58.2954,2.4929,2.4088,7.3188,3.0383,0.9663,2.9359,2.0
 673.5,73.3643,9.9065,2.0062,2.0089,-999.25,7.875,228248.0469,2267.9478,120.5935,5.4416,5.1596,4.7793,4.5315,4.6789,5.1287,0.0,187.0905,93.2699,187.3502,32.2983,-999.25,229.7875,0.0038,0.2952,521.0375,13.4574,-999.25,-999.25,-999.25,186.4607,187.9799,-999.25,-999.25,0.8136,1914.9043,-72.1052,0.0177,1.3569,1.324,1.329,1.327,1.3361,1.3569,1.324,0.2535,2.5075,-0.0378,-0.1937,3.2994,31.5756,26.7206,26.7206,24.4432,0.0159,8.6388,11.8444,19.3871,11.8444,755.2914,9.9597,2.4032,1.4319,94.4758,73.3451,60.8937,2.6247,2.4328,7.5468,3.1021,0.9269,2.8753,7.0
 674.0,85.5361,9.9517,2.0032,2.016,-999.25,7.875,228201.875,2241.6877,119.1147,5.5104,5.1752,4.7992,4.5308,4.708,5.1314,0.0,189.094,94.4072,190.2859,33.1027,-999.25,230.6647,0.0032,0.2547,612.0475,15.6988,-999.25,-999.25,-999.25,188.7043,190.6756,-999.25,-999.25,1.0456,1924.8768,-71.4445,0.0188,1.3497,1.3148,1.3228,1.322,1.3306,1.3497,1.3148,0.2535,2.4944,-0.0449,0.1186,3.3337,30.8111,25.9525,25.9525,23.7281,0.0143,9.4304,12.6083,20.0857,12.6083,760.5504,9.9939,2.4881,1.4001,98.4916,76.6012,64.3164,2.7869,2.4182,7.9017,3.2676,0.8677,2.8353,2.0
 674.5,99.6814,9.9332,1.9994,2.0069,-999.25,7.875,228178.0156,2277.6294,117.5168,5.4578,5.144,4.8247,4.5509,4.6868,5.1354,0.0,193.1091,96.5984,193.7992,34.6524,-999.25,235.2403,0.0033,0.2199,625.2137,19.7981,-999.25,-999.25,-999.25,192.6376,194.2706,-999.25,-999.25,0.8553,1942.1642,-70.9079,0.021,1.3458,1.307,1.317,1.3174,1.3245,1.3458,1.307,0.2535,2.4796,-0.0879,0.2309,3.1962,30.8678,26.0093,26.0093,23.7811,0.0112,10.3277,13.4741,20.8774,13.4741,765.1279,10.0144,2.6815,1.4892,100.1154,79.9992,67.6611,2.9415,2.4545,8.2664,3.3678,0.8344,2.8102,1.0
 675.0,109.2167,10.0166,1.9961,1.9982,-999.25,7.875,228128.4375,2240.3455,115.9763,5.488,5.1643,4.8646,4.6105,4.7727,5.1496,0.0,197.1111,98.7621,197.2952,36.1825,-999.25,239.1832,0.0032,0.1675,560.0897,22.5634,-999.25,-999.25,-999.25,196.6284,197.7779,-999.25,-999.25,0.5946,1930.4058,-70.6803,0.0233,1.3132,1.2711,1.282,1.2833,1.2928,1.3132,1.2711,0.2535,2.4624,-0.2838,0.2764,3.0297,30.6258,25.7668,25.7668,23.5551,0.009,11.3678,14.4777,21.7951,14.4777,786.7103,10.0472,2.059,1.2023,101.0174,80.6183,68.4758,2.9846,2.4422,8.3297,3.4108,0.8183,2.7909,2.0
 675.5,113.994,10.0247,1.9954,1.9963,-999.25,7.875,228077.3594,2193.5056,114.6564,5.4841,5.1612,4.8845,4.6367,4.727,5.1808,0.0,199.2945,99.8933,199.3677,36.9825,-999.25,241.013,0.0034,0.1409,533.0405,24.5204,-999.25,-999.25,-999.25,198.9431,199.7191,-999.25,-999.25,0.396,1962.3296,-70.7546,0.0241,1.3238,1.2801,1.2916,1.2935,1.3027,1.3238,1.2801,0.2535,2.464,-0.3838,0.3022,2.9424,30.4965,25.6373,25.6373,23.4344,0.0085,11.2717,14.385,21.7103,14.385,781.2142,10.0601,2.4652,1.4243,100.1734,76.1635,64.783,2.8326,2.2822,7.8378,3.4343,0.8057,2.767,1.0
 676.0,113.2454,10.1542,2.0017,2.0027,-999.25,7.875,228026.2656,2164.4482,112.733,5.5676,5.2362,4.9633,4.6668,4.8113,5.2173,0.0,198.9716,99.4187,199.0534,36.6469,-999.25,240.1464,0.0041,0.1371,520.5682,27.5457,-999.25,-999.25,-999.25,198.6477,199.3773,-999.25,-999.25,0.3719,1944.9275,-71.0236,0.0232,1.3242,1.2821,1.2935,1.2958,1.3037,1.3242,1.2821,0.2535,2.4779,-0.0032,-0.0872,2.882,31.4695,26.6138,26.6138,24.3438,0.0063,10.4322,13.5749,20.9696,13.575,779.9864,10.0818,2.4493,1.3994,91.6271,69.4199,59.5078,2.5965,2.002,7.2257,3.6092,0.7711,2.7829,0.0
 676.5,106.3414,10.0132,2.0119,2.0135,-999.25,7.875,227976.6719,2185.7742,111.0236,5.5483,5.176,4.8574,4.5556,4.7325,5.17,0.0,197.4334,98.1493,197.5732,35.7492,-999.25,237.0668,0.004,0.1168,484.9607,27.8853,-999.25,-999.25,-999.25,197.0928,197.9138,-999.25,-999.25,0.4196,1976.5758,-71.3349,0.0201,1.3036,1.2676,1.2781,1.2805,1.2861,1.3036,1.2676,0.2535,2.4887,0.4562,-0.162,2.851,32.1925,27.3427,27.3427,25.0215,0.0053,9.7746,12.9404,20.3893,12.9404,788.8657,10.0815,1.8727,1.2353,81.6756,65.2292,56.2059,2.4491,1.8193,6.8401,3.7597,0.7428,2.7929,2.0
 677.0,94.7742,10.0082,2.0195,2.0262,-999.25,7.875,227928.1875,2255.845,109.6552,5.5552,5.1416,4.8598,4.5509,4.712,5.2051,0.0,195.3262,96.7343,195.9572,34.7484,-999.25,234.1658,0.0031,0.1005,534.2365,25.5452,-999.25,-999.25,-999.25,195.0628,196.2206,-999.25,-999.25,0.5955,1995.6469,-71.5974,0.0147,1.3436,1.3165,1.3263,1.3287,1.3315,1.3436,1.3165,0.2535,2.5031,0.2739,-0.172,2.8806,29.7812,24.9227,24.9227,22.7676,0.0089,8.9041,12.1005,19.6213,12.1005,759.6116,10.1039,2.6139,1.5641,83.0032,67.6552,58.5934,2.5421,1.8428,7.1834,3.8982,0.7249,2.8258,1.0
 677.5,92.5642,10.0923,2.0238,2.0382,-999.25,7.875,227880.3594,2253.5618,108.381,5.5429,5.1823,4.9402,4.6367,4.775,5.1997,0.0,193.5796,95.6594,194.9429,33.9883,-999.25,233.3759,0.0026,0.1112,731.0211,25.4678,-999.25,-999.25,-999.25,193.4618,195.0607,-999.25,-999.25,0.8254,1961.8921,-71.4373,0.0097,1.4031,1.3844,1.3931,1.3954,1.3959,1.4031,1.3844,0.2535,2.5042,-0.1205,-0.2354,2.9449,30.5558,25.6967,25.6967,23.4898,0.0137,8.8379,12.0365,19.5628,12.0366,722.3597,10.0935,3.2424,1.7712,94.4053,76.8827,66.6979,2.8754,2.0877,8.2636,3.9583,0.726,2.8738,0.8
 678.0,103.1396,10.0993,2.0263,2.0425,-999.25,7.875,227809.4063,2299.575,106.5961,5.6333,5.1659,4.9243,4.6367,4.7333,5.2045,0.0,192.756,95.1287,194.2888,33.6129,-999.25,233.3087,0.0018,0.135,1070.3922,22.4756,-999.25,-999.25,-999.25,192.7116,194.3333,-999.25,-999.25,0.8381,1966.6022,-70.3272,0.0078,1.3878,1.3729,1.3793,1.3813,1.3809,1.3878,1.3729,0.2535,2.4809,-0.0652,0.3166,2.9809,32.2758,27.4268,27.4268,25.0996,0.0164,10.2509,13.4,20.8096,13.4,728.3635,10.1195,2.7576,1.4547,109.3121,87.2314,75.9502,3.2407,2.3488,9.5695,4.0742,0.7248,2.9529,0.8
 678.5,114.1147,10.0914,2.0235,2.0367,-999.25,7.875,227762.1094,2239.9668,105.1708,5.556,5.176,4.9363,4.6447,4.7616,5.1997,0.0,192.6942,95.2279,193.9479,33.6831,-999.25,233.3868,0.0013,0.1941,1604.7804,20.7569,-999.25,-999.25,-999.25,192.6717,193.9704,-999.25,-999.25,0.6709,1959.3008,-69.5465,0.0079,1.3594,1.3446,1.3485,1.35,1.3492,1.3594,1.3446,0.2535,2.4619,0.2535,0.0626,2.9805,34.1829,29.364,29.364,26.895,0.0166,11.4014,14.5101,21.8248,14.5101,743.7181,10.1891,2.0886,1.3299,122.2212,93.4079,81.185,3.433,2.5363,10.3764,4.0911,0.7388,3.0226,0.8
 679.0,113.9807,10.1471,2.0172,2.0297,-999.25,7.875,227714.2813,2231.5701,103.7642,5.583,5.2135,4.9458,4.6902,4.7955,5.2133,0.0,193.3844,95.8623,194.5805,34.1318,-999.25,233.9361,0.0014,0.3087,2127.5256,22.5119,-999.25,-999.25,-999.25,193.3784,194.5866,-999.25,-999.25,0.6222,1980.7562,-69.4963,0.0086,1.4002,1.3837,1.3853,1.3865,1.3844,1.4002,1.3837,0.2535,2.4682,0.1929,-0.853,3.0087,34.2793,29.4624,29.4624,26.9861,0.0178,11.0195,14.1416,21.4878,14.1417,722.7244,10.1418,2.8537,1.5387,125.5526,94.5437,81.6457,3.4339,2.6364,10.5235,3.9917,0.7678,3.0646,3.0
 679.5,104.4486,10.194,2.0212,2.0329,-999.25,7.875,227666.2969,2256.051,102.5539,5.6325,5.2401,4.9816,4.7096,4.7939,5.2241,0.0,195.5683,96.749,196.7038,34.7588,-999.25,234.6377,0.0016,0.46,2382.5134,20.6645,-999.25,-999.25,-999.25,195.535,196.737,-999.25,-999.25,0.6125,1957.3776,-69.8616,0.0063,1.4175,1.4053,1.4044,1.4052,1.4005,1.4175,1.4053,0.2535,2.4773,-0.2485,-0.4943,3.058,32.8564,28.0145,28.0145,25.6451,0.0212,10.469,13.6104,21.002,13.6104,711.6064,10.1346,2.2896,1.2928,119.6445,92.1528,78.4111,3.2969,2.72,10.1112,3.7173,0.825,3.0669,2.0
 680.0,100.8663,10.1978,2.0316,2.0428,-999.25,7.875,227617.125,2284.8911,100.9625,5.6093,5.2065,5.0031,4.7223,4.8144,5.2376,0.0,199.2019,98.0406,200.3033,35.6723,-999.25,235.8029,0.0014,0.5348,2308.9766,15.0152,-999.25,-999.25,-999.25,199.1151,200.3902,-999.25,-999.25,0.6389,1947.9799,-70.1746,0.0,1.4339,1.4344,1.4309,1.4314,1.4242,1.4339,1.4344,0.2535,2.4864,-0.2887,0.3839,3.077,34.4912,29.679,29.679,27.1863,0.0258,9.9158,13.0767,20.514,13.0767,697.1507,10.1474,2.1588,1.3171,107.7829,87.5151,73.0772,3.0976,2.7593,9.3047,3.3722,0.8908,3.0038,1.0
 680.5,108.3049,10.2725,2.0497,2.0576,-999.25,7.875,227567.0781,2320.0879,98.5047,5.6387,5.2604,5.0604,4.7538,4.8585,5.2457,0.0,202.6779,98.881,203.4602,36.2666,-999.25,238.424,0.002,0.7173,2406.2319,15.9498,-999.25,-999.25,-999.25,202.5005,203.6376,-999.25,-999.25,0.5615,1943.4767,-70.6981,-0.003,1.5276,1.534,1.5278,1.5278,1.5278,1.5278,1.534,0.2535,2.5061,0.0272,0.3711,3.0562,31.9182,27.0658,27.0658,24.7642,0.0259,8.7228,11.9255,19.4613,11.9255,651.8956,10.1866,2.8273,1.6253,97.536,84.0311,68.9709,2.9468,2.8061,8.6715,3.0903,0.9522,2.9427,3.0
 681.0,116.9426,10.2911,2.0637,2.0647,-999.25,7.875,227516.4531,2274.7615,97.437,5.6325,5.2698,5.0819,4.8079,4.8428,5.2383,0.0,203.8438,98.7859,203.9396,36.1994,-999.25,240.1015,0.0022,0.711,2050.7476,14.9067,-999.25,-999.25,-999.25,203.4865,204.2969,-999.25,-999.25,0.3995,1924.9004,-71.4118,-0.0165,1.5939,1.6304,1.6217,1.6211,1.6183,1.5942,1.6304,0.2535,2.5085,0.0738,-0.0642,2.9935,29.9174,25.0585,25.0585,22.8944,0.0199,8.5772,11.785,19.3328,11.785,613.3643,10.2517,3.0424,1.7709,98.703,82.6167,66.9316,2.89,2.877,8.2714,2.875,0.9955,2.8621,0.0
 681.5,116.4255,10.3785,2.0748,2.0748,-999.25,7.875,227491.5938,2270.7351,95.4783,5.6449,5.3237,5.1416,4.8935,4.8585,5.2735,0.0,200.7644,96.7801,200.7451,34.7808,-999.25,239.1528,0.0026,0.6784,1738.6554,15.4942,-999.25,-999.25,-999.25,200.3359,201.1736,-999.25,-999.25,0.4226,1946.6786,-71.7146,-0.0274,1.5973,1.6581,1.6479,1.6468,1.6399,1.5976,1.6581,0.2535,2.4959,-0.126,-0.2444,2.9387,31.1758,26.3185,26.3185,24.069,0.0167,9.3366,12.5178,20.0029,12.5178,603.115,10.2889,2.7109,1.6066,107.0423,83.3034,66.6882,2.9084,3.0209,8.1041,2.6827,1.0387,2.7865,2.0
 682.0,104.885,10.4078,2.0832,2.0865,-999.25,7.875,227443.7969,2265.5837,92.9609,5.6904,5.3354,5.1639,4.8848,4.8719,5.2768,0.0,195.3448,93.7768,195.6108,32.6568,-999.25,236.7866,0.0032,0.741,1628.8422,17.4637,-999.25,-999.25,-999.25,195.0086,195.947,-999.25,-999.25,0.4895,1931.3156,-71.623,-0.0354,1.6347,1.715,1.704,1.7024,1.6915,1.635,1.715,0.2535,2.4939,-0.426,-0.1662,2.9218,30.7972,25.9385,25.9385,23.7151,0.016,9.4589,12.6358,20.1108,12.6358,583.1069,10.3191,2.6699,1.6308,108.3833,84.8627,67.3935,2.9645,3.1695,8.0695,2.5459,1.0692,2.722,2.0
 682.5,87.3198,10.4534,2.0758,2.0835,-999.25,7.875,227398.4063,2291.3621,90.8936,5.7097,5.2995,5.2291,4.9035,4.9349,5.2836,0.0,188.4669,90.7733,189.1275,30.5327,-999.25,232.9612,0.0033,0.9095,1671.0815,16.4726,-999.25,-999.25,-999.25,188.234,189.3604,-999.25,-999.25,0.6099,1984.7296,-71.6785,-0.0425,1.7089,1.81,1.799,1.7969,1.7811,1.7094,1.81,0.2535,2.4937,-0.5334,0.3496,2.8734,29.326,24.4695,24.4695,22.3441,0.0128,9.4726,12.649,20.1229,12.649,552.4919,10.3698,3.6671,2.0382,103.3549,85.2584,67.7458,3.0,3.1806,8.0169,2.5206,1.0602,2.6723,2.0
 683.0,70.2225,10.2762,2.0604,2.0752,-999.25,7.875,227354.2188,2271.4812,89.3986,5.6449,5.2401,5.1249,4.7651,4.8349,5.2187,0.0,181.9539,88.2885,183.2193,28.7755,-999.25,229.7446,0.0029,0.9055,1477.7128,13.135,-999.25,-999.25,-999.25,181.7975,183.3757,-999.25,-999.25,0.8791,1937.707,-71.6315,-0.0463,1.6894,1.7983,1.7893,1.7868,1.7659,1.6898,1.7983,0.2535,2.4873,-0.2004,0.4705,2.8055,29.1948,24.339,24.339,22.2221,0.0116,9.8635,13.0262,20.4678,13.0262,556.0898,10.3889,2.9612,1.7796,101.2065,86.3824,69.1049,3.0565,3.1773,8.1951,2.5793,1.0395,2.6812,3.0
 683.5,59.8703,10.1849,2.0541,2.0747,-999.25,7.875,227311.2969,2269.8745,88.2517,5.6333,5.1979,5.0604,4.7277,4.7979,5.1375,0.0,177.3613,86.3291,179.1123,27.3897,-999.25,228.586,0.0027,0.7082,1190.2488,12.3838,76.7487,41.406,59.0774,177.1337,179.1184,59.0774,239.0774,1.1317,1914.27,-71.0688,-0.0409,1.6316,1.7244,1.7187,1.7162,1.6931,1.6319,1.7244,0.2535,2.4882,0.1765,-0.2448,2.8274,30.305,25.4457,25.4457,23.2557,0.0153,9.8085,12.9731,20.4192,12.9731,579.9216,10.4305,2.8855,1.6481,106.3455,89.5076,71.8003,3.1673,3.2966,8.5547,2.595,1.0408,2.701,3.2
 684.0,62.4408,10.0928,2.0415,2.0599,-999.25,7.875,227268.7656,2263.6804,86.4852,5.6364,5.1416,4.9482,4.7049,4.7104,5.1368,0.0,173.8698,85.1633,175.4383,26.5652,-999.25,229.2641,0.0022,0.4938,963.632,11.5805,70.0681,35.6954,52.8817,173.365,175.3888,52.8817,232.8817,1.2115,1895.6252,-70.2629,-0.0252,1.5557,1.61,1.6084,1.6059,1.59,1.5558,1.61,0.2535,2.49,0.2753,-0.6496,2.9523,31.2498,26.3928,26.3928,24.1382,0.0194,9.7,12.8684,20.3235,12.8684,621.1096,10.4897,2.7823,1.6137,115.2701,92.9779,74.3664,3.2639,3.4851,8.9391,2.565,1.0678,2.7388,5.6
 684.5,74.0488,10.0684,2.0195,2.034,-999.25,7.875,227225.7969,2273.3162,85.2338,5.5769,5.1205,4.9609,4.717,4.7183,5.1117,0.0,169.3699,83.8674,170.5928,25.6488,-999.25,230.3345,0.0017,0.3704,791.4898,9.893,67.4193,34.4472,50.9332,168.1685,170.4924,50.9332,230.9332,1.5165,1939.6989,-70.0703,-0.0029,1.4689,1.4748,1.4766,1.4743,1.4747,1.4686,1.4748,0.2535,2.4803,0.2275,-0.41,3.0147,33.2764,28.4407,28.4407,26.0403,0.0239,10.2852,13.433,20.8398,13.4331,678.0712,10.5217,2.7188,1.554,119.3697,94.2808,75.1756,3.2721,3.6003,9.1658,2.5459,1.1003,2.8012,1.6
 685.0,85.1114,10.1048,2.0041,2.018,-999.25,7.875,227161.4844,2264.9419,83.9322,5.566,5.1799,4.9808,4.7471,4.7309,5.1097,0.0,163.2329,81.4266,164.3757,23.9226,-999.25,230.3241,0.0016,0.3195,637.8813,9.0958,68.3645,34.7365,51.5505,160.8848,164.1552,51.5505,231.5505,2.2713,1970.1956,-70.9418,0.0176,1.3579,1.3252,1.3292,1.3272,1.3403,1.357,1.3252,0.2535,2.4733,0.1828,-0.1261,2.9345,33.3026,28.4674,28.4674,26.0649,0.0287,10.7118,13.8447,21.2163,13.8447,754.6073,10.4648,1.9972,1.3697,115.6395,87.2858,69.1506,2.989,3.4042,8.5301,2.5058,1.1389,2.8538,2.0
 685.5,81.3142,10.1835,2.0004,2.0164,-999.25,7.875,227122.8125,2228.8513,82.6696,5.5869,5.1838,5.0843,4.7946,4.7742,5.1266,0.0,152.7713,76.3553,154.0097,20.3361,-999.25,227.1913,0.002,0.4467,676.2717,9.7867,68.3645,34.7365,51.5505,147.4285,153.508,51.5505,231.5505,4.3877,1975.2745,-72.9734,0.0339,1.2829,1.2234,1.2286,1.2266,1.2438,1.2819,1.2234,0.2535,2.4694,0.162,0.1961,2.8789,33.6341,28.8045,28.8045,26.3773,0.0234,10.9476,14.0723,21.4244,14.0723,817.3992,10.4083,2.4153,1.3564,98.4853,74.8607,58.9349,2.5327,2.991,7.3402,2.4541,1.181,2.8982,0.0
 686.0,56.7576,10.0076,1.9928,2.0037,-999.25,7.875,227089.4531,2237.3398,81.4143,5.5939,5.0031,5.0286,4.7223,4.7853,4.8895,0.0,139.5116,70.0231,140.2963,15.8579,-999.25,220.9204,0.0016,0.7458,895.8995,6.6263,62.004,29.6767,45.8403,132.8661,140.8689,45.8403,225.8403,6.139,2042.5199,-74.857,0.0434,1.2294,1.1566,1.1623,1.16,1.1778,1.2289,1.1566,0.2535,2.4694,0.1612,0.589,2.8938,34.2223,29.4042,29.4042,26.9322,0.013,10.9444,14.0691,21.4215,14.0691,864.57,10.3412,1.8392,1.1944,73.1748,60.8508,47.2966,2.0322,2.5323,5.8922,2.3268,1.2461,2.8994,1.0
 686.5,28.5828,9.7822,1.9548,1.9669,-999.25,7.875,227057.7031,2245.416,80.0766,5.5073,4.8786,4.8622,4.5958,4.6899,4.8129,0.0,127.3601,65.2469,128.1186,12.4801,-999.25,216.7804,0.0018,0.8724,818.8994,6.0068,61.3317,30.0789,45.7053,120.0707,128.7463,45.7053,225.7053,7.0751,2006.3571,-76.0763,0.0497,1.2885,1.2013,1.2073,1.2044,1.2249,1.2873,1.2013,0.2535,2.489,0.0623,0.2679,2.8917,33.126,28.288,28.288,25.8987,0.0123,9.7575,12.9239,20.3742,12.9239,832.4181,10.2593,2.4705,1.5989,56.8771,50.7749,38.8639,1.6713,2.2094,4.8349,2.1883,1.322,2.893,3.0
 687.0,13.2526,9.5807,1.9,1.9287,-999.25,7.875,227024.2969,2249.9141,78.6752,5.3859,4.7736,4.7227,4.5141,4.5819,4.764,0.0,116.2469,61.5608,117.9634,9.8732,-999.25,214.4396,0.002,0.4546,450.0479,6.8101,70.9252,34.0954,52.5103,111.4622,118.0364,52.5103,232.5103,5.6075,2000.5302,-77.0724,0.0541,1.3675,1.2669,1.2723,1.2686,1.293,1.3659,1.2669,0.2535,2.5052,-0.1874,-0.4384,2.8434,31.7911,26.9376,26.9376,24.645,0.013,8.7742,11.9751,19.5066,11.9751,789.3074,10.2324,2.3438,1.4526,54.4531,49.908,37.5217,1.6185,2.2745,4.6448,2.0421,1.4054,2.8699,9.0
 687.5,8.3354,9.4806,1.9709,2.0058,-999.25,7.875,226999.125,2282.5049,77.4583,5.3487,4.7352,4.6206,4.4652,4.5637,4.7084,0.0,108.4408,55.3756,110.3286,5.499,-999.25,212.9463,0.0016,0.2358,260.2933,6.2091,60.5414,22.5786,41.56,106.1899,110.4175,55.6851,235.6851,3.7555,1990.2338,-78.2532,0.0579,1.4539,1.3395,1.3426,1.338,1.3669,1.4519,1.3395,0.2535,2.4912,-0.3159,-0.2004,2.6942,30.5447,25.6855,25.6855,23.4793,0.0096,9.6225,12.7936,20.2551,12.7936,746.5314,10.2312,2.2885,1.4364,64.7757,56.7209,42.0812,1.8163,2.6609,5.2037,1.9556,1.4651,2.865,3.0
 688.0,8.0065,9.4107,1.9618,1.9958,-999.25,7.875,226973.5781,2228.6675,75.9802,5.3387,4.696,4.5511,4.4377,4.5361,4.6724,0.0,103.0504,52.6785,104.8294,3.5916,-999.25,212.3186,0.0018,0.136,158.4192,6.5676,32.5004,-8.56,11.9702,101.9433,105.0502,63.8893,243.8893,2.928,1996.7524,-78.6952,0.062,1.604,1.4689,1.4666,1.4608,1.4958,1.6015,1.4689,0.2535,2.4637,-0.2281,0.7723,2.515,28.4598,23.6101,23.6101,21.5399,0.0126,11.291,14.4036,21.7273,14.4036,680.7829,10.2875,2.4069,1.5069,81.1421,64.1263,47.0995,2.0312,3.056,5.832,1.9084,1.5045,2.8712,2.0
 688.5,8.5395,9.3694,1.9284,1.956,-999.25,7.875,226960.8281,2216.5647,74.6984,5.2899,4.6795,4.5359,4.4243,4.5211,4.6574,0.0,99.3452,51.5889,100.7809,2.821,-999.25,212.2045,0.0018,0.0895,97.1881,5.3676,-18.0025,-64.8571,-41.4298,98.3651,101.2854,80.3558,260.3558,2.8974,1983.29,-78.2526,0.0622,1.8522,1.6958,1.6771,1.6679,1.7158,1.8488,1.6958,0.2535,2.4644,-0.131,0.7699,2.5486,26.679,21.8563,21.8563,19.8937,0.0207,11.2482,14.3622,21.6895,14.3623,589.6874,10.3087,2.3257,1.5232,88.1145,64.8994,46.8885,2.0399,3.1834,5.7215,1.7973,1.5606,2.8048,5.0
 689.0,9.0266,9.3073,1.9205,1.9301,-999.25,7.875,226935.4688,2160.5471,73.5561,5.2643,4.6458,4.472,4.3821,4.5085,4.6493,0.0,97.5689,50.8541,98.0794,2.3013,-999.25,212.2306,0.0023,0.0643,65.4181,5.0872,-51.6058,-102.3959,-77.0008,96.192,99.1944,90.8408,270.8408,3.1009,1974.8134,-77.142,0.0486,2.7962,2.6111,2.5477,2.5258,2.6035,2.791,2.6111,0.2535,2.564,0.1108,-0.0277,3.012,22.2024,17.5255,17.5255,15.7987,0.0278,5.2095,8.5355,16.3613,8.5355,382.981,10.1127,2.3414,2.0617,74.9449,53.9341,38.0185,1.668,2.7706,4.5731,1.6506,1.6611,2.7417,1.6
 689.5,10.8419,9.306,1.9506,1.9376,-999.25,7.875,226910.1875,2126.1201,71.9374,5.3193,4.6278,4.4609,4.3807,4.4951,4.6343,0.0,99.8282,51.2715,99.1784,2.5966,-999.25,212.5029,0.0034,0.0816,70.034,6.0423,-999.25,-999.25,-999.25,97.8872,100.964,-999.25,-999.25,3.1784,1984.0729,-75.913,-0.0212,6.423,6.612,6.3021,6.2101,6.3197,6.4155,6.6119,0.2535,2.7541,0.4081,0.096,3.8435,9.9999,6.3016,6.3016,4.9569,0.0229,-6.3108,-2.5806,6.1964,-2.5806,151.2401,9.9219,13.5912,18.1664,44.2973,35.8446,24.5534,1.0808,1.9416,2.9364,1.5123,1.7965,2.7168,1.6
 690.0,13.9063,9.2473,1.994,1.9697,-999.25,7.875,226885.2813,2178.7073,70.7794,5.2496,4.5862,4.4177,4.3821,4.4754,4.6309,0.0,104.8153,52.8752,103.57,3.7307,-999.25,212.9676,0.0046,0.1155,94.0281,7.5156,-999.25,-999.25,-999.25,102.8262,105.4856,-999.25,-999.25,2.666,1975.7919,-75.0084,-0.0866,28.1776,31.5996,29.9351,29.4388,29.2305,28.2981,31.5977,0.2535,2.9032,0.3846,0.5412,4.5732,3.1053,0.3486,0.3486,-0.9544,0.0073,-15.3482,-11.301,-1.7779,-11.3009,31.6459,9.7329,24.595,36.1133,18.3809,19.38,13.0079,0.5697,1.0908,1.5693,1.4387,1.9146,2.7546,0.8
 690.5,19.1149,9.1645,2.0212,2.0058,-999.25,7.875,226860.0938,2258.0811,68.3043,5.2372,4.5446,4.337,4.3391,4.4169,4.6187,0.0,112.6048,56.484,111.7669,6.2829,-999.25,213.9075,0.0056,0.1357,106.3213,8.0486,-999.25,-999.25,-999.25,111.1536,113.1837,-999.25,-999.25,1.9435,1981.8966,-74.8105,-0.1422,145.737,174.861,166.5676,163.7791,160.6296,150.8035,175.005,0.2535,2.9593,0.1078,0.2435,4.9226,1.155,-1.2828,-1.2828,-2.5976,0.008,-18.7483,-14.5817,-4.7779,-14.5816,5.7188,9.6312,29.6041,41.0672,9.1244,9.8751,6.5602,0.283,0.5661,0.8122,1.4346,2.0008,2.8703,2.4
 691.0,33.1128,9.1296,1.9635,1.9579,-999.25,7.875,226835.5781,2297.5798,67.3834,5.3069,4.5273,4.2746,4.2935,4.3806,4.6058,0.0,122.9743,63.8446,122.5767,11.4884,-999.25,215.6898,0.0058,0.1205,93.4248,8.3169,-999.25,-999.25,-999.25,122.03,123.5056,-999.25,-999.25,1.3018,1960.7742,-75.3742,-0.2695,171.1141,236.3183,221.439,216.13,203.5695,176.8221,236.6217,0.2535,2.9784,-0.1518,-0.3319,5.0497,0.6348,-1.714,-1.714,-3.0337,0.0193,-19.901,-15.694,-5.795,-15.694,4.2316,9.5942,33.941,50.4734,7.6309,6.7579,4.5285,0.1921,0.3817,0.576,1.1521,1.987,2.9989,0.0
 691.5,58.9768,8.9939,1.8646,1.8562,-999.25,7.875,226782.9063,2270.5176,65.8742,5.1869,4.5234,4.1882,4.2781,4.2605,4.5447,0.0,134.7479,73.1734,134.0851,18.0858,-999.25,218.1787,0.0056,0.0884,74.2892,9.7114,-999.25,-999.25,-999.25,133.7931,135.0399,-999.25,-999.25,0.9656,1978.5912,-76.2083,-0.2661,525.7299,721.2761,683.504,659.9249,613.9776,570.9084,724.4413,0.2535,2.9856,-0.0582,-0.3149,5.0679,0.6674,-1.6871,-1.6871,-3.0064,0.0179,-20.3391,-16.1167,-6.1816,-16.1167,1.3864,9.5456,33.1003,49.0873,7.7754,6.319,4.2875,0.1785,0.3499,0.5612,1.1224,1.9597,3.1433,3.0
 692.0,83.1212,8.858,1.8323,1.8238,-999.25,7.875,226739.5,2312.3667,64.9819,5.1605,4.4645,4.0969,4.1794,4.1791,4.4937,0.0,148.2764,81.4597,147.5435,23.9461,-999.25,221.6768,0.0065,0.0609,48.6865,13.1193,-999.25,-999.25,-999.25,147.2713,148.5486,-999.25,-999.25,0.886,1982.9561,-76.9808,-0.2391,801.8586,1065.0145,1032.6563,1005.4231,949.9054,893.8543,1074.1599,0.2535,2.981,0.1322,0.1726,5.0304,0.727,-1.6377,-1.6377,-2.9565,0.0116,-20.0602,-15.8476,-5.9355,-15.8476,0.939,9.5186,30.9146,47.0111,8.4169,6.4815,4.4703,0.1828,0.3502,0.6009,1.2018,1.9158,3.2868,4.0
 692.5,87.1973,8.919,1.8481,1.8463,-999.25,7.875,226694.4219,2327.1995,64.0265,5.2101,4.4802,4.1282,4.2667,4.1878,4.4842,0.0,160.5208,87.0413,160.3474,27.8934,-999.25,225.1522,0.0066,0.0421,28.7463,12.3684,-999.25,-999.25,-999.25,159.9276,160.9406,-999.25,-999.25,0.6427,1979.708,-77.6084,-0.286,445.0923,622.7061,580.7252,556.6946,525.7961,471.4913,625.9074,0.2535,2.9711,0.0273,0.3148,4.9792,0.8824,-1.509,-1.509,-2.8263,0.0082,-19.4584,-15.2669,-5.4044,-15.2668,1.6059,9.5633,27.1876,42.632,9.103,7.3162,5.0821,0.2056,0.3931,0.6935,1.3871,1.9113,3.3725,3.0
 693.0,76.701,9.1374,1.8699,1.873,-999.25,7.875,226647.5,2328.5999,62.9899,5.286,4.5885,4.2706,4.3304,4.3443,4.5922,0.0,168.8182,90.3312,169.1133,30.2201,-999.25,227.3998,0.0067,0.0436,24.4457,11.8873,-999.25,-999.25,-999.25,168.33,169.6015,-999.25,-999.25,0.7508,1906.0936,-77.9529,-0.1655,160.961,198.419,183.051,176.2979,173.1382,163.8203,198.6653,0.2535,2.9613,-0.0973,0.046,4.8888,1.1357,-1.2989,-1.2989,-2.6139,0.0086,-18.8657,-14.695,-4.8815,-14.695,5.0398,9.5088,28.7848,42.514,10.0148,9.2571,6.4058,0.2568,0.503,0.8858,1.7609,1.9591,3.4498,1.0
 693.5,70.2475,9.2018,1.9193,1.9194,-999.25,7.875,226599.7188,2333.6011,62.1914,5.2636,4.6082,4.3298,4.3975,4.4075,4.599,0.0,173.329,90.5299,173.311,30.3606,-999.25,227.7003,0.0053,0.0248,20.5034,12.7937,-999.25,-999.25,-999.25,172.6762,173.9638,-999.25,-999.25,0.7434,1826.7209,-78.2536,-0.1701,207.0072,256.4508,222.7691,192.4544,209.8155,211.4893,256.8453,0.2535,2.9463,-0.1808,-0.5091,4.7302,2.0311,-0.5529,-0.5529,-1.8611,0.0081,-17.9559,-13.8171,-4.0788,-13.8171,3.8994,9.4517,26.5433,40.7784,12.1561,12.5075,8.5285,0.3404,0.696,1.1864,1.7047,2.0447,3.4856,5.0
 694.0,68.0408,9.3407,1.9954,2.0016,-999.25,7.875,226555.3906,2322.8752,61.6136,5.3356,4.6458,4.3929,4.4685,4.5653,4.614,0.0,173.1108,87.0481,173.6279,27.8982,-999.25,226.8692,0.0036,0.02,24.3688,10.6524,-999.25,-999.25,-999.25,172.7767,173.9619,-999.25,-999.25,0.683,1832.7672,-78.2906,-0.0656,73.0718,79.7352,67.5614,59.3749,66.6994,73.4482,79.7709,0.2535,2.905,-0.2411,-0.8198,4.4857,3.9475,1.0603,1.0603,-0.2409,-0.0023,-15.4555,-11.4044,-1.8725,-11.4044,12.5415,9.35,30.1239,43.2489,19.2793,19.0616,12.6697,0.5057,1.0955,1.7623,1.6087,2.1663,3.485,4.0
 694.5,60.3965,9.4008,2.0658,2.0735,-999.25,7.875,226513.9063,2328.9785,60.7146,5.2876,4.6772,4.4329,4.5355,4.6158,4.6534,0.0,170.1363,82.5994,170.7637,24.752,-999.25,224.9795,0.002,0.0251,37.8752,6.4482,-999.25,-999.25,-999.25,169.8914,171.0085,-999.25,-999.25,0.6536,1904.3088,-78.1566,0.0014,20.2144,20.1727,18.3462,17.4576,18.6336,20.2329,20.1748,0.2535,2.8271,-0.0787,-0.3191,4.2376,7.9601,4.5106,4.5106,3.1916,-0.0057,-10.7343,-6.8489,2.2933,-6.8488,49.5718,9.2643,37.4604,43.1349,34.3047,31.0071,20.1069,0.8122,1.8379,2.7508,1.4967,2.2627,3.3868,1.0
 695.0,48.9593,9.3554,2.0894,2.0977,-999.25,7.875,226494.2813,2382.9763,60.1713,5.286,4.6246,4.4161,4.496,4.5764,4.6669,0.0,164.3565,78.8073,165.0081,22.0702,-999.25,223.2039,0.0016,0.0247,29.8538,5.1133,-999.25,-999.25,-999.25,164.1244,165.2401,-999.25,-999.25,0.6802,1981.7009,-77.5827,0.0296,5.6221,5.3945,5.1256,5.0176,5.2153,5.6072,5.3946,0.2535,2.7131,0.1389,0.2571,4.0054,14.4335,10.2796,10.2796,8.8409,0.008,-3.8241,-0.1812,8.3905,-0.1812,185.375,9.2918,24.5346,14.8753,58.7258,46.0013,29.5965,1.2028,2.7457,4.015,1.4623,2.2829,3.3382,0.0
 695.5,45.4036,9.2053,2.0897,2.1005,-999.25,7.875,226456.1875,2405.5415,59.4933,5.2187,4.605,4.257,4.3552,4.5614,4.6187,1.0,156.8159,75.093,157.6232,19.4434,-999.25,221.3523,0.0022,0.0376,33.9732,5.9308,-999.25,-999.25,-999.25,156.6238,157.8153,-999.25,-999.25,0.7664,2012.3573,-76.5599,0.0418,2.8296,2.668,2.6009,2.5781,2.6494,2.8155,2.668,0.2535,2.613,0.1972,0.1653,3.7146,20.9491,16.3332,16.3332,14.6634,0.0249,2.2438,5.6738,13.7445,5.6738,374.818,9.32,6.785,2.6684,81.9736,57.0794,36.4179,1.489,3.4467,4.8976,1.421,2.3148,3.2893,4.0
 696.0,43.1428,8.99,2.0754,2.088,-999.25,7.875,226420.2031,2334.9094,58.0176,5.1443,4.5352,4.1089,4.2418,4.3632,4.5766,0.0,148.848,71.7275,149.7727,17.0633,-999.25,219.7576,0.0036,0.0665,50.3378,8.7238,-999.25,-999.25,-999.25,148.6066,150.0141,-999.25,-999.25,0.9733,1984.7982,-76.0056,0.0529,2.2416,2.0802,2.0565,2.0502,2.0923,2.2257,2.0801,0.2535,2.5936,0.0992,-0.0697,3.4853,27.7436,22.9027,22.9027,20.8767,0.0341,3.4175,6.8064,14.7802,6.8064,480.734,9.4581,3.3287,2.2577,82.6623,60.9021,39.0011,1.5779,3.6626,5.3242,1.4537,2.3212,3.3743,3.2
 696.5,35.8899,9.0893,2.0346,2.0548,1.7127,7.875,226386.9063,2328.1641,57.6436,5.1582,4.5917,4.1322,4.2707,4.4809,4.6343,0.0,142.6736,70.1282,144.1024,15.9323,121.5553,219.0394,0.0058,0.0953,72.6003,13.8975,-999.25,-999.25,-999.25,142.4489,144.327,-999.25,-999.25,1.3522,2008.8561,-76.3331,0.0604,2.0884,1.9174,1.9147,1.9188,1.9496,2.07,1.9171,0.2535,2.5956,-0.0192,-0.2477,3.3291,28.274,23.4263,23.4263,21.3677,0.0298,3.2987,6.6918,14.6754,6.6918,521.5336,9.5603,3.2206,2.2166,68.4364,58.2251,37.3744,1.4956,3.495,5.1806,1.4823,2.3369,3.464,3.2
 697.0,28.8143,9.028,1.9684,2.0032,1.7268,7.875,226351.5313,2303.0166,57.0476,5.1303,4.5736,4.1161,4.2734,4.3624,4.6282,0.0,136.9022,69.5671,139.3295,15.5354,123.8239,218.9915,0.0095,0.1506,116.465,21.7481,-999.25,-999.25,-999.25,136.7999,139.4318,-999.25,-999.25,1.9462,1966.9475,-77.1164,0.0814,2.0459,1.8214,1.834,1.8472,1.9046,2.0243,1.821,0.2535,2.561,0.1778,-0.3527,3.1968,28.8834,24.0298,24.0298,21.9328,0.0196,5.3949,8.7144,16.5249,8.7144,549.0371,9.5787,2.9149,1.9412,62.9547,53.2433,34.3268,1.3574,3.1831,4.8352,1.519,2.3451,3.5622,7.0
 697.5,24.2794,9.0629,1.905,1.9504,1.7311,7.875,226317.3594,2261.4197,56.2902,5.1869,4.5516,4.1338,4.3002,4.3806,4.6357,0.0,132.3231,69.4877,135.467,15.4793,124.617,218.9108,0.0114,0.229,190.0511,24.5779,-999.25,-999.25,-999.25,132.2711,135.5191,-999.25,-999.25,2.4549,1960.9822,-77.6222,0.0918,2.0571,1.8032,1.8292,1.8525,1.9183,2.0343,1.8028,0.2535,2.5529,0.3566,-0.0417,3.2544,26.0451,21.2362,21.2362,19.3101,0.0147,5.883,9.1853,16.9556,9.1853,554.5756,9.6053,2.6418,1.7734,65.2709,48.8923,31.3974,1.2342,2.9309,4.4574,1.5208,2.3747,3.6115,1.0
 698.0,22.6947,9.0413,1.8558,1.8996,1.7346,7.875,226265.375,2248.5137,55.529,5.1613,4.5485,4.1121,4.2559,4.458,4.5882,0.0,129.5154,69.8091,132.5492,15.7066,125.0912,218.7168,0.0119,0.3295,285.0475,24.3538,-999.25,-999.25,-999.25,129.4813,132.5832,-999.25,-999.25,2.3825,1960.1758,-78.0212,0.1166,2.4341,2.0557,2.1064,2.1525,2.2466,2.3767,2.0552,0.2535,2.6316,0.0,0.4845,3.5642,21.4754,16.8328,16.8328,15.1396,0.0195,1.1126,4.5823,12.7464,4.5823,486.446,9.5122,2.6544,2.3663,60.9009,43.3469,27.3693,1.0731,2.6496,3.8986,1.4714,2.4691,3.6331,3.0
 698.5,25.6758,8.9219,1.8339,1.8622,1.7369,7.875,226229.875,2254.5254,54.0912,5.1443,4.5108,4.0104,4.0894,4.4919,4.5188,0.0,130.2614,71.0352,132.2367,16.5737,125.3552,218.7348,0.0084,0.2817,365.9405,23.1092,-999.25,-999.25,-999.25,130.2263,132.2717,-999.25,-999.25,1.568,1975.8156,-78.8378,0.2037,3.744,2.757,2.8742,2.9886,3.1794,3.3951,2.7561,0.2535,2.738,-0.403,0.4753,3.9471,16.3663,12.0498,12.0498,10.554,0.0236,-5.3334,-1.6376,7.0587,-1.6375,362.7172,9.403,11.7126,12.0289,48.4959,37.2535,23.104,0.9046,2.3278,3.2969,1.4163,2.5731,3.6443,3.0
 699.0,31.9245,8.9337,1.8355,1.8523,1.756,7.875,226193.2656,2237.5122,53.3794,5.1466,4.5469,4.0312,4.084,4.4706,4.5216,0.0,132.8054,72.3509,133.9954,17.5041,128.2495,219.2354,0.0079,0.2936,481.7592,30.0538,-999.25,-999.25,-999.25,132.7285,134.0723,-999.25,-999.25,1.0161,1982.2183,-80.7707,0.2378,3.9136,2.7251,2.8622,3.0053,3.2213,3.4801,2.7242,0.2535,2.732,-0.3103,-0.266,3.9514,15.9131,11.6328,11.6328,10.1513,0.0225,-4.97,-1.2869,7.3794,-1.2869,366.9654,9.2754,11.9905,10.6243,41.9454,32.1817,19.7236,0.774,2.0342,2.8062,1.3795,2.628,3.6254,4.0
 699.5,38.7319,8.8765,1.8467,1.8631,1.7711,7.875,226156.375,2119.7075,52.2141,5.1133,4.492,4.0104,4.0457,4.4682,4.4998,0.0,135.2807,73.2434,136.4688,18.1354,130.2646,219.5872,0.0087,0.3762,634.1093,34.8232,-999.25,-999.25,-999.25,135.244,136.5055,-999.25,-999.25,0.9305,1956.0764,-83.7686,0.2068,2.9811,2.184,2.2838,2.3924,2.5516,2.786,2.1835,0.2535,2.6168,-0.0125,-0.5569,3.4905,22.7219,18.0224,18.0224,16.2708,0.0272,2.0105,5.4487,13.5387,5.4487,457.8685,9.3024,6.6512,3.677,38.7175,27.4271,16.758,0.6614,1.7318,2.3663,1.3664,2.6183,3.5775,4.0
 700.0,41.5898,8.9093,1.863,1.8838,1.791,7.875,226119.3125,2155.1553,51.2442,5.1822,4.4904,4.0064,4.0417,4.4959,4.5114,0.0,137.4141,73.7528,138.9527,18.4956,132.2757,220.1435,0.0095,0.347,567.5333,36.0867,-999.25,-999.25,-999.25,137.3969,138.9698,-999.25,-999.25,1.1336,1975.8503,-86.9331,0.2071,2.6677,1.9536,2.0408,2.1401,2.2869,2.5341,1.9532,0.2535,2.5157,0.0838,-0.1623,3.082,25.1942,20.4074,20.4074,18.5286,0.0296,8.1383,11.3615,18.9455,11.3615,511.8768,9.3422,5.5973,3.1296,33.359,23.8985,14.5807,0.5799,1.5002,2.0381,1.3586,2.5871,3.5148,5.6
 700.5,36.5569,8.9613,1.8709,1.8998,1.8103,7.875,226082.2813,2247.1604,50.1596,5.2163,4.5171,4.0296,4.0787,4.5219,4.5202,0.0,138.4567,74.0033,140.601,18.6728,133.9742,220.5169,0.0108,0.3182,481.1335,35.2432,-999.25,-999.25,-999.25,138.4488,140.6088,-999.25,-999.25,1.5425,1964.1493,-89.411,0.2456,2.9643,2.0376,2.1386,2.2593,2.4403,2.7568,2.0369,0.2535,2.4991,-0.0077,0.1818,3.0551,25.4209,20.6279,20.6279,18.7367,0.0291,9.1464,12.3342,19.835,12.3342,490.7783,9.2938,5.6953,3.7579,28.8124,20.4391,12.458,0.4949,1.2738,1.7438,1.369,2.5736,3.5231,5.6
 701.0,30.7853,8.9202,1.8789,1.9061,1.8224,7.875,226045.3281,2296.1335,49.105,5.1388,4.5187,4.0096,4.033,4.5409,4.5195,0.0,139.3448,74.1617,141.3596,18.7848,135.1545,220.883,0.0103,0.2147,299.6565,29.9599,-999.25,-999.25,-999.25,139.3414,141.363,-999.25,-999.25,1.4389,1992.2155,-91.5813,0.3273,4.0365,2.4157,2.5638,2.7528,3.04,3.5264,2.4122,0.2535,2.5558,-0.1481,-0.3914,3.3812,22.4771,17.788,17.788,16.0482,0.0233,5.7081,9.0166,16.8012,9.0166,413.9551,9.2167,9.6338,6.2117,24.9885,19.2274,11.3303,0.4449,1.2484,1.6109,1.2904,2.8061,3.6209,1.0
 701.5,32.6797,8.9028,1.8807,1.908,1.8255,7.875,226026.8281,2349.1912,48.0206,5.097,4.5336,4.0112,4.0101,4.5622,4.4944,0.0,140.1455,74.5195,142.179,19.0378,136.0381,220.9011,0.0098,0.2065,291.6704,27.3829,-999.25,-999.25,-999.25,140.1455,142.179,-999.25,-999.25,1.4399,1957.0436,-92.2797,0.3394,4.1222,2.419,2.5662,2.7567,3.0398,3.4994,2.4116,0.2535,2.5621,-0.1098,-0.4533,3.3871,22.1014,17.4291,17.4291,15.7071,0.0143,5.3295,8.6513,16.4672,8.6513,413.3984,9.2371,8.4588,5.3925,25.0456,20.894,11.8741,0.4596,1.418,1.7199,1.2129,3.0855,3.7424,3.0
 702.0,36.2104,8.9264,1.8783,1.9089,1.8315,7.875,225989.3906,2310.9897,46.8049,5.1226,4.5328,4.0288,4.0209,4.5811,4.493,0.0,140.9418,75.0365,143.2348,19.4035,137.4331,221.0231,0.0109,0.2219,341.0519,29.7221,-999.25,-999.25,-999.25,140.9418,143.2348,-999.25,-999.25,1.6134,1947.3342,-92.5493,0.2967,3.6355,2.3021,2.4314,2.5979,2.8326,3.2025,2.291,0.2535,2.5648,-0.2399,-0.1953,3.2522,22.9058,18.1986,18.1986,16.4381,0.009,5.1646,8.4922,16.3217,8.4922,434.3928,9.2283,7.1409,4.4211,28.6875,24.5781,13.3005,0.5111,1.7549,1.944,1.1078,3.4337,3.8038,4.0
 702.5,36.3012,8.9292,1.8816,1.9096,1.8411,7.875,225951.75,2351.2334,45.6699,5.1094,4.5406,4.0328,4.0289,4.5795,4.4964,0.0,142.2531,75.5995,144.3681,19.8016,139.1921,221.4164,0.0116,0.2488,444.2091,33.8861,-999.25,-999.25,-999.25,142.2515,144.3697,-999.25,-999.25,1.4816,1949.1202,-92.5515,0.2256,2.9559,2.11,2.2142,2.3456,2.5137,2.7753,2.0997,0.2535,2.5372,-0.4264,-0.3624,3.1353,25.2969,20.5072,20.5072,18.6228,0.0038,6.8389,10.1077,17.7991,10.1077,473.931,9.2524,10.1657,5.4158,35.4289,28.1366,14.4895,0.5528,2.0898,2.1365,1.0223,3.7804,3.8648,3.0
 703.0,38.8735,8.9148,1.8861,1.91,1.8441,7.875,225913.8125,2325.1125,44.1536,5.0877,4.572,4.0096,4.0027,4.5787,4.4937,0.0,143.6305,76.1513,145.4491,20.1919,140.4415,221.9577,0.0112,0.279,558.7608,36.0564,-999.25,-999.25,-999.25,143.6271,145.4525,-999.25,-999.25,1.2667,1966.303,-92.1389,0.1758,2.5914,2.0049,2.0954,2.2068,2.329,2.5225,1.9951,0.2535,2.4934,-0.2866,0.0,3.0541,27.8226,22.9806,22.9806,20.9498,0.0,9.489,12.6648,20.1373,12.6648,498.7766,9.2934,6.5416,3.9441,41.7206,30.3885,14.9611,0.5663,2.3304,2.2274,0.9558,4.1151,3.9333,7.2
 703.5,40.6246,8.9396,1.8902,1.9129,1.8508,7.875,225875.625,2276.2078,42.9152,5.0877,4.5556,4.0577,4.0162,4.5984,4.5032,0.0,145.0016,76.7105,146.7446,20.5874,141.9826,222.434,0.0108,0.2818,518.9344,31.7997,-999.25,-999.25,-999.25,144.9945,146.7517,-999.25,-999.25,1.2099,1984.625,-91.5356,0.1658,2.621,2.0609,2.1545,2.267,2.3656,2.5312,2.0503,0.2535,2.4889,0.1722,0.0683,3.0566,27.9977,23.1534,23.1534,21.1118,0.0052,9.7659,12.932,20.3817,12.932,485.2327,9.3335,4.3842,2.5019,41.6082,29.8899,13.9889,0.5242,2.3747,2.1079,0.8877,4.5302,4.0213,3.2
 704.0,44.1478,8.9589,1.8987,1.917,1.8605,7.875,225836.7344,2299.4956,42.0633,5.0877,4.572,4.0312,4.0357,4.6339,4.5161,0.0,146.0431,76.9161,147.4501,20.7327,143.1074,222.7128,0.0093,0.2086,321.4784,22.9624,-999.25,-999.25,-999.25,146.0289,147.4643,-999.25,-999.25,0.9869,1944.2133,-91.2384,0.1667,2.8015,2.2009,2.3085,2.4348,2.5159,2.6683,2.1884,0.2535,2.5059,0.2702,-0.5903,3.1523,26.6481,21.8261,21.8261,19.8653,0.0132,8.734,11.9363,19.4711,11.9363,454.3533,9.3399,4.1347,2.4836,35.8634,28.0833,12.5858,0.469,2.3063,1.9089,0.8277,4.9174,4.0701,5.6
 704.5,49.9752,8.9897,1.9,1.9136,1.8661,7.875,225778.8438,2297.981,40.96,5.0877,4.5901,4.0705,4.0175,4.6757,4.5277,0.0,145.8116,76.7387,146.8525,20.6073,143.2008,222.9427,0.0074,0.1295,186.4393,18.5455,-999.25,-999.25,-999.25,145.7846,146.8795,-999.25,-999.25,0.7584,2000.1276,-91.2456,0.1541,2.7815,2.2341,2.3491,2.4807,2.5387,2.6666,2.2164,0.2535,2.5275,-0.0598,-0.4701,3.2403,24.6408,19.8706,19.8706,18.0216,0.0124,7.4262,10.6744,18.3173,10.6744,447.6093,9.3118,5.4679,3.2077,33.5749,27.03,11.7605,0.4356,2.2646,1.7964,0.7933,5.1994,4.1244,4.8
 705.0,50.369,9.0003,1.8827,1.9033,1.8669,7.875,225740.6563,2326.0413,40.2295,5.0892,4.5877,4.0705,4.0175,4.6986,4.5372,0.0,143.6797,76.3168,145.2535,20.3089,142.4772,222.8577,0.0082,0.1043,136.4844,22.8457,-999.25,-999.25,-999.25,143.6614,145.2717,-999.25,-999.25,1.1263,1963.2158,-91.1571,0.1354,2.5537,2.1175,2.2277,2.3506,2.3893,2.4894,2.095,0.2535,2.5548,-0.1461,-0.0907,3.2644,24.4578,19.6934,19.6934,17.8541,0.0064,5.7703,9.0766,16.8561,9.0766,472.245,9.3144,6.1489,3.2846,35.6385,27.1131,11.6942,0.4319,2.288,1.7921,0.7832,5.2976,4.1493,1.6
 705.5,45.2112,8.9558,1.8895,1.9047,1.8607,7.875,225703.0469,2293.0706,38.7155,5.1094,4.5516,4.0088,3.994,4.6773,4.5263,0.0,143.2402,75.813,144.3945,19.9526,141.0659,222.3867,0.0095,0.0943,124.3553,32.3,-999.25,-999.25,-999.25,143.2235,144.4112,-999.25,-999.25,0.8297,1951.9072,-91.0364,0.1268,2.306,1.94,2.0406,2.1505,2.1817,2.2641,1.917,0.2535,2.559,-0.1431,-0.072,3.2507,25.9459,21.1394,21.1394,19.2189,0.0028,5.5136,8.8289,16.6296,8.8289,515.4723,9.2976,5.4167,2.8109,37.8699,29.1824,12.5806,0.4636,2.4661,1.9328,0.7837,5.3194,4.169,4.8
 706.0,37.4653,8.9961,1.8881,1.9008,1.8435,7.875,225665.625,2303.5566,38.3178,5.1086,4.572,4.0513,3.9893,4.6852,4.582,0.0,143.0804,75.7934,144.0444,19.9387,139.7062,222.2023,0.0089,0.0654,150.4173,48.7505,-999.25,-999.25,-999.25,143.0558,144.0691,-999.25,-999.25,0.7064,1949.4656,-91.0864,0.1325,2.1576,1.798,1.8931,1.9959,2.0305,2.1052,1.7779,0.2535,2.5354,-0.2259,-0.0715,3.1851,27.3567,22.5217,22.5217,20.5191,0.0013,6.9478,10.2128,17.8951,10.2128,556.1678,9.2883,4.6359,2.6154,40.7133,31.1387,13.2898,0.4918,2.6607,2.0318,0.7636,5.4098,4.1311,4.8
 706.5,32.2642,8.9533,1.8711,1.8789,1.8249,7.875,225627.6094,2320.6379,37.9479,5.1202,4.4928,4.0096,3.9805,4.6781,4.5786,0.0,143.0306,76.4613,143.6248,20.4111,139.502,222.2696,0.0083,0.053,218.0327,77.7661,-999.25,-999.25,-999.25,142.9842,143.6712,-999.25,-999.25,0.4768,1971.3809,-91.4271,0.1483,2.08,1.689,1.7814,1.881,1.9273,1.9997,1.6726,0.2535,2.5191,-0.0223,-0.0894,3.0928,28.6142,23.763,23.763,21.6831,0.0021,7.9316,11.162,18.7631,11.162,592.0557,9.3163,3.9796,2.6147,42.0757,33.8192,14.323,0.5329,2.9161,2.1764,0.7463,5.4722,4.0841,0.0
 707.0,29.8693,8.7996,1.8642,1.87,1.8117,7.875,225589.6094,2330.825,36.8464,5.1071,4.4731,3.9687,3.8177,4.5779,4.4543,0.0,144.2651,77.4164,144.7208,21.0866,140.2218,222.7547,0.007,0.0387,258.5431,101.0459,-999.25,-999.25,-999.25,144.1734,144.8125,-999.25,-999.25,0.4391,1997.0752,-91.691,0.171,2.0348,1.5915,1.6812,1.778,1.8423,1.923,1.5788,0.2535,2.5232,0.1794,0.3046,3.0712,27.9397,23.0961,23.0961,21.0581,0.005,7.6856,10.9247,18.5461,10.9247,628.3329,9.3837,4.6431,2.5687,43.0303,36.138,15.1065,0.5637,3.1538,2.2875,0.7253,5.5948,4.0581,3.0
 707.5,31.4557,8.6687,1.851,1.8596,1.8019,7.875,225550.5625,2320.0645,35.9325,5.0381,4.4354,3.9078,3.7787,4.4185,4.4277,0.0,146.1929,79.0126,146.8832,22.2154,142.342,223.6204,0.0065,0.029,252.9913,111.9891,-999.25,-999.25,-999.25,146.1526,146.9235,-999.25,-999.25,0.523,1956.3058,-91.3472,0.1942,1.9595,1.475,1.5581,1.6479,1.7311,1.8341,1.4648,0.2541,2.5246,0.0858,0.4366,3.065,27.7596,22.9184,22.9184,20.8915,0.0037,7.5971,10.8393,18.468,10.8393,677.9812,9.3987,3.7724,2.0796,47.8375,37.808,15.7888,0.5924,3.3087,2.3757,0.718,5.5857,4.0107,1.0
 708.0,35.8149,8.7708,1.8427,1.8518,1.8066,7.875,225530.0,2271.4004,34.5588,5.0877,4.4857,3.9102,3.8575,4.4959,4.4753,0.0,147.7935,80.2271,148.5302,23.0743,144.9211,224.2688,0.007,0.0255,250.2029,123.6944,-999.25,-999.25,-999.25,147.7691,148.5546,-999.25,-999.25,0.5272,1919.7405,-91.1588,0.2116,1.8603,1.3605,1.4356,1.5169,1.6149,1.7497,1.352,0.2545,2.5002,0.065,0.0678,2.9989,29.0922,24.2371,24.2371,22.1268,0.0,9.0816,12.2717,19.7779,12.2718,735.0153,9.3709,4.2941,1.9559,51.11,36.8876,15.7345,0.5872,3.1953,2.3821,0.7455,5.4413,4.0565,2.0
 708.5,39.5938,8.8131,1.8449,1.8528,1.8221,7.875,225488.7656,2302.4553,33.2457,5.0877,4.5085,3.9551,3.8521,4.5164,4.5195,0.0,147.8892,80.1759,148.5272,23.0381,146.0568,224.3516,0.0068,0.0236,239.8036,118.2272,-999.25,-999.25,-999.25,147.8716,148.5448,-999.25,-999.25,0.4536,1912.3705,-91.5758,0.2397,1.8903,1.3194,1.3932,1.4736,1.5915,1.769,1.3116,0.253,2.4493,0.3329,-0.0717,2.9722,30.5302,25.6711,25.6711,23.4659,0.0101,12.1646,15.2466,22.4982,15.2466,757.9102,9.3256,3.9707,2.3172,47.7143,33.5205,14.7101,0.541,2.8607,2.2648,0.7917,5.2874,4.1861,7.0
 709.0,47.2813,8.8404,1.8489,1.8559,1.8334,7.875,225448.3125,2295.9622,31.7715,5.0993,4.5218,3.9663,3.8635,4.5188,4.5515,0.0,146.0365,78.9994,146.582,22.206,144.8006,223.8303,0.006,0.023,237.1941,98.9714,-999.25,-999.25,-999.25,146.0161,146.6024,-999.25,-999.25,0.4032,1908.5702,-92.4702,0.298,2.1499,1.3597,1.4401,1.5291,1.6783,1.917,1.3518,0.2539,2.416,0.5033,-0.2308,2.9784,28.0243,23.1796,23.1796,21.1365,0.0337,14.183,17.1941,24.2791,17.1941,735.4597,9.2486,4.4974,2.8448,40.3074,28.0547,12.697,0.4588,2.3518,1.9939,0.8479,5.1262,4.3463,4.0
 709.5,50.0418,8.8677,1.8516,1.8578,1.8389,7.875,225408.8281,2289.6526,30.8749,5.1109,4.5312,3.9687,3.8635,4.5393,4.5895,0.0,142.4007,76.9282,142.8701,20.7413,141.4509,222.7224,0.0051,0.0235,268.0118,85.3416,-999.25,-999.25,-999.25,142.3176,142.9532,-999.25,-999.25,0.4516,1902.8344,-92.9422,0.3702,2.5488,1.4189,1.5069,1.606,1.7867,2.0864,1.4117,0.2539,2.4309,0.1824,-0.297,2.8859,26.1969,21.3845,21.3845,19.4497,0.0493,13.2778,16.3207,23.4804,16.3207,704.7653,9.1354,5.2566,3.6219,32.3865,23.6561,10.976,0.3875,1.9563,1.7668,0.9031,5.0485,4.5594,8.0
 710.0,38.7252,8.9111,1.8592,1.8666,1.8389,7.875,225370.7344,2377.4241,29.3824,5.1528,4.5289,3.9679,3.8763,4.5771,4.6303,0.0,138.3464,74.44,138.8826,18.9816,136.9049,221.3891,0.0046,0.0233,281.333,78.8074,-999.25,-999.25,-999.25,138.2055,139.0234,-999.25,-999.25,0.5991,1845.4705,-92.8639,0.3742,2.5711,1.418,1.5043,1.6025,1.7902,2.1076,1.4139,0.2552,2.4612,-0.364,-0.2206,2.795,25.4898,20.6949,20.6949,18.7999,0.0472,11.4414,14.5487,21.86,14.5487,705.2115,9.0321,7.7862,4.7191,29.2817,22.2878,10.4892,0.3602,1.8397,1.7363,0.9438,5.1072,4.8202,1.0
 710.5,26.8841,8.8959,1.8648,1.8709,1.819,7.875,225335.0313,2380.9351,28.0776,5.2001,4.4739,3.9551,3.8581,4.5472,4.6534,0.0,135.229,72.5356,135.6634,17.6348,131.9765,220.4861,0.0043,0.0265,318.9349,73.35,-999.25,-999.25,-999.25,134.9823,135.91,-999.25,-999.25,0.6895,1815.8375,-92.292,0.3264,2.2109,1.3244,1.3964,1.4787,1.6392,1.9128,1.3232,0.2554,2.4696,-0.545,-0.3613,2.8223,27.0067,22.1777,22.1777,20.196,0.0385,10.9354,14.0604,21.4136,14.0604,755.0731,9.1156,5.3895,3.6604,31.5211,24.3386,11.4355,0.3843,2.0357,1.9327,0.9494,5.2967,5.0288,3.0
 711.0,22.997,8.792,1.8616,1.86,1.7899,7.875,225299.6563,2336.4353,27.0604,5.1869,4.4535,3.9086,3.7363,4.4651,4.6255,0.0,133.4688,71.7113,133.362,17.0519,128.3734,220.0448,0.0038,0.0341,406.4588,67.2885,-999.25,-999.25,-999.25,132.967,133.8637,-999.25,-999.25,0.6743,1788.797,-91.3442,0.3157,2.0972,1.2789,1.3419,1.4148,1.5588,1.8091,1.2789,0.2542,2.4541,-0.2814,-0.0615,2.8359,29.3925,24.5357,24.5357,22.4059,0.0301,11.8708,14.963,22.2389,14.963,781.9394,9.1557,4.686,2.9877,35.7983,28.711,13.4871,0.4506,2.4246,2.2921,0.9453,5.3805,5.0863,2.4
 711.5,23.8139,8.6034,1.8509,1.8453,1.7673,7.875,225246.5625,2277.8938,25.917,5.0877,4.4299,3.8052,3.6481,4.3206,4.5188,0.0,132.6391,71.6753,132.24,17.0264,126.6567,219.8347,0.0038,0.0421,447.0654,61.1392,-999.25,-999.25,-999.25,132.0338,132.8454,-999.25,-999.25,0.6159,1894.9335,-90.1419,0.3189,2.146,1.3014,1.3615,1.4324,1.5743,1.8265,1.3014,0.255,2.4275,-0.1144,0.4394,2.7792,29.9941,25.1352,25.1352,22.9659,0.0269,13.4878,16.5233,23.6657,16.5233,768.4235,9.1868,4.6161,2.6297,41.1576,32.7937,15.5961,0.5252,2.7489,2.6311,0.9571,5.2341,5.0097,2.4
 712.0,25.879,8.5419,1.8293,1.8261,1.7569,7.875,225209.75,2282.459,24.4827,5.1512,4.3718,3.7859,3.6204,4.221,4.4753,0.0,131.7468,72.0337,131.5137,17.2799,126.5195,219.8816,0.0039,0.0421,423.323,59.0903,-999.25,-999.25,-999.25,131.2817,131.9788,-999.25,-999.25,0.5377,1940.3557,-88.9389,0.3277,2.3449,1.4002,1.463,1.5394,1.6947,1.976,1.4002,0.2549,2.4009,-0.2951,0.3631,2.7604,30.1956,25.3364,25.3364,23.1537,0.0282,15.0962,18.0752,25.0848,18.0752,714.179,9.1748,5.0417,2.6757,46.1271,34.094,16.2938,0.5462,2.8382,2.7607,0.9727,5.1965,5.0544,1.6
 712.5,27.9308,8.6023,1.8137,1.8105,1.7624,7.875,225173.4844,2288.9412,22.9639,5.1869,4.4276,3.8276,3.6278,4.2052,4.5318,0.0,129.8167,71.5833,129.5768,16.9613,126.1157,219.6794,0.004,0.0381,332.849,50.1959,-999.25,-999.25,-999.25,129.2397,130.1538,-999.25,-999.25,0.7177,1968.6749,-88.2765,0.3433,2.731,1.5867,1.658,1.7484,1.9373,2.2883,1.5867,0.2543,2.4138,-0.2594,-0.008,2.8498,30.337,25.4777,25.4777,23.2855,0.0308,14.3181,17.3244,24.3983,17.3244,630.2501,9.1268,4.9722,2.6227,44.5114,31.594,15.2298,0.5114,2.6035,2.5762,0.9895,5.091,5.0377,1.6
 713.0,28.7827,8.6617,1.8098,1.8096,1.7742,7.875,225138.0,2307.5259,20.3389,5.1931,4.4307,3.8966,3.6447,4.2399,4.58,0.0,127.7065,70.5675,127.6569,16.2429,125.1532,219.2729,0.003,0.032,236.4036,32.2001,-999.25,-999.25,-999.25,126.9492,128.4141,-999.25,-999.25,1.161,1958.7711,-88.4762,0.3597,3.1607,1.7836,1.8616,1.9648,2.191,2.6323,1.7836,0.2542,2.4694,0.2203,-0.3558,2.9708,25.2081,20.421,20.421,18.5414,0.0348,10.9446,14.0693,21.4217,14.0694,560.6664,9.1123,7.9272,5.6836,35.8277,27.4445,13.2817,0.4427,2.2587,2.2624,1.0017,5.1026,5.111,2.4
 713.5,27.2879,8.7187,1.8134,1.8305,1.7904,7.875,225103.9844,2307.583,17.8709,5.2125,4.4802,3.9407,3.6481,4.2818,4.5929,0.0,125.9504,69.4588,127.1019,15.4589,124.3068,218.878,0.002,0.0228,155.7107,20.3383,-999.25,-999.25,-999.25,125.6128,127.4395,-999.25,-999.25,1.4581,1940.6436,-89.2718,0.3601,3.2867,1.8536,1.9243,2.0225,2.2522,2.732,1.8536,0.2535,2.4997,0.3281,-0.171,2.9193,22.8288,18.1248,18.1248,16.368,0.0372,9.1111,12.3002,19.8039,12.3002,539.5023,9.1696,9.2668,6.4163,27.4661,22.3613,11.076,0.3717,1.8121,1.8745,1.0345,4.8748,5.0428,2.0
 714.0,25.7391,8.7681,1.815,1.8385,1.7932,7.875,225070.4219,2361.0083,15.3698,5.2303,4.5501,3.9695,3.6609,4.27,4.6235,0.0,126.0834,69.4672,127.6838,15.4648,124.5328,218.7488,0.0013,0.0151,99.2073,12.9076,-999.25,-999.25,-999.25,125.9349,127.8324,-999.25,-999.25,1.5123,1960.1522,-90.2018,0.3522,3.3205,1.8989,1.9594,2.0486,2.2758,2.7936,1.8989,0.2544,2.4929,0.0,0.1473,2.7025,22.6633,17.9663,17.9663,16.2175,0.0349,9.5188,12.6936,20.1636,12.6936,526.6287,9.0787,9.535,6.5001,22.5349,18.6998,9.4285,0.3255,1.4896,1.5526,1.0423,4.5761,4.7695,0.0
 714.5,27.3088,8.7754,1.8191,1.84,1.7898,7.875,225036.0156,2437.7549,12.9014,5.2248,4.532,3.9888,3.6723,4.2842,4.6242,0.0,129.0415,70.9308,130.4942,16.4999,126.9562,219.26,0.0,0.0117,72.9876,7.4185,-999.25,-999.25,-999.25,128.9762,130.5595,-999.25,-999.25,1.2385,1972.0265,-91.0598,0.3127,2.9855,1.8298,1.8738,1.9436,2.1392,2.6156,1.8298,0.2538,2.4738,-0.066,-0.0886,2.5528,21.9956,17.3281,17.3281,15.611,0.0301,10.6792,13.8132,21.1875,13.8133,546.4958,9.0043,12.8433,6.6031,21.6829,16.9081,8.6637,0.3083,1.3273,1.3832,1.042,4.3057,4.4867,0.8
 715.0,37.1014,8.75,1.8226,1.8404,1.7896,7.875,225018.2344,2450.6272,10.896,5.2241,4.5328,3.9687,3.675,4.1925,4.6568,0.0,134.6906,73.8969,135.978,18.5975,132.3079,220.3517,0.0,0.0092,55.9874,6.242,-999.25,-999.25,-999.25,134.6601,136.0085,-999.25,-999.25,1.0196,2006.5529,-91.5887,0.2751,2.5332,1.6564,1.6827,1.7294,1.8747,2.2445,1.6564,0.2547,2.4426,0.0788,-0.1029,2.5217,24.3351,19.5747,19.5747,17.7419,0.0271,12.571,15.6386,22.8567,15.6386,603.7219,9.0071,10.579,5.2697,24.4023,16.7022,8.6941,0.319,1.2931,1.3423,1.038,4.0536,4.2077,0.0
 715.5,49.4131,8.7498,1.8241,1.8403,1.8035,7.875,224980.125,2442.7917,9.4351,5.2907,4.5014,3.9094,3.6972,4.1878,4.6629,0.0,141.6612,77.6475,142.897,21.25,140.1841,221.6019,0.0,0.0088,50.1215,6.1818,-999.25,-999.25,-999.25,141.6612,142.897,-999.25,-999.25,0.8832,1987.3085,-91.7047,0.2448,2.2988,1.5816,1.5971,1.6307,1.7458,2.0494,1.5816,0.2539,2.4234,0.1199,0.3282,2.5354,26.3975,21.5807,21.5807,19.6345,0.0245,13.7309,16.7579,23.8802,16.7579,632.2531,9.0695,7.0453,4.3554,27.2332,18.4345,9.8326,0.3656,1.3967,1.495,1.0703,3.8201,4.0888,0.0
 716.0,55.0722,8.8491,1.8355,1.8497,1.8301,7.875,224939.25,2358.3811,8.0436,5.3178,4.5563,3.9551,3.7545,4.2273,4.7362,0.0,148.7776,81.0283,149.9151,23.6409,148.4472,222.7575,0.0,0.0094,45.9219,6.1497,-999.25,-999.25,-999.25,148.7776,149.9151,-999.25,-999.25,0.7738,1979.3279,-91.2069,0.209,2.3401,1.708,1.7167,1.7457,1.8534,2.1438,1.708,0.2564,2.4352,0.0762,0.3579,2.588,27.0536,22.2238,22.2238,20.2392,0.0177,13.0161,16.0682,23.2495,16.0682,585.4702,9.1399,6.5154,3.6162,29.2897,20.2828,11.2069,0.4249,1.4777,1.665,1.1268,3.4775,3.9184,1.6
 716.5,60.7496,9.0008,1.8551,1.8679,1.8529,7.875,224897.0625,2254.8804,6.5734,5.4029,4.6129,4.0545,3.8386,4.3063,4.7871,0.0,154.1209,83.0594,155.174,25.0773,153.9966,223.7165,0.0012,0.0097,41.5905,6.8685,-999.25,-999.25,-999.25,154.119,155.1759,-999.25,-999.25,0.6873,1989.658,-90.1138,0.1787,2.9082,2.2288,2.2288,2.2618,2.3914,2.7405,2.2288,0.2543,2.4711,0.1284,0.1031,2.6914,26.2376,21.4243,21.4243,19.4872,0.0,10.8443,13.9725,21.3332,13.9725,448.6772,9.1788,6.6573,5.3323,30.338,21.0082,12.1035,0.4663,1.4584,1.7632,1.209,3.1274,3.781,0.0
 717.0,69.7579,9.066,1.8819,1.8952,1.8736,7.875,224854.2656,2227.647,5.5443,5.3828,4.6513,4.0905,3.8965,4.3443,4.8325,0.0,157.8362,83.8769,158.9546,25.6555,157.1696,224.1799,0.0016,0.0104,45.0438,8.6174,-999.25,-999.25,-999.25,157.8259,158.9649,-999.25,-999.25,0.7186,1957.4698,-88.3935,0.1515,4.2703,3.4163,3.3891,3.4335,3.6141,4.0773,3.4163,0.2539,2.5214,0.1811,-0.0012,2.8737,23.8967,19.1514,19.1514,17.3413,-0.0213,7.7933,11.0286,18.6411,11.0286,292.7185,9.1999,18.0095,14.3066,27.9327,21.6421,12.991,0.5099,1.4229,1.8477,1.2986,2.7903,3.6234,0.0
 717.5,77.0682,9.1217,1.9084,1.9191,1.8866,7.875,224812.3906,2390.1003,4.7046,5.3975,4.6913,4.1137,3.9187,4.3632,4.8807,0.0,159.671,83.6863,160.5702,25.5207,157.874,224.0646,0.0017,0.0128,61.2918,9.8067,-999.25,-999.25,-999.25,159.596,160.6452,-999.25,-999.25,0.6565,1983.9806,-86.194,0.0808,4.8679,4.3366,4.2644,4.295,4.4313,4.7329,4.3366,0.2545,2.5715,0.037,-0.3608,3.0889,22.5455,17.8535,17.8535,16.1104,-0.0215,4.7602,8.102,15.9649,8.102,230.5961,9.1804,24.733,23.1857,25.7486,24.7271,15.2426,0.6068,1.5665,2.1277,1.3582,2.5816,3.5064,0.0
 718.0,76.0657,9.1885,1.9313,1.9364,1.8927,7.875,224749.3594,2521.5806,3.2837,5.3998,4.7438,4.1482,3.9496,4.4161,4.9078,0.0,160.5572,83.1564,160.9886,25.146,157.3773,223.819,0.0015,0.0173,92.1685,9.7003,-999.25,-999.25,-999.25,160.3966,161.1492,-999.25,-999.25,0.4691,1957.101,-83.6388,0.0282,3.3077,3.1801,3.1361,3.1383,3.1569,3.248,3.1801,0.2562,2.5887,-0.0992,-0.3256,3.1637,23.1169,18.401,18.401,16.6302,-0.0043,3.7147,7.0931,15.0424,7.0931,314.4604,9.1528,21.4073,15.8133,31.9886,30.2274,19.1016,0.7654,1.8455,2.6426,1.4319,2.411,3.4524,0.0
 718.5,70.5181,9.2021,1.9515,1.9503,1.8967,7.875,224708.3906,2520.95,1.6651,5.4261,4.7438,4.189,3.9328,4.4075,4.9071,0.0,160.3951,82.2124,160.3046,24.4784,155.9259,223.5839,0.0012,0.0305,171.8091,9.0966,-999.25,-999.25,-999.25,160.0092,160.6904,-999.25,-999.25,0.4262,1982.9437,-81.2015,-0.0048,2.2008,2.2153,2.1877,2.1851,2.1828,2.1856,2.2153,0.2569,2.5554,-0.0122,0.3518,3.018,23.5733,18.8398,18.8398,17.0462,0.0044,5.7312,9.0389,16.8216,9.0389,451.4132,9.2075,9.2917,4.1815,48.2381,37.2508,23.9142,0.9626,2.2228,3.2881,1.4793,2.3092,3.416,1.6
 719.0,71.2209,9.1297,1.9669,1.9587,1.896,7.875,224668.4375,2511.1294,0.2187,5.3913,4.6992,4.133,3.9066,4.3664,4.8929,0.0,160.073,81.3997,159.4061,23.9036,154.3187,222.9732,0.0011,0.0539,300.9719,8.4447,-999.25,-999.25,-999.25,159.2758,160.2033,-999.25,-999.25,0.5825,1953.1624,-79.3464,0.003,1.8055,1.7981,1.776,1.7724,1.7649,1.8074,1.7981,0.2565,2.5223,0.2803,0.6887,2.819,25.7552,20.9535,20.9535,19.0437,0.0076,7.7368,10.9741,18.5913,10.9741,556.1402,9.267,3.0571,1.7371,58.7204,43.4867,28.1486,1.132,2.5822,3.8753,1.5007,2.2812,3.4235,1.6
 719.5,73.9048,9.2073,1.9657,1.9484,1.8836,7.875,224627.9531,2480.1213,358.9358,5.4625,4.7399,4.1602,3.9086,4.424,4.9268,0.0,160.5718,81.7024,159.1706,24.1177,153.8812,222.9727,0.0014,0.0549,295.1565,10.7309,-999.25,-999.25,-999.25,159.0972,160.6453,-999.25,-999.25,0.9724,1938.9735,-77.6756,0.004,1.8571,1.8467,1.823,1.8178,1.8023,1.86,1.8467,0.2563,2.5387,0.4764,0.5227,2.7887,26.6771,21.8545,21.8545,19.8921,0.0148,6.7475,10.0195,17.7184,10.0195,541.4976,9.3708,2.879,1.807,61.3069,48.1713,31.5051,1.2649,2.8342,4.347,1.5338,2.2406,3.4365,4.0
 720.0,69.7945,9.1916,1.9578,1.9443,1.8788,7.875,224587.0938,2487.8066,357.709,5.4122,4.6944,4.1722,3.9348,4.4209,4.9403,0.0,161.6501,82.5889,160.5594,24.7446,155.1514,223.4799,0.0018,0.0428,219.8009,14.3829,-999.25,-999.25,-999.25,160.4602,161.7494,-999.25,-999.25,0.8043,1959.6809,-75.8836,-0.013,2.0628,2.0999,2.0705,2.0626,2.0316,2.0645,2.0999,0.2573,2.5746,0.2987,-0.0894,2.8911,25.9416,21.1352,21.1352,19.2149,0.0223,4.5707,7.9191,15.7977,7.9191,476.221,9.3855,3.5557,2.1291,66.9036,53.6579,35.7727,1.4216,3.0803,5.0055,1.625,2.1668,3.5211,3.2
 720.5,63.3135,9.2246,1.9457,1.9367,1.8738,7.875,224545.7656,2479.9265,356.6075,5.4408,4.7227,4.1906,3.9691,4.3901,4.9607,0.0,163.6298,84.1193,162.9054,25.8269,157.5995,224.4355,0.0024,0.0354,165.1556,18.8337,-999.25,-999.25,-999.25,162.705,163.8302,-999.25,-999.25,0.6942,1969.343,-73.968,-0.0392,2.233,2.3546,2.3226,2.3116,2.2618,2.2353,2.3546,0.2562,2.5965,0.1184,-0.1987,2.9508,24.0438,19.2934,19.2934,17.4757,0.0264,3.2416,6.6366,14.6249,6.6366,424.7025,9.4381,3.776,2.2567,71.7955,56.8495,38.6918,1.5292,3.1449,5.4539,1.7342,2.0566,3.5666,0.0
 721.0,66.1298,9.2538,1.9374,1.9356,1.8691,7.875,224502.9688,2453.6318,354.9594,5.447,4.7313,4.2034,3.994,4.4075,4.9783,0.0,167.3271,86.3803,167.2092,27.4259,161.4457,225.8709,0.0032,0.043,181.2099,25.6608,-999.25,-999.25,-999.25,166.7955,167.7407,-999.25,-999.25,0.569,1971.2775,-72.5369,-0.0636,2.3979,2.611,2.5772,2.5629,2.4959,2.4031,2.611,0.2572,2.6088,0.2527,0.1557,2.9327,22.9406,18.232,18.232,16.4698,0.0274,2.4989,5.92,13.9696,5.92,382.9998,9.4513,3.8666,2.4235,76.1253,59.2456,41.187,1.6244,3.1237,5.8219,1.8638,1.923,3.5841,1.0
 721.5,75.2563,9.3016,1.9387,1.9419,1.8732,7.875,224480.6875,2474.3967,352.3477,5.4764,4.7282,4.2338,4.0363,4.4335,4.9966,0.0,171.4771,88.4491,171.791,28.889,165.6986,226.99,0.0032,0.0342,176.6574,31.0473,-999.25,-999.25,-999.25,171.1917,172.0763,-999.25,-999.25,0.5207,1949.5229,-71.7452,-0.0762,2.5498,2.8217,2.7877,2.7705,2.6927,2.5574,2.8217,0.2563,2.6107,0.362,-0.0976,2.9016,22.1722,17.4967,17.4967,15.7713,0.0267,2.3822,5.8074,13.8666,5.8074,354.4007,9.3911,5.0097,2.9095,78.1309,57.4804,40.7313,1.5966,2.9079,5.804,1.996,1.8213,3.6353,4.0
 722.0,84.7916,9.3607,1.9483,1.9515,1.882,7.875,224435.5313,2453.8042,350.1669,5.4563,4.7885,4.2594,4.0605,4.4904,5.0271,0.0,175.1853,89.9144,175.4936,29.9253,169.5178,227.6849,0.0029,0.027,154.282,28.9767,-999.25,-999.25,-999.25,174.9319,175.7469,-999.25,-999.25,0.4697,1944.1334,-71.4003,-0.071,2.4834,2.7299,2.7003,2.683,2.6121,2.4904,2.7299,0.2566,2.6026,0.047,-0.1752,2.8831,22.3765,17.6918,17.6918,15.9568,0.0245,2.8698,6.2778,14.2968,6.2778,366.3092,9.389,4.5755,2.8337,74.5122,56.0758,40.537,1.5811,2.7204,5.8136,2.137,1.7206,3.6769,4.0
 722.5,87.5754,9.4036,1.9595,1.9614,1.8947,7.875,224389.5156,2464.2781,348.3141,5.4841,4.823,4.2922,4.0706,4.499,5.042,0.0,176.4981,90.1072,176.6866,30.0616,172.7041,227.8503,0.0021,0.02,122.5541,21.8454,-999.25,-999.25,-999.25,176.1515,177.0332,-999.25,-999.25,0.5069,1940.4019,-71.2293,-0.0516,2.3349,2.5029,2.4791,2.4633,2.4129,2.3394,2.5029,0.2561,2.5908,-0.4799,0.2528,2.8481,23.2533,18.5321,18.5321,16.7545,0.0199,3.5866,6.9695,14.9293,6.9695,399.5373,9.4049,5.3689,3.0132,70.8792,54.4415,39.887,1.5524,2.5816,5.7361,2.222,1.6629,3.6949,0.0
 723.0,84.7375,9.3352,1.9724,1.97,1.913,7.875,224343.1719,2423.3118,346.1711,5.4447,4.7729,4.2402,4.0491,4.4588,5.04,0.0,174.7878,88.6947,174.5861,29.0627,174.9302,227.4441,0.0014,0.0198,130.4004,14.1718,-999.25,-999.25,-999.25,174.1349,175.239,-999.25,-999.25,0.645,1957.4698,-70.9434,-0.0264,2.1839,2.2639,2.2452,2.2313,2.2067,2.1855,2.2639,0.257,2.571,-0.6465,0.5287,2.7762,23.8337,19.0906,19.0906,17.2838,0.0156,4.7887,8.1294,15.99,8.1294,441.7144,9.4449,4.2788,2.3086,69.0582,52.8778,39.1669,1.5238,2.4645,5.6354,2.2866,1.6173,3.6982,1.0
 723.5,83.436,9.3294,1.9966,1.9872,-999.25,7.875,224297.75,2404.1533,344.6299,5.488,4.7462,4.2354,4.0511,4.4438,5.0237,0.0,169.6386,85.0611,168.7902,26.493,-999.25,226.1854,0.0012,0.0197,125.1131,10.066,-999.25,-999.25,-999.25,168.3858,170.043,-999.25,-999.25,0.9951,1941.7379,-70.4884,-0.0046,2.0169,2.0296,2.015,2.0033,2.0013,2.0161,2.0296,0.2571,2.5516,-0.3246,0.3246,2.7109,24.9283,20.1492,20.1492,18.2849,0.0145,5.9635,9.263,17.0266,9.2631,492.7092,9.4673,3.15,1.859,67.0731,52.4683,39.2081,1.5286,2.4079,5.6264,2.3366,1.5753,3.6808,0.0
 724.0,83.2453,9.3146,2.0157,2.0106,-999.25,7.875,224255.4063,2385.627,342.9719,5.4222,4.7877,4.1954,4.0834,4.413,5.042,0.0,160.9208,79.8894,160.3698,22.8355,-999.25,224.2368,0.0015,0.0173,95.0205,11.0828,-999.25,-999.25,-999.25,159.7789,161.5117,-999.25,-999.25,1.0795,1962.2722,-70.3377,0.0083,1.9538,1.9314,1.9183,1.9075,1.9191,1.9526,1.9314,0.2576,2.5458,0.0227,-0.3384,2.7347,25.7411,20.9397,20.9397,19.0307,0.0139,6.3129,9.6001,17.3349,9.6001,517.7714,9.498,2.8683,1.7225,67.0445,53.5886,40.2478,1.5588,2.4425,5.8243,2.3845,1.5669,3.7363,3.0
 724.5,72.0295,9.3549,2.021,2.0302,-999.25,7.875,224197.0938,2351.5315,341.5645,5.43,4.805,4.1914,4.1217,4.4335,5.0833,0.0,149.6642,74.073,150.1957,18.7221,-999.25,221.8125,0.0016,0.0154,75.4131,10.3625,-999.25,-999.25,-999.25,149.1794,150.6805,-999.25,-999.25,1.0133,1959.7844,-70.8757,0.0129,2.0151,1.9794,1.9644,1.9529,1.9733,2.015,1.9794,0.2571,2.5461,-0.1746,-0.4683,2.8144,26.0284,21.2199,21.2199,19.2948,0.0118,6.298,9.5858,17.3218,9.5858,505.2158,9.5039,3.1041,1.8403,71.6375,57.4438,43.4565,1.6684,2.5788,6.3585,2.4657,1.5457,3.8111,0.0
 725.0,43.9447,9.4171,2.0147,2.0306,-999.25,7.875,224164.2969,2384.5369,339.9346,5.4207,4.8324,4.229,4.1573,4.484,5.128,0.0,136.5076,67.752,137.4694,14.2518,-999.25,218.7627,0.0014,0.0236,102.3466,8.072,-999.25,-999.25,-999.25,136.2614,137.7155,-999.25,-999.25,1.0745,1937.4653,-71.5863,0.0138,2.1509,2.1102,2.0896,2.0758,2.1026,2.151,2.1102,0.257,2.5446,-0.6024,0.2253,2.8543,26.6025,21.7814,21.7814,19.8233,0.007,6.3865,9.6711,17.3998,9.6711,473.8925,9.4954,3.7701,2.2098,80.6852,62.0087,47.5023,1.8024,2.6996,7.0516,2.6121,1.4978,3.9124,2.0
 725.5,21.0743,9.3781,2.0137,2.0373,-999.25,7.875,224134.5,2357.5083,338.1801,5.4346,4.8034,4.1898,4.1646,4.4248,5.1172,0.0,125.504,62.3359,126.9076,10.4214,-999.25,215.8624,0.0013,0.0402,162.2909,7.4122,-999.25,-999.25,-999.25,125.3876,127.0239,-999.25,-999.25,1.3041,1966.4751,-71.8563,0.0136,2.2675,2.2251,2.1959,2.1792,2.2092,2.2678,2.2251,0.2565,2.5402,-0.5424,0.4837,2.8425,27.1642,22.3324,22.3324,20.3413,0.0027,6.6534,9.9287,17.6353,9.9287,449.4211,9.4808,3.6766,2.1015,86.3301,65.1482,50.5887,1.9036,2.728,7.5853,2.7805,1.4331,3.9847,2.0
 726.0,13.0636,9.3445,2.0119,2.0359,-999.25,7.875,224106.9219,2386.4873,335.817,5.4006,4.7501,4.1794,4.1767,4.4075,5.1192,0.0,118.4211,58.9521,119.847,8.0284,-999.25,213.9562,0.0011,0.0641,283.3493,6.9658,-999.25,-999.25,-999.25,118.4211,119.847,-999.25,-999.25,1.1919,2005.4135,-71.6327,0.0132,2.3476,2.3051,2.2652,2.2458,2.2744,2.3485,2.3051,0.2562,2.5363,-0.125,0.2165,2.789,27.3818,22.5463,22.5463,20.5423,0.0062,6.8916,10.1586,17.8456,10.1586,433.8272,9.5029,3.7806,2.1722,87.854,68.1122,53.4216,1.9913,2.7679,8.0998,2.9263,1.39,4.0677,1.0
 726.5,11.0193,9.3504,1.9932,2.0217,-999.25,7.875,224080.2813,2390.5024,334.1536,5.375,4.787,4.1554,4.2271,4.3782,5.1287,0.0,116.5318,58.7055,118.2433,7.8539,-999.25,213.028,0.001,0.1115,429.845,6.1409,-999.25,-999.25,-999.25,116.5318,118.2433,-999.25,-999.25,1.4304,2008.0846,-71.042,0.0105,2.4792,2.4435,2.3888,2.3652,2.3885,2.4806,2.4435,0.2573,2.5323,0.2301,-0.041,2.7648,27.5423,22.7043,22.7043,20.6905,0.0118,7.1347,10.3931,18.06,10.3931,409.2422,9.4692,3.4631,1.9495,90.9588,69.9941,55.8275,2.0509,2.7048,8.6069,3.1821,1.3188,4.1966,2.0
 727.0,12.8296,9.3709,1.9208,1.9542,-999.25,7.875,224049.7969,2395.5159,332.6455,5.3874,4.7823,4.173,4.2566,4.3822,5.1314,0.0,119.7917,62.6586,121.9121,10.6496,-999.25,213.8795,0.0016,0.199,623.8694,5.4315,-999.25,-999.25,-999.25,119.7917,121.9121,-999.25,-999.25,1.7212,2029.1261,-70.5279,-0.0206,2.6447,2.7201,2.643,2.613,2.6196,2.6467,2.7201,0.2561,2.5537,0.2165,-0.0587,2.8892,25.27,20.4812,20.4812,18.5982,0.0166,5.835,9.1391,16.9133,9.1391,367.6345,9.4817,3.7321,2.0638,93.2455,68.0503,54.9485,2.0013,2.5328,8.5537,3.3772,1.2656,4.274,1.0
 727.5,21.852,9.4024,1.8896,1.9357,-999.25,7.875,224017.8125,2392.6702,331.2318,5.3712,4.8042,4.2122,4.2761,4.4075,5.1361,0.0,127.9112,68.009,130.9628,14.4335,-999.25,215.8045,0.0028,0.2188,464.7469,6.1361,-999.25,-999.25,-999.25,127.9112,130.9628,-999.25,-999.25,2.3884,1988.9325,-70.527,-0.0401,3.7762,3.9867,3.8424,3.7905,3.7279,3.7874,3.9867,0.2577,2.6673,-0.17,0.0886,3.2816,18.1279,13.6821,13.6821,12.1258,0.0268,-1.0514,2.4943,10.837,2.4943,250.8326,9.5065,3.2523,2.2533,86.7745,58.1423,47.6535,1.7181,2.0802,7.5013,3.606,1.2108,4.3661,2.0
 728.0,41.046,9.4503,1.8516,1.8861,-999.25,7.875,223981.2031,2489.8491,330.2873,5.3952,4.8261,4.2322,4.3123,4.443,5.1422,0.0,139.1211,75.3633,141.5902,19.6346,-999.25,218.884,0.0046,0.2352,387.3959,8.3109,-999.25,-999.25,-999.25,139.1201,141.5911,-999.25,-999.25,1.83,1940.0677,-71.2129,-0.1677,7.8115,9.6655,9.1715,8.9765,8.4406,7.9228,9.6655,0.2567,2.8306,-0.445,0.0492,3.9227,7.963,4.513,4.513,3.194,0.0271,-10.9472,-7.0543,2.1054,-7.0543,103.4609,9.5915,17.0893,16.8501,61.198,40.9651,34.0007,1.2242,1.4207,5.3599,3.7728,1.1605,4.3782,1.0
 728.5,70.4132,9.5134,1.8429,1.869,-999.25,7.875,223960.6406,2491.1116,329.5582,5.4052,4.8465,4.2842,4.3794,4.4509,5.174,0.0,151.861,82.4965,153.8445,24.6793,-999.25,222.8914,0.0063,0.2174,306.2952,11.6057,-999.25,-999.25,-999.25,151.8588,153.8467,-999.25,-999.25,1.3945,1843.374,-72.3915,-0.3716,30.5024,46.4735,43.8549,42.7242,39.3965,33.1883,46.5204,0.2577,2.9247,-0.2323,0.1414,4.4277,2.7832,0.0776,0.0776,-1.2267,0.0157,-16.6459,-12.5531,-2.9228,-12.553,21.5176,9.6427,32.5832,38.1264,30.2408,24.287,20.3285,0.7345,0.8308,3.1926,3.8429,1.1311,4.3467,0.0
 729.0,95.8109,9.6368,1.852,1.8695,-999.25,7.875,223915.6719,2494.4727,328.6497,5.457,4.9249,4.3586,4.4672,4.5227,5.1801,0.0,164.4984,88.7589,165.9124,29.1081,-999.25,227.0047,0.0077,0.1762,224.7091,14.473,-999.25,-999.25,-999.25,164.4935,165.9173,-999.25,-999.25,0.9418,1822.5405,-73.6938,-1.0218,121.4397,263.4137,249.7059,242.297,223.3479,184.2996,265.0675,0.2576,2.9459,0.2548,-0.0996,4.6262,1.3311,-1.1365,-1.1365,-2.4498,0.0147,-17.9307,-13.7928,-4.0565,-13.7928,3.7963,9.6847,45.014,49.106,14.6007,13.2299,11.1523,0.4077,0.4427,1.729,3.458,1.086,4.2413,1.6
 729.5,103.7292,9.6677,1.8936,1.9038,-999.25,7.875,223868.0625,2515.3518,327.8959,5.4547,4.9483,4.3937,4.4799,4.5416,5.1848,0.0,176.4595,93.0704,177.3214,32.1573,-999.25,230.6061,0.0067,0.1136,142.8915,14.3836,-999.25,-999.25,-999.25,176.4078,177.3731,-999.25,-999.25,0.5983,1918.0714,-75.0496,-0.733,88.4528,172.0343,162.2043,157.1476,143.6619,117.3317,172.7864,0.256,2.9485,0.4884,-0.2526,4.8004,1.1614,-1.2775,-1.2775,-2.5923,0.0166,-18.0884,-13.945,-4.1957,-13.945,5.8128,9.7102,44.14,53.7058,10.9962,9.5059,8.0077,0.2962,0.32,1.2248,2.4496,1.0802,4.1346,0.8
 730.0,101.6874,9.7551,1.9473,1.9535,-999.25,7.875,223819.6875,2530.4255,326.8298,5.5483,4.975,4.4593,4.5315,4.5598,5.1916,0.0,185.7075,95.2704,186.2722,33.7132,-999.25,233.2452,0.0051,0.0767,109.1005,14.0805,-999.25,-999.25,-999.25,185.6097,186.3701,-999.25,-999.25,0.422,1971.5653,-76.4496,-0.4512,42.3894,69.0154,65.0657,63.1456,57.9539,47.8756,69.1418,0.2565,2.9509,0.3149,0.0987,4.9824,1.9137,-0.651,-0.651,-1.9599,0.0149,-18.2393,-14.0906,-4.3288,-14.0905,14.4895,9.7465,37.0587,44.5341,10.7375,10.4071,8.7191,0.3273,0.3566,1.3113,2.6226,1.0897,4.0071,0.0
 730.5,102.4026,9.765,1.992,1.9979,-999.25,7.875,223771.8281,2537.0217,326.4391,5.4679,4.9867,4.496,4.5335,4.6174,5.1936,1.0,192.4462,96.5757,193.0191,34.6363,-999.25,235.4358,0.0036,0.0643,97.1095,11.2143,-999.25,-999.25,-999.25,192.2503,193.215,-999.25,-999.25,0.495,2015.7549,-77.6608,-0.2645,12.3716,17.0122,16.0729,15.6336,14.5601,12.7671,17.0201,0.2573,2.9198,-0.0433,-0.2231,4.9377,4.1667,1.2463,1.2463,-0.0548,0.0132,-16.3509,-12.2685,-2.6626,-12.2684,58.7812,9.7477,44.5171,52.0163,14.3821,16.2068,13.5455,0.514,0.5593,2.0107,3.5949,1.0882,3.9121,1.6
 731.0,110.8838,9.8498,2.0163,2.0192,-999.25,7.875,223722.875,2536.0012,325.7473,5.4547,5.0031,4.5966,4.6367,4.645,5.2133,1.0,195.0916,96.744,195.3694,34.7553,-999.25,236.8573,0.002,0.0633,98.4269,6.1911,-999.25,-999.25,-999.25,194.6982,195.7627,-999.25,-999.25,0.5396,1989.4286,-78.5479,-0.1396,5.2483,6.2817,5.9718,5.822,5.5833,5.2967,6.2828,0.2565,2.8099,-0.3241,-0.7437,4.4515,8.7547,5.2053,5.2053,3.8776,0.0088,-9.6919,-5.843,3.213,-5.843,159.1922,9.8409,43.96,36.9526,27.8658,28.8049,24.0143,0.9171,1.01,3.5369,3.5017,1.1014,3.8567,3.2
 731.5,114.0498,9.9849,2.0291,2.028,-999.25,7.875,223649.1875,2453.4255,325.3696,5.5204,5.0462,4.6373,4.7223,4.7719,5.2566,0.0,194.2181,95.7183,194.1178,34.0299,-999.25,237.4324,0.0012,0.07,105.404,3.6409,-999.25,-999.25,-999.25,193.74,194.5959,-999.25,-999.25,0.4366,1975.9426,-79.0158,-0.0597,2.9845,3.2328,3.0985,3.0282,2.9946,2.9942,3.2331,0.256,2.6521,-0.516,-0.57,3.6378,15.4484,11.2064,11.2064,9.7389,0.0027,-0.1256,3.3875,11.6539,3.3876,309.3305,9.9729,15.0801,5.5118,54.0953,47.1829,39.259,1.5077,1.6887,5.7421,3.4003,1.1201,3.8086,0.8
 732.0,100.4791,10.1255,2.02,2.0202,-999.25,7.875,223602.0156,2454.0339,324.9581,5.5452,5.1017,4.7227,4.8206,4.9089,5.2775,0.0,187.4638,92.8401,187.5075,31.9944,-999.25,236.2662,0.0012,0.0994,122.0624,3.0925,-999.25,-999.25,-999.25,187.082,187.8893,-999.25,-999.25,0.431,1917.887,-79.0894,-0.0114,2.2317,2.2667,2.1982,2.1594,2.1791,2.2344,2.2669,0.2562,2.5293,-0.4727,-0.0095,3.0207,22.012,17.3438,17.3438,15.6259,-0.0011,7.3146,10.5667,18.2188,10.5667,441.1666,10.0571,4.142,2.3915,82.7203,65.2888,54.2455,2.0932,2.3707,7.8868,3.3268,1.1326,3.7678,0.8
 732.5,75.8975,10.1577,2.0193,2.0178,-999.25,7.875,223556.8281,2427.5566,324.231,5.5606,5.1291,4.7227,4.8741,4.8617,5.3249,0.0,178.6314,88.555,178.4986,28.9639,-999.25,234.3254,0.0013,0.145,162.2948,2.592,1.5704,-35.7743,-17.1019,178.199,179.0164,162.8981,342.8981,0.4819,1973.6268,-78.6322,0.0147,1.8991,1.8608,1.823,1.7971,1.8325,1.8989,1.8608,0.2581,2.4781,0.1742,0.3038,2.9224,26.6189,21.7974,21.7974,19.8384,-0.0012,10.4195,13.5627,20.9584,13.5627,537.4145,10.1257,2.9476,1.6919,101.5143,77.8877,64.5395,2.4909,2.8858,9.3809,3.2507,1.1585,3.766,3.2
 733.0,47.9725,10.179,2.0474,2.0471,-999.25,7.875,223515.9219,2426.0083,323.6802,5.6549,5.0798,4.7211,4.8641,4.8735,5.3438,0.0,169.1898,82.7316,169.1205,24.8456,-999.25,230.5055,0.0016,0.1638,190.5188,2.9006,1.5704,-35.7743,-17.1019,168.6724,169.8202,162.8981,342.8981,0.745,1975.3781,-78.3613,0.0275,1.8465,1.7768,1.7527,1.731,1.7768,1.8454,1.7769,0.2581,2.4728,0.7544,0.1879,3.1719,29.515,24.6575,24.6575,22.5198,0.0016,10.7379,13.8699,21.2393,13.8699,562.8057,10.1493,3.385,1.8646,106.1118,82.6786,68.2093,2.6322,3.1063,9.916,3.1922,1.1801,3.7672,0.8
 733.5,30.9269,9.9639,2.0612,2.0648,1.898,7.875,223477.8125,2438.6387,322.5942,5.5676,4.9867,4.5567,4.7424,4.6939,5.3445,0.0,159.7685,77.5512,159.9711,21.1819,137.2584,225.5556,0.0016,0.2205,274.9185,3.5594,1.5704,-35.7743,-17.1019,159.1455,160.9764,162.8981,342.8981,1.2421,1998.3303,-78.3523,0.0349,1.8376,1.7499,1.7355,1.7156,1.767,1.8367,1.75,0.2562,2.4758,0.5232,-0.2172,3.2873,29.4612,24.604,24.604,22.4698,0.0107,10.5569,13.6952,21.0796,13.6952,571.4661,10.1676,4.4346,2.2476,104.2114,84.3728,69.0518,2.6558,3.2337,10.0809,3.1175,1.2176,3.7958,0.8
 734.0,26.2054,9.8355,2.046,2.0593,1.9038,7.875,223441.9219,2317.8965,322.0427,5.5877,4.9734,4.365,4.557,4.6805,5.3431,0.0,150.9635,73.7716,151.84,18.5089,140.3983,221.302,0.0019,0.3143,427.3562,5.5956,1.5704,-35.7743,-17.1019,150.1262,153.458,162.8981,342.8981,2.2998,2004.5149,-78.399,0.0387,1.7864,1.6919,1.6836,1.6667,1.717,1.7862,1.6919,0.2566,2.4741,0.1618,-0.5052,3.0837,28.9201,24.0663,24.0663,21.967,0.021,10.6628,13.7974,21.1731,13.7974,591.0459,10.3186,2.792,1.6775,107.3948,85.0581,68.4757,2.6272,3.3989,10.0272,2.9502,1.2937,3.8166,0.8
 734.5,28.5786,9.6819,2.0125,2.0631,1.9011,7.875,223407.5469,2191.0745,320.9725,5.5421,4.8888,4.2586,4.4886,4.5811,5.2863,0.0,144.4966,71.7775,147.996,17.0987,141.7506,218.8868,0.0026,0.3925,624.5667,9.9048,1.5704,-35.7743,-17.1019,144.5881,149.4423,162.8981,342.8981,3.3897,1963.1123,-78.3949,0.0391,1.8392,1.7409,1.7355,1.7203,1.7689,1.8391,1.7409,0.2567,2.4781,0.1627,-0.2456,2.8647,30.0381,25.1791,25.1791,23.0069,0.0269,10.4176,13.5608,20.9567,13.5608,574.4119,10.4361,2.2713,1.724,109.4789,83.8171,65.9011,2.5326,3.5624,9.6303,2.7033,1.4066,3.8025,5.0
 735.0,38.3547,9.6646,2.0029,2.0474,1.9002,7.875,223390.1406,2120.1433,319.7419,5.539,4.9084,4.2554,4.4518,4.559,5.2802,0.0,145.1875,72.5073,148.3269,17.6148,142.4704,218.2933,0.0036,0.2929,547.937,18.1659,-999.25,-999.25,-999.25,145.1358,149.1868,-999.25,-999.25,2.809,1962.0304,-78.5376,0.0347,1.9792,1.8855,1.8805,1.8662,1.9107,1.9792,1.8855,0.2582,2.4914,0.3311,0.3476,2.9085,28.4364,23.5869,23.5869,21.5182,0.0336,9.6119,12.7834,20.2458,12.7835,530.3728,10.4828,2.962,1.9437,104.9234,78.1141,59.8027,2.3063,3.5475,8.7009,2.4527,1.5381,3.7726,1.0
 735.5,55.4752,9.6783,1.9829,2.019,1.902,7.875,223354.0,2194.4006,318.4148,5.5034,4.9476,4.2794,4.4652,4.5606,5.2789,0.0,148.1898,74.8072,150.8651,19.2413,145.4411,218.5752,0.0044,0.2544,698.1395,28.32,-999.25,-999.25,-999.25,148.0961,151.3546,-999.25,-999.25,2.204,1926.8698,-78.7483,0.0231,2.1503,2.082,2.0753,2.0618,2.0927,2.1504,2.082,0.2571,2.5227,0.506,0.7033,3.332,25.276,20.487,20.487,18.6037,0.0453,7.7168,10.9548,18.5736,10.9548,480.296,10.4734,2.2382,1.4842,90.5671,67.4682,50.3454,1.9411,3.2579,7.3275,2.2491,1.6784,3.7749,1.0
 736.0,75.3312,9.7014,1.9533,1.9913,1.8992,7.875,223315.6094,2270.9299,317.58,5.5065,4.9374,4.2954,4.4732,4.6134,5.2782,0.0,151.231,77.4974,154.1627,21.1438,149.133,219.3751,0.0055,0.2992,1066.8258,38.1475,-999.25,-999.25,-999.25,151.1898,154.3933,-999.25,-999.25,2.1098,1983.6466,-79.1879,-0.0063,2.4029,2.4238,2.4115,2.3979,2.3986,2.4033,2.4238,0.2569,2.5627,0.4237,0.1932,3.915,20.6934,16.0911,16.0911,14.4324,0.0459,5.2914,8.6145,16.4336,8.6145,412.5727,10.4314,1.1643,1.3856,69.4151,54.0073,39.2341,1.5133,2.7574,5.7074,2.0699,1.8221,3.7716,0.0
 736.5,87.6553,9.7545,1.9385,1.9786,1.8967,7.875,223275.6094,2358.8057,316.5394,5.5784,4.9452,4.3338,4.4953,4.6237,5.287,0.0,154.4954,79.7401,157.6808,22.7299,152.1895,220.3233,0.0068,0.4033,1628.402,49.3807,-999.25,-999.25,-999.25,154.502,157.7626,-999.25,-999.25,2.0936,2028.665,-80.3119,-0.0269,3.0684,3.1828,3.1599,3.1451,3.0896,3.0703,3.1828,0.258,2.5818,0.1119,-0.3621,4.2886,17.3554,12.964,12.964,11.4353,0.0296,4.1352,7.4989,15.4134,7.4989,314.1876,10.2841,3.2566,2.7985,50.6969,40.9352,28.8093,1.1114,2.2136,4.1898,1.8927,1.9917,3.7698,4.0
 737.0,86.4562,9.8093,1.9372,1.9733,1.9012,7.875,223234.75,2380.9116,315.6774,5.58,4.9804,4.3753,4.5221,4.66,5.31,0.0,157.5241,81.3319,160.4652,23.8557,154.6299,221.0958,0.0068,0.4336,2091.9846,56.4293,-999.25,-999.25,-999.25,157.5101,160.4792,-999.25,-999.25,1.8656,2095.1511,-81.8647,-0.0568,4.0384,4.3583,4.3189,4.3025,4.1971,4.0437,4.3583,0.2564,2.5863,-0.2485,0.0544,4.5172,15.0805,10.8697,10.8697,9.413,0.0152,3.863,7.2362,15.1732,7.2362,229.4487,10.062,8.4641,4.9685,36.0177,30.698,20.8597,0.8014,1.7569,3.0493,1.7356,2.1922,3.8048,1.0
 737.5,82.4009,9.837,1.9419,1.9728,1.9085,7.875,223172.9688,2436.4934,314.4095,5.5506,5.0008,4.3929,4.5637,4.66,5.3431,0.0,158.8845,81.8258,161.4121,24.205,156.1573,221.3893,0.0052,0.3633,2159.1514,55.8129,-999.25,-999.25,-999.25,158.8845,161.4121,-999.25,-999.25,1.5795,2065.4722,-83.3148,-0.0654,4.2766,4.6673,4.6196,4.6057,4.5302,4.2833,4.6673,0.2559,2.591,-0.6336,0.4162,4.7621,13.3944,9.3369,9.3369,7.9249,0.0073,3.5754,6.9587,14.9194,6.9587,214.2585,10.0083,14.4911,7.7489,30.082,27.1401,17.7534,0.6801,1.6405,2.6047,1.5878,2.4121,3.8299,0.0
 738.0,81.2976,9.8982,1.9353,1.9614,1.9012,7.875,223131.3906,2442.1487,313.4749,5.583,5.0337,4.4369,4.6233,4.6686,5.3492,0.0,158.7269,82.0235,160.868,24.3447,155.9348,221.6086,0.0045,0.2465,1564.0712,57.2669,-999.25,-999.25,-999.25,158.7269,160.868,-999.25,-999.25,1.3396,2079.7756,-84.3168,-0.0416,3.5712,3.778,3.7389,3.7309,3.704,3.5748,3.778,0.2573,2.5904,-0.7945,-0.0954,4.741,14.1682,10.0383,10.0383,8.6067,0.0013,3.6102,6.9923,14.9502,6.9923,264.6872,10.055,10.5046,6.4293,37.7441,31.1914,19.4863,0.7418,2.0004,2.8813,1.4403,2.6968,3.8842,0.0
 738.5,80.2317,9.9442,1.9391,1.9639,1.8989,7.875,223090.4844,2443.7776,312.47,5.5946,5.0736,4.4768,4.6407,4.6915,5.3553,0.0,157.8479,81.4025,159.8607,23.9056,154.5662,221.4468,0.0043,0.1645,1164.0519,65.716,-999.25,-999.25,-999.25,157.8479,159.8607,-999.25,-999.25,1.2663,2100.7363,-84.969,-0.0275,2.8445,2.9529,2.925,2.9206,2.9087,2.8457,2.9529,0.257,2.5734,-0.5408,-0.2428,4.2334,16.9719,12.6089,12.6089,11.0932,-0.0041,4.6451,7.9908,15.8633,7.9908,338.6487,10.1072,7.5963,4.1695,52.2235,42.1674,25.0875,0.9443,2.858,3.7603,1.3157,3.0266,3.9821,1.0
 739.0,73.7074,10.007,1.9391,1.9637,1.8981,7.875,223050.1563,2488.4385,311.2891,5.617,5.0978,4.5168,4.7176,4.7057,5.3661,0.0,155.8649,80.3772,157.8482,23.1804,152.55,221.0193,0.0037,0.1151,978.9838,70.7289,-999.25,-999.25,-999.25,155.8649,157.8482,-999.25,-999.25,1.2621,2046.5045,-85.3752,-0.033,2.3893,2.4989,2.48,2.4769,2.4604,2.3893,2.4989,0.2561,2.5444,-0.138,-0.0031,3.6421,20.6481,16.0482,16.0482,14.3914,-0.0079,6.3992,9.6834,17.411,9.6834,400.1785,10.104,5.6666,2.9596,69.0814,55.2275,31.2046,1.1636,3.9332,4.7288,1.2023,3.3801,4.0638,0.0
 739.5,63.8348,10.0126,1.9342,1.9564,1.9076,7.875,223010.5781,2464.8752,310.2102,5.6163,5.0751,4.5535,4.7109,4.7207,5.3614,0.0,152.9751,79.0857,154.7354,22.2671,150.8374,220.5904,0.0031,0.1115,992.6538,66.6889,-999.25,-999.25,-999.25,152.9751,154.7354,-999.25,-999.25,1.1403,2080.6282,-85.5561,-0.0221,2.2103,2.2781,2.2669,2.2639,2.2352,2.2102,2.2781,0.2557,2.5264,0.0074,0.0212,3.328,23.1705,18.4525,18.4525,16.679,-0.0092,7.4891,10.7351,18.3727,10.7351,438.9606,10.1459,4.4524,2.4402,82.384,64.9681,35.1027,1.2848,4.8105,5.4344,1.1297,3.7442,4.2298,1.0
 740.0,63.8073,10.1237,1.9265,1.9473,1.9182,7.875,222971.6875,2487.5894,308.7817,5.6989,5.1252,4.6206,4.7651,4.775,5.3864,0.0,149.9549,77.8394,151.5817,21.3857,149.2997,219.8145,0.002,0.1466,1103.4574,37.8989,-999.25,-999.25,-999.25,149.9549,151.5817,-999.25,-999.25,1.0756,2075.4346,-85.5795,-0.0086,2.1387,2.1642,2.1602,2.1567,2.1457,2.1385,2.1642,0.2571,2.5235,-0.2384,0.3444,3.2091,23.8039,19.062,19.062,17.2566,-0.0113,7.6664,10.9061,18.5291,10.9061,462.0668,10.2189,4.5595,2.5037,85.396,69.3988,35.7923,1.2723,5.35,5.7203,1.0692,4.205,4.496,2.4
 740.5,72.226,10.1368,1.927,1.9459,1.9163,7.875,222933.3594,2483.0813,307.3697,5.6464,5.1236,4.6644,4.8079,4.779,5.3891,0.0,147.868,76.7388,149.3245,20.6073,147.0515,219.1064,0.0016,0.1894,939.584,21.2578,-999.25,-999.25,-999.25,147.868,149.3245,-999.25,-999.25,0.9773,2077.1968,-85.7027,0.0087,2.078,2.0532,2.0555,2.0516,2.0682,2.0776,2.0532,0.2553,2.5293,-0.344,0.3983,3.1525,23.8448,19.1014,19.1014,17.294,-0.0086,7.3146,10.5668,18.2188,10.5668,487.0487,10.2596,4.3725,2.4616,84.0345,69.2528,34.1819,1.1813,5.5462,5.6229,1.0138,4.6949,4.7598,1.6
 741.0,74.8807,10.1738,1.9385,1.9541,1.9136,7.875,222914.3281,2449.2839,306.0231,5.7151,5.1369,4.6788,4.8126,4.7916,5.3864,0.0,146.9714,75.834,148.1678,19.9675,145.1106,218.4877,0.0015,0.1586,683.7291,15.5075,-999.25,-999.25,-999.25,146.9683,148.1709,-999.25,-999.25,0.8127,2106.4023,-86.0775,0.0307,1.9862,1.9027,1.9089,1.9049,1.9357,1.9855,1.9027,0.2573,2.5256,0.0667,-0.2286,3.1572,26.6224,21.8008,21.8008,19.8416,-0.0019,7.5397,10.7839,18.4174,10.7839,525.5764,10.3394,4.1554,2.5758,84.9374,67.7343,31.8454,1.0664,5.6494,5.4009,0.956,5.2978,5.0647,0.8
 741.5,66.1131,10.2194,1.9466,1.9624,1.9116,7.875,222877.3125,2421.4197,304.7269,5.7313,5.1361,4.7378,4.8674,4.8113,5.3742,0.0,146.3734,75.2103,147.573,19.5264,143.765,218.2957,0.0014,0.1059,444.1743,12.2097,-999.25,-999.25,-999.25,146.3665,147.5799,-999.25,-999.25,0.8252,2071.6106,-87.3434,0.0482,1.7905,1.6729,1.6805,1.6769,1.7014,1.7899,1.6729,0.2572,2.496,0.3804,-0.7382,3.2662,28.862,24.0086,24.0086,21.913,0.0011,9.3328,12.5141,19.9995,12.5141,597.7542,10.4017,4.775,3.1471,83.0228,65.6122,29.7164,0.9662,5.633,5.177,0.9191,5.8303,5.3583,0.0
 742.0,52.4566,10.2527,1.9478,1.9649,1.9115,7.875,222839.6406,2406.4478,303.1422,5.7313,5.1401,4.8247,4.8648,4.8136,5.3837,0.0,145.6046,74.7715,146.885,19.216,142.9181,218.4856,0.002,0.0646,265.8062,13.6721,-999.25,-999.25,-999.25,145.5898,146.8997,-999.25,-999.25,0.8964,2113.3359,-89.4497,0.0389,1.5908,1.5063,1.5135,1.5106,1.5257,1.5903,1.5063,0.2555,2.4725,0.2969,-0.3756,3.3709,31.0893,26.2316,26.2316,23.9881,0.007,10.7562,13.8875,21.2554,13.8875,663.8673,10.4485,5.6001,3.4099,75.945,61.3182,27.2573,0.8679,5.3192,4.8356,0.9091,6.1289,5.5718,0.0
 742.5,38.796,10.3805,1.9618,1.9747,1.9169,7.875,222802.0,2467.0317,301.2671,5.7915,5.1745,4.9267,4.9082,4.9144,5.4262,0.0,145.2567,74.0693,146.2208,18.7195,141.9663,218.647,0.003,0.042,146.9144,18.1894,-999.25,-999.25,-999.25,145.2255,146.252,-999.25,-999.25,0.7063,2079.5002,-91.6174,0.0323,1.5913,1.5211,1.5281,1.5249,1.5393,1.5906,1.5211,0.2562,2.4703,0.2669,0.1855,3.4253,30.7427,25.8839,25.8839,23.6642,0.0125,10.8931,14.0197,21.3763,14.0197,657.4232,10.4907,3.4994,2.1597,68.5176,56.3711,24.8964,0.7859,4.8915,4.4493,0.9096,6.2244,5.6617,5.0
 743.0,29.2573,10.5009,1.9838,1.9935,1.9253,7.875,222765.0156,2437.7671,299.8749,5.8425,5.2253,4.9992,4.979,5.0135,5.4431,0.0,144.867,73.044,145.5719,17.9943,140.6139,218.4849,0.0038,0.0324,115.8999,21.6164,-999.25,-999.25,-999.25,144.8361,145.6029,-999.25,-999.25,0.53,2078.958,-93.096,0.0436,1.8433,1.7336,1.7402,1.7359,1.7569,1.8424,1.7336,0.2564,2.4781,0.3686,0.3271,3.5537,27.7813,22.9398,22.9398,20.9116,0.0089,10.4161,13.5594,20.9554,13.5594,576.8449,10.5429,4.0699,3.016,64.6963,53.1885,23.2079,0.7281,4.6314,4.1686,0.9001,6.3608,5.7252,1.0
 743.5,24.1403,10.6319,1.997,2.0088,1.9317,7.875,222728.8125,2443.2163,298.3971,5.9412,5.2737,5.1018,5.0525,5.0529,5.4735,0.0,144.0255,72.1349,144.8724,17.3514,139.3311,218.082,0.0038,0.0345,156.3915,22.7197,-999.25,-999.25,-999.25,144.0117,144.8862,-999.25,-999.25,0.6068,2078.9705,-93.3836,0.0562,2.2852,2.1105,2.1137,2.1073,2.145,2.2841,2.1105,0.2554,2.5041,0.406,0.3019,3.7549,24.1304,19.3769,19.3769,17.5548,0.0027,8.8412,12.0398,19.5658,12.0398,473.8238,10.5516,4.7927,3.5249,70.6196,54.2206,23.3811,0.7316,4.7486,4.2089,0.8864,6.4906,5.753,1.0
 744.0,20.7886,10.704,2.0035,2.0185,1.933,7.875,222675.3281,2462.4429,296.7915,5.9018,5.3042,5.1559,5.1072,5.17,5.4729,0.0,143.1921,71.4756,144.2601,16.8852,138.1518,217.6417,0.0029,0.0317,228.0624,22.6424,-999.25,-999.25,-999.25,143.1862,144.2659,-999.25,-999.25,0.7521,2060.175,-93.2099,0.0443,2.781,2.6131,2.6041,2.595,2.6523,2.7797,2.6131,0.2564,2.5234,0.3911,0.4054,3.9427,22.8919,18.1852,18.1852,16.4254,0.0,7.6751,10.9145,18.5368,10.9145,382.6899,10.5697,4.8837,3.1794,79.1177,56.0293,23.7164,0.7338,4.9614,4.3087,0.8684,6.7613,5.8718,1.0
 744.5,20.7054,10.7281,1.9988,2.0141,1.9273,7.875,222640.0781,2447.9417,295.6714,5.9782,5.2815,5.1575,5.1145,5.1621,5.4904,0.0,142.4068,71.2466,143.496,16.7232,137.3019,217.4033,0.0016,0.0329,410.2461,21.2476,-999.25,-999.25,-999.25,142.3861,143.5167,-999.25,-999.25,0.7898,2055.5684,-93.3333,0.0155,3.3988,3.3265,3.2905,3.2778,3.3298,3.3978,3.3265,0.2573,2.5117,0.0599,0.1851,4.0869,23.7344,18.995,18.995,17.1932,0.0066,8.3847,11.5992,19.1629,11.5993,300.6118,10.5885,6.4355,3.8463,74.183,53.8418,22.5481,0.6837,4.8032,4.1627,0.8666,7.0255,6.0886,1.0
 745.0,22.4416,10.7013,1.9947,2.0127,1.9123,7.875,222604.625,2474.4998,294.4899,6.0252,5.2737,5.1241,5.0925,5.1134,5.4749,0.0,142.7422,71.5651,144.0287,16.9484,136.8436,217.1555,0.001,0.043,760.8865,30.4466,-999.25,-999.25,-999.25,142.7033,144.0677,-999.25,-999.25,0.9482,2030.5195,-93.9638,-0.018,4.2738,4.3805,4.3025,4.2881,4.2808,4.2724,4.3805,0.2564,2.4833,-0.5646,-0.3961,4.1722,24.354,19.593,19.593,17.7592,0.0145,10.1014,13.2557,20.6777,13.2557,228.2841,10.6323,8.7339,7.3407,58.4039,45.5556,18.9508,0.5526,4.0791,3.6031,0.8833,7.3821,6.5207,3.0
 745.5,23.5699,10.6738,1.9905,2.0124,1.9041,7.875,222568.5313,2463.7964,293.472,5.989,5.2386,5.1265,5.0992,5.1252,5.4431,0.0,144.0691,72.386,145.6459,17.529,137.8237,217.5702,0.0,0.0356,901.7476,52.1802,-999.25,-999.25,-999.25,143.9859,145.7291,-999.25,-999.25,1.2002,2050.3623,-94.8874,-0.046,5.4748,5.8255,5.6766,5.661,5.5687,5.473,5.8255,0.256,2.4355,-0.5395,-0.3275,4.2274,26.4022,21.5853,21.5853,19.6388,0.0137,12.9985,16.0511,23.2339,16.0511,171.6603,10.726,13.6194,11.9703,43.0981,35.1621,14.6404,0.412,3.1281,2.8544,0.9125,7.5932,6.929,0.0
 746.0,23.5374,10.7198,1.9809,1.9952,1.9012,7.875,222531.6875,2463.9106,292.5682,5.9936,5.2737,5.1432,5.1446,5.1661,5.4384,0.0,145.2999,73.3584,146.3422,18.2167,139.4609,218.3118,0.0,0.0286,914.7017,77.8445,-999.25,-999.25,-999.25,145.1254,146.5167,-999.25,-999.25,0.9533,2023.3566,-95.7226,-0.0623,8.2819,9.0027,8.7043,8.6872,8.5782,8.2833,9.0027,0.2579,2.3799,0.0481,-0.2209,4.242,27.1032,22.2725,22.2725,20.285,0.0143,16.369,19.3034,26.208,19.3035,111.078,10.8634,10.6721,9.7216,31.6557,25.9535,10.8709,0.2951,2.2822,2.1705,0.951,7.7327,7.3542,2.4
 746.5,22.7871,10.7532,1.9732,1.9832,1.9033,7.875,222494.4844,2412.8157,291.0612,5.952,5.3237,5.1845,5.1733,5.1763,5.4499,0.0,146.2,74.0974,146.9334,18.7393,141.0316,219.0807,0.0,0.0223,646.0608,55.1649,-999.25,-999.25,-999.25,145.8436,147.2898,-999.25,-999.25,0.9858,2047.0231,-96.3067,-0.0309,13.1199,13.6833,13.1316,13.1284,13.1285,13.1286,13.6833,0.2558,2.344,0.0423,-0.5584,4.2136,29.4287,24.5716,24.5716,22.4396,0.0188,18.5475,21.4055,28.1302,21.4055,73.0816,10.9218,8.7912,9.6574,24.1134,20.6016,8.581,0.2271,1.8047,1.741,0.9647,7.9457,7.6656,2.4
 747.0,22.4815,10.7552,1.9647,1.9836,1.9001,7.875,222456.9844,2405.76,289.9706,6.029,5.3276,5.1209,5.1606,5.148,5.4796,0.0,146.5178,74.5783,147.9246,19.0794,141.7087,219.3026,0.0,0.0175,419.5757,41.4825,-999.25,-999.25,-999.25,146.3611,148.0813,-999.25,-999.25,1.1679,2017.4711,-96.7337,-0.0602,18.2661,19.8021,18.8681,18.9035,18.7545,18.2801,19.8021,0.2561,2.3371,-0.3099,-0.3261,4.2702,32.6757,27.8314,27.8314,25.4752,0.0143,18.9644,21.8078,28.498,21.8078,50.4997,10.9255,9.6528,10.6228,21.4795,18.1256,7.4756,0.1966,1.5953,1.5226,0.9545,8.1133,7.7441,3.2
 747.5,23.6498,10.709,1.967,1.9861,1.903,7.875,222438.2344,2366.2041,288.795,6.0021,5.3237,5.0382,5.1092,5.1472,5.5066,0.0,146.8508,74.6605,148.2818,19.1376,142.0783,219.498,0.0,0.0158,327.9354,28.9057,-999.25,-999.25,-999.25,146.7685,148.3641,-999.25,-999.25,1.0818,2004.3304,-97.0958,-0.0454,23.9795,25.4947,24.1516,24.2527,23.6108,23.9995,25.4947,0.2562,2.3634,-0.2759,0.2056,4.5568,34.3449,29.5294,29.5294,27.048,0.011,17.3703,20.2695,27.0914,20.2695,39.2238,10.9396,12.7544,11.3397,22.9141,17.3203,6.9614,0.1815,1.552,1.4255,0.9184,8.5507,7.8533,3.0
 748.0,23.9871,10.6891,1.9728,1.99,1.9058,7.875,222400.9688,2393.9207,288.0846,5.9905,5.3034,4.9785,5.1339,5.1511,5.51,0.0,147.1993,74.6142,148.4843,19.1048,142.1977,219.5771,0.0,0.0146,272.5972,18.0132,-999.25,-999.25,-999.25,147.1582,148.5254,-999.25,-999.25,0.9256,2033.0996,-97.4582,-0.0187,24.9449,25.5893,23.9912,24.2889,23.9403,24.965,25.5893,0.2563,2.384,-0.1518,0.0926,5.0911,32.0177,27.1662,27.1662,24.8575,0.0128,16.1229,19.066,25.9908,19.066,39.0789,10.9663,12.787,11.0976,23.8304,17.3974,6.9017,0.1781,1.5783,1.4219,0.9009,8.8598,7.9818,1.0
 748.5,23.9354,10.6923,1.9739,1.9916,1.9061,7.875,222363.7188,2395.0789,287.6059,5.9797,5.3018,4.9785,5.1713,5.1566,5.4891,0.0,147.2436,74.5954,148.5647,19.0915,142.1836,219.5867,0.0,0.0125,231.1437,11.3415,-999.25,-999.25,-999.25,147.2237,148.5846,-999.25,-999.25,0.9214,2009.7198,-97.7746,0.0246,19.9693,19.2964,17.856,18.238,18.8942,19.9818,19.2964,0.2552,2.3576,-0.0345,-0.0526,5.6357,32.0985,27.2477,27.2477,24.9332,0.0097,17.7209,20.6079,27.4008,20.6079,51.8231,11.0179,13.7273,13.4232,22.4199,17.6157,6.873,0.1778,1.6151,1.414,0.8755,9.0841,7.9533,1.0
 749.0,24.5567,10.7751,1.9715,1.9939,1.9067,7.875,222326.3125,2346.4497,287.1353,5.9951,5.3589,4.957,5.2206,5.2682,5.5255,0.0,146.962,74.5441,148.631,19.0552,142.1281,219.5672,0.0,0.0116,236.2782,10.5542,-999.25,-999.25,-999.25,146.962,148.631,-999.25,-999.25,1.1308,2065.2539,-97.9611,0.0342,10.597,10.1016,9.4901,9.6186,10.0664,10.5985,10.1016,0.2572,2.3073,0.2993,-0.0427,5.9323,34.6531,29.8446,29.8446,27.3393,0.0067,20.7722,23.5521,30.0931,23.5521,98.9938,11.0297,14.8837,12.9022,20.5025,17.3115,6.7637,0.1749,1.5876,1.3917,0.8766,9.0747,7.9547,0.0
 749.5,23.853,10.6656,1.969,1.9978,1.909,7.875,222289.0781,2409.1555,287.0189,6.0768,5.2581,4.9243,5.1506,5.1134,5.4735,0.0,146.6064,74.4581,148.7524,18.9944,142.1408,219.488,0.0,0.0133,294.1729,12.3573,-999.25,-999.25,-999.25,146.6064,148.7524,-999.25,-999.25,1.4554,2052.9197,-98.0581,0.0321,6.1559,5.8854,5.6302,5.6801,5.9005,6.1561,5.8854,0.2569,2.2645,0.5018,-0.0699,5.9114,35.6281,30.8449,30.8449,28.2627,0.0123,23.3648,26.0538,32.3807,26.0538,169.9114,10.9885,11.1206,9.3584,20.4338,16.9274,6.6136,0.1702,1.5498,1.3646,0.8805,9.1031,8.0156,2.0
 750.0,23.4866,10.584,1.966,1.9993,1.9081,7.875,222252.0938,2385.8567,286.4319,6.0529,5.2151,4.8996,5.1119,5.0678,5.4046,0.0,146.6247,74.5793,149.0993,19.0801,142.3004,219.5255,0.0,0.0156,367.446,17.381,-999.25,-999.25,-999.25,146.6247,149.0993,-999.25,-999.25,1.6771,2091.0168,-98.1239,0.0261,4.9873,4.8087,4.6253,4.6582,4.823,4.9873,4.8087,0.2555,2.2404,0.1621,0.123,5.6331,33.9683,29.145,29.145,26.6924,0.0217,24.8239,27.4616,33.6681,27.4616,207.9574,10.8898,7.6118,6.0331,22.874,17.3838,6.8102,0.1761,1.5827,1.4017,0.8856,8.99,7.9617,1.0
 750.5,24.8939,10.5124,1.966,1.9977,1.9046,7.875,222214.9219,2433.8774,285.5403,6.086,5.2049,4.8598,5.0071,4.9884,5.3911,0.0,147.3741,74.9621,149.7425,19.3509,142.7681,219.8463,0.0,0.0163,403.8161,19.7614,-999.25,-999.25,-999.25,147.3741,149.7425,-999.25,-999.25,1.6004,2077.9099,-98.2606,0.0129,4.9591,4.8711,4.6781,4.7075,4.8664,4.9591,4.8711,0.2558,2.2541,-0.3968,0.4832,5.