~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                                                          VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                                               0.0  : START DEPTH                    {F}
 STOP  .F                                                              45.0  : END DEPTH                      {F}
 STEP  .F                                                               0.0  : STEP LENGTH                    {F}
 NULL  .                                                            -999.95  : NULL VALUE                     {F}
 COMP  .                                                                     : Company                        {S}
 WELL  .          Kansas Turnpike 6 Miles West of West Lawrence Interchange  : Well Name                      {S}
 FLD   .                                                                     : Field                          {S}
 SEC   .                                                                 24  : Section                        {I}
 TOWN  .                                                                12S  : Township (e.g. 42S)            {S}
 RANG  .                                                                18E  : Range  (e.g. 25E)              {S}
 LOC   .                                                   T12S-R18E-Sec 24  : Location (Sec Town Range)      {S}
 LOC1  .                                                              NW NW  : Location 1 (quarter calls)     {S}
 LOC2  .                                                                     : Location 2 (footages)          {S}
 COUN  .                                                            Douglas  : County                         {S}
 STAT  .                                                             Kansas  : State                          {S}
 CTRY  .                                                                 US  : Country                        {S}
 PROV  .                                                                     : Province                       {S}
 SRVC  .                                                                     : Service Company                {S}
 LIC   .                                                                     : License Number                 {S}
 DATE  .                                                                     : Completion Date                {D/M/YYY}
 API   .                                                                     : API-Number                     {S}
 UWI   .                                                                     : Unique Well ID Number          {S}
 LATI  .DEG                                                       38.993153  : Latitude                       {F}
 LONG  .DEG                                                      -95.363003  : Longitude                      {F}
 GDAT  .                                                              NAD27  : Geodetic Datum                 {S}
 X     .                                                          295346.25  : X or East-West coordinate      {F}
 Y     .                                                         4318465.11  : Y or North South coordinate    {F}
 HZCS  .                                                                UTM  : Horizontal Co-ordinate System  {S}
 UTM   .                                                               15.0  : UTM Location                   {F}
 STUS  .                                                            OUTCROP  : Well Status                    {S}

~Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                  GL  : Permanent Data                 {S}
 APD   .F                0.0  : Above Permanent Data           {F}
 DREF  .                  GL  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F             1001.0  : Elevation of Depth Reference   {F}
 RUN   .                   1  : Run Number                     {F}
 TDL   .F               45.0  : Total Depth Logger             {F}
 TDD   .F                     : Total Depth Driller            {F}
 CSGL  .F                     : Casing Bottom Logger           {F}
 CSGD  .F                     : Casing Bottom Driller          {F}
 CSGS  .IN                    : Casing Size                    {F}
 CSGW  .LB                    : Casing Weight                  {F}
 BS    .IN                    : Bit Size                       {F}
 MUD   .                      : Mud type                       {S}
 MUDS  .                      : Mud Source                     {S}
 MUDD  .GM/CC                 : Mud Density                    {F}
 MUDV  .CC                    : Mud Viscosity (Funnel)         {F}
 FL    .LB/S                  : Fluid Loss                     {F}
 PH    .                      : PH                             {F}
 RM    .OHM-M                 : Resistivity of Mud             {F}
 RMT   .DEG-F                 : Temperature of Mud             {F}
 RMF   .OHM-M                 : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEG-F                 : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M                 : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F                 : Temperature of Mud Cake        {F}
 TMAX  .DEG-F                 : Maximum Recorded Temp.         {F}
 TIMC  .DATE                  : Date/Time Circulation Stopped  {DD/MM/YYYY}
 TIML  .DATE                  : Date/Time Logger Tagged Bottom {DD/MM/YYYY}
 UNIT  .                      : Logging Unit Number            {S}
 BASE  .                      : Home Base of Logging Unit      {S}
 ENG   .            RC MOORE  : Recording Engineer             {S}
 WIT   .                      : Witnessed By                   {S}

~Tops_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                      : Profile Web App Saved Data Indicator {S}
 TOPS  .            RC Moore  : Formation Source               {S}
 TOPDR .           Log Depth  : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 SSYS  .                      : Subsystem                      {S}
 STG   .                      : Stage                          {S}
 GRP   .                      : Group                          {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
# TOPT TOPB RANK LVL TOPN EON ERA SYS SER SSYS STG GRP FORM
 0.0,0.5,"MEMBER","Poor","Avoca Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 0.5,8.5,"MEMBER","Poor","King Hill Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 8.5,17.1,"MEMBER","Poor","Beil Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 17.1,20.6,"MEMBER","Poor","Queen Hill Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 20.6,23.9,"MEMBER","Poor","Big Springs Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 23.9,25.1,"MEMBER","Poor","Doniphan Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 25.1,37.2,"MEMBER","Poor","Spring Branch Limestone","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Lecompton Limestone"
 37.2,45.0,"FORMATION","Poor","Kanwaka Shale","Phanerozoic","Paleozoic","Carboniferous","Upper","Pennsylvanian","Virgilian","Shawnee","Kanwaka Shale"

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F                0.0  : Starting Display Depth         {F}
 IQSTOP  .F               45.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN              5  : Plot Scale Feet/Inch           {F}
 IQGRP   .                ROCK  : LAS, ROCK or HORIZON           {S}
 IQORDR  .             DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                      : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                      : Conductivity Image Track Curve Mnemonic {S}
 IQOHM_L .MMHO/M                : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M                : Conductivity Image Track Maximum Value {F}
 IQPHI   .                      : Porosity Image Track Curve Mnemonic {S}
 IQPHI_L .PU                    : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                    : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
# IQ_SRC IQ_TYPE IQ_DESC
 "TOPS","SEQ","Horizons - Sequence Stratigraphy"
 "TOPS","STRAT","Horizons - Stratigraphic Units"
 "TOPS","ENV","Horizons - Depositional Environment"
 "ROCK","COLOR","Color - Rock RGB Values"
 "ROCK","ROCK","Lithology - Measured Sections"
 "ROCK","ICON","Sedimentary Structures"
 "ROCK","ICON","Fossils"
 "ROCK","ICON","Bio Stratigraphy Fossil Track"
 "ROCK","DESC","Description"

~IQ_Seq_Strat_Parameter
#MNEM    .UNIT                VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS    .                      YES  : Profile Web App Saved Data Indicator {S}
 SEQ_SRC  .          KGS Guidebook 4  : Source of Data                 {S}
 SEQ_DATE .              23/Oct/2014  : Created Date                   {DD/MMM/YYYY}

~IQ_Seq_Strat_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 SEQFT   .F                     : Sequence Stratigraphy Top Depth {F}
 SEQFB   .F                     : Sequence Stratigraphy Bottom Depth {F}
 SEQMNEM .                      : Sequence Stratigraphy Mnemonic {S}
 SEQDES  .                      : Sequence Stratigraphy Description {S}

~IQ_Seq_Strat_Data | IQ_Seq_Strat_Definition 
# SEQFT SEQFB SEQMNEM SEQDES
 8.5,17.1,"HST","Highstand systems tract"
 17.1,20.6,"TST","Transgressive systems tract"
 20.6,23.9,"LST","Lowstand systems tract"
 23.9,23.9,"SB","Sequence boundary"
 30.6,32.2,"HST","Highstand systems tract"
 32.2,37.2,"TST","Transgressive systems tract"
 37.2,37.7,"LST","Lowstand systems tract"
 37.7,37.7,"SB","Sequence boundary"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                 YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F                0.0  : Starting Display Depth         {F}
 GEOSTOP .F                0.0  : Ending Display Depth           {F}
 GEOSRC  .            RC MOORE  : Source                         {S}
 GEOREF  .           Log Depth  : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
# GEOTOP GEOBASE GEOBED GEODES
 0.0,0.5,0.5,"19. Limestone (Avoca), bluish-gray, weathers brown, medium fine grained hard, massive; large fusulinids common, crinoid columnals, brachiopods, moderatley large incrusting algae ( Ottonosia ), and some clams ( Myalina ) {A-Avoca type marine assemblage } | 0.5+ "
 0.5,3.0,2.5,"18a. earthy limestone (King Hill), gray, limestone weathering punky yellow-brown, contains small irregular calcite filled spaces; unfossiliferous | 2.5 "
 3.0,5.5,2.5,"18b. shale (King Hill), gray unfossiliferous | 2.5 "
 5.5,8.5,3.0,"17. Shale (King Hill), gray, weathers tan, clayey, laminated | 3 "
 8.5,12.8,4.3,"16a. Limestone (Beil), very shaly, bluish gray, weathers brownish, medium to thin bedded; highly fossiliferous (B - Beil type assemblage fusulinids, brachiopods, bryozoans, corals, crinoid fragments, mollusks ) (B-Beil type marine assemblage)  | 4.3 "
 12.8,17.1,4.3,"16b. Limestone (Beil), bluish gray, weathers brownish, medium to thin bedded; highly fossiliferous (B - Beil type marine assemblage fusulinids, brachiopods, bryozoans, corals, crinoid fragments, mollusks ) (B-Beil type marine assemblage) | 4.3 "
 17.1,18.6,1.5,"15a Shale (Queen Hill), bluish-gray | 1.5 "
 18.6,20.6,2.0,"15b Shale (Queen Hill), black and fissile, with two thin streaks of hard black shale in middle; black shale with conodonts (H-Heebner type marine assemblage Phosphate ) | 2.0 "
 20.6,23.1,2.5,"14. Limestone (Big Springs), grayish blue, weathering light gray, fine grained massive, vertical jointed, top surface plane; abundant small fusulinids some brachiopods (T-Tarkio type marine assemblage) | 2.5 "
 23.1,23.9,0.8,"13. Limestone (Big Springs), grayish blue, weathering light gray, but thin wavy bedded, grading downward to limestone nodules and shale; fusulinids sparse (T-Tarkio type marine assemblage) | 0.8 "
 23.9,24.5,0.6,"12a. Shale (Doniphan), olive-green above, clayey; fossiliferous above | 0.6 "
 24.5,25.1,0.6,"12b. Shale (Doniphan), bluish-drab below, clayey; unfossiliferous below | 0.6 "
 25.1,26.2,1.1,"11. Limestone (Spring Branch), gray, weathering nearly white, fine-grained, earthy, massive; unfossiliferous 0.9 to | 1.1 "
 26.2,27.0,0.8,"10. Shale (Spring Branch), dark bluish gray, clayey, well laminated; unfossiliferous | 0.8 "
 27.0,29.6,2.6,"9. Limestone (Spring Branch), gray, weathering nearly white, softer and irregularly bedded to shaly, upper surface even; unfossiliferous | 2.6 "
 29.6,30.1,0.5,"8a. Shale (Spring Branch), bluish gray, well laminated; upper half unfossiliferous | 0.5 "
 30.1,30.6,0.5,"8b. Shale (Spring Branch), bluish gray, well laminated; lower half crowed with fusulinids | 0.5 "
 30.6,32.2,1.6,"7. Limestone (Spring Branch), light gray, soft shaly, weathers brownish; crowded with fusulinids (T-Tarkio-type marine assemblage) | 1.6 "
 32.2,37.2,5.0,"6. Limestone (Spring Branch), bluish gray, weathers rich brown, medium fine-grained, hard, massive; fusulinids scattered to common, crinoid columnals, few brachiopods (T-Tarkio-type marine assemblage) | 5 "
 37.2,37.7,0.5,"5. Shale (Kanwaka), tan, clayey, laminated; abundant compressed brachiopods (especially Chonetes, Juresania, Derbyia ) and pelecypods ( Myalina, Aviculopecten, Edmondia ) (S-Speiser type marine Assemblage) | 0.5 "
 37.7,38.3,0.6,"4. Coal and Coaly shale (Kanwaka), black soft | 0.6 "
 38.3,39.5,1.2,"3a.Shale (Kanwaka), bluish-gray, clayey in part crowded with well preserved land plants ( Cordaites, Alethopteris ) | 1.2 "
 39.5,40.8,1.3,"3b.Shale (Kanwaka), bluish-gray, sandy, in part crowded with well preserved land plants ( Cordaites, Alethopteris ) | 1.3 "
 40.8,41.8,1.0,"2. Sandstone (Kanwaka), bluish gray, weathers tan-brown, soft micaceous | 1 "
 41.8,44.8,3.0,"1. Shale (Kanwaka), very sandy, bluish gray; unfossiliferous | 3+ "

~IQ_Bio_Parameter
#MNEM  .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS  .                      : Profile Web App Saved Data Indicator {S}
 BIOSRC .                      : Formation Source               {S}
 BIODR  .           Log Depth  : Tops Depth Reference           {S}

~IQ_Bio_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 SP    .                      : Species                        {S}
 ABUN  .                      : Abundance, (sparse, common, etc.) {S}
 STRT  .F                     : Starting Depth                 {F}
 END   .F                     : Ending Depth                   {F}
 GENUS .                      : Genus                          {S}
 TRIBE .                      : Tribe                          {S}
 SBFAM .                      : Subfamily                      {S}
 FAM   .                      : Family                         {S}
 SPFAM .                      : Superfamily                    {S}
 SBORD .                      : Suborder                       {S}
 ORDER .                      : Order                          {S}
 SBCLS .                      : Subclass                       {S}
 CLASS .                      : Class                          {S}
 SBPHY .                      : Subphylum                      {S}
 PHYLM .                      : Phylum                         {S}
 SBKNG .                      : Subkingdom                     {S}
 KNGDM .                      : Kingdom                        {S}
 AUTHR .                      : Author                         {S}
 GENID .                      : Generic Fossil ID              {S}
 GENRC .                      : Generic Fossil Name            {S}
 FROM  .Ma                    : Age From                       {F}
 KEYE  .                      : Stratigraphic Unit KEY         {S}
 SYSE  .                      : System stratigraphic unit name {S}
 SERE  .                      : Series stratigraphic unit name {S}
 TO    .Ma                    : Age To                         {F}
 KEYL  .                      : Stratigraphic Unit KEY         {S}
 SYSL  .                      : System stratigraphic unit name {S}
 SERL  .                      : Series stratigraphic unit name {S}

~IQ_Bio_Data | IQ_Bio_Definition 
# SP ABUN STRT END GENUS TRIBE SBFAM FAM SPFAM SBORD ORDER SBCLS CLASS SBPHY PHYLM SBKNG KNGDM AUTHR GENID GENRC FROM KEYE SYSE SERE TO KEYL SYSL SERL
 "Myalina (sp)","present",37.2,37.7,"Myalina","-999.95","-999.95","Myalinidae","Ambonychioidea","-999.95","Pterioida","Autolamellibranchiata","Bivalvia","-999.95","Mollusca","-999.95","Metazoa","de Koninck 1841","10.2.24","pelecypods",216.5,"10203010","Triassic","Upper",391.9,"10305020","Devonian","Middle"
 "Aviculopecten (sp)","present",37.2,37.7,"Aviculopecten","-999.95","-999.95","Aviculopectinidae","Aviculopectinoidea","-999.95","Pectinoida","Autolamellibranchiata","Bivalvia","-999.95","Mollusca","-999.95","Metazoa","Lamarack 1801","10.2.24","pelecypods",65.0,"10103030","Paleogene","Paleocene",70.6,"10201010","Cretaceous","Upper"
 "Alethopteris (sp)","present",38.3,39.5,"Alethopteris","-999.95","-999.95","Alethopteridae","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","Plantae","Eukaryota","Sternberg 1825","10.2.31","plants",112.0,"10201020","Cretaceous","Lower",360.7,"10305010","Devonian","Upper"
 "Alethopteris (sp)","present",39.5,40.8,"Alethopteris","-999.95","-999.95","Alethopteridae","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","Plantae","Eukaryota","Sternberg 1825","10.2.31","plants",112.0,"10201020","Cretaceous","Lower",360.7,"10305010","Devonian","Upper"
 "Ottonosia (sp)","present",0.0,0.5,"Ottonosia","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","-999.95","10.2.35","algae",-999.95,"-999.95","-999.95","-999.95",-999.95,"-999.95","-999.95","-999.95"
 "Cordaites (sp)","present",38.3,39.5,"Cordaites","-999.95","-999.95","-999.95","-999.95","-999.95","Cordaitanthales","-999.95","Pinopsida","-999.95","Coniferophyta","-999.95","-999.95","-999.95","10.2.36","conifers",228.0,"10203010","Triassic","Upper",383.7,"10305010","Devonian","Upper"
 "Cordaites (sp)","present",39.5,40.8,"Cordaites","-999.95","-999.95","-999.95","-999.95","-999.95","Cordaitanthales","-999.95","Pinopsida","-999.95","Coniferophyta","-999.95","-999.95","-999.95","10.2.36","conifers",228.0,"10203010","Triassic","Upper",383.7,"10305010","Devonian","Upper"
 "Chonetes granulifer","abundant",37.2,37.7,"Chonetes","-999.95","Chonetinae","Chonetidae","Chonetoidea","Chonetidina","Productida","-999.95","Strophomenata","Rhynchonelliformea","Brachiopoda","-999.95","Metazoa","Owen (1852)","10.2.9","brachiopods",251.0,"10301010","Permian","Lopingian",360.7,"10305010","Devonian","Upper"
 "Juresania (sp)","present",37.2,37.7,"Juresania","Juresaniini","Juresaniinae","Echinoconchidae","Echinoconchoidea","Productidina","Productida","-999.95","Strophomenata","Rhynchonelliformea","Brachiopoda","-999.95","Metazoa","Fredericks 1928","10.2.9","brachiopods",255.0,"10301010","Permian","Lopingian",299.0,"10301030","Permian","Cisuralian"
 "Derbyia (sp)","present",37.2,37.7,"Derbyia","-999.95","-999.95","Derbyiidae","Orthotetoidea","Orthotetidina","Orthotetida","-999.95","Strophomenata","Rhynchonelliformea","Brachiopoda","-999.95","Metazoa","Waagen 1884","10.2.9","brachiopods",255.0,"10301010","Permian","Lopingian",299.0,"10301030","Permian","Cisuralian"

~IQ_Env_Parameter
#MNEM  .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS  .                      : Profile Web App Saved Data Indicator {S}
 ENVSRC .          JVictorine  : Source                         {S}
 ENVDR  .           Log Depth  : Depth Reference                {S}

~IQ_Env_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                     : Starting Depth                 {F}
 END   .F                     : Ending Depth                   {F}
 THICK .F                     : Bed Thickness                  {F}
 ENV   .                      : Dep Environment Terms          {S}
 MODEL .                      : Sedimentary Model              {S}
 TYPE  .                      : Environment Type               {S}
 GRP   .                      : Environment Group              {S}
 SGRP  .                      : Environment Subgroup           {S}
 DESC  .                      : Description                    {S}
 LEVEL .                      : Sea Level identifer            {S}

~IQ_Env_Data | IQ_Env_Definition 
# STRT END THICK ENV MODEL TYPE GRP SGRP DESC LEVEL
 0.0,0.5,0.5,"Storm wavebase","Marine","Shallow Marine","Inner Neritic","Offshore","-999.95",".......X......"
 0.5,2.0,1.5,"Offshore-Transition","Marine","Shallow Marine","Inner Neritic","Offshore","-999.95","......X......."
 2.0,3.0,1.0,"Nearshore","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95",".....XX......."
 3.0,5.5,2.5,"Lower Shoreface","Marine","Shallow Marine","Inner Neritic","Shoreface","-999.95",".....X........"
 5.5,8.5,3.0,"Upper Shoreface","Marine","Shallow Marine","Inner Neritic","Shoreface","-999.95",".....X........"
 8.5,10.0,1.5,"Fairweather Wavebase","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95","......X......."
 10.0,13.0,3.0,"Inner Neritic","Marine","Shallow Marine","Inner Neritic","-999.95","-999.95",".......X......"
 13.0,16.0,3.0,"Middle Neritic","Marine","Middle Marine","Middle Neritic","-999.95","-999.95","........X....."
 16.0,17.1,1.1,"Outer Neritic","Marine","Middle Marine","Outer Neritic","-999.95","-999.95",".........X...."
 17.1,17.8,0.69,"Upper Bathyal","Marine","Deep Marine","Upper Bathyal","-999.95","-999.95","..........X..."
 17.8,18.6,0.8,"Middle Bathyal","Marine","Deep Marine","Middle Bathyal","-999.95","-999.95","...........X.."
 18.6,20.6,2.0,"Lower Bathyal","Marine","Deep Marine","Lower Bathyal","-999.95","-999.95","............X."
 20.6,23.1,2.5,"Outer Neritic","Marine","Middle Marine","Outer Neritic","-999.95","-999.95",".........X...."
 23.1,23.9,0.79,"Middle Neritic","Marine","Middle Marine","Middle Neritic","-999.95","-999.95","........X....."
 23.9,24.5,0.6,"Fairweather Wavebase","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95","......X......."
 24.5,25.1,0.6,"Nearshore","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95",".....X........"
 25.1,26.2,1.09,"Nearshore","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95",".....XX......."
 26.2,27.0,0.8,"Upper Shoreface","Marine","Shallow Marine","Inner Neritic","Shoreface","-999.95",".....X........"
 27.0,29.6,2.6,"Nearshore","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95",".....XX......."
 29.6,30.1,0.5,"Lower Shoreface","Marine","Shallow Marine","Inner Neritic","Shoreface","-999.95",".....X........"
 30.1,30.6,0.5,"Fairweather Wavebase","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95","......X......."
 30.6,31.0,0.39,"Offshore","Marine","Shallow Marine","Inner Neritic","Offshore","-999.95",".......X......"
 31.0,32.2,1.2,"Storm wavebase","Marine","Shallow Marine","Inner Neritic","Offshore","-999.95",".......X......"
 32.2,33.2,1.0,"Middle Neritic","Marine","Middle Marine","Middle Neritic","-999.95","-999.95","........X....."
 33.2,36.2,3.0,"Outer Neritic","Marine","Middle Marine","Outer Neritic","-999.95","-999.95",".........X...."
 36.2,37.2,1.0,"Middle Neritic","Marine","Middle Marine","Middle Neritic","-999.95","-999.95","........X....."
 37.2,37.7,0.5,"Nearshore","Marine","Shallow Marine","Inner Neritic","Nearshore","-999.95",".....XX......."
 37.7,38.3,0.59,"Fresh Water","Transitional","Coastal Interdeltaic","Subaqueous","Swamp","-999.95","..X..........."
 38.2,39.5,1.29,"Fresh Water","Transitional","Coastal Interdeltaic","Subaqueous","Lagoons","-999.95","..X..........."
 39.5,40.8,1.29,"Swamps","Transitional","Deltaic","Upper Deltaic Plain","Floodbasins","-999.95",".XX..........."
 40.8,41.8,1.0,"Upper Deltaic Plain","Transitional","Deltaic","Upper Deltaic Plain","-999.95","-999.95",".X............"
 41.8,44.8,3.0,"Floodbasins","Transitional","Deltaic","Upper Deltaic Plain","Floodbasins","-999.95","..X..........."

