~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                                 VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                  224.409  : START DEPTH                    {F}
 STOP  .F                                 6654.409  : END DEPTH                      {F}
 STEP  .F                                      0.5  : STEP LENGTH                    {F}
 NULL  .                                   -999.25  : NULL VALUE                     {F}
 COMP  .          WOOLSEY OPERATING COMPANY, L.L.C  : Company                        {S}
 WELL  .                          STEPHENS TRUST 1  : Well Name                      {S}
 FLD   .                                   WILDCAT  : Field                          {S}
 SEC   .                                         0  : Section                        {I}
 TOWN  .                                        0S  : Township (e.g. 42S)            {S}
 RANG  .                                        0W  : Range  (e.g. 25E)              {S}
 LOC   .                               S3-T33S-R4W  : Location (Sec Town Range)      {S}
 LOC1  .                                  NW NE NE  : Location 1 (quarter calls)     {S}
 LOC2  .                       530' FNL & 970' FEL  : Location 2 (footages)          {S}
 COUN  .                                    Sumner  : County                         {S}
 STAT  .                                    Kansas  : State                          {S}
 CTRY  .                                       USA  : Country                        {S}
 PROV  .                                            : Province                       {S}
 SRVC  .                               Weatherford  : Service Company                {S}
 LIC   .                                            : License Number                 {S}
 DATE  .                               28/Jul/2005  : Completion Date                {DD/MMM/YYYY}
 API   .                              15-191-22454  : API-Number                     {S}
 UWI   .                                            : Unique Well ID Number          {S}
 LATI  .DEG                                    0.0  : Latitude                       {F}
 LONG  .DEG                                    0.0  : Longitude                      {F}
 GDAT  .                                     NAD27  : Geodetic Datum                 {S}
 X     .                                       0.0  : X or East-West coordinate      {F}
 Y     .                                       0.0  : Y or North South coordinate    {F}
 HZCS  .                                            : Horizontal Co-ordinate System  {S}
 UTM   .                                       0.0  : UTM Location                   {F}
 STUS  .                                       D&A  : Well Status                    {S}

~Parameter
#MNEM .UNIT                 VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                        GL  : Permanent Data                 {S}
 APD   .F                     15.0  : Above Permanent Data           {F}
 DREF  .                        KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F                   1247.0  : Elevation of Depth Reference   {F}
 RUN   .                         1  : Run Number                     {F}
 TDL   .F                   6647.0  : Total Depth Logger             {F}
 TDD   .F                   6651.0  : Total Depth Driller            {F}
 CSGL  .FEET                 321.0  : Casing Bottom Logger           {F}
 CSGD  .FEET                 319.0  : Casing Bottom Driller          {F}
 CSGS  .INCHES               8.625  : Casing Size                    {F}
 CSGW  .LB/FT                 24.0  : Casing Weight                  {F}
 BS    .INCHES                7.88  : Bit Size                       {F}
 MUD   .                  CHEMICAL  : Mud type                       {S}
 MUDS  .                RETURN PIT  : Mud Source                     {S}
 MUDD  .LB/USG                 9.3  : Mud Density                    {F}
 MUDV  .CP                    49.0  : Mud Viscosity (Funnel)         {F}
 FL    .ML/30MIN              12.8  : Fluid Loss                     {F}
 PH    .                       8.5  : PH                             {F}
 RM    .OHM-M                 0.52  : Resistivity of Mud             {F}
 RMT   .DEGF                  84.0  : Temperature of Mud             {F}
 RMF   .OHM-M                 0.42  : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEGF                  84.0  : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M                 0.62  : Resistivity of Mud Cake        {F}
 RMCT  .DEGF                  84.0  : Temperature of Mud Cake        {F}
 TMAX  .DEGF                 146.0  : Maximum Recorded Temp.         {F}
 TIMC  .DATE                        : Date/Time Circulation Stopped  {D/M/YYY}
 TIML  .DATE                        : Date/Time Logger Tagged Bottom {D/M/YYY}
 UNIT  .                      3440  : Logging Unit Number            {F}
 BASE  .                       OKC  : Home Base of Logging Unit      {S}
 ENG   .                J. BULLARD  : Recording Engineer             {S}
 WIT   .          MR. DENNIS HEDKE  : Witnessed By                   {S}

~Curve
#MNEM .UNIT             VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .FT        00 001 00 00  : Logged depth                   
 CGXT  .DEGF      30 660 01 00  : MCG External Temperature       
 SMTU  .LB        30 635 00 00  : DST Uphole Tension             
 GRGC  .GAPI      30 310 01 00  : Gamma Ray                      
 SPCG  .MV        30 010 00 00  : Spontaneous Potential          
 NPRL  .PERC      42 890 01 00  : Limestone Neutron Por.         
 CLDC  .IN        45 280 01 00  : Density Caliper                
 DCOR  .G/C3      42 356 01 00  : Density Correction             
 DEN   .G/C3      42 350 01 00  : Compensated Density            
 PDPE  .B/E       45 358 01 00  : PE                             
 DPRL  .PERC      45 890 10 00  : Limestone Density Por.         
 FEFE  .OHMM      10 220 06 00  : Shallow FE                     
 DT35  .US/F      60 520 32 00  : 3-5' Compensated Sonic         
 SPRL  .PERC      61 890 20 00  : Limestone Sonic Porosity       
 RILM  .OHMM      07 120 44 00  : Medium Induction               
 RILD  .OHMM      07 120 46 00  : Deep Induction                 

~Tops_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                      : Profile Web App Saved Data Indicator {S}
 TOPS  .           GeoReport  : Formation Source               {S}
 TOPDR .           Log Depth  : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 KEY   .                      : User Define Primary Key        {S}
 ID    .                      : Stratigraphic Unit ID          {S}
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 SSYS  .                      : Subsystem                      {S}
 SSER  .                      : Subseries                      {S}
 STG   .                      : Stage                          {S}
 GRP   .                      : Group                          {S}
 SGRP  .                      : Subgroup                       {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
# KEY ID TOPT TOPB RANK LVL TOPN EON ERA SYS SER SSYS SSER STG GRP SGRP FORM
 "1008020751270","3313207000",1700.0,0.0,"FORMATION","Poor","Onaga Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Admire","-999.25","-999.25"
 "1008020751271","3313435000",1930.0,0.0,"FORMATION","Poor","Stotler Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Wabaunsee","Richardson","Stotler Limestone"
 "1008020751272","3313473900",2131.0,0.0,"MEMBER","Poor","White Cloud Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Wabaunsee","Sacfox","Scranton Shale"
 "1008020751273","3313475000",2176.0,0.0,"FORMATION","Poor","Howard Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Wabaunsee","Sacfox","Howard Limestone"
 "1008020751274","3313477000",2252.0,0.0,"FORMATION","Poor","Severy Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Wabaunsee","Sacfox","Severy Shale"
 "1008020751275","3313601000",2333.0,0.0,"FORMATION","Poor","Topeka Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Topeka Limestone"
 "1008020751276","3313607000",2468.0,0.0,"FORMATION","Poor","Lecompton Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Lecompton Limestone"
 "1008020751277","3313608000",2561.0,0.0,"FORMATION","Poor","Kanwaka Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Kanwaka Shale"
 "1008020751278","3313609500",2716.0,0.0,"MEMBER","Poor","Heebner Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Oread Limestone"
 "1008020751279","3313609900",2730.0,0.0,"MEMBER","Poor","Toronto Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Oread Limestone"
 "10080207512710","3313800000",2750.0,0.0,"GROUP","Poor","Douglas","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Douglas","-999.25","-999.25"
 "10080207512711","3313803900",3030.0,0.0,"MEMBER","Poor","Haskell Limestone","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Douglas","-999.25","Lawrence"
 "10080207512712","3317575500",3553.0,0.0,"MEMBER","Poor","Hushpuckney Shale","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Swope Limestone"
 "10080207512713","3323300000",3667.0,3800.0,"GROUP","Poor","Marmaton","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Middle","Desmoinesian","Marmaton","-999.25","-999.25"
 "10080207512714","3323700000",3800.0,0.0,"GROUP","Poor","Cherokee","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Middle","Desmoinesian","Cherokee","-999.25","-999.25"
 "10080207512715","3400000000",3989.0,0.0,"SUBSYSTEM","Poor","Mississippian","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","-999.25","-999.25","-999.25","-999.25","-999.25"
 "10080207512716","3437000000",4256.0,0.0,"STAGE","Poor","Kinderhookian","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","Lower","Kinderhookian","-999.25","-999.25","-999.25"
 "10080207512717","3437009000",4309.0,4338.0,"FORMATION","Poor","Chattanooga Shale","Phanerozoic","Paleozoic","Devonian","-999.25","-999.25","-999.25","Kinderhookian","-999.25","-999.25","Chattanooga Shale"
 "10080207512718","3720300000",4338.0,4468.0,"GROUP","Poor","Simpson","Phanerozoic","Paleozoic","Ordovician","Middle","-999.25","-999.25","-999.25","Simpson","-999.25","-999.25"
 "10080207512719","3720300000",4399.0,4468.0,"GROUP","Poor","Simpson Shale","Phanerozoic","Paleozoic","Ordovician","Middle","-999.25","-999.25","-999.25","Simpson","-999.25","-999.25"
 "10080207512720","3730700000",4468.0,5479.0,"GROUP","Poor","Arbuckle","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","Arbuckle","-999.25","-999.25"
 "10080207512721","3810507000",5479.0,5500.0,"FORMATION","Poor","Lamotte (Reagan) Sandstone","Phanerozoic","Paleozoic","Cambrian","Upper","-999.25","-999.25","-999.25","Unkown","-999.25","-999.25"

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F             1500.0  : Starting Display Depth         {F}
 IQSTOP  .F           6654.409  : Ending Display Depth           {F}
 IQSCLE  .FT/IN            200  : Plot Scale Feet/Inch           {F}
 IQGRP   .                 ALL  : LAS, ROCK or HORIZON           {S}
 IQORDR  .             DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                NPHI  : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                      : Conductivity Image Track Curve Mnemonic {S}
 IQOHM_L .MMHO/M                : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M                : Conductivity Image Track Maximum Value {F}
 IQPHI   .                      : Porosity Image Track Curve Mnemonic {S}
 IQPHI_L .PU                    : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                    : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
# IQ_SRC IQ_TYPE IQ_DESC
 "LAS","LITH","Lithology - Gamma Ray"
 "LAS","LAS","LAS - Reference - GR,SP,CAL Logs"
 "LAS","LAS","LAS - Induction Resistivity Logs"
 "LAS","LAS","LAS - Litho-Density - NPHI,RHOB,PE Logs"
 "LAS","LITH","Colorlith - Rhomaa-Umaa Track"
 "LAS","ROCK","Lithology - Rhomaa-Umaa Track"
 "LAS","PHI","Thin Porosity Track"
 "LAS","GRAIN","Texture - by Gamma Ray"
 "TOPS","STRAT","Horizons - Stratigraphic Units"
 "ROCK","ROCK","Lithology - Rock Column"
 "ROCK","GRAIN","Texture - by User Input"
 "ROCK","ICON","Sedimentary Structures"
 "ROCK","ICON","Fossils"
 "ROCK","COLOR","Color - Rock RGB Values"
 "ROCK","DESC","Description"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT                 VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                       YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F                   1500.0  : Starting Display Depth         {F}
 GEOSTOP .F                   5560.0  : Ending Display Depth           {F}
 GEOSRC  .          Geologist Report  : Source                         {S}
 GEOREF  .                 Log Depth  : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
# GEOTOP GEOBASE GEOBED GEODES
 1500.0,1505.0,5.0,"1500.0; 1505.0; LS: cm-Gy pkst w/pr-fr por; NS "
 1505.0,1512.5,7.5,"1505.0; 1512.5; sm wkst-mdst w/Pr pro to NV por; NS "
 1512.5,1520.0,7.5,"1512.5; 1520.0; Abndt SH: Gy-Blk & gn-Gy Rr mm-rd-SH "
 1520.0,1525.0,5.0,"1520.0; 1525.0; "
 1525.0,1540.0,15.0,"1525.0; 1540.0; LS: Wh-Gy Wkst-Mdst w/Vpr por-NV por; NS "
 1540.0,1542.5,2.5,"1540.0; 1542.5; Rare ( Rr ) LS: As Above ( AA ) "
 1542.0,1552.5,10.5,"1542.0; 1552.5; Pred SH: AA, small cavings "
 1552.5,1565.0,12.5,"1552.5; 1565.0; Very Rare (Vrr) LS: AA & LS:cm-Gy pkst "
 1565.0,1567.5,2.5,"1565.0; 1567.5; "
 1567.5,1580.0,12.5,"1567.5; 1580.0; Pred SH: AA-cavings w/sm Anhy cavings "
 1580.0,1585.0,5.0,"1580.0; 1585.0; Pr Samples "
 1585.0,1595.0,10.0,"1585.0; 1595.0; Vrr LS: cm-Tn-Gy wkst-mdst w.Vpr por - NV por "
 1595.0,1600.0,5.0,"1595.0; 1600.0; Pred SH: AA ( Rr Anhy ) "
 1600.0,1605.0,5.0,"1600.0; 1605.0; Vrr LS: AA "
 1605.0,1607.5,2.5,"1605.0; 1607.5; "
 1607.5,1615.0,7.5,"1607.5; 1615.0; Vrr LS: cm-Tn-Gy Pkst-fos w/Pr-Fr vis por; NS "
 1615.0,1620.0,5.0,"1615.0; 1620.0; Trc Gd por; NS "
 1620.0,1630.0,10.0,"1620.0; 1630.0; V.Abndt SH: gn-Gy-Blk & Rr mm-rd SH. Vrr ( very rare ) LS: AA "
 1630.0,1635.0,5.0,"1630.0; 1635.0; ( Abndt cavings-SH & Rr Anhy ) "
 1635.0,1640.0,5.0,"1635.0; 1640.0; V.Abndt SH: AA "
 1640.0,1650.0,10.0,"1640.0; 1650.0; Rr LS: Tn-Gy dn Mdst & sm Wkst w/Pr por to NV por; NS "
 1650.0,1660.0,10.0,"1650.0; 1660.0; SH: Lt-dk Gy & gn - Gy & Blk carb sm V.gated Rr rd-mm SH "
 1660.0,1670.0,10.0,"1660.0; 1670.0; SH: AA ( V. Abndt ) "
 1670.0,1680.0,10.0,"1670.0; 1680.0; SH: AA ( V. Abndt ) "
 1680.0,1690.0,10.0,"1680.0; 1690.0; Vrr LS: cm-Tn-Gy, dn mdst-subchlky-wkst. V.Pr por - NV por; NS "
 1690.0,1700.0,10.0,"1690.0; 1700.0; SH: gn-Gy-Blk & sm rd-mm-Bn SH-v.gated "
 1700.0,1700.0,-999.25,"1700.0; Onaga Shale "
 1700.0,1702.5,2.5,"1700.0; 1702.5; LS: ( Vrr ) cm-Tn-Gy fos Pkst w/Pr-Fr por. Trc Gd por. NS & Vrr Mdst-Wkst w/V.Pr por - NV por. NS "
 1702.5,1705.0,2.5,"1702.5; 1705.0; SH: gn-Gy & Blk & rd-mm SH "
 1705.0,1722.5,17.5,"1705.0; 1722.5; SH; AA "
 1722.5,1735.0,12.5,"1722.5; 1735.0; Vrr Silts: Gy & gn-Gy, Trc sndy, micac V.Pr-Pr vis por; NS, NGK ( No Gas Kick ) "
 1735.0,1750.0,15.0,"1735.0; 1750.0; Pred SH: gn-Gy; AA "
 1750.0,1760.0,10.0,"1750.0; 1760.0; Vrr LS: cm-Tn-Gy, Mdst-Wkst; Pr. por - NV por; NS; Trc Pkst; Pr-Fr por; NS "
 1760.0,1770.0,10.0,"1760.0; 1770.0; V.Abndt SH: AA - gn-GY "
 1772.5,1772.5,-999.25,"1770.0. 1772.5; V.Abndt SH: AA "
 1772.5,1780.0,7.5,"1772.5; 1780.0; Vrr LS: cm-Tn-Gy Mdst-Wkst w/Pr. por - NV por; NS "
 1780.0,1790.0,10.0,"1780.0; 1790.0; Vrr ( Very Rare ) Pkst: Gy-Tn-cm; microX - v.fnXln; Fr. por; NS Trc Gd Por "
 1790.0,1792.5,2.5,"1790.0; 1792.5; "
 1792.5,1800.0,7.5,"1792.5; 1800.0; Pred SH: v.gated - gn-Gy & Blk, Rr mm-rd "
 1800.0,1810.0,10.0,"1800.0; 1810.0; SH: AA ( As Above ) ( Vrr LS: AA ) "
 1810.0,1820.0,10.0,"1810.0; 1820.0; SH: AA "
 1820.0,1830.0,10.0,"1820.0; 1830.0; SH: AA, sm Blk carb, pyritic "
 1830.0,1840.0,10.0,"1830.0; 1840.0; SH: AA "
 1840.0,1850.0,10.0,"1840.0; 1850.0; > 99% SH: gn-Gy & Blk &  mm-rd SH "
 1850.0,1860.0,10.0,"1850.0; 1860.0; SH: AA, v.gated, Si lncrs Blk. carb SH & Gy-Blk SH "
 1860.0,1870.0,10.0,"1860.0; 1870.0; SH: AA "
 1870.0,1877.5,7.5,"1870.0; 1877.5; Vrr LS. cm-Tn-Gy Wkst & Pkst w/VPr. por - Fr. por; NS "
 1877.5,1900.0,22.5,"1877.5; 1900.0; V. Abndt SH; AA; gn-Gy & Blk, sm mm-rd "
 1900.0,1910.0,10.0,"1900.0; 1910.0; Vrr LS: cm-Tn-Gy-Bn, microX-fnXln Pkst & Wkst w/Pr. por & NV por ( Rr Anhy cavings ) "
 1910.0,1920.0,10.0,"1910.0; 1920.0; V.Abndt SH: AA; gn-Gy & Blk, sm mm-rd "
 1920.0,1930.0,10.0,"1920.0; 1930.0; SH: AA "
 1930.0,1930.0,-999.25,"1930.0; Stotler Limestone "
 1930.0,1932.5,2.5,"1930.0; 1932.5; Trc LS: AA "
 1932.5,1940.0,7.5,"1932.5; 1940.0; Trc Wh-chlky LS & Wh-Gy-Tn Mdst-Wkst w/Pr. por & NV por; NS "
 1940.0,1945.0,5.0,"1940.0; 1945.0; "
 1945.0,1952.5,7.5,"1945.0; 1952.5; Vrr Sd Clust: Gy & gn-Gy Vft Gr'd silty w/Pr.-Fr vis l.Gr Por; NSGB ( No Show Gas Bubls ) "
 1952.5,1960.0,7.5,"1952.5; 1960.0; "
 1960.0,1965.0,5.0,"1960.0; 1965.0; Vrr LS: AA "
 1965.0,1970.0,5.0,"1965.0; 1970.0; SH: AA; Rr silts; Gy micac "
 1970.0,1980.0,10.0,"1970.0; 1980.0; V.Abndt SH: AA ( Trc sd clust: AA ) "
 1980.0,1990.0,10.0,"1980.0; 1990.0; V.Abndt SH: AA ( Vrr Anhy: AA ) "
 1990.0,1997.5,7.5,"1990.0; 1997.5; Vrr LS: ( Si lncrs ) cm-Tn-Gy, Mdst-Wkst w/Pr. por to NV por; NS "
 1997.5,2002.5,5.0,"1997.5; 2002.5; V.Abndt SH: AA - gn-Gy & Blk "
 2002.5,2010.0,7.5,"2002.5; 2010.0; Trc Sd Clust; Lt Gy, Vfn Gr'd silty w/Pr.por - Fr.por; NS; Silts: LtGy, gn-Gy, mica "
 2010.0,2030.0,20.0,"2010.0; 2030.0; Vrr LS; Wh-Tn, chlky to dn Mdst-Wkst w/Pr. vis por to NV por; NS; V.Abndt SH: Aa "
 2030.0,2032.5,2.5,"2030.0; 2032.5; Trc Chert: Wh-Tn-Gy fos "
 2032.5,2052.5,20.0,"2032.5; 2052.5; Pred. SH: gn-Gy & dk Gy-Blk, sm mm-rd & Bn SH. Trc Silts: gn-Gy w/Blk carb SH "
 2052.5,2055.0,2.5,"2052.5; 2055.0; Trc Sd Clust: Lt Gy, Vfn Gr'd, silty w/Pr.-Fr. por; NS "
 2055.0,2060.0,5.0,"2055.0; 2060.0; Trc LS: AA, Trc Pkst; NS "
 2060.0,2070.0,10.0,"2060.0; 2070.0; V.Abndt SH: AA "
 2070.0,2072.5,2.5,"2070.0; 2072.5; Vrr LS: Wy-Tn-Gy, Mdst & Wkst, Trc Pkst. Pr. por to NV por; NS "
 2072.5,2085.0,12.5,"2072.5; 2085.0; > 99% SH: gn-Gy-Blk & mm-rd; SH: AA "
 2085.0,2100.0,15.0,"2085.0; 2100.0; LS: AA "
 2100.0,2120.0,20.0,"2100.0; 2120.0; Pred SH: AA; Trc LS; cm-Tn-Gy Mdst-Wkst, Pr.por - NV por. "
 2120.0,2130.0,10.0,"2120.0; 2130.0; SH: Lt-dk gn-Gy, sm Blk sm rd-mm-brn SH "
 2131.0,2131.0,-999.25,"2131.0; White Cloud Shale "
 2130.0,2140.0,10.0,"2130.0; 2140.0; Trc Sd Clust: Lt. Gy, vfn Gr'd, silty frbl w/Pr.-Fr. vis l. Gr por; NSGB; NGK; Trc silts; Gy, sndy: Vfn Gr'd micac. VPr.-Pr. por; NS; ( Samples > 99% SH; AA ) "
 2140.0,2150.0,10.0,"2140.0; 2150.0; Trc Sd Clust: AA; Trc Silts: AA; SH: AA "
 2150.0,2167.5,17.5,"2150.0; 2167.5; V.Abndt SH: AA- gn-Gy & Blk & sm rd-mm "
 2167.5,2172.5,5.0,"2167.5; 2172.5; Vrr LS: cm-Tn, Mdst-Wkst; Pr. por - NV por; NS "
 2175.5,2175.0,0.5,"2175.5; 2175.0; SH: AA "
 2176.0,2176.0,-999.25,"2176.0; Howard Limestone "
 2175.0,2185.0,10.0,"2175.0; 2185.0; Vrr LS: AA & Pkst Gy-Tn-cm w/Pr. vis por; NS "
 2185.0,2200.0,15.0,"2185.0; 2200.0; Pred. SH: AA "
 2200.0,2212.5,12.5,"2200.0; 2212.5; Grst-Fr-Gd por. Trc oomidc w/VGd por; NS; Trc chertL Wh-Tn-Gy, fos chert "
 2212.5,2220.0,7.5,"2212.5; 2220.0; V.Abndt SH: AA "
 2220.0,2230.0,10.0,"2220.0; 2230.0; Vrr LS: AA Mdst-Wkst w/Pred Pr por - NV por; NS "
 2230.0,2240.0,10.0,"2230.0; 2240.0; Vpr Samples; > 99% SH cavings w/Rr Anhy "
 2240.0,2250.0,10.0,"2240.0; 2250.0; AA "
 2252.0,2252.0,-999.25,"2252.0; Severy Shale "
 2250.0,2255.0,5.0,"2250.0; 2255.0; SH; AA, sl lncrs in Blk subcarb to carb SH; sl pyrite "
 2255.0,2282.5,27.5,"2255.0; 2282.5; Trc Sd Clusters; Lt Gy Vfn Gr'd, well cmt'd to subfribl w/Pr - Fr vis l.Gr por w/NS. Silty "
 2282.5,2290.0,7.5,"2282.5; 2290.0; > 99% SH: AA "
 2290.0,2300.0,10.0,"2290.0; 2300.0; SH: gn-Gy-Blk & mm-rd SH "
 2300.0,2310.0,10.0,"2300.0; 2310.0; SH: AA "
 2310.0,2333.0,23.0,"2310.0; 2333.0; Trc Silts: lt-md Gy sndy: Vfn Gr'd VPr-Pr vis por; NS; Trc Sd Clust: Lt Gy vfn Gr'd silty Pr vis por; NS; > 99% SH; AA "
 2333.0,2333.0,-999.25,"2333.0; Topeka Limestone "
 2333.0,2342.5,9.5,"2333.0; 2342.5; LS- cm-Tn-Gy, microX - fnX dn Mdst & Wkst w/Pr vis por to NV por; NS "
 2342.5,2350.0,7.5,"2342.5; 2350.0; Vrr LS: Wh-Tn-Gy, micrX - fnXln Pkst - Grst sm fos & sm ool w/ Fr-Gd vis por; l.fos por; l.ool por, l.gr Por; vug por; NS; sm chlky LS & Mdst-Wkst: AA "
 2350.0,2365.0,15.0,"2350.0; 2365.0; Vrr LS: AA "
 2365.0,2390.0,25.0,"2365.0; 2390.0; VPr samples > 99% SH cavings AA. Trc LS "
 2390.0,2400.0,10.0,"2390.0; 2400.0; SH: gn-Gy & Blk & rd-mm: AA; Trc LS: AA "
 2400.0,2410.0,10.0,"2400.0; 2410.0; SH: AA "
 2410.0,2430.0,20.0,"2410.0; 2430.0; SH: AA; lncrs dk Gy-Blk sub carb to carb SH "
 2430.0,2445.0,15.0,"2430.0; 2445.0; SH: AA; sl lncrs dk Gy-Blk fiss & carb SH "
 2445.0,2450.0,5.0,"2445.0; 2450.0; Pred SH: AA "
 2450.0,2460.0,10.0,"2450.0; 2460.0; Vrr LS: Wh-Tn-Gy microX - fnXln, sm Pkst w/Pr-Fr por; NS; sm Mdst & Wkst & chlky LS "
 2460.0,2468.0,8.0,"2460.0; 2468.0; Pred SH: AA "
 2468.0,2468.0,-999.25,"2468.0; Lecompton Limestone "
 2468.0,2482.5,14.5,"2468.0; 2482.5; Rr LS: AA ( sl lncrs LS ); NS & Rr LS: Wh-chlky to cm-Tn Mdst-Wkst; Vrr Pkst: microX - fnXln; Trc Fr-Gd por; NS "
 2482.5,2485.0,2.5,"2482.5; 2485.0; "
 2485.0,2490.0,5.0,"2485.0; 2490.0; "
 2490.0,2530.0,40.0,"2490.0; 2530.0; ( VPr samples; >95% SH: AA ) SH: gn-Gy & Blk, sm rd-mm SH ( sm Anhy cavings ) "
 2530.0,2535.0,5.0,"2530.0; 2535.0; Trc LS: cm-Tn & Gy, microX - fnXln, Mdst-Wkst w/VPr por - NV por "
 2535.0,2550.0,15.0,"2535.0; 2550.0; Pred SH AA "
 2550.0,2561.0,11.0,"2550.0; 2561.0; Sl lncrs LS: AA "
 2561.0,2561.0,-999.25,"2561.0; Kanwaka Shale "
 2561.0,2590.0,29.0,"2561.0; 2590.0; Vrr ( Very rare ) Sd Clust: Lt Gy, gn-Gy, Vfn-fn Gr'd well sort'd, anglr-subrnd'd wekk cnt'd to sub fribl. w/Pr-Fr l.Gr por; NS: sm v.silty, shly, micac; sm Silts: lt-dk Gy, micac Pred. SH: AA "
 2590.0,2590.0,-999.25,"2590.0; Elgin Sandstone "
 2590.0,2605.0,15.0,"2590.0; 2605.0; SS: Sd Clust: LtGy, gn-Gy, Vfn-fn Gr'd, anglr to submd'd, well sort'd well cmt'd to fribl, silty & micac. Pr-Fr vis l.Gr por; NS "
 2605.0,2620.0,15.0,"2605.0; 2620.0; Silts: Lt-med Gy, gn-Gy, micac, sm sndy; V.Abndt SH: AA-cavings "
 2620.0,2632.5,12.5,"2620.0; 2632.5; Pred SH: AA; gn-Gy & Blk & sm rd-mm SH ( Pred cavings ) "
 2632.5,2650.0,17.5,"2632.5; 2650.0; Rr SIlts: Lt Gy & gn-Gy micac & sm sndy Vrr Sd Clusters: AA; vfn-fn Gr'd w/VPr-Pr por, Trc Fr l.Gr por; NS; Vrr sd clust; AA; NS "
 2650.0,2660.0,10.0,"2650.0; 2660.0; Vrr Sd, ClustL AA; NS "
 2660.0,2675.0,15.0,"2660.0; 2675.0; SH-Silts: md-dk Gy-Blk sm spkl'd micac, sm sndy vfn Gr'd; "
 2675.0,2690.0,15.0,"2675.0; 2690.0; Sd Clust: AA, pred vfn Gr'd w/Pr vis por; NS "
 2690.0,2697.5,7.5,"2690.0; 2697.5; LS: ( Rr ) Tn-Gy-Bn microX - dn Mdst & Vsl fos - Wkst, sm argil - shly & SH: Blk carb "
 2697.5,2702.5,5.0,"2697.5; 2702.5; LS: AA, lncrs dn hd, dk Gy-Bn, cryptoX - microX, Mdst-Wkst "
 2702.5,2710.0,7.5,"2702.5; 2710.0; SH: Blk carb - V.carb "
 2710.0,2716.0,6.0,"2710.0; 2716.0; LS: Tn-Gy-Bn, cryptoX - fnX dn hd Mdst & fm Wkst sm argil-shly; NV por "
 2716.0,2716.0,-999.25,"2716.0; Heebner Shale "
 2716.0,2730.0,14.0,"2716.0; 2730.0; SH: Blk v.carb-subcarb & dk Gy-Blk ( V.Abndt. Lt-Dk Gy & gn-Gy SH: AA ); Silts: Lt-dk Gy, Vrr sd clust AA w/NS "
 2730.0,2730.0,-999.25,"2730.0; Toronto Limestone "
 2730.0,2740.0,10.0,"2730.0; 2740.0; LS: ( lncrs 2760' ) Tn-Gy-Bn, cm microX-fnCln, pred dn Mdst & Wkst; Pr vis por - NV por "
 2740.0,2745.0,5.0,"2740.0; 2745.0; LS: AA; lncrs ( 2770' ) Gy-Bn & tn, dn Mdst - Wkst "
 2745.0,2750.0,5.0,"2745.0; 2750.0; LS: Wh-cm-Tn, microX sm chlky & subchlky wkst; Pr-VPr por; NS; Vrr pkst "
 2750.0,2750.0,-999.25,"2750.0; Douglas "
 2750.0,2770.0,20.0,"2750.0; 2770.0; SH: AA, sm Blk carb - V.carb & dk Gy, sm gn-Gy "
 2770.0,2780.0,10.0,"2770.0; 2780.0; SH: Pred SH: AA, Rr LS; AA. NS "
 2780.0,2810.0,30.0,"2780.0; 2810.0; LS: cm-bf-Tn, microX - fnXln sm dn Mdst - Wkst w/Pr por - NV por; Rr Pkst - Grst w/Fr. por; l.Gr por; pp por - vug por, lX por; NS ( lncrs LS: AA in 2820' spl ) "
 2810.0,2820.0,10.0,"2810.0; 2820.0; LS: AA, sm Pkst-Rr Grst w/ Pr-Fr por Vrr Gd por; NS; sm Wh-chlky & subshlky; sm fn ool & fos Pkst: AA "
 2820.0,2822.5,2.5,"2820.0; 2822.5; Abndt LS: AA, NS "
 2822.5,2830.0,7.5,"2822.5; 2830.0; SH: Lt-dk Gy & gn-Gy sm silty micac & sm sndy: vfn Gr'd. & dk Gy-blk fiss SH: sm carb; Silts: Lt Gy & gn-Gy, micac, sndy ( 2860' spl ) Vrr Sd Clust: Lt Gy, gn-Gy, vfn Gr'd well cmt'd - clac, micac, silty VPr - Pr vis l.Gr por; NS "
 2830.0,2860.0,30.0,"2830.0; 2860.0; SILTS: AA ( lncrs ) & SH: AA "
 2860.0,2870.0,10.0,"2860.0; 2870.0; SILTS & SH: AA sm Sd Clust. ( sm LS: AA ); NS "
 2870.0,2880.0,10.0,"2870.0; 2880.0; Silts: Lt-md gn-Gy ( lncrs ) sndy, micac, VPr-Pr por; NS; "
 2880.0,2890.0,10.0,"2880.0; 2890.0; SS-Sd Clust: LtGy, gn-Gy, vfn Gr'd silty, micac, well cmt'd-calc w/vPr-Pr vis por; NS & SH: gn-Gy & Blk "
 2890.0,2900.0,10.0,"2890.0; 2900.0; ( Frly Abndt LS: cm-Tn, microX-fnXln, Trc mdX sm Pkst - Grst w/ Pr-Fr por. Trc Gd por; NS "
 2900.0,2920.0,20.0,"2900.0; 2920.0; SH: dk-Lt Gy, sm micac & sm silty Silts: Lt-dk Gy & gn-Gy micac & sndy: vfn-fn Gr'd VPr-Pr por; NS "
 2920.0,2935.0,15.0,"2920.0; 2935.0; SS-sm Sd Clust: Lt Gy & gn-Gy, vfn-fn Gr'd, well cmt'd micac, calc, silty; VPr-Pr vis l.Gr por; NS "
 2935.0,2940.0,5.0,"2935.0; 2940.0; Pred SH: dk-Lt Gy-sm Blk & gn-Gy, sm silty & SILTS: AA - sndy "
 2940.0,2950.0,10.0,"2940.0; 2950.0; Rr Sd Clust: AA, VPr.-Pr. por; vis l.Gr por; NS "
 2950.0,2960.0,10.0,"2950.0; 2960.0; SH; AA, lncrs dk Gy-Blk fiss subcarb to carb SH "
 2960.0,2970.0,10.0,"2960.0; 2970.0; Silts & SH: lt-dk Gy & gn-Gy, sm micac, sm sndy. Vrr Sd Clust: AA, vfn-fn Gr'd, well cmt'd w/VPr-Pr vis l.Gr por; NS "
 2970.0,2985.0,15.0,"2970.0; 2985.0; SH: AA; lncrs md-dkGy & Blk, sm sl pyrtc, sm silts & gn-Gy SH: AA; Rr Silty Sd Clustl AA; NS "
 2985.0,3000.0,15.0,"2985.0; 3000.0; SH: AA, pred dk Gy-Blk fiss sub carb to carb "
 3000.0,3010.0,10.0,"3000.0; 3010.0; SH: AA, ( Rr Silts: AA, Trc Sd Clust: AA, NS ) "
 3010.0,3020.0,10.0,"3010.0; 3020.0; SH: med-dk Gy-Blk, sm gn-Gy, sm pyrtc "
 3020.0,3030.0,10.0,"3020.0; 3030.0; SH: AA, lncrs dk Gy-Blk fiss, sub carb to carb "
 3030.0,3030.0,-999.25,"3030.0; Haskell Limestone "
 3030.0,3035.0,5.0,"3030.0; 3035.0; LS: Tn-Gy-Bn, microX-fnX, sm dn Wkst-Mdst. Rr Pkst ool & fos w/Pr por - NV por "
 3035.0,3050.0,15.0,"3035.0; 3050.0; SH: AA & Silts: ( lncrs ) Lt Gy & gn-Gy, sndy micac, sm calc. VPr vis por "
 3050.0,3070.0,20.0,"3050.0; 3070.0; SS: Sd Clust: Ly Gy-Wh, gn-Gy, pred vfn Gr'd, micac-silty, Vrr prt fn Gr'd well cmt'd to fribl w/VPr to Fr por; NS; NSGB. AA; lncrs silty Sd; Silts: Lt-dk Gy, micac, sm sndy & gn-Gy & SH: AA. sm sd clusters: AA; NS "
 3070.0,3090.0,20.0,"3070.0; 3090.0; Silts: AA, lncrs Lt Gy, sm sndy, micac, sl pyrtc, Sm Sd Clust: Lt Gy-Wh vfn Gr'd silty micac, Vrr vfn Gr'd silty micac, vrr vfn-fn gr'd, well cmt'd fribl w/VPr por-Fr por; NS; Pred Silts: Lt Gy & Lt gn-Gy - AA "
 3090.0,3100.0,10.0,"3090.0; 3100.0; SS-Sd Clust: Lt Gy & Lt Gn-Gy Pred vfn Gr'd, Rr vfn-fn Gr'd, V.well-well sort'd, sm fribl w/Fr por; NS. Silty, micac "
 3100.0,3110.0,10.0,"3100.0; 3110.0; Abndt Sd Clust; AA, NS; Silts: Lt Gy, sndy: vfn Gr'd, micac, VPr-Pr vis por; NS; NF "
 3110.0,3120.0,10.0,"3110.0; 3120.0; SS: Incrs Sd Clust: Lt Gy, vfn Gr'd & vfn-fn Gr'd sm silty, sm Frly 'cln,' micac sm Fr-Gd l.Gr por; NS; NF "
 3120.0,3142.5,22.5,"3120.0; 3142.5; SS- Sd Clust: AA, lncrs vfn to fn Gr'd well sort'd, Vrr prt med Gr'd sm micac & silty, sm Fr to Gd l.Gr por; NS; NF; fribl to well cmt'd. Pred Pr-Fr vis por w.NS; NF & Silts: lt-med-Gy, gn-Gy, micac, sndy, VPr por; NS "
 3142.5,3160.0,17.5,"3142.5; 3160.0; SS-Sd Clust: ( Abndt ) Lt Gy  vfn Gr'd-Rr vfn-fn Gr'd sm micac, silty, well cmt'd to sub fribl w/Pr-Fr vis por; NS; Fr frible w/Gd l.Gr por; NS; NF & silts: Lt Gy-med Gy sm sndy, micac, VPr-Pr por; NS "
 3160.0,3170.0,10.0,"3160.0; 3170.0; SS-Sd Clust: AA, vfn Gr'd Rr fvn-fn-Gr'd, well cmt'd to fribl w/PR-Fr por Vrr Gd por; NS; NF "
 3170.0,3190.0,20.0,"3170.0; 3190.0; SH: ( lncrs ) md-dk Gy & Blk sm carb, sm micac ( Frly Abndt Sd Clust & Silts: AA, NS; NF ) "
 3190.0,3210.0,20.0,"3190.0; 3210.0; SH: ( lncrs ) dk Gy-Blk, sm carb, sm med Gy & gn-Gy SH & Silts. ( Decrs Sd Clust: AA, NS ) "
 3210.0,3230.0,20.0,"3210.0; 3230.0; SH: Pred dk Gy to Blk sub carb to carb SH. ( sm silts: AA, Rr Sd Clust: AA, NS ) "
 3230.0,3270.0,40.0,"3230.0; 3270.0; SH: Abndt dk Gy-Blk subcarb to carb SH "
 3270.0,3280.0,10.0,"3270.0; 3280.0; SH: Pred dk Gy-Blk subn carb to subcarb SH sm gn-Gy & Bn SH "
 3280.0,3290.0,10.0,"3280.0; 3290.0; Vrr LS: Gy-Bn, cryptoX-dn Mdst "
 3290.0,3300.0,10.0,"3290.0; 3300.0; SH: AA lncrs Blk subcarb to carb, Vrr pyrtc ( Vrr Sd Clust: AA; NS ) "
 3300.0,3310.0,10.0,"3300.0; 3310.0; SH: AA "
 3310.0,3320.0,10.0,"3310.0; 3320.0; SH: dk Gy-Blk, dk gn-Gy sm Lmy, sm calc "
 3320.0,3330.0,10.0,"3320.0; 3330.0; SH: dk-md Gy & Gy-Blk AA, sm pyrtc, sm silts: AA "
 3330.0,3347.5,17.5,"3330.0; 3347.5; SH: AA, lncrs Blk carb & subcarb "
 3347.5,3355.0,7.5,"3347.5; 3355.0; LS: Tn-Gy, microX-fnX - dn Mdst-Wkst VPr - NV por "
 3355.0,3357.5,2.5,"3355.0; 3357.5; SH: AA, Gy-Blk "
 3357.5,3377.5,20.0,"3357.5; 3377.5; LS: Wh-Tn, microX-fnX., sm Wkst-Pkst w/pred Pr-Fr por: pp-vug por, lX por; Vrr Gd vis por w/SN; sm subchlky to chlky * dn Mdst w/Vpr por to NV por & NS "
 3377.5,3380.0,2.5,"3377.5; 3380.0; SH: AA, md-dk Gy & Blk carb "
 3380.0,3410.0,30.0,"3380.0; 3410.0; LS: Wh-Tn-Gy, microX-fnXln sm subchlky to chlky pred Mdst-Wkst w.VPr-Pr por; sm Pkst w/Fr-Gd vug por; NS. Sm lX por & lGr por; NS; Cherty: Gy-bf-Wh, shrp.frsh "
 3410.0,3420.0,10.0,"3410.0; 3420.0; LS: AA, Rr Fr-Gd por; NS; Vrr prt mdx-2nd ReX sm lX por; NS; SH: AA; sm dn Mdst-Wkst "
 3420.0,3440.0,20.0,"3420.0; 3440.0; LS: Tn-Gy-Wh, microX-fnXln sm Fr-Gd lX por & vig por w/NS; sm Wkst-Pkst sm fos fragmnts w/Fr-Gd por; NS; sm chlky & subchlky w/VPr-Pr por; NS; Rr Chert: AA "
 3440.0,3450.0,10.0,"3440.0; 3450.0; LS: AA & SH: AA sm cavings "
 3450.0,3465.0,15.0,"3450.0; 3465.0; LS: cm-Tn, microX-fnX - dn to chlky. Mdst-Wkst; Pred Pr por - NV por; NS ( sm Pkst: AA w/por; NS ) "
 3465.0,3485.0,20.0,"3465.0; 3485.0; LS: Tn-gm, microX-fnXln, Rr prt mdXln, oomidc & prt ool Pkst-Grst & V.comidc w.Fr to V.Gd por; pred oomidc por sm l.ool por & lX por; NS; sl Cherty "
 3485.0,3490.0,5.0,"3485.0; 3490.0; LS: AA, prt oomidc-v.ppmidc w. Fr-VGd por; NS; sl cherty "
 3490.0,3505.0,15.0,"3490.0; 3505.0; LS: Tn-Gy-Wh, microX-fnXln pred Mdst-Wkst w/Pr por - NV por; NS; sl cherty Tn-Gy-Bn shrp Chert "
 3505.0,3507.5,2.5,"3505.0; 3507.5; SH: Blk carb-v.carb "
 3507.5,3520.0,12.5,"3507.5; 3520.0; LS: cm-Tn-Gy-Bn, microX-fnXln, Pred dn-sm Mdst-sm Wkst w/Pr por - NV por; Vrr microfrac's-2nd Rex w/FLR ( brt ); NSFO. Pr lX por "
 3520.0,3530.0,10.0,"3520.0; 3530.0; SH: Pred dk Gy-Bn-Blk "
 3530.0,3540.0,10.0,"3530.0; 3540.0; LS: Tn-Bn, Gy-Bn, microX-Rr fnX, pred dn hd-Mdst-Wkst w/VPr por-NV por w/ NSFO "
 3540.0,3553.0,13.0,"3540.0; 3553.0; LS: Tn-Gy-Wh, microX-fnXln, Trc md X's, Mdst-Wkst w/Pr-Fr por pp por, lX por, microFrac por w/spt'd to sat brt FLR in 5%, sl s. gas bubl -conds & vsl SFO Vrr VLt spt'd-subsat O.STN; Vrr Pkst: Trc Gd por; FLR-SFOil; Abndt dn Mdst-Wkst "
 3553.0,3553.0,-999.25,"3553.0; Hushpuckney Shale "
 3553.0,3560.0,7.0,"3553.0; 3560.0; SH: Blk carb-v.carb "
 3560.0,3572.5,12.5,"3560.0; 3572.5; LS: Tn-Gy-Wh, microX-Rr prtfnXln, pred dn Mdst & Wkst - sm sl fos Vrr Pkst Rr Pr por - VPr vis por: microFrac's & Edg's & pp por - lX por w/ spt'd - sub-sat brt FLR & VSISFOil on brk & Gas Bubls - Conds; Vrr spt'd-subsat Lt Tn O.STN & CPr cut; No odor "
 3572.5,3580.0,7.5,"3572.5; 3580.0; "
 3580.0,3590.0,10.0,"3580.0; 3590.0; SH: dk Gy-Blk, fis, sm carb ( lncrs SHL AA in 3590' spl ) "
 3590.0,3600.0,10.0,"3590.0; 3600.0; SH: AA; lncrs Blk carb-v.carb & LS: AA, pred dn Mdst & Wkst w/Pr por - NV por "
 3600.0,3610.0,10.0,"3600.0; 3610.0; LS: dk Gy-Bn-Blk, microX-fnX, pred dn Mdst, sm shly-argil. VPr por-NV por "
 3610.0,3617.0,7.0,"3610.0; 3617.0; LS: AA, lncrs dk Gy-Blk microX-dn-Mdst-argil. V.Pr por - NV por. NS "
 3617.0,3625.0,8.0,"3617.0; 3625.0; SH: Blk subcarb-carb fis & dk-md Gy "
 3625.0,3632.5,7.5,"3625.0; 3632.5; LS: AA "
 3632.5,3635.0,2.5,"3632.5; 3635.0; SH: Blk subcarb-carb fis & dk-md Gy "
 3635.0,3650.0,15.0,"3635.0; 3650.0; Abndt LS: AA, pred VPr por to NV por w/NS. Pred dn & argil LS "
 3650.0,3660.0,10.0,"3650.0; 3660.0; SH: Abndt Blk subcarb fis to car SH & dk Gy-Blk, sm md gn-Gy SH "
 3660.0,3667.0,7.0,"3660.0; 3667.0; Sm LS: AA & LS: cm-Tn microX-fnX - Wkst-Pkst w. Pred Pr vis por; NS ( Pred SH: AA ) "
 3667.0,3667.0,-999.25,"3667.0; Marmaton "
 3667.0,3685.0,18.0,"3667.0; 3685.0; LS: ( lncrs ) Tn-Gy-cm microX-fnXln, Pred Mdst-dn, sm Wkst-Pkst w/Pr-Fr vis por w/NS. LS: sm dn Mdst-Wkst AA, Rr subchlky-chlky "
 3685.0,3687.5,2.5,"3685.0; 3687.5; SH: ( lncrs ) Blk carb & dk Gy to Blk & med-dk gn-Gy "
 3687.5,3690.0,2.5,"3687.5; 3690.0; "
 3690.0,3707.5,17.5,"3690.0; 3707.5; LS: ( Shrp lncrs ) Tn-cm, microX-Rr fnXln, Red dn Mdst & Wkst, Rr Pkst: ool - V.ool; sm VPr-Pr por; micro Frac por & microlX por & l.ool por; Vrr brt spt'd FLR; Trc SFOil-Conds & Gas Bubls & VPr cut "
 3707.5,3712.5,5.0,"3707.5; 3712.5; Abndt SH: dk Gy-Blk, sm carb & gn-Gy SH "
 3712.5,3722.5,10.0,"3712.5; 3722.5; LS: Tn-Gy-Bn, microX-fnX, Pred dn Mdst, sm Wkst-Pkst, Pr vis por to NV por w/NSF "
 3722.5,3732.5,10.0,"3722.5; 3732.5; SH: lncrs dkGy to Blk sm carb, fis "
 3732.5,3745.0,12.5,"3732.5; 3745.0; LS: dk Gy-Blk microX-dn-hd Mdst VPr por-NV por & SH: dk-Lt gn-Gy & dk Gy-Blk sm carb, fis "
 3745.0,3750.0,5.0,"3745.0; 3750.0; LS: AA & SH: AA "
 3750.0,3755.0,5.0,"3750.0; 3755.0; SH: Blk carb-V.carb "
 3755.0,3760.0,5.0,"3755.0; 3760.0; LS: Gy-Bn-Tn, microX-fnX-dn Mdst-sm argil VPr vis por to NV por w/NS "
 3760.0,3770.0,10.0,"3760.0; 3770.0; SH: Pred dk Gy-Blk sm carb, sm gn-Gy "
 3770.0,3787.5,17.5,"3770.0; 3787.5; LS: Tn-cm microX-fnX-dn Mdst-Wkst w/VPr vis por to NV por; NS; Vrr Pkst: fos w/Pr por; NS; LS: Gy-Blk, microX-dn Mdst "
 3787.5,3790.0,2.5,"3787.5; 3790.0; SH: Blk carb-v.carb & dk Gy, gn-Gy "
 3790.0,3800.0,10.0,"3790.0; 3800.0; LS: Tn-Gy-Bn, microX-fnX-pred on Mdst sm argil VPr por-NV por; NS "
 3800.0,3800.0,-999.25,"3800.0; Cherokee "
 3800.0,3805.0,5.0,"3800.0; 3805.0; SH: Blk carb - v.carb & dk Gy-Blk subcarb & dk to Lt gn-Gy, V.gated "
 3805.0,3815.0,10.0,"3805.0; 3815.0; Sm Silts; Gy, gn-Gy, calc "
 3815.0,3820.0,5.0,"3815.0; 3820.0; Pred SH: AA, sm LS: AA "
 3820.0,3840.0,20.0,"3820.0; 3840.0; LS: ( lncrs ) Wh-Tn-Gy, microX-Rr fnX, pred dn Mdst sm chlky & subchlky LS w/VPr-Pr por. Rr Wkst-Pkst w/VPr-Pr por; NS "
 3840.0,3850.0,10.0,"3840.0; 3850.0; SH: dk Gy-Blk & gn-Gy Rr LS: AA, Tn-microX -dn Mdst "
 3850.0,3867.5,17.5,"3850.0; 3867.5; SH: dkGy-Blk & Lt-dk gn-Gy SH. Trc Sd Clust: Lt Gy, vfn Gr'd well cmt'd silty, calc VPr por; NS SH: sm Blk carb to V.carb & SH: AA "
 3867.5,3877.5,10.0,"3867.5; 3877.5; LS: Gy-Tn, microX-vfnX-dn hd, Mdst-sm Lithogr, sm argil VPr-NV por. NS "
 3877.5,3887.5,10.0,"3877.5; 3887.5; SH: v.gated dk to Lt Gy-gn & Gy-Blk, & mm-rd SH "
 3887.5,3895.0,7.5,"3887.5; 3895.0; SH: AA, shrp lncrs Blk carb to v.carb SH "
 3895.0,3900.0,5.0,"3895.0; 3900.0; Silts: gn-Gy, calc "
 3900.0,3905.0,5.0,"3900.0; 3905.0; SH: AA, Blk carb & VV-v.gated SH. Sm v.carb "
 3905.0,3910.0,5.0,"3905.0; 3910.0; LS: dk-Lt Gy, microX-dn hd & argil-shly Mdst w.NV por; NS "
 3910.0,3925.0,15.0,"3910.0; 3925.0; Pred SH: Blk carb & v.gated SH "
 3925.0,3930.0,5.0,"3925.0; 3930.0; SH: V.gated-gn-Gy-Blk lncrs mm-rd "
 3930.0,3940.0,10.0,"3930.0; 3940.0; LS: Lt-dk Gy & gn-Gy microX-Rr fnX, pred dn & argil Mdst & Wkst; Vrr Pkst, VPr-NV por, NS "
 3940.0,3950.0,10.0,"3940.0; 3950.0; SH: V.gated-AA, lncrs rd-mm SH "
 3950.0,3975.0,25.0,"3950.0; 3975.0; SH: V.gated-AA, Sl lncrs Blk carb-v.carb SH; Pred Lt-dk gn-Gy & Gy-Blk & rd mm SH. Sm LS: Gy-Tn & gn-Gy cryptoX-vfnX -dn hd Mdst, argil-shly "
 3975.0,3980.0,5.0,"3975.0; 3980.0; Vrr LS: AA dn Mdst "
 3980.0,3989.0,9.0,"3980.0; 3989.0; SH: V.gated-AA & yel-gn-Gy & mm. Vrr LS: AA "
 3989.0,3989.0,-999.25,"3989.0; Mississippian "
 3989.0,4002.5,13.5,"3989.0; 4002.5; CHERT: Wh-cm-bf-Tn, pred wthr'd-semi Tripol to Tripolitic w/ Pr-Fr vis por; l.Gr por, pp por, Pred spt'd-subsat brt FLR w/Vsl -sl SFOil-Conds & Gas bubls on brk, sm spt'd Lt. O.STN w/wk cut; Vsl odor "
 4002.5,4010.0,7.5,"4002.5; 4010.0; CHERT: Wh-cm-bf-Tn-& Gy, pred wthr'd semi Tripol-smGranir 40% sl wthr'd to frsh-prt shrp. 50% w/spt'd-subsat brt FLR w/vsl-sl SFOil, sl-Fr S.Gas bubls-Conds. "
 4010.0,4025.0,15.0,"4010.0; 4025.0; CHERT: bone Wh-cm-bf-Tn. Pred wthr'd sm w/pp por-vug por, sm Frac Edg's;' sm semi Tripol-Rr Tripolitic w/lGr por; Rr Fr-Gd por; vug por, l.Gr por & pp por; 90% w/spt'd-subsat FLR, SISFOil, Sl-Fr S. Gas bubls & Conds; 30% w/Lt O.STN & cut w/Frly Gd S.Gas bubls-Conds "
 4025.0,4035.0,10.0,"4025.0; 4035.0; CHERT; bone WH & Tn, sm prt frsh-shrp & prt wthr'd w/Frac Edg's w/FLR & Pr-Fr vis por; pp por - vug por w/Sl-Fr SFOil & Conds & Gas bubls, Fnt Odor "
 4035.0,4040.0,5.0,"4035.0; 4040.0; CHERT: AA, prt frsh & prt wthr'd w/spt'd FLR-SFOil-Conds-Gas bubls ( sl lncrs frsh-shrp chert ) "
 4040.0,4065.0,25.0,"4040.0; 4065.0; LS-Dolomitic LS: Tn-Gy-Bn, microX-fnXln, Wkst-Pkst-fos, chrty: Gy-Tn fos opaq, shrp-frsh chert VPr-Pr por; l.fos por, lX por, pp por w. Vsl S. Gas Bubls w. Trc SFOil & Conds, Dolomc LS; AA, microXln-vfnXLn, chrty: Gy, fos, sm dolomc & Lmy chrt. VPr-Pr vis por; Vrr S. Gas, Trc SFOil & Conds "
 4065.0,4085.0,20.0,"4065.0; 4085.0; Dolomitic LS: bf-Tn, cm microXln-fnXln, Pkst-Grst, fos w/sm Fr-Gd por; lX por, pp por, l.fos por, l.Gr por w. sat brt FLR VGd S. Gas bubls-Conds, Fr SFO. O.STN &cut. Dolo. bf-Tn, vfn to fn Xln-sm sucro, sm fragm-fos w/Fr-Gd por; lX por, pp-vug por & fos mod por w/brt FLR; V Gd S. Gas bubls-Cond, Fr SFO, O.STN & cut & odor "
 4085.0,4115.0,30.0,"4085.0; 4115.0; LS: Wh-cm-Tn, cryptoX-mdXln sm chlky & subchlky, sm Pkst, Pr-Rr Fr por; lX por, l.Gr por; l.pos por, Trc spt'd FLR vsl SFOil & Conds & Gas bubls on brk. Chrty: Wh-cm sm shrp frsh, sm granlr-fos-Trpolc w. VPr-Pr vis por; Trc FLR-SFO-Gas-Conds Abndt Wh-Chlky LS-Trc FLR-SFO-Conds-Gas bubls "
 4115.0,4120.0,5.0,"4115.0; 4120.0; LS: AA ( Abndt SH cavings ); "
 4120.0,4130.0,10.0,"4120.0; 4130.0; LS: Pkst-Grst: cm-Tn, vfnXln to mdXln, sm dolmc fragm-granlr & Xln, sm Fr-Gd por; l.Gr por, vug por & lX por. 50% w/Fr-Gd S. Gas bubls & Conds & vsl SFOil & O.STN & vsl cut "
 4130.0,4140.0,10.0,"4130.0; 4140.0; Dolomitic LS: cm-Tn, microXln-mdXln Pkst-Rr Grst-fos w/Fr por: lX por, l.fos por, pp-vug por w/Fr S. Gas bubls-conds, vsl SFOil & O.STN & cut, v.fnt odor; sm silic & chrty "
 4140.0,4160.0,20.0,"4140.0; 4160.0; LS: Gy-Tn-cm, microXln-fnXln sm dolomc, pred Pr vis por; lX por, sm Pkst-fos, v.chrty: wh-cm, vos, opaq, sm l.Gr por & sm Aprnt Frac por. Rr FLR & vsl SFOil-Gas-Conds, O.STN-cut "
 4160.0,4180.0,20.0,"4160.0; 4180.0; LS: cm-bf-Tn, microXln-fnXln, Rr prt mdXln, sm dolomc, sm Pkst-Grst, sm silic & chrty: cm-Gy-Tn, fos, opaq & granir chrt. Pred Pr vis por; lX por, pp por, Rr spt'd-subsat FLR & vsl SFOil-Conds & Gas bubls. sm l.Gr por. Trc O.STN & cut; Pred barren w/VPr-Pr vis por. sm dk Gy-Bn microX-mdX-Pkst-Grst-argil-shly, chrty. Pr por-NV por "
 4180.0,4210.0,30.0,"4180.0; 4210.0; Dolomc LS: Lt-dk Gy & Gy-Bn microX-vfnXln, argil & silic & chrty w/VPr-Pr vis lX por & l.Gr por Vrr spt'd FLR & Trc SF Oil & Conds. Chty: Lt-dk Gy, dolomc & Lmy, granlr, Pred Pr vis por: l.Gr por & micro Frac por. Trc SFO & Silts: md-dk Gy, calc & dolomc ( Abndt v.gated SH: AA-cavings ) "
 4210.0,4225.0,15.0,"4210.0; 4225.0; Dolomc LS: cm-LtGy-Tn, dk-Gy & Gy-Bn, microXln -vfnXln silic & chrty w/VPr-Pr vis l.Gr por & lX por & microFrac's w/NSFO, NF; sm argil-shly. ( Abndt SH: v.gated AA ) "
 4225.0,4240.0,15.0,"4225.0; 4240.0; Dolmc LS - Dolo: Lt-dk Gy, Gy-bf, microXln-vfnXln, subsucro, silic, & granlr, Pred VPr-Pr w/NS. Silts: gn-Gy & dk Gy calc. LS: Gy-Tn-cm, microX-fnX, sm Pkst. Chrty: Gy-Bn, vt shrp, opaq, VPr por-NV por. NSFO. V. Abndt SH: v.gated-AA, pred gn-Gy & sm Blk, mm, Yel-gn "
 4240.0,4250.0,10.0,"4240.0; 4250.0; "
 4250.0,4256.0,6.0,"4250.0; 4256.0; LS: AA, lncrs Tn-Gy, microX-vfnX-dn-Mdst "
 4256.0,4256.0,-999.25,"4256.0; Kinderhookian "
 4256.0,4270.0,14.0,"4256.0; 4270.0; SH: lncrs dk Gy & Lt gn-Gy & Blk carb & sm mm-rd ( Rr chrt & LS: AA ) "
 4270.0,4285.0,15.0,"4270.0; 4285.0; SH: AA. Pred md-dk Gy & gn-Gy. Vrr LS: Tn dn Mdst. Rr Pyrt "
 4285.0,4295.0,10.0,"4285.0; 4295.0; Pred SH: AA "
 4295.0,4305.0,10.0,"4295.0; 4305.0; SH: Pred md-dk Gy & gn-Gy, sm pyrtc, sm mm-rd. Rr Blk carb fis "
 4305.0,4309.0,4.0,"4305.0; 4309.0; SH-Silts md-dk Gy, sm calc & micac "
 4309.0,4309.0,-999.25,"4309.0; Chattanooga Shale "
 4309.0,4320.0,11.0,"4309.0; 4320.0; SH: lncrs Blk carb & sm v.carb "
 4320.0,4330.0,10.0,"4320.0; 4330.0; Dolomc SH: dk Gy, microXln w/Vpr-Pr vis por w/Fr-Gd S.Gas bubls on brk w/NF ( no FLR ) "
 4330.0,4338.0,8.0,"4330.0; 4338.0; SH: AA & Dolo-Dolomc LS: Gy, microXln, v.argil w/VPr vis por. lX por. Fr-Gd S. Gas bubls "
 4338.0,4338.0,-999.25,"4338.0; Simpson "
 4338.0,4358.0,20.0,"4338.0; 4358.0; SS: Sd Clusters: Lt Tn-Gy vfn-fn Gr'd, md'd to angl well sort'd, pred well cmt'd w/VPr-Pr vis l.Gr por-subsat FLR & O.STN.Fr.S.Gas bubls & Conds & VslSFOil, spt'd Gils-dd. STN.smdolomc cmt. Vrr prt md Gr'd-fribl w/Fr. por-sat brt FLR-O.STN, Fr. Odor "
 4358.0,4390.0,32.0,"4358.0; 4390.0; SS: Sd Clust: Trnsl-Lt bf-Tn, vfn to md Gr'd pred fn Gr'd well md'd-subanglr, v.well-well sort'd well cmt'd-subfribl w/pred sisic cmt. pred cir Gr's sm fract'd Pred Pr-Fr vis por, sub sat-sat brt FLR & Lt O.STN, sl-Fr S. Gas bubls & Conds & vsl SFOil & Cut, Crr fribl w GD l.Gr por w/spt'd to sat FLR & Lt O.STN, Fr S. Gas-Conds & SISFO & cut Fr odor. Abndt vfn-fn Gr'd Transl-Gy-Tn v.well cmt'd w/VPr-Pr vis por v/FLR-SFO & Gas -Conds. Vrr Fribl w/Gd por & Gd S. Gas & Conds & Sl-Fr SFOil; Vrr Wh, vfn-fn Gr'd barren sd. ( Frly Abndt sd clust: AA w/FLR-O.STN-SFO-Gas bubls-Conds ) "
 4390.0,4399.0,9.0,"4390.0; 4399.0; Sd Clust: Wh-Gy, gn-Gy, Vfn-fn Gr'd, v.well sort'd, sm pyrtc, pred barren w/V.Pr-Pr vis por "
 4399.0,4399.0,-999.25,"4399.0; Simpson Shale "
 4399.0,4412.5,13.5,"4399.0; 4412.5; SH: Lt-dk gn-Gy & mm-rd-Bn, sm Blk subcarb-carb. Rr Turq-gn, pyrt SH "
 4412.5,4415.0,2.5,"4412.5; 4415.0; SH: Abndt md Gy & Gy-Bn sm glauc ( Sd clust: AA ) "
 4415.0,4420.0,5.0,"4415.0; 4420.0; Silts: Lt gn-Gy, sndy: vfn, Gr'd "
 4420.0,4430.0,10.0,"4420.0; 4430.0; Sd Clust: Gy, vfn Gr'd to fn Gr'd w/Rr md Gr's, well cmt'd, shly-silty, dolomc w/VPr vis por w/NSFO "
 4430.0,4445.0,15.0,"4430.0; 4445.0; SS Clust: AA, lncrs vfn-fn Gr'd, well sort'd, sm fn-md Gr'd, clr & md'd to anglr Gr's; Pred Pr-Fr por w/NS. Trc Gd por w/NS "
 4445.0,4447.5,2.5,"4445.0; 4447.5; Abndt SH: AA & Silts: AA "
 4447.5,4457.5,10.0,"4447.5; 4457.5; SS-Sd Clusters: Wh-Gy & Transl, vfn to crs Gr'd, Pr sort'd, well smt'd to sub-fribl w/VPr-Fr l.Gr por w/NS "
 4457.5,4468.0,10.5,"4457.5; 4468.0; SS-Sd Clust: Transl-bf-Tn-Gy-Wh, vfn md Gr'd, pred fn Gr'd well md'd submd'd, well cmt'd to subfribl dolomc w/Pr-Fr por & Rr Gd por w/NSFO "
 4468.0,4468.0,-999.25,"4468.0; Arbuckle "
 4468.0,4480.0,12.0,"4468.0; 4480.0; Dolo: Tn-crm, Gy-Bn, microXln to md Xln, sm sndy: vfn-md Gr'd Rr sl pyrtc. Sm pp por-vug por & Pr-Fr lX por & l.Gr Por NSFO "
 4480.0,4490.0,10.0,"4480.0; 4490.0; Dolo: cm-bf-Tn-Bn, microX-fnXln, prd dn w/VPr-Pr por; pp por & microlX por w/NSFO "
 4490.0,4500.0,10.0,"4490.0; 4500.0; Dolo: cm-bf-Tn-Bn, microXln-fnXln, Vrr mdXln w/Pr-Fr lX por, pp por-micro por. NSFO; Abndt SHL gn-Gy & Blk "
 4500.0,4510.0,10.0,"4500.0; 4510.0; Dolo: Tn-Gy microXln-fnXln w/Rr md-vcrs 2ndReX w.Rr Fr-Gd por. NS Pred dn w. VPr-Pr por; NS. sm argil-shly Dolo: AA "
 4510.0,4520.0,10.0,"4510.0; 4520.0; Dolo: Tn-cm, Gy-Bn, microXln-fnXln, sm prt mdXln, Vrr crs-vcrs X's-2ndReX, Rr Fr pp por-vug por. NS "
 4520.0,4535.0,15.0,"4520.0; 4535.0; Dolo: bf-Tn-Gy cm, fn-medXln w/Rr crs-vcrs 2ndReX, sm Fr-Gd vug por & lX por; NS; sm prt dn w/Pr-Fr por; NS "
 4535.0,4555.0,20.0,"4535.0; 4555.0; Dolo: AA & bf-Tn, cm-Gy & Gy-Bn, fnXln-mdXln rhmbc w/Pred Pr-Fr vis por: lX por & vug por. Rr Gd vis por; lX por & vug por & Vrr crs X's-vcrs X's-2ndRex-sm Gd to V.Gd apt por; NSFO; NC; sm dull MNRL, FLR "
 4555.0,4560.0,5.0,"4555.0; 4560.0; Dolo: Gy-Tn-Bn,  microXln-fnXln dn w/Pr por to NV por; NS "
 4560.0,4570.0,10.0,"4560.0; 4570.0; Dolo: Lt-dk Gy, microXln-mdXln prt dn w/Pr por to NV por & sm pred mdxln w/Fr-Gd por; lX por & vug por & 2ndReX; NS "
 4570.0,4580.0,10.0,"4570.0; 4580.0; Dolo: bf-Tn-Gy fnXln-mdXln rhombc w/Fr-Gd lX por & vug por W/NS. Chrty: Lt-dk Gy & blu/Gy & cm-Wh, opag to transl shrp chrt. "
 4580.0,4590.0,10.0,"4580.0; 4590.0; Dolo: Tn-Gy-Bn, microXln-fnXln, sm dn hd w. pred Pr vis por to NV por w/NS; ls chrty: AA & Tn-Gy-Bn, fos, opaq, vit chrt "
 4590.0,4600.0,10.0,"4590.0; 4600.0; Dolo: cm-Tn, fnX-mdXln, sm rhombic w/Fr-Gd por. vug por & lX por w/NS. Sl chrty: AA & dk Gy to Blk vit. chrt "
 4600.0,4605.0,5.0,"4600.0; 4605.0; Dolo: Gy-Bn-Tn, microX-fnXln, prt dn hd w/Pr por-NV por. NS "
 4605.0,4620.0,15.0,"4605.0; 4620.0; Dolo: Tn-Gy-cm, fnXln-medXln, sucros to rhombc w/sm Fr-Gd por; lX por, vug por, Trc moldc por. NSFO. Trc crs-v.crs X's. NS. chrty: cm-Tn-Gy & blu.Gy - sm vc, fos & ool, shrp vit. chrt. "
 4620.0,4630.0,10.0,"4620.0; 4630.0; Dolo: Tn-Gy-Bn microX-fnXln, dn hd w/V.Pr-NV por w/NS. sl chrty. "
 4630.0,4640.0,10.0,"4630.0; 4640.0; Dolo: cm-Tn, fnXln-mdXln-sm rhombc w/Pr-Fr por, Vrr Gd por w/NSFO. sm microXln-medXln, pred dn w/VPr por-NV por. NS. "
 4640.0,4645.0,5.0,"4640.0; 4645.0; Dolo: Tn-Bn, vfnXln-fnXln. sucros w/Pr-Fr lX por & pp por. NS. "
 4645.0,4655.0,10.0,"4645.0; 4655.0; Dolo: Gy-Tn-Bn, microXln-mdXln prt dn w/VPr por-Nv por. NS "
 4655.0,4665.0,10.0,"4655.0; 4665.0; Dolo: Tn-Bn & Gy-Bn, prt cm, vfnXln to mdXln, pred Pr-Fr lX por, pp por-vug por. Vrr oomidc & ool w/Fr-Gd por. NS. "
 4665.0,4675.0,10.0,"4665.0; 4675.0; Dolo: cm-Tn & Gy-Bn, vfn-fnXln, Rr prt mdXln, sm sucro w/Pr-Fr lX por, pp-vug por w/NS "
 4675.0,4690.0,15.0,"4675.0; 4690.0; Dolo: Tn-Gy-Bn, microXln-fnXln pred dn w/VPr por-NV por. NS. Rr argil-shly. Sl chrty: Tn-blu-Gy ool & fos vit shrp chrt ( V.Abndt SH: AA: dkGy-Blk & gn-Gy-SH ) ( Pr-VPr spls ) "
 4690.0,4700.0,10.0,"4690.0; 4700.0; Dolo: cm-Tn-Gy, fnXln-mdXln-sucro & rhombic. Pr-Fr lX por. Vrr Gd por: lX por & oomldc por. NS "
 4700.0,4710.0,10.0,"4700.0; 4710.0; Dolo: Tn-Gy-Bn, microXln-fnXln, pred dn hd w/Pr por - NV por, NS ( lncrs SH: AA: sm mm-rd ) "
 4710.0,4720.0,10.0,"4710.0; 4720.0; Dolo: Tn-Gy-cm, vfn-fnXln, pred dn w/Pr por-NV por. NS, sm mdXln w/Fr-Gd lX por vug por. NS ( V.Abndt SH: AA-cavings ) "
 4720.0,4730.0,10.0,"4720.0; 4730.0; Dolo: Tn-Gy-cm, microXln-mdXln, sm dn hd, sm Pr-Fr por: lX por, vug por, Trc Gd por. NS. Sm granlr Dol. ( Pred SH caving ) "
 4730.0,4750.0,20.0,"4730.0; 4750.0; Dolo: Tn-Gy-Bn, microXln-Rr fnXln-dn hd w/VPR por-NV por ( V. Abndt SH cavings-VPr-Pr spls ) "
 4750.0,4755.0,5.0,"4750.0; 4755.0; Dolo: Tn-Gy, microXln, dn hd. ( pred SH: AA ) "
 4755.0,4765.0,10.0,"4755.0; 4765.0; Dolo: bf-Tn, fnX-mdXln, rhombc, Pr-Fr lX por, Trc Gd por; NS "
 4765.0,4770.0,5.0,"4765.0; 4770.0; Vrr Dolo: Tn & Gy & dk Gy-Bn microXln-mdXln, sm dn hd "
 4770.0,4780.0,10.0,"4770.0; 4780.0; Dolo: AA, sm rhombc w/Pr-Fr por. NS "
 4780.0,4790.0,10.0,"4780.0; 4790.0; Dolo: Tn-Gy-cm, microX-mdXln, sm dn hd, sm rhombc w/Pr-Fr por; AA. NS ( V. Abndt v.gated SH: AA in samples - cavings- Pr spls. ) ( Shrp lncrs Dolo in 4820' spl ) "
 4790.0,4822.5,32.5,"4790.0; 4822.5; Dolo: Tn-cm & Gy-Bn, fnXln to mdXln w/Pr-Fr vis lX por NSFO. Vrr Gd vug por & lX por xm 2nd Rex- Trc crs-vcrs X's. sm aprnt v.gd por. NSFO, NC. NS. Chrty: Lt-dk Gy & cm-Wh, Tn & blu.Gy-vc, ool & fos, opaq, shrp chrt & Dolo: Tn-Gy-Bn, microX-fnXln, dn hd, sm argil-shly. "
 4822.5,4835.0,12.5,"4822.5; 4835.0; Dolo: Tn-cm & Gy-Bn, pred fnXln-mdXln w/Pr-Fr por: lX por & vug por; NS. sm grnlr sm rhombc. sl chrty: Wh-cm Tn & blu.Gy. sm opaq-ool & fos, sm transl, shrp vit chrt "
 4835.0,4845.0,10.0,"4835.0; 4845.0; Dolo: AA, Vrr mdXln-crsXln rhombc w/Gd-V.Gd lX por & vug por, sm 2ndReX. NS. sl chrty: AA "
 4845.0,4865.0,20.0,"4845.0; 4865.0; Dolo: Tn-cm & Gy-Bn, microXln-mdXln, Abndt dn w/Pr por to NV por, NS. chrty: AA blu Gy, transl & opaq & dk Gy-Bn, Tn-cm, vit. shrp "
 4865.0,4882.5,17.5,"4865.0; 4882.5; Dolo: Tn-cm, Gy-Bn, fnXln-mdXln, sm rhombc w/Fr por - Gd por; vug por & lX por - sm 2ndRex-aprnt Gd-V.Gd por; Vrr crsX's-Trc V.crsX's. sl chrty: tn-cm & blu.Gy, sm fos-ool, pred opaq shrp chrt "
 4882.0,4895.0,13.0,"4882.0; 4895.0; Dolo: Tn-cm & Gy-Bn, microX-fnXln, Rr prt mdXln-crsXln-sm 2ndReX-sm Gd aprnt por & Vrr Gd vis por; NSFO NC ( Frly Gd spls ) "
 4895.0,4902.5,7.5,"4895.0; 4902.5; Abndt dn Dolo: Gy-Bn, microXln-fnXln-dn hd w/VPr por-NV por "
 4902.5,4915.0,12.5,"4902.5; 4915.0; Dolo: Tn-Gy-Bn & cm, microXln-mdXln, sm 2ndReX-Vrr crs-V.crs X's-sm Gd-V.Gd aprnt por. NS; sl chrty "
 4915.0,4930.0,15.0,"4915.0; 4930.0; Dolo: Tn-Gy-cm, microXln-fnXln, Rr prt mdXln-2ndReX. Rr Fr-Gd por: vug por, lX por; NS. Abndt Dolo w/Pr por to NV por "
 4930.0,4945.0,15.0,"4930.0; 4945.0; Dolo: Tn-Gy-cm, microXln-fnXln, Vrr prt md-crsXln-2ndReX. Rr Fr-Gd vug por & moldc por & pr-Fr lX por, NS. chrty: Wh-cm-Gy, opaq, shrp & SH: lncrs Blk carb SH, sm gn-Gy SH "
 4945.0,4950.0,5.0,"4945.0; 4950.0; Dolo: Gy-Bn fnXln-granlr w. V.Pr por -NV por NS "
 4950.0,4957.5,7.5,"4950.0; 4957.5; Dolo: dk Gy-Bn, microX-fnXln argil-shly w/Blk carb SH & dk mm-rd & gn-Gy SH. "
 4957.5,4970.0,12.5,"4957.5; 4970.0; Dolo: Tn-Bn & Gy-cm, microXln-fnXln, Rr prt mdXln-2ndReX. Vrr Fr-Gd por; NS. Pred dn sl chrty: Wh-cm, opaq & sm Transl Qtzc chrt "
 4970.0,4977.5,7.5,"4970.0; 4977.5; Dolo: cm-Gy-Tn, mdXln-crsXln w/Vrr Fr-Gd vug por & lX por; NS "
 4977.5,4985.0,7.5,"4977.5; 4985.0; Dolo: Tn-Gy-Bn, microXln-fnXln pred dn Vrr vug por & sm vis lX por. NS sl. chrty "
 4985.0,5010.0,25.0,"4985.0; 5010.0; Dolo: Tn-Gy-Bn & cm, fnXln to mdXln-rhombc w/Pr-Fr vis lX por & vug por. NS & Dolo: Tn-Gy-Bn & cm, microXln-fnXln, pred dn w/V.Pr por-NV por. NS. V.chrty: Wh-cm-Gy blu.Gy, pred opaq-shrp, Rr Transl Qtzc chrt "
 5010.0,5012.5,2.5,"5010.0; 5012.5; Dolo: AA, NS. Chrty: AA "
 5012.5,5030.0,17.5,"5012.5; 5030.0; Dolo: Tn-Gy-Bn, fn-mdXln w/Vrr crs-V.crsX's-2ndReX, sm Fr por to V.Gd por; vug por & lX por. NS. sm V.Gd aprnt por-Euhedral X's-NS. sm chrt: AA. sm dn Dolo: AA "
 5030.0,5045.0,15.0,"5030.0; 5045.0; Dolo: Tn-Gy-Bn & cm-Tn, fn-mdXln w/Rr crs. v.crs X's-2ndReX-Vrr Euhedral X's Rr Fr-VGd vug por & aprnt Frac por. NS. sl chrty "
 5045.0,5055.0,10.0,"5045.0; 5055.0; Abndt dn Dolo w/Pr por -NV por "
 5055.0,5067.5,12.5,"5055.0; 5067.5; Dolo: Gy-Bn-Tn-cm, microXln-mdXln w/Rr crs -v.crs X's - 2ndReX Vrr Fr-V.Gd por; vug por & lX por w/NSFO. NC. NS.  V chrty; cm-blu.Gy opaq shrp & transl chrt. "
 5067.5,5085.0,17.5,"5067.5; 5085.0; Dolo: Tn-Bn & Gy-Bn & cm-Tn, fnXln-Rr mdXln, sm sucro & sm rhombc w/Fr-Gd por; vug por & lX por & 2nd ReX w/NS. chrty. Abndt dn dolo "
 5085.0,5095.0,10.0,"5085.0; 5095.0; Dolo: Tn-Gy-Bn & cm, fnXln to mdXln, sucrs to rhombc w/Rr Fr-Gd por; lX por & vug por. NS chrty: AA "
 5095.0,5115.0,20.0,"5095.0; 5115.0; Dolo: Tn-Bn & Gy-cm, Abndt mdXln-rhombc, Rr crsXln, Vrr Euhedral X's-v.crs X's-sm aprnt Gd to V.Gd por-NS chrty: WH-Gy-opaq to transl sm shrp chrt., Trc ool chrt "
 5115.0,5125.0,10.0,"5115.0; 5125.0; Dolo: AA & Tn-Gy-Bn & Gy-cm microXln-fnXln, sm dn hd; Pred Pr por-NV por; NS "
 5125.0,5145.0,20.0,"5125.0; 5145.0; Dolo: Tn-Gy-cm, fn-mdXln, sm rhombc w/Fr-V.Gd vug por & lX por & 2ndRex w/NS. chrty: Wh-cm-Gy-Tn, sm fos-ool. sm microX-fnXln-dn w/ Pr por to NV por. sm silic dn dolo. sm dolomc chrt, sm qtzc transl chrt "
 5145.0,5152.5,7.5,"5145.0; 5152.5; Dolo: AA, sm Fr-V.Gd por. NS "
 5125.5,5185.5,60.0,"5125.5; 5185.5; Dolo: Gy-Tn-bf-cm, vfnXln to mdXln, Rr prt crsXln-2ndReX-Trc v.crs X's, xm rhombc, sm silic & granlr & chrty. Rr Gd por; vug por & lX por; Vrr Euhedral dolo X's - Gd to V.Gd aprnt por w/NS. Pred Pr-Fr vis por. NS. Sm dn Dolo w/V.Pr por-NV por. chrty: Wh-bf-Tn & blue-Gy, opaq-shrp, ool & fos chrt. "
 5185.5,5192.5,7.0,"5185.5; 5192.5; Dolo: Tn-Gy-Bn, fn-medXln prt dn, sm Pr-Fr por. NS. Rr Fr-Gd vug por & lX por. NS "
 5192.5,5207.5,15.0,"5192.5; 5207.5; Dolo: Gy-Tn-cm-bf, vfn-mdXln w/Vrr crs-v.crs X's-2ndReX, sm Fr-Gd vis por. NS. Sm V.Gd aprnt por-2ndReX Euhedral Dolo X's w/NS "
 5207.5,5222.5,15.0,"5207.5; 5222.5; Dolo: bf-Tn & Gy-cm, fn-mdXln, sm rhombc w/Fr-Gd por; lX por & vug por. NS. chrty: blu.Gy Tn-cm, sm opaq-shrp, sm fos. sm microX-fnXLN-dn dolo, NV por "
 5222.5,5232.5,10.0,"5222.5; 5232.5; Dolo: bf-Tn-Gy, lncrs md-crsXln w.2ndReX & Fr por to V.Gd por, vug por, lX por. NS. Rhombc "
 5232.5,5242.5,10.0,"5232.5; 5242.5; Dolo: Gy-Tn-bf-cm, sm microXX-fnXln, dn to VPr vis por; NS; sm fn-mdXln, Pr por to NV por "
 5242.5,5252.5,10.0,"5242.5; 5252.5; Dolo: AA, Abndt md to crsXln rhombc w/Fr-Gd por. NS. Sl.chrty "
 5252.5,5262.5,10.0,"5252.5; 5262.5; Dolo: bf-Tn-Gy-cm, sm microXln-fnXln dn to Pr por, NS. Rr Fr-Gd por. NS, AA "
 5265.5,5275.0,9.5,"5265.5; 5275.0; Dolo: bf-Tn-Gy-cm, md-crsXln, rhombc w/Fr-Gd lX por & vug por; NS. chrty: Wh-cm-Tn-Gy, framntl-fos, granlr chrt. Vrr V. Gd por. NS "
 5275.0,5287.5,12.5,"5275.0; 5287.5; Dolo: AA, lncrs cm-bf-Tn, md-crsXln w/sm Fr-V.Gd or; vug por & lX por. NS. sm w/ Pr por to dn. chrty: Wh-cm-Gy, opaq to transl "
 5287.5,5310.0,22.5,"5287.5; 5310.0; Dolo: bf-Tn-cm-Gy, microXln to mdXln, sm dn to Pr vis por; Abndt cm-Gy-bf-Tn, mdXln-crsXln w/Fr-Gd por; lX por & vug por. NS Vrr pyrtc chrty: Wh-cm-Gy-Tn, sm opaq-shrp, sm granlr-fram & dolomc chrt. "
 5310.0,5317.5,7.5,"5310.0; 5317.5; Dolo: AA, sm dk-Lt Gy-bf-Tn microXln-mdXln, prt dn w/Pr por to NV por "
 5317.5,5322.5,5.0,"5317.5; 5322.5; Dolo: AA, Trc V.Gd lX por-Trc v.crs X's-2ndReX. NS. "
 5322.5,5330.0,7.5,"5322.5; 5330.0; Dolo: Tn-Bn & Gy-Bn, microXln to mdXln, pred fnXln dn to Pr por. NS. "
 5330.0,5345.0,15.0,"5330.0; 5345.0; Dolo: bf-Tn-Gy-cm, sm mdXln-crsXln-rhombc w/Fr-Gd lX por & vug por. Vrr V.Gd vis lX por & vug por. Euhedral X's NS. "
 5345.0,5347.5,2.5,"5345.0; 5347.5; Dolo: AA, sm dn to Pr vis por. NS "
 5347.5,5370.0,22.5,"5347.5; 5370.0; Dolo: Tn-bf-cm-Gy, sm mdXln-crsXln-rhombc w/Fr-VGd por; lX por & vug por & 2ndReX-Vrr Euhedral X's-Gd-VGd aprnt por; vug & or Frac por. NS. sm microXln to mdXln prt dn dolo w/2ndReX-Gd vug &/or frac por. NS ( Fr spls ) "
 5370.0,5380.0,10.0,"5370.0; 5380.0; Dolo: Gy-Tn-bf-cm, microXln-mdXln prt dn to Pr vis por. NS. sm md to crsXln-rhombc w/Fr-Gd lX por & vug por. NS "
 5380.0,5395.0,15.0,"5380.0; 5395.0; Dolo: Lt-dk Gy-Tn-Bn, & bf-Tn, fnXln-mdXln w/Rr crsXln w/Fr-Gd por. NS. & Euhedral X's-2ndReX w/NS. Vrr pyrtc sm dn to Pr por; NS "
 5395.0,5417.5,22.5,"5395.0; 5417.5; Dolo: cm-bf-Tn-Gy, sm mdXln to crsXln w/sm Gd to V.Gd vis por. NS. sm 2ndRex-Rr Euhedral X's-sm Gd to VGd aprnt por w/NS. sm pyrtc Sm microXln-mdXln, w/dn to Pr vis por-Rr 2ndReX w/Fr-V.Gd aprnt por w/NS "
 5417.5,5440.0,22.5,"5417.5; 5440.0; Dolo: bf-Tn & Gy-cm, fnXln to mdXln, sm dn to Pr por, sm sucro to rhombc w/Fr-Gd lX por & vug por. NS Vrr V.Gd vis por w/NSFO & Euhedral X's-2ndReX V.Gd por ( aprnt por ) NS Rr pyrtc. "
 5440.0,5453.0,13.0,"5440.0; 5453.0; Dolo: Gy-bf-Tn, fn-mdXln w/Vrr crs X's-2ndReX-Trc sndy. Rr Fr-Gd vis por & SH: Gy-Blk carb "
 5453.0,5465.0,12.0,"5453.0; 5465.0; Dolo: AA, lncrs bf-Tn, mdXln to crsXln-2ndReX-Vrr "
 5465.0,5479.0,14.0,"5465.0; 5479.0; Dolo: AA, lncrs bf-Tn, mdXln to crsXln-2ndReX-Vrr V.Gd por; vug por & lX por w/NS. sm microXln-mdXln Dolo w/VPr por-NV por & NS. sm microXln-mdXln Dolo w/VPr por - NV por & NS. sm sndy Dolo: dk Gy-Tn-Bn, fn-mdXln dn to Pr vis por. NS. sm sndy "
 5479.0,5479.0,-999.25,"5479.0; Lamotte (Reagan) Sandstone "
 5479.0,5490.0,11.0,"5479.0; 5490.0; SS: Sd Clusters: Gy-Bn-Tn & trnsl, vfn to crs Gr'd wll to Pr sort'd well md'd to subanglr Gr's, Pred wll cmt'd-dolomc. Vrr fribl w/Fr-Gd l.Gr por. NS. NC. ( Dolo: AA-sm sndy ) "
 5490.0,5505.0,15.0,"5490.0; 5505.0; SS: Sd Clusters (Abndt in 5520' spl ): bf-Tn-Gy-Bn, transl vfn to v.crs Gr'd, well md'd to subanglr, well to Pr sort'd Pred well cmt'd-dolomc w/VPr-Pr vis por.Vrr cln clusters w/Fr-Gd por. NS. "
 5520.0,5520.0,-999.25,"5520.0; Granite Wash "
 5505.0,5520.0,15.0,"5505.0; 5520.0; SS: Sd Clusters: AA & md-vcrs well md'd to subanglr clr Gr's pred well cmt'd, Vrr fribl w/Fr-Gd l.Gr por. NS. NC. Sd Clust: AA, pred vfn to md Gr'd, dolomc w/Pr-Fr vis por. NS. NC. Vrr crs-v.crs Gr's. "
 5520.0,5550.0,30.0,"5520.0; 5550.0; Granite Wash: ( GRAN.WSH ) Pred K-Feldspar ( K-Felds ) brt rd-org-pnk, w/sm trnsl-qtz w/sm ferro-magnesian MINRLS: Esp Biotite & Hornblende. Sm Shly & pyrtc fragments of K-Felds-qtz & Ferromag's w/gn-Gy & Blk carb SH-sm pyrtc. Trc S. Gas bubls on brk of shly ( Blk carb ) fragm. "
 5550.0,5560.0,10.0,"5550.0; 5560.0; GRAN WSH: Pred K-Felds: rd-org-pnk & trnsl Qtz & sm Wh-Plagioclase ( Plag ) w/sm Feromg MINERLS Esp Biotite "

~IQ_Las_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .FT          SELECTED  : Logged depth                   
 ?     .DEGF                  : MCG External Temperature       
 ?     .LB                    : DST Uphole Tension             
 GR    .API         SELECTED  : Gamma Ray                      
 SP    .MV          SELECTED  : Spontaneous Potential          
 NPRL  .PU          SELECTED  : Neutron porosity               
 CAL   .IN          SELECTED  : Caliper                        
 DCOR  .GM/CC       SELECTED  : Bulk Density Correction        
 DEN   .GM/CC       SELECTED  : Bulk Density                   
 PE    .BARNS/E     SELECTED  : Photoelectric factor           
 DPHI  .PU          SELECTED  : Density porosity               
 RSHAL .OHM-M       SELECTED  : Shallow Resistivity            
 DT    .USEC/FT     SELECTED  : Acoustic transit time          
 SPHI  .PU          SELECTED  : Sonic porosity                 
 RILM  .OHM-M       SELECTED  : Medium Induction Resistivity   
 RILD  .OHM-M       SELECTED  : Deep Induction Resistivity     

~ASCII
# DEPT CGXT SMTU GRGC SPCG NPRL CLDC DCOR DEN PDPE DPRL FEFE DT35 SPRL RILM RILD
 224.409,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 224.909,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 225.409,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 225.909,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 226.409,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 226.909,-999.250,-999.250,54.518,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 227.409,-999.250,-999.250,53.163,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 227.909,-999.250,-999.250,54.289,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 228.409,-999.250,-999.250,56.770,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 228.909,-999.250,-999.250,57.076,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 229.409,-999.250,-999.250,54.136,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 229.909,101.914,-999.250,50.841,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 230.409,101.806,-999.250,48.875,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 230.909,101.718,-999.250,48.201,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 231.409,101.808,-999.250,51.476,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 231.909,101.908,-999.250,56.504,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 232.409,101.887,-999.250,61.526,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 232.909,101.801,-999.250,61.914,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 233.409,101.815,-999.250,58.270,-999.250,34.094,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 233.909,101.841,-999.250,58.906,-999.250,42.781,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 234.409,101.770,-999.250,61.653,-999.250,47.990,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 234.909,102.026,-999.250,62.096,-999.250,47.209,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 235.409,101.856,-999.250,58.388,-999.250,42.053,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 235.909,101.772,-999.250,55.374,-999.250,38.762,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 236.409,101.872,-999.250,52.916,-999.250,39.425,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 236.909,101.938,-999.250,49.488,-999.250,40.416,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 237.409,101.915,-999.250,46.440,-999.250,38.624,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 237.909,101.903,-999.250,47.797,-999.250,34.534,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 238.409,101.898,-999.250,53.672,-999.250,31.609,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 238.909,101.852,-999.250,58.544,-999.250,31.584,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 239.409,101.875,-999.250,58.827,-999.250,33.383,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 239.909,101.881,-999.250,55.726,-999.250,37.915,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 240.409,101.864,-999.250,53.416,-999.250,47.012,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 240.909,101.764,-999.250,51.183,-999.250,55.081,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 241.409,101.818,-999.250,50.891,-999.250,55.787,10.663,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 241.909,101.819,-999.250,52.403,-999.250,48.643,10.663,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250,-999.250
 242.409,101.799,-999.250,52.718,-999.250,40.057,10.664,-0.151,2.277,-999.250,25.305,-999.250,-999.250,-999.250,-999.250,-999.250
 242.909,101.904,-999.250,53.211,-999.250,38.116,10.665,-0.149,2.279,13.795,25.186,-999.250,-999.250,-999.250,-999.250,-999.250
 243.409,101.922,-999.250,54.008,-999.250,38.999,10.666,-0.147,2.283,13.803,24.995,-999.250,-999.250,-999.250,-999.250,-999.250
 243.909,101.844,-999.250,57.245,-999.250,36.723,10.666,-0.144,2.292,13.734,24.460,-999.250,-999.250,-999.250,-999.250,-999.250
 244.409,101.935,-999.250,59.996,-999.250,33.526,10.666,-0.143,2.302,13.519,23.870,-999.250,-999.250,-999.250,-999.250,-999.250
 244.909,101.879,-999.250,59.978,-999.250,33.015,10.667,-0.145,2.302,13.362,23.848,-999.250,-999.250,-999.250,-999.250,-999.250
 245.409,101.934,-999.250,60.648,-999.250,36.051,10.668,-0.149,2.295,13.449,24.262,-999.250,-999.250,-999.250,-999.250,-999.250
 245.909,101.945,-999.250,61.356,-999.250,44.259,10.668,-0.152,2.288,13.241,24.705,-999.250,-999.250,-999.250,-999.250,-999.250
 246.409,101.974,-999.250,61.033,-999.250,53.034,10.668,-0.153,2.282,13.147,25.036,-999.250,-999.250,-999.250,-999.250,-999.250
 246.909,101.922,-999.250,59.518,-999.250,56.836,10.669,-0.153,2.274,13.231,25.497,-999.250,-999.250,-999.250,-999.250,-999.250
 247.409,101.916,-999.250,59.230,-999.250,54.604,10.669,-0.152,2.268,13.422,25.836,-999.250,-999.250,-999.250,-999.250,-999.250
 247.909,101.885,-999.250,61.757,-999.250,47.447,10.669,-0.151,2.269,13.661,25.789,0.033,-999.250,-999.250,-999.250,-999.250
 248.409,101.934,-999.250,65.721,-999.250,43.167,10.669,-0.150,2.278,13.612,25.275,0.033,-999.250,-999.250,-999.250,-999.250
 248.909,101.930,-999.250,67.283,-999.250,42.793,10.669,-0.148,2.288,13.885,24.691,0.033,-999.250,-999.250,-999.250,-999.250
 249.409,101.851,-999.250,64.806,-999.250,42.563,10.669,-0.146,2.293,14.336,24.360,0.032,-999.250,-999.250,-999.250,-999.250
 249.909,102.015,-999.250,58.730,-999.250,43.082,10.669,-0.145,2.297,14.559,24.143,0.032,-999.250,-999.250,-999.250,-999.250
 250.409,101.908,-999.250,52.284,-999.250,43.642,10.669,-0.145,2.297,14.347,24.155,0.032,-999.250,-999.250,-999.250,-999.250
 250.909,101.833,-999.250,50.377,-999.250,44.487,10.669,-0.146,2.293,13.895,24.410,0.032,-999.250,-999.250,-999.250,-999.250
 251.409,101.890,-999.250,51.282,-999.250,45.877,10.669,-0.148,2.286,13.817,24.809,0.032,-999.250,-999.250,-999.250,-999.250
 251.909,102.069,-999.250,50.615,-999.250,46.902,10.669,-0.149,2.281,13.851,25.083,0.032,-999.250,-999.250,-999.250,-999.250
 252.409,101.885,-999.250,48.503,-999.250,47.812,10.669,-0.148,2.286,14.009,24.797,0.032,-999.250,-999.250,-999.250,-999.250
 252.909,101.809,-999.250,48.758,-999.250,48.081,10.669,-0.146,2.296,13.968,24.198,0.032,-999.250,-999.250,-999.250,-999.250
 253.409,101.919,-999.250,51.398,-999.250,47.963,10.669,-0.144,2.308,13.828,23.532,0.032,-999.250,-999.250,-999.250,-999.250
 253.909,102.105,-999.250,50.992,-999.250,47.097,10.669,-0.141,2.318,14.054,22.927,0.032,-999.250,-999.250,-999.250,-999.250
 254.409,101.942,-999.250,48.552,-999.250,44.867,10.669,-0.139,2.319,14.660,22.856,0.031,-999.250,-999.250,-999.250,-999.250
 254.909,101.886,-999.250,47.170,-999.250,41.638,10.669,-0.139,2.312,15.300,23.289,0.031,-999.250,-999.250,-999.250,-999.250
 255.409,101.942,-999.250,50.835,-999.250,39.654,10.669,-0.139,2.306,15.310,23.614,0.031,-999.250,-999.250,-999.250,-999.250
 255.909,101.956,-999.250,57.264,-999.250,41.507,10.669,-0.141,2.305,14.733,23.710,0.030,-999.250,-999.250,-999.250,-999.250
 256.409,101.971,-999.250,58.931,-999.250,44.453,10.669,-0.142,2.304,14.232,23.754,0.030,-999.250,-999.250,-999.250,-999.250
 256.909,101.785,-999.250,55.788,-999.250,47.669,10.669,-0.144,2.298,14.215,24.114,0.030,-999.250,-999.250,-999.250,-999.250
 257.409,101.961,-999.250,53.029,-999.250,49.819,10.669,-0.145,2.288,14.285,24.704,0.029,-999.250,-999.250,-999.250,-999.250
 257.909,102.090,-999.250,51.628,-999.250,47.241,10.669,-0.145,2.284,14.262,24.911,0.029,-999.250,-999.250,-999.250,-999.250
 258.409,101.976,-999.250,50.913,-999.250,40.645,10.669,-0.145,2.287,14.039,24.765,0.028,-999.250,-999.250,-999.250,-999.250
 258.909,101.947,-999.250,49.908,-999.250,32.419,10.669,-0.145,2.292,13.887,24.449,0.028,-999.250,-999.250,-999.250,-999.250
 259.409,102.055,-999.250,46.687,-999.250,26.892,10.669,-0.145,2.298,14.012,24.088,0.027,-999.250,-999.250,-999.250,-999.250
 259.909,101.904,-999.250,46.064,-999.250,26.777,10.669,-0.146,2.298,14.308,24.107,0.027,-999.250,-999.250,-999.250,-999.250
 260.409,101.968,-999.250,50.676,-999.250,31.721,10.669,-0.147,2.291,14.667,24.480,0.028,169.159,85.978,-999.250,-999.250
 260.909,102.055,-999.250,56.113,-999.250,38.228,10.669,-0.148,2.283,14.936,24.994,0.028,172.666,88.457,-999.250,-999.250
 261.409,102.014,-999.250,61.617,-999.250,42.290,10.669,-0.147,2.281,14.743,25.105,0.029,175.835,90.696,-999.250,-999.250
 261.909,101.963,-999.250,63.374,-999.250,43.466,10.669,-0.147,2.286,14.356,24.823,0.029,177.558,91.914,-999.250,-999.250
 262.409,101.898,-999.250,60.891,-999.250,44.236,10.669,-0.146,2.294,14.242,24.345,0.030,180.843,94.235,-999.250,-999.250
 262.909,101.984,-999.250,55.723,-999.250,46.386,10.669,-0.146,2.304,14.163,23.767,0.030,186.956,98.555,-999.250,-999.250
 263.409,101.928,-999.250,50.685,-999.250,46.943,10.669,-0.147,2.308,14.101,23.487,0.030,193.591,103.245,-999.250,-999.250
 263.909,102.017,-999.250,50.040,-999.250,43.522,10.669,-0.146,2.309,13.707,23.452,0.030,197.074,105.706,-999.250,-999.250
 264.409,101.906,-999.250,52.525,-999.250,39.603,10.669,-0.146,2.308,13.263,23.497,0.030,196.668,105.419,-999.250,-999.250
 264.909,102.053,-999.250,55.331,-999.250,39.067,10.669,-0.144,2.316,13.461,23.038,0.030,193.875,103.445,-999.250,-999.250
 265.409,102.106,-999.250,57.098,-999.250,40.139,10.669,-0.143,2.363,14.019,20.300,0.030,189.756,100.534,-999.250,-999.250
 265.909,102.101,-999.250,57.444,-999.250,40.199,10.669,-0.175,2.405,14.566,17.858,0.030,185.648,97.631,-999.250,-999.250
 266.409,101.976,-999.250,56.337,-999.250,38.319,10.669,-0.229,2.431,14.794,16.315,0.030,182.192,95.189,-999.250,-999.250
 266.909,102.110,-999.250,54.593,-999.250,35.292,10.673,-0.252,2.440,14.599,15.818,0.030,183.069,95.809,-999.250,-999.250
 267.409,102.036,-999.250,52.884,-999.250,32.388,10.671,-0.234,2.405,14.443,17.829,0.030,189.465,100.329,-999.250,-999.250
 267.909,101.935,-999.250,51.370,-999.250,30.551,10.665,-0.182,2.370,14.286,19.890,0.029,199.317,107.291,-999.250,-999.250
 268.409,102.134,-999.250,50.350,-999.250,30.429,10.665,-0.144,2.327,14.122,22.395,0.029,205.628,111.751,-999.250,-999.250
 268.909,102.028,-999.250,48.823,-999.250,32.513,10.665,-0.138,2.297,14.069,24.152,0.030,202.018,109.200,-999.250,-999.250
 269.409,102.092,-999.250,50.261,-999.250,37.715,10.665,-0.140,2.283,13.898,24.996,0.030,192.282,102.319,-999.250,-999.250
 269.909,102.084,-999.250,55.223,-999.250,44.776,10.664,-0.143,2.266,13.776,25.967,0.030,182.248,95.228,-999.250,-999.250
 270.409,102.007,-999.250,59.861,-999.250,50.481,10.664,-0.146,2.256,13.749,26.540,0.030,175.837,90.697,-999.250,-999.250
 270.909,101.934,-999.250,64.094,-999.250,50.594,10.664,-0.147,2.256,13.682,26.571,0.030,172.206,88.132,-999.250,-999.250
 271.409,102.033,-999.250,68.327,-999.250,44.706,10.664,-0.147,2.261,13.824,26.263,0.030,170.993,87.274,-999.250,-999.250
 271.909,102.000,-999.250,71.891,-999.250,38.251,10.664,-0.146,2.266,14.166,25.951,0.030,175.367,90.365,-999.250,-999.250
 272.409,101.880,-999.250,72.757,-999.250,37.980,10.665,-0.144,2.271,14.463,25.674,0.030,184.139,96.565,-999.250,-999.250
 272.909,101.984,-999.250,72.238,-999.250,43.960,10.665,-0.143,2.275,14.425,25.456,0.030,192.964,102.801,-999.250,-999.250
 273.409,102.105,-999.250,71.156,-34.783,48.843,10.665,-0.141,2.277,14.014,25.312,0.030,193.678,103.306,-999.250,-999.250
 273.909,101.986,-999.250,69.485,-34.664,48.298,10.664,-0.139,2.284,13.815,24.914,0.030,187.201,98.729,-999.250,-999.250
 274.409,101.975,399.414,65.887,-34.827,44.652,10.664,-0.137,2.298,13.874,24.116,0.031,178.201,92.368,-999.250,-999.250
 274.909,102.003,405.273,59.888,-35.482,42.914,10.664,-0.135,2.312,13.941,23.298,0.030,172.047,88.019,-999.250,-999.250
 275.409,102.005,408.447,56.454,-36.265,42.589,10.661,-0.135,2.316,13.867,23.069,0.030,171.768,87.822,-999.250,999999.999
 275.909,102.131,400.391,53.631,-36.484,40.002,10.658,-0.135,2.312,13.639,23.247,0.030,174.630,89.844,999999.999,999999.999
 276.409,102.135,407.666,55.357,-35.910,34.891,10.658,-0.136,2.306,13.589,23.618,0.030,181.487,94.690,999999.999,999999.999
 276.909,102.059,405.273,61.545,-35.240,32.766,10.658,-0.137,2.299,13.560,24.006,0.030,189.825,100.583,999999.999,999999.999
 277.409,102.057,400.000,67.811,-35.039,36.392,10.659,-0.138,2.298,13.458,24.083,0.030,194.814,104.109,999999.999,999999.999
 277.909,102.170,400.391,72.905,-34.873,39.020,10.659,-0.139,2.299,13.365,24.007,0.030,195.989,104.939,999999.999,999999.999
 278.409,102.191,400.391,75.003,-34.624,37.501,10.659,-0.139,2.302,13.174,23.859,0.030,192.462,102.447,999999.999,999999.999
 278.909,102.024,405.273,76.131,-33.841,34.952,10.659,-0.138,2.305,13.128,23.691,0.030,187.112,98.666,999999.999,999999.999
 279.409,101.998,405.273,75.673,-33.607,35.526,10.658,-0.138,2.309,13.180,23.435,0.030,184.024,96.483,999999.999,999999.999
 279.909,102.193,392.188,70.579,-33.936,39.178,10.658,-0.138,2.314,13.149,23.175,0.030,183.375,96.024,999999.999,999999.999
 280.409,102.106,400.391,63.532,-34.768,45.495,10.658,-0.136,2.322,13.170,22.709,0.030,183.623,96.200,999999.999,999999.999
 280.909,101.967,402.441,58.858,-35.234,52.423,10.659,-0.135,2.322,13.067,22.694,0.030,183.246,95.933,999999.999,999999.999
 281.409,102.010,410.156,57.243,-35.615,56.570,10.659,-0.136,2.313,12.928,23.229,0.030,182.301,95.265,999999.999,999999.999
 281.909,102.040,407.617,58.578,-35.447,54.673,10.659,-0.138,2.309,12.826,23.440,0.031,181.947,95.016,999999.999,999999.999
 282.409,102.143,388.965,61.355,-35.205,46.100,10.659,-0.138,2.317,12.726,22.972,0.031,178.956,92.902,999999.999,999999.999
 282.909,102.157,390.283,60.871,-35.220,37.804,10.659,-0.135,2.338,13.226,21.754,0.031,167.352,84.701,999999.999,999999.999
 283.409,102.130,400.391,57.326,-35.977,34.416,10.659,-0.132,2.352,13.932,20.946,0.031,150.924,73.092,999999.999,999999.999
 283.909,102.007,405.518,56.309,-36.994,34.974,10.659,-0.132,2.347,14.348,21.235,0.031,136.998,63.250,999999.999,999999.999
 284.409,102.179,410.742,60.449,-37.423,37.628,10.659,-0.134,2.324,14.391,22.591,0.031,129.661,58.064,999999.999,999999.999
 284.909,102.043,410.156,68.831,-36.997,40.810,10.659,-0.135,2.235,14.097,27.786,0.031,125.384,55.042,999999.999,999999.999
 285.409,102.050,405.615,75.178,-36.162,40.004,10.659,-0.130,2.037,14.255,39.371,0.031,118.919,50.473,999999.999,999999.999
 285.909,102.099,390.625,78.243,-35.330,31.454,10.659,-0.119,1.755,15.034,55.855,0.031,109.941,44.128,999999.999,999999.999
 286.409,102.286,404.834,80.492,-34.731,18.688,10.658,-0.105,1.519,16.151,69.630,0.031,97.176,35.107,999999.999,999999.999
 286.909,102.044,400.391,80.637,-34.083,8.417,10.658,-0.097,1.491,16.422,71.308,0.031,82.813,24.956,999999.999,999999.999
 287.409,102.154,405.273,77.150,-33.314,5.859,10.658,-0.096,1.630,15.641,63.157,0.031,70.190,16.035,999999.999,999999.999
 287.909,102.124,402.588,71.399,-32.915,12.216,10.658,-0.102,1.814,14.246,52.423,0.031,64.227,11.821,999999.999,999999.999
 288.409,102.337,400.391,66.224,-32.598,23.147,10.658,-0.110,1.923,12.991,46.050,0.032,63.703,11.451,999999.999,999999.999
 288.909,102.089,397.510,62.340,-33.054,33.837,10.658,-0.117,1.933,12.620,45.409,0.032,63.491,11.301,999999.999,999999.999
 289.409,102.090,396.094,61.591,-33.876,40.207,10.653,-0.121,1.914,12.649,46.558,0.032,62.344,10.491,999999.999,999999.999
 289.909,102.098,416.016,62.396,-34.997,40.948,10.647,-0.121,1.904,12.690,47.109,0.032,60.788,9.391,999999.999,999999.999
 290.409,102.130,410.156,63.216,-35.301,39.689,10.645,-0.120,1.909,12.580,46.839,0.032,59.556,8.520,999999.999,999999.999
 290.909,102.093,410.156,63.314,-34.567,41.218,10.645,-0.119,1.918,12.416,46.295,0.032,59.109,8.205,999999.999,999999.999
 291.409,102.166,405.273,59.349,-33.118,46.339,10.644,-0.117,1.931,12.578,45.540,0.032,58.926,8.075,999999.999,999999.999
 291.909,102.145,401.660,53.806,-32.433,50.873,10.644,-0.114,1.950,12.781,44.422,0.033,58.828,8.005,999999.999,999999.999
 292.409,102.095,390.625,48.542,-32.825,50.357,10.644,-0.110,1.971,12.707,43.207,0.033,58.816,7.997,999999.999,999999.999
 292.909,102.088,394.482,46.076,-34.012,44.447,10.643,-0.108,1.987,12.534,42.285,0.033,58.839,8.013,999999.999,999999.999
 293.409,102.177,399.219,46.313,-34.858,38.280,10.643,-0.106,1.997,12.335,41.708,0.033,58.906,8.061,999999.999,999999.999
 293.909,102.043,385.742,44.619,-35.034,36.883,10.642,-0.105,2.008,12.450,41.059,0.033,58.983,8.115,999999.999,999999.999
 294.409,101.977,402.148,41.820,-34.773,38.770,10.640,-0.103,2.027,12.763,39.967,0.033,58.991,8.121,999999.999,999999.999
 294.909,102.217,405.273,39.253,-34.271,39.267,10.637,-0.101,2.050,12.915,38.602,0.033,58.937,8.083,999999.999,999999.999
 295.409,102.139,405.273,39.085,-33.511,36.998,10.632,-0.100,2.066,12.806,37.661,0.033,58.803,7.988,999999.999,999999.999
 295.909,101.989,405.273,41.206,-32.718,34.583,10.622,-0.100,2.076,12.418,37.047,0.033,58.662,7.889,999999.999,999999.999
 296.409,102.146,405.762,41.656,-32.166,33.755,10.607,-0.100,2.088,12.207,36.397,0.033,58.583,7.832,999999.999,999999.999
 296.909,102.097,400.391,42.230,-31.773,34.835,10.594,-0.099,2.096,12.359,35.894,0.033,58.490,7.767,999999.999,999999.999
 297.409,102.108,397.949,43.973,-31.609,37.880,10.588,-0.098,2.102,12.633,35.556,0.033,58.365,7.678,999999.999,999999.999
 297.909,102.096,400.391,45.598,-31.834,41.191,10.584,-0.097,2.107,12.901,35.291,0.033,58.269,7.610,999999.999,999999.999
 298.409,102.169,403.076,47.587,-32.644,42.290,10.582,-0.095,2.113,12.799,34.902,0.032,58.294,7.629,999999.999,999999.999
 298.909,102.104,410.156,46.019,-33.968,39.674,10.581,-0.092,2.120,12.860,34.515,0.032,58.463,7.748,999999.999,999999.999
 299.409,102.044,413.086,43.068,-34.453,36.482,10.580,-0.091,2.103,13.149,35.488,0.032,58.668,7.893,999999.999,999999.999
 299.909,102.082,400.391,44.062,-34.239,37.650,10.578,-0.091,2.080,13.129,36.853,0.033,58.745,7.947,999999.999,999999.999
 300.409,102.268,400.391,48.351,-33.540,41.686,10.576,-0.088,2.089,12.680,36.321,0.033,58.652,7.881,999999.999,999999.999
 300.909,102.240,392.285,54.497,-33.123,42.531,10.574,-0.081,2.132,11.904,33.812,0.033,58.486,7.764,999999.999,999999.999
 301.409,102.044,400.391,55.513,-33.416,37.803,10.572,-0.069,2.185,11.253,30.715,0.033,58.345,7.665,999999.999,999999.999
 301.909,102.129,412.891,53.145,-33.386,30.565,10.566,-0.056,2.211,10.798,29.173,0.033,58.234,7.586,999999.999,999999.999
 302.409,102.232,405.273,52.422,-33.147,25.488,10.558,-0.044,2.209,10.514,29.302,0.033,58.155,7.530,999999.999,999999.999
 302.909,102.156,405.273,52.890,-32.619,24.128,10.552,-0.034,2.202,10.139,29.689,0.033,58.168,7.539,999999.999,999999.999
 303.409,102.096,405.273,52.885,-32.227,25.315,10.549,-0.026,2.199,9.823,29.899,0.033,58.582,7.832,999999.999,999999.999
 303.909,102.217,406.787,53.279,-32.054,26.917,10.549,-0.022,2.184,9.624,30.784,0.032,59.773,8.674,999999.999,999999.999
 304.409,102.208,393.750,56.702,-32.576,27.340,10.549,-0.022,2.142,9.449,33.245,0.032,61.142,9.641,999999.999,999999.999
 304.909,102.114,395.898,61.609,-33.396,27.861,10.548,-0.023,2.085,9.336,36.524,0.031,62.834,10.837,999999.999,999999.999
 305.409,102.094,400.928,65.229,-34.340,29.437,10.545,-0.021,2.040,9.027,39.173,0.031,65.291,12.573,999999.999,999999.999
 305.909,102.339,402.393,64.791,-34.864,30.997,10.543,-0.016,2.026,8.824,39.997,0.033,69.910,15.838,999999.999,999999.999
 306.409,102.195,405.273,63.164,-35.763,31.578,10.542,-0.008,2.035,8.616,39.462,0.039,77.054,20.886,999999.999,999999.999
 306.909,102.137,405.273,58.490,-37.707,31.497,10.544,0.005,2.054,8.342,38.363,0.049,83.920,25.738,999999.999,999999.999
 307.409,102.261,400.488,52.949,-40.769,32.829,10.560,0.024,2.083,7.886,36.665,0.060,89.627,29.772,999999.999,999999.999
 307.909,102.250,410.156,48.966,-44.286,35.619,10.612,0.055,2.115,6.796,34.792,0.065,96.533,34.652,999999.999,999999.999
 308.409,102.229,405.127,49.592,-48.498,37.274,10.690,0.092,2.143,5.548,33.169,0.058,106.406,41.630,999999.999,999999.999
 308.909,102.278,400.391,55.944,-53.489,37.155,10.792,0.128,2.179,4.474,31.048,0.045,120.394,51.516,999999.999,999999.999
 309.409,102.234,404.883,60.067,-59.821,37.038,10.905,0.147,2.223,3.682,28.497,0.033,134.331,61.364,999999.999,999999.999
 309.909,102.238,400.391,61.642,-68.201,36.210,11.004,0.142,2.257,3.366,26.468,0.037,145.037,68.931,999999.999,999999.999
 310.409,102.167,405.273,62.780,-78.642,33.976,11.083,0.130,2.277,3.254,25.326,0.119,150.480,72.778,999999.999,999999.999
 310.909,102.251,411.621,64.094,-89.917,31.642,11.232,0.121,2.287,3.088,24.753,0.421,149.877,72.351,999999.999,999999.999
 311.409,102.223,413.379,64.826,-99.552,30.194,11.594,0.109,2.300,2.901,23.954,0.919,147.216,70.470,999999.999,13.001
 311.909,102.291,405.273,65.807,-104.448,29.529,12.431,0.085,2.316,2.711,23.048,1.502,144.880,68.820,999999.999,3.689
 312.409,102.192,404.199,69.218,-105.434,28.431,13.016,0.053,2.323,2.605,22.607,1.967,144.776,68.746,1748.606,999999.999
 312.909,102.102,396.729,75.620,-103.938,26.182,13.025,0.030,2.326,2.583,22.475,2.212,144.148,68.303,1989.489,16.877
 313.409,102.289,405.273,83.453,-102.754,24.836,13.009,0.025,2.330,2.560,22.223,2.286,139.600,65.088,999999.999,999999.999
 313.909,102.295,412.988,87.620,-102.858,26.179,12.911,0.032,2.345,2.657,21.370,2.262,131.634,59.459,999999.999,999999.999
 314.409,102.212,405.273,85.153,-104.005,28.007,12.193,0.037,2.374,2.824,19.637,2.267,122.490,52.996,4.449,4.966
 314.909,102.085,413.477,77.848,-105.146,28.279,11.457,0.038,2.416,2.912,17.220,2.358,114.704,47.494,2.217,7.267
 315.409,102.350,410.156,69.415,-106.050,26.400,11.232,0.032,2.447,2.886,15.355,2.502,109.856,44.068,1.791,3.232
 315.909,102.262,401.465,64.015,-106.960,23.813,11.105,0.022,2.461,2.771,14.579,2.631,107.683,42.532,1.760,2.908
 316.409,102.197,409.277,62.921,-108.021,23.188,11.133,0.014,2.459,2.677,14.659,2.691,108.493,43.105,2.010,3.213
 316.909,102.188,415.039,64.441,-108.557,23.698,11.243,0.009,2.454,2.607,14.963,2.719,111.308,45.094,2.129,2.709
 317.409,102.202,408.301,65.141,-108.035,23.833,11.249,0.007,2.461,2.597,14.583,2.784,114.409,47.285,2.131,2.607
 317.909,102.263,400.391,63.818,-107.251,23.852,11.195,0.008,2.470,2.688,14.059,2.841,120.427,51.538,2.070,2.500
 318.409,102.242,410.059,62.317,-107.263,26.599,11.229,0.014,2.479,2.754,13.516,2.769,131.906,59.651,1.991,2.427
 318.909,102.299,405.273,63.001,-107.470,32.298,11.241,0.019,2.477,2.768,13.606,2.596,146.679,70.091,1.972,2.428
 319.409,102.352,405.273,67.053,-107.918,40.081,11.262,0.020,2.455,2.673,14.917,2.425,160.166,79.623,1.999,2.458
 319.909,102.306,410.156,71.045,-108.547,48.079,11.301,0.016,2.426,2.597,16.627,2.427,167.811,85.025,2.047,2.494
 320.409,102.307,407.178,70.519,-109.444,53.820,11.299,0.012,2.410,2.597,17.570,2.599,171.165,87.396,2.102,2.554
 320.909,102.255,400.391,67.563,-109.702,56.107,11.211,0.015,2.421,2.599,16.873,2.769,175.676,90.584,2.180,2.671
 321.409,102.272,403.564,65.813,-109.053,54.539,11.177,0.024,2.449,2.603,15.281,2.845,181.835,94.936,2.329,2.917
 321.909,102.287,406.152,63.691,-107.745,51.387,11.243,0.031,2.472,2.563,13.928,2.857,189.153,100.108,2.589,3.251
 322.409,102.323,410.156,59.473,-107.112,48.736,11.380,0.030,2.491,2.558,12.787,2.886,194.708,104.034,2.960,3.596
 322.909,102.408,411.279,53.363,-106.688,46.973,11.503,0.019,2.515,2.800,11.392,2.864,197.911,106.298,3.368,3.783
 323.409,102.302,415.039,48.563,-105.880,44.169,11.498,0.006,2.533,3.357,10.332,2.643,200.101,107.845,3.623,3.751
 323.909,102.313,411.084,48.719,-104.983,40.035,11.476,0.005,2.530,3.672,10.522,2.241,199.691,107.556,3.633,3.597
 324.409,102.268,400.391,52.717,-104.898,37.098,11.541,0.019,2.506,3.626,11.926,1.864,195.977,104.931,3.416,3.374
 324.909,102.324,403.711,56.611,-106.487,36.740,11.585,0.038,2.496,3.247,12.531,1.786,190.343,100.949,3.107,3.129
 325.409,102.335,408.691,59.165,-109.079,37.645,11.562,0.050,2.505,2.955,12.012,2.078,186.267,98.069,2.756,2.828
 325.909,102.359,410.156,57.077,-111.848,38.112,11.467,0.046,2.521,3.042,11.079,2.535,185.003,97.175,2.418,2.515
 326.409,102.293,414.502,52.826,-114.007,38.314,11.325,0.036,2.529,3.153,10.556,2.845,185.689,97.660,2.130,2.244
 326.909,102.392,408.887,52.444,-115.587,38.015,11.237,0.029,2.521,3.125,11.058,2.853,187.956,99.262,1.906,2.041
 327.409,102.363,409.570,56.777,-116.654,37.057,11.263,0.024,2.498,2.990,12.405,2.670,190.221,100.863,1.746,1.906
 327.909,102.380,403.271,64.729,-117.599,35.982,11.327,0.021,2.467,2.891,14.217,2.516,189.835,100.590,1.640,1.822
 328.409,102.340,410.010,70.395,-119.294,35.522,11.341,0.018,2.453,2.971,15.012,2.513,185.374,97.437,1.574,1.775
 328.909,102.321,410.156,71.493,-120.637,35.752,11.357,0.017,2.468,3.201,14.173,2.543,178.386,92.499,1.560,1.782
 329.409,102.492,400.977,72.125,-121.169,35.273,11.343,0.019,2.489,3.226,12.928,2.520,173.166,88.810,1.590,1.840
 329.909,102.301,415.039,75.399,-120.474,34.836,11.277,0.022,2.488,3.024,12.964,2.529,173.186,88.824,1.682,1.952
 330.409,102.278,410.156,75.147,-120.004,36.950,11.252,0.021,2.479,2.845,13.524,2.688,176.533,91.189,1.817,2.086
 330.909,102.468,410.156,69.059,-121.091,40.900,11.243,0.013,2.490,2.963,12.851,3.077,184.224,96.625,1.963,2.195
 331.409,102.343,415.674,58.305,-122.265,42.001,11.142,0.007,2.532,3.177,10.393,3.490,194.487,103.878,2.089,2.272
 331.909,102.246,419.922,49.456,-122.291,37.380,11.022,0.010,2.582,3.264,7.505,3.606,203.608,110.324,2.155,2.319
 332.409,102.188,419.922,49.283,-120.691,30.540,11.041,0.021,2.597,3.246,6.591,3.372,210.013,114.850,2.187,2.362
 332.909,102.373,406.055,56.434,-119.068,26.743,11.173,0.030,2.578,3.210,7.703,2.944,216.484,119.423,2.194,2.414
 333.409,102.430,404.883,66.451,-118.239,27.269,11.269,0.028,2.552,3.261,9.232,2.633,224.737,125.256,2.182,2.447
 333.909,102.249,408.936,73.206,-118.379,29.848,11.306,0.018,2.535,3.191,10.262,2.590,233.126,131.185,2.162,2.456
 334.409,102.367,406.641,75.057,-118.973,31.329,11.341,0.014,2.539,3.071,9.971,2.708,238.383,134.899,2.119,2.403
 334.909,102.390,417.969,70.524,-119.457,30.458,11.369,0.021,2.562,3.122,8.647,2.874,237.469,134.254,2.070,2.292
 335.409,102.413,424.805,64.289,-120.190,28.790,11.374,0.033,2.584,3.309,7.345,2.948,229.354,128.518,1.992,2.140
 335.909,102.380,420.654,61.454,-121.362,27.679,11.355,0.037,2.601,3.513,6.397,2.891,215.414,118.667,1.884,1.965
 336.409,102.313,419.922,60.820,-123.645,27.512,11.342,0.035,2.615,3.684,5.543,2.618,200.682,108.256,1.759,1.821
 336.909,102.433,424.316,64.436,-125.998,27.461,11.348,0.037,2.620,3.617,5.259,2.154,188.119,99.377,1.630,1.707
 337.409,102.424,415.039,72.962,-127.467,27.090,11.374,0.043,2.592,3.398,6.880,1.678,178.844,92.822,1.527,1.637
 337.909,102.432,415.039,84.595,-127.437,27.759,11.423,0.047,2.537,3.019,10.123,1.321,169.902,86.503,1.444,1.585
 338.409,102.366,425.098,89.674,-127.127,30.355,11.468,0.047,2.501,2.678,12.219,1.251,156.860,77.286,1.377,1.533
 338.909,102.195,419.922,84.839,-127.133,33.718,11.501,0.052,2.515,2.687,11.405,1.345,142.049,66.819,1.328,1.490
 339.409,102.376,409.961,76.290,-126.871,35.588,11.500,0.059,2.535,2.819,10.228,1.452,129.569,57.999,1.302,1.463
 339.909,102.412,405.664,76.318,-125.886,35.159,11.529,0.059,2.515,2.879,11.408,1.513,120.447,51.552,1.300,1.460
 340.409,102.300,417.822,84.792,-124.136,34.419,11.591,0.050,2.459,2.735,14.660,1.538,116.188,48.543,1.321,1.469
 340.909,102.534,434.570,87.586,-123.519,36.229,11.772,0.039,2.428,2.576,16.469,1.598,112.879,46.204,1.334,1.455
 341.409,102.396,425.635,82.048,-124.671,39.865,11.879,0.034,2.461,2.642,14.535,1.685,108.294,42.964,1.316,1.410
 341.909,102.390,415.039,72.224,-126.934,41.241,11.806,0.036,2.514,2.818,11.461,1.677,104.503,40.285,1.269,1.350
 342.409,102.391,418.262,66.309,-128.545,38.778,11.833,0.039,2.534,2.918,10.317,1.528,103.636,39.672,1.214,1.305
 342.909,102.289,415.039,69.377,-129.336,35.558,11.917,0.045,2.516,2.918,11.323,1.325,105.385,40.908,1.173,1.279
 343.409,102.378,418.506,78.411,-129.157,35.316,11.964,0.046,2.484,2.865,13.218,1.193,108.766,43.297,1.152,1.261
 343.909,102.470,421.436,86.498,-129.434,37.589,12.172,0.040,2.479,2.936,13.510,1.212,110.733,44.688,1.137,1.232
 344.409,102.418,410.156,85.764,-129.480,39.115,12.212,0.026,2.503,3.160,12.093,1.328,109.481,43.803,1.118,1.188
 344.909,102.235,408.008,78.901,-129.411,37.797,11.957,0.015,2.524,3.342,10.851,1.384,106.633,41.790,1.090,1.142
 345.409,102.287,415.039,75.478,-129.095,34.614,11.880,0.013,2.523,3.268,10.907,1.334,104.818,40.507,1.061,1.105
 345.909,102.345,408.545,78.298,-129.663,32.929,11.894,0.016,2.498,3.062,12.405,1.207,105.669,41.109,1.039,1.085
 346.409,102.422,405.273,81.805,-131.303,33.860,11.940,0.019,2.470,2.827,14.034,1.081,107.856,42.654,1.021,1.072
 346.909,102.506,417.578,85.194,-133.274,35.765,12.013,0.021,2.453,2.690,15.017,1.013,109.360,43.717,1.005,1.062
 347.409,102.423,412.109,92.764,-135.019,36.556,12.069,0.022,2.443,2.685,15.639,0.972,109.624,43.904,0.986,1.050
 347.909,102.392,414.355,99.434,-136.630,35.078,12.085,0.022,2.434,2.590,16.157,0.972,108.849,43.356,0.964,1.031
 348.409,102.606,419.922,102.789,-137.802,33.188,12.092,0.020,2.433,2.489,16.208,1.004,107.687,42.535,0.945,1.013
 348.909,102.517,417.627,99.779,-137.631,32.231,12.104,0.017,2.434,2.410,16.139,1.024,106.624,41.784,0.933,1.000
 349.409,102.515,410.156,96.717,-136.225,32.072,12.115,0.015,2.432,2.351,16.231,1.025,105.959,41.314,0.930,0.999
 349.909,102.500,417.773,96.037,-134.690,32.937,12.118,0.014,2.427,2.379,16.547,1.010,107.771,42.594,0.942,1.018
 350.409,102.457,419.922,93.384,-133.645,33.965,12.127,0.012,2.423,2.488,16.788,0.992,111.562,45.273,0.962,1.044
 350.909,102.487,419.922,92.519,-133.712,34.884,12.157,0.015,2.418,2.655,17.069,0.982,115.800,48.269,0.987,1.071
 351.409,102.578,424.365,94.839,-134.176,36.529,12.207,0.025,2.403,2.764,17.925,0.983,119.351,50.778,1.003,1.091
 351.909,102.375,419.922,103.641,-135.038,39.295,12.302,0.040,2.370,2.840,19.892,1.011,121.691,52.432,1.010,1.103
 352.409,102.536,429.004,109.070,-136.574,43.131,12.475,0.055,2.321,2.886,22.763,1.045,126.394,55.755,1.017,1.122
 352.909,102.492,428.076,111.393,-137.690,48.382,12.669,0.075,2.237,2.851,27.663,1.042,135.901,62.474,1.033,1.149
 353.409,102.446,427.832,107.974,-138.882,53.557,12.772,0.095,2.089,2.693,36.296,1.004,147.152,70.425,1.070,1.194
 353.909,102.464,423.389,96.404,-139.509,60.261,12.904,0.107,1.944,2.382,44.782,1.018,153.025,74.576,1.118,1.241
 354.409,102.511,423.633,83.912,-139.901,64.975,13.015,0.097,1.935,2.207,45.320,1.216,149.199,71.872,1.173,1.287
 354.909,102.424,416.211,70.958,-139.669,62.278,12.688,0.082,2.097,2.377,35.845,1.467,140.219,65.526,1.233,1.339
 355.409,102.385,419.287,70.156,-138.717,51.955,12.015,0.087,2.315,2.741,23.118,1.554,134.743,61.656,1.310,1.400
 355.909,102.347,413.867,79.988,-137.736,38.834,11.959,0.102,2.429,3.095,16.460,1.478,134.041,61.160,1.417,1.482
 356.409,102.536,429.688,91.752,-136.728,33.320,12.287,0.124,2.422,3.234,16.840,1.427,134.474,61.465,1.550,1.559
 356.909,102.603,429.688,101.328,-136.144,35.972,12.336,0.141,2.389,3.132,18.771,1.531,133.439,60.734,1.680,1.627
 357.409,102.430,419.922,101.084,-135.780,40.280,12.418,0.141,2.386,2.930,18.957,1.637,130.482,58.644,1.756,1.682
 357.909,102.440,415.479,97.876,-135.493,42.383,12.571,0.121,2.408,2.711,17.677,1.612,127.278,56.381,1.755,1.717
 358.409,102.498,419.922,94.490,-135.900,41.582,12.606,0.078,2.448,2.721,15.343,1.596,123.509,53.717,1.699,1.727
 358.909,102.297,424.561,88.145,-135.945,39.712,12.620,0.038,2.498,2.883,12.376,1.675,118.012,49.832,1.629,1.701
 359.409,102.514,427.344,81.379,-133.302,37.551,12.648,0.019,2.543,3.106,9.750,1.775,113.043,46.320,1.582,1.659
 359.909,102.359,424.805,79.086,-130.518,35.290,12.667,0.014,2.564,3.248,8.545,1.827,110.976,44.860,1.549,1.619
 360.409,102.569,422.510,80.719,-128.398,33.610,12.685,0.014,2.561,3.342,8.736,1.837,111.822,45.457,1.522,1.572
 360.909,102.584,423.828,81.151,-128.766,32.797,12.672,0.018,2.557,3.406,8.953,1.878,112.909,46.225,1.481,1.522
 361.409,102.545,416.406,82.114,-129.704,32.593,12.616,0.023,2.544,3.303,9.690,1.890,109.976,44.153,1.423,1.465
 361.909,102.579,424.805,83.199,-129.629,32.133,12.594,0.030,2.525,3.123,10.836,1.796,106.040,41.371,1.361,1.422
 362.409,102.561,421.777,86.017,-127.932,30.869,12.638,0.033,2.497,2.932,12.463,1.620,104.624,40.370,1.314,1.405
 362.909,102.483,424.805,86.657,-126.515,29.411,12.681,0.029,2.465,2.892,14.339,1.456,106.809,41.914,1.291,1.414
 363.409,102.592,428.076,84.613,-126.205,30.304,12.789,0.024,2.437,2.897,15.952,1.360,110.340,44.410,1.293,1.447
 363.909,102.494,429.688,83.800,-127.040,35.046,12.851,0.018,2.419,2.838,17.002,1.418,112.498,45.935,1.312,1.491
 364.409,102.542,429.688,80.749,-129.193,41.507,12.816,0.019,2.432,2.740,16.282,1.663,112.400,45.866,1.341,1.540
 364.909,102.530,438.281,72.788,-132.114,44.089,12.710,0.027,2.466,2.716,14.253,1.933,112.687,46.068,1.384,1.592
 365.409,102.533,434.570,61.434,-135.451,40.685,12.591,0.036,2.497,2.737,12.432,2.076,115.656,48.166,1.449,1.653
 365.909,102.415,426.221,53.798,-136.066,35.175,12.575,0.041,2.503,2.770,12.114,2.031,120.410,51.526,1.526,1.718
 366.409,102.572,429.688,51.947,-133.276,31.716,12.577,0.042,2.493,2.795,12.697,1.899,127.138,56.281,1.595,1.763
 366.909,102.455,423.242,53.635,-129.542,32.090,12.596,0.040,2.488,2.775,12.981,1.807,135.550,62.226,1.619,1.769
 367.409,102.372,429.688,60.735,-126.980,33.899,12.632,0.034,2.496,2.872,12.507,1.772,144.755,68.732,1.595,1.733
 367.909,102.593,428.613,70.156,-127.426,33.434,12.680,0.032,2.512,3.074,11.563,1.727,156.481,77.018,1.542,1.680
 368.409,102.626,434.570,79.312,-128.865,30.598,12.736,0.035,2.515,3.153,11.377,1.660,168.338,85.398,1.483,1.622
 368.909,102.610,429.004,86.907,-130.107,27.685,12.798,0.041,2.512,3.085,11.594,1.637,177.658,91.984,1.429,1.556
 369.409,102.644,420.508,85.330,-131.143,26.671,12.858,0.046,2.520,3.064,11.131,1.687,185.568,97.574,1.378,1.490
 369.909,102.498,415.234,79.484,-131.312,27.223,12.868,0.046,2.535,3.217,10.238,1.751,191.094,101.480,1.331,1.436
 370.409,102.628,424.902,75.030,-130.898,27.639,12.871,0.044,2.534,3.414,10.307,1.750,196.091,105.012,1.295,1.409
 370.909,102.404,434.570,79.125,-129.839,28.459,12.898,0.047,2.503,3.246,12.080,1.660,196.985,105.643,1.276,1.406
 371.409,102.679,434.326,89.691,-128.456,31.069,12.912,0.048,2.470,2.896,14.041,1.591,192.227,102.281,1.276,1.416
 371.909,102.583,429.688,96.921,-127.419,35.275,12.907,0.047,2.467,2.790,14.188,1.608,182.568,95.454,1.286,1.426
 372.409,102.580,428.223,98.662,-127.102,38.269,12.920,0.045,2.490,2.885,12.886,1.634,170.018,86.585,1.295,1.424
 372.909,102.593,421.191,96.999,-127.989,39.117,12.948,0.040,2.508,3.141,11.797,1.684,157.806,77.955,1.296,1.418
 373.409,102.475,424.072,94.269,-129.234,39.089,12.960,0.035,2.518,3.358,11.207,1.776,147.358,70.571,1.285,1.405
 373.909,102.526,423.193,89.812,-130.456,38.851,12.948,0.031,2.525,3.536,10.803,1.901,138.655,64.420,1.284,1.409
 374.409,102.510,424.805,86.281,-130.642,38.626,12.940,0.030,2.526,3.671,10.746,1.941,134.463,61.458,1.300,1.446
 374.909,102.513,424.805,87.213,-130.389,38.585,12.917,0.028,2.497,3.595,12.443,1.855,134.660,61.597,1.350,1.521
 375.409,102.543,419.922,92.775,-130.693,40.288,12.928,0.028,2.448,3.338,15.341,1.770,135.896,62.470,1.423,1.633
 375.909,102.593,423.682,96.962,-131.823,42.794,12.903,0.032,2.425,3.049,16.677,1.944,136.314,62.766,1.506,1.732
 376.409,102.515,424.805,91.050,-132.965,42.376,12.812,0.033,2.465,3.089,14.354,2.511,132.234,59.882,1.595,1.830
 376.909,102.458,428.809,75.214,-133.087,37.616,12.773,0.033,2.541,3.394,9.886,3.080,126.394,55.755,1.697,1.934
 377.409,102.528,434.570,61.456,-131.754,30.415,12.752,0.032,2.578,3.526,7.747,3.256,125.107,54.846,1.851,2.098
 377.909,102.546,426.074,57.659,-129.993,25.878,12.739,0.037,2.560,3.371,8.755,3.005,127.264,56.370,2.076,2.345
 378.409,102.570,423.975,64.219,-128.938,26.311,12.747,0.044,2.540,3.016,9.919,2.739,129.943,58.264,2.330,2.576
 378.909,102.718,415.039,68.033,-128.705,28.485,12.799,0.041,2.559,2.947,8.816,2.896,132.364,59.974,2.523,2.740
 379.409,102.616,422.070,60.441,-129.007,28.712,12.845,0.034,2.608,3.102,5.968,3.268,135.193,61.974,2.516,2.713
 379.909,102.494,424.805,48.864,-129.001,26.121,12.847,0.028,2.627,3.096,4.831,3.492,137.208,63.398,2.387,2.598
 380.409,102.640,427.393,45.832,-128.018,23.242,12.867,0.034,2.595,2.978,6.717,3.246,135.056,61.877,2.232,2.481
 380.909,102.470,434.570,57.811,-126.651,22.551,12.903,0.049,2.550,2.756,9.378,2.742,129.231,57.760,2.087,2.330
 381.409,102.652,429.395,71.368,-125.601,25.025,12.955,0.055,2.516,2.675,11.364,2.322,122.374,52.914,1.948,2.163
 381.909,102.650,424.805,79.829,-125.560,28.981,13.002,0.050,2.495,2.712,12.600,2.033,120.017,51.249,1.774,1.943
 382.409,102.572,424.805,81.124,-126.864,32.239,13.017,0.035,2.481,2.726,13.409,1.897,119.803,51.098,1.586,1.734
 382.909,102.593,445.996,76.979,-127.996,33.908,13.024,0.023,2.475,2.854,13.753,1.760,117.093,49.182,1.420,1.568
 383.409,102.478,419.922,76.550,-128.352,34.161,13.036,0.021,2.476,2.956,13.690,1.588,113.261,46.474,1.305,1.464
 383.909,102.572,419.922,78.173,-128.644,34.610,13.041,0.022,2.475,2.942,13.738,1.456,109.840,44.056,1.244,1.420
 384.409,102.581,419.922,77.407,-128.932,36.901,13.040,0.021,2.465,2.850,14.347,1.401,107.986,42.746,1.230,1.419
 384.909,102.547,415.039,77.232,-129.654,39.538,13.040,0.019,2.452,2.700,15.069,1.421,107.143,42.151,1.246,1.444
 385.409,102.537,425.732,78.575,-130.021,40.032,13.040,0.016,2.448,2.633,15.335,1.483,105.782,41.189,1.280,1.480
 385.909,102.595,429.688,80.195,-130.036,37.698,13.040,0.014,2.466,2.686,14.252,1.556,103.973,39.910,1.319,1.518
 386.409,102.468,418.408,78.766,-130.193,33.706,13.040,0.020,2.501,2.785,12.250,1.587,105.351,40.884,1.366,1.570
 386.909,102.517,415.039,72.968,-131.245,30.227,13.039,0.043,2.514,2.822,11.448,1.507,111.272,45.068,1.422,1.648
 387.409,102.628,423.047,71.875,-132.155,28.680,13.040,0.086,2.492,2.776,12.752,1.355,119.290,50.735,1.486,1.747
 387.909,102.742,439.453,78.593,-132.044,30.925,13.045,0.121,2.437,2.698,15.993,1.263,125.480,55.109,1.539,1.835
 388.409,102.690,439.453,92.090,-130.921,36.784,13.048,0.125,2.386,2.668,18.930,1.312,127.099,56.253,1.561,1.872
 388.909,102.618,444.336,103.351,-130.080,42.403,13.048,0.098,2.373,2.633,19.705,1.405,126.988,56.175,1.539,1.848
 389.409,102.649,430.859,107.241,-129.999,43.950,13.048,0.063,2.379,2.587,19.357,1.416,132.436,60.025,1.498,1.797
 389.909,102.621,434.570,107.431,-130.143,41.688,13.048,0.044,2.398,2.563,18.246,1.331,147.657,70.782,1.458,1.754
 390.409,102.585,425.098,101.614,-130.976,39.680,13.048,0.039,2.416,2.632,17.176,1.234,166.149,83.851,1.425,1.714
 390.909,102.687,417.627,96.208,-131.837,39.143,13.048,0.047,2.422,2.815,16.844,1.210,180.158,93.752,1.396,1.681
 391.409,102.609,410.303,94.103,-133.074,38.704,13.048,0.065,2.416,2.933,17.168,1.224,189.521,100.368,1.360,1.657
 391.909,102.631,430.078,95.537,-132.627,38.665,13.048,0.086,2.391,2.910,18.664,1.241,198.308,106.578,1.333,1.656
 392.409,102.691,433.984,102.870,-131.644,40.248,13.048,0.103,2.366,2.793,20.145,1.239,209.950,114.806,1.325,1.688
 392.909,102.609,427.686,109.081,-130.581,42.965,13.048,0.105,2.356,2.637,20.727,1.228,223.121,124.114,1.354,1.740
 393.409,102.656,424.805,109.566,-129.179,44.499,13.048,0.095,2.364,2.607,20.212,1.238,233.319,131.321,1.409,1.803
 393.909,102.663,427.881,105.766,-128.087,43.800,13.048,0.077,2.387,2.700,18.884,1.291,238.113,134.709,1.475,1.857
 394.409,102.513,434.570,101.216,-127.147,42.613,13.048,0.060,2.416,2.890,17.215,1.350,238.883,135.253,1.538,1.908
 394.909,102.627,437.891,101.278,-126.923,42.080,13.048,0.055,2.441,3.075,15.728,1.369,236.547,133.602,1.602,1.969
 395.409,102.745,432.520,102.420,-127.569,42.070,13.048,0.052,2.445,3.136,15.505,1.361,227.743,127.380,1.684,2.045
 395.909,102.582,424.805,99.220,-128.310,42.876,13.048,0.040,2.435,3.183,16.059,1.389,212.772,116.800,1.794,2.137
 396.409,102.720,424.805,91.173,-129.464,42.992,13.047,0.025,2.437,3.358,15.986,1.503,195.214,104.392,1.900,2.205
 396.909,102.635,424.805,81.791,-128.473,41.259,13.045,0.020,2.460,3.607,14.605,1.639,180.926,94.294,1.953,2.222
 397.409,102.656,434.570,75.411,-127.547,38.174,13.046,0.031,2.488,3.700,13.004,1.740,170.905,87.212,1.928,2.191
 397.909,102.661,434.570,74.740,-126.190,35.798,13.048,0.042,2.493,3.465,12.716,1.810,159.042,78.828,1.854,2.131
 398.409,102.591,431.152,79.613,-125.359,35.998,13.048,0.044,2.478,3.101,13.588,1.860,143.522,67.860,1.788,2.081
 398.909,102.740,437.549,83.893,-126.397,37.209,13.048,0.043,2.462,2.924,14.481,1.893,128.181,57.019,1.749,2.039
 399.409,102.634,435.547,83.574,-128.319,37.896,13.048,0.054,2.465,2.942,14.302,1.903,114.996,47.701,1.732,2.006
 399.909,102.763,425.195,80.429,-130.683,37.760,13.048,0.075,2.483,3.105,13.259,1.944,108.479,43.095,1.719,1.980
 400.409,102.717,429.688,77.632,-132.750,36.493,13.048,0.096,2.504,3.239,12.074,2.005,109.876,44.082,1.715,1.970
 400.909,102.671,439.160,77.541,-133.054,34.497,13.048,0.102,2.518,3.289,11.232,2.043,112.090,45.646,1.728,1.978
 401.409,102.624,410.156,77.296,-132.640,32.144,13.048,0.085,2.535,3.341,10.247,2.127,113.520,46.657,1.766,1.984
 401.909,102.781,429.785,74.619,-132.121,30.187,13.048,0.062,2.568,3.493,8.301,2.207,112.812,46.157,1.811,1.968
 402.409,102.764,434.570,71.098,-131.249,28.482,13.048,0.051,2.597,3.756,6.613,2.180,111.115,44.958,1.813,1.907
 402.909,102.655,434.229,70.301,-130.568,27.211,13.048,0.052,2.590,3.888,6.989,2.012,114.322,47.224,1.772,1.833
 403.409,102.781,429.688,78.029,-130.454,27.991,13.048,0.066,2.538,3.702,10.047,1.696,122.907,53.291,1.697,1.776
 403.909,102.691,430.225,86.225,-130.312,31.049,13.047,0.083,2.470,3.270,14.014,1.417,132.490,60.064,1.622,1.731
 404.409,102.855,428.320,88.851,-130.883,35.960,13.046,0.099,2.417,2.892,17.162,1.244,139.860,65.272,1.560,1.691
 404.909,102.691,419.922,86.314,-131.622,40.399,13.046,0.114,2.386,2.678,18.975,1.178,149.014,71.741,1.491,1.619
 405.409,102.696,430.029,87.363,-132.073,43.257,13.046,0.122,2.368,2.587,20.025,1.230,167.105,84.527,1.404,1.520
 405.909,102.597,419.922,93.802,-132.080,44.236,13.047,0.124,2.347,2.557,21.218,1.295,187.628,99.030,1.317,1.428
 406.409,102.716,419.922,98.590,-130.434,44.232,13.047,0.125,2.320,2.521,22.814,1.287,203.839,110.487,1.250,1.368
 406.909,102.725,432.227,100.267,-129.192,45.555,13.045,0.128,2.302,2.499,23.846,1.200,209.973,114.822,1.227,1.357
 407.409,102.850,439.453,97.331,-128.003,48.082,13.045,0.125,2.315,2.494,23.101,1.109,208.438,113.737,1.238,1.378
 407.909,102.673,428.174,92.115,-128.419,49.348,13.045,0.103,2.367,2.660,20.051,1.142,210.417,115.135,1.274,1.405
 408.409,102.811,424.805,86.153,-129.456,47.157,13.045,0.068,2.438,3.049,15.923,1.296,211.701,116.043,1.320,1.436
 408.909,102.763,426.514,83.837,-129.475,41.346,13.045,0.044,2.486,3.340,13.118,1.445,207.577,113.129,1.372,1.473
 409.409,102.755,433.984,85.442,-128.089,35.818,13.045,0.039,2.497,3.355,12.473,1.527,200.518,108.140,1.454,1.547
 409.909,102.651,438.477,86.182,-127.479,34.661,13.045,0.043,2.481,3.088,13.404,1.548,192.974,102.808,1.585,1.683
 410.409,102.893,435.254,83.916,-126.273,36.288,13.045,0.039,2.475,2.838,13.750,1.610,190.395,100.986,1.770,1.865
 410.909,102.788,434.570,82.350,-125.144,37.365,13.045,0.032,2.513,2.945,11.527,1.852,190.450,101.025,1.996,2.090
 411.409,102.885,434.570,80.964,-124.028,35.208,13.045,0.029,2.573,3.203,8.003,2.227,187.099,98.657,2.193,2.274
 411.909,102.784,424.805,74.631,-124.897,30.219,13.045,0.031,2.617,3.415,5.428,2.601,173.625,89.134,2.287,2.353
 412.409,102.792,434.863,65.397,-126.838,26.465,13.045,0.035,2.635,3.351,4.411,2.783,155.535,76.350,2.281,2.343
 412.909,102.837,443.848,59.988,-126.327,25.772,13.045,0.039,2.622,3.098,5.156,2.642,136.721,63.053,2.180,2.247
 413.409,102.863,438.770,64.672,-127.050,27.224,13.045,0.045,2.595,2.922,6.704,2.313,123.965,54.039,2.058,2.160
 413.909,102.691,426.807,79.214,-128.252,29.442,13.045,0.052,2.554,2.803,9.140,1.934,119.383,50.801,1.931,2.070
 414.409,102.817,424.805,90.814,-129.214,31.823,13.044,0.056,2.499,2.754,12.347,1.620,117.738,49.638,1.811,1.982
 414.909,102.803,418.555,95.247,-128.582,34.912,13.043,0.054,2.462,2.679,14.504,1.447,118.537,50.202,1.692,1.859
 415.409,102.910,424.805,91.671,-128.009,37.521,13.042,0.043,2.461,2.761,14.560,1.416,117.999,49.823,1.564,1.690
 415.909,102.693,431.543,83.923,-129.177,37.690,13.044,0.036,2.498,2.945,12.391,1.395,113.485,46.632,1.428,1.513
 416.409,102.885,424.805,81.880,-130.303,34.791,13.045,0.040,2.521,2.955,11.074,1.284,107.332,42.284,1.301,1.359
 416.909,102.775,432.031,88.120,-131.417,31.204,13.045,0.059,2.499,2.858,12.351,1.090,104.036,39.955,1.191,1.250
 417.409,102.856,425.879,99.253,-132.626,30.772,13.045,0.081,2.442,2.763,15.678,0.910,105.041,40.665,1.108,1.180
 417.909,102.766,415.039,107.608,-132.458,34.408,13.044,0.096,2.378,2.781,19.442,0.814,108.912,43.400,1.050,1.141
 418.409,102.901,426.318,105.815,-130.217,40.450,13.043,0.105,2.346,2.902,21.295,0.782,112.238,45.752,1.018,1.124
 418.909,102.675,429.688,97.945,-128.612,46.089,13.043,0.109,2.346,2.988,21.269,0.781,113.259,46.473,1.006,1.118
 419.409,102.695,434.570,88.894,-127.773,49.184,13.042,0.109,2.380,2.955,19.310,0.829,111.180,45.004,1.003,1.107
 419.909,102.731,421.680,78.898,-128.839,49.733,13.042,0.096,2.429,2.854,16.461,0.955,106.223,41.501,1.000,1.081
 420.409,102.755,419.922,72.498,-129.368,46.682,13.042,0.078,2.478,2.802,13.575,1.071,99.852,36.998,0.984,1.042
 420.909,102.762,415.381,69.719,-129.966,40.631,13.042,0.071,2.498,2.849,12.418,1.084,95.641,34.022,0.955,1.003
 421.409,102.877,417.236,74.258,-129.964,34.197,13.042,0.091,2.456,2.950,14.880,0.956,98.367,35.948,0.922,0.984
 421.909,102.783,434.277,84.562,-129.739,30.951,13.042,0.126,2.368,2.937,19.974,0.773,106.802,41.910,0.892,0.978
 422.409,102.818,419.922,95.546,-131.418,34.083,13.042,0.147,2.280,2.783,25.143,0.665,116.711,48.912,0.876,0.986
 422.909,102.779,424.658,102.199,-133.048,40.605,13.041,0.145,2.243,2.651,27.302,0.633,123.233,53.521,0.868,0.995
 423.409,102.813,419.922,101.893,-131.901,45.131,13.040,0.120,2.279,2.642,25.213,0.683,123.053,53.394,0.867,0.993
 423.909,102.652,424.463,100.197,-129.725,44.871,13.019,0.088,2.340,2.785,21.608,0.785,119.381,50.799,0.873,0.991
 424.409,102.826,428.711,98.347,-129.194,40.516,13.022,0.061,2.384,2.924,19.084,0.896,114.993,47.699,0.890,0.996
 424.909,102.656,433.398,99.099,-129.794,36.636,13.048,0.044,2.403,3.011,17.943,0.968,112.025,45.600,0.922,1.026
 425.409,102.838,427.979,101.008,-131.734,36.924,13.048,0.035,2.412,2.998,17.432,0.980,110.908,44.812,0.979,1.096
 425.909,102.836,428.857,98.107,-131.903,39.118,13.048,0.035,2.434,2.947,16.146,0.986,110.475,44.505,1.052,1.198
 426.409,102.771,424.805,96.902,-132.323,39.598,13.048,0.040,2.460,3.006,14.632,1.029,110.129,44.261,1.139,1.322
 426.909,102.786,429.688,98.083,-132.372,37.877,13.048,0.047,2.469,3.015,14.115,1.099,109.459,43.787,1.227,1.440
 427.409,102.821,429.688,101.863,-131.759,35.746,13.048,0.050,2.461,2.924,14.548,1.171,108.281,42.955,1.309,1.531
 427.909,102.795,429.688,102.098,-131.258,35.355,13.047,0.048,2.450,2.784,15.217,1.209,106.652,41.803,1.390,1.604
 428.409,102.942,429.688,97.505,-130.994,36.153,13.046,0.047,2.452,2.718,15.082,1.236,104.743,40.454,1.472,1.659
 428.909,102.828,434.570,91.882,-131.141,36.888,13.046,0.050,2.459,2.740,14.654,1.316,103.597,39.644,1.553,1.704
 429.409,102.901,434.570,86.139,-131.129,37.572,13.045,0.062,2.449,2.800,15.285,1.469,104.012,39.938,1.615,1.734
 429.909,102.847,424.805,84.422,-131.104,38.069,13.045,0.083,2.419,2.819,17.022,1.625,105.687,41.122,1.635,1.745
 430.409,102.945,424.805,85.707,-131.508,37.888,13.045,0.108,2.386,2.781,18.959,1.652,107.328,42.281,1.621,1.751
 430.909,102.905,440.332,92.421,-132.737,36.408,13.045,0.128,2.370,2.824,19.910,1.484,107.315,42.272,1.593,1.765
 431.409,102.865,420.947,103.177,-134.517,34.977,13.044,0.141,2.369,2.883,19.952,1.242,105.947,41.305,1.577,1.799
 431.909,102.948,422.168,111.150,-135.583,35.955,13.044,0.148,2.361,2.969,20.390,1.075,104.583,40.341,1.576,1.841
 432.409,102.797,415.234,114.393,-135.372,38.926,13.047,0.158,2.348,3.000,21.193,1.030,104.332,40.164,1.581,1.864
 432.909,102.782,417.529,116.398,-133.847,41.119,13.046,0.170,2.337,2.977,21.840,1.070,105.722,41.147,1.580,1.850
 433.409,102.770,425.098,118.406,-131.424,41.332,13.047,0.175,2.333,2.995,22.037,1.104,108.000,42.756,1.572,1.812
 433.909,102.786,434.570,119.948,-129.693,41.302,13.048,0.168,2.349,2.999,21.120,1.106,110.071,44.220,1.567,1.775
 434.409,102.916,439.453,116.663,-130.488,42.628,13.047,0.144,2.383,3.014,19.098,1.122,110.573,44.574,1.574,1.753
 434.909,102.957,439.453,104.275,-132.612,44.467,13.047,0.107,2.441,2.971,15.704,1.178,108.131,42.849,1.592,1.743
 435.409,102.894,430.322,91.938,-135.529,43.839,13.046,0.071,2.503,2.893,12.086,1.249,103.611,39.654,1.612,1.735
 435.909,102.871,428.223,85.908,-135.181,40.172,13.045,0.050,2.523,2.852,10.924,1.321,99.770,36.940,1.614,1.710
 436.409,102.911,424.805,88.977,-134.377,36.265,13.042,0.045,2.493,2.818,12.706,1.417,99.268,36.585,1.585,1.655
 436.909,102.756,431.641,97.728,-133.043,34.290,13.040,0.043,2.432,2.820,16.247,1.480,102.767,39.058,1.514,1.557
 437.409,102.949,435.645,102.345,-130.072,34.316,13.040,0.039,2.392,2.875,18.603,1.426,107.791,42.608,1.406,1.432
 437.909,102.723,435.791,104.477,-127.788,34.707,13.040,0.035,2.394,2.934,18.502,1.230,111.963,45.557,1.273,1.302
 438.409,102.871,424.805,108.534,-126.121,34.108,13.041,0.034,2.410,3.025,17.567,0.981,114.671,47.471,1.142,1.190
 438.909,102.814,417.090,114.016,-126.370,33.123,13.042,0.035,2.413,3.063,17.396,0.794,116.959,49.088,1.028,1.104
 439.409,102.778,424.805,117.762,-127.357,34.414,13.042,0.036,2.390,3.034,18.688,0.681,119.779,51.080,0.941,1.047
 439.909,102.915,437.109,119.372,-127.928,38.467,13.042,0.034,2.360,3.002,20.484,0.626,122.457,52.973,0.883,1.015
 440.409,102.790,434.570,124.254,-127.423,43.064,13.042,0.034,2.343,2.937,21.477,0.643,123.575,53.763,0.852,1.006
 440.909,102.972,434.570,132.341,-125.425,44.882,13.041,0.033,2.336,2.946,21.847,0.713,122.770,53.194,0.843,1.019
 441.409,102.915,424.561,134.525,-123.627,42.896,13.038,0.032,2.335,3.039,21.957,0.805,120.559,51.632,0.856,1.052
 441.909,102.871,410.156,133.495,-122.413,40.311,13.037,0.030,2.330,3.124,22.204,0.886,118.263,50.009,0.885,1.099
 442.409,102.884,429.297,128.424,-124.901,39.757,13.042,0.027,2.324,3.156,22.602,0.929,116.759,48.946,0.924,1.144
 442.909,102.821,434.570,125.472,-126.758,41.629,13.045,0.027,2.325,3.121,22.515,0.936,115.991,48.404,0.956,1.169
 443.409,102.858,434.570,125.883,-129.320,44.307,13.045,0.031,2.333,3.062,22.055,0.901,116.114,48.490,0.960,1.156
 443.909,102.988,429.688,125.326,-129.604,46.301,13.045,0.035,2.338,2.963,21.747,0.837,116.918,49.058,0.938,1.117
 444.409,102.910,432.422,128.259,-128.499,46.981,13.045,0.033,2.330,2.794,22.202,0.753,118.228,49.985,0.897,1.060
 444.909,103.049,425.586,129.498,-125.950,46.570,13.045,0.027,2.315,2.671,23.097,0.674,119.535,50.908,0.853,0.999
 445.409,102.903,434.570,132.691,-124.128,46.849,13.045,0.026,2.310,2.675,23.406,0.623,120.187,51.369,0.814,0.936
 445.909,102.736,438.818,134.107,-122.098,47.852,13.045,0.030,2.325,2.705,22.503,0.613,119.845,51.127,0.778,0.879
 446.409,102.891,434.570,132.087,-121.545,49.606,13.045,0.035,2.360,2.774,20.495,0.635,118.790,50.382,0.749,0.834
 446.909,102.955,431.934,125.372,-120.883,51.616,13.045,0.039,2.386,2.864,18.925,0.646,118.096,49.891,0.729,0.814
 447.409,102.919,426.758,116.781,-121.626,51.111,13.045,0.040,2.390,2.910,18.690,0.625,118.471,50.156,0.727,0.824
 447.909,103.037,429.688,113.599,-123.437,48.459,13.045,0.041,2.385,2.855,18.985,0.599,119.413,50.822,0.750,0.867
 448.409,102.827,433.350,114.182,-124.752,45.334,13.045,0.043,2.394,2.718,18.494,0.623,119.133,50.624,0.798,0.942
 448.909,103.036,439.453,112.205,-126.398,43.321,13.044,0.044,2.433,2.696,16.216,0.764,115.885,48.329,0.873,1.038
 449.409,102.975,435.547,101.119,-126.477,42.369,13.043,0.040,2.482,2.857,13.311,1.005,110.028,44.189,0.974,1.154
 449.909,103.026,434.570,87.189,-123.935,39.864,13.043,0.032,2.506,3.104,11.916,1.272,103.698,39.716,1.095,1.277
 450.409,102.910,434.570,80.983,-121.332,36.283,13.042,0.026,2.495,3.278,12.572,1.507,99.407,36.683,1.245,1.422
 450.909,102.789,421.729,87.114,-117.094,33.475,13.042,0.033,2.463,3.214,14.465,1.618,99.271,36.587,1.411,1.589
 451.409,102.981,424.805,97.606,-115.103,32.132,13.042,0.047,2.423,2.979,16.809,1.628,102.289,38.720,1.593,1.771
 451.909,102.937,435.352,103.212,-116.218,33.586,13.042,0.058,2.402,2.769,18.025,1.544,106.070,41.392,1.761,1.975
 452.409,103.127,429.688,102.310,-119.968,36.715,13.042,0.064,2.409,2.723,17.603,1.470,108.290,42.961,1.899,2.147
 452.909,102.991,434.570,97.109,-124.563,39.127,13.042,0.070,2.441,2.836,15.738,1.490,108.583,43.168,2.013,2.304
 453.409,102.885,434.570,92.945,-124.562,39.476,13.042,0.082,2.471,2.974,13.971,1.568,107.468,42.381,2.131,2.417
 453.909,103.098,431.982,92.434,-124.927,38.117,13.041,0.090,2.467,2.892,14.189,1.702,105.113,40.716,2.284,2.514
 454.409,103.046,439.453,94.808,-124.139,37.249,13.042,0.093,2.449,2.776,15.274,1.828,102.077,38.570,2.476,2.620
 454.909,102.924,439.453,99.638,-125.813,38.138,13.042,0.087,2.422,2.766,16.844,1.961,98.977,36.380,2.677,2.706
 455.409,102.926,434.570,101.524,-124.888,39.676,13.041,0.077,2.402,2.763,18.033,2.073,98.389,35.964,2.841,2.799
 455.909,102.903,434.570,101.122,-124.217,40.949,13.041,0.069,2.398,2.766,18.269,2.114,101.090,37.873,2.922,2.850
 456.409,103.084,450.293,97.785,-121.832,42.343,13.041,0.059,2.399,2.715,18.204,2.073,103.869,39.837,2.912,2.870
 456.909,102.922,424.805,93.524,-119.575,42.863,13.041,0.050,2.409,2.672,17.613,1.917,104.626,40.372,2.812,2.799
 457.409,102.952,440.332,90.585,-120.572,41.257,13.042,0.044,2.428,2.649,16.487,1.728,103.040,39.251,2.628,2.593
 457.909,102.927,444.336,88.050,-123.837,38.031,13.042,0.044,2.453,2.685,15.014,1.577,100.459,37.427,2.337,2.265
 458.409,102.911,440.576,86.685,-126.423,34.849,13.041,0.048,2.484,2.814,13.214,1.490,99.203,36.539,1.997,1.902
 458.909,102.952,437.012,84.163,-124.688,33.351,13.040,0.052,2.504,3.017,12.047,1.416,99.366,36.654,1.670,1.589
 459.409,103.019,431.836,82.923,-124.451,34.078,13.040,0.059,2.504,3.136,12.044,1.274,100.922,37.754,1.411,1.361
 459.909,103.067,432.617,89.829,-125.347,36.143,13.040,0.070,2.485,3.142,13.187,1.065,104.402,40.213,1.227,1.213
 460.409,102.960,439.453,102.052,-127.566,38.601,13.040,0.079,2.443,3.047,15.603,0.865,109.290,43.668,1.105,1.124
 460.909,103.027,439.453,114.416,-129.064,41.201,13.040,0.087,2.400,2.932,18.117,0.738,113.746,46.817,1.021,1.066
 461.409,103.045,434.570,115.522,-129.785,44.165,13.040,0.095,2.381,2.901,19.239,0.723,115.950,48.374,0.964,1.022
 461.909,103.026,438.965,108.050,-130.155,46.358,13.040,0.108,2.392,2.972,18.619,0.787,115.869,48.317,0.926,0.987
 462.409,102.908,431.738,101.222,-127.052,45.836,13.040,0.124,2.406,3.156,17.752,0.833,114.574,47.402,0.904,0.954
 462.909,102.996,434.570,99.198,-125.419,42.683,13.040,0.137,2.399,3.273,18.162,0.834,113.351,46.538,0.892,0.925
 463.409,102.953,434.277,101.218,-123.148,39.379,13.039,0.140,2.381,3.270,19.235,0.823,112.797,46.146,0.878,0.892
 463.909,103.119,439.453,101.937,-120.576,38.318,13.039,0.141,2.378,3.283,19.409,0.833,113.193,46.426,0.854,0.854
 464.409,103.020,439.258,101.592,-121.165,38.554,13.036,0.143,2.396,3.304,18.371,0.839,118.342,50.065,0.818,0.822
 464.909,102.858,424.805,100.560,-121.507,38.418,13.033,0.142,2.400,3.347,18.116,0.804,128.144,56.992,0.783,0.798
 465.409,103.027,427.588,102.165,-121.462,39.576,13.027,0.137,2.358,3.252,20.569,0.721,140.060,65.414,0.758,0.793
 465.909,103.023,434.570,99.441,-118.022,43.675,12.987,0.125,2.293,2.997,24.367,0.662,148.904,71.663,0.749,0.801
 466.409,102.984,437.549,94.403,-118.787,49.940,12.989,0.100,2.262,2.799,26.221,0.701,150.525,72.809,0.754,0.820
 466.909,103.034,444.336,90.494,-121.476,54.318,13.035,0.070,2.295,2.796,24.281,0.810,150.322,72.666,0.774,0.846
 467.409,102.983,444.336,90.099,-120.903,53.338,13.039,0.046,2.370,3.071,19.898,0.912,154.298,75.476,0.800,0.883
 467.909,103.034,441.553,93.657,-118.630,48.407,13.037,0.038,2.431,3.312,16.296,0.927,165.008,83.044,0.830,0.923
 468.409,102.976,429.688,93.433,-118.196,42.760,13.037,0.046,2.451,3.353,15.169,0.889,178.468,92.557,0.846,0.967
 468.909,103.194,436.816,88.516,-118.482,38.655,13.037,0.049,2.427,3.272,16.561,1.013,183.556,96.152,0.830,1.012
 469.409,102.981,451.758,77.653,-118.443,36.180,13.036,0.047,2.336,3.309,21.890,1.582,178.071,92.276,0.788,1.093
 469.909,103.044,448.633,63.632,-119.980,33.967,12.710,0.052,2.152,3.274,32.624,2.563,171.338,87.518,0.752,1.254
 470.409,103.072,442.480,48.606,-122.390,31.333,11.121,0.057,1.911,3.039,46.751,3.658,175.302,90.319,0.747,1.549
 470.909,103.042,442.725,35.516,-125.794,28.069,11.142,0.053,1.704,2.757,58.802,4.435,189.650,100.459,0.800,1.941
 471.409,103.078,427.002,28.519,-128.560,23.572,12.716,0.044,1.594,2.537,65.291,4.665,204.376,110.867,0.911,2.277
 471.909,103.128,434.570,27.003,-130.109,18.640,13.042,0.044,1.603,2.584,64.741,4.358,210.631,115.287,1.012,2.274
 472.409,102.954,434.570,31.931,-130.742,15.117,13.042,0.061,1.721,2.761,57.822,3.820,205.163,111.422,1.060,2.106
 472.909,103.074,444.336,45.847,-126.842,15.031,13.042,0.079,1.917,2.998,46.397,3.383,192.728,102.635,1.008,2.075
 473.409,103.236,439.697,62.180,-125.698,18.470,13.040,0.088,2.076,3.237,37.061,3.138,180.286,93.841,0.974,2.242
 473.909,103.118,436.865,72.823,-129.445,26.122,13.007,0.092,2.088,3.151,36.349,2.962,175.174,90.229,1.000,2.823
 474.409,102.977,439.453,73.740,-133.508,36.486,12.686,0.090,2.018,2.863,40.477,2.773,176.924,91.466,1.085,3.457
 474.909,103.072,432.227,67.566,-136.404,46.594,12.535,0.075,1.976,2.993,42.944,2.813,178.065,92.272,1.137,3.447
 475.409,102.933,434.814,61.850,-138.442,53.521,10.773,0.067,1.966,3.248,43.527,3.114,175.151,90.212,1.075,2.825
 475.909,102.983,439.453,57.628,-141.529,55.978,8.626,0.060,1.866,3.223,49.356,3.521,169.961,86.545,0.947,2.309
 476.409,102.962,434.570,51.553,-143.924,57.183,9.942,0.049,1.646,2.819,62.243,3.750,166.484,84.088,0.860,2.187
 476.909,103.141,440.625,44.536,-143.945,58.966,12.276,0.030,1.399,2.101,76.695,3.643,171.565,87.679,0.852,2.236
 477.409,103.024,434.570,38.993,-143.877,64.927,13.036,0.006,1.257,1.682,84.955,3.352,181.817,94.923,0.918,2.441
 477.909,103.078,434.570,36.330,-142.894,72.838,13.036,-0.000,1.291,1.658,82.958,2.952,191.516,101.778,0.983,2.535
 478.409,103.004,440.381,38.371,-142.271,74.700,13.035,0.010,1.455,1.934,73.405,2.667,198.815,106.937,1.017,2.668
 478.909,103.068,444.336,45.732,-142.220,67.028,13.027,0.029,1.655,2.473,61.710,2.637,204.627,111.044,0.994,3.117
 479.409,103.114,444.336,54.238,-143.043,54.221,13.008,0.048,1.747,2.813,56.329,2.806,211.362,115.804,0.978,3.524
 479.909,103.102,440.625,57.993,-140.346,49.107,13.007,0.053,1.686,2.712,59.859,3.023,219.782,121.754,1.029,4.318
 480.409,103.036,436.621,54.733,-135.112,52.711,13.023,0.050,1.601,2.356,64.864,3.144,227.621,127.294,1.109,4.497
 480.909,103.171,433.643,50.433,-132.517,56.200,13.030,0.052,1.617,2.215,63.893,3.209,233.370,131.357,1.170,4.209
 481.409,103.101,436.182,48.773,-129.711,54.701,12.467,0.060,1.708,2.403,58.575,3.250,237.754,134.455,1.165,3.837
 481.909,103.161,447.852,48.061,-129.983,48.483,11.732,0.059,1.758,2.719,55.656,3.244,239.004,135.339,1.093,3.356
 482.409,103.135,444.336,46.297,-132.130,40.833,12.276,0.041,1.705,2.910,58.745,3.136,237.130,134.014,1.026,3.312
 482.909,103.045,444.336,41.952,-135.436,33.117,12.993,0.023,1.603,2.872,64.732,2.927,233.745,131.622,0.983,3.297
 483.409,103.080,434.570,37.767,-138.440,27.386,13.031,0.025,1.518,2.686,69.717,2.701,223.438,124.338,0.969,3.386
 483.909,103.163,434.570,35.133,-138.864,26.884,13.022,0.036,1.454,2.451,73.455,2.542,205.621,111.746,0.989,3.595
 484.409,103.048,439.258,33.153,-140.606,32.938,12.950,0.037,1.390,2.248,77.182,2.515,183.264,95.946,1.017,3.631
 484.909,103.079,444.336,31.298,-143.059,40.984,12.947,0.025,1.317,2.103,81.473,2.575,160.536,79.884,1.057,3.575
 485.409,103.091,439.453,29.144,-146.229,48.650,13.024,0.009,1.244,1.883,85.713,2.665,149.982,72.425,1.078,3.160
 485.909,103.066,439.697,29.379,-146.162,53.479,12.894,-0.001,1.199,1.701,88.354,2.731,148.987,71.722,1.065,2.773
 486.409,103.094,433.203,30.869,-146.114,55.414,12.891,-0.005,1.189,1.673,88.970,2.797,144.330,68.431,1.036,2.640
 486.909,103.247,434.570,32.230,-147.453,54.966,13.037,-0.007,1.187,1.668,89.082,2.886,132.916,60.365,0.997,2.676
 487.409,103.125,443.652,33.223,-147.642,50.903,13.043,-0.007,1.190,1.686,88.911,2.972,118.462,50.150,1.014,3.082
 487.909,103.178,439.453,33.439,-147.879,46.853,13.043,-0.001,1.210,1.719,87.721,2.962,105.787,41.192,1.078,3.928
 488.409,103.160,432.910,38.769,-147.701,44.860,13.042,0.025,1.285,1.795,83.327,2.809,99.137,36.493,1.219,5.404
 488.909,103.044,439.453,48.882,-146.915,47.813,13.042,0.072,1.451,1.912,73.620,2.654,93.575,32.562,1.456,8.973
 489.409,103.153,439.453,57.853,-146.322,52.362,13.043,0.113,1.736,2.191,56.965,2.794,87.896,28.549,1.824,20.504
 489.909,103.234,434.570,56.218,-146.118,48.285,13.045,0.117,2.079,2.819,36.898,3.676,84.193,25.931,2.375,999999.999
 490.409,103.044,434.570,41.249,-146.003,34.472,13.046,0.091,2.390,3.680,18.735,5.361,81.515,24.039,3.215,999999.999
 490.909,103.207,444.336,25.607,-145.570,17.567,13.044,0.069,2.569,4.467,8.246,7.184,85.088,26.564,3.849,999999.999
 491.409,103.061,440.381,19.910,-144.717,6.082,13.043,0.080,2.603,4.797,6.244,8.170,97.927,35.638,3.524,999999.999
 491.909,103.193,442.773,27.470,-144.409,3.545,13.040,0.112,2.531,4.558,10.463,7.745,113.324,46.519,2.409,18.139
 492.409,103.283,436.621,44.013,-144.352,7.628,12.579,0.128,2.361,4.054,20.427,6.557,126.311,55.697,1.505,5.018
 492.909,103.223,439.453,64.146,-145.115,19.199,11.945,0.107,2.060,3.367,37.987,5.522,133.964,61.105,1.012,2.727
 493.409,103.115,435.010,78.807,-145.425,36.979,12.423,0.064,1.705,2.656,58.753,5.034,139.667,65.136,0.741,1.786
 493.909,103.204,449.219,79.549,-145.296,56.273,13.028,0.022,1.403,2.135,76.417,4.863,147.851,70.919,0.607,1.352
 494.409,103.065,449.219,73.243,-144.591,70.361,13.035,-0.001,1.232,1.805,86.461,4.595,156.052,76.715,0.536,1.135
 494.909,103.134,441.797,65.844,-143.214,75.097,13.034,-0.004,1.202,1.691,88.160,4.103,157.504,77.741,0.523,1.065
 495.409,103.017,444.287,64.119,-142.062,76.010,13.034,0.004,1.263,1.674,84.636,3.482,151.157,73.256,0.542,1.088
 495.909,103.214,439.453,72.062,-141.983,76.024,13.034,0.023,1.471,1.840,72.470,2.957,138.610,64.388,0.603,1.196
 496.409,103.106,440.186,79.692,-143.691,72.714,13.033,0.039,1.783,2.239,54.214,2.798,127.150,56.290,0.687,1.376
 496.909,103.050,448.438,86.739,-144.968,62.274,12.950,0.048,2.099,2.894,35.727,3.188,120.577,51.645,0.806,1.687
 497.409,103.161,444.336,90.099,-146.399,48.968,10.891,0.053,2.267,3.476,25.891,3.824,116.302,48.624,0.932,2.229
 497.909,103.225,441.260,84.392,-146.163,39.867,8.097,0.058,2.185,3.591,30.687,4.389,112.237,45.751,1.093,3.346
 498.409,103.042,449.219,72.514,-146.293,37.579,7.884,0.062,1.964,3.228,43.641,4.676,107.946,42.718,1.287,6.438
 498.909,103.258,445.947,55.350,-145.999,38.058,9.965,0.052,1.760,2.714,55.563,4.750,104.317,40.154,1.491,17.068
 499.409,103.027,450.195,40.274,-145.492,35.971,12.237,0.033,1.668,2.641,60.943,4.703,101.903,38.447,1.721,45955.285
 499.909,103.221,454.102,33.129,-144.606,29.870,12.973,0.018,1.673,2.824,60.616,4.519,101.531,38.184,1.927,74208.234
 500.409,103.163,441.895,31.553,-144.185,22.430,12.923,0.008,1.683,2.960,60.049,4.299,100.338,37.341,2.141,57.106
 500.909,103.249,449.219,31.649,-144.782,16.317,11.519,0.011,1.689,2.915,59.679,4.108,97.257,35.164,2.323,19.208
 501.409,103.277,445.752,30.519,-145.966,11.801,9.706,0.018,1.725,2.806,57.609,4.025,94.559,33.257,2.306,9.893
 501.909,103.226,433.203,28.332,-147.412,9.068,8.742,0.017,1.778,2.976,54.523,4.060,93.428,32.458,2.144,9.303
 502.409,103.059,436.328,27.571,-148.665,8.556,8.867,0.011,1.776,3.138,54.616,4.126,94.583,33.275,1.980,16.500
 502.909,103.188,517.188,28.355,-149.051,11.060,10.926,0.002,1.683,3.045,60.069,4.157,95.861,34.177,1.902,171.998
 503.409,103.135,493.066,29.593,-149.258,18.117,12.601,0.002,1.554,2.660,67.617,4.084,96.422,34.574,1.932,999999.999
 503.909,103.248,452.783,31.497,-148.730,28.054,12.965,0.006,1.482,2.261,71.830,3.938,98.265,35.876,1.846,32.483
 504.409,103.228,449.219,32.680,-148.289,35.049,12.503,0.006,1.530,2.284,68.984,3.814,101.982,38.503,1.576,5.322
 504.909,103.219,449.219,33.634,-148.093,35.584,10.628,0.004,1.623,2.624,63.575,3.737,107.933,42.709,1.247,3.039
 505.409,103.227,441.553,36.744,-148.716,31.450,9.493,0.006,1.639,2.768,62.631,3.719,118.283,50.023,1.026,2.459
 505.909,103.138,458.643,43.164,-149.272,30.486,9.640,0.009,1.554,2.517,67.630,3.745,131.115,59.092,0.920,2.382
 506.409,103.220,448.096,55.108,-147.038,39.991,10.990,0.012,1.451,2.104,73.615,3.753,143.772,68.037,0.906,2.465
 506.909,103.173,468.164,69.797,-145.990,52.107,12.686,0.015,1.445,1.874,73.954,3.669,149.548,72.119,0.931,2.514
 507.409,103.041,461.816,83.750,-144.577,57.538,12.983,0.019,1.586,1.993,65.718,3.448,141.978,66.769,0.963,2.531
 507.909,103.222,458.984,91.239,-145.447,55.472,11.447,0.027,1.753,2.271,55.984,3.202,126.411,55.767,0.978,2.542
 508.409,103.146,480.518,84.884,-145.669,47.831,8.724,0.032,1.794,2.409,53.583,3.057,108.500,43.109,0.987,2.733
 508.909,103.120,488.281,68.107,-146.196,39.901,8.673,0.034,1.696,2.390,59.285,3.045,94.439,33.172,1.031,3.181
 509.409,103.214,455.078,49.601,-146.853,32.205,11.251,0.031,1.524,2.187,69.353,3.133,85.690,26.990,1.100,3.966
 509.909,103.205,451.172,37.261,-143.837,26.284,12.851,0.020,1.383,1.944,77.584,3.229,79.481,22.602,1.182,5.028
 510.409,103.251,439.453,33.053,-144.258,24.537,13.030,0.009,1.321,1.762,81.240,3.264,75.615,19.869,1.223,5.882
 510.909,103.224,440.674,32.825,-144.767,26.022,13.029,0.000,1.331,1.686,80.655,3.202,76.037,20.168,1.196,5.804
 511.409,103.200,444.336,33.613,-145.160,29.346,12.917,-0.005,1.393,1.792,77.023,3.128,81.120,23.760,1.146,5.194
 511.909,103.266,457.031,35.032,-144.466,33.244,11.224,-0.006,1.451,1.954,73.597,3.120,87.806,28.484,1.096,4.561
 512.409,103.099,455.859,34.977,-144.082,36.835,10.628,-0.005,1.453,2.028,73.526,3.179,90.627,30.479,1.069,4.033
 512.909,103.353,455.811,34.791,-146.259,38.930,12.312,-0.005,1.392,1.929,77.088,3.265,87.030,27.936,1.058,3.858
 513.409,103.312,454.736,34.289,-147.974,39.443,12.980,-0.005,1.315,1.785,81.571,3.310,81.117,23.757,1.056,3.830
 513.909,103.241,459.814,33.180,-148.477,39.757,13.014,-0.006,1.266,1.688,84.462,3.300,77.127,20.938,1.050,3.916
 514.409,103.292,491.211,30.998,-148.367,41.541,13.027,-0.008,1.247,1.650,85.571,3.268,75.068,19.483,1.046,3.861
 514.909,103.317,444.336,26.980,-149.151,44.786,13.026,-0.008,1.251,1.666,85.335,3.307,73.830,18.608,1.032,3.572
 515.409,103.158,444.336,25.961,-147.121,46.981,13.008,-0.007,1.259,1.678,84.848,3.451,72.893,17.946,1.003,3.298
 515.909,103.230,454.102,28.069,-146.224,48.890,13.011,-0.004,1.267,1.691,84.364,3.628,73.270,18.212,0.962,3.170
 516.409,103.260,449.268,30.775,-145.672,50.032,13.020,0.001,1.279,1.695,83.676,3.736,76.319,20.367,0.937,3.326
 516.909,103.218,454.102,31.424,-146.489,48.450,12.100,0.007,1.298,1.728,82.571,3.715,81.958,24.352,0.948,3.956
 517.409,103.130,454.395,32.159,-147.036,45.767,11.964,0.011,1.318,1.750,81.420,3.622,87.204,28.060,1.016,4.908
 517.909,103.111,453.223,34.376,-147.157,41.555,12.494,0.008,1.362,1.730,78.803,3.448,91.777,31.291,1.123,5.910
 518.409,103.242,449.219,36.185,-147.460,37.356,12.662,0.002,1.469,1.912,72.599,3.270,94.026,32.881,1.221,5.717
 518.909,103.081,443.066,37.213,-146.079,32.558,11.992,-0.000,1.605,2.345,64.592,3.148,93.035,32.180,1.239,5.177
 519.409,103.356,444.336,36.963,-146.874,26.738,9.313,0.002,1.659,2.617,61.481,3.102,89.756,29.863,1.187,4.804
 519.909,103.219,447.656,34.213,-148.208,23.632,8.741,0.004,1.560,2.502,67.237,3.149,83.618,25.525,1.139,5.264
 520.409,103.150,454.102,30.825,-150.777,25.425,11.074,0.002,1.386,2.086,77.419,3.212,79.537,22.641,1.113,6.326
 520.909,103.295,454.102,28.705,-152.843,31.316,12.717,-0.004,1.254,1.741,85.159,3.273,79.401,22.545,1.122,6.788
 521.409,103.245,447.998,28.688,-153.202,37.392,13.033,-0.008,1.211,1.644,87.660,3.294,80.735,23.488,1.099,5.781
 521.909,103.175,444.336,30.102,-154.041,41.450,13.033,-0.009,1.222,1.629,87.010,3.234,83.593,25.507,1.024,3.813
 522.409,103.201,448.242,31.969,-155.077,43.505,13.030,-0.006,1.257,1.699,84.987,3.119,87.113,27.995,0.897,2.657
 522.909,103.288,450.781,33.593,-155.758,42.865,12.904,-0.000,1.296,1.819,82.710,2.996,91.705,31.240,0.777,2.040
 523.409,103.376,452.393,32.034,-155.841,39.885,12.790,0.004,1.313,1.942,81.690,2.921,95.511,33.930,0.690,1.806
 523.909,103.274,474.707,28.347,-155.683,36.185,12.922,0.006,1.300,1.974,82.448,2.896,96.512,34.637,0.653,1.858
 524.409,103.242,460.938,25.303,-155.331,34.688,13.035,0.004,1.273,1.904,84.062,2.826,95.445,33.883,0.671,2.237
 524.909,103.214,475.000,25.686,-155.317,36.620,13.037,0.012,1.279,1.842,83.694,2.653,93.979,32.847,0.742,2.912
 525.409,103.182,468.750,29.251,-155.492,37.155,13.037,0.042,1.385,1.903,77.483,2.440,92.345,31.692,0.883,3.511
 525.909,103.171,445.068,34.261,-155.683,33.531,13.037,0.082,1.602,2.171,64.805,2.386,90.193,30.172,1.027,3.244
 526.409,103.297,458.984,44.764,-155.743,27.595,12.677,0.105,1.901,2.545,47.313,2.744,90.198,30.175,1.059,2.478
 526.909,103.218,463.574,55.517,-156.163,24.060,11.001,0.098,2.163,2.948,32.011,3.339,95.159,33.681,0.992,2.071
 527.409,103.255,449.219,60.422,-157.321,27.550,9.357,0.074,2.231,3.138,27.999,3.792,104.774,40.477,0.891,2.133
 527.909,103.145,448.877,59.131,-158.528,36.181,9.756,0.055,2.083,2.969,36.638,3.906,114.513,47.359,0.853,2.760
 528.409,103.306,447.217,54.723,-159.158,46.593,11.644,0.047,1.802,2.532,53.128,3.652,120.216,51.389,0.893,4.569
 528.909,103.250,448.682,53.673,-158.659,54.268,12.898,0.053,1.586,2.131,65.719,3.313,122.077,52.705,0.982,6.400
 529.409,103.177,450.586,56.645,-157.463,55.826,13.039,0.082,1.566,2.046,66.876,3.093,125.503,55.126,1.078,5.555
 529.909,103.245,488.281,65.125,-156.445,53.652,13.039,0.126,1.724,2.169,57.684,3.021,130.533,58.680,1.156,3.919
 530.409,103.198,484.912,72.576,-155.874,52.698,13.039,0.151,1.976,2.373,42.944,3.220,133.957,61.100,1.212,3.046
 530.909,103.233,502.930,73.287,-156.488,51.904,13.038,0.141,2.223,2.601,28.459,3.609,134.035,61.155,1.347,2.995
 531.409,103.364,488.672,71.907,-157.417,47.778,13.036,0.109,2.394,2.834,18.495,4.013,131.116,59.093,1.612,3.476
 531.909,103.291,452.832,69.572,-158.335,40.199,13.032,0.084,2.430,3.001,16.363,4.270,131.938,59.673,1.972,4.934
 532.409,103.354,449.219,70.076,-157.961,34.793,13.029,0.072,2.337,2.900,21.792,4.237,138.172,64.079,2.411,9.643
 532.909,103.388,467.236,72.468,-156.914,38.345,12.472,0.054,2.200,2.676,29.809,4.060,145.367,69.164,2.503,84.559
 533.409,103.148,463.867,73.559,-155.869,46.427,12.219,0.030,2.119,2.584,34.584,3.939,150.118,72.521,2.429,402627.594
 533.909,103.353,491.211,71.620,-154.993,50.330,12.790,0.013,2.106,2.748,35.306,3.917,146.920,70.262,2.158,6170.188
 534.409,103.257,482.813,64.551,-153.905,47.102,13.007,0.009,2.122,2.993,34.365,4.026,135.175,61.961,1.992,15.895
 534.909,103.302,485.352,56.711,-152.634,38.707,12.995,0.023,2.115,3.292,34.815,4.203,118.611,50.255,1.828,9.171
 535.409,103.354,470.117,50.533,-151.758,30.124,12.591,0.045,2.042,3.448,39.042,4.356,103.140,39.322,1.697,6.407
 535.909,103.228,468.750,44.577,-152.024,23.829,12.474,0.062,1.889,3.327,48.032,4.481,92.787,32.005,1.571,5.423
 536.409,103.420,459.277,37.042,-152.240,18.901,12.916,0.068,1.691,3.012,59.578,4.459,87.918,28.564,1.456,4.766
 536.909,103.338,454.102,29.386,-152.766,15.595,12.627,0.059,1.513,2.471,69.983,4.241,86.493,27.557,1.281,4.138
 537.409,103.371,473.633,27.122,-153.398,15.059,11.575,0.047,1.423,2.098,75.253,3.903,86.124,27.296,1.145,3.902
 537.909,103.339,476.318,30.145,-152.409,18.794,11.910,0.037,1.424,2.010,75.184,3.446,87.397,28.196,1.037,3.566
 538.409,103.204,479.199,33.512,-148.596,25.728,12.931,0.030,1.448,2.071,73.792,3.037,89.737,29.849,0.985,3.198
 538.909,103.191,473.877,36.419,-147.905,34.343,13.034,0.021,1.457,2.061,73.273,2.778,94.207,33.009,1.007,3.029
 539.409,103.128,463.867,37.834,-147.233,41.556,12.976,0.013,1.489,2.003,71.422,2.671,101.792,38.369,1.059,2.802
 539.909,103.182,466.992,43.560,-146.473,44.314,12.203,0.012,1.614,2.106,64.087,2.763,112.923,46.236,1.165,2.881
 540.409,103.359,478.516,54.216,-145.823,43.078,11.229,0.017,1.810,2.398,52.655,2.982,124.043,54.094,1.307,3.239
 540.909,103.264,478.516,66.628,-146.116,41.191,11.726,0.030,2.002,2.705,41.382,3.254,131.951,59.683,1.514,4.060
 541.409,103.191,498.047,79.076,-149.651,40.619,12.701,0.050,2.109,2.810,35.163,3.434,135.960,62.516,1.914,6.984
 541.909,103.223,476.367,83.604,-152.952,40.676,12.304,0.074,2.126,2.694,34.178,3.393,137.325,63.481,2.769,20.601
 542.409,103.325,458.984,83.137,-153.126,40.418,11.532,0.087,2.109,2.585,35.169,3.285,139.146,64.768,4.436,999999.999
 542.909,103.362,458.984,80.248,-153.098,38.784,10.315,0.088,2.103,2.600,35.492,3.317,141.314,66.300,6.322,999999.999
 543.409,103.303,452.588,75.970,-151.339,35.822,8.011,0.074,2.116,2.731,34.739,3.563,139.817,65.242,4.911,33.670
 543.909,103.164,449.219,71.678,-146.456,32.084,6.751,0.058,2.118,3.013,34.612,3.996,134.940,61.795,3.174,10.947
 544.409,103.264,477.539,64.730,-146.188,28.300,6.718,0.048,2.038,3.228,39.281,4.542,126.694,55.967,2.228,8.447
 544.909,103.314,463.086,55.894,-147.370,25.965,7.089,0.037,1.843,3.078,50.719,5.079,118.462,50.150,1.858,8.667
 545.409,103.387,456.982,48.316,-149.266,25.685,8.593,0.026,1.615,2.594,64.034,5.470,113.116,46.371,1.801,11.802
 545.909,103.303,458.643,43.069,-149.570,26.497,10.870,0.021,1.482,2.163,71.790,5.569,110.596,44.591,1.790,11.439
 546.409,103.414,454.590,41.277,-148.948,27.687,11.267,0.026,1.506,2.107,70.437,5.376,108.934,43.416,1.708,7.951
 546.909,103.372,458.789,42.021,-146.912,28.352,9.524,0.033,1.586,2.306,65.757,5.078,104.425,40.230,1.563,5.713
 547.409,103.369,454.102,40.796,-145.114,27.315,8.611,0.032,1.620,2.452,63.770,4.728,96.766,34.817,1.426,4.445
 547.909,103.234,464.014,38.011,-145.391,25.687,8.788,0.029,1.607,2.464,64.507,4.424,90.223,30.193,1.372,4.260
 548.409,103.310,468.750,35.580,-149.193,25.226,8.821,0.036,1.576,2.428,66.323,4.241,89.478,29.667,1.388,4.410
 548.909,103.234,442.529,33.908,-154.197,26.923,9.573,0.047,1.526,2.299,69.247,4.155,90.875,30.654,1.389,4.680
 549.409,103.348,471.680,33.461,-155.836,30.797,11.703,0.046,1.444,2.100,74.006,4.048,89.538,29.709,1.342,5.082
 549.909,103.203,465.625,32.747,-155.404,34.605,12.679,0.033,1.357,1.940,79.123,3.754,83.949,25.759,1.258,5.207
 550.409,103.461,488.037,29.976,-155.274,36.963,12.735,0.017,1.294,1.861,82.824,3.290,76.480,20.481,1.180,5.123
 550.909,103.250,487.354,29.165,-154.968,37.768,13.035,0.006,1.256,1.818,85.005,2.890,72.351,17.562,1.151,4.767
 551.409,103.328,475.830,30.569,-154.360,38.267,13.042,-0.001,1.232,1.752,86.443,2.726,72.413,17.607,1.137,4.411
 551.909,103.342,468.750,33.927,-153.647,39.547,13.042,0.000,1.241,1.703,85.906,2.773,73.492,18.369,1.130,4.211
 552.409,103.354,497.656,37.029,-153.647,40.704,13.042,0.011,1.297,1.794,82.614,2.853,74.355,18.979,1.097,4.206
 552.909,103.217,481.689,36.917,-153.682,40.414,12.542,0.021,1.353,1.912,79.358,2.792,74.004,18.731,1.059,4.218
 553.409,103.275,463.867,35.472,-154.572,39.245,10.947,0.021,1.358,1.944,79.064,2.626,73.555,18.413,1.029,4.379
 553.909,103.297,462.354,32.422,-155.946,39.778,11.099,0.012,1.308,1.869,82.002,2.496,73.450,18.339,1.009,4.527
 554.409,103.462,458.984,29.685,-157.041,43.217,12.676,-0.001,1.241,1.734,85.888,2.445,73.058,18.062,0.994,4.606
 554.909,103.211,455.859,28.995,-157.631,48.776,13.033,-0.007,1.208,1.686,87.849,2.427,74.200,18.869,0.972,4.463
 555.409,103.394,476.367,29.145,-157.076,55.052,13.032,-0.008,1.205,1.680,88.025,2.392,76.051,20.177,0.937,3.967
 555.909,103.332,470.508,28.035,-156.075,59.681,13.027,-0.007,1.209,1.689,87.773,2.400,78.188,21.688,0.895,3.360
 556.409,103.275,468.066,26.392,-155.444,63.018,12.982,-0.008,1.210,1.681,87.738,2.498,79.562,22.659,0.847,2.762
 556.909,103.397,468.750,25.017,-155.923,68.611,12.970,-0.010,1.202,1.639,88.171,2.666,82.990,25.081,0.797,2.323
 557.409,103.408,463.965,25.106,-157.233,75.929,13.020,-0.013,1.191,1.584,88.837,2.808,90.494,30.384,0.751,2.067
 557.909,103.361,458.984,28.374,-158.347,81.930,13.036,-0.014,1.185,1.546,89.172,2.854,95.975,34.258,0.726,1.985
 558.409,103.517,449.365,31.383,-159.030,86.089,13.036,-0.014,1.187,1.537,89.040,2.815,96.323,34.504,0.727,2.040
 558.909,103.282,454.102,30.454,-158.870,86.506,13.036,-0.009,1.201,1.558,88.273,2.694,90.263,30.221,0.770,2.238
 559.409,103.467,489.063,28.503,-158.257,81.489,13.036,0.001,1.241,1.614,85.883,2.552,84.730,26.311,0.853,2.641
 559.909,103.433,495.117,29.477,-157.244,69.168,13.036,0.027,1.363,1.752,78.784,2.472,84.304,26.010,0.990,3.468
 560.409,103.307,489.355,37.422,-156.224,52.725,13.035,0.069,1.568,1.993,66.759,2.506,86.904,27.848,1.191,5.253
 560.909,103.295,463.867,50.150,-155.654,39.868,13.033,0.114,1.802,2.240,53.087,2.632,91.619,31.180,1.487,8.179
 561.409,103.304,462.207,60.327,-155.156,36.070,13.032,0.147,1.982,2.427,42.578,2.762,96.625,34.717,1.877,10.042
 561.909,103.409,450.684,65.599,-155.310,40.522,13.034,0.160,2.083,2.511,36.641,2.851,102.855,39.120,2.154,7.902
 562.409,103.359,468.750,67.433,-155.750,47.002,13.034,0.158,2.149,2.580,32.811,2.900,108.977,43.447,2.033,5.240
 562.909,103.258,465.088,71.225,-156.487,51.017,13.023,0.153,2.199,2.712,29.858,2.905,114.621,47.435,1.628,4.013
 563.409,103.401,468.750,76.324,-157.196,50.306,12.781,0.149,2.177,2.778,31.145,2.834,120.852,51.839,1.262,3.327
 563.909,103.204,461.035,80.260,-157.134,48.278,12.788,0.136,2.029,2.662,39.839,2.704,127.828,56.769,1.051,3.002
 564.409,103.481,462.500,82.292,-156.610,51.399,12.985,0.118,1.835,2.364,51.168,2.561,133.948,61.094,0.964,2.793
 564.909,103.306,449.219,84.554,-155.690,59.529,12.966,0.109,1.719,2.180,57.981,2.451,136.306,62.761,0.951,2.516
 565.409,103.437,472.363,89.589,-155.261,67.985,13.007,0.124,1.738,2.183,56.843,2.384,129.821,58.177,1.004,2.365
 565.909,103.372,478.516,91.390,-154.938,71.769,13.026,0.152,1.874,2.297,48.893,2.423,114.767,47.539,1.104,2.350
 566.409,103.476,463.867,87.691,-152.532,66.497,13.028,0.152,2.078,2.607,36.974,3.001,95.213,33.720,1.294,2.585
 566.909,103.288,482.227,73.249,-149.074,53.187,13.023,0.123,2.312,3.242,23.303,4.355,76.144,20.243,1.616,3.101
 567.409,103.385,474.414,52.167,-147.751,34.952,13.008,0.086,2.505,4.185,11.975,6.346,68.644,14.943,2.163,3.833
 567.909,103.399,488.037,34.609,-145.319,17.369,12.962,0.065,2.578,5.071,7.731,8.333,75.211,19.584,2.828,5.251
 568.409,103.419,483.301,30.448,-143.131,8.916,12.187,0.079,2.449,5.048,15.269,9.318,91.778,31.292,3.392,10.231
 568.909,103.364,468.457,41.873,-141.786,11.527,10.075,0.096,2.216,4.247,28.864,9.415,106.581,41.754,3.561,600058.688
 569.409,103.449,458.984,62.453,-141.091,23.055,9.030,0.096,1.996,3.345,41.753,8.937,109.341,43.704,3.458,999999.999
 569.909,103.499,496.094,75.368,-139.630,34.792,8.540,0.084,1.834,2.752,51.220,8.293,103.492,39.570,3.250,999999.999
 570.409,103.399,473.633,71.503,-136.660,39.558,7.977,0.067,1.720,2.539,57.894,7.669,94.027,32.882,2.879,999999.999
 570.909,103.315,459.619,55.524,-137.380,35.275,9.673,0.052,1.616,2.411,63.955,6.991,87.970,28.601,2.468,21.632
 571.409,103.431,457.520,39.579,-142.227,25.070,10.553,0.037,1.522,2.235,69.472,6.275,87.207,28.062,2.186,13.661
 571.909,103.241,457.617,32.352,-149.129,15.726,8.642,0.020,1.461,2.134,73.055,5.600,90.032,30.058,2.009,13.483
 572.409,103.435,477.051,29.667,-150.833,11.031,7.411,0.012,1.418,2.090,75.574,4.963,94.214,33.013,1.941,13.013
 572.909,103.318,483.398,29.530,-151.720,11.486,7.636,0.010,1.376,1.951,77.997,4.390,99.965,37.078,1.778,9.111
 573.409,103.364,498.047,31.331,-152.548,15.593,9.159,0.004,1.365,1.849,78.651,3.957,109.466,43.792,1.528,5.445
 573.909,103.426,458.984,37.053,-152.528,21.604,11.506,-0.002,1.386,1.927,77.402,3.665,122.551,53.039,1.254,3.628
 574.409,103.469,482.422,46.192,-153.182,30.132,11.452,-0.004,1.391,1.968,77.145,3.495,137.134,63.346,1.048,2.769
 574.909,103.445,526.563,54.781,-153.927,43.216,10.775,-0.002,1.367,1.874,78.528,3.379,147.374,70.582,0.929,2.376
 575.409,103.489,483.398,62.051,-153.698,57.884,11.932,-0.000,1.385,1.749,77.483,3.257,151.648,73.603,0.867,2.152
 575.909,103.443,488.281,69.078,-152.765,66.805,11.382,0.003,1.504,1.837,70.527,3.132,148.360,71.279,0.851,2.057
 576.409,103.428,488.281,75.369,-151.884,67.701,8.606,0.015,1.669,2.177,60.869,3.035,139.262,64.849,0.862,2.119
 576.909,103.337,488.281,76.102,-150.603,61.550,7.724,0.029,1.718,2.373,58.029,3.001,126.666,55.948,0.908,2.370
 577.409,103.470,506.641,69.837,-149.063,54.246,9.733,0.033,1.615,2.280,64.056,3.021,116.480,48.749,0.985,2.882
 577.909,103.440,510.107,59.845,-149.070,48.492,11.935,0.028,1.461,2.009,73.014,3.110,113.083,46.348,1.089,3.521
 578.409,103.452,483.691,53.879,-149.441,43.285,12.300,0.024,1.377,1.888,77.929,3.261,114.478,47.335,1.188,4.302
 578.909,103.416,485.889,52.802,-150.677,41.741,10.556,0.030,1.380,1.959,77.789,3.462,116.494,48.759,1.243,5.109
 579.409,103.280,483.008,53.988,-151.647,45.496,9.661,0.033,1.376,2.003,78.036,3.627,118.276,50.018,1.254,5.901
 579.909,103.408,473.633,53.307,-153.761,52.027,11.391,0.023,1.328,1.941,80.803,3.673,120.255,51.417,1.253,6.132
 580.409,103.389,487.842,49.966,-156.334,59.212,12.679,0.008,1.272,1.814,84.081,3.628,124.361,54.318,1.240,5.480
 580.909,103.514,483.398,46.201,-158.588,65.116,12.864,-0.001,1.240,1.749,85.955,3.517,130.350,58.551,1.222,4.776
 581.409,103.406,501.660,40.649,-158.844,66.247,13.021,-0.004,1.224,1.705,86.886,3.383,131.022,59.026,1.193,4.451
 581.909,103.438,483.496,37.007,-158.336,62.452,13.034,-0.006,1.216,1.671,87.387,3.237,123.296,53.566,1.185,4.755
 582.409,103.507,476.758,36.162,-158.382,55.540,12.969,-0.004,1.223,1.667,86.953,3.084,111.696,45.368,1.224,5.498
 582.909,103.418,468.750,36.519,-158.334,48.082,12.226,0.003,1.261,1.704,84.728,2.956,100.567,37.503,1.313,6.076
 583.409,103.545,469.873,37.176,-158.496,42.802,11.904,0.017,1.331,1.779,80.620,2.909,94.122,32.949,1.416,6.282
 583.909,103.566,469.971,41.574,-159.137,37.817,12.283,0.027,1.413,1.866,75.855,3.007,90.992,30.736,1.456,6.051
 584.409,103.341,468.750,48.186,-159.096,33.435,11.645,0.028,1.470,1.982,72.493,3.278,90.879,30.657,1.433,6.346
 584.909,103.470,472.656,54.099,-158.795,31.204,10.210,0.022,1.470,2.034,72.491,3.656,96.402,34.560,1.396,7.453
 585.409,103.490,468.750,53.206,-158.410,30.801,9.920,0.014,1.412,1.986,75.903,3.991,100.955,37.777,1.386,9.619
 585.909,103.360,489.502,45.321,-157.953,31.874,11.451,0.011,1.350,1.886,79.508,4.126,99.842,36.991,1.406,10.778
 586.409,103.354,492.090,38.920,-157.330,32.924,12.605,0.019,1.345,1.874,79.821,4.007,92.350,31.696,1.387,8.875
 586.909,103.359,473.633,38.133,-156.493,32.678,12.294,0.038,1.400,2.011,76.609,3.794,84.380,26.064,1.320,6.490
 587.409,103.400,467.969,42.104,-155.258,32.694,10.659,0.053,1.445,2.128,74.004,3.714,80.879,23.589,1.212,5.306
 587.909,103.460,473.633,41.549,-153.924,36.118,9.283,0.049,1.418,2.095,75.565,3.842,79.752,22.793,1.118,4.752
 588.409,103.416,476.514,35.727,-154.269,43.922,10.566,0.026,1.327,1.923,80.876,4.049,78.631,22.001,1.062,4.559
 588.909,103.543,473.584,29.190,-155.561,50.211,12.476,0.003,1.237,1.769,86.138,4.090,75.888,20.062,1.025,4.227
 589.409,103.504,471.094,27.772,-157.612,50.497,12.973,-0.007,1.194,1.713,88.670,3.841,72.159,17.427,0.997,3.922
 589.909,103.429,473.047,31.251,-159.109,47.643,13.001,-0.008,1.183,1.712,89.282,3.458,69.512,15.556,0.958,3.623
 590.409,103.527,458.984,33.311,-159.229,48.795,13.019,-0.007,1.184,1.730,89.257,3.134,68.891,15.117,0.920,3.447
 590.909,103.562,462.988,34.372,-158.581,58.283,13.024,-0.006,1.186,1.754,89.136,2.983,69.241,15.365,0.888,3.360
 591.409,103.380,454.102,32.958,-157.482,71.285,13.031,-0.005,1.189,1.787,88.952,3.039,72.256,17.496,0.864,3.252
 591.909,103.482,461.035,30.961,-156.741,79.979,13.034,-0.005,1.190,1.826,88.871,3.239,77.535,21.226,0.844,3.178
 592.409,103.391,473.633,28.679,-156.477,81.982,13.034,-0.005,1.190,1.837,88.910,3.481,82.575,24.788,0.820,3.090
 592.909,103.588,470.850,26.558,-156.534,79.646,13.034,-0.006,1.188,1.823,89.017,3.634,84.300,26.007,0.793,2.995
 593.409,103.397,465.918,26.569,-156.278,77.788,13.034,-0.007,1.187,1.802,89.049,3.627,81.323,23.903,0.767,2.872
 593.909,103.563,466.504,28.173,-156.133,79.291,13.034,-0.006,1.190,1.779,88.884,3.473,76.244,20.314,0.743,2.642
 594.409,103.582,466.406,31.029,-156.174,81.899,13.034,-0.006,1.194,1.764,88.665,3.248,74.643,19.182,0.718,2.341
 594.909,103.500,463.867,32.606,-156.648,82.077,13.034,-0.005,1.199,1.756,88.361,3.037,82.317,24.605,0.686,2.020
 595.409,103.424,475.732,32.932,-157.278,77.033,13.034,-0.004,1.206,1.767,87.929,2.865,97.875,35.601,0.642,1.754
 595.909,103.513,493.164,33.026,-157.677,70.369,13.034,-0.003,1.213,1.782,87.571,2.747,112.717,46.090,0.601,1.613
 596.409,103.507,468.262,32.138,-157.567,70.628,13.033,-0.002,1.214,1.787,87.472,2.651,120.786,51.792,0.569,1.590
 596.909,103.618,471.094,30.936,-157.747,76.383,13.032,-0.003,1.211,1.772,87.668,2.542,120.634,51.685,0.562,1.694
 597.409,103.411,458.984,30.888,-158.257,81.382,13.030,-0.003,1.212,1.748,87.609,2.398,119.582,50.942,0.575,1.859
 597.909,103.463,465.283,33.442,-158.722,85.466,13.026,0.007,1.240,1.776,85.941,2.211,120.060,51.279,0.606,1.952
 598.409,103.378,473.633,38.461,-157.085,87.536,12.976,0.024,1.297,1.831,82.623,2.046,117.949,49.787,0.635,1.940
 598.909,103.559,473.633,43.453,-157.136,83.427,11.981,0.047,1.409,1.952,76.068,2.022,113.964,46.971,0.651,1.884
 599.409,103.595,473.633,48.292,-157.062,70.162,11.184,0.069,1.549,2.191,67.869,2.199,108.560,43.152,0.659,1.956
 599.909,103.481,476.172,54.124,-156.431,52.534,9.688,0.070,1.601,2.304,64.843,2.522,104.165,40.046,0.669,2.215
 600.409,103.479,488.281,54.740,-156.368,47.900,8.436,0.051,1.539,2.272,68.471,2.821,99.654,36.858,0.695,2.653
 600.909,103.609,488.281,49.614,-157.666,63.702,10.286,0.022,1.388,2.044,77.284,2.989,90.851,30.637,0.737,3.106
 601.409,103.466,502.930,43.074,-159.965,82.557,12.345,-0.003,1.255,1.789,85.083,3.035,81.229,23.837,0.782,3.234
 601.909,103.618,502.930,38.899,-162.193,94.081,12.983,-0.011,1.204,1.698,88.049,3.023,72.630,17.760,0.819,3.130
 602.409,103.434,498.047,39.740,-161.008,94.646,13.013,-0.011,1.193,1.625,88.717,2.982,67.548,14.168,0.848,2.933
 602.909,103.690,498.047,38.598,-159.821,88.072,13.004,-0.012,1.188,1.591,88.979,2.913,67.124,13.868,0.870,2.917
 603.409,103.685,505.273,34.407,-158.331,83.525,12.996,-0.012,1.189,1.593,88.961,2.853,68.698,14.981,0.903,3.114
 603.909,103.561,477.100,30.709,-155.287,80.620,13.009,-0.011,1.197,1.615,88.479,2.820,71.363,16.864,0.944,3.597
 604.409,103.468,485.547,32.737,-154.095,80.599,12.972,-0.008,1.210,1.653,87.745,2.835,72.430,17.618,1.014,4.612
 604.909,103.594,496.680,40.659,-153.759,84.643,12.656,-0.006,1.220,1.679,87.151,2.871,71.442,16.920,1.108,6.429
 605.409,103.502,512.695,48.334,-156.461,90.142,12.642,-0.003,1.225,1.701,86.841,2.857,72.253,17.494,1.222,8.341
 605.909,103.541,512.695,53.355,-156.596,90.267,12.968,0.008,1.245,1.760,85.684,2.789,77.995,21.551,1.315,8.666
 606.409,103.693,473.633,54.778,-156.638,83.201,12.048,0.032,1.297,1.857,82.621,2.742,86.923,27.861,1.360,7.696
 606.909,103.665,486.230,56.163,-156.768,72.428,9.918,0.053,1.348,1.961,79.659,2.784,94.277,33.058,1.341,7.230
 607.409,103.627,501.074,56.399,-155.802,66.194,9.112,0.050,1.343,1.959,79.932,2.908,96.574,34.681,1.296,7.395
 607.909,103.620,498.047,53.335,-155.641,69.334,9.953,0.026,1.287,1.843,83.218,3.027,95.235,33.735,1.246,7.822
 608.409,103.598,495.996,48.888,-154.977,77.273,11.634,0.001,1.220,1.702,87.146,3.074,91.713,31.246,1.182,6.723
 608.909,103.672,512.695,43.497,-154.515,84.110,12.885,-0.012,1.183,1.617,89.295,3.071,86.909,27.851,1.091,5.075
 609.409,103.666,499.609,37.851,-153.778,86.726,12.402,-0.013,1.177,1.616,89.664,3.019,80.878,23.589,0.983,3.702
 609.909,103.519,488.281,33.807,-154.655,88.449,12.170,-0.013,1.175,1.637,89.747,2.920,75.942,20.100,0.880,2.776
 610.409,103.684,490.869,31.907,-155.485,88.826,12.818,-0.012,1.175,1.662,89.742,2.767,74.076,18.781,0.806,2.269
 610.909,103.653,493.164,31.164,-157.826,86.609,13.031,-0.011,1.176,1.685,89.714,2.592,75.461,19.760,0.755,1.960
 611.409,103.623,484.814,32.386,-158.121,90.582,13.031,-0.011,1.175,1.710,89.756,2.490,81.797,24.238,0.728,1.822
 611.909,103.589,509.766,33.227,-159.464,107.637,13.029,-0.012,1.173,1.710,89.909,2.503,87.784,28.469,0.715,1.806
 612.409,103.541,483.398,32.320,-159.678,132.792,13.027,-0.013,1.170,1.693,90.041,2.580,86.815,27.784,0.716,1.876
 612.909,103.619,486.816,31.138,-159.298,145.271,13.024,-0.012,1.171,1.670,90.000,2.590,79.212,22.411,0.726,2.007
 613.409,103.673,478.516,28.475,-158.335,130.878,13.019,-0.010,1.180,1.659,89.477,2.455,69.177,15.319,0.748,2.193
 613.909,103.712,473.633,26.927,-157.323,103.429,12.968,-0.005,1.199,1.665,88.391,2.300,63.322,11.181,0.779,2.503
 614.409,103.707,477.148,26.588,-157.023,77.853,12.370,-0.003,1.216,1.680,87.379,2.264,64.174,11.784,0.818,2.991
 614.909,103.684,478.516,27.170,-157.605,62.864,11.986,-0.003,1.223,1.721,86.970,2.336,67.267,13.970,0.859,3.566
 615.409,103.835,497.314,29.338,-159.182,57.635,12.587,-0.003,1.223,1.748,86.986,2.413,69.083,15.253,0.891,3.874
 615.909,103.722,483.398,30.645,-160.800,57.528,12.905,0.002,1.233,1.751,86.378,2.439,68.728,15.002,0.894,3.700
 616.409,103.728,491.309,30.896,-161.372,61.158,11.922,0.014,1.258,1.759,84.892,2.472,70.333,16.136,0.880,3.437
 616.909,103.722,502.930,30.490,-161.098,66.018,11.468,0.019,1.271,1.752,84.149,2.570,77.716,21.354,0.857,3.316
 617.409,103.770,490.332,32.613,-160.606,72.761,12.496,0.014,1.257,1.745,84.971,2.679,89.452,29.648,0.853,3.363
 617.909,103.713,504.004,36.133,-160.330,82.103,13.019,0.002,1.228,1.750,86.688,2.682,99.315,36.618,0.869,3.526
 618.409,103.824,498.047,39.118,-160.630,88.224,13.020,-0.004,1.209,1.738,87.774,2.560,104.802,40.496,0.900,3.611
 618.909,103.647,489.697,42.067,-160.706,85.986,12.882,-0.004,1.211,1.715,87.645,2.399,111.317,45.101,0.934,3.851
 619.409,103.791,498.047,43.203,-160.734,77.919,12.221,-0.002,1.221,1.698,87.084,2.307,119.119,50.614,0.969,4.336
 619.909,103.684,488.672,41.818,-160.656,69.470,11.373,-0.002,1.227,1.696,86.718,2.341,126.241,55.647,1.004,5.982
 620.409,103.628,512.695,40.148,-160.559,66.122,11.655,-0.003,1.226,1.699,86.808,2.447,128.209,57.038,1.036,9.880
 620.909,103.800,497.168,38.603,-159.838,66.916,11.614,-0.005,1.216,1.660,87.392,2.536,123.129,53.448,1.033,20.875
 621.409,103.776,483.398,37.247,-158.067,66.675,11.773,-0.008,1.203,1.606,88.142,2.546,118.713,50.327,0.986,26.859
 621.909,103.608,483.398,35.487,-157.762,65.055,12.665,-0.009,1.196,1.595,88.529,2.432,118.833,50.412,0.894,12.343
 622.409,103.750,478.027,33.408,-156.948,62.705,11.719,-0.009,1.196,1.618,88.511,2.243,124.328,54.295,0.782,4.960
 622.909,103.792,473.633,33.279,-156.307,61.526,11.159,-0.009,1.195,1.619,88.610,2.059,135.564,62.236,0.670,2.502
 623.409,103.811,477.783,34.575,-154.819,64.380,12.114,-0.012,1.187,1.587,89.065,1.940,148.114,71.105,0.561,1.432
 623.909,103.672,473.633,38.317,-155.064,71.748,11.387,-0.014,1.177,1.550,89.643,1.907,158.753,78.624,0.467,0.949
 624.409,103.958,471.680,44.097,-155.133,83.013,10.974,-0.016,1.170,1.543,90.050,1.913,165.855,83.643,0.394,0.701
 624.909,103.796,483.398,49.942,-152.730,92.663,12.372,-0.016,1.169,1.562,90.122,1.889,168.742,85.683,0.346,0.578
 625.409,103.805,482.178,55.212,-150.481,93.572,13.015,-0.015,1.169,1.574,90.112,1.788,168.246,85.333,0.318,0.525
 625.909,103.754,474.756,58.428,-149.979,86.894,13.016,-0.014,1.170,1.568,90.084,1.624,164.829,82.918,0.307,0.521
 626.409,103.769,475.049,64.427,-152.329,77.381,12.785,-0.013,1.174,1.552,89.820,1.484,160.295,79.714,0.313,0.559
 626.909,103.734,486.523,70.592,-154.112,68.549,11.342,-0.010,1.184,1.552,89.222,1.448,152.815,74.427,0.336,0.651
 627.409,103.802,478.516,70.965,-154.127,62.177,9.890,-0.004,1.204,1.589,88.060,1.531,141.659,66.544,0.383,0.823
 627.909,103.887,478.516,67.415,-153.049,57.368,10.413,0.014,1.250,1.677,85.387,1.701,128.300,57.102,0.467,1.143
 628.409,103.856,488.281,59.967,-148.048,53.629,10.349,0.051,1.342,1.800,79.974,1.996,113.805,46.859,0.618,1.749
 628.909,103.932,483.838,51.730,-141.947,48.545,9.374,0.098,1.478,2.013,72.022,2.642,100.566,37.503,0.870,2.938
 629.409,103.864,484.961,41.883,-140.246,39.733,8.817,0.136,1.625,2.325,63.477,4.547,87.342,28.157,1.326,6.692
 629.909,103.774,493.164,29.616,-141.066,28.499,8.231,0.159,1.732,2.605,57.200,7.979,74.196,18.867,2.089,26.480
 630.409,103.851,478.516,19.140,-140.584,16.684,8.103,0.169,1.778,2.781,54.523,12.962,64.572,12.065,3.777,999999.999
 630.909,103.750,478.760,13.268,-137.767,7.332,8.070,0.176,1.784,2.860,54.129,18.271,59.970,8.812,8.121,999999.999
 631.409,103.849,505.518,10.172,-138.853,2.772,8.042,0.181,1.770,2.859,54.955,22.530,62.695,10.738,202.812,999999.999
 631.909,103.707,478.516,9.094,-140.886,1.036,8.016,0.182,1.747,2.800,56.324,25.278,69.919,15.844,999999.999,999999.999
 632.409,103.800,478.516,9.618,-141.261,0.638,7.989,0.180,1.717,2.673,58.064,25.865,77.570,21.251,999999.999,999999.999
 632.909,103.714,504.004,10.501,-140.997,0.537,7.954,0.174,1.690,2.533,59.671,24.771,84.149,25.900,999999.999,999999.999
 633.409,103.866,512.695,11.260,-143.212,0.540,7.912,0.165,1.670,2.429,60.833,22.490,89.756,29.863,999999.999,999999.999
 633.909,103.880,479.248,11.289,-143.852,0.585,7.848,0.156,1.657,2.373,61.582,20.143,93.640,32.608,999999.999,999999.999
 634.409,103.880,483.398,10.495,-140.824,0.714,7.754,0.150,1.660,2.374,61.394,18.611,96.347,34.521,999999.999,999999.999
 634.909,103.818,486.328,10.216,-139.713,0.940,7.644,0.150,1.681,2.467,60.157,17.806,100.307,37.320,999999.999,999999.999
 635.409,103.933,485.645,10.360,-142.423,1.111,7.545,0.154,1.701,2.614,59.034,16.918,109.302,43.676,999999.999,999999.999
 635.909,103.969,485.840,11.919,-144.355,0.988,7.488,0.151,1.679,2.624,60.277,15.249,126.498,55.829,13.644,999999.999
 636.409,103.762,478.516,15.624,-144.183,0.761,7.484,0.141,1.621,2.523,63.692,12.801,147.938,70.981,4.233,999999.999
 636.909,103.994,479.980,19.741,-144.872,1.385,7.439,0.130,1.560,2.407,67.229,10.039,168.028,85.179,1.921,3.639
 637.409,103.944,495.410,24.525,-147.822,4.419,7.402,0.112,1.499,2.264,70.798,7.554,183.574,96.166,1.140,1.933
 637.909,103.840,483.398,31.086,-151.016,15.533,7.978,0.078,1.414,2.084,75.802,5.811,192.927,102.775,0.809,1.456
 638.409,103.946,479.150,40.907,-150.014,36.834,9.860,0.037,1.310,1.863,81.881,4.913,196.466,105.276,0.662,1.322
 638.909,104.007,493.164,54.527,-148.158,58.768,11.472,0.011,1.249,1.724,85.446,4.600,191.995,102.117,0.608,1.362
 639.409,103.952,493.164,69.094,-146.425,70.651,9.932,0.023,1.291,1.764,82.994,4.274,181.245,94.520,0.605,1.468
 639.909,104.031,506.055,78.205,-145.174,65.706,8.094,0.059,1.422,1.929,75.313,3.663,167.528,84.826,0.618,1.477
 640.409,103.989,522.461,77.787,-144.587,53.759,8.657,0.095,1.573,2.178,66.502,3.047,156.394,76.957,0.623,1.392
 640.909,104.063,500.928,69.274,-146.865,45.589,8.588,0.110,1.659,2.404,61.452,2.728,154.332,75.500,0.597,1.265
 641.409,103.961,478.516,57.158,-148.261,41.674,7.695,0.095,1.624,2.409,63.507,2.692,160.006,79.510,0.551,1.159
 641.909,104.055,489.063,47.966,-148.218,44.976,8.458,0.057,1.473,2.168,72.315,2.861,170.338,86.812,0.505,1.117
 642.409,104.014,483.398,42.171,-147.592,53.869,10.177,0.018,1.304,1.876,82.226,3.006,178.373,92.490,0.466,1.090
 642.909,103.892,477.637,40.822,-145.727,64.726,11.952,-0.006,1.202,1.705,88.181,2.975,179.506,93.291,0.440,1.049
 643.409,103.943,487.744,45.514,-146.717,71.086,12.923,-0.005,1.203,1.679,88.138,2.743,176.747,91.341,0.424,1.010
 643.909,104.027,483.398,52.539,-148.122,70.114,12.780,0.016,1.294,1.792,82.790,2.405,174.427,89.701,0.418,0.975
 644.409,103.965,482.617,55.524,-150.560,65.892,10.891,0.045,1.419,1.972,75.473,2.255,172.463,88.313,0.424,0.988
 644.909,104.029,478.516,50.585,-150.729,61.609,8.481,0.061,1.489,2.085,71.394,2.517,166.730,84.262,0.447,1.074
 645.409,103.950,472.607,41.535,-150.663,62.252,8.378,0.049,1.443,2.041,74.090,3.035,156.795,77.240,0.484,1.236
 645.909,104.127,475.879,32.898,-149.311,70.604,10.506,0.018,1.315,1.864,81.567,3.511,146.954,70.285,0.533,1.503
 646.409,103.972,479.736,29.408,-146.740,80.924,12.506,-0.009,1.202,1.716,88.203,3.669,141.081,66.135,0.579,1.813
 646.909,104.144,502.441,29.768,-145.674,89.777,13.009,-0.020,1.155,1.642,90.923,3.454,137.985,63.947,0.607,2.046
 647.409,103.993,504.883,31.063,-145.088,92.368,13.018,-0.020,1.152,1.629,91.083,3.081,134.005,61.134,0.616,2.100
 647.909,104.090,489.941,31.522,-147.647,89.658,13.017,-0.019,1.156,1.653,90.904,2.723,128.159,57.003,0.614,2.046
 648.409,103.861,478.516,32.242,-148.093,86.543,13.016,-0.018,1.159,1.683,90.711,2.471,125.574,55.176,0.615,2.007
 648.909,104.044,499.756,34.046,-147.863,80.584,13.015,-0.017,1.163,1.708,90.489,2.296,128.866,57.503,0.624,2.032
 649.409,103.976,502.930,35.986,-146.948,75.939,13.010,-0.016,1.166,1.718,90.301,2.138,136.806,63.114,0.645,2.139
 649.909,104.180,498.438,38.311,-147.626,76.496,12.910,-0.016,1.170,1.720,90.047,2.018,145.969,69.590,0.677,2.382
 650.409,104.016,490.967,40.081,-149.856,91.725,12.553,-0.015,1.175,1.722,89.766,1.982,150.969,73.123,0.730,3.057
 650.909,104.201,488.281,41.089,-151.593,117.951,11.931,-0.012,1.190,1.726,88.871,2.021,151.891,73.774,0.814,4.674
 651.409,104.153,483.203,39.102,-150.609,132.004,11.790,-0.002,1.261,1.787,84.710,2.141,155.488,76.316,0.945,12.896
 651.909,104.167,493.652,36.721,-149.094,124.002,11.514,0.015,1.406,1.926,76.244,2.319,163.743,82.150,1.081,42.373
 652.409,104.156,520.215,38.340,-146.692,96.155,11.367,0.032,1.611,2.237,64.283,2.546,173.454,89.013,1.131,23.220
 652.909,104.098,507.813,39.901,-143.888,69.864,10.292,0.038,1.794,2.611,53.565,2.758,181.106,94.421,1.041,6.502
 653.409,104.010,510.693,39.846,-143.815,56.050,8.809,0.024,1.851,2.939,50.249,2.857,181.906,94.986,0.875,3.272
 653.909,104.102,493.164,37.208,-142.702,48.481,9.384,0.005,1.766,3.009,55.203,2.829,179.517,93.298,0.726,2.074
 654.409,104.016,486.914,35.924,-139.661,47.179,9.255,-0.008,1.565,2.659,66.941,2.743,179.548,93.320,0.614,1.473
 654.909,104.174,510.156,38.157,-135.475,56.258,9.610,-0.013,1.358,2.188,79.088,2.686,182.667,95.524,0.533,1.097
 655.409,104.135,522.461,41.527,-134.041,73.763,11.843,-0.014,1.220,1.776,87.115,2.697,187.057,98.627,0.471,0.869
 655.909,104.262,501.904,44.997,-134.033,89.012,12.974,-0.014,1.167,1.631,90.213,2.704,189.922,100.652,0.425,0.730
 656.409,104.095,522.998,47.935,-132.854,98.542,13.025,-0.008,1.185,1.632,89.205,2.630,188.510,99.654,0.398,0.673
 656.909,104.099,519.531,50.627,-130.936,101.860,13.009,0.010,1.286,1.640,83.262,2.514,183.980,96.453,0.389,0.669
 657.409,104.118,483.398,54.046,-132.751,98.979,12.975,0.025,1.447,1.764,73.839,2.404,177.924,92.172,0.401,0.725
 657.909,104.110,484.912,60.929,-134.741,88.884,12.853,0.036,1.628,1.951,63.289,2.338,171.868,87.893,0.435,0.848
 658.409,104.116,480.176,70.829,-133.958,73.702,11.867,0.050,1.788,2.158,53.890,2.285,167.572,84.856,0.498,1.074
 658.909,104.134,502.930,81.346,-135.321,60.672,10.767,0.060,1.896,2.297,47.596,2.224,159.595,79.219,0.599,1.523
 659.409,104.056,498.633,85.144,-139.412,53.694,10.230,0.060,1.993,2.424,41.923,2.333,144.373,68.461,0.760,2.332
 659.909,104.031,517.578,79.346,-144.078,50.721,9.175,0.035,2.078,2.744,36.975,3.065,124.378,54.331,1.029,3.932
 660.409,104.232,503.955,66.621,-144.118,46.566,7.557,0.004,2.152,3.030,32.614,4.898,104.052,39.966,1.432,6.143
 660.909,103.988,497.070,50.115,-141.891,38.363,6.680,-0.009,2.224,3.243,28.397,8.466,90.725,30.547,2.016,8.091
 661.409,104.290,507.813,34.595,-140.149,26.709,6.604,-0.008,2.284,3.413,24.929,12.749,86.585,27.622,2.645,9.666
 661.909,104.188,502.930,24.513,-138.278,15.978,6.598,0.004,2.301,3.630,23.894,15.300,92.170,31.569,3.161,11.215
 662.409,104.197,502.832,20.915,-138.864,10.027,6.606,0.027,2.240,3.787,27.457,14.701,102.891,39.146,3.621,20.652
 662.909,104.207,498.047,26.143,-141.206,11.997,6.771,0.057,2.081,3.439,36.813,11.280,110.903,44.808,4.045,4729.555
 663.409,104.237,507.813,33.589,-144.660,21.195,7.347,0.071,1.953,2.895,44.248,8.480,109.441,43.775,4.421,999999.999
 663.909,104.188,502.051,35.877,-143.206,30.518,7.155,0.050,1.960,2.557,43.872,9.324,99.353,36.646,4.486,999999.999
 664.409,104.274,502.930,34.050,-142.245,32.061,6.506,0.015,2.075,2.662,37.109,13.799,86.306,27.425,4.323,16.910
 664.909,104.184,506.055,27.893,-143.263,23.561,6.451,-0.010,2.198,2.957,29.960,22.310,74.937,19.390,4.507,8.814
 665.409,104.240,504.590,20.764,-146.004,12.049,6.444,-0.016,2.252,3.142,26.797,33.984,65.932,13.026,5.214,7.352
 665.909,104.181,512.695,15.783,-146.858,5.172,6.432,-0.015,2.278,3.245,25.274,47.174,58.752,7.952,7.769,9.368
 666.409,104.171,499.072,12.464,-145.154,2.491,6.426,-0.017,2.304,3.363,23.714,59.000,54.233,4.758,16.376,17.978
 666.909,104.233,510.156,12.835,-144.906,1.529,6.425,-0.018,2.327,3.498,22.410,66.542,52.908,3.822,104.022,75.002
 667.409,104.174,511.426,14.839,-145.098,0.930,6.425,-0.016,2.319,3.504,22.856,69.529,53.707,4.387,139830.281,999999.999
 667.909,104.078,507.813,14.980,-146.412,0.479,6.426,-0.014,2.283,3.457,24.997,69.313,55.501,5.654,84419.023,999999.999
 668.409,104.308,510.840,14.743,-147.550,0.415,6.425,-0.014,2.248,3.415,27.020,67.569,56.831,6.594,780.962,999999.999
 668.909,104.282,501.367,15.016,-147.763,0.730,6.426,-0.014,2.221,3.437,28.608,64.809,57.058,6.755,93.973,155976.531
 669.409,104.253,527.344,15.434,-145.577,0.988,6.426,-0.007,2.183,3.424,30.835,59.905,56.566,6.407,74.290,20976.105
 669.909,104.297,497.266,15.515,-143.397,1.001,6.426,0.003,2.127,3.263,34.108,52.083,56.932,6.665,129.394,999999.999
 670.409,104.306,522.461,14.759,-142.648,1.549,6.424,0.007,2.078,3.007,36.954,41.852,59.333,8.363,999999.999,999999.999
 670.909,104.250,531.543,16.963,-141.035,3.335,6.397,0.001,2.072,2.875,37.291,33.283,62.148,10.352,999999.999,999999.999
 671.409,104.267,509.033,20.564,-141.237,5.631,6.364,-0.012,2.119,3.037,34.549,29.437,63.091,11.018,999999.999,999999.999
 671.909,104.242,522.461,22.440,-141.093,6.646,6.357,-0.020,2.179,3.342,31.039,27.845,61.264,9.727,400050.031,400052.719
 672.409,104.280,529.785,21.326,-142.528,5.315,6.361,-0.007,2.194,3.625,30.167,24.966,67.007,13.786,7.988,8.916
 672.909,104.297,540.674,20.541,-141.581,3.361,6.380,0.028,2.140,3.669,33.357,19.306,84.157,25.906,3.443,4.857
 673.409,104.322,519.531,27.633,-138.522,4.357,6.438,0.065,1.981,3.315,42.652,13.226,108.106,42.831,2.397,4.489
 673.909,104.172,517.578,38.862,-136.136,12.773,6.620,0.077,1.752,2.704,56.017,9.239,127.136,56.280,2.053,5.276
 674.409,104.448,526.367,50.240,-137.613,33.846,7.989,0.060,1.597,2.113,65.063,7.628,129.533,57.974,1.991,6.478
 674.909,104.382,537.109,56.558,-139.822,54.684,9.735,0.030,1.625,2.006,63.469,7.468,119.734,51.049,2.039,6.044
 675.409,104.310,505.371,56.863,-140.080,60.930,8.273,0.008,1.835,2.474,51.171,8.043,103.882,39.846,2.140,5.253
 675.909,104.307,502.930,56.732,-138.394,50.567,6.348,-0.004,2.061,3.005,37.966,8.965,89.692,29.818,2.409,5.090
 676.409,104.263,502.930,53.449,-136.716,32.457,6.326,-0.011,2.155,3.297,32.436,10.754,80.840,23.562,3.103,7.472
 676.909,104.300,518.652,47.646,-136.236,20.856,6.363,-0.010,2.120,3.180,34.525,13.100,78.118,21.638,4.851,26.194
 677.409,104.243,515.234,40.964,-136.887,16.912,6.425,-0.005,2.020,2.809,40.333,14.490,79.773,22.808,7.238,999999.999
 677.909,104.324,520.605,37.150,-138.163,17.031,6.451,0.008,1.938,2.515,45.149,13.435,84.281,25.994,6.238,999999.999
 678.409,104.288,514.990,38.837,-137.505,19.871,6.440,0.034,1.880,2.355,48.514,10.241,91.821,31.323,3.407,1126.897
 678.909,104.326,506.299,40.555,-136.837,25.349,6.514,0.056,1.787,2.285,53.989,6.991,101.407,38.097,1.927,10.811
 679.409,104.315,507.031,40.282,-138.332,34.259,7.271,0.055,1.611,2.166,64.251,5.141,110.957,44.846,1.288,5.541
 679.909,104.250,493.164,38.415,-141.183,46.151,9.564,0.030,1.396,1.903,76.841,4.590,119.156,50.640,0.969,3.602
 680.409,104.408,493.164,37.870,-142.777,59.462,12.130,0.000,1.228,1.652,86.639,4.421,126.828,56.062,0.787,2.566
 680.909,104.354,498.047,36.496,-141.995,73.032,13.001,-0.015,1.164,1.558,90.422,4.114,138.953,64.631,0.679,2.054
 681.409,104.509,498.047,34.147,-140.455,80.931,13.013,-0.018,1.156,1.532,90.906,3.552,153.845,75.155,0.615,1.731
 681.909,104.354,509.668,30.460,-138.625,79.810,13.020,-0.017,1.166,1.531,90.296,2.826,168.104,85.233,0.583,1.495
 682.409,104.395,517.578,28.278,-134.372,74.494,13.019,-0.013,1.197,1.568,88.493,2.179,179.435,93.240,0.561,1.263
 682.909,104.369,515.088,32.441,-133.712,67.526,12.994,-0.006,1.248,1.685,85.497,1.833,185.390,97.449,0.528,1.026
 683.409,104.166,512.842,38.179,-132.890,62.277,11.869,-0.001,1.280,1.775,83.647,1.823,189.087,100.061,0.486,0.854
 683.909,104.323,509.521,45.004,-133.310,59.627,11.300,-0.003,1.262,1.764,84.670,2.065,188.508,99.652,0.445,0.765
 684.409,104.345,512.695,50.173,-132.119,63.697,12.426,-0.008,1.214,1.676,87.457,2.271,182.824,95.635,0.419,0.745
 684.909,104.400,512.695,51.135,-132.978,78.527,13.000,-0.012,1.184,1.590,89.258,2.263,172.815,88.562,0.425,0.820
 685.409,104.338,517.578,49.830,-136.285,94.721,13.029,0.004,1.246,1.615,85.598,2.137,158.635,78.540,0.459,0.966
 685.909,104.434,530.273,48.292,-139.290,98.761,13.023,0.055,1.448,1.906,73.778,2.333,141.263,66.263,0.536,1.219
 686.409,104.546,520.801,48.763,-136.795,88.951,12.777,0.118,1.751,2.258,56.081,3.362,121.141,52.043,0.661,1.575
 686.909,104.458,512.695,49.193,-137.459,70.995,12.207,0.146,2.115,2.690,34.782,6.224,98.722,36.199,0.862,2.100
 687.409,104.421,539.355,42.679,-137.122,50.588,12.044,0.119,2.458,3.301,14.743,11.279,79.132,22.355,1.216,3.200
 687.909,104.425,505.371,30.797,-138.422,31.182,11.627,0.064,2.720,3.947,-0.584,16.592,65.753,12.899,1.895,6.174
 688.409,104.405,504.248,20.602,-137.801,15.752,11.128,0.028,2.854,4.403,-8.438,18.929,61.163,9.656,3.558,999999.999
 688.909,104.355,496.240,19.008,-137.498,7.025,11.158,0.028,2.857,4.373,-8.570,17.498,63.195,11.092,8.559,999999.999
 689.409,104.506,497.852,26.004,-138.335,6.752,11.233,0.034,2.790,3.927,-4.685,15.281,66.644,13.530,34.469,999999.999
 689.909,104.418,491.406,31.035,-135.690,10.446,11.370,0.029,2.753,3.652,-2.517,17.071,67.470,14.113,91.114,999999.999
 690.409,104.559,498.047,29.225,-134.323,12.671,11.262,0.019,2.791,3.761,-4.749,24.907,65.049,12.402,46.381,999999.999
 690.909,104.322,519.775,23.027,-133.602,11.213,11.045,0.014,2.873,4.011,-9.520,35.315,66.350,13.322,23.591,999999.999
 691.409,104.536,527.344,16.706,-133.654,6.783,11.033,0.018,2.945,4.244,-13.761,42.393,74.553,19.119,19.136,161.845
 691.909,104.299,536.523,14.232,-132.187,2.807,11.036,0.023,2.962,4.233,-14.709,41.914,85.398,26.783,19.468,23.562
 692.409,104.338,517.578,16.688,-132.018,1.986,11.034,0.028,2.918,4.037,-12.164,34.655,92.845,32.046,22.397,21.204
 692.909,104.349,517.578,22.409,-133.260,3.281,11.030,0.034,2.872,3.835,-9.450,29.327,95.381,33.838,26.944,21.761
 693.409,104.319,517.676,25.330,-133.494,5.165,11.025,0.039,2.874,3.838,-9.578,33.588,95.156,33.679,28.854,22.903
 693.909,104.573,522.754,23.150,-131.309,5.945,11.021,0.035,2.903,4.007,-11.314,44.414,94.675,33.339,27.612,21.796
 694.409,104.548,526.758,17.552,-132.589,4.769,11.023,0.026,2.941,4.401,-13.503,54.596,100.401,37.386,24.157,19.406
 694.909,104.516,507.813,13.422,-136.311,2.767,11.026,0.021,2.955,4.664,-14.346,57.026,111.950,45.548,22.525,18.473
 695.409,104.479,525.684,13.820,-138.150,1.392,11.027,0.020,2.951,4.575,-14.091,49.763,126.006,55.481,23.512,20.497
 695.909,104.409,512.695,16.657,-137.483,1.225,11.030,0.025,2.955,4.361,-14.304,39.749,136.517,62.910,28.071,25.810
 696.409,104.549,512.695,19.532,-137.388,1.776,11.051,0.023,2.950,4.139,-14.045,36.341,138.186,64.089,41.069,32.517
 696.909,104.368,514.453,18.993,-138.191,2.175,11.008,0.026,2.969,4.222,-15.123,42.228,135.687,62.323,39.092,26.428
 697.409,104.532,522.461,15.610,-140.536,2.020,10.924,0.034,3.002,4.490,-17.067,49.927,134.391,61.407,21.710,14.270
 697.909,104.429,517.578,12.534,-140.964,1.473,10.895,0.042,3.024,4.637,-18.372,48.368,136.840,63.138,10.086,7.909
 698.409,104.569,521.240,11.888,-140.254,1.004,10.882,0.042,3.005,4.645,-17.260,35.337,146.616,70.047,5.676,5.135
 698.909,104.657,521.143,15.693,-140.027,1.502,10.879,0.030,2.881,4.510,-9.981,19.636,160.155,79.615,3.882,4.004
 699.409,104.549,513.672,22.934,-139.605,4.238,10.903,0.020,2.667,4.098,2.526,8.654,170.984,87.268,2.996,3.442
 699.909,104.602,514.258,32.151,-139.810,10.956,11.161,0.025,2.455,3.500,14.940,3.915,176.344,91.056,2.531,3.102
 700.409,104.521,521.729,45.396,-138.953,21.100,11.453,0.047,2.330,2.909,22.212,2.738,176.100,90.883,2.198,2.760
 700.909,104.541,517.578,59.162,-136.109,30.837,11.436,0.068,2.320,2.543,22.792,3.095,172.116,88.068,1.975,2.432
 701.409,104.526,517.578,69.107,-133.780,37.162,11.570,0.076,2.357,2.456,20.630,3.681,166.289,83.950,1.834,2.237
 701.909,104.570,522.461,76.782,-132.557,38.353,11.509,0.074,2.383,2.437,19.096,3.927,157.774,77.932,1.817,2.177
 702.409,104.548,522.461,78.351,-131.843,37.312,11.363,0.064,2.396,2.409,18.348,3.963,149.848,72.330,1.910,2.282
 702.909,104.601,524.756,75.585,-131.206,36.808,11.400,0.058,2.441,2.418,15.721,4.090,143.260,67.675,2.152,2.531
 703.409,104.574,527.344,70.425,-130.519,36.097,11.213,0.052,2.506,2.594,11.923,4.560,137.056,63.291,2.492,2.905
 703.909,104.597,515.088,62.109,-129.104,33.586,10.969,0.047,2.596,2.992,6.647,6.305,129.741,58.121,2.989,3.536
 704.409,104.652,513.281,53.359,-128.100,28.105,10.784,0.048,2.706,3.552,0.223,11.229,122.275,52.844,3.658,4.495
 704.909,104.500,521.875,40.776,-128.911,19.728,10.521,0.047,2.803,3.972,-5.455,22.092,118.225,49.982,4.734,6.640
 705.409,104.625,522.461,27.116,-130.854,11.194,10.263,0.044,2.871,4.203,-9.425,36.191,118.956,50.499,6.831,12.501
 705.909,104.610,519.482,17.388,-134.052,4.578,9.959,0.046,2.911,4.261,-11.758,45.514,128.860,57.498,9.967,77.698
 706.409,104.522,527.344,13.034,-136.844,0.951,9.045,0.045,2.920,4.279,-12.289,44.175,142.128,66.875,12.080,8271.173
 706.909,104.630,546.680,13.708,-139.019,0.107,7.359,0.032,2.876,4.495,-9.707,32.253,152.141,73.951,7.976,58.517
 707.409,104.470,522.461,18.353,-140.809,0.654,6.361,0.010,2.770,4.630,-3.500,18.221,158.651,78.552,3.671,6.284
 707.909,104.721,522.461,23.824,-141.515,2.790,6.305,-0.008,2.612,4.496,5.710,8.511,164.579,82.741,2.010,2.763
 708.409,104.603,518.701,31.141,-140.118,7.290,6.408,-0.004,2.417,3.991,17.121,3.895,172.977,88.676,1.216,1.611
 708.909,104.734,522.461,42.409,-140.111,14.792,6.594,0.014,2.146,3.226,33.002,2.126,182.278,95.250,0.854,1.105
 709.409,104.641,522.461,51.754,-140.469,26.894,7.406,0.024,1.802,2.460,53.105,1.401,189.696,100.492,0.651,0.837
 709.909,104.661,518.555,55.177,-140.676,44.104,9.773,0.017,1.476,1.905,72.187,1.154,195.900,104.876,0.531,0.673
 710.409,104.514,517.578,50.078,-139.659,65.465,12.187,-0.001,1.263,1.651,84.596,1.117,201.005,108.484,0.458,0.578
 710.909,104.583,530.029,44.045,-140.024,88.203,12.998,-0.013,1.184,1.604,89.211,1.116,201.977,109.171,0.416,0.534
 711.409,104.653,502.930,46.018,-140.938,99.554,13.028,-0.007,1.203,1.649,88.134,1.099,196.377,105.213,0.401,0.524
 711.909,104.720,529.297,52.324,-141.712,97.234,13.025,0.011,1.285,1.698,83.339,1.086,186.149,97.985,0.404,0.543
 712.409,104.614,537.109,60.312,-141.573,84.531,13.021,0.030,1.473,1.812,72.335,1.125,176.874,91.430,0.422,0.572
 712.909,104.761,504.639,66.592,-140.836,70.236,12.854,0.037,1.724,2.341,57.690,1.210,171.230,87.441,0.445,0.613
 713.409,104.611,500.928,67.839,-138.677,62.025,11.652,0.031,1.868,2.946,49.255,1.289,171.260,87.463,0.471,0.665
 713.909,104.508,493.164,66.989,-134.422,55.235,10.569,0.018,1.807,3.107,52.819,1.327,174.098,89.469,0.498,0.739
 714.409,104.719,493.164,64.430,-133.463,53.296,11.717,0.017,1.588,2.755,65.588,1.314,177.932,92.178,0.533,0.834
 714.909,104.761,498.047,64.968,-134.538,57.652,12.924,0.035,1.472,2.112,72.386,1.307,180.147,93.744,0.573,0.905
 715.409,104.657,498.047,68.910,-134.351,63.303,12.978,0.057,1.642,1.961,62.447,1.393,178.427,92.528,0.597,0.897
 715.909,104.662,527.344,68.747,-132.131,63.067,12.556,0.064,1.928,2.443,45.755,1.565,176.073,90.865,0.594,0.823
 716.409,104.589,521.387,61.489,-130.541,55.872,11.356,0.050,2.066,2.903,37.675,1.674,176.163,90.928,0.562,0.745
 716.909,104.810,496.680,54.537,-133.243,47.912,10.489,0.030,1.980,2.933,42.711,1.632,180.479,93.978,0.529,0.696
 717.409,104.721,488.281,56.859,-137.014,48.083,11.380,0.019,1.813,2.642,52.467,1.455,185.518,97.539,0.512,0.692
 717.909,104.755,498.975,70.281,-138.592,54.239,12.658,0.020,1.751,2.376,56.070,1.283,185.361,97.428,0.514,0.714
 718.409,104.684,502.930,84.640,-138.803,59.515,13.013,0.039,1.838,2.472,50.995,1.239,177.650,91.979,0.529,0.745
 718.909,104.718,512.305,91.956,-138.047,61.424,13.018,0.068,1.979,2.692,42.747,1.310,166.069,83.794,0.543,0.750
 719.409,104.684,508.789,89.673,-135.405,59.122,12.711,0.082,2.109,2.899,35.141,1.521,156.492,77.026,0.545,0.714
 719.909,104.775,505.664,78.505,-134.628,53.506,11.460,0.065,2.173,3.337,31.401,1.733,153.345,74.802,0.531,0.654
 720.409,104.756,512.695,66.324,-135.861,45.669,9.858,0.033,2.077,3.605,36.992,1.761,156.978,77.369,0.502,0.586
 720.909,104.891,514.307,55.684,-137.758,43.277,9.433,0.011,1.797,3.294,53.419,1.567,167.084,84.512,0.467,0.531
 721.409,104.695,521.729,48.282,-137.372,52.348,10.858,0.004,1.466,2.577,72.738,1.279,181.514,94.709,0.428,0.488
 721.909,104.869,517.578,46.451,-136.111,69.603,12.535,-0.002,1.249,1.908,85.430,1.096,194.862,104.143,0.392,0.454
 722.409,104.674,517.578,50.257,-137.254,91.170,13.013,-0.007,1.186,1.677,89.098,1.039,201.708,108.981,0.363,0.428
 722.909,104.815,512.695,57.012,-136.906,110.191,13.023,0.004,1.274,1.697,83.983,1.057,200.089,107.837,0.343,0.405
 723.409,104.769,512.695,65.687,-136.321,116.615,13.021,0.028,1.465,1.895,72.827,1.125,194.842,104.129,0.328,0.386
 723.909,104.773,514.990,77.388,-134.735,104.405,12.956,0.056,1.721,2.263,57.850,1.197,187.810,99.159,0.318,0.373
 724.409,104.761,517.578,88.557,-135.562,81.953,12.156,0.070,1.913,2.693,46.616,1.217,181.251,94.524,0.311,0.369
 724.909,104.791,517.578,91.218,-136.813,69.815,11.425,0.063,1.894,2.815,47.692,1.133,176.175,90.936,0.312,0.385
 725.409,104.692,517.578,86.213,-138.154,76.098,12.041,0.045,1.715,2.575,58.199,0.995,165.705,83.537,0.325,0.426
 725.909,104.764,514.795,79.848,-141.252,90.293,12.818,0.037,1.507,2.182,70.354,0.863,142.886,67.411,0.358,0.509
 726.409,104.827,512.695,76.597,-144.177,99.902,13.012,0.051,1.458,1.902,73.206,0.835,111.812,45.451,0.413,0.633
 726.909,104.771,512.695,72.715,-143.871,98.647,13.010,0.075,1.690,2.137,59.666,1.298,84.051,25.831,0.503,0.800
 727.409,104.894,514.063,60.609,-142.649,83.667,12.763,0.079,2.088,2.883,36.356,2.972,67.307,13.998,0.618,0.977
 727.909,104.852,522.461,42.524,-141.376,57.344,11.457,0.062,2.514,3.914,11.460,6.628,63.847,11.552,0.764,1.157
 728.409,104.792,517.578,26.467,-140.302,28.966,10.332,0.035,2.799,4.841,-5.233,10.531,71.873,17.225,0.943,1.402
 728.909,104.914,514.111,18.766,-138.591,9.866,10.226,0.022,2.852,5.353,-8.312,12.007,87.535,28.293,1.192,1.839
 729.409,104.918,513.867,22.043,-138.011,4.790,10.245,0.033,2.677,5.121,1.915,10.244,103.020,39.237,1.561,2.868
 729.909,104.840,517.578,33.732,-137.011,12.622,10.512,0.050,2.412,4.277,17.414,7.172,109.968,44.147,2.061,5.363
 730.409,104.874,516.162,45.286,-134.307,27.022,11.556,0.054,2.294,3.709,24.314,7.272,104.478,40.267,2.556,10.394
 730.909,104.828,516.650,47.408,-133.329,35.721,11.576,0.038,2.403,3.812,17.928,13.955,89.600,29.753,2.855,11.634
 731.409,104.832,527.344,36.961,-133.279,31.727,10.485,0.016,2.656,4.510,3.133,28.350,72.814,17.890,3.087,7.865
 731.909,104.701,523.145,22.051,-133.909,18.028,10.158,0.009,2.875,5.089,-9.675,46.264,59.206,8.273,3.364,5.530
 732.409,104.887,522.461,13.578,-133.281,6.028,10.146,0.014,2.963,5.065,-14.768,58.022,52.602,3.605,3.750,4.416
 732.909,104.720,518.018,12.134,-133.281,1.155,10.146,0.020,2.980,4.917,-15.777,57.352,54.539,4.975,3.850,3.855
 733.409,104.895,514.795,14.860,-134.579,0.272,10.151,0.017,2.928,4.967,-12.724,43.463,66.526,13.446,3.482,3.579
 733.909,104.810,517.578,19.490,-137.886,1.127,10.164,0.016,2.774,4.986,-3.758,25.659,83.755,25.622,3.001,3.716
 734.409,104.854,515.039,28.820,-138.661,6.432,10.240,0.023,2.518,4.377,11.205,12.426,98.179,35.816,2.696,4.332
 734.909,104.917,517.578,38.508,-138.068,17.765,10.980,0.024,2.310,3.637,23.404,6.554,101.003,37.811,2.580,5.023
 735.409,104.832,507.520,40.972,-137.373,27.643,11.739,0.016,2.341,3.402,21.602,10.813,89.321,29.556,2.605,4.914
 735.909,104.711,517.578,34.222,-135.054,28.677,10.985,0.001,2.547,3.776,9.504,23.658,73.256,18.202,2.739,4.312
 736.409,105.027,509.229,22.756,-130.754,19.102,10.180,-0.009,2.785,4.499,-4.361,43.529,59.630,8.572,3.054,4.099
 736.909,104.890,507.813,14.736,-128.379,7.087,10.156,-0.007,2.919,4.805,-12.198,61.121,55.314,5.522,3.780,4.515
 737.409,105.041,513.867,12.938,-127.232,1.553,10.166,0.002,2.951,4.842,-14.090,65.599,61.902,10.178,5.350,5.758
 737.909,104.810,518.799,14.822,-127.173,0.408,10.200,0.009,2.937,4.928,-13.300,56.099,72.913,17.960,8.029,7.631
 738.409,105.079,498.047,18.655,-129.158,0.827,10.274,0.020,2.884,4.957,-10.153,38.284,85.328,26.734,9.005,9.283
 738.909,104.979,519.434,24.187,-129.110,2.072,10.402,0.045,2.802,4.824,-5.385,22.066,94.551,33.252,7.332,10.392
 739.409,104.973,527.344,33.239,-128.614,4.944,10.621,0.078,2.691,4.373,1.124,12.159,100.779,37.653,5.327,10.611
 739.909,104.923,527.344,47.168,-128.109,10.860,10.876,0.105,2.569,3.726,8.233,7.820,105.135,40.732,4.387,9.563
 740.409,104.946,523.584,62.617,-128.745,20.654,11.220,0.112,2.439,3.147,15.828,6.587,106.894,41.975,4.044,7.802
 740.909,104.995,525.293,75.650,-131.300,32.018,11.512,0.105,2.356,2.809,20.716,6.587,106.138,41.440,3.597,5.710
 741.409,104.982,504.541,78.008,-132.701,40.797,11.740,0.083,2.361,2.816,20.408,7.286,103.700,39.717,3.049,4.056
 741.909,104.907,561.523,66.387,-134.487,41.611,11.712,0.052,2.461,3.140,14.557,8.210,101.056,37.848,2.469,3.201
 742.409,104.989,540.527,48.883,-135.404,35.281,11.391,0.023,2.538,3.729,10.047,8.390,99.131,36.489,2.180,2.918
 742.909,104.994,498.047,38.548,-136.492,28.403,11.045,0.008,2.422,4.017,16.853,7.254,99.522,36.765,2.172,3.355
 743.409,104.842,489.160,41.948,-136.912,29.540,11.262,0.014,2.210,3.701,29.260,5.696,102.687,39.001,2.451,4.432
 743.909,105.012,495.264,47.614,-136.137,39.499,12.344,0.018,2.135,3.399,33.630,6.554,105.519,41.003,3.013,6.176
 744.409,104.965,498.047,44.573,-133.638,45.051,12.192,0.012,2.298,3.429,24.084,11.460,102.900,39.152,3.592,6.872
 744.909,104.953,507.422,32.957,-129.243,37.065,10.985,-0.000,2.592,3.944,6.889,18.351,92.934,32.109,3.904,5.998
 745.409,104.954,517.529,22.442,-125.023,20.809,10.552,-0.006,2.810,4.396,-5.859,22.550,83.275,25.283,3.962,5.343
 745.909,104.869,517.871,19.867,-125.132,7.770,10.570,0.002,2.869,4.525,-9.325,20.320,84.867,26.408,4.087,5.110
 746.409,104.944,512.695,23.042,-127.764,3.361,10.619,0.019,2.793,4.584,-4.849,14.181,94.622,33.302,4.210,5.351
 746.909,104.939,495.703,30.307,-129.558,5.333,10.773,0.048,2.576,4.195,7.810,8.232,108.739,43.279,3.911,5.019
 747.409,104.979,502.930,39.499,-128.243,11.501,11.511,0.069,2.332,3.485,22.129,4.834,119.513,50.893,3.171,4.301
 747.909,104.993,502.930,49.698,-128.680,22.030,12.265,0.077,2.199,2.782,29.864,3.712,124.398,54.345,2.415,3.443
 748.409,105.109,529.297,57.128,-128.731,33.925,11.811,0.081,2.209,2.433,29.315,3.450,125.224,54.929,1.916,2.806
 748.909,105.054,512.695,61.299,-127.472,44.051,11.149,0.088,2.258,2.472,26.414,3.195,122.710,53.152,1.709,2.520
 749.409,105.006,528.320,64.099,-124.603,50.039,11.568,0.093,2.269,2.456,25.811,2.877,119.520,50.897,1.669,2.426
 749.909,105.016,504.102,63.144,-122.544,51.769,12.201,0.082,2.293,2.427,24.409,2.953,113.611,46.721,1.765,2.470
 750.409,105.019,495.605,59.636,-123.243,48.767,11.600,0.056,2.385,2.594,19.011,3.839,104.403,40.214,1.984,2.619
 750.909,104.813,510.449,54.557,-123.947,41.015,10.796,0.034,2.531,2.895,10.485,5.921,93.726,32.668,2.311,2.880
 751.409,105.195,512.695,47.618,-123.016,30.380,10.572,0.020,2.676,3.305,1.999,11.773,82.913,25.027,2.890,3.493
 751.909,105.017,516.699,39.069,-123.057,19.234,10.358,0.008,2.789,3.698,-4.593,25.123,72.299,17.526,3.852,4.732
 752.409,105.090,527.344,27.343,-121.461,10.523,10.130,-0.001,2.863,3.980,-8.972,47.827,63.095,11.021,5.688,7.079
 752.909,105.096,514.600,17.255,-120.878,4.480,10.031,-0.008,2.905,4.282,-11.380,73.703,57.113,6.794,8.999,12.011
 753.409,105.010,541.992,12.698,-120.574,1.160,10.016,-0.008,2.924,4.471,-12.503,88.999,56.730,6.523,14.068,20.042
 753.909,104.998,546.436,12.378,-120.078,-0.141,10.014,-0.005,2.933,4.604,-13.035,86.784,59.379,8.395,18.322,32.132
 754.409,105.092,510.547,13.190,-117.292,-0.055,10.019,-0.000,2.937,4.614,-13.302,67.198,63.234,11.119,19.181,31.953
 754.909,104.966,507.813,12.742,-116.575,0.793,10.039,0.004,2.917,4.504,-12.108,43.473,68.417,14.782,16.898,19.784
 755.409,105.036,505.322,14.306,-119.088,2.775,10.082,0.007,2.863,4.224,-8.972,25.672,75.918,20.084,12.236,11.927
 755.909,104.933,507.666,17.620,-123.023,5.508,10.124,0.008,2.812,3.833,-5.965,15.992,86.093,27.274,8.162,7.204
 756.409,105.088,503.516,22.587,-122.256,8.276,10.165,0.011,2.781,3.829,-4.130,12.195,100.482,37.443,5.596,5.225
 756.909,105.098,512.695,27.951,-121.664,10.318,10.231,0.023,2.745,3.943,-2.034,9.595,117.147,49.220,4.126,4.197
 757.409,105.141,521.191,32.721,-122.025,12.664,10.345,0.038,2.654,3.842,3.270,7.394,132.412,60.009,3.459,3.852
 757.909,104.994,517.578,38.362,-124.042,17.937,10.399,0.047,2.527,3.399,10.699,5.508,142.087,66.846,3.175,3.824
 758.409,105.045,511.426,45.379,-122.708,26.115,10.353,0.047,2.445,2.909,15.499,5.044,144.123,68.285,3.155,3.893
 758.909,105.114,502.930,48.839,-122.184,33.210,10.403,0.042,2.472,2.965,13.915,6.336,142.283,66.985,3.304,3.998
 759.409,105.141,502.930,44.097,-121.277,33.864,10.486,0.036,2.599,3.453,6.500,9.779,138.879,64.579,3.568,4.068
 759.909,105.093,507.813,36.224,-122.239,27.413,10.274,0.032,2.749,4.019,-2.267,14.963,135.937,62.499,3.893,4.170
 760.409,105.102,520.215,28.327,-120.456,17.685,10.027,0.024,2.863,4.391,-8.929,21.558,131.313,59.232,4.388,4.508
 760.909,105.177,520.020,23.124,-119.483,9.487,9.957,0.020,2.925,4.657,-12.554,25.908,125.242,54.941,4.984,5.050
 761.409,105.117,519.824,20.355,-116.358,5.000,9.906,0.017,2.905,4.775,-11.401,24.988,119.916,51.177,5.991,6.160
 761.909,105.189,516.113,20.184,-116.763,4.253,9.899,0.019,2.811,4.642,-5.922,19.546,117.173,49.239,7.274,7.930
 762.409,105.096,512.695,23.835,-116.365,6.417,9.946,0.030,2.722,4.309,-0.719,14.242,117.312,49.337,8.518,9.508
 762.909,105.114,507.813,26.463,-119.055,9.540,10.115,0.036,2.719,4.101,-0.514,15.327,116.612,48.843,8.616,9.521
 763.409,105.175,524.805,24.785,-119.522,10.709,10.048,0.035,2.805,4.286,-5.556,19.982,114.526,47.369,6.944,7.214
 763.909,105.063,527.344,20.627,-119.865,8.688,9.868,0.028,2.866,4.813,-9.130,21.269,114.638,47.447,5.201,5.385
 764.409,105.141,527.344,21.596,-121.588,5.482,9.918,0.045,2.828,5.100,-6.888,17.073,116.713,48.914,3.902,4.326
 764.909,105.154,518.164,34.549,-124.010,5.198,10.227,0.083,2.657,4.653,3.071,9.928,121.272,52.135,3.227,3.808
 765.409,105.021,512.695,53.807,-125.311,9.973,11.238,0.124,2.431,3.966,16.289,4.850,128.614,57.325,2.778,3.481
 765.909,105.085,524.854,74.937,-125.355,19.306,11.596,0.155,2.244,3.228,27.260,3.246,137.742,63.775,2.395,2.952
 766.409,105.268,527.295,90.919,-124.639,29.704,11.613,0.158,2.129,2.680,33.963,2.914,148.214,71.176,1.945,2.331
 766.909,105.246,527.734,95.980,-125.672,37.565,11.588,0.130,2.144,2.528,33.110,3.004,154.790,75.824,1.531,1.803
 767.409,105.062,498.047,95.246,-125.065,40.839,11.133,0.086,2.207,2.625,29.410,3.041,155.213,76.122,1.231,1.463
 767.909,105.190,506.689,87.761,-126.711,39.819,10.989,0.050,2.196,2.830,30.075,2.789,151.203,73.288,1.070,1.325
 768.409,105.190,512.695,81.241,-130.782,38.337,10.863,0.041,2.069,2.754,37.489,2.359,145.681,69.386,1.004,1.304
 768.909,105.107,521.924,78.605,-133.680,40.769,11.528,0.044,1.928,2.432,45.717,2.014,139.518,65.031,1.009,1.365
 769.409,105.104,526.563,77.669,-132.625,46.694,12.490,0.039,1.926,2.237,45.875,2.065,132.525,60.088,1.047,1.427
 769.909,105.252,522.461,78.624,-128.712,50.678,11.868,0.029,2.100,2.340,35.681,2.565,124.967,54.747,1.101,1.482
 770.409,105.079,518.604,78.506,-124.601,48.661,10.978,0.027,2.312,2.553,23.258,3.193,116.623,48.850,1.185,1.577
 770.909,105.139,522.461,78.517,-122.222,42.038,10.947,0.035,2.427,2.627,16.542,3.657,108.091,42.820,1.340,1.791
 771.409,105.175,517.578,77.434,-118.434,37.152,10.999,0.043,2.469,2.587,14.100,4.141,100.143,37.203,1.628,2.204
 771.909,105.129,529.004,72.312,-117.554,36.057,10.942,0.041,2.525,2.745,10.798,5.489,91.145,30.845,2.127,2.843
 772.409,105.233,529.297,62.070,-117.731,34.135,10.714,0.034,2.635,3.234,4.381,8.291,81.820,24.254,2.774,3.614
 772.909,105.076,518.408,47.857,-118.526,27.996,10.475,0.025,2.763,3.879,-3.119,11.588,72.836,17.905,3.406,4.344
 773.409,105.108,517.578,37.509,-118.721,18.667,10.375,0.026,2.842,4.403,-7.738,13.113,67.102,13.853,3.758,4.952
 773.909,105.097,500.586,32.709,-120.601,11.063,10.359,0.039,2.832,4.411,-7.116,11.975,67.988,14.479,4.012,5.605
 774.409,105.248,522.461,34.897,-119.998,10.419,10.373,0.053,2.722,3.892,-0.727,9.244,73.920,18.671,4.494,6.494
 774.909,105.416,513.477,38.782,-117.369,15.761,10.320,0.061,2.621,3.345,5.194,7.836,78.278,21.751,5.164,7.496
 775.409,105.200,524.658,37.161,-115.322,21.237,10.428,0.050,2.622,3.356,5.122,12.916,76.456,20.463,5.944,8.157
 775.909,105.336,527.344,30.030,-117.635,21.361,10.356,0.031,2.727,3.859,-1.013,26.386,69.299,15.405,6.525,8.303
 776.409,105.350,510.107,20.292,-121.487,14.572,10.064,0.016,2.871,4.468,-9.408,49.332,63.044,10.985,7.259,8.225
 776.909,105.376,517.578,14.103,-121.480,6.088,10.028,0.004,2.954,4.720,-14.271,74.844,62.199,10.388,8.460,8.758
 777.409,105.291,517.578,14.762,-119.866,1.480,10.025,-0.001,2.956,4.540,-14.402,93.483,65.556,12.760,11.321,10.776
 777.909,105.381,527.344,16.470,-119.485,0.044,10.024,-0.006,2.933,4.342,-13.069,105.585,69.522,15.563,17.019,15.542
 778.409,105.357,524.463,17.068,-119.211,-0.133,10.025,-0.008,2.917,4.282,-12.098,112.433,72.076,17.368,30.960,27.996
 778.909,105.258,517.578,15.366,-117.243,-0.181,10.026,-0.007,2.915,4.418,-11.999,114.668,77.627,21.291,58.306,49.612
 779.409,105.272,530.078,13.697,-118.946,-0.243,10.028,-0.003,2.928,4.612,-12.771,107.531,88.434,28.929,61.608,43.604
 779.909,105.301,510.156,13.750,-121.968,-0.286,10.031,0.000,2.939,4.825,-13.369,89.058,99.999,37.102,29.079,19.827
 780.409,105.309,522.461,14.409,-122.337,-0.189,10.033,0.005,2.942,4.943,-13.583,63.367,106.757,41.878,12.831,10.007
 780.909,105.429,514.746,17.342,-120.856,0.276,10.048,0.010,2.924,4.877,-12.502,39.409,106.912,41.987,6.893,6.146
 781.409,105.248,522.461,22.992,-121.161,1.635,10.155,0.014,2.841,4.656,-7.663,21.781,106.121,41.428,4.638,4.705
 781.909,105.405,527.148,33.038,-124.451,5.791,10.322,0.022,2.667,4.175,2.535,11.159,109.066,43.509,3.619,4.171
 782.409,105.297,516.504,45.276,-124.837,17.259,10.417,0.036,2.452,3.517,15.091,6.198,113.277,46.486,3.171,4.055
 782.909,105.216,516.064,51.169,-124.609,34.217,11.038,0.040,2.329,3.058,22.299,5.230,110.395,44.449,2.965,4.015
 783.409,105.368,512.695,45.988,-124.029,44.988,11.328,0.030,2.388,3.172,18.816,7.449,97.617,35.418,2.880,3.833
 783.909,105.235,516.113,33.268,-123.524,41.579,10.541,0.010,2.547,3.786,9.529,10.714,81.721,24.184,2.918,3.705
 784.409,105.306,522.461,23.308,-122.402,27.626,10.001,0.001,2.651,4.206,3.432,12.808,70.696,16.393,3.152,3.822
 784.909,105.296,527.344,23.526,-122.017,15.953,10.070,0.007,2.661,4.136,2.875,15.172,68.981,15.181,3.759,4.436
 785.409,105.228,527.344,26.891,-122.321,12.256,10.166,0.013,2.673,4.190,2.147,22.219,74.526,19.100,4.919,5.685
 785.909,105.258,532.227,25.831,-120.782,11.345,10.014,0.012,2.765,4.570,-3.242,36.000,81.922,24.327,6.875,7.482
 786.409,105.189,522.754,21.437,-118.441,8.997,9.904,0.008,2.877,5.002,-9.745,51.224,88.080,28.678,9.233,9.585
 786.909,105.375,529.785,17.439,-117.337,5.135,9.907,0.006,2.924,4.993,-12.512,59.691,89.272,29.521,11.067,11.109
 787.409,105.411,532.031,16.947,-119.361,2.215,9.920,0.003,2.910,4.728,-11.721,57.889,85.647,26.959,11.817,12.051
 787.909,105.360,519.775,19.300,-118.966,1.612,9.934,0.005,2.889,4.655,-10.472,46.351,86.676,27.686,12.645,12.574
 788.409,105.313,517.578,23.552,-119.823,2.121,9.954,0.013,2.879,4.673,-9.890,32.438,94.005,32.866,13.552,13.027
 788.909,105.354,520.459,28.792,-120.515,3.406,10.002,0.018,2.865,4.647,-9.053,23.464,105.757,41.171,14.786,14.320
 789.409,105.212,532.227,31.103,-120.010,5.055,9.986,0.017,2.858,4.610,-8.634,23.866,115.586,48.117,16.072,16.207
 789.909,105.427,532.227,29.722,-118.916,6.089,9.887,0.009,2.862,4.645,-8.872,33.578,117.808,49.688,17.010,17.534
 790.409,105.379,532.227,25.239,-120.935,5.884,9.835,0.004,2.890,4.800,-10.508,45.826,116.547,48.797,17.019,15.879
 790.909,105.438,525.488,20.701,-125.495,4.477,9.831,0.009,2.934,4.945,-13.120,51.138,118.416,50.117,15.003,11.933
 791.409,105.243,516.553,18.656,-130.308,2.778,9.846,0.013,2.957,5.017,-14.425,45.109,127.665,56.654,9.806,7.800
 791.909,105.420,512.695,18.664,-129.499,1.715,9.886,0.014,2.924,5.085,-12.509,30.529,143.060,67.534,6.138,5.231
 792.409,105.395,518.848,23.083,-128.417,1.853,9.958,0.030,2.841,4.990,-7.653,15.940,155.119,76.056,3.891,3.861
 792.909,105.396,518.604,32.571,-126.764,4.104,10.170,0.052,2.700,4.577,0.586,7.149,158.017,78.104,2.743,3.084
 793.409,105.387,517.578,46.620,-124.896,10.187,10.482,0.070,2.510,3.968,11.693,3.624,153.837,75.150,2.162,2.695
 793.909,105.367,533.789,61.659,-124.351,20.846,10.631,0.084,2.303,3.279,23.825,2.533,148.439,71.335,1.805,2.349
 794.409,105.425,531.836,72.157,-124.194,34.056,10.938,0.098,2.116,2.843,34.733,2.323,146.019,69.625,1.580,2.003
 794.909,105.429,518.164,79.128,-125.016,45.056,11.576,0.124,2.006,2.670,41.158,2.301,144.005,68.201,1.368,1.662
 795.409,105.355,527.344,84.813,-123.243,49.854,12.264,0.134,1.992,2.534,41.982,2.376,141.035,66.102,1.172,1.369
 795.909,105.410,531.885,85.743,-122.953,49.858,12.568,0.112,2.000,2.579,41.509,2.426,138.070,64.007,1.018,1.202
 796.409,105.342,541.992,81.030,-124.547,48.715,11.655,0.070,1.895,2.552,47.661,2.292,137.990,63.951,0.931,1.148
 796.909,105.289,532.422,73.629,-127.610,50.249,11.218,0.031,1.676,2.400,60.458,2.039,138.850,64.559,0.907,1.194
 797.409,105.491,524.902,69.892,-124.518,68.469,11.987,0.023,1.493,2.106,71.181,1.773,132.773,60.264,0.954,1.333
 797.909,105.345,522.314,70.912,-122.117,104.785,11.840,0.029,1.518,1.876,69.705,1.806,118.956,50.499,1.033,1.469
 798.409,105.422,517.578,65.286,-120.832,125.784,11.005,0.028,1.858,2.314,49.833,3.207,98.625,36.131,1.137,1.568
 798.909,105.389,518.604,52.246,-120.800,113.614,10.478,0.021,2.311,3.165,23.358,5.944,79.249,22.437,1.241,1.615
 799.409,105.359,529.297,36.855,-120.775,67.374,10.196,0.015,2.660,3.998,2.929,8.339,69.739,15.717,1.390,1.738
 799.909,105.443,532.227,27.864,-120.099,23.941,10.158,0.024,2.776,4.325,-3.840,8.856,70.038,15.928,1.655,2.059
 800.409,105.500,513.184,30.787,-121.961,11.447,10.210,0.041,2.702,3.946,0.467,7.911,77.352,21.097,2.143,2.743
 800.909,105.477,537.109,36.645,-124.603,13.679,10.415,0.043,2.637,3.649,4.253,8.866,83.569,25.490,2.942,4.008
 801.409,105.591,523.633,38.967,-125.520,17.918,10.409,0.028,2.675,3.784,2.032,14.189,82.056,24.421,3.970,5.912
 801.909,105.385,518.066,35.787,-126.171,18.132,10.201,0.013,2.787,4.429,-4.507,24.681,74.882,19.351,4.980,7.812
 802.409,105.566,537.109,29.934,-125.570,13.686,10.176,0.017,2.892,5.081,-10.662,41.661,66.608,13.504,5.978,9.468
 802.909,105.432,531.836,24.723,-127.984,8.042,10.181,0.030,2.941,5.214,-13.516,61.312,59.874,8.745,7.088,9.774
 803.409,105.515,517.578,18.692,-129.815,4.419,10.184,0.033,2.947,5.033,-13.841,73.982,55.361,5.556,8.338,9.300
 803.909,105.433,527.686,14.009,-132.094,2.479,10.184,0.026,2.926,4.809,-12.607,69.836,53.974,4.576,8.286,8.077
 804.409,105.479,521.680,15.120,-131.261,1.539,10.184,0.018,2.894,4.717,-10.785,50.913,58.891,8.050,6.904,6.770
 804.909,105.443,525.977,21.669,-130.646,2.184,10.190,0.013,2.810,4.739,-5.854,29.020,71.072,16.659,5.417,5.996
 805.409,105.641,536.572,31.937,-130.269,5.422,10.202,0.011,2.646,4.465,3.725,13.437,84.283,25.995,4.127,5.040
 805.909,105.340,532.227,40.013,-129.819,12.751,10.443,0.006,2.496,4.038,12.540,7.382,89.892,29.959,3.236,4.029
 806.409,105.550,536.768,41.509,-129.636,21.175,10.728,-0.001,2.451,4.181,15.145,6.714,88.212,28.772,2.548,3.176
 806.909,105.538,517.578,38.112,-127.020,25.310,10.473,-0.002,2.478,4.745,13.545,7.825,87.364,28.172,2.145,2.703
 807.409,105.505,522.363,34.026,-127.665,24.688,10.220,0.010,2.413,4.973,17.358,8.026,93.212,32.306,1.956,2.610
 807.909,105.443,534.521,37.480,-127.106,24.776,10.769,0.039,2.207,4.218,29.393,6.718,100.830,37.689,2.014,2.844
 808.409,105.533,527.344,45.455,-129.431,31.460,11.906,0.068,2.069,3.127,37.476,5.769,101.292,38.015,2.222,3.261
 808.909,105.566,527.344,48.955,-129.474,39.065,11.622,0.074,2.208,2.840,29.351,9.379,90.680,30.516,2.615,3.688
 809.409,105.457,527.734,43.473,-130.443,38.352,10.648,0.058,2.522,3.392,10.995,20.222,76.800,20.706,3.096,4.094
 809.909,105.480,529.297,31.916,-127.596,26.361,10.239,0.031,2.803,4.188,-5.453,41.846,67.384,14.052,3.759,4.824
 810.409,105.561,522.461,22.979,-124.375,11.876,9.967,0.009,2.952,4.826,-14.144,71.485,62.934,10.907,4.965,6.838
 810.909,105.495,531.982,18.540,-123.055,3.757,9.931,0.001,2.987,5.038,-16.197,101.748,60.699,9.328,8.369,15.277
 811.409,105.634,537.109,17.364,-123.182,0.828,9.916,-0.001,2.980,4.852,-15.779,123.829,58.548,7.808,257.022,999999.999
 811.909,105.484,533.691,15.900,-122.576,0.196,9.908,-0.002,2.967,4.552,-15.014,130.106,55.508,5.660,999999.999,999999.999
 812.409,105.591,539.844,15.558,-122.721,0.099,9.905,0.000,2.963,4.530,-14.790,118.935,55.353,5.550,999999.999,999999.999
 812.909,105.527,532.227,17.969,-124.444,0.114,9.904,0.001,2.953,4.741,-14.195,93.413,62.863,10.857,999999.999,999999.999
 813.409,105.593,535.791,20.849,-125.903,0.219,9.906,-0.000,2.922,4.914,-12.371,62.931,76.420,20.438,7.815,9.324
 813.909,105.580,532.227,24.227,-122.913,0.970,9.917,-0.001,2.801,4.989,-5.331,36.267,94.516,33.227,3.668,4.858
 814.409,105.571,525.781,30.735,-121.902,4.070,9.951,0.009,2.512,4.534,11.557,18.844,112.012,45.591,2.512,3.912
 814.909,105.620,530.664,41.363,-122.689,13.127,10.411,0.024,2.102,3.624,35.564,9.956,120.556,51.630,2.112,3.936
 815.409,105.530,534.033,50.425,-125.420,32.927,11.775,0.045,1.769,2.646,55.045,6.668,117.249,49.293,1.988,4.038
 815.909,105.469,524.072,56.984,-124.218,56.258,12.857,0.071,1.685,2.044,59.963,6.111,103.835,39.813,1.973,3.838
 816.409,105.491,526.465,56.676,-120.888,70.030,12.739,0.106,1.911,2.147,46.750,7.026,86.462,27.535,2.029,3.416
 816.909,105.401,527.637,52.775,-118.913,67.729,11.622,0.126,2.267,2.646,25.924,10.113,72.273,17.507,2.171,3.184
 817.409,105.610,532.227,44.527,-115.485,49.694,10.570,0.101,2.568,3.405,8.277,19.800,62.011,10.255,2.590,3.457
 817.909,105.556,527.393,31.281,-113.445,28.771,10.172,0.053,2.783,4.097,-4.285,38.210,55.620,5.738,3.488,4.380
 818.409,105.506,537.207,21.459,-113.647,13.142,9.992,0.012,2.893,4.571,-10.711,66.397,53.121,3.972,5.908,7.075
 818.909,105.580,541.699,14.364,-114.944,3.664,9.944,-0.001,2.956,4.774,-14.379,97.161,52.040,3.208,12.015,15.413
 819.409,105.586,534.961,12.761,-113.202,0.315,9.916,0.002,2.979,4.848,-15.720,122.730,51.712,2.976,32.676,1018.536
 819.909,105.603,537.109,13.059,-112.536,-0.567,9.897,0.007,2.989,4.976,-16.300,139.174,51.139,2.572,65.200,999999.999
 820.409,105.531,531.152,12.098,-113.289,-0.698,9.876,0.010,2.993,4.969,-16.555,144.671,50.133,1.861,63.862,999999.999
 820.909,105.590,532.227,11.554,-115.553,-0.723,9.854,0.011,2.993,4.802,-16.526,141.684,49.669,1.533,49.897,12748.765
 821.409,105.479,529.053,10.946,-113.621,-0.714,9.839,0.010,2.990,4.740,-16.369,128.840,49.859,1.667,39.804,87.703
 821.909,105.488,512.695,11.280,-112.395,-0.581,9.835,0.009,2.976,4.874,-15.550,106.522,50.258,1.949,34.002,34.684
 822.409,105.613,529.785,16.286,-113.991,-0.102,9.835,0.012,2.950,4.955,-14.008,78.428,51.081,2.530,30.524,26.776
 822.909,105.671,531.104,25.925,-115.323,0.797,9.842,0.016,2.919,4.772,-12.223,56.399,52.520,3.548,28.792,23.717
 823.409,105.628,527.344,33.654,-115.121,1.805,9.880,0.015,2.892,4.422,-10.616,54.468,54.027,4.612,28.393,22.599
 823.909,105.656,525.098,32.774,-114.585,2.325,9.930,0.013,2.891,4.265,-10.575,74.840,54.540,4.976,28.207,21.721
 824.409,105.599,532.227,24.623,-115.631,2.063,9.960,0.014,2.918,4.408,-12.151,106.356,53.660,4.354,28.319,21.133
 824.909,105.522,529.102,15.293,-116.106,1.257,9.985,0.014,2.944,4.555,-13.710,131.481,52.834,3.769,29.333,21.520
 825.409,105.698,530.762,11.510,-113.057,0.470,10.011,0.012,2.951,4.598,-14.096,143.083,53.355,4.138,32.471,23.355
 825.909,105.562,530.420,11.502,-110.744,0.050,10.030,0.005,2.942,4.632,-13.556,143.237,55.082,5.358,38.861,26.223
 826.409,105.622,531.689,11.944,-109.035,-0.113,10.045,-0.001,2.937,4.687,-13.246,136.933,57.256,6.895,48.193,28.826
 826.909,105.553,530.176,11.279,-109.775,-0.173,10.058,-0.001,2.941,4.788,-13.508,122.745,60.116,8.916,45.348,26.572
 827.409,105.687,545.703,9.677,-112.363,-0.217,10.074,0.004,2.954,4.894,-14.288,100.169,66.551,13.464,29.886,19.649
 827.909,105.735,517.578,9.526,-114.637,-0.172,10.105,0.011,2.962,4.984,-14.747,70.583,78.486,21.899,17.065,13.066
 828.409,105.514,512.744,12.899,-116.630,0.140,10.160,0.017,2.939,4.929,-13.402,42.021,92.042,31.478,9.913,8.517
 828.909,105.677,534.717,23.542,-116.046,1.390,10.268,0.032,2.864,4.630,-9.011,21.957,101.427,38.111,6.618,6.172
 829.409,105.730,536.523,42.316,-115.966,4.433,10.417,0.065,2.752,4.178,-2.442,10.236,106.544,41.727,4.658,4.645
 829.909,105.677,525.195,66.439,-113.717,10.811,10.807,0.091,2.626,3.645,4.892,5.689,110.048,44.203,3.528,3.677
 830.409,105.620,527.783,86.396,-113.680,19.405,11.409,0.096,2.516,3.426,11.320,3.919,112.349,45.829,2.762,2.979
 830.909,105.638,517.334,94.817,-112.889,27.115,11.258,0.101,2.442,3.444,15.697,3.421,114.109,47.074,2.261,2.478
 831.409,105.497,537.109,91.725,-114.049,31.987,11.136,0.116,2.400,3.374,18.123,3.173,114.755,47.530,1.938,2.144
 831.909,105.730,537.109,87.904,-113.345,34.620,11.792,0.129,2.394,3.139,18.483,2.968,114.793,47.557,1.739,1.921
 832.409,105.619,541.992,89.453,-111.889,36.501,11.608,0.108,2.403,2.761,17.940,2.866,116.029,48.430,1.612,1.764
 832.909,105.672,524.658,93.794,-110.860,37.325,11.051,0.057,2.426,2.681,16.633,2.840,116.330,48.643,1.524,1.651
 833.409,105.674,532.227,94.451,-110.716,36.499,10.992,0.022,2.458,2.914,14.729,2.894,115.049,47.738,1.452,1.568
 833.909,105.716,532.227,89.107,-112.143,34.948,10.984,0.025,2.490,3.332,12.861,2.986,112.992,46.284,1.410,1.547
 834.409,105.682,534.375,84.392,-113.841,33.463,10.986,0.068,2.500,3.623,12.279,2.964,110.821,44.750,1.413,1.603
 834.909,105.685,527.344,83.846,-116.125,33.079,11.073,0.118,2.473,3.519,13.856,2.840,109.363,43.719,1.477,1.743
 835.409,105.775,537.109,84.149,-117.163,35.014,11.527,0.132,2.448,3.092,15.304,3.066,105.958,41.313,1.623,1.964
 835.909,105.695,532.959,79.333,-115.185,37.245,11.455,0.099,2.492,2.787,12.731,4.557,99.796,36.958,1.828,2.228
 836.409,105.566,534.033,64.732,-112.874,35.915,10.883,0.047,2.614,3.125,5.595,7.444,92.792,32.008,2.140,2.558
 836.909,105.597,532.715,49.934,-112.154,29.146,10.592,0.014,2.737,3.719,-1.562,10.922,87.419,28.211,2.568,3.036
 837.409,105.524,534.277,40.385,-112.703,19.500,10.397,0.007,2.806,4.159,-5.594,16.212,85.054,26.540,3.286,3.804
 837.909,105.796,532.471,32.836,-113.926,11.891,10.327,0.008,2.846,4.449,-7.950,24.132,83.495,25.438,4.389,4.980
 838.409,105.627,541.992,26.038,-115.733,7.914,10.296,0.005,2.881,4.634,-9.983,32.097,81.465,24.003,5.926,6.267
 838.909,105.770,537.158,18.466,-115.775,5.420,10.289,0.002,2.913,4.797,-11.877,35.150,82.759,24.918,7.228,7.046
 839.409,105.595,534.766,17.660,-115.179,3.692,10.304,-0.002,2.903,4.778,-11.265,29.075,90.771,30.580,6.858,6.713
 839.909,105.741,537.891,21.153,-113.849,3.227,10.333,0.001,2.848,4.536,-8.069,18.876,105.927,41.291,5.878,5.829
 840.409,105.712,531.592,30.380,-114.048,5.470,10.373,0.012,2.757,3.976,-2.733,10.383,125.660,55.237,4.720,4.877
 840.909,105.741,515.771,43.297,-115.536,10.429,10.425,0.020,2.648,3.314,3.624,5.973,139.833,65.253,3.940,4.034
 841.409,105.654,540.918,54.714,-110.970,17.780,10.484,0.023,2.571,2.877,8.140,4.624,144.003,68.200,3.305,3.430
 841.909,105.709,532.227,64.801,-105.368,24.930,10.538,0.018,2.534,2.830,10.298,4.382,143.604,67.918,2.829,2.977
 842.409,105.704,532.227,68.414,-103.312,29.302,10.609,0.027,2.528,3.169,10.669,4.446,144.320,68.424,2.541,2.758
 842.909,105.671,532.227,70.353,-103.438,30.099,10.703,0.056,2.507,3.372,11.881,4.380,148.435,71.332,2.394,2.691
 843.409,105.574,532.227,72.039,-103.228,29.025,11.227,0.093,2.452,3.416,15.096,4.252,149.628,72.175,2.440,2.817
 843.909,105.763,539.355,73.969,-103.720,29.906,11.622,0.132,2.418,3.228,17.091,4.252,139.830,65.251,2.616,3.087
 844.409,105.614,546.875,73.113,-105.397,32.854,11.401,0.138,2.455,3.076,14.889,5.902,124.192,54.199,2.953,3.459
 844.909,105.786,532.227,64.068,-106.963,33.368,11.106,0.108,2.589,3.349,7.062,11.864,109.805,44.032,3.420,3.986
 845.409,105.840,532.227,49.271,-104.136,27.707,10.554,0.065,2.770,3.808,-3.526,23.333,102.791,39.075,4.083,4.592
 845.909,105.659,535.449,33.809,-103.832,17.506,10.209,0.028,2.914,4.400,-11.946,37.879,105.415,40.929,5.058,5.508
 846.409,105.884,533.691,24.784,-105.686,8.068,10.187,0.016,2.981,4.668,-15.868,49.128,118.982,50.517,6.538,6.659
 846.909,105.653,535.938,23.241,-106.978,3.218,10.178,0.013,2.981,4.580,-15.828,50.218,147.218,70.472,8.294,7.815
 847.409,105.662,550.781,24.577,-105.187,1.799,10.164,0.004,2.946,4.457,-13.772,41.634,178.988,92.924,9.665,8.595
 847.909,105.747,517.578,26.327,-106.353,2.088,10.154,-0.002,2.884,4.355,-10.162,27.823,202.606,109.616,9.068,8.188
 848.409,105.689,517.578,29.413,-109.276,3.648,10.148,0.000,2.801,4.066,-5.349,15.762,212.522,116.624,7.573,7.280
 848.909,105.780,522.461,36.384,-109.668,7.436,10.138,0.003,2.701,3.496,0.544,9.121,205.343,111.550,6.171,6.221
 849.409,105.750,532.227,45.600,-108.843,13.483,10.125,0.004,2.612,2.909,5.753,6.351,190.764,101.246,5.121,5.317
 849.909,105.763,541.992,56.597,-107.754,20.228,10.119,0.003,2.558,2.549,8.889,5.906,178.029,92.247,4.516,4.753
 850.409,105.819,546.875,65.813,-108.177,25.412,10.110,0.002,2.529,2.439,10.568,5.928,171.362,87.535,4.160,4.496
 850.909,105.672,544.092,70.351,-106.172,28.032,10.076,0.003,2.514,2.438,11.466,5.983,174.483,89.741,4.091,4.566
 851.409,105.832,541.553,72.772,-105.866,29.580,10.018,0.004,2.515,2.401,11.384,6.231,175.310,90.325,4.286,4.869
 851.909,105.781,531.055,68.546,-108.534,31.070,9.974,0.009,2.563,2.430,8.580,7.446,163.528,81.999,4.732,5.218
 852.409,105.744,532.227,59.731,-109.392,30.806,9.955,0.013,2.641,2.551,4.042,9.718,144.869,68.812,5.139,5.194
 852.909,105.708,535.498,50.596,-107.727,26.547,9.941,0.013,2.717,2.730,-0.399,12.499,126.040,55.505,5.010,4.619
 853.409,105.635,537.109,44.191,-107.980,19.881,9.939,0.011,2.764,2.892,-3.147,14.019,114.828,47.581,4.260,3.804
 853.909,105.627,540.576,41.013,-109.403,13.551,9.946,0.012,2.748,2.960,-2.233,12.806,113.139,46.388,3.393,3.150
 854.409,105.726,544.531,46.925,-108.564,10.265,9.977,0.030,2.687,2.984,1.348,9.430,115.611,48.135,2.750,2.769
 854.909,105.720,537.109,64.851,-105.224,10.768,10.142,0.062,2.603,2.924,6.256,5.662,119.678,51.009,2.397,2.620
 855.409,105.866,544.043,88.063,-105.015,15.341,10.431,0.078,2.516,2.838,11.367,3.257,121.280,52.141,2.232,2.621
 855.909,105.764,537.109,104.599,-107.664,25.098,10.603,0.071,2.482,2.698,13.349,2.699,117.676,49.594,2.199,2.658
 856.409,105.806,543.652,100.888,-109.000,36.971,10.663,0.045,2.530,2.748,10.522,3.989,107.516,42.414,2.257,2.702
 856.909,105.884,532.910,80.384,-109.136,42.151,10.728,0.023,2.653,3.149,3.330,7.891,93.921,32.806,2.403,2.766
 857.409,105.691,534.082,55.243,-109.767,34.986,10.672,0.012,2.793,3.723,-4.869,15.002,82.369,24.642,2.703,2.965
 857.909,105.841,541.553,33.809,-111.633,20.338,10.520,0.003,2.886,4.251,-10.292,22.318,76.740,20.664,3.225,3.397
 858.409,105.878,539.893,24.646,-112.648,7.830,10.462,-0.000,2.897,4.565,-10.915,24.537,78.576,21.962,4.131,4.192
 858.909,105.734,532.471,29.253,-112.129,2.424,10.470,-0.000,2.854,4.682,-8.447,21.188,84.035,25.820,5.374,5.414
 859.409,105.825,541.992,41.707,-112.154,2.829,10.492,0.003,2.805,4.636,-5.537,15.202,87.102,27.987,6.386,6.581
 859.909,105.776,541.992,51.713,-112.359,5.553,10.526,0.004,2.777,4.543,-3.898,10.955,84.739,26.318,6.387,6.856
 860.409,105.775,551.758,51.773,-113.806,8.683,10.542,0.005,2.774,4.331,-3.736,9.204,83.154,25.197,5.343,5.796
 860.909,105.761,537.354,46.018,-115.770,10.634,10.558,0.009,2.772,4.144,-3.643,7.716,84.493,26.143,4.274,4.557
 861.409,105.708,547.559,48.542,-117.161,11.535,10.623,0.021,2.740,3.929,-1.728,5.777,90.378,30.302,3.482,3.677
 861.909,105.811,550.781,65.245,-116.926,13.227,10.734,0.030,2.668,3.529,2.462,4.095,98.364,35.946,2.903,3.050
 862.409,105.700,535.938,87.863,-114.277,17.279,10.845,0.036,2.593,3.095,6.863,3.253,104.272,40.121,2.489,2.654
 862.909,105.819,537.109,102.657,-112.915,22.670,10.920,0.040,2.543,2.737,9.790,2.858,106.624,41.783,2.168,2.358
 863.409,105.760,543.652,104.334,-110.006,27.890,10.987,0.039,2.519,2.627,11.177,2.727,105.503,40.991,1.942,2.159
 863.909,105.846,532.227,97.747,-109.126,32.080,11.031,0.047,2.495,2.679,12.567,2.617,102.766,39.057,1.795,2.030
 864.409,105.781,535.742,92.944,-108.777,34.205,11.039,0.074,2.465,2.651,14.338,2.483,101.567,38.210,1.715,1.949
 864.909,105.894,539.648,93.945,-109.002,34.980,11.432,0.095,2.435,2.547,16.098,2.414,103.048,39.257,1.685,1.901
 865.409,105.879,532.227,96.477,-108.371,35.335,11.863,0.093,2.431,2.481,16.343,2.490,104.773,40.475,1.667,1.860
 865.909,105.859,536.475,97.933,-105.463,35.487,11.551,0.069,2.459,2.446,14.696,2.676,105.089,40.699,1.652,1.834
 866.409,105.747,546.875,95.748,-104.104,35.129,11.311,0.041,2.489,2.494,12.945,2.788,102.803,39.084,1.655,1.859
 866.909,105.888,545.215,95.652,-103.112,33.245,11.439,0.035,2.502,2.599,12.163,2.693,99.757,36.931,1.698,1.958
 867.409,105.802,541.992,96.039,-103.410,31.779,11.430,0.039,2.462,2.665,14.526,2.492,98.090,35.753,1.818,2.164
 867.909,105.667,541.992,92.077,-101.137,34.765,11.260,0.055,2.405,2.684,17.841,2.488,98.118,35.773,2.029,2.483
 868.409,105.831,541.992,82.101,-102.469,39.624,11.340,0.068,2.416,2.706,17.191,3.472,99.230,36.558,2.332,2.864
 868.909,105.686,539.893,65.076,-103.820,38.639,11.577,0.058,2.535,2.997,10.238,7.194,100.038,37.129,2.738,3.296
 869.409,105.863,532.422,45.695,-105.842,29.707,11.134,0.031,2.715,3.504,-0.307,13.300,100.291,37.308,3.220,3.682
 869.909,105.789,522.461,28.316,-105.662,16.036,10.652,0.005,2.856,4.056,-8.539,18.581,101.983,38.504,3.814,4.089
 870.409,105.933,546.875,20.507,-106.274,5.576,10.657,0.001,2.914,4.294,-11.930,20.069,105.890,41.265,4.413,4.473
 870.909,105.807,546.875,24.778,-105.480,2.694,10.702,0.009,2.896,4.214,-10.867,17.199,113.055,46.328,4.809,4.734
 871.409,105.802,551.025,31.120,-104.940,3.441,10.783,0.020,2.848,4.168,-8.058,13.101,117.848,49.716,4.826,4.920
 871.909,105.855,539.941,40.602,-103.547,5.856,10.874,0.043,2.763,3.963,-3.089,9.844,118.165,49.940,4.523,4.949
 872.409,105.815,541.016,55.229,-103.055,9.358,11.158,0.082,2.639,3.692,4.179,7.578,117.891,49.746,4.259,5.093
 872.909,105.643,535.303,73.245,-103.607,16.743,11.543,0.124,2.506,3.199,11.946,6.078,119.061,50.573,4.182,5.257
 873.409,105.891,541.992,84.366,-104.282,26.904,12.143,0.126,2.441,2.820,15.720,6.569,118.779,50.374,4.280,5.305
 873.909,105.906,541.992,76.267,-105.386,33.319,11.954,0.086,2.521,3.031,11.053,9.757,110.966,44.852,4.422,5.067
 874.409,105.796,541.992,56.824,-104.784,30.662,11.017,0.034,2.681,3.637,1.696,13.874,97.149,35.087,4.441,4.568
 874.909,105.924,538.477,37.091,-102.385,19.841,10.714,0.003,2.819,4.346,-6.389,16.001,85.628,26.946,4.277,4.135
 875.409,105.736,540.771,27.320,-101.664,9.192,10.707,0.002,2.871,4.704,-9.428,14.336,81.034,23.699,4.041,3.857
 875.909,105.798,537.109,31.363,-101.690,4.960,10.747,0.013,2.829,4.506,-6.932,9.945,81.783,24.228,3.794,3.805
 876.409,105.707,541.357,44.303,-101.434,6.668,10.826,0.024,2.729,3.885,-1.126,5.830,84.852,26.397,3.591,3.879
 876.909,105.800,551.758,61.246,-96.999,12.269,10.915,0.029,2.608,3.235,5.977,3.642,87.427,28.217,3.401,3.947
 877.409,105.893,538.672,77.448,-92.163,19.731,10.986,0.028,2.518,2.809,11.223,3.161,95.983,34.264,3.198,3.825
 877.909,105.626,536.475,90.267,-92.450,26.486,11.023,0.028,2.485,2.738,13.146,3.434,112.909,46.225,3.011,3.521
 878.409,105.873,539.014,95.647,-94.237,30.123,11.052,0.030,2.511,2.901,11.656,3.846,131.099,59.081,2.840,3.189
 878.909,105.768,533.105,94.032,-98.292,30.550,11.141,0.027,2.562,3.197,8.637,4.181,143.231,67.655,2.731,2.946
 879.409,105.899,534.375,82.523,-98.702,28.521,11.125,0.021,2.612,3.621,5.752,4.246,145.082,68.962,2.687,2.881
 879.909,105.828,546.484,70.358,-97.456,25.412,11.051,0.019,2.637,3.773,4.246,3.995,144.122,68.284,2.732,2.944
 880.409,105.837,546.875,68.867,-92.974,22.915,11.086,0.025,2.627,3.650,4.849,3.541,147.035,70.343,2.864,3.171
 880.909,105.831,546.777,73.750,-87.491,23.595,11.138,0.031,2.597,3.321,6.598,3.177,151.372,73.408,3.029,3.412
 881.409,105.853,539.697,82.497,-88.718,28.380,11.165,0.025,2.583,3.039,7.418,3.439,154.029,75.286,3.158,3.554
 881.909,105.869,542.578,85.338,-92.407,32.567,11.131,0.012,2.600,3.145,6.445,4.375,154.250,75.442,3.175,3.502
 882.409,105.798,546.094,76.426,-92.964,31.002,11.045,0.005,2.637,3.502,4.295,5.335,156.480,77.018,3.127,3.342
 882.909,105.774,541.455,65.948,-93.786,24.532,10.933,0.020,2.650,3.806,3.485,5.443,162.805,81.488,3.064,3.245
 883.409,105.780,540.186,61.336,-93.693,18.318,10.888,0.054,2.614,3.654,5.624,4.555,170.484,86.915,3.043,3.218
 883.909,105.830,556.641,65.020,-97.763,17.102,11.109,0.078,2.558,3.175,8.889,3.448,177.012,91.528,3.037,3.250
 884.409,105.917,553.320,72.485,-99.533,20.582,11.118,0.075,2.525,2.806,10.803,2.850,179.168,93.052,2.950,3.167
 884.909,105.960,541.992,72.029,-101.643,24.895,10.946,0.051,2.522,2.839,10.970,2.780,179.670,93.407,2.772,2.986
 885.409,105.798,545.557,65.547,-102.576,27.525,10.985,0.035,2.537,3.043,10.107,2.807,180.814,94.215,2.546,2.769
 885.909,105.759,552.979,63.019,-99.105,27.316,11.025,0.038,2.542,3.096,9.799,2.771,180.347,93.885,2.357,2.579
 886.409,105.859,556.641,67.201,-96.642,26.192,11.077,0.058,2.516,3.028,11.366,2.616,176.709,91.314,2.266,2.506
 886.909,105.893,546.875,77.583,-95.930,27.655,11.103,0.092,2.470,2.896,14.060,2.357,169.870,86.480,2.255,2.508
 887.409,105.802,546.875,84.069,-98.387,33.191,11.165,0.106,2.432,2.750,16.259,2.221,162.715,81.424,2.312,2.588
 887.909,105.658,543.701,78.946,-97.207,39.030,11.252,0.090,2.462,2.701,14.493,2.379,158.289,78.296,2.403,2.702
 888.409,105.836,542.627,69.264,-95.956,39.686,11.130,0.054,2.545,2.758,9.622,2.758,154.462,75.591,2.495,2.780
 888.909,105.877,545.801,57.885,-93.448,34.075,10.930,0.025,2.617,2.822,5.412,3.193,146.519,69.978,2.611,2.874
 889.409,105.716,551.758,50.051,-95.061,26.303,10.838,0.017,2.652,2.758,3.416,3.506,135.059,61.879,2.743,2.971
 889.909,105.835,547.461,46.544,-96.494,21.281,10.767,0.016,2.643,2.567,3.933,3.617,126.866,56.089,2.919,3.132
 890.409,105.752,546.729,45.799,-99.103,19.394,10.699,0.018,2.635,2.442,4.400,3.543,124.219,54.218,3.122,3.347
 890.909,105.833,541.992,51.341,-99.717,19.332,10.689,0.021,2.634,2.431,4.458,3.350,126.363,55.734,3.304,3.552
 891.409,105.869,542.041,57.139,-101.197,19.902,10.682,0.025,2.635,2.432,4.401,3.210,128.426,57.192,3.442,3.741
 891.909,105.821,546.875,59.046,-100.246,20.363,10.669,0.025,2.642,2.455,3.984,3.275,127.030,56.205,3.483,3.790
 892.409,105.829,551.465,56.227,-100.746,20.167,10.674,0.019,2.644,2.555,3.887,3.483,124.925,54.717,3.464,3.745
 892.909,105.791,549.756,53.816,-103.028,19.254,10.685,0.013,2.642,2.695,3.969,3.648,123.945,54.025,3.425,3.644
 893.409,105.904,551.758,56.900,-103.633,18.103,10.690,0.013,2.642,2.769,3.981,3.653,123.849,53.957,3.391,3.555
 893.909,105.733,548.682,60.704,-102.880,17.575,10.691,0.016,2.642,2.676,4.000,3.482,124.471,54.396,3.373,3.513
 894.409,105.759,546.875,59.969,-100.856,17.961,10.692,0.022,2.647,2.564,3.707,3.290,125.187,54.902,3.348,3.476
 894.909,105.844,550.195,55.315,-101.447,18.791,10.685,0.022,2.643,2.536,3.894,3.213,127.427,56.485,3.298,3.428
 895.409,105.743,556.641,51.901,-103.824,19.408,10.691,0.016,2.627,2.564,4.866,3.203,131.507,59.369,3.212,3.345
 895.909,105.922,545.947,52.983,-106.059,19.448,10.729,0.013,2.609,2.616,5.898,3.161,135.434,62.144,3.101,3.234
 896.409,105.821,545.654,53.055,-105.541,19.540,10.778,0.019,2.609,2.649,5.901,3.043,138.953,64.631,2.983,3.113
 896.909,105.930,541.992,51.126,-104.973,20.187,10.820,0.027,2.622,2.642,5.155,2.890,141.496,66.428,2.871,2.994
 897.409,105.882,545.410,50.870,-103.838,20.957,10.858,0.026,2.622,2.645,5.161,2.750,143.865,68.103,2.768,2.895
 897.909,105.885,541.992,54.021,-104.378,21.828,10.899,0.017,2.606,2.653,6.080,2.619,147.443,70.631,2.677,2.813
 898.409,105.773,554.932,59.486,-105.038,23.052,10.951,0.009,2.589,2.650,7.075,2.509,152.312,74.072,2.594,2.748
 898.909,105.907,547.510,65.136,-106.187,24.797,10.947,0.009,2.592,2.667,6.873,2.434,159.020,78.813,2.532,2.692
 899.409,105.878,546.875,69.167,-107.856,26.943,10.907,0.014,2.615,2.668,5.585,2.425,166.412,84.036,2.486,2.650
 899.909,105.868,537.891,70.390,-109.336,28.564,10.908,0.018,2.636,2.659,4.338,2.455,171.714,87.783,2.459,2.612
 900.409,105.798,539.307,67.466,-110.131,28.627,10.895,0.019,2.640,2.652,4.121,2.480,174.387,89.673,2.447,2.588
 900.909,105.952,546.729,63.132,-108.886,27.317,10.871,0.021,2.630,2.671,4.652,2.476,174.498,89.751,2.439,2.565
 901.409,105.682,546.875,60.518,-108.304,25.340,10.865,0.023,2.616,2.733,5.498,2.448,173.003,88.695,2.427,2.539
 901.909,105.773,546.973,58.343,-107.945,24.071,10.846,0.027,2.615,2.795,5.539,2.406,170.883,87.196,2.400,2.507
 902.409,105.877,551.758,55.007,-108.101,24.279,10.827,0.030,2.621,2.810,5.200,2.348,165.850,83.640,2.360,2.464
 902.909,105.865,547.217,52.159,-107.571,25.059,10.883,0.028,2.620,2.774,5.270,2.258,160.370,79.767,2.310,2.421
 903.409,105.868,548.877,48.274,-110.819,25.654,10.853,0.023,2.615,2.781,5.551,2.134,158.749,78.621,2.260,2.373
 903.909,105.853,547.949,43.540,-114.110,25.727,10.742,0.020,2.614,2.789,5.613,2.035,159.383,79.069,2.207,2.319
 904.409,105.796,556.641,37.827,-116.866,25.156,10.701,0.025,2.628,2.831,4.816,1.989,158.716,78.598,2.151,2.254
 904.909,105.834,546.875,35.468,-114.548,23.949,10.686,0.034,2.647,2.847,3.675,1.975,154.673,75.741,2.085,2.175
 905.409,105.792,556.982,39.980,-116.396,22.515,10.681,0.039,2.657,2.815,3.125,1.965,149.245,71.905,2.013,2.091
 905.909,105.985,537.109,45.023,-117.262,21.734,10.681,0.037,2.645,2.788,3.817,1.927,148.763,71.564,1.937,2.009
 906.409,105.992,533.545,48.773,-119.934,21.846,10.682,0.033,2.628,2.772,4.809,1.857,154.850,75.865,1.865,1.936
 906.909,105.894,550.488,49.676,-119.762,22.878,10.688,0.031,2.610,2.795,5.872,1.765,158.165,78.209,1.799,1.878
 907.409,105.896,546.875,49.077,-120.866,24.417,10.705,0.032,2.587,2.805,7.212,1.669,153.392,74.836,1.745,1.840
 907.909,105.900,548.389,49.321,-121.739,26.006,10.749,0.035,2.560,2.810,8.781,1.612,144.291,68.403,1.713,1.834
 908.409,105.734,551.758,50.746,-120.007,27.619,10.806,0.035,2.540,2.770,9.925,1.610,137.555,63.643,1.718,1.871
 908.909,105.915,542.236,52.911,-120.824,29.253,10.753,0.035,2.542,2.710,9.845,1.647,137.367,63.511,1.778,1.971
 909.409,105.861,538.867,52.743,-122.311,31.098,10.632,0.033,2.559,2.692,8.856,1.754,133.105,60.499,1.903,2.125
 909.909,105.918,544.922,52.304,-123.586,32.471,10.566,0.028,2.584,2.715,7.380,2.113,118.251,50.001,2.094,2.317
 910.409,105.862,547.559,53.473,-122.321,31.821,10.514,0.023,2.619,2.770,5.316,2.816,101.540,38.191,2.322,2.489
 910.909,105.829,553.467,57.426,-122.726,28.145,10.457,0.018,2.657,2.841,3.100,3.634,90.614,30.469,2.517,2.579
 911.409,105.879,542.578,59.119,-123.806,22.825,10.419,0.013,2.674,2.915,2.094,4.063,86.005,27.212,2.610,2.577
 911.909,105.904,546.875,57.066,-123.685,17.986,10.435,0.017,2.664,2.984,2.669,3.708,82.558,24.776,2.539,2.479
 912.409,105.729,551.953,56.408,-121.813,15.718,10.486,0.025,2.637,3.024,4.294,2.897,78.429,21.858,2.353,2.336
 912.909,105.866,561.523,59.835,-121.279,17.176,10.571,0.032,2.599,2.982,6.470,2.075,76.618,20.578,2.107,2.152
 913.409,105.766,541.309,66.415,-123.659,20.638,10.671,0.036,2.564,2.920,8.549,1.537,77.715,21.353,1.863,1.960
 913.909,105.992,537.988,70.080,-123.745,24.215,10.767,0.036,2.533,2.856,10.375,1.282,80.109,23.045,1.655,1.771
 914.409,105.939,541.992,68.346,-124.947,26.647,10.841,0.034,2.511,2.785,11.625,1.190,81.561,24.072,1.487,1.598
 914.909,105.880,535.742,63.534,-127.743,28.371,10.886,0.031,2.502,2.767,12.152,1.193,80.961,23.647,1.369,1.465
 915.409,105.845,536.377,58.054,-131.281,29.762,10.909,0.025,2.493,2.797,12.693,1.205,79.208,22.408,1.286,1.366
 915.909,105.878,556.641,54.919,-132.573,30.493,10.914,0.023,2.490,2.815,12.860,1.206,79.757,22.796,1.235,1.308
 916.409,105.919,537.109,56.456,-132.652,30.564,10.914,0.025,2.494,2.794,12.636,1.198,82.956,25.057,1.207,1.278
 916.909,105.915,544.336,60.781,-133.491,30.042,10.916,0.025,2.493,2.705,12.661,1.173,88.893,29.253,1.198,1.275
 917.409,105.853,541.992,63.863,-133.796,29.647,10.927,0.020,2.483,2.639,13.257,1.131,95.634,34.017,1.206,1.294
 917.909,105.849,557.422,64.284,-133.690,29.999,10.947,0.016,2.470,2.652,14.008,1.100,100.184,37.232,1.224,1.324
 918.409,105.883,546.875,63.431,-131.710,31.257,10.971,0.019,2.474,2.675,13.797,1.136,100.742,37.627,1.251,1.362
 918.909,105.866,546.875,62.265,-129.736,32.592,10.994,0.026,2.492,2.738,12.740,1.232,99.299,36.607,1.286,1.403
 919.409,105.884,548.242,62.163,-126.194,33.281,11.023,0.032,2.513,2.775,11.535,1.324,97.142,35.082,1.337,1.450
 919.909,105.754,541.992,61.193,-122.607,33.326,11.059,0.033,2.522,2.824,10.983,1.369,97.423,35.281,1.399,1.499
 920.409,105.968,548.877,60.501,-119.377,33.157,11.099,0.031,2.518,2.840,11.245,1.382,100.004,37.105,1.455,1.526
 920.909,105.900,551.758,59.374,-119.070,33.268,11.123,0.028,2.510,2.831,11.716,1.400,102.019,38.529,1.484,1.524
 921.409,105.756,547.363,55.835,-120.310,33.005,11.135,0.028,2.502,2.794,12.143,1.384,102.073,38.568,1.467,1.496
 921.909,105.857,556.348,55.842,-123.513,32.225,11.156,0.030,2.496,2.767,12.534,1.304,98.160,35.802,1.426,1.470
 922.409,105.874,551.758,56.797,-126.553,32.035,11.188,0.034,2.485,2.787,13.168,1.166,91.975,31.431,1.387,1.473
 922.909,105.833,556.348,57.668,-129.766,32.456,11.221,0.033,2.469,2.725,14.088,1.052,86.643,27.663,1.363,1.486
 923.409,105.939,546.875,58.310,-131.652,32.525,11.243,0.031,2.469,2.667,14.100,1.073,83.503,25.443,1.362,1.499
 923.909,106.073,546.533,57.350,-130.616,31.433,11.266,0.032,2.490,2.712,12.840,1.198,81.957,24.351,1.372,1.498
 924.409,105.865,550.781,55.614,-127.596,29.436,11.298,0.036,2.517,2.816,11.287,1.348,81.631,24.121,1.386,1.488
 924.909,105.926,557.227,54.345,-122.216,28.903,11.321,0.039,2.530,2.901,10.552,1.450,81.081,23.732,1.406,1.490
 925.409,105.879,558.350,56.036,-118.508,30.824,11.320,0.035,2.524,2.873,10.892,1.502,80.815,23.544,1.433,1.510
 925.909,105.735,556.641,60.086,-117.871,33.096,11.300,0.029,2.517,2.812,11.266,1.517,82.089,24.444,1.476,1.564
 926.409,105.883,546.533,63.611,-121.905,34.022,11.259,0.023,2.509,2.795,11.767,1.474,85.710,27.003,1.541,1.662
 926.909,105.764,537.109,61.899,-127.086,33.886,11.177,0.017,2.494,2.770,12.649,1.400,90.716,30.542,1.638,1.806
 927.409,105.872,547.949,56.177,-129.695,33.572,11.053,0.009,2.467,2.769,14.201,1.391,94.406,33.149,1.768,1.986
 927.909,105.967,571.289,51.086,-130.488,32.825,10.949,0.005,2.449,2.721,15.238,1.633,95.917,34.217,1.915,2.133
 928.409,105.982,555.859,50.400,-128.603,30.509,10.891,0.007,2.465,2.796,14.307,2.208,95.796,34.131,2.047,2.204
 928.909,105.812,553.271,56.324,-125.433,26.270,10.813,0.015,2.510,3.050,11.681,2.838,97.238,35.150,2.114,2.186
 929.409,105.865,556.641,59.766,-120.734,21.353,10.773,0.023,2.556,3.364,8.987,3.120,103.993,39.924,2.112,2.135
 929.909,105.803,545.508,56.231,-117.980,17.797,10.836,0.032,2.577,3.517,7.803,2.786,112.314,45.805,2.064,2.102
 930.409,105.866,560.449,50.333,-116.136,17.155,10.940,0.041,2.566,3.337,8.407,2.105,119.138,50.628,1.994,2.073
 930.909,105.954,559.521,46.328,-116.620,20.491,11.048,0.041,2.536,3.015,10.147,1.563,123.585,53.770,1.904,2.022
 931.409,105.868,552.100,46.519,-118.579,25.564,11.128,0.033,2.506,2.759,11.906,1.333,125.922,55.422,1.791,1.924
 931.909,105.942,545.020,49.075,-119.586,29.499,11.178,0.023,2.487,2.714,13.020,1.355,128.343,57.133,1.663,1.794
 932.409,105.979,551.465,54.947,-119.604,30.905,11.202,0.021,2.486,2.776,13.107,1.432,130.504,58.660,1.555,1.687
 932.909,105.957,541.992,63.522,-115.998,30.096,11.205,0.025,2.494,2.818,12.611,1.480,130.058,58.345,1.500,1.641
 933.409,105.921,551.904,69.789,-114.472,29.857,11.200,0.028,2.502,2.790,12.136,1.490,128.198,57.030,1.509,1.668
 933.909,105.764,556.641,69.734,-113.491,31.730,11.188,0.026,2.501,2.683,12.209,1.476,125.145,54.873,1.599,1.782
 934.409,105.999,550.977,65.561,-115.098,35.113,11.165,0.023,2.508,2.590,11.813,1.551,120.558,51.631,1.748,1.957
 934.909,105.927,547.852,62.452,-112.336,37.277,11.125,0.021,2.559,2.629,8.852,2.115,114.967,47.680,1.950,2.181
 935.409,106.003,553.027,55.394,-112.486,35.142,11.092,0.017,2.652,2.970,3.380,3.323,110.804,44.738,2.173,2.418
 935.909,105.749,545.654,45.304,-112.247,28.001,11.054,0.013,2.744,3.520,-1.979,4.590,111.503,45.232,2.439,2.675
 936.409,105.977,561.523,37.956,-112.116,19.066,11.022,0.013,2.791,3.949,-4.749,5.309,116.374,48.674,2.745,2.970
 936.909,105.910,558.105,35.301,-109.516,12.526,11.019,0.018,2.785,4.209,-4.414,5.311,120.616,51.672,3.099,3.269
 937.409,105.835,556.641,40.027,-108.939,10.319,11.020,0.026,2.761,4.212,-2.969,4.872,120.399,51.519,3.356,3.460
 937.909,105.757,560.303,44.828,-110.484,11.078,11.022,0.031,2.744,4.062,-2.007,4.541,118.817,50.401,3.363,3.394
 938.409,105.935,557.568,47.414,-111.072,12.825,11.023,0.033,2.741,4.078,-1.821,4.128,121.570,52.346,3.127,3.148
 938.909,105.780,546.875,55.612,-107.576,14.342,11.025,0.037,2.732,3.962,-1.291,3.434,127.954,56.858,2.789,2.837
 939.409,105.897,556.641,66.754,-107.868,15.856,11.013,0.038,2.690,3.688,1.180,2.704,132.152,59.825,2.490,2.557
 939.909,106.012,556.641,76.064,-112.435,18.995,10.960,0.032,2.625,3.353,4.993,2.052,128.371,57.153,2.243,2.316
 940.409,105.913,551.758,73.962,-118.407,23.471,10.911,0.023,2.573,3.116,8.032,1.750,117.557,49.510,2.042,2.102
 940.909,105.979,547.412,65.553,-119.599,26.751,10.902,0.018,2.557,3.175,8.934,1.703,106.994,42.045,1.876,1.937
 941.409,105.935,546.875,62.628,-118.714,27.647,10.911,0.025,2.559,3.184,8.846,1.632,100.631,37.549,1.750,1.820
 941.909,105.970,546.875,66.000,-117.260,27.423,10.924,0.036,2.549,3.006,9.392,1.508,98.442,36.002,1.661,1.744
 942.409,105.967,553.613,75.479,-117.774,28.464,10.926,0.040,2.529,2.777,10.557,1.418,96.933,34.935,1.609,1.693
 942.909,106.049,561.523,82.583,-117.602,30.704,10.920,0.034,2.510,2.714,11.700,1.403,94.349,33.109,1.571,1.647
 943.409,105.927,546.875,85.499,-118.126,31.966,10.899,0.026,2.495,2.768,12.598,1.419,90.812,30.609,1.545,1.617
 943.909,106.005,556.641,89.820,-118.465,32.215,10.883,0.024,2.481,2.831,13.367,1.395,88.191,28.757,1.525,1.599
 944.409,105.966,556.641,95.872,-115.625,32.101,10.883,0.027,2.476,2.851,13.669,1.334,88.374,28.886,1.511,1.590
 944.909,105.843,561.133,100.109,-112.150,32.417,10.879,0.026,2.483,2.792,13.249,1.299,89.652,29.789,1.502,1.577
 945.409,105.816,559.619,97.370,-110.518,33.138,10.837,0.024,2.502,2.746,12.153,1.318,90.109,30.112,1.486,1.556
 945.909,105.792,561.523,89.660,-109.572,33.539,10.790,0.024,2.512,2.717,11.585,1.330,89.824,29.911,1.464,1.534
 946.409,106.020,558.350,86.088,-110.187,33.461,10.767,0.029,2.501,2.727,12.211,1.294,89.498,29.680,1.440,1.521
 946.909,105.845,557.520,84.926,-111.283,32.973,10.726,0.029,2.482,2.729,13.345,1.239,89.182,29.457,1.416,1.506
 947.409,106.012,558.105,83.843,-112.744,32.937,10.674,0.024,2.467,2.701,14.194,1.198,88.763,29.161,1.394,1.473
 947.909,105.919,556.641,86.244,-111.884,33.641,10.647,0.022,2.461,2.702,14.557,1.172,88.963,29.302,1.353,1.407
 948.409,105.971,556.641,93.044,-109.857,35.028,10.648,0.033,2.453,2.789,15.006,1.149,90.994,30.738,1.281,1.308
 948.909,105.760,556.641,102.286,-110.451,37.156,10.648,0.057,2.448,2.831,15.343,1.105,94.150,32.968,1.185,1.201
 949.409,105.956,556.641,99.821,-117.185,38.702,10.602,0.066,2.430,2.805,16.369,1.030,95.569,33.971,1.084,1.105
 949.909,105.792,559.766,81.266,-125.670,39.330,10.507,0.054,2.410,2.730,17.548,0.932,93.875,32.774,1.006,1.041
 950.409,106.029,566.406,57.509,-130.793,39.671,10.433,0.030,2.391,2.660,18.656,0.824,90.534,30.413,0.954,1.010
 950.909,105.794,555.371,41.144,-132.640,40.788,10.407,0.014,2.388,2.648,18.851,0.769,88.890,29.251,0.928,1.005
 951.409,105.935,561.523,37.056,-132.471,42.846,10.389,0.013,2.406,2.682,17.792,0.805,90.229,30.197,0.925,1.020
 951.909,105.849,563.574,41.335,-130.486,43.406,10.379,0.012,2.422,3.015,16.837,0.932,94.161,32.976,0.945,1.052
 952.409,105.929,561.816,48.292,-125.179,41.953,10.370,0.017,2.412,3.491,17.406,1.079,99.967,37.079,0.993,1.113
 952.909,105.959,561.523,61.671,-119.912,40.181,10.334,0.038,2.376,3.604,19.535,1.186,105.892,41.267,1.089,1.223
 953.409,105.859,551.855,75.689,-115.057,39.568,10.333,0.055,2.336,3.347,21.875,1.330,110.393,44.448,1.230,1.380
 953.909,105.884,556.738,80.721,-114.261,39.485,10.102,0.054,2.317,2.875,22.999,1.640,110.946,44.838,1.437,1.596
 954.409,105.866,566.406,74.480,-113.934,37.429,9.700,0.044,2.339,2.515,21.672,2.141,108.594,43.176,1.672,1.832
 954.909,105.938,566.406,58.547,-114.930,31.960,9.433,0.037,2.399,2.413,18.190,2.621,107.116,42.132,1.905,2.061
 955.409,105.964,569.971,46.358,-117.232,25.180,9.188,0.044,2.472,2.333,13.927,2.773,108.606,43.185,2.097,2.255
 955.909,105.962,556.641,40.159,-119.481,19.592,9.172,0.048,2.535,2.300,10.216,2.590,109.284,43.663,2.226,2.377
 956.409,105.867,556.006,35.211,-119.688,16.609,9.327,0.039,2.566,2.382,8.401,2.315,105.678,41.115,2.301,2.431
 956.909,106.000,551.758,32.603,-119.171,16.308,9.468,0.028,2.565,2.450,8.481,2.138,100.247,37.277,2.300,2.404
 957.409,105.908,554.395,32.958,-118.465,17.331,9.604,0.023,2.550,2.446,9.337,2.028,101.577,38.217,2.250,2.349
 957.909,105.825,562.939,36.965,-116.090,18.863,9.739,0.026,2.530,2.444,10.555,1.880,110.809,44.741,2.167,2.288
 958.409,106.018,556.641,43.399,-113.009,21.031,9.869,0.033,2.521,2.416,11.040,1.768,120.734,51.756,2.095,2.233
 958.909,105.963,552.979,54.016,-107.573,24.100,9.990,0.036,2.524,2.417,10.904,1.769,126.424,55.777,2.050,2.194
 959.409,105.979,546.875,67.410,-103.653,27.170,10.105,0.033,2.528,2.476,10.625,1.847,125.990,55.470,2.033,2.173
 959.909,105.793,546.875,82.318,-100.170,29.030,10.207,0.029,2.541,2.571,9.904,1.928,122.412,52.941,2.047,2.190
 960.409,105.955,554.980,91.710,-99.764,29.499,10.291,0.023,2.548,2.750,9.462,1.988,115.834,48.293,2.089,2.245
 960.909,105.878,561.523,88.683,-99.761,29.273,10.340,0.017,2.553,2.928,9.190,2.049,107.888,42.677,2.156,2.327
 961.409,105.911,561.523,79.991,-101.610,29.085,10.327,0.013,2.553,3.004,9.191,2.146,102.059,38.557,2.236,2.418
 961.909,106.006,561.523,70.770,-99.021,29.407,10.292,0.011,2.550,3.003,9.365,2.277,99.442,36.708,2.317,2.503
 962.409,105.906,567.188,65.207,-98.606,30.005,10.285,0.011,2.548,2.962,9.459,2.393,99.322,36.623,2.382,2.575
 962.909,105.988,570.801,63.969,-97.765,30.332,10.295,0.013,2.546,2.916,9.613,2.449,99.054,36.434,2.433,2.632
 963.409,105.897,557.520,61.785,-97.301,29.472,10.315,0.018,2.549,2.867,9.428,2.428,98.280,35.887,2.469,2.676
 963.909,105.895,580.664,60.817,-93.773,28.218,10.327,0.022,2.552,2.868,9.233,2.397,96.730,34.791,2.492,2.704
 964.409,105.981,573.438,61.955,-93.265,28.017,10.334,0.019,2.545,2.872,9.626,2.398,96.020,34.290,2.506,2.723
 964.909,105.903,561.133,63.749,-93.261,28.725,10.340,0.016,2.539,2.832,9.976,2.404,96.585,34.689,2.513,2.746
 965.409,105.988,551.758,64.355,-95.372,29.343,10.345,0.012,2.532,2.762,10.427,2.392,97.097,35.051,2.534,2.788
 965.909,105.897,552.197,64.255,-92.959,29.278,10.346,0.011,2.528,2.767,10.653,2.389,97.584,35.395,2.574,2.859
 966.409,105.937,556.641,64.093,-94.282,29.014,10.329,0.012,2.528,2.879,10.624,2.478,97.533,35.359,2.649,2.957
 966.909,106.003,555.957,64.215,-96.503,28.947,10.294,0.008,2.524,3.034,10.887,2.664,96.489,34.621,2.763,3.086
 967.409,105.904,554.980,64.051,-100.267,28.428,10.232,0.006,2.528,3.136,10.672,2.895,94.408,33.151,2.910,3.251
 967.909,105.971,557.568,62.007,-100.435,27.055,10.150,0.004,2.530,3.208,10.546,3.138,91.051,30.778,3.103,3.458
 968.409,105.969,558.057,58.271,-99.739,25.186,10.072,0.002,2.531,3.269,10.464,3.422,86.225,27.367,3.335,3.716
 968.909,105.934,561.523,53.915,-101.301,23.298,10.014,0.001,2.535,3.340,10.215,3.763,81.047,23.708,3.608,3.997
 969.409,105.959,557.813,50.009,-103.885,21.464,9.989,0.004,2.547,3.429,9.528,4.102,76.589,20.558,3.904,4.296
 969.909,106.065,571.289,47.728,-105.361,19.463,9.992,0.011,2.565,3.453,8.495,4.373,74.027,18.747,4.195,4.578
 970.409,106.036,559.424,46.182,-105.993,17.472,10.013,0.016,2.575,3.465,7.885,4.547,72.862,17.924,4.449,4.822
 970.909,105.872,559.912,45.663,-105.398,15.772,10.045,0.016,2.569,3.470,8.266,4.622,72.170,17.435,4.642,5.015
 971.409,106.017,556.641,45.952,-105.098,14.534,10.077,0.014,2.558,3.473,8.913,4.630,71.930,17.265,4.780,5.140
 971.909,105.882,559.180,46.192,-103.043,14.349,10.126,0.012,2.551,3.461,9.293,4.582,72.130,17.406,4.865,5.221
 972.409,106.074,571.289,50.178,-103.140,15.221,10.200,0.013,2.552,3.430,9.240,4.481,72.750,17.844,4.920,5.276
 972.909,105.988,567.090,54.942,-101.801,16.545,10.279,0.016,2.564,3.407,8.559,4.379,73.577,18.429,4.944,5.308
 973.409,106.064,556.885,58.468,-102.080,17.730,10.345,0.017,2.573,3.432,8.037,4.368,74.015,18.739,4.955,5.333
 973.909,105.876,558.936,61.714,-101.919,18.456,10.386,0.015,2.583,3.482,7.422,4.504,73.331,18.255,4.962,5.350
 974.409,105.762,561.523,64.391,-103.551,18.656,10.406,0.013,2.594,3.567,6.766,4.629,71.996,17.312,5.003,5.401
 974.909,105.985,556.641,68.595,-105.967,18.346,10.412,0.013,2.601,3.674,6.352,4.564,71.026,16.626,5.077,5.465
 975.409,106.027,561.523,70.931,-107.093,17.705,10.415,0.016,2.606,3.753,6.063,4.481,70.690,16.389,5.129,5.447
 975.909,105.925,567.090,66.986,-110.608,16.827,10.416,0.019,2.607,3.908,6.024,4.570,70.393,16.179,5.053,5.240
 976.409,106.017,570.410,60.158,-114.538,15.637,10.420,0.021,2.606,4.140,6.108,4.696,69.311,15.414,4.801,4.874
 976.909,105.995,567.578,54.358,-119.172,14.035,10.437,0.021,2.592,4.366,6.891,4.513,67.513,14.144,4.433,4.493
 977.409,106.041,571.289,51.564,-122.584,12.879,10.474,0.021,2.571,4.447,8.145,3.938,65.933,13.027,4.073,4.213
 977.909,105.894,564.746,53.929,-126.364,13.141,10.515,0.021,2.549,4.412,9.422,3.246,65.016,12.379,3.813,4.083
 978.409,105.996,551.758,61.012,-130.319,14.563,10.531,0.020,2.534,4.419,10.283,2.814,64.557,12.055,3.672,4.081
 978.909,105.923,565.625,68.746,-135.472,16.242,10.533,0.020,2.534,4.453,10.314,2.787,64.184,11.791,3.654,4.165
 979.409,106.025,561.523,68.919,-137.237,17.047,10.535,0.018,2.538,4.446,10.044,3.163,63.511,11.316,3.747,4.311
 979.909,105.992,561.523,57.741,-138.806,16.736,10.535,0.016,2.552,4.412,9.267,3.883,62.398,10.529,3.949,4.498
 980.409,105.876,562.939,44.441,-139.933,15.754,10.477,0.018,2.568,4.514,8.311,4.762,60.919,9.483,4.265,4.737
 980.909,105.964,566.406,36.129,-139.739,14.386,10.356,0.019,2.562,4.685,8.651,5.584,59.322,8.354,4.659,5.023
 981.409,105.978,566.406,34.536,-140.440,12.922,10.289,0.025,2.541,4.545,9.894,6.053,58.025,7.438,5.064,5.306
 981.909,105.762,570.605,37.358,-140.092,11.372,10.302,0.037,2.521,4.138,11.054,5.906,57.393,6.992,5.333,5.512
 982.409,105.955,561.523,45.874,-140.736,10.000,10.380,0.052,2.527,3.832,10.689,5.165,57.768,7.256,5.306,5.476
 982.909,105.792,561.523,62.059,-139.532,9.593,10.496,0.059,2.549,3.781,9.391,4.207,58.963,8.101,4.994,5.201
 983.409,106.018,556.641,84.301,-139.131,10.720,10.608,0.047,2.555,4.090,9.076,3.489,60.467,9.164,4.463,4.714
 983.909,106.000,565.918,110.590,-138.826,12.690,10.717,0.027,2.541,4.421,9.869,3.093,61.792,10.101,3.933,4.212
 984.409,105.965,561.523,124.606,-140.094,14.785,10.808,0.014,2.518,4.622,11.239,2.804,62.904,10.886,3.493,3.827
 984.909,105.941,561.523,124.601,-137.033,16.340,10.880,0.014,2.504,4.697,12.046,2.512,63.995,11.657,3.197,3.567
 985.409,105.932,566.406,112.127,-136.251,17.296,10.941,0.020,2.501,4.527,12.210,2.304,65.122,12.454,3.040,3.436
 985.909,105.981,561.523,96.216,-134.567,17.999,10.993,0.024,2.505,4.309,11.992,2.256,66.188,13.207,2.960,3.321
 986.409,106.076,561.523,88.224,-133.780,18.259,11.041,0.025,2.514,4.194,11.439,2.394,67.181,13.909,2.898,3.162
 986.909,105.998,566.406,80.477,-129.507,18.083,11.088,0.027,2.530,4.132,10.512,2.578,68.160,14.600,2.798,2.942
 987.409,105.995,566.406,74.106,-124.601,17.653,11.128,0.028,2.546,4.042,9.608,2.641,69.475,15.530,2.629,2.695
 987.909,105.986,580.322,73.567,-120.943,17.326,11.164,0.027,2.549,3.865,9.401,2.475,71.608,17.038,2.429,2.478
 988.409,106.119,572.900,78.765,-118.782,17.858,11.207,0.026,2.536,3.608,10.179,2.112,74.879,19.349,2.239,2.320
 988.909,105.865,571.289,82.820,-114.439,20.115,11.247,0.026,2.514,3.324,11.460,1.741,78.931,22.213,2.088,2.226
 989.409,106.019,571.289,81.938,-111.824,24.457,11.279,0.029,2.492,3.042,12.776,1.499,83.209,25.236,1.991,2.188
 989.909,105.860,571.289,76.909,-110.429,29.930,11.299,0.039,2.488,2.899,12.962,1.439,86.830,27.795,1.948,2.189
 990.409,106.122,567.529,72.315,-110.613,34.363,11.306,0.046,2.503,2.921,12.102,1.571,88.982,29.316,1.958,2.212
 990.909,105.881,566.406,70.567,-106.752,35.742,11.283,0.043,2.522,3.077,11.001,1.883,88.728,29.137,2.014,2.247
 991.409,105.841,566.406,66.239,-103.676,33.690,11.234,0.033,2.543,3.251,9.754,2.302,85.868,27.115,2.112,2.294
 991.909,105.853,564.844,61.135,-103.827,29.368,11.212,0.026,2.567,3.359,8.385,2.659,82.504,24.738,2.239,2.371
 992.409,105.993,571.289,57.965,-106.751,25.171,11.232,0.029,2.592,3.433,6.920,2.796,81.007,23.680,2.381,2.479
 992.909,105.903,563.428,58.922,-107.888,22.733,11.271,0.036,2.606,3.469,6.072,2.680,82.314,24.604,2.507,2.614
 993.409,105.981,561.963,63.736,-107.977,22.839,11.319,0.040,2.604,3.441,6.224,2.448,85.509,26.861,2.603,2.748
 993.909,106.019,563.623,67.936,-107.064,25.360,11.371,0.038,2.585,3.362,7.286,2.252,89.041,29.358,2.652,2.837
 994.409,106.020,557.031,70.058,-106.068,28.326,11.417,0.035,2.571,3.240,8.145,2.156,93.372,32.419,2.660,2.863
 994.909,105.960,563.672,69.465,-104.722,29.742,11.459,0.032,2.563,3.222,8.572,2.157,100.824,37.685,2.617,2.787
 995.409,105.903,556.836,67.841,-104.546,29.504,11.502,0.033,2.567,3.343,8.389,2.181,108.973,43.444,2.520,2.636
 995.909,105.924,576.172,70.135,-105.996,28.231,11.559,0.037,2.573,3.545,8.013,2.165,114.349,47.243,2.356,2.428
 996.409,106.013,571.289,74.356,-109.494,26.968,11.633,0.045,2.542,3.770,9.827,2.041,117.731,49.633,2.166,2.224
 996.909,106.085,565.625,81.542,-112.625,26.220,11.743,0.073,2.416,3.846,17.178,1.767,124.462,54.390,1.966,2.054
 997.409,106.073,561.035,87.342,-115.547,26.554,11.942,0.110,2.197,3.613,30.026,1.449,135.610,62.269,1.791,1.921
 997.909,105.913,559.717,89.938,-116.912,29.398,12.534,0.138,1.931,3.055,45.543,1.194,145.385,69.177,1.652,1.824
 998.409,106.098,562.256,93.255,-116.608,35.807,12.995,0.143,1.732,2.489,57.203,1.061,148.113,71.105,1.541,1.733
 998.909,106.028,566.406,96.560,-116.760,44.814,13.012,0.123,1.682,2.219,60.110,1.032,143.026,67.509,1.464,1.648
 999.409,106.044,566.406,100.321,-116.526,51.665,13.000,0.098,1.767,2.312,55.138,1.050,135.553,62.228,1.404,1.559
 999.909,106.013,573.438,104.799,-115.939,54.481,12.934,0.084,1.936,2.598,45.237,1.112,127.643,56.638,1.361,1.474
 1000.409,105.973,567.627,107.048,-113.566,53.568,12.813,0.088,2.134,2.899,33.673,1.192,119.766,51.071,1.330,1.409
 1000.909,106.017,571.289,105.270,-114.031,49.837,12.590,0.108,2.308,3.086,23.509,1.237,110.519,44.536,1.309,1.368
 1001.409,105.892,567.822,99.111,-117.828,45.967,12.427,0.112,2.412,3.112,17.442,1.207,100.146,37.206,1.305,1.366
 1001.909,106.023,575.293,88.768,-124.378,42.452,12.476,0.095,2.457,3.032,14.768,1.122,90.710,30.537,1.315,1.394
 1002.409,105.997,576.172,77.760,-126.960,40.098,12.415,0.067,2.466,2.923,14.282,1.066,84.374,26.060,1.337,1.438
 1002.909,106.046,580.420,70.055,-126.337,39.253,12.246,0.045,2.463,2.903,14.450,1.094,81.949,24.345,1.363,1.480
 1003.409,105.934,571.289,70.213,-123.506,38.437,12.150,0.034,2.469,2.947,14.110,1.198,82.436,24.690,1.389,1.507
 1003.909,105.848,571.289,78.674,-121.835,37.193,12.083,0.023,2.469,2.987,14.090,1.309,84.404,26.080,1.416,1.529
 1004.409,105.979,574.023,86.280,-120.082,36.689,12.044,0.013,2.467,3.020,14.216,1.369,86.782,27.761,1.446,1.550
 1004.909,105.897,571.289,88.972,-118.685,36.563,11.999,0.010,2.473,3.044,13.848,1.389,88.652,29.083,1.477,1.569
 1005.409,106.053,568.799,88.757,-118.176,35.642,11.977,0.012,2.483,3.108,13.259,1.393,89.399,29.611,1.498,1.575
 1005.909,105.877,571.338,90.600,-116.298,34.537,11.973,0.018,2.493,3.231,12.699,1.381,89.392,29.606,1.498,1.565
 1006.409,106.075,573.584,99.481,-113.994,34.601,11.973,0.040,2.491,3.389,12.782,1.321,89.860,29.936,1.467,1.537
 1006.909,106.071,561.523,107.231,-113.704,35.768,11.978,0.073,2.480,3.436,13.445,1.239,91.286,30.944,1.415,1.492
 1007.409,105.999,567.188,108.826,-114.376,37.796,12.213,0.098,2.459,3.383,14.677,1.186,93.076,32.209,1.358,1.442
 1007.909,106.049,576.172,103.595,-115.618,39.813,12.323,0.116,2.427,3.392,16.542,1.154,94.913,33.508,1.309,1.401
 1008.409,105.973,576.172,97.322,-114.727,41.308,12.033,0.134,2.359,3.374,20.504,1.114,97.824,35.565,1.287,1.386
 1008.909,106.099,584.473,97.424,-114.859,43.833,12.193,0.152,2.279,3.253,25.220,1.072,101.779,38.360,1.286,1.396
 1009.409,105.816,572.852,104.617,-116.404,46.504,12.757,0.158,2.241,3.039,27.416,1.108,104.234,40.095,1.307,1.427
 1009.909,106.058,572.266,110.134,-117.551,46.947,12.630,0.134,2.275,2.914,25.423,1.253,102.500,38.869,1.343,1.476
 1010.409,105.943,569.043,109.508,-116.995,44.333,11.897,0.096,2.375,2.995,19.591,1.435,97.071,35.032,1.402,1.553
 1010.909,105.993,567.627,106.707,-116.824,39.200,11.488,0.064,2.466,3.046,14.294,1.566,92.171,31.570,1.501,1.678
 1011.409,105.906,575.049,104.308,-115.906,34.628,11.295,0.040,2.497,2.958,12.436,1.650,89.862,29.938,1.649,1.850
 1011.909,106.113,581.055,102.356,-113.856,32.696,11.055,0.022,2.482,2.859,13.352,1.821,88.851,29.223,1.835,2.019
 1012.409,105.961,573.047,97.300,-111.167,32.394,10.864,0.013,2.471,2.887,14.004,2.235,86.407,27.496,1.987,2.106
 1012.909,106.036,563.477,91.038,-112.393,31.044,10.714,0.010,2.495,3.228,12.582,2.839,81.617,24.111,2.026,2.068
 1013.409,106.081,576.172,88.634,-116.479,27.301,10.541,0.012,2.544,3.720,9.725,3.165,77.153,20.956,1.960,1.986
 1013.909,105.997,571.289,90.568,-120.327,22.452,10.460,0.018,2.570,4.025,8.163,2.855,76.448,20.458,1.859,1.936
 1014.409,105.983,584.766,91.163,-122.659,19.171,10.550,0.026,2.560,4.046,8.785,2.142,79.621,22.700,1.791,1.942
 1014.909,106.059,579.492,90.039,-124.193,20.452,10.673,0.034,2.533,3.686,10.328,1.609,84.102,25.867,1.774,1.994
 1015.409,105.970,580.762,88.009,-126.122,24.275,10.735,0.036,2.524,3.254,10.896,1.595,86.297,27.418,1.794,2.057
 1015.909,106.067,576.172,86.595,-125.937,27.361,10.684,0.031,2.541,3.072,9.858,1.941,85.366,26.760,1.872,2.160
 1016.409,106.003,571.289,85.776,-124.492,28.608,10.587,0.024,2.577,3.060,7.772,2.554,82.676,24.860,2.014,2.325
 1016.909,106.158,571.289,76.516,-123.618,26.989,10.498,0.014,2.638,3.461,4.195,5.234,78.073,21.606,2.311,2.627
 1017.409,105.856,580.762,63.031,-123.780,23.129,10.360,0.007,2.714,3.918,-0.220,12.008,72.446,17.629,2.788,3.085
 1017.909,106.050,573.291,52.494,-124.448,17.106,10.186,0.001,2.780,4.153,-4.113,22.998,65.630,12.812,3.618,3.791
 1018.409,105.951,571.826,45.829,-125.081,11.039,10.059,-0.001,2.818,4.229,-6.312,32.081,59.579,8.536,4.798,4.851
 1018.909,106.039,566.943,40.967,-125.590,7.329,9.998,-0.004,2.821,4.128,-6.463,35.349,56.506,6.365,6.431,6.368
 1019.409,106.056,571.289,32.860,-125.422,5.883,9.978,-0.008,2.817,4.003,-6.236,34.028,58.444,7.734,8.183,8.173
 1019.909,106.002,567.969,23.679,-124.285,5.632,9.973,-0.011,2.811,3.877,-5.906,30.081,66.066,13.121,9.308,9.247
 1020.409,106.018,577.197,21.165,-123.631,5.905,9.971,-0.012,2.789,3.863,-4.646,25.398,76.023,20.158,9.296,8.813
 1020.909,105.947,581.055,24.235,-123.222,6.848,9.972,-0.006,2.774,3.852,-3.764,19.514,83.777,25.638,7.950,7.350
 1021.409,106.056,577.393,27.519,-123.198,8.308,9.997,0.005,2.771,4.001,-3.586,13.598,88.732,29.139,6.310,5.647
 1021.909,106.049,570.215,34.324,-121.800,10.034,10.074,0.024,2.759,4.154,-2.836,9.161,92.293,31.656,4.850,4.309
 1022.409,105.931,566.895,46.448,-120.074,12.510,10.182,0.043,2.716,3.972,-0.360,6.108,95.632,34.015,3.736,3.350
 1022.909,105.958,572.852,57.225,-119.410,16.900,10.320,0.053,2.657,3.730,3.125,4.125,100.042,37.132,2.934,2.729
 1023.409,105.959,576.172,61.027,-119.791,22.743,10.379,0.048,2.607,3.393,6.022,3.217,104.170,40.049,2.417,2.371
 1023.909,106.092,580.420,56.303,-122.099,28.127,10.354,0.031,2.570,3.174,8.166,2.848,106.683,41.825,2.107,2.185
 1024.409,106.040,571.289,49.824,-125.222,32.064,10.327,0.015,2.530,3.078,10.538,2.465,105.154,40.745,1.983,2.150
 1024.909,106.177,571.289,49.048,-127.109,34.677,10.287,0.015,2.501,2.887,12.232,2.210,97.836,35.573,1.965,2.173
 1025.409,105.930,576.172,51.128,-126.403,36.290,10.267,0.020,2.525,3.000,10.834,2.767,86.814,27.784,2.021,2.199
 1025.909,106.099,576.172,49.180,-124.139,35.174,10.247,0.019,2.600,3.424,6.459,4.170,76.263,20.327,2.081,2.173
 1026.409,105.994,581.055,41.275,-123.542,28.909,10.106,0.010,2.691,3.916,1.090,5.368,69.328,15.426,2.097,2.094
 1026.909,106.154,576.172,32.363,-125.857,20.388,9.964,0.002,2.737,4.131,-1.569,5.414,66.793,13.635,2.083,2.025
 1027.409,105.941,578.809,31.860,-129.531,14.268,9.937,0.004,2.686,3.815,1.392,4.054,67.892,14.411,2.022,1.954
 1027.909,106.166,571.289,39.046,-131.492,13.967,9.922,0.010,2.592,3.253,6.886,2.507,72.340,17.555,1.930,1.869
 1028.409,105.884,571.289,44.767,-132.394,19.786,9.881,0.016,2.512,2.819,11.550,1.873,80.130,23.060,1.788,1.752
 1028.909,105.992,571.289,45.570,-132.154,26.779,9.813,0.022,2.467,2.676,14.229,1.778,88.304,28.837,1.625,1.619
 1029.409,105.890,571.289,43.268,-131.469,31.790,9.724,0.027,2.449,2.716,15.286,1.791,95.574,33.975,1.481,1.511
 1029.909,106.035,579.492,40.388,-133.519,33.897,9.605,0.027,2.433,2.738,16.194,1.785,98.665,36.159,1.386,1.442
 1030.409,106.015,564.551,37.551,-136.115,32.979,9.465,0.026,2.430,2.627,16.390,1.765,96.272,34.468,1.350,1.418
 1030.909,106.120,560.498,33.243,-138.899,30.423,9.322,0.031,2.450,2.464,15.229,1.763,93.413,32.447,1.366,1.433
 1031.409,106.071,556.641,29.452,-137.332,26.919,9.180,0.033,2.481,2.357,13.405,1.882,94.303,33.076,1.415,1.476
 1031.909,106.094,561.523,26.774,-136.349,23.767,9.085,0.028,2.523,2.370,10.949,2.231,98.984,36.384,1.476,1.530
 1032.409,106.090,572.949,23.579,-134.988,21.813,9.036,0.021,2.564,2.569,8.542,2.562,106.294,41.551,1.528,1.580
 1032.909,106.037,576.172,22.128,-135.153,20.532,9.012,0.015,2.576,2.745,7.848,2.586,111.361,45.131,1.560,1.613
 1033.409,106.087,572.119,22.666,-132.544,20.041,9.009,0.013,2.549,2.731,9.417,2.302,112.660,46.049,1.573,1.636
 1033.909,106.105,567.871,24.643,-132.614,20.943,8.998,0.011,2.504,2.537,12.040,1.952,112.488,45.928,1.569,1.651
 1034.409,105.881,561.523,25.717,-133.327,22.762,8.978,0.008,2.466,2.278,14.253,1.788,110.147,44.274,1.559,1.667
 1034.909,106.051,562.500,25.252,-135.359,24.186,9.019,0.008,2.453,2.167,15.012,1.743,107.519,42.416,1.554,1.682
 1035.409,106.067,565.723,25.293,-134.629,25.086,9.094,0.013,2.456,2.130,14.872,1.717,103.414,39.515,1.558,1.695
 1035.909,106.079,570.801,26.497,-134.702,25.586,9.155,0.019,2.465,2.113,14.339,1.766,96.065,34.322,1.579,1.708
 1036.409,106.101,576.172,29.205,-134.183,25.850,9.221,0.026,2.487,2.193,13.047,1.908,86.796,27.771,1.611,1.723
 1036.909,106.073,561.523,30.195,-133.680,25.840,9.248,0.026,2.499,2.346,12.315,2.074,78.812,22.128,1.658,1.756
 1037.409,106.182,571.387,29.330,-131.761,25.227,9.218,0.024,2.495,2.465,12.570,2.168,74.661,19.195,1.723,1.818
 1037.909,106.059,573.486,27.808,-132.235,24.159,9.192,0.026,2.477,2.528,13.636,2.193,74.745,19.254,1.817,1.927
 1038.409,106.138,571.631,26.409,-133.468,23.350,9.282,0.031,2.459,2.598,14.662,2.213,75.718,19.942,1.938,2.076
 1038.909,106.081,579.053,27.748,-136.075,23.000,9.510,0.036,2.457,2.869,14.789,2.339,75.630,19.880,2.099,2.267
 1039.409,106.129,580.469,30.426,-136.708,23.110,9.755,0.032,2.468,3.370,14.129,2.626,74.007,18.733,2.298,2.487
 1039.909,106.067,569.922,32.049,-138.715,23.502,9.936,0.019,2.490,3.944,12.892,3.092,71.618,17.045,2.527,2.700
 1040.409,106.157,566.406,30.920,-140.917,23.285,10.050,0.005,2.511,4.311,11.654,3.642,69.777,15.743,2.769,2.874
 1040.909,106.030,569.775,28.981,-142.737,22.200,10.109,-0.003,2.533,4.496,10.372,4.070,68.133,14.581,2.961,2.945
 1041.409,106.089,570.264,27.792,-142.508,20.535,10.143,-0.005,2.548,4.580,9.460,4.178,66.896,13.707,3.024,2.887
 1041.909,106.082,566.406,28.704,-141.198,18.692,10.174,-0.006,2.549,4.733,9.434,3.854,66.436,13.383,2.898,2.715
 1042.409,106.017,572.559,29.520,-140.333,17.716,10.199,-0.005,2.530,4.806,10.515,3.253,66.964,13.756,2.610,2.466
 1042.909,105.961,572.314,28.222,-137.553,18.307,10.220,-0.004,2.488,4.737,12.956,2.609,68.322,14.715,2.265,2.184
 1043.409,106.129,568.262,27.363,-135.969,20.270,10.236,-0.004,2.448,4.594,15.349,2.137,69.866,15.807,1.954,1.904
 1043.909,105.921,569.629,29.079,-136.332,22.827,10.240,-0.001,2.427,4.301,16.570,1.819,71.189,16.741,1.687,1.630
 1044.409,106.015,566.406,33.603,-137.207,25.235,10.179,0.005,2.408,4.047,17.674,1.590,72.926,17.969,1.462,1.374
 1044.909,106.122,583.594,40.286,-135.495,27.474,10.083,0.018,2.380,3.699,19.279,1.434,75.794,19.996,1.258,1.149
 1045.409,106.041,581.055,46.010,-131.619,30.452,10.111,0.041,2.335,3.315,21.924,1.382,79.640,22.714,1.078,0.973
 1045.909,105.946,581.055,45.910,-129.999,34.428,10.164,0.066,2.282,3.014,25.011,1.356,83.275,25.283,0.928,0.850
 1046.409,106.140,578.857,40.513,-130.676,38.495,10.063,0.089,2.247,2.889,27.104,1.226,85.111,26.580,0.826,0.782
 1046.909,106.019,576.172,32.742,-133.698,40.873,9.976,0.100,2.223,3.030,28.455,1.010,85.125,26.590,0.764,0.753
 1047.409,106.142,573.730,29.665,-135.259,40.197,9.976,0.099,2.225,3.233,28.357,0.783,83.779,25.639,0.746,0.761
 1047.909,106.006,581.055,31.917,-136.861,37.857,9.963,0.092,2.249,3.339,26.988,0.652,81.817,24.253,0.752,0.783
 1048.409,106.078,578.369,33.773,-137.235,36.506,9.973,0.082,2.300,3.384,23.951,0.775,79.177,22.387,0.774,0.805
 1048.909,106.061,581.055,34.987,-136.184,37.037,10.020,0.075,2.379,3.482,19.350,1.109,75.807,20.005,0.797,0.814
 1049.409,106.194,581.055,33.612,-135.382,37.349,10.063,0.067,2.456,3.619,14.850,1.399,72.290,17.520,0.818,0.818
 1049.909,105.965,577.930,30.990,-134.905,35.475,10.127,0.056,2.493,3.671,12.669,1.406,70.137,15.998,0.844,0.831
 1050.409,106.098,590.820,29.043,-134.377,32.244,10.240,0.043,2.466,3.595,14.252,1.140,70.706,16.400,0.875,0.856
 1050.909,105.929,583.447,28.542,-134.449,30.871,10.355,0.032,2.412,3.522,17.415,0.962,73.537,18.401,0.903,0.882
 1051.409,106.130,574.658,29.778,-133.790,32.163,10.447,0.023,2.366,3.440,20.091,1.121,77.129,20.939,0.917,0.900
 1051.909,106.071,578.320,30.336,-133.504,33.933,10.553,0.014,2.342,3.265,21.511,1.425,79.793,22.822,0.919,0.915
 1052.409,106.115,582.324,32.256,-132.041,34.345,10.650,0.011,2.348,3.107,21.185,1.586,80.957,23.644,0.928,0.947
 1052.909,106.078,581.055,36.577,-130.818,33.148,10.731,0.009,2.372,2.955,19.774,1.535,82.137,24.478,0.963,1.007
 1053.409,106.133,584.912,42.649,-128.824,31.833,10.801,0.007,2.412,2.906,17.432,1.446,84.637,26.245,1.036,1.098
 1053.909,106.086,582.910,49.858,-124.697,30.886,10.862,0.006,2.457,2.882,14.801,1.484,88.641,29.075,1.146,1.214
 1054.409,106.026,576.172,62.198,-118.642,29.812,10.933,0.008,2.489,2.798,12.902,1.618,94.834,33.452,1.280,1.350
 1054.909,106.165,590.820,76.812,-114.016,29.799,11.001,0.011,2.503,2.721,12.116,1.730,101.647,38.266,1.410,1.502
 1055.409,106.241,577.783,88.945,-111.190,31.058,11.052,0.011,2.496,2.650,12.536,1.770,106.493,41.691,1.531,1.658
 1055.909,106.163,572.168,93.568,-111.550,32.910,11.085,0.008,2.483,2.598,13.280,1.778,105.797,41.200,1.642,1.804
 1056.409,106.042,575.488,89.854,-108.708,34.885,11.109,0.006,2.480,2.560,13.434,1.787,101.215,37.961,1.754,1.949
 1056.909,106.130,576.172,86.073,-107.249,36.216,11.123,0.006,2.487,2.565,13.022,1.808,96.493,34.624,1.885,2.126
 1057.409,106.095,571.387,82.841,-105.181,36.589,11.128,0.008,2.501,2.635,12.236,1.895,94.940,33.527,2.047,2.363
 1057.909,106.094,576.172,80.975,-105.094,36.532,11.130,0.007,2.534,2.749,10.320,2.398,96.795,34.838,2.299,2.691
 1058.409,106.168,581.055,75.114,-102.913,35.135,11.139,0.006,2.611,2.990,5.783,4.172,95.621,34.008,2.660,3.090
 1058.909,106.095,581.055,57.820,-103.512,29.963,11.109,0.001,2.725,3.459,-0.868,8.577,87.602,28.341,3.186,3.517
 1059.409,106.083,581.445,39.405,-103.577,21.879,11.065,-0.005,2.826,3.942,-6.766,14.071,78.412,21.846,3.789,3.881
 1059.909,106.058,580.078,28.002,-104.522,12.666,11.066,-0.009,2.873,4.332,-9.542,17.108,72.980,18.007,4.272,4.037
 1060.409,106.134,576.172,25.938,-102.696,6.193,11.086,-0.009,2.867,4.642,-9.155,15.737,73.231,18.185,4.402,3.971
 1060.909,106.129,569.824,33.891,-104.078,4.738,11.144,-0.001,2.814,4.661,-6.070,10.720,76.335,20.378,4.118,3.758
 1061.409,106.168,571.289,46.940,-106.478,6.838,11.233,0.011,2.727,4.272,-0.981,5.793,78.968,22.239,3.655,3.507
 1061.909,105.966,578.125,62.702,-109.286,12.286,11.312,0.019,2.620,3.584,5.259,3.085,83.334,25.325,3.203,3.272
 1062.409,106.158,585.938,79.178,-107.670,19.695,11.342,0.019,2.536,3.072,10.186,2.187,89.243,29.500,2.867,3.065
 1062.909,106.025,585.938,87.309,-107.104,26.910,11.321,0.016,2.504,3.045,12.041,2.132,94.205,33.007,2.655,2.900
 1063.409,106.080,581.982,87.382,-107.033,31.501,11.286,0.015,2.511,3.166,11.641,2.323,96.179,34.402,2.572,2.796
 1063.909,105.979,575.146,82.325,-108.722,32.770,11.249,0.016,2.530,3.211,10.498,2.635,94.569,33.264,2.594,2.762
 1064.409,105.984,577.734,73.672,-109.581,31.510,11.198,0.015,2.559,3.431,8.849,3.055,89.308,29.546,2.689,2.769
 1064.909,106.083,581.055,65.995,-111.706,28.813,11.111,0.011,2.586,3.807,7.257,3.477,82.404,24.667,2.806,2.785
 1065.409,106.149,590.820,57.471,-114.896,25.484,11.051,0.008,2.606,4.074,6.082,3.656,75.766,19.976,2.866,2.789
 1065.909,106.134,590.820,49.880,-117.130,22.721,11.051,0.004,2.607,4.120,6.034,3.442,71.202,16.750,2.831,2.766
 1066.409,106.123,601.221,46.091,-119.009,21.596,11.069,0.001,2.585,3.933,7.303,2.894,69.136,15.290,2.713,2.722
 1066.909,106.152,581.055,44.924,-122.202,22.080,11.102,0.001,2.566,3.795,8.405,2.332,68.430,14.791,2.535,2.618
 1067.409,106.099,583.691,47.184,-122.684,23.642,11.153,0.004,2.553,3.745,9.193,1.999,68.918,15.136,2.347,2.435
 1067.909,105.963,581.055,54.205,-121.072,24.986,11.233,0.009,2.549,3.743,9.392,1.853,70.381,16.170,2.130,2.192
 1068.409,106.010,593.213,63.445,-117.465,25.569,11.327,0.015,2.549,3.919,9.396,1.806,73.101,18.093,1.907,1.928
 1068.909,106.146,585.938,71.776,-114.744,26.235,11.411,0.034,2.542,3.983,9.810,1.710,77.057,20.888,1.696,1.706
 1069.409,106.170,583.203,75.604,-114.591,27.976,11.562,0.057,2.512,3.738,11.553,1.541,82.313,24.603,1.529,1.555
 1069.909,106.100,577.344,73.598,-116.956,31.607,11.757,0.064,2.474,3.361,13.789,1.343,87.807,28.485,1.416,1.476
 1070.409,106.243,590.820,65.860,-119.268,35.778,11.802,0.048,2.459,3.076,14.702,1.157,91.770,31.286,1.361,1.462
 1070.909,106.118,582.959,55.161,-121.750,37.653,11.666,0.019,2.462,3.063,14.504,1.101,93.281,32.354,1.349,1.480
 1071.409,106.161,598.877,47.325,-121.206,37.021,11.539,0.001,2.483,3.067,13.282,1.220,93.423,32.454,1.373,1.519
 1071.909,106.070,599.707,43.921,-116.712,35.711,11.480,0.000,2.500,2.957,12.272,1.445,93.443,32.469,1.422,1.568
 1072.409,106.093,592.285,45.450,-113.750,35.773,11.389,0.002,2.510,2.915,11.715,1.697,94.904,33.501,1.506,1.646
 1072.909,106.230,590.820,47.566,-112.445,36.210,11.273,0.003,2.524,2.980,10.875,1.902,99.482,36.737,1.630,1.764
 1073.409,106.025,583.496,47.801,-111.643,34.739,11.177,0.002,2.542,3.141,9.835,2.036,105.872,41.252,1.797,1.916
 1073.909,106.189,590.820,48.850,-108.325,31.872,11.112,0.003,2.562,3.302,8.659,2.117,110.042,44.199,1.974,2.075
 1074.409,106.022,586.914,49.977,-106.909,29.254,11.069,0.006,2.574,3.455,7.948,2.154,109.521,43.831,2.109,2.201
 1074.909,106.191,595.703,55.226,-106.387,27.706,11.038,0.006,2.571,3.530,8.156,2.127,105.113,40.716,2.159,2.274
 1075.409,106.018,595.703,61.430,-108.071,26.793,11.014,0.004,2.556,3.515,8.988,2.018,100.588,37.518,2.149,2.316
 1075.909,106.027,586.475,63.737,-109.219,26.463,11.006,0.001,2.546,3.608,9.606,1.826,97.954,35.657,2.134,2.336
 1076.409,106.071,573.975,62.817,-113.530,27.530,11.005,-0.000,2.554,4.188,9.118,1.642,94.708,33.362,2.127,2.330
 1076.909,106.232,575.391,55.016,-119.545,29.592,11.000,0.002,2.589,4.744,7.098,1.637,88.326,28.852,2.099,2.243
 1077.409,106.005,585.645,44.596,-123.925,30.263,10.957,0.006,2.639,4.893,4.144,1.837,79.694,22.752,2.018,2.089
 1077.909,106.144,590.820,35.713,-123.196,28.327,10.904,0.009,2.666,4.437,2.549,2.044,71.701,17.103,1.888,1.919
 1078.409,105.949,585.986,30.937,-123.869,25.427,10.884,0.012,2.654,3.660,3.262,2.024,67.588,14.197,1.764,1.800
 1078.909,106.085,578.662,33.448,-125.367,24.553,10.868,0.015,2.600,3.261,6.427,1.707,69.232,15.358,1.680,1.758
 1079.409,106.239,581.250,38.999,-125.492,26.436,10.855,0.014,2.534,2.928,10.282,1.369,73.650,18.480,1.643,1.766
 1079.909,106.085,585.938,44.822,-120.051,29.816,10.840,0.011,2.497,2.725,12.429,1.284,78.596,21.976,1.642,1.806
 1080.409,106.031,585.938,52.569,-115.413,32.430,10.795,0.007,2.494,2.670,12.611,1.403,82.177,24.507,1.669,1.857
 1080.909,106.157,585.938,60.028,-113.336,33.627,10.749,0.003,2.511,2.683,11.664,1.647,83.235,25.255,1.730,1.940
 1081.409,106.132,585.938,63.541,-113.838,33.384,10.717,-0.000,2.528,2.789,10.655,1.996,82.085,24.442,1.843,2.067
 1081.909,106.193,585.938,65.685,-113.875,31.398,10.687,-0.000,2.550,2.993,9.357,2.467,78.819,22.133,2.040,2.266
 1082.409,106.127,590.820,65.216,-115.041,28.135,10.667,0.003,2.577,3.202,7.751,2.982,75.024,19.452,2.325,2.539
 1082.909,106.218,590.820,65.157,-116.267,23.997,10.658,0.006,2.595,3.367,6.710,3.436,71.940,17.272,2.701,2.891
 1083.409,106.238,588.184,67.940,-118.134,20.750,10.657,0.005,2.595,3.404,6.730,3.697,70.348,16.147,3.099,3.301
 1083.909,106.245,595.703,71.883,-119.054,19.188,10.657,-0.000,2.579,3.404,7.675,3.772,70.200,16.042,3.445,3.674
 1084.409,106.122,595.703,76.137,-120.628,19.026,10.651,-0.001,2.569,3.513,8.240,3.721,70.647,16.359,3.655,3.901
 1084.909,106.166,583.984,76.345,-121.953,19.455,10.639,0.001,2.568,3.746,8.305,3.566,70.667,16.372,3.717,3.930
 1085.409,105.997,582.666,69.495,-124.439,19.580,10.625,0.001,2.563,4.027,8.618,3.324,69.755,15.728,3.638,3.813
 1085.909,106.198,590.088,62.441,-127.204,19.204,10.612,-0.000,2.556,4.202,9.007,3.023,68.396,14.767,3.491,3.641
 1086.409,106.004,585.938,59.436,-129.007,18.734,10.608,-0.002,2.547,4.182,9.524,2.745,67.406,14.068,3.319,3.452
 1086.909,106.270,594.727,59.065,-132.134,18.794,10.607,-0.001,2.542,4.188,9.812,2.596,67.085,13.841,3.153,3.271
 1087.409,106.062,583.887,61.314,-134.393,19.233,10.607,-0.001,2.541,4.334,9.882,2.589,67.126,13.870,2.996,3.104
 1087.909,106.060,581.055,66.154,-136.798,19.387,10.609,-0.000,2.539,4.590,9.974,2.663,67.076,13.834,2.840,2.942
 1088.409,106.166,585.938,69.808,-138.185,19.241,10.614,0.002,2.538,4.860,10.070,2.744,66.923,13.727,2.697,2.800
 1088.909,106.204,585.938,71.659,-137.303,19.339,10.618,0.006,2.538,4.926,10.069,2.720,66.905,13.714,2.569,2.675
 1089.409,106.097,588.477,70.937,-137.583,19.919,10.616,0.008,2.530,4.796,10.498,2.530,67.241,13.951,2.461,2.579
 1089.909,106.097,586.133,70.758,-138.199,20.400,10.605,0.007,2.520,4.539,11.129,2.274,67.809,14.353,2.367,2.499
 1090.409,106.228,590.820,72.930,-139.667,20.526,10.571,0.004,2.512,4.361,11.551,2.074,68.252,14.666,2.280,2.426
 1090.909,106.083,595.264,72.555,-140.617,20.342,10.526,0.002,2.511,4.330,11.627,1.976,68.412,14.779,2.200,2.359
 1091.409,106.143,593.799,71.984,-138.920,19.911,10.486,0.004,2.524,4.475,10.903,1.931,68.453,14.808,2.133,2.305
 1091.909,106.088,595.020,71.781,-138.380,19.294,10.456,0.005,2.540,4.937,9.924,1.891,68.624,14.928,2.086,2.275
 1092.409,106.194,587.598,69.742,-138.139,19.025,10.437,0.004,2.543,5.388,9.763,1.880,68.943,15.154,2.072,2.280
 1092.909,106.212,585.938,65.751,-138.180,19.564,10.403,0.002,2.530,5.462,10.514,1.914,69.107,15.270,2.093,2.325
 1093.409,106.103,589.404,58.996,-137.148,20.234,10.364,0.000,2.506,5.185,11.939,1.987,68.989,15.187,2.160,2.417
 1093.909,106.049,590.820,55.219,-137.045,20.310,10.327,-0.000,2.491,4.802,12.820,2.119,68.748,15.017,2.273,2.563
 1094.409,106.244,579.688,58.249,-136.483,19.756,10.288,0.000,2.496,4.635,12.486,2.368,68.507,14.846,2.443,2.765
 1094.909,106.218,587.305,64.929,-135.876,19.056,10.269,-0.000,2.512,4.605,11.558,2.737,68.136,14.584,2.672,3.026
 1095.409,106.228,590.820,70.185,-134.133,18.284,10.265,0.001,2.535,4.570,10.234,3.190,67.530,14.155,2.973,3.357
 1095.909,106.203,587.598,70.840,-133.190,17.189,10.265,0.007,2.559,4.525,8.858,3.664,66.697,13.567,3.355,3.771
 1096.409,106.035,589.355,67.930,-131.791,16.073,10.265,0.011,2.571,4.537,8.127,4.181,65.944,13.035,3.808,4.260
 1096.909,106.172,592.676,66.658,-126.637,15.338,10.264,0.012,2.579,4.577,7.662,4.777,65.621,12.806,4.330,4.800
 1097.409,106.243,591.309,69.974,-123.398,14.852,10.262,0.010,2.586,4.547,7.275,5.344,65.651,12.828,4.852,5.323
 1097.909,106.159,595.703,75.276,-121.554,14.372,10.267,0.011,2.602,4.523,6.289,5.711,66.017,13.086,5.337,5.778
 1098.409,106.284,595.703,77.007,-122.589,13.772,10.272,0.016,2.624,4.460,5.001,5.834,66.419,13.370,5.728,6.145
 1098.909,106.092,590.820,75.074,-121.398,13.273,10.276,0.016,2.627,4.326,4.866,5.785,66.629,13.519,6.016,6.383
 1099.409,106.232,590.820,71.712,-120.569,13.051,10.281,0.014,2.626,4.209,4.932,5.737,66.631,13.520,6.194,6.495
 1099.909,106.130,598.242,71.132,-118.812,12.953,10.296,0.011,2.619,4.086,5.335,5.765,66.691,13.562,6.260,6.471
 1100.409,106.034,600.586,73.875,-117.122,12.965,10.312,0.010,2.613,3.927,5.698,5.773,67.066,13.828,6.215,6.351
 1100.909,106.185,597.803,75.003,-113.442,13.156,10.331,0.011,2.609,3.802,5.911,5.687,67.818,14.359,6.099,6.181
 1101.409,105.996,590.820,77.892,-112.534,13.542,10.358,0.013,2.612,3.747,5.717,5.468,68.613,14.921,5.946,5.990
 1101.909,106.049,593.848,77.952,-112.284,13.893,10.388,0.019,2.626,3.783,4.923,5.161,69.025,15.212,5.771,5.791
 1102.409,106.272,590.820,74.030,-112.505,13.829,10.420,0.019,2.626,3.907,4.928,4.886,68.978,15.178,5.589,5.599
 1102.909,106.068,590.820,66.965,-110.149,13.659,10.453,0.019,2.623,4.041,5.063,4.690,68.585,14.901,5.389,5.408
 1103.409,106.201,595.703,58.183,-110.875,13.700,10.489,0.017,2.620,4.130,5.240,4.554,68.155,14.597,5.206,5.238
 1103.909,106.276,595.703,56.403,-113.642,13.920,10.531,0.016,2.619,4.069,5.336,4.380,68.021,14.503,5.053,5.115
 1104.409,106.298,588.281,58.794,-116.338,14.216,10.581,0.014,2.610,3.883,5.864,4.190,68.316,14.711,4.946,5.034
 1104.909,106.264,591.992,60.698,-113.767,14.410,10.631,0.007,2.587,3.741,7.181,4.125,68.834,15.077,4.874,4.991
 1105.409,106.225,590.820,62.089,-112.204,14.622,10.682,0.004,2.573,3.764,8.012,4.213,69.342,15.436,4.849,4.964
 1105.909,106.296,590.820,62.715,-111.733,14.725,10.751,0.008,2.571,3.861,8.116,4.282,69.934,15.854,4.834,4.933
 1106.409,106.231,590.820,66.423,-112.164,14.628,10.856,0.015,2.578,3.852,7.702,4.167,70.834,16.491,4.816,4.859
 1106.909,106.222,599.219,71.196,-109.750,15.063,10.968,0.019,2.586,3.756,7.253,3.943,71.862,17.217,4.709,4.694
 1107.409,106.136,590.820,70.606,-111.305,16.326,11.058,0.017,2.589,3.661,7.090,3.771,72.112,17.394,4.449,4.372
 1107.909,105.961,590.820,65.469,-115.934,17.509,11.137,0.008,2.579,3.637,7.684,3.597,71.371,16.870,4.070,3.961
 1108.409,106.163,583.154,59.645,-121.360,17.638,11.221,0.004,2.571,3.611,8.125,3.223,70.405,16.187,3.637,3.553
 1108.909,106.006,585.938,59.178,-124.318,16.962,11.320,0.005,2.572,3.532,8.080,2.677,70.032,15.924,3.237,3.195
 1109.409,106.149,593.164,63.903,-126.763,17.250,11.405,0.004,2.575,3.900,7.892,2.157,70.514,16.264,2.900,2.908
 1109.909,106.282,590.820,65.946,-130.124,18.928,11.466,0.001,2.575,4.395,7.906,1.834,71.000,16.608,2.616,2.654
 1110.409,106.207,593.408,61.445,-133.743,20.899,11.518,-0.004,2.548,4.514,9.501,1.744,70.871,16.517,2.389,2.436
 1110.909,106.049,595.215,55.260,-135.090,22.005,11.585,-0.005,2.516,4.269,11.358,1.741,70.448,16.218,2.202,2.252
 1111.409,106.292,585.938,49.675,-136.001,21.858,11.675,-0.001,2.490,3.851,12.852,1.756,70.121,15.986,2.064,2.106
 1111.909,106.357,595.215,46.729,-137.306,21.651,11.791,0.003,2.473,3.751,13.871,1.771,70.064,15.947,1.963,1.992
 1112.409,106.202,590.820,45.832,-138.405,21.901,11.926,0.009,2.474,3.965,13.772,1.793,70.156,16.012,1.894,1.905
 1112.909,106.252,591.553,46.302,-140.411,22.790,12.051,0.012,2.479,4.208,13.525,1.801,70.310,16.120,1.840,1.835
 1113.409,106.224,598.975,46.694,-142.453,24.109,12.157,0.012,2.481,4.286,13.408,1.806,70.588,16.317,1.794,1.776
 1113.909,106.266,598.730,46.353,-143.695,24.900,12.248,0.008,2.474,4.275,13.822,1.871,70.994,16.604,1.746,1.720
 1114.409,106.224,590.820,47.823,-143.648,25.163,12.328,0.001,2.451,4.225,15.160,2.018,71.471,16.940,1.699,1.664
 1114.909,106.280,595.703,48.705,-143.581,25.624,12.400,-0.002,2.433,4.250,16.173,2.166,71.850,17.209,1.656,1.608
 1115.409,106.330,591.943,49.152,-143.978,26.354,12.461,-0.003,2.431,4.426,16.336,2.204,72.062,17.358,1.619,1.559
 1115.909,106.179,600.586,47.372,-144.809,26.848,12.516,-0.002,2.435,4.544,16.059,2.156,72.132,17.408,1.588,1.514
 1116.409,106.300,600.586,44.488,-145.215,26.535,12.576,0.000,2.438,4.585,15.886,2.150,72.216,17.467,1.560,1.474
 1116.909,106.203,597.266,41.259,-145.518,26.261,12.658,0.002,2.432,4.577,16.285,2.224,72.491,17.661,1.531,1.434
 1117.409,106.309,590.820,35.559,-145.246,27.858,12.745,0.002,2.415,4.500,17.260,2.301,72.965,17.997,1.503,1.394
 1117.909,106.119,595.703,30.821,-145.336,30.178,12.813,0.001,2.397,4.428,18.303,2.296,73.465,18.350,1.473,1.354
 1118.409,106.149,591.260,29.380,-145.305,31.174,12.859,-0.001,2.381,4.411,19.236,2.232,73.718,18.529,1.441,1.312
 1118.909,106.184,595.020,27.919,-145.236,30.736,12.874,-0.001,2.367,4.386,20.030,2.155,73.669,18.494,1.400,1.265
 1119.409,106.362,605.273,28.660,-145.395,30.144,12.875,0.003,2.354,4.370,20.802,2.071,73.614,18.455,1.350,1.213
 1119.909,106.092,595.703,31.163,-144.633,30.843,12.874,0.015,2.341,4.292,21.592,1.972,73.871,18.637,1.285,1.161
 1120.409,106.323,590.771,32.553,-144.121,32.131,12.871,0.031,2.327,4.217,22.399,1.840,74.389,19.003,1.214,1.109
 1120.909,106.176,591.113,34.807,-144.533,32.803,12.869,0.050,2.317,4.239,22.966,1.651,74.823,19.310,1.146,1.067
 1121.409,106.265,595.703,35.094,-145.269,33.216,12.866,0.066,2.305,4.191,23.690,1.422,74.920,19.378,1.087,1.033
 1121.909,106.192,598.535,35.332,-145.052,34.159,12.854,0.076,2.288,4.118,24.653,1.197,74.644,19.183,1.042,1.005
 1122.409,106.307,600.098,33.514,-144.965,35.347,12.837,0.083,2.270,3.970,25.724,1.046,74.231,18.891,1.005,0.979
 1122.909,106.281,595.703,28.704,-143.967,35.685,12.819,0.088,2.250,3.877,26.893,1.011,73.848,18.620,0.975,0.951
 1123.409,106.249,581.055,26.502,-143.644,34.950,12.794,0.096,2.238,3.884,27.576,1.046,73.597,18.443,0.947,0.921
 1123.909,106.234,590.869,28.223,-140.667,34.245,12.701,0.104,2.217,3.921,28.837,1.085,73.769,18.564,0.924,0.896
 1124.409,106.394,591.797,34.150,-139.881,34.595,12.569,0.116,2.187,3.831,30.608,1.071,74.626,19.171,0.905,0.879
 1124.909,106.336,595.703,40.135,-141.290,36.180,12.490,0.132,2.161,3.564,32.114,1.023,76.001,20.142,0.893,0.871
 1125.409,106.200,600.586,42.612,-143.544,37.381,12.422,0.149,2.156,3.353,32.397,1.003,77.188,20.981,0.886,0.869
 1125.909,106.299,600.586,41.476,-143.540,37.292,12.408,0.163,2.180,3.317,31.013,1.031,77.452,21.167,0.883,0.870
 1126.409,106.364,600.586,38.270,-142.007,35.862,12.449,0.168,2.208,3.475,29.386,1.054,76.772,20.687,0.884,0.877
 1126.909,106.232,600.586,35.038,-140.107,33.602,12.464,0.166,2.227,3.594,28.218,1.017,75.654,19.897,0.892,0.890
 1127.409,106.386,595.703,33.229,-138.224,32.620,12.456,0.162,2.243,3.624,27.305,0.949,74.627,19.171,0.907,0.905
 1127.909,106.253,604.199,35.006,-135.259,32.802,12.426,0.157,2.253,3.676,26.732,0.910,74.039,18.755,0.925,0.915
 1128.409,106.393,605.469,38.753,-134.329,32.960,12.314,0.152,2.245,3.629,27.217,0.950,74.257,18.909,0.933,0.911
 1128.909,106.155,601.025,42.751,-135.379,32.644,12.171,0.149,2.223,3.500,28.498,1.030,75.469,19.766,0.924,0.893
 1129.409,106.265,595.703,46.064,-135.544,31.811,12.091,0.151,2.205,3.281,29.547,1.056,77.569,21.250,0.896,0.865
 1129.909,106.343,595.703,46.065,-133.417,31.443,12.027,0.158,2.206,3.042,29.464,0.995,79.628,22.705,0.860,0.838
 1130.409,106.289,595.801,44.118,-134.053,31.688,11.958,0.165,2.214,2.955,29.011,0.850,80.762,23.507,0.827,0.819
 1130.909,106.166,595.703,39.016,-135.485,32.188,11.876,0.170,2.215,2.978,28.929,0.697,80.776,23.516,0.804,0.806
 1131.409,106.313,603.467,33.942,-137.378,33.487,11.823,0.171,2.208,3.132,29.363,0.609,79.652,22.722,0.788,0.797
 1131.909,106.181,605.469,33.637,-134.627,34.921,11.788,0.170,2.204,3.292,29.610,0.594,78.013,21.564,0.775,0.788
 1132.409,106.228,605.469,39.478,-133.194,35.452,11.712,0.167,2.215,3.378,28.975,0.643,76.580,20.551,0.766,0.782
 1132.909,106.396,601.123,47.300,-134.617,35.213,11.602,0.160,2.226,3.378,28.283,0.710,75.856,20.039,0.764,0.782
 1133.409,106.299,605.469,51.882,-138.662,34.669,11.484,0.151,2.240,3.405,27.506,0.738,75.895,20.067,0.777,0.799
 1133.909,106.395,611.084,51.457,-139.439,33.972,11.407,0.145,2.255,3.594,26.616,0.719,76.248,20.317,0.806,0.832
 1134.409,106.407,611.914,46.420,-139.144,33.333,11.356,0.144,2.272,3.971,25.615,0.732,76.497,20.493,0.851,0.878
 1134.909,106.269,610.352,42.414,-139.245,32.904,11.305,0.146,2.296,4.312,24.202,0.882,76.611,20.573,0.906,0.929
 1135.409,106.303,599.658,40.657,-140.146,32.316,11.242,0.142,2.318,4.326,22.903,1.142,76.676,20.619,0.965,0.979
 1135.909,106.242,595.703,40.986,-141.139,31.071,11.172,0.130,2.335,4.140,21.926,1.401,76.614,20.576,1.023,1.028
 1136.409,106.257,599.463,39.941,-141.611,29.469,11.150,0.113,2.349,4.023,21.082,1.625,76.463,20.468,1.091,1.083
 1136.909,106.306,600.098,35.655,-141.621,28.194,11.160,0.088,2.359,3.990,20.549,1.834,76.365,20.400,1.163,1.140
 1137.409,106.273,610.352,31.422,-140.822,27.493,11.203,0.060,2.364,4.091,20.218,2.075,76.381,20.411,1.239,1.195
 1137.909,106.185,602.051,30.960,-139.953,27.261,11.255,0.033,2.364,4.260,20.246,2.283,76.452,20.460,1.298,1.233
 1138.409,106.343,604.199,33.519,-140.446,26.934,11.227,0.013,2.353,4.411,20.872,2.371,76.386,20.414,1.331,1.253
 1138.909,106.187,605.469,34.273,-142.367,27.060,11.114,0.005,2.332,4.484,22.119,2.319,76.196,20.280,1.337,1.256
 1139.409,106.325,605.469,32.431,-142.691,27.747,10.997,0.011,2.314,4.333,23.183,2.201,76.000,20.141,1.326,1.245
 1139.909,106.304,607.617,30.269,-142.477,28.030,10.847,0.026,2.309,4.150,23.421,2.111,75.825,20.018,1.310,1.229
 1140.409,106.357,610.352,29.461,-141.866,27.745,10.740,0.042,2.319,4.048,22.859,2.051,75.706,19.933,1.293,1.212
 1140.909,106.401,600.586,29.407,-142.099,26.728,10.746,0.050,2.334,4.023,21.973,2.002,75.621,19.873,1.277,1.199
 1141.409,106.309,610.352,29.767,-140.534,25.583,10.757,0.049,2.345,4.057,21.366,1.968,75.526,19.807,1.267,1.195
 1141.909,106.351,605.078,31.709,-140.491,25.143,10.731,0.038,2.353,4.095,20.904,2.023,75.151,19.541,1.267,1.203
 1142.409,106.292,600.586,33.687,-141.101,25.249,10.678,0.025,2.361,4.170,20.419,2.137,74.474,19.063,1.280,1.228
 1142.909,106.335,600.586,35.029,-143.359,25.427,10.650,0.015,2.368,4.160,20.014,2.235,73.635,18.470,1.313,1.278
 1143.409,106.298,610.352,35.032,-143.564,25.336,10.635,0.009,2.372,4.113,19.748,2.317,72.858,17.921,1.368,1.357
 1143.909,106.391,607.275,34.403,-141.737,24.857,10.589,0.008,2.380,4.115,19.316,2.420,72.241,17.485,1.456,1.474
 1144.409,106.187,616.992,36.167,-138.760,24.313,10.500,0.008,2.393,4.172,18.524,2.535,71.582,17.019,1.579,1.631
 1144.909,106.303,600.586,38.686,-136.080,23.524,10.368,0.010,2.413,4.232,17.393,2.625,70.803,16.469,1.744,1.827
 1145.409,106.352,593.896,41.368,-133.932,21.946,10.204,0.015,2.438,4.192,15.897,2.703,69.875,15.813,1.945,2.052
 1145.909,106.383,605.469,41.055,-132.652,19.769,10.048,0.020,2.460,4.079,14.636,2.817,68.809,15.059,2.172,2.294
 1146.409,106.352,610.352,38.249,-132.142,17.549,9.879,0.022,2.471,3.911,13.966,2.964,67.812,14.355,2.410,2.539
 1146.909,106.301,606.543,36.499,-130.992,15.938,9.703,0.022,2.481,3.761,13.413,3.097,67.179,13.907,2.637,2.781
 1147.409,106.433,605.469,36.063,-130.353,15.473,9.577,0.023,2.490,3.540,12.894,3.161,67.182,13.910,2.855,3.021
 1147.909,106.311,601.416,36.194,-130.342,15.894,9.496,0.025,2.497,3.283,12.447,3.194,67.485,14.123,3.053,3.261
 1148.409,106.387,600.586,35.611,-130.063,16.342,9.448,0.023,2.500,3.191,12.285,3.318,68.715,14.993,3.253,3.498
 1148.909,106.363,604.834,37.115,-128.363,16.049,9.417,0.018,2.501,3.240,12.201,3.571,70.946,16.570,3.464,3.740
 1149.409,106.358,597.656,40.434,-123.823,14.754,9.392,0.014,2.515,3.531,11.376,3.952,73.379,18.289,3.710,3.983
 1149.909,106.454,585.938,44.643,-120.079,13.296,9.371,0.016,2.544,3.882,9.701,4.332,76.848,20.741,4.002,4.249
 1150.409,106.399,595.703,50.236,-119.067,12.329,9.358,0.025,2.576,4.011,7.811,4.666,82.726,24.895,4.327,4.519
 1150.909,106.333,595.703,55.156,-117.303,11.850,9.349,0.028,2.588,3.869,7.145,5.117,88.144,28.724,4.634,4.750
 1151.409,106.325,593.311,57.904,-114.228,11.576,9.346,0.026,2.593,3.707,6.824,5.537,91.982,31.436,4.822,4.886
 1151.909,106.416,595.703,58.564,-111.908,11.067,9.369,0.023,2.600,3.702,6.456,5.573,94.569,33.264,4.859,4.897
 1152.409,106.283,595.703,64.919,-108.565,10.578,9.425,0.021,2.602,3.910,6.329,4.993,97.168,35.101,4.741,4.829
 1152.909,106.369,595.703,76.803,-104.025,10.852,9.469,0.025,2.607,4.089,5.998,4.148,103.554,39.614,4.558,4.728
 1153.409,106.387,595.703,87.429,-100.351,12.796,9.483,0.024,2.602,3.988,6.315,3.559,107.558,42.444,4.366,4.631
 1153.909,106.420,604.395,92.615,-98.697,15.671,9.484,0.023,2.600,3.813,6.427,3.355,106.375,41.608,4.224,4.564
 1154.409,106.428,595.703,87.664,-101.091,17.985,9.484,0.021,2.602,3.642,6.328,3.400,100.613,37.535,4.150,4.544
 1154.909,106.329,595.703,77.972,-101.609,18.949,9.484,0.017,2.590,3.531,6.996,3.570,93.364,32.413,4.178,4.596
 1155.409,106.329,595.703,69.439,-104.014,18.912,9.480,0.012,2.579,3.515,7.670,3.956,88.863,29.232,4.311,4.734
 1155.909,106.328,590.820,65.766,-106.691,18.312,9.464,0.008,2.577,3.600,7.783,4.728,87.509,28.275,4.550,4.937
 1156.409,106.392,594.385,64.058,-110.499,16.963,9.450,0.004,2.581,3.821,7.548,5.745,87.110,27.993,4.890,5.236
 1156.909,106.346,595.703,61.420,-109.061,14.711,9.452,0.003,2.593,4.008,6.854,6.456,86.234,27.374,5.318,5.622
 1157.409,106.484,595.703,62.116,-108.381,12.144,9.462,0.006,2.602,4.117,6.325,6.633,83.922,25.740,5.789,6.071
 1157.909,106.361,600.586,64.312,-106.970,10.531,9.477,0.011,2.612,4.188,5.731,6.616,80.352,23.217,6.249,6.508
 1158.409,106.325,600.586,64.378,-109.934,10.105,9.484,0.015,2.628,4.183,4.784,6.830,79.814,22.837,6.580,6.800
 1158.909,106.432,600.586,62.462,-110.098,10.104,9.489,0.017,2.635,4.141,4.379,7.040,86.520,27.576,6.711,6.899
 1159.409,106.368,604.883,62.310,-110.522,10.053,9.508,0.018,2.632,3.996,4.590,6.843,96.773,34.822,6.695,6.876
 1159.909,106.511,599.609,68.074,-109.795,10.277,9.544,0.017,2.619,3.838,5.294,6.234,101.254,37.988,6.577,6.773
 1160.409,106.372,595.361,75.044,-109.351,11.148,9.586,0.017,2.609,3.754,5.914,5.645,96.943,34.942,6.478,6.657
 1160.909,106.393,600.586,75.043,-108.395,12.487,9.617,0.017,2.606,3.697,6.087,5.460,88.356,28.873,6.333,6.463
 1161.409,106.393,614.795,71.874,-107.433,13.498,9.632,0.016,2.609,3.717,5.921,5.644,86.118,27.292,6.170,6.222
 1161.909,106.365,603.027,66.082,-104.477,13.516,9.638,0.016,2.610,3.797,5.864,5.801,92.934,32.109,5.956,5.995
 1162.409,106.387,595.703,61.293,-102.043,12.798,9.665,0.017,2.607,3.851,6.017,5.699,99.548,36.783,5.751,5.798
 1162.909,106.443,595.703,61.282,-98.846,12.087,9.730,0.020,2.606,3.913,6.084,5.364,99.486,36.739,5.606,5.702
 1163.409,106.335,595.703,64.349,-98.900,12.195,9.781,0.020,2.606,3.873,6.087,5.085,93.709,32.657,5.511,5.634
 1163.909,106.348,607.227,69.101,-99.571,13.070,9.817,0.017,2.604,3.874,6.183,5.103,87.563,28.313,5.452,5.581
 1164.409,106.428,610.352,71.146,-101.659,14.044,9.861,0.014,2.598,3.857,6.573,5.102,88.076,28.675,5.390,5.518
 1164.909,106.375,604.102,73.411,-101.804,14.575,9.915,0.014,2.587,3.843,7.176,4.986,93.803,32.723,5.291,5.387
 1165.409,106.348,602.246,74.281,-101.381,14.938,9.974,0.016,2.579,3.828,7.685,4.875,98.068,35.737,5.152,5.221
 1165.909,106.427,610.352,74.138,-99.969,15.657,10.029,0.017,2.575,3.810,7.904,4.763,98.918,36.338,4.966,4.992
 1166.409,106.293,601.611,73.722,-98.425,16.349,10.080,0.016,2.567,3.813,8.349,4.555,96.858,34.882,4.749,4.754
 1166.909,106.520,605.469,74.188,-98.648,16.693,10.134,0.018,2.562,3.725,8.640,4.178,93.772,32.701,4.500,4.519
 1167.409,106.382,605.469,79.014,-100.639,17.226,10.189,0.025,2.564,3.620,8.557,3.787,91.703,31.239,4.238,4.290
 1167.909,106.538,609.326,83.388,-102.211,18.356,10.240,0.027,2.561,3.531,8.716,3.516,90.183,30.165,3.972,4.077
 1168.409,106.353,600.586,82.886,-100.964,19.326,10.277,0.026,2.556,3.498,8.982,3.346,89.165,29.445,3.736,3.875
 1168.909,106.540,604.639,73.153,-100.415,19.628,10.320,0.023,2.553,3.430,9.184,3.191,88.403,28.907,3.538,3.700
 1169.409,106.292,600.586,61.339,-99.621,19.463,10.377,0.020,2.544,3.290,9.683,2.985,87.153,28.023,3.378,3.522
 1169.909,106.413,609.180,57.493,-99.080,19.549,10.418,0.015,2.531,3.151,10.471,2.799,85.750,27.032,3.219,3.315
 1170.409,106.561,609.229,59.031,-97.296,20.356,10.450,0.012,2.521,3.139,11.032,2.691,84.609,26.225,3.019,3.054
 1170.909,106.502,600.586,64.500,-95.660,21.119,10.502,0.017,2.524,3.157,10.905,2.590,83.624,25.529,2.769,2.771
 1171.409,106.513,602.783,71.149,-95.955,21.881,10.590,0.032,2.532,3.148,10.414,2.399,83.858,25.694,2.512,2.530
 1171.909,106.370,586.328,75.952,-95.977,23.212,10.674,0.052,2.530,3.052,10.500,2.115,85.323,26.730,2.286,2.353
 1172.409,106.367,600.586,79.960,-95.444,25.578,10.785,0.075,2.497,3.000,12.433,1.812,88.215,28.774,2.144,2.267
 1172.909,106.320,610.352,82.590,-97.273,28.912,10.947,0.099,2.453,3.021,15.022,1.587,91.759,31.278,2.066,2.236
 1173.409,106.337,610.352,80.479,-98.708,32.431,11.160,0.101,2.417,3.018,17.161,1.565,93.963,32.836,2.049,2.236
 1173.909,106.386,604.785,76.648,-99.532,34.499,11.066,0.082,2.410,3.054,17.521,1.721,93.352,32.405,2.063,2.245
 1174.409,106.400,595.703,73.201,-98.060,33.956,10.665,0.049,2.442,3.069,15.685,2.005,89.068,29.377,2.096,2.252
 1174.909,106.392,610.352,68.511,-97.295,31.288,10.479,0.025,2.484,3.112,13.219,2.283,83.759,25.625,2.144,2.266
 1175.409,106.432,613.525,67.109,-98.657,27.298,10.466,0.023,2.515,3.119,11.412,2.381,79.992,22.963,2.197,2.284
 1175.909,106.411,615.234,68.848,-97.894,23.714,10.521,0.030,2.528,3.092,10.642,2.289,79.077,22.316,2.223,2.274
 1176.409,106.339,621.973,72.786,-96.699,21.602,10.652,0.036,2.534,3.116,10.305,2.092,80.880,23.590,2.182,2.211
 1176.909,106.547,610.352,79.949,-97.493,21.901,10.771,0.034,2.523,3.216,10.948,1.873,83.931,25.746,2.062,2.086
 1177.409,106.531,617.578,87.817,-98.704,24.558,10.843,0.042,2.495,3.379,12.584,1.676,87.535,28.293,1.887,1.931
 1177.909,106.518,609.033,94.836,-99.892,28.834,10.970,0.074,2.449,3.511,15.259,1.460,91.938,31.405,1.710,1.779
 1178.409,106.511,605.469,98.800,-99.437,34.198,11.206,0.120,2.398,3.466,18.239,1.246,96.945,34.943,1.557,1.646
 1178.909,106.496,613.379,97.725,-100.134,39.708,11.611,0.146,2.365,3.271,20.199,1.128,101.063,37.854,1.436,1.535
 1179.409,106.503,616.016,96.305,-101.037,43.287,12.076,0.134,2.347,3.186,21.215,1.108,103.071,39.273,1.346,1.447
 1179.909,106.447,613.477,94.436,-101.061,43.758,12.193,0.112,2.347,3.266,21.218,1.118,103.104,39.296,1.285,1.389
 1180.409,106.482,614.697,92.159,-101.469,41.878,12.209,0.107,2.331,3.358,22.145,1.110,103.069,39.272,1.252,1.363
 1180.909,106.421,615.234,92.946,-103.172,39.743,12.497,0.124,2.286,3.271,24.810,1.083,104.366,40.188,1.250,1.369
 1181.409,106.497,615.234,95.823,-106.812,38.898,12.643,0.136,2.248,3.057,27.011,1.085,105.778,41.186,1.264,1.392
 1181.909,106.494,615.234,98.569,-107.554,38.749,12.500,0.118,2.259,3.060,26.350,1.161,105.169,40.756,1.291,1.426
 1182.409,106.536,624.805,99.417,-108.570,38.868,12.091,0.084,2.316,3.223,23.052,1.270,102.315,38.739,1.322,1.469
 1182.909,106.516,622.607,94.645,-110.063,38.948,11.407,0.053,2.380,3.399,19.279,1.358,97.912,35.627,1.369,1.541
 1183.409,106.507,624.854,84.876,-112.765,39.252,10.956,0.034,2.418,3.408,17.072,1.397,93.073,32.207,1.450,1.663
 1183.909,106.557,622.803,71.885,-117.259,39.295,10.744,0.025,2.434,3.244,16.158,1.470,87.431,28.220,1.585,1.854
 1184.409,106.672,629.883,56.856,-123.141,38.726,10.527,0.022,2.460,3.308,14.591,1.788,80.981,23.662,1.788,2.105
 1184.909,106.533,626.953,45.342,-127.512,36.665,10.358,0.024,2.503,3.656,12.083,2.712,74.175,18.852,2.057,2.406
 1185.409,106.541,628.613,36.622,-130.216,32.431,10.218,0.022,2.543,3.990,9.771,4.374,67.962,14.461,2.399,2.736
 1185.909,106.586,620.117,28.309,-130.449,26.386,10.130,0.015,2.565,4.181,8.463,6.259,63.302,11.168,2.813,3.133
 1186.409,106.544,616.895,22.034,-131.415,19.866,10.091,0.007,2.576,4.219,7.808,7.400,60.088,8.896,3.325,3.599
 1186.909,106.594,625.000,20.725,-132.923,14.448,10.076,-0.000,2.581,4.337,7.566,7.291,58.365,7.679,3.933,4.161
 1187.409,106.589,618.457,25.267,-132.739,10.995,10.064,-0.002,2.590,4.587,7.047,6.334,57.914,7.360,4.546,4.731
 1187.909,106.632,618.896,33.558,-130.745,9.522,10.057,0.002,2.598,4.732,6.537,5.348,58.441,7.732,5.008,5.172
 1188.409,106.593,619.189,39.398,-129.711,9.529,10.055,0.008,2.605,4.658,6.162,4.817,59.504,8.483,5.210,5.445
 1188.909,106.538,622.168,41.556,-128.967,10.155,10.055,0.015,2.611,4.511,5.764,4.659,60.565,9.233,5.224,5.507
 1189.409,106.525,625.000,42.435,-128.483,10.658,10.055,0.017,2.608,4.473,5.939,4.756,61.545,9.926,5.217,5.516
 1189.909,106.458,625.000,45.284,-128.177,10.854,10.055,0.017,2.605,4.506,6.168,4.996,62.582,10.659,5.333,5.574
 1190.409,106.486,622.461,52.898,-127.659,10.825,10.055,0.013,2.599,4.401,6.515,5.430,63.516,11.319,5.603,5.736
 1190.909,106.427,634.766,60.219,-127.541,10.652,10.046,0.008,2.593,4.232,6.823,6.083,64.297,11.871,6.003,5.976
 1191.409,106.544,629.004,61.902,-125.138,10.209,10.011,0.006,2.599,4.182,6.475,6.902,64.949,12.331,6.360,6.073
 1191.909,106.411,630.176,60.044,-121.825,9.329,9.984,0.006,2.609,4.347,5.885,7.643,65.768,12.910,6.389,5.869
 1192.409,106.549,627.637,56.662,-120.226,8.159,9.985,0.008,2.611,4.611,5.789,7.669,68.304,14.703,5.913,5.321
 1192.909,106.595,629.834,57.500,-118.561,7.259,10.005,0.014,2.604,4.668,6.190,6.793,73.785,18.576,5.098,4.650
 1193.409,106.629,620.117,66.791,-116.896,7.895,10.097,0.025,2.586,4.384,7.243,5.191,82.021,24.396,4.264,4.029
 1193.909,106.511,630.029,78.730,-114.105,10.835,10.234,0.037,2.564,3.929,8.542,3.588,89.385,29.601,3.556,3.514
 1194.409,106.594,634.766,88.525,-113.107,15.990,10.362,0.047,2.542,3.462,9.811,2.576,93.584,32.568,3.015,3.091
 1194.909,106.452,634.766,94.746,-113.575,21.264,10.472,0.046,2.517,3.143,11.311,2.098,96.194,34.413,2.608,2.745
 1195.409,106.533,631.787,97.898,-114.533,25.006,10.571,0.042,2.502,3.029,12.161,1.914,100.292,37.309,2.312,2.472
 1195.909,106.584,630.518,101.154,-113.900,26.783,10.661,0.040,2.498,2.978,12.370,1.836,106.084,41.402,2.099,2.261
 1196.409,106.480,631.592,105.195,-113.559,27.564,10.726,0.041,2.504,3.004,12.064,1.805,110.156,44.280,1.957,2.117
 1196.909,106.445,629.883,103.661,-112.342,27.935,10.771,0.044,2.513,3.053,11.537,1.775,111.122,44.963,1.865,2.018
 1197.409,106.516,629.883,97.656,-110.651,27.965,10.804,0.047,2.521,3.045,11.070,1.741,109.426,43.764,1.809,1.956
 1197.909,106.499,629.883,92.033,-109.846,29.024,10.831,0.050,2.526,3.017,10.736,1.696,107.315,42.272,1.769,1.913
 1198.409,106.645,629.883,88.624,-110.455,31.221,10.831,0.048,2.525,2.959,10.806,1.649,105.389,40.911,1.735,1.877
 1198.909,106.563,629.492,87.258,-111.064,33.114,10.816,0.043,2.517,2.913,11.305,1.609,102.633,38.964,1.700,1.845
 1199.409,106.486,634.766,84.536,-109.578,33.670,10.812,0.037,2.505,2.860,12.002,1.572,99.725,36.908,1.667,1.823
 1199.909,106.732,636.523,84.464,-107.324,32.560,10.797,0.033,2.494,2.818,12.628,1.544,98.014,35.699,1.648,1.824
 1200.409,106.653,642.334,88.180,-106.958,31.296,10.767,0.032,2.485,2.821,13.150,1.526,97.917,35.631,1.655,1.859
 1200.909,106.602,629.883,94.245,-107.095,31.493,10.722,0.032,2.477,2.837,13.642,1.547,97.714,35.487,1.701,1.935
 1201.409,106.611,634.229,101.273,-105.612,32.761,10.663,0.027,2.464,2.871,14.385,1.670,96.266,34.464,1.785,2.047
 1201.909,106.653,625.000,103.723,-107.250,34.253,10.600,0.021,2.459,2.994,14.675,1.970,93.076,32.209,1.918,2.194
 1202.409,106.655,634.180,102.374,-109.273,34.578,10.510,0.017,2.471,3.188,13.974,2.371,88.569,29.024,2.087,2.368
 1202.909,106.662,642.236,96.697,-112.425,32.450,10.399,0.018,2.490,3.371,12.841,2.756,83.724,25.600,2.301,2.581
 1203.409,106.523,639.648,86.908,-111.562,28.962,10.321,0.020,2.505,3.498,11.985,3.041,79.718,22.769,2.547,2.831
 1203.909,106.614,629.785,79.950,-111.247,25.155,10.295,0.023,2.515,3.480,11.377,3.209,77.174,20.971,2.807,3.091
 1204.409,106.621,629.883,74.704,-110.455,21.981,10.290,0.027,2.527,3.454,10.695,3.297,75.846,20.032,3.055,3.337
 1204.909,106.586,629.883,70.449,-111.118,20.008,10.301,0.033,2.539,3.417,10.002,3.258,75.599,19.858,3.239,3.528
 1205.409,106.650,630.322,68.985,-110.708,18.898,10.315,0.038,2.540,3.374,9.947,3.136,75.956,20.110,3.343,3.651
 1205.909,106.641,634.766,68.336,-112.084,18.803,10.321,0.040,2.530,3.380,10.554,3.005,76.816,20.718,3.374,3.708
 1206.409,106.542,630.518,67.640,-113.916,19.437,10.320,0.039,2.516,3.388,11.353,2.936,77.672,21.323,3.355,3.689
 1206.909,106.684,634.766,69.305,-113.862,20.540,10.316,0.038,2.507,3.416,11.855,2.940,78.229,21.717,3.321,3.623
 1207.409,106.559,634.766,75.013,-113.904,21.222,10.307,0.038,2.505,3.421,12.005,2.965,78.530,21.929,3.288,3.558
 1207.909,106.544,627.832,84.264,-113.998,21.180,10.282,0.039,2.505,3.377,11.972,2.987,79.238,22.430,3.275,3.521
 1208.409,106.559,628.369,89.665,-115.294,20.755,10.244,0.041,2.508,3.368,11.815,3.015,81.752,24.206,3.286,3.537
 1208.909,106.609,635.986,87.939,-114.828,20.411,10.199,0.041,2.507,3.355,11.860,3.067,84.845,26.392,3.328,3.590
 1209.409,106.558,649.414,85.356,-114.217,20.573,10.157,0.042,2.508,3.305,11.814,3.161,85.498,26.854,3.400,3.677
 1209.909,106.554,641.602,83.070,-114.634,21.090,10.118,0.040,2.505,3.289,11.965,3.299,82.930,25.039,3.494,3.784
 1210.409,106.674,636.377,80.774,-116.576,22.001,10.085,0.033,2.498,3.313,12.387,3.462,78.699,22.049,3.614,3.898
 1210.909,106.675,639.648,78.713,-118.716,22.801,10.058,0.027,2.496,3.360,12.526,3.603,76.476,20.478,3.759,4.031
 1211.409,106.686,623.730,76.127,-119.228,22.730,10.016,0.025,2.501,3.428,12.227,3.774,77.447,21.164,3.927,4.156
 1211.909,106.680,634.277,75.838,-120.165,21.443,9.899,0.028,2.499,3.547,12.361,4.085,78.254,21.734,4.112,4.278
 1212.409,106.688,634.766,74.308,-120.611,19.347,9.766,0.038,2.481,3.637,13.419,4.792,75.808,20.005,4.301,4.371
 1212.909,106.773,634.766,67.287,-123.157,17.604,9.715,0.050,2.451,3.662,15.131,5.836,70.464,16.229,4.480,4.443
 1213.409,106.697,629.883,57.795,-124.782,16.505,9.711,0.059,2.422,3.541,16.823,6.839,64.494,12.010,4.664,4.564
 1213.909,106.534,634.717,48.647,-127.301,15.642,9.711,0.064,2.408,3.471,17.656,7.614,61.818,10.119,4.873,4.767
 1214.409,106.719,625.195,45.843,-127.505,14.913,9.718,0.071,2.410,3.650,17.571,8.122,63.214,11.105,5.192,5.127
 1214.909,106.650,629.883,48.483,-126.969,14.433,9.737,0.082,2.420,3.860,16.964,8.609,65.803,12.935,5.687,5.594
 1215.409,106.699,635.449,51.500,-126.620,14.164,9.763,0.087,2.432,3.955,16.280,8.858,68.450,14.806,6.136,5.918
 1215.909,106.651,634.766,56.507,-126.774,13.587,9.782,0.082,2.442,3.947,15.673,8.379,72.223,17.472,6.314,5.915
 1216.409,106.844,643.701,65.556,-126.990,12.466,9.788,0.070,2.449,3.951,15.277,7.096,76.935,20.802,5.673,5.476
 1216.909,106.613,634.766,71.198,-126.101,11.210,9.788,0.065,2.437,3.988,15.980,5.512,81.916,24.322,4.715,4.859
 1217.409,106.760,637.988,70.937,-123.988,10.480,9.784,0.085,2.377,4.017,19.461,4.039,89.935,29.990,3.843,4.361
 1217.909,106.665,634.766,68.085,-120.752,11.088,9.837,0.119,2.231,3.772,28.028,2.846,101.200,37.950,3.118,3.822
 1218.409,106.659,634.766,66.139,-117.610,14.699,10.512,0.149,2.020,3.287,40.353,1.939,112.643,46.037,2.556,3.259
 1218.909,106.751,640.771,70.504,-116.683,22.865,11.922,0.166,1.831,2.814,51.419,1.395,117.655,49.579,2.057,2.662
 1219.409,106.764,637.109,75.756,-117.066,33.407,12.733,0.164,1.729,2.528,57.372,1.220,114.864,47.607,1.656,2.150
 1219.909,106.745,634.766,79.080,-118.340,41.991,12.883,0.150,1.691,2.492,59.581,1.155,111.870,45.491,1.382,1.843
 1220.409,106.809,634.766,79.330,-117.404,47.525,13.006,0.123,1.630,2.422,63.138,1.073,115.418,47.999,1.220,1.682
 1220.909,106.793,634.766,74.938,-115.398,52.148,13.003,0.095,1.568,2.305,66.763,0.993,121.629,52.388,1.152,1.635
 1221.409,106.838,638.916,70.365,-114.745,58.369,12.999,0.087,1.596,2.267,65.163,0.952,123.963,54.037,1.152,1.633
 1221.909,106.813,637.793,68.541,-115.148,62.283,12.961,0.110,1.768,2.386,55.085,0.975,119.691,51.018,1.195,1.632
 1222.409,106.769,634.766,71.831,-116.047,60.620,12.490,0.148,2.027,2.570,39.931,1.067,110.178,44.295,1.272,1.653
 1222.909,106.708,639.648,77.366,-116.067,53.901,11.664,0.163,2.264,2.701,26.077,1.272,99.555,36.788,1.384,1.707
 1223.409,106.844,639.648,81.254,-116.276,45.879,11.121,0.133,2.417,2.776,17.156,1.601,90.153,30.143,1.518,1.788
 1223.909,106.749,639.648,78.642,-117.187,38.903,10.785,0.076,2.488,3.066,12.992,1.993,83.075,25.141,1.668,1.878
 1224.409,106.830,654.297,69.145,-119.269,32.002,10.522,0.026,2.510,3.523,11.693,2.203,78.918,22.204,1.776,1.932
 1224.909,106.650,651.758,58.910,-120.942,25.640,10.459,0.019,2.508,3.759,11.785,2.024,77.648,21.306,1.779,1.932
 1225.409,106.861,644.531,56.312,-122.346,21.686,10.514,0.051,2.491,3.716,12.803,1.610,79.213,22.412,1.712,1.897
 1225.909,106.815,644.531,66.966,-122.176,21.947,10.631,0.100,2.452,3.291,15.070,1.185,84.387,26.069,1.591,1.800
 1226.409,106.762,635.205,81.892,-119.526,25.778,11.004,0.128,2.413,2.846,17.387,0.960,90.346,30.280,1.486,1.682
 1226.909,106.702,639.648,94.322,-119.203,31.979,11.166,0.116,2.398,2.655,18.225,0.933,94.250,33.039,1.397,1.553
 1227.409,106.763,641.016,94.185,-121.891,37.372,10.876,0.080,2.407,2.666,17.712,1.010,94.156,32.973,1.330,1.436
 1227.909,106.793,636.328,79.858,-127.862,39.663,10.681,0.043,2.419,2.993,17.009,1.130,89.695,29.820,1.294,1.364
 1228.409,106.815,629.883,61.738,-131.165,38.709,10.567,0.022,2.428,3.466,16.474,1.297,83.263,25.274,1.289,1.331
 1228.909,106.932,633.350,46.329,-133.324,35.808,10.424,0.011,2.434,3.815,16.121,1.572,77.119,20.932,1.323,1.349
 1229.409,106.859,638.477,39.333,-132.910,32.651,10.316,0.006,2.438,3.854,15.892,1.960,72.836,17.905,1.395,1.406
 1229.909,106.937,634.766,36.411,-131.320,29.982,10.230,0.007,2.439,3.648,15.867,2.447,70.397,16.181,1.489,1.480
 1230.409,106.876,639.648,37.849,-127.929,27.273,10.171,0.012,2.443,3.375,15.618,2.850,68.984,15.183,1.587,1.559
 1230.909,106.902,639.648,50.503,-127.263,24.180,10.194,0.020,2.463,3.261,14.417,3.003,67.956,14.456,1.654,1.608
 1231.409,106.779,626.660,69.458,-128.651,20.942,10.249,0.029,2.489,3.379,12.953,2.871,67.336,14.018,1.670,1.611
 1231.909,106.928,636.914,85.939,-129.932,18.304,10.270,0.031,2.497,3.557,12.464,2.555,67.303,13.995,1.624,1.563
 1232.409,106.821,641.504,91.695,-128.767,17.283,10.291,0.026,2.475,3.788,13.763,2.159,67.739,14.303,1.534,1.477
 1232.909,106.841,640.088,84.664,-128.945,17.551,10.314,0.022,2.443,3.956,15.589,1.716,68.225,14.647,1.413,1.376
 1233.409,106.849,644.531,74.446,-131.129,18.496,10.330,0.025,2.421,3.953,16.898,1.285,68.626,14.930,1.301,1.291
 1233.909,106.862,635.254,66.289,-132.508,19.620,10.338,0.031,2.403,3.883,17.927,0.940,69.178,15.320,1.212,1.235
 1234.409,106.900,637.109,62.160,-130.653,20.943,10.326,0.034,2.390,3.870,18.709,0.783,69.915,15.841,1.167,1.213
 1234.909,106.997,639.648,60.116,-129.291,22.686,10.313,0.028,2.380,3.921,19.309,0.762,70.405,16.187,1.158,1.217
 1235.409,106.905,642.529,61.566,-130.081,24.914,10.257,0.017,2.391,4.033,18.668,1.005,70.056,15.941,1.179,1.223
 1235.909,106.938,639.648,66.942,-131.159,26.304,10.070,0.007,2.411,3.994,17.457,1.536,69.016,15.205,1.208,1.223
 1236.409,106.972,647.998,71.596,-130.671,25.223,9.899,0.005,2.424,3.617,16.728,2.098,68.118,14.571,1.231,1.217
 1236.909,106.965,644.531,71.746,-133.274,22.233,9.865,0.013,2.431,3.213,16.314,2.345,68.490,14.834,1.245,1.214
 1237.409,106.889,644.531,67.573,-135.430,19.194,9.877,0.026,2.426,2.973,16.609,2.113,70.910,16.544,1.256,1.216
 1237.909,106.966,638.916,63.050,-136.178,18.669,9.870,0.035,2.410,2.831,17.530,1.710,74.479,19.067,1.252,1.202
 1238.409,106.982,634.766,57.592,-135.078,21.226,9.828,0.034,2.400,2.854,18.148,1.450,77.470,21.180,1.216,1.153
 1238.909,106.864,641.504,52.015,-133.607,24.453,9.809,0.028,2.408,2.859,17.655,1.340,78.609,21.985,1.139,1.078
 1239.409,106.915,649.414,48.194,-133.212,26.808,9.863,0.026,2.440,2.842,15.811,1.265,77.821,21.428,1.038,0.997
 1239.909,107.034,647.070,48.303,-131.108,27.977,9.986,0.027,2.464,2.861,14.365,1.137,76.525,20.513,0.954,0.940
 1240.409,106.863,654.688,51.314,-128.139,28.661,10.107,0.027,2.458,2.778,14.759,0.978,76.024,20.158,0.900,0.910
 1240.909,107.065,639.648,53.147,-127.705,30.322,10.103,0.023,2.418,2.722,17.093,0.878,76.658,20.606,0.881,0.902
 1241.409,107.011,643.604,56.554,-129.244,33.487,9.941,0.024,2.369,2.732,19.925,0.903,77.352,21.097,0.880,0.902
 1241.909,107.045,651.074,62.307,-130.664,35.811,9.815,0.035,2.350,2.669,21.063,1.139,76.510,20.502,0.884,0.900
 1242.409,107.054,654.297,69.528,-131.778,34.698,9.741,0.044,2.361,2.549,20.391,1.428,74.361,18.983,0.887,0.906
 1242.909,107.020,647.510,75.005,-132.342,29.619,9.681,0.052,2.397,2.484,18.297,1.499,72.774,17.862,0.900,0.935
 1243.409,106.998,640.088,73.028,-133.075,23.700,9.767,0.052,2.422,2.506,16.871,1.331,74.118,18.811,0.937,1.001
 1243.909,106.950,639.648,66.498,-130.969,21.623,9.932,0.041,2.421,2.664,16.895,1.047,77.938,21.511,1.010,1.116
 1244.409,106.919,644.336,60.689,-128.490,24.235,10.044,0.025,2.422,2.792,16.857,0.918,81.284,23.876,1.110,1.261
 1244.909,107.085,649.414,61.347,-126.127,29.219,10.079,0.010,2.439,2.851,15.819,1.095,81.959,24.353,1.232,1.422
 1245.409,107.104,649.365,66.529,-127.276,32.577,10.074,0.002,2.472,3.042,13.900,1.437,80.532,23.344,1.358,1.580
 1245.909,107.039,644.531,73.492,-128.569,31.939,10.033,0.005,2.512,3.321,11.585,1.825,79.228,22.422,1.514,1.757
 1246.409,107.051,644.043,82.298,-128.794,28.950,9.948,0.011,2.541,3.561,9.909,2.183,78.700,22.049,1.715,1.981
 1246.909,107.015,637.598,90.844,-128.176,26.221,9.849,0.015,2.550,3.623,9.351,2.568,78.081,21.612,2.030,2.278
 1247.409,107.023,641.113,95.417,-128.085,24.492,9.775,0.020,2.552,3.580,9.214,3.014,76.306,20.357,2.433,2.674
 1247.909,107.024,651.221,90.011,-126.611,22.582,9.744,0.028,2.558,3.741,8.875,3.557,72.743,17.840,2.908,3.126
 1248.409,106.932,659.180,75.944,-125.208,19.784,9.740,0.042,2.575,4.121,7.867,4.090,68.693,14.978,3.352,3.589
 1248.909,107.085,655.908,61.016,-124.675,16.411,9.721,0.050,2.580,4.528,7.587,4.606,65.349,12.614,3.712,3.958
 1249.409,107.019,665.039,49.095,-126.251,13.448,9.667,0.051,2.568,4.475,8.304,5.216,63.367,11.214,4.025,4.208
 1249.909,106.948,649.414,41.486,-127.697,11.167,9.589,0.048,2.548,3.782,9.477,5.713,63.030,10.975,4.294,4.390
 1250.409,107.063,650.635,36.092,-128.469,9.597,9.525,0.042,2.528,2.888,10.655,6.008,64.611,12.092,4.539,4.482
 1250.909,107.109,650.537,30.876,-129.102,8.727,9.498,0.037,2.520,2.287,11.132,6.036,67.313,14.002,4.698,4.528
 1251.409,107.059,649.414,28.442,-129.539,8.270,9.490,0.030,2.515,2.191,11.391,5.913,69.521,15.563,4.758,4.474
 1251.909,107.174,633.398,29.282,-128.238,8.020,9.491,0.028,2.514,2.253,11.460,5.708,70.601,16.326,4.663,4.358
 1252.409,107.120,634.766,35.323,-125.267,8.063,9.526,0.035,2.529,2.317,10.581,5.178,71.297,16.818,4.450,4.228
 1252.909,107.199,634.766,46.160,-124.205,8.865,9.626,0.045,2.558,2.406,8.918,4.410,74.274,18.922,4.206,4.111
 1253.409,107.135,634.766,58.771,-123.895,10.978,9.754,0.047,2.581,2.580,7.546,3.620,80.542,23.351,3.980,4.033
 1253.909,107.149,634.766,72.302,-123.299,13.824,9.845,0.037,2.588,2.829,7.109,3.052,86.537,27.588,3.816,3.939
 1254.409,107.068,641.797,84.312,-121.497,16.626,9.873,0.022,2.577,3.013,7.798,2.812,89.238,29.497,3.680,3.809
 1254.909,106.929,644.531,89.670,-120.061,18.823,9.869,0.015,2.563,3.134,8.598,2.838,87.335,28.152,3.534,3.609
 1255.409,107.111,651.807,81.844,-120.753,19.869,9.837,0.019,2.556,3.365,8.996,3.206,81.640,24.127,3.348,3.379
 1255.909,107.118,654.297,65.154,-122.834,19.576,9.788,0.029,2.549,3.518,9.437,3.612,76.056,20.181,3.159,3.161
 1256.409,107.189,651.709,48.194,-123.211,17.469,9.763,0.034,2.531,3.516,10.448,3.678,71.370,16.870,3.018,3.025
 1256.909,107.097,654.297,35.945,-126.426,14.837,9.773,0.031,2.504,3.334,12.072,3.440,67.661,14.248,2.963,2.983
 1257.409,107.132,654.297,29.642,-128.076,13.338,9.825,0.025,2.483,3.231,13.282,3.222,65.099,12.438,2.982,3.013
 1257.909,107.164,653.223,27.332,-129.193,13.298,9.901,0.022,2.479,3.406,13.519,3.431,63.168,11.073,3.028,3.048
 1258.409,107.214,647.607,27.622,-127.087,13.821,9.965,0.023,2.494,3.530,12.639,4.133,61.597,9.963,3.035,3.030
 1258.909,107.328,649.414,28.836,-127.857,13.621,10.020,0.024,2.521,3.642,11.074,4.760,60.096,8.902,2.983,2.959
 1259.409,107.201,649.414,27.483,-130.072,12.490,10.096,0.022,2.545,3.697,9.658,4.721,58.597,7.842,2.913,2.902
 1259.909,107.355,649.414,25.030,-131.222,11.387,10.165,0.020,2.553,3.793,9.204,4.014,57.983,7.408,2.873,2.900
 1260.409,107.235,652.979,25.733,-127.632,11.115,10.204,0.017,2.538,3.818,10.035,3.049,59.091,8.192,2.890,2.968
 1260.909,107.154,644.531,31.706,-124.967,11.699,10.266,0.015,2.519,3.719,11.146,2.465,62.120,10.332,2.960,3.083
 1261.409,107.210,644.531,43.116,-123.028,12.717,10.347,0.016,2.511,3.649,11.626,2.474,66.902,13.712,3.053,3.202
 1261.909,107.228,647.949,52.815,-123.685,14.075,10.410,0.022,2.518,3.577,11.244,3.055,72.227,17.475,3.159,3.305
 1262.409,107.206,644.531,53.576,-121.814,15.728,10.443,0.027,2.525,3.566,10.845,4.140,79.314,22.484,3.277,3.388
 1262.909,107.302,656.006,44.452,-122.108,16.518,10.459,0.025,2.530,3.605,10.509,5.342,87.471,28.248,3.417,3.470
 1263.409,107.167,659.180,33.150,-122.973,15.479,10.480,0.019,2.541,3.744,9.865,6.037,94.567,33.263,3.580,3.572
 1263.909,107.263,657.275,29.339,-123.443,12.759,10.503,0.011,2.551,3.975,9.302,5.731,101.106,37.884,3.745,3.689
 1264.409,107.315,654.297,34.477,-119.094,10.117,10.540,0.009,2.561,3.957,8.707,4.732,113.352,46.538,3.873,3.795
 1264.909,107.287,649.414,48.795,-117.033,9.537,10.624,0.019,2.576,3.697,7.807,3.669,133.612,60.857,3.859,3.811
 1265.409,107.452,654.150,63.221,-115.616,10.836,10.723,0.031,2.594,3.438,6.772,2.946,154.217,75.418,3.710,3.715
 1265.909,107.439,664.063,70.431,-116.692,13.308,10.765,0.033,2.596,3.269,6.665,2.688,165.695,83.530,3.388,3.467
 1266.409,107.340,659.131,69.863,-115.541,15.590,10.776,0.027,2.582,3.256,7.502,2.586,168.606,85.587,3.036,3.145
 1266.909,107.412,654.297,66.006,-113.063,16.884,10.795,0.030,2.559,3.272,8.829,2.391,170.488,86.918,2.709,2.831
 1267.409,107.533,654.004,67.948,-111.660,17.632,10.818,0.049,2.535,3.191,10.214,2.080,174.238,89.568,2.415,2.532
 1267.909,107.310,649.414,73.495,-110.808,18.517,10.868,0.079,2.508,3.061,11.792,1.741,180.039,93.667,2.183,2.300
 1268.409,107.494,654.297,76.575,-107.867,19.996,11.176,0.100,2.476,2.897,13.671,1.507,183.373,96.023,1.969,2.101
 1268.909,107.526,654.297,75.011,-105.569,22.501,11.730,0.108,2.427,2.835,16.560,1.399,181.515,94.710,1.796,1.949
 1269.409,107.358,667.383,73.135,-104.284,26.107,11.666,0.121,2.367,2.818,20.033,1.310,177.458,91.843,1.666,1.853
 1269.909,107.579,659.180,73.804,-105.293,30.348,11.541,0.132,2.314,2.711,23.133,1.222,173.749,89.222,1.597,1.804
 1270.409,107.483,653.271,74.431,-105.228,34.647,11.666,0.124,2.301,2.597,23.914,1.166,170.512,86.934,1.577,1.796
 1270.909,107.638,652.979,73.444,-105.313,37.568,11.203,0.092,2.342,2.577,21.510,1.194,165.754,83.572,1.592,1.788
 1271.409,107.393,656.738,71.608,-105.870,37.360,10.639,0.054,2.400,2.796,18.152,1.299,156.758,77.214,1.603,1.761
 1271.909,107.576,667.871,72.099,-105.505,33.740,10.292,0.044,2.433,3.080,16.209,1.392,144.373,68.461,1.624,1.753
 1272.409,107.476,668.945,75.095,-104.040,28.352,10.531,0.059,2.409,3.227,17.608,1.438,129.034,57.622,1.642,1.777
 1272.909,107.493,660.840,76.806,-101.886,24.245,11.608,0.084,2.325,3.256,22.514,1.441,112.705,46.081,1.692,1.861
 1273.409,107.426,654.297,74.530,-101.095,23.554,12.354,0.105,2.173,3.081,31.381,1.391,103.319,39.448,1.771,1.983
 1273.909,107.512,654.297,69.594,-102.079,25.406,12.604,0.116,1.982,2.790,42.557,1.308,102.744,39.042,1.859,2.106
 1274.409,107.555,663.086,66.510,-102.353,29.311,12.900,0.118,1.822,2.508,51.933,1.235,107.599,42.473,1.925,2.197
 1274.909,107.467,668.945,67.146,-102.611,33.827,13.007,0.120,1.749,2.291,56.198,1.229,110.353,44.419,1.939,2.223
 1275.409,107.463,666.260,68.815,-104.400,36.860,13.006,0.123,1.773,2.282,54.770,1.299,106.413,41.635,1.923,2.180
 1275.909,107.668,668.945,70.979,-106.500,37.324,13.004,0.129,1.833,2.331,51.260,1.370,99.991,37.096,1.909,2.138
 1276.409,107.517,668.945,73.563,-106.809,36.062,13.002,0.132,1.881,2.391,48.507,1.379,94.767,33.404,1.942,2.114
 1276.909,107.573,659.180,75.264,-107.002,35.698,12.994,0.133,1.912,2.426,46.694,1.354,92.054,31.487,2.002,2.151
 1277.409,107.425,659.180,73.058,-106.514,36.719,12.961,0.138,1.956,2.428,44.110,1.334,91.807,31.312,2.078,2.204
 1277.909,107.589,669.629,66.107,-106.754,37.930,12.952,0.144,2.024,2.468,40.096,1.332,91.537,31.122,2.123,2.254
 1278.409,107.589,678.711,60.463,-106.123,38.357,12.988,0.141,2.096,2.563,35.925,1.342,91.520,31.110,2.126,2.260
 1278.909,107.570,664.600,57.986,-107.846,39.280,13.004,0.133,2.144,2.670,33.075,1.341,92.570,31.852,2.109,2.247
 1279.409,107.631,665.820,60.391,-110.047,41.404,13.004,0.127,2.157,2.718,32.349,1.320,95.287,33.772,2.081,2.221
 1279.909,107.547,664.063,66.015,-112.521,43.047,13.004,0.127,2.157,2.693,32.350,1.279,102.167,38.634,2.043,2.200
 1280.409,107.578,667.432,69.788,-110.024,43.387,12.998,0.127,2.169,2.724,31.658,1.227,115.503,48.059,1.986,2.180
 1280.909,107.674,668.945,71.687,-109.405,41.320,12.885,0.127,2.197,2.825,30.016,1.168,130.209,58.452,1.902,2.154
 1281.409,107.679,661.816,69.697,-109.899,38.247,12.567,0.135,2.227,2.923,28.262,1.106,142.940,67.449,1.817,2.122
 1281.909,107.505,670.215,66.837,-111.567,37.073,12.437,0.143,2.225,2.925,28.371,1.059,150.549,72.826,1.748,2.083
 1282.409,107.712,673.828,66.928,-109.236,39.008,12.545,0.137,2.189,2.848,30.447,1.043,148.976,71.714,1.712,2.064
 1282.909,107.454,665.918,68.400,-108.683,43.692,12.724,0.119,2.148,2.802,32.851,1.076,140.685,65.855,1.717,2.085
 1283.409,107.670,667.285,70.683,-108.723,47.586,12.883,0.106,2.148,2.804,32.887,1.165,130.944,58.971,1.754,2.142
 1283.909,107.373,670.654,69.734,-109.341,47.296,12.818,0.106,2.217,2.888,28.813,1.364,124.567,54.464,1.845,2.245
 1284.409,107.516,669.531,65.293,-105.473,43.259,12.669,0.105,2.326,3.049,22.473,1.757,123.556,53.750,1.992,2.392
 1284.909,107.589,668.945,58.318,-104.020,36.814,11.798,0.098,2.442,3.297,15.693,2.406,121.746,52.471,2.241,2.607
 1285.409,107.636,668.945,49.034,-103.998,29.497,11.126,0.086,2.539,3.559,10.017,3.239,114.712,47.500,2.611,2.934
 1285.909,107.583,673.828,41.437,-105.553,22.440,11.133,0.077,2.595,3.832,6.736,4.069,103.129,39.314,3.149,3.421
 1286.409,107.507,664.355,36.542,-101.671,16.272,10.901,0.071,2.623,4.055,5.096,4.718,89.249,29.505,3.839,4.124
 1286.909,107.666,668.945,33.099,-98.741,12.560,10.791,0.062,2.621,4.161,5.178,5.065,77.819,21.427,4.618,5.071
 1287.409,107.562,668.750,32.275,-98.538,11.005,10.727,0.057,2.622,4.171,5.120,5.199,72.130,17.406,5.374,6.079
 1287.909,107.588,664.551,33.225,-102.143,10.668,10.703,0.053,2.625,4.078,4.993,5.227,72.627,17.758,5.907,6.828
 1288.409,107.612,673.828,35.029,-101.886,10.680,10.688,0.044,2.622,3.990,5.163,5.297,76.479,20.480,6.230,7.052
 1288.909,107.545,670.947,36.497,-101.477,10.833,10.662,0.037,2.623,4.095,5.066,5.506,80.970,23.654,6.210,6.741
 1289.409,107.669,668.945,37.723,-101.388,10.913,10.587,0.030,2.623,4.450,5.064,5.809,87.153,28.023,5.977,6.168
 1289.909,107.434,675.195,39.397,-103.191,10.871,10.517,0.023,2.622,4.788,5.132,5.905,96.476,34.612,5.528,5.544
 1290.409,107.548,678.711,41.361,-101.833,10.761,10.503,0.021,2.620,4.829,5.260,5.478,108.451,43.075,5.005,4.955
 1290.909,107.542,678.711,50.627,-100.971,11.030,10.504,0.025,2.614,4.458,5.590,4.578,120.353,51.486,4.429,4.394
 1291.409,107.513,668.945,75.740,-100.039,12.413,10.502,0.032,2.609,3.969,5.887,3.648,130.746,58.831,3.869,3.866
 1291.909,107.468,672.559,112.524,-100.661,14.970,10.490,0.034,2.604,3.662,6.174,3.030,143.353,67.741,3.336,3.378
 1292.409,107.601,675.098,139.491,-98.234,17.494,10.480,0.032,2.591,3.504,6.932,2.664,157.043,77.416,2.890,2.989
 1292.909,107.581,686.426,144.656,-97.559,19.245,10.504,0.033,2.577,3.358,7.805,2.315,169.382,86.136,2.548,2.701
 1293.409,107.608,678.711,135.173,-98.074,20.672,10.550,0.040,2.558,3.195,8.890,1.983,177.853,92.123,2.307,2.500
 1293.909,107.413,666.553,124.136,-100.229,22.357,10.580,0.047,2.540,3.055,9.969,1.775,181.712,94.850,2.148,2.351
 1294.409,107.444,678.711,119.045,-100.097,24.218,10.568,0.048,2.530,3.005,10.545,1.745,183.539,96.140,2.042,2.237
 1294.909,107.562,678.711,120.598,-98.933,25.272,10.529,0.043,2.530,3.035,10.551,1.800,183.058,95.801,1.974,2.150
 1295.409,107.471,682.715,123.732,-97.726,25.330,10.507,0.033,2.534,3.036,10.305,1.865,177.954,92.193,1.928,2.100
 1295.909,107.619,674.854,127.090,-97.689,25.965,10.473,0.021,2.533,3.019,10.379,1.918,166.520,84.113,1.909,2.082
 1296.409,107.588,680.420,126.108,-96.145,27.058,10.418,0.017,2.531,3.022,10.452,1.961,150.897,73.072,1.921,2.119
 1296.909,107.645,674.121,120.392,-93.802,27.537,10.371,0.018,2.532,3.020,10.416,1.989,137.145,63.353,1.973,2.208
 1297.409,107.706,673.828,115.355,-94.849,26.967,10.339,0.024,2.534,3.074,10.279,1.997,128.638,57.341,2.095,2.384
 1297.909,107.481,678.711,109.933,-96.374,26.611,10.302,0.030,2.536,3.159,10.163,2.061,118.585,50.237,2.281,2.651
 1298.409,107.657,678.711,106.072,-97.656,27.644,10.174,0.031,2.535,3.304,10.245,2.481,102.766,39.057,2.565,2.996
 1298.909,107.479,679.395,96.952,-97.061,27.910,10.028,0.024,2.535,3.488,10.249,3.795,85.442,26.814,2.920,3.390
 1299.409,107.424,682.617,80.289,-97.630,24.535,9.862,0.014,2.554,3.775,9.109,6.577,73.163,18.136,3.354,3.759
 1299.909,107.450,675.781,63.272,-99.552,18.095,9.715,0.008,2.589,4.169,7.076,9.270,70.503,16.257,3.816,4.094
 1300.409,107.584,670.166,55.881,-99.691,11.130,9.696,0.015,2.629,4.393,4.757,10.005,74.268,18.918,4.315,4.450
 1300.909,107.587,668.945,61.277,-98.600,6.806,9.744,0.030,2.651,4.438,3.422,8.579,80.782,23.521,4.748,4.789
 1301.409,107.593,668.945,69.996,-98.712,6.180,9.830,0.042,2.650,4.326,3.538,6.161,85.562,26.899,4.990,5.066
 1301.909,107.479,680.859,73.960,-99.649,8.122,9.913,0.045,2.638,4.161,4.230,4.573,87.689,28.402,4.954,5.131
 1302.409,107.457,688.477,70.770,-100.896,11.105,9.987,0.037,2.619,3.983,5.299,3.982,90.407,30.323,4.643,4.914
 1302.909,107.629,676.465,66.871,-99.662,13.552,10.042,0.027,2.603,3.700,6.234,3.715,96.067,34.323,4.275,4.562
 1303.409,107.411,679.736,65.829,-99.343,15.064,10.069,0.022,2.594,3.477,6.791,3.542,104.412,40.221,3.954,4.176
 1303.909,107.504,680.225,65.109,-97.915,16.291,10.080,0.017,2.585,3.383,7.299,3.448,110.694,44.660,3.706,3.837
 1304.409,107.447,700.000,63.494,-95.779,17.455,10.084,0.011,2.576,3.394,7.843,3.398,113.530,46.664,3.518,3.574
 1304.909,107.597,688.477,61.048,-93.959,18.108,10.096,0.007,2.568,3.480,8.333,3.304,113.782,46.843,3.353,3.370
 1305.409,107.646,684.131,59.820,-94.685,17.821,10.117,0.008,2.561,3.594,8.693,3.122,115.542,48.086,3.193,3.216
 1305.909,107.533,673.828,63.129,-97.413,17.111,10.152,0.015,2.561,3.554,8.718,2.876,120.004,51.239,3.040,3.087
 1306.409,107.583,664.746,69.097,-98.113,17.070,10.193,0.023,2.564,3.427,8.534,2.661,123.970,54.043,2.890,2.977
 1306.909,107.594,654.297,76.683,-95.441,18.020,10.251,0.025,2.564,3.309,8.524,2.536,125.354,55.020,2.755,2.891
 1307.409,107.684,654.297,79.240,-94.637,19.470,10.307,0.024,2.565,3.220,8.457,2.487,125.172,54.892,2.654,2.835
 1307.909,107.653,666.650,76.068,-93.701,20.660,10.327,0.023,2.564,3.236,8.524,2.447,124.922,54.715,2.621,2.838
 1308.409,107.750,668.945,74.001,-94.336,21.552,10.330,0.021,2.553,3.243,9.178,2.407,124.924,54.716,2.629,2.854
 1308.909,107.501,666.260,73.842,-93.363,22.737,10.289,0.020,2.534,3.238,10.311,2.471,124.214,54.215,2.657,2.821
 1309.409,107.515,664.844,76.528,-95.179,23.982,10.256,0.019,2.516,3.389,11.365,2.769,122.716,53.156,2.617,2.693
 1309.909,107.482,673.828,73.615,-99.164,24.036,10.225,0.018,2.506,3.696,11.934,3.201,121.537,52.323,2.474,2.488
 1310.409,107.519,668.311,66.711,-103.287,22.044,10.097,0.027,2.483,3.905,13.262,3.294,122.265,52.837,2.288,2.323
 1310.909,107.624,667.236,69.316,-105.212,18.942,10.075,0.052,2.446,3.691,15.437,2.862,123.705,53.855,2.135,2.248
 1311.409,107.613,668.945,78.580,-105.852,18.045,10.501,0.073,2.411,3.172,17.496,2.210,124.650,54.523,2.063,2.279
 1311.909,107.653,668.945,92.426,-105.068,22.319,10.560,0.079,2.374,2.737,19.676,1.758,124.110,54.141,2.080,2.387
 1312.409,107.562,664.063,97.754,-101.130,29.802,10.235,0.074,2.343,2.590,21.461,1.851,119.439,50.840,2.159,2.507
 1312.909,107.545,660.400,87.529,-98.456,35.274,10.307,0.060,2.349,2.863,21.107,2.910,111.576,45.283,2.282,2.607
 1313.409,107.554,673.828,70.225,-97.624,33.630,10.083,0.047,2.419,3.387,17.040,4.641,102.690,39.004,2.423,2.670
 1313.909,107.589,673.828,54.141,-98.729,25.224,9.656,0.033,2.518,3.806,11.221,5.931,95.804,34.137,2.603,2.750
 1314.409,107.549,675.391,49.441,-96.734,15.974,9.646,0.021,2.578,3.911,7.743,6.045,94.459,33.187,2.820,2.877
 1314.909,107.454,678.711,52.386,-94.994,11.195,9.742,0.025,2.574,3.752,7.976,5.072,99.591,36.813,3.028,3.007
 1315.409,107.653,670.215,58.499,-92.357,11.981,9.804,0.050,2.541,3.555,9.862,3.935,109.701,43.959,3.086,3.070
 1315.909,107.600,668.408,69.363,-92.837,15.433,10.115,0.079,2.513,3.464,11.507,3.187,121.150,52.050,2.905,2.969
 1316.409,107.560,674.951,81.624,-91.511,19.149,10.564,0.097,2.475,3.394,13.759,2.608,131.087,59.072,2.571,2.742
 1316.909,107.683,674.414,92.778,-91.820,22.402,10.578,0.112,2.426,3.240,16.591,2.184,137.811,63.824,2.247,2.502
 1317.409,107.560,673.828,97.901,-92.852,25.747,10.764,0.129,2.364,3.143,20.241,1.936,140.929,66.028,2.033,2.325
 1317.909,107.692,688.330,96.377,-95.120,30.037,10.970,0.148,2.289,3.066,24.627,1.727,141.432,66.383,1.925,2.231
 1318.409,107.701,676.221,93.157,-95.160,35.723,10.928,0.152,2.223,2.876,28.482,1.638,138.472,64.291,1.897,2.188
 1318.909,107.694,673.828,87.823,-96.389,41.398,11.206,0.133,2.214,2.755,29.002,1.765,133.649,60.883,1.910,2.173
 1319.409,107.662,676.563,78.624,-99.724,42.831,11.055,0.098,2.300,2.935,23.962,2.113,129.409,57.886,1.946,2.184
 1319.909,107.743,678.711,70.279,-102.324,38.915,10.462,0.062,2.417,3.216,17.145,2.443,126.711,55.979,2.017,2.241
 1320.409,107.590,678.711,68.241,-101.493,31.658,10.155,0.042,2.476,3.408,13.694,2.559,127.050,56.219,2.171,2.422
 1320.909,107.710,668.945,69.692,-99.205,25.931,10.122,0.055,2.465,3.335,14.315,2.542,125.585,55.184,2.426,2.721
 1321.409,107.579,668.945,69.099,-97.252,24.545,10.075,0.077,2.443,3.095,15.641,2.840,115.773,48.249,2.815,3.169
 1321.909,107.525,661.816,60.636,-99.227,25.342,10.052,0.077,2.469,3.000,14.089,3.795,100.990,37.802,3.291,3.696
 1322.409,107.660,673.828,48.691,-99.505,25.040,9.929,0.049,2.533,3.089,10.376,5.172,86.761,27.746,3.782,4.207
 1322.909,107.678,680.957,39.684,-100.121,22.349,9.670,0.019,2.586,3.294,7.229,6.388,79.345,22.505,4.263,4.751
 1323.409,107.698,677.490,34.922,-100.982,17.970,9.516,0.008,2.605,3.462,6.156,7.117,78.590,21.972,4.803,5.319
 1323.909,107.631,673.828,34.381,-102.014,14.029,9.481,0.009,2.603,3.636,6.280,7.374,77.941,21.513,5.489,5.982
 1324.409,107.502,673.828,35.374,-102.856,11.895,9.479,0.015,2.613,3.816,5.666,7.521,74.172,18.850,6.390,6.750
 1324.909,107.701,673.828,37.429,-101.869,11.028,9.463,0.018,2.631,3.959,4.592,7.793,68.605,14.915,7.295,7.507
 1325.409,107.726,669.678,38.884,-104.079,10.411,9.442,0.017,2.641,4.094,4.021,8.239,64.934,12.321,8.039,8.162
 1325.909,107.616,680.518,36.983,-107.084,9.584,9.437,0.012,2.631,4.192,4.601,8.793,64.331,11.895,8.464,8.439
 1326.409,107.787,683.594,32.155,-108.967,8.598,9.437,0.007,2.616,4.271,5.525,9.243,64.263,11.847,8.541,8.259
 1326.909,107.526,676.660,27.765,-107.202,7.735,9.438,0.005,2.607,4.419,6.012,9.565,62.830,10.834,8.324,7.771
 1327.409,107.647,683.008,30.011,-106.998,7.071,9.443,0.005,2.610,4.534,5.866,9.583,60.507,9.193,7.953,7.307
 1327.909,107.562,679.004,43.122,-107.075,6.677,9.457,0.011,2.620,4.448,5.245,8.767,60.384,9.105,7.580,7.054
 1328.409,107.662,678.662,61.526,-107.117,6.792,9.484,0.020,2.626,4.169,4.915,7.302,63.936,11.615,7.364,7.051
 1328.909,107.715,678.711,80.956,-104.022,8.207,9.495,0.026,2.618,3.788,5.382,6.015,68.779,15.038,7.325,7.207
 1329.409,107.773,688.281,91.643,-103.775,10.641,9.481,0.025,2.598,3.602,6.575,6.037,72.456,17.637,7.360,7.299
 1329.909,107.759,683.594,87.503,-104.285,12.479,9.459,0.018,2.579,3.502,7.668,7.607,74.917,19.376,7.381,7.198
 1330.409,107.783,678.711,76.578,-105.223,12.400,9.427,0.016,2.582,3.428,7.479,9.199,77.643,21.303,7.278,6.887
 1330.909,107.815,684.668,65.897,-102.135,10.289,9.440,0.022,2.608,3.506,5.941,9.569,83.400,25.371,6.986,6.435
 1331.409,107.751,687.207,62.915,-102.096,8.073,9.490,0.031,2.637,3.708,4.243,8.637,90.617,30.472,6.442,5.845
 1331.909,107.715,681.934,66.408,-100.505,7.144,9.556,0.037,2.651,3.996,3.434,7.047,100.462,37.429,5.660,5.158
 1332.409,107.766,688.477,72.139,-99.539,7.384,9.622,0.035,2.639,4.112,4.147,5.471,110.872,44.786,4.797,4.495
 1332.909,107.704,681.543,79.556,-95.219,8.534,9.688,0.034,2.610,3.928,5.835,4.089,117.798,49.681,4.025,3.922
 1333.409,107.663,682.471,90.544,-93.212,10.738,9.774,0.032,2.573,3.615,8.028,3.055,118.838,50.416,3.418,3.472
 1333.909,107.603,678.711,104.974,-92.155,14.535,9.850,0.028,2.534,3.339,10.305,2.427,115.183,47.832,2.979,3.107
 1334.409,107.634,675.195,116.770,-92.640,19.265,9.894,0.022,2.508,3.198,11.808,2.206,110.957,44.846,2.668,2.816
 1334.909,107.686,678.711,120.901,-92.055,23.288,9.912,0.020,2.501,3.234,12.247,2.200,107.347,42.295,2.454,2.595
 1335.409,107.801,680.322,118.971,-92.623,25.401,9.920,0.027,2.513,3.332,11.516,2.226,104.513,40.292,2.318,2.447
 1335.909,107.708,683.594,116.097,-92.317,26.313,9.929,0.036,2.529,3.350,10.608,2.223,101.284,38.010,2.240,2.364
 1336.409,107.737,685.400,116.713,-93.159,27.321,9.936,0.041,2.537,3.340,10.095,2.199,97.577,35.390,2.213,2.334
 1336.909,107.663,675.293,118.732,-93.693,28.477,9.938,0.035,2.527,3.326,10.690,2.179,94.083,32.921,2.215,2.338
 1337.409,107.699,683.594,117.379,-95.069,29.709,9.963,0.023,2.506,3.310,11.906,2.186,90.809,30.607,2.234,2.359
 1337.909,107.721,683.594,115.931,-94.314,30.820,9.995,0.013,2.493,3.306,12.692,2.213,88.695,29.113,2.255,2.392
 1338.409,107.701,688.477,111.643,-91.813,31.220,10.009,0.010,2.487,3.323,13.064,2.245,89.647,29.786,2.281,2.430
 1338.909,107.709,688.477,105.641,-89.399,30.752,10.021,0.012,2.487,3.351,13.054,2.290,92.577,31.856,2.318,2.482
 1339.409,107.711,681.055,102.541,-90.947,29.270,10.030,0.014,2.491,3.418,12.827,2.355,97.092,35.047,2.376,2.547
 1339.909,107.743,678.711,101.615,-92.607,27.645,10.039,0.015,2.500,3.460,12.300,2.445,101.920,38.459,2.450,2.614
 1340.409,107.595,675.928,98.922,-93.827,26.503,10.055,0.015,2.519,3.570,11.178,2.571,105.606,41.065,2.518,2.659
 1340.909,107.789,683.154,88.915,-91.234,25.440,10.071,0.017,2.542,3.726,9.845,2.694,108.254,42.936,2.551,2.652
 1341.409,107.748,678.711,76.379,-91.393,24.198,10.094,0.022,2.560,3.769,8.789,2.730,112.242,45.754,2.518,2.580
 1341.909,107.758,678.027,71.343,-90.972,23.077,10.134,0.027,2.566,3.712,8.418,2.637,116.572,48.814,2.422,2.460
 1342.409,107.725,667.383,73.443,-90.742,22.259,10.204,0.035,2.553,3.598,9.189,2.392,121.356,52.195,2.288,2.328
 1342.909,107.871,666.846,77.912,-89.524,21.888,10.284,0.052,2.526,3.460,10.746,2.048,125.270,54.961,2.148,2.209
 1343.409,107.842,685.645,80.658,-90.495,22.161,10.538,0.072,2.499,3.254,12.318,1.730,125.929,55.427,2.020,2.108
 1343.909,107.743,686.230,79.682,-92.016,23.889,10.689,0.075,2.476,3.076,13.706,1.540,125.317,54.994,1.910,2.017
 1344.409,107.749,686.133,75.078,-95.261,27.484,10.491,0.056,2.471,3.059,13.988,1.518,121.478,52.281,1.816,1.931
 1344.909,107.785,668.945,71.754,-95.665,30.930,10.374,0.028,2.482,3.202,13.333,1.593,113.246,46.464,1.750,1.865
 1345.409,107.679,676.855,72.220,-98.898,32.674,10.351,0.015,2.502,3.326,12.171,1.653,102.541,38.898,1.714,1.826
 1345.909,107.774,681.934,71.183,-99.073,32.020,10.308,0.015,2.516,3.301,11.358,1.669,92.419,31.745,1.709,1.819
 1346.409,107.725,688.477,69.014,-99.780,30.156,10.230,0.014,2.515,3.181,11.409,1.677,87.027,27.934,1.728,1.845
 1346.909,107.847,680.566,67.329,-97.013,29.090,10.129,0.011,2.508,3.149,11.813,1.688,87.736,28.436,1.760,1.890
 1347.409,107.920,679.199,68.300,-96.303,28.986,10.018,0.007,2.496,3.151,12.507,1.695,92.934,32.108,1.795,1.936
 1347.909,107.810,680.811,76.312,-96.601,29.749,9.925,0.006,2.483,3.176,13.246,1.692,102.543,38.900,1.811,1.942
 1348.409,107.843,678.955,85.947,-97.373,30.819,9.865,0.009,2.460,3.216,14.604,1.669,113.831,46.877,1.769,1.880
 1348.909,107.707,683.594,91.493,-98.600,31.302,9.840,0.017,2.418,3.253,17.082,1.613,124.011,54.072,1.647,1.755
 1349.409,107.774,678.711,93.045,-99.573,31.509,9.907,0.034,2.359,3.257,20.500,1.520,133.170,60.544,1.491,1.635
 1349.909,107.839,671.289,88.094,-99.886,32.697,10.339,0.063,2.264,3.168,26.092,1.388,141.139,66.176,1.367,1.601
 1350.409,107.625,669.189,81.086,-100.350,35.865,11.297,0.087,2.091,2.901,36.206,1.234,149.336,71.969,1.310,1.675
 1350.909,107.833,679.395,73.082,-101.788,42.868,12.363,0.082,1.837,2.469,51.066,1.113,156.336,76.916,1.347,1.873
 1351.409,107.896,673.828,65.601,-103.622,52.495,12.905,0.067,1.667,2.143,61.018,1.159,157.554,77.777,1.454,2.119
 1351.909,107.802,667.773,59.521,-103.930,58.933,12.779,0.060,1.755,2.205,55.853,1.700,150.126,72.527,1.627,2.304
 1352.409,107.831,675.195,53.648,-100.061,56.905,11.664,0.061,2.041,2.694,39.098,2.814,134.978,61.822,1.842,2.429
 1352.909,107.920,683.594,48.293,-96.960,45.762,10.494,0.058,2.363,3.408,20.302,4.235,116.353,48.660,2.152,2.621
 1353.409,107.776,679.639,43.288,-95.414,32.218,10.249,0.039,2.547,3.907,9.523,5.405,99.262,36.581,2.635,3.051
 1353.909,107.883,683.594,39.732,-94.930,22.692,10.254,0.016,2.598,3.977,6.553,6.098,85.266,26.690,3.512,3.902
 1354.409,107.727,681.250,36.133,-94.234,18.210,10.232,0.005,2.604,3.847,6.216,6.528,75.932,20.094,4.939,5.318
 1354.909,107.839,670.117,31.386,-92.919,16.277,10.204,0.003,2.602,3.795,6.305,6.874,71.833,17.196,6.766,7.201
 1355.409,107.719,671.777,29.412,-93.611,14.830,10.182,0.004,2.603,3.897,6.266,7.072,70.051,15.937,7.935,8.900
 1355.909,107.960,678.711,29.680,-95.960,13.711,10.155,0.005,2.603,3.986,6.282,7.101,68.445,14.802,7.936,9.579
 1356.409,107.882,683.594,31.425,-96.405,13.163,10.066,0.004,2.599,3.988,6.496,7.058,67.049,13.816,7.663,9.205
 1356.909,107.847,675.195,33.622,-96.967,12.921,9.922,0.003,2.592,3.971,6.880,7.169,65.780,12.919,7.686,8.621
 1357.409,107.905,677.539,34.516,-97.266,12.317,9.797,0.002,2.596,4.155,6.673,7.597,65.754,12.901,8.000,8.222
 1357.909,107.803,683.594,38.126,-98.901,11.237,9.693,0.000,2.605,4.527,6.140,8.429,66.516,13.439,8.284,7.980
 1358.409,107.903,685.693,52.811,-98.910,9.954,9.631,-0.003,2.610,4.653,5.872,9.561,68.484,14.830,8.360,7.747
 1358.909,107.749,683.838,69.761,-95.922,8.669,9.594,-0.003,2.618,4.495,5.396,10.383,71.932,17.266,8.099,7.328
 1359.409,107.924,681.250,81.603,-96.162,7.440,9.589,0.003,2.621,4.054,5.213,10.113,75.306,19.651,7.565,6.781
 1359.909,107.762,688.477,92.409,-96.326,6.702,9.599,0.012,2.617,3.652,5.427,8.779,76.778,20.691,6.855,6.231
 1360.409,107.852,683.594,104.764,-95.823,7.522,9.624,0.020,2.606,3.582,6.104,6.912,75.762,19.973,6.052,5.699
 1360.909,107.819,678.955,118.656,-92.598,9.866,9.654,0.023,2.587,3.468,7.201,5.362,74.804,19.296,5.350,5.275
 1361.409,107.792,683.594,120.415,-92.011,13.568,9.668,0.022,2.576,3.306,7.862,4.497,76.203,20.285,4.818,4.972
 1361.909,107.834,684.082,111.824,-94.266,17.310,9.655,0.019,2.568,3.226,8.302,4.067,79.290,22.467,4.492,4.799
 1362.409,107.873,685.449,100.297,-95.854,20.137,9.594,0.017,2.558,3.210,8.903,3.871,81.311,23.895,4.370,4.759
 1362.909,107.728,684.326,89.763,-95.597,22.123,9.530,0.017,2.548,3.241,9.491,4.178,80.801,23.534,4.376,4.737
 1363.409,107.881,685.205,78.434,-94.770,22.404,9.494,0.013,2.543,3.368,9.754,5.472,77.663,21.317,4.446,4.690
 1363.909,107.976,683.594,64.613,-93.860,20.456,9.448,0.008,2.553,3.572,9.206,6.877,74.527,19.101,4.495,4.589
 1364.409,107.781,680.078,55.920,-92.505,16.474,9.462,0.010,2.576,3.732,7.832,7.295,73.791,18.580,4.496,4.507
 1364.909,107.912,685.938,53.855,-89.051,12.858,9.574,0.017,2.596,3.713,6.676,6.405,76.569,20.544,4.453,4.487
 1365.409,107.793,693.359,54.790,-87.107,11.909,9.701,0.021,2.599,3.545,6.475,4.889,81.564,24.074,4.356,4.486
 1365.909,107.816,685.010,59.871,-86.725,13.375,9.789,0.019,2.591,3.476,6.935,3.947,87.294,28.123,4.206,4.439
 1366.409,107.908,680.566,67.813,-86.232,15.514,9.837,0.016,2.585,3.572,7.317,3.563,94.658,33.327,3.987,4.287
 1366.909,107.899,678.711,75.263,-85.908,16.987,9.859,0.016,2.583,3.664,7.420,3.404,104.043,39.960,3.740,4.043
 1367.409,107.865,682.910,78.333,-86.275,17.869,9.877,0.019,2.587,3.674,7.220,3.372,113.375,46.555,3.497,3.772
 1367.909,107.833,679.785,74.873,-87.418,18.606,9.870,0.018,2.587,3.634,7.169,3.403,120.096,51.304,3.317,3.538
 1368.409,107.890,682.715,69.599,-87.894,19.081,9.825,0.016,2.588,3.636,7.113,3.404,121.066,51.990,3.209,3.401
 1368.909,107.911,683.594,70.369,-85.052,19.139,9.788,0.015,2.592,3.687,6.912,3.312,115.455,48.025,3.183,3.382
 1369.409,107.952,692.969,76.244,-84.479,18.980,9.775,0.012,2.590,3.692,6.996,3.200,108.715,43.262,3.223,3.463
 1369.909,107.974,681.055,82.900,-84.939,19.019,9.744,0.007,2.583,3.661,7.440,3.227,103.203,39.366,3.304,3.596
 1370.409,107.768,683.594,86.684,-86.550,19.243,9.713,0.002,2.576,3.636,7.849,3.498,100.947,37.772,3.412,3.731
 1370.909,107.941,686.182,86.063,-87.706,19.044,9.665,0.002,2.578,3.637,7.725,3.946,100.347,37.348,3.546,3.872
 1371.409,107.779,678.711,84.833,-87.707,18.002,9.608,0.003,2.581,3.606,7.541,4.391,96.656,34.739,3.698,4.026
 1371.909,107.923,681.543,81.925,-88.963,16.440,9.597,0.005,2.578,3.599,7.722,4.592,89.652,29.789,3.889,4.225
 1372.409,107.839,683.105,81.211,-90.474,15.399,9.597,0.012,2.573,3.559,8.039,4.489,82.473,24.716,4.061,4.374
 1372.909,107.933,678.711,81.000,-91.867,15.369,9.614,0.020,2.570,3.547,8.185,4.428,76.617,20.577,4.115,4.349
 1373.409,107.889,683.594,78.461,-93.193,15.854,9.612,0.025,2.571,3.727,8.118,4.422,73.773,18.567,4.036,4.193
 1373.909,107.983,686.865,76.796,-95.457,15.876,9.576,0.032,2.561,3.946,8.727,4.204,73.623,18.461,3.797,3.943
 1374.409,107.918,687.500,76.521,-97.663,15.546,9.616,0.039,2.541,3.909,9.899,3.782,74.886,19.354,3.578,3.754
 1374.909,107.920,683.594,78.216,-99.119,16.169,9.692,0.042,2.524,3.523,10.887,3.248,77.961,21.527,3.415,3.664
 1375.409,107.814,688.477,82.174,-98.738,18.346,9.663,0.030,2.505,3.095,11.974,2.965,80.802,23.535,3.357,3.640
 1375.909,107.944,680.957,84.433,-98.116,21.503,9.568,0.015,2.495,3.061,12.597,3.088,81.428,23.978,3.403,3.724
 1376.409,108.033,678.711,82.165,-97.717,23.997,9.507,0.009,2.504,3.361,12.055,3.836,78.897,22.188,3.545,3.850
 1376.909,107.787,686.719,71.823,-98.188,23.824,9.469,0.008,2.532,3.775,10.435,5.295,73.819,18.600,3.813,4.079
 1377.409,107.826,686.816,57.284,-99.403,20.327,9.406,0.007,2.577,4.079,7.767,6.825,68.043,14.518,4.255,4.423
 1377.909,107.863,683.594,45.798,-100.093,15.197,9.371,0.002,2.615,4.202,5.560,7.947,63.166,11.071,4.864,4.815
 1378.409,107.915,685.498,41.728,-101.100,10.971,9.370,-0.001,2.626,4.281,4.926,8.586,60.112,8.913,5.423,5.100
 1378.909,107.929,679.590,40.650,-101.171,8.795,9.370,0.003,2.633,4.353,4.475,8.928,58.517,7.786,5.499,4.939
 1379.409,107.981,683.008,42.121,-100.641,8.121,9.388,0.017,2.645,4.451,3.826,8.342,59.166,8.244,4.794,4.304
 1379.909,107.976,725.977,52.086,-98.771,7.851,9.456,0.038,2.658,4.353,3.045,6.625,62.776,10.796,3.818,3.537
 1380.409,108.020,678.711,70.290,-97.466,8.675,9.608,0.053,2.644,3.909,3.852,4.300,69.899,15.830,3.005,2.911
 1380.909,107.934,688.574,91.437,-97.181,11.635,9.786,0.052,2.599,3.415,6.509,2.470,78.007,21.559,2.432,2.468
 1381.409,107.947,690.479,103.170,-98.767,17.445,9.930,0.038,2.549,3.093,9.422,1.702,83.975,25.778,2.071,2.166
 1381.909,108.100,684.473,104.189,-99.412,24.495,10.041,0.023,2.512,2.971,11.569,1.447,88.172,28.744,1.825,1.947
 1382.409,107.884,689.746,97.478,-98.722,30.956,10.109,0.019,2.507,2.988,11.849,1.456,92.502,31.804,1.662,1.778
 1382.909,107.996,688.477,89.974,-96.640,34.493,10.139,0.022,2.519,2.994,11.168,1.566,97.356,35.234,1.545,1.649
 1383.409,107.909,676.172,90.084,-93.646,34.206,10.174,0.025,2.520,3.001,11.116,1.675,100.584,37.515,1.476,1.574
 1383.909,107.965,671.875,91.941,-90.055,32.151,10.243,0.040,2.504,3.044,12.067,1.709,100.673,37.578,1.443,1.551
 1384.409,108.037,688.477,91.616,-89.217,29.856,10.333,0.081,2.469,3.093,14.103,1.661,99.159,36.508,1.460,1.601
 1384.909,108.068,681.641,88.389,-87.048,29.315,10.410,0.133,2.424,3.103,16.749,1.578,98.905,36.329,1.524,1.723
 1385.409,107.891,693.359,86.588,-86.629,31.810,10.368,0.164,2.373,2.982,19.684,1.534,99.773,36.942,1.650,1.926
 1385.909,108.031,689.697,86.810,-86.304,37.528,10.432,0.154,2.330,2.836,22.218,1.714,97.937,35.645,1.837,2.193
 1386.409,107.972,689.600,83.146,-88.334,43.636,10.370,0.116,2.330,2.829,22.196,2.699,91.600,31.166,2.091,2.480
 1386.909,107.981,689.941,72.252,-88.881,43.154,9.894,0.080,2.400,3.051,18.146,5.452,81.465,24.003,2.417,2.758
 1387.409,107.898,693.359,56.965,-89.422,34.284,9.382,0.059,2.511,3.292,11.647,9.177,70.852,16.503,2.817,3.000
 1387.909,107.944,693.359,45.842,-89.893,21.175,9.181,0.050,2.608,3.595,5.962,11.409,63.620,11.392,3.293,3.249
 1388.409,107.843,689.111,44.605,-92.391,10.562,9.272,0.046,2.654,3.918,3.256,10.852,61.063,9.585,3.783,3.525
 1388.909,107.996,682.520,49.909,-94.241,6.679,9.431,0.042,2.649,4.175,3.550,7.992,64.780,12.212,4.048,3.769
 1389.409,107.939,688.477,55.130,-92.785,7.287,9.582,0.031,2.616,4.210,5.478,5.192,77.893,21.479,4.041,3.952
 1389.909,108.037,690.625,58.304,-91.550,10.143,9.695,0.024,2.565,3.997,8.487,3.809,98.951,36.361,3.799,4.016
 1390.409,108.157,693.359,60.045,-90.222,13.469,9.771,0.031,2.494,3.805,12.637,3.109,121.316,52.167,3.551,3.980
 1390.909,107.968,690.967,62.482,-91.608,16.789,9.981,0.058,2.418,3.683,17.077,2.756,136.086,62.605,3.450,3.888
 1391.409,108.129,688.574,62.756,-93.728,20.228,10.075,0.085,2.378,3.530,19.407,2.765,140.003,65.373,3.350,3.620
 1391.909,107.953,698.242,58.125,-95.981,22.884,10.097,0.080,2.403,3.436,17.955,3.491,134.302,61.344,3.190,3.185
 1392.409,108.074,697.949,52.388,-99.254,23.012,10.053,0.058,2.482,3.687,13.336,4.276,123.646,53.813,2.869,2.704
 1392.909,108.110,693.359,50.227,-101.085,19.752,9.918,0.038,2.555,4.106,9.085,4.272,113.032,46.313,2.487,2.300
 1393.409,108.167,697.168,56.433,-102.947,15.780,9.991,0.040,2.553,4.357,9.199,3.403,104.967,40.613,2.143,2.037
 1393.909,107.965,691.553,64.616,-103.511,14.800,10.148,0.070,2.488,4.016,12.961,2.162,101.183,37.938,1.891,1.868
 1394.409,108.139,691.016,67.943,-104.475,18.344,10.729,0.090,2.419,3.408,16.997,1.373,98.450,36.007,1.710,1.757
 1394.909,108.080,688.672,65.252,-107.268,25.320,10.911,0.084,2.400,3.024,18.156,1.121,94.331,33.096,1.582,1.657
 1395.409,108.109,678.711,59.135,-110.610,32.493,10.453,0.058,2.419,2.879,17.043,1.137,89.166,29.446,1.476,1.545
 1395.909,108.125,682.275,52.922,-114.818,36.897,10.292,0.030,2.449,2.964,15.274,1.407,82.237,24.549,1.384,1.431
 1396.409,108.104,690.918,44.904,-117.782,37.197,10.220,0.015,2.475,3.185,13.755,1.789,75.346,19.679,1.311,1.329
 1396.909,108.064,698.242,38.004,-120.262,33.526,10.108,0.009,2.491,3.510,12.812,1.971,69.837,15.786,1.264,1.264
 1397.409,108.102,693.359,34.160,-121.555,27.833,10.062,0.011,2.491,3.904,12.802,1.762,67.014,13.791,1.251,1.243
 1397.909,107.948,701.465,32.992,-123.442,22.721,10.101,0.017,2.466,4.207,14.283,1.297,66.788,13.631,1.255,1.251
 1398.409,108.062,699.707,32.081,-123.156,21.173,10.164,0.021,2.437,4.328,15.949,1.039,67.835,14.371,1.257,1.256
 1398.909,108.089,684.863,31.863,-123.315,23.391,10.192,0.017,2.423,4.409,16.772,1.184,68.480,14.827,1.237,1.236
 1399.409,108.065,687.500,35.090,-123.274,26.400,10.165,0.009,2.427,4.459,16.556,1.506,68.028,14.507,1.199,1.199
 1399.909,108.129,688.867,39.888,-126.410,27.535,10.142,0.008,2.436,4.385,16.048,1.725,67.374,14.045,1.173,1.179
 1400.409,108.119,688.477,44.895,-129.023,27.268,10.124,0.010,2.430,4.183,16.351,1.741,67.499,14.134,1.180,1.198
 1400.909,107.955,693.213,47.391,-131.137,27.248,10.093,0.009,2.424,3.870,16.728,1.782,68.175,14.611,1.227,1.248
 1401.409,108.221,693.262,48.346,-126.960,27.674,10.057,0.003,2.438,3.814,15.924,2.170,68.455,14.809,1.308,1.322
 1401.909,108.220,698.242,48.856,-124.765,27.186,10.028,-0.003,2.468,4.002,14.126,2.784,67.932,14.439,1.397,1.400
 1402.409,108.132,700.879,47.958,-123.112,24.754,10.019,-0.001,2.507,4.105,11.843,3.317,66.837,13.666,1.476,1.478
 1402.909,108.208,693.359,45.555,-121.841,22.051,10.017,0.004,2.535,3.952,10.223,3.602,65.554,12.759,1.544,1.559
 1403.409,108.168,696.240,42.377,-117.695,20.413,10.017,0.011,2.558,3.566,8.871,3.567,64.223,11.818,1.614,1.646
 1403.909,108.125,706.396,40.578,-114.705,19.646,10.026,0.023,2.582,3.293,7.489,3.285,64.297,11.871,1.698,1.755
 1404.409,108.131,693.359,41.581,-112.961,19.366,10.071,0.035,2.595,3.235,6.741,2.778,67.614,14.215,1.799,1.897
 1404.909,108.183,696.680,47.531,-111.207,19.035,10.146,0.042,2.600,3.321,6.418,2.288,72.972,18.001,1.909,2.057
 1405.409,108.089,695.215,59.410,-110.167,18.681,10.221,0.040,2.601,3.548,6.368,2.122,77.528,21.222,2.027,2.211
 1405.909,108.306,700.293,70.014,-107.195,18.408,10.274,0.033,2.601,3.826,6.347,2.309,78.868,22.168,2.156,2.351
 1406.409,108.257,700.879,77.811,-105.340,18.120,10.294,0.028,2.606,3.969,6.073,2.630,78.226,21.714,2.314,2.507
 1406.909,108.307,698.242,81.644,-101.319,17.905,10.294,0.024,2.604,3.991,6.198,2.883,78.068,21.603,2.516,2.716
 1407.409,108.264,698.242,83.026,-99.452,17.787,10.287,0.019,2.594,3.944,6.756,3.079,79.835,22.851,2.763,2.969
 1407.909,108.214,688.477,81.420,-99.518,17.601,10.281,0.013,2.585,3.947,7.287,3.300,82.317,24.606,3.031,3.217
 1408.409,108.197,688.477,71.159,-100.496,16.979,10.283,0.012,2.589,4.093,7.052,3.513,83.430,25.393,3.258,3.389
 1408.909,108.147,691.895,58.307,-101.643,15.888,10.290,0.014,2.600,4.206,6.433,3.644,83.606,25.517,3.371,3.444
 1409.409,108.193,698.242,50.700,-102.092,14.942,10.302,0.014,2.607,4.232,6.052,3.645,83.636,25.538,3.352,3.389
 1409.909,108.302,692.383,52.615,-101.493,14.477,10.320,0.015,2.604,4.151,6.189,3.467,85.248,26.677,3.217,3.240
 1410.409,108.220,698.242,59.582,-100.070,14.449,10.346,0.016,2.594,3.931,6.802,3.158,88.012,28.631,3.025,3.061
 1410.909,108.204,698.242,67.469,-97.096,15.191,10.388,0.025,2.593,3.715,6.849,2.795,89.630,29.774,2.829,2.905
 1411.409,108.219,698.242,75.127,-95.234,16.814,10.432,0.031,2.587,3.502,7.197,2.467,91.046,30.775,2.658,2.790
 1411.909,108.258,698.242,80.046,-96.334,19.220,10.459,0.029,2.572,3.296,8.099,2.269,93.656,32.619,2.557,2.733
 1412.409,108.267,708.105,83.391,-96.419,21.636,10.477,0.022,2.553,3.153,9.188,2.204,96.700,34.771,2.523,2.723
 1412.909,108.319,707.520,86.140,-96.983,23.568,10.469,0.014,2.536,3.129,10.184,2.318,99.047,36.429,2.574,2.766
 1413.409,108.224,701.416,85.306,-98.696,24.774,10.440,0.009,2.532,3.259,10.415,2.650,97.328,35.214,2.680,2.854
 1413.909,108.216,690.234,78.336,-102.420,24.525,10.389,0.007,2.544,3.554,9.709,3.259,89.667,29.800,2.836,2.966
 1414.409,108.307,698.242,67.613,-106.571,22.867,10.330,0.005,2.561,3.945,8.701,3.927,80.236,23.135,3.004,3.070
 1414.909,108.237,695.117,57.544,-109.084,20.045,10.301,0.003,2.575,4.212,7.923,4.312,72.017,17.327,3.139,3.110
 1415.409,108.260,699.902,51.063,-112.141,16.961,10.300,0.006,2.585,4.291,7.332,4.236,67.636,14.230,3.194,3.052
 1415.909,108.340,708.008,48.085,-112.337,14.418,10.328,0.012,2.583,4.209,7.399,3.766,67.079,13.837,3.108,2.896
 1416.409,108.327,704.932,49.291,-115.015,12.816,10.374,0.017,2.565,4.024,8.475,3.253,67.985,14.477,2.897,2.666
 1416.909,108.343,693.359,52.003,-116.034,13.098,10.424,0.021,2.530,4.045,10.499,2.974,69.653,15.656,2.597,2.399
 1417.409,108.289,695.703,52.014,-119.926,15.675,10.468,0.023,2.490,4.136,12.887,2.965,71.195,16.746,2.289,2.125
 1417.909,108.363,696.191,47.776,-122.764,19.494,10.494,0.022,2.455,4.251,14.890,3.076,72.276,17.510,2.010,1.861
 1418.409,108.296,696.729,44.857,-125.304,22.508,10.504,0.018,2.429,4.303,16.410,3.094,72.941,17.979,1.783,1.639
 1418.909,108.414,693.359,44.315,-124.709,23.655,10.517,0.009,2.402,4.221,17.991,2.909,73.408,18.310,1.603,1.464
 1419.409,108.287,688.477,43.781,-125.397,23.357,10.532,0.003,2.378,4.210,19.425,2.571,73.763,18.561,1.462,1.345
 1419.909,108.399,697.070,43.810,-125.221,23.482,10.539,0.001,2.368,4.217,19.999,2.206,73.838,18.613,1.355,1.269
 1420.409,108.121,697.363,42.328,-125.395,24.406,10.540,0.001,2.376,4.191,19.536,1.901,73.337,18.259,1.278,1.230
 1420.909,108.349,703.125,39.060,-121.770,24.994,10.541,0.002,2.396,4.128,18.392,1.658,72.376,17.580,1.229,1.218
 1421.409,108.233,700.439,34.828,-120.404,24.674,10.528,0.007,2.417,4.033,17.115,1.434,71.310,16.827,1.208,1.228
 1421.909,108.258,703.125,29.442,-119.965,23.614,10.515,0.012,2.429,3.984,16.425,1.233,70.453,16.221,1.209,1.254
 1422.409,108.347,695.801,25.750,-121.904,22.670,10.555,0.016,2.430,4.036,16.366,1.127,69.799,15.759,1.228,1.292
 1422.909,108.353,702.832,24.034,-123.586,22.113,10.616,0.013,2.422,4.054,16.850,1.128,69.101,15.266,1.257,1.337
 1423.409,108.382,693.359,21.192,-124.333,21.606,10.572,0.009,2.419,4.034,17.018,1.187,68.360,14.742,1.293,1.384
 1423.909,108.430,698.926,19.593,-124.033,21.157,10.485,0.008,2.421,4.029,16.897,1.228,67.731,14.297,1.331,1.428
 1424.409,108.419,708.008,19.931,-125.264,20.987,10.454,0.009,2.423,4.044,16.757,1.228,67.410,14.071,1.375,1.474
 1424.909,108.312,707.422,21.856,-124.774,21.193,10.426,0.012,2.427,4.069,16.570,1.203,67.330,14.014,1.425,1.526
 1425.409,108.322,699.951,24.109,-127.994,21.955,10.397,0.013,2.427,4.058,16.565,1.213,67.443,14.094,1.489,1.595
 1425.909,108.420,696.582,24.559,-128.964,22.897,10.366,0.017,2.442,4.132,15.695,1.340,67.898,14.415,1.565,1.680
 1426.409,108.292,695.215,26.799,-129.736,23.313,10.305,0.019,2.462,4.277,14.482,1.704,68.839,15.081,1.662,1.775
 1426.909,108.409,693.359,31.578,-127.506,22.953,10.252,0.016,2.478,4.388,13.571,2.298,69.953,15.868,1.779,1.877
 1427.409,108.303,693.359,35.032,-124.100,21.809,10.233,0.015,2.490,4.453,12.850,2.984,70.565,16.300,1.925,1.975
 1427.909,108.277,698.242,36.603,-120.616,20.131,10.213,0.014,2.504,4.497,12.072,3.508,70.178,16.027,2.060,2.067
 1428.409,108.370,698.242,38.376,-117.815,18.174,10.195,0.016,2.526,4.529,10.756,3.613,69.532,15.570,2.165,2.146
 1428.909,108.330,693.359,45.067,-114.189,16.187,10.192,0.017,2.550,4.357,9.330,3.265,70.301,16.114,2.204,2.238
 1429.409,108.302,689.258,57.525,-111.922,14.981,10.227,0.019,2.553,4.019,9.195,2.690,73.287,18.224,2.217,2.349
 1429.909,108.415,688.477,67.154,-110.679,16.167,10.313,0.040,2.518,3.692,11.235,2.196,78.472,21.888,2.255,2.526
 1430.409,108.364,692.822,71.517,-110.015,20.312,10.429,0.087,2.459,3.397,14.693,1.907,84.008,25.800,2.341,2.739
 1430.909,108.373,698.242,71.751,-107.902,26.951,10.933,0.125,2.406,3.207,17.782,1.904,87.203,28.058,2.509,2.976
 1431.409,108.515,693.701,68.477,-106.106,33.184,11.399,0.126,2.400,3.116,18.139,2.195,86.716,27.714,2.713,3.184
 1431.909,108.304,688.477,62.427,-105.726,34.515,10.940,0.083,2.450,3.262,15.198,2.995,81.176,23.799,2.934,3.308
 1432.409,108.559,693.262,50.768,-108.279,30.474,10.314,0.030,2.523,3.553,10.964,4.314,73.210,18.169,3.198,3.467
 1432.909,108.317,693.359,35.333,-107.912,22.506,9.999,0.005,2.586,3.838,7.242,5.974,65.715,12.873,3.619,3.733
 1433.409,108.462,693.506,23.191,-107.659,14.778,9.835,-0.000,2.629,4.065,4.713,7.232,61.482,9.881,4.241,4.103
 1433.909,108.392,703.613,20.082,-107.309,9.728,9.829,0.002,2.651,4.115,3.441,7.525,63.098,11.023,5.088,4.512
 1434.409,108.353,698.242,23.207,-108.437,6.946,9.829,0.005,2.659,4.001,2.987,7.189,68.409,14.776,5.518,4.644
 1434.909,108.298,695.313,29.428,-106.941,5.976,9.828,0.009,2.657,3.799,3.118,6.427,74.315,18.950,5.105,4.530
 1435.409,108.522,693.994,39.135,-106.304,5.830,9.830,0.015,2.644,3.603,3.844,5.443,80.208,23.115,4.309,4.331
 1435.909,108.277,698.242,53.962,-105.076,6.435,9.879,0.025,2.609,3.438,5.886,4.191,87.304,28.130,3.668,4.186
 1436.409,108.367,701.465,70.622,-105.225,8.676,10.137,0.048,2.540,3.262,9.969,2.929,94.963,33.543,3.403,4.273
 1436.909,108.525,700.195,81.016,-103.827,14.217,10.400,0.081,2.447,2.985,15.400,2.184,102.075,38.569,3.349,4.355
 1437.409,108.411,700.977,78.902,-100.922,21.939,10.799,0.094,2.383,2.925,19.105,2.244,110.997,44.874,3.356,4.188
 1437.909,108.546,697.021,65.042,-100.439,27.372,10.602,0.076,2.400,3.208,18.122,2.908,125.618,55.207,3.163,3.580
 1438.409,108.432,693.359,48.672,-103.328,26.248,9.768,0.038,2.472,3.641,13.942,3.410,142.905,67.424,2.673,2.789
 1438.909,108.407,689.502,37.424,-105.441,19.877,9.496,0.015,2.530,3.932,10.548,3.245,156.803,77.246,2.104,2.198
 1439.409,108.438,693.164,34.324,-105.831,14.273,9.627,0.029,2.497,3.737,12.452,2.413,161.610,80.643,1.643,1.845
 1439.909,108.399,703.125,40.170,-105.491,14.750,10.423,0.060,2.354,3.259,20.810,1.519,160.903,80.143,1.344,1.692
 1440.409,108.480,690.283,51.413,-106.911,22.411,11.792,0.092,2.136,2.795,33.551,1.043,158.203,78.236,1.177,1.674
 1440.909,108.436,693.359,60.001,-105.161,34.875,12.582,0.104,1.913,2.469,46.597,0.857,154.249,75.441,1.091,1.689
 1441.409,108.559,693.359,65.916,-103.687,51.881,12.807,0.086,1.773,2.310,54.800,0.832,150.006,72.442,1.060,1.666
 1441.909,108.528,688.770,67.566,-103.053,67.336,12.976,0.068,1.773,2.315,54.814,0.917,146.529,69.985,1.040,1.556
 1442.409,108.638,692.969,67.520,-105.680,71.394,13.009,0.081,1.922,2.577,46.104,1.077,143.970,68.177,1.042,1.437
 1442.909,108.541,707.910,68.401,-107.422,64.410,13.005,0.124,2.106,2.861,35.324,1.226,136.132,62.637,1.062,1.380
 1443.409,108.540,693.359,71.086,-107.722,51.034,12.807,0.163,2.206,2.939,29.503,1.293,122.347,52.895,1.150,1.456
 1443.909,108.434,702.832,78.317,-106.424,41.569,12.754,0.167,2.168,2.886,31.707,1.277,109.086,43.524,1.325,1.697
 1444.409,108.523,696.094,82.441,-105.768,41.325,12.942,0.148,2.034,2.615,39.506,1.276,100.889,37.731,1.640,2.162
 1444.909,108.598,697.852,80.249,-104.195,46.335,12.864,0.136,1.981,2.480,42.624,1.548,97.827,35.566,2.062,2.822
 1445.409,108.538,696.338,71.242,-103.214,49.899,12.010,0.133,2.105,2.605,35.363,2.398,94.585,33.275,2.477,3.480
 1445.909,108.622,712.891,59.082,-101.124,45.676,10.874,0.115,2.328,3.013,22.334,3.664,87.931,28.573,2.793,3.856
 1446.409,108.689,706.543,47.631,-101.327,33.206,10.252,0.075,2.522,3.635,10.979,4.929,78.864,22.165,3.063,4.045
 1446.909,108.719,703.125,42.130,-98.492,19.493,10.069,0.038,2.604,4.062,6.204,5.683,70.595,16.322,3.522,4.235
 1447.409,108.670,699.707,42.681,-98.397,11.534,10.112,0.036,2.613,4.171,5.648,5.659,66.535,13.452,4.245,4.729
 1447.909,108.651,689.600,46.092,-98.576,9.529,10.241,0.058,2.615,4.028,5.547,5.176,69.924,15.847,5.143,5.435
 1448.409,108.687,693.359,51.911,-101.546,10.540,10.536,0.073,2.619,3.898,5.311,4.664,79.275,22.456,5.741,6.132
 1448.909,108.572,700.879,57.021,-102.484,12.435,10.462,0.069,2.635,3.924,4.396,4.387,88.756,29.156,5.712,6.320
 1449.409,108.684,708.008,62.357,-103.375,14.028,10.194,0.050,2.653,4.021,3.358,4.350,95.150,33.675,5.237,5.856
 1449.909,108.691,706.445,65.944,-101.671,14.859,10.181,0.031,2.659,4.069,3.001,4.351,95.674,34.045,4.764,5.203
 1450.409,108.729,694.824,69.405,-102.342,15.035,10.192,0.020,2.654,3.975,3.283,4.273,92.357,31.701,4.375,4.614
 1450.909,108.670,693.359,75.065,-101.011,14.835,10.215,0.014,2.633,3.781,4.502,4.081,93.487,32.499,4.108,4.288
 1451.409,108.791,702.051,79.471,-102.440,14.817,10.267,0.011,2.610,3.522,5.829,3.765,100.209,37.250,3.907,4.133
 1451.909,108.665,708.789,81.714,-102.827,15.424,10.368,0.015,2.596,3.272,6.675,3.409,107.400,42.332,3.806,4.163
 1452.409,108.832,703.125,84.526,-104.837,16.735,10.593,0.026,2.598,3.167,6.563,3.166,111.217,45.030,3.785,4.300
 1452.909,108.698,702.832,92.884,-103.826,18.489,10.672,0.038,2.611,3.244,5.810,3.201,106.904,41.981,3.877,4.490
 1453.409,108.769,698.340,109.092,-105.547,20.044,10.521,0.044,2.627,3.384,4.877,3.516,99.718,36.903,4.038,4.681
 1453.909,108.798,695.752,125.879,-107.491,20.463,10.439,0.035,2.628,3.476,4.772,4.339,92.736,31.969,4.261,4.787
 1454.409,108.737,698.242,131.911,-110.783,18.999,10.337,0.022,2.627,3.700,4.855,5.579,84.196,25.934,4.545,4.904
 1454.909,108.930,698.242,121.889,-108.689,15.260,10.098,0.022,2.639,4.018,4.176,6.765,75.107,19.510,4.880,5.061
 1455.409,108.760,703.125,104.522,-106.654,10.999,9.948,0.027,2.643,4.329,3.932,7.340,66.982,13.768,5.287,5.318
 1455.909,108.873,703.125,89.105,-106.792,8.370,9.930,0.035,2.638,4.509,4.226,6.949,61.871,10.156,5.763,5.718
 1456.409,108.706,698.242,79.899,-109.320,7.966,9.909,0.034,2.617,4.510,5.415,6.163,60.394,9.112,6.132,6.085
 1456.909,108.731,698.242,73.587,-110.925,9.020,9.901,0.025,2.594,4.544,6.784,5.607,61.748,10.069,6.253,6.436
 1457.409,108.934,699.121,68.666,-111.585,10.145,9.901,0.015,2.582,4.538,7.481,5.517,63.903,11.592,6.175,6.814
 1457.909,109.002,706.592,65.276,-108.125,10.827,9.901,0.007,2.581,4.518,7.544,5.711,66.425,13.374,6.226,7.562
 1458.409,108.907,698.242,68.489,-106.740,10.978,9.901,0.006,2.589,4.425,7.074,5.681,69.081,15.252,6.933,9.018
 1458.909,108.905,701.904,82.338,-104.356,10.939,9.905,0.011,2.592,4.156,6.887,5.381,71.990,17.307,8.384,10.394
 1459.409,108.853,700.391,94.016,-105.328,11.392,9.911,0.012,2.581,3.984,7.532,5.347,74.023,18.744,9.112,9.395
 1459.909,108.909,693.359,96.326,-105.689,12.157,9.882,0.009,2.570,3.992,8.167,5.870,76.502,20.496,6.743,6.242
 1460.409,109.046,701.465,87.124,-106.208,12.221,9.850,0.003,2.564,4.261,8.550,6.411,85.293,26.709,4.074,4.017
 1460.909,109.125,712.158,76.085,-104.672,11.297,9.854,0.005,2.527,4.504,10.693,6.006,100.880,37.725,2.660,3.046
 1461.409,108.995,711.084,74.910,-104.282,10.759,9.902,0.018,2.359,4.228,20.540,4.451,118.229,49.985,2.060,2.850
 1461.909,109.150,708.008,77.344,-101.319,15.653,10.278,0.027,2.051,3.488,38.527,2.657,129.609,58.028,1.858,3.164
 1462.409,109.026,708.008,74.130,-100.426,33.889,11.582,0.027,1.789,2.632,53.862,1.665,126.713,55.981,1.854,3.671
 1462.909,109.178,703.369,66.251,-98.336,57.078,12.787,0.020,1.740,2.172,56.696,1.717,111.430,45.180,1.894,3.647
 1463.409,109.031,703.125,55.551,-97.173,66.414,12.029,0.021,1.984,2.417,42.478,2.648,91.385,31.014,1.915,3.096
 1463.909,109.064,712.793,46.736,-95.831,57.631,10.569,0.024,2.305,3.054,23.687,3.833,74.417,19.022,1.952,2.623
 1464.409,108.997,710.547,40.357,-96.728,35.570,10.049,0.019,2.512,3.684,11.568,4.808,68.084,14.547,2.168,2.613
 1464.909,109.187,712.500,35.993,-97.884,18.973,9.981,0.010,2.607,4.074,6.040,5.329,68.044,14.519,2.703,3.017
 1465.409,109.179,705.908,34.541,-99.669,13.714,9.960,0.002,2.634,4.174,4.417,5.513,67.898,14.416,3.917,4.090
 1465.909,109.188,708.008,33.419,-99.850,11.787,9.925,0.001,2.654,4.085,3.288,5.746,66.970,13.759,5.959,6.032
 1466.409,109.229,710.986,33.968,-100.885,10.410,9.889,0.003,2.668,4.040,2.440,6.172,65.416,12.662,7.924,8.980
 1466.909,109.170,712.891,34.222,-100.779,8.861,9.873,0.006,2.676,4.155,2.002,6.662,64.065,11.707,8.244,11.436
 1467.409,109.336,712.891,37.478,-99.413,7.710,9.867,0.009,2.673,4.255,2.177,6.926,63.303,11.168,7.527,11.211
 1467.909,109.308,709.863,41.724,-98.332,7.472,9.883,0.011,2.667,4.272,2.493,6.988,63.244,11.127,7.218,9.783
 1468.409,109.334,717.773,45.656,-99.966,7.941,9.901,0.013,2.665,4.195,2.651,7.027,63.916,11.602,7.333,8.845
 1468.909,109.240,715.527,47.109,-101.091,8.265,9.877,0.015,2.671,4.132,2.276,7.160,64.355,11.911,7.571,8.510
 1469.409,109.403,715.430,47.357,-102.039,7.995,9.850,0.019,2.680,4.203,1.730,7.392,64.368,11.921,7.800,8.554
 1469.909,109.400,712.891,49.731,-102.155,7.311,9.844,0.019,2.677,4.410,1.903,7.631,64.109,11.738,7.929,8.612
 1470.409,109.397,716.846,50.734,-102.788,6.639,9.817,0.017,2.668,4.604,2.463,8.049,63.494,11.303,8.034,8.542
 1470.909,109.490,717.773,50.748,-102.576,6.186,9.772,0.012,2.660,4.632,2.936,8.738,62.440,10.558,7.980,8.434
 1471.409,109.417,713.623,48.121,-101.743,5.740,9.748,0.007,2.662,4.535,2.823,9.471,60.966,9.516,7.775,8.129
 1471.909,109.459,718.457,45.727,-102.493,5.235,9.757,0.006,2.669,4.435,2.415,9.624,59.824,8.709,7.484,7.842
 1472.409,109.549,727.539,53.544,-103.108,4.854,9.781,0.009,2.676,4.382,1.985,8.927,59.812,8.701,7.200,7.609
 1472.909,109.427,714.990,75.363,-104.537,4.966,9.799,0.010,2.675,4.266,2.071,7.843,61.028,9.560,6.990,7.493
 1473.409,109.405,708.496,97.829,-104.460,5.679,9.804,0.008,2.671,4.261,2.277,7.111,62.519,10.614,6.795,7.437
 1473.909,109.486,703.418,101.601,-105.371,6.644,9.804,0.005,2.677,4.678,1.952,7.126,63.179,11.081,6.580,7.264
 1474.409,109.582,708.008,85.829,-107.264,7.262,9.808,0.007,2.687,5.097,1.371,7.312,63.146,11.057,6.349,7.096
 1474.909,109.459,698.242,65.546,-108.943,7.130,9.821,0.017,2.699,5.048,0.645,7.176,63.050,10.990,6.176,6.943
 1475.409,109.521,704.346,54.234,-109.605,6.725,9.839,0.023,2.698,4.625,0.726,6.931,63.236,11.121,6.046,6.832
 1475.909,109.673,719.189,51.622,-110.082,6.572,9.848,0.017,2.679,4.229,1.800,6.856,63.358,11.207,5.984,6.737
 1476.409,109.681,711.572,48.533,-110.336,6.623,9.852,0.007,2.658,4.231,3.068,6.912,63.173,11.076,5.916,6.634
 1476.909,109.674,701.270,46.066,-110.056,6.602,9.856,0.005,2.652,4.348,3.395,6.782,63.083,11.012,5.846,6.615
 1477.409,109.636,712.891,47.018,-108.699,6.502,9.857,0.011,2.662,4.368,2.815,6.422,63.529,11.328,5.803,6.693
 1477.909,109.724,725.977,48.328,-108.883,6.554,9.857,0.020,2.678,4.324,1.845,6.085,64.457,11.984,5.756,6.790
 1478.409,109.563,722.656,51.467,-108.686,6.970,9.856,0.025,2.688,4.375,1.290,5.996,65.207,12.514,5.722,6.848
 1478.909,109.766,719.189,53.390,-108.122,7.586,9.856,0.023,2.687,4.492,1.345,6.135,65.327,12.598,5.669,6.763
 1479.409,109.773,724.023,52.868,-105.940,7.959,9.856,0.018,2.686,4.659,1.425,6.387,64.937,12.323,5.595,6.597
 1479.909,109.725,712.891,51.105,-104.694,8.016,9.855,0.013,2.687,4.918,1.342,6.585,64.557,12.054,5.574,6.519
 1480.409,109.779,722.656,48.131,-103.691,7.933,9.855,0.007,2.684,5.046,1.524,6.595,64.557,12.054,5.594,6.527
 1480.909,109.763,722.656,47.379,-103.358,7.995,9.853,0.005,2.678,5.017,1.893,6.488,64.988,12.359,5.672,6.711
 1481.409,109.885,721.045,49.336,-104.857,8.341,9.851,0.004,2.667,4.738,2.486,6.564,65.317,12.592,5.771,6.874
 1481.909,109.821,717.773,52.351,-106.099,8.661,9.850,0.002,2.659,4.455,3.010,6.987,65.105,12.442,5.863,6.995
 1482.409,109.787,717.773,52.942,-107.702,8.498,9.858,0.001,2.654,4.422,3.248,7.445,64.468,11.991,5.983,7.054
 1482.909,109.667,726.660,50.695,-106.506,7.817,9.873,-0.000,2.651,4.478,3.450,7.704,63.799,11.519,6.113,7.096
 1483.409,109.906,719.873,48.750,-104.840,6.972,9.882,0.001,2.655,4.573,3.240,7.764,63.364,11.212,6.270,7.164
 1483.909,109.647,722.656,48.512,-103.051,6.377,9.888,0.006,2.666,4.609,2.545,7.805,63.015,10.964,6.371,7.216
 1484.409,109.791,727.539,50.961,-102.898,6.240,9.910,0.009,2.671,4.575,2.270,7.687,62.979,10.939,6.410,7.188
 1484.909,109.797,737.305,55.566,-102.664,6.350,9.945,0.012,2.664,4.481,2.682,7.219,63.565,11.354,6.382,7.157
 1485.409,109.830,726.953,59.566,-101.798,6.717,10.002,0.017,2.651,4.351,3.445,6.460,65.110,12.445,6.296,7.047
 1485.909,109.671,727.539,61.688,-102.712,7.453,10.058,0.023,2.644,4.328,3.864,5.812,66.957,13.750,6.193,6.879
 1486.409,109.881,724.756,61.965,-104.163,8.429,10.080,0.027,2.647,4.341,3.678,5.556,68.191,14.622,6.040,6.586
 1486.909,109.707,722.656,62.258,-104.288,9.249,10.072,0.028,2.651,4.301,3.459,5.546,68.478,14.825,5.847,6.245
 1487.409,109.927,722.656,65.223,-104.406,9.722,10.055,0.025,2.645,4.246,3.778,5.549,68.115,14.569,5.656,5.985
 1487.909,109.930,727.539,68.232,-102.921,9.954,10.048,0.019,2.626,4.086,4.897,5.488,67.834,14.370,5.552,5.862
 1488.409,109.877,724.268,65.693,-102.483,10.160,10.048,0.011,2.607,3.926,6.029,5.448,67.897,14.415,5.569,5.879
 1488.909,109.940,722.656,61.605,-102.139,10.271,10.048,0.004,2.598,3.832,6.545,5.568,68.044,14.519,5.747,5.942
 1489.409,109.855,726.172,58.637,-100.190,10.109,10.048,0.005,2.612,3.770,5.759,5.906,67.820,14.360,5.889,5.889
 1489.909,109.805,732.422,56.179,-98.532,9.738,10.048,0.013,2.635,3.852,4.408,6.293,67.059,13.823,5.823,5.570
 1490.409,109.850,736.182,54.007,-97.740,9.140,10.047,0.019,2.647,3.988,3.668,6.491,65.910,13.010,5.386,5.001
 1490.909,109.751,733.838,53.342,-97.877,8.556,10.044,0.020,2.645,4.090,3.799,6.104,65.728,12.882,4.675,4.364
 1491.409,109.902,737.305,55.209,-97.911,8.296,10.034,0.020,2.626,4.171,4.925,5.051,68.048,14.521,3.909,3.745
 1491.909,109.913,727.539,62.324,-98.353,8.858,10.077,0.024,2.583,4.046,7.428,3.704,73.850,18.622,3.235,3.226
 1492.409,109.920,727.539,74.305,-97.990,10.895,10.181,0.044,2.529,3.796,10.587,2.574,82.032,24.404,2.714,2.804
 1492.909,109.938,738.135,85.784,-98.687,14.927,10.397,0.084,2.476,3.500,13.666,1.930,90.524,30.405,2.321,2.467
 1493.409,109.822,738.184,92.520,-97.739,20.377,11.181,0.121,2.426,3.219,16.623,1.630,97.491,35.329,2.041,2.213
 1493.909,109.953,743.604,94.746,-98.436,26.355,11.849,0.138,2.383,3.055,19.115,1.510,101.782,38.362,1.837,2.008
 1494.409,109.910,770.703,97.588,-98.100,31.286,11.810,0.137,2.349,2.952,21.096,1.476,103.853,39.825,1.684,1.845
 1494.909,109.961,722.656,100.004,-98.286,34.251,11.664,0.125,2.336,2.969,21.889,1.487,103.871,39.838,1.582,1.728
 1495.409,109.941,717.920,100.680,-97.785,36.158,11.670,0.111,2.339,3.056,21.674,1.505,102.984,39.211,1.510,1.644
 1495.909,109.875,735.010,97.634,-98.580,36.946,11.606,0.110,2.351,3.123,21.013,1.516,102.034,38.540,1.469,1.599
 1496.409,109.967,737.305,94.616,-100.390,37.001,11.661,0.122,2.338,3.152,21.774,1.504,101.744,38.335,1.449,1.579
 1496.909,109.885,737.305,89.985,-100.919,36.176,12.015,0.146,2.273,3.071,25.543,1.458,102.470,38.848,1.437,1.579
 1497.409,109.990,732.422,86.078,-98.635,35.222,12.009,0.164,2.189,2.908,30.456,1.412,103.349,39.469,1.433,1.586
 1497.909,109.993,732.422,85.637,-98.484,35.273,12.026,0.166,2.127,2.838,34.096,1.380,104.223,40.087,1.426,1.590
 1498.409,110.116,733.154,88.013,-97.765,36.135,12.047,0.159,2.110,2.827,35.108,1.369,104.916,40.576,1.414,1.577
 1498.909,109.861,737.305,90.303,-99.412,37.062,12.205,0.141,2.133,2.871,33.760,1.386,105.451,40.955,1.402,1.554
 1499.409,109.996,731.445,89.821,-97.476,37.721,12.290,0.121,2.173,2.908,31.380,1.414,105.576,41.043,1.386,1.527
 1499.909,110.024,747.070,91.287,-98.125,38.791,11.906,0.112,2.225,2.891,28.390,1.435,104.962,40.609,1.374,1.510
 1500.409,109.981,737.305,94.498,-99.782,40.594,11.881,0.112,2.272,2.909,25.586,1.432,104.311,40.149,1.376,1.526
 1500.909,109.982,737.305,95.720,-100.948,41.823,11.904,0.122,2.301,2.879,23.908,1.413,103.973,39.911,1.405,1.579
 1501.409,109.888,735.889,94.885,-100.828,41.605,11.657,0.124,2.296,2.811,24.223,1.408,104.328,40.161,1.475,1.683
 1501.909,110.053,736.426,95.302,-101.912,41.032,11.435,0.116,2.262,2.703,26.193,1.466,104.422,40.227,1.589,1.827
 1502.409,109.983,742.188,94.467,-101.519,41.806,11.608,0.102,2.258,2.676,26.439,1.803,101.949,38.480,1.742,1.984
 1502.909,110.065,746.436,87.903,-102.904,41.929,11.461,0.073,2.314,2.973,23.131,2.605,96.795,34.838,1.924,2.144
 1503.409,110.017,744.092,74.270,-100.227,37.326,10.404,0.047,2.430,3.500,16.399,3.539,90.278,30.232,2.126,2.296
 1503.909,110.104,747.070,62.676,-99.719,28.642,9.697,0.033,2.541,3.921,9.910,4.092,84.777,26.344,2.356,2.493
 1504.409,110.066,742.773,60.875,-98.904,20.003,9.677,0.033,2.590,3.984,7.011,3.963,81.781,24.227,2.652,2.789
 1504.909,110.149,741.992,64.593,-99.432,15.573,9.691,0.044,2.605,3.746,6.142,3.482,80.857,23.574,2.996,3.165
 1505.409,109.945,744.580,67.729,-98.012,16.043,9.683,0.050,2.600,3.572,6.453,3.207,82.619,24.819,3.342,3.545
 1505.909,110.045,747.070,63.192,-97.594,18.427,9.639,0.053,2.582,3.632,7.503,3.200,86.197,27.347,3.551,3.739
 1506.409,109.964,747.070,58.808,-98.144,20.681,9.572,0.063,2.557,3.634,8.921,3.341,89.480,29.668,3.468,3.611
 1506.909,109.932,747.070,60.093,-98.236,21.649,9.786,0.065,2.535,3.604,10.260,3.588,89.472,29.662,3.189,3.277
 1507.409,110.025,747.070,62.902,-99.921,21.052,9.712,0.058,2.509,3.667,11.725,3.678,85.603,26.928,2.858,2.918
 1507.909,110.024,738.379,66.710,-101.678,19.794,9.438,0.065,2.466,3.756,14.293,3.378,83.829,25.674,2.563,2.620
 1508.409,109.985,743.994,73.230,-102.978,19.170,9.917,0.100,2.406,3.719,17.755,2.716,88.972,29.309,2.344,2.412
 1508.909,110.040,743.652,84.186,-104.154,20.666,10.924,0.138,2.363,3.489,20.292,2.023,98.071,35.739,2.143,2.238
 1509.409,109.967,745.313,94.860,-99.869,25.030,11.275,0.142,2.344,3.232,21.406,1.684,105.007,40.641,1.935,2.047
 1509.909,110.028,747.070,100.837,-100.247,29.825,10.904,0.117,2.345,3.149,21.365,1.652,105.794,41.198,1.747,1.876
 1510.409,109.983,747.070,99.943,-101.530,32.739,10.786,0.095,2.350,3.180,21.052,1.682,103.008,39.228,1.607,1.756
 1510.909,110.071,737.305,99.269,-105.711,33.548,10.730,0.098,2.334,3.214,21.960,1.652,101.805,38.378,1.546,1.722
 1511.409,110.075,737.305,97.027,-107.742,34.538,10.581,0.123,2.274,3.218,25.508,1.570,102.501,38.870,1.573,1.784
 1511.909,110.030,747.070,91.503,-108.271,39.058,10.747,0.143,2.199,3.105,29.878,1.594,102.453,38.836,1.678,1.909
 1512.409,110.096,747.070,83.902,-107.559,45.158,11.100,0.139,2.194,2.967,30.169,1.946,99.777,36.945,1.844,2.082
 1512.909,110.079,745.361,72.259,-107.516,47.099,10.490,0.101,2.297,2.976,24.145,2.651,95.391,33.845,2.048,2.271
 1513.409,110.004,746.436,60.755,-105.507,42.387,9.631,0.055,2.449,3.275,15.292,3.416,91.101,30.814,2.283,2.490
 1513.909,109.901,743.262,52.674,-104.343,32.697,9.518,0.030,2.546,3.663,9.562,3.944,87.820,28.494,2.604,2.807
 1514.409,110.030,741.797,50.305,-100.722,23.393,9.515,0.027,2.577,3.799,7.761,4.248,87.632,28.362,3.051,3.244
 1514.909,109.943,747.070,49.956,-101.657,18.065,9.515,0.033,2.578,3.859,7.724,4.461,91.516,31.106,3.662,3.833
 1515.409,110.107,751.807,49.620,-99.673,15.314,9.516,0.041,2.573,3.895,8.026,4.573,98.707,36.189,4.306,4.431
 1515.909,110.059,749.463,54.235,-102.226,13.890,9.555,0.053,2.566,3.847,8.407,4.530,105.706,41.135,4.691,4.777
 1516.409,109.985,751.758,61.270,-103.320,13.305,9.618,0.055,2.552,3.851,9.267,4.384,110.677,44.648,4.655,4.734
 1516.909,110.111,740.332,66.496,-106.785,13.526,9.615,0.043,2.529,3.880,10.592,4.070,115.182,47.832,4.145,4.183
 1517.409,109.926,747.070,69.239,-108.488,13.893,9.627,0.040,2.478,4.008,13.589,3.566,119.432,50.835,3.485,3.523
 1517.909,110.037,752.832,70.373,-110.363,14.774,9.835,0.073,2.365,3.948,20.201,2.814,122.078,52.705,2.810,2.949
 1518.409,109.884,750.342,70.608,-107.969,17.347,10.589,0.123,2.195,3.540,30.126,2.077,125.100,54.841,2.287,2.539
 1518.909,110.072,737.305,69.054,-108.785,22.656,11.609,0.154,1.978,2.996,42.794,1.596,130.059,58.345,1.921,2.288
 1519.409,110.009,736.523,66.305,-105.543,29.851,12.114,0.150,1.765,2.504,55.278,1.330,135.524,62.208,1.684,2.105
 1519.909,110.125,735.742,63.097,-106.990,39.495,12.484,0.120,1.596,2.246,65.135,1.204,138.091,64.022,1.538,1.962
 1520.409,110.205,736.279,63.558,-106.669,50.040,12.877,0.098,1.502,2.143,70.664,1.138,135.500,62.191,1.447,1.809
 1520.909,110.091,746.680,65.933,-108.263,56.681,12.992,0.096,1.490,2.125,71.370,1.120,130.556,58.697,1.389,1.668
 1521.409,110.270,737.305,67.074,-109.215,57.070,12.984,0.110,1.569,2.173,66.740,1.135,122.059,52.692,1.365,1.569
 1521.909,110.003,733.496,68.408,-110.152,51.854,12.966,0.130,1.746,2.260,56.350,1.176,110.505,44.527,1.380,1.538
 1522.409,110.188,737.305,67.505,-111.035,46.807,12.947,0.131,1.982,2.397,42.554,1.259,98.679,36.169,1.450,1.590
 1522.909,110.041,741.357,62.517,-113.106,44.886,12.353,0.108,2.197,2.603,30.028,1.386,91.457,31.065,1.583,1.723
 1523.409,110.168,737.549,60.747,-116.215,43.205,11.008,0.074,2.323,2.773,22.645,1.569,92.603,31.875,1.779,1.932
 1523.909,109.989,747.070,60.657,-119.372,40.428,10.135,0.047,2.392,3.001,18.587,1.940,96.199,34.416,2.025,2.196
 1524.409,110.096,747.070,57.499,-120.319,36.045,9.929,0.035,2.459,3.287,14.682,2.624,98.331,35.923,2.304,2.467
 1524.909,110.140,742.578,49.765,-120.512,30.564,9.859,0.029,2.531,3.512,10.442,3.432,97.081,35.040,2.570,2.677
 1525.409,110.171,748.779,38.002,-119.366,24.752,9.849,0.021,2.572,3.673,8.051,3.951,94.861,33.470,2.775,2.741
 1525.909,110.100,742.627,33.040,-120.732,19.345,9.842,0.017,2.578,3.662,7.726,3.907,96.126,34.365,2.845,2.680
 1526.409,110.184,742.188,39.300,-124.451,15.980,9.867,0.021,2.568,3.600,8.277,3.357,99.702,36.892,2.745,2.538
 1526.909,110.188,742.285,47.169,-126.238,14.936,9.894,0.025,2.559,3.574,8.829,2.685,102.113,38.596,2.558,2.398
 1527.409,110.110,749.707,49.595,-126.486,15.773,9.899,0.025,2.547,3.565,9.550,2.102,98.435,35.997,2.372,2.302
 1527.909,110.206,751.611,45.529,-126.755,17.385,9.898,0.021,2.538,3.556,10.045,1.715,89.902,29.966,2.242,2.236
 1528.409,110.248,738.428,37.554,-126.826,19.591,9.898,0.013,2.539,3.711,10.017,1.673,81.519,24.042,2.170,2.180
 1528.909,110.157,742.188,32.991,-129.465,21.764,9.899,0.006,2.549,3.885,9.434,1.943,76.423,20.440,2.128,2.110
 1529.409,110.184,735.938,34.489,-129.942,22.612,9.902,0.002,2.560,3.940,8.786,2.347,73.908,18.663,2.108,2.052
 1529.909,110.196,745.508,38.204,-131.571,21.470,9.913,0.001,2.560,3.857,8.790,2.569,71.932,17.266,2.103,2.028
 1530.409,110.223,737.305,40.422,-132.147,19.238,9.937,0.004,2.553,3.673,9.198,2.473,69.642,15.648,2.117,2.057
 1530.909,110.161,750.928,41.861,-131.279,17.981,9.979,0.005,2.542,3.656,9.853,2.189,67.343,14.024,2.145,2.120
 1531.409,110.228,747.070,46.492,-127.978,18.518,10.039,0.006,2.521,3.664,11.066,1.890,67.127,13.871,2.155,2.176
 1531.909,110.204,737.305,58.658,-123.255,19.998,10.123,0.013,2.500,3.542,12.273,1.716,69.330,15.427,2.117,2.189
 1532.409,110.148,744.922,78.189,-119.670,21.740,10.263,0.036,2.476,3.303,13.681,1.682,73.522,18.390,2.044,2.163
 1532.909,110.119,742.529,97.547,-116.604,24.330,10.489,0.078,2.427,3.047,16.539,1.693,80.694,23.459,1.963,2.133
 1533.409,110.088,740.527,111.254,-113.221,27.991,10.854,0.115,2.334,2.880,21.998,1.673,90.613,30.469,1.915,2.128
 1533.909,110.157,737.305,113.612,-110.073,32.048,11.585,0.131,2.217,2.805,28.854,1.623,100.620,37.540,1.906,2.150
 1534.409,110.149,741.602,108.974,-106.474,36.227,12.057,0.130,2.134,2.731,33.677,1.603,105.928,41.292,1.909,2.158
 1534.909,110.126,746.094,107.002,-106.573,39.544,11.795,0.127,2.136,2.741,33.545,1.645,104.212,40.079,1.913,2.144
 1535.409,110.120,751.953,105.581,-105.981,40.813,11.599,0.130,2.181,2.830,30.952,1.702,99.253,36.575,1.898,2.112
 1535.909,110.113,765.869,105.788,-106.809,39.490,11.610,0.128,2.202,2.848,29.715,1.739,95.852,34.171,1.885,2.091
 1536.409,110.153,737.598,105.382,-106.362,37.065,11.738,0.116,2.192,2.812,30.315,1.742,95.816,34.145,1.883,2.097
 1536.909,110.148,732.422,103.926,-105.760,36.285,11.865,0.106,2.173,2.714,31.407,1.722,97.103,35.055,1.892,2.107
 1537.409,110.002,737.500,102.943,-104.064,37.219,11.889,0.114,2.170,2.732,31.586,1.706,97.602,35.408,1.902,2.122
 1537.909,110.207,747.070,99.874,-106.543,38.280,11.715,0.143,2.142,2.812,33.205,1.696,97.180,35.110,1.893,2.112
 1538.409,110.181,737.988,95.907,-108.457,39.020,11.669,0.174,2.080,2.770,36.817,1.695,96.719,34.783,1.868,2.087
 1538.909,110.178,741.309,94.617,-108.864,40.201,11.885,0.192,2.017,2.625,40.500,1.696,97.305,35.198,1.831,2.051
 1539.409,110.118,737.891,92.415,-107.427,42.915,11.621,0.196,1.984,2.513,42.477,1.688,98.446,36.004,1.798,2.014
 1539.909,110.219,748.438,91.481,-108.051,47.397,11.509,0.189,1.984,2.498,42.457,1.672,100.088,37.165,1.783,2.011
 1540.409,110.126,752.783,91.960,-106.981,50.738,11.497,0.176,2.000,2.473,41.543,1.659,101.737,38.330,1.801,2.047
 1540.909,110.097,753.467,94.941,-107.453,50.069,11.674,0.157,2.032,2.464,39.657,1.673,102.548,38.903,1.866,2.137
 1541.409,110.197,751.953,99.527,-105.174,46.184,11.779,0.140,2.097,2.488,35.842,1.758,101.923,38.461,1.988,2.268
 1541.909,110.198,741.113,97.508,-104.689,41.672,11.195,0.124,2.200,2.568,29.848,2.038,98.695,36.180,2.167,2.416
 1542.409,110.244,746.875,91.745,-107.319,38.969,10.740,0.099,2.315,2.705,23.083,2.709,92.001,31.449,2.384,2.554
 1542.909,110.118,732.422,80.181,-110.286,36.328,10.423,0.062,2.424,3.031,16.735,3.688,82.467,24.712,2.610,2.663
 1543.409,110.079,727.539,67.757,-114.916,31.239,10.212,0.031,2.512,3.509,11.596,4.302,73.849,18.621,2.799,2.747
 1543.909,110.266,735.645,59.719,-119.523,24.447,10.216,0.018,2.567,3.807,8.358,4.166,69.262,15.379,2.917,2.788
 1544.409,110.190,744.336,58.383,-122.594,19.262,10.271,0.016,2.577,3.842,7.793,3.463,69.326,15.424,2.894,2.732
 1544.909,110.226,739.648,56.632,-124.166,18.349,10.306,0.014,2.551,3.775,9.286,2.775,71.007,16.613,2.715,2.545
 1545.409,110.214,737.305,47.666,-126.847,20.624,10.321,0.010,2.511,3.790,11.628,2.399,71.209,16.755,2.405,2.254
 1545.909,110.105,732.764,34.605,-128.710,22.628,10.335,0.005,2.479,3.932,13.510,2.094,69.873,15.811,2.066,1.959
 1546.409,110.229,734.619,23.922,-133.792,22.725,10.351,0.003,2.459,4.091,14.662,1.696,68.288,14.691,1.785,1.721
 1546.909,110.024,737.305,20.349,-135.266,21.744,10.363,0.001,2.443,4.199,15.642,1.331,67.546,14.167,1.572,1.547
 1547.409,110.132,737.305,20.228,-135.182,21.402,10.367,0.003,2.426,4.218,16.604,1.133,67.964,14.462,1.437,1.429
 1547.909,110.078,737.598,21.195,-134.956,22.587,10.367,0.010,2.415,4.096,17.279,1.061,68.850,15.088,1.344,1.342
 1548.409,110.036,747.070,23.158,-135.421,25.582,10.361,0.023,2.415,3.930,17.278,1.108,69.594,15.614,1.290,1.284
 1548.909,110.270,742.188,26.037,-135.314,28.858,10.336,0.035,2.425,3.935,16.691,1.204,69.703,15.691,1.260,1.247
 1549.409,110.229,745.117,29.177,-135.894,30.400,10.300,0.037,2.439,4.109,15.857,1.291,69.033,15.218,1.257,1.237
 1549.909,110.012,747.656,31.196,-135.555,30.175,10.273,0.031,2.452,4.245,15.088,1.358,68.121,14.573,1.278,1.251
 1550.409,110.226,751.953,33.489,-136.021,29.372,10.240,0.021,2.459,4.191,14.653,1.498,67.418,14.076,1.322,1.288
 1550.909,110.251,757.568,35.647,-134.887,29.520,10.184,0.015,2.468,4.035,14.135,1.814,67.150,13.887,1.381,1.335
 1551.409,110.242,740.674,36.035,-134.337,30.675,10.094,0.010,2.475,3.827,13.725,2.313,67.236,13.948,1.447,1.384
 1551.909,110.171,741.113,35.820,-134.363,31.360,10.001,0.005,2.478,3.627,13.574,2.819,67.389,14.056,1.514,1.429
 1552.409,110.187,722.852,35.254,-135.102,30.905,9.942,-0.000,2.471,3.419,13.951,3.189,67.599,14.204,1.566,1.465
 1552.909,110.075,727.539,34.811,-133.757,29.296,9.913,-0.001,2.459,3.340,14.684,3.355,68.528,14.861,1.601,1.496
 1553.409,110.210,727.539,36.252,-131.628,27.079,9.895,0.005,2.448,3.423,15.308,3.296,70.557,16.295,1.619,1.533
 1553.909,110.277,729.053,40.128,-128.391,25.096,9.886,0.015,2.436,3.548,16.002,2.980,73.113,18.101,1.642,1.591
 1554.409,110.060,732.422,48.253,-126.763,23.867,9.889,0.030,2.419,3.674,17.038,2.425,76.352,20.390,1.689,1.689
 1554.909,110.194,730.664,62.496,-124.297,24.551,9.892,0.065,2.407,3.606,17.733,1.871,80.418,23.264,1.768,1.817
 1555.409,110.014,740.576,80.586,-121.861,27.143,10.048,0.097,2.411,3.394,17.461,1.609,86.417,27.503,1.874,1.955
 1555.909,110.135,740.186,92.011,-117.960,29.126,10.281,0.095,2.447,3.295,15.375,1.831,95.248,33.744,1.987,2.078
 1556.409,110.189,737.305,89.378,-114.757,28.107,10.052,0.065,2.508,3.331,11.828,2.301,103.402,39.507,2.100,2.174
 1556.909,110.147,747.070,78.620,-111.844,23.784,9.756,0.026,2.560,3.481,8.752,2.655,106.788,41.899,2.225,2.278
 1557.409,110.235,747.070,70.655,-108.568,19.204,9.753,0.012,2.593,3.525,6.840,2.722,103.580,39.632,2.373,2.408
 1557.909,110.142,744.678,71.568,-106.164,17.708,9.744,0.015,2.592,3.407,6.873,2.580,96.651,34.736,2.525,2.569
 1558.409,110.165,746.924,74.347,-104.033,18.950,9.733,0.014,2.572,3.453,8.092,2.504,91.948,31.412,2.665,2.750
 1558.909,110.075,742.188,73.120,-102.764,20.958,9.734,0.022,2.561,3.701,8.739,2.544,91.235,30.908,2.773,2.924
 1559.409,110.274,742.578,70.144,-101.193,21.927,9.742,0.036,2.558,3.849,8.882,2.608,94.389,33.137,2.857,3.049
 1559.909,110.114,750.000,69.012,-100.732,21.937,9.747,0.053,2.537,3.908,10.136,2.597,100.832,37.690,2.911,3.034
 1560.409,110.138,732.422,69.777,-102.142,22.129,9.728,0.078,2.501,3.747,12.237,2.494,107.430,42.353,2.809,2.807
 1560.909,110.279,738.770,69.152,-102.562,22.728,9.759,0.093,2.452,3.489,15.075,2.410,114.014,47.006,2.456,2.428
 1561.409,110.176,746.240,68.638,-103.464,23.409,9.772,0.096,2.396,3.558,18.359,2.286,120.510,51.598,2.038,2.098
 1561.909,110.213,742.188,67.939,-105.148,23.906,9.715,0.099,2.289,3.652,24.608,2.032,129.586,58.011,1.692,1.909
 1562.409,110.252,744.922,68.886,-106.290,25.326,10.410,0.103,2.086,3.506,36.492,1.671,141.876,66.697,1.512,1.893
 1562.909,110.101,733.643,72.943,-108.768,30.978,12.014,0.110,1.835,3.024,51.175,1.301,149.590,72.148,1.468,2.012
 1563.409,110.190,736.377,75.048,-110.022,43.366,12.928,0.099,1.699,2.388,59.096,1.207,145.070,68.954,1.501,2.085
 1563.909,110.067,739.355,69.412,-112.760,55.943,12.992,0.062,1.785,2.365,54.084,1.588,130.681,58.785,1.541,1.982
 1564.409,110.126,742.188,56.874,-115.230,58.344,11.572,0.031,2.046,2.927,38.807,2.315,112.565,45.983,1.509,1.720
 1564.909,110.148,742.188,42.065,-117.833,48.257,9.900,0.014,2.312,3.654,23.282,2.914,97.773,35.528,1.436,1.495
 1565.409,110.175,740.918,29.978,-120.300,33.008,9.724,0.011,2.449,4.139,15.262,2.891,88.009,28.628,1.382,1.378
 1565.909,110.314,747.070,28.065,-120.990,24.049,9.801,0.017,2.476,4.121,13.700,2.281,81.081,23.732,1.359,1.324
 1566.409,110.268,749.072,35.173,-122.918,23.713,9.890,0.024,2.453,3.748,15.007,1.544,78.938,22.218,1.339,1.276
 1566.909,110.377,742.773,42.141,-122.891,27.354,9.993,0.027,2.430,3.232,16.396,1.129,80.094,23.034,1.253,1.183
 1567.409,110.163,742.188,43.424,-125.121,31.308,10.033,0.022,2.419,2.897,17.026,1.120,80.532,23.344,1.107,1.052
 1567.909,110.248,737.354,39.660,-128.079,33.469,10.022,0.015,2.417,2.788,17.125,1.173,78.530,21.929,0.958,0.938
 1568.409,110.261,747.070,38.649,-132.352,33.901,10.032,0.013,2.417,2.835,17.143,1.047,75.948,20.105,0.860,0.863
 1568.909,110.206,751.514,41.298,-134.213,34.248,10.053,0.013,2.406,2.870,17.753,0.800,74.870,19.343,0.806,0.824
 1569.409,110.280,737.305,42.496,-135.223,35.563,10.074,0.010,2.389,2.871,18.747,0.656,75.320,19.661,0.788,0.809
 1569.909,110.207,737.305,41.738,-133.341,36.638,10.080,0.006,2.382,3.015,19.158,0.739,75.460,19.759,0.786,0.805
 1570.409,110.268,746.240,39.455,-132.355,35.651,10.080,0.003,2.384,3.410,19.037,0.951,74.916,19.376,0.794,0.817
 1570.909,110.154,749.414,40.442,-133.375,33.321,10.072,0.001,2.383,3.784,19.108,1.101,74.452,19.047,0.816,0.843
 1571.409,110.214,741.943,50.026,-133.065,31.318,10.045,0.003,2.382,3.865,19.208,1.121,74.558,19.123,0.850,0.883
 1571.909,110.114,756.836,66.838,-132.561,30.636,9.987,0.006,2.391,3.732,18.677,1.088,74.923,19.380,0.893,0.923
 1572.409,110.128,746.582,80.246,-131.687,30.438,9.893,0.006,2.413,3.601,17.381,1.077,75.164,19.551,0.927,0.952
 1572.909,110.208,750.830,82.072,-129.558,29.338,9.782,0.004,2.438,3.661,15.897,1.056,75.352,19.684,0.950,0.981
 1573.409,110.230,747.070,72.263,-128.639,26.990,9.720,0.002,2.447,3.715,15.399,0.955,75.740,19.958,0.965,1.027
 1573.909,110.113,737.305,60.691,-127.217,25.411,9.711,0.002,2.439,3.557,15.842,0.815,76.376,20.407,0.996,1.096
 1574.409,110.238,749.023,53.660,-126.920,27.088,9.697,0.004,2.436,3.371,16.001,0.753,76.871,20.757,1.049,1.181
 1574.909,110.334,751.953,54.258,-125.168,30.996,9.668,0.004,2.455,3.316,14.935,0.875,76.809,20.713,1.129,1.267
 1575.409,110.216,735.352,59.285,-122.910,33.853,9.628,0.003,2.488,3.409,13.004,1.157,76.335,20.378,1.228,1.365
 1575.909,110.218,737.842,65.833,-119.539,33.025,9.587,0.003,2.519,3.437,11.189,1.510,75.886,20.061,1.357,1.497
 1576.409,110.140,742.725,75.262,-117.173,29.707,9.555,0.001,2.537,3.365,10.088,1.858,75.734,19.954,1.536,1.688
 1576.909,110.255,747.070,85.605,-115.015,26.526,9.529,0.002,2.553,3.311,9.154,2.154,75.853,20.038,1.805,1.982
 1577.409,110.299,747.070,93.217,-113.372,24.370,9.515,0.003,2.569,3.294,8.265,2.415,75.862,20.044,2.176,2.361
 1577.909,110.284,752.246,93.178,-113.382,23.135,9.512,0.002,2.573,3.302,7.983,2.831,74.871,19.343,2.620,2.828
 1578.409,110.183,747.070,84.613,-113.704,22.114,9.512,0.001,2.575,3.409,7.887,3.500,72.477,17.652,3.058,3.260
 1578.909,110.268,751.855,68.281,-114.980,20.508,9.513,0.001,2.577,3.797,7.758,4.151,68.681,14.969,3.345,3.549
 1579.409,110.313,751.953,51.839,-116.555,18.256,9.527,0.007,2.584,4.208,7.363,4.424,65.115,12.449,3.541,3.677
 1579.909,110.349,746.484,41.821,-116.944,16.032,9.553,0.012,2.585,4.436,7.283,4.120,63.611,11.386,3.609,3.685
 1580.409,110.199,752.393,37.857,-118.310,14.604,9.565,0.014,2.577,4.465,7.776,3.585,63.843,11.550,3.618,3.648
 1580.909,110.167,756.836,36.274,-120.725,14.645,9.559,0.009,2.554,4.380,9.140,3.208,64.754,12.193,3.550,3.580
 1581.409,110.309,747.070,32.983,-122.224,15.692,9.545,0.003,2.532,4.339,10.422,3.021,65.141,12.467,3.448,3.499
 1581.909,110.327,747.070,28.290,-123.042,16.688,9.523,-0.002,2.519,4.329,11.182,2.970,64.783,12.214,3.343,3.420
 1582.409,110.379,744.434,26.520,-122.471,17.026,9.497,-0.005,2.511,4.357,11.664,3.005,64.323,11.889,3.270,3.372
 1582.909,110.377,739.355,29.106,-122.822,16.801,9.475,-0.005,2.510,4.390,11.707,3.074,64.188,11.794,3.251,3.367
 1583.409,110.358,751.953,32.989,-122.709,16.430,9.456,-0.005,2.511,4.334,11.655,3.167,64.324,11.890,3.289,3.416
 1583.909,110.278,751.953,37.326,-122.247,16.313,9.437,-0.005,2.516,4.282,11.326,3.290,64.551,12.050,3.397,3.526
 1584.409,110.314,747.070,39.097,-122.442,16.580,9.424,-0.004,2.525,4.284,10.800,3.428,64.613,12.094,3.540,3.687
 1584.909,110.274,747.070,38.329,-122.160,17.104,9.419,-0.004,2.535,4.291,10.218,3.590,65.926,13.022,3.709,3.863
 1585.409,110.302,745.459,38.053,-121.139,17.468,9.417,-0.004,2.544,4.315,9.731,3.804,71.464,16.936,3.849,4.014
 1585.909,110.287,742.188,39.248,-120.236,17.217,9.417,-0.004,2.553,4.286,9.174,4.083,79.703,22.758,3.943,4.114
 1586.409,110.262,747.070,44.716,-116.613,16.292,9.421,-0.000,2.564,4.187,8.530,4.232,87.851,28.517,3.990,4.183
 1586.909,110.344,738.281,54.750,-111.478,15.358,9.456,0.006,2.570,3.892,8.188,4.131,92.812,32.022,4.007,4.236
 1587.409,110.368,743.457,68.847,-105.699,15.513,9.528,0.009,2.562,3.531,8.645,3.925,95.521,33.937,4.019,4.267
 1587.909,110.390,751.953,84.076,-102.143,16.926,9.580,0.008,2.551,3.345,9.281,3.816,101.081,37.866,4.021,4.272
 1588.409,110.286,751.953,95.196,-102.690,19.101,9.591,0.005,2.554,3.427,9.149,3.895,112.238,45.752,3.999,4.240
 1588.909,110.382,747.119,96.969,-103.997,20.874,9.581,0.004,2.565,3.605,8.454,3.949,124.943,54.730,3.971,4.216
 1589.409,110.363,747.266,91.903,-103.709,21.589,9.564,0.007,2.579,3.592,7.659,3.874,133.281,60.623,3.926,4.196
 1589.909,110.281,751.758,90.212,-104.268,22.061,9.558,0.010,2.582,3.567,7.471,3.898,135.198,61.977,3.901,4.179
 1590.409,110.443,747.070,90.465,-104.597,22.266,9.557,0.020,2.572,3.779,8.095,4.064,130.714,58.808,3.908,4.200
 1590.909,110.371,756.836,87.247,-106.195,21.728,9.630,0.038,2.553,3.941,9.207,4.163,124.646,54.520,3.971,4.273
 1591.409,110.472,753.857,78.020,-107.342,20.513,9.952,0.049,2.528,3.898,10.659,4.083,118.484,50.166,4.121,4.493
 1591.909,110.325,756.836,66.021,-106.542,20.132,10.031,0.046,2.509,3.662,11.743,3.970,112.161,45.697,4.339,4.797
 1592.409,110.497,753.613,58.465,-106.826,21.810,9.824,0.029,2.503,3.452,12.093,4.377,106.666,41.814,4.604,5.124
 1592.909,110.315,751.025,52.050,-105.761,23.540,9.697,0.011,2.518,3.628,11.254,5.609,101.524,38.179,4.910,5.429
 1593.409,110.462,747.070,42.325,-105.057,22.516,9.550,0.007,2.556,3.950,9.018,7.112,94.090,32.926,5.291,5.709
 1593.909,110.393,757.959,36.385,-105.316,18.512,9.479,0.012,2.594,4.168,6.782,7.889,84.887,26.422,5.778,6.050
 1594.409,110.444,758.008,38.063,-106.751,14.067,9.512,0.017,2.609,4.207,5.909,7.664,76.359,20.395,6.429,6.438
 1594.909,110.431,756.836,44.714,-109.145,12.105,9.566,0.016,2.599,4.157,6.498,7.120,70.437,16.210,6.818,6.611
 1595.409,110.376,744.971,50.522,-109.288,12.616,9.599,0.009,2.579,4.183,7.669,6.911,67.351,14.029,6.734,6.431
 1595.909,110.460,737.305,50.355,-107.255,13.996,9.642,0.006,2.566,4.261,8.411,6.812,66.044,13.105,6.075,6.010
 1596.409,110.322,737.305,51.667,-105.902,15.040,9.721,0.011,2.560,4.203,8.759,6.179,67.476,14.117,5.354,5.591
 1596.909,110.440,751.953,60.889,-104.752,16.251,9.817,0.027,2.522,3.914,11.014,4.917,72.680,17.795,4.900,5.446
 1597.409,110.305,751.953,73.773,-104.912,19.124,9.897,0.052,2.456,3.476,14.828,3.671,79.898,22.896,4.665,5.418
 1597.909,110.509,756.152,78.727,-107.360,24.427,10.315,0.067,2.410,3.112,17.544,3.167,85.049,26.536,4.616,5.412
 1598.409,110.281,761.719,74.905,-110.272,29.657,10.532,0.062,2.417,3.074,17.152,3.518,84.994,26.498,4.555,5.267
 1598.909,110.453,759.424,64.883,-113.032,30.952,10.066,0.037,2.474,3.394,13.813,4.443,79.911,22.905,4.495,5.010
 1599.409,110.492,747.070,53.260,-114.529,28.143,9.780,0.010,2.530,3.820,10.536,5.269,74.343,18.971,4.486,4.877
 1599.909,110.529,751.953,46.574,-114.199,23.476,9.747,0.001,2.548,4.065,9.495,5.519,70.920,16.551,4.665,4.950
 1600.409,110.355,747.559,41.998,-115.046,20.302,9.706,0.002,2.544,4.125,9.721,5.431,69.270,15.385,5.028,5.253
 1600.909,110.528,756.836,40.381,-115.334,19.444,9.662,0.003,2.536,4.128,10.168,5.466,68.123,14.575,5.520,5.665
 1601.409,110.379,756.836,38.695,-116.857,19.090,9.619,0.001,2.531,4.173,10.493,5.792,66.692,13.563,5.907,5.997
 1601.909,110.421,756.836,36.478,-116.189,18.123,9.564,-0.002,2.533,4.120,10.323,6.157,65.658,12.832,6.055,6.204
 1602.409,110.420,756.152,36.123,-117.410,16.738,9.526,-0.002,2.542,4.019,9.813,6.180,65.522,12.737,5.966,6.218
 1602.909,110.324,751.953,37.901,-117.047,15.741,9.515,0.004,2.562,3.866,8.656,5.782,66.536,13.453,5.803,6.123
 1603.409,110.564,751.953,40.001,-116.890,15.592,9.510,0.009,2.578,3.764,7.693,5.411,67.978,14.472,5.668,5.974
 1603.909,110.429,751.953,42.549,-117.402,16.198,9.489,0.008,2.583,3.776,7.406,5.233,69.445,15.509,5.547,5.826
 1604.409,110.468,758.008,47.014,-117.829,16.857,9.442,0.005,2.582,3.733,7.493,5.069,71.386,16.880,5.463,5.728
 1604.909,110.500,761.719,52.810,-118.666,17.144,9.397,0.005,2.583,3.564,7.403,4.937,72.804,17.883,5.365,5.641
 1605.409,110.521,750.537,56.466,-116.776,17.250,9.380,0.007,2.587,3.460,7.175,5.160,72.721,17.824,5.317,5.571
 1605.909,110.572,747.070,58.279,-115.269,17.245,9.387,0.011,2.592,3.554,6.881,5.643,71.106,16.683,5.293,5.516
 1606.409,110.387,747.070,61.021,-113.245,16.934,9.464,0.016,2.600,3.727,6.440,5.927,69.452,15.514,5.327,5.509
 1606.909,110.403,755.469,63.998,-113.182,16.598,9.615,0.019,2.600,3.832,6.415,5.804,69.807,15.765,5.417,5.568
 1607.409,110.367,751.953,64.717,-113.512,16.712,9.738,0.016,2.593,3.786,6.852,5.580,71.659,17.073,5.519,5.639
 1607.909,110.582,756.396,60.349,-113.367,17.203,9.805,0.007,2.579,3.774,7.652,5.699,72.670,17.788,5.583,5.698
 1608.409,110.523,751.953,57.228,-112.673,17.645,9.817,-0.001,2.572,3.857,8.042,5.966,72.065,17.360,5.659,5.805
 1608.909,110.354,751.953,56.980,-112.047,17.799,9.799,0.001,2.582,3.883,7.514,6.072,71.021,16.623,5.754,5.959
 1609.409,110.501,752.148,58.086,-112.572,18.456,9.754,0.004,2.588,3.847,7.129,6.094,71.426,16.909,6.079,6.285
 1609.909,110.445,747.070,56.302,-114.345,20.186,9.632,0.006,2.582,3.809,7.506,6.337,73.137,18.118,6.598,6.684
 1610.409,110.488,752.246,50.029,-114.561,21.798,9.476,0.008,2.571,3.802,8.131,7.485,73.633,18.469,7.218,6.954
 1610.909,110.528,751.953,44.017,-114.246,21.355,9.373,0.006,2.568,3.900,8.282,9.569,72.209,17.462,7.681,7.045
 1611.409,110.537,751.953,40.831,-113.773,17.879,9.252,0.002,2.582,4.154,7.477,11.424,69.781,15.746,7.337,6.707
 1611.909,110.394,751.465,41.023,-114.854,13.271,9.166,-0.001,2.588,4.562,7.157,11.493,69.365,15.452,6.572,6.267
 1612.409,110.467,750.098,45.456,-113.443,10.171,9.202,0.022,2.551,4.911,9.309,9.090,72.840,17.908,5.540,5.877
 1612.909,110.428,751.953,56.852,-112.798,9.732,9.472,0.077,2.473,4.684,13.850,5.779,80.502,23.323,4.588,5.371
 1613.409,110.349,751.953,72.965,-110.923,12.723,10.326,0.134,2.378,3.918,19.442,3.429,91.668,31.214,3.685,4.622
 1613.909,110.555,756.836,87.892,-111.977,18.685,10.900,0.155,2.280,3.125,25.136,2.361,103.669,39.695,2.827,3.528
 1614.409,110.471,749.805,97.742,-112.698,25.943,11.157,0.144,2.190,2.754,30.407,1.961,117.255,49.297,2.109,2.563
 1614.909,110.587,751.953,103.811,-115.811,32.826,11.447,0.137,2.086,2.704,36.498,1.661,130.818,58.882,1.571,1.906
 1615.409,110.500,751.953,104.237,-117.887,38.742,11.729,0.145,1.936,2.571,45.262,1.383,143.380,67.760,1.222,1.518
 1615.909,110.553,753.369,98.245,-119.276,43.661,12.308,0.142,1.753,2.313,55.941,1.166,154.248,75.440,1.019,1.331
 1616.409,110.505,756.836,89.634,-118.867,49.404,12.277,0.103,1.568,2.001,66.799,1.016,159.497,79.150,0.917,1.259
 1616.909,110.516,755.273,82.409,-119.167,57.245,12.322,0.052,1.472,1.819,72.393,0.928,154.075,75.318,0.892,1.276
 1617.409,110.454,753.320,77.871,-118.897,65.629,12.496,0.024,1.533,1.776,68.820,0.939,139.495,65.014,0.922,1.328
 1617.909,110.473,753.857,72.891,-117.733,69.231,12.372,0.018,1.757,1.963,55.751,1.266,121.428,52.246,1.001,1.390
 1618.409,110.364,752.393,65.745,-116.233,63.750,11.437,0.018,2.055,2.475,38.281,1.955,108.188,42.889,1.118,1.464
 1618.909,110.510,756.836,60.566,-114.084,49.764,10.058,0.014,2.318,3.042,22.924,2.761,104.196,40.068,1.284,1.587
 1619.409,110.575,756.836,60.826,-112.877,35.000,9.738,0.008,2.484,3.469,13.239,3.322,105.449,40.953,1.517,1.823
 1619.909,110.571,761.914,66.346,-111.663,26.509,9.780,0.014,2.526,3.700,10.738,3.296,109.672,43.938,1.862,2.259
 1620.409,110.686,756.836,74.786,-112.500,24.355,9.769,0.038,2.480,3.753,13.457,2.894,113.788,46.846,2.331,2.977
 1620.909,110.452,754.248,81.150,-113.507,28.121,9.719,0.073,2.357,3.524,20.635,2.470,114.273,47.189,2.901,4.088
 1621.409,110.716,747.070,84.760,-113.869,34.467,10.400,0.091,2.253,3.243,26.721,2.596,111.375,45.141,3.444,5.325
 1621.909,110.390,749.902,80.629,-114.057,39.130,10.924,0.073,2.269,3.298,25.774,4.337,106.527,41.715,3.815,5.923
 1622.409,110.523,756.836,68.511,-113.449,37.549,9.851,0.034,2.391,3.644,18.656,7.395,99.847,36.994,4.036,5.474
 1622.909,110.493,756.836,52.430,-113.967,28.976,9.010,0.003,2.543,4.096,9.757,11.422,96.698,34.769,4.244,4.721
 1623.409,110.565,755.615,38.307,-113.850,18.482,8.979,-0.007,2.625,4.319,4.990,14.371,98.989,36.388,4.362,4.076
 1623.909,110.592,763.281,32.425,-115.290,11.217,8.971,-0.006,2.633,4.365,4.514,13.965,103.943,39.889,4.256,3.640
 1624.409,110.499,756.836,34.808,-115.047,8.356,9.007,0.003,2.621,4.410,5.228,10.749,107.980,42.742,3.757,3.263
 1624.909,110.638,753.320,45.269,-115.607,8.554,9.161,0.024,2.586,4.250,7.274,6.332,108.835,43.346,3.086,2.892
 1625.409,110.435,751.953,62.240,-113.831,11.806,9.432,0.062,2.527,3.786,10.721,3.174,109.731,43.980,2.505,2.604
 1625.909,110.494,759.473,82.787,-112.061,17.913,9.773,0.107,2.447,3.319,15.362,1.956,111.489,45.222,2.116,2.378
 1626.409,110.633,761.719,98.568,-108.054,25.276,10.074,0.141,2.336,3.049,21.845,1.568,114.569,47.399,1.913,2.263
 1626.909,110.488,761.719,103.298,-104.969,32.208,10.229,0.155,2.214,2.859,29.026,1.458,117.997,49.822,1.833,2.201
 1627.409,110.484,753.613,97.355,-104.484,37.805,11.034,0.133,2.153,2.803,32.570,1.725,119.927,51.185,1.850,2.186
 1627.909,110.591,756.836,85.753,-105.422,41.093,11.204,0.089,2.212,2.980,29.151,2.463,114.079,47.052,1.925,2.199
 1628.409,110.602,757.666,72.687,-107.399,38.573,9.838,0.045,2.374,3.438,19.673,3.397,100.744,37.628,2.054,2.239
 1628.909,110.370,762.158,61.709,-107.329,31.122,9.101,0.014,2.533,3.923,10.344,4.080,88.341,28.863,2.256,2.377
 1629.409,110.464,763.867,58.099,-108.346,22.253,9.093,0.006,2.600,4.091,6.406,4.195,83.121,25.174,2.558,2.636
 1629.909,110.569,757.227,57.600,-109.280,16.578,9.097,0.004,2.604,4.096,6.182,3.986,85.734,27.020,2.931,3.006
 1630.409,110.581,756.836,55.206,-110.579,15.672,9.101,0.002,2.592,4.051,6.917,3.770,89.674,29.805,3.322,3.442
 1630.909,110.646,756.836,50.360,-110.528,16.050,9.107,0.003,2.593,3.975,6.840,3.624,93.967,32.839,3.574,3.778
 1631.409,110.601,756.836,44.572,-109.741,16.252,9.111,0.006,2.599,3.847,6.469,3.526,100.446,37.418,3.654,3.998
 1631.909,110.548,757.129,40.856,-107.619,16.294,9.119,0.010,2.608,3.774,5.976,3.474,107.220,42.205,3.641,4.071
 1632.409,110.629,756.055,38.598,-107.614,16.635,9.124,0.012,2.610,3.862,5.820,3.530,113.064,46.335,3.628,3.999
 1632.909,110.622,756.836,40.118,-107.860,17.214,9.125,0.011,2.608,3.939,5.986,3.696,116.757,48.945,3.649,3.868
 1633.409,110.633,756.836,44.746,-108.687,17.688,9.129,0.010,2.606,3.911,6.087,3.895,118.467,50.153,3.604,3.676
 1633.909,110.434,753.418,48.304,-109.465,17.775,9.136,0.010,2.604,3.902,6.177,4.031,119.332,50.765,3.496,3.490
 1634.409,110.569,761.719,49.307,-110.067,17.457,9.143,0.013,2.604,4.001,6.185,3.938,118.345,50.067,3.325,3.349
 1634.909,110.645,773.438,50.166,-111.360,17.457,9.152,0.020,2.604,4.074,6.227,3.582,116.269,48.600,3.192,3.287
 1635.409,110.593,761.719,52.045,-113.220,18.725,9.148,0.028,2.598,4.045,6.542,3.058,114.688,47.482,3.147,3.355
 1635.909,110.506,761.719,54.532,-115.390,21.136,9.101,0.031,2.588,3.856,7.128,2.713,112.671,46.057,3.191,3.497
 1636.409,110.621,757.959,57.082,-116.666,22.993,9.042,0.027,2.578,3.784,7.720,3.016,108.565,43.155,3.343,3.695
 1636.909,110.537,756.836,60.035,-115.626,22.707,8.971,0.017,2.578,4.039,7.706,4.107,102.694,39.006,3.571,3.896
 1637.409,110.519,764.844,62.473,-116.452,20.147,8.916,0.006,2.591,4.385,6.977,6.318,98.577,36.097,3.909,4.123
 1637.909,110.678,766.602,56.826,-117.519,16.413,8.894,-0.002,2.607,4.626,6.049,9.370,98.822,36.270,4.408,4.488
 1638.409,110.525,758.105,48.591,-118.673,12.896,8.879,-0.005,2.622,4.655,5.127,11.950,100.875,37.721,5.115,4.989
 1638.909,110.593,768.506,43.773,-118.547,9.951,8.884,-0.004,2.636,4.615,4.338,13.101,100.394,37.381,6.130,5.750
 1639.409,110.623,771.484,41.903,-117.762,7.941,8.905,0.005,2.654,4.698,3.284,12.594,96.304,34.490,7.336,6.635
 1639.909,110.649,762.305,40.757,-115.989,7.239,8.938,0.018,2.669,4.868,2.414,11.512,92.044,31.480,8.478,7.516
 1640.409,110.584,756.836,37.330,-117.150,7.261,8.949,0.029,2.675,4.981,2.075,10.835,90.427,30.337,9.182,8.277
 1640.909,110.666,759.229,34.629,-115.266,7.473,8.953,0.027,2.662,4.833,2.815,10.927,90.639,30.487,9.524,8.583
 1641.409,110.650,761.572,33.439,-115.210,7.527,8.972,0.018,2.644,4.600,3.834,11.181,90.979,30.727,9.617,8.653
 1641.909,110.473,747.070,34.954,-114.162,7.562,9.001,0.010,2.636,4.372,4.322,10.840,90.663,30.504,9.734,8.233
 1642.409,110.565,766.602,40.326,-113.846,7.979,9.044,0.008,2.635,4.341,4.395,9.765,91.895,31.375,9.312,7.530
 1642.909,110.712,757.959,47.954,-112.726,8.874,9.087,0.007,2.627,4.458,4.825,8.215,95.758,34.104,7.883,6.325
 1643.409,110.643,751.953,54.705,-110.600,9.772,9.147,0.005,2.619,4.552,5.325,7.023,97.903,35.621,6.217,5.147
 1643.909,110.576,758.105,59.129,-108.465,10.425,9.218,0.012,2.619,4.676,5.346,5.874,96.410,34.565,4.559,4.128
 1644.409,110.737,761.719,61.309,-106.669,11.333,9.359,0.038,2.594,4.601,6.800,4.571,94.543,33.246,3.504,3.387
 1644.909,110.523,761.719,64.560,-105.545,14.041,10.147,0.089,2.503,4.217,12.078,3.155,96.505,34.633,2.788,2.920
 1645.409,110.690,771.484,71.438,-103.612,19.996,11.654,0.144,2.348,3.592,21.166,2.070,103.957,39.899,2.363,2.575
 1645.909,110.496,757.227,81.091,-102.351,29.559,12.338,0.181,2.161,3.045,32.108,1.622,113.889,46.918,2.071,2.341
 1646.409,110.684,766.602,90.413,-101.871,39.993,11.801,0.192,2.001,2.699,41.461,1.484,121.250,52.120,1.866,2.121
 1646.909,110.685,766.602,98.457,-101.073,47.051,11.737,0.182,1.941,2.548,44.991,1.481,124.122,54.150,1.703,1.923
 1647.409,110.539,766.602,102.825,-100.887,48.771,11.972,0.165,1.995,2.619,41.837,1.545,124.149,54.169,1.580,1.757
 1647.909,110.646,758.496,102.929,-99.710,46.087,11.605,0.160,2.106,2.850,35.345,1.612,124.952,54.736,1.490,1.628
 1648.409,110.678,756.836,101.891,-99.505,42.464,11.395,0.173,2.168,3.035,31.673,1.612,125.956,55.446,1.435,1.567
 1648.909,110.560,752.588,99.752,-99.328,41.444,11.712,0.198,2.142,3.046,33.229,1.541,125.459,55.095,1.419,1.562
 1649.409,110.611,761.719,101.941,-99.239,45.742,12.048,0.217,2.062,2.865,37.910,1.449,122.255,52.830,1.430,1.616
 1649.909,110.618,770.703,109.958,-98.109,54.822,12.354,0.219,1.993,2.666,41.931,1.393,117.938,49.780,1.471,1.699
 1650.409,110.713,761.230,116.041,-99.098,63.810,12.430,0.210,1.979,2.553,42.777,1.405,114.617,47.433,1.533,1.794
 1650.909,110.591,766.602,114.531,-101.176,67.824,11.862,0.190,2.039,2.461,39.266,1.529,110.392,44.447,1.614,1.882
 1651.409,110.603,771.484,105.490,-103.729,63.726,11.412,0.144,2.186,2.631,30.645,1.869,102.666,38.987,1.717,1.963
 1651.909,110.736,776.367,93.857,-104.723,55.130,11.023,0.089,2.358,2.925,20.582,2.318,93.717,32.662,1.844,2.046
 1652.409,110.665,771.094,88.434,-101.856,45.531,10.424,0.046,2.486,3.155,13.097,2.667,87.958,28.592,2.000,2.145
 1652.909,110.610,753.320,88.137,-99.973,37.611,10.245,0.024,2.546,3.264,9.600,2.799,86.687,27.694,2.180,2.288
 1653.409,110.673,771.484,91.526,-98.871,33.177,10.322,0.021,2.546,3.146,9.609,2.720,88.104,28.695,2.350,2.445
 1653.909,110.648,775.293,95.359,-99.887,31.629,10.407,0.020,2.528,3.015,10.641,2.609,89.046,29.361,2.481,2.602
 1654.409,110.700,769.727,99.212,-101.755,31.976,10.463,0.023,2.519,2.913,11.152,2.509,89.565,29.728,2.553,2.719
 1654.909,110.530,773.828,98.748,-103.462,31.711,10.552,0.032,2.523,2.814,10.958,2.420,91.994,31.444,2.578,2.785
 1655.409,110.617,779.395,94.416,-103.697,31.293,10.873,0.035,2.523,2.755,10.920,2.395,96.404,34.561,2.588,2.816
 1655.909,110.724,771.484,94.928,-103.876,31.748,10.840,0.029,2.521,2.730,11.035,2.495,99.206,36.541,2.600,2.801
 1656.409,110.499,775.049,96.724,-102.426,32.078,10.476,0.021,2.528,2.738,10.670,2.729,97.386,35.255,2.614,2.762
 1656.909,110.700,771.680,98.310,-102.735,30.804,10.325,0.016,2.538,2.786,10.054,2.973,91.729,31.257,2.626,2.727
 1657.409,110.736,786.133,96.019,-103.906,27.367,10.277,0.019,2.549,2.828,9.402,3.077,85.953,27.175,2.646,2.729
 1657.909,110.588,776.367,92.957,-104.672,23.995,10.308,0.027,2.553,2.828,9.180,3.004,83.056,25.128,2.677,2.777
 1658.409,110.699,768.262,96.536,-104.455,23.417,10.359,0.030,2.546,2.812,9.588,2.864,83.457,25.411,2.731,2.854
 1658.909,110.786,766.602,104.680,-103.769,25.560,10.353,0.025,2.536,2.801,10.152,2.803,85.458,26.826,2.779,2.922
 1659.409,110.773,775.195,110.832,-102.876,28.086,10.270,0.016,2.532,2.856,10.410,2.909,86.942,27.874,2.807,2.942
 1659.909,110.642,770.508,108.422,-102.832,29.820,10.188,0.009,2.533,2.966,10.349,3.138,86.771,27.753,2.789,2.911
 1660.409,110.738,766.260,100.268,-103.452,29.985,10.147,0.007,2.536,3.017,10.203,3.322,85.516,26.866,2.748,2.848
 1660.909,110.707,776.367,94.001,-104.315,27.841,10.125,0.007,2.534,2.959,10.289,3.305,84.432,26.100,2.710,2.804
 1661.409,110.654,766.895,92.543,-106.576,25.208,10.104,0.008,2.527,2.830,10.684,3.132,84.179,25.922,2.688,2.787
 1661.909,110.720,766.602,93.363,-106.857,23.778,10.088,0.008,2.512,2.780,11.590,2.955,84.708,26.295,2.695,2.805
 1662.409,110.787,762.012,91.903,-108.089,24.782,10.084,0.005,2.493,2.825,12.714,2.878,85.082,26.560,2.708,2.837
 1662.909,110.707,765.625,85.049,-108.570,27.338,10.083,0.006,2.492,2.911,12.756,2.985,84.406,26.082,2.724,2.850
 1663.409,110.844,766.602,76.335,-110.217,28.202,10.083,0.008,2.501,2.999,12.211,3.221,83.058,25.130,2.726,2.846
 1663.909,110.587,769.482,73.408,-109.910,26.586,10.091,0.009,2.511,3.029,11.657,3.505,81.882,24.298,2.726,2.824
 1664.409,110.683,775.781,75.545,-109.232,24.227,10.124,0.012,2.523,3.034,10.961,3.681,81.781,24.227,2.730,2.816
 1664.909,110.744,771.484,80.474,-108.021,23.250,10.180,0.018,2.535,3.020,10.224,3.606,82.995,25.085,2.747,2.834
 1665.409,110.686,766.602,85.746,-106.890,24.497,10.232,0.024,2.545,2.967,9.662,3.389,84.813,26.370,2.775,2.873
 1665.909,110.705,769.971,92.686,-106.052,26.753,10.259,0.025,2.543,2.912,9.743,3.204,86.554,27.600,2.785,2.905
 1666.409,110.792,770.459,99.210,-105.630,28.309,10.266,0.023,2.536,2.972,10.175,3.151,87.734,28.434,2.775,2.905
 1666.909,110.789,770.215,101.308,-106.090,28.391,10.226,0.022,2.537,3.040,10.130,3.185,88.041,28.651,2.733,2.876
 1667.409,110.769,766.602,98.485,-107.226,27.436,10.166,0.020,2.535,3.058,10.219,3.237,87.515,28.279,2.690,2.839
 1667.909,110.705,770.459,92.793,-107.336,26.311,10.107,0.015,2.522,3.026,10.966,3.208,86.713,27.713,2.668,2.822
 1668.409,110.624,761.377,90.574,-107.253,25.297,10.036,0.011,2.504,2.901,12.025,3.147,85.939,27.165,2.671,2.813
 1668.909,110.762,771.484,92.389,-106.845,24.524,9.974,0.009,2.492,2.822,12.770,3.197,85.113,26.582,2.698,2.812
 1669.409,110.832,766.602,92.055,-107.853,24.209,9.931,0.010,2.490,2.801,12.888,3.302,83.941,25.753,2.717,2.806
 1669.909,110.869,758.008,89.133,-108.743,24.042,9.920,0.008,2.487,2.785,13.069,3.377,82.621,24.820,2.713,2.799
 1670.409,110.712,762.842,83.421,-109.042,23.877,9.931,0.008,2.484,2.770,13.212,3.368,81.925,24.329,2.712,2.835
 1670.909,110.731,771.484,78.346,-108.403,23.815,9.952,0.011,2.489,2.747,12.949,3.315,82.211,24.531,2.739,2.916
 1671.409,110.771,771.484,78.719,-109.288,23.876,9.998,0.018,2.502,2.719,12.141,3.270,83.558,25.483,2.860,3.089
 1671.909,110.643,776.270,83.901,-109.728,24.129,10.040,0.024,2.513,2.749,11.525,3.205,85.122,26.588,3.072,3.332
 1672.409,110.757,778.809,87.176,-110.664,25.342,10.030,0.023,2.519,2.854,11.169,3.394,84.925,26.449,3.319,3.532
 1672.909,110.885,771.338,82.866,-109.697,26.840,9.982,0.017,2.539,3.141,9.993,4.184,81.689,24.162,3.495,3.613
 1673.409,110.735,771.973,70.275,-108.902,26.268,9.920,0.010,2.573,3.647,8.021,5.244,74.819,19.307,3.445,3.481
 1673.909,110.630,771.484,57.628,-107.303,23.049,9.911,0.013,2.592,4.198,6.876,5.599,68.266,14.676,3.262,3.277
 1674.409,110.818,771.484,58.262,-105.061,18.598,10.044,0.044,2.532,4.431,10.429,4.694,67.907,14.422,3.004,3.095
 1674.909,110.794,775.781,64.646,-102.469,17.213,10.341,0.101,2.386,4.149,18.967,3.217,74.680,19.208,2.755,2.934
 1675.409,110.864,771.484,71.607,-102.388,21.291,11.365,0.167,2.213,3.558,29.089,2.116,86.110,27.286,2.497,2.780
 1675.909,110.598,776.367,74.948,-102.442,28.279,12.583,0.211,2.084,3.000,36.614,1.690,95.896,34.202,2.245,2.584
 1676.409,110.797,776.367,75.853,-101.355,36.319,12.955,0.225,2.027,2.794,39.924,1.605,100.549,37.491,2.026,2.384
 1676.909,110.869,777.441,81.532,-101.136,43.397,12.929,0.223,2.005,2.781,41.209,1.562,101.410,38.099,1.865,2.213
 1677.409,110.714,781.250,86.309,-101.629,48.040,12.951,0.218,1.990,2.715,42.110,1.512,100.527,37.475,1.793,2.107
 1677.909,110.761,776.367,89.411,-102.902,49.908,12.969,0.199,2.008,2.603,41.057,1.500,98.270,35.880,1.792,2.073
 1678.409,110.844,764.795,88.243,-105.571,49.532,12.964,0.156,2.102,2.634,35.557,1.602,93.820,32.735,1.855,2.097
 1678.909,110.790,776.367,79.007,-105.752,47.910,12.339,0.101,2.264,2.999,26.081,1.798,86.822,27.790,1.958,2.191
 1679.409,110.812,768.164,66.513,-107.305,44.566,11.117,0.051,2.428,3.425,16.481,2.019,79.982,22.955,2.103,2.341
 1679.909,110.824,768.359,55.633,-107.066,39.080,10.504,0.026,2.536,3.675,10.181,2.244,76.246,20.315,2.292,2.561
 1680.409,110.895,771.484,51.033,-107.013,32.621,10.355,0.018,2.579,3.649,7.675,2.527,75.189,19.568,2.547,2.831
 1680.909,110.784,781.250,52.823,-105.626,27.700,10.279,0.016,2.584,3.588,7.395,2.946,75.341,19.675,2.843,3.127
 1681.409,110.801,772.168,52.997,-103.973,24.863,10.350,0.012,2.586,3.709,7.279,3.424,74.864,19.339,3.162,3.431
 1681.909,110.810,776.367,52.606,-103.131,23.019,10.341,0.007,2.591,3.804,6.971,3.744,74.494,19.077,3.432,3.706
 1682.409,110.710,776.367,54.257,-101.854,21.072,10.245,0.003,2.598,3.781,6.540,3.844,75.652,19.896,3.660,3.968
 1682.909,110.889,776.270,59.092,-101.864,19.611,10.255,0.003,2.598,3.665,6.574,3.790,77.683,21.331,3.857,4.199
 1683.409,110.672,776.367,66.473,-102.063,19.443,10.281,0.007,2.595,3.623,6.728,3.738,79.202,22.404,4.034,4.368
 1683.909,110.786,776.367,72.250,-102.173,20.304,10.305,0.012,2.599,3.623,6.465,3.814,79.239,22.430,4.174,4.440
 1684.409,110.939,775.977,73.160,-103.215,21.084,10.318,0.015,2.608,3.570,5.948,4.014,78.144,21.657,4.233,4.410
 1684.909,110.824,771.484,68.958,-103.195,20.875,10.298,0.013,2.609,3.456,5.933,4.244,76.919,20.791,4.198,4.307
 1685.409,110.903,775.732,65.835,-104.308,19.800,10.272,0.008,2.598,3.346,6.546,4.336,75.642,19.888,4.123,4.203
 1685.909,110.784,774.658,68.837,-103.823,18.392,10.289,0.006,2.580,3.265,7.585,4.145,75.071,19.485,4.057,4.142
 1686.409,110.847,776.367,78.632,-103.121,17.280,10.341,0.009,2.567,3.112,8.391,3.799,75.725,19.947,4.015,4.116
 1686.909,110.842,772.949,89.360,-103.024,16.796,10.395,0.013,2.559,2.929,8.827,3.592,77.146,20.951,3.980,4.097
 1687.409,110.855,780.176,97.879,-102.062,16.679,10.428,0.015,2.560,2.824,8.765,3.625,78.194,21.692,3.904,4.019
 1687.909,110.792,776.367,104.319,-101.245,16.693,10.454,0.016,2.564,2.806,8.558,3.742,78.998,22.260,3.795,3.876
 1688.409,110.832,772.803,106.684,-101.026,16.982,10.499,0.018,2.569,2.834,8.270,3.728,81.275,23.869,3.631,3.684
 1688.909,110.905,768.652,107.608,-99.953,18.058,10.551,0.020,2.566,2.860,8.449,3.529,84.588,26.210,3.449,3.470
 1689.409,110.792,768.164,107.282,-100.577,19.776,10.608,0.030,2.559,2.857,8.857,3.242,86.680,27.689,3.241,3.279
 1689.909,110.854,779.688,103.375,-100.208,21.957,10.697,0.045,2.564,2.869,8.540,2.971,86.385,27.481,3.040,3.118
 1690.409,110.771,771.484,94.701,-100.890,24.694,10.826,0.052,2.566,2.982,8.403,2.737,84.598,26.218,2.889,3.048
 1690.909,110.727,780.176,82.308,-100.715,27.164,10.782,0.062,2.579,3.084,7.639,2.531,83.964,25.770,2.816,3.054
 1691.409,110.835,776.367,73.223,-101.012,29.216,10.722,0.073,2.577,3.121,7.756,2.409,84.491,26.142,2.865,3.152
 1691.909,110.900,776.367,68.967,-102.094,30.984,10.761,0.085,2.572,3.091,8.085,2.550,83.534,25.466,3.016,3.308
 1692.409,110.944,771.484,64.441,-106.381,31.544,10.630,0.079,2.582,3.189,7.482,3.507,79.358,22.514,3.239,3.471
 1692.909,110.858,776.318,56.305,-108.770,29.929,10.466,0.051,2.604,3.561,6.212,5.099,72.897,17.948,3.498,3.651
 1693.409,110.817,771.387,49.306,-109.869,24.839,10.406,0.025,2.639,3.959,4.147,6.410,66.934,13.734,3.782,3.863
 1693.909,111.021,781.104,46.157,-108.228,18.587,10.428,0.012,2.654,4.213,3.281,6.710,64.287,11.863,4.104,4.108
 1694.409,110.902,779.102,52.290,-108.477,14.438,10.503,0.030,2.626,4.256,4.917,5.693,66.673,13.550,4.380,4.315
 1694.909,110.773,780.469,65.566,-109.409,13.370,10.621,0.072,2.575,4.056,7.875,4.308,72.296,17.523,4.228,4.173
 1695.409,110.932,780.420,77.377,-109.820,15.632,11.016,0.106,2.520,3.776,11.108,3.313,80.821,23.548,3.609,3.660
 1695.909,110.915,771.484,82.968,-110.828,20.131,11.450,0.110,2.477,3.673,13.620,2.727,90.878,30.656,2.844,3.078
 1696.409,110.971,781.006,79.758,-113.563,25.773,11.303,0.088,2.397,3.710,18.287,2.276,102.976,39.206,2.306,2.656
 1696.909,110.861,781.250,74.862,-118.546,32.774,11.081,0.065,2.236,3.555,27.707,1.803,116.182,48.538,1.974,2.413
 1697.409,110.976,781.250,71.871,-124.012,42.583,11.535,0.057,2.090,3.023,36.261,1.429,125.755,55.304,1.814,2.246
 1697.909,110.933,779.004,71.585,-128.148,50.538,12.283,0.045,2.071,2.529,37.359,1.359,127.378,56.451,1.718,2.070
 1698.409,110.949,771.484,72.870,-129.987,50.534,11.735,0.025,2.203,2.401,29.651,1.541,119.202,50.673,1.635,1.858
 1698.909,110.929,771.484,80.515,-129.953,42.521,10.905,0.011,2.364,2.555,20.221,1.713,106.178,41.468,1.560,1.685
 1699.409,110.954,779.297,93.105,-128.474,32.428,10.871,0.008,2.448,2.685,15.342,1.720,95.288,33.773,1.507,1.586
 1699.909,111.004,776.367,99.096,-127.930,28.112,10.870,0.009,2.463,2.700,14.440,1.600,90.414,30.328,1.497,1.559
 1700.409,110.786,776.367,99.213,-129.066,29.261,10.881,0.009,2.457,2.634,14.814,1.463,89.999,30.035,1.518,1.575
 1700.909,110.952,792.090,94.798,-130.562,31.467,10.898,0.008,2.445,2.516,15.500,1.366,91.249,30.918,1.535,1.589
 1701.409,111.055,780.127,93.922,-131.478,32.028,10.919,0.007,2.431,2.432,16.300,1.317,91.981,31.435,1.527,1.591
 1701.909,110.937,776.367,95.734,-129.151,30.851,10.960,0.008,2.422,2.513,16.865,1.310,91.961,31.421,1.484,1.568
 1702.409,110.973,780.957,97.045,-128.003,29.509,11.007,0.012,2.422,2.675,16.833,1.317,91.571,31.146,1.434,1.528
 1702.909,110.976,776.367,97.647,-126.279,29.335,11.062,0.024,2.435,2.766,16.107,1.309,91.222,30.899,1.405,1.497
 1703.409,110.864,781.201,96.433,-125.900,30.284,11.141,0.039,2.446,2.731,15.464,1.286,91.203,30.886,1.395,1.481
 1703.909,110.950,781.152,94.771,-122.700,31.440,11.218,0.052,2.448,2.648,15.337,1.265,91.218,30.896,1.407,1.493
 1704.409,111.028,776.563,91.096,-121.334,31.712,11.266,0.053,2.440,2.610,15.800,1.280,91.240,30.912,1.432,1.524
 1704.909,111.040,781.250,89.721,-120.010,31.257,11.299,0.040,2.432,2.620,16.256,1.366,91.374,31.006,1.470,1.572
 1705.409,111.028,776.367,92.088,-120.674,30.552,11.330,0.027,2.440,2.672,15.788,1.476,91.614,31.176,1.527,1.636
 1705.909,110.925,782.324,99.092,-118.539,30.130,11.348,0.021,2.462,2.697,14.475,1.589,91.701,31.238,1.605,1.718
 1706.409,110.989,781.250,104.721,-117.869,29.867,11.361,0.022,2.492,2.713,12.766,1.747,91.269,30.932,1.702,1.807
 1706.909,110.926,781.250,104.480,-115.535,28.755,11.395,0.026,2.518,2.812,11.249,1.969,90.486,30.379,1.807,1.891
 1707.409,111.012,781.250,104.325,-114.994,27.133,11.435,0.025,2.529,2.978,10.572,2.172,90.289,30.240,1.898,1.956
 1707.909,110.927,770.850,105.429,-113.048,26.331,11.478,0.023,2.529,3.124,10.562,2.263,91.607,31.171,1.960,2.002
 1708.409,110.957,766.602,109.931,-111.078,27.902,11.496,0.026,2.529,3.200,10.598,2.214,94.216,33.015,1.992,2.034
 1708.909,111.038,762.939,114.691,-109.679,31.537,11.498,0.041,2.528,3.224,10.657,2.085,97.119,35.066,1.996,2.052
 1709.409,111.034,772.266,120.126,-109.414,35.697,11.581,0.066,2.520,3.271,11.125,1.947,100.029,37.123,1.989,2.057
 1709.909,111.024,761.719,123.881,-109.705,39.588,11.928,0.092,2.500,3.297,12.289,1.840,102.871,39.132,1.969,2.057
 1710.409,110.971,771.484,123.059,-110.371,42.969,12.328,0.101,2.459,3.320,14.661,1.809,105.461,40.962,1.952,2.052
 1710.909,110.919,775.635,118.756,-111.622,45.985,12.329,0.085,2.407,3.375,17.704,1.842,107.236,42.217,1.951,2.049
 1711.409,111.145,776.367,114.613,-113.006,47.530,11.912,0.055,2.386,3.356,18.943,1.920,106.673,41.818,1.971,2.024
 1711.909,111.142,780.762,114.338,-113.643,46.603,11.597,0.028,2.407,3.259,17.717,2.025,103.746,39.750,1.988,1.957
 1712.409,111.009,771.484,115.679,-115.440,43.723,11.409,0.016,2.451,3.050,15.154,2.140,98.681,36.170,1.938,1.813
 1712.909,111.032,776.123,113.036,-117.211,40.114,11.215,0.013,2.486,2.865,13.097,2.242,92.621,31.888,1.783,1.605
 1713.409,111.003,783.545,103.218,-121.956,36.203,11.179,0.014,2.488,2.816,12.965,2.160,87.116,27.997,1.556,1.394
 1713.909,111.026,786.133,91.190,-127.161,31.955,11.178,0.021,2.476,2.743,13.666,1.831,83.139,25.187,1.328,1.219
 1714.409,110.955,786.133,81.438,-129.376,27.690,11.202,0.030,2.451,2.559,15.144,1.330,82.193,24.518,1.152,1.097
 1714.909,110.962,790.625,75.475,-131.522,24.840,11.242,0.036,2.416,2.358,17.193,0.876,83.532,25.464,1.023,1.009
 1715.409,111.140,781.250,70.542,-131.135,24.584,11.286,0.035,2.382,2.250,19.187,0.665,86.017,27.221,0.930,0.933
 1715.909,111.151,785.693,67.529,-132.323,25.960,11.332,0.031,2.363,2.243,20.280,0.646,88.251,28.800,0.858,0.866
 1716.409,111.085,784.229,67.640,-132.328,28.249,11.375,0.029,2.361,2.294,20.406,0.701,89.781,29.881,0.803,0.810
 1716.909,111.140,785.449,70.340,-131.293,31.126,11.407,0.026,2.363,2.332,20.306,0.754,90.791,30.594,0.764,0.772
 1717.409,111.122,787.695,75.652,-131.955,33.280,11.418,0.024,2.365,2.369,20.196,0.764,91.322,30.970,0.750,0.759
 1717.909,111.170,791.016,80.886,-132.163,33.561,11.419,0.022,2.367,2.377,20.064,0.742,91.166,30.860,0.754,0.768
 1718.409,111.079,791.016,84.760,-131.658,32.109,11.421,0.021,2.370,2.360,19.912,0.731,90.483,30.377,0.778,0.799
 1718.909,111.160,786.133,85.333,-129.778,30.391,11.436,0.021,2.369,2.346,19.948,0.765,89.957,30.005,0.815,0.845
 1719.409,111.162,786.133,86.334,-128.589,29.883,11.464,0.024,2.374,2.336,19.666,0.885,90.119,30.119,0.862,0.901
 1719.909,111.152,779.883,89.793,-128.803,30.060,11.493,0.026,2.382,2.364,19.188,1.126,90.961,30.714,0.920,0.965
 1720.409,111.035,788.232,90.955,-129.994,30.027,11.515,0.025,2.393,2.368,18.535,1.446,91.933,31.402,0.992,1.035
 1720.909,111.229,789.404,90.042,-128.559,30.055,11.538,0.023,2.408,2.381,17.665,1.738,92.445,31.763,1.082,1.118
 1721.409,111.223,794.434,90.329,-127.904,30.833,11.568,0.021,2.422,2.440,16.868,1.920,92.478,31.787,1.187,1.217
 1721.909,111.109,776.367,94.835,-127.609,32.544,11.596,0.021,2.431,2.507,16.338,1.986,92.419,31.745,1.303,1.331
 1722.409,111.125,776.367,100.126,-128.365,33.698,11.621,0.022,2.429,2.599,16.454,1.994,92.567,31.849,1.413,1.453
 1722.909,111.177,783.350,101.222,-128.714,33.397,11.645,0.021,2.424,2.613,16.711,1.959,92.832,32.036,1.507,1.569
 1723.409,111.210,781.494,99.016,-128.693,32.454,11.665,0.021,2.430,2.600,16.383,1.882,92.843,32.045,1.585,1.675
 1723.909,111.121,781.250,99.084,-128.133,31.889,11.678,0.026,2.453,2.562,15.052,1.789,92.289,31.653,1.653,1.768
 1724.409,111.334,781.250,99.682,-125.631,32.183,11.689,0.030,2.478,2.458,13.590,1.750,91.506,31.099,1.725,1.848
 1724.909,111.257,781.250,102.207,-120.088,32.883,11.694,0.029,2.491,2.508,12.826,1.813,91.215,30.894,1.806,1.922
 1725.409,111.103,772.217,110.823,-116.494,33.553,11.693,0.026,2.501,2.678,12.237,1.932,91.727,31.256,1.892,1.990
 1725.909,111.092,786.133,121.588,-113.903,33.976,11.693,0.025,2.511,2.873,11.620,2.047,93.005,32.159,1.978,2.058
 1726.409,111.247,786.572,131.366,-113.048,34.681,11.692,0.027,2.522,2.999,11.000,2.112,94.436,33.171,2.054,2.130
 1726.909,111.125,787.988,131.184,-110.654,35.843,11.661,0.032,2.533,2.990,10.347,2.121,95.567,33.970,2.116,2.195
 1727.409,111.185,791.016,124.395,-108.503,37.133,11.724,0.035,2.541,2.999,9.885,2.106,96.376,34.541,2.159,2.252
 1727.909,111.207,784.473,119.087,-105.828,38.789,11.965,0.038,2.553,3.068,9.152,2.081,97.043,35.013,2.181,2.284
 1728.409,111.208,784.277,116.542,-104.770,39.941,11.942,0.037,2.558,3.135,8.902,2.056,97.671,35.457,2.184,2.295
 1728.909,111.266,776.367,118.540,-102.540,39.909,11.735,0.031,2.551,3.147,9.303,2.032,98.231,35.852,2.174,2.288
 1729.409,111.114,787.305,121.481,-101.679,38.552,11.656,0.027,2.540,3.122,9.937,2.002,98.671,36.163,2.152,2.264
 1729.909,111.273,772.461,120.044,-100.871,37.028,11.574,0.025,2.532,3.119,10.425,1.967,99.015,36.407,2.128,2.241
 1730.409,111.177,786.133,115.711,-101.609,37.082,11.438,0.025,2.529,3.118,10.567,1.940,99.308,36.614,2.104,2.219
 1730.909,111.190,774.268,111.595,-102.030,38.857,11.404,0.022,2.526,3.113,10.754,1.931,99.532,36.772,2.082,2.204
 1731.409,111.342,781.250,107.777,-102.207,40.790,11.652,0.016,2.518,3.062,11.210,1.932,99.713,36.900,2.070,2.195
 1731.909,111.179,781.250,108.231,-101.682,41.387,11.718,0.019,2.512,3.021,11.578,1.932,99.896,37.029,2.068,2.187
 1732.409,111.349,787.305,108.799,-101.681,41.206,11.989,0.039,2.507,3.034,11.862,1.930,100.103,37.175,2.077,2.187
 1732.909,111.411,790.137,108.105,-102.235,40.494,12.266,0.067,2.496,3.028,12.539,1.935,100.341,37.344,2.086,2.192
 1733.409,111.302,788.916,111.556,-101.360,38.882,11.899,0.087,2.487,2.978,13.038,1.952,100.446,37.417,2.085,2.200
 1733.909,111.244,786.133,117.072,-101.636,36.902,11.698,0.088,2.475,2.940,13.756,1.969,100.424,37.402,2.070,2.205
 1734.409,111.302,781.250,121.887,-100.856,35.519,11.940,0.081,2.472,3.010,13.941,1.965,100.396,37.383,2.044,2.209
 1734.909,111.216,781.250,123.293,-100.909,34.828,12.172,0.089,2.480,3.123,13.428,1.934,100.604,37.529,2.018,2.212
 1735.409,111.401,783.545,122.680,-99.789,34.709,12.160,0.115,2.482,3.103,13.311,1.869,101.461,38.135,2.003,2.218
 1735.909,111.157,781.250,122.098,-98.544,35.634,12.202,0.139,2.473,3.006,13.846,1.798,102.526,38.887,1.991,2.220
 1736.409,111.327,786.816,122.655,-98.539,38.748,12.545,0.141,2.443,2.942,15.599,1.756,103.347,39.468,1.976,2.205
 1736.909,111.472,776.367,124.255,-98.550,42.656,12.751,0.131,2.421,2.893,16.912,1.747,103.592,39.641,1.952,2.170
 1737.409,111.303,776.367,125.408,-97.426,43.980,12.689,0.112,2.424,2.887,16.727,1.768,103.085,39.283,1.917,2.118
 1737.909,111.387,790.283,127.200,-95.906,42.616,12.622,0.089,2.444,2.871,15.540,1.794,102.514,38.879,1.890,2.072
 1738.409,111.395,789.404,128.472,-95.418,40.173,12.476,0.068,2.469,2.887,14.084,1.805,102.130,38.608,1.877,2.042
 1738.909,111.425,789.160,129.703,-94.757,38.552,12.541,0.056,2.486,2.927,13.123,1.801,101.998,38.515,1.880,2.028
 1739.409,111.414,791.797,131.206,-94.834,38.673,12.750,0.058,2.492,2.936,12.745,1.785,102.024,38.533,1.888,2.032
 1739.909,111.461,795.898,129.978,-95.277,40.670,12.823,0.067,2.490,2.942,12.877,1.768,101.966,38.492,1.883,2.034
 1740.409,111.382,792.139,126.037,-95.598,44.326,12.777,0.077,2.483,2.888,13.299,1.751,101.873,38.426,1.862,2.034
 1740.909,111.378,791.016,121.703,-96.436,47.901,12.719,0.081,2.469,2.803,14.111,1.722,101.815,38.385,1.836,2.037
 1741.409,111.380,791.016,118.262,-96.684,50.976,12.629,0.079,2.439,2.706,15.867,1.676,102.489,38.861,1.826,2.064
 1741.909,111.438,791.016,114.932,-99.404,52.943,12.435,0.073,2.388,2.575,18.827,1.625,103.334,39.459,1.858,2.147
 1742.409,111.311,791.016,106.794,-103.718,52.904,12.282,0.070,2.347,2.597,21.210,1.613,102.222,38.673,1.947,2.292
 1742.909,111.372,787.207,87.728,-109.437,49.667,11.970,0.069,2.354,2.951,20.823,1.727,96.434,34.582,2.114,2.505
 1743.409,111.387,776.807,62.475,-113.275,42.977,11.327,0.062,2.413,3.464,17.393,2.095,86.071,27.258,2.349,2.735
 1743.909,111.427,786.133,39.782,-115.157,34.601,10.949,0.041,2.495,4.031,12.576,2.955,73.952,18.694,2.624,2.904
 1744.409,111.574,781.445,25.551,-114.971,26.052,10.911,0.019,2.567,4.448,8.387,4.113,63.782,11.507,2.877,2.969
 1744.909,111.456,781.445,21.505,-114.931,18.476,10.903,0.006,2.613,4.656,5.674,4.852,58.355,7.671,2.990,2.925
 1745.409,111.453,781.250,22.153,-114.887,13.155,10.904,0.001,2.627,4.736,4.876,4.724,56.942,6.673,2.977,2.845
 1745.909,111.526,781.250,26.583,-114.748,10.796,10.922,0.003,2.609,4.567,5.923,3.637,59.023,8.143,2.824,2.755
 1746.409,111.443,790.283,32.723,-114.829,10.864,10.964,0.013,2.578,4.286,7.739,2.410,63.277,11.150,2.617,2.635
 1746.909,111.425,776.367,44.863,-114.682,14.086,11.033,0.035,2.551,3.959,9.293,1.657,69.371,15.457,2.371,2.459
 1747.409,111.583,786.621,58.439,-114.042,18.623,11.214,0.054,2.533,3.612,10.325,1.377,75.403,19.719,2.128,2.249
 1747.909,111.473,791.016,65.131,-113.047,22.467,11.589,0.051,2.523,3.447,10.954,1.383,79.217,22.415,1.941,2.077
 1748.409,111.468,791.016,60.556,-113.385,24.306,11.504,0.035,2.528,3.445,10.651,1.425,79.021,22.276,1.826,1.976
 1748.909,111.516,791.016,46.223,-115.215,24.579,11.137,0.020,2.545,3.527,9.653,1.454,74.945,19.395,1.811,1.967
 1749.409,111.458,786.133,32.839,-116.502,25.032,11.007,0.014,2.571,3.631,8.149,1.533,69.519,15.561,1.875,2.023
 1749.909,111.389,789.648,26.123,-117.140,25.533,10.957,0.010,2.598,3.691,6.561,1.834,64.737,12.181,1.996,2.100
 1750.409,111.525,781.250,26.090,-116.730,24.581,10.954,0.005,2.631,3.844,4.626,2.346,61.626,9.983,2.123,2.173
 1750.909,111.632,781.250,28.415,-117.035,21.776,10.955,0.004,2.664,4.012,2.685,2.782,60.275,9.028,2.218,2.231
 1751.409,111.558,794.482,31.000,-117.234,18.525,10.965,0.010,2.678,4.002,1.843,2.830,60.822,9.415,2.282,2.307
 1751.909,111.593,787.012,34.120,-116.574,16.710,10.999,0.019,2.664,3.838,2.671,2.460,64.204,11.805,2.342,2.421
 1752.409,111.548,786.133,38.837,-114.209,17.319,11.060,0.025,2.631,3.607,4.619,2.014,71.547,16.994,2.404,2.538
 1752.909,111.436,790.381,48.586,-111.331,19.722,11.137,0.030,2.608,3.419,5.945,1.808,81.455,23.996,2.453,2.628
 1753.409,111.620,787.207,59.036,-109.013,22.626,11.216,0.035,2.609,3.292,5.897,1.908,92.128,31.540,2.465,2.645
 1753.909,111.662,781.250,67.330,-105.953,24.414,11.280,0.038,2.618,3.154,5.376,2.136,101.472,38.143,2.450,2.631
 1754.409,111.514,795.898,72.580,-104.690,24.614,11.344,0.038,2.609,3.092,5.893,2.332,107.824,42.632,2.456,2.624
 1754.909,111.576,791.211,74.028,-102.323,24.009,11.423,0.049,2.593,3.202,6.822,2.445,110.426,44.470,2.506,2.661
 1755.409,111.561,798.193,72.456,-101.384,23.403,11.522,0.078,2.579,3.273,7.651,2.459,109.476,43.799,2.609,2.743
 1755.909,111.550,786.182,70.604,-100.018,23.572,11.659,0.106,2.553,3.271,9.153,2.415,108.824,43.338,2.740,2.855
 1756.409,111.717,791.016,72.211,-100.863,24.680,11.929,0.124,2.531,3.121,10.461,2.361,110.755,44.703,2.833,2.950
 1756.909,111.593,786.426,75.178,-101.655,25.994,12.001,0.114,2.516,3.072,11.371,2.387,115.078,47.759,2.874,2.986
 1757.409,111.612,788.184,74.934,-101.916,26.890,11.865,0.081,2.526,3.320,10.784,2.515,119.326,50.760,2.853,2.955
 1757.909,111.700,785.596,72.718,-101.453,26.633,11.599,0.047,2.556,3.466,8.978,2.638,121.434,52.250,2.794,2.852
 1758.409,111.680,784.326,72.664,-101.769,25.697,11.365,0.021,2.580,3.488,7.613,2.640,119.844,51.127,2.720,2.744
 1758.909,111.610,781.982,75.104,-101.340,25.378,11.300,0.011,2.589,3.422,7.105,2.508,115.139,47.801,2.630,2.650
 1759.409,111.578,786.133,77.368,-102.867,25.574,11.253,0.008,2.585,3.433,7.306,2.315,108.836,43.347,2.531,2.585
 1759.909,111.689,795.898,78.606,-101.600,26.148,11.285,0.006,2.580,3.548,7.618,2.147,103.105,39.297,2.456,2.570
 1760.409,111.574,795.898,81.775,-101.108,26.857,11.331,0.009,2.584,3.575,7.347,2.025,99.683,36.878,2.423,2.590
 1760.909,111.540,793.457,85.962,-100.008,27.591,11.259,0.016,2.584,3.519,7.354,1.961,98.482,36.029,2.460,2.671
 1761.409,111.734,782.373,86.918,-100.355,29.190,11.129,0.022,2.572,3.401,8.088,2.048,96.882,34.899,2.562,2.794
 1761.909,111.675,781.250,79.037,-101.142,30.570,11.080,0.025,2.564,3.350,8.555,2.558,91.259,30.925,2.701,2.931
 1762.409,111.696,781.250,65.264,-100.994,29.841,11.063,0.024,2.576,3.414,7.811,3.479,81.805,24.244,2.872,3.086
 1762.909,111.714,789.795,55.729,-102.293,25.905,11.059,0.025,2.607,3.596,6.028,4.299,72.920,17.965,3.084,3.286
 1763.409,111.701,805.664,51.776,-103.123,20.079,11.082,0.026,2.621,3.820,5.184,4.535,68.574,14.893,3.399,3.593
 1763.909,111.794,785.059,52.374,-105.190,16.044,11.121,0.035,2.600,3.937,6.448,4.098,69.765,15.735,3.873,4.032
 1764.409,111.653,795.508,56.115,-106.115,15.583,11.216,0.052,2.570,3.901,8.216,3.589,72.996,18.018,4.325,4.382
 1764.909,111.708,791.016,58.085,-106.373,17.937,11.360,0.068,2.570,3.898,8.199,3.648,74.322,18.956,4.459,4.388
 1765.409,111.845,781.543,58.606,-105.674,19.738,11.317,0.080,2.603,3.941,6.262,4.008,72.695,17.806,4.059,4.030
 1765.909,111.626,785.938,56.162,-104.677,18.920,11.144,0.081,2.618,4.104,5.406,4.072,70.379,16.169,3.495,3.598
 1766.409,111.927,795.850,55.517,-103.261,17.327,11.036,0.089,2.575,4.200,7.885,3.572,71.537,16.987,3.068,3.363
 1766.909,111.731,793.652,60.696,-101.611,18.012,11.160,0.109,2.450,3.816,15.177,2.660,78.413,21.847,2.883,3.317
 1767.409,111.781,795.898,66.851,-101.776,22.312,11.906,0.122,2.313,3.250,23.233,1.951,87.188,28.048,2.883,3.443
 1767.909,111.843,793.018,69.861,-103.299,30.161,12.735,0.116,2.253,2.693,26.730,1.841,92.110,31.527,2.980,3.559
 1768.409,111.598,789.941,68.669,-105.111,36.871,12.936,0.092,2.294,2.569,24.315,2.422,89.780,29.880,3.095,3.553
 1768.909,111.794,781.250,65.230,-106.148,37.511,12.344,0.060,2.414,2.979,17.339,3.725,80.998,23.674,3.214,3.504
 1769.409,111.916,786.914,57.664,-106.265,31.753,11.610,0.035,2.536,3.551,10.200,5.330,70.906,16.541,3.338,3.447
 1769.909,111.750,794.336,50.184,-106.590,22.603,11.419,0.018,2.613,4.092,5.646,6.461,63.912,11.598,3.565,3.560
 1770.409,111.794,794.873,45.598,-106.283,15.442,11.377,0.010,2.639,4.400,4.163,6.454,61.552,9.931,3.867,3.797
 1770.909,111.795,791.016,48.381,-106.779,12.469,11.291,0.016,2.619,4.317,5.342,5.361,63.398,11.236,4.129,4.053
 1771.409,111.749,782.471,59.304,-106.403,14.027,11.520,0.049,2.570,3.996,8.210,3.947,68.605,14.915,4.236,4.257
 1771.909,111.639,786.133,72.467,-107.087,20.383,12.072,0.103,2.514,3.483,11.469,2.880,75.753,19.967,4.013,4.191
 1772.409,111.873,787.598,87.210,-107.940,28.628,12.344,0.131,2.475,3.023,13.759,2.425,82.556,24.775,3.642,3.910
 1772.909,111.891,782.910,97.766,-109.642,35.097,12.410,0.113,2.471,2.792,13.990,2.328,87.319,28.141,3.213,3.505
 1773.409,111.849,784.668,103.480,-110.421,37.136,12.187,0.061,2.494,2.770,12.659,2.350,89.071,29.378,2.892,3.118
 1773.909,111.765,782.520,108.751,-109.622,36.070,12.016,0.015,2.512,2.873,11.551,2.367,89.571,29.732,2.696,2.870
 1774.409,111.874,795.898,108.949,-107.985,34.787,12.051,-0.000,2.512,2.911,11.568,2.354,89.964,30.010,2.640,2.743
 1774.909,111.741,804.883,106.156,-106.246,34.391,12.060,-0.001,2.500,2.887,12.309,2.363,90.050,30.071,2.662,2.700
 1775.409,111.768,793.213,106.259,-106.972,33.915,11.905,0.003,2.493,2.851,12.674,2.405,89.123,29.415,2.674,2.667
 1775.909,111.910,791.162,112.356,-108.347,32.564,11.661,0.009,2.505,2.756,11.988,2.418,87.332,28.150,2.610,2.606
 1776.409,111.821,795.801,123.498,-109.752,30.292,11.585,0.015,2.512,2.643,11.576,2.353,85.782,27.054,2.431,2.511
 1776.909,111.821,810.352,134.101,-110.560,28.482,11.737,0.021,2.487,2.619,13.058,2.206,85.847,27.100,2.240,2.409
 1777.409,111.730,800.781,137.784,-109.677,28.698,11.645,0.045,2.397,2.641,18.309,1.959,89.733,29.846,2.074,2.332
 1777.909,111.888,795.898,136.351,-108.809,30.382,11.450,0.088,2.280,2.644,25.151,1.692,96.643,34.730,1.954,2.253
 1778.409,111.905,795.898,131.429,-109.289,33.968,12.154,0.135,2.210,2.602,29.247,1.480,104.385,40.201,1.862,2.178
 1778.909,111.922,796.973,126.451,-110.444,39.225,12.728,0.167,2.220,2.611,28.626,1.378,109.245,43.636,1.764,2.049
 1779.409,111.931,802.539,123.851,-111.299,43.982,12.573,0.169,2.285,2.733,24.852,1.399,109.083,43.521,1.662,1.906
 1779.909,111.947,815.430,123.862,-112.375,46.329,12.541,0.153,2.331,2.838,22.187,1.439,106.845,41.940,1.571,1.784
 1780.409,111.977,801.953,121.953,-111.963,46.348,12.664,0.130,2.336,2.839,21.873,1.456,105.016,40.648,1.514,1.714
 1780.909,111.922,796.924,116.965,-112.389,45.044,12.746,0.107,2.330,2.825,22.212,1.448,104.401,40.213,1.507,1.718
 1781.409,111.924,800.781,113.953,-111.216,43.959,12.665,0.089,2.331,2.857,22.151,1.425,104.991,40.630,1.557,1.788
 1781.909,111.949,797.168,112.215,-111.437,43.892,12.555,0.079,2.325,2.904,22.531,1.429,105.565,41.035,1.658,1.929
 1782.409,111.817,796.973,107.993,-110.774,44.724,12.679,0.075,2.331,2.947,22.178,1.568,104.631,40.375,1.811,2.121
 1782.909,111.848,795.898,97.622,-108.597,45.531,12.670,0.067,2.382,3.139,19.196,1.953,100.412,37.394,2.001,2.329
 1783.409,112.052,804.004,85.390,-106.210,43.862,12.042,0.052,2.482,3.424,13.344,2.584,92.079,31.504,2.218,2.498
 1783.909,111.959,802.246,73.990,-105.120,39.064,11.529,0.033,2.597,3.719,6.585,3.361,82.130,24.473,2.444,2.624
 1784.409,111.931,795.898,65.364,-106.072,32.867,11.503,0.020,2.680,3.947,1.734,3.934,74.079,18.783,2.654,2.720
 1784.909,111.893,798.828,60.012,-107.237,26.886,11.534,0.023,2.708,4.027,0.146,3.916,70.817,16.478,2.803,2.817
 1785.409,111.913,809.521,61.228,-106.760,22.618,11.599,0.035,2.689,3.974,1.229,3.383,72.510,17.675,2.873,2.908
 1785.909,111.928,808.350,71.460,-105.641,21.780,11.714,0.051,2.637,3.681,4.256,2.645,78.439,21.865,2.831,2.950
 1786.409,111.778,800.928,84.639,-104.866,24.798,11.842,0.065,2.584,3.333,7.366,2.113,86.052,27.245,2.731,2.942
 1786.909,111.965,805.664,96.100,-103.726,30.968,11.892,0.076,2.556,3.129,9.000,1.942,92.458,31.772,2.613,2.882
 1787.409,111.966,800.879,105.322,-103.406,36.351,11.847,0.076,2.541,3.059,9.906,1.951,96.341,34.517,2.524,2.783
 1787.909,111.865,802.979,113.000,-101.335,39.304,11.731,0.063,2.531,3.007,10.489,2.144,96.458,34.599,2.482,2.682
 1788.409,111.843,801.465,111.039,-101.306,40.437,11.663,0.046,2.532,3.035,10.405,2.545,93.168,32.275,2.470,2.582
 1788.909,112.058,807.666,99.582,-101.983,39.627,11.667,0.031,2.543,3.250,9.769,2.972,87.519,28.282,2.483,2.530
 1789.409,111.836,805.078,87.505,-104.015,36.495,11.678,0.027,2.563,3.388,8.604,3.134,82.494,24.731,2.515,2.537
 1789.909,111.937,800.781,85.157,-102.957,31.141,11.719,0.033,2.575,3.309,7.883,2.935,81.309,23.894,2.586,2.634
 1790.409,111.914,799.951,94.822,-102.366,27.087,11.771,0.037,2.570,3.082,8.193,2.598,83.877,25.708,2.688,2.796
 1790.909,112.032,802.637,105.522,-103.355,26.830,11.758,0.037,2.560,2.918,8.778,2.445,87.620,28.353,2.813,2.965
 1791.409,111.887,805.664,110.335,-105.756,28.947,11.676,0.030,2.551,2.987,9.297,2.565,89.430,29.632,2.908,3.069
 1791.909,111.955,802.051,110.241,-105.952,30.880,11.590,0.021,2.553,3.128,9.199,2.880,88.195,28.759,2.930,3.046
 1792.409,112.062,800.781,109.618,-106.126,30.855,11.555,0.015,2.564,3.180,8.525,3.198,85.122,26.588,2.876,2.936
 1792.909,111.980,793.066,108.154,-106.208,29.106,11.551,0.014,2.577,3.138,7.753,3.321,82.166,24.499,2.765,2.783
 1793.409,112.091,802.295,104.514,-108.068,26.592,11.535,0.021,2.578,3.053,7.747,3.100,81.612,24.107,2.641,2.644
 1793.909,112.072,805.664,100.380,-107.909,24.719,11.513,0.038,2.562,3.015,8.642,2.634,84.012,25.804,2.514,2.538
 1794.409,111.924,800.781,99.041,-106.817,25.941,11.625,0.060,2.543,2.976,9.744,2.178,88.421,28.919,2.377,2.447
 1794.909,112.113,800.781,102.366,-104.558,30.832,11.906,0.067,2.521,2.858,11.059,1.887,92.800,32.014,2.244,2.364
 1795.409,111.912,808.789,110.664,-104.337,37.139,12.166,0.060,2.516,2.805,11.362,1.792,95.469,33.900,2.116,2.265
 1795.909,111.944,797.607,118.480,-102.361,42.012,12.256,0.047,2.517,2.856,11.280,1.799,96.664,34.745,2.017,2.171
 1796.409,112.036,815.430,122.665,-101.668,44.116,12.315,0.042,2.526,2.942,10.764,1.840,97.109,35.060,1.961,2.106
 1796.909,112.105,801.074,125.985,-100.578,43.847,12.453,0.046,2.544,2.963,9.710,1.899,97.234,35.148,1.945,2.074
 1797.409,111.990,805.664,127.441,-101.646,42.178,12.338,0.044,2.553,2.934,9.183,1.969,96.988,34.974,1.973,2.094
 1797.909,112.023,810.400,125.600,-103.056,40.488,12.105,0.039,2.556,2.949,8.979,2.036,96.303,34.490,2.026,2.141
 1798.409,112.036,800.293,122.375,-105.726,39.337,12.036,0.032,2.548,3.053,9.495,2.098,95.365,33.827,2.091,2.211
 1798.909,112.061,806.006,119.094,-106.285,38.328,11.992,0.029,2.539,3.155,10.008,2.157,94.609,33.292,2.159,2.292
 1799.409,112.041,810.547,116.534,-107.545,36.556,11.935,0.030,2.534,3.189,10.265,2.201,94.191,32.997,2.226,2.373
 1799.909,112.139,794.727,115.589,-106.642,34.814,11.878,0.029,2.533,3.140,10.377,2.235,93.887,32.783,2.298,2.454
 1800.409,112.085,786.133,113.781,-105.969,34.944,11.851,0.025,2.531,3.063,10.490,2.287,93.211,32.305,2.371,2.526
 1800.909,111.982,789.453,109.497,-107.510,36.196,11.847,0.018,2.529,3.048,10.613,2.381,91.844,31.338,2.439,2.580
 1801.409,112.126,805.664,103.237,-111.144,36.576,11.804,0.016,2.532,3.021,10.387,2.510,89.913,29.974,2.490,2.613
 1801.909,111.939,805.664,96.349,-115.155,34.668,11.746,0.015,2.533,2.946,10.363,2.609,88.263,28.808,2.528,2.631
 1802.409,112.140,805.664,92.527,-118.940,31.149,11.727,0.013,2.517,2.868,11.268,2.615,87.768,28.458,2.551,2.648
 1802.909,112.173,806.592,96.262,-119.407,28.486,11.727,0.012,2.495,2.837,12.573,2.542,88.548,29.009,2.570,2.668
 1803.409,112.115,795.898,104.370,-120.695,28.379,11.724,0.013,2.483,2.880,13.249,2.451,89.940,29.993,2.581,2.685
 1803.909,112.052,812.402,109.910,-120.462,30.084,11.712,0.015,2.487,2.945,13.037,2.401,90.946,30.704,2.580,2.687
 1804.409,112.140,797.461,113.192,-121.072,31.381,11.685,0.017,2.500,3.035,12.262,2.402,91.002,30.744,2.565,2.672
 1804.909,112.131,794.141,116.048,-121.351,31.383,11.663,0.016,2.505,3.076,11.961,2.424,90.079,30.091,2.541,2.645
 1805.409,112.070,808.398,117.601,-121.037,31.407,11.657,0.014,2.499,3.020,12.332,2.440,88.687,29.107,2.516,2.616
 1805.909,112.054,803.662,116.108,-120.156,32.495,11.656,0.013,2.491,2.887,12.811,2.425,87.450,28.233,2.506,2.600
 1806.409,112.238,800.781,111.470,-119.922,33.177,11.656,0.018,2.491,2.784,12.792,2.392,86.742,27.733,2.503,2.594
 1806.909,112.122,808.301,105.834,-120.939,32.325,11.661,0.025,2.496,2.851,12.534,2.371,86.768,27.751,2.506,2.596
 1807.409,111.889,805.664,101.524,-122.801,30.697,11.676,0.031,2.502,2.970,12.182,2.375,87.219,28.070,2.504,2.599
 1807.909,112.165,805.664,100.433,-122.160,30.332,11.694,0.038,2.517,3.031,11.282,2.401,87.965,28.597,2.494,2.590
 1808.409,112.074,805.811,103.843,-120.413,31.711,11.711,0.043,2.532,3.034,10.380,2.420,88.914,29.268,2.482,2.579
 1808.909,112.112,810.547,113.708,-117.140,34.287,11.743,0.047,2.550,3.042,9.381,2.412,90.211,30.185,2.470,2.564
 1809.409,112.152,805.664,124.688,-115.193,36.449,11.776,0.050,2.564,3.098,8.566,2.383,91.828,31.327,2.459,2.555
 1809.909,112.198,808.594,128.305,-114.842,36.677,11.789,0.050,2.571,3.175,8.132,2.346,93.489,32.501,2.446,2.548
 1810.409,112.167,808.643,126.701,-114.062,36.199,11.791,0.051,2.579,3.247,7.650,2.324,94.781,33.414,2.430,2.538
 1810.909,112.118,802.246,121.993,-112.422,36.089,11.789,0.046,2.575,3.234,7.890,2.327,95.405,33.855,2.410,2.524
 1811.409,112.063,810.547,119.860,-112.390,36.606,11.784,0.038,2.563,3.197,8.590,2.342,95.515,33.933,2.391,2.505
 1811.909,112.141,807.129,117.505,-113.672,36.861,11.777,0.034,2.557,3.179,8.943,2.356,95.358,33.822,2.378,2.488
 1812.409,112.109,809.473,114.539,-114.473,36.201,11.763,0.034,2.559,3.220,8.804,2.362,95.202,33.712,2.371,2.472
 1812.909,112.031,805.664,117.138,-113.410,36.388,11.740,0.032,2.560,3.306,8.771,2.364,95.113,33.649,2.364,2.458
 1813.409,112.149,805.664,121.266,-112.988,38.625,11.685,0.024,2.552,3.302,9.239,2.366,95.076,33.622,2.353,2.444
 1813.909,112.226,805.664,125.420,-112.852,40.966,11.613,0.017,2.546,3.230,9.573,2.362,95.115,33.650,2.339,2.429
 1814.409,112.126,820.313,127.801,-112.488,41.396,11.579,0.012,2.547,3.100,9.555,2.344,95.287,33.772,2.325,2.419
 1814.909,112.289,812.109,126.518,-111.066,40.036,11.576,0.011,2.550,2.968,9.329,2.312,95.541,33.951,2.313,2.411
 1815.409,112.132,812.354,125.413,-110.241,37.644,11.580,0.014,2.554,2.933,9.112,2.282,95.815,34.145,2.303,2.404
 1815.909,112.200,815.430,121.499,-111.230,35.689,11.588,0.018,2.551,2.916,9.316,2.274,96.046,34.308,2.294,2.398
 1816.409,112.266,798.779,116.019,-109.564,34.586,11.598,0.022,2.548,2.964,9.464,2.289,96.276,34.471,2.286,2.391
 1816.909,112.066,828.027,113.311,-108.985,34.581,11.609,0.025,2.546,3.069,9.610,2.310,96.578,34.684,2.279,2.389
 1817.409,112.170,825.586,116.007,-106.776,35.517,11.621,0.024,2.540,3.151,9.919,2.311,97.014,34.992,2.277,2.388
 1817.909,112.255,810.645,118.772,-107.688,36.262,11.625,0.023,2.538,3.232,10.075,2.292,97.560,35.378,2.281,2.392
 1818.409,112.149,815.430,116.462,-108.129,36.225,11.609,0.022,2.535,3.234,10.211,2.271,98.037,35.716,2.287,2.393
 1818.909,112.233,810.254,113.339,-109.112,35.682,11.598,0.022,2.540,3.224,9.956,2.265,98.300,35.901,2.281,2.381
 1819.409,112.167,800.781,114.747,-107.949,35.300,11.598,0.027,2.542,3.218,9.816,2.266,98.218,35.843,2.258,2.358
 1819.909,112.133,801.563,119.465,-106.770,34.843,11.597,0.040,2.542,3.220,9.804,2.249,98.074,35.741,2.216,2.326
 1820.409,112.087,813.525,123.636,-106.117,34.735,11.617,0.063,2.539,3.251,10.002,2.192,98.334,35.925,2.167,2.303
 1820.909,112.235,810.547,123.358,-105.631,35.999,12.009,0.087,2.524,3.294,10.894,2.104,99.010,36.403,2.135,2.304
 1821.409,112.272,813.721,122.671,-105.417,38.530,12.549,0.110,2.503,3.334,12.122,2.010,99.970,37.081,2.126,2.325
 1821.909,112.239,811.426,126.774,-104.449,41.182,12.493,0.128,2.462,3.253,14.500,1.930,101.012,37.818,2.147,2.359
 1822.409,112.183,815.430,131.206,-103.121,43.365,12.428,0.140,2.408,3.098,17.653,1.910,101.568,38.210,2.175,2.372
 1822.909,112.218,806.787,129.069,-103.213,44.420,12.755,0.144,2.389,2.996,18.792,2.030,100.409,37.391,2.184,2.340
 1823.409,112.211,814.209,113.475,-105.140,43.276,12.860,0.122,2.420,3.189,16.938,2.257,96.936,34.937,2.162,2.278
 1823.909,112.304,810.547,93.360,-106.723,38.991,12.170,0.085,2.491,3.558,12.827,2.397,92.413,31.741,2.115,2.214
 1824.409,112.258,810.547,84.530,-107.770,32.745,11.444,0.046,2.549,3.784,9.440,2.346,89.223,29.487,2.087,2.197
 1824.909,112.218,808.984,89.417,-107.681,28.292,11.361,0.019,2.554,3.694,9.096,2.133,89.231,29.492,2.100,2.247
 1825.409,112.270,805.664,98.341,-106.886,27.724,11.357,0.007,2.535,3.412,10.232,1.943,91.375,31.007,2.163,2.345
 1825.909,112.228,807.471,98.582,-105.963,30.642,11.349,0.001,2.520,3.328,11.107,1.961,93.037,32.182,2.250,2.446
 1826.409,112.304,819.238,90.405,-103.848,33.505,11.349,0.001,2.526,3.400,10.788,2.256,92.003,31.451,2.332,2.500
 1826.909,112.320,816.211,80.549,-103.710,33.277,11.323,0.009,2.556,3.597,8.999,2.732,87.956,28.591,2.368,2.499
 1827.409,112.152,815.137,75.993,-103.591,30.329,11.284,0.018,2.587,3.700,7.205,3.039,83.766,25.630,2.387,2.491
 1827.909,112.243,805.664,79.195,-105.226,27.036,11.286,0.021,2.584,3.566,7.372,2.967,82.827,24.966,2.414,2.535
 1828.409,112.379,810.498,82.650,-105.508,26.156,11.379,0.014,2.540,3.320,9.950,2.673,85.477,26.839,2.481,2.645
 1828.909,112.329,813.037,85.179,-106.342,28.761,11.407,0.016,2.475,3.193,13.744,2.431,91.337,30.980,2.611,2.843
 1829.409,112.330,815.430,85.722,-106.028,33.038,11.355,0.034,2.440,3.152,15.778,2.419,97.169,35.102,2.762,3.064
 1829.909,112.166,812.695,81.440,-106.897,36.776,11.795,0.051,2.455,3.181,14.900,2.785,99.694,36.886,2.947,3.273
 1830.409,112.290,814.551,76.505,-107.198,37.562,12.036,0.060,2.512,3.267,11.580,3.415,98.073,35.741,3.109,3.413
 1830.909,112.278,805.664,72.163,-106.717,34.274,11.619,0.052,2.583,3.402,7.443,4.088,92.579,31.858,3.258,3.449
 1831.409,112.182,805.664,71.519,-106.199,29.338,11.398,0.037,2.630,3.589,4.670,4.475,89.835,29.919,3.390,3.475
 1831.909,112.229,805.664,74.781,-106.702,25.578,11.379,0.027,2.656,3.595,3.182,4.351,94.413,33.154,3.494,3.483
 1832.409,112.156,807.422,81.820,-108.793,24.400,11.383,0.017,2.656,3.534,3.154,3.918,102.864,39.126,3.549,3.511
 1832.909,112.101,811.963,90.673,-110.408,25.183,11.413,0.017,2.641,3.399,4.027,3.364,111.675,45.354,3.524,3.517
 1833.409,112.323,810.547,99.134,-111.190,27.591,11.448,0.026,2.628,3.222,4.809,2.899,114.863,47.607,3.404,3.446
 1833.909,112.290,810.547,109.695,-110.511,31.928,11.449,0.037,2.623,3.206,5.089,2.634,111.866,45.488,3.234,3.337
 1834.409,112.321,812.695,119.082,-109.202,36.680,11.409,0.042,2.625,3.284,4.946,2.540,107.386,42.322,3.042,3.179
 1834.909,112.270,805.664,125.335,-108.072,38.747,11.378,0.038,2.612,3.310,5.753,2.522,103.292,39.429,2.880,3.024
 1835.409,112.325,815.381,127.570,-107.602,37.104,11.370,0.027,2.579,3.166,7.664,2.514,102.074,38.568,2.765,2.901
 1835.909,112.298,812.744,127.933,-107.393,34.214,11.365,0.017,2.541,2.882,9.863,2.501,102.836,39.107,2.692,2.814
 1836.409,112.346,808.740,132.018,-108.293,32.585,11.359,0.013,2.518,2.749,11.233,2.485,102.140,38.615,2.650,2.768
 1836.909,112.386,810.059,138.086,-108.403,32.166,11.354,0.014,2.513,2.784,11.506,2.474,99.684,36.879,2.628,2.746
 1837.409,112.273,810.547,138.779,-108.090,31.711,11.352,0.016,2.516,2.874,11.361,2.472,96.828,34.861,2.614,2.736
 1837.909,112.331,810.547,136.266,-106.775,31.800,11.353,0.017,2.521,2.955,11.040,2.473,94.592,33.280,2.603,2.733
 1838.409,112.387,822.607,136.532,-105.091,33.155,11.364,0.018,2.526,2.941,10.773,2.484,94.006,32.867,2.596,2.732
 1838.909,112.305,820.361,137.614,-104.546,35.004,11.384,0.019,2.527,2.935,10.676,2.497,94.041,32.891,2.590,2.730
 1839.409,112.261,812.695,134.221,-104.258,35.849,11.406,0.024,2.533,3.048,10.378,2.507,93.940,32.820,2.585,2.724
 1839.909,112.404,805.664,128.787,-103.651,34.632,11.427,0.030,2.539,3.147,9.992,2.510,93.977,32.846,2.581,2.717
 1840.409,112.359,805.664,127.933,-103.336,32.638,11.453,0.033,2.545,3.170,9.642,2.507,94.229,33.024,2.575,2.708
 1840.909,112.343,819.873,130.477,-104.190,31.616,11.460,0.034,2.552,3.111,9.250,2.507,94.539,33.243,2.565,2.695
 1841.409,112.310,815.430,130.961,-104.581,32.852,11.445,0.034,2.561,3.000,8.735,2.509,94.798,33.426,2.554,2.680
 1841.909,112.216,815.430,124.971,-104.639,35.482,11.438,0.034,2.564,2.953,8.522,2.507,94.959,33.540,2.541,2.664
 1842.409,112.327,815.430,119.198,-104.006,36.469,11.435,0.033,2.567,3.010,8.380,2.499,95.106,33.644,2.529,2.649
 1842.909,112.274,810.547,117.507,-103.775,35.691,11.434,0.030,2.560,3.078,8.759,2.487,95.323,33.797,2.518,2.637
 1843.409,112.337,807.080,114.270,-104.666,34.366,11.432,0.025,2.553,3.154,9.161,2.481,95.568,33.970,2.505,2.624
 1843.909,112.287,811.670,111.733,-105.358,34.008,11.424,0.024,2.555,3.156,9.043,2.483,95.769,34.112,2.494,2.613
 1844.409,112.405,815.430,112.500,-105.957,35.042,11.417,0.025,2.559,3.134,8.837,2.484,95.918,34.218,2.485,2.603
 1844.909,112.328,815.430,115.162,-106.328,36.232,11.401,0.028,2.562,3.105,8.678,2.472,96.133,34.370,2.480,2.595
 1845.409,112.496,819.385,119.165,-105.981,37.309,11.331,0.029,2.560,3.066,8.746,2.450,96.514,34.639,2.479,2.591
 1845.909,112.355,810.547,119.027,-105.024,37.654,11.257,0.029,2.562,3.085,8.683,2.442,96.856,34.881,2.476,2.588
 1846.409,112.363,793.945,117.996,-103.474,37.434,11.232,0.026,2.560,3.148,8.761,2.461,96.883,34.899,2.473,2.584
 1846.909,112.458,822.168,120.153,-102.845,37.295,11.231,0.025,2.557,3.226,8.948,2.502,96.502,34.631,2.471,2.579
 1847.409,112.473,825.195,121.030,-102.980,37.844,11.235,0.029,2.550,3.261,9.336,2.530,95.994,34.272,2.472,2.572
 1847.909,112.307,814.746,118.523,-105.386,39.358,11.239,0.042,2.553,3.254,9.173,2.512,95.781,34.121,2.472,2.568
 1848.409,112.357,815.674,115.369,-105.534,40.773,11.339,0.046,2.550,3.244,9.380,2.467,95.999,34.275,2.465,2.565
 1848.909,112.383,817.725,113.732,-106.380,41.118,11.707,0.039,2.529,3.277,10.598,2.434,96.378,34.543,2.443,2.562
 1849.409,112.196,805.664,111.326,-105.150,40.934,11.816,0.041,2.508,3.311,11.802,2.425,96.512,34.638,2.414,2.553
 1849.909,112.399,810.547,106.322,-105.290,41.196,11.501,0.077,2.494,3.339,12.655,2.400,96.687,34.761,2.392,2.544
 1850.409,112.333,810.791,101.969,-104.533,43.214,11.356,0.134,2.485,3.286,13.134,2.334,97.474,35.317,2.383,2.539
 1850.909,112.335,815.430,102.838,-103.611,47.632,11.683,0.169,2.473,3.079,13.871,2.263,98.823,36.271,2.377,2.530
 1851.409,112.471,815.430,106.424,-104.552,50.613,12.312,0.156,2.461,2.889,14.568,2.248,99.834,36.985,2.360,2.505
 1851.909,112.397,815.430,107.936,-105.660,49.320,12.283,0.104,2.459,2.833,14.707,2.303,99.373,36.659,2.315,2.454
 1852.409,112.316,810.547,107.854,-106.736,44.889,11.766,0.059,2.457,2.882,14.788,2.353,98.057,35.729,2.261,2.403
 1852.909,112.393,810.547,110.730,-106.074,40.898,11.487,0.062,2.451,3.017,15.143,2.320,97.323,35.211,2.224,2.380
 1853.409,112.322,813.574,114.780,-105.765,42.183,11.703,0.101,2.441,3.027,15.739,2.223,97.846,35.580,2.209,2.388
 1853.909,112.434,816.064,114.065,-105.203,48.772,12.332,0.136,2.431,2.969,16.313,2.124,99.369,36.656,2.216,2.411
 1854.409,112.409,821.484,110.976,-105.388,54.961,12.628,0.144,2.434,2.958,16.152,2.071,100.616,37.538,2.215,2.405
 1854.909,112.276,814.063,108.402,-104.893,55.349,12.588,0.125,2.442,3.000,15.696,2.062,100.656,37.566,2.181,2.342
 1855.409,112.324,800.781,105.032,-103.533,50.463,12.546,0.106,2.449,3.084,15.241,2.049,99.704,36.894,2.098,2.226
 1855.909,112.395,812.646,102.514,-102.888,45.142,12.495,0.100,2.449,3.118,15.240,1.999,98.534,36.066,1.970,2.089
 1856.409,112.425,820.313,103.801,-102.589,44.208,12.553,0.102,2.430,3.140,16.385,1.907,97.929,35.639,1.827,1.969
 1856.909,112.457,820.313,111.095,-102.814,47.969,12.653,0.113,2.386,3.231,18.968,1.788,98.782,36.242,1.709,1.899
 1857.409,112.377,817.285,115.730,-104.425,52.259,12.582,0.130,2.282,3.250,25.057,1.652,102.568,38.917,1.648,1.909
 1857.909,112.528,811.426,110.919,-105.928,55.255,12.482,0.142,2.102,3.054,35.555,1.520,108.300,42.969,1.645,1.986
 1858.409,112.422,812.646,100.355,-107.331,62.288,12.522,0.139,1.939,2.665,45.117,1.467,111.178,45.002,1.687,2.089
 1858.909,112.417,824.707,91.333,-107.098,72.673,12.740,0.118,1.909,2.493,46.834,1.641,106.075,41.396,1.731,2.126
 1859.409,112.499,830.078,87.164,-106.415,77.008,12.614,0.087,2.070,3.027,37.419,2.155,93.157,32.267,1.745,2.059
 1859.909,112.321,820.313,86.865,-106.150,69.617,11.518,0.075,2.266,3.931,25.941,2.615,82.472,24.715,1.744,1.975
 1860.409,112.451,815.723,89.497,-106.615,49.916,10.758,0.105,2.315,4.344,23.123,2.638,83.304,25.303,1.757,1.960
 1860.909,112.443,810.547,93.594,-106.581,34.344,11.490,0.152,2.242,4.021,27.375,2.303,92.621,31.887,1.812,2.037
 1861.409,112.476,816.113,101.907,-105.520,31.484,12.578,0.185,2.187,3.260,30.611,1.903,102.461,38.842,1.890,2.161
 1861.909,112.367,828.613,111.382,-104.480,36.234,12.870,0.180,2.217,2.793,28.859,1.750,107.019,42.063,1.944,2.240
 1862.409,112.373,815.430,120.734,-104.089,44.232,12.621,0.147,2.291,2.846,24.514,1.773,106.787,41.899,1.950,2.252
 1862.909,112.356,816.895,128.531,-104.542,49.244,12.240,0.120,2.346,2.910,21.275,1.842,104.767,40.471,1.929,2.227
 1863.409,112.397,825.195,129.062,-104.213,49.476,12.021,0.099,2.386,2.951,18.918,2.025,102.348,38.762,1.938,2.228
 1863.909,112.346,823.340,125.456,-103.493,46.158,11.737,0.075,2.447,3.086,15.364,2.365,99.261,36.580,2.017,2.273
 1864.409,112.453,818.945,117.505,-102.322,41.496,10.947,0.047,2.525,3.328,10.806,2.787,94.435,33.169,2.172,2.380
 1864.909,112.423,825.195,107.749,-101.984,37.298,10.405,0.022,2.577,3.549,7.787,3.149,89.546,29.714,2.420,2.604
 1865.409,112.590,817.676,102.868,-102.170,34.186,10.302,0.009,2.578,3.612,7.713,3.419,85.830,27.089,2.760,2.988
 1865.909,112.487,820.313,102.619,-103.764,33.829,10.233,0.011,2.565,3.511,8.469,4.037,82.563,24.779,3.233,3.542
 1866.409,112.486,828.223,100.576,-105.146,34.631,10.356,0.015,2.569,3.560,8.272,6.258,77.996,21.552,3.878,4.266
 1866.909,112.539,826.758,85.689,-106.561,32.247,10.288,0.014,2.609,3.887,5.926,11.298,71.074,16.660,4.701,5.039
 1867.409,112.351,820.313,60.076,-106.742,25.474,10.044,0.005,2.659,4.312,2.963,17.885,63.354,11.204,5.650,5.772
 1867.909,112.541,820.313,38.660,-107.900,16.705,10.013,-0.005,2.691,4.654,1.124,22.646,57.629,7.158,6.662,6.448
 1868.409,112.577,820.313,29.977,-108.043,10.123,10.018,-0.007,2.703,4.745,0.408,22.759,55.342,5.542,7.632,6.858
 1868.909,112.463,815.430,35.067,-108.669,7.615,10.025,-0.002,2.688,4.554,1.277,18.174,57.013,6.723,8.132,6.956
 1869.409,112.589,815.430,44.351,-110.022,7.667,10.037,0.003,2.660,4.194,2.919,12.710,60.874,9.451,7.854,6.522
 1869.909,112.389,817.969,51.456,-110.048,9.630,10.048,0.003,2.617,3.722,5.419,9.207,65.221,12.524,6.666,5.704
 1870.409,112.502,815.430,59.149,-109.803,12.432,10.072,0.003,2.573,3.280,8.017,7.310,69.541,15.576,5.390,4.846
 1870.909,112.516,828.369,71.477,-106.868,15.356,10.179,0.012,2.548,3.053,9.466,5.894,74.559,19.123,4.412,4.150
 1871.409,112.547,829.346,88.774,-104.014,18.270,10.346,0.026,2.547,2.902,9.544,4.357,80.653,23.430,3.725,3.638
 1871.909,112.452,815.430,106.133,-101.220,21.718,10.497,0.036,2.554,2.824,9.103,3.292,86.936,27.870,3.278,3.264
 1872.409,112.587,820.801,115.278,-100.693,25.223,10.622,0.039,2.556,2.817,9.027,2.875,91.783,31.296,2.946,2.985
 1872.909,112.561,815.967,113.622,-101.237,27.812,10.758,0.042,2.551,2.787,9.296,2.771,94.567,33.263,2.709,2.779
 1873.409,112.333,812.744,109.899,-102.045,29.551,10.870,0.047,2.546,2.754,9.608,2.699,95.972,34.256,2.535,2.636
 1873.909,112.495,828.467,109.614,-103.597,31.054,10.884,0.047,2.546,2.734,9.612,2.633,96.673,34.752,2.431,2.551
 1874.409,112.489,816.406,113.617,-104.550,32.945,10.971,0.036,2.539,2.742,9.984,2.584,97.063,35.027,2.377,2.504
 1874.909,112.513,820.313,116.610,-104.891,34.519,11.157,0.021,2.529,2.797,10.590,2.567,97.028,35.002,2.361,2.493
 1875.409,112.524,828.857,117.577,-103.739,34.613,11.220,0.011,2.526,2.815,10.783,2.580,96.668,34.747,2.372,2.526
 1875.909,112.378,825.195,117.622,-103.279,33.862,10.978,0.008,2.533,2.801,10.356,2.617,96.238,34.444,2.407,2.610
 1876.409,112.521,826.611,117.699,-104.718,33.745,10.771,0.006,2.542,2.878,9.829,2.678,95.842,34.164,2.493,2.758
 1876.909,112.622,830.078,117.929,-106.972,35.605,10.770,0.004,2.542,2.959,9.818,2.771,95.519,33.935,2.663,2.978
 1877.409,112.511,825.195,117.483,-108.826,38.279,10.768,0.004,2.533,2.936,10.369,2.896,94.687,33.348,2.885,3.184
 1877.909,112.542,825.195,118.638,-111.889,39.449,10.762,0.003,2.519,2.814,11.192,3.033,93.077,32.210,3.073,3.272
 1878.409,112.496,828.174,117.315,-114.426,38.318,10.750,0.003,2.506,2.661,11.942,3.127,91.991,31.443,2.954,3.066
 1878.909,112.354,825.195,112.896,-117.329,36.010,10.746,0.006,2.479,2.611,13.508,3.083,94.206,33.008,2.559,2.689
 1879.409,112.517,824.023,106.554,-118.708,34.692,10.756,0.022,2.376,2.633,19.517,2.762,104.428,40.232,2.121,2.397
 1879.909,112.592,825.586,102.349,-118.859,35.144,10.821,0.045,2.154,2.555,32.492,2.255,119.829,51.116,1.800,2.274
 1880.409,112.544,829.980,99.557,-118.930,38.843,11.503,0.055,1.822,2.300,51.922,1.733,133.461,60.750,1.662,2.400
 1880.909,112.625,825.049,95.148,-117.771,48.142,12.520,0.051,1.536,1.993,68.656,1.387,140.223,65.528,1.635,2.647
 1881.409,112.524,820.898,89.448,-116.451,66.409,12.923,0.047,1.501,1.868,70.681,1.374,137.244,63.424,1.686,2.776
 1881.909,112.501,829.785,85.095,-114.054,82.538,12.854,0.057,1.727,2.064,57.465,1.669,130.307,58.521,1.764,2.691
 1882.409,112.598,825.195,82.815,-113.850,82.266,12.405,0.063,2.092,2.522,36.128,2.316,123.063,53.402,1.844,2.444
 1882.909,112.474,830.078,78.297,-112.888,66.361,11.551,0.054,2.396,3.099,18.367,3.055,117.800,49.682,1.973,2.324
 1883.409,112.442,830.078,74.818,-113.425,44.040,11.058,0.048,2.527,3.542,10.728,3.489,117.007,49.122,2.210,2.414
 1883.909,112.525,821.045,76.616,-112.860,30.543,11.100,0.071,2.526,3.737,10.777,3.448,119.708,51.030,2.583,2.717
 1884.409,112.618,825.195,80.210,-113.265,28.747,11.485,0.125,2.450,3.658,15.181,3.010,123.054,53.395,3.045,3.231
 1884.909,112.676,825.195,83.611,-112.489,32.183,12.159,0.172,2.361,3.392,20.397,2.519,125.545,55.156,3.338,3.700
 1885.409,112.419,828.760,85.920,-112.564,37.182,12.728,0.187,2.297,3.224,24.174,2.174,128.261,57.075,3.258,3.865
 1885.909,112.522,828.857,89.938,-111.794,41.431,12.859,0.175,2.294,3.226,24.327,2.008,131.994,59.713,2.942,3.596
 1886.409,112.551,825.195,97.300,-110.943,44.252,12.825,0.152,2.356,3.383,20.707,1.982,135.781,62.390,2.632,3.158
 1886.909,112.626,821.777,100.930,-109.587,45.037,12.746,0.130,2.437,3.594,15.953,2.036,133.252,60.602,2.433,2.802
 1887.409,112.650,825.195,100.866,-109.235,44.031,12.326,0.118,2.506,3.657,11.938,2.116,122.969,53.335,2.347,2.586
 1887.909,112.494,821.777,99.591,-106.140,43.038,12.170,0.106,2.533,3.579,10.355,2.191,109.789,44.021,2.343,2.519
 1888.409,112.746,823.926,98.308,-104.256,42.586,12.364,0.092,2.531,3.437,10.477,2.259,98.952,36.362,2.382,2.532
 1888.909,112.517,825.195,96.308,-102.579,42.670,12.574,0.072,2.528,3.402,10.626,2.338,94.699,33.356,2.432,2.598
 1889.409,112.579,811.719,92.162,-103.508,43.284,12.508,0.050,2.532,3.500,10.403,2.431,93.913,32.801,2.473,2.665
 1889.909,112.634,815.430,89.520,-103.652,43.349,12.072,0.035,2.537,3.517,10.132,2.517,93.360,32.410,2.496,2.713
 1890.409,112.491,824.902,91.261,-102.368,42.922,11.586,0.041,2.545,3.430,9.676,2.579,92.902,32.087,2.519,2.753
 1890.909,112.602,832.568,98.142,-100.796,41.706,11.334,0.064,2.553,3.293,9.209,2.612,92.752,31.980,2.552,2.786
 1891.409,112.553,829.883,106.141,-100.071,39.411,11.336,0.081,2.553,3.180,9.202,2.641,92.860,32.056,2.601,2.836
 1891.909,112.513,818.457,109.206,-100.472,36.893,11.363,0.074,2.537,3.132,10.144,2.689,92.885,32.074,2.652,2.876
 1892.409,112.464,834.961,108.061,-99.218,35.275,11.271,0.059,2.522,3.155,10.974,2.768,92.494,31.798,2.690,2.901
 1892.909,112.505,840.723,104.374,-99.067,35.139,11.097,0.059,2.536,3.245,10.189,2.875,91.681,31.223,2.713,2.902
 1893.409,112.607,829.004,102.601,-98.755,35.871,10.978,0.062,2.556,3.340,9.018,2.963,90.727,30.549,2.718,2.892
 1893.909,112.737,817.236,104.201,-100.555,36.427,11.135,0.051,2.554,3.420,9.100,2.986,89.999,30.035,2.731,2.903
 1894.409,112.748,816.211,105.419,-100.810,36.306,11.527,0.030,2.538,3.446,10.049,2.950,89.696,29.821,2.756,2.945
 1894.909,112.548,826.953,101.009,-101.839,35.859,11.857,0.018,2.530,3.361,10.522,2.926,89.740,29.851,2.816,3.051
 1895.409,112.584,830.078,93.352,-103.604,35.590,11.843,0.018,2.534,3.249,10.274,3.013,89.554,29.720,2.949,3.251
 1895.909,112.724,830.078,87.572,-105.766,34.919,11.386,0.021,2.538,3.171,10.037,3.233,88.826,29.206,3.195,3.572
 1896.409,112.589,834.961,86.313,-105.917,33.376,10.866,0.022,2.540,3.180,9.919,3.708,87.310,28.135,3.616,4.006
 1896.909,112.610,834.961,86.129,-104.495,31.539,10.615,0.021,2.556,3.425,9.027,5.137,85.806,27.071,4.229,4.509
 1897.409,112.641,831.543,76.360,-103.286,28.685,10.544,0.016,2.593,3.917,6.870,8.200,86.630,27.654,4.835,4.859
 1897.909,112.498,830.908,60.229,-103.960,23.631,10.481,0.008,2.643,4.497,3.945,11.684,89.148,29.433,5.202,4.967
 1898.409,112.614,828.369,46.568,-105.307,16.708,10.474,0.002,2.667,4.832,2.518,13.036,96.155,34.385,5.059,4.865
 1898.909,112.524,833.691,42.710,-105.784,10.517,10.475,0.004,2.625,4.795,4.952,11.320,106.732,41.860,4.719,4.748
 1899.409,112.708,834.961,52.627,-108.913,9.152,10.655,0.023,2.461,4.261,14.584,7.620,118.057,49.863,4.401,4.828
 1899.909,112.764,834.961,67.683,-110.831,13.476,10.888,0.054,2.236,3.515,27.720,4.514,128.772,57.436,4.134,4.881
 1900.409,112.542,830.566,83.096,-112.046,23.704,11.567,0.088,2.110,2.858,35.093,3.173,133.474,60.759,3.868,4.744
 1900.909,112.658,825.195,96.268,-109.290,35.548,12.017,0.104,2.149,2.462,32.780,2.918,132.178,59.843,3.503,4.202
 1901.409,112.676,832.471,106.692,-106.422,42.348,11.758,0.086,2.323,2.561,22.648,3.153,123.951,54.029,3.126,3.544
 1901.909,112.649,830.176,113.851,-104.895,42.229,11.567,0.052,2.482,2.778,13.361,3.395,111.900,45.512,2.839,3.064
 1902.409,112.641,834.961,117.750,-104.629,37.179,11.324,0.026,2.543,2.906,9.794,3.415,100.598,37.525,2.700,2.818
 1902.909,112.520,836.670,123.112,-106.267,33.803,11.060,0.020,2.560,2.997,8.754,3.271,94.045,32.894,2.686,2.758
 1903.409,112.650,844.971,129.383,-107.280,34.202,10.913,0.027,2.568,3.055,8.317,3.045,92.698,31.942,2.749,2.814
 1903.909,112.686,834.961,135.618,-109.325,35.454,10.999,0.029,2.565,3.047,8.500,2.853,93.293,32.362,2.800,2.903
 1904.409,112.666,834.961,136.707,-109.848,36.101,11.362,0.021,2.553,3.010,9.172,2.787,94.699,33.357,2.819,3.017
 1904.909,112.565,834.961,130.766,-110.623,36.378,11.914,0.014,2.547,2.935,9.537,2.838,95.312,33.789,2.806,3.094
 1905.409,112.605,834.961,125.294,-109.884,37.018,11.797,0.010,2.550,2.886,9.356,2.977,94.603,33.288,2.831,3.176
 1905.909,112.802,834.961,119.871,-109.726,37.270,11.161,0.009,2.556,2.879,9.003,3.141,92.954,32.123,2.934,3.289
 1906.409,112.678,834.961,115.792,-110.160,36.882,10.817,0.009,2.549,2.874,9.387,3.363,90.543,30.419,3.121,3.458
 1906.909,112.744,829.004,110.241,-110.590,36.134,10.697,0.009,2.546,2.987,9.605,3.868,86.862,27.817,3.383,3.678
 1907.409,112.776,836.035,97.429,-111.100,34.194,10.667,0.008,2.557,3.319,8.945,4.670,81.843,24.271,3.684,3.912
 1907.909,112.651,834.961,86.720,-111.026,30.323,10.657,0.006,2.582,3.700,7.493,5.328,76.588,20.557,3.985,4.126
 1908.409,112.758,834.961,79.935,-113.181,25.150,10.657,0.003,2.605,3.885,6.152,5.543,72.842,17.910,4.251,4.340
 1908.909,112.537,834.961,75.429,-112.668,20.876,10.657,0.001,2.620,3.842,5.269,5.343,71.306,16.824,4.475,4.547
 1909.409,112.634,830.664,74.609,-113.192,19.412,10.657,0.003,2.643,3.743,3.930,5.025,70.851,16.502,4.624,4.709
 1909.909,112.765,827.148,74.943,-111.191,20.596,10.663,0.007,2.670,3.765,2.319,4.772,70.395,16.181,4.708,4.767
 1910.409,112.574,830.078,76.697,-111.199,22.443,10.794,0.011,2.691,3.685,1.096,4.486,70.136,15.997,4.724,4.732
 1910.909,112.762,832.275,82.504,-111.090,23.243,10.900,0.016,2.693,3.414,1.004,4.211,70.943,16.567,4.600,4.558
 1911.409,112.822,830.225,90.543,-110.983,22.929,10.894,0.025,2.682,3.129,1.622,4.064,72.750,17.845,4.396,4.331
 1911.909,112.696,830.078,97.873,-111.207,22.005,10.914,0.031,2.660,3.006,2.920,4.027,75.069,19.484,4.061,4.049
 1912.409,112.809,830.176,101.887,-110.793,21.072,10.943,0.035,2.621,2.991,5.187,3.937,77.583,21.260,3.739,3.794
 1912.909,112.712,829.590,101.070,-111.325,21.191,11.010,0.054,2.562,3.009,8.678,3.618,81.746,24.202,3.479,3.632
 1913.409,112.665,825.195,101.935,-111.375,22.360,11.185,0.093,2.491,2.983,12.806,3.149,87.533,28.292,3.279,3.502
 1913.909,112.646,825.195,104.863,-110.770,24.750,11.983,0.139,2.430,2.964,16.363,2.720,93.382,32.425,3.156,3.425
 1914.409,112.751,834.961,108.340,-110.213,29.420,12.575,0.163,2.408,2.949,17.656,2.506,96.772,34.821,3.040,3.328
 1914.909,112.766,831.836,111.565,-111.229,35.922,12.527,0.140,2.423,2.922,16.794,2.554,96.228,34.437,2.950,3.224
 1915.409,112.815,831.738,115.974,-112.016,41.447,12.060,0.093,2.457,2.915,14.796,2.709,94.242,33.033,2.901,3.161
 1915.909,112.717,839.844,120.717,-113.255,42.975,11.309,0.050,2.490,2.808,12.871,2.949,92.178,31.575,2.924,3.131
 1916.409,112.714,830.078,119.747,-113.380,39.654,11.033,0.020,2.510,2.665,11.683,3.360,89.627,29.772,3.032,3.169
 1916.909,112.726,833.691,113.534,-114.806,33.276,10.992,0.010,2.537,2.632,10.102,3.968,85.346,26.746,3.187,3.217
 1917.409,112.720,832.422,104.247,-114.509,26.986,10.983,0.009,2.560,2.664,8.786,4.450,80.099,23.038,3.317,3.264
 1917.909,112.737,825.195,98.068,-114.339,22.293,10.983,0.015,2.576,2.685,7.831,4.458,76.675,20.618,3.376,3.323
 1918.409,112.775,827.051,97.604,-112.858,19.889,10.995,0.019,2.569,2.627,8.261,3.969,76.889,20.770,3.343,3.363
 1918.909,112.604,820.313,100.333,-113.379,19.871,11.063,0.018,2.544,2.506,9.686,3.325,79.918,22.910,3.265,3.396
 1919.409,112.797,825.586,108.396,-112.888,22.392,11.139,0.011,2.520,2.430,11.139,2.911,83.902,25.726,3.166,3.370
 1919.909,112.734,826.367,113.752,-112.209,25.799,11.176,0.007,2.513,2.403,11.527,2.763,87.454,28.236,3.068,3.294
 1920.409,112.763,829.199,114.024,-111.796,28.262,11.177,0.008,2.527,2.425,10.726,2.779,89.785,29.883,2.982,3.188
 1920.909,112.608,825.879,112.264,-110.086,29.599,11.167,0.007,2.532,2.494,10.383,2.860,90.723,30.546,2.897,3.060
 1921.409,112.775,830.078,108.412,-108.712,30.453,11.161,0.007,2.531,2.599,10.479,2.925,90.444,30.349,2.818,2.938
 1921.909,112.869,825.293,109.662,-106.068,32.237,11.171,0.011,2.532,2.754,10.404,2.939,89.520,29.696,2.717,2.825
 1922.409,112.788,832.520,110.640,-105.463,33.984,11.221,0.028,2.531,2.921,10.478,2.872,88.509,28.982,2.610,2.751
 1922.909,112.774,834.814,108.969,-105.931,33.991,11.381,0.065,2.519,3.016,11.173,2.729,88.754,29.155,2.527,2.753
 1923.409,112.768,832.764,107.564,-106.865,32.803,11.547,0.107,2.469,2.936,14.095,2.523,91.576,31.149,2.505,2.850
 1923.909,112.747,834.961,105.471,-109.061,32.687,11.980,0.127,2.387,2.772,18.905,2.320,95.855,34.173,2.574,3.047
 1924.409,112.834,829.102,103.999,-110.970,36.503,12.440,0.123,2.322,2.636,22.710,2.305,98.607,36.118,2.723,3.283
 1924.909,112.767,830.078,98.609,-112.612,41.532,12.296,0.100,2.319,2.733,22.879,2.789,96.371,34.538,2.923,3.466
 1925.409,112.869,830.078,84.948,-113.359,41.971,11.789,0.071,2.401,3.208,18.048,4.002,87.974,28.603,3.151,3.570
 1925.909,112.739,836.621,72.720,-112.343,35.955,11.067,0.044,2.517,3.696,11.286,5.454,77.107,20.924,3.408,3.642
 1926.409,112.713,837.988,66.066,-112.784,26.364,10.694,0.023,2.609,4.001,5.879,6.438,68.407,14.775,3.793,3.839
 1926.909,112.711,830.078,66.934,-111.357,18.897,10.712,0.016,2.656,3.965,3.137,6.500,64.787,12.217,4.366,4.223
 1927.409,112.802,830.078,69.156,-111.745,15.843,10.732,0.017,2.666,3.731,2.588,5.928,65.419,12.663,5.063,4.721
 1927.909,112.923,828.760,67.965,-112.937,15.791,10.745,0.012,2.654,3.721,3.281,5.400,67.304,13.996,5.637,5.167
 1928.409,112.679,825.195,66.565,-114.077,16.723,10.757,0.003,2.638,3.889,4.204,5.241,68.116,14.570,5.611,5.185
 1928.909,112.825,829.736,64.457,-113.943,17.430,10.744,0.000,2.624,4.177,5.032,5.218,68.113,14.568,5.139,4.804
 1929.409,112.873,843.945,67.172,-112.653,17.479,10.744,0.017,2.614,4.376,5.602,4.895,69.422,15.493,4.518,4.269
 1929.909,112.811,841.211,75.945,-110.748,17.242,10.822,0.045,2.601,4.121,6.349,4.197,73.872,18.638,3.990,3.750
 1930.409,112.852,830.615,87.645,-110.270,18.014,10.953,0.063,2.582,3.632,7.498,3.399,80.128,23.058,3.575,3.349
 1930.909,112.870,834.961,100.235,-111.074,20.753,10.944,0.063,2.569,3.221,8.234,2.888,85.426,26.802,3.203,2.995
 1931.409,112.898,848.584,107.449,-111.633,24.865,10.842,0.049,2.542,3.082,9.804,2.682,88.831,29.209,2.890,2.686
 1931.909,112.850,851.855,112.140,-111.990,29.319,10.811,0.048,2.495,3.187,12.571,2.527,91.679,31.222,2.635,2.438
 1932.409,112.789,854.492,115.863,-112.674,33.212,10.839,0.057,2.450,3.161,15.228,2.333,94.896,33.495,2.448,2.231
 1932.909,112.872,839.746,112.944,-116.227,36.004,10.980,0.060,2.432,3.068,16.230,2.277,96.668,34.748,2.321,2.077
 1933.409,112.878,844.727,106.690,-120.006,36.800,10.893,0.054,2.443,2.964,15.620,2.481,95.922,34.220,2.230,1.943
 1933.909,112.841,842.041,100.454,-123.720,34.927,10.688,0.042,2.461,2.853,14.580,2.902,93.101,32.227,2.159,1.834
 1934.409,112.791,844.336,95.724,-126.320,31.889,10.649,0.032,2.454,2.768,14.986,3.261,90.504,30.391,2.110,1.751
 1934.909,112.870,839.844,93.030,-127.500,29.605,10.617,0.028,2.428,2.661,16.486,3.378,89.366,29.588,2.072,1.690
 1935.409,112.896,844.727,88.129,-129.009,29.322,10.599,0.029,2.403,2.603,17.936,3.321,90.359,30.289,2.047,1.643
 1935.909,112.865,841.553,81.035,-130.857,30.320,10.596,0.034,2.383,2.572,19.142,3.203,93.743,32.681,2.024,1.606
 1936.409,112.804,844.727,74.925,-132.331,31.345,10.595,0.041,2.371,2.567,19.852,3.085,98.123,35.776,1.997,1.578
 1936.909,112.873,837.891,71.658,-133.365,32.467,10.585,0.045,2.365,2.674,20.159,2.952,102.645,38.972,1.970,1.559
 1937.409,112.981,839.844,75.619,-134.363,33.927,10.569,0.047,2.365,2.860,20.187,2.837,105.477,40.973,1.945,1.544
 1937.909,112.824,839.844,84.835,-133.891,35.307,10.520,0.047,2.360,2.992,20.484,2.780,106.276,41.538,1.925,1.527
 1938.409,112.829,841.162,93.117,-133.844,35.232,10.464,0.046,2.347,2.886,21.210,2.753,107.937,42.712,1.905,1.503
 1938.909,112.944,848.584,93.923,-133.816,33.657,10.448,0.042,2.331,2.616,22.169,2.751,112.090,45.647,1.885,1.475
 1939.409,112.927,848.047,88.115,-134.519,31.563,10.446,0.037,2.327,2.415,22.395,2.736,117.343,49.359,1.858,1.445
 1939.909,112.907,844.727,83.132,-134.934,29.848,10.446,0.032,2.337,2.368,21.785,2.709,121.687,52.429,1.829,1.412
 1940.409,112.782,849.609,82.524,-135.083,29.322,10.446,0.028,2.346,2.403,21.300,2.671,122.274,52.844,1.792,1.381
 1940.909,112.858,845.264,85.338,-135.851,30.013,10.447,0.022,2.338,2.376,21.747,2.572,118.117,49.906,1.754,1.352
 1941.409,112.911,844.727,86.731,-137.061,31.495,10.448,0.015,2.315,2.240,23.108,2.425,111.391,45.153,1.714,1.333
 1941.909,112.706,844.727,85.180,-138.310,31.928,10.452,0.011,2.299,2.115,24.029,2.293,104.845,40.526,1.679,1.323
 1942.409,112.872,846.973,82.785,-137.695,30.029,10.475,0.013,2.302,2.072,23.879,2.260,101.278,38.006,1.652,1.326
 1942.909,113.058,844.775,80.338,-136.099,27.352,10.521,0.018,2.319,2.089,22.861,2.325,100.626,37.545,1.633,1.340
 1943.409,112.838,842.236,80.911,-134.129,26.429,10.592,0.025,2.349,2.168,21.122,2.409,100.074,37.154,1.631,1.373
 1943.909,112.776,849.463,86.148,-133.786,27.009,10.682,0.031,2.384,2.268,19.061,2.413,97.737,35.503,1.643,1.424
 1944.409,112.928,844.727,95.440,-133.061,27.397,10.773,0.033,2.416,2.373,17.196,2.321,93.682,32.638,1.680,1.499
 1944.909,112.971,848.828,104.172,-133.148,27.395,10.848,0.028,2.433,2.428,16.191,2.191,89.737,29.849,1.734,1.590
 1945.409,112.933,842.822,108.405,-131.570,27.740,10.894,0.022,2.446,2.484,15.410,2.106,87.579,28.324,1.802,1.687
 1945.909,112.951,849.609,110.717,-130.204,28.954,10.919,0.020,2.464,2.562,14.401,2.101,87.284,28.116,1.871,1.787
 1946.409,113.001,843.262,113.016,-128.289,30.323,10.927,0.022,2.486,2.633,13.122,2.147,87.587,28.330,1.938,1.886
 1946.909,112.962,838.965,115.858,-126.086,31.298,10.927,0.025,2.500,2.640,12.254,2.233,88.011,28.630,2.006,1.987
 1947.409,112.956,834.961,118.312,-125.243,32.476,10.921,0.027,2.504,2.559,12.071,2.325,88.304,28.837,2.083,2.093
 1947.909,112.971,843.604,116.469,-124.503,34.079,10.906,0.027,2.501,2.516,12.208,2.394,90.006,30.040,2.165,2.194
 1948.409,112.757,843.506,114.746,-123.645,35.214,10.890,0.026,2.498,2.570,12.374,2.451,94.180,32.989,2.247,2.283
 1948.909,112.964,848.682,116.523,-122.796,34.490,10.876,0.023,2.500,2.657,12.302,2.479,99.035,36.420,2.320,2.354
 1949.409,112.936,851.563,122.884,-120.460,32.360,10.869,0.019,2.508,2.721,11.832,2.490,101.189,37.943,2.368,2.407
 1949.909,112.966,849.609,129.490,-118.705,30.504,10.868,0.017,2.528,2.764,10.645,2.503,98.842,36.284,2.405,2.448
 1950.409,112.875,845.459,130.702,-116.970,30.385,10.868,0.019,2.550,2.823,9.353,2.528,94.753,33.394,2.428,2.493
 1950.909,112.962,844.727,127.036,-115.963,31.823,10.860,0.021,2.564,2.887,8.526,2.570,92.313,31.670,2.475,2.566
 1951.409,113.064,844.727,123.094,-114.460,32.999,10.741,0.024,2.566,2.936,8.411,2.593,91.838,31.334,2.565,2.702
 1951.909,112.927,846.777,122.330,-114.042,33.869,10.508,0.025,2.550,3.084,9.335,2.680,90.265,30.222,2.734,2.931
 1952.409,112.996,849.609,117.345,-113.627,34.714,10.321,0.031,2.547,3.308,9.540,3.180,85.999,27.208,3.008,3.249
 1952.909,113.047,849.609,98.982,-114.880,34.746,10.183,0.038,2.586,3.594,7.231,4.888,78.583,21.967,3.423,3.671
 1953.409,112.991,839.941,72.894,-115.521,32.661,10.065,0.042,2.659,3.833,2.968,7.823,69.885,15.820,4.009,4.162
 1953.909,113.065,839.844,52.246,-116.602,26.993,10.015,0.038,2.733,3.973,-1.321,11.686,62.579,10.656,4.809,4.776
 1954.409,112.892,831.445,39.732,-116.449,20.219,10.009,0.026,2.763,4.107,-3.083,15.251,57.526,7.086,5.797,5.443
 1954.909,112.991,858.789,36.380,-116.362,14.799,10.014,0.013,2.747,4.241,-2.140,16.759,55.182,5.429,6.677,5.999
 1955.409,112.993,853.613,37.267,-115.561,11.197,10.034,0.008,2.720,4.494,-0.582,15.665,55.094,5.367,7.024,6.200
 1955.909,112.866,847.705,42.670,-114.423,9.755,10.093,0.026,2.701,4.682,0.545,12.133,58.234,7.586,6.528,5.894
 1956.409,112.920,844.727,55.137,-111.823,10.457,10.228,0.061,2.679,4.456,1.832,8.039,64.564,12.059,5.602,5.359
 1956.909,112.915,844.727,74.912,-109.424,14.151,10.457,0.086,2.640,3.862,4.102,5.012,73.447,18.337,4.703,4.753
 1957.409,113.001,843.848,96.160,-107.396,19.561,10.617,0.086,2.594,3.281,6.770,3.506,82.025,24.399,3.988,4.204
 1957.909,113.020,853.711,112.561,-105.925,24.475,10.664,0.061,2.555,3.020,9.045,3.045,87.972,28.602,3.481,3.730
 1958.409,112.883,858.252,119.905,-105.973,27.663,10.696,0.035,2.534,3.054,10.273,2.963,91.037,30.768,3.133,3.369
 1958.909,113.085,854.492,119.643,-106.642,29.074,10.712,0.025,2.530,3.095,10.501,2.959,92.042,31.479,2.908,3.111
 1959.409,112.997,854.492,117.095,-107.661,29.822,10.720,0.023,2.533,3.056,10.357,2.981,91.926,31.396,2.772,2.944
 1959.909,113.070,838.867,112.975,-108.468,30.680,10.722,0.026,2.545,2.997,9.664,2.999,91.309,30.960,2.700,2.857
 1960.409,113.075,852.881,113.128,-109.579,31.045,10.724,0.028,2.554,2.905,9.134,2.981,90.517,30.400,2.661,2.838
 1960.909,113.088,849.609,115.323,-110.087,31.344,10.804,0.024,2.548,2.842,9.459,2.925,90.110,30.113,2.660,2.895
 1961.409,113.061,851.416,118.716,-110.300,31.989,10.804,0.018,2.536,2.842,10.193,2.850,90.361,30.291,2.708,3.037
 1961.909,112.970,854.492,121.121,-110.356,32.938,10.681,0.013,2.517,2.918,11.286,2.824,90.773,30.582,2.826,3.259
 1962.409,112.985,850.391,119.542,-112.006,34.262,10.485,0.016,2.497,3.108,12.431,2.974,90.283,30.235,3.056,3.590
 1962.909,112.913,840.088,115.377,-112.844,35.114,10.421,0.026,2.488,3.296,12.976,3.592,87.587,28.330,3.393,4.004
 1963.409,113.116,849.609,99.430,-115.391,33.621,10.346,0.031,2.507,3.670,11.847,5.830,81.262,23.860,3.890,4.526
 1963.909,112.927,835.107,74.096,-117.157,29.321,10.064,0.026,2.547,4.201,9.532,10.095,72.666,17.785,4.552,5.149
 1964.409,113.066,852.148,50.319,-120.578,22.056,9.959,0.015,2.607,4.671,6.035,15.602,63.983,11.649,5.530,5.992
 1964.909,112.964,854.297,33.559,-123.057,14.851,9.945,0.007,2.655,4.897,3.188,20.461,57.575,7.120,6.940,7.176
 1965.409,113.003,844.043,25.664,-125.121,10.656,9.918,0.006,2.666,4.836,2.565,24.486,54.514,4.957,9.116,8.966
 1965.909,113.040,836.719,23.686,-126.167,8.922,9.861,0.008,2.653,4.763,3.307,28.094,53.548,4.275,12.000,11.265
 1966.409,113.083,854.492,22.982,-129.846,8.590,9.830,0.016,2.637,4.821,4.287,31.534,53.850,4.488,15.263,13.833
 1966.909,113.042,853.125,23.287,-131.262,8.702,9.829,0.024,2.624,4.842,5.055,34.045,54.563,4.991,17.736,15.764
 1967.409,113.035,838.281,22.973,-133.577,9.089,9.829,0.032,2.622,4.846,5.163,34.873,55.399,5.582,19.008,16.627
 1967.909,113.134,834.961,21.512,-132.948,9.725,9.816,0.032,2.623,5.026,5.102,35.217,55.971,5.987,19.510,16.539
 1968.409,113.075,834.961,21.914,-131.872,10.157,9.782,0.024,2.622,5.230,5.149,35.877,56.025,6.025,20.033,16.075
 1968.909,113.063,834.961,23.399,-131.864,9.914,9.730,0.015,2.619,5.227,5.296,37.331,55.669,5.773,20.536,15.732
 1969.409,113.025,834.961,25.978,-132.983,9.116,9.668,0.006,2.611,5.014,5.784,39.424,55.088,5.362,21.097,15.574
 1969.909,113.066,844.727,27.625,-135.050,8.352,9.614,0.005,2.609,4.820,5.935,41.109,54.593,5.013,21.397,15.586
 1970.409,113.092,844.727,28.660,-135.026,7.965,9.558,0.009,2.612,4.856,5.727,41.630,54.317,4.818,21.702,15.707
 1970.909,112.982,847.998,29.974,-134.589,7.858,9.504,0.015,2.615,4.957,5.556,41.572,54.214,4.745,22.001,15.890
 1971.409,113.091,844.727,31.681,-131.803,7.759,9.462,0.015,2.604,4.919,6.208,41.847,54.247,4.768,22.362,16.063
 1971.909,113.135,844.727,34.491,-130.649,7.445,9.427,0.009,2.593,4.941,6.814,42.147,54.349,4.840,22.933,16.265
 1972.409,112.956,844.727,33.837,-128.527,6.981,9.383,0.004,2.587,5.009,7.168,41.535,54.489,4.939,23.303,16.446
 1972.909,113.067,858.008,30.333,-127.662,6.597,9.318,0.007,2.587,4.988,7.213,39.455,55.148,5.405,23.956,16.891
 1973.409,113.175,869.141,26.530,-126.581,6.413,9.275,0.018,2.591,4.804,6.984,37.192,57.810,7.286,24.892,17.618
 1973.909,113.072,854.785,26.407,-125.403,6.316,9.266,0.032,2.595,4.652,6.703,36.042,62.373,10.511,25.184,17.746
 1974.409,113.259,844.727,30.025,-125.412,6.102,9.275,0.050,2.615,4.661,5.533,34.528,67.664,14.250,25.267,17.199
 1974.909,113.068,844.727,34.334,-125.898,5.727,9.324,0.064,2.645,4.825,3.818,30.361,72.641,17.767,20.614,14.663
 1975.409,113.173,854.736,38.874,-126.805,5.342,9.389,0.066,2.666,4.938,2.583,23.944,76.572,20.546,15.484,11.621
 1975.909,113.206,859.375,41.802,-126.701,5.180,9.448,0.054,2.666,4.812,2.549,16.805,83.590,25.506,10.843,9.020
 1976.409,113.003,849.609,44.249,-126.190,5.473,9.507,0.039,2.641,4.583,4.036,11.045,92.924,32.102,7.670,6.915
 1976.909,113.088,852.637,50.372,-124.091,6.954,9.589,0.042,2.588,4.266,7.158,7.191,99.156,36.506,5.841,5.613
 1977.409,113.153,853.809,61.711,-122.093,10.483,9.742,0.063,2.532,3.828,10.415,4.567,100.253,37.281,4.571,4.618
 1977.909,113.084,849.609,76.756,-119.943,16.904,10.403,0.079,2.489,3.393,12.922,3.191,98.181,35.817,3.753,3.887
 1978.409,113.200,853.564,85.894,-118.988,23.974,10.584,0.082,2.481,3.049,13.421,2.756,98.575,36.096,3.138,3.320
 1978.909,113.131,849.609,89.121,-118.264,28.429,10.169,0.075,2.497,2.835,12.475,2.767,102.060,38.558,2.735,2.910
 1979.409,113.129,849.609,87.779,-119.807,29.561,10.266,0.067,2.508,2.798,11.833,2.720,101.957,38.486,2.507,2.729
 1979.909,113.218,842.188,79.641,-122.221,28.610,10.137,0.063,2.504,2.791,12.057,2.516,95.212,33.719,2.452,2.731
 1980.409,113.153,844.092,65.982,-124.895,27.647,9.832,0.052,2.497,2.941,12.472,2.509,86.733,27.726,2.566,2.929
 1980.909,113.094,846.582,49.793,-126.033,26.919,9.695,0.043,2.503,3.314,12.112,3.160,80.569,23.370,2.855,3.279
 1981.409,113.108,839.844,39.994,-124.874,24.471,9.537,0.039,2.523,3.676,10.921,5.088,78.473,21.889,3.317,3.726
 1981.909,113.157,848.242,35.651,-123.913,20.206,9.434,0.034,2.550,3.952,9.328,8.812,77.943,21.515,3.997,4.332
 1982.409,113.049,849.609,32.047,-122.307,15.097,9.406,0.027,2.571,4.105,8.114,13.313,78.046,21.588,4.798,5.007
 1982.909,113.093,849.609,30.328,-123.548,10.370,9.400,0.024,2.596,4.212,6.651,16.453,82.597,24.804,5.672,5.744
 1983.409,113.115,849.609,32.816,-122.506,7.518,9.408,0.029,2.616,4.374,5.509,16.432,91.089,30.805,6.407,6.476
 1983.909,113.037,835.693,39.710,-124.218,6.421,9.451,0.041,2.614,4.432,5.616,13.676,101.782,38.362,6.842,7.016
 1984.409,113.130,849.609,52.421,-122.677,7.544,9.505,0.065,2.543,4.196,9.775,9.783,112.464,45.911,6.938,7.491
 1984.909,113.196,859.375,67.016,-123.093,11.086,9.586,0.094,2.427,3.625,16.542,6.646,120.697,51.729,6.589,7.439
 1985.409,113.155,859.082,78.820,-122.801,16.860,10.042,0.105,2.357,3.187,20.658,5.567,126.022,55.493,5.896,6.636
 1985.909,113.220,854.736,81.239,-121.647,21.157,10.239,0.093,2.362,3.294,20.376,5.860,127.062,56.228,5.113,5.590
 1986.409,113.063,856.592,73.673,-121.858,20.656,9.750,0.087,2.425,3.732,16.682,6.039,125.402,55.054,4.492,4.759
 1986.909,113.074,854.492,65.168,-121.134,17.179,9.619,0.098,2.465,3.827,14.319,5.344,124.950,54.735,4.093,4.308
 1987.409,113.114,851.465,60.211,-123.069,15.443,9.954,0.109,2.460,3.441,14.630,4.221,126.248,55.652,3.944,4.149
 1987.909,113.175,867.676,55.893,-123.355,17.666,9.923,0.093,2.457,3.087,14.806,3.926,127.253,56.363,3.870,4.049
 1988.409,113.200,859.375,50.855,-122.679,21.004,9.696,0.060,2.464,3.173,14.368,4.464,126.850,56.078,3.851,3.966
 1988.909,113.279,867.285,49.889,-120.583,21.899,9.676,0.057,2.460,3.431,14.624,4.715,125.188,54.903,3.811,3.930
 1989.409,113.213,852.344,55.228,-119.636,20.768,9.719,0.077,2.430,3.292,16.398,4.448,122.387,52.924,3.840,4.042
 1989.909,113.235,848.438,58.756,-120.387,21.224,9.916,0.080,2.412,3.037,17.402,4.267,118.579,50.232,3.993,4.326
 1990.409,113.167,852.246,53.670,-121.296,23.206,9.756,0.061,2.449,3.010,15.254,4.689,114.197,47.136,4.294,4.672
 1990.909,113.253,875.293,43.942,-122.219,23.639,9.445,0.036,2.518,3.263,11.226,5.778,110.350,44.417,4.774,5.122
 1991.409,113.278,854.492,39.115,-121.391,21.334,9.428,0.025,2.572,3.687,8.090,7.409,108.195,42.894,5.449,5.771
 1991.909,113.177,854.492,38.119,-121.465,17.328,9.426,0.017,2.580,3.944,7.618,10.227,104.244,40.102,6.409,6.669
 1992.409,113.243,846.094,37.139,-121.096,13.807,9.424,0.007,2.572,4.028,8.058,14.607,98.660,36.155,7.775,7.795
 1992.909,113.273,846.631,34.656,-121.568,11.018,9.426,0.002,2.581,4.155,7.560,18.352,98.094,35.756,9.276,8.404
 1993.409,113.280,849.609,32.694,-120.686,8.511,9.435,0.010,2.589,4.301,7.057,18.762,102.365,38.774,9.619,8.035
 1993.909,113.120,849.609,38.324,-118.936,6.958,9.484,0.035,2.589,4.337,7.058,14.904,109.552,43.853,7.876,6.680
 1994.409,113.165,844.922,48.919,-116.732,6.839,9.698,0.059,2.572,4.169,8.062,9.450,116.098,48.479,5.608,5.183
 1994.909,113.244,854.297,58.012,-116.844,9.201,9.988,0.067,2.506,3.875,11.916,5.598,123.820,53.936,4.065,4.187
 1995.409,113.118,859.229,66.148,-117.260,14.344,10.116,0.070,2.390,3.536,18.728,3.553,133.809,60.996,3.114,3.548
 1995.909,113.166,847.314,75.834,-120.213,22.943,10.461,0.067,2.228,3.177,28.190,2.633,142.281,66.983,2.612,3.211
 1996.409,113.174,854.492,88.559,-121.704,32.966,11.367,0.069,2.108,2.875,35.213,2.122,144.126,68.287,2.308,2.931
 1996.909,113.260,857.324,102.341,-122.319,41.476,11.803,0.080,2.103,2.691,35.500,2.012,136.770,63.088,2.124,2.646
 1997.409,113.211,863.281,108.362,-120.522,46.234,11.520,0.100,2.174,2.713,31.353,2.087,126.599,55.900,2.003,2.387
 1997.909,113.209,854.492,109.695,-117.878,46.872,11.415,0.135,2.265,2.854,25.997,2.218,114.345,47.240,1.931,2.206
 1998.409,113.348,857.910,109.932,-115.978,45.925,11.473,0.159,2.321,2.886,22.760,2.341,104.200,40.071,1.910,2.132
 1998.909,113.223,849.609,111.448,-114.203,43.962,11.394,0.160,2.336,2.934,21.863,2.416,98.594,36.109,1.949,2.165
 1999.409,113.218,859.375,113.566,-112.959,41.919,11.208,0.153,2.331,3.020,22.138,2.420,96.707,34.775,2.048,2.289
 1999.909,113.219,855.859,111.675,-112.532,41.459,11.154,0.155,2.310,3.050,23.363,2.370,98.506,36.046,2.203,2.503
 2000.409,113.318,858.154,105.292,-113.024,43.820,11.340,0.161,2.305,3.030,23.692,2.398,99.845,36.993,2.392,2.769
 2000.909,113.174,854.492,97.780,-114.184,47.894,11.401,0.142,2.340,3.113,21.655,2.716,97.816,35.559,2.591,3.026
 2001.409,113.183,856.543,89.738,-113.921,47.919,10.806,0.097,2.417,3.382,17.129,3.428,93.046,32.188,2.781,3.191
 2001.909,113.222,849.609,80.339,-113.364,41.387,10.171,0.046,2.509,3.785,11.765,4.342,88.221,28.778,2.965,3.267
 2002.409,113.354,849.609,69.293,-112.343,31.337,10.031,0.021,2.584,4.134,7.393,4.936,86.506,27.566,3.149,3.326
 2002.909,113.282,866.602,58.131,-110.154,22.836,10.031,0.026,2.635,4.296,4.405,4.945,87.404,28.201,3.328,3.401
 2003.409,113.317,859.375,57.027,-110.443,19.198,10.059,0.039,2.653,4.236,3.325,4.458,90.485,30.378,3.458,3.489
 2003.909,113.154,859.375,66.595,-110.376,18.424,10.088,0.046,2.648,4.002,3.647,3.854,98.324,35.918,3.491,3.539
 2004.409,113.257,859.375,81.116,-111.350,19.238,10.101,0.044,2.625,3.739,4.981,3.419,110.262,44.355,3.412,3.541
 2004.909,113.211,859.375,92.391,-110.621,20.785,10.105,0.037,2.598,3.590,6.551,3.153,121.979,52.635,3.287,3.516
 2005.409,113.276,856.982,95.288,-109.562,22.720,10.093,0.033,2.578,3.560,7.716,3.025,128.769,57.434,3.202,3.482
 2005.909,113.272,854.492,90.415,-108.796,24.967,10.050,0.039,2.563,3.606,8.606,3.011,130.477,58.641,3.189,3.473
 2006.409,113.373,859.668,82.124,-107.891,26.847,10.005,0.052,2.553,3.705,9.203,3.268,129.706,58.096,3.258,3.485
 2006.909,113.111,864.844,72.831,-108.511,27.159,10.120,0.055,2.549,3.862,9.398,3.767,126.543,55.861,3.378,3.545
 2007.409,113.300,871.191,67.721,-107.229,25.023,10.023,0.044,2.565,4.004,8.479,4.281,121.046,51.976,3.522,3.637
 2007.909,113.374,869.141,67.158,-106.648,21.455,9.791,0.024,2.580,4.000,7.603,4.625,116.357,48.662,3.684,3.772
 2008.409,113.230,872.217,68.171,-105.271,18.525,9.779,0.011,2.595,3.881,6.735,4.691,115.865,48.314,3.862,3.939
 2008.909,113.336,864.258,70.632,-105.869,17.312,9.780,0.009,2.607,3.800,6.012,4.625,118.374,50.087,4.019,4.081
 2009.409,113.343,864.258,70.928,-106.542,17.070,9.788,0.009,2.607,3.878,6.052,4.576,121.228,52.105,4.125,4.175
 2009.909,113.361,869.141,71.205,-106.963,16.947,9.798,0.011,2.606,3.931,6.095,4.497,120.593,51.656,4.128,4.167
 2010.409,113.305,869.141,68.622,-106.885,16.789,9.811,0.012,2.604,3.850,6.225,4.366,116.070,48.459,4.027,4.071
 2010.909,113.155,860.596,64.260,-106.962,17.013,9.835,0.014,2.604,3.701,6.220,4.184,113.188,46.423,3.883,3.943
 2011.409,113.339,860.498,63.129,-107.450,18.010,9.865,0.017,2.606,3.623,6.064,3.929,113.581,46.700,3.722,3.793
 2011.909,113.377,859.375,62.333,-107.672,19.058,9.900,0.020,2.604,3.670,6.227,3.672,112.772,46.129,3.586,3.673
 2012.409,113.231,855.371,62.569,-108.027,19.571,9.929,0.017,2.589,3.761,7.055,3.484,109.141,43.563,3.471,3.574
 2012.909,113.270,849.609,63.921,-107.022,19.556,9.938,0.011,2.574,3.785,7.941,3.394,101.637,38.259,3.378,3.494
 2013.409,113.343,858.105,65.903,-107.084,19.545,9.939,0.004,2.564,3.791,8.546,3.375,94.805,33.431,3.309,3.433
 2013.909,113.348,856.396,66.938,-107.125,20.123,9.947,0.002,2.564,3.802,8.513,3.391,92.678,31.928,3.265,3.386
 2014.409,113.237,859.375,66.697,-107.345,20.686,9.962,0.005,2.574,3.826,7.937,3.412,91.271,30.934,3.242,3.361
 2014.909,113.357,866.992,66.888,-107.518,20.578,9.980,0.008,2.582,3.833,7.490,3.435,88.554,29.014,3.240,3.355
 2015.409,113.479,864.258,66.459,-107.373,20.139,9.999,0.008,2.583,3.779,7.441,3.452,84.532,26.171,3.243,3.361
 2015.909,113.328,864.258,65.018,-106.821,19.825,10.014,0.007,2.584,3.705,7.352,3.435,79.727,22.775,3.253,3.374
 2016.409,113.324,859.375,61.070,-107.035,19.664,10.022,0.004,2.583,3.694,7.454,3.397,77.125,20.936,3.258,3.385
 2016.909,113.395,862.012,59.261,-107.421,19.803,10.013,0.002,2.580,3.775,7.621,3.361,77.207,20.995,3.262,3.394
 2017.409,113.321,864.844,61.800,-108.794,20.384,9.971,0.001,2.576,3.845,7.810,3.347,77.148,20.953,3.260,3.395
 2017.909,113.437,868.262,66.010,-109.041,21.290,9.937,0.004,2.581,3.810,7.528,3.350,76.952,20.814,3.253,3.384
 2018.409,113.386,869.141,69.374,-109.530,22.108,9.934,0.007,2.591,3.695,6.984,3.361,76.907,20.782,3.242,3.368
 2018.909,113.408,869.141,66.977,-108.055,22.531,9.934,0.007,2.596,3.637,6.660,3.356,77.641,21.301,3.227,3.346
 2019.409,113.380,866.016,63.043,-107.139,22.822,9.934,0.007,2.598,3.699,6.547,3.330,80.111,23.047,3.210,3.326
 2019.909,113.381,849.609,59.693,-107.338,23.008,9.934,0.009,2.600,3.697,6.458,3.289,83.836,25.679,3.188,3.302
 2020.409,113.355,870.166,60.643,-108.068,22.972,9.934,0.012,2.605,3.611,6.149,3.244,87.330,28.149,3.159,3.275
 2020.909,113.382,870.459,65.613,-109.278,22.719,9.934,0.015,2.609,3.617,5.921,3.192,89.271,29.520,3.122,3.243
 2021.409,113.274,869.141,67.768,-109.384,22.180,9.934,0.014,2.604,3.678,6.170,3.128,89.819,29.907,3.079,3.206
 2021.909,113.348,869.141,65.936,-108.578,21.749,9.934,0.010,2.591,3.761,6.942,3.059,91.356,30.994,3.034,3.164
 2022.409,113.439,864.258,62.416,-107.514,21.504,9.934,0.006,2.576,3.768,7.822,3.004,96.174,34.398,2.988,3.117
 2022.909,113.386,860.205,61.157,-106.974,21.530,9.934,0.004,2.565,3.701,8.496,2.962,103.634,39.671,2.940,3.063
 2023.409,113.463,861.084,63.603,-106.690,21.849,9.934,0.006,2.567,3.662,8.339,2.919,112.719,46.091,2.888,2.999
 2023.909,113.226,864.258,67.349,-106.501,22.169,9.934,0.007,2.570,3.579,8.160,2.876,121.815,52.520,2.823,2.924
 2024.409,113.394,864.258,69.764,-105.466,22.376,9.934,0.008,2.574,3.485,7.965,2.830,128.098,56.960,2.745,2.850
 2024.909,113.434,868.750,72.390,-105.332,22.457,9.934,0.007,2.572,3.407,8.085,2.784,130.861,58.912,2.672,2.799
 2025.409,113.435,874.023,74.273,-105.822,22.716,9.933,0.010,2.573,3.429,8.033,2.729,128.454,57.212,2.632,2.800
 2025.909,113.457,864.551,75.379,-107.178,23.262,9.934,0.014,2.575,3.448,7.912,2.667,124.905,54.703,2.655,2.868
 2026.409,113.398,873.926,76.269,-107.946,24.279,9.931,0.018,2.579,3.367,7.640,2.639,126.332,55.712,2.757,3.013
 2026.909,113.430,878.418,75.658,-108.283,25.734,9.902,0.020,2.586,3.260,7.242,2.798,130.467,58.634,2.920,3.193
 2027.409,113.454,857.129,72.259,-108.809,26.945,9.844,0.016,2.587,3.271,7.175,3.579,133.286,60.626,3.114,3.362
 2027.909,113.287,869.141,66.420,-109.176,26.306,9.799,0.014,2.603,3.484,6.281,4.900,131.555,59.403,3.289,3.473
 2028.409,113.424,869.141,59.023,-110.421,22.407,9.784,0.022,2.624,3.859,5.024,5.892,125.502,55.125,3.440,3.543
 2028.909,113.394,873.486,53.178,-111.625,17.085,9.793,0.039,2.643,4.094,3.929,5.882,121.461,52.269,3.566,3.617
 2029.409,113.496,869.141,52.142,-113.042,13.354,9.886,0.052,2.637,3.947,4.262,4.889,122.640,53.102,3.650,3.679
 2029.909,113.440,867.578,55.268,-113.691,13.525,10.093,0.049,2.607,3.603,6.048,3.879,125.803,55.338,3.640,3.687
 2030.409,113.509,862.744,58.855,-114.520,17.386,10.032,0.035,2.581,3.267,7.567,3.484,129.535,57.975,3.493,3.564
 2030.909,113.552,864.258,59.012,-114.665,21.613,9.843,0.020,2.572,3.180,8.042,3.395,131.340,59.251,3.265,3.385
 2031.409,113.401,864.258,56.057,-115.101,23.991,9.822,0.014,2.571,3.279,8.151,3.259,132.161,59.831,3.071,3.246
 2031.909,113.520,849.609,53.996,-114.650,24.763,9.802,0.013,2.560,3.331,8.754,3.041,133.650,60.884,2.970,3.192
 2032.409,113.580,864.844,54.528,-113.157,25.220,9.784,0.014,2.548,3.284,9.473,2.935,133.796,60.987,2.998,3.227
 2032.909,113.478,867.627,55.324,-110.970,25.555,9.765,0.013,2.545,3.224,9.668,3.111,131.841,59.605,3.116,3.309
 2033.409,113.445,860.205,54.331,-109.718,24.721,9.758,0.009,2.555,3.243,9.068,3.587,128.337,57.129,3.250,3.364
 2033.909,113.455,861.084,50.950,-110.842,22.215,9.759,0.004,2.570,3.430,8.211,4.280,125.278,54.966,3.325,3.365
 2034.409,113.513,859.961,47.129,-112.244,19.155,9.769,0.001,2.581,3.713,7.517,4.826,124.182,54.193,3.297,3.285
 2034.909,113.556,854.492,46.118,-114.295,16.817,9.797,0.005,2.590,3.919,7.001,4.755,125.275,54.965,3.196,3.177
 2035.409,113.332,868.115,49.484,-115.288,15.437,9.852,0.014,2.591,3.873,6.974,4.067,124.843,54.659,3.062,3.093
 2035.909,113.438,869.141,58.544,-116.004,15.727,9.965,0.021,2.579,3.595,7.678,3.135,122.367,52.910,2.917,3.020
 2036.409,113.524,869.141,69.521,-116.918,18.121,10.091,0.024,2.570,3.426,8.179,2.490,120.872,51.853,2.787,2.966
 2036.909,113.538,861.816,74.693,-118.157,22.350,10.087,0.022,2.573,3.525,7.992,2.362,121.462,52.270,2.665,2.882
 2037.409,113.523,864.258,75.568,-119.732,26.345,10.029,0.022,2.589,3.711,7.071,2.470,123.132,53.450,2.578,2.806
 2037.909,113.419,861.572,73.518,-120.284,28.602,9.991,0.026,2.609,3.766,5.912,2.626,121.681,52.425,2.558,2.787
 2038.409,113.538,855.518,66.086,-121.268,29.221,9.961,0.027,2.615,3.742,5.527,2.849,113.290,46.495,2.601,2.826
 2038.909,113.566,869.141,58.093,-120.268,28.314,9.951,0.024,2.605,3.857,6.153,3.174,100.426,37.404,2.765,2.997
 2039.409,113.417,868.555,56.232,-118.776,26.101,9.915,0.020,2.587,3.994,7.174,3.479,89.455,29.650,3.028,3.291
 2039.909,113.578,870.508,60.781,-117.098,23.296,9.869,0.018,2.571,4.043,8.130,3.912,86.178,27.334,3.469,3.778
 2040.409,113.598,872.363,66.000,-116.389,21.509,9.763,0.017,2.562,4.060,8.681,4.803,90.709,30.537,4.088,4.476
 2040.909,113.452,864.258,62.320,-115.813,20.914,9.640,0.013,2.564,4.163,8.565,6.717,93.356,32.407,4.900,5.232
 2041.409,113.432,859.375,50.666,-116.039,19.733,9.601,0.006,2.581,4.486,7.548,9.838,91.327,30.973,5.710,5.835
 2041.909,113.462,862.988,38.695,-116.278,16.508,9.608,0.000,2.605,4.753,6.144,13.108,88.165,28.738,6.106,5.872
 2042.409,113.590,867.871,33.112,-117.508,12.142,9.642,0.005,2.617,4.861,5.458,14.348,92.066,31.495,5.827,5.470
 2042.909,113.402,864.258,37.442,-117.590,8.538,9.746,0.034,2.608,4.686,5.965,12.429,104.250,40.106,5.087,4.927
 2043.409,113.543,874.023,55.551,-118.404,7.440,10.008,0.080,2.556,4.203,8.996,8.486,115.827,48.287,4.338,4.463
 2043.909,113.664,865.918,79.678,-117.930,9.651,10.462,0.121,2.469,3.638,14.110,4.833,121.565,52.342,3.744,4.165
 2044.409,113.516,859.375,98.567,-117.507,15.759,10.948,0.137,2.387,3.143,18.874,2.977,122.598,53.073,3.321,3.914
 2044.909,113.640,867.969,109.876,-116.757,24.293,11.135,0.127,2.331,2.924,22.154,2.476,123.680,53.838,3.039,3.706
 2045.409,113.572,859.375,110.761,-116.414,33.111,10.881,0.109,2.307,2.861,23.549,2.566,119.623,50.971,2.877,3.505
 2045.909,113.528,859.375,107.638,-117.584,39.044,10.689,0.095,2.324,3.003,22.578,3.016,107.504,42.406,2.847,3.396
 2046.409,113.636,864.746,100.398,-118.249,38.579,10.569,0.077,2.381,3.420,19.257,3.820,91.451,31.061,2.974,3.441
 2046.909,113.411,868.945,85.883,-118.590,33.264,10.330,0.057,2.471,3.900,13.986,4.843,78.315,21.778,3.280,3.652
 2047.409,113.640,871.582,73.418,-117.311,25.849,10.271,0.038,2.556,4.271,9.018,6.058,72.640,17.767,3.888,4.220
 2047.909,113.660,868.848,66.552,-117.107,19.564,10.247,0.024,2.601,4.350,6.370,7.650,70.329,16.133,4.828,5.149
 2048.409,113.554,859.375,61.707,-117.389,15.913,10.138,0.016,2.617,4.412,5.429,9.804,69.645,15.650,6.353,6.756
 2048.909,113.602,869.141,58.145,-118.688,13.399,10.066,0.009,2.622,4.589,5.157,11.702,71.663,17.077,8.451,8.937
 2049.409,113.567,863.281,53.585,-119.162,11.100,10.043,0.006,2.623,4.699,5.116,12.669,78.651,22.015,10.103,10.515
 2049.909,113.600,859.375,50.774,-119.985,9.319,10.013,0.007,2.625,4.709,4.947,13.135,87.863,28.525,10.691,11.010
 2050.409,113.547,862.549,51.400,-120.845,8.253,9.980,0.013,2.636,4.741,4.310,13.244,95.621,34.007,9.151,9.791
 2050.909,113.686,869.141,51.845,-122.898,7.661,9.982,0.015,2.621,4.851,5.228,12.468,99.749,36.925,7.552,8.351
 2051.409,113.721,865.771,54.060,-124.652,7.870,10.031,0.016,2.516,4.863,11.338,10.072,101.358,38.062,6.549,7.792
 2051.909,113.611,864.258,61.106,-125.245,9.474,10.206,0.022,2.348,4.343,21.177,6.864,104.694,40.420,5.847,7.358
 2052.409,113.589,857.031,69.232,-125.565,13.539,11.124,0.031,2.216,3.722,28.878,4.668,110.847,44.768,5.595,7.376
 2052.909,113.659,858.447,75.716,-124.225,19.156,11.307,0.053,2.225,3.386,28.337,4.132,116.202,48.552,5.236,6.865
 2053.409,113.414,869.141,74.702,-123.418,22.912,10.486,0.066,2.347,3.445,21.208,4.850,119.162,50.645,4.951,6.000
 2053.909,113.552,874.023,66.422,-122.436,22.865,10.551,0.064,2.480,3.846,13.469,5.905,118.092,49.888,4.794,5.538
 2054.409,113.602,865.820,59.088,-123.444,19.358,10.527,0.054,2.557,3.974,8.948,6.778,109.885,44.088,4.839,5.246
 2054.909,113.661,858.008,54.795,-123.178,15.315,10.272,0.041,2.587,3.996,7.187,7.406,97.543,35.366,5.262,5.567
 2055.409,113.761,864.258,55.449,-123.502,12.783,10.293,0.038,2.610,4.001,5.832,7.777,85.119,26.586,6.030,6.190
 2055.909,113.558,867.383,55.193,-123.526,11.354,10.268,0.032,2.616,4.071,5.501,8.123,78.376,21.821,6.941,7.032
 2056.409,113.613,869.824,51.552,-124.351,10.628,10.251,0.024,2.619,4.198,5.337,8.399,77.555,21.240,7.968,8.298
 2056.909,113.656,866.895,46.527,-125.889,10.369,10.263,0.021,2.627,4.220,4.834,8.985,77.058,20.889,8.493,9.025
 2057.409,113.740,869.043,40.708,-128.098,10.285,10.279,0.019,2.633,4.237,4.525,10.546,73.839,18.614,8.914,9.512
 2057.909,113.565,859.375,35.080,-129.445,9.920,10.291,0.019,2.640,4.318,4.069,13.084,67.595,14.201,9.236,9.328
 2058.409,113.779,854.492,27.793,-130.040,9.032,10.294,0.018,2.639,4.501,4.173,15.461,60.963,9.514,9.420,8.880
 2058.909,113.693,857.178,21.497,-132.083,8.076,10.294,0.014,2.614,4.678,5.640,16.370,57.355,6.965,9.482,8.604
 2059.409,113.722,874.023,18.979,-133.952,7.745,10.294,0.010,2.586,4.755,7.273,15.980,57.099,6.784,9.343,8.303
 2059.909,113.752,876.953,18.951,-136.643,8.175,10.287,0.004,2.560,4.744,8.758,14.894,58.019,7.434,9.105,8.191
 2060.409,113.764,864.893,21.725,-137.555,8.797,10.278,0.003,2.548,4.635,9.477,13.474,59.084,8.186,8.901,8.135
 2060.909,113.666,869.141,25.891,-136.082,9.409,10.275,0.007,2.555,4.496,9.071,11.799,60.670,9.307,8.838,8.158
 2061.409,113.682,856.982,29.668,-132.225,9.929,10.266,0.013,2.576,4.409,7.842,10.170,63.766,11.496,8.778,8.089
 2061.909,113.708,869.141,33.877,-129.621,10.063,10.271,0.019,2.607,4.346,6.009,9.192,67.529,14.155,8.540,7.678
 2062.409,113.718,869.141,38.021,-128.077,9.678,10.256,0.021,2.631,4.382,4.629,8.981,70.484,16.243,7.879,6.961
 2062.909,113.577,865.479,45.867,-127.832,8.886,10.214,0.020,2.639,4.472,4.179,8.896,71.780,17.159,6.866,6.016
 2063.409,113.712,864.258,57.949,-127.057,8.293,10.209,0.021,2.630,4.550,4.669,8.109,72.739,17.837,5.783,5.150
 2063.909,113.765,864.258,71.361,-124.672,8.522,10.239,0.036,2.622,4.455,5.147,6.460,79.664,22.731,4.816,4.407
 2064.409,113.670,867.578,87.060,-122.681,10.458,10.343,0.054,2.614,4.027,5.623,4.614,90.578,30.444,3.994,3.786
 2064.909,113.751,864.258,105.181,-119.794,15.320,10.511,0.061,2.601,3.601,6.369,3.290,99.331,36.630,3.318,3.262
 2065.409,113.693,867.871,123.316,-119.694,22.983,10.654,0.054,2.578,3.333,7.732,2.691,102.906,39.156,2.789,2.827
 2065.909,113.774,878.369,134.260,-120.169,30.707,10.743,0.056,2.541,3.293,9.886,2.446,102.057,38.556,2.397,2.500
 2066.409,113.623,876.904,132.705,-121.621,36.490,10.976,0.090,2.488,3.327,12.975,2.230,102.994,39.218,2.156,2.294
 2066.909,113.785,874.023,125.443,-121.134,40.088,11.486,0.135,2.421,3.316,16.884,2.010,106.275,41.537,2.013,2.183
 2067.409,113.817,875.879,119.359,-121.250,42.623,11.753,0.151,2.378,3.411,19.393,1.902,107.635,42.498,1.955,2.132
 2067.909,113.587,883.789,118.627,-121.941,45.589,11.515,0.133,2.377,3.433,19.462,1.958,105.770,41.180,1.940,2.118
 2068.409,113.791,864.160,123.866,-122.491,47.376,11.308,0.093,2.416,3.310,17.215,2.161,100.856,37.708,1.956,2.126
 2068.909,113.841,874.023,129.836,-121.584,47.211,11.129,0.060,2.457,3.078,14.823,2.373,95.143,33.670,2.000,2.166
 2069.409,113.636,871.289,133.345,-119.408,44.810,10.905,0.059,2.487,2.913,13.046,2.458,91.713,31.246,2.088,2.265
 2069.909,113.713,869.141,131.656,-118.712,41.546,10.868,0.075,2.502,2.879,12.151,2.467,90.046,30.068,2.214,2.398
 2070.409,113.663,869.141,127.920,-118.242,38.587,10.927,0.085,2.508,2.842,11.820,2.517,89.480,29.668,2.373,2.573
 2070.909,113.755,872.754,127.607,-118.898,35.724,10.891,0.083,2.514,2.779,11.446,2.632,89.295,29.537,2.519,2.721
 2071.409,113.859,867.432,131.096,-118.388,33.507,10.778,0.060,2.508,2.693,11.833,2.763,89.026,29.347,2.619,2.813
 2071.909,113.840,869.141,132.082,-118.598,33.269,10.713,0.038,2.507,2.669,11.860,2.827,88.867,29.234,2.656,2.822
 2072.409,113.745,858.887,127.006,-119.053,35.338,10.688,0.023,2.511,2.693,11.631,2.823,89.226,29.488,2.613,2.733
 2072.909,113.751,864.258,118.994,-119.441,37.591,10.697,0.013,2.517,2.845,11.299,2.783,91.258,30.924,2.505,2.598
 2073.409,113.781,860.596,117.386,-120.761,37.836,10.704,0.019,2.522,3.052,10.974,2.680,94.361,33.118,2.355,2.458
 2073.909,113.765,871.777,124.947,-120.797,35.949,10.764,0.046,2.508,3.225,11.833,2.483,96.736,34.796,2.213,2.376
 2074.409,113.729,878.906,131.434,-120.582,34.362,10.891,0.096,2.471,3.309,13.980,2.218,97.878,35.603,2.121,2.374
 2074.909,113.729,880.664,131.044,-119.659,35.635,11.128,0.150,2.406,3.252,17.786,2.000,98.555,36.081,2.102,2.451
 2075.409,113.712,874.023,121.649,-119.462,39.281,11.222,0.184,2.330,3.080,22.250,1.938,100.043,37.133,2.164,2.596
 2075.909,113.838,859.375,112.381,-119.699,42.606,11.188,0.173,2.277,2.832,25.299,2.188,100.994,37.805,2.291,2.766
 2076.409,113.929,872.412,104.659,-120.831,43.284,11.268,0.125,2.286,2.786,24.778,2.884,98.690,36.177,2.480,2.963
 2076.909,113.695,866.309,91.673,-121.733,39.522,10.917,0.069,2.373,3.020,19.726,4.078,90.902,30.673,2.752,3.196
 2077.409,113.761,869.141,74.535,-123.013,32.685,10.505,0.024,2.478,3.423,13.571,5.373,80.493,23.317,3.120,3.516
 2077.909,113.827,874.023,59.032,-122.050,24.653,10.428,0.005,2.557,3.865,8.963,6.320,70.863,16.511,3.709,4.036
 2078.409,113.715,864.355,50.013,-121.875,17.538,10.376,0.005,2.602,4.117,6.307,6.798,64.929,12.317,4.496,4.801
 2078.909,113.756,874.219,45.572,-121.680,13.243,10.301,0.008,2.619,4.204,5.300,6.838,63.233,11.119,5.564,5.905
 2079.409,113.653,878.516,43.050,-124.091,11.302,10.174,0.005,2.623,4.118,5.070,6.873,62.372,10.510,6.659,7.270
 2079.909,113.929,869.141,40.892,-126.064,11.210,10.102,-0.003,2.612,3.934,5.705,7.836,61.512,9.902,7.587,8.553
 2080.409,113.903,874.023,39.489,-128.188,11.958,10.009,-0.008,2.593,3.911,6.841,10.194,62.370,10.509,8.222,9.495
 2080.909,113.879,874.023,38.135,-129.737,12.542,9.871,-0.009,2.578,4.061,7.703,14.059,67.154,13.889,8.771,9.749
 2081.409,113.730,875.293,34.461,-131.221,12.066,9.789,-0.006,2.580,4.330,7.628,17.923,77.001,20.849,9.402,9.723
 2081.909,113.802,877.344,29.728,-131.786,10.278,9.736,-0.003,2.591,4.533,6.979,20.009,92.769,31.992,10.178,9.741
 2082.409,113.809,870.020,28.508,-131.596,8.095,9.680,-0.001,2.614,4.609,5.637,19.842,106.891,41.972,10.944,9.942
 2082.909,113.845,874.023,33.523,-130.398,6.496,9.652,0.002,2.641,4.525,4.055,18.059,114.366,47.255,11.393,10.300
 2083.409,113.801,874.023,40.290,-128.283,5.671,9.645,0.004,2.655,4.372,3.235,16.490,113.737,46.811,11.410,10.613
 2083.909,113.794,881.348,44.440,-126.862,5.321,9.644,0.008,2.656,4.354,3.149,15.307,108.559,43.151,11.442,11.094
 2084.409,113.866,883.789,48.627,-125.580,5.291,9.644,0.023,2.647,4.350,3.682,13.652,104.350,40.176,11.675,11.971
 2084.909,113.946,872.070,53.608,-127.128,5.892,9.659,0.046,2.643,4.299,3.942,11.766,102.187,38.648,12.724,13.457
 2085.409,113.940,878.906,56.295,-129.428,7.500,9.681,0.059,2.652,4.146,3.365,11.399,103.327,39.454,14.294,15.172
 2085.909,113.834,883.057,52.749,-132.306,9.184,9.609,0.050,2.662,4.050,2.786,13.465,107.687,42.535,14.994,14.495
 2086.409,113.904,878.369,43.346,-132.762,9.365,9.506,0.025,2.666,4.191,2.565,16.245,113.773,46.836,13.043,11.352
 2086.909,113.938,869.141,36.755,-132.149,7.852,9.481,0.005,2.660,4.415,2.947,16.869,120.928,51.893,9.248,7.963
 2087.409,113.843,878.906,41.524,-132.631,6.012,9.479,0.006,2.616,4.610,5.521,13.870,129.747,58.125,6.380,5.926
 2087.909,113.842,874.268,55.409,-132.473,5.501,9.480,0.034,2.526,4.514,10.743,9.239,139.366,64.923,4.555,4.847
 2088.409,113.879,876.318,76.976,-132.790,7.801,9.686,0.078,2.394,3.888,18.468,5.325,147.420,70.615,3.639,4.394
 2088.909,113.884,869.238,98.529,-131.559,13.961,10.153,0.116,2.273,3.092,25.540,3.031,152.179,73.978,3.134,4.257
 2089.409,113.823,869.141,109.256,-130.969,25.906,10.337,0.121,2.205,2.541,29.519,2.367,147.506,70.676,2.913,4.177
 2089.909,113.736,873.828,109.781,-130.757,40.086,10.371,0.102,2.194,2.416,30.203,2.364,135.192,61.973,2.829,4.053
 2090.409,113.919,869.141,103.523,-129.995,48.720,10.832,0.081,2.264,2.648,26.082,3.294,117.634,49.564,2.871,3.907
 2090.909,113.876,869.141,97.003,-129.654,47.022,10.390,0.059,2.374,3.111,19.664,5.591,101.918,38.458,3.031,3.824
 2091.409,113.875,872.119,87.753,-128.333,35.167,9.412,0.039,2.497,3.634,12.441,9.187,96.248,34.451,3.426,4.019
 2091.909,113.907,864.258,75.965,-126.413,21.203,9.185,0.018,2.572,4.011,8.054,12.703,99.158,36.508,4.192,4.577
 2092.409,114.000,864.258,62.287,-124.580,11.522,9.151,0.008,2.583,4.170,7.439,14.726,107.062,42.094,5.668,5.859
 2092.909,113.931,874.023,52.549,-123.500,6.522,9.124,0.011,2.578,4.211,7.721,15.074,112.929,46.239,8.193,8.215
 2093.409,113.804,863.623,50.058,-122.904,4.914,9.109,0.018,2.574,4.270,7.950,14.357,113.905,46.929,11.446,11.798
 2093.909,113.911,860.498,52.578,-121.976,4.701,9.107,0.026,2.580,4.329,7.577,13.456,110.640,44.622,13.505,15.148
 2094.409,113.930,864.258,56.670,-120.845,5.003,9.107,0.036,2.591,4.360,6.971,12.635,105.302,40.849,13.131,15.836
 2094.909,113.756,874.023,58.160,-118.807,5.368,9.107,0.046,2.599,4.328,6.502,11.721,102.794,39.077,11.743,14.134
 2095.409,113.866,870.068,61.635,-117.723,5.737,9.107,0.056,2.604,4.224,6.209,10.553,104.164,40.046,10.723,12.089
 2095.909,113.799,877.295,67.719,-117.020,6.319,9.103,0.060,2.606,4.037,6.079,9.469,108.390,43.032,10.131,10.721
 2096.409,113.951,874.023,71.964,-117.278,7.168,9.080,0.057,2.606,3.920,6.100,8.890,112.684,46.066,9.722,9.878
 2096.909,113.985,870.313,69.601,-117.941,8.062,9.037,0.054,2.608,3.978,5.941,8.945,114.281,47.195,9.372,9.359
 2097.409,113.916,864.258,63.621,-117.468,8.726,9.009,0.052,2.608,4.073,5.970,9.124,114.463,47.323,9.001,8.960
 2097.909,113.913,872.656,61.656,-117.173,9.009,8.996,0.055,2.606,4.084,6.067,8.996,114.621,47.436,8.697,8.636
 2098.409,113.934,879.150,64.732,-116.384,9.120,8.982,0.059,2.606,4.059,6.056,8.672,114.780,47.547,8.413,8.380
 2098.909,113.984,883.789,68.201,-115.637,9.239,8.964,0.058,2.607,4.021,6.007,8.368,114.689,47.483,8.142,8.159
 2099.409,113.952,883.789,71.166,-114.834,9.432,8.939,0.056,2.608,3.964,5.977,8.085,114.355,47.248,7.879,7.973
 2099.909,113.898,871.680,79.676,-114.447,9.819,8.919,0.056,2.603,3.817,6.241,7.784,113.918,46.939,7.642,7.828
 2100.409,113.877,864.258,88.267,-113.940,10.318,8.897,0.053,2.592,3.715,6.899,7.541,113.820,46.869,7.446,7.707
 2100.909,113.853,867.041,90.667,-114.004,10.869,8.869,0.048,2.570,3.783,8.199,7.371,114.183,47.126,7.288,7.598
 2101.409,113.900,874.463,86.382,-114.391,11.203,8.851,0.044,2.549,4.018,9.413,7.298,114.791,47.555,7.165,7.472
 2101.909,114.048,878.906,76.419,-115.081,11.172,8.839,0.047,2.545,4.264,9.636,7.253,115.683,48.186,7.068,7.372
 2102.409,113.801,874.023,69.502,-116.523,11.194,8.830,0.051,2.549,4.294,9.428,7.195,117.645,49.572,6.989,7.298
 2102.909,113.972,874.023,66.101,-117.512,11.441,8.824,0.053,2.553,4.152,9.160,7.145,121.594,52.363,6.936,7.284
 2103.409,114.079,871.240,64.283,-117.380,11.691,8.821,0.053,2.558,3.989,8.911,7.065,124.995,54.767,6.920,7.308
 2103.909,113.877,866.309,65.104,-116.576,11.691,8.816,0.052,2.561,3.965,8.738,6.993,125.468,55.101,6.922,7.341
 2104.409,113.894,874.023,64.868,-115.732,11.514,8.812,0.054,2.572,4.011,8.089,7.008,123.073,53.408,6.944,7.358
 2104.909,113.943,881.445,62.193,-115.971,11.467,8.810,0.053,2.583,4.045,7.422,7.156,119.685,51.014,6.942,7.327
 2105.409,114.096,872.607,59.600,-117.157,11.564,8.808,0.051,2.589,4.033,7.090,7.337,119.286,50.732,6.946,7.283
 2105.909,113.947,873.096,60.453,-118.439,11.483,8.807,0.049,2.591,3.988,6.973,7.386,121.927,52.598,6.932,7.257
 2106.409,114.044,870.801,63.585,-119.147,11.114,8.807,0.046,2.583,3.981,7.429,7.284,123.895,53.990,6.927,7.263
 2106.909,113.932,872.656,63.644,-119.263,10.703,8.806,0.044,2.575,3.994,7.904,7.146,123.863,53.967,6.930,7.298
 2107.409,113.914,869.141,61.216,-119.066,10.579,8.808,0.041,2.566,3.970,8.419,7.126,121.522,52.312,6.911,7.297
 2107.909,114.068,886.914,58.245,-118.373,10.684,8.812,0.039,2.555,3.944,9.040,7.192,118.769,50.367,6.901,7.284
 2108.409,114.050,877.490,58.542,-117.794,10.936,8.820,0.044,2.550,3.846,9.384,7.145,118.035,49.848,6.866,7.250
 2108.909,113.998,869.141,62.485,-117.100,11.286,8.858,0.053,2.553,3.754,9.183,7.014,118.007,49.828,6.851,7.223
 2109.409,113.939,876.563,64.662,-117.996,11.708,8.935,0.061,2.577,3.861,7.785,6.899,118.107,49.899,6.834,7.215
 2109.909,114.026,869.141,65.911,-119.440,12.140,9.002,0.056,2.598,4.030,6.521,6.896,118.347,50.069,6.829,7.189
 2110.409,114.010,874.316,64.042,-120.609,12.423,9.033,0.036,2.605,4.234,6.139,7.069,118.487,50.168,6.815,7.163
 2110.909,113.963,883.057,61.918,-121.897,12.522,9.041,0.015,2.605,4.336,6.159,7.232,118.678,50.303,6.802,7.129
 2111.409,114.064,869.141,62.193,-122.148,12.241,9.044,0.004,2.603,4.341,6.239,7.310,118.530,50.198,6.804,7.116
 2111.909,114.046,874.023,60.056,-122.238,11.695,9.049,0.001,2.608,4.314,5.978,7.289,117.937,49.779,6.835,7.139
 2112.409,114.081,870.996,56.914,-121.176,11.275,9.058,0.003,2.616,4.200,5.520,7.194,117.215,49.269,6.893,7.176
 2112.909,114.037,870.605,53.670,-120.515,11.275,9.072,0.004,2.618,4.129,5.406,7.151,116.599,48.833,6.962,7.216
 2113.409,114.014,875.635,52.835,-120.078,11.709,9.091,0.003,2.607,4.129,6.028,7.234,115.029,47.723,7.007,7.225
 2113.909,114.144,870.996,54.018,-119.929,11.920,9.110,-0.001,2.589,4.127,7.072,7.381,112.426,45.884,7.026,7.206
 2114.409,114.095,878.906,53.964,-120.628,11.462,9.131,-0.005,2.574,4.077,7.924,7.474,109.595,43.883,7.022,7.175
 2114.909,113.992,871.484,55.614,-120.856,10.718,9.157,-0.006,2.572,4.031,8.066,7.425,107.567,42.450,7.042,7.160
 2115.409,114.133,871.387,59.689,-120.941,10.175,9.185,-0.005,2.581,4.000,7.571,7.302,107.100,42.120,7.093,7.176
 2115.909,114.093,870.557,63.341,-120.821,10.180,9.214,-0.003,2.592,4.026,6.894,7.242,106.702,41.839,7.203,7.223
 2116.409,114.069,874.023,64.330,-121.355,10.502,9.253,-0.002,2.598,4.052,6.567,7.302,102.267,38.705,7.331,7.274
 2116.909,114.063,874.023,63.506,-122.085,10.648,9.297,-0.004,2.596,4.010,6.687,7.589,93.470,32.487,7.460,7.281
 2117.409,113.915,865.625,59.961,-122.501,10.415,9.332,-0.007,2.591,3.972,6.963,8.049,83.993,25.790,7.546,7.230
 2117.909,114.120,874.023,57.208,-122.731,9.917,9.362,-0.009,2.591,3.954,6.956,8.457,77.732,21.365,7.587,7.123
 2118.409,113.916,874.023,55.326,-123.505,9.494,9.398,-0.007,2.598,3.999,6.524,8.639,75.997,20.139,7.613,7.000
 2118.909,114.121,871.240,55.221,-124.601,9.307,9.445,-0.005,2.606,4.144,6.105,8.514,75.500,19.788,7.619,6.875
 2119.409,114.123,883.398,60.120,-126.491,9.329,9.497,-0.004,2.606,4.278,6.080,8.305,73.808,18.592,7.610,6.716
 2119.909,114.078,886.133,66.971,-128.265,9.486,9.553,-0.003,2.609,4.348,5.882,8.310,70.785,16.456,7.544,6.495
 2120.409,114.056,878.955,70.586,-130.483,9.607,9.613,0.000,2.615,4.391,5.567,8.427,67.489,14.127,7.435,6.198
 2120.909,114.146,878.613,68.954,-132.922,9.509,9.679,0.002,2.616,4.367,5.522,8.549,65.103,12.440,7.235,5.824
 2121.409,114.190,873.779,64.161,-136.344,9.316,9.743,0.003,2.605,4.296,6.157,8.943,63.879,11.575,6.976,5.401
 2121.909,114.200,880.469,56.462,-140.484,9.312,9.798,0.004,2.575,4.228,7.922,9.718,63.109,11.031,6.613,4.952
 2122.409,113.928,883.789,48.042,-145.039,9.616,9.861,0.011,2.540,4.258,9.960,10.403,63.083,11.013,6.193,4.503
 2122.909,114.104,880.713,37.072,-150.036,10.635,9.939,0.026,2.510,4.384,11.724,10.538,64.556,12.054,5.747,4.101
 2123.409,114.123,869.141,28.498,-153.009,12.555,10.014,0.040,2.487,4.549,13.026,9.904,67.019,13.795,5.292,3.743
 2123.909,114.096,869.141,27.057,-154.113,15.034,10.098,0.044,2.468,4.686,14.154,8.905,69.599,15.618,4.865,3.438
 2124.409,114.139,858.398,28.247,-154.863,17.494,10.195,0.038,2.448,4.740,15.329,8.023,71.509,16.968,4.457,3.173
 2124.909,114.102,868.555,29.014,-156.265,19.101,10.287,0.030,2.427,4.748,16.541,7.335,72.508,17.674,4.107,2.950
 2125.409,114.156,874.023,29.847,-157.835,19.912,10.392,0.027,2.412,4.658,17.409,6.864,73.002,18.023,3.810,2.773
 2125.909,114.175,877.783,32.994,-159.072,20.690,10.463,0.029,2.408,4.483,17.647,6.531,73.366,18.280,3.591,2.639
 2126.409,114.073,869.141,38.784,-160.500,21.559,10.435,0.029,2.407,4.320,17.738,6.257,73.584,18.434,3.432,2.544
 2126.909,114.167,877.148,46.340,-162.314,22.435,10.393,0.024,2.404,4.177,17.923,6.126,73.467,18.351,3.326,2.478
 2127.409,114.151,870.801,52.544,-164.961,22.960,10.405,0.017,2.395,4.114,18.413,6.247,73.100,18.092,3.263,2.442
 2127.909,114.113,874.023,56.319,-166.721,23.044,10.421,0.013,2.388,4.161,18.824,6.508,72.705,17.813,3.233,2.436
 2128.409,114.045,875.928,55.422,-166.971,22.691,10.431,0.016,2.392,4.190,18.569,6.763,72.524,17.685,3.246,2.465
 2128.909,113.961,883.350,50.052,-165.721,21.937,10.438,0.020,2.400,4.193,18.149,6.871,72.499,17.667,3.299,2.524
 2129.409,114.117,874.023,43.013,-165.616,21.107,10.441,0.023,2.405,4.096,17.826,6.922,72.194,17.451,3.399,2.611
 2129.909,114.112,878.711,36.738,-164.597,20.814,10.442,0.025,2.413,3.990,17.385,7.113,71.415,16.901,3.534,2.714
 2130.409,114.090,871.631,32.665,-164.815,21.280,10.440,0.025,2.418,4.030,17.077,7.484,70.248,16.077,3.699,2.834
 2130.909,114.127,869.141,30.305,-164.014,21.765,10.420,0.026,2.423,4.101,16.812,7.984,69.066,15.241,3.877,2.963
 2131.409,114.091,869.141,30.108,-163.158,21.664,10.374,0.028,2.426,4.104,16.582,8.690,68.063,14.532,4.063,3.109
 2131.909,114.123,888.672,29.379,-162.027,20.819,10.347,0.030,2.431,4.016,16.333,9.456,67.196,13.919,4.267,3.272
 2132.409,114.084,877.344,28.849,-160.278,19.205,10.347,0.035,2.439,3.937,15.856,9.903,66.670,13.548,4.488,3.447
 2132.909,114.191,878.369,30.403,-158.592,17.722,10.347,0.040,2.442,3.956,15.657,9.886,66.511,13.436,4.750,3.629
 2133.409,114.113,874.023,33.661,-156.370,17.243,10.356,0.044,2.435,4.007,16.094,9.692,66.805,13.643,5.014,3.819
 2133.909,114.042,874.023,36.851,-154.056,17.584,10.373,0.049,2.436,4.001,16.039,9.775,67.404,14.066,5.218,3.976
 2134.409,114.080,883.984,37.218,-150.894,18.230,10.422,0.050,2.446,4.005,15.456,10.219,68.019,14.501,5.335,4.121
 2134.909,114.267,886.719,34.515,-148.158,18.435,10.489,0.045,2.459,4.053,14.706,10.646,68.137,14.584,5.343,4.231
 2135.409,114.260,875.342,32.410,-146.253,17.939,10.554,0.039,2.468,4.218,14.136,10.438,67.988,14.479,5.356,4.361
 2135.909,114.098,874.023,36.366,-145.409,17.157,10.622,0.046,2.478,4.341,13.593,9.254,68.858,15.094,5.441,4.566
 2136.409,114.138,870.264,44.929,-143.654,16.371,10.692,0.069,2.494,4.123,12.606,7.729,69.918,15.843,5.605,4.811
 2136.909,114.133,874.023,49.820,-141.619,16.269,10.754,0.077,2.501,3.822,12.251,7.311,69.877,15.814,5.820,5.098
 2137.409,114.188,874.023,47.430,-139.374,17.050,10.776,0.064,2.505,3.769,12.000,8.489,67.993,14.483,5.989,5.294
 2137.909,114.203,877.441,40.327,-138.686,17.593,10.765,0.043,2.513,3.965,11.492,10.411,65.323,12.596,6.111,5.403
 2138.409,114.046,883.789,34.554,-137.032,17.117,10.727,0.032,2.524,4.182,10.887,11.559,64.585,12.074,6.238,5.492
 2138.909,114.226,883.789,34.784,-135.477,15.874,10.665,0.035,2.536,4.162,10.193,10.987,66.264,13.261,6.329,5.519
 2139.409,114.211,874.805,39.062,-131.918,14.840,10.580,0.035,2.533,3.959,10.372,9.625,68.213,14.639,6.264,5.436
 2139.909,114.212,885.938,42.525,-129.672,14.619,10.511,0.034,2.527,3.835,10.692,8.328,69.048,15.228,5.877,5.137
 2140.409,114.224,888.672,46.387,-127.175,14.638,10.483,0.046,2.527,3.732,10.686,7.218,69.858,15.801,5.217,4.695
 2140.909,114.098,883.789,56.039,-124.347,14.543,10.507,0.068,2.523,3.560,10.913,6.167,72.745,17.841,4.527,4.263
 2141.409,114.158,878.906,70.679,-122.164,15.322,10.591,0.089,2.518,3.327,11.208,4.893,78.176,21.680,3.926,3.871
 2141.909,114.140,881.543,91.021,-119.248,18.787,10.669,0.097,2.508,3.008,11.803,3.786,84.214,25.946,3.480,3.533
 2142.409,114.207,883.789,109.238,-116.846,23.930,10.689,0.094,2.504,2.811,12.051,3.235,88.788,29.179,3.140,3.243
 2142.909,114.277,883.789,116.600,-115.499,28.686,10.680,0.090,2.515,2.748,11.423,3.094,91.973,31.430,2.897,3.013
 2143.409,114.167,884.863,118.987,-115.446,31.442,10.690,0.085,2.525,2.773,10.830,3.029,94.663,33.330,2.721,2.846
 2143.909,114.108,887.402,115.551,-115.508,31.968,10.731,0.071,2.522,2.806,11.000,2.996,96.032,34.298,2.618,2.749
 2144.409,114.205,874.023,112.935,-116.116,31.473,10.784,0.051,2.515,2.832,11.382,3.009,95.766,34.110,2.568,2.699
 2144.909,114.099,877.344,113.939,-116.620,30.788,10.847,0.038,2.521,2.894,11.032,3.061,94.019,32.876,2.564,2.696
 2145.409,114.226,887.646,112.601,-117.151,30.609,10.891,0.034,2.536,2.927,10.174,3.115,91.905,31.382,2.590,2.727
 2145.909,114.083,883.789,108.583,-117.548,31.023,10.891,0.034,2.540,2.952,9.938,3.131,90.911,30.679,2.633,2.787
 2146.409,114.200,892.334,109.544,-117.958,31.622,10.878,0.034,2.531,2.984,10.471,3.128,90.592,30.454,2.684,2.854
 2146.909,114.314,888.672,113.691,-118.838,32.055,10.876,0.034,2.523,3.068,10.912,3.169,90.379,30.303,2.732,2.912
 2147.409,114.179,887.207,113.973,-119.361,31.611,10.849,0.032,2.525,3.159,10.838,3.269,89.890,29.957,2.767,2.941
 2147.909,114.188,875.684,109.487,-119.059,30.096,10.800,0.028,2.533,3.223,10.346,3.378,89.064,29.374,2.777,2.943
 2148.409,114.243,883.789,104.246,-118.130,27.667,10.763,0.026,2.545,3.205,9.653,3.404,88.439,28.932,2.774,2.934
 2148.909,114.173,879.541,104.390,-116.781,25.644,10.742,0.026,2.559,3.117,8.838,3.338,88.381,28.892,2.763,2.916
 2149.409,114.190,882.813,106.537,-116.119,25.988,10.740,0.024,2.566,3.017,8.400,3.237,88.988,29.320,2.750,2.892
 2149.909,114.133,888.672,110.190,-115.587,28.048,10.715,0.017,2.563,2.911,8.583,3.165,89.796,29.891,2.730,2.855
 2150.409,114.232,882.080,113.999,-115.614,30.476,10.643,0.012,2.557,2.833,8.924,3.136,91.851,31.343,2.688,2.810
 2150.909,114.297,874.023,118.022,-116.028,32.915,10.584,0.007,2.550,2.810,9.385,3.137,95.321,33.796,2.639,2.779
 2151.409,114.246,876.416,120.762,-115.454,34.984,10.562,0.003,2.539,2.853,10.006,3.154,99.077,36.450,2.602,2.774
 2151.909,114.319,888.770,121.950,-114.590,35.779,10.555,0.004,2.525,3.009,10.800,3.163,102.170,38.636,2.607,2.820
 2152.409,114.247,890.918,121.586,-115.484,34.836,10.540,0.027,2.515,3.202,11.384,3.137,102.864,39.127,2.683,2.934
 2152.909,114.137,888.672,118.991,-116.463,33.807,10.503,0.061,2.506,3.209,11.927,3.142,100.770,37.647,2.835,3.119
 2153.409,114.191,891.553,114.456,-118.233,34.601,10.449,0.078,2.492,3.120,12.775,3.408,97.009,34.989,3.053,3.354
 2153.909,114.296,878.906,106.721,-118.952,35.387,10.375,0.067,2.493,3.121,12.716,4.197,92.765,31.989,3.297,3.565
 2154.409,114.328,878.906,93.801,-118.242,32.811,10.273,0.041,2.532,3.390,10.401,5.420,89.869,29.942,3.516,3.699
 2154.909,114.185,879.688,78.401,-117.943,26.717,10.115,0.027,2.591,3.704,6.973,6.394,90.930,30.693,3.668,3.747
 2155.409,114.200,883.789,64.419,-118.947,19.868,10.030,0.025,2.622,3.871,5.119,6.526,94.390,33.138,3.747,3.761
 2155.909,114.229,883.789,65.155,-120.010,16.074,10.009,0.030,2.613,3.790,5.668,5.780,97.380,35.251,3.726,3.748
 2156.409,114.317,876.660,79.591,-120.817,16.032,10.020,0.037,2.580,3.476,7.583,4.728,97.601,35.407,3.622,3.697
 2156.909,114.187,875.293,97.144,-120.709,18.689,10.075,0.046,2.557,3.197,8.945,3.922,94.481,33.202,3.407,3.577
 2157.409,114.244,882.715,110.940,-121.515,22.456,10.168,0.056,2.537,3.035,10.137,3.483,91.732,31.259,3.154,3.391
 2157.909,114.257,883.789,112.595,-123.233,25.807,10.360,0.077,2.499,3.023,12.356,3.245,90.704,30.533,2.926,3.220
 2158.409,114.196,883.789,110.785,-124.487,28.162,10.474,0.105,2.452,2.965,15.065,3.062,90.824,30.618,2.771,3.094
 2158.909,114.240,883.545,112.049,-125.185,30.555,10.560,0.123,2.412,2.841,17.401,2.936,91.763,31.281,2.730,3.083
 2159.409,114.286,874.023,114.782,-125.512,34.222,10.493,0.130,2.398,2.737,18.274,2.905,91.592,31.161,2.781,3.166
 2159.909,114.300,874.023,111.179,-127.617,38.674,10.360,0.125,2.416,2.751,17.192,3.200,89.131,29.422,2.942,3.342
 2160.409,114.352,869.482,95.379,-130.334,40.890,10.367,0.110,2.452,3.058,15.099,4.018,84.388,26.069,3.195,3.632
 2160.909,114.225,874.023,74.457,-134.465,37.556,9.997,0.084,2.484,3.628,13.211,5.399,78.122,21.641,3.526,3.929
 2161.409,114.319,874.023,59.216,-138.272,30.944,9.572,0.054,2.493,4.167,12.696,7.430,72.130,17.406,3.950,4.312
 2161.909,114.165,886.230,52.881,-141.055,24.192,9.464,0.033,2.483,4.408,13.279,10.181,67.408,14.069,4.395,4.663
 2162.409,114.307,888.574,50.707,-140.750,19.494,9.389,0.023,2.480,4.506,13.478,12.077,64.006,11.665,4.866,5.021
 2162.909,114.292,878.418,49.707,-139.932,16.568,9.344,0.031,2.483,4.680,13.294,11.350,63.728,11.468,5.248,5.453
 2163.409,114.335,874.023,50.680,-139.048,14.184,9.376,0.059,2.490,4.605,12.866,8.721,66.522,13.443,5.484,5.775
 2163.909,114.287,876.904,58.246,-139.877,13.336,9.521,0.083,2.493,4.246,12.686,5.942,70.957,16.578,5.569,6.180
 2164.409,114.173,878.906,64.488,-141.045,14.602,9.461,0.081,2.508,3.818,11.788,5.004,72.878,17.935,5.515,6.322
 2164.909,114.341,878.906,62.487,-141.784,16.709,9.285,0.049,2.538,3.748,10.040,5.915,70.076,15.955,5.448,6.240
 2165.409,114.390,880.566,53.059,-142.754,17.274,9.190,0.017,2.567,3.944,8.373,7.142,65.326,12.598,5.508,6.164
 2165.909,114.292,878.564,40.848,-142.992,15.151,9.113,0.003,2.587,4.107,7.221,8.251,61.395,9.820,5.786,6.191
 2166.409,114.248,874.023,33.585,-142.818,11.812,9.102,0.002,2.609,4.320,5.915,9.871,60.207,8.980,6.366,6.576
 2166.909,114.285,877.637,29.962,-140.646,9.036,9.101,0.006,2.634,4.466,4.438,12.967,61.459,9.865,7.290,7.113
 2167.409,114.272,878.906,27.863,-138.335,7.277,9.102,0.007,2.648,4.537,3.640,16.045,62.618,10.684,8.227,7.716
 2167.909,114.267,882.764,27.092,-136.050,6.124,9.104,0.009,2.651,4.467,3.442,16.912,62.993,10.949,9.020,8.274
 2168.409,114.307,874.365,29.832,-134.728,5.557,9.110,0.009,2.643,4.386,3.906,14.926,64.093,11.726,9.116,8.523
 2168.909,114.326,860.205,34.469,-133.325,5.755,9.115,0.014,2.647,4.385,3.708,11.855,66.694,13.565,8.762,8.371
 2169.409,114.377,866.406,39.368,-132.922,6.623,9.116,0.022,2.651,4.560,3.460,9.840,71.920,17.258,8.113,7.794
 2169.909,114.329,878.906,45.924,-132.196,7.671,9.125,0.036,2.652,4.578,3.385,8.459,80.755,23.502,7.344,6.950
 2170.409,114.279,883.789,59.501,-132.435,8.740,9.180,0.050,2.643,4.253,3.927,7.097,89.371,29.591,6.539,6.045
 2170.909,114.192,874.707,76.359,-132.344,10.216,9.248,0.054,2.623,3.945,5.090,5.939,94.356,33.114,5.695,5.237
 2171.409,114.322,870.850,83.282,-132.278,12.327,9.265,0.052,2.620,3.888,5.260,5.336,93.595,32.576,4.883,4.561
 2171.909,114.414,878.906,78.615,-131.611,14.387,9.279,0.043,2.622,4.116,5.167,4.996,89.805,29.898,4.213,4.093
 2172.409,114.330,876.465,66.646,-130.900,15.655,9.323,0.038,2.621,4.244,5.218,4.431,87.599,28.339,3.793,3.831
 2172.909,114.418,874.463,59.036,-130.223,16.666,9.351,0.042,2.591,4.121,6.965,3.743,86.599,27.632,3.550,3.693
 2173.409,114.272,888.672,65.069,-129.646,18.865,9.360,0.075,2.509,3.910,11.765,3.257,87.616,28.351,3.530,3.674
 2173.909,114.361,878.906,78.863,-129.305,23.235,9.480,0.117,2.394,3.547,18.474,3.171,89.308,29.547,3.566,3.642
 2174.409,114.338,878.906,90.810,-129.907,29.387,9.784,0.127,2.328,3.190,22.363,4.417,88.550,29.010,3.639,3.554
 2174.909,114.216,878.906,88.362,-132.666,33.422,9.703,0.095,2.364,3.058,20.253,7.127,82.296,24.591,3.604,3.364
 2175.409,114.363,878.906,71.999,-137.681,31.669,9.245,0.041,2.479,3.283,13.498,9.951,73.123,18.108,3.465,3.079
 2175.909,114.415,874.023,56.104,-143.896,25.542,9.115,0.012,2.583,3.667,7.405,11.081,67.155,13.890,3.296,2.834
 2176.409,114.217,877.393,52.823,-148.809,19.086,9.198,0.016,2.609,3.898,5.932,9.933,66.123,13.161,3.122,2.616
 2176.909,114.380,882.715,61.533,-152.398,16.204,9.307,0.024,2.577,4.056,7.786,7.939,67.482,14.122,2.952,2.432
 2177.409,114.367,878.906,70.572,-154.801,16.795,9.393,0.026,2.537,4.128,10.104,6.527,68.859,15.095,2.741,2.249
 2177.909,114.253,882.471,77.574,-156.740,18.082,9.458,0.022,2.502,4.145,12.136,5.772,72.132,17.408,2.483,2.054
 2178.409,114.327,867.334,79.912,-157.811,18.927,9.505,0.013,2.478,4.039,13.544,5.314,79.101,22.333,2.225,1.889
 2178.909,114.412,868.799,75.865,-156.982,19.153,9.525,0.005,2.471,3.925,13.979,4.993,87.792,28.475,2.003,1.760
 2179.409,114.390,878.906,67.109,-154.284,18.863,9.539,-0.001,2.475,3.944,13.723,4.541,94.339,33.102,1.860,1.697
 2179.909,114.434,869.141,59.083,-150.261,18.445,9.564,0.002,2.491,3.887,12.827,3.731,98.525,36.060,1.796,1.700
 2180.409,114.376,869.141,59.023,-144.087,18.374,9.603,0.012,2.502,3.726,12.152,2.796,104.459,40.254,1.795,1.747
 2180.909,114.396,871.143,67.505,-137.385,20.330,9.662,0.038,2.506,3.522,11.957,2.143,109.957,44.139,1.836,1.829
 2181.409,114.369,874.023,79.071,-131.661,24.294,9.780,0.074,2.500,3.262,12.264,1.951,111.026,44.894,1.882,1.900
 2181.909,114.476,878.516,84.202,-128.665,29.024,10.203,0.090,2.495,3.123,12.545,2.116,106.563,41.741,1.931,1.972
 2182.409,114.354,874.219,84.362,-127.165,33.046,10.322,0.080,2.496,3.085,12.525,2.263,99.958,37.073,1.970,2.020
 2182.909,114.431,883.789,80.647,-126.326,34.281,10.101,0.064,2.486,3.149,13.074,2.253,95.397,33.849,2.008,2.040
 2183.409,114.325,874.316,75.957,-127.115,33.665,10.190,0.074,2.452,3.213,15.084,2.116,91.410,31.032,2.044,2.052
 2183.909,114.331,881.104,74.141,-129.694,32.682,10.505,0.103,2.401,3.038,18.081,1.976,86.566,27.608,2.061,2.045
 2184.409,114.525,878.516,68.136,-134.331,32.973,10.907,0.105,2.367,2.940,20.086,2.037,81.440,23.986,2.059,2.051
 2184.909,114.555,874.023,55.960,-138.634,34.244,10.492,0.068,2.383,3.170,19.103,2.396,76.348,20.388,2.045,2.054
 2185.409,114.496,878.906,41.808,-142.482,33.684,9.908,0.025,2.437,3.543,15.970,2.960,71.445,16.923,2.036,2.047
 2185.909,114.373,875.732,33.103,-144.267,30.640,9.896,0.004,2.479,3.779,13.484,3.405,68.582,14.899,2.080,2.064
 2186.409,114.554,882.959,35.302,-144.875,26.378,9.900,0.013,2.487,3.712,13.016,3.431,69.009,15.201,2.174,2.103
 2186.909,114.452,875.488,48.936,-145.949,23.008,9.931,0.041,2.472,3.511,13.927,3.238,72.089,17.377,2.323,2.180
 2187.409,114.420,874.023,63.712,-148.090,22.374,9.977,0.058,2.448,3.502,15.299,3.426,74.928,19.384,2.497,2.264
 2187.909,114.422,877.686,70.561,-150.847,23.652,9.843,0.057,2.441,3.645,15.737,4.401,74.789,19.286,2.639,2.315
 2188.409,114.329,888.672,66.308,-154.030,24.651,9.646,0.038,2.439,3.936,15.869,5.695,72.097,17.383,2.737,2.328
 2188.909,114.556,888.672,54.968,-156.896,23.739,9.510,0.023,2.430,4.150,16.392,6.545,69.182,15.323,2.782,2.315
 2189.409,114.499,877.148,46.735,-160.139,20.913,9.349,0.026,2.417,4.119,17.141,6.655,68.832,15.075,2.815,2.294
 2189.909,114.574,883.789,43.625,-162.759,18.301,9.274,0.036,2.401,4.027,18.089,6.256,71.530,16.982,2.853,2.290
 2190.409,114.509,877.637,42.725,-164.461,17.247,9.270,0.047,2.395,3.969,18.407,5.792,74.584,19.141,2.894,2.286
 2190.909,114.507,870.752,43.535,-165.602,17.349,9.270,0.053,2.397,3.968,18.302,5.481,75.500,19.788,2.926,2.290
 2191.409,114.548,875.146,45.745,-166.496,18.053,9.268,0.053,2.399,4.020,18.194,5.367,73.181,18.149,2.942,2.296
 2191.909,114.474,888.379,46.883,-166.979,18.862,9.293,0.050,2.400,4.068,18.137,5.437,69.878,15.815,2.946,2.295
 2192.409,114.373,888.672,45.943,-167.505,19.444,9.239,0.045,2.401,4.068,18.066,5.523,69.520,15.562,2.954,2.298
 2192.909,114.547,879.004,43.028,-167.239,19.506,9.019,0.035,2.404,4.012,17.916,5.689,73.306,18.237,2.963,2.299
 2193.409,114.497,883.789,39.565,-167.162,18.952,9.126,0.021,2.417,3.965,17.125,6.215,79.813,22.836,2.978,2.311
 2193.909,114.459,883.643,38.931,-167.370,17.990,9.340,0.010,2.437,3.979,15.982,6.767,84.211,25.944,2.998,2.333
 2194.409,114.584,878.906,42.097,-167.924,16.776,9.334,0.011,2.452,3.999,15.103,6.980,83.491,25.435,3.032,2.369
 2194.909,114.418,888.281,45.171,-168.520,15.947,9.330,0.018,2.455,4.063,14.887,6.864,78.215,21.706,3.081,2.418
 2195.409,114.532,883.789,46.195,-168.437,15.776,9.312,0.024,2.460,4.119,14.629,6.773,71.122,16.694,3.133,2.468
 2195.909,114.546,892.285,43.330,-169.194,15.774,9.295,0.024,2.471,4.184,13.989,7.079,66.816,13.651,3.186,2.518
 2196.409,114.538,883.789,39.476,-168.860,15.352,9.317,0.020,2.474,4.214,13.772,7.350,66.987,13.772,3.232,2.567
 2196.909,114.589,884.668,37.856,-168.177,14.629,9.374,0.018,2.463,4.138,14.458,7.166,70.384,16.173,3.269,2.617
 2197.409,114.372,878.418,38.675,-166.638,14.525,9.451,0.015,2.443,4.142,15.626,6.689,74.355,18.979,3.298,2.671
 2197.909,114.646,869.141,41.080,-165.206,15.121,9.522,0.010,2.439,4.217,15.866,6.568,74.843,19.323,3.293,2.715
 2198.409,114.584,872.803,42.758,-164.135,15.519,9.572,0.004,2.466,4.252,14.296,7.082,71.578,17.016,3.265,2.746
 2198.909,114.449,885.107,42.120,-161.873,15.142,9.634,-0.001,2.503,4.257,12.085,7.483,67.175,13.904,3.219,2.780
 2199.409,114.578,888.672,39.757,-158.206,14.249,9.676,-0.002,2.532,4.213,10.431,7.134,64.391,11.937,3.183,2.828
 2199.909,114.440,883.789,38.454,-153.869,13.771,9.624,-0.001,2.546,4.191,9.578,6.104,64.612,12.094,3.199,2.922
 2200.409,114.461,883.789,41.615,-149.006,14.323,9.571,0.000,2.551,4.135,9.311,5.032,66.020,13.089,3.267,3.059
 2200.909,114.507,885.596,48.872,-146.106,15.790,9.559,0.003,2.549,4.143,9.402,4.799,69.406,15.481,3.398,3.239
 2201.409,114.522,884.326,50.496,-143.642,17.364,9.519,0.004,2.544,4.260,9.735,5.365,74.455,19.049,3.573,3.458
 2201.909,114.660,878.906,43.954,-142.138,17.670,9.485,0.004,2.550,4.377,9.366,6.371,78.709,22.056,3.788,3.697
 2202.409,114.500,883.496,34.481,-139.083,16.045,9.481,0.003,2.574,4.478,7.929,7.318,79.905,22.901,4.041,3.963
 2202.909,114.547,888.672,31.535,-134.750,12.914,9.483,0.003,2.610,4.384,5.848,7.527,77.376,21.114,4.349,4.260
 2203.409,114.457,893.506,38.161,-130.985,9.985,9.492,0.006,2.634,4.253,4.450,7.040,77.092,20.913,4.682,4.590
 2203.909,114.622,888.574,49.125,-128.251,8.906,9.500,0.010,2.633,4.097,4.486,6.141,85.225,26.661,5.020,4.953
 2204.409,114.398,874.414,56.987,-125.188,9.700,9.521,0.013,2.625,3.868,4.952,5.453,97.381,35.252,5.269,5.253
 2204.909,114.630,883.789,61.378,-122.589,11.662,9.507,0.010,2.618,3.733,5.381,5.405,107.110,42.127,5.351,5.394
 2205.409,114.680,870.459,62.372,-120.108,13.323,9.471,0.005,2.615,3.738,5.580,5.668,109.490,43.809,5.282,5.340
 2205.909,114.722,889.746,61.670,-118.663,13.894,9.478,0.001,2.609,3.835,5.902,5.825,106.323,41.571,5.111,5.155
 2206.409,114.519,892.920,63.587,-118.358,13.852,9.509,0.000,2.602,3.868,6.302,5.644,104.245,40.102,4.930,4.964
 2206.909,114.634,888.672,68.949,-117.303,13.975,9.548,0.005,2.595,3.816,6.709,5.189,105.179,40.762,4.764,4.814
 2207.409,114.703,878.906,76.245,-116.453,14.849,9.578,0.009,2.591,3.697,6.976,4.720,108.338,42.995,4.627,4.715
 2207.909,114.560,885.840,81.138,-115.651,16.455,9.595,0.014,2.592,3.600,6.893,4.383,111.246,45.050,4.481,4.631
 2208.409,114.581,887.549,83.509,-114.207,18.410,9.605,0.016,2.586,3.547,7.231,4.221,113.136,46.386,4.336,4.541
 2208.909,114.646,883.789,89.229,-113.285,20.469,9.612,0.016,2.576,3.537,7.863,4.184,114.077,47.051,4.199,4.447
 2209.409,114.693,890.820,96.000,-111.743,22.205,9.608,0.016,2.570,3.568,8.191,4.194,114.502,47.351,4.090,4.341
 2209.909,114.657,883.789,97.892,-110.874,23.172,9.585,0.018,2.575,3.533,7.876,4.231,116.325,48.640,4.009,4.237
 2210.409,114.692,883.789,95.405,-110.010,22.970,9.572,0.020,2.589,3.501,7.102,4.270,119.429,50.833,3.947,4.145
 2210.909,114.615,887.939,92.861,-109.531,22.091,9.583,0.020,2.595,3.438,6.735,4.272,121.157,52.054,3.872,4.071
 2211.409,114.701,886.865,97.654,-109.399,21.759,9.614,0.016,2.590,3.380,7.002,4.215,120.316,51.460,3.803,4.043
 2211.909,114.590,883.789,105.317,-110.251,22.395,9.633,0.014,2.587,3.412,7.173,4.119,118.028,49.843,3.768,4.090
 2212.409,114.746,881.738,108.185,-111.665,23.450,9.628,0.013,2.589,3.457,7.071,4.011,114.322,47.224,3.812,4.227
 2212.909,114.695,883.545,105.408,-112.260,24.399,9.610,0.010,2.585,3.529,7.285,3.937,109.117,43.546,3.972,4.485
 2213.409,114.655,881.494,98.734,-112.235,25.376,9.550,0.008,2.570,3.530,8.188,4.154,101.859,38.416,4.270,4.843
 2213.909,114.835,883.740,90.850,-113.195,26.278,9.481,0.010,2.561,3.644,8.720,5.360,94.593,33.281,4.672,5.240
 2214.409,114.657,883.789,81.684,-115.784,25.433,9.439,0.013,2.576,3.958,7.819,8.373,91.524,31.113,5.156,5.605
 2214.909,114.817,883.789,67.739,-118.424,21.698,9.412,0.015,2.615,4.177,5.528,11.677,90.411,30.326,5.630,5.869
 2215.409,114.578,878.223,54.246,-120.168,15.718,9.415,0.019,2.667,4.212,2.504,13.261,88.038,28.648,6.054,6.107
 2215.909,114.670,876.660,45.905,-120.179,10.649,9.444,0.030,2.713,4.067,-0.182,12.426,84.593,26.214,6.406,6.367
 2216.409,114.707,897.363,45.845,-119.784,8.545,9.486,0.044,2.738,3.859,-1.664,9.826,83.244,25.261,6.592,6.606
 2216.909,114.796,888.672,51.889,-118.330,8.920,9.534,0.051,2.736,3.746,-1.492,7.440,88.938,29.285,6.567,6.747
 2217.409,114.822,882.227,60.292,-117.653,10.721,9.589,0.049,2.708,3.689,0.105,5.998,100.224,37.261,6.295,6.645
 2217.909,114.580,883.789,68.330,-116.696,12.944,9.632,0.041,2.668,3.615,2.443,5.319,110.811,44.743,5.873,6.343
 2218.409,114.673,883.789,74.852,-116.138,14.922,9.649,0.033,2.633,3.604,4.476,5.191,117.265,49.304,5.462,5.924
 2218.909,114.748,883.789,80.885,-115.665,16.291,9.659,0.025,2.613,3.614,5.644,5.245,120.763,51.776,5.140,5.537
 2219.409,114.769,887.500,83.278,-114.471,17.105,9.697,0.020,2.615,3.636,5.560,5.308,124.132,54.157,4.938,5.251
 2219.909,114.692,888.672,83.431,-114.497,17.502,9.708,0.018,2.629,3.669,4.736,5.290,126.765,56.018,4.847,5.120
 2220.409,114.669,884.717,79.409,-114.944,17.555,9.691,0.018,2.641,3.618,4.031,5.224,127.839,56.777,4.827,5.093
 2220.909,114.791,880.518,75.031,-115.693,17.443,9.685,0.019,2.649,3.590,3.577,5.147,127.531,56.559,4.852,5.132
 2221.409,114.823,883.789,74.088,-115.123,17.417,9.660,0.020,2.652,3.584,3.401,5.083,127.064,56.229,4.887,5.186
 2221.909,114.781,891.699,76.977,-114.450,17.616,9.642,0.018,2.647,3.578,3.690,5.094,126.570,55.880,4.897,5.201
 2222.409,114.851,879.883,78.638,-114.420,17.799,9.631,0.011,2.638,3.484,4.238,5.198,125.319,54.996,4.878,5.182
 2222.909,114.778,876.807,75.811,-115.089,17.596,9.609,0.005,2.632,3.349,4.572,5.306,121.453,52.264,4.818,5.138
 2223.409,114.710,874.023,72.739,-116.246,16.995,9.600,0.004,2.636,3.319,4.334,5.328,114.294,47.204,4.757,5.118
 2223.909,114.802,883.789,73.162,-116.629,16.454,9.600,0.008,2.642,3.337,3.982,5.219,105.331,40.870,4.757,5.204
 2224.409,114.854,874.023,80.423,-117.534,16.443,9.593,0.013,2.644,3.381,3.886,5.044,99.645,36.851,4.843,5.384
 2224.909,114.709,883.789,86.408,-119.164,17.205,9.572,0.016,2.642,3.341,4.004,4.965,101.864,38.420,5.073,5.670
 2225.409,114.764,883.545,84.489,-120.533,18.699,9.546,0.015,2.641,3.342,4.044,5.225,107.245,42.223,5.362,5.945
 2225.909,114.827,884.473,73.154,-123.366,19.865,9.525,0.012,2.646,3.412,3.762,6.504,110.199,44.310,5.639,6.074
 2226.409,114.683,878.906,57.517,-125.964,19.172,9.515,0.008,2.658,3.557,3.042,8.445,108.902,43.394,5.817,6.075
 2226.909,114.862,881.934,45.337,-129.556,16.112,9.517,0.007,2.677,3.744,1.901,9.949,104.564,40.328,5.881,5.994
 2227.409,114.939,883.105,42.537,-131.510,12.280,9.530,0.013,2.698,3.798,0.684,10.027,100.659,37.568,5.954,6.033
 2227.909,114.745,885.449,50.270,-131.699,9.938,9.552,0.020,2.706,3.606,0.212,8.443,97.640,35.435,6.117,6.289
 2228.409,114.783,888.672,69.454,-131.259,10.301,9.564,0.023,2.692,3.248,1.054,6.661,92.976,32.139,6.393,6.719
 2228.909,114.813,888.672,92.287,-131.204,13.267,9.565,0.020,2.672,3.043,2.210,6.190,86.559,27.603,6.716,7.231
 2229.409,114.837,888.672,101.733,-132.328,16.639,9.565,0.013,2.660,3.241,2.934,8.694,79.448,22.578,7.057,7.630
 2229.909,114.705,888.672,100.498,-133.568,17.316,9.566,0.008,2.659,3.736,2.993,14.686,73.815,18.597,7.445,7.961
 2230.409,114.762,892.139,91.858,-133.528,14.368,9.575,0.006,2.662,4.261,2.799,22.181,71.960,17.286,8.161,8.386
 2230.909,114.872,888.672,83.356,-133.089,9.497,9.598,0.007,2.662,4.666,2.783,28.420,72.058,17.355,9.272,9.019
 2231.409,114.873,891.943,77.537,-132.689,5.908,9.628,0.008,2.663,4.871,2.742,32.085,71.844,17.204,10.766,9.676
 2231.909,114.865,892.871,67.973,-132.386,4.507,9.667,0.011,2.671,4.973,2.260,33.459,69.000,15.194,11.721,9.931
 2232.409,114.728,889.844,60.393,-131.596,4.034,9.714,0.017,2.685,5.026,1.465,31.607,64.430,11.965,11.102,9.284
 2232.909,114.824,888.232,60.992,-130.094,3.723,9.764,0.025,2.697,5.134,0.766,25.929,62.717,10.754,9.354,8.161
 2233.409,114.827,903.320,70.457,-128.501,3.954,9.826,0.041,2.705,5.194,0.282,17.511,65.958,13.045,7.531,6.970
 2233.909,114.715,889.404,85.874,-126.741,5.630,9.937,0.063,2.708,4.880,0.122,9.875,72.122,17.400,6.138,5.940
 2234.409,114.915,893.750,102.526,-125.055,10.564,10.123,0.079,2.699,4.289,0.658,5.815,78.314,21.777,5.135,5.117
 2234.909,115.000,888.672,113.521,-123.277,17.651,10.307,0.079,2.671,3.664,2.262,4.332,83.467,25.419,4.401,4.425
 2235.409,114.863,886.084,120.932,-120.460,24.450,10.430,0.057,2.625,3.289,4.958,4.045,87.859,28.522,3.862,3.915
 2235.909,114.898,889.404,125.746,-119.177,28.835,10.524,0.035,2.588,3.297,7.139,3.919,90.818,30.614,3.483,3.540
 2236.409,114.858,903.320,127.562,-119.323,29.753,10.597,0.024,2.577,3.409,7.763,3.806,91.878,31.362,3.248,3.312
 2236.909,114.819,897.461,129.908,-120.768,29.396,10.645,0.023,2.582,3.507,7.481,3.732,91.208,30.889,3.125,3.183
 2237.409,114.864,894.727,132.489,-122.842,29.493,10.678,0.028,2.591,3.539,6.947,3.726,89.486,29.672,3.093,3.132
 2237.909,114.988,897.705,135.396,-124.534,30.424,10.716,0.040,2.603,3.524,6.254,3.762,88.176,28.746,3.106,3.124
 2238.409,114.958,893.555,136.944,-125.831,31.366,10.767,0.056,2.614,3.453,5.609,3.807,87.490,28.261,3.140,3.126
 2238.909,114.943,893.555,135.873,-126.526,31.227,10.814,0.062,2.595,3.309,6.698,3.875,87.572,28.319,3.149,3.105
 2239.409,114.879,900.586,129.591,-126.697,31.730,10.844,0.056,2.496,3.142,12.506,4.050,89.967,30.012,3.134,3.046
 2239.909,115.005,900.977,116.440,-126.549,36.893,10.870,0.042,2.324,2.930,22.548,4.161,94.852,33.465,3.091,2.975
 2240.409,115.002,893.555,105.933,-126.830,46.884,10.923,0.025,2.187,2.786,30.556,4.006,100.247,37.277,3.034,2.892
 2240.909,114.916,890.088,107.705,-127.476,55.200,10.916,0.016,2.197,2.774,29.983,3.675,102.317,38.740,2.968,2.811
 2241.409,114.962,893.555,117.164,-129.208,56.003,10.852,0.016,2.335,2.843,21.940,3.352,99.373,36.659,2.894,2.706
 2241.909,114.960,893.555,124.898,-131.362,48.479,10.836,0.026,2.491,2.998,12.803,3.236,93.482,32.496,2.809,2.581
 2242.409,115.038,889.355,126.708,-134.735,38.767,10.834,0.038,2.574,3.091,7.935,3.229,88.154,28.731,2.733,2.459
 2242.909,114.858,901.416,123.889,-138.370,32.301,10.817,0.041,2.584,3.141,7.350,3.179,85.245,26.675,2.671,2.346
 2243.409,114.869,898.438,123.432,-141.872,29.653,10.777,0.036,2.561,3.182,8.687,3.216,84.115,25.876,2.628,2.248
 2243.909,114.958,901.221,120.315,-144.684,29.458,10.747,0.031,2.523,3.110,10.915,3.478,83.611,25.520,2.604,2.157
 2244.409,115.033,903.125,112.434,-147.238,29.119,10.740,0.033,2.488,2.906,12.973,3.850,83.218,25.242,2.577,2.073
 2244.909,115.035,898.633,103.881,-150.348,27.696,10.736,0.037,2.463,2.623,14.463,4.130,83.075,25.141,2.564,2.013
 2245.409,114.811,883.838,96.729,-152.274,26.151,10.726,0.042,2.450,2.387,15.224,4.198,83.187,25.221,2.549,1.970
 2245.909,114.908,888.672,92.076,-153.538,25.514,10.719,0.038,2.433,2.261,16.172,4.173,83.329,25.321,2.543,1.939
 2246.409,114.927,884.277,87.683,-153.918,25.575,10.720,0.030,2.410,2.201,17.550,4.266,83.375,25.353,2.533,1.911
 2246.909,114.940,896.387,83.387,-154.412,25.296,10.736,0.028,2.400,2.170,18.134,4.462,83.430,25.392,2.507,1.881
 2247.409,114.826,898.926,86.851,-154.633,24.285,10.765,0.035,2.410,2.165,17.554,4.568,83.580,25.498,2.469,1.858
 2247.909,115.041,897.168,99.502,-154.857,23.022,10.789,0.043,2.440,2.271,15.796,4.373,83.901,25.725,2.426,1.850
 2248.409,115.054,903.320,109.885,-155.516,22.596,10.798,0.047,2.462,2.409,14.477,4.020,84.324,26.024,2.393,1.854
 2248.909,114.887,903.320,109.945,-156.457,23.687,10.797,0.045,2.459,2.441,14.664,3.716,84.837,26.386,2.383,1.875
 2249.409,115.009,884.766,102.268,-157.044,25.492,10.796,0.047,2.454,2.447,14.975,3.534,85.324,26.731,2.394,1.902
 2249.909,114.996,899.219,100.651,-155.921,26.836,10.792,0.053,2.465,2.500,14.347,3.568,85.206,26.647,2.417,1.930
 2250.409,115.096,903.320,103.899,-154.979,27.414,10.789,0.055,2.482,2.633,13.336,3.925,84.134,25.889,2.443,1.947
 2250.909,114.927,892.041,105.070,-154.156,27.300,10.800,0.050,2.487,2.737,13.022,4.527,82.357,24.634,2.451,1.945
 2251.409,115.081,893.555,95.560,-154.379,26.198,10.835,0.046,2.483,2.643,13.289,5.109,80.717,23.475,2.443,1.935
 2251.909,115.149,893.555,83.045,-154.653,24.094,10.884,0.047,2.476,2.532,13.696,5.306,80.160,23.081,2.425,1.929
 2252.409,115.097,896.777,80.228,-154.276,21.566,10.932,0.053,2.471,2.453,13.972,5.031,80.886,23.595,2.411,1.939
 2252.909,115.027,893.555,83.357,-153.709,20.099,10.972,0.057,2.469,2.433,14.122,4.591,82.374,24.646,2.411,1.967
 2253.409,115.030,896.533,90.945,-153.850,20.926,10.986,0.054,2.465,2.464,14.332,4.214,83.893,25.720,2.426,2.004
 2253.909,115.088,893.555,97.638,-156.563,23.218,10.985,0.049,2.468,2.461,14.153,4.063,84.971,26.481,2.449,2.047
 2254.409,115.145,891.406,98.008,-156.386,25.835,10.983,0.045,2.473,2.445,13.879,4.220,85.137,26.598,2.473,2.089
 2254.909,115.108,902.734,96.658,-155.374,27.665,10.984,0.041,2.466,2.371,14.289,4.579,84.402,26.079,2.500,2.134
 2255.409,115.114,893.555,93.492,-150.105,27.886,10.994,0.037,2.455,2.290,14.936,4.825,84.626,26.238,2.541,2.195
 2255.909,115.256,893.799,91.256,-146.671,26.869,11.021,0.035,2.452,2.295,15.109,4.694,86.560,27.604,2.599,2.281
 2256.409,115.100,910.205,94.049,-146.759,25.425,11.086,0.035,2.462,2.393,14.492,4.184,88.243,28.794,2.682,2.407
 2256.909,115.112,903.320,93.851,-146.788,24.739,11.168,0.038,2.479,2.514,13.524,3.746,88.228,28.783,2.778,2.558
 2257.409,115.117,897.656,95.113,-147.103,25.417,11.233,0.041,2.498,2.651,12.412,3.687,86.861,27.817,2.874,2.711
 2257.909,115.110,889.209,100.583,-144.685,26.280,11.270,0.043,2.515,2.707,11.416,3.841,85.747,27.030,2.974,2.852
 2258.409,115.136,893.555,107.563,-143.547,26.676,11.274,0.044,2.533,2.736,10.322,3.983,85.428,26.804,3.069,2.977
 2258.909,115.225,899.170,114.949,-142.901,27.103,11.215,0.044,2.543,2.783,9.784,4.023,84.696,26.287,3.187,3.109
 2259.409,115.066,900.000,118.881,-141.823,28.227,11.091,0.044,2.530,2.828,10.509,4.104,82.713,24.885,3.319,3.248
 2259.909,115.128,899.414,116.784,-139.628,29.662,11.033,0.045,2.510,2.866,11.703,4.315,80.553,23.359,3.460,3.386
 2260.409,115.107,896.191,107.754,-137.239,29.771,11.054,0.048,2.504,2.859,12.065,4.505,79.316,22.485,3.584,3.517
 2260.909,115.142,903.320,101.626,-136.266,27.803,11.097,0.055,2.526,2.826,10.761,4.568,79.089,22.324,3.677,3.629
 2261.409,115.105,895.801,97.942,-136.783,24.959,11.144,0.060,2.554,2.827,9.150,4.501,79.568,22.663,3.755,3.741
 2261.909,115.238,898.438,99.492,-137.653,23.096,11.195,0.064,2.567,2.825,8.392,4.360,80.330,23.202,3.814,3.830
 2262.409,115.213,898.438,107.054,-137.128,22.996,11.270,0.059,2.554,2.813,9.110,4.275,81.182,23.804,3.864,3.903
 2262.909,115.177,888.672,115.883,-135.785,24.383,11.366,0.051,2.544,2.828,9.731,4.198,82.641,24.835,3.887,3.951
 2263.409,115.256,901.416,125.544,-133.380,26.340,11.469,0.045,2.546,2.840,9.613,4.125,84.367,26.054,3.882,3.959
 2263.909,115.245,903.320,130.133,-131.880,28.481,11.559,0.044,2.555,2.917,9.076,4.072,85.773,27.048,3.863,3.959
 2264.409,115.201,898.828,129.887,-130.434,30.839,11.633,0.051,2.570,3.048,8.200,4.003,86.603,27.634,3.834,3.930
 2264.909,115.208,896.289,129.460,-130.384,32.377,11.715,0.053,2.569,3.101,8.248,3.946,86.727,27.723,3.804,3.903
 2265.409,115.113,893.555,129.703,-130.703,32.613,11.799,0.051,2.562,3.080,8.642,3.904,86.467,27.538,3.783,3.883
 2265.909,115.199,900.928,129.112,-132.007,32.374,11.872,0.050,2.557,3.023,8.962,3.847,86.055,27.248,3.762,3.877
 2266.409,115.119,898.438,125.224,-133.082,32.440,11.941,0.052,2.553,3.005,9.176,3.753,85.601,26.926,3.761,3.894
 2266.909,115.209,903.711,118.701,-134.399,33.165,12.004,0.057,2.545,2.999,9.649,3.648,84.827,26.380,3.771,3.917
 2267.409,115.302,894.141,110.520,-136.029,33.376,12.053,0.059,2.532,2.937,10.418,3.587,83.687,25.574,3.792,3.936
 2267.909,115.353,903.320,105.736,-137.385,31.975,12.101,0.055,2.521,2.832,11.027,3.586,82.122,24.467,3.816,3.948
 2268.409,115.155,907.666,106.416,-138.129,29.752,12.145,0.049,2.521,2.750,11.059,3.607,80.563,23.366,3.834,3.953
 2268.909,115.331,891.016,106.810,-137.501,27.807,12.169,0.047,2.533,2.729,10.337,3.615,79.500,22.615,3.851,3.970
 2269.409,115.415,885.352,105.644,-136.614,27.312,12.218,0.050,2.545,2.763,9.651,3.613,79.101,22.333,3.870,3.993
 2269.909,115.155,893.555,106.608,-135.341,28.260,12.272,0.055,2.552,2.878,9.240,3.617,79.407,22.549,3.890,4.012
 2270.409,115.278,903.320,110.023,-134.466,29.362,12.295,0.057,2.550,3.016,9.364,3.643,80.065,23.014,3.910,4.021
 2270.909,115.229,903.320,112.188,-135.017,29.452,12.301,0.054,2.544,3.096,9.726,3.676,80.705,23.466,3.917,4.014
 2271.409,115.262,893.555,114.948,-135.007,28.827,12.301,0.052,2.543,3.061,9.767,3.695,81.124,23.762,3.915,4.003
 2271.909,115.344,893.555,118.488,-134.318,28.599,12.301,0.052,2.551,2.980,9.318,3.694,81.243,23.847,3.905,4.000
 2272.409,115.384,893.555,120.037,-132.697,29.275,12.301,0.054,2.561,2.924,8.740,3.689,81.072,23.726,3.901,4.009
 2272.909,115.329,893.555,117.497,-131.929,29.905,12.301,0.058,2.571,2.965,8.122,3.704,80.736,23.488,3.918,4.043
 2273.409,115.422,893.555,112.385,-131.451,29.693,12.289,0.065,2.583,3.046,7.442,3.734,80.400,23.251,3.959,4.094
 2273.909,115.311,893.555,113.865,-131.601,29.061,12.265,0.070,2.597,3.075,6.633,3.768,80.256,23.149,4.027,4.159
 2274.409,115.397,888.672,118.908,-130.902,28.235,12.232,0.071,2.605,3.057,6.158,3.830,80.292,23.174,4.101,4.218
 2274.909,115.338,888.672,120.054,-130.400,27.406,12.192,0.063,2.596,2.978,6.653,3.964,80.252,23.147,4.162,4.248
 2275.409,115.367,895.752,116.596,-129.876,26.262,12.185,0.051,2.578,2.945,7.747,4.152,80.080,23.025,4.192,4.251
 2275.909,115.531,893.701,115.981,-129.345,25.278,12.209,0.046,2.569,2.939,8.244,4.261,79.935,22.923,4.194,4.236
 2276.409,115.328,893.555,119.548,-129.016,24.993,12.256,0.052,2.576,2.964,7.854,4.205,80.083,23.027,4.172,4.220
 2276.909,115.357,898.145,121.513,-128.867,25.049,12.309,0.060,2.586,2.956,7.229,4.036,80.546,23.354,4.140,4.204
 2277.409,115.367,883.789,117.811,-128.182,25.574,12.351,0.063,2.585,2.900,7.288,3.873,81.103,23.747,4.090,4.171
 2277.909,115.383,884.473,111.005,-127.418,26.501,12.386,0.059,2.575,2.907,7.906,3.773,81.686,24.160,4.027,4.127
 2278.409,115.413,890.674,110.034,-127.262,27.433,12.415,0.056,2.572,2.925,8.061,3.708,82.212,24.531,3.956,4.071
 2278.909,115.401,893.555,112.648,-128.113,27.810,12.441,0.059,2.581,2.954,7.551,3.656,82.561,24.778,3.890,4.016
 2279.409,115.424,890.430,117.140,-129.794,27.569,12.464,0.067,2.597,2.987,6.595,3.626,82.588,24.797,3.849,3.973
 2279.909,115.314,892.773,118.702,-131.125,27.605,12.479,0.071,2.601,3.008,6.396,3.623,82.297,24.591,3.825,3.940
 2280.409,115.386,888.672,118.683,-131.316,28.252,12.488,0.073,2.599,3.044,6.477,3.636,81.982,24.369,3.818,3.919
 2280.909,115.395,887.891,120.817,-130.229,28.528,12.496,0.072,2.594,3.024,6.767,3.639,81.915,24.322,3.811,3.910
 2281.409,115.311,892.627,124.509,-129.525,27.792,12.480,0.072,2.596,2.975,6.679,3.624,82.072,24.432,3.800,3.905
 2281.909,115.473,891.211,125.677,-129.161,26.745,12.444,0.072,2.596,2.959,6.640,3.602,82.252,24.560,3.786,3.904
 2282.409,115.202,894.629,122.369,-129.538,26.352,12.427,0.070,2.593,2.989,6.870,3.581,82.282,24.581,3.775,3.903
 2282.909,115.498,892.041,119.837,-130.650,26.836,12.427,0.068,2.587,3.016,7.191,3.566,82.205,24.527,3.766,3.896
 2283.409,115.486,888.672,119.690,-131.083,28.012,12.427,0.064,2.577,2.997,7.772,3.561,82.137,24.479,3.758,3.884
 2283.909,115.391,893.555,123.907,-130.818,29.012,12.426,0.060,2.567,2.960,8.373,3.570,82.114,24.462,3.746,3.860
 2284.409,115.481,884.961,125.865,-129.251,28.918,12.409,0.057,2.560,2.947,8.763,3.588,82.257,24.563,3.727,3.834
 2284.909,115.506,891.602,122.166,-127.442,28.297,12.380,0.058,2.568,2.913,8.296,3.600,82.706,24.881,3.702,3.809
 2285.409,115.373,903.320,116.728,-125.625,28.055,12.364,0.056,2.574,2.859,7.957,3.593,83.528,25.462,3.681,3.796
 2285.909,115.455,888.672,116.754,-123.544,28.429,12.360,0.054,2.578,2.885,7.744,3.559,84.741,26.319,3.673,3.806
 2286.409,115.454,893.408,122.057,-121.361,28.987,12.360,0.055,2.581,2.937,7.521,3.521,86.067,27.256,3.679,3.827
 2286.909,115.494,895.996,127.720,-120.193,28.905,12.360,0.061,2.588,3.028,7.126,3.521,87.008,27.921,3.701,3.856
 2287.409,115.465,893.652,130.721,-120.722,28.622,12.334,0.065,2.594,3.078,6.768,3.594,87.126,28.004,3.720,3.868
 2287.909,115.529,906.494,125.789,-122.638,28.748,12.277,0.065,2.595,3.063,6.738,3.753,86.164,27.324,3.736,3.867
 2288.409,115.338,898.438,121.587,-124.189,28.456,12.242,0.062,2.593,3.040,6.871,3.876,84.886,26.421,3.745,3.862
 2288.909,115.476,901.318,118.848,-125.111,27.655,12.236,0.060,2.586,2.977,7.238,3.884,84.112,25.874,3.755,3.867
 2289.409,115.577,902.734,119.344,-125.769,27.488,12.221,0.061,2.581,2.966,7.527,3.801,84.130,25.887,3.769,3.889
 2289.909,115.510,898.438,123.091,-125.986,28.486,12.194,0.060,2.574,2.980,7.937,3.703,84.700,26.290,3.779,3.907
 2290.409,115.338,901.660,123.323,-126.153,29.691,12.116,0.056,2.565,3.011,8.498,3.668,85.249,26.678,3.780,3.919
 2290.909,115.492,893.555,122.957,-126.641,29.682,12.019,0.052,2.549,3.020,9.418,3.675,85.461,26.828,3.770,3.915
 2291.409,115.532,903.320,121.853,-127.603,28.577,11.983,0.054,2.534,3.008,10.271,3.691,85.379,26.770,3.760,3.910
 2291.909,115.592,903.320,122.730,-128.229,27.765,11.974,0.065,2.538,2.982,10.077,3.701,85.095,26.569,3.763,3.918
 2292.409,115.421,910.547,123.152,-128.844,28.201,11.938,0.077,2.551,2.920,9.290,3.701,84.609,26.225,3.782,3.937
 2292.909,115.345,903.320,122.234,-129.017,29.184,11.889,0.081,2.556,2.819,9.020,3.704,84.010,25.802,3.818,3.972
 2293.409,115.526,899.951,121.577,-129.486,29.541,11.869,0.079,2.550,2.784,9.362,3.727,83.443,25.401,3.856,4.011
 2293.909,115.598,907.373,121.863,-129.034,29.234,11.861,0.075,2.543,2.845,9.750,3.773,83.180,25.215,3.894,4.049
 2294.409,115.462,906.445,126.449,-128.307,28.284,11.851,0.072,2.545,2.902,9.629,3.824,83.289,25.292,3.922,4.076
 2294.909,115.509,907.617,129.585,-127.156,26.919,11.847,0.070,2.552,2.936,9.261,3.874,83.499,25.441,3.941,4.084
 2295.409,115.500,898.438,128.819,-126.904,25.549,11.847,0.069,2.556,2.916,9.028,3.927,83.524,25.459,3.944,4.077
 2295.909,115.456,893.896,125.048,-127.586,24.686,11.847,0.068,2.560,2.909,8.770,3.965,83.292,25.295,3.938,4.066
 2296.409,115.566,903.320,119.550,-127.440,24.551,11.847,0.070,2.568,2.945,8.323,3.945,83.220,25.244,3.919,4.056
 2296.909,115.690,903.320,115.781,-127.864,24.850,11.848,0.074,2.574,2.949,7.978,3.866,83.667,25.560,3.902,4.049
 2297.409,115.556,908.203,112.217,-127.658,25.680,11.849,0.087,2.570,2.945,8.177,3.763,84.605,26.223,3.881,4.034
 2297.909,115.585,903.027,108.634,-127.542,26.881,11.836,0.109,2.554,2.929,9.096,3.693,85.483,26.843,3.859,4.006
 2298.409,115.513,893.555,108.433,-127.307,28.088,11.811,0.129,2.524,2.890,10.858,3.674,85.760,27.039,3.836,3.977
 2298.909,115.525,903.320,111.434,-127.370,28.639,11.788,0.138,2.501,2.883,12.250,3.669,85.568,26.903,3.809,3.943
 2299.409,115.585,903.320,116.190,-128.008,28.490,11.766,0.124,2.492,2.902,12.740,3.680,85.261,26.687,3.782,3.912
 2299.909,115.605,903.320,121.605,-128.646,28.264,11.753,0.105,2.510,2.968,11.720,3.698,85.112,26.581,3.758,3.887
 2300.409,115.506,903.320,121.998,-129.184,28.045,11.750,0.096,2.543,3.031,9.795,3.714,85.205,26.647,3.740,3.870
 2300.909,115.658,898.438,120.579,-128.731,27.718,11.749,0.093,2.564,3.073,8.555,3.716,85.419,26.798,3.742,3.881
 2301.409,115.575,895.068,121.663,-128.496,27.501,11.744,0.098,2.573,3.117,7.997,3.706,85.671,26.976,3.769,3.910
 2301.909,115.603,904.395,122.759,-127.855,27.893,11.739,0.100,2.567,3.138,8.361,3.711,85.897,27.136,3.812,3.952
 2302.409,115.559,908.203,120.264,-127.188,28.931,11.707,0.098,2.556,3.103,8.999,3.767,85.847,27.100,3.860,3.983
 2302.909,115.695,904.639,113.020,-125.801,30.164,11.615,0.095,2.545,3.054,9.627,3.911,85.397,26.782,3.886,3.984
 2303.409,115.639,904.346,108.135,-124.459,30.909,11.509,0.087,2.532,3.023,10.410,4.076,84.716,26.301,3.887,3.960
 2303.909,115.668,903.320,110.529,-123.608,31.068,11.436,0.079,2.529,3.005,10.579,4.131,85.007,26.507,3.860,3.918
 2304.409,115.622,895.117,118.752,-123.335,30.993,11.402,0.074,2.537,2.980,10.092,4.038,87.369,28.176,3.821,3.878
 2304.909,115.637,903.320,122.071,-123.089,30.695,11.389,0.074,2.548,2.950,9.480,3.849,91.795,31.304,3.773,3.842
 2305.409,115.510,903.320,121.832,-122.544,30.021,11.375,0.079,2.557,2.915,8.918,3.685,96.693,34.765,3.716,3.803
 2305.909,115.658,901.318,120.942,-120.992,29.199,11.358,0.079,2.551,2.906,9.300,3.607,99.939,37.059,3.655,3.758
 2306.409,115.518,898.438,122.277,-119.136,29.011,11.319,0.073,2.536,2.873,10.159,3.571,102.770,39.060,3.594,3.710
 2306.909,115.570,902.930,125.786,-117.708,29.702,11.256,0.065,2.527,2.877,10.722,3.553,108.591,43.174,3.542,3.663
 2307.409,115.595,903.418,125.044,-117.024,30.734,11.191,0.062,2.523,2.931,10.926,3.555,116.173,48.532,3.506,3.622
 2307.909,115.687,898.438,124.956,-118.448,32.038,11.124,0.067,2.528,2.954,10.672,3.582,122.944,53.318,3.481,3.584
 2308.409,115.653,913.232,123.689,-119.250,33.201,11.062,0.074,2.529,2.937,10.556,3.621,126.084,55.536,3.459,3.545
 2308.909,115.594,909.912,120.156,-120.086,33.506,11.008,0.077,2.520,2.846,11.131,3.648,124.820,54.643,3.434,3.510
 2309.409,115.765,903.320,117.608,-120.522,33.072,10.948,0.078,2.503,2.813,12.129,3.630,122.308,52.868,3.401,3.477
 2309.909,115.597,903.320,116.269,-120.162,32.612,10.872,0.079,2.487,2.803,13.066,3.558,121.496,52.294,3.366,3.454
 2310.409,115.681,893.555,116.593,-120.217,32.822,10.775,0.083,2.477,2.848,13.601,3.465,122.496,53.000,3.333,3.440
 2310.909,115.622,899.902,117.129,-119.888,33.886,10.603,0.086,2.470,2.901,14.040,3.397,122.328,52.882,3.304,3.425
 2311.409,115.651,906.543,116.307,-120.165,34.927,10.430,0.091,2.465,2.988,14.336,3.361,118.085,49.883,3.282,3.410
 2311.909,115.660,901.855,117.978,-120.880,34.873,10.347,0.099,2.459,3.108,14.696,3.321,110.218,44.323,3.249,3.386
 2312.409,115.692,901.172,119.021,-122.252,34.275,10.574,0.108,2.451,3.097,15.155,3.257,103.089,39.285,3.206,3.355
 2312.909,115.588,897.217,118.733,-123.935,34.359,10.854,0.115,2.442,3.043,15.659,3.195,98.231,35.852,3.139,3.318
 2313.409,115.655,898.438,118.877,-126.234,36.045,10.685,0.129,2.428,2.988,16.514,3.154,94.503,33.218,3.068,3.276
 2313.909,115.710,902.295,118.664,-128.577,38.726,10.459,0.158,2.397,2.964,18.294,3.099,92.734,31.968,2.990,3.239
 2314.409,115.674,901.758,117.246,-129.162,40.909,10.917,0.187,2.336,2.904,21.848,2.999,93.305,32.371,2.914,3.198
 2314.909,115.644,898.438,112.834,-128.970,41.385,11.924,0.203,2.263,2.788,26.156,2.884,94.377,33.128,2.838,3.154
 2315.409,115.742,903.320,107.530,-128.116,41.079,12.238,0.197,2.195,2.695,30.135,2.806,95.292,33.776,2.748,3.090
 2315.909,115.741,903.320,103.816,-127.978,42.297,11.695,0.186,2.158,2.639,32.273,2.770,96.280,34.473,2.662,3.021
 2316.409,115.800,903.320,108.243,-128.362,44.501,11.692,0.182,2.166,2.573,31.809,2.742,98.126,35.778,2.589,2.965
 2316.909,115.632,903.320,118.069,-128.046,46.423,12.087,0.178,2.199,2.516,29.885,2.709,99.650,36.855,2.537,2.910
 2317.409,115.702,903.320,126.682,-127.895,48.065,12.257,0.174,2.235,2.573,27.755,2.680,99.029,36.416,2.511,2.860
 2317.909,115.757,903.320,129.107,-127.651,49.256,12.049,0.175,2.245,2.663,27.176,2.658,96.893,34.907,2.470,2.790
 2318.409,115.731,895.947,122.121,-127.968,50.366,11.608,0.182,2.230,2.712,28.073,2.635,94.978,33.553,2.410,2.709
 2318.909,115.595,908.203,116.372,-127.825,50.643,11.662,0.185,2.215,2.708,28.921,2.597,94.600,33.286,2.333,2.653
 2319.409,115.735,905.469,114.320,-127.395,49.973,11.879,0.173,2.209,2.693,29.269,2.529,96.171,34.397,2.277,2.641
 2319.909,115.626,903.320,115.874,-127.275,51.808,11.735,0.158,2.192,2.709,30.298,2.437,98.808,36.260,2.278,2.718
 2320.409,115.676,903.320,117.844,-127.996,55.772,11.096,0.146,2.152,2.669,32.616,2.376,101.491,38.156,2.362,2.887
 2320.909,115.828,907.568,114.300,-128.112,58.562,10.921,0.127,2.155,2.653,32.473,2.544,101.711,38.312,2.537,3.133
 2321.409,115.745,903.320,101.786,-128.290,57.361,10.588,0.088,2.252,2.889,26.756,3.270,94.846,33.460,2.794,3.420
 2321.909,115.689,904.199,84.748,-128.706,50.197,9.391,0.041,2.416,3.310,17.200,5.048,82.529,24.756,3.144,3.702
 2322.409,115.760,901.367,66.399,-129.608,38.522,8.696,0.009,2.566,3.812,8.403,8.609,71.205,16.753,3.613,4.065
 2322.909,115.842,898.438,49.506,-131.049,25.892,8.615,-0.000,2.643,4.293,3.906,12.787,65.339,12.607,4.285,4.575
 2323.409,115.776,902.100,38.554,-132.199,15.597,8.607,0.004,2.668,4.570,2.437,15.008,65.491,12.715,5.239,5.393
 2323.909,115.840,902.002,34.636,-134.001,9.644,8.608,0.010,2.679,4.711,1.793,14.044,67.918,14.430,6.506,6.504
 2324.409,115.789,902.344,38.685,-136.061,7.680,8.608,0.012,2.678,4.562,1.900,11.152,70.259,16.084,7.673,7.575
 2324.909,115.740,903.320,44.773,-137.466,8.334,8.608,0.008,2.667,4.272,2.488,9.252,75.148,19.539,8.161,8.138
 2325.409,115.819,911.621,50.670,-138.094,9.636,8.607,0.006,2.657,4.174,3.113,8.758,83.156,25.198,7.713,7.834
 2325.909,115.757,908.203,53.731,-137.711,10.215,8.613,0.009,2.648,4.162,3.631,8.313,91.643,31.197,6.961,7.170
 2326.409,115.709,903.857,57.475,-136.282,10.317,8.642,0.020,2.645,4.186,3.782,7.290,99.210,36.544,6.390,6.614
 2326.909,115.756,906.934,61.824,-134.619,10.724,8.679,0.030,2.642,4.212,3.973,6.296,103.900,39.859,6.091,6.293
 2327.409,115.869,898.438,61.688,-133.280,11.574,8.698,0.029,2.632,4.282,4.551,6.038,106.312,41.563,6.079,6.262
 2327.909,115.675,915.674,64.421,-133.055,12.460,8.706,0.026,2.627,4.279,4.865,6.393,106.905,41.982,6.248,6.367
 2328.409,115.746,893.750,67.470,-133.159,13.097,8.710,0.023,2.624,4.285,5.012,7.521,105.960,41.315,6.556,6.542
 2328.909,115.632,906.006,66.963,-133.994,13.200,8.666,0.028,2.639,4.454,4.125,9.471,104.230,40.092,6.945,6.736
 2329.409,115.932,912.695,64.034,-135.874,12.411,8.615,0.029,2.653,4.730,3.361,11.292,102.423,38.815,7.373,6.853
 2329.909,115.837,903.320,62.962,-138.349,10.727,8.604,0.026,2.656,4.903,3.157,11.787,99.989,37.095,7.864,7.021
 2330.409,115.842,912.646,65.154,-140.593,9.288,8.602,0.026,2.661,4.741,2.870,11.467,94.049,32.897,8.313,7.145
 2330.909,115.756,905.225,61.696,-142.534,9.099,8.599,0.022,2.656,4.510,3.130,12.956,85.499,26.855,8.610,7.219
 2331.409,115.927,903.320,50.414,-145.492,9.451,8.584,0.015,2.648,4.504,3.636,17.560,77.370,21.110,8.689,7.147
 2331.909,115.939,906.543,34.721,-149.445,9.116,8.567,0.004,2.632,4.650,4.568,24.743,71.952,17.281,8.443,6.815
 2332.409,115.714,908.203,23.752,-153.432,8.004,8.564,-0.002,2.617,4.800,5.428,30.667,70.120,15.986,8.057,6.406
 2332.909,115.850,908.203,18.824,-157.106,6.861,8.560,-0.000,2.609,4.830,5.893,31.737,68.658,14.953,7.555,5.945
 2333.409,115.774,909.326,16.860,-160.160,6.603,8.554,0.000,2.590,4.880,7.016,27.761,66.132,13.167,7.069,5.545
 2333.909,115.761,909.424,17.193,-163.783,7.374,8.552,0.002,2.559,4.972,8.824,20.865,63.459,11.279,6.611,5.215
 2334.409,115.839,908.203,18.749,-166.320,8.680,8.552,0.005,2.527,4.924,10.713,14.686,61.431,9.845,6.188,4.937
 2334.909,115.955,904.297,19.039,-168.555,10.172,8.552,0.010,2.501,4.808,12.195,11.048,61.168,9.659,5.825,4.725
 2335.409,115.853,913.086,17.954,-169.552,11.546,8.552,0.017,2.491,4.636,12.820,9.858,61.960,10.219,5.508,4.536
 2335.909,115.883,908.936,17.810,-170.563,12.556,8.551,0.023,2.490,4.504,12.869,10.258,61.819,10.119,5.259,4.375
 2336.409,115.846,905.127,20.090,-170.918,13.132,8.552,0.032,2.506,4.513,11.952,11.011,60.470,9.166,5.043,4.234
 2336.909,115.809,908.203,23.266,-170.920,13.279,8.556,0.038,2.525,4.550,10.813,11.005,58.620,7.858,4.865,4.114
 2337.409,115.905,900.000,24.556,-170.803,12.861,8.567,0.037,2.530,4.628,10.553,9.700,57.255,6.894,4.728,4.046
 2337.909,115.758,893.311,24.273,-171.390,12.280,8.584,0.031,2.513,4.685,11.511,7.940,56.855,6.611,4.625,4.029
 2338.409,115.820,922.852,22.624,-172.903,12.142,8.602,0.024,2.480,4.613,13.459,6.731,57.544,7.098,4.603,4.079
 2338.909,116.018,908.350,20.090,-174.824,12.528,8.599,0.021,2.457,4.542,14.782,6.361,58.544,7.805,4.630,4.198
 2339.409,115.934,905.859,17.125,-176.367,13.155,8.603,0.023,2.461,4.485,14.574,6.940,59.141,8.227,4.726,4.301
 2339.909,115.764,907.813,16.387,-176.606,13.175,8.636,0.029,2.484,4.428,13.241,8.532,58.846,8.018,4.872,4.453
 2340.409,115.840,904.004,18.827,-176.312,12.295,8.687,0.032,2.502,4.434,12.144,11.793,57.541,7.096,5.119,4.650
 2340.909,115.954,903.320,20.189,-175.794,11.141,8.691,0.034,2.512,4.435,11.554,16.108,56.120,6.092,5.421,4.941
 2341.409,115.841,906.299,18.825,-175.334,10.185,8.673,0.037,2.523,4.425,10.927,20.241,55.194,5.438,5.962,5.373
 2341.909,115.948,909.570,17.281,-175.860,9.659,8.690,0.039,2.538,4.407,10.062,22.789,54.933,5.253,6.567,5.827
 2342.409,115.844,917.969,17.550,-176.363,9.479,8.715,0.035,2.555,4.393,9.092,23.286,55.935,5.961,7.331,6.353
 2342.909,115.875,910.059,19.563,-176.155,9.426,8.753,0.021,2.558,4.545,8.863,22.850,59.559,8.522,8.125,6.996
 2343.409,115.945,917.969,21.540,-175.005,9.268,8.793,0.009,2.561,4.802,8.721,23.475,64.893,12.292,8.902,7.584
 2343.909,115.883,913.086,21.909,-173.557,8.789,8.838,0.006,2.572,5.053,8.054,26.203,68.892,15.118,9.718,8.363
 2344.409,115.828,920.508,20.206,-172.845,7.963,8.882,0.010,2.585,5.171,7.315,30.403,69.029,15.215,10.461,9.012
 2344.909,115.948,914.453,16.498,-172.630,7.167,8.875,0.013,2.583,5.163,7.404,34.089,66.595,13.495,11.154,9.753
 2345.409,115.819,917.969,13.280,-171.954,6.796,8.825,0.019,2.575,5.141,7.888,36.389,66.068,13.122,12.075,10.536
 2345.909,115.941,913.086,14.039,-171.869,6.930,8.779,0.027,2.576,5.148,7.815,38.014,71.336,16.845,12.995,11.167
 2346.409,116.012,913.086,16.975,-172.013,7.170,8.758,0.030,2.589,5.098,7.052,40.060,80.344,23.212,13.978,11.954
 2346.909,115.876,911.230,19.162,-172.836,7.038,8.758,0.024,2.609,4.924,5.898,42.340,88.752,29.154,14.972,12.683
 2347.409,115.903,908.203,20.317,-173.258,6.590,8.758,0.011,2.618,4.777,5.355,43.609,92.589,31.865,15.841,13.479
 2347.909,115.998,911.719,20.510,-173.396,6.214,8.759,0.001,2.619,4.733,5.332,44.032,91.610,31.173,16.716,14.312
 2348.409,116.009,922.852,19.816,-172.659,6.020,8.759,-0.002,2.622,4.771,5.166,44.974,88.448,28.939,17.473,15.179
 2348.909,115.940,915.381,18.666,-171.849,5.851,8.759,-0.001,2.630,4.846,4.679,48.451,84.776,26.344,18.358,16.161
 2349.409,115.985,908.203,18.273,-170.906,5.539,8.758,0.003,2.647,4.856,3.663,54.661,83.708,25.588,19.464,17.243
 2349.909,115.951,908.203,19.893,-171.113,5.045,8.759,0.006,2.659,4.763,2.983,62.756,85.606,26.930,20.816,18.450
 2350.409,115.920,917.480,22.377,-171.080,4.554,8.759,0.006,2.659,4.617,2.968,70.948,88.077,28.676,22.588,19.816
 2350.909,116.026,908.203,23.890,-171.052,4.144,8.758,0.002,2.648,4.558,3.634,78.651,88.851,29.224,24.607,21.449
 2351.409,116.000,908.203,25.397,-170.418,3.826,8.756,-0.003,2.636,4.683,4.309,88.099,87.794,28.476,26.850,23.335
 2351.909,116.012,908.203,26.689,-169.667,3.606,8.753,-0.003,2.641,4.865,4.026,102.037,86.017,27.220,29.263,25.350
 2352.409,115.998,903.320,26.844,-168.531,3.406,8.753,0.001,2.656,5.023,3.133,115.605,84.797,26.358,31.499,27.216
 2352.909,115.860,916.406,26.573,-168.091,3.195,8.756,0.005,2.671,5.083,2.259,120.319,83.044,25.120,33.771,28.722
 2353.409,116.005,914.014,25.531,-167.113,3.075,8.767,0.008,2.678,5.009,1.894,114.376,80.994,23.671,35.668,30.094
 2353.909,116.091,917.969,23.082,-166.686,3.109,8.779,0.008,2.679,4.867,1.829,103.918,80.981,23.662,37.312,31.188
 2354.409,115.943,915.430,21.086,-166.607,3.194,8.786,0.008,2.676,4.655,1.963,98.292,83.867,25.701,38.158,32.138
 2354.909,115.979,915.430,22.998,-166.793,3.211,8.793,0.006,2.673,4.507,2.161,99.182,86.842,27.803,38.619,32.716
 2355.409,115.862,914.502,28.855,-167.568,3.150,8.797,0.002,2.664,4.443,2.713,101.403,86.403,27.493,38.484,32.883
 2355.909,115.978,921.924,34.742,-167.532,3.109,8.799,-0.000,2.657,4.497,3.090,100.727,82.739,24.904,38.300,32.918
 2356.409,115.953,922.852,35.931,-167.150,3.221,8.802,0.002,2.659,4.651,2.955,97.213,79.669,22.735,38.211,32.958
 2356.909,116.001,922.852,33.755,-165.776,3.473,8.803,0.004,2.659,4.814,2.954,94.511,80.555,23.361,38.305,33.164
 2357.409,116.046,919.824,33.248,-164.550,3.757,8.804,0.003,2.658,4.866,3.037,95.881,83.348,25.334,38.494,33.530
 2357.909,115.952,927.295,37.425,-163.760,3.948,8.807,0.002,2.657,4.852,3.097,99.812,84.859,26.402,38.715,33.843
 2358.409,116.031,923.535,43.417,-163.640,3.866,8.810,0.001,2.658,4.833,3.013,102.300,81.219,23.830,38.721,34.228
 2358.909,115.898,913.330,48.257,-163.969,3.634,8.808,-0.000,2.660,4.761,2.927,100.173,73.436,18.329,38.840,34.543
 2359.409,116.039,920.508,48.370,-163.669,3.459,8.802,-0.001,2.659,4.712,2.954,93.088,68.641,14.941,38.862,34.959
 2359.909,116.110,917.969,43.831,-163.023,3.429,8.799,-0.001,2.659,4.666,3.004,85.375,69.573,15.599,39.214,35.591
 2360.409,115.950,917.676,38.786,-161.713,3.539,8.799,0.003,2.662,4.676,2.796,79.299,76.241,20.311,39.547,36.335
 2360.909,116.038,913.086,35.936,-159.992,3.660,8.799,0.007,2.666,4.659,2.587,76.737,83.612,25.521,39.960,36.867
 2361.409,115.924,913.086,37.641,-157.828,3.734,8.799,0.011,2.671,4.667,2.272,77.377,84.631,26.241,39.470,36.951
 2361.909,116.151,905.273,40.070,-155.608,3.731,8.799,0.012,2.680,4.703,1.771,77.700,80.176,23.092,38.413,36.267
 2362.409,116.037,922.852,40.768,-153.254,3.613,8.799,0.009,2.683,4.579,1.570,73.349,74.598,19.151,36.797,35.455
 2362.909,115.994,920.654,39.446,-151.619,3.446,8.799,0.007,2.680,4.399,1.757,61.953,70.165,16.018,35.357,34.848
 2363.409,116.119,908.203,38.193,-150.674,3.485,8.799,0.008,2.673,4.285,2.136,47.420,69.153,15.303,33.923,34.514
 2363.909,115.928,921.924,38.694,-150.310,3.895,8.802,0.014,2.673,4.343,2.135,36.242,70.116,15.983,32.925,34.414
 2364.409,116.067,917.969,40.414,-149.505,4.589,8.803,0.018,2.674,4.460,2.103,32.318,71.465,16.937,31.460,33.620
 2364.909,116.112,915.430,42.860,-148.766,5.177,8.800,0.017,2.671,4.468,2.281,33.796,72.462,17.641,29.961,32.200
 2365.409,115.996,922.852,46.632,-148.277,5.403,8.802,0.014,2.664,4.368,2.704,35.194,70.275,16.095,28.333,30.609
 2365.909,115.922,920.020,51.261,-148.840,5.398,8.806,0.011,2.657,4.360,3.114,33.578,66.456,13.397,26.938,29.045
 2366.409,116.040,913.086,53.463,-149.970,5.521,8.811,0.012,2.657,4.494,3.078,29.827,63.673,11.430,25.964,28.118
 2366.909,116.041,914.648,51.187,-149.824,5.931,8.813,0.011,2.650,4.609,3.482,26.169,62.855,10.851,25.318,27.595
 2367.409,115.991,908.203,47.202,-149.064,6.480,8.813,0.011,2.648,4.651,3.600,24.403,63.019,10.968,24.964,27.320
 2367.909,116.140,913.086,47.540,-148.166,6.961,8.813,0.011,2.650,4.635,3.517,24.116,62.359,10.501,24.666,27.221
 2368.409,115.818,921.973,50.151,-147.635,7.179,8.813,0.011,2.651,4.684,3.434,24.668,61.445,9.855,24.347,26.550
 2368.909,116.080,920.752,50.932,-147.592,7.112,8.813,0.012,2.651,4.645,3.461,26.510,63.902,11.592,23.919,25.750
 2369.409,116.085,913.281,46.636,-146.721,6.818,8.813,0.010,2.640,4.478,4.084,29.364,67.257,13.963,23.339,24.614
 2369.909,116.106,915.430,39.291,-145.105,6.360,8.813,0.009,2.633,4.304,4.484,31.494,67.875,14.399,22.978,23.954
 2370.409,115.912,917.822,34.896,-142.607,6.031,8.815,0.013,2.640,4.212,4.114,30.780,65.885,12.993,22.815,23.844
 2370.909,116.136,916.260,34.538,-140.259,6.067,8.817,0.020,2.652,4.187,3.391,27.381,63.957,11.630,22.939,24.107
 2371.409,115.918,917.725,37.331,-139.498,6.416,8.818,0.022,2.653,4.210,3.315,24.259,66.837,13.665,23.356,24.886
 2371.909,116.101,913.086,39.024,-139.918,6.884,8.818,0.020,2.647,4.381,3.709,24.257,73.458,18.345,23.815,25.489
 2372.409,116.147,908.691,38.621,-140.824,7.111,8.818,0.013,2.636,4.646,4.303,27.716,77.346,21.093,24.485,25.609
 2372.909,116.057,910.010,36.333,-139.738,6.995,8.819,0.006,2.627,4.882,4.846,32.719,75.818,20.013,25.204,25.367
 2373.409,116.063,909.668,34.561,-138.411,6.653,8.823,0.002,2.627,4.945,4.862,36.847,72.313,17.536,25.007,23.889
 2373.909,116.085,914.697,34.829,-136.651,6.274,8.835,0.003,2.636,4.852,4.315,38.682,72.775,17.862,23.778,22.224
 2374.409,115.941,918.945,35.998,-135.237,6.050,8.848,0.011,2.655,4.701,3.191,37.390,78.592,21.973,21.118,19.859
 2374.909,116.125,922.852,38.205,-133.947,6.057,8.855,0.018,2.655,4.590,3.236,32.348,86.264,27.395,18.191,17.466
 2375.409,116.099,917.969,41.703,-131.697,6.465,8.865,0.030,2.612,4.395,5.719,24.400,93.777,32.705,15.704,15.679
 2375.909,115.982,917.969,51.202,-129.646,7.568,9.139,0.052,2.550,4.001,9.382,16.114,99.967,37.079,13.784,14.375
 2376.409,116.077,916.553,63.720,-127.331,10.038,9.433,0.067,2.512,3.564,11.604,10.634,104.693,40.419,12.348,13.494
 2376.909,116.142,913.086,70.783,-125.120,13.909,9.301,0.065,2.529,3.349,10.589,9.151,108.243,42.928,11.101,12.495
 2377.409,116.088,919.629,69.352,-123.420,17.337,9.054,0.048,2.577,3.513,7.785,10.144,112.436,45.891,10.017,11.231
 2377.909,116.096,922.852,61.643,-122.188,18.617,8.921,0.037,2.619,3.836,5.301,11.493,118.286,50.025,9.236,10.225
 2378.409,116.136,919.873,55.564,-121.579,17.409,8.901,0.046,2.636,3.915,4.312,12.027,125.515,55.134,8.907,9.654
 2378.909,116.121,918.408,54.569,-121.372,15.283,8.915,0.064,2.644,3.747,3.844,11.646,132.375,59.982,8.999,9.625
 2379.409,116.024,917.969,56.507,-121.480,14.138,8.971,0.071,2.643,3.574,3.942,10.837,133.750,60.954,9.510,10.068
 2379.909,116.068,922.656,59.130,-121.950,14.283,9.054,0.059,2.632,3.565,4.583,10.274,130.640,58.756,10.103,10.664
 2380.409,116.076,920.557,60.152,-123.178,14.849,9.009,0.037,2.620,3.918,5.238,10.641,128.940,57.555,10.544,11.152
 2380.909,116.044,913.135,57.744,-123.824,14.835,8.965,0.019,2.615,4.309,5.578,11.743,133.304,60.639,10.598,11.099
 2381.409,116.234,923.145,57.848,-123.961,13.444,9.077,0.022,2.617,4.516,5.437,12.656,143.124,67.579,10.257,10.419
 2381.909,116.012,917.969,61.058,-122.724,11.442,9.112,0.045,2.625,4.483,4.959,12.517,152.501,74.206,9.691,9.497
 2382.409,116.131,917.969,63.158,-120.390,10.075,9.086,0.065,2.625,4.141,4.974,11.243,153.967,75.241,8.990,8.659
 2382.909,116.014,921.777,61.513,-118.267,10.114,9.087,0.068,2.624,3.859,5.001,9.504,148.983,71.720,8.202,7.991
 2383.409,116.101,916.162,59.194,-118.225,11.890,9.070,0.054,2.630,3.638,4.663,7.926,141.440,66.389,7.446,7.421
 2383.909,116.082,918.701,63.026,-118.299,14.489,9.080,0.034,2.629,3.498,4.761,6.754,132.507,60.076,6.757,6.916
 2384.409,116.261,919.531,70.580,-118.857,17.399,9.109,0.024,2.623,3.367,5.059,5.970,124.973,54.751,6.177,6.382
 2384.909,115.952,921.875,74.602,-117.533,19.741,9.104,0.021,2.616,3.244,5.501,5.691,120.394,51.516,5.689,5.890
 2385.409,115.991,917.969,75.253,-116.304,20.635,9.076,0.019,2.614,3.240,5.607,5.776,120.617,51.673,5.295,5.473
 2385.909,116.135,921.631,76.590,-115.061,20.170,9.066,0.018,2.615,3.263,5.547,5.853,124.197,54.203,5.022,5.192
 2386.409,116.071,929.248,79.233,-114.068,19.069,9.063,0.021,2.614,3.240,5.636,5.714,127.473,56.518,4.877,5.087
 2386.909,116.076,928.223,83.080,-112.621,18.792,9.063,0.025,2.603,3.162,6.243,5.467,128.924,57.543,4.858,5.088
 2387.409,116.186,921.973,84.782,-111.266,19.688,9.063,0.025,2.585,3.141,7.335,5.394,127.984,56.879,4.917,5.160
 2387.909,116.163,921.143,84.556,-111.483,20.852,9.062,0.023,2.582,3.164,7.493,5.722,125.045,54.802,4.972,5.176
 2388.409,116.151,917.969,80.402,-112.674,21.723,9.062,0.023,2.597,3.250,6.632,6.385,120.881,51.859,4.964,5.116
 2388.909,116.217,914.990,72.640,-113.857,21.583,9.063,0.025,2.615,3.414,5.573,6.830,117.227,49.277,4.888,4.997
 2389.409,116.143,931.445,69.949,-113.750,20.520,9.072,0.029,2.616,3.518,5.481,6.687,115.982,48.397,4.763,4.844
 2389.909,116.162,927.734,76.043,-112.646,19.352,9.096,0.034,2.597,3.462,6.597,5.941,117.065,49.163,4.641,4.723
 2390.409,116.254,913.525,90.200,-111.247,18.749,9.135,0.039,2.581,3.202,7.566,5.121,118.131,49.916,4.484,4.588
 2390.909,116.141,922.949,100.905,-110.428,19.491,9.177,0.037,2.572,2.986,8.085,4.755,117.926,49.771,4.290,4.419
 2391.409,116.125,918.018,102.997,-109.787,20.912,9.204,0.032,2.568,2.950,8.312,4.639,116.657,48.874,4.073,4.242
 2391.909,116.213,925.488,101.156,-110.387,22.490,9.219,0.026,2.566,2.939,8.405,4.549,115.965,48.385,3.868,4.066
 2392.409,116.033,922.559,97.985,-110.285,24.626,9.224,0.022,2.559,2.957,8.815,4.389,116.836,49.001,3.728,3.956
 2392.909,116.122,917.969,95.726,-110.337,27.480,9.198,0.020,2.545,2.904,9.642,4.278,119.345,50.774,3.661,3.897
 2393.409,116.114,918.506,92.605,-109.877,29.909,9.175,0.018,2.533,2.913,10.360,4.338,122.793,53.211,3.663,3.893
 2393.909,116.183,929.004,87.734,-109.709,30.266,9.173,0.016,2.533,2.944,10.359,4.482,125.476,55.107,3.705,3.934
 2394.409,116.107,931.836,83.254,-109.886,28.445,9.174,0.014,2.542,2.911,9.846,4.676,126.465,55.806,3.774,4.002
 2394.909,116.206,924.414,79.800,-110.200,25.778,9.154,0.012,2.549,2.957,9.410,4.915,125.393,55.048,3.859,4.109
 2395.409,116.232,923.877,78.451,-110.403,23.632,9.097,0.012,2.553,3.056,9.176,5.166,123.894,53.989,3.978,4.229
 2395.909,116.082,927.734,80.629,-110.361,22.747,9.061,0.015,2.561,3.188,8.708,5.319,124.343,54.306,4.128,4.385
 2396.409,116.173,932.617,83.357,-111.013,22.907,9.060,0.018,2.575,3.145,7.876,5.355,125.502,55.125,4.291,4.538
 2396.909,116.170,913.574,82.740,-110.729,23.326,9.060,0.016,2.583,3.039,7.439,5.492,125.746,55.297,4.440,4.669
 2397.409,116.132,914.063,80.990,-111.163,23.217,9.060,0.014,2.591,3.027,6.935,5.831,125.332,55.005,4.509,4.711
 2397.909,116.197,935.840,78.009,-110.841,22.185,9.060,0.014,2.601,3.164,6.381,6.219,123.189,53.491,4.518,4.676
 2398.409,116.073,930.664,76.724,-110.678,20.801,9.060,0.018,2.604,3.315,6.225,6.174,122.652,53.111,4.478,4.634
 2398.909,116.068,917.969,81.977,-111.058,20.123,9.060,0.024,2.604,3.262,6.191,5.690,124.471,54.397,4.440,4.604
 2399.409,116.162,924.805,88.839,-111.886,20.989,9.060,0.029,2.600,3.084,6.411,5.120,126.754,56.010,4.401,4.592
 2399.909,116.144,927.734,94.149,-111.978,23.013,9.060,0.028,2.594,2.936,6.773,4.849,129.035,57.622,4.344,4.531
 2400.409,116.205,929.932,94.169,-112.494,25.345,9.060,0.022,2.586,3.085,7.253,4.965,130.011,58.312,4.245,4.406
 2400.909,116.208,923.145,91.419,-111.608,26.623,9.061,0.015,2.572,3.256,8.093,5.075,128.924,57.543,4.116,4.262
 2401.409,116.218,927.637,90.705,-111.461,26.361,9.065,0.016,2.560,3.237,8.764,5.051,127.877,56.804,3.995,4.141
 2401.909,116.199,932.324,90.082,-111.805,25.977,9.071,0.021,2.552,3.106,9.238,4.939,125.547,55.157,3.913,4.088
 2402.409,116.105,923.242,89.720,-111.590,25.624,9.060,0.023,2.546,2.944,9.583,4.801,122.672,53.125,3.911,4.117
 2402.909,116.126,927.734,90.196,-111.017,25.330,9.043,0.019,2.545,2.892,9.623,4.681,123.626,53.799,3.968,4.217
 2403.409,116.094,927.734,88.529,-109.320,25.406,8.964,0.011,2.548,2.897,9.455,4.646,127.748,56.712,4.084,4.363
 2403.909,116.184,919.043,84.239,-108.367,26.119,8.886,0.005,2.558,2.950,8.915,4.926,132.432,60.022,4.214,4.500
 2404.409,116.299,927.734,76.794,-109.194,27.220,8.858,0.003,2.578,3.048,7.696,5.811,132.445,60.032,4.328,4.571
 2404.909,116.252,927.734,67.677,-110.842,26.764,8.828,0.002,2.602,3.243,6.332,6.878,126.934,56.137,4.426,4.595
 2405.409,116.198,924.365,61.953,-111.962,24.133,8.808,0.003,2.617,3.386,5.431,7.258,119.980,51.223,4.498,4.618
 2405.909,116.182,928.760,65.158,-111.722,21.303,8.802,0.006,2.609,3.310,5.899,6.718,117.773,49.663,4.583,4.703
 2406.409,116.193,932.617,77.567,-111.451,20.251,8.797,0.011,2.588,3.048,7.132,5.689,121.802,52.510,4.649,4.841
 2406.909,116.195,927.734,88.909,-110.813,21.337,8.780,0.012,2.569,2.841,8.240,5.157,128.070,56.940,4.701,4.961
 2407.409,116.228,923.926,92.339,-110.496,23.394,8.761,0.010,2.558,2.865,8.878,5.363,131.533,59.387,4.716,5.039
 2407.909,116.161,925.879,86.745,-111.256,25.076,8.756,0.007,2.558,2.976,8.915,5.714,130.542,58.687,4.738,5.064
 2408.409,116.306,928.564,79.313,-112.214,25.640,8.756,0.004,2.554,3.041,9.130,5.925,128.538,57.271,4.801,5.109
 2408.909,116.099,919.189,74.746,-114.090,24.820,8.756,0.004,2.557,3.046,8.940,6.200,126.808,56.048,4.909,5.161
 2409.409,116.076,903.320,71.558,-114.579,23.080,8.755,0.004,2.571,3.196,8.148,6.771,124.671,54.538,5.057,5.230
 2409.909,116.117,924.805,69.516,-114.340,21.090,8.754,0.006,2.588,3.457,7.132,7.272,120.949,51.907,5.180,5.318
 2410.409,116.320,923.193,68.530,-114.252,19.628,8.753,0.008,2.600,3.652,6.416,7.357,118.131,49.916,5.292,5.427
 2410.909,116.124,922.852,71.071,-113.909,19.330,8.753,0.010,2.593,3.548,6.863,6.788,118.663,50.292,5.386,5.615
 2411.409,116.341,918.115,76.315,-114.509,19.870,8.753,0.010,2.573,3.192,7.987,6.165,121.799,52.508,5.484,5.770
 2411.909,116.101,920.410,78.153,-114.668,20.974,8.753,0.006,2.558,2.963,8.889,6.249,125.179,54.897,5.553,5.865
 2412.409,116.159,913.184,75.385,-114.771,21.598,8.753,0.001,2.552,2.924,9.225,6.728,126.392,55.754,5.583,5.842
 2412.909,116.330,926.025,70.703,-115.127,20.823,8.754,-0.003,2.554,2.998,9.150,7.205,126.885,56.103,5.511,5.724
 2413.409,116.208,927.734,68.401,-115.748,19.416,8.758,-0.003,2.562,3.147,8.635,7.307,127.997,56.889,5.456,5.636
 2413.909,116.256,927.734,71.740,-116.459,18.610,8.762,0.000,2.572,3.192,8.084,6.947,130.027,58.323,5.390,5.566
 2414.409,116.249,928.320,76.944,-116.216,18.885,8.763,0.005,2.580,3.198,7.582,6.600,132.680,60.198,5.375,5.556
 2414.909,116.262,929.492,81.545,-114.147,19.855,8.765,0.008,2.581,3.209,7.544,6.312,134.519,61.497,5.358,5.584
 2415.409,116.237,926.904,82.383,-113.319,20.602,8.765,0.007,2.567,3.143,8.341,6.100,133.511,60.785,5.335,5.611
 2415.909,116.300,922.852,77.994,-113.025,20.849,8.765,0.005,2.557,3.104,8.932,6.046,129.590,58.014,5.326,5.667
 2416.409,116.237,932.617,71.025,-113.761,20.878,8.765,0.002,2.554,3.081,9.109,6.162,123.670,53.831,5.325,5.690
 2416.909,116.249,929.004,65.455,-114.735,20.633,8.765,0.002,2.560,3.127,8.779,6.401,118.436,50.132,5.373,5.731
 2417.409,116.334,921.582,65.423,-115.344,20.124,8.765,0.005,2.575,3.209,7.891,6.604,116.610,48.841,5.454,5.802
 2417.909,116.173,917.969,65.658,-115.791,19.422,8.765,0.008,2.589,3.282,7.080,6.803,118.286,50.026,5.570,5.910
 2418.409,116.296,919.482,64.891,-115.361,18.700,8.765,0.011,2.598,3.392,6.528,6.918,123.398,53.638,5.718,6.081
 2418.909,116.117,918.799,66.180,-114.501,18.150,8.765,0.016,2.606,3.405,6.078,6.965,128.398,57.172,5.874,6.256
 2419.409,116.243,927.734,69.618,-113.793,17.916,8.765,0.018,2.603,3.354,6.231,7.002,131.145,59.113,6.051,6.455
 2419.909,116.210,927.734,73.124,-113.350,17.982,8.765,0.017,2.595,3.218,6.750,7.102,131.796,59.573,6.211,6.627
 2420.409,116.221,925.732,74.660,-113.515,18.067,8.764,0.012,2.587,3.166,7.188,7.484,132.436,60.026,6.363,6.775
 2420.909,116.219,922.852,72.938,-113.668,18.048,8.765,0.006,2.582,3.295,7.465,7.915,135.275,62.032,6.504,6.910
 2421.409,116.327,920.654,71.431,-114.841,17.839,8.764,0.006,2.587,3.369,7.212,8.067,139.222,64.821,6.638,7.013
 2421.909,116.269,922.754,71.171,-115.797,17.414,8.764,0.004,2.584,3.339,7.375,8.050,142.030,66.806,6.768,7.136
 2422.409,116.259,925.293,69.585,-116.632,17.078,8.770,0.002,2.582,3.298,7.471,8.089,142.144,66.886,6.859,7.241
 2422.909,116.319,927.441,67.713,-116.257,16.852,8.776,0.002,2.589,3.277,7.104,8.183,140.332,65.605,6.946,7.366
 2423.409,116.270,920.654,66.342,-115.628,16.690,8.776,0.004,2.593,3.314,6.858,8.148,137.498,63.603,7.031,7.557
 2423.909,116.304,927.734,66.939,-115.276,16.598,8.776,0.007,2.595,3.319,6.724,8.014,134.907,61.772,7.195,7.803
 2424.409,116.264,924.805,68.065,-115.816,16.456,8.776,0.006,2.588,3.327,7.129,7.945,132.771,60.262,7.462,8.115
 2424.909,116.360,923.438,69.944,-116.630,16.649,8.776,0.004,2.587,3.348,7.210,8.242,129.945,58.265,7.753,8.321
 2425.409,116.168,924.561,67.938,-117.672,17.234,8.777,0.001,2.590,3.419,7.034,9.455,125.165,54.887,8.014,8.411
 2425.909,116.291,921.191,65.172,-117.762,17.432,8.777,-0.001,2.597,3.598,6.583,11.037,119.784,51.084,8.105,8.367
 2426.409,116.234,923.193,66.479,-117.679,16.702,8.785,0.002,2.617,3.779,5.445,12.073,114.084,47.056,8.100,8.290
 2426.909,116.447,922.852,68.392,-116.898,15.375,8.797,0.009,2.636,3.869,4.308,11.733,106.559,41.738,8.098,8.389
 2427.409,116.381,922.852,72.243,-116.955,14.588,8.802,0.017,2.645,3.702,3.812,10.170,98.258,35.871,8.264,8.682
 2427.909,116.199,917.969,73.513,-117.837,15.166,8.794,0.016,2.630,3.436,4.693,8.754,91.219,30.897,8.649,9.338
 2428.409,116.221,925.684,72.695,-119.461,16.949,8.774,0.008,2.609,3.238,5.932,9.270,87.111,27.994,9.218,10.097
 2428.909,116.247,927.734,64.883,-122.246,18.516,8.743,-0.001,2.605,3.408,6.155,14.110,84.997,26.500,9.886,10.790
 2429.409,116.348,927.734,50.877,-126.367,18.265,8.714,-0.003,2.626,3.858,4.934,22.006,82.420,24.678,10.543,11.157
 2429.909,116.280,927.734,37.922,-130.057,15.781,8.705,-0.001,2.651,4.325,3.460,28.530,77.647,21.306,11.096,11.138
 2430.409,116.283,927.734,28.780,-133.368,12.223,8.708,0.001,2.667,4.609,2.538,30.553,73.022,18.036,11.525,11.045
 2430.909,116.397,927.734,27.837,-134.707,9.529,8.718,0.000,2.670,4.539,2.351,26.898,70.207,16.047,11.543,10.790
 2431.409,116.233,927.734,32.016,-134.202,8.392,8.741,0.002,2.663,4.464,2.725,21.015,70.527,16.274,11.298,10.587
 2431.909,116.339,925.488,39.916,-133.158,8.632,8.771,0.010,2.651,4.351,3.466,15.141,74.841,19.322,10.676,10.352
 2432.409,116.436,927.637,49.050,-131.581,9.873,8.813,0.018,2.630,4.183,4.662,10.550,80.197,23.108,9.960,10.004
 2432.909,116.376,922.852,57.994,-131.768,12.036,8.785,0.020,2.624,3.913,5.005,8.585,87.533,28.292,9.298,9.609
 2433.409,116.295,918.262,60.817,-132.446,14.155,8.717,0.015,2.631,3.625,4.612,8.960,95.609,33.999,8.674,8.990
 2433.909,116.271,925.049,53.758,-133.829,15.250,8.697,0.007,2.644,3.693,3.875,11.020,102.158,38.628,8.305,8.523
 2434.409,116.317,927.734,42.300,-134.368,15.099,8.687,0.002,2.648,3.915,3.618,12.681,106.257,41.524,8.208,8.322
 2434.909,116.334,927.734,33.117,-135.082,14.056,8.685,0.003,2.645,4.058,3.806,12.997,107.706,42.548,8.504,8.421
 2435.409,116.277,922.217,31.046,-135.445,13.093,8.682,0.008,2.644,4.096,3.844,12.463,106.887,41.970,9.260,8.853
 2435.909,116.289,917.969,34.122,-136.050,12.781,8.664,0.014,2.651,4.147,3.466,12.290,109.940,44.128,9.978,9.145
 2436.409,116.395,909.863,38.618,-136.395,13.079,8.644,0.015,2.661,4.311,2.894,13.216,117.262,49.302,10.248,9.141
 2436.909,116.358,921.387,41.928,-136.270,13.282,8.642,0.011,2.665,4.497,2.638,14.715,125.871,55.386,9.656,8.700
 2437.409,116.306,927.734,41.524,-137.142,12.820,8.650,0.007,2.663,4.597,2.771,15.598,131.901,59.648,8.629,7.893
 2437.909,116.453,927.734,41.676,-138.525,11.890,8.660,0.006,2.611,4.621,5.786,14.363,126.893,56.108,7.893,7.311
 2438.409,116.400,924.170,49.024,-140.193,11.842,8.687,0.016,2.512,4.348,11.555,11.208,114.549,47.384,7.386,6.882
 2438.909,116.349,912.305,70.527,-140.443,14.768,9.018,0.027,2.433,3.907,16.172,8.062,100.244,37.275,7.164,6.574
 2439.409,116.327,914.453,92.945,-141.283,20.243,9.075,0.028,2.434,3.726,16.160,7.749,88.526,28.993,6.857,6.148
 2439.909,116.418,931.836,98.740,-143.827,24.160,8.691,0.019,2.499,3.943,12.356,10.112,82.607,24.810,6.338,5.409
 2440.409,116.211,922.852,84.793,-149.250,23.528,8.542,0.004,2.543,4.383,9.769,12.579,78.939,22.218,5.790,4.750
 2440.909,116.392,927.197,62.917,-155.986,19.453,8.496,-0.004,2.537,4.593,10.114,13.716,74.292,18.934,5.375,4.235
 2441.409,116.358,924.854,47.571,-161.729,15.652,8.484,-0.005,2.520,4.558,11.103,13.075,68.235,14.654,5.137,3.917
 2441.909,116.321,923.145,39.270,-166.613,14.227,8.475,-0.002,2.519,4.570,11.151,11.670,62.233,10.412,5.038,3.718
 2442.409,116.324,922.852,36.036,-169.151,14.268,8.471,0.002,2.517,4.574,11.269,9.893,59.103,8.200,4.860,3.533
 2442.909,116.367,922.852,33.352,-170.817,14.864,8.485,0.003,2.508,4.485,11.834,8.755,58.963,8.101,4.612,3.358
 2443.409,116.396,932.617,32.952,-171.998,15.729,8.587,0.001,2.508,4.520,11.823,9.202,59.518,8.493,4.288,3.184
 2443.909,116.364,927.441,32.625,-173.227,16.139,8.680,-0.002,2.512,4.603,11.569,9.794,60.137,8.930,3.988,3.006
 2444.409,116.430,920.703,31.709,-173.914,15.946,8.683,-0.003,2.510,4.710,11.672,9.443,61.291,9.747,3.791,2.877
 2444.909,116.266,927.734,31.369,-174.761,15.903,8.706,-0.002,2.501,4.727,12.203,8.244,63.602,11.380,3.686,2.786
 2445.409,116.296,927.734,30.458,-175.036,16.662,8.794,0.000,2.502,4.559,12.182,7.765,66.213,13.225,3.631,2.734
 2445.909,116.359,927.100,32.231,-175.689,17.859,8.871,0.001,2.521,4.408,11.040,8.983,68.771,15.033,3.608,2.711
 2446.409,116.473,922.852,33.240,-176.446,18.234,8.915,-0.001,2.546,4.342,9.617,10.810,70.223,16.059,3.586,2.702
 2446.909,116.402,929.492,33.685,-177.531,17.539,8.960,-0.004,2.557,4.398,8.951,11.961,68.731,15.004,3.581,2.718
 2447.409,116.436,927.246,35.295,-177.970,16.763,8.996,-0.004,2.548,4.575,9.491,11.514,65.902,13.005,3.610,2.764
 2447.909,116.455,922.852,39.160,-177.906,16.424,9.017,-0.000,2.522,4.779,11.005,10.111,64.193,11.797,3.677,2.827
 2448.409,116.375,919.189,45.804,-177.950,16.674,8.904,0.002,2.490,4.918,12.850,9.211,65.922,13.019,3.782,2.915
 2448.909,116.503,929.053,49.296,-178.149,17.421,8.717,0.004,2.477,4.954,13.646,9.315,70.695,16.392,3.904,3.013
 2449.409,116.507,932.617,49.482,-178.911,18.265,8.624,0.005,2.485,4.904,13.169,10.295,73.887,18.648,4.026,3.125
 2449.909,116.423,929.492,47.145,-179.111,18.864,8.609,0.004,2.501,4.795,12.227,11.590,72.423,17.613,4.166,3.253
 2450.409,116.422,922.852,43.816,-178.389,18.922,8.611,0.001,2.513,4.706,11.522,12.520,67.836,14.372,4.319,3.394
 2450.909,116.449,917.969,44.319,-177.941,18.284,8.620,-0.003,2.515,4.700,11.378,12.788,62.671,10.721,4.505,3.540
 2451.409,116.556,926.660,47.198,-176.645,17.431,8.636,-0.004,2.516,4.694,11.360,12.628,60.055,8.873,4.708,3.680
 2451.909,116.484,930.566,51.442,-175.717,16.673,8.649,-0.003,2.519,4.623,11.164,12.817,60.263,9.020,4.882,3.770
 2452.409,116.408,927.734,53.666,-175.028,15.925,8.657,-0.000,2.529,4.528,10.578,14.093,60.717,9.341,4.984,3.794
 2452.909,116.498,925.439,49.683,-174.907,15.325,8.657,0.001,2.542,4.375,9.810,15.880,60.770,9.378,4.956,3.726
 2453.409,116.586,937.354,46.877,-175.027,15.217,8.657,0.002,2.555,4.375,9.084,16.922,60.406,9.121,4.806,3.592
 2453.909,116.476,932.617,47.461,-175.612,15.886,8.659,0.002,2.551,4.638,9.276,15.890,60.110,8.911,4.575,3.432
 2454.409,116.446,937.500,48.401,-176.312,16.771,8.662,0.004,2.535,4.887,10.260,13.418,60.283,9.034,4.308,3.273
 2454.909,116.446,929.297,46.644,-176.998,17.451,8.650,0.012,2.517,4.968,11.281,10.935,61.310,9.760,4.062,3.146
 2455.409,116.501,932.617,42.742,-177.173,18.163,8.630,0.023,2.503,4.813,12.129,9.068,62.842,10.842,3.863,3.059
 2455.909,116.433,932.617,41.525,-176.720,18.785,8.616,0.034,2.502,4.601,12.162,8.052,64.215,11.813,3.725,3.016
 2456.409,116.306,929.004,41.929,-176.179,19.269,8.611,0.038,2.503,4.569,12.093,7.464,65.118,12.451,3.658,3.019
 2456.909,116.466,937.500,40.943,-176.346,19.715,8.605,0.035,2.499,4.642,12.348,7.261,65.807,12.938,3.657,3.068
 2457.409,116.468,929.980,38.508,-177.086,20.094,8.576,0.032,2.500,4.674,12.298,7.790,67.647,14.238,3.720,3.154
 2457.909,116.498,928.369,36.232,-178.052,20.250,8.543,0.028,2.505,4.672,12.017,8.428,70.600,16.325,3.856,3.291
 2458.409,116.395,932.617,35.204,-178.189,19.747,8.531,0.020,2.508,4.594,11.809,8.682,72.556,17.707,4.054,3.463
 2458.909,116.517,932.617,34.558,-178.184,18.678,8.522,0.010,2.513,4.517,11.496,9.469,71.514,16.971,4.320,3.672
 2459.409,116.580,922.070,32.080,-177.661,17.837,8.509,-0.000,2.519,4.521,11.156,12.151,68.024,14.504,4.630,3.882
 2459.909,116.396,932.617,29.991,-176.836,17.195,8.501,-0.005,2.531,4.569,10.446,16.104,65.230,12.530,4.936,4.052
 2460.409,116.546,929.395,30.304,-175.594,16.248,8.499,-0.005,2.545,4.642,9.623,19.053,66.483,13.416,5.199,4.165
 2460.909,116.561,922.852,32.936,-174.098,15.180,8.498,-0.005,2.549,4.667,9.418,19.265,70.815,16.477,5.369,4.207
 2461.409,116.555,927.734,37.480,-172.636,14.418,8.511,-0.003,2.548,4.688,9.498,17.092,74.408,19.017,5.431,4.181
 2461.909,116.382,932.129,40.337,-171.680,14.106,8.571,-0.003,2.546,4.703,9.609,15.012,74.493,19.076,5.395,4.104
 2462.409,116.504,935.449,40.265,-171.268,13.952,8.665,-0.003,2.545,4.664,9.674,14.711,71.305,16.823,5.256,3.989
 2462.909,116.647,932.617,38.617,-171.332,13.589,8.722,-0.002,2.554,4.649,9.136,15.710,67.308,13.999,5.083,3.872
 2463.409,116.563,934.912,34.817,-170.985,13.179,8.776,0.004,2.574,4.666,7.935,16.884,64.138,11.759,4.899,3.766
 2463.909,116.459,927.832,31.805,-169.569,12.914,8.806,0.009,2.594,4.696,6.758,17.555,62.154,10.356,4.753,3.670
 2464.409,116.478,932.617,30.028,-167.019,12.637,8.731,0.009,2.597,4.754,6.607,16.933,61.625,9.983,4.629,3.590
 2464.909,116.627,932.617,30.623,-163.920,12.502,8.637,0.007,2.587,4.717,7.222,15.399,62.269,10.437,4.490,3.510
 2465.409,116.523,935.400,35.033,-161.263,12.929,8.605,0.005,2.567,4.664,8.345,13.279,63.528,11.327,4.301,3.432
 2465.909,116.591,932.617,38.457,-157.931,13.949,8.614,0.005,2.548,4.561,9.490,11.185,67.454,14.102,4.074,3.356
 2466.409,116.447,932.617,38.634,-153.397,15.044,8.632,0.006,2.545,4.452,9.638,9.416,76.306,20.358,3.827,3.279
 2466.909,116.549,928.418,44.734,-146.663,15.826,8.659,0.010,2.549,4.350,9.438,7.471,85.969,27.187,3.612,3.224
 2467.409,116.551,932.617,67.224,-138.420,17.328,8.681,0.024,2.549,3.951,9.419,5.328,94.103,32.935,3.425,3.183
 2467.909,116.651,938.428,103.373,-130.186,21.185,8.747,0.037,2.528,3.399,10.651,3.758,99.510,36.756,3.269,3.146
 2468.409,116.524,938.916,138.356,-124.085,27.465,8.725,0.040,2.500,2.953,12.279,3.349,104.006,39.934,3.149,3.115
 2468.909,116.540,927.734,156.729,-120.799,33.623,8.588,0.033,2.482,2.737,13.325,3.514,109.165,43.580,3.065,3.077
 2469.409,116.612,931.445,164.061,-119.363,37.351,8.511,0.023,2.478,2.744,13.595,3.743,111.635,45.325,3.060,3.088
 2469.909,116.448,932.617,172.925,-118.805,38.959,8.473,0.020,2.473,2.782,13.872,3.977,109.371,43.725,3.144,3.155
 2470.409,116.641,932.617,189.525,-120.245,40.185,8.438,0.019,2.447,2.774,15.398,4.594,104.060,39.971,3.327,3.272
 2470.909,116.629,937.500,205.323,-124.330,42.216,8.402,0.018,2.417,2.778,17.146,6.054,97.482,35.323,3.597,3.424
 2471.409,116.509,937.500,195.270,-130.290,44.997,8.359,0.014,2.408,3.036,17.633,8.432,91.239,30.911,3.910,3.566
 2471.909,116.549,927.734,155.892,-135.950,44.437,8.348,0.009,2.448,3.528,15.316,11.715,86.618,27.645,4.255,3.728
 2472.409,116.706,923.340,104.833,-140.070,38.877,8.413,0.002,2.526,3.971,10.783,15.313,81.441,23.987,4.614,3.928
 2472.909,116.474,929.834,67.095,-143.137,29.457,8.480,-0.001,2.605,4.258,6.142,18.063,77.188,20.981,5.003,4.143
 2473.409,116.699,932.617,54.840,-145.411,20.455,8.502,0.000,2.651,4.326,3.460,18.843,75.273,19.628,5.404,4.379
 2473.909,116.657,928.027,58.926,-146.595,16.624,8.518,0.002,2.633,4.372,4.502,17.475,75.473,19.769,5.689,4.522
 2474.409,116.703,942.383,66.467,-146.969,16.019,8.567,0.003,2.582,4.411,7.508,15.687,78.151,21.662,5.793,4.576
 2474.909,116.519,937.500,71.002,-145.729,15.990,8.659,0.002,2.537,4.438,10.099,15.061,82.602,24.807,5.595,4.494
 2475.409,116.582,927.734,71.464,-143.206,15.167,8.747,0.000,2.523,4.599,10.926,14.849,91.807,31.312,5.210,4.296
 2475.909,116.608,924.951,70.708,-138.306,13.750,8.805,0.015,2.530,4.738,10.542,13.032,105.439,40.946,4.785,4.089
 2476.409,116.659,932.617,80.953,-132.620,12.952,8.880,0.053,2.521,4.497,11.078,9.683,118.013,49.832,4.358,3.889
 2476.909,116.714,938.672,101.024,-127.304,14.670,9.108,0.098,2.489,3.798,12.897,6.159,122.186,52.782,3.994,3.716
 2477.409,116.710,931.934,123.032,-123.750,19.551,9.270,0.120,2.467,3.063,14.228,3.993,118.543,50.207,3.653,3.546
 2477.909,116.547,927.734,135.249,-122.048,26.468,9.260,0.106,2.473,2.715,13.881,3.360,113.067,46.337,3.330,3.306
 2478.409,116.619,934.473,134.457,-121.290,32.363,9.280,0.075,2.496,2.752,12.519,3.208,109.102,43.535,3.056,3.083
 2478.909,116.648,942.383,129.893,-121.505,35.035,9.318,0.054,2.519,2.791,11.158,3.146,108.188,42.889,2.845,2.891
 2479.409,116.591,927.734,126.371,-121.117,34.859,9.417,0.039,2.527,2.721,10.682,3.155,106.561,41.739,2.709,2.770
 2479.909,116.800,931.445,129.730,-120.798,33.153,9.366,0.023,2.525,2.650,10.832,3.205,102.132,38.609,2.642,2.725
 2480.409,116.671,934.033,133.288,-119.066,31.565,9.305,0.008,2.524,2.633,10.868,3.266,96.331,34.510,2.625,2.719
 2480.909,116.725,937.500,130.769,-116.783,30.971,9.491,-0.001,2.523,2.699,10.943,3.322,91.685,31.226,2.639,2.752
 2481.409,116.666,927.734,126.700,-114.769,30.857,9.482,-0.003,2.525,2.739,10.818,3.388,90.343,30.278,2.678,2.796
 2481.909,116.669,936.133,122.346,-112.879,30.761,9.360,-0.001,2.532,2.701,10.433,3.465,90.823,30.617,2.724,2.846
 2482.409,116.757,942.383,120.147,-112.563,30.968,9.359,0.002,2.546,2.689,9.568,3.531,91.078,30.797,2.779,2.901
 2482.909,116.772,929.053,120.832,-112.717,32.624,9.360,0.004,2.557,2.752,8.938,3.574,90.917,30.684,2.829,2.953
 2483.409,116.617,932.617,121.624,-113.339,35.168,9.365,0.007,2.551,2.908,9.290,3.575,90.535,30.413,2.865,2.999
 2483.909,116.658,932.617,122.783,-113.794,36.203,9.377,0.017,2.540,3.040,9.923,3.545,90.226,30.195,2.895,3.028
 2484.409,116.770,927.734,125.809,-114.895,34.775,9.393,0.029,2.529,3.014,10.591,3.518,90.008,30.041,2.914,3.041
 2484.909,116.703,937.500,125.504,-115.771,32.769,9.404,0.037,2.527,2.927,10.675,3.521,89.764,29.868,2.928,3.042
 2485.409,116.676,932.617,120.775,-116.432,32.007,9.455,0.038,2.536,2.826,10.176,3.547,89.470,29.661,2.923,3.033
 2485.909,116.728,942.383,117.809,-116.372,32.578,9.641,0.042,2.545,2.738,9.622,3.537,89.301,29.541,2.901,3.017
 2486.409,116.674,934.033,119.781,-116.165,34.082,9.852,0.051,2.544,2.731,9.694,3.450,89.542,29.712,2.867,2.993
 2486.909,116.674,942.383,125.287,-117.116,35.264,9.939,0.059,2.527,2.722,10.719,3.323,90.233,30.200,2.835,2.974
 2487.409,116.767,933.301,127.237,-118.510,35.610,10.122,0.065,2.506,2.715,11.925,3.197,91.210,30.890,2.809,2.951
 2487.909,116.611,933.350,124.948,-119.767,35.693,10.398,0.070,2.493,2.706,12.674,3.107,92.181,31.577,2.786,2.930
 2488.409,116.785,937.500,121.772,-120.485,36.889,10.571,0.073,2.492,2.693,12.763,3.089,92.782,32.002,2.763,2.910
 2488.909,116.721,938.428,122.097,-121.177,38.956,10.490,0.071,2.499,2.689,12.351,3.157,92.980,32.141,2.740,2.892
 2489.409,116.731,938.867,122.690,-120.722,39.362,10.229,0.062,2.512,2.706,11.599,3.286,92.898,32.083,2.723,2.877
 2489.909,116.725,927.734,122.772,-120.749,38.177,10.311,0.054,2.536,2.721,10.190,3.413,92.629,31.893,2.719,2.862
 2490.409,116.826,935.254,125.415,-119.268,37.220,10.451,0.050,2.556,2.725,8.984,3.481,92.359,31.703,2.733,2.859
 2490.909,116.740,943.018,128.278,-118.283,37.045,10.340,0.046,2.558,2.738,8.896,3.482,92.203,31.593,2.759,2.866
 2491.409,116.751,932.617,131.462,-117.351,37.123,10.363,0.037,2.544,2.712,9.695,3.456,92.158,31.560,2.786,2.880
 2491.909,116.815,942.383,134.566,-116.419,36.645,10.370,0.023,2.534,2.698,10.267,3.430,92.437,31.758,2.798,2.889
 2492.409,116.773,954.980,138.112,-116.146,36.292,10.342,0.015,2.541,2.727,9.881,3.410,94.211,33.011,2.798,2.892
 2492.909,116.727,932.617,142.661,-116.220,36.519,10.309,0.018,2.560,2.794,8.746,3.390,97.430,35.286,2.781,2.891
 2493.409,116.669,932.617,143.452,-116.738,36.173,10.300,0.028,2.570,2.901,8.179,3.362,100.829,37.689,2.769,2.892
 2493.909,116.737,951.465,139.012,-117.646,35.504,10.384,0.047,2.561,2.934,8.689,3.293,103.188,39.355,2.761,2.902
 2494.409,116.787,957.031,129.286,-118.617,35.477,10.535,0.074,2.548,2.874,9.466,3.188,103.340,39.463,2.764,2.915
 2494.909,116.831,942.188,122.048,-119.683,36.174,10.786,0.101,2.543,2.840,9.753,3.079,101.291,38.015,2.782,2.947
 2495.409,116.713,927.930,116.372,-120.559,37.442,10.852,0.114,2.540,2.873,9.922,3.016,99.236,36.562,2.803,2.972
 2495.909,116.879,947.266,114.943,-120.501,38.719,10.716,0.101,2.533,2.964,10.371,3.046,98.688,36.175,2.824,2.987
 2496.409,116.836,932.861,117.041,-120.453,39.278,10.551,0.076,2.527,3.055,10.700,3.143,99.978,37.087,2.843,2.995
 2496.909,116.747,951.660,118.518,-118.443,38.391,10.353,0.046,2.529,3.079,10.594,3.327,102.182,38.645,2.866,2.999
 2497.409,116.839,960.938,121.377,-116.390,35.918,10.196,0.024,2.546,3.106,9.575,3.534,103.802,39.789,2.905,3.031
 2497.909,116.932,945.996,124.784,-114.208,32.972,10.140,0.016,2.566,3.121,8.427,3.705,103.660,39.689,2.976,3.089
 2498.409,116.697,942.383,129.673,-113.442,31.006,10.141,0.021,2.585,3.074,7.297,3.831,101.302,38.022,3.071,3.181
 2498.909,116.895,942.383,133.934,-113.675,29.854,10.111,0.028,2.587,3.040,7.203,3.948,96.034,34.299,3.194,3.303
 2499.409,116.908,947.266,136.399,-114.087,29.293,10.080,0.028,2.572,3.004,8.064,4.094,90.871,30.651,3.324,3.442
 2499.909,116.838,947.266,136.619,-114.785,29.793,10.078,0.026,2.564,2.960,8.564,4.247,88.377,28.888,3.452,3.584
 2500.409,116.767,946.045,134.079,-115.349,31.198,10.077,0.025,2.563,2.926,8.625,4.381,88.710,29.124,3.574,3.707
 2500.909,116.772,934.863,127.448,-115.637,32.368,10.056,0.026,2.571,2.930,8.143,4.508,91.053,30.779,3.676,3.805
 2501.409,116.870,940.967,124.776,-115.288,32.247,9.997,0.025,2.574,3.007,7.970,4.640,92.040,31.477,3.761,3.862
 2501.909,116.847,937.500,125.774,-114.205,31.139,9.920,0.021,2.571,3.105,8.157,4.718,90.178,30.161,3.811,3.890
 2502.409,116.970,944.043,129.844,-113.969,29.851,9.866,0.017,2.565,3.148,8.489,4.679,86.993,27.910,3.833,3.890
 2502.909,116.888,943.018,136.261,-113.607,28.894,9.841,0.018,2.560,3.089,8.754,4.540,85.073,26.553,3.825,3.881
 2503.409,116.824,942.383,136.166,-113.459,28.181,9.848,0.025,2.565,3.002,8.498,4.352,85.694,26.992,3.802,3.862
 2503.909,116.856,942.383,135.274,-112.933,27.947,9.875,0.032,2.574,2.940,7.968,4.199,87.418,28.211,3.769,3.839
 2504.409,116.859,956.445,133.914,-112.809,28.882,9.892,0.036,2.584,2.974,7.386,4.113,88.564,29.020,3.735,3.814
 2504.909,116.890,961.914,134.361,-112.893,30.836,9.912,0.037,2.587,3.050,7.214,4.083,89.059,29.370,3.701,3.787
 2505.409,116.961,949.463,140.636,-112.472,33.561,9.941,0.036,2.585,2.976,7.336,4.099,89.120,29.413,3.675,3.765
 2505.909,116.724,952.148,142.267,-111.732,35.385,9.969,0.035,2.579,2.896,7.674,4.127,89.170,29.449,3.661,3.751
 2506.409,116.944,946.973,139.791,-110.932,35.643,9.988,0.033,2.571,2.864,8.117,4.134,89.602,29.754,3.666,3.752
 2506.909,116.916,942.969,136.195,-110.798,35.347,10.005,0.029,2.559,2.887,8.838,4.122,90.395,30.315,3.681,3.763
 2507.409,116.934,954.980,132.453,-111.799,34.894,10.023,0.031,2.557,3.003,8.969,4.111,91.198,30.882,3.700,3.783
 2507.909,116.954,955.420,131.948,-112.967,34.426,10.028,0.038,2.565,3.069,8.469,4.109,91.667,31.213,3.710,3.803
 2508.409,116.999,945.459,134.997,-114.360,33.944,10.033,0.043,2.572,3.054,8.053,4.124,91.682,31.224,3.712,3.824
 2508.909,116.828,951.416,137.648,-115.832,34.015,10.073,0.044,2.573,2.999,8.020,4.134,91.417,31.037,3.706,3.851
 2509.409,116.934,947.266,133.970,-116.374,34.690,10.153,0.041,2.569,2.887,8.269,4.100,90.882,30.659,3.700,3.876
 2509.909,116.876,946.289,127.788,-117.298,35.100,10.222,0.038,2.570,2.809,8.183,4.002,90.112,30.114,3.708,3.909
 2510.409,116.965,945.947,121.152,-117.948,34.363,10.316,0.034,2.574,2.720,7.925,3.879,89.177,29.453,3.732,3.930
 2510.909,116.964,947.266,119.898,-118.013,32.773,10.452,0.028,2.579,2.623,7.653,3.828,87.985,28.612,3.766,3.928
 2511.409,117.017,951.025,124.287,-118.030,30.820,10.405,0.024,2.595,2.652,6.749,3.888,86.536,27.587,3.769,3.883
 2511.909,116.923,940.430,132.906,-117.730,28.952,10.247,0.025,2.617,2.758,5.421,4.014,84.944,26.462,3.700,3.785
 2512.409,116.950,947.266,136.977,-118.895,28.051,10.198,0.030,2.634,2.807,4.463,4.111,83.440,25.399,3.576,3.695
 2512.909,116.863,956.787,133.644,-120.237,28.292,10.196,0.036,2.623,2.780,5.085,4.098,82.522,24.751,3.460,3.669
 2513.409,116.913,938.770,131.546,-121.451,29.169,10.195,0.042,2.575,2.697,7.922,3.923,83.093,25.154,3.422,3.763
 2513.909,116.988,939.404,129.414,-123.752,30.211,10.094,0.063,2.493,2.646,12.663,3.580,85.450,26.820,3.525,4.025
 2514.409,116.984,946.875,127.652,-125.627,32.021,9.992,0.092,2.408,2.664,17.643,3.336,87.903,28.554,3.769,4.427
 2514.909,116.931,944.531,117.984,-127.862,34.939,10.311,0.101,2.379,2.818,19.357,4.024,87.376,28.181,4.137,4.897
 2515.409,117.004,947.266,104.011,-129.052,36.190,10.077,0.077,2.420,3.211,16.932,5.868,82.442,24.694,4.589,5.314
 2515.909,117.065,949.658,94.566,-130.560,32.305,9.376,0.033,2.516,3.714,11.353,8.221,75.220,19.590,5.063,5.580
 2516.409,117.086,952.148,86.939,-130.459,24.764,9.253,0.001,2.599,4.078,6.499,10.419,69.082,15.252,5.614,5.816
 2516.909,116.939,949.512,78.954,-130.057,16.895,9.315,-0.007,2.634,4.225,4.444,11.550,64.876,12.280,6.224,6.103
 2517.409,117.112,951.563,75.949,-127.594,11.935,9.357,-0.005,2.641,4.169,4.030,11.440,62.612,10.680,6.745,6.339
 2517.909,117.037,953.906,81.201,-125.985,10.296,9.407,0.008,2.629,4.037,4.757,9.980,62.242,10.418,6.929,6.425
 2518.409,116.981,960.303,92.770,-123.841,10.358,9.517,0.041,2.617,3.817,5.412,7.626,65.560,12.763,6.593,6.272
 2518.909,116.981,950.342,106.518,-121.989,12.280,9.714,0.085,2.616,3.403,5.520,5.521,73.333,18.257,5.955,5.904
 2519.409,117.084,966.797,115.329,-120.716,16.131,9.917,0.108,2.614,3.016,5.632,4.311,80.660,23.434,5.280,5.474
 2519.909,117.106,953.516,122.934,-120.092,20.801,10.056,0.091,2.598,2.723,6.524,3.956,84.346,26.039,4.746,4.947
 2520.409,117.060,946.240,129.243,-120.068,24.504,10.121,0.054,2.580,2.637,7.611,3.977,84.261,25.979,4.355,4.516
 2520.909,116.995,942.383,129.725,-120.956,26.215,10.139,0.029,2.577,2.629,7.778,4.041,82.357,24.634,4.087,4.183
 2521.409,117.059,943.604,129.054,-121.481,26.335,10.182,0.022,2.584,2.704,7.357,4.063,81.500,24.028,3.909,3.947
 2521.909,117.140,951.074,129.354,-121.521,25.796,10.234,0.019,2.592,2.881,6.908,4.030,81.514,24.038,3.797,3.818
 2522.409,117.014,947.266,131.111,-120.735,25.463,10.190,0.013,2.590,2.999,7.018,3.940,81.605,24.102,3.718,3.717
 2522.909,117.087,947.266,134.226,-120.453,25.867,10.125,0.009,2.589,3.065,7.091,3.825,81.804,24.243,3.648,3.664
 2523.409,117.082,940.674,133.861,-120.262,26.494,10.127,0.010,2.592,2.994,6.901,3.701,81.928,24.330,3.564,3.603
 2523.909,117.103,950.244,132.931,-120.773,26.829,10.147,0.012,2.586,2.948,7.256,3.568,82.226,24.542,3.455,3.507
 2524.409,117.073,954.102,138.140,-121.220,27.081,10.174,0.020,2.575,2.894,7.920,3.405,83.236,25.255,3.327,3.398
 2524.909,117.009,934.570,147.076,-121.659,28.144,10.230,0.032,2.568,2.838,8.309,3.249,84.602,26.221,3.187,3.261
 2525.409,117.105,963.623,153.561,-122.226,30.299,10.441,0.041,2.560,2.925,8.781,3.148,85.846,27.099,3.043,3.133
 2525.909,117.096,971.680,151.920,-122.730,31.643,10.517,0.056,2.551,3.021,9.283,3.042,87.042,27.945,2.918,3.021
 2526.409,117.191,949.658,145.429,-122.296,31.742,10.765,0.078,2.539,3.049,10.006,2.904,88.644,29.077,2.806,2.932
 2526.909,117.001,952.148,140.655,-121.075,32.302,11.262,0.088,2.528,2.951,10.646,2.774,90.714,30.540,2.731,2.879
 2527.409,117.126,949.512,142.204,-118.691,34.159,10.988,0.080,2.540,2.884,9.949,2.750,92.240,31.618,2.677,2.834
 2527.909,117.031,951.123,148.625,-117.024,36.275,10.483,0.054,2.545,3.008,9.661,2.843,92.929,32.105,2.643,2.798
 2528.409,117.078,940.381,158.099,-116.511,37.290,10.388,0.036,2.538,3.166,10.041,2.988,93.412,32.447,2.638,2.782
 2528.909,117.136,942.920,164.464,-116.620,37.212,10.421,0.032,2.533,3.235,10.353,3.138,93.716,32.661,2.647,2.782
 2529.409,117.208,956.641,160.944,-116.597,36.912,10.465,0.034,2.546,3.259,9.580,3.311,93.388,32.430,2.685,2.813
 2529.909,117.053,947.266,149.195,-115.545,36.307,10.550,0.038,2.585,3.340,7.333,3.435,92.109,31.526,2.735,2.868
 2530.409,117.189,957.373,136.517,-114.565,34.530,10.500,0.045,2.624,3.414,5.017,3.442,90.168,30.154,2.799,2.943
 2530.909,117.235,957.031,133.266,-113.645,32.474,10.376,0.048,2.643,3.343,3.937,3.392,88.526,28.994,2.877,3.048
 2531.409,117.158,949.902,133.905,-113.691,31.106,10.367,0.045,2.637,3.164,4.278,3.382,87.547,28.302,2.959,3.156
 2531.909,117.129,945.996,136.821,-114.237,30.746,10.313,0.033,2.611,2.909,5.812,3.502,87.167,28.033,3.046,3.249
 2532.409,117.093,946.191,140.946,-114.685,30.882,10.176,0.022,2.586,2.770,7.240,3.696,87.065,27.961,3.134,3.335
 2532.909,117.157,952.148,141.327,-115.391,30.757,10.056,0.013,2.575,2.789,7.907,3.851,87.017,27.927,3.228,3.414
 2533.409,117.231,952.148,144.358,-115.214,30.356,9.999,0.009,2.574,2.867,7.950,3.954,86.953,27.882,3.332,3.512
 2533.909,117.197,947.266,145.395,-115.678,29.800,9.980,0.013,2.582,3.013,7.461,4.034,86.741,27.732,3.454,3.624
 2534.409,117.239,942.969,144.779,-116.222,29.394,9.978,0.016,2.582,3.108,7.466,4.111,86.305,27.424,3.577,3.738
 2534.909,117.151,942.383,141.989,-117.788,29.364,9.978,0.021,2.583,3.114,7.451,4.178,85.612,26.934,3.697,3.848
 2535.409,117.234,956.006,134.958,-117.905,29.691,9.977,0.026,2.588,3.106,7.117,4.232,84.778,26.345,3.793,3.941
 2535.909,117.130,957.520,130.389,-117.096,29.784,9.974,0.028,2.590,3.052,7.021,4.265,84.150,25.901,3.862,4.012
 2536.409,117.178,952.148,127.170,-116.120,29.151,9.969,0.029,2.594,3.024,6.788,4.288,83.776,25.637,3.916,4.066
 2536.909,117.271,954.590,126.222,-117.575,28.095,9.968,0.032,2.602,3.078,6.316,4.314,83.529,25.462,3.961,4.104
 2537.409,117.146,952.148,128.620,-119.905,27.079,9.976,0.036,2.610,3.161,5.845,4.349,83.196,25.227,4.002,4.136
 2537.909,117.178,949.463,131.814,-122.143,26.474,10.008,0.043,2.624,3.263,5.051,4.376,82.649,24.840,4.039,4.165
 2538.409,117.164,947.949,129.908,-123.964,26.394,10.048,0.047,2.632,3.267,4.585,4.386,82.049,24.416,4.069,4.190
 2538.909,117.111,954.150,123.796,-124.434,26.972,10.072,0.046,2.628,3.268,4.790,4.414,81.470,24.007,4.088,4.204
 2539.409,117.210,953.320,120.567,-124.663,27.589,10.080,0.046,2.627,3.299,4.871,4.464,80.944,23.636,4.103,4.216
 2539.909,117.219,955.664,120.563,-125.016,27.032,10.080,0.047,2.626,3.301,4.925,4.476,80.623,23.408,4.110,4.225
 2540.409,117.100,947.266,123.120,-125.481,25.561,10.080,0.047,2.619,3.278,5.296,4.425,80.545,23.353,4.122,4.237
 2540.909,117.202,947.266,127.829,-126.144,24.370,10.077,0.045,2.615,3.223,5.579,4.353,80.591,23.386,4.131,4.246
 2541.409,117.368,959.863,129.123,-125.771,24.158,10.068,0.040,2.607,3.179,6.048,4.364,80.464,23.296,4.128,4.232
 2541.909,117.309,952.148,128.201,-125.256,24.480,10.062,0.035,2.601,3.130,6.368,4.441,80.066,23.015,4.106,4.202
 2542.409,117.297,952.148,125.605,-125.129,24.210,10.057,0.033,2.602,3.054,6.333,4.459,79.626,22.704,4.071,4.162
 2542.909,117.250,948.291,124.144,-125.497,23.397,10.043,0.031,2.601,3.024,6.375,4.380,79.279,22.459,4.040,4.135
 2543.409,117.285,955.176,128.790,-126.584,23.167,10.029,0.031,2.602,3.035,6.308,4.273,78.945,22.223,4.023,4.127
 2543.909,117.282,961.914,129.814,-127.089,23.889,10.027,0.030,2.603,3.022,6.283,4.227,78.653,22.016,4.016,4.121
 2544.409,117.220,957.031,124.560,-127.285,24.879,10.015,0.030,2.601,2.958,6.357,4.251,78.490,21.901,4.011,4.113
 2544.909,117.141,952.734,119.705,-127.234,25.591,9.963,0.028,2.593,2.884,6.828,4.298,78.593,21.974,3.998,4.092
 2545.409,117.317,957.031,116.410,-126.517,26.098,9.915,0.023,2.583,2.872,7.436,4.334,79.122,22.348,3.977,4.065
 2545.909,117.349,947.949,118.155,-124.991,26.602,9.901,0.017,2.575,2.869,7.908,4.332,79.898,22.896,3.959,4.042
 2546.409,117.215,951.172,121.455,-123.204,27.309,9.870,0.009,2.570,2.923,8.180,4.276,80.969,23.653,3.946,4.018
 2546.909,117.351,961.914,127.791,-121.002,28.062,9.828,0.006,2.573,3.007,8.000,4.202,82.123,24.468,3.937,4.003
 2547.409,117.322,954.590,136.544,-120.350,28.421,9.808,0.009,2.582,3.105,7.462,4.163,82.976,25.071,3.921,3.982
 2547.909,117.329,952.148,142.800,-120.180,28.396,9.785,0.017,2.597,3.146,6.634,4.168,83.557,25.482,3.899,3.957
 2548.409,117.285,952.148,146.770,-120.840,28.188,9.722,0.025,2.610,3.092,5.835,4.183,83.822,25.669,3.887,3.935
 2548.909,117.221,952.490,147.828,-121.435,28.481,9.634,0.029,2.616,3.080,5.504,4.177,84.693,26.285,3.880,3.911
 2549.409,117.308,962.891,145.231,-122.023,29.174,9.541,0.029,2.613,3.116,5.680,4.173,87.268,28.105,3.896,3.891
 2549.909,117.301,965.625,140.105,-122.290,28.867,9.464,0.027,2.605,3.100,6.119,4.227,90.269,30.225,3.904,3.859
 2550.409,117.379,950.684,137.212,-123.064,27.053,9.422,0.024,2.598,2.964,6.534,4.408,92.543,31.832,3.903,3.804
 2550.909,117.273,956.201,136.160,-124.078,25.387,9.414,0.024,2.592,2.883,6.901,4.559,93.032,32.178,3.885,3.741
 2551.409,117.434,952.148,139.851,-125.299,25.635,9.428,0.030,2.594,2.937,6.798,4.544,90.861,30.644,3.862,3.663
 2551.909,117.282,952.148,142.683,-126.685,27.307,9.441,0.038,2.600,2.974,6.416,4.427,88.426,28.923,3.854,3.584
 2552.409,117.261,944.922,140.214,-128.801,28.663,9.442,0.037,2.592,2.918,6.914,4.326,87.542,28.298,3.858,3.491
 2552.909,117.399,952.148,134.454,-132.286,28.668,9.376,0.032,2.565,2.776,8.473,4.483,88.170,28.742,3.861,3.382
 2553.409,117.411,948.291,121.155,-136.761,27.803,9.213,0.030,2.530,2.612,10.534,5.046,89.628,29.773,3.848,3.266
 2553.909,117.320,948.779,105.936,-141.597,26.875,9.078,0.032,2.506,2.469,11.955,5.869,89.620,29.767,3.812,3.150
 2554.409,117.373,952.148,91.899,-145.671,25.636,9.034,0.037,2.502,2.370,12.137,6.624,87.361,28.170,3.766,3.048
 2554.909,117.366,950.391,78.868,-147.384,24.047,9.032,0.038,2.503,2.320,12.112,6.919,84.023,25.811,3.726,2.968
 2555.409,117.257,951.611,73.866,-146.900,22.563,9.036,0.037,2.505,2.369,12.006,6.711,80.831,23.555,3.681,2.902
 2555.909,117.474,952.148,77.694,-145.903,21.620,9.063,0.035,2.503,2.467,12.129,6.332,78.992,22.256,3.599,2.832
 2556.409,117.397,952.148,85.111,-145.565,21.517,9.095,0.033,2.496,2.497,12.512,5.970,78.802,22.121,3.486,2.758
 2556.909,117.320,947.266,88.192,-146.281,22.308,9.143,0.036,2.504,2.474,12.064,5.420,79.442,22.574,3.332,2.685
 2557.409,117.528,952.051,87.251,-146.439,23.130,9.231,0.041,2.517,2.456,11.275,4.728,80.375,23.233,3.200,2.627
 2557.909,117.398,952.148,88.016,-145.595,23.413,9.314,0.043,2.534,2.500,10.283,4.034,81.214,23.826,3.104,2.597
 2558.409,117.274,952.002,94.935,-144.321,23.345,9.354,0.038,2.538,2.560,10.036,3.648,81.560,24.071,3.047,2.568
 2558.909,117.439,947.266,105.110,-143.351,23.500,9.361,0.024,2.520,2.533,11.101,3.816,81.341,23.916,3.025,2.549
 2559.409,117.495,938.281,112.439,-142.632,24.330,9.361,0.017,2.508,2.488,11.820,4.191,80.885,23.594,3.014,2.528
 2559.909,117.348,950.195,115.007,-141.973,25.183,9.361,0.019,2.512,2.482,11.591,4.562,80.494,23.317,3.015,2.521
 2560.409,117.525,952.148,116.365,-141.602,25.460,9.361,0.024,2.522,2.523,10.977,4.722,80.374,23.232,3.023,2.526
 2560.909,117.497,952.148,119.533,-141.719,25.287,9.361,0.025,2.523,2.569,10.926,4.697,80.527,23.340,3.025,2.513
 2561.409,117.426,948.926,121.992,-142.105,25.059,9.361,0.026,2.517,2.590,11.273,4.629,80.869,23.582,3.003,2.457
 2561.909,117.497,943.359,124.627,-143.151,25.362,9.351,0.028,2.517,2.668,11.300,4.417,81.317,23.899,2.904,2.323
 2562.409,117.528,935.352,122.990,-145.159,26.312,9.305,0.035,2.524,2.804,10.875,4.144,81.686,24.160,2.718,2.124
 2562.909,117.480,949.707,119.564,-148.830,27.613,9.250,0.045,2.524,2.889,10.853,3.917,81.746,24.202,2.455,1.895
 2563.409,117.522,947.266,111.182,-153.022,28.705,9.197,0.051,2.505,2.813,11.963,3.872,81.211,23.824,2.172,1.679
 2563.909,117.503,947.266,98.554,-157.573,28.827,9.104,0.052,2.474,2.609,13.819,3.919,80.156,23.078,1.924,1.509
 2564.409,117.460,952.344,86.613,-162.119,27.957,9.018,0.046,2.438,2.400,15.913,3.774,79.117,22.344,1.742,1.396
 2564.909,117.582,954.688,75.350,-165.484,26.398,8.980,0.037,2.409,2.266,17.602,3.469,78.727,22.068,1.629,1.335
 2565.409,117.474,951.611,67.708,-166.725,24.236,8.967,0.027,2.393,2.182,18.526,3.318,79.167,22.380,1.584,1.324
 2565.909,117.446,946.729,61.260,-166.033,22.025,8.966,0.021,2.393,2.117,18.543,3.515,79.938,22.924,1.589,1.348
 2566.409,117.572,947.266,62.390,-164.075,20.226,8.970,0.017,2.403,2.119,17.939,4.037,80.423,23.267,1.644,1.409
 2566.909,117.601,947.266,70.891,-161.486,19.237,8.979,0.016,2.418,2.182,17.065,4.662,80.346,23.213,1.741,1.509
 2567.409,117.537,949.902,80.081,-157.530,19.341,9.000,0.020,2.437,2.256,15.953,5.106,79.821,22.842,1.888,1.656
 2567.909,117.483,952.100,90.690,-152.941,20.376,9.043,0.028,2.466,2.352,14.258,5.211,79.414,22.554,2.085,1.852
 2568.409,117.498,957.129,105.508,-146.127,22.009,9.123,0.035,2.506,2.488,11.909,4.909,79.604,22.688,2.331,2.101
 2568.909,117.504,947.266,124.458,-139.725,23.607,9.212,0.036,2.545,2.621,9.676,4.468,80.313,23.189,2.604,2.382
 2569.409,117.593,947.266,140.602,-134.445,25.140,9.269,0.029,2.570,2.728,8.202,4.159,81.280,23.873,2.873,2.685
 2569.909,117.661,957.031,147.793,-131.793,26.434,9.293,0.020,2.581,2.751,7.548,4.127,81.927,24.330,3.121,2.970
 2570.409,117.499,954.053,137.715,-132.003,26.967,9.299,0.021,2.588,2.783,7.115,4.409,81.850,24.276,3.331,3.213
 2570.909,117.625,937.500,120.539,-132.682,26.474,9.299,0.027,2.597,2.833,6.622,4.881,81.117,23.757,3.524,3.400
 2571.409,117.484,950.195,105.302,-131.954,24.801,9.299,0.036,2.606,2.836,6.070,5.324,80.199,23.109,3.690,3.535
 2571.909,117.691,956.152,99.371,-130.750,22.864,9.299,0.040,2.603,2.783,6.268,5.439,79.823,22.843,3.840,3.653
 2572.409,117.694,955.566,107.228,-129.594,22.042,9.298,0.039,2.590,2.703,7.009,5.173,80.210,23.117,3.961,3.769
 2572.909,117.615,957.031,120.450,-128.721,22.817,9.291,0.035,2.577,2.691,7.751,4.784,80.959,23.646,4.051,3.880
 2573.409,117.629,949.707,132.418,-128.013,24.554,9.278,0.027,2.565,2.751,8.481,4.535,81.560,24.071,4.092,3.960
 2573.909,117.636,947.266,135.993,-127.474,25.941,9.259,0.020,2.563,2.840,8.598,4.471,81.739,24.197,4.094,3.997
 2574.409,117.730,951.172,136.220,-126.841,26.743,9.237,0.014,2.562,2.918,8.680,4.459,81.666,24.145,4.065,4.001
 2574.909,117.655,950.391,135.377,-126.357,27.348,9.220,0.017,2.571,2.920,8.153,4.442,81.607,24.104,4.034,3.999
 2575.409,117.731,957.031,136.169,-125.379,27.982,9.205,0.020,2.581,2.868,7.560,4.429,81.611,24.107,4.024,4.016
 2575.909,117.659,957.031,133.973,-124.960,28.185,9.185,0.020,2.585,2.808,7.295,4.434,81.657,24.139,4.044,4.055
 2576.409,117.482,957.031,128.526,-124.665,27.379,9.170,0.018,2.582,2.758,7.485,4.470,81.714,24.180,4.099,4.118
 2576.909,117.715,957.031,127.478,-124.745,26.128,9.159,0.012,2.568,2.759,8.332,4.557,82.213,24.532,4.160,4.188
 2577.409,117.696,943.262,129.808,-124.395,25.219,9.149,0.010,2.561,2.815,8.697,4.717,83.194,25.225,4.226,4.244
 2577.909,117.543,954.736,131.493,-124.690,24.775,9.148,0.008,2.561,2.838,8.743,4.881,84.648,26.253,4.270,4.283
 2578.409,117.760,961.816,128.154,-124.933,24.593,9.147,0.006,2.560,2.855,8.788,4.985,86.001,27.209,4.297,4.297
 2578.909,117.611,959.424,121.959,-125.909,24.515,9.147,0.007,2.561,2.881,8.723,4.988,85.603,26.928,4.300,4.306
 2579.409,117.647,956.836,119.327,-125.919,24.526,9.146,0.014,2.572,2.898,8.088,4.874,83.970,25.774,4.286,4.311
 2579.909,117.588,952.148,122.887,-125.070,24.915,9.146,0.025,2.590,2.910,6.997,4.719,82.859,24.989,4.267,4.316
 2580.409,117.543,951.709,126.081,-124.008,25.821,9.146,0.033,2.605,2.894,6.130,4.563,83.403,25.373,4.241,4.321
 2580.909,117.737,953.223,127.171,-124.392,26.820,9.146,0.033,2.605,2.886,6.144,4.477,85.810,27.074,4.216,4.309
 2581.409,117.766,952.148,126.374,-124.459,27.186,9.146,0.029,2.594,2.909,6.803,4.496,87.998,28.620,4.188,4.289
 2581.909,117.757,955.371,126.321,-124.417,26.641,9.146,0.033,2.593,2.967,6.863,4.577,87.740,28.438,4.164,4.258
 2582.409,117.591,952.148,129.525,-123.870,25.845,9.146,0.044,2.601,3.024,6.387,4.632,85.773,27.048,4.144,4.232
 2582.909,117.649,945.215,135.258,-124.063,25.372,9.143,0.050,2.605,3.084,6.169,4.614,83.296,25.298,4.139,4.219
 2583.409,117.681,944.629,140.192,-124.744,25.239,9.137,0.047,2.601,3.131,6.395,4.551,81.822,24.256,4.137,4.216
 2583.909,117.638,955.811,142.384,-124.371,25.396,9.126,0.039,2.591,3.163,6.980,4.488,81.670,24.148,4.133,4.215
 2584.409,117.728,952.148,140.930,-123.319,25.906,9.108,0.037,2.590,3.181,7.026,4.457,82.993,25.084,4.115,4.207
 2584.909,117.798,956.055,134.475,-122.332,26.437,9.066,0.037,2.593,3.167,6.815,4.435,85.983,27.197,4.090,4.192
 2585.409,117.649,952.148,127.492,-120.922,26.474,9.018,0.033,2.590,3.109,7.024,4.397,90.330,30.268,4.061,4.175
 2585.909,117.794,952.148,120.093,-120.265,25.980,8.991,0.025,2.582,3.049,7.493,4.353,95.032,33.591,4.043,4.165
 2586.409,117.853,944.189,116.833,-120.728,25.529,8.979,0.019,2.576,3.006,7.847,4.331,98.171,35.810,4.034,4.158
 2586.909,117.807,956.055,115.133,-122.255,25.517,8.975,0.021,2.579,3.009,7.656,4.349,99.823,36.977,4.036,4.156
 2587.409,117.743,957.031,114.779,-124.373,25.719,8.975,0.027,2.585,3.089,7.334,4.410,102.731,39.032,4.042,4.158
 2587.909,117.788,961.670,121.196,-125.454,25.960,8.975,0.031,2.588,3.115,7.121,4.469,108.062,42.800,4.053,4.167
 2588.409,117.731,947.559,130.127,-124.597,26.584,8.975,0.031,2.590,3.068,7.021,4.482,111.680,45.357,4.072,4.188
 2588.909,117.736,956.885,136.670,-122.885,27.411,8.975,0.031,2.597,3.023,6.611,4.472,111.242,45.047,4.095,4.213
 2589.409,117.656,954.492,138.168,-120.751,27.662,8.975,0.032,2.603,2.987,6.234,4.486,106.535,41.721,4.120,4.236
 2589.909,117.822,961.914,139.487,-120.208,27.205,8.975,0.028,2.595,2.990,6.726,4.521,101.893,38.440,4.139,4.251
 2590.409,117.838,961.914,138.100,-120.588,27.040,8.975,0.025,2.583,3.039,7.407,4.530,101.017,37.821,4.149,4.258
 2590.909,117.707,961.035,132.035,-120.440,27.609,8.970,0.025,2.581,3.067,7.546,4.512,102.861,39.124,4.153,4.260
 2591.409,117.832,955.127,122.907,-119.995,27.826,8.961,0.033,2.595,3.077,6.733,4.501,102.142,38.616,4.147,4.251
 2591.909,117.791,957.031,118.599,-119.706,26.905,8.949,0.039,2.607,3.096,6.004,4.512,97.283,35.182,4.138,4.238
 2592.409,117.836,957.031,120.171,-120.146,25.301,8.935,0.038,2.605,3.075,6.130,4.513,90.193,30.172,4.124,4.223
 2592.909,117.818,957.031,124.774,-119.724,24.653,8.927,0.035,2.595,3.071,6.710,4.477,84.320,26.021,4.112,4.211
 2593.409,117.835,957.031,133.876,-118.709,25.304,8.921,0.031,2.584,3.039,7.386,4.432,83.207,25.234,4.100,4.205
 2593.909,117.831,954.785,140.207,-117.372,26.036,8.910,0.031,2.585,2.995,7.283,4.414,84.368,26.055,4.090,4.197
 2594.409,117.754,947.266,142.782,-117.716,26.304,8.892,0.031,2.592,3.011,6.908,4.424,85.127,26.591,4.077,4.187
 2594.909,117.855,957.031,137.445,-119.081,26.254,8.871,0.028,2.595,3.001,6.720,4.445,86.733,27.726,4.068,4.176
 2595.409,117.802,957.031,130.059,-120.990,26.180,8.863,0.022,2.593,3.036,6.856,4.459,90.300,30.247,4.060,4.167
 2595.909,117.798,952.148,126.710,-120.862,26.024,8.862,0.012,2.579,3.031,7.636,4.448,94.707,33.362,4.055,4.161
 2596.409,117.858,960.449,127.333,-119.679,25.829,8.862,0.006,2.572,3.012,8.052,4.427,98.613,36.122,4.050,4.154
 2596.909,117.820,958.203,133.748,-118.835,26.103,8.862,0.005,2.570,3.008,8.166,4.418,98.572,36.093,4.039,4.146
 2597.409,117.887,947.754,137.797,-118.689,26.688,8.864,0.007,2.570,2.950,8.186,4.425,94.980,33.555,4.026,4.135
 2597.909,117.942,966.797,133.083,-119.493,27.326,8.873,0.008,2.570,2.945,8.167,4.424,92.347,31.694,4.011,4.127
 2598.409,117.838,962.158,125.389,-119.532,27.817,8.892,0.010,2.572,2.904,8.079,4.393,93.134,32.250,4.002,4.127
 2598.909,117.883,969.092,123.640,-119.476,27.846,8.910,0.013,2.583,2.850,7.446,4.351,96.818,34.853,4.005,4.139
 2599.409,117.728,961.914,128.981,-119.593,27.536,8.924,0.019,2.595,2.845,6.710,4.330,100.309,37.321,4.019,4.162
 2599.909,117.862,961.914,134.788,-120.980,26.976,8.931,0.023,2.600,2.851,6.457,4.353,99.201,36.538,4.043,4.191
 2600.409,117.785,966.064,134.716,-121.730,26.625,8.934,0.023,2.592,2.868,6.888,4.414,94.559,33.257,4.071,4.218
 2600.909,117.964,952.148,128.324,-122.764,26.920,8.934,0.021,2.581,2.883,7.531,4.506,88.441,28.934,4.098,4.235
 2601.409,117.946,962.354,122.069,-122.429,27.293,8.934,0.018,2.574,2.869,7.945,4.586,83.339,25.328,4.121,4.244
 2601.909,117.871,963.770,118.115,-123.039,26.952,8.934,0.021,2.581,2.894,7.553,4.596,81.061,23.718,4.136,4.245
 2602.409,117.970,947.266,115.772,-122.800,26.247,8.934,0.027,2.593,2.879,6.823,4.541,80.942,23.634,4.141,4.245
 2602.909,117.914,950.537,116.081,-123.193,25.951,8.933,0.029,2.599,2.836,6.499,4.451,81.572,24.079,4.139,4.246
 2603.409,117.982,953.076,118.323,-124.625,26.478,8.933,0.027,2.591,2.842,6.965,4.379,82.069,24.431,4.126,4.245
 2603.909,117.907,957.031,120.516,-126.993,27.329,8.933,0.023,2.575,2.861,7.887,4.342,82.538,24.762,4.113,4.239
 2604.409,117.799,958.203,120.456,-128.832,27.425,8.933,0.020,2.564,2.860,8.547,4.333,84.324,26.024,4.097,4.227
 2604.909,117.941,961.914,116.803,-128.705,26.374,8.932,0.018,2.560,2.797,8.766,4.361,88.149,28.727,4.085,4.212
 2605.409,117.979,961.914,112.903,-127.820,24.585,8.932,0.015,2.560,2.710,8.794,4.404,92.659,31.915,4.079,4.199
 2605.909,117.893,954.004,116.999,-126.207,22.918,8.932,0.012,2.558,2.677,8.884,4.429,96.242,34.447,4.078,4.193
 2606.409,117.990,955.371,123.530,-126.208,22.160,8.932,0.010,2.557,2.738,8.930,4.426,98.102,35.761,4.085,4.194
 2606.909,118.003,961.914,126.183,-126.933,22.553,8.932,0.011,2.556,2.806,8.988,4.411,100.101,37.174,4.092,4.194
 2607.409,117.876,960.059,122.385,-128.151,23.505,8.932,0.012,2.555,2.838,9.071,4.408,105.457,40.959,4.094,4.183
 2607.909,117.970,957.031,115.732,-128.982,23.960,8.932,0.016,2.560,2.810,8.787,4.419,112.483,45.924,4.079,4.168
 2608.409,118.014,957.031,119.008,-128.787,23.936,8.930,0.022,2.570,2.811,8.215,4.429,115.907,48.344,4.058,4.162
 2608.909,118.075,957.031,124.951,-129.285,24.118,8.929,0.026,2.581,2.822,7.556,4.425,114.395,47.275,4.054,4.192
 2609.409,117.972,957.227,123.699,-129.892,24.467,8.929,0.027,2.583,2.801,7.437,4.386,107.684,42.533,4.100,4.273
 2609.909,117.993,957.031,116.042,-131.701,24.461,8.926,0.023,2.574,2.757,7.935,4.346,102.165,38.633,4.204,4.391
 2610.409,117.985,959.619,105.912,-133.022,23.550,8.917,0.017,2.563,2.783,8.622,4.490,102.068,38.564,4.343,4.495
 2610.909,117.911,966.553,101.104,-134.333,22.299,8.910,0.011,2.556,2.861,9.016,5.026,102.605,38.943,4.465,4.545
 2611.409,118.042,961.914,99.001,-135.532,20.881,8.910,0.007,2.561,2.920,8.709,5.824,99.559,36.791,4.524,4.532
 2611.909,117.869,966.797,95.591,-136.258,19.076,8.915,0.008,2.569,2.936,8.239,6.263,92.366,31.707,4.530,4.503
 2612.409,118.015,963.770,93.000,-136.348,17.204,8.941,0.021,2.574,2.894,7.975,5.940,85.009,26.508,4.513,4.499
 2612.909,118.086,961.914,93.849,-134.858,16.307,8.992,0.043,2.569,2.844,8.260,5.155,84.476,26.131,4.494,4.516
 2613.409,118.088,961.914,101.530,-132.941,17.413,9.043,0.069,2.560,2.793,8.789,4.521,91.005,30.745,4.459,4.514
 2613.909,117.950,978.662,111.628,-130.706,20.045,9.067,0.082,2.557,2.738,8.968,4.311,96.768,34.818,4.385,4.468
 2614.409,118.066,963.281,119.949,-128.288,23.040,9.070,0.073,2.558,2.704,8.886,4.348,97.593,35.402,4.278,4.378
 2614.909,117.993,961.914,127.461,-127.054,24.854,9.070,0.054,2.567,2.667,8.354,4.425,93.821,32.736,4.173,4.287
 2615.409,117.977,961.914,133.649,-125.988,25.066,9.070,0.038,2.576,2.669,7.822,4.465,90.842,30.630,4.106,4.215
 2615.909,118.011,966.797,137.153,-127.421,24.637,9.070,0.037,2.586,2.742,7.270,4.469,95.539,33.950,4.090,4.179
 2616.409,117.992,966.797,133.517,-129.409,24.286,9.070,0.042,2.591,2.777,6.982,4.506,104.530,40.304,4.105,4.168
 2616.909,118.111,958.691,119.847,-132.041,23.711,9.073,0.040,2.580,2.788,7.603,4.577,109.932,44.122,4.129,4.180
 2617.409,118.020,961.914,109.931,-134.308,22.601,9.075,0.032,2.568,2.777,8.328,4.587,108.109,42.833,4.138,4.199
 2617.909,117.949,958.105,111.333,-133.632,21.528,9.075,0.027,2.568,2.763,8.330,4.525,102.121,38.601,4.138,4.216
 2618.409,118.033,961.035,120.221,-130.577,21.573,9.075,0.030,2.586,2.780,7.268,4.430,97.880,35.604,4.131,4.225
 2618.909,118.078,957.031,128.703,-126.417,23.024,9.075,0.037,2.608,2.739,5.938,4.391,97.429,35.285,4.120,4.217
 2619.409,118.091,957.031,130.940,-122.679,24.864,9.076,0.039,2.618,2.700,5.384,4.399,98.367,35.949,4.106,4.206
 2619.909,118.112,966.602,129.461,-122.846,26.078,9.076,0.035,2.610,2.747,5.856,4.382,98.481,36.029,4.095,4.197
 2620.409,118.177,966.797,125.780,-124.440,26.721,9.075,0.031,2.595,2.774,6.713,4.351,98.181,35.817,4.091,4.202
 2620.909,117.965,966.797,123.923,-125.161,27.002,9.075,0.025,2.574,2.780,7.939,4.323,98.134,35.784,4.107,4.218
 2621.409,118.122,961.670,121.589,-125.994,26.974,9.075,0.021,2.557,2.789,8.955,4.330,96.786,34.831,4.124,4.230
 2621.909,118.044,957.031,116.428,-126.933,26.674,9.071,0.018,2.550,2.746,9.367,4.400,92.375,31.714,4.139,4.234
 2622.409,118.116,957.520,111.095,-128.451,25.721,9.064,0.019,2.555,2.712,9.080,4.486,87.812,28.489,4.140,4.224
 2622.909,118.143,961.914,109.362,-129.693,24.070,9.060,0.022,2.564,2.670,8.514,4.497,85.330,26.735,4.127,4.207
 2623.409,118.168,961.914,111.732,-129.449,22.777,9.057,0.023,2.570,2.597,8.216,4.419,86.261,27.393,4.110,4.190
 2623.909,118.109,961.914,116.980,-128.356,22.794,9.048,0.025,2.576,2.566,7.849,4.293,88.018,28.635,4.090,4.178
 2624.409,118.142,966.797,119.474,-128.568,23.669,9.028,0.028,2.581,2.553,7.543,4.201,87.041,27.944,4.070,4.169
 2624.909,118.126,966.797,119.280,-129.619,24.084,9.011,0.029,2.580,2.586,7.593,4.174,84.561,26.191,4.049,4.160
 2625.409,118.227,970.459,116.859,-130.480,23.506,9.004,0.032,2.577,2.709,7.752,4.186,86.140,27.307,4.031,4.150
 2625.909,118.155,966.797,111.877,-130.157,22.265,9.000,0.030,2.566,2.811,8.418,4.223,94.494,33.211,4.022,4.139
 2626.409,118.157,952.148,113.954,-127.958,21.177,8.997,0.025,2.556,2.877,8.985,4.260,105.269,40.826,4.024,4.135
 2626.909,118.204,964.160,119.504,-125.024,21.184,8.987,0.020,2.560,2.920,8.774,4.277,109.809,44.035,4.036,4.145
 2627.409,118.213,973.242,125.632,-123.428,23.045,8.974,0.020,2.576,2.973,7.827,4.291,103.269,39.413,4.058,4.174
 2627.909,118.267,962.549,126.824,-123.647,26.282,8.969,0.022,2.594,3.036,6.788,4.332,92.147,31.553,4.092,4.217
 2628.409,118.174,963.818,121.079,-124.785,28.862,8.969,0.024,2.599,3.059,6.488,4.392,87.505,28.272,4.141,4.272
 2628.909,118.194,966.797,116.232,-125.361,29.533,8.969,0.024,2.596,3.040,6.659,4.441,92.436,31.757,4.200,4.331
 2629.409,118.131,971.680,115.908,-124.385,28.775,8.969,0.021,2.586,3.007,7.229,4.517,101.897,38.443,4.263,4.383
 2629.909,118.246,971.680,117.436,-124.173,27.643,8.970,0.017,2.580,2.979,7.594,4.678,107.905,42.689,4.314,4.417
 2630.409,118.265,969.287,117.975,-124.047,26.203,8.979,0.015,2.578,2.956,7.735,4.877,105.865,41.248,4.346,4.429
 2630.909,118.281,966.797,118.087,-124.689,24.347,9.002,0.016,2.576,2.931,7.826,4.965,100.427,37.404,4.356,4.428
 2631.409,118.276,964.209,118.026,-124.002,22.545,9.030,0.027,2.590,2.911,7.011,4.851,98.537,36.069,4.353,4.427
 2631.909,118.248,967.383,124.867,-123.580,21.830,9.047,0.036,2.603,2.919,6.245,4.644,102.085,38.576,4.334,4.416
 2632.409,118.265,968.066,132.458,-122.663,22.303,9.050,0.034,2.598,2.868,6.549,4.498,104.915,40.576,4.296,4.384
 2632.909,118.292,962.988,138.831,-121.582,23.022,9.050,0.026,2.590,2.794,7.037,4.432,104.750,40.460,4.242,4.335
 2633.409,118.284,971.680,143.086,-120.176,23.641,9.050,0.020,2.581,2.772,7.553,4.385,102.360,38.770,4.178,4.282
 2633.909,118.207,966.797,143.995,-118.370,23.936,9.050,0.021,2.586,2.840,7.262,4.335,100.473,37.437,4.128,4.244
 2634.409,118.250,963.477,140.579,-117.147,23.979,9.050,0.025,2.596,2.941,6.663,4.298,101.143,37.910,4.100,4.230
 2634.909,118.253,964.844,132.245,-115.814,24.046,9.050,0.027,2.602,2.974,6.337,4.320,101.795,38.371,4.100,4.232
 2635.409,118.271,969.434,124.894,-115.836,24.579,9.050,0.026,2.604,2.950,6.209,4.410,99.047,36.429,4.125,4.251
 2635.909,118.301,968.018,122.332,-116.693,25.376,9.050,0.026,2.603,2.926,6.277,4.520,93.029,32.176,4.157,4.275
 2636.409,118.330,967.920,123.352,-118.042,25.393,9.049,0.025,2.600,2.913,6.455,4.629,86.921,27.859,4.196,4.305
 2636.909,118.164,961.914,125.254,-119.044,24.439,9.049,0.025,2.597,2.913,6.633,4.705,84.513,26.158,4.229,4.334
 2637.409,118.244,969.922,123.771,-119.584,23.457,9.049,0.026,2.600,2.899,6.433,4.748,86.171,27.329,4.254,4.351
 2637.909,118.182,963.623,120.003,-118.954,23.598,9.050,0.026,2.603,2.900,6.260,4.730,88.754,29.155,4.271,4.364
 2638.409,118.250,962.549,117.356,-117.835,24.700,9.050,0.028,2.609,2.923,5.887,4.642,89.755,29.863,4.274,4.366
 2638.909,118.303,967.627,116.143,-117.206,26.121,9.050,0.026,2.610,2.898,5.849,4.549,90.566,30.435,4.268,4.361
 2639.409,118.291,972.070,122.816,-117.202,27.710,9.052,0.022,2.605,2.890,6.122,4.480,94.287,33.065,4.252,4.354
 2639.909,118.205,961.914,133.049,-117.722,28.727,9.058,0.022,2.609,2.882,5.901,4.460,102.059,38.558,4.231,4.331
 2640.409,118.245,961.914,137.101,-117.840,28.520,9.062,0.025,2.617,2.873,5.435,4.465,111.076,44.930,4.206,4.302
 2640.909,118.356,979.053,133.836,-117.220,27.334,9.063,0.030,2.624,2.877,5.032,4.485,117.104,49.190,4.179,4.259
 2641.409,118.323,971.680,125.651,-117.312,26.356,9.063,0.031,2.625,2.886,4.993,4.512,116.810,48.982,4.147,4.213
 2641.909,118.356,976.953,125.174,-116.642,26.808,9.066,0.024,2.610,2.894,5.821,4.508,110.649,44.628,4.119,4.177
 2642.409,118.314,980.566,131.633,-115.393,28.003,9.070,0.014,2.586,2.900,7.236,4.460,104.908,40.571,4.089,4.152
 2642.909,118.366,966.797,136.483,-113.406,28.509,9.075,0.008,2.566,2.903,8.408,4.391,101.508,38.169,4.060,4.134
 2643.409,118.444,968.408,137.554,-112.317,28.400,9.088,0.018,2.562,2.926,8.662,4.332,101.419,38.105,4.030,4.115
 2643.909,118.435,981.445,133.892,-111.753,27.983,9.117,0.045,2.575,2.957,7.869,4.292,102.192,38.651,3.999,4.080
 2644.409,118.327,986.328,130.830,-111.766,27.513,9.136,0.071,2.593,2.960,6.864,4.270,100.827,37.687,3.965,4.041
 2644.909,118.379,976.367,130.994,-111.645,27.110,9.139,0.079,2.603,3.016,6.272,4.258,96.989,34.974,3.926,3.996
 2645.409,118.288,971.680,133.736,-111.258,27.135,9.138,0.065,2.600,3.087,6.420,4.248,92.268,31.638,3.881,3.949
 2645.909,118.300,971.680,135.209,-110.423,27.873,9.138,0.044,2.592,3.152,6.900,4.224,88.458,28.946,3.830,3.898
 2646.409,118.377,971.680,133.525,-109.505,28.724,9.138,0.034,2.594,3.172,6.809,4.183,87.214,28.066,3.773,3.840
 2646.909,118.325,975.488,128.791,-108.446,29.803,9.135,0.035,2.604,3.107,6.187,4.123,87.710,28.417,3.712,3.780
 2647.409,118.329,966.797,128.221,-108.035,31.358,9.130,0.037,2.609,3.138,5.881,4.041,88.334,28.858,3.651,3.722
 2647.909,118.324,974.902,137.290,-108.622,33.346,9.118,0.035,2.606,3.213,6.098,3.941,89.061,29.372,3.593,3.671
 2648.409,118.292,965.088,147.346,-108.720,35.340,9.092,0.028,2.593,3.260,6.843,3.857,89.791,29.888,3.540,3.629
 2648.909,118.367,961.914,152.406,-108.898,36.369,9.074,0.020,2.580,3.261,7.601,3.813,90.405,30.322,3.495,3.592
 2649.409,118.341,973.633,149.876,-107.634,36.116,9.073,0.015,2.576,3.162,7.865,3.812,90.784,30.590,3.457,3.559
 2649.909,118.431,972.070,145.286,-107.209,35.015,9.073,0.016,2.581,3.124,7.545,3.830,90.897,30.669,3.429,3.531
 2650.409,118.376,971.680,143.777,-106.428,33.297,9.073,0.017,2.581,3.230,7.524,3.850,90.800,30.601,3.413,3.512
 2650.909,118.549,971.680,144.219,-105.628,31.733,9.073,0.016,2.575,3.358,7.879,3.868,90.597,30.457,3.405,3.503
 2651.409,118.362,971.680,143.382,-105.270,30.642,9.077,0.012,2.567,3.404,8.356,3.886,90.412,30.327,3.407,3.506
 2651.909,118.448,971.680,140.371,-104.989,30.291,9.090,0.009,2.566,3.352,8.434,3.892,90.265,30.223,3.415,3.520
 2652.409,118.394,976.953,139.993,-105.333,30.623,9.105,0.017,2.585,3.194,7.297,3.879,90.241,30.206,3.430,3.545
 2652.909,118.300,980.762,141.446,-105.941,31.034,9.116,0.027,2.605,3.099,6.111,3.870,90.280,30.233,3.454,3.575
 2653.409,118.374,971.680,141.958,-107.159,31.310,9.120,0.031,2.612,3.055,5.741,3.904,90.133,30.129,3.479,3.601
 2653.909,118.343,971.143,141.114,-108.164,31.159,9.120,0.029,2.605,3.033,6.137,3.978,89.667,29.800,3.506,3.621
 2654.409,118.503,969.922,135.166,-108.433,30.664,9.120,0.023,2.592,3.076,6.892,4.056,88.989,29.321,3.528,3.636
 2654.909,118.294,966.797,130.706,-107.433,29.969,9.120,0.020,2.588,3.168,7.124,4.099,88.401,28.905,3.546,3.648
 2655.409,118.470,973.535,127.755,-106.276,29.421,9.120,0.024,2.596,3.263,6.650,4.106,88.136,28.718,3.562,3.667
 2655.909,118.469,980.420,124.388,-106.289,29.562,9.120,0.033,2.614,3.282,5.586,4.090,88.170,28.742,3.584,3.693
 2656.409,118.392,976.563,123.450,-107.195,30.194,9.120,0.043,2.635,3.236,4.375,4.064,88.325,28.851,3.613,3.732
 2656.909,118.453,981.445,124.999,-108.025,30.736,9.120,0.046,2.643,3.186,3.927,4.046,88.446,28.937,3.656,3.783
 2657.409,118.507,977.637,131.124,-108.629,30.684,9.117,0.042,2.635,3.200,4.401,4.077,88.257,28.803,3.702,3.833
 2657.909,118.377,976.563,136.085,-109.278,29.847,9.109,0.031,2.614,3.172,5.596,4.205,87.603,28.342,3.752,3.873
 2658.409,118.496,972.510,137.694,-108.858,28.761,9.092,0.020,2.597,3.054,6.608,4.383,86.519,27.575,3.795,3.902
 2658.909,118.571,978.271,135.204,-108.468,27.877,9.064,0.011,2.587,2.923,7.166,4.503,85.450,26.820,3.838,3.928
 2659.409,118.388,981.445,129.197,-107.793,27.410,9.044,0.003,2.582,2.857,7.511,4.506,84.871,26.411,3.885,3.968
 2659.909,118.531,971.680,124.908,-107.776,27.667,9.041,-0.000,2.577,2.864,7.753,4.430,84.942,26.461,3.931,4.008
 2660.409,118.417,971.680,123.955,-107.784,28.210,9.041,0.001,2.579,2.916,7.684,4.398,85.241,26.672,3.966,4.035
 2660.909,118.578,986.328,123.463,-107.747,28.475,9.045,0.008,2.592,2.949,6.902,4.457,85.244,26.674,3.977,4.036
 2661.409,118.503,981.592,120.981,-108.357,28.264,9.054,0.018,2.610,2.983,5.843,4.516,84.974,26.483,3.971,4.019
 2661.909,118.536,981.445,117.457,-109.251,27.257,9.073,0.024,2.624,2.954,5.042,4.493,84.883,26.419,3.956,4.001
 2662.409,118.415,981.445,118.145,-109.491,26.525,9.092,0.025,2.630,2.848,4.675,4.414,85.203,26.645,3.946,3.987
 2662.909,118.403,976.074,126.614,-108.623,27.308,9.104,0.022,2.626,2.720,4.941,4.345,85.874,27.119,3.943,3.975
 2663.409,118.519,980.762,137.326,-106.991,28.778,9.112,0.017,2.613,2.681,5.657,4.300,86.512,27.570,3.940,3.959
 2663.909,118.471,971.680,145.350,-106.356,29.607,9.113,0.013,2.602,2.748,6.301,4.254,86.918,27.857,3.933,3.938
 2664.409,118.563,980.273,148.141,-105.935,28.965,9.113,0.011,2.593,2.835,6.836,4.197,87.266,28.103,3.918,3.916
 2664.909,118.566,977.930,144.995,-105.380,27.946,9.113,0.013,2.591,2.943,6.970,4.129,87.726,28.428,3.905,3.895
 2665.409,118.517,981.445,139.711,-105.110,28.914,9.113,0.016,2.590,3.006,7.003,4.069,88.487,28.966,3.894,3.875
 2665.909,118.515,974.707,135.748,-104.693,31.623,9.109,0.017,2.590,3.060,7.017,4.014,89.551,29.718,3.884,3.854
 2666.409,118.627,971.680,135.286,-104.365,33.788,9.101,0.015,2.593,3.069,6.839,3.970,90.639,30.487,3.866,3.826
 2666.909,118.606,971.680,138.413,-104.237,34.451,9.084,0.014,2.599,3.054,6.488,3.948,91.401,31.026,3.835,3.792
 2667.409,118.590,974.023,143.100,-103.706,34.118,9.070,0.013,2.604,3.153,6.184,3.947,91.640,31.194,3.796,3.755
 2667.909,118.602,978.369,145.009,-103.918,33.762,9.064,0.012,2.602,3.276,6.295,3.960,91.514,31.106,3.762,3.730
 2668.409,118.567,981.445,143.313,-103.548,33.545,9.056,0.011,2.596,3.359,6.644,3.987,91.385,31.014,3.753,3.722
 2668.909,118.562,981.445,141.057,-104.146,32.900,9.047,0.009,2.591,3.353,6.987,4.039,91.399,31.024,3.774,3.732
 2669.409,118.636,981.445,140.829,-105.134,31.955,9.040,0.011,2.597,3.271,6.585,4.140,91.326,30.973,3.840,3.764
 2669.909,118.427,981.445,143.134,-106.901,31.561,9.036,0.013,2.603,3.229,6.276,4.264,91.077,30.796,3.932,3.805
 2670.409,118.570,971.924,144.579,-107.225,32.858,9.035,0.011,2.595,3.208,6.720,4.357,90.807,30.606,4.046,3.856
 2670.909,118.496,986.328,143.173,-107.160,34.924,9.035,0.006,2.582,3.211,7.500,4.396,90.709,30.536,4.161,3.903
 2671.409,118.482,971.680,142.621,-107.691,35.693,9.035,0.003,2.575,3.133,7.906,4.388,90.891,30.665,4.255,3.941
 2671.909,118.587,981.250,143.538,-109.119,34.410,9.031,0.002,2.575,3.034,7.882,4.334,91.302,30.955,4.330,3.988
 2672.409,118.530,986.328,149.248,-110.533,31.882,9.040,0.003,2.572,2.995,8.058,4.196,91.816,31.318,4.322,4.003
 2672.909,118.649,986.182,154.892,-111.730,30.749,9.115,0.006,2.557,3.003,8.976,3.997,92.159,31.561,4.273,3.991
 2673.409,118.614,984.131,152.996,-113.020,31.694,9.225,0.035,2.534,3.108,10.288,3.768,92.263,31.635,4.124,3.896
 2673.909,118.707,981.104,148.077,-114.270,33.623,9.262,0.090,2.497,3.139,12.483,3.544,92.666,31.919,3.919,3.732
 2674.409,118.617,976.563,138.694,-115.104,36.635,9.334,0.153,2.424,3.045,16.698,3.338,93.654,32.618,3.664,3.548
 2674.909,118.648,982.031,131.578,-115.041,40.164,10.003,0.192,2.358,2.931,20.612,3.174,94.409,33.152,3.382,3.346
 2675.409,118.595,986.328,126.373,-115.067,43.096,10.900,0.191,2.327,3.053,22.375,3.086,94.310,33.081,3.121,3.168
 2675.909,118.638,986.328,119.551,-114.590,43.465,10.531,0.182,2.354,3.289,20.848,3.023,93.925,32.809,2.890,3.008
 2676.409,118.642,982.959,116.618,-113.840,41.122,10.395,0.177,2.395,3.361,18.444,2.949,94.672,33.337,2.731,2.895
 2676.909,118.633,981.445,118.021,-113.039,39.165,11.136,0.173,2.411,3.263,17.494,2.857,96.695,34.767,2.649,2.863
 2677.409,118.545,981.445,121.389,-112.493,39.906,11.440,0.161,2.418,3.091,17.050,2.809,98.533,36.066,2.651,2.890
 2677.909,118.695,982.764,122.863,-112.455,41.924,11.366,0.135,2.429,3.069,16.411,2.890,99.155,36.505,2.742,3.004
 2678.409,118.550,986.328,124.801,-111.831,42.981,10.910,0.108,2.457,3.109,14.789,3.180,97.964,35.664,2.908,3.183
 2678.909,118.537,971.680,123.426,-111.347,42.836,10.590,0.079,2.486,3.196,13.096,3.953,94.581,33.273,3.161,3.443
 2679.409,118.490,971.680,115.503,-110.281,40.972,10.197,0.056,2.520,3.391,11.100,5.373,88.905,29.261,3.523,3.820
 2679.909,118.607,978.320,104.129,-110.056,36.378,9.401,0.048,2.563,3.557,8.586,7.045,81.533,24.051,4.017,4.301
 2680.409,118.769,981.445,95.905,-109.776,29.469,8.910,0.042,2.591,3.605,6.935,8.507,74.570,19.131,4.717,4.993
 2680.909,118.635,983.447,99.143,-109.683,22.596,8.858,0.030,2.596,3.552,6.695,9.613,72.185,17.445,5.677,5.930
 2681.409,118.724,986.328,103.248,-110.305,18.192,8.856,0.013,2.596,3.554,6.695,10.711,74.418,19.023,6.850,6.966
 2681.909,118.634,971.680,96.116,-110.260,16.396,8.857,0.003,2.613,3.761,5.691,12.036,78.315,21.777,7.986,7.843
 2682.409,118.690,981.250,80.611,-109.772,15.481,8.858,0.002,2.639,3.984,4.149,12.857,78.952,22.228,8.592,8.085
 2682.909,118.680,978.955,65.163,-108.650,14.734,8.860,0.006,2.657,4.012,3.113,12.667,75.078,19.490,8.309,7.785
 2683.409,118.734,981.445,59.345,-107.762,14.053,8.870,0.011,2.656,3.861,3.159,11.654,71.873,17.225,7.571,7.240
 2683.909,118.776,981.445,65.646,-107.264,13.473,8.929,0.024,2.630,3.635,4.691,9.830,73.757,18.556,6.836,6.699
 2684.409,118.729,986.328,77.314,-107.058,13.616,9.036,0.056,2.583,3.503,7.409,7.704,79.965,22.944,6.314,6.383
 2684.909,118.719,986.328,91.355,-106.735,16.126,9.352,0.098,2.541,3.364,9.881,5.732,85.088,26.564,6.004,6.174
 2685.409,118.836,980.176,100.627,-106.860,21.060,9.720,0.114,2.524,3.178,10.901,4.893,86.118,27.292,5.779,6.024
 2685.909,118.838,971.680,103.817,-107.591,26.150,9.566,0.089,2.545,3.120,9.661,5.628,83.371,25.350,5.475,5.677
 2686.409,118.600,981.445,104.877,-108.287,28.016,9.328,0.046,2.577,3.235,7.789,6.821,80.574,23.374,5.170,5.241
 2686.909,118.761,984.863,104.085,-108.949,25.348,9.343,0.017,2.593,3.409,6.820,7.386,80.948,23.638,4.877,4.875
 2687.409,118.791,977.637,108.079,-108.865,20.892,9.391,0.016,2.584,3.436,7.369,6.935,84.856,26.400,4.669,4.607
 2687.909,118.814,981.445,109.935,-109.011,18.180,9.453,0.040,2.553,3.400,9.176,5.878,89.302,29.542,4.497,4.499
 2688.409,118.825,974.316,108.281,-109.205,18.901,9.685,0.081,2.529,3.352,10.586,4.937,91.200,30.883,4.328,4.446
 2688.909,118.726,981.445,107.235,-109.798,22.056,10.145,0.110,2.511,3.269,11.645,4.310,90.613,30.469,4.159,4.492
 2689.409,118.782,986.328,106.419,-110.675,25.753,10.122,0.123,2.501,3.223,12.241,3.959,89.223,29.486,4.052,4.603
 2689.909,118.786,986.328,105.788,-111.131,28.470,10.025,0.125,2.478,3.171,13.575,3.866,89.223,29.486,4.080,4.776
 2690.409,118.731,979.639,103.292,-110.886,30.193,10.282,0.122,2.450,3.140,15.199,4.342,88.878,29.242,4.299,5.041
 2690.909,118.767,980.908,94.993,-110.469,31.073,9.992,0.107,2.451,3.096,15.129,6.723,85.594,26.922,4.726,5.336
 2691.409,118.823,981.445,78.654,-110.465,28.991,9.301,0.065,2.502,3.286,12.188,13.773,78.147,21.659,5.369,5.764
 2691.909,118.725,990.625,59.415,-110.563,23.306,8.900,0.022,2.591,3.783,6.969,23.997,69.819,15.773,6.233,6.285
 2692.409,118.849,986.328,41.400,-110.572,15.190,8.880,0.002,2.660,4.318,2.932,31.773,65.957,13.044,7.332,7.024
 2692.909,118.874,995.996,34.218,-110.164,8.101,8.907,0.001,2.696,4.646,0.823,33.149,66.591,13.492,8.637,7.917
 2693.409,118.751,993.799,43.090,-109.983,5.089,8.951,0.010,2.700,4.582,0.580,26.695,70.458,16.225,9.404,8.482
 2693.909,118.671,1005.859,59.989,-109.663,4.700,9.015,0.022,2.694,4.301,0.944,18.224,75.631,19.881,9.378,8.584
 2694.409,118.846,1000.391,80.567,-109.124,6.322,9.118,0.034,2.677,3.903,1.937,11.773,82.188,24.515,8.188,7.907
 2694.909,118.723,991.211,99.099,-108.731,9.337,9.238,0.038,2.647,3.492,3.679,7.929,88.927,29.277,6.812,6.932
 2695.409,118.803,991.211,117.649,-108.556,13.694,9.336,0.041,2.604,3.222,6.217,6.156,94.742,33.386,5.750,6.029
 2695.909,118.975,986.963,136.769,-108.703,18.229,9.408,0.059,2.570,3.074,8.214,5.220,98.924,36.342,4.963,5.287
 2696.409,118.885,984.863,151.429,-108.397,21.895,9.656,0.076,2.539,2.952,9.986,4.727,102.369,38.777,4.510,4.833
 2696.909,118.835,966.797,155.575,-107.699,24.875,9.700,0.075,2.519,2.822,11.175,4.562,104.747,40.457,4.225,4.591
 2697.409,118.838,973.633,151.581,-106.615,27.826,9.390,0.055,2.517,2.715,11.306,4.813,103.714,39.727,4.116,4.500
 2697.909,118.930,985.205,147.577,-106.183,30.747,9.259,0.032,2.519,2.789,11.169,5.251,100.778,37.652,4.171,4.623
 2698.409,118.869,981.445,153.071,-104.748,32.586,9.208,0.026,2.516,2.981,11.326,5.860,98.342,35.931,4.410,4.879
 2698.909,118.883,982.764,169.880,-103.107,33.017,9.165,0.024,2.483,3.073,13.294,7.053,98.395,35.968,4.824,5.299
 2699.409,118.804,982.422,193.773,-101.051,33.609,9.146,0.022,2.431,3.034,16.336,8.833,100.351,37.350,5.371,5.790
 2699.909,118.785,981.445,221.053,-99.402,35.574,9.143,0.022,2.386,2.933,18.970,10.720,104.097,39.998,5.919,6.223
 2700.409,118.851,981.445,252.581,-98.729,38.440,9.143,0.027,2.362,2.882,20.335,12.086,109.960,44.141,6.373,6.650
 2700.909,118.839,983.252,282.371,-97.982,41.749,9.142,0.031,2.354,2.884,20.813,12.209,116.018,48.422,6.658,6.953
 2701.409,118.914,986.328,294.917,-98.173,45.911,9.142,0.033,2.355,2.842,20.747,11.076,120.450,51.555,6.866,7.281
 2701.909,118.900,984.277,276.914,-98.851,49.941,9.142,0.030,2.386,2.733,18.963,9.119,120.055,51.276,6.999,7.520
 2702.409,118.860,981.445,230.951,-100.582,50.465,9.180,0.022,2.448,2.736,15.297,7.780,115.250,47.880,7.106,7.658
 2702.909,118.802,981.445,171.393,-103.125,44.019,9.175,0.013,2.531,3.047,10.450,8.685,110.455,44.491,7.059,7.604
 2703.409,118.868,981.445,116.449,-105.452,33.207,9.085,0.008,2.605,3.637,6.151,10.855,108.181,42.884,7.005,7.414
 2703.909,118.914,988.818,86.018,-106.139,22.521,9.044,0.012,2.646,4.084,3.752,11.893,106.951,42.015,7.109,7.534
 2704.409,118.838,991.211,82.804,-105.337,15.358,9.044,0.019,2.663,4.086,2.768,11.561,103.258,39.405,7.526,7.962
 2704.909,118.898,991.211,92.842,-105.513,13.349,9.043,0.019,2.657,3.791,3.116,12.408,95.063,33.614,8.471,8.996
 2705.409,118.893,991.211,93.730,-106.675,13.334,9.035,0.018,2.659,3.651,2.997,17.623,86.048,27.243,9.880,10.266
 2705.909,118.806,985.254,76.400,-108.931,12.230,9.030,0.020,2.681,3.996,1.708,29.651,79.299,22.473,11.677,11.483
 2706.409,118.819,983.350,51.734,-110.641,9.222,9.031,0.020,2.701,4.518,0.498,42.477,73.949,18.692,13.308,12.430
 2706.909,118.912,1002.539,35.378,-111.376,5.571,9.037,0.017,2.712,4.963,-0.091,47.385,68.377,14.754,14.156,12.527
 2707.409,118.948,986.328,29.506,-110.958,3.391,9.053,0.011,2.708,5.160,0.117,42.392,63.404,11.239,13.723,11.857
 2707.909,118.972,989.795,34.964,-110.273,2.944,9.087,0.010,2.701,5.060,0.520,30.533,60.085,8.894,12.269,10.484
 2708.409,118.964,988.965,55.037,-108.823,3.548,9.125,0.012,2.681,4.680,1.682,19.613,60.022,8.850,10.434,9.181
 2708.909,118.936,985.107,84.715,-107.666,5.235,9.195,0.018,2.650,4.127,3.485,12.827,64.159,11.773,8.842,8.250
 2709.409,118.916,989.063,118.348,-106.086,8.528,9.313,0.027,2.614,3.630,5.615,8.790,71.606,17.036,7.706,7.628
 2709.909,119.002,992.188,145.313,-103.908,13.669,9.415,0.034,2.579,3.204,7.664,6.997,79.891,22.891,6.999,7.238
 2710.409,118.889,976.563,158.168,-102.724,19.671,9.459,0.038,2.544,2.960,9.712,7.189,87.090,27.979,6.619,6.955
 2710.909,118.989,984.863,166.898,-102.195,25.642,9.437,0.035,2.491,2.828,12.814,8.421,92.748,31.978,6.539,6.864
 2711.409,118.936,981.445,183.144,-102.763,32.125,9.376,0.038,2.435,2.764,16.091,10.136,97.363,35.239,6.756,6.982
 2711.909,119.022,981.445,212.395,-103.131,39.479,9.309,0.044,2.385,2.763,19.000,11.977,101.162,37.924,7.332,7.303
 2712.409,119.018,987.598,244.575,-102.800,46.749,9.264,0.043,2.358,2.741,20.585,13.515,102.397,38.796,8.135,7.706
 2712.909,118.780,1000.732,255.838,-103.001,51.550,9.243,0.033,2.371,2.742,19.836,14.941,99.506,36.753,8.746,7.824
 2713.409,118.908,991.504,223.016,-104.401,49.253,9.235,0.018,2.442,3.023,15.655,16.433,91.054,30.780,8.591,7.563
 2713.909,118.996,986.328,164.363,-106.219,39.905,9.241,0.009,2.537,3.638,10.126,16.503,80.348,23.214,7.614,6.847
 2714.409,118.971,986.328,114.144,-107.753,26.203,9.314,0.018,2.579,4.215,7.659,13.783,73.302,18.234,6.503,6.078
 2714.909,118.858,991.211,92.328,-108.752,15.023,9.496,0.048,2.540,4.293,9.930,9.381,73.379,18.289,5.510,5.423
 2715.409,119.072,996.777,99.469,-109.222,12.252,9.895,0.078,2.447,3.689,15.400,5.274,80.099,23.038,4.774,4.833
 2715.909,118.999,1000.977,113.836,-109.393,16.137,10.553,0.086,2.386,3.049,18.951,3.312,86.872,27.825,4.171,4.353
 2716.409,118.950,995.020,119.412,-109.201,22.132,10.669,0.072,2.407,2.775,17.729,2.946,88.913,29.267,3.651,3.831
 2716.909,119.035,991.895,117.920,-109.350,26.073,10.513,0.051,2.459,2.766,14.657,2.989,86.944,27.876,3.243,3.406
 2717.409,119.015,989.648,112.285,-109.671,27.041,10.602,0.048,2.499,2.835,12.349,3.024,84.142,25.895,2.969,3.105
 2717.909,118.879,991.211,106.089,-109.921,26.759,10.647,0.067,2.519,2.824,11.149,2.972,82.713,24.886,2.806,2.913
 2718.409,118.948,991.211,104.289,-110.345,27.089,10.730,0.086,2.521,2.843,11.079,2.887,83.183,25.218,2.744,2.853
 2718.909,118.913,994.971,104.944,-111.665,28.006,10.842,0.098,2.522,2.885,10.970,2.806,84.068,25.843,2.728,2.856
 2719.409,119.008,991.211,106.450,-113.305,28.761,10.885,0.089,2.520,2.865,11.103,2.754,84.404,26.081,2.757,2.946
 2719.909,118.948,989.844,108.830,-114.799,29.312,10.940,0.067,2.513,2.863,11.505,2.727,84.127,25.885,2.825,3.089
 2720.409,118.894,990.283,109.777,-116.106,29.828,11.054,0.051,2.508,2.905,11.804,2.735,83.581,25.499,2.951,3.264
 2720.909,119.002,991.211,108.332,-118.256,30.630,10.847,0.049,2.486,2.943,13.074,2.876,82.416,24.675,3.154,3.469
 2721.409,118.992,991.211,101.218,-121.393,31.468,10.383,0.056,2.475,2.978,13.759,3.489,79.016,22.273,3.405,3.641
 2721.909,119.050,994.922,80.980,-125.874,30.524,10.199,0.054,2.494,3.160,12.640,4.847,72.830,17.901,3.679,3.779
 2722.409,118.906,992.188,57.476,-130.717,26.614,9.961,0.040,2.540,3.528,9.920,6.227,65.786,12.923,3.910,3.836
 2722.909,119.019,993.311,38.923,-135.344,20.478,9.681,0.022,2.586,3.996,7.278,6.949,61.178,9.667,4.072,3.817
 2723.409,119.069,982.178,30.368,-139.605,14.879,9.678,0.013,2.591,4.349,6.980,6.864,60.446,9.149,4.172,3.781
 2723.909,119.082,981.445,34.352,-142.575,12.494,9.698,0.022,2.566,4.368,8.398,6.101,63.039,10.981,4.169,3.711
 2724.409,119.183,996.094,44.510,-144.894,12.988,9.730,0.032,2.527,4.206,10.684,5.283,66.875,13.693,4.114,3.660
 2724.909,119.076,996.094,53.942,-146.793,15.237,9.755,0.038,2.499,4.034,12.344,4.592,70.109,15.978,4.001,3.592
 2725.409,118.901,1000.977,57.108,-148.672,17.516,9.763,0.038,2.489,3.987,12.909,4.495,71.573,17.013,3.886,3.500
 2725.909,119.041,1000.977,51.143,-150.564,18.761,9.708,0.032,2.499,4.048,12.367,5.390,70.781,16.453,3.813,3.405
 2726.409,119.130,1000.098,41.640,-152.728,18.852,9.580,0.026,2.517,4.068,11.267,6.539,68.785,15.042,3.801,3.313
 2726.909,119.063,991.211,33.405,-155.175,17.926,9.502,0.020,2.528,4.146,10.649,7.582,66.415,13.368,3.875,3.278
 2727.409,119.092,996.094,28.139,-157.488,17.129,9.490,0.014,2.534,4.286,10.285,8.595,64.321,11.888,4.012,3.282
 2727.909,119.021,996.094,25.332,-159.655,16.641,9.485,0.011,2.549,4.538,9.397,9.876,62.406,10.534,4.155,3.273
 2728.409,119.126,1000.977,22.626,-160.367,15.830,9.486,0.014,2.577,4.787,7.785,11.213,60.520,9.202,4.225,3.209
 2728.909,119.016,994.043,20.434,-160.084,14.585,9.492,0.023,2.605,4.914,6.154,11.879,59.030,8.149,4.129,3.073
 2729.409,119.025,983.984,17.556,-159.278,13.147,9.506,0.029,2.615,4.901,5.582,11.520,58.346,7.665,3.889,2.912
 2729.909,119.081,976.563,16.603,-158.412,12.117,9.536,0.028,2.603,4.798,6.257,10.350,58.677,7.899,3.614,2.784
 2730.409,119.113,989.160,20.082,-157.606,11.678,9.567,0.023,2.586,4.679,7.266,8.763,59.680,8.608,3.388,2.703
 2730.909,119.078,992.139,26.126,-155.394,11.647,9.579,0.021,2.569,4.571,8.262,7.010,61.469,9.872,3.278,2.684
 2731.409,119.117,986.328,36.761,-152.277,12.157,9.579,0.029,2.554,4.337,9.131,5.358,64.233,11.825,3.260,2.700
 2731.909,119.062,990.527,49.815,-149.090,13.478,9.624,0.037,2.533,3.925,10.328,4.540,66.919,13.724,3.314,2.722
 2732.409,119.102,982.617,54.992,-148.917,15.870,9.706,0.033,2.512,3.754,11.558,5.380,67.965,14.463,3.399,2.735
 2732.909,119.218,976.563,48.994,-150.862,18.046,9.568,0.021,2.505,3.839,12.008,7.278,66.786,13.630,3.489,2.723
 2733.409,119.163,986.328,33.540,-154.499,18.288,9.404,0.008,2.510,4.162,11.721,8.977,64.393,11.938,3.590,2.721
 2733.909,119.174,990.967,20.833,-157.052,16.828,9.411,0.005,2.519,4.380,11.166,9.623,62.421,10.545,3.702,2.730
 2734.409,119.097,996.094,17.019,-158.665,14.723,9.431,0.006,2.521,4.278,11.044,9.268,61.491,9.888,3.806,2.749
 2734.909,119.252,991.211,16.080,-160.182,13.548,9.451,0.007,2.521,4.139,11.068,8.796,61.253,9.720,3.874,2.768
 2735.409,119.148,991.211,16.673,-161.645,13.403,9.460,0.007,2.515,4.150,11.425,8.511,61.259,9.724,3.870,2.768
 2735.909,118.958,991.211,17.732,-163.147,13.380,9.471,0.010,2.510,4.412,11.717,8.371,61.357,9.793,3.824,2.769
 2736.409,119.168,996.777,18.053,-163.567,13.079,9.496,0.020,2.517,4.680,11.265,8.398,61.677,10.019,3.786,2.770
 2736.909,119.213,1000.488,17.816,-163.212,12.535,9.535,0.036,2.534,4.709,10.305,8.650,61.824,10.123,3.769,2.780
 2737.409,119.190,996.094,17.105,-161.949,12.040,9.568,0.051,2.553,4.472,9.184,9.256,61.756,10.075,3.775,2.795
 2737.909,119.228,995.361,18.742,-158.493,11.906,9.579,0.052,2.556,4.242,8.984,10.020,61.697,10.033,3.790,2.832
 2738.409,119.115,997.754,23.424,-154.499,12.171,9.592,0.041,2.559,4.224,8.850,10.502,61.791,10.099,3.768,2.871
 2738.909,119.236,986.328,30.104,-148.904,12.402,9.623,0.027,2.558,4.380,8.914,10.101,62.744,10.773,3.744,2.925
 2739.409,119.218,989.844,43.887,-144.035,12.320,9.675,0.028,2.542,4.468,9.838,8.472,65.249,12.543,3.701,3.004
 2739.909,119.186,1001.172,65.217,-138.143,12.184,9.812,0.042,2.517,4.124,11.311,6.305,69.170,15.314,3.648,3.092
 2740.409,119.196,993.848,85.356,-132.238,12.757,10.081,0.052,2.488,3.416,12.974,4.499,73.413,18.313,3.599,3.216
 2740.909,119.295,994.678,99.423,-128.092,14.433,10.040,0.056,2.472,2.691,13.932,3.639,76.260,20.325,3.516,3.283
 2741.409,119.259,983.301,104.807,-125.001,16.917,9.896,0.070,2.457,2.335,14.799,3.458,78.124,21.643,3.435,3.301
 2741.909,119.214,991.211,108.677,-122.008,20.387,10.143,0.111,2.434,2.372,16.120,3.397,80.264,23.155,3.357,3.282
 2742.409,119.216,987.012,118.635,-118.723,25.061,10.695,0.155,2.422,2.478,16.848,3.309,82.969,25.066,3.288,3.236
 2742.909,119.276,987.402,131.168,-116.382,29.515,10.893,0.165,2.431,2.605,16.323,3.262,85.442,26.814,3.219,3.207
 2743.409,119.121,977.002,142.014,-115.246,31.852,10.673,0.147,2.452,2.731,15.113,3.221,86.813,27.783,3.145,3.155
 2743.909,119.264,976.563,145.964,-114.561,32.109,10.991,0.122,2.469,2.867,14.065,3.141,87.908,28.557,3.072,3.124
 2744.409,119.249,995.313,144.330,-114.195,32.283,11.227,0.105,2.478,2.967,13.544,3.049,89.196,29.467,3.020,3.111
 2744.909,119.272,988.867,138.717,-112.744,34.111,10.732,0.099,2.491,3.010,12.802,3.024,90.135,30.131,3.001,3.103
 2745.409,119.124,986.328,135.505,-111.540,36.275,10.479,0.102,2.514,3.068,11.450,3.071,90.605,30.463,3.009,3.099
 2745.909,119.140,994.092,134.474,-110.169,37.024,10.479,0.103,2.533,2.990,10.323,3.192,90.157,30.146,3.032,3.086
 2746.409,119.284,996.094,133.173,-109.624,36.821,10.317,0.090,2.546,2.836,9.603,3.354,89.361,29.584,3.055,3.096
 2746.909,119.262,998.926,134.628,-110.014,35.609,10.174,0.062,2.553,2.718,9.209,3.524,88.666,29.093,3.070,3.125
 2747.409,119.393,1000.488,135.401,-110.277,34.023,10.143,0.037,2.556,2.697,8.982,3.646,88.123,28.709,3.097,3.171
 2747.909,119.250,986.865,136.577,-110.822,33.132,10.166,0.043,2.562,2.777,8.681,3.658,88.101,28.693,3.145,3.238
 2748.409,119.194,983.643,137.375,-111.104,33.781,10.202,0.077,2.561,2.853,8.701,3.584,88.562,29.019,3.209,3.305
 2748.909,119.150,999.365,134.626,-111.341,36.052,10.400,0.114,2.557,2.905,8.944,3.482,89.273,29.522,3.272,3.374
 2749.409,119.419,986.328,131.751,-111.154,38.250,10.707,0.123,2.547,2.922,9.549,3.433,89.773,29.875,3.305,3.414
 2749.909,119.292,989.844,131.598,-110.762,38.563,10.570,0.100,2.535,2.900,10.239,3.458,89.494,29.678,3.288,3.409
 2750.409,119.312,992.432,134.665,-110.792,37.048,10.289,0.073,2.533,2.892,10.377,3.498,88.612,29.054,3.231,3.367
 2750.909,119.174,992.334,136.494,-111.545,35.019,10.320,0.071,2.544,2.905,9.697,3.480,87.857,28.521,3.163,3.308
 2751.409,119.316,991.211,136.659,-111.758,34.413,10.513,0.086,2.548,2.888,9.485,3.384,88.040,28.650,3.110,3.273
 2751.909,119.315,999.219,136.143,-112.237,36.251,10.880,0.092,2.524,2.879,10.880,3.261,89.310,29.547,3.080,3.262
 2752.409,119.321,992.773,134.064,-112.197,39.185,11.126,0.085,2.485,2.880,13.133,3.177,91.072,30.793,3.060,3.259
 2752.909,119.349,986.328,130.924,-112.293,41.385,11.206,0.081,2.459,2.877,14.707,3.157,92.525,31.820,3.037,3.252
 2753.409,119.270,993.115,129.009,-111.147,41.819,11.252,0.088,2.459,2.844,14.666,3.178,97.759,35.519,3.012,3.230
 2753.909,119.348,996.094,128.160,-109.354,41.696,11.348,0.096,2.472,2.816,13.930,3.205,107.933,42.709,2.993,3.206
 2754.409,119.294,993.945,132.167,-107.853,43.750,11.176,0.090,2.473,2.876,13.859,3.243,118.939,50.487,2.993,3.176
 2754.909,119.453,991.211,138.233,-107.293,48.163,10.773,0.072,2.471,3.023,13.995,3.312,127.051,56.220,3.006,3.151
 2755.409,119.395,991.211,141.272,-107.398,51.439,10.458,0.051,2.480,3.126,13.478,3.429,128.478,57.228,3.026,3.139
 2755.909,119.302,991.211,143.757,-107.418,50.363,10.234,0.032,2.496,3.129,12.536,3.564,126.991,56.178,3.047,3.149
 2756.409,119.344,988.623,142.753,-107.396,44.598,10.043,0.023,2.521,3.028,11.054,3.670,127.547,56.570,3.082,3.197
 2756.909,119.318,991.211,140.927,-106.807,37.913,9.851,0.022,2.543,2.917,9.781,3.725,135.243,62.009,3.141,3.273
 2757.409,119.318,988.379,140.683,-106.431,33.814,9.823,0.029,2.557,2.897,8.975,3.725,149.736,72.251,3.226,3.372
 2757.909,119.250,990.674,137.035,-105.822,32.448,9.801,0.037,2.566,2.925,8.450,3.718,163.161,81.739,3.342,3.495
 2758.409,119.343,995.557,128.588,-106.033,31.989,9.767,0.038,2.565,2.957,8.480,3.858,166.639,84.197,3.444,3.604
 2758.909,119.371,998.779,117.778,-106.316,30.541,9.716,0.032,2.553,2.962,9.199,4.216,158.857,78.698,3.544,3.692
 2759.409,119.323,986.328,104.412,-106.985,27.238,9.696,0.033,2.536,2.892,10.192,4.526,146.242,69.783,3.626,3.737
 2759.909,119.335,988.281,98.243,-107.664,23.241,9.746,0.049,2.525,2.743,10.807,4.542,134.883,61.755,3.697,3.759
 2760.409,119.364,996.094,100.669,-107.596,20.565,9.944,0.061,2.524,2.606,10.850,4.321,122.803,53.217,3.761,3.808
 2760.909,119.432,996.094,108.472,-107.336,20.334,9.946,0.057,2.538,2.549,10.081,4.123,109.579,43.872,3.789,3.867
 2761.409,119.325,992.334,118.115,-106.544,22.175,9.801,0.038,2.548,2.553,9.469,4.168,96.793,34.836,3.811,3.953
 2761.909,119.397,991.211,121.236,-106.063,24.727,9.791,0.021,2.543,2.567,9.771,4.291,88.401,28.905,3.833,4.021
 2762.409,119.328,991.211,121.031,-106.456,26.652,9.791,0.032,2.527,2.560,10.710,4.287,87.919,28.564,3.915,4.086
 2762.909,119.293,994.385,118.475,-107.824,27.425,9.821,0.071,2.512,2.535,11.557,4.185,91.262,30.927,4.008,4.113
 2763.409,119.295,991.211,115.459,-109.482,27.820,10.100,0.103,2.507,2.472,11.847,4.189,94.609,33.293,4.138,4.141
 2763.909,119.451,993.115,116.292,-110.448,28.047,10.056,0.102,2.525,2.384,10.841,4.453,97.235,35.148,4.158,4.133
 2764.409,119.329,991.602,116.796,-110.642,27.182,9.637,0.068,2.539,2.314,9.995,4.848,99.640,36.848,4.087,4.058
 2764.909,119.259,981.445,113.181,-111.216,25.055,9.533,0.043,2.515,2.380,11.381,4.940,101.493,38.158,3.955,3.999
 2765.409,119.501,990.918,107.337,-112.226,23.059,9.592,0.062,2.470,2.465,14.012,4.550,101.646,38.266,3.834,3.935
 2765.909,119.396,988.818,104.610,-113.757,23.654,10.125,0.108,2.426,2.574,16.634,3.886,98.261,35.874,3.775,3.926
 2766.409,119.295,986.426,107.273,-114.943,27.113,10.458,0.142,2.400,2.646,18.122,3.304,93.610,32.586,3.711,3.888
 2766.909,119.443,993.457,112.067,-115.679,31.663,10.623,0.141,2.402,2.615,18.026,3.048,90.989,30.734,3.564,3.685
 2767.409,119.385,986.328,111.947,-115.612,34.325,10.832,0.118,2.422,2.555,16.827,2.998,90.687,30.521,3.343,3.436
 2767.909,119.456,986.328,110.146,-115.138,33.760,10.586,0.092,2.457,2.539,14.813,2.978,92.217,31.602,3.081,3.139
 2768.409,119.580,992.285,108.041,-115.395,31.594,10.411,0.069,2.481,2.724,13.404,2.882,93.369,32.416,2.851,2.932
 2768.909,119.324,997.900,104.400,-116.838,29.828,10.464,0.061,2.478,2.916,13.539,2.689,92.588,31.865,2.706,2.833
 2769.409,119.414,993.750,102.564,-118.615,29.958,10.638,0.074,2.458,2.954,14.752,2.486,90.883,30.659,2.643,2.847
 2769.909,119.386,981.445,104.831,-119.988,32.448,10.698,0.103,2.433,2.832,16.200,2.364,89.328,29.560,2.672,2.956
 2770.409,119.514,993.262,111.664,-120.682,36.492,10.680,0.122,2.402,2.609,18.008,2.355,88.639,29.073,2.765,3.087
 2770.909,119.378,1000.977,117.544,-122.536,40.699,10.552,0.110,2.342,2.428,21.532,2.464,88.372,28.885,2.907,3.205
 2771.409,119.514,1015.625,115.644,-125.404,43.219,10.363,0.083,2.310,2.285,23.373,2.809,86.479,27.547,3.051,3.256
 2771.909,119.379,993.359,101.515,-130.137,42.490,10.230,0.052,2.351,2.357,21.012,3.616,80.855,23.572,3.174,3.266
 2772.409,119.466,1005.859,78.420,-135.228,37.751,9.768,0.029,2.449,2.737,15.260,4.646,72.519,17.681,3.260,3.247
 2772.909,119.551,997.754,52.412,-139.720,29.748,9.287,0.025,2.555,3.285,9.053,5.293,64.735,12.181,3.339,3.246
 2773.409,119.488,993.164,36.154,-141.603,21.426,9.260,0.038,2.604,3.632,6.202,5.109,61.044,9.572,3.462,3.316
 2773.909,119.503,1005.859,33.285,-142.412,15.696,9.297,0.057,2.606,3.745,6.061,4.395,61.132,9.634,3.646,3.448
 2774.409,119.481,1009.766,36.711,-143.468,13.862,9.263,0.062,2.586,3.800,7.243,4.001,62.748,10.776,3.864,3.619
 2774.909,119.599,991.992,38.447,-145.423,14.376,9.220,0.050,2.565,3.905,8.466,4.792,63.556,11.347,4.093,3.772
 2775.409,119.461,991.211,36.743,-148.439,15.432,9.166,0.034,2.564,4.141,8.529,7.488,62.354,10.498,4.297,3.884
 2775.909,119.575,1000.684,35.271,-152.141,15.953,9.116,0.022,2.574,4.161,7.958,11.362,60.303,9.048,4.535,3.980
 2776.409,119.594,993.604,36.352,-156.839,15.635,9.107,0.011,2.575,4.066,7.873,15.475,58.659,7.886,4.892,4.098
 2776.909,119.414,996.094,36.093,-161.323,14.743,9.107,0.006,2.568,4.056,8.323,18.544,57.963,7.394,5.382,4.252
 2777.409,119.521,996.094,35.186,-164.302,13.540,9.107,0.008,2.557,4.221,8.965,19.554,58.277,7.616,5.974,4.429
 2777.909,119.514,977.588,39.767,-167.080,12.353,9.107,0.011,2.550,4.530,9.372,19.128,58.950,8.092,6.513,4.589
 2778.409,119.488,991.211,47.416,-171.189,11.369,9.107,0.014,2.553,4.717,9.208,17.626,60.532,9.210,6.795,4.622
 2778.909,119.489,995.557,51.768,-172.794,10.730,9.107,0.015,2.553,4.672,9.168,15.952,62.356,10.499,6.799,4.535
 2779.409,119.585,1003.711,51.057,-173.417,10.536,9.107,0.015,2.548,4.551,9.474,14.588,63.246,11.128,6.575,4.308
 2779.909,119.580,1007.617,46.809,-171.622,10.504,9.108,0.016,2.541,4.473,9.859,13.638,63.115,11.035,6.219,4.032
 2780.409,119.475,991.211,42.978,-171.671,10.641,9.108,0.015,2.538,4.431,10.063,13.075,62.129,10.338,5.832,3.761
 2780.909,119.606,996.094,41.336,-172.319,11.043,9.108,0.014,2.544,4.433,9.680,12.587,62.071,10.297,5.455,3.534
 2781.409,119.532,996.094,39.222,-172.649,11.593,9.108,0.011,2.558,4.380,8.913,11.929,63.776,11.502,5.142,3.365
 2781.909,119.609,996.094,37.089,-172.624,12.234,9.106,0.011,2.570,4.299,8.160,11.225,65.151,12.474,4.907,3.246
 2782.409,119.506,1003.711,37.090,-172.644,12.929,9.102,0.013,2.579,4.314,7.688,10.790,65.132,12.461,4.743,3.165
 2782.909,119.540,1002.832,37.832,-172.572,13.484,9.101,0.018,2.576,4.405,7.829,10.856,63.831,11.542,4.636,3.109
 2783.409,119.406,1000.146,39.842,-172.442,13.617,9.101,0.018,2.559,4.588,8.825,11.363,62.373,10.511,4.567,3.072
 2783.909,119.641,997.559,41.809,-171.611,13.091,9.101,0.016,2.544,4.791,9.715,11.881,62.747,10.775,4.528,3.048
 2784.409,119.662,991.211,38.901,-171.327,12.196,9.101,0.014,2.537,4.871,10.128,11.950,63.999,11.660,4.507,3.038
 2784.909,119.611,1002.930,34.983,-171.874,11.648,9.101,0.013,2.536,4.912,10.166,11.349,64.503,12.016,4.508,3.044
 2785.409,119.716,996.777,30.655,-173.002,11.695,9.103,0.012,2.535,4.881,10.239,10.465,64.225,11.820,4.517,3.061
 2785.909,119.659,1000.977,29.260,-174.173,12.233,9.104,0.011,2.534,4.821,10.283,9.985,63.172,11.076,4.542,3.093
 2786.409,119.515,996.240,30.795,-174.298,12.950,9.112,0.010,2.534,4.849,10.303,10.069,62.331,10.481,4.579,3.132
 2786.909,119.676,998.535,34.437,-173.877,13.493,9.126,0.010,2.535,4.766,10.253,10.736,62.170,10.367,4.635,3.175
 2787.409,119.665,995.996,38.420,-173.245,13.662,9.134,0.013,2.538,4.694,10.033,11.736,61.991,10.241,4.698,3.217
 2787.909,119.691,999.268,39.089,-173.159,13.293,9.140,0.014,2.539,4.651,10.008,13.003,61.605,9.968,4.766,3.256
 2788.409,119.743,1000.977,37.915,-173.470,12.683,9.146,0.011,2.539,4.625,10.001,13.862,61.158,9.652,4.831,3.297
 2788.909,119.625,1000.977,37.019,-173.874,12.255,9.149,0.006,2.535,4.698,10.243,13.411,60.913,9.479,4.908,3.347
 2789.409,119.704,991.211,36.183,-173.739,12.172,9.150,0.001,2.531,4.696,10.483,11.994,61.059,9.582,4.992,3.412
 2789.909,119.667,991.211,33.647,-173.036,12.399,9.153,0.001,2.532,4.589,10.384,10.695,61.564,9.939,5.085,3.486
 2790.409,119.699,991.211,30.986,-172.421,12.659,9.159,0.002,2.542,4.456,9.804,10.638,61.930,10.198,5.176,3.565
 2790.909,119.574,1001.318,29.929,-172.075,12.652,9.169,0.005,2.556,4.302,8.977,11.733,61.859,10.148,5.272,3.646
 2791.409,119.706,1002.002,30.050,-171.647,12.327,9.179,0.008,2.564,4.305,8.528,12.885,61.474,9.876,5.386,3.742
 2791.909,119.558,1005.859,31.355,-171.072,11.876,9.182,0.010,2.561,4.437,8.712,13.632,60.961,9.513,5.554,3.871
 2792.409,119.683,1005.859,32.098,-170.608,11.641,9.182,0.012,2.558,4.584,8.884,14.119,60.493,9.182,5.775,4.028
 2792.909,119.569,1002.002,32.205,-170.435,11.669,9.182,0.018,2.571,4.671,8.131,14.871,60.076,8.887,6.057,4.212
 2793.409,119.689,1000.977,30.680,-170.297,11.641,9.182,0.021,2.584,4.607,7.350,16.394,59.596,8.548,6.347,4.404
 2793.909,119.720,1005.029,28.503,-170.193,11.265,9.182,0.018,2.589,4.613,7.079,18.515,59.013,8.136,6.646,4.596
 2794.409,119.691,1007.227,29.467,-169.905,10.566,9.181,0.012,2.593,4.642,6.859,20.504,58.390,7.696,6.924,4.789
 2794.909,119.651,1000.977,30.037,-169.338,9.886,9.180,0.006,2.595,4.642,6.713,21.668,57.872,7.330,7.189,4.966
 2795.409,119.682,998.096,30.672,-168.631,9.388,9.179,0.004,2.595,4.584,6.740,21.854,57.588,7.129,7.430,5.127
 2795.909,119.788,991.895,30.850,-167.646,9.161,9.178,0.002,2.591,4.519,6.983,21.669,57.488,7.058,7.635,5.263
 2796.409,119.595,1005.859,31.522,-167.685,9.208,9.171,-0.001,2.580,4.526,7.588,21.401,57.461,7.040,7.802,5.374
 2796.909,119.740,1001.074,33.218,-167.240,9.272,9.162,-0.003,2.573,4.457,8.021,20.912,57.482,7.055,7.923,5.481
 2797.409,119.735,1008.301,32.850,-166.996,9.189,9.158,-0.005,2.567,4.409,8.340,20.223,57.566,7.114,8.033,5.579
 2797.909,119.676,1000.977,30.377,-165.274,8.977,9.157,-0.003,2.571,4.422,8.120,20.020,57.631,7.159,8.121,5.693
 2798.409,119.749,995.605,27.532,-162.715,8.983,9.157,0.003,2.585,4.416,7.309,20.680,57.559,7.109,8.245,5.831
 2798.909,119.703,1001.318,26.950,-159.887,9.266,9.157,0.008,2.599,4.445,6.483,21.542,57.428,7.016,8.398,6.032
 2799.409,119.753,1005.859,28.537,-156.736,9.378,9.157,0.010,2.605,4.489,6.141,22.226,57.384,6.985,8.671,6.306
 2799.909,119.710,1013.867,31.058,-153.875,9.064,9.157,0.009,2.601,4.578,6.386,22.802,57.491,7.061,9.064,6.649
 2800.409,119.754,1007.324,31.738,-150.112,8.426,9.156,0.013,2.601,4.757,6.355,23.560,57.606,7.142,9.545,6.990
 2800.909,119.629,1010.742,29.883,-146.212,7.933,9.150,0.019,2.610,4.838,5.844,24.604,57.551,7.103,9.926,7.241
 2801.409,119.813,1004.004,26.591,-142.157,7.745,9.144,0.020,2.620,4.814,5.261,25.719,57.092,6.779,9.944,7.293
 2801.909,119.769,1004.199,24.983,-138.111,7.488,9.142,0.014,2.635,4.767,4.362,25.932,56.517,6.372,9.477,7.137
 2802.409,119.777,1008.398,28.888,-133.010,6.989,9.144,0.010,2.661,4.753,2.894,23.640,58.388,7.694,8.662,6.835
 2802.909,119.738,1007.178,40.679,-127.044,6.584,9.168,0.012,2.679,4.716,1.826,18.473,63.873,11.571,7.754,6.502
 2803.409,119.622,1006.885,62.438,-120.669,7.001,9.248,0.026,2.682,4.498,1.639,12.207,71.434,16.914,6.942,6.194
 2803.909,119.812,1005.859,89.389,-116.038,9.027,9.354,0.047,2.677,3.967,1.940,7.581,77.637,21.298,6.244,5.895
 2804.409,119.828,1001.758,112.578,-112.735,12.728,9.441,0.060,2.664,3.353,2.694,5.510,80.760,23.505,5.663,5.567
 2804.909,119.869,1004.102,126.927,-110.725,17.367,9.496,0.059,2.645,2.903,3.826,5.000,81.823,24.256,5.170,5.210
 2805.409,119.854,1005.322,131.265,-108.771,21.548,9.514,0.046,2.617,2.596,5.431,4.925,82.774,24.929,4.766,4.844
 2805.909,119.661,1005.859,129.798,-107.207,24.242,9.515,0.033,2.596,2.434,6.681,4.885,84.696,26.287,4.468,4.551
 2806.409,119.796,1001.318,125.326,-105.954,25.956,9.515,0.032,2.598,2.384,6.555,4.827,86.077,27.263,4.251,4.327
 2806.909,119.775,991.211,123.046,-104.180,27.197,9.515,0.033,2.609,2.455,5.880,4.725,86.393,27.487,4.124,4.201
 2807.409,119.740,995.996,126.210,-102.525,28.206,9.515,0.030,2.612,2.596,5.705,4.557,86.382,27.479,4.032,4.139
 2807.909,119.749,1000.977,129.244,-100.665,28.520,9.515,0.026,2.610,2.761,5.849,4.410,87.972,28.602,3.962,4.097
 2808.409,119.780,1005.859,131.749,-99.622,28.238,9.515,0.027,2.606,2.843,6.057,4.358,91.645,31.198,3.898,4.071
 2808.909,119.711,1003.174,132.295,-99.140,27.963,9.515,0.035,2.613,2.859,5.655,4.410,96.604,34.703,3.833,4.022
 2809.409,119.828,996.484,133.034,-99.129,28.008,9.515,0.039,2.619,2.845,5.311,4.475,100.704,37.600,3.790,3.989
 2809.909,119.763,1000.977,134.202,-99.868,28.108,9.515,0.036,2.617,2.852,5.442,4.471,101.970,38.495,3.781,3.988
 2810.409,119.897,991.846,133.325,-101.265,27.937,9.516,0.030,2.614,2.871,5.635,4.459,102.360,38.770,3.808,4.030
 2810.909,119.898,999.268,132.076,-102.275,27.999,9.487,0.022,2.604,2.812,6.206,4.492,104.087,39.990,3.883,4.127
 2811.409,119.719,1000.977,131.779,-102.715,28.728,9.412,0.015,2.597,2.747,6.590,4.623,106.741,41.866,3.988,4.245
 2811.909,119.810,994.141,132.305,-102.711,29.777,9.361,0.006,2.586,2.669,7.245,4.921,110.351,44.418,4.122,4.385
 2812.409,119.826,992.285,136.501,-102.867,30.341,9.345,-0.000,2.576,2.599,7.833,5.330,113.223,46.447,4.284,4.536
 2812.909,119.806,996.094,137.542,-104.056,29.730,9.320,0.000,2.573,2.548,8.023,5.781,114.381,47.265,4.480,4.706
 2813.409,119.790,993.457,130.265,-105.914,28.019,9.299,0.002,2.570,2.502,8.210,6.125,114.027,47.016,4.712,4.903
 2813.909,119.912,990.186,121.024,-107.867,25.840,9.292,0.006,2.570,2.492,8.210,6.308,111.039,44.904,4.960,5.113
 2814.409,119.827,996.094,116.138,-109.763,24.148,9.279,0.011,2.572,2.466,8.054,6.432,106.155,41.452,5.186,5.305
 2814.909,119.736,996.094,116.757,-111.303,23.247,9.260,0.012,2.573,2.411,8.040,6.606,102.090,38.580,5.346,5.437
 2815.409,119.934,999.707,117.093,-112.958,22.490,9.251,0.011,2.571,2.362,8.101,6.809,101.238,37.978,5.418,5.477
 2815.909,119.916,1005.859,111.595,-113.971,21.457,9.252,0.007,2.566,2.354,8.424,6.872,104.591,40.347,5.413,5.456
 2816.409,119.748,1003.857,102.787,-114.260,20.485,9.264,0.006,2.563,2.414,8.604,6.651,112.494,45.932,5.368,5.404
 2816.909,119.794,1000.977,101.427,-113.037,20.007,9.298,0.009,2.565,2.481,8.453,6.283,120.773,51.783,5.307,5.353
 2817.409,119.821,996.094,108.327,-111.412,20.344,9.332,0.017,2.580,2.521,7.588,5.968,124.771,54.608,5.247,5.300
 2817.909,119.790,996.094,118.724,-110.304,21.314,9.344,0.024,2.598,2.553,6.571,5.743,125.834,55.360,5.174,5.231
 2818.409,119.860,998.682,127.399,-110.557,22.712,9.346,0.029,2.612,2.572,5.724,5.618,125.608,55.200,5.083,5.128
 2818.909,119.867,1005.859,130.376,-112.142,24.406,9.346,0.030,2.624,2.556,5.048,5.543,127.140,56.283,4.980,5.011
 2819.409,119.949,1003.125,130.608,-114.264,25.696,9.346,0.023,2.616,2.531,5.471,5.462,130.348,58.550,4.867,4.888
 2819.909,119.963,1000.586,129.376,-117.647,26.013,9.348,0.013,2.595,2.565,6.745,5.348,132.258,59.900,4.768,4.778
 2820.409,119.922,1002.051,122.563,-121.165,25.492,9.353,0.003,2.561,2.532,8.701,5.229,131.672,59.485,4.672,4.670
 2820.909,119.934,1004.590,114.313,-123.937,24.531,9.356,0.001,2.541,2.466,9.897,5.130,130.224,58.462,4.581,4.568
 2821.409,119.942,1002.441,109.376,-125.836,23.622,9.361,0.010,2.546,2.400,9.600,5.039,129.018,57.610,4.488,4.480
 2821.909,119.848,1010.742,108.900,-127.086,23.207,9.365,0.020,2.559,2.373,8.835,4.953,127.418,56.479,4.408,4.421
 2822.409,119.891,997.070,112.668,-128.875,23.151,9.365,0.025,2.563,2.392,8.580,4.889,122.456,52.973,4.354,4.395
 2822.909,120.010,1000.977,112.875,-129.491,23.238,9.365,0.024,2.555,2.342,9.043,4.851,114.419,47.292,4.336,4.399
 2823.409,119.915,1000.977,107.939,-129.347,23.238,9.365,0.021,2.544,2.305,9.730,4.806,107.081,42.107,4.359,4.429
 2823.909,119.997,1002.295,106.512,-128.581,22.994,9.364,0.020,2.540,2.329,9.948,4.821,102.125,38.604,4.396,4.468
 2824.409,119.920,1005.859,106.802,-128.354,22.745,9.360,0.017,2.540,2.387,9.946,5.082,99.314,36.617,4.451,4.500
 2824.909,119.984,1010.742,108.920,-128.272,22.262,9.356,0.016,2.541,2.467,9.864,5.429,95.522,33.938,4.498,4.517
 2825.409,119.866,1006.592,107.714,-128.519,21.480,9.362,0.020,2.546,2.512,9.609,5.618,90.067,30.082,4.543,4.509
 2825.909,120.045,1007.666,103.898,-129.144,20.816,9.369,0.023,2.548,2.499,9.459,5.649,85.312,26.722,4.558,4.484
 2826.409,119.998,1015.088,101.325,-130.366,20.292,9.371,0.023,2.549,2.422,9.396,5.690,81.431,23.980,4.531,4.405
 2826.909,120.072,1013.574,99.882,-131.524,19.673,9.374,0.025,2.561,2.375,8.687,5.779,78.534,21.932,4.430,4.274
 2827.409,120.023,1010.742,102.446,-132.706,18.923,9.380,0.029,2.572,2.388,8.069,5.756,76.615,20.576,4.289,4.114
 2827.909,120.044,1010.449,103.469,-133.555,18.758,9.382,0.029,2.561,2.358,8.732,5.514,75.644,19.890,4.128,3.952
 2828.409,119.948,1015.625,103.457,-134.239,19.447,9.381,0.023,2.532,2.268,10.428,5.334,75.082,19.493,3.967,3.798
 2828.909,119.961,1022.607,104.916,-135.011,20.444,9.380,0.010,2.495,2.165,12.578,5.487,74.854,19.331,3.826,3.662
 2829.409,120.119,1005.859,106.064,-135.964,20.681,9.383,0.006,2.482,2.125,13.318,5.606,74.578,19.136,3.708,3.568
 2829.909,119.983,1005.859,107.522,-136.564,19.885,9.402,0.009,2.484,2.208,13.201,5.462,75.157,19.546,3.636,3.549
 2830.409,120.126,1006.738,108.185,-136.581,19.313,9.434,0.011,2.485,2.286,13.186,5.184,76.861,20.750,3.628,3.607
 2830.909,120.093,1012.646,107.089,-135.139,19.703,9.460,0.010,2.488,2.294,12.973,4.978,78.968,22.239,3.686,3.732
 2831.409,119.958,1010.107,108.009,-132.288,20.787,9.488,0.007,2.495,2.314,12.593,5.015,80.219,23.123,3.806,3.896
 2831.909,120.013,1005.859,110.857,-128.684,22.080,9.509,0.005,2.507,2.381,11.868,5.167,79.745,22.788,3.980,4.098
 2832.409,120.030,1010.742,115.189,-124.505,23.177,9.524,0.010,2.528,2.553,10.617,5.326,78.811,22.128,4.174,4.315
 2832.909,119.986,1007.275,121.509,-120.360,24.496,9.540,0.019,2.560,2.698,8.781,5.532,78.971,22.241,4.397,4.553
 2833.409,119.943,1006.982,126.583,-116.688,26.044,9.546,0.024,2.584,2.732,7.368,5.715,80.564,23.367,4.629,4.799
 2833.909,120.067,1014.404,130.453,-114.362,27.240,9.548,0.021,2.591,2.648,6.988,5.834,82.559,24.776,4.859,5.020
 2834.409,120.007,1012.891,129.999,-113.902,27.682,9.555,0.016,2.583,2.548,7.398,5.901,83.126,25.178,5.061,5.222
 2834.909,120.057,1013.672,128.587,-114.962,27.400,9.563,0.014,2.574,2.522,7.980,5.937,82.360,24.636,5.211,5.362
 2835.409,120.073,1010.693,128.017,-115.928,26.650,9.570,0.020,2.574,2.530,7.927,5.959,82.250,24.558,5.304,5.452
 2835.909,120.095,1020.508,126.594,-116.048,25.703,9.576,0.029,2.584,2.597,7.357,5.956,83.492,25.436,5.364,5.497
 2836.409,120.063,1015.625,127.158,-114.974,25.287,9.577,0.031,2.587,2.650,7.176,5.928,85.118,26.585,5.387,5.509
 2836.909,119.963,1011.230,129.522,-113.575,25.861,9.577,0.029,2.587,2.707,7.196,5.899,85.471,26.835,5.394,5.508
 2837.409,120.009,1008.691,133.156,-112.108,27.202,9.577,0.026,2.590,2.805,7.019,5.885,84.006,25.799,5.387,5.503
 2837.909,120.034,1001.221,131.428,-111.069,28.326,9.563,0.024,2.593,2.898,6.821,5.885,82.764,24.922,5.378,5.493
 2838.409,119.983,1011.328,122.581,-109.951,28.487,9.532,0.024,2.597,2.973,6.596,5.869,83.698,25.581,5.369,5.487
 2838.909,120.160,1000.977,115.547,-109.523,28.257,9.516,0.023,2.599,2.932,6.472,5.848,86.215,27.360,5.366,5.478
 2839.409,120.162,1017.969,117.309,-109.229,28.416,9.515,0.020,2.594,2.845,6.775,5.858,88.130,28.713,5.363,5.477
 2839.909,120.084,1015.625,122.262,-109.094,28.890,9.515,0.019,2.594,2.802,6.781,5.911,87.783,28.469,5.366,5.487
 2840.409,120.142,1012.842,123.244,-109.528,28.932,9.503,0.017,2.593,2.755,6.819,5.997,86.653,27.670,5.381,5.511
 2840.909,120.200,996.973,119.525,-110.240,28.410,9.480,0.017,2.594,2.764,6.810,6.072,86.443,27.522,5.414,5.541
 2841.409,120.163,1011.816,116.770,-111.360,27.518,9.456,0.018,2.596,2.756,6.677,6.133,86.536,27.587,5.464,5.573
 2841.909,120.147,1014.941,117.564,-112.356,26.547,9.433,0.018,2.591,2.721,6.966,6.208,86.352,27.457,5.511,5.581
 2842.409,120.115,1010.742,115.685,-113.324,25.631,9.410,0.018,2.586,2.671,7.237,6.305,85.740,27.025,5.532,5.549
 2842.909,120.113,1005.859,111.722,-114.075,24.853,9.394,0.018,2.584,2.639,7.339,6.379,85.566,26.902,5.509,5.479
 2843.409,120.064,1005.859,109.894,-114.937,24.236,9.393,0.023,2.594,2.650,6.798,6.384,88.972,29.309,5.442,5.395
 2843.909,120.092,1009.619,109.958,-115.868,23.814,9.393,0.029,2.602,2.658,6.341,6.301,94.026,32.880,5.361,5.324
 2844.409,120.053,1013.281,111.860,-116.302,23.498,9.393,0.031,2.598,2.658,6.551,6.179,96.388,34.550,5.289,5.274
 2844.909,120.131,1014.258,112.312,-115.913,23.084,9.391,0.028,2.589,2.643,7.084,6.065,94.971,33.548,5.258,5.246
 2845.409,120.154,1014.697,115.520,-114.831,22.910,9.377,0.022,2.580,2.658,7.621,5.968,91.235,30.908,5.283,5.247
 2845.909,120.010,1005.908,122.706,-114.218,23.706,9.305,0.020,2.582,2.718,7.510,5.994,88.874,29.239,5.381,5.268
 2846.409,120.160,996.094,123.396,-115.000,25.365,9.199,0.018,2.584,2.805,7.382,6.411,88.149,28.727,5.532,5.300
 2846.909,120.192,1010.742,112.419,-116.819,26.414,9.148,0.014,2.573,2.822,7.989,7.527,87.628,28.359,5.702,5.295
 2847.409,119.979,1015.137,93.393,-118.833,25.657,9.139,0.009,2.554,2.690,9.146,9.059,90.842,30.630,5.841,5.252
 2847.909,120.137,1017.725,77.157,-120.054,22.690,9.139,0.004,2.536,2.520,10.161,10.357,95.565,33.968,5.888,5.192
 2848.409,120.237,1015.869,68.833,-120.016,19.123,9.139,0.003,2.534,2.564,10.310,10.885,98.311,35.909,5.864,5.146
 2848.909,120.070,1011.035,67.065,-118.352,16.737,9.156,0.012,2.547,2.753,9.542,10.170,98.057,35.730,5.787,5.179
 2849.409,120.207,1005.859,71.519,-116.006,15.688,9.227,0.030,2.567,2.877,8.342,8.748,95.662,34.037,5.672,5.213
 2849.909,120.232,1008.594,85.310,-113.338,16.555,9.336,0.051,2.568,2.875,8.302,7.171,95.743,34.094,5.539,5.251
 2850.409,120.242,1011.230,105.766,-111.115,19.190,9.412,0.076,2.556,2.801,9.001,5.901,96.896,34.909,5.366,5.233
 2850.909,120.157,1020.508,122.356,-109.639,23.530,9.753,0.097,2.545,2.771,9.640,5.344,97.424,35.282,5.172,5.167
 2851.409,120.319,1015.625,128.716,-108.348,27.917,10.202,0.095,2.543,2.752,9.756,5.211,98.980,36.381,5.003,5.099
 2851.909,120.134,997.461,131.200,-107.301,30.327,9.972,0.070,2.558,2.840,8.912,5.369,101.397,38.090,4.863,4.992
 2852.409,120.309,989.746,134.602,-105.989,30.636,9.653,0.045,2.575,3.082,7.917,5.598,101.693,38.299,4.797,4.923
 2852.909,120.250,1014.014,137.150,-104.936,29.798,9.669,0.046,2.596,3.193,6.657,5.786,97.901,35.619,4.810,4.917
 2853.409,120.165,1018.652,133.282,-103.993,29.184,9.750,0.054,2.611,3.073,5.809,5.972,91.190,30.876,4.903,4.991
 2853.909,120.137,1010.742,123.758,-103.857,28.892,9.719,0.049,2.618,2.842,5.381,6.186,84.814,26.370,5.055,5.149
 2854.409,120.241,1014.453,118.196,-104.469,28.367,9.598,0.035,2.620,2.774,5.292,6.386,81.627,24.118,5.224,5.306
 2854.909,120.269,1014.453,114.812,-105.385,27.498,9.576,0.028,2.623,2.878,5.085,6.559,80.350,23.216,5.360,5.452
 2855.409,120.168,1015.625,110.911,-106.213,26.313,9.561,0.031,2.627,2.913,4.827,6.813,78.508,21.914,5.459,5.546
 2855.909,120.359,1011.670,105.860,-106.751,24.778,9.551,0.034,2.627,2.874,4.872,7.038,76.807,20.712,5.513,5.601
 2856.409,120.289,1028.662,104.111,-107.399,22.899,9.558,0.040,2.622,2.847,5.121,7.045,76.324,20.370,5.564,5.632
 2856.909,120.230,1025.391,109.281,-108.001,21.602,9.575,0.050,2.621,2.861,5.184,6.855,77.508,21.207,5.603,5.688
 2857.409,120.306,1015.625,117.566,-108.015,22.388,9.574,0.053,2.615,2.876,5.582,6.627,79.677,22.740,5.652,5.776
 2857.909,120.372,1020.068,120.945,-108.095,24.665,9.542,0.044,2.603,2.843,6.267,6.540,81.347,23.920,5.691,5.872
 2858.409,120.278,1018.408,118.312,-107.732,26.706,9.518,0.028,2.591,2.778,6.968,6.595,81.412,23.966,5.719,5.897
 2858.909,120.284,1006.348,116.057,-107.999,27.242,9.515,0.016,2.581,2.721,7.520,6.665,80.538,23.348,5.728,5.847
 2859.409,120.273,1018.164,112.959,-108.760,26.242,9.498,0.022,2.591,2.760,6.940,6.675,80.213,23.119,5.730,5.757
 2859.909,120.265,1015.625,109.927,-109.747,24.831,9.467,0.035,2.601,2.826,6.355,6.658,80.787,23.525,5.708,5.661
 2860.409,120.320,1015.918,105.998,-110.742,23.495,9.465,0.041,2.599,2.797,6.477,6.668,81.487,24.019,5.686,5.618
 2860.909,120.147,1020.752,106.017,-110.181,22.829,9.504,0.043,2.601,2.757,6.379,6.612,81.728,24.190,5.639,5.602
 2861.409,120.352,1025.391,108.380,-108.606,23.029,9.580,0.043,2.615,2.762,5.529,6.427,81.161,23.789,5.594,5.608
 2861.909,120.389,1024.414,109.960,-106.657,23.934,9.653,0.042,2.636,2.862,4.326,6.137,80.629,23.413,5.565,5.644
 2862.409,120.321,1009.570,113.074,-106.255,25.503,9.686,0.035,2.643,2.950,3.903,5.893,81.235,23.841,5.548,5.656
 2862.909,120.285,1008.057,117.867,-106.514,27.367,9.702,0.022,2.625,2.897,4.966,5.855,82.610,24.813,5.548,5.672
 2863.409,120.406,1023.779,121.579,-106.955,28.817,9.707,0.011,2.603,2.841,6.264,6.002,83.835,25.678,5.543,5.658
 2863.909,120.205,1021.436,119.115,-107.134,28.947,9.708,0.009,2.588,2.835,7.130,6.260,84.011,25.803,5.517,5.606
 2864.409,120.226,1025.391,113.223,-106.920,27.704,9.721,0.015,2.582,2.842,7.457,6.472,82.586,24.796,5.479,5.552
 2864.909,120.381,1029.102,108.190,-106.359,26.081,9.764,0.024,2.586,2.834,7.263,6.516,80.683,23.451,5.423,5.481
 2865.409,120.260,1021.631,108.393,-105.512,24.998,9.823,0.026,2.588,2.778,7.155,6.388,79.414,22.554,5.360,5.431
 2865.909,120.372,1019.092,111.444,-105.005,24.780,9.880,0.022,2.589,2.750,7.098,6.154,79.337,22.499,5.290,5.394
 2866.409,120.446,1023.535,114.873,-103.438,25.279,9.944,0.017,2.598,2.766,6.578,5.892,80.469,23.300,5.203,5.349
 2866.909,120.359,1025.391,118.176,-101.825,26.548,9.996,0.013,2.603,2.804,6.264,5.626,81.992,24.376,5.111,5.295
 2867.409,120.313,1025.391,119.214,-100.127,28.442,10.025,0.009,2.603,2.823,6.269,5.429,83.079,25.144,5.006,5.210
 2867.909,120.271,1023.486,119.341,-100.238,30.364,10.023,0.005,2.596,2.818,6.646,5.407,83.211,25.238,4.910,5.106
 2868.409,120.271,1020.508,118.769,-100.751,31.692,10.013,0.003,2.589,2.752,7.054,5.493,82.615,24.816,4.827,5.020
 2868.909,120.435,1015.625,118.826,-100.828,32.140,10.003,0.005,2.592,2.718,6.914,5.568,81.865,24.286,4.781,4.964
 2869.409,120.350,1015.625,122.098,-100.299,32.471,9.983,0.009,2.599,2.742,6.475,5.572,81.607,24.104,4.772,4.968
 2869.909,120.281,1022.852,127.143,-100.062,33.556,9.973,0.012,2.603,2.815,6.270,5.520,82.041,24.411,4.803,4.998
 2870.409,120.379,1025.293,129.815,-100.660,34.285,9.972,0.012,2.600,2.884,6.461,5.532,82.631,24.827,4.844,5.028
 2870.909,120.357,1015.625,124.675,-101.696,33.187,9.948,0.014,2.596,2.877,6.676,5.646,82.863,24.991,4.874,5.043
 2871.409,120.293,1025.146,115.145,-102.551,30.992,9.920,0.019,2.588,2.825,7.111,5.758,82.579,24.791,4.885,5.042
 2871.909,120.410,1020.508,111.214,-102.709,29.158,9.910,0.035,2.582,2.756,7.478,5.789,81.972,24.362,4.883,5.053
 2872.409,120.477,1020.508,113.062,-102.718,28.297,9.942,0.057,2.581,2.728,7.550,5.738,81.542,24.058,4.898,5.084
 2872.909,120.383,1023.584,118.802,-102.159,27.641,9.912,0.075,2.581,2.725,7.556,5.649,81.455,23.996,4.923,5.126
 2873.409,120.313,1024.658,124.465,-101.446,27.060,9.842,0.082,2.582,2.703,7.485,5.615,81.709,24.176,4.971,5.174
 2873.909,120.314,1017.236,126.831,-101.216,27.387,9.863,0.073,2.578,2.657,7.724,5.678,83.705,25.586,5.008,5.196
 2874.409,120.457,1016.602,125.134,-102.029,28.423,9.908,0.053,2.572,2.617,8.093,5.816,87.812,28.489,5.030,5.185
 2874.909,120.373,1020.508,120.106,-103.814,28.855,9.943,0.034,2.574,2.619,7.974,5.920,92.176,31.573,5.028,5.165
 2875.409,120.528,1019.287,119.863,-105.005,28.194,9.955,0.018,2.578,2.667,7.694,5.923,93.149,32.261,5.021,5.160
 2875.909,120.441,1022.754,122.912,-107.227,27.362,9.945,0.011,2.583,2.708,7.423,5.889,89.504,29.685,5.035,5.204
 2876.409,120.368,1021.924,124.586,-110.542,27.306,9.932,0.011,2.583,2.740,7.456,5.852,84.350,26.042,5.084,5.273
 2876.909,120.425,1029.395,120.133,-114.798,27.688,9.923,0.017,2.576,2.752,7.862,5.771,82.192,24.517,5.171,5.347
 2877.409,120.455,1018.945,110.599,-117.288,27.334,9.852,0.024,2.564,2.775,8.556,5.662,84.721,26.304,5.291,5.421
 2877.909,120.551,1025.391,104.649,-117.448,26.464,9.724,0.029,2.550,2.823,9.374,5.751,88.946,29.290,5.407,5.468
 2878.409,120.490,1025.391,99.681,-116.970,25.437,9.666,0.027,2.542,2.827,9.804,6.378,89.956,30.004,5.496,5.474
 2878.909,120.373,1029.834,94.557,-116.553,23.599,9.666,0.020,2.544,2.792,9.725,7.158,86.771,27.753,5.542,5.436
 2879.409,120.451,1020.508,95.117,-115.472,20.584,9.688,0.017,2.558,2.732,8.915,7.357,83.316,25.312,5.565,5.399
 2879.909,120.480,1020.508,104.224,-113.883,17.587,9.748,0.019,2.580,2.688,7.629,6.901,81.739,24.197,5.594,5.421
 2880.409,120.458,1035.352,119.932,-112.070,16.978,9.812,0.024,2.595,2.718,6.707,6.159,81.829,24.261,5.616,5.482
 2880.909,120.404,1025.342,128.259,-110.992,18.812,9.867,0.026,2.599,2.741,6.482,5.742,81.056,23.715,5.605,5.539
 2881.409,120.539,1030.859,123.128,-110.961,21.516,9.907,0.024,2.594,2.660,6.785,5.687,79.306,22.478,5.515,5.525
 2881.909,120.455,1021.094,112.861,-111.158,23.334,9.929,0.024,2.588,2.576,7.158,5.635,79.738,22.783,5.366,5.451
 2882.409,120.437,1030.273,109.495,-110.871,23.925,9.946,0.031,2.596,2.630,6.677,5.522,83.098,25.158,5.210,5.345
 2882.909,120.297,1021.045,114.626,-109.280,24.252,9.950,0.035,2.604,2.766,6.217,5.404,86.118,27.292,5.084,5.239
 2883.409,120.544,1028.467,122.390,-107.298,24.887,9.951,0.033,2.607,2.912,6.008,5.331,86.433,27.515,5.013,5.162
 2883.909,120.397,1031.006,127.710,-106.549,25.745,9.951,0.029,2.605,2.945,6.139,5.313,84.499,26.148,4.983,5.129
 2884.409,120.541,1031.836,126.937,-107.057,26.528,9.960,0.026,2.594,2.849,6.770,5.321,81.759,24.212,4.979,5.141
 2884.909,120.554,1033.203,123.415,-107.849,26.766,10.001,0.030,2.595,2.758,6.745,5.328,80.449,23.285,4.989,5.177
 2885.409,120.524,1025.391,122.757,-108.439,26.444,10.055,0.032,2.602,2.654,6.302,5.317,80.337,23.206,5.008,5.215
 2885.909,120.555,1026.611,123.971,-108.365,26.180,10.095,0.029,2.609,2.590,5.890,5.285,80.023,22.984,5.029,5.233
 2886.409,120.520,1041.553,127.004,-108.392,26.294,10.133,0.024,2.611,2.586,5.818,5.243,79.279,22.459,5.045,5.234
 2886.909,120.620,1030.273,129.871,-108.298,26.861,10.166,0.019,2.604,2.610,6.212,5.179,78.410,21.844,5.056,5.230
 2887.409,120.658,1018.262,132.129,-108.259,27.314,10.179,0.018,2.596,2.666,6.641,5.105,77.852,21.450,5.069,5.241
 2887.909,120.539,1033.447,130.975,-108.962,27.377,10.159,0.018,2.587,2.730,7.203,5.056,77.764,21.388,5.085,5.251
 2888.409,120.456,1030.273,126.744,-109.601,27.546,10.143,0.017,2.569,2.768,8.250,5.055,78.542,21.938,5.107,5.255
 2888.909,120.553,1030.273,126.250,-111.302,27.899,10.082,0.014,2.550,2.769,9.377,5.140,80.853,23.571,5.117,5.227
 2889.409,120.590,1034.766,127.477,-112.067,27.745,9.983,0.011,2.533,2.717,10.342,5.340,84.475,26.131,5.121,5.203
 2889.909,120.563,1035.156,128.117,-112.167,26.192,9.952,0.012,2.531,2.624,10.465,5.554,89.640,29.781,5.118,5.208
 2890.409,120.646,1039.893,123.419,-110.780,23.764,9.980,0.020,2.547,2.610,9.561,5.637,94.388,33.136,5.139,5.263
 2890.909,120.462,1030.273,116.186,-109.248,22.283,10.008,0.030,2.570,2.711,8.163,5.584,97.631,35.428,5.181,5.343
 2891.409,120.552,1030.273,112.393,-107.850,22.984,10.012,0.034,2.593,2.855,6.822,5.550,100.281,37.301,5.235,5.387
 2891.909,120.575,1035.547,115.357,-107.402,25.041,9.986,0.036,2.598,2.981,6.533,5.618,103.391,39.499,5.273,5.379
 2892.409,120.631,1039.746,122.002,-107.698,26.248,9.895,0.046,2.587,2.986,7.202,5.649,108.388,43.031,5.262,5.332
 2892.909,120.544,1035.156,127.780,-108.424,25.993,9.867,0.055,2.561,2.853,8.708,5.633,115.348,47.949,5.214,5.295
 2893.409,120.442,1039.502,131.078,-108.878,25.097,9.872,0.054,2.543,2.683,9.750,5.637,121.367,52.203,5.128,5.257
 2893.909,120.490,1032.080,126.451,-108.917,24.766,9.844,0.042,2.544,2.603,9.731,5.735,124.589,54.480,5.038,5.163
 2894.409,120.534,1031.836,119.032,-108.127,25.061,9.862,0.037,2.559,2.601,8.803,5.812,122.373,52.914,4.956,5.075
 2894.909,120.690,1040.039,112.724,-107.815,25.224,9.910,0.046,2.583,2.636,7.437,5.743,113.695,46.781,4.903,4.994
 2895.409,120.585,1043.896,108.271,-107.375,25.494,9.966,0.053,2.601,2.668,6.364,5.599,103.365,39.480,4.865,4.966
 2895.909,120.448,1040.039,108.637,-107.654,26.285,10.023,0.051,2.611,2.705,5.781,5.449,95.668,34.041,4.859,4.972
 2896.409,120.507,1026.611,112.222,-107.685,27.802,10.097,0.047,2.620,2.771,5.275,5.352,92.748,31.977,4.840,4.977
 2896.909,120.520,1041.699,120.483,-107.872,29.771,10.152,0.045,2.620,2.813,5.289,5.317,92.385,31.721,4.834,4.997
 2897.409,120.618,1040.039,125.258,-107.472,30.754,10.127,0.041,2.608,2.822,5.945,5.348,91.026,30.760,4.827,5.011
 2897.909,120.687,1040.039,123.045,-107.253,30.147,10.071,0.041,2.604,2.856,6.206,5.418,87.980,28.607,4.816,4.993
 2898.409,120.573,1033.691,118.420,-106.514,28.778,10.065,0.040,2.596,2.840,6.646,5.505,84.380,26.064,4.829,4.987
 2898.909,120.593,1040.039,116.357,-106.033,27.748,10.088,0.042,2.602,2.771,6.335,5.542,81.771,24.220,4.830,4.968
 2899.409,120.618,1035.156,118.631,-105.082,27.231,10.090,0.043,2.607,2.730,6.043,5.564,80.800,23.534,4.848,4.967
 2899.909,120.542,1035.156,121.111,-104.239,26.909,10.088,0.050,2.612,2.757,5.706,5.536,80.479,23.307,4.854,4.993
 2900.409,120.677,1040.039,116.381,-104.996,26.461,10.118,0.063,2.619,2.821,5.293,5.474,80.119,23.052,4.854,4.989
 2900.909,120.620,1040.039,107.304,-105.833,26.184,10.163,0.070,2.611,2.879,5.774,5.406,79.901,22.898,4.869,5.035
 2901.409,120.677,1037.549,104.520,-107.298,26.127,10.190,0.069,2.607,2.942,6.049,5.361,80.242,23.139,4.878,5.021
 2901.909,120.760,1039.844,106.026,-107.853,25.911,10.199,0.060,2.602,3.005,6.298,5.407,82.314,24.604,4.889,5.014
 2902.409,120.545,1032.910,109.525,-108.270,25.338,10.217,0.050,2.609,3.030,5.902,5.448,87.911,28.559,4.874,4.968
 2902.909,120.639,1039.355,111.641,-107.159,24.530,10.234,0.041,2.617,3.072,5.410,5.439,93.219,32.310,4.828,4.913
 2903.409,120.727,1030.273,110.104,-105.496,23.891,10.248,0.035,2.624,3.128,5.043,5.350,94.751,33.393,4.781,4.915
 2903.909,120.591,1035.693,111.585,-104.302,23.483,10.262,0.033,2.625,3.185,4.978,5.189,92.105,31.523,4.734,4.914
 2904.409,120.724,1033.789,117.664,-104.966,23.492,10.269,0.039,2.624,3.156,5.052,4.954,87.941,28.580,4.729,4.948
 2904.909,120.633,1030.273,124.026,-106.494,24.027,10.282,0.053,2.630,3.050,4.686,4.704,85.869,27.116,4.731,4.960
 2905.409,120.582,1026.904,126.248,-107.932,25.506,10.467,0.061,2.632,3.008,4.561,4.621,86.423,27.507,4.734,4.951
 2905.909,120.601,1042.871,120.229,-108.092,27.460,10.479,0.057,2.624,2.978,5.044,4.793,88.563,29.020,4.720,4.931
 2906.409,120.649,1035.156,114.493,-106.773,28.196,10.199,0.042,2.606,2.923,6.074,5.074,89.671,29.803,4.675,4.858
 2906.909,120.812,1035.156,118.142,-104.586,26.929,10.096,0.031,2.601,2.827,6.379,5.243,88.090,28.685,4.643,4.805
 2907.409,120.753,1038.965,122.301,-103.267,24.820,10.090,0.029,2.610,2.742,5.846,5.231,84.597,26.217,4.634,4.765
 2907.909,120.786,1035.498,124.550,-101.617,23.906,10.082,0.026,2.612,2.753,5.758,5.128,81.607,24.104,4.650,4.764
 2908.409,120.618,1025.391,123.916,-100.342,24.694,10.080,0.018,2.604,2.801,6.226,5.021,80.652,23.429,4.678,4.792
 2908.909,120.719,1039.795,124.191,-99.546,26.012,10.082,0.007,2.589,2.795,7.074,4.930,81.427,23.977,4.682,4.806
 2909.409,120.821,1030.273,131.326,-99.794,27.146,10.091,-0.000,2.581,2.760,7.565,4.860,82.199,24.522,4.668,4.820
 2909.909,120.700,1032.227,132.402,-100.764,28.069,10.089,-0.002,2.583,2.728,7.451,4.843,82.636,24.831,4.636,4.797
 2910.409,120.823,1034.131,128.185,-101.015,28.353,10.080,0.002,2.595,2.739,6.746,4.858,83.475,25.424,4.602,4.750
 2910.909,120.747,1035.156,122.745,-100.684,27.656,10.090,0.011,2.616,2.816,5.517,4.884,85.984,27.197,4.571,4.698
 2911.409,120.733,1039.893,117.590,-100.422,26.629,10.113,0.019,2.626,2.899,4.934,4.908,89.334,29.565,4.542,4.656
 2911.909,120.789,1037.598,117.804,-100.709,26.048,10.136,0.020,2.617,2.967,5.451,4.901,92.429,31.752,4.515,4.655
 2912.409,120.715,1035.254,118.057,-101.231,26.151,10.161,0.018,2.598,3.008,6.540,4.849,94.101,32.934,4.501,4.671
 2912.909,120.713,1034.668,116.880,-101.674,26.660,10.196,0.022,2.578,3.071,7.745,4.740,93.023,32.172,4.494,4.682
 2913.409,120.834,1034.814,116.340,-101.718,27.196,10.245,0.039,2.571,3.117,8.132,4.617,91.316,30.965,4.495,4.676
 2913.909,120.753,1030.273,115.043,-102.569,27.938,10.342,0.053,2.576,3.100,7.834,4.549,90.869,30.649,4.485,4.649
 2914.409,120.793,1030.859,113.432,-102.197,28.818,10.342,0.050,2.583,3.021,7.454,4.560,91.658,31.207,4.464,4.614
 2914.909,120.825,1035.156,115.771,-102.446,29.646,10.285,0.031,2.590,2.906,7.004,4.630,93.475,32.491,4.436,4.576
 2915.409,120.705,1033.496,121.625,-101.155,30.137,10.275,0.010,2.595,2.837,6.706,4.703,94.432,33.168,4.406,4.541
 2915.909,120.769,1022.021,126.898,-100.489,29.942,10.240,0.005,2.609,2.822,5.917,4.744,93.108,32.232,4.399,4.539
 2916.409,120.722,1039.014,126.017,-99.539,29.608,10.231,0.007,2.618,2.841,5.370,4.765,90.451,30.354,4.418,4.557
 2916.909,120.795,1035.156,122.246,-99.192,29.484,10.249,0.006,2.616,2.871,5.479,4.780,87.273,28.108,4.458,4.582
 2917.409,120.887,1031.543,123.694,-99.651,29.763,10.269,0.002,2.608,2.851,5.952,4.788,84.645,26.251,4.498,4.585
 2917.909,120.645,1027.441,131.266,-100.698,30.298,10.292,-0.001,2.599,2.844,6.476,4.788,83.491,25.435,4.509,4.562
 2918.409,120.797,1030.273,137.695,-101.901,30.595,10.323,0.002,2.604,2.891,6.198,4.782,83.162,25.203,4.479,4.537
 2918.909,120.851,1030.273,137.803,-102.539,30.623,10.361,0.007,2.607,2.967,5.998,4.763,83.282,25.288,4.427,4.526
 2919.409,120.846,1038.281,129.976,-103.538,30.327,10.409,0.018,2.601,3.086,6.367,4.698,83.854,25.692,4.358,4.511
 2919.909,120.856,1035.156,118.832,-104.993,29.633,10.474,0.045,2.581,3.098,7.526,4.532,84.822,26.376,4.289,4.486
 2920.409,120.804,1029.395,113.074,-106.996,29.065,10.667,0.091,2.552,2.985,9.243,4.276,86.031,27.231,4.222,4.450
 2920.909,120.886,1026.074,114.631,-108.875,29.585,11.011,0.130,2.529,2.854,10.571,4.037,87.247,28.090,4.148,4.412
 2921.409,120.874,1035.156,122.574,-109.853,31.301,11.228,0.139,2.501,2.769,12.209,3.897,88.088,28.684,4.079,4.386
 2921.909,120.768,1039.941,127.412,-110.031,33.462,11.237,0.133,2.472,2.718,13.903,3.842,88.479,28.960,3.993,4.331
 2922.409,120.793,1037.598,125.029,-109.404,35.418,11.450,0.126,2.460,2.700,14.636,3.853,88.203,28.765,3.933,4.258
 2922.909,120.793,1039.746,120.158,-108.270,36.899,11.766,0.120,2.465,2.717,14.323,3.904,87.472,28.249,3.894,4.189
 2923.409,120.832,1035.645,118.965,-107.296,38.051,11.623,0.109,2.486,2.795,13.083,4.012,86.573,27.613,3.890,4.116
 2923.909,120.936,1039.014,121.008,-106.437,38.559,11.265,0.092,2.502,2.932,12.159,4.145,85.763,27.041,3.914,4.083
 2924.409,120.795,1025.391,120.617,-105.989,37.874,11.052,0.084,2.510,2.998,11.690,4.253,85.328,26.733,3.954,4.081
 2924.909,120.929,1030.273,117.638,-105.609,36.588,10.936,0.079,2.514,2.973,11.446,4.334,85.061,26.545,3.996,4.109
 2925.409,120.767,1033.447,116.554,-106.138,34.870,10.847,0.077,2.527,2.956,10.722,4.372,84.968,26.479,4.045,4.179
 2925.909,120.878,1044.922,116.382,-107.255,33.607,10.829,0.086,2.551,2.948,9.283,4.359,85.061,26.545,4.084,4.236
 2926.409,120.842,1038.184,117.981,-108.305,33.365,10.884,0.096,2.576,2.909,7.861,4.327,85.395,26.781,4.124,4.302
 2926.909,120.723,1042.773,122.790,-108.396,33.626,10.921,0.095,2.587,2.819,7.221,4.304,85.945,27.169,4.159,4.346
 2927.409,120.777,1035.156,126.803,-107.392,34.024,10.936,0.092,2.594,2.765,6.796,4.296,86.344,27.452,4.173,4.356
 2927.909,120.848,1037.793,132.545,-106.225,33.908,10.983,0.091,2.591,2.769,6.933,4.307,86.416,27.503,4.161,4.334
 2928.409,120.863,1041.064,136.220,-105.719,33.814,10.923,0.094,2.577,2.764,7.774,4.317,86.346,27.453,4.139,4.310
 2928.909,120.833,1040.039,136.843,-106.131,33.816,10.851,0.098,2.553,2.710,9.153,4.322,86.186,27.340,4.091,4.278
 2929.409,120.914,1035.938,134.306,-106.770,33.335,10.869,0.096,2.524,2.639,10.849,4.313,86.138,27.306,4.055,4.260
 2929.909,120.947,1032.031,130.344,-107.446,32.735,10.940,0.099,2.508,2.659,11.785,4.241,86.427,27.510,4.036,4.255
 2930.409,120.854,1035.156,126.109,-107.729,33.093,10.941,0.106,2.500,2.674,12.260,4.136,87.010,27.922,4.018,4.231
 2930.909,120.862,1040.918,125.949,-107.534,34.640,11.008,0.102,2.496,2.714,12.519,4.068,87.398,28.197,4.023,4.222
 2931.409,120.869,1030.615,127.206,-107.346,35.888,11.065,0.097,2.504,2.792,12.037,4.054,87.227,28.075,3.999,4.180
 2931.909,120.832,1030.273,124.980,-107.129,36.168,11.051,0.091,2.526,2.878,10.774,4.096,86.762,27.747,3.960,4.132
 2932.409,120.906,1035.059,122.519,-106.558,35.597,11.107,0.089,2.549,2.990,9.422,4.148,86.441,27.520,3.918,4.118
 2932.909,120.854,1042.334,117.773,-106.301,34.567,11.236,0.091,2.565,3.050,8.487,4.174,86.274,27.402,3.886,4.113
 2933.409,120.803,1035.156,114.689,-106.383,33.011,11.272,0.097,2.568,3.105,8.293,4.161,86.101,27.280,3.891,4.151
 2933.909,120.829,1035.156,113.883,-107.457,31.313,11.250,0.114,2.562,3.113,8.626,4.098,86.226,27.368,3.924,4.187
 2934.409,120.867,1040.039,112.979,-108.503,31.617,11.370,0.133,2.538,3.119,10.032,4.029,86.914,27.854,3.969,4.231
 2934.909,120.988,1040.039,114.432,-109.122,34.058,11.407,0.135,2.501,3.053,12.215,4.022,87.773,28.462,4.005,4.273
 2935.409,120.894,1036.426,120.618,-109.245,35.995,11.364,0.118,2.470,2.935,14.034,4.088,87.988,28.613,3.997,4.259
 2935.909,120.941,1044.922,124.228,-109.218,35.435,11.314,0.097,2.461,2.880,14.570,4.163,87.369,28.176,3.978,4.219
 2936.409,120.992,1035.156,126.169,-108.395,33.506,11.258,0.091,2.478,2.836,13.582,4.209,86.498,27.560,3.944,4.176
 2936.909,120.864,1038.574,127.059,-108.136,32.910,11.235,0.087,2.496,2.850,12.503,4.232,86.108,27.285,3.955,4.169
 2937.409,120.946,1044.922,127.267,-107.508,34.220,11.180,0.089,2.523,2.916,10.940,4.227,86.296,27.418,3.999,4.214
 2937.909,120.894,1044.922,129.190,-107.621,35.760,11.249,0.090,2.545,2.966,9.668,4.202,86.498,27.560,4.059,4.238
 2938.409,120.892,1044.922,128.373,-107.288,36.427,11.442,0.089,2.566,3.042,8.431,4.179,86.439,27.519,4.127,4.280
 2938.909,120.962,1044.922,129.017,-106.527,36.483,11.411,0.084,2.576,3.063,7.853,4.196,85.950,27.173,4.168,4.291
 2939.409,120.805,1035.156,131.027,-105.893,36.730,11.162,0.069,2.560,3.001,8.762,4.288,85.265,26.689,4.175,4.283
 2939.909,121.015,1039.258,129.843,-105.470,37.387,10.946,0.061,2.543,2.969,9.746,4.407,84.743,26.320,4.170,4.285
 2940.409,120.991,1041.846,126.609,-105.423,37.204,10.903,0.069,2.536,2.945,10.166,4.471,84.751,26.326,4.146,4.294
 2940.909,120.987,1044.922,124.063,-105.111,35.783,10.987,0.079,2.533,2.958,10.372,4.459,85.326,26.732,4.152,4.337
 2941.409,120.954,1044.922,124.797,-105.312,33.734,11.003,0.092,2.526,3.029,10.747,4.351,86.041,27.238,4.170,4.390
 2941.909,121.056,1035.742,125.987,-105.359,31.874,11.122,0.116,2.519,3.056,11.173,4.213,86.484,27.551,4.198,4.399
 2942.409,120.953,1044.922,123.714,-106.047,31.545,11.533,0.142,2.517,2.969,11.283,4.139,86.650,27.668,4.217,4.441
 2942.909,120.971,1049.756,121.168,-106.150,33.063,11.700,0.153,2.529,2.838,10.576,4.142,86.460,27.534,4.222,4.438
 2943.409,120.948,1052.393,122.829,-105.946,35.355,11.410,0.133,2.549,2.779,9.442,4.217,85.929,27.158,4.204,4.434
 2943.909,120.948,1059.424,125.234,-105.275,37.271,11.261,0.105,2.567,2.815,8.336,4.293,85.294,26.710,4.174,4.373
 2944.409,120.884,1051.953,125.174,-104.926,37.802,11.207,0.092,2.571,2.894,8.156,4.338,84.886,26.421,4.142,4.290
 2944.909,120.904,1048.633,123.768,-104.885,36.654,11.124,0.097,2.560,2.920,8.758,4.355,85.032,26.524,4.134,4.257
 2945.409,120.953,1035.156,123.144,-105.679,34.652,11.035,0.098,2.535,2.847,10.228,4.352,85.490,26.848,4.133,4.239
 2945.909,120.871,1036.426,123.945,-106.529,32.891,10.956,0.094,2.509,2.808,11.766,4.314,86.095,27.276,4.152,4.280
 2946.409,120.810,1048.096,124.095,-107.096,32.324,10.974,0.102,2.504,2.811,12.072,4.238,86.767,27.751,4.143,4.308
 2946.909,120.976,1048.926,121.078,-106.647,33.557,11.154,0.114,2.505,2.843,11.968,4.182,87.197,28.055,4.142,4.338
 2947.409,120.919,1048.340,118.593,-105.912,36.122,11.314,0.120,2.517,2.931,11.295,4.159,87.170,28.035,4.134,4.372
 2947.909,120.984,1049.805,119.283,-104.836,38.205,11.267,0.110,2.526,2.953,10.768,4.155,86.569,27.610,4.114,4.339
 2948.409,121.158,1042.480,121.563,-104.169,38.222,11.204,0.093,2.521,2.977,11.072,4.137,85.858,27.108,4.122,4.354
 2948.909,120.962,1044.922,123.793,-103.505,36.200,11.091,0.092,2.511,2.942,11.662,4.107,85.418,26.797,4.143,4.369
 2949.409,121.064,1041.016,123.859,-103.188,33.751,10.980,0.092,2.497,2.888,12.480,4.160,85.120,26.586,4.181,4.390
 2949.909,121.056,1041.602,123.758,-102.866,32.645,10.956,0.095,2.498,2.905,12.391,4.293,84.767,26.337,4.245,4.394
 2950.409,121.064,1053.223,126.658,-103.035,32.526,11.018,0.117,2.530,2.920,10.542,4.427,84.465,26.124,4.274,4.346
 2950.909,120.945,1041.846,129.926,-103.208,32.419,11.114,0.138,2.567,2.905,8.354,4.545,84.493,26.144,4.303,4.363
 2951.409,120.967,1044.922,130.307,-103.842,32.276,11.042,0.134,2.586,2.913,7.268,4.639,84.601,26.220,4.325,4.459
 2951.909,120.893,1050.586,127.077,-104.610,32.421,10.950,0.112,2.593,3.065,6.820,4.669,84.509,26.155,4.350,4.564
 2952.409,120.877,1049.512,123.394,-104.571,32.321,10.971,0.100,2.598,3.266,6.528,4.592,84.202,25.938,4.408,4.678
 2952.909,121.039,1052.100,122.987,-104.728,32.060,11.013,0.118,2.593,3.410,6.842,4.378,83.737,25.609,4.493,4.735
 2953.409,121.049,1040.186,122.892,-104.841,33.285,10.945,0.136,2.569,3.328,8.246,4.190,83.448,25.405,4.567,4.759
 2953.909,120.981,1040.039,120.438,-105.240,36.070,11.072,0.121,2.538,3.074,10.063,4.257,83.184,25.219,4.617,4.761
 2954.409,121.127,1035.547,118.439,-105.460,37.871,11.131,0.085,2.524,2.834,10.888,4.546,82.544,24.766,4.600,4.695
 2954.909,121.030,1044.922,115.907,-105.176,36.962,10.881,0.051,2.540,2.789,9.937,4.866,81.809,24.246,4.536,4.607
 2955.409,120.918,1044.922,116.037,-104.835,34.569,10.788,0.034,2.565,2.960,8.481,5.013,81.615,24.110,4.483,4.552
 2955.909,121.067,1047.900,120.348,-105.216,32.950,10.819,0.040,2.573,3.107,7.995,4.915,82.299,24.593,4.463,4.527
 2956.409,120.949,1044.922,124.570,-105.266,32.794,10.868,0.066,2.577,3.128,7.761,4.708,83.198,25.229,4.471,4.556
 2956.909,121.093,1044.922,121.874,-105.108,33.522,10.939,0.103,2.580,3.050,7.629,4.479,83.792,25.648,4.465,4.600
 2957.409,121.014,1043.164,113.951,-104.628,34.685,11.098,0.133,2.568,2.960,8.322,4.258,84.253,25.974,4.419,4.645
 2957.909,121.017,1045.557,108.490,-104.234,35.930,11.394,0.149,2.540,2.844,9.922,4.087,85.088,26.564,4.363,4.702
 2958.409,120.988,1054.688,111.521,-104.114,36.964,11.545,0.147,2.506,2.705,11.950,4.015,86.144,27.310,4.302,4.683
 2958.909,121.140,1051.025,119.536,-104.466,37.412,11.279,0.133,2.483,2.619,13.298,4.028,86.670,27.682,4.268,4.607
 2959.409,121.127,1047.070,122.762,-105.516,37.465,11.096,0.115,2.454,2.651,14.955,4.079,86.144,27.311,4.243,4.484
 2959.909,120.935,1040.039,120.989,-106.367,37.617,11.308,0.101,2.425,2.649,16.658,4.183,84.875,26.413,4.240,4.413
 2960.409,121.169,1043.262,118.979,-105.780,37.447,11.192,0.078,2.415,2.632,17.249,4.393,83.651,25.549,4.262,4.420
 2960.909,121.014,1053.955,119.271,-104.475,36.289,10.799,0.056,2.436,2.707,16.002,4.637,82.816,24.958,4.323,4.465
 2961.409,121.047,1054.688,121.876,-103.747,34.096,10.672,0.055,2.481,2.843,13.410,4.749,82.419,24.678,4.428,4.536
 2961.909,121.118,1041.504,124.732,-103.769,32.227,10.643,0.074,2.505,2.913,12.007,4.704,82.325,24.611,4.541,4.606
 2962.409,120.983,1055.957,124.950,-103.554,31.765,10.721,0.099,2.509,2.861,11.782,4.628,82.467,24.712,4.648,4.708
 2962.909,121.007,1064.453,121.326,-102.753,32.062,10.782,0.115,2.532,2.717,10.391,4.632,82.642,24.836,4.687,4.798
 2963.409,121.063,1055.566,118.051,-101.420,31.885,10.671,0.104,2.561,2.632,8.711,4.737,82.599,24.805,4.674,4.818
 2963.909,121.103,1044.873,120.771,-100.856,31.526,10.586,0.085,2.583,2.700,7.447,4.816,82.421,24.679,4.630,4.804
 2964.409,121.080,1050.000,127.241,-100.399,31.815,10.570,0.079,2.589,2.824,7.073,4.793,82.346,24.626,4.587,4.729
 2964.909,121.018,1054.102,131.440,-101.021,32.056,10.584,0.082,2.586,2.917,7.244,4.723,82.743,24.907,4.554,4.673
 2965.409,121.182,1040.039,128.489,-101.755,32.322,10.630,0.092,2.594,2.905,6.790,4.652,83.526,25.460,4.550,4.669
 2965.909,121.077,1044.922,125.804,-102.057,32.497,10.689,0.083,2.593,2.837,6.821,4.631,84.162,25.910,4.526,4.690
 2966.409,121.223,1041.943,127.778,-102.415,32.519,10.760,0.056,2.584,2.855,7.366,4.652,84.382,26.065,4.519,4.724
 2966.909,121.100,1040.723,130.161,-102.577,32.831,10.827,0.052,2.583,2.927,7.434,4.628,84.566,26.195,4.514,4.733
 2967.409,121.053,1048.145,127.686,-103.818,32.877,10.865,0.074,2.585,2.848,7.332,4.580,84.815,26.371,4.531,4.720
 2967.909,121.052,1044.922,121.101,-104.411,32.635,10.848,0.085,2.578,2.734,7.730,4.652,84.820,26.375,4.570,4.715
 2968.409,121.088,1048.389,116.491,-104.227,32.719,10.739,0.074,2.568,2.692,8.276,4.833,84.345,26.039,4.597,4.705
 2968.909,121.222,1049.805,116.731,-102.820,32.700,10.643,0.065,2.571,2.664,8.129,4.969,83.519,25.455,4.585,4.675
 2969.409,121.065,1046.094,118.611,-102.613,32.684,10.629,0.068,2.583,2.660,7.454,4.956,83.117,25.171,4.587,4.709
 2969.909,120.997,1052.539,119.807,-103.285,32.569,10.655,0.072,2.588,2.628,7.158,4.822,83.257,25.270,4.596,4.756
 2970.409,121.057,1059.570,120.255,-104.846,32.146,10.745,0.067,2.589,2.624,7.056,4.703,83.589,25.505,4.626,4.787
 2970.909,121.024,1049.805,123.111,-106.352,32.284,10.836,0.072,2.593,2.703,6.865,4.632,83.968,25.772,4.660,4.799
 2971.409,121.165,1053.955,123.758,-107.169,33.499,10.952,0.093,2.600,2.748,6.454,4.572,84.210,25.944,4.651,4.773
 2971.909,121.099,1050.977,121.635,-107.381,35.566,11.033,0.104,2.588,2.708,7.111,4.553,84.384,26.067,4.614,4.775
 2972.409,121.169,1044.922,120.912,-107.262,36.735,11.005,0.098,2.573,2.674,8.015,4.540,84.407,26.083,4.544,4.754
 2972.909,121.070,1042.822,120.126,-107.374,35.609,11.093,0.094,2.570,2.680,8.215,4.467,84.385,26.067,4.461,4.677
 2973.409,121.288,1049.316,121.698,-107.476,33.597,11.284,0.100,2.570,2.708,8.206,4.352,84.728,26.310,4.387,4.601
 2973.909,121.097,1049.805,120.934,-107.375,33.316,11.544,0.108,2.558,2.751,8.860,4.247,85.498,26.854,4.324,4.515
 2974.409,121.159,1044.922,117.063,-107.849,34.834,11.727,0.105,2.539,2.821,10.011,4.198,86.296,27.418,4.249,4.434
 2974.909,121.231,1049.805,114.528,-108.572,36.276,11.610,0.098,2.528,2.940,10.617,4.197,86.615,27.643,4.170,4.368
 2975.409,121.095,1049.805,113.536,-109.958,37.016,11.446,0.099,2.523,3.009,10.955,4.184,86.625,27.650,4.094,4.327
 2975.909,121.205,1049.805,116.589,-109.763,37.925,11.329,0.107,2.517,2.974,11.282,4.154,86.650,27.668,4.053,4.324
 2976.409,121.160,1049.805,117.759,-109.365,39.287,11.308,0.106,2.497,2.943,12.449,4.135,86.752,27.740,4.056,4.326
 2976.909,121.251,1049.805,114.321,-109.035,39.779,11.210,0.093,2.467,2.921,14.201,4.141,86.912,27.853,4.095,4.314
 2977.409,121.189,1044.922,111.211,-107.523,39.047,10.917,0.078,2.428,2.923,16.467,4.201,86.948,27.879,4.158,4.304
 2977.909,121.191,1041.650,113.018,-106.299,38.524,10.732,0.069,2.410,2.871,17.519,4.397,86.592,27.627,4.218,4.329
 2978.409,121.078,1044.922,118.707,-104.224,38.779,10.717,0.057,2.428,2.855,16.507,4.707,85.577,26.910,4.256,4.351
 2978.909,121.141,1055.322,121.264,-104.650,38.464,10.685,0.048,2.478,2.931,13.590,4.959,84.028,25.815,4.275,4.363
 2979.409,121.160,1054.688,119.646,-105.295,35.973,10.669,0.053,2.527,2.996,10.706,4.970,82.727,24.896,4.281,4.366
 2979.909,121.182,1054.688,117.414,-105.772,31.903,10.953,0.077,2.544,2.996,9.706,4.731,82.564,24.780,4.284,4.384
 2980.409,121.105,1046.973,116.961,-105.969,29.000,11.476,0.113,2.533,2.930,10.331,4.406,83.910,25.732,4.304,4.453
 2980.909,121.114,1040.039,119.816,-105.782,28.910,11.562,0.140,2.497,2.872,12.430,4.144,85.916,27.149,4.283,4.486
 2981.409,121.248,1044.873,119.543,-105.532,32.078,11.422,0.146,2.457,2.887,14.821,3.988,87.516,28.280,4.250,4.481
 2981.909,121.227,1063.086,116.641,-105.030,36.443,11.791,0.144,2.452,2.996,15.111,3.919,88.391,28.898,4.159,4.418
 2982.409,121.294,1060.742,119.643,-103.650,39.142,12.098,0.136,2.495,3.082,12.556,3.977,88.444,28.936,4.047,4.297
 2982.909,121.239,1045.801,126.254,-102.371,39.605,11.977,0.120,2.542,3.142,9.817,4.111,87.930,28.572,3.957,4.197
 2983.409,121.263,1051.221,128.377,-101.946,37.763,11.657,0.118,2.564,3.132,8.516,4.198,87.238,28.084,3.908,4.113
 2983.909,121.258,1068.848,121.100,-102.782,36.037,11.480,0.126,2.555,3.064,9.046,4.201,86.766,27.750,3.908,4.093
 2984.409,121.222,1054.688,111.116,-104.232,36.521,11.709,0.140,2.524,3.076,10.881,4.116,86.853,27.811,3.952,4.140
 2984.909,121.256,1049.805,109.105,-104.922,38.215,11.740,0.151,2.480,3.078,13.443,4.042,87.315,28.138,3.979,4.171
 2985.409,121.280,1057.275,114.645,-104.939,39.386,11.448,0.140,2.429,3.008,16.439,4.073,87.392,28.192,3.973,4.181
 2985.909,121.254,1058.838,121.523,-104.683,39.187,11.469,0.125,2.405,3.069,17.822,4.145,87.098,27.985,3.926,4.142
 2986.409,121.180,1047.705,122.524,-104.350,38.921,11.476,0.122,2.419,3.127,17.030,4.174,87.025,27.933,3.852,4.082
 2986.909,121.235,1050.293,121.100,-104.288,39.832,11.600,0.129,2.446,3.107,15.455,4.141,87.559,28.311,3.804,4.054
 2987.409,121.190,1054.688,118.201,-104.312,41.354,11.733,0.139,2.471,3.009,13.957,4.082,88.358,28.875,3.805,4.075
 2987.909,121.331,1054.688,116.288,-103.970,41.998,11.483,0.145,2.498,2.917,12.403,4.043,88.548,29.009,3.841,4.116
 2988.409,121.257,1057.959,118.844,-103.198,41.427,11.406,0.134,2.499,2.966,12.329,4.035,88.236,28.789,3.912,4.161
 2988.909,121.287,1059.570,122.825,-102.315,41.287,11.375,0.113,2.460,3.026,14.630,4.071,87.927,28.571,3.993,4.203
 2989.409,121.210,1056.055,125.340,-101.234,41.360,11.105,0.095,2.430,2.985,16.383,4.247,87.498,28.267,4.065,4.236
 2989.909,121.317,1046.094,122.045,-100.533,40.373,10.868,0.072,2.448,2.951,15.325,4.580,86.645,27.664,4.153,4.316
 2990.409,121.389,1049.805,114.079,-99.508,37.311,10.739,0.052,2.518,2.987,11.218,4.940,84.999,26.501,4.256,4.401
 2990.909,121.219,1048.389,109.952,-98.447,32.583,10.676,0.031,2.577,3.042,7.761,5.162,83.151,25.195,4.415,4.518
 2991.409,121.164,1044.922,118.486,-97.990,28.681,10.693,0.021,2.589,3.092,7.082,5.191,81.887,24.302,4.601,4.622
 2991.909,121.330,1054.590,129.138,-98.542,27.338,10.728,0.040,2.593,3.057,6.849,5.109,81.388,23.949,4.771,4.681
 2992.409,121.267,1057.520,132.423,-99.515,28.224,10.722,0.068,2.604,3.034,6.199,5.047,81.361,23.930,4.845,4.734
 2992.909,121.318,1059.570,126.376,-100.855,29.987,10.697,0.077,2.603,3.123,6.230,5.039,81.134,23.770,4.798,4.767
 2993.409,121.303,1050.684,118.856,-101.895,30.991,10.656,0.069,2.565,3.242,8.461,4.983,81.127,23.764,4.668,4.770
 2993.909,121.228,1049.805,114.714,-103.165,30.627,10.653,0.079,2.485,3.258,13.141,4.727,82.488,24.727,4.508,4.724
 2994.409,121.292,1063.867,111.541,-104.430,30.296,10.976,0.122,2.406,3.128,17.765,4.335,85.236,26.669,4.374,4.625
 2994.909,121.413,1054.688,111.231,-105.709,32.444,11.570,0.176,2.364,3.032,20.221,3.982,88.901,29.259,4.272,4.562
 2995.409,121.330,1054.639,113.136,-106.612,37.280,11.817,0.206,2.356,3.041,20.723,3.808,91.919,31.391,4.151,4.443
 2995.909,121.332,1060.156,118.742,-106.854,41.975,11.991,0.202,2.372,3.160,19.744,3.827,92.922,32.100,4.006,4.320
 2996.409,121.353,1068.848,123.550,-106.313,43.919,12.253,0.194,2.401,3.252,18.068,3.881,92.320,31.675,3.872,4.165
 2996.909,121.429,1059.570,127.232,-105.749,42.211,12.192,0.184,2.433,3.190,16.227,3.926,90.478,30.373,3.770,4.024
 2997.409,121.235,1061.035,127.949,-104.765,38.823,12.127,0.161,2.458,3.120,14.736,3.959,88.934,29.282,3.729,3.922
 2997.909,121.286,1068.066,127.828,-103.957,35.666,12.110,0.131,2.481,3.053,13.370,3.979,88.169,28.741,3.707,3.840
 2998.409,121.317,1054.688,127.508,-102.969,33.739,11.969,0.109,2.503,3.031,12.109,3.975,87.965,28.597,3.685,3.797
 2998.909,121.373,1051.416,128.241,-102.451,34.530,11.850,0.103,2.520,3.035,11.082,3.930,88.447,28.938,3.663,3.803
 2999.409,121.360,1059.570,129.151,-102.266,38.154,11.703,0.105,2.532,3.073,10.410,3.851,89.275,29.523,3.633,3.829
 2999.909,121.298,1056.055,125.204,-102.430,42.116,11.689,0.103,2.527,3.219,10.677,3.771,90.018,30.048,3.631,3.872
 3000.409,121.346,1060.791,124.567,-103.393,44.475,11.820,0.100,2.508,3.355,11.811,3.719,90.749,30.565,3.660,3.917
 3000.909,121.338,1064.453,123.699,-104.306,45.315,11.902,0.097,2.488,3.338,12.990,3.745,91.310,30.961,3.704,3.947
 3001.409,121.311,1056.738,122.444,-104.690,46.007,12.088,0.092,2.489,3.229,12.920,3.891,91.122,30.828,3.767,3.982
 3001.909,121.438,1053.809,122.958,-104.110,46.244,11.894,0.087,2.514,3.133,11.479,4.121,89.878,29.949,3.822,4.007
 3002.409,121.359,1056.348,120.524,-102.716,44.507,11.437,0.083,2.545,3.132,9.659,4.344,87.795,28.477,3.878,4.026
 3002.909,121.472,1055.322,121.467,-101.930,41.746,11.321,0.087,2.562,3.171,8.626,4.474,85.985,27.198,3.936,4.070
 3003.409,121.399,1058.496,120.500,-101.858,38.914,11.290,0.098,2.557,3.141,8.973,4.466,85.327,26.733,3.991,4.109
 3003.909,121.269,1064.453,118.673,-102.844,36.541,11.304,0.109,2.536,3.103,10.178,4.370,85.756,27.036,4.038,4.163
 3004.409,121.321,1059.570,122.093,-103.478,34.741,11.343,0.123,2.519,3.067,11.142,4.224,87.151,28.022,4.075,4.206
 3004.909,121.376,1059.570,125.651,-103.559,33.416,11.436,0.132,2.514,3.046,11.452,4.104,88.569,29.024,4.074,4.227
 3005.409,121.307,1049.805,128.385,-103.345,34.396,11.627,0.120,2.510,3.020,11.700,4.092,89.176,29.453,4.064,4.239
 3005.909,121.397,1059.619,127.632,-102.867,36.736,11.712,0.102,2.518,3.025,11.216,4.169,89.041,29.358,4.031,4.224
 3006.409,121.502,1061.865,119.912,-102.293,37.868,11.578,0.090,2.533,3.032,10.340,4.300,88.228,28.783,4.015,4.191
 3006.909,121.397,1059.570,114.318,-101.479,37.421,11.437,0.090,2.545,3.063,9.631,4.419,87.353,28.165,4.031,4.175
 3007.409,121.459,1059.570,115.606,-100.284,35.733,11.369,0.104,2.558,3.088,8.896,4.476,86.735,27.728,4.076,4.173
 3007.909,121.362,1058.496,122.314,-99.705,34.627,11.365,0.116,2.562,3.079,8.655,4.499,86.361,27.464,4.138,4.193
 3008.409,121.544,1052.881,130.674,-100.077,35.074,11.381,0.117,2.561,3.049,8.726,4.504,86.273,27.401,4.179,4.224
 3008.909,121.295,1044.922,131.485,-100.904,35.964,11.376,0.106,2.558,2.993,8.896,4.514,86.189,27.342,4.180,4.236
 3009.409,121.473,1061.523,126.502,-101.947,36.713,11.387,0.087,2.551,2.962,9.327,4.506,86.158,27.320,4.137,4.223
 3009.909,121.373,1071.289,122.833,-102.220,37.107,11.384,0.076,2.543,2.990,9.759,4.421,86.490,27.555,4.072,4.162
 3010.409,121.342,1059.570,121.962,-101.545,37.413,11.445,0.085,2.544,3.036,9.719,4.255,87.407,28.203,3.995,4.071
 3010.909,121.365,1049.805,124.627,-100.856,37.797,11.646,0.101,2.538,3.049,10.055,4.063,88.795,29.184,3.914,3.980
 3011.409,121.504,1064.453,126.727,-100.699,38.718,11.772,0.116,2.533,3.075,10.351,3.898,90.130,30.127,3.823,3.896
 3011.909,121.423,1083.008,126.872,-101.282,40.602,11.733,0.125,2.533,3.120,10.352,3.785,90.889,30.664,3.713,3.809
 3012.409,121.434,1061.328,127.683,-101.240,43.007,11.786,0.129,2.530,3.145,10.516,3.708,91.267,30.931,3.600,3.721
 3012.909,121.457,1064.453,130.200,-100.863,46.034,11.822,0.129,2.525,3.142,10.834,3.657,91.806,31.312,3.499,3.640
 3013.409,121.481,1068.701,131.335,-100.258,47.672,11.725,0.124,2.519,3.150,11.160,3.624,92.609,31.879,3.419,3.574
 3013.909,121.524,1064.453,131.369,-100.397,46.450,11.757,0.114,2.513,3.184,11.495,3.605,93.299,32.367,3.369,3.530
 3014.409,121.526,1059.961,134.323,-100.471,44.040,11.857,0.107,2.507,3.185,11.899,3.599,93.643,32.610,3.333,3.504
 3014.909,121.413,1044.922,136.203,-100.844,42.130,11.848,0.106,2.499,3.124,12.343,3.608,93.490,32.502,3.312,3.498
 3015.409,121.453,1063.867,138.444,-100.852,41.502,11.862,0.105,2.487,3.058,13.049,3.623,93.161,32.269,3.297,3.514
 3015.909,121.448,1064.551,135.102,-100.830,41.087,11.964,0.107,2.472,3.137,13.896,3.640,92.988,32.147,3.288,3.537
 3016.409,121.518,1059.619,130.909,-100.825,40.158,11.936,0.113,2.453,3.231,15.055,3.650,93.214,32.307,3.289,3.556
 3016.909,121.458,1059.180,130.137,-101.626,39.517,11.809,0.127,2.430,3.269,16.347,3.620,93.904,32.795,3.276,3.537
 3017.409,121.428,1054.688,128.825,-102.739,40.062,11.830,0.146,2.412,3.281,17.407,3.550,94.641,33.315,3.248,3.482
 3017.909,121.332,1057.568,128.741,-103.538,41.540,11.980,0.160,2.400,3.207,18.117,3.456,95.154,33.678,3.162,3.405
 3018.409,121.448,1079.102,129.985,-103.487,42.844,12.223,0.168,2.385,3.177,19.007,3.367,95.134,33.664,3.058,3.342
 3018.909,121.514,1069.873,132.338,-102.958,43.936,12.264,0.174,2.359,3.115,20.502,3.295,94.765,33.403,2.986,3.359
 3019.409,121.442,1053.906,133.520,-102.891,45.538,11.944,0.178,2.324,3.012,22.555,3.228,94.561,33.259,2.977,3.439
 3019.909,121.526,1049.805,128.991,-103.289,49.123,11.687,0.172,2.244,2.879,27.273,3.189,94.586,33.276,3.104,3.624
 3020.409,121.464,1049.805,119.611,-104.299,55.672,11.684,0.159,2.173,2.713,31.383,3.375,93.184,32.285,3.335,3.890
 3020.909,121.572,1064.063,106.499,-105.713,61.318,11.698,0.131,2.208,2.885,29.360,4.676,88.038,28.648,3.688,4.208
 3021.409,121.390,1070.557,86.092,-107.521,58.647,11.261,0.091,2.361,3.614,20.429,8.337,78.362,21.810,4.135,4.595
 3021.909,121.511,1074.219,62.356,-109.340,45.169,10.310,0.055,2.574,4.541,7.954,13.574,66.183,13.203,4.667,4.968
 3022.409,121.477,1074.219,43.699,-110.962,26.715,9.784,0.032,2.709,5.107,0.034,17.593,57.031,6.736,5.417,5.493
 3022.909,121.529,1058.008,35.422,-112.148,12.336,9.785,0.024,2.738,5.070,-1.662,18.697,53.148,3.992,6.440,6.227
 3023.409,121.465,1074.219,40.165,-112.746,6.667,9.786,0.022,2.712,4.689,-0.108,16.586,54.137,4.691,7.681,7.093
 3023.909,121.529,1069.971,53.942,-112.496,6.061,9.808,0.018,2.671,4.182,2.262,13.419,57.787,7.270,8.737,7.992
 3024.409,121.622,1060.547,71.223,-112.367,7.825,9.862,0.022,2.645,3.593,3.805,10.608,62.494,10.596,8.830,8.258
 3024.909,121.563,1069.336,87.751,-113.303,10.634,9.908,0.027,2.631,3.016,4.613,8.486,67.061,13.824,8.191,8.039
 3025.409,121.575,1066.650,96.671,-115.291,13.740,9.902,0.027,2.622,2.695,5.145,7.439,70.417,16.196,7.344,7.408
 3025.909,121.595,1069.336,101.698,-117.205,16.473,9.873,0.029,2.617,2.630,5.421,6.943,72.555,17.707,6.657,6.671
 3026.409,121.550,1069.434,101.996,-118.055,18.104,9.851,0.036,2.613,2.620,5.655,6.866,73.517,18.386,6.242,6.121
 3026.909,121.603,1069.336,96.745,-118.480,18.380,9.808,0.040,2.603,2.576,6.287,7.108,73.747,18.549,5.928,5.692
 3027.409,121.494,1071.973,89.768,-118.157,17.200,9.749,0.038,2.589,2.514,7.094,7.370,73.537,18.401,5.673,5.401
 3027.909,121.502,1068.994,87.860,-117.730,15.473,9.741,0.041,2.583,2.513,7.433,7.232,73.525,18.392,5.433,5.174
 3028.409,121.600,1064.453,97.451,-117.452,14.762,9.837,0.059,2.598,2.533,6.577,6.543,74.292,18.934,5.231,5.001
 3028.909,121.682,1063.916,107.708,-117.834,15.988,9.966,0.073,2.618,2.548,5.389,5.689,75.463,19.762,5.054,4.888
 3029.409,121.495,1053.320,112.937,-118.300,18.561,10.067,0.063,2.614,2.546,5.596,5.126,76.293,20.349,4.890,4.800
 3029.909,121.570,1051.367,115.351,-118.533,20.875,10.141,0.042,2.601,2.598,6.373,4.904,76.412,20.433,4.746,4.725
 3030.409,121.645,1069.678,118.836,-119.140,22.088,10.174,0.030,2.594,2.647,6.794,4.809,76.069,20.190,4.626,4.639
 3030.909,121.635,1064.453,121.951,-119.863,22.412,10.179,0.031,2.600,2.646,6.425,4.775,75.702,19.931,4.533,4.533
 3031.409,121.624,1068.018,121.279,-120.199,22.496,10.177,0.033,2.605,2.647,6.131,4.817,75.485,19.778,4.444,4.393
 3031.909,121.632,1066.797,117.532,-119.651,22.451,10.175,0.026,2.598,2.718,6.543,4.971,75.143,19.536,4.332,4.203
 3032.409,121.665,1059.570,114.135,-119.598,22.046,10.176,0.016,2.591,2.921,6.933,5.152,74.640,19.180,4.177,4.003
 3032.909,121.706,1056.201,104.879,-122.058,21.371,10.180,0.016,2.588,3.051,7.131,5.162,74.277,18.924,3.989,3.815
 3033.409,121.611,1059.570,94.810,-126.246,20.925,10.197,0.029,2.585,2.998,7.304,4.872,74.344,18.971,3.799,3.664
 3033.909,121.437,1066.162,88.611,-130.892,20.864,10.230,0.043,2.570,2.706,8.213,4.378,74.903,19.366,3.620,3.530
 3034.409,121.728,1060.742,88.209,-133.728,20.834,10.266,0.049,2.551,2.403,9.321,3.970,75.574,19.840,3.457,3.392
 3034.909,121.607,1061.523,93.964,-134.726,20.705,10.298,0.045,2.545,2.365,9.642,3.788,75.908,20.076,3.309,3.257
 3035.409,121.647,1064.453,97.458,-135.048,20.772,10.319,0.034,2.541,2.459,9.902,3.761,75.898,20.069,3.172,3.127
 3035.909,121.699,1064.453,98.174,-135.584,21.100,10.323,0.024,2.533,2.507,10.325,3.777,75.766,19.976,3.069,3.035
 3036.409,121.620,1069.189,98.539,-136.350,21.315,10.318,0.021,2.531,2.491,10.443,3.754,75.774,19.982,3.000,2.975
 3036.909,121.664,1066.895,97.554,-136.698,21.314,10.304,0.022,2.538,2.413,10.066,3.705,75.995,20.138,2.981,2.952
 3037.409,121.740,1069.238,98.521,-136.106,21.346,10.289,0.021,2.549,2.382,9.408,3.644,76.227,20.302,3.001,2.960
 3037.909,121.706,1061.768,100.816,-135.540,21.822,10.224,0.015,2.546,2.561,9.606,3.711,76.266,20.330,3.052,2.984
 3038.409,121.740,1059.570,100.463,-136.146,22.393,10.140,0.013,2.529,2.679,10.602,4.106,75.827,20.019,3.104,3.005
 3038.909,121.560,1062.451,98.807,-135.993,21.923,10.113,0.016,2.518,2.675,11.209,4.808,74.610,19.159,3.137,3.003
 3039.409,121.665,1068.164,93.216,-135.850,20.092,10.116,0.020,2.521,2.624,11.076,5.331,72.963,17.995,3.143,2.983
 3039.909,121.683,1059.570,86.744,-135.034,17.412,10.155,0.029,2.544,2.636,9.723,5.239,71.738,17.129,3.129,2.967
 3040.409,121.630,1069.336,85.363,-134.709,15.625,10.235,0.042,2.572,2.728,8.090,4.669,71.747,17.136,3.113,2.965
 3040.909,121.669,1069.336,90.784,-134.824,16.086,10.323,0.052,2.584,2.694,7.398,4.043,73.014,18.031,3.093,2.960
 3041.409,121.638,1055.713,99.889,-135.354,17.618,10.405,0.054,2.581,2.567,7.560,3.691,74.717,19.235,3.055,2.928
 3041.909,121.581,1070.410,108.578,-135.870,18.795,10.470,0.046,2.565,2.454,8.492,3.588,76.032,20.164,2.985,2.856
 3042.409,121.660,1072.949,110.477,-137.033,19.405,10.506,0.041,2.550,2.449,9.356,3.616,76.533,20.518,2.884,2.762
 3042.909,121.741,1069.336,103.994,-138.318,20.055,10.530,0.042,2.538,2.474,10.076,3.702,76.578,20.550,2.782,2.675
 3043.409,121.621,1069.336,93.977,-139.718,20.589,10.556,0.044,2.527,2.459,10.687,3.728,76.639,20.593,2.700,2.611
 3043.909,121.700,1077.441,85.485,-140.681,20.518,10.590,0.044,2.520,2.453,11.087,3.646,76.882,20.765,2.654,2.581
 3044.409,121.709,1059.570,82.705,-141.632,20.016,10.624,0.043,2.518,2.471,11.232,3.479,77.236,21.015,2.641,2.583
 3044.909,121.868,1059.570,83.223,-141.827,19.594,10.645,0.041,2.519,2.505,11.152,3.348,77.521,21.216,2.646,2.601
 3045.409,121.710,1068.457,85.157,-141.150,19.792,10.652,0.038,2.521,2.499,11.042,3.305,77.622,21.288,2.658,2.618
 3045.909,121.820,1069.678,89.538,-139.815,20.414,10.652,0.034,2.526,2.483,10.786,3.304,77.462,21.174,2.665,2.614
 3046.409,121.710,1067.139,90.885,-138.419,20.999,10.652,0.029,2.529,2.503,10.568,3.329,76.909,20.783,2.659,2.592
 3046.909,121.743,1064.453,88.794,-138.188,21.431,10.652,0.026,2.531,2.504,10.458,3.370,76.203,20.285,2.643,2.559
 3047.409,121.775,1059.570,86.412,-138.714,21.522,10.652,0.027,2.528,2.492,10.652,3.459,75.742,19.959,2.613,2.518
 3047.909,121.723,1060.010,87.217,-139.580,21.511,10.652,0.027,2.514,2.457,11.483,3.589,75.756,19.969,2.572,2.475
 3048.409,121.743,1074.219,88.414,-140.124,21.589,10.652,0.025,2.495,2.454,12.588,3.677,76.341,20.382,2.528,2.434
 3048.909,121.703,1078.760,90.221,-140.497,21.225,10.653,0.024,2.483,2.456,13.298,3.654,77.203,20.992,2.485,2.402
 3049.409,121.756,1071.289,91.094,-141.495,20.232,10.653,0.023,2.486,2.482,13.096,3.556,81.420,23.972,2.458,2.391
 3049.909,121.756,1069.336,90.636,-142.047,19.246,10.652,0.024,2.503,2.525,12.096,3.459,88.809,29.194,2.448,2.400
 3050.409,121.767,1072.510,91.206,-142.026,19.141,10.651,0.026,2.520,2.512,11.111,3.421,96.617,34.712,2.459,2.419
 3050.909,121.726,1069.336,87.278,-140.527,20.048,10.645,0.027,2.527,2.441,10.726,3.443,101.934,38.469,2.480,2.442
 3051.409,121.709,1072.705,86.381,-139.236,21.098,10.635,0.026,2.520,2.340,11.095,3.470,103.116,39.305,2.499,2.453
 3051.909,121.835,1072.070,87.523,-138.716,21.755,10.628,0.020,2.508,2.323,11.833,3.471,103.474,39.557,2.513,2.459
 3052.409,121.678,1064.453,91.266,-139.685,21.906,10.626,0.014,2.498,2.375,12.394,3.424,109.221,43.619,2.511,2.459
 3052.909,121.787,1069.336,97.628,-141.037,21.547,10.630,0.016,2.494,2.424,12.621,3.386,120.459,51.561,2.510,2.458
 3053.409,121.644,1065.479,101.271,-142.014,20.933,10.635,0.025,2.497,2.437,12.469,3.352,132.502,60.072,2.501,2.462
 3053.909,121.830,1067.480,104.225,-142.380,20.098,10.637,0.033,2.501,2.417,12.241,3.321,140.339,65.611,2.495,2.467
 3054.409,121.884,1074.219,101.467,-142.330,19.501,10.637,0.032,2.499,2.412,12.348,3.282,142.283,66.984,2.495,2.484
 3054.909,121.797,1074.219,98.186,-141.802,19.692,10.635,0.027,2.496,2.430,12.499,3.244,142.429,67.088,2.502,2.500
 3055.409,121.873,1069.873,94.620,-140.849,20.126,10.634,0.024,2.494,2.425,12.625,3.269,142.326,67.015,2.519,2.514
 3055.909,121.751,1079.102,92.251,-139.466,20.170,10.633,0.021,2.494,2.408,12.605,3.291,140.995,66.074,2.535,2.514
 3056.409,121.859,1074.561,95.218,-138.439,19.727,10.632,0.020,2.503,2.432,12.088,3.283,134.461,61.457,2.545,2.496
 3056.909,121.902,1066.309,98.083,-138.277,19.376,10.632,0.019,2.512,2.519,11.608,3.251,122.796,53.213,2.537,2.468
 3057.409,121.840,1074.219,98.644,-139.426,19.823,10.632,0.019,2.513,2.585,11.515,3.273,111.391,45.153,2.511,2.429
 3057.909,121.761,1076.611,94.989,-141.320,20.582,10.632,0.022,2.503,2.504,12.082,3.390,105.362,40.892,2.464,2.387
 3058.409,121.907,1079.102,89.678,-143.650,20.657,10.633,0.025,2.486,2.393,13.121,3.488,107.264,42.236,2.417,2.347
 3058.909,121.758,1071.045,85.396,-144.659,19.988,10.633,0.031,2.481,2.365,13.379,3.485,115.184,47.833,2.375,2.319
 3059.409,121.773,1060.352,83.000,-144.969,19.274,10.634,0.039,2.490,2.384,12.851,3.417,119.743,51.055,2.350,2.307
 3059.909,121.880,1069.336,81.685,-144.538,19.205,10.635,0.043,2.499,2.407,12.353,3.372,116.846,49.008,2.343,2.311
 3060.409,121.816,1083.350,83.526,-143.917,19.417,10.638,0.044,2.501,2.405,12.242,3.368,105.904,41.275,2.350,2.323
 3060.909,121.838,1079.102,87.010,-142.825,19.474,10.640,0.040,2.498,2.416,12.383,3.333,93.488,32.500,2.368,2.338
 3061.409,121.812,1083.154,89.904,-141.747,19.925,10.640,0.034,2.500,2.447,12.306,3.237,89.538,29.709,2.389,2.358
 3061.909,121.750,1079.102,90.558,-141.528,20.807,10.639,0.030,2.508,2.475,11.805,3.142,95.704,34.066,2.410,2.384
 3062.409,121.808,1076.953,90.385,-141.386,21.641,10.636,0.029,2.512,2.471,11.550,3.122,108.024,42.773,2.429,2.411
 3062.909,121.895,1072.998,87.987,-141.409,21.874,10.633,0.029,2.510,2.454,11.675,3.173,120.217,51.390,2.444,2.434
 3063.409,121.773,1074.219,87.435,-140.820,21.338,10.625,0.026,2.501,2.432,12.216,3.242,124.070,54.113,2.454,2.453
 3063.909,121.770,1081.934,91.171,-140.188,20.738,10.614,0.019,2.488,2.388,12.979,3.281,118.629,50.268,2.466,2.468
 3064.409,121.775,1077.539,94.489,-139.473,20.302,10.611,0.016,2.487,2.325,13.056,3.274,111.337,45.114,2.480,2.482
 3064.909,121.830,1074.219,95.669,-138.924,19.922,10.611,0.016,2.492,2.250,12.724,3.260,109.128,43.553,2.496,2.488
 3065.409,121.915,1072.412,93.917,-139.248,19.687,10.609,0.014,2.495,2.226,12.594,3.222,114.327,47.228,2.508,2.483
 3065.909,121.858,1064.990,94.467,-140.364,19.717,10.602,0.012,2.494,2.280,12.659,3.158,123.245,53.530,2.506,2.466
 3066.409,121.829,1070.459,94.731,-141.428,20.199,10.585,0.013,2.492,2.329,12.728,3.112,130.632,58.750,2.487,2.443
 3066.909,121.914,1079.102,93.511,-141.887,20.568,10.564,0.015,2.489,2.348,12.944,3.131,131.709,59.512,2.458,2.421
 3067.409,121.874,1079.102,94.205,-141.882,20.600,10.552,0.017,2.480,2.311,13.452,3.244,126.019,55.491,2.429,2.403
 3067.909,121.943,1069.434,95.043,-142.171,20.679,10.536,0.015,2.467,2.237,14.190,3.375,118.373,50.087,2.412,2.392
 3068.409,121.819,1074.219,94.103,-142.541,20.868,10.521,0.016,2.466,2.189,14.274,3.429,113.502,46.645,2.410,2.390
 3068.909,121.979,1074.512,90.862,-142.330,20.873,10.517,0.023,2.482,2.219,13.311,3.433,113.076,46.343,2.419,2.393
 3069.409,121.851,1081.250,87.987,-141.406,20.376,10.517,0.028,2.501,2.301,12.199,3.427,112.372,45.846,2.435,2.404
 3069.909,121.887,1079.102,92.069,-139.981,19.853,10.514,0.029,2.514,2.385,11.449,3.404,107.573,42.455,2.456,2.421
 3070.409,121.967,1082.080,99.235,-139.040,19.483,10.509,0.024,2.513,2.470,11.504,3.336,99.144,36.498,2.481,2.452
 3070.909,121.869,1069.336,101.655,-138.531,19.375,10.503,0.024,2.515,2.495,11.386,3.235,90.506,30.393,2.512,2.495
 3071.409,121.943,1072.510,100.045,-138.563,19.576,10.494,0.027,2.523,2.449,10.936,3.140,84.324,26.024,2.543,2.538
 3071.909,121.915,1081.738,95.130,-138.681,19.894,10.481,0.028,2.525,2.348,10.790,3.099,81.502,24.029,2.572,2.576
 3072.409,122.012,1093.750,91.559,-138.604,20.320,10.470,0.026,2.522,2.251,10.968,3.111,80.170,23.088,2.595,2.599
 3072.909,121.864,1083.984,90.172,-138.538,20.952,10.467,0.022,2.511,2.260,11.642,3.148,78.244,21.727,2.610,2.604
 3073.409,121.878,1080.322,90.395,-139.185,21.642,10.467,0.024,2.509,2.329,11.755,3.173,76.577,20.549,2.618,2.588
 3073.909,121.806,1079.102,92.183,-139.880,22.148,10.467,0.026,2.513,2.434,11.524,3.150,75.611,19.866,2.612,2.552
 3074.409,121.826,1075.195,95.769,-140.615,22.207,10.466,0.026,2.515,2.551,11.389,3.095,75.456,19.757,2.585,2.498
 3074.909,121.920,1083.984,99.864,-140.916,21.947,10.465,0.026,2.511,2.622,11.641,3.082,75.618,19.872,2.537,2.435
 3075.409,121.978,1092.285,97.230,-141.211,21.696,10.464,0.024,2.498,2.597,12.404,3.128,75.950,20.106,2.474,2.370
 3075.909,121.991,1082.178,89.852,-141.654,21.232,10.462,0.024,2.490,2.487,12.879,3.168,76.561,20.538,2.410,2.310
 3076.409,122.095,1079.102,83.333,-142.736,20.654,10.457,0.024,2.482,2.346,13.315,3.168,77.292,21.055,2.355,2.258
 3076.909,122.076,1079.883,82.095,-143.804,20.337,10.453,0.022,2.476,2.294,13.702,3.129,77.776,21.396,2.310,2.212
 3077.409,121.932,1074.219,85.703,-144.791,20.537,10.451,0.023,2.479,2.356,13.483,3.129,77.937,21.510,2.275,2.169
 3077.909,121.951,1081.104,86.438,-145.310,20.735,10.444,0.026,2.492,2.395,12.741,3.163,77.710,21.350,2.245,2.133
 3078.409,121.873,1088.867,86.369,-144.978,20.248,10.431,0.027,2.503,2.397,12.107,3.155,77.229,21.010,2.222,2.101
 3078.909,122.074,1088.867,87.278,-144.546,19.157,10.420,0.024,2.501,2.355,12.218,3.094,76.746,20.669,2.205,2.075
 3079.409,121.969,1078.906,86.445,-144.698,18.635,10.411,0.019,2.487,2.303,13.040,3.039,76.548,20.528,2.190,2.050
 3079.909,121.980,1074.219,83.098,-145.252,19.406,10.404,0.021,2.482,2.258,13.307,3.060,77.122,20.934,2.169,2.016
 3080.409,121.912,1079.541,78.239,-145.403,20.441,10.398,0.029,2.489,2.245,12.914,3.154,78.835,22.145,2.142,1.972
 3080.909,121.967,1083.984,77.106,-145.616,20.984,10.380,0.034,2.491,2.286,12.823,3.276,80.517,23.333,2.106,1.923
 3081.409,121.946,1083.984,81.475,-145.946,20.980,10.354,0.033,2.485,2.352,13.174,3.333,81.196,23.814,2.067,1.875
 3081.909,121.941,1080.762,84.498,-147.636,20.794,10.336,0.030,2.476,2.377,13.708,3.324,80.673,23.444,2.033,1.836
 3082.409,122.009,1074.219,83.054,-149.474,20.584,10.300,0.029,2.474,2.370,13.791,3.308,79.711,22.764,2.006,1.807
 3082.909,122.157,1081.152,79.952,-150.671,20.164,10.269,0.029,2.475,2.299,13.749,3.344,79.604,22.688,1.986,1.784
 3083.409,121.898,1079.102,78.049,-151.278,19.859,10.264,0.027,2.467,2.218,14.194,3.422,80.400,23.251,1.967,1.762
 3083.909,122.075,1079.102,78.974,-151.480,19.741,10.255,0.023,2.456,2.163,14.881,3.482,80.942,23.634,1.945,1.738
 3084.409,121.885,1083.984,76.489,-151.680,19.471,10.250,0.021,2.447,2.146,15.372,3.477,80.757,23.503,1.919,1.714
 3084.909,122.019,1083.984,72.380,-152.300,19.034,10.276,0.020,2.445,2.152,15.518,3.433,80.021,22.983,1.893,1.695
 3085.409,122.049,1083.984,72.120,-152.862,18.966,10.312,0.017,2.443,2.166,15.619,3.400,79.372,22.525,1.872,1.684
 3085.909,121.989,1083.984,75.827,-152.652,19.611,10.310,0.012,2.441,2.200,15.731,3.370,79.515,22.626,1.858,1.678
 3086.409,121.967,1083.984,78.146,-152.236,20.659,10.291,0.008,2.436,2.234,16.024,3.336,79.609,22.692,1.851,1.674
 3086.909,122.182,1088.379,78.112,-151.810,21.364,10.280,0.010,2.441,2.280,15.757,3.284,79.352,22.510,1.845,1.670
 3087.409,122.116,1093.750,78.355,-151.890,21.452,10.274,0.019,2.459,2.312,14.665,3.294,78.961,22.234,1.842,1.664
 3087.909,122.180,1084.473,76.438,-151.992,21.369,10.245,0.028,2.474,2.353,13.799,3.383,78.663,22.023,1.840,1.660
 3088.409,122.114,1083.984,73.448,-152.126,20.958,10.205,0.031,2.476,2.324,13.687,3.475,78.495,21.904,1.842,1.656
 3088.909,122.134,1083.984,70.162,-151.783,20.121,10.182,0.030,2.470,2.259,14.055,3.503,79.108,22.338,1.846,1.655
 3089.409,122.086,1079.297,70.385,-152.018,19.268,10.160,0.030,2.469,2.216,14.097,3.475,81.634,24.123,1.851,1.655
 3089.909,122.169,1088.867,73.939,-152.038,18.856,10.138,0.032,2.471,2.174,13.960,3.459,85.871,27.117,1.854,1.657
 3090.409,121.984,1083.301,74.139,-152.410,19.063,10.122,0.034,2.476,2.168,13.690,3.453,91.638,31.193,1.861,1.661
 3090.909,122.238,1093.750,74.184,-152.129,19.396,10.109,0.036,2.483,2.174,13.300,3.427,94.806,33.432,1.870,1.666
 3091.409,122.035,1087.793,79.180,-151.985,19.682,10.075,0.032,2.477,2.173,13.636,3.434,94.310,33.081,1.881,1.668
 3091.909,122.115,1083.301,82.603,-151.994,20.142,10.026,0.024,2.460,2.140,14.647,3.553,94.009,32.869,1.890,1.667
 3092.409,122.050,1079.102,80.351,-152.685,20.616,9.997,0.016,2.433,2.050,16.201,3.739,99.219,36.550,1.898,1.663
 3092.909,122.038,1088.867,76.702,-153.897,20.780,9.986,0.012,2.419,1.975,17.016,3.879,110.604,44.596,1.904,1.661
 3093.409,122.162,1088.867,74.918,-154.673,20.493,9.979,0.014,2.427,1.986,16.575,3.893,122.982,53.344,1.910,1.661
 3093.909,122.009,1087.744,76.831,-154.790,20.053,9.974,0.012,2.432,2.028,16.244,3.853,128.266,57.078,1.915,1.662
 3094.409,122.116,1083.984,80.675,-154.467,19.695,9.974,0.011,2.435,2.045,16.083,3.847,125.306,54.986,1.918,1.663
 3094.909,122.045,1079.102,84.145,-155.220,19.495,9.977,0.012,2.441,2.062,15.753,3.860,119.554,50.922,1.919,1.662
 3095.409,122.001,1079.102,86.788,-156.534,19.374,9.979,0.016,2.448,2.054,15.322,3.844,118.139,49.922,1.920,1.659
 3095.909,122.196,1085.596,86.556,-159.079,19.316,9.975,0.020,2.455,2.077,14.916,3.802,123.523,53.727,1.922,1.655
 3096.409,122.104,1088.867,85.529,-160.005,19.492,9.964,0.020,2.451,2.103,15.133,3.830,128.951,57.563,1.927,1.646
 3096.909,122.083,1082.129,83.850,-159.843,19.947,9.945,0.019,2.443,2.098,15.597,3.964,130.036,58.330,1.937,1.638
 3097.409,122.172,1079.102,82.135,-158.557,20.299,9.912,0.020,2.441,2.104,15.715,4.135,127.357,56.436,1.949,1.630
 3097.909,122.045,1081.885,78.040,-158.372,20.234,9.823,0.021,2.444,2.090,15.537,4.280,125.325,55.000,1.968,1.626
 3098.409,122.103,1083.740,73.989,-159.377,20.127,9.671,0.021,2.445,2.089,15.512,4.403,127.522,56.553,1.991,1.624
 3098.909,122.079,1081.689,69.641,-160.024,20.328,9.552,0.021,2.441,2.085,15.719,4.545,133.313,60.645,2.017,1.620
 3099.409,122.062,1088.867,63.456,-159.637,20.703,9.491,0.023,2.436,2.068,16.049,4.674,136.836,63.135,2.039,1.616
 3099.909,122.197,1079.102,61.698,-158.917,20.667,9.507,0.026,2.426,2.057,16.616,4.737,134.645,61.586,2.052,1.606
 3100.409,122.052,1078.857,64.037,-158.796,20.150,9.514,0.034,2.425,2.075,16.694,4.735,128.932,57.549,2.055,1.595
 3100.909,122.109,1082.568,69.219,-159.928,19.436,9.467,0.044,2.433,2.118,16.183,4.676,125.451,55.089,2.047,1.581
 3101.409,122.185,1087.988,73.125,-160.898,18.740,9.477,0.050,2.446,2.142,15.422,4.596,128.326,57.121,2.033,1.565
 3101.909,122.157,1082.129,73.959,-161.227,18.269,9.508,0.050,2.456,2.106,14.836,4.520,134.940,61.795,2.017,1.548
 3102.409,122.108,1088.867,73.877,-161.253,18.124,9.506,0.043,2.454,2.043,14.999,4.477,139.519,65.031,1.999,1.531
 3102.909,122.205,1088.867,75.132,-161.205,18.325,9.465,0.035,2.444,2.017,15.549,4.495,136.527,62.917,1.982,1.513
 3103.409,122.147,1083.984,78.654,-161.104,18.579,9.392,0.031,2.435,2.036,16.102,4.559,128.287,57.093,1.970,1.498
 3103.909,122.140,1083.984,80.739,-160.615,18.610,9.350,0.031,2.430,2.063,16.375,4.640,122.728,53.164,1.965,1.487
 3104.409,122.175,1080.273,80.853,-160.233,18.541,9.350,0.034,2.437,2.104,15.974,4.716,124.090,54.127,1.968,1.481
 3104.909,122.146,1083.984,78.619,-160.012,18.629,9.347,0.036,2.447,2.189,15.385,4.761,130.019,58.317,1.978,1.479
 3105.409,122.189,1087.451,75.108,-160.207,19.029,9.364,0.036,2.451,2.291,15.134,4.782,134.397,61.411,1.993,1.482
 3105.909,122.212,1083.984,69.938,-160.977,19.339,9.356,0.034,2.439,2.314,15.821,4.794,134.089,61.194,2.010,1.485
 3106.409,122.160,1085.596,63.281,-161.991,19.312,9.233,0.030,2.416,2.217,17.187,4.817,132.053,59.755,2.029,1.491
 3106.909,122.185,1084.668,62.690,-163.563,19.152,9.113,0.028,2.398,2.054,18.255,4.839,131.685,59.495,2.048,1.496
 3107.409,122.255,1088.867,66.683,-163.993,19.360,9.188,0.028,2.389,1.957,18.777,4.846,133.198,60.564,2.066,1.498
 3107.909,122.275,1084.424,69.659,-163.792,20.028,9.220,0.031,2.391,1.957,18.642,4.851,135.518,62.204,2.081,1.498
 3108.409,122.099,1083.984,70.457,-163.791,20.523,9.118,0.033,2.396,1.998,18.356,4.861,135.849,62.438,2.089,1.495
 3108.909,122.258,1083.984,70.878,-163.898,20.415,9.147,0.032,2.401,2.039,18.060,4.887,133.513,60.787,2.095,1.490
 3109.409,122.152,1088.867,74.649,-164.481,19.491,9.201,0.030,2.410,2.028,17.519,4.914,131.226,59.170,2.097,1.483
 3109.909,122.179,1074.219,75.984,-165.170,18.574,9.203,0.026,2.414,1.985,17.332,4.900,129.899,58.233,2.097,1.473
 3110.409,122.245,1079.395,70.779,-166.338,18.337,9.214,0.024,2.409,1.913,17.626,4.836,128.584,57.303,2.095,1.464
 3110.909,122.268,1088.867,63.872,-167.587,18.418,9.187,0.022,2.396,1.870,18.345,4.762,127.403,56.469,2.091,1.456
 3111.409,122.151,1088.867,59.264,-168.651,18.423,9.188,0.021,2.383,1.879,19.100,4.729,124.435,54.371,2.086,1.451
 3111.909,122.269,1084.473,57.250,-169.486,18.204,9.205,0.020,2.380,1.893,19.287,4.733,120.456,51.559,2.084,1.449
 3112.409,122.290,1088.867,58.741,-170.349,18.040,9.179,0.021,2.384,1.899,19.070,4.723,118.187,49.956,2.083,1.449
 3112.909,122.223,1079.834,60.104,-170.314,18.154,9.149,0.024,2.387,1.911,18.874,4.690,116.527,48.783,2.085,1.452
 3113.409,122.325,1083.984,59.363,-169.696,18.265,9.102,0.028,2.394,1.936,18.468,4.692,114.947,47.666,2.087,1.456
 3113.909,122.213,1083.984,60.621,-169.222,18.142,9.075,0.030,2.402,1.959,18.027,4.754,113.471,46.623,2.090,1.462
 3114.409,122.326,1083.984,62.911,-169.084,17.944,9.117,0.029,2.403,1.941,17.935,4.832,110.738,44.691,2.097,1.471
 3114.909,122.236,1093.750,65.965,-168.855,17.780,9.148,0.028,2.404,1.914,17.878,4.914,109.345,43.707,2.108,1.483
 3115.409,122.347,1089.990,71.741,-168.152,17.663,9.125,0.030,2.405,1.927,17.827,5.025,109.184,43.593,2.128,1.498
 3115.909,122.389,1083.984,78.149,-167.516,17.517,9.065,0.033,2.407,1.958,17.718,5.162,108.841,43.351,2.156,1.515
 3116.409,122.406,1083.984,84.306,-167.350,17.414,9.029,0.034,2.406,1.982,17.789,5.296,108.687,43.241,2.188,1.534
 3116.909,122.212,1085.645,85.261,-167.985,17.619,9.037,0.034,2.403,1.976,17.925,5.367,109.750,43.993,2.224,1.554
 3117.409,122.236,1097.266,77.807,-169.417,18.079,9.021,0.034,2.402,1.946,17.983,5.370,112.297,45.793,2.260,1.577
 3117.909,122.262,1096.729,67.113,-170.965,18.370,8.997,0.033,2.402,1.944,18.023,5.313,115.100,47.774,2.296,1.599
 3118.409,122.259,1089.307,58.419,-171.907,18.062,8.990,0.030,2.400,1.956,18.142,5.233,115.673,48.179,2.330,1.619
 3118.909,122.335,1083.984,53.972,-171.770,17.164,8.983,0.029,2.403,1.993,17.968,5.189,114.261,47.181,2.357,1.634
 3119.409,122.267,1088.672,51.524,-170.928,16.149,8.975,0.031,2.410,2.050,17.558,5.206,112.867,46.196,2.374,1.644
 3119.909,122.377,1088.867,51.669,-169.838,15.461,8.985,0.032,2.410,2.060,17.527,5.267,113.019,46.303,2.375,1.646
 3120.409,122.250,1088.867,53.696,-168.936,15.224,9.004,0.033,2.404,2.039,17.872,5.328,114.690,47.484,2.362,1.643
 3120.909,122.333,1091.455,60.972,-167.664,15.168,9.010,0.034,2.402,2.006,17.993,5.342,116.737,48.931,2.340,1.638
 3121.409,122.214,1093.018,71.514,-166.823,15.185,9.008,0.034,2.406,1.995,17.762,5.322,118.734,50.342,2.318,1.633
 3121.909,122.380,1079.102,78.135,-166.804,15.463,9.006,0.035,2.414,2.034,17.293,5.304,120.812,51.810,2.302,1.631
 3122.409,122.173,1088.867,79.149,-167.590,15.813,9.003,0.034,2.419,2.063,17.030,5.301,122.107,52.726,2.289,1.630
 3122.909,122.270,1088.867,72.108,-167.835,16.121,8.977,0.033,2.424,2.085,16.749,5.345,121.133,52.038,2.279,1.628
 3123.409,122.246,1089.600,61.987,-167.224,16.372,8.919,0.031,2.424,2.131,16.753,5.356,118.012,49.832,2.268,1.626
 3123.909,122.263,1093.750,56.120,-165.823,16.554,8.892,0.027,2.414,2.151,17.311,5.288,115.296,47.912,2.260,1.626
 3124.409,122.346,1094.727,58.406,-164.675,16.645,8.938,0.026,2.408,2.153,17.633,5.201,116.509,48.770,2.256,1.627
 3124.909,122.444,1088.086,66.359,-164.249,16.588,9.020,0.026,2.407,2.089,17.699,5.137,120.994,51.940,2.258,1.630
 3125.409,122.386,1082.764,72.469,-164.693,16.729,9.060,0.027,2.415,1.992,17.279,5.154,125.020,54.784,2.260,1.632
 3125.909,122.440,1082.861,73.525,-165.859,17.465,9.060,0.028,2.420,1.985,16.931,5.211,125.576,55.178,2.262,1.632
 3126.409,122.211,1083.984,70.779,-166.737,18.353,9.042,0.030,2.423,2.019,16.808,5.233,123.769,53.900,2.260,1.631
 3126.909,122.377,1083.984,69.002,-167.181,18.957,8.993,0.035,2.423,2.051,16.770,5.215,121.839,52.536,2.260,1.631
 3127.409,122.268,1083.984,68.516,-166.976,19.072,8.973,0.038,2.422,2.013,16.863,5.189,120.027,51.256,2.265,1.633
 3127.909,122.415,1083.984,68.144,-166.777,18.737,8.971,0.039,2.420,1.961,16.982,5.212,119.375,50.795,2.277,1.639
 3128.409,122.286,1081.006,69.956,-166.841,18.394,8.952,0.040,2.416,1.989,17.177,5.286,120.660,51.703,2.296,1.649
 3128.909,122.387,1092.871,70.918,-166.308,18.366,8.919,0.039,2.412,2.080,17.402,5.387,122.796,53.213,2.320,1.664
 3129.409,122.334,1093.750,70.910,-166.093,18.848,8.875,0.037,2.408,2.183,17.636,5.479,125.561,55.167,2.350,1.683
 3129.909,122.411,1089.063,68.915,-166.617,19.530,8.844,0.036,2.410,2.200,17.542,5.546,125.603,55.196,2.386,1.704
 3130.409,122.448,1083.984,64.978,-168.651,19.623,8.817,0.036,2.412,2.141,17.446,5.595,120.762,51.775,2.427,1.728
 3130.909,122.354,1083.984,61.984,-170.448,18.920,8.801,0.037,2.411,2.036,17.473,5.645,115.264,47.890,2.475,1.751
 3131.409,122.436,1083.984,58.941,-171.570,17.953,8.798,0.037,2.403,1.969,17.962,5.758,112.547,45.970,2.523,1.775
 3131.909,122.411,1088.867,57.462,-171.654,17.576,8.777,0.036,2.393,1.958,18.540,5.928,113.526,46.661,2.572,1.799
 3132.409,122.493,1094.531,57.947,-171.412,18.216,8.741,0.039,2.392,1.986,18.591,6.077,116.630,48.855,2.614,1.826
 3132.909,122.465,1098.633,58.839,-171.515,19.199,8.681,0.040,2.392,2.011,18.584,6.122,117.852,49.719,2.657,1.859
 3133.409,122.504,1086.328,56.032,-172.643,19.759,8.598,0.035,2.385,2.016,18.989,6.017,117.423,49.415,2.708,1.906
 3133.909,122.462,1083.984,52.678,-173.307,19.779,8.525,0.026,2.374,2.031,19.643,5.896,116.964,49.091,2.777,1.967
 3134.409,122.479,1083.984,51.704,-172.847,19.268,8.467,0.019,2.370,2.015,19.868,5.988,116.557,48.803,2.875,2.046
 3134.909,122.432,1084.961,56.787,-172.274,18.601,8.418,0.015,2.374,2.005,19.635,6.421,116.340,48.650,3.004,2.138
 3135.409,122.399,1088.867,67.987,-171.408,18.046,8.407,0.014,2.387,2.014,18.868,7.184,115.983,48.398,3.164,2.242
 3135.909,122.395,1097.412,77.069,-170.452,17.707,8.435,0.016,2.403,2.071,17.954,8.064,116.278,48.606,3.342,2.352
 3136.409,122.443,1093.750,84.372,-168.433,17.596,8.456,0.022,2.418,2.145,17.100,8.869,118.126,49.913,3.529,2.462
 3136.909,122.439,1083.984,86.870,-165.432,17.463,8.476,0.028,2.431,2.228,16.293,9.316,120.667,51.708,3.714,2.569
 3137.409,122.497,1083.984,88.435,-161.617,17.908,8.504,0.034,2.446,2.384,15.427,9.208,123.169,53.477,3.886,2.665
 3137.909,122.464,1083.984,89.381,-157.093,19.454,8.525,0.037,2.464,2.553,14.406,8.779,124.285,54.265,4.031,2.740
 3138.409,122.512,1083.984,88.834,-154.780,21.587,8.525,0.037,2.478,2.653,13.579,8.525,124.158,54.175,4.139,2.786
 3138.909,122.389,1093.750,89.399,-154.559,23.491,8.504,0.035,2.484,2.631,13.233,8.796,123.249,53.533,4.192,2.791
 3139.409,122.429,1093.750,88.549,-156.678,23.836,8.468,0.032,2.482,2.501,13.354,9.294,121.897,52.577,4.207,2.768
 3139.909,122.518,1083.984,89.301,-158.984,22.518,8.422,0.030,2.481,2.354,13.385,9.457,120.820,51.816,4.190,2.722
 3140.409,122.345,1083.984,90.613,-161.861,20.750,8.370,0.026,2.475,2.217,13.769,9.322,120.116,51.319,4.160,2.663
 3140.909,122.414,1083.887,91.357,-165.043,19.372,8.329,0.018,2.463,2.114,14.471,9.199,119.623,50.970,4.107,2.595
 3141.409,122.450,1093.750,90.730,-168.803,18.862,8.314,0.011,2.455,2.127,14.930,9.266,118.777,50.372,4.024,2.514
 3141.909,122.423,1096.387,85.462,-172.100,18.678,8.311,0.008,2.448,2.263,15.346,9.254,117.582,49.528,3.907,2.432
 3142.409,122.506,1088.867,77.933,-174.476,18.220,8.310,0.011,2.439,2.403,15.858,8.818,116.634,48.858,3.771,2.352
 3142.909,122.389,1091.748,71.263,-175.087,17.759,8.313,0.017,2.422,2.386,16.827,7.976,116.440,48.721,3.639,2.284
 3143.409,122.489,1070.947,69.246,-174.881,17.671,8.318,0.023,2.407,2.258,17.712,7.190,117.029,49.137,3.524,2.228
 3143.909,122.583,1083.984,70.123,-174.111,18.192,8.319,0.031,2.410,2.175,17.569,6.833,117.971,49.803,3.433,2.185
 3144.409,122.496,1092.969,72.473,-173.196,18.936,8.319,0.038,2.424,2.182,16.753,6.838,118.727,50.337,3.362,2.157
 3144.909,122.565,1092.188,76.819,-172.511,19.458,8.319,0.042,2.439,2.251,15.873,7.014,119.317,50.754,3.318,2.144
 3145.409,122.664,1092.725,79.474,-171.972,20.033,8.319,0.042,2.445,2.248,15.496,7.206,119.783,51.083,3.300,2.146
 3145.909,122.519,1092.432,80.159,-171.541,20.715,8.320,0.040,2.444,2.192,15.545,7.405,120.114,51.317,3.310,2.160
 3146.409,122.551,1088.867,82.924,-171.461,20.988,8.320,0.038,2.444,2.174,15.568,7.667,120.184,51.367,3.340,2.182
 3146.909,122.606,1088.867,84.185,-171.578,20.583,8.321,0.039,2.448,2.207,15.328,7.968,119.986,51.227,3.383,2.211
 3147.409,122.576,1090.820,85.974,-171.705,19.935,8.320,0.038,2.450,2.246,15.187,8.173,119.682,51.012,3.426,2.245
 3147.909,122.501,1083.984,85.380,-170.833,19.875,8.315,0.030,2.436,2.215,16.048,8.139,119.490,50.876,3.472,2.283
 3148.409,122.626,1092.041,82.088,-168.782,20.293,8.331,0.021,2.413,2.128,17.342,7.980,119.319,50.755,3.517,2.327
 3148.909,122.657,1080.371,83.921,-166.894,20.393,8.362,0.014,2.399,2.079,18.186,7.916,119.053,50.567,3.570,2.373
 3149.409,122.426,1079.102,86.286,-166.329,19.937,8.376,0.015,2.404,2.109,17.877,8.056,118.625,50.265,3.623,2.424
 3149.909,122.712,1092.578,87.169,-166.657,19.493,8.393,0.026,2.432,2.177,16.257,8.323,118.142,49.924,3.680,2.475
 3150.409,122.583,1103.516,85.884,-167.054,19.467,8.399,0.041,2.462,2.208,14.523,8.562,117.745,49.643,3.738,2.525
 3150.909,122.633,1089.307,86.398,-166.993,19.772,8.395,0.052,2.478,2.207,13.557,8.703,117.376,49.383,3.792,2.573
 3151.409,122.559,1088.867,88.113,-166.133,20.461,8.384,0.053,2.470,2.220,14.030,8.753,116.914,49.056,3.837,2.615
 3151.909,122.535,1088.672,88.710,-165.099,21.220,8.368,0.051,2.456,2.230,14.882,8.818,116.107,48.486,3.865,2.656
 3152.409,122.511,1079.102,82.670,-164.168,21.658,8.361,0.050,2.449,2.215,15.251,9.014,114.945,47.664,3.882,2.697
 3152.909,122.626,1079.785,70.601,-162.938,21.215,8.362,0.049,2.452,2.172,15.066,9.212,113.670,46.763,3.893,2.746
 3153.409,122.546,1091.748,59.990,-161.469,19.587,8.376,0.045,2.450,2.160,15.186,9.132,112.406,45.870,3.914,2.813
 3153.909,122.651,1083.984,53.395,-159.552,17.408,8.389,0.042,2.440,2.156,15.814,8.803,111.577,45.284,3.968,2.902
 3154.409,122.615,1087.109,56.417,-157.400,15.533,8.398,0.049,2.440,2.190,15.793,8.503,111.569,45.278,4.073,3.023
 3154.909,122.570,1083.984,68.099,-155.506,14.820,8.472,0.064,2.458,2.245,14.734,8.648,113.208,46.437,4.231,3.170
 3155.409,122.630,1083.984,81.043,-153.654,15.385,8.597,0.078,2.489,2.301,12.912,9.428,116.596,48.831,4.446,3.348
 3155.909,122.684,1086.035,88.367,-151.052,16.713,8.661,0.083,2.517,2.348,11.290,10.630,118.228,49.985,4.702,3.549
 3156.409,122.730,1090.186,87.624,-148.727,18.076,8.663,0.075,2.531,2.351,10.473,12.116,115.358,47.957,4.989,3.780
 3156.909,122.520,1088.867,81.860,-146.699,18.543,8.634,0.057,2.528,2.326,10.632,13.668,108.597,43.178,5.316,4.051
 3157.409,122.618,1088.867,75.161,-145.751,17.723,8.609,0.041,2.520,2.310,11.107,14.948,103.672,39.698,5.686,4.364
 3157.909,122.619,1085.840,71.840,-143.817,15.998,8.617,0.030,2.513,2.310,11.549,15.699,105.290,40.841,6.143,4.732
 3158.409,122.736,1079.102,75.087,-140.865,14.688,8.684,0.030,2.518,2.301,11.202,15.907,109.730,43.979,6.648,5.132
 3158.909,122.641,1083.984,80.243,-136.458,14.609,8.755,0.036,2.540,2.288,9.915,16.844,110.056,44.209,7.144,5.518
 3159.409,122.650,1092.578,80.171,-131.684,14.905,8.779,0.040,2.563,2.301,8.569,19.125,103.323,39.451,7.505,5.836
 3159.909,122.748,1086.914,73.446,-127.247,14.394,8.840,0.038,2.576,2.336,7.839,20.406,92.926,32.103,7.643,6.029
 3160.409,122.668,1083.984,67.777,-123.156,12.881,8.919,0.033,2.576,2.379,7.825,18.843,87.108,27.991,7.609,6.166
 3160.909,122.659,1079.590,74.494,-117.850,11.767,9.005,0.030,2.577,2.473,7.783,14.217,87.993,28.617,7.454,6.257
 3161.409,122.720,1083.691,91.556,-112.591,12.609,9.102,0.031,2.587,2.569,7.192,9.521,90.474,30.370,7.272,6.343
 3161.909,122.685,1086.426,105.370,-107.441,16.116,9.167,0.030,2.602,2.649,6.315,7.428,91.320,30.968,7.032,6.353
 3162.409,122.712,1088.867,110.207,-104.496,20.438,9.217,0.025,2.608,2.694,5.989,6.989,91.286,30.944,6.776,6.298
 3162.909,122.707,1088.867,110.206,-103.099,23.108,9.244,0.018,2.603,2.744,6.246,7.110,90.634,30.483,6.543,6.222
 3163.409,122.660,1088.867,109.624,-102.402,23.656,9.259,0.015,2.601,2.825,6.347,7.232,89.003,29.331,6.393,6.169
 3163.909,122.714,1083.105,106.808,-101.717,23.184,9.265,0.011,2.598,2.861,6.548,7.377,88.679,29.102,6.374,6.184
 3164.409,122.754,1079.688,101.923,-99.977,22.556,9.266,0.009,2.602,2.848,6.291,7.621,91.138,30.840,6.447,6.239
 3164.909,122.621,1090.234,96.715,-98.682,21.537,9.269,0.006,2.607,2.917,6.041,7.894,95.386,33.842,6.536,6.288
 3165.409,122.776,1093.750,95.498,-97.432,19.971,9.283,0.003,2.604,3.011,6.225,8.039,98.839,36.282,6.585,6.328
 3165.909,122.726,1093.750,95.451,-97.882,18.424,9.310,0.004,2.604,3.052,6.220,7.959,98.801,36.255,6.507,6.290
 3166.409,122.725,1083.984,95.300,-98.809,17.894,9.339,0.010,2.601,3.043,6.388,7.635,97.342,35.224,6.347,6.190
 3166.909,122.839,1080.371,98.036,-99.201,18.451,9.361,0.029,2.609,3.041,5.889,7.066,98.721,36.199,6.145,6.041
 3167.409,122.541,1082.910,102.583,-98.804,19.397,9.381,0.057,2.628,3.092,4.789,6.413,102.018,38.529,5.910,5.862
 3167.909,122.760,1093.750,110.583,-97.040,20.462,9.393,0.071,2.637,3.102,4.275,5.866,105.174,40.759,5.688,5.703
 3168.409,122.641,1092.236,119.165,-95.315,21.606,9.394,0.064,2.634,3.020,4.441,5.580,105.613,41.069,5.461,5.540
 3168.909,122.780,1084.814,122.150,-94.375,22.920,9.442,0.040,2.617,3.001,5.411,5.538,103.815,39.798,5.263,5.381
 3169.409,122.615,1085.742,121.283,-94.032,24.397,9.528,0.026,2.602,3.046,6.326,5.549,105.400,40.919,5.111,5.251
 3169.909,122.701,1088.867,121.063,-94.323,25.657,9.571,0.040,2.594,3.070,6.776,5.520,108.886,43.383,5.018,5.149
 3170.409,122.817,1088.867,122.625,-95.052,26.495,9.579,0.072,2.593,2.987,6.834,5.486,109.133,43.557,4.982,5.110
 3170.909,122.816,1088.867,123.023,-96.049,27.366,9.581,0.092,2.591,2.795,6.948,5.506,103.318,39.447,4.984,5.108
 3171.409,122.814,1089.355,120.262,-96.569,28.704,9.581,0.078,2.590,2.676,7.029,5.605,94.339,33.102,4.991,5.131
 3171.909,122.839,1083.984,114.829,-96.091,30.012,9.581,0.045,2.589,2.662,7.103,5.703,89.730,29.845,4.985,5.137
 3172.409,122.814,1088.867,109.163,-95.340,30.271,9.581,0.028,2.599,2.783,6.495,5.690,94.594,33.282,4.964,5.118
 3172.909,122.764,1088.574,105.182,-94.719,29.609,9.582,0.032,2.620,2.920,5.270,5.589,102.127,38.605,4.936,5.086
 3173.409,122.812,1084.473,107.214,-94.578,28.644,9.600,0.036,2.627,2.963,4.877,5.469,103.644,39.678,4.920,5.055
 3173.909,122.747,1088.867,115.302,-94.895,27.556,9.613,0.032,2.625,2.926,4.992,5.360,97.921,35.633,4.913,5.037
 3174.409,122.877,1094.727,121.781,-95.236,26.300,9.593,0.024,2.609,2.913,5.923,5.284,89.192,29.465,4.906,5.022
 3174.909,122.665,1098.047,123.531,-95.694,25.022,9.573,0.020,2.594,2.923,6.757,5.248,85.464,26.829,4.898,5.025
 3175.409,122.801,1093.750,121.934,-95.243,24.090,9.572,0.021,2.589,2.915,7.092,5.247,87.235,28.081,4.887,5.024
 3175.909,122.763,1087.207,121.051,-94.708,23.741,9.572,0.023,2.587,2.981,7.202,5.258,89.270,29.519,4.872,5.016
 3176.409,122.717,1079.102,122.017,-94.404,23.668,9.572,0.029,2.598,3.089,6.544,5.261,88.280,28.820,4.869,5.001
 3176.909,122.815,1081.250,122.260,-93.887,24.184,9.597,0.037,2.612,3.145,5.726,5.277,85.244,26.674,4.863,4.976
 3177.409,122.816,1088.867,121.242,-93.291,25.552,9.627,0.042,2.623,3.162,5.079,5.341,83.043,25.119,4.860,4.958
 3177.909,122.874,1088.867,116.212,-92.396,27.080,9.593,0.040,2.622,3.089,5.167,5.442,84.142,25.895,4.848,4.937
 3178.409,122.886,1088.867,108.542,-92.499,28.057,9.545,0.037,2.616,3.063,5.491,5.531,87.431,28.220,4.831,4.919
 3178.909,122.842,1083.984,102.043,-93.748,27.732,9.541,0.037,2.615,3.135,5.564,5.547,90.599,30.459,4.816,4.907
 3179.409,122.762,1092.188,100.740,-95.128,26.119,9.593,0.042,2.617,3.203,5.432,5.479,92.498,31.801,4.795,4.886
 3179.909,122.849,1097.266,106.435,-95.589,24.531,9.623,0.054,2.622,3.243,5.125,5.375,93.056,32.195,4.784,4.884
 3180.409,122.851,1103.516,115.007,-95.187,24.000,9.680,0.062,2.618,3.234,5.379,5.285,94.669,33.335,4.760,4.875
 3180.909,122.734,1095.752,123.523,-94.373,24.744,9.952,0.061,2.601,3.208,6.382,5.223,98.936,36.350,4.735,4.867
 3181.409,122.826,1098.633,127.800,-93.830,25.823,9.995,0.061,2.582,3.205,7.507,5.152,101.953,38.483,4.702,4.849
 3181.909,122.894,1098.633,125.437,-93.706,26.711,9.815,0.065,2.578,3.120,7.711,5.069,101.544,38.194,4.662,4.808
 3182.409,122.874,1093.848,121.185,-93.691,27.605,9.822,0.066,2.591,2.962,6.953,5.012,98.341,35.930,4.638,4.783
 3182.909,122.939,1103.516,119.166,-93.735,28.614,9.814,0.054,2.611,2.869,5.806,5.020,97.911,35.626,4.616,4.753
 3183.409,122.739,1098.926,120.952,-93.512,29.697,9.739,0.031,2.617,2.883,5.465,5.081,103.143,39.324,4.604,4.727
 3183.909,122.896,1105.713,125.201,-93.325,30.466,9.739,0.016,2.617,2.971,5.432,5.145,108.852,43.358,4.604,4.719
 3184.409,122.783,1102.344,125.889,-93.271,30.641,9.771,0.018,2.629,3.045,4.714,5.190,109.577,43.871,4.608,4.708
 3184.909,122.846,1088.867,122.450,-93.146,30.079,9.788,0.024,2.640,3.064,4.119,5.214,103.752,39.754,4.627,4.725
 3185.409,122.797,1093.750,116.570,-92.672,28.639,9.811,0.026,2.640,3.032,4.094,5.223,96.693,34.765,4.644,4.738
 3185.909,122.780,1100.098,116.626,-92.307,27.026,9.831,0.024,2.630,2.956,4.676,5.207,93.016,32.167,4.650,4.750
 3186.409,123.001,1108.398,121.649,-92.160,25.885,9.834,0.019,2.613,2.849,5.681,5.153,92.866,32.060,4.645,4.754
 3186.909,122.907,1101.563,123.835,-92.351,25.197,9.832,0.019,2.609,2.786,5.899,5.073,93.493,32.504,4.627,4.742
 3187.409,122.813,1094.824,123.770,-92.598,25.410,9.841,0.023,2.618,2.822,5.382,5.009,94.083,32.921,4.605,4.726
 3187.909,122.876,1098.633,123.565,-92.712,26.388,9.871,0.029,2.633,2.880,4.526,4.981,95.458,33.892,4.576,4.689
 3188.409,122.799,1104.443,126.846,-92.806,27.814,9.888,0.031,2.643,2.878,3.901,4.981,99.477,36.733,4.543,4.645
 3188.909,122.941,1089.893,129.966,-92.716,29.433,9.885,0.027,2.640,2.848,4.066,4.978,102.621,38.955,4.496,4.589
 3189.409,122.909,1088.867,127.855,-93.376,30.268,9.885,0.021,2.627,2.826,4.873,4.932,102.502,38.871,4.450,4.546
 3189.909,122.872,1092.969,122.273,-94.270,30.156,9.903,0.020,2.615,2.818,5.563,4.859,99.347,36.641,4.414,4.527
 3190.409,122.926,1093.750,118.431,-95.212,29.408,9.918,0.023,2.606,2.868,6.078,4.783,94.578,33.271,4.387,4.511
 3190.909,123.021,1098.096,117.695,-95.397,28.511,9.915,0.031,2.598,2.955,6.557,4.717,91.806,31.312,4.373,4.494
 3191.409,122.903,1104.639,116.450,-95.206,28.218,9.956,0.051,2.597,3.009,6.618,4.665,91.237,30.909,4.350,4.465
 3191.909,122.808,1113.281,115.599,-94.932,28.571,10.062,0.067,2.596,2.971,6.695,4.646,92.234,31.614,4.323,4.431
 3192.409,123.032,1101.270,118.702,-94.025,28.932,10.105,0.070,2.607,2.858,6.028,4.669,94.555,33.254,4.292,4.425
 3192.909,122.878,1098.633,126.659,-93.296,29.067,10.016,0.060,2.618,2.777,5.402,4.705,95.897,34.203,4.262,4.400
 3193.409,122.976,1106.006,129.960,-92.114,29.135,9.975,0.044,2.618,2.848,5.364,4.721,93.992,32.857,4.252,4.388
 3193.909,122.791,1103.516,127.116,-91.701,29.496,9.995,0.041,2.619,3.018,5.327,4.705,90.627,30.478,4.260,4.376
 3194.409,122.971,1098.047,121.580,-91.534,29.600,10.073,0.044,2.618,3.157,5.408,4.707,87.118,27.999,4.277,4.375
 3194.909,122.918,1098.242,118.204,-91.984,28.860,10.082,0.044,2.622,3.186,5.136,4.745,84.482,26.135,4.299,4.396
 3195.409,122.984,1093.750,120.337,-92.965,27.671,9.977,0.035,2.621,3.199,5.196,4.800,83.410,25.378,4.312,4.404
 3195.909,122.931,1098.633,125.419,-93.538,26.799,9.952,0.024,2.615,3.172,5.551,4.828,82.986,25.078,4.317,4.419
 3196.409,123.002,1101.807,128.851,-93.595,26.662,9.952,0.020,2.617,3.101,5.432,4.809,82.949,25.052,4.321,4.423
 3196.909,122.874,1102.637,129.490,-92.697,26.406,9.951,0.017,2.615,3.000,5.568,4.768,83.400,25.371,4.320,4.409
 3197.409,122.951,1105.469,127.562,-92.317,26.098,9.961,0.013,2.611,2.922,5.817,4.742,83.966,25.771,4.314,4.389
 3197.909,122.978,1108.398,124.153,-92.825,26.249,9.972,0.009,2.602,2.907,6.296,4.738,84.298,26.005,4.300,4.369
 3198.409,122.828,1108.398,123.336,-93.972,26.713,9.972,0.007,2.599,2.920,6.512,4.736,84.340,26.035,4.279,4.374
 3198.909,122.934,1102.197,120.822,-95.354,27.187,9.966,0.013,2.612,2.936,5.758,4.712,84.266,25.983,4.272,4.386
 3199.409,123.014,1098.633,123.572,-95.922,27.269,9.970,0.022,2.618,2.939,5.393,4.666,84.290,26.000,4.272,4.386
 3199.909,122.936,1101.758,133.332,-96.377,27.834,9.995,0.037,2.622,2.984,5.147,4.611,84.480,26.134,4.281,4.359
 3200.409,123.029,1108.398,140.351,-96.404,29.457,10.079,0.051,2.617,2.989,5.413,4.571,84.709,26.296,4.276,4.331
 3200.909,123.019,1108.398,138.779,-96.251,31.126,10.077,0.053,2.604,2.957,6.228,4.586,84.736,26.315,4.256,4.318
 3201.409,123.095,1108.398,131.783,-96.122,31.692,10.014,0.047,2.594,2.977,6.757,4.639,85.195,26.640,4.224,4.326
 3201.909,123.052,1108.398,126.160,-95.884,30.652,10.025,0.047,2.584,2.989,7.352,4.658,87.512,28.277,4.200,4.317
 3202.409,123.003,1099.219,125.527,-96.530,29.312,10.096,0.073,2.579,2.990,7.674,4.590,90.387,30.309,4.186,4.301
 3202.909,123.066,1108.398,127.291,-97.934,29.177,10.244,0.113,2.568,2.982,8.332,4.446,91.501,31.096,4.184,4.280
 3203.409,123.083,1108.398,128.222,-99.901,30.093,10.470,0.139,2.554,2.981,9.139,4.337,90.220,30.191,4.167,4.271
 3203.909,123.116,1103.418,126.472,-101.141,31.513,10.538,0.136,2.542,3.094,9.819,4.338,87.202,28.058,4.138,4.267
 3204.409,122.851,1098.828,126.166,-101.247,32.561,10.279,0.123,2.526,3.217,10.753,4.376,86.206,27.354,4.080,4.231
 3204.909,123.222,1100.781,126.625,-100.655,32.483,10.110,0.128,2.514,3.263,11.490,4.353,88.885,29.247,4.033,4.180
 3205.409,123.016,1108.398,126.260,-100.421,31.693,10.214,0.143,2.507,3.218,11.878,4.264,91.762,31.281,3.995,4.130
 3205.909,123.086,1111.377,127.259,-101.539,30.951,10.463,0.148,2.518,3.107,11.257,4.196,92.400,31.731,3.978,4.104
 3206.409,123.127,1095.020,126.349,-102.339,30.947,10.625,0.134,2.540,3.073,9.923,4.199,90.506,30.393,3.962,4.102
 3206.909,122.960,1103.516,120.621,-102.402,31.434,10.637,0.110,2.551,3.079,9.287,4.245,87.370,28.177,3.935,4.101
 3207.409,123.073,1108.398,117.739,-101.867,31.931,10.749,0.098,2.548,3.087,9.473,4.265,85.967,27.185,3.924,4.123
 3207.909,123.005,1104.932,120.088,-100.763,33.047,10.739,0.109,2.548,3.066,9.487,4.226,85.907,27.143,3.935,4.149
 3208.409,122.943,1101.270,125.179,-100.357,35.847,10.477,0.119,2.533,3.000,10.345,4.173,85.944,27.169,3.981,4.183
 3208.909,122.970,1101.074,129.935,-99.526,39.232,10.441,0.118,2.511,2.922,11.618,4.189,86.262,27.393,4.045,4.226
 3209.409,123.151,1102.148,129.115,-98.816,40.324,10.447,0.101,2.504,2.831,12.020,4.353,86.364,27.466,4.104,4.258
 3209.909,123.091,1106.445,124.746,-97.473,37.901,10.220,0.070,2.520,2.792,11.119,4.627,86.362,27.464,4.153,4.295
 3210.409,123.101,1103.516,119.833,-96.134,33.463,10.048,0.043,2.558,2.818,8.887,4.890,87.352,28.164,4.197,4.314
 3210.909,122.908,1107.666,117.334,-95.356,30.141,10.007,0.025,2.585,2.875,7.329,5.052,89.237,29.496,4.266,4.350
 3211.409,123.172,1105.322,114.963,-95.153,28.771,10.005,0.020,2.599,2.956,6.518,5.091,91.391,31.019,4.363,4.423
 3211.909,123.144,1108.398,112.407,-95.489,28.573,10.005,0.019,2.602,3.007,6.289,5.071,92.794,32.010,4.470,4.512
 3212.409,123.093,1108.398,108.707,-94.911,28.864,10.005,0.016,2.598,3.006,6.522,5.026,93.073,32.207,4.551,4.610
 3212.909,123.153,1103.760,111.780,-94.104,28.592,10.005,0.013,2.597,3.013,6.603,4.977,94.590,33.279,4.592,4.668
 3213.409,123.149,1103.516,119.512,-93.502,27.549,10.005,0.012,2.600,2.975,6.438,4.943,99.726,36.909,4.586,4.690
 3213.909,123.074,1108.350,126.904,-93.873,26.374,10.005,0.013,2.607,2.856,6.005,4.921,106.360,41.597,4.565,4.675
 3214.409,123.148,1113.281,126.122,-94.580,25.985,10.002,0.012,2.608,2.817,5.949,4.911,112.240,45.753,4.536,4.637
 3214.909,123.180,1103.320,120.026,-95.095,26.267,9.996,0.008,2.599,2.871,6.511,4.900,115.085,47.763,4.513,4.606
 3215.409,123.110,1101.416,118.937,-94.944,26.040,9.993,0.005,2.593,2.958,6.840,4.877,115.059,47.745,4.495,4.577
 3215.909,123.213,1103.516,119.414,-94.534,25.319,9.993,0.004,2.592,3.014,6.922,4.844,115.178,47.829,4.474,4.551
 3216.409,123.173,1103.516,126.101,-93.702,25.434,10.000,0.004,2.592,2.935,6.917,4.802,115.598,48.126,4.456,4.522
 3216.909,123.091,1104.883,134.509,-92.896,26.562,10.041,0.006,2.595,2.877,6.707,4.771,116.203,48.553,4.426,4.490
 3217.409,123.131,1110.059,138.514,-92.579,27.583,10.048,0.011,2.602,2.869,6.342,4.755,116.728,48.924,4.399,4.472
 3217.909,123.168,1108.398,137.368,-92.604,27.307,10.018,0.016,2.610,2.850,5.837,4.749,116.864,49.021,4.365,4.457
 3218.409,123.067,1104.932,132.744,-92.999,25.742,10.017,0.022,2.621,2.855,5.183,4.736,115.663,48.172,4.339,4.441
 3218.909,123.281,1100.879,126.087,-93.938,24.655,10.022,0.025,2.622,2.892,5.137,4.694,111.178,45.002,4.319,4.422
 3219.409,123.195,1108.398,121.213,-95.029,25.141,10.005,0.027,2.619,3.020,5.337,4.634,104.509,40.289,4.304,4.395
 3219.909,123.213,1107.031,117.827,-95.860,26.411,9.958,0.027,2.619,3.098,5.347,4.592,98.500,36.042,4.294,4.381
 3220.409,123.144,1103.516,117.354,-95.802,27.622,9.925,0.024,2.619,3.087,5.297,4.585,95.503,33.924,4.281,4.367
 3220.909,123.275,1105.127,123.241,-95.219,28.619,9.918,0.021,2.626,3.022,4.911,4.609,97.697,35.475,4.265,4.351
 3221.409,123.083,1104.248,130.340,-94.637,29.204,9.917,0.019,2.628,2.903,4.805,4.632,101.985,38.505,4.246,4.330
 3221.909,123.229,1103.516,132.387,-95.123,29.172,9.913,0.018,2.625,2.835,4.962,4.631,103.845,39.819,4.237,4.315
 3222.409,123.146,1103.516,129.906,-96.202,28.735,9.956,0.023,2.629,2.822,4.754,4.621,102.614,38.950,4.231,4.311
 3222.909,123.184,1111.182,125.206,-97.587,28.272,10.028,0.027,2.627,2.911,4.880,4.605,99.841,36.990,4.239,4.315
 3223.409,123.248,1108.398,125.056,-98.592,28.134,10.020,0.040,2.619,3.044,5.333,4.579,99.224,36.554,4.236,4.322
 3223.909,123.211,1108.398,126.742,-98.600,28.417,10.128,0.071,2.624,3.076,5.018,4.541,102.111,38.594,4.221,4.327
 3224.409,123.292,1108.398,126.267,-98.997,28.968,10.217,0.101,2.629,3.055,4.744,4.505,103.707,39.723,4.208,4.354
 3224.909,123.204,1110.938,124.768,-99.313,29.910,10.179,0.108,2.622,3.058,5.149,4.479,101.859,38.416,4.194,4.368
 3225.409,123.252,1103.516,122.613,-99.693,31.096,10.180,0.102,2.599,3.067,6.501,4.443,99.443,36.709,4.194,4.369
 3225.909,123.166,1106.299,122.739,-99.523,31.904,10.185,0.100,2.564,3.027,8.531,4.395,99.300,36.608,4.195,4.362
 3226.409,123.359,1113.281,123.672,-99.004,32.523,10.270,0.101,2.540,2.874,9.949,4.402,101.123,37.896,4.205,4.352
 3226.909,123.195,1113.281,121.784,-98.930,32.887,10.212,0.084,2.542,2.815,9.835,4.524,101.327,38.040,4.216,4.377
 3227.409,123.204,1108.398,122.565,-98.758,32.398,10.031,0.051,2.563,2.906,8.616,4.706,98.151,35.796,4.232,4.384
 3227.909,123.211,1108.398,125.583,-98.807,31.157,9.970,0.025,2.598,3.036,6.525,4.871,92.059,31.491,4.251,4.400
 3228.409,123.248,1109.326,129.121,-98.284,29.592,9.978,0.020,2.634,3.102,4.448,4.975,86.969,27.893,4.302,4.433
 3228.909,123.274,1116.748,131.634,-97.389,28.287,10.026,0.019,2.637,3.075,4.251,5.046,84.564,26.194,4.368,4.487
 3229.409,123.201,1113.281,128.607,-96.445,27.560,10.095,0.019,2.632,3.066,4.538,5.110,83.951,25.761,4.450,4.567
 3229.909,123.324,1105.859,124.388,-96.017,27.097,10.108,0.024,2.631,3.081,4.607,5.151,83.969,25.773,4.525,4.642
 3230.409,123.298,1107.764,123.581,-96.255,27.334,10.062,0.030,2.627,3.084,4.880,5.162,84.373,26.059,4.573,4.708
 3230.909,123.129,1118.164,128.069,-97.179,28.186,10.043,0.037,2.617,3.060,5.435,5.153,86.283,27.409,4.596,4.746
 3231.409,123.322,1105.176,132.944,-97.952,28.812,10.072,0.044,2.601,3.107,6.356,5.122,89.692,29.818,4.583,4.762
 3231.909,123.246,1098.633,136.571,-98.551,29.146,10.115,0.056,2.601,3.117,6.387,5.085,92.722,31.959,4.552,4.756
 3232.409,123.326,1116.309,136.189,-98.554,29.332,10.143,0.063,2.605,3.073,6.148,5.055,92.769,31.992,4.524,4.763
 3232.909,123.397,1099.951,129.636,-98.908,29.436,10.200,0.065,2.598,3.039,6.524,5.018,90.226,30.195,4.503,4.753
 3233.409,123.298,1096.533,120.857,-98.997,29.390,10.262,0.078,2.580,3.038,7.619,4.953,87.667,28.387,4.496,4.713
 3233.909,123.222,1107.666,116.350,-99.203,29.657,10.238,0.107,2.558,3.081,8.895,4.875,87.862,28.525,4.500,4.679
 3234.409,123.311,1118.164,120.547,-99.123,31.342,10.378,0.131,2.553,3.028,9.209,4.874,91.026,30.760,4.480,4.631
 3234.909,123.335,1103.516,126.756,-98.944,33.524,10.495,0.120,2.557,2.971,8.952,4.975,93.526,32.527,4.448,4.600
 3235.409,123.379,1115.576,127.757,-98.798,34.511,10.334,0.074,2.570,2.952,8.160,5.111,93.968,32.840,4.392,4.562
 3235.909,123.379,1112.793,126.935,-98.526,34.304,10.303,0.030,2.575,2.968,7.893,5.205,93.688,32.642,4.344,4.516
 3236.409,123.308,1103.516,125.645,-98.689,33.237,10.299,0.020,2.564,3.035,8.536,5.192,94.208,33.009,4.349,4.527
 3236.909,123.420,1118.164,125.252,-98.390,31.909,10.274,0.044,2.555,3.026,9.068,5.115,94.985,33.558,4.380,4.545
 3237.409,123.253,1118.164,124.472,-98.505,30.591,10.275,0.083,2.546,3.036,9.569,5.025,93.809,32.727,4.444,4.594
 3237.909,123.329,1111.084,124.353,-98.633,29.710,10.268,0.117,2.537,3.032,10.141,4.947,91.126,30.831,4.504,4.647
 3238.409,123.182,1098.633,126.679,-99.886,29.816,10.312,0.124,2.522,2.922,10.992,4.946,92.186,31.580,4.513,4.648
 3238.909,123.293,1105.371,130.013,-100.627,29.923,10.383,0.101,2.512,2.835,11.572,5.026,103.072,39.274,4.494,4.631
 3239.409,123.356,1113.281,132.581,-101.044,29.731,10.280,0.067,2.520,2.864,11.136,5.136,120.217,51.390,4.431,4.562
 3239.909,123.382,1112.109,132.400,-100.561,29.588,10.131,0.041,2.535,2.973,10.238,5.233,133.180,60.551,4.365,4.505
 3240.409,123.361,1104.639,133.430,-100.287,29.418,10.224,0.035,2.542,3.107,9.824,5.264,133.805,60.993,4.335,4.499
 3240.909,123.258,1106.348,137.240,-100.307,29.450,10.306,0.060,2.540,3.144,9.937,5.192,122.878,53.271,4.344,4.526
 3241.409,123.391,1109.326,139.978,-100.101,29.511,10.497,0.102,2.528,3.095,10.637,5.063,110.210,44.318,4.394,4.571
 3241.909,123.322,1113.281,138.788,-100.003,29.954,10.664,0.141,2.508,3.058,11.794,4.956,100.379,37.370,4.450,4.601
 3242.409,123.448,1113.281,134.847,-99.329,31.278,10.544,0.167,2.497,2.994,12.459,4.944,94.237,33.030,4.467,4.597
 3242.909,123.317,1106.494,132.331,-98.822,33.017,10.259,0.155,2.496,2.901,12.516,5.063,90.599,30.458,4.424,4.569
 3243.409,123.369,1103.516,131.534,-98.455,34.440,10.031,0.113,2.512,2.888,11.580,5.224,87.846,28.513,4.369,4.545
 3243.909,123.350,1113.965,126.751,-98.276,34.783,10.021,0.063,2.536,2.988,10.190,5.331,88.166,28.739,4.321,4.508
 3244.409,123.452,1103.711,120.612,-98.413,34.184,9.996,0.032,2.551,3.175,9.327,5.349,90.150,30.142,4.332,4.481
 3244.909,123.240,1108.203,121.469,-97.957,33.712,9.975,0.049,2.557,3.317,8.924,5.263,90.990,30.735,4.390,4.485
 3245.409,123.488,1108.398,127.177,-97.267,33.565,9.971,0.081,2.565,3.244,8.486,5.167,89.900,29.965,4.444,4.499
 3245.909,123.449,1108.398,128.391,-96.024,33.251,9.970,0.087,2.575,3.157,7.903,5.123,87.687,28.401,4.482,4.554
 3246.409,123.334,1103.760,125.507,-95.748,32.535,9.973,0.062,2.582,3.116,7.501,5.105,88.114,28.702,4.464,4.586
 3246.909,123.402,1108.398,125.772,-96.418,31.499,9.978,0.027,2.585,3.074,7.299,5.082,92.266,31.637,4.430,4.576
 3247.409,123.339,1108.398,127.181,-97.558,30.581,9.982,0.014,2.589,3.033,7.053,5.024,97.893,35.613,4.412,4.559
 3247.909,123.435,1108.398,128.372,-98.178,30.054,9.989,0.023,2.589,2.940,7.049,4.971,101.184,37.939,4.420,4.527
 3248.409,123.419,1109.131,125.646,-98.094,29.576,10.006,0.028,2.582,2.920,7.472,4.956,101.246,37.983,4.439,4.534
 3248.909,123.359,1116.553,123.228,-97.599,28.988,10.033,0.032,2.570,2.938,8.161,4.962,98.907,36.330,4.444,4.550
 3249.409,123.421,1118.164,126.562,-97.088,28.561,10.068,0.046,2.565,2.924,8.460,4.952,96.944,34.943,4.438,4.598
 3249.909,123.435,1114.648,129.013,-96.871,28.674,10.099,0.071,2.567,2.907,8.359,4.913,97.111,35.061,4.423,4.623
 3250.409,123.504,1120.605,130.460,-96.985,29.829,10.115,0.093,2.558,2.911,8.871,4.853,97.593,35.402,4.423,4.625
 3250.909,123.536,1113.281,130.814,-97.250,31.433,10.119,0.110,2.544,2.921,9.727,4.772,98.142,35.789,4.415,4.596
 3251.409,123.397,1108.398,129.971,-97.768,32.906,10.106,0.117,2.530,2.868,10.502,4.704,98.439,35.999,4.399,4.558
 3251.909,123.545,1116.406,130.181,-98.506,33.976,10.106,0.102,2.524,2.791,10.851,4.681,98.581,36.100,4.371,4.541
 3252.409,123.416,1114.844,132.651,-99.447,33.984,10.127,0.067,2.533,2.802,10.327,4.716,99.063,36.440,4.326,4.486
 3252.909,123.579,1112.646,132.751,-99.368,32.825,10.107,0.025,2.544,2.917,9.719,4.775,100.839,37.696,4.292,4.409
 3253.409,123.435,1108.398,128.924,-98.312,30.995,10.080,0.003,2.556,3.033,9.024,4.803,101.447,38.125,4.282,4.344
 3253.909,123.603,1112.842,124.409,-97.429,29.761,10.108,0.003,2.576,3.038,7.823,4.800,98.831,36.276,4.285,4.305
 3254.409,123.410,1108.398,123.064,-97.360,29.774,10.191,0.006,2.594,2.963,6.763,4.788,92.846,32.047,4.307,4.337
 3254.909,123.435,1113.086,128.313,-97.894,30.569,10.219,0.009,2.609,2.829,5.891,4.764,87.150,28.021,4.330,4.380
 3255.409,123.464,1113.184,133.557,-98.499,31.103,10.203,0.014,2.609,2.772,5.921,4.721,85.672,26.977,4.338,4.413
 3255.909,123.491,1118.213,138.405,-99.467,30.980,10.275,0.027,2.601,2.836,6.348,4.659,87.619,28.352,4.355,4.445
 3256.409,123.530,1120.459,140.255,-100.414,30.985,10.564,0.053,2.608,2.894,5.969,4.583,91.118,30.825,4.342,4.441
 3256.909,123.506,1113.281,137.909,-101.253,31.352,10.664,0.067,2.609,2.896,5.886,4.510,92.842,32.044,4.341,4.451
 3257.409,123.588,1107.617,132.290,-101.435,31.982,10.468,0.063,2.607,2.907,6.002,4.458,91.338,30.981,4.323,4.450
 3257.909,123.564,1118.701,126.310,-101.776,32.603,10.498,0.052,2.594,2.962,6.792,4.424,88.117,28.705,4.304,4.430
 3258.409,123.540,1123.047,126.680,-101.824,32.684,10.730,0.054,2.572,3.015,8.062,4.411,86.081,27.266,4.299,4.434
 3258.909,123.374,1113.281,129.125,-101.618,32.278,10.762,0.068,2.553,3.018,9.186,4.428,85.552,26.892,4.299,4.417
 3259.409,123.436,1109.961,129.219,-101.413,31.545,10.623,0.078,2.525,3.004,10.805,4.453,85.372,26.764,4.331,4.424
 3259.909,123.411,1109.375,126.501,-101.801,30.524,10.563,0.094,2.511,3.019,11.642,4.442,85.404,26.787,4.358,4.421
 3260.409,123.504,1116.846,123.704,-102.407,29.693,10.609,0.111,2.505,2.979,12.000,4.418,85.737,27.023,4.391,4.429
 3260.909,123.542,1123.047,125.057,-102.638,29.812,10.727,0.119,2.505,2.964,11.988,4.411,86.214,27.360,4.420,4.480
 3261.409,123.597,1119.287,127.438,-102.189,30.835,10.717,0.118,2.517,2.971,11.263,4.442,86.426,27.509,4.453,4.519
 3261.909,123.530,1162.109,126.457,-101.725,32.106,10.528,0.111,2.526,3.046,10.742,4.491,86.137,27.306,4.495,4.564
 3262.409,123.682,1126.074,123.227,-101.826,32.549,10.468,0.116,2.528,3.091,10.642,4.517,85.502,26.856,4.548,4.575
 3262.909,123.612,1121.338,122.331,-102.206,31.582,10.530,0.133,2.518,3.054,11.213,4.512,85.154,26.611,4.610,4.586
 3263.409,123.533,1118.164,125.890,-102.581,30.341,10.507,0.145,2.511,2.972,11.628,4.499,85.287,26.705,4.649,4.598
 3263.909,123.484,1123.047,129.657,-102.473,29.817,10.452,0.133,2.517,2.903,11.264,4.510,85.687,26.987,4.679,4.606
 3264.409,123.556,1123.047,129.407,-101.682,29.766,10.414,0.109,2.543,2.866,9.788,4.540,85.897,27.136,4.667,4.615
 3264.909,123.518,1120.898,124.102,-101.087,30.161,10.419,0.089,2.568,2.859,8.303,4.576,85.786,27.057,4.645,4.586
 3265.409,123.562,1122.900,118.431,-100.941,31.105,10.456,0.090,2.591,2.902,6.935,4.573,85.608,26.931,4.616,4.573
 3265.909,123.594,1118.164,115.569,-101.723,32.512,10.584,0.105,2.605,2.931,6.120,4.528,85.241,26.672,4.569,4.517
 3266.409,123.470,1113.379,116.496,-102.858,33.069,10.837,0.110,2.603,2.951,6.245,4.478,84.809,26.367,4.503,4.467
 3266.909,123.447,1115.137,118.742,-103.525,31.892,10.841,0.106,2.596,2.904,6.640,4.392,84.659,26.261,4.399,4.403
 3267.409,123.582,1108.984,121.605,-104.294,30.846,10.674,0.096,2.575,2.894,7.880,4.276,84.812,26.369,4.275,4.318
 3267.909,123.561,1118.164,120.468,-105.231,31.760,10.966,0.096,2.559,2.981,8.820,4.146,85.242,26.673,4.169,4.259
 3268.409,123.554,1113.281,116.917,-105.987,34.223,11.324,0.104,2.558,3.056,8.903,4.037,85.629,26.946,4.079,4.184
 3268.909,123.599,1113.281,115.545,-106.173,35.945,11.258,0.108,2.555,3.091,9.057,3.977,85.815,27.078,4.004,4.124
 3269.409,123.658,1116.602,118.176,-105.668,35.692,11.171,0.110,2.547,3.128,9.525,3.946,86.120,27.293,3.950,4.081
 3269.909,123.645,1108.398,125.414,-105.075,33.909,11.178,0.112,2.528,3.169,10.660,3.942,86.587,27.624,3.910,4.062
 3270.409,123.704,1114.307,130.767,-105.057,32.133,11.233,0.116,2.501,3.187,12.194,3.971,86.966,27.891,3.890,4.059
 3270.909,123.579,1118.164,131.859,-105.231,31.596,11.293,0.134,2.467,3.145,14.227,4.008,87.197,28.054,3.906,4.071
 3271.409,123.647,1108.398,129.027,-105.580,32.078,11.115,0.161,2.393,3.000,18.562,4.028,88.192,28.757,3.929,4.076
 3271.909,123.566,1112.207,121.563,-106.045,33.320,10.921,0.187,2.309,2.854,23.458,4.041,94.594,33.282,3.963,4.088
 3272.409,123.630,1117.676,116.037,-106.171,34.465,10.862,0.201,2.278,2.852,25.273,4.057,105.682,41.118,3.984,4.105
 3272.909,123.672,1127.930,116.829,-106.077,35.094,10.764,0.197,2.314,2.853,23.179,4.085,116.449,48.727,3.979,4.088
 3273.409,123.709,1127.930,121.994,-106.125,35.630,10.974,0.177,2.390,2.856,18.691,4.109,122.640,53.103,3.973,4.075
 3273.909,123.716,1115.186,128.140,-105.846,36.131,11.086,0.152,2.453,2.813,15.024,4.107,123.505,53.714,3.954,4.044
 3274.409,123.627,1121.094,129.878,-105.115,36.667,11.035,0.128,2.479,2.748,13.530,4.095,123.343,53.599,3.940,4.018
 3274.909,123.723,1118.164,126.466,-104.027,36.701,11.301,0.111,2.485,2.774,13.183,4.078,123.615,53.791,3.926,4.022
 3275.409,123.625,1118.164,121.519,-103.722,35.949,11.588,0.104,2.475,2.809,13.725,4.046,123.482,53.698,3.910,4.025
 3275.909,123.631,1122.900,119.022,-104.526,35.734,11.824,0.108,2.463,2.897,14.451,3.995,120.545,51.622,3.900,4.063
 3276.409,123.575,1123.047,114.800,-105.725,36.688,11.782,0.131,2.443,3.003,15.639,3.923,114.125,47.085,3.908,4.102
 3276.909,123.609,1098.633,110.602,-106.505,37.776,11.574,0.163,2.421,3.044,16.917,3.866,107.235,42.216,3.924,4.138
 3277.409,123.628,1109.180,110.474,-106.177,38.799,11.473,0.181,2.419,2.982,17.025,3.870,102.806,39.086,3.970,4.157
 3277.909,123.670,1123.047,113.754,-105.193,39.625,11.641,0.174,2.442,2.904,15.646,3.937,101.049,37.844,4.006,4.135
 3278.409,123.753,1123.047,119.768,-104.404,39.384,11.929,0.148,2.484,2.904,13.199,4.060,99.906,37.036,4.045,4.097
 3278.909,123.706,1123.047,121.019,-104.438,38.521,11.540,0.118,2.484,2.961,13.230,4.222,99.369,36.657,4.087,4.097
 3279.409,123.674,1119.922,118.199,-105.000,37.053,10.778,0.101,2.439,2.986,15.833,4.413,99.965,37.078,4.141,4.143
 3279.909,123.836,1118.164,115.593,-105.248,35.838,10.553,0.107,2.402,3.039,18.024,4.580,101.429,38.112,4.219,4.240
 3280.409,123.734,1118.164,116.248,-104.727,35.459,10.809,0.144,2.413,3.058,17.351,4.667,104.814,40.505,4.311,4.337
 3280.909,123.663,1123.047,119.549,-104.088,35.174,11.129,0.182,2.460,3.080,14.636,4.672,109.141,43.562,4.390,4.393
 3281.409,123.763,1126.611,126.113,-103.505,35.350,11.053,0.184,2.476,3.074,13.672,4.612,111.145,44.979,4.462,4.435
 3281.909,123.663,1120.508,134.946,-103.381,36.240,10.755,0.155,2.463,3.060,14.431,4.536,108.909,43.398,4.473,4.418
 3282.409,123.757,1113.281,141.028,-103.011,37.254,10.696,0.119,2.460,3.156,14.646,4.497,104.523,40.299,4.447,4.393
 3282.909,123.691,1123.047,138.207,-102.665,37.325,10.711,0.102,2.484,3.299,13.207,4.481,104.094,39.996,4.398,4.373
 3283.409,123.744,1110.889,129.232,-102.637,35.917,10.622,0.108,2.528,3.304,10.635,4.466,107.511,42.410,4.339,4.330
 3283.909,123.775,1111.816,120.142,-103.138,34.436,10.584,0.118,2.557,3.228,8.970,4.411,109.546,43.849,4.324,4.344
 3284.409,123.795,1122.461,113.823,-104.039,34.284,10.675,0.123,2.566,3.165,8.445,4.322,107.649,42.508,4.314,4.341
 3284.909,123.648,1118.164,113.498,-104.650,35.416,10.991,0.121,2.569,3.203,8.224,4.264,105.129,40.727,4.322,4.370
 3285.409,123.791,1122.705,113.334,-104.744,36.627,11.200,0.120,2.582,3.281,7.498,4.235,106.802,41.910,4.321,4.408
 3285.909,123.651,1113.281,117.532,-104.610,36.547,11.131,0.112,2.578,3.235,7.719,4.224,109.444,43.777,4.301,4.405
 3286.409,123.852,1118.018,125.270,-104.784,35.729,11.238,0.099,2.555,3.192,9.059,4.209,108.299,42.968,4.277,4.409
 3286.909,123.653,1115.723,130.111,-105.924,34.948,11.331,0.090,2.526,3.207,10.765,4.209,101.659,38.275,4.260,4.373
 3287.409,123.741,1113.477,130.340,-108.277,34.895,11.167,0.089,2.509,3.268,11.750,4.260,93.937,32.817,4.246,4.341
 3287.909,123.720,1131.104,125.562,-109.102,35.723,11.034,0.099,2.520,3.255,11.126,4.356,89.044,29.360,4.238,4.289
 3288.409,123.714,1118.164,122.947,-108.740,36.441,10.977,0.108,2.540,3.207,9.970,4.452,87.251,28.092,4.228,4.234
 3288.909,123.765,1115.283,124.835,-106.589,36.258,10.924,0.112,2.557,3.161,8.922,4.522,87.619,28.353,4.208,4.182
 3289.409,123.702,1123.047,127.207,-104.802,34.659,10.863,0.111,2.564,3.104,8.555,4.550,87.975,28.605,4.194,4.161
 3289.909,123.865,1123.047,124.848,-104.136,33.057,10.843,0.110,2.567,3.211,8.370,4.522,88.303,28.836,4.181,4.178
 3290.409,123.755,1131.982,122.371,-103.591,33.078,10.976,0.112,2.565,3.340,8.490,4.436,89.672,29.803,4.176,4.210
 3290.909,123.882,1127.930,123.443,-103.332,34.654,11.045,0.121,2.559,3.386,8.822,4.292,92.228,31.610,4.185,4.244
 3291.409,123.785,1126.904,124.265,-103.272,36.329,11.021,0.128,2.555,3.250,9.083,4.152,95.489,33.915,4.191,4.246
 3291.909,123.715,1126.660,125.634,-103.306,36.584,11.064,0.112,2.542,3.026,9.834,4.083,98.218,35.843,4.210,4.240
 3292.409,123.628,1123.047,124.585,-103.766,35.707,11.013,0.085,2.545,2.914,9.655,4.100,99.407,36.684,4.222,4.240
 3292.909,123.747,1126.904,125.467,-104.265,34.918,10.854,0.060,2.557,2.871,8.928,4.177,99.566,36.796,4.230,4.227
 3293.409,123.862,1119.678,127.573,-104.128,34.631,10.712,0.054,2.575,2.922,7.884,4.264,99.050,36.431,4.243,4.225
 3293.909,123.776,1123.047,126.630,-103.194,34.416,10.634,0.073,2.601,2.987,6.354,4.320,98.942,36.354,4.267,4.211
 3294.409,123.861,1124.805,124.468,-101.951,33.581,10.676,0.094,2.602,3.020,6.289,4.330,100.281,37.301,4.296,4.220
 3294.909,123.852,1127.930,120.891,-101.833,32.238,10.733,0.110,2.583,3.031,7.427,4.311,106.494,41.692,4.329,4.254
 3295.409,123.911,1123.047,115.556,-102.517,31.307,10.711,0.118,2.558,2.965,8.902,4.272,119.908,51.172,4.341,4.324
 3295.909,123.810,1127.588,111.544,-103.637,30.869,10.675,0.116,2.539,2.874,10.027,4.232,135.085,61.897,4.333,4.377
 3296.409,123.813,1127.930,110.902,-104.054,31.070,10.692,0.109,2.533,2.851,10.369,4.189,146.168,69.730,4.337,4.410
 3296.909,123.648,1123.145,115.701,-104.166,31.837,10.880,0.109,2.533,2.861,10.375,4.139,149.034,71.756,4.327,4.376
 3297.409,123.826,1113.281,122.883,-103.899,32.745,11.003,0.110,2.533,2.913,10.335,4.125,146.473,69.946,4.320,4.300
 3297.909,123.796,1123.047,125.495,-103.286,34.057,10.831,0.109,2.543,2.968,9.777,4.168,145.842,69.500,4.285,4.239
 3298.409,123.802,1114.990,123.947,-102.988,35.185,10.698,0.092,2.544,2.969,9.723,4.300,150.595,72.859,4.192,4.145
 3298.909,123.874,1109.082,119.952,-102.839,35.488,10.641,0.074,2.535,3.022,10.263,4.419,159.494,79.148,4.092,4.076
 3299.409,123.821,1115.234,113.532,-103.316,35.060,10.550,0.086,2.542,3.042,9.831,4.352,167.362,84.708,3.983,3.990
 3299.909,123.739,1127.930,108.559,-103.745,34.906,10.750,0.110,2.550,3.026,9.335,4.121,169.255,86.046,3.897,3.915
 3300.409,123.874,1121.582,105.283,-104.561,35.993,11.031,0.121,2.547,2.904,9.528,3.826,164.912,82.977,3.823,3.880
 3300.909,123.796,1114.111,104.552,-105.287,37.104,11.178,0.108,2.530,2.766,10.529,3.639,157.195,77.523,3.739,3.818
 3301.409,123.890,1118.164,107.570,-105.122,37.297,11.255,0.082,2.509,2.768,11.780,3.594,149.298,71.942,3.638,3.748
 3301.909,123.932,1117.090,114.784,-104.095,36.941,11.126,0.071,2.506,2.788,11.915,3.591,141.622,66.517,3.531,3.646
 3302.409,123.868,1113.281,121.926,-102.831,36.551,11.054,0.076,2.518,2.861,11.206,3.596,134.323,61.359,3.432,3.547
 3302.909,123.695,1118.164,123.187,-102.284,36.305,11.107,0.081,2.520,2.903,11.129,3.607,130.119,58.388,3.358,3.486
 3303.409,123.963,1122.021,118.579,-102.200,35.808,11.035,0.083,2.521,2.882,11.081,3.622,125.822,55.351,3.318,3.458
 3303.909,123.814,1120.020,114.535,-102.204,34.750,10.972,0.084,2.531,2.841,10.461,3.615,119.288,50.734,3.313,3.482
 3304.409,123.868,1121.484,116.014,-101.774,33.697,10.981,0.088,2.549,2.795,9.436,3.572,111.489,45.222,3.345,3.532
 3304.909,123.830,1127.930,120.358,-101.286,33.957,11.024,0.088,2.534,2.793,10.295,3.542,103.840,39.816,3.418,3.617
 3305.409,123.915,1127.930,124.986,-100.717,35.275,10.758,0.080,2.485,2.771,13.155,3.636,100.775,37.650,3.511,3.705
 3305.909,123.978,1125.928,123.790,-100.182,36.088,10.324,0.065,2.454,2.734,14.968,3.998,103.069,39.271,3.612,3.779
 3306.409,123.913,1123.047,122.912,-99.407,35.572,10.142,0.050,2.476,2.747,13.659,4.478,104.317,40.153,3.704,3.839
 3306.909,123.914,1125.293,122.511,-98.746,33.159,10.001,0.041,2.548,2.831,9.445,4.842,102.625,38.957,3.784,3.878
 3307.409,123.749,1127.930,121.119,-97.743,30.522,9.920,0.033,2.602,2.927,6.341,4.991,98.694,36.180,3.880,3.945
 3307.909,123.952,1122.949,119.722,-97.185,28.987,9.868,0.024,2.604,2.940,6.224,4.919,95.295,33.777,3.987,4.032
 3308.409,123.778,1118.164,115.972,-97.244,28.023,9.805,0.014,2.578,2.898,7.715,4.815,96.665,34.746,4.090,4.125
 3308.909,123.900,1118.164,114.645,-97.509,28.204,9.784,0.005,2.560,2.913,8.780,4.719,102.439,38.826,4.156,4.217
 3309.409,123.884,1127.539,116.670,-97.455,29.281,9.773,0.005,2.561,2.992,8.707,4.676,109.288,43.666,4.172,4.265
 3309.909,123.907,1117.188,121.764,-96.755,30.262,9.766,0.009,2.573,3.095,8.023,4.773,115.274,47.897,4.156,4.287
 3310.409,123.974,1112.012,122.240,-96.271,30.622,9.764,0.015,2.585,3.184,7.300,4.932,119.463,50.857,4.137,4.273
 3310.909,123.932,1109.863,121.461,-96.162,29.821,9.765,0.020,2.592,3.126,6.876,5.062,121.174,52.066,4.142,4.253
 3311.409,123.940,1127.930,120.702,-96.464,27.967,9.763,0.020,2.587,3.064,7.192,5.103,121.845,52.541,4.176,4.260
 3311.909,123.955,1127.930,117.954,-96.947,26.185,9.757,0.018,2.577,3.054,7.755,5.077,120.832,51.825,4.220,4.284
 3312.409,123.948,1137.695,115.232,-97.292,25.875,9.757,0.016,2.567,3.064,8.378,5.065,119.045,50.562,4.269,4.331
 3312.909,123.997,1126.709,108.701,-97.153,27.271,9.757,0.014,2.565,3.103,8.494,5.071,117.856,49.722,4.308,4.373
 3313.409,123.866,1120.410,105.540,-96.727,29.014,9.757,0.013,2.569,3.103,8.218,5.078,115.147,47.807,4.336,4.401
 3313.909,124.034,1113.281,107.879,-96.170,29.408,9.751,0.011,2.573,3.129,7.991,5.087,110.128,44.260,4.355,4.419
 3314.409,123.970,1134.570,115.419,-96.104,28.260,9.705,0.013,2.583,3.135,7.410,5.111,103.911,39.866,4.367,4.417
 3314.909,123.913,1127.930,125.428,-96.127,27.012,9.656,0.019,2.594,3.084,6.809,5.155,98.958,36.366,4.374,4.415
 3315.409,123.873,1127.930,129.202,-96.285,26.183,9.645,0.024,2.599,2.998,6.478,5.197,96.565,34.675,4.385,4.415
 3315.909,123.904,1123.584,126.585,-96.894,25.819,9.641,0.025,2.594,2.955,6.776,5.212,95.102,33.641,4.395,4.424
 3316.409,123.950,1123.047,122.326,-97.844,26.319,9.641,0.019,2.577,2.959,7.759,5.207,92.540,31.831,4.414,4.441
 3316.909,123.910,1118.457,122.444,-98.756,27.425,9.641,0.011,2.561,2.959,8.730,5.219,89.250,29.505,4.437,4.458
 3317.409,123.950,1118.164,123.752,-98.429,28.474,9.641,0.005,2.549,2.919,9.401,5.270,86.439,27.519,4.457,4.467
 3317.909,123.864,1118.164,125.599,-97.679,28.482,9.641,0.004,2.552,2.840,9.240,5.340,85.164,26.618,4.477,4.467
 3318.409,123.984,1128.027,124.094,-96.522,26.887,9.642,0.009,2.573,2.825,8.036,5.390,85.366,26.760,4.482,4.453
 3318.909,124.084,1118.164,119.702,-96.117,25.010,9.641,0.018,2.597,2.842,6.612,5.407,85.536,26.880,4.470,4.423
 3319.409,123.919,1118.164,119.620,-96.101,24.620,9.615,0.022,2.607,2.852,6.009,5.386,85.660,26.968,4.432,4.375
 3319.909,123.810,1118.164,121.190,-96.824,25.874,9.593,0.020,2.595,2.956,6.702,5.320,85.763,27.041,4.367,4.301
 3320.409,124.001,1118.164,128.403,-97.270,28.224,9.593,0.016,2.580,3.008,7.580,5.180,85.904,27.141,4.276,4.205
 3320.909,124.026,1123.047,133.453,-97.266,30.377,9.593,0.015,2.576,2.977,7.825,4.970,86.048,27.242,4.161,4.099
 3321.409,123.979,1123.047,133.355,-96.912,30.929,9.593,0.013,2.578,2.929,7.701,4.743,87.006,27.919,4.032,3.981
 3321.909,124.055,1125.684,131.796,-96.524,30.146,9.583,0.011,2.583,2.931,7.451,4.540,90.905,30.675,3.905,3.862
 3322.409,123.997,1117.188,130.913,-96.635,28.362,9.568,0.010,2.583,3.071,7.399,4.344,96.945,34.944,3.785,3.740
 3322.909,124.080,1111.768,133.006,-96.486,26.593,9.563,0.015,2.591,3.216,6.985,4.170,102.652,38.977,3.669,3.624
 3323.409,123.948,1130.371,132.593,-96.339,25.866,9.552,0.023,2.609,3.237,5.884,4.078,105.270,40.827,3.544,3.503
 3323.909,123.894,1118.164,127.927,-96.532,25.525,9.523,0.028,2.627,3.176,4.874,4.135,105.338,40.875,3.411,3.377
 3324.409,123.896,1125.977,121.671,-98.142,25.129,9.501,0.029,2.632,3.157,4.547,4.259,109.646,43.920,3.278,3.257
 3324.909,124.001,1118.164,117.512,-100.882,24.830,9.494,0.038,2.616,3.193,5.496,4.185,118.771,50.368,3.159,3.161
 3325.409,124.049,1118.164,119.920,-103.730,25.301,9.509,0.066,2.584,3.241,7.393,3.844,128.597,57.313,3.060,3.099
 3325.909,124.005,1129.736,125.869,-105.340,27.165,9.692,0.094,2.550,3.201,9.385,3.459,133.712,60.927,2.981,3.065
 3326.409,123.995,1128.467,128.871,-105.677,29.516,9.813,0.097,2.517,3.171,11.259,3.260,133.429,60.727,2.917,3.043
 3326.909,123.893,1129.980,130.683,-105.595,30.474,9.590,0.084,2.496,3.203,12.530,3.257,131.907,59.652,2.872,3.031
 3327.409,124.074,1119.043,130.918,-105.725,29.993,9.415,0.085,2.485,3.201,13.180,3.282,131.111,59.089,2.857,3.050
 3327.909,124.054,1123.047,131.309,-106.060,30.397,9.552,0.098,2.478,3.135,13.554,3.362,131.075,59.064,2.922,3.157
 3328.409,124.090,1123.047,129.017,-105.858,32.303,9.584,0.093,2.480,3.039,13.422,3.668,129.931,58.255,3.052,3.337
 3328.909,124.014,1125.439,125.517,-104.565,33.505,9.395,0.061,2.497,3.033,12.444,4.349,126.490,55.824,3.308,3.609
 3329.409,123.930,1123.047,128.340,-103.506,32.483,9.330,0.037,2.519,3.066,11.148,5.150,122.924,53.303,3.674,3.972
 3329.909,124.132,1131.250,142.645,-102.319,30.314,9.325,0.044,2.519,3.052,11.177,6.580,119.247,50.705,4.181,4.437
 3330.409,124.140,1123.047,167.930,-101.162,30.506,9.276,0.048,2.464,2.979,14.394,9.793,116.214,48.561,4.830,5.019
 3330.909,124.006,1123.047,195.022,-99.552,34.119,9.220,0.035,2.378,2.866,19.432,14.255,114.523,47.366,5.521,5.561
 3331.409,124.008,1127.930,210.228,-97.827,38.600,9.208,0.018,2.329,2.780,22.295,17.126,112.682,46.065,6.144,5.987
 3331.909,124.003,1124.707,204.324,-96.812,42.067,9.210,0.013,2.357,2.727,20.623,16.145,110.875,44.788,6.562,6.346
 3332.409,124.005,1124.805,183.110,-96.688,43.352,9.215,0.016,2.429,2.766,16.420,12.501,108.016,42.767,6.713,6.584
 3332.909,123.996,1132.813,158.164,-96.810,41.296,9.217,0.019,2.502,2.942,12.164,9.117,103.189,39.356,6.631,6.676
 3333.409,124.176,1123.047,144.125,-97.123,36.208,9.209,0.024,2.553,3.175,9.153,7.682,98.954,36.364,6.382,6.464
 3333.909,124.041,1126.709,136.606,-97.283,30.690,9.199,0.027,2.572,3.412,8.093,7.460,96.787,34.832,5.991,6.018
 3334.409,124.177,1125.195,129.798,-97.350,27.410,9.203,0.028,2.570,3.474,8.185,7.368,97.068,35.030,5.570,5.549
 3334.909,124.115,1118.164,123.772,-98.052,26.328,9.203,0.025,2.562,3.363,8.647,7.114,99.114,36.476,5.162,5.110
 3335.409,124.044,1132.813,121.598,-99.151,25.906,9.201,0.020,2.567,3.285,8.383,6.804,100.798,37.666,4.845,4.798
 3335.909,124.006,1132.813,122.328,-100.986,24.875,9.208,0.022,2.579,3.298,7.638,6.519,103.373,39.487,4.570,4.567
 3336.409,124.058,1127.930,119.826,-102.906,23.835,9.231,0.036,2.570,3.388,8.168,6.142,108.922,43.408,4.379,4.461
 3336.909,124.018,1127.930,114.364,-104.232,24.211,9.256,0.071,2.551,3.347,9.304,5.646,115.030,47.724,4.248,4.478
 3337.409,124.109,1127.930,109.774,-104.965,26.447,9.439,0.097,2.522,3.092,10.986,5.337,116.574,48.815,4.217,4.592
 3337.909,124.072,1127.930,113.623,-105.182,30.083,9.669,0.099,2.485,2.881,13.145,5.362,112.550,45.972,4.341,4.871
 3338.409,124.155,1125.635,121.700,-105.583,34.424,9.431,0.090,2.460,2.816,14.602,5.705,105.853,41.239,4.603,5.240
 3338.909,124.182,1132.715,123.224,-105.838,38.030,9.208,0.075,2.453,2.859,15.004,6.901,101.610,38.240,5.091,5.766
 3339.409,124.092,1130.273,111.590,-106.259,37.617,9.069,0.060,2.496,2.984,12.519,11.956,98.361,35.944,5.829,6.508
 3339.909,124.213,1123.242,90.045,-106.837,31.974,8.805,0.033,2.567,3.191,8.382,23.661,90.764,30.575,6.839,7.245
 3340.409,124.180,1127.930,67.600,-108.037,21.646,8.745,0.001,2.634,3.622,4.438,41.191,80.624,23.409,8.361,8.280
 3340.909,123.994,1127.930,50.017,-109.786,11.599,8.742,-0.011,2.681,4.159,1.709,53.663,73.723,18.532,9.980,8.981
 3341.409,124.146,1124.951,39.664,-111.502,5.530,8.744,-0.003,2.687,4.683,1.325,51.514,72.173,17.437,10.893,9.110
 3341.909,124.188,1125.098,41.671,-112.363,3.200,8.770,0.025,2.670,4.971,2.350,37.507,73.640,18.474,10.043,8.595
 3342.409,124.148,1137.695,57.055,-111.799,3.833,8.887,0.073,2.631,4.702,4.649,21.089,74.140,18.827,7.915,7.483
 3342.909,124.113,1132.813,82.067,-111.385,7.008,9.217,0.120,2.565,4.087,8.488,10.645,75.429,19.738,6.223,6.813
 3343.409,124.188,1136.279,104.425,-112.055,13.202,9.595,0.151,2.469,3.381,14.101,6.512,80.354,23.218,5.190,6.407
 3343.909,124.194,1131.689,113.446,-113.905,21.666,10.101,0.160,2.341,2.868,21.603,5.035,88.156,28.732,4.730,6.345
 3344.409,124.193,1127.930,108.607,-115.791,31.656,10.468,0.155,2.210,2.579,29.265,4.577,91.757,31.277,4.633,6.392
 3344.909,124.239,1124.414,95.585,-116.975,41.178,10.355,0.144,2.168,2.455,31.701,5.165,87.345,28.159,4.706,6.250
 3345.409,124.152,1127.930,80.244,-117.321,45.170,9.842,0.114,2.243,2.722,27.282,7.705,77.699,21.342,4.864,6.019
 3345.909,124.143,1131.152,64.081,-116.738,39.904,9.149,0.077,2.398,3.243,18.222,11.658,67.908,14.422,5.119,5.826
 3346.409,124.013,1125.244,50.323,-115.323,28.042,8.850,0.053,2.550,3.769,9.338,14.859,62.363,10.504,5.627,5.988
 3346.909,124.199,1124.902,42.148,-114.358,16.202,8.864,0.047,2.621,3.953,5.223,15.449,60.848,9.433,6.719,6.847
 3347.409,124.243,1136.719,39.282,-113.907,10.370,8.888,0.052,2.631,3.779,4.602,14.087,62.003,10.249,8.526,8.437
 3347.909,124.145,1132.813,39.738,-114.486,10.214,8.870,0.046,2.613,3.601,5.651,13.191,63.805,11.523,11.095,11.060
 3348.409,124.202,1137.451,41.568,-115.964,11.707,8.797,0.030,2.597,3.540,6.625,13.738,64.326,11.891,13.254,13.744
 3348.909,124.223,1130.811,41.109,-119.292,12.361,8.722,0.017,2.591,3.705,6.953,15.003,63.130,11.046,13.716,15.306
 3349.409,124.090,1123.047,37.886,-123.877,11.694,8.681,0.012,2.593,3.957,6.819,16.047,61.452,9.860,13.377,15.483
 3349.909,124.270,1132.813,31.045,-127.910,10.400,8.583,0.016,2.605,4.140,6.153,16.641,59.936,8.789,13.311,14.603
 3350.409,124.366,1137.695,26.030,-131.540,9.279,8.441,0.017,2.617,4.300,5.422,18.436,58.468,7.752,13.944,13.808
 3350.909,124.170,1137.695,26.013,-135.214,8.434,8.357,0.013,2.619,4.431,5.305,25.785,56.947,6.677,15.053,13.330
 3351.409,124.093,1127.930,26.189,-139.851,7.510,8.315,0.008,2.610,4.546,5.854,39.236,55.341,5.541,16.077,12.950
 3351.909,124.073,1127.930,24.065,-145.178,6.460,8.301,0.012,2.606,4.695,6.073,54.773,53.991,4.587,16.683,12.624
 3352.409,124.139,1135.645,21.219,-149.871,5.733,8.299,0.020,2.602,4.801,6.297,64.099,53.232,4.051,16.813,12.181
 3352.909,124.227,1126.318,20.068,-154.766,5.592,8.278,0.024,2.589,4.844,7.052,61.615,53.102,3.959,16.570,11.678
 3353.409,124.196,1128.857,21.091,-158.541,5.981,8.229,0.020,2.555,4.928,9.084,51.085,53.589,4.303,16.040,11.179
 3353.909,124.168,1136.279,23.889,-162.469,6.991,8.189,0.017,2.514,4.929,11.455,38.617,54.731,5.110,15.251,10.668
 3354.409,124.284,1136.523,25.560,-165.584,8.397,8.177,0.021,2.491,4.807,12.783,28.873,56.390,6.283,14.337,10.197
 3354.909,124.231,1129.102,26.425,-168.301,9.868,8.179,0.024,2.479,4.557,13.520,23.833,58.193,7.557,13.624,9.864
 3355.409,124.273,1123.047,24.968,-170.020,11.065,8.182,0.024,2.478,4.397,13.541,23.162,59.660,8.594,13.145,9.694
 3355.909,124.426,1127.002,22.064,-170.464,11.526,8.189,0.018,2.482,4.377,13.355,25.829,60.361,9.089,13.022,9.726
 3356.409,124.283,1127.930,19.068,-170.370,11.131,8.206,0.017,2.498,4.449,12.405,31.772,59.990,8.827,13.271,9.970
 3356.909,124.148,1127.930,17.130,-170.249,10.124,8.230,0.024,2.534,4.605,10.296,41.417,58.605,7.848,13.801,10.345
 3357.409,124.265,1129.785,18.400,-170.372,8.882,8.249,0.030,2.570,4.813,8.192,52.929,56.605,6.435,14.572,10.842
 3357.909,124.115,1119.482,19.998,-169.822,7.782,8.243,0.028,2.589,4.982,7.079,61.905,54.717,5.100,15.513,11.438
 3358.409,124.202,1126.563,20.070,-168.162,7.041,8.188,0.019,2.575,4.919,7.922,63.450,53.748,4.416,16.427,12.153
 3358.909,124.278,1133.057,18.244,-166.280,6.873,8.136,0.013,2.542,4.742,9.799,58.631,53.855,4.491,17.329,13.031
 3359.409,124.257,1137.695,16.142,-164.217,7.470,8.146,0.019,2.523,4.559,10.911,52.086,54.827,5.178,18.283,14.188
 3359.909,124.312,1127.930,15.289,-162.002,8.201,8.208,0.033,2.533,4.492,10.322,49.903,55.952,5.973,19.521,15.560
 3360.409,124.214,1128.223,16.641,-159.293,8.330,8.310,0.044,2.572,4.598,8.097,57.452,57.012,6.722,21.570,17.075
 3360.909,124.293,1133.057,19.097,-155.841,7.560,8.397,0.044,2.615,4.803,5.545,71.560,58.992,8.122,24.474,18.424
 3361.409,124.200,1137.695,21.829,-152.219,6.100,8.440,0.030,2.646,4.867,3.763,86.081,61.766,10.082,26.634,19.061
 3361.909,124.385,1136.719,23.281,-147.820,4.667,8.454,0.012,2.661,4.849,2.885,94.032,64.261,11.845,25.860,18.529
 3362.409,124.185,1133.984,23.828,-143.183,3.520,8.454,-0.000,2.665,4.808,2.617,88.647,65.239,12.537,22.513,17.476
 3362.909,124.238,1137.695,26.635,-139.074,2.671,8.455,-0.003,2.667,4.801,2.516,71.657,64.638,12.112,18.433,15.948
 3363.409,124.334,1127.881,36.219,-135.208,2.259,8.460,0.008,2.648,4.822,3.647,47.897,64.269,11.851,16.081,15.124
 3363.909,124.302,1137.695,51.268,-132.290,2.892,8.507,0.040,2.602,4.539,6.306,26.204,65.593,12.787,14.827,14.880
 3364.409,124.317,1137.695,70.199,-131.027,5.912,8.968,0.075,2.549,3.984,9.411,14.558,68.353,14.737,14.252,14.790
 3364.909,124.293,1126.563,82.141,-132.426,10.567,9.180,0.081,2.529,3.731,10.573,15.511,71.744,17.134,13.939,14.667
 3365.409,124.319,1137.695,77.717,-136.725,13.636,8.701,0.058,2.570,3.924,8.161,24.377,73.869,18.635,13.180,13.512
 3365.909,124.425,1133.447,66.078,-141.163,12.753,8.462,0.022,2.623,4.392,5.084,32.845,71.478,16.946,12.659,12.429
 3366.409,124.429,1130.957,52.977,-145.637,8.939,8.462,0.003,2.652,4.791,3.377,36.155,65.754,12.900,12.618,11.921
 3366.909,124.353,1137.695,48.756,-149.154,5.755,8.462,0.003,2.651,4.828,3.428,34.413,59.312,8.348,13.403,12.026
 3367.409,124.415,1137.695,51.476,-152.614,5.273,8.462,0.005,2.642,4.664,3.990,33.760,55.051,5.336,14.965,12.937
 3367.909,124.407,1127.930,51.795,-155.869,6.430,8.461,0.006,2.645,4.296,3.803,36.740,54.423,4.893,16.628,13.817
 3368.409,124.385,1127.930,48.242,-159.208,7.519,8.461,0.004,2.644,3.914,3.866,41.040,54.762,5.132,17.617,14.671
 3368.909,124.262,1139.795,43.143,-162.042,7.789,8.462,0.002,2.627,3.693,4.849,43.924,55.243,5.472,17.689,15.183
 3369.409,124.249,1142.578,40.547,-163.638,7.400,8.462,0.004,2.608,3.673,5.959,44.791,57.559,7.109,17.403,15.190
 3369.909,124.369,1145.313,41.856,-163.994,6.662,8.462,0.007,2.592,3.755,6.907,45.399,61.863,10.150,17.549,15.243
 3370.409,124.418,1142.578,43.084,-163.381,5.993,8.462,0.007,2.583,3.859,7.440,45.624,65.192,12.503,18.058,15.327
 3370.909,124.318,1142.578,42.719,-162.883,5.529,8.463,0.004,2.592,4.010,6.894,44.871,63.806,11.523,18.733,15.761
 3371.409,124.381,1137.695,42.407,-161.866,5.171,8.461,0.002,2.613,4.093,5.687,43.023,59.396,8.407,19.339,16.339
 3371.909,124.372,1137.695,42.424,-160.398,4.784,8.462,0.001,2.636,4.138,4.339,39.817,55.584,5.713,19.832,16.829
 3372.409,124.555,1138.184,43.404,-159.243,4.345,8.470,0.002,2.657,4.154,3.109,36.428,55.983,5.995,20.345,17.177
 3372.909,124.388,1142.578,43.781,-159.196,4.005,8.480,0.004,2.669,4.068,2.406,34.235,60.184,8.964,20.996,17.362
 3373.409,124.414,1141.846,43.116,-160.448,3.867,8.484,0.005,2.679,3.983,1.807,34.875,63.144,11.056,21.760,17.379
 3373.909,124.303,1147.510,42.760,-162.426,3.822,8.488,0.008,2.691,3.987,1.104,38.654,61.682,10.023,22.342,17.052
 3374.409,124.373,1137.695,42.939,-164.522,3.648,8.492,0.015,2.696,3.903,0.838,44.473,57.191,6.849,22.431,16.204
 3374.909,124.475,1144.727,42.197,-166.282,3.332,8.470,0.026,2.692,3.782,1.047,49.914,52.927,3.835,21.573,14.935
 3375.409,124.503,1148.682,40.958,-168.443,3.037,8.425,0.033,2.672,3.639,2.248,52.740,50.967,2.450,20.060,13.479
 3375.909,124.455,1152.344,40.437,-170.866,2.997,8.416,0.031,2.636,3.489,4.331,51.512,50.944,2.434,18.219,12.129
 3376.409,124.352,1146.045,41.038,-173.837,3.425,8.468,0.023,2.602,3.517,6.290,45.923,51.491,2.820,16.412,10.908
 3376.909,124.523,1142.578,41.177,-177.159,4.328,8.472,0.017,2.576,3.687,7.835,38.383,52.621,3.619,14.749,9.856
 3377.409,124.388,1141.016,40.249,-179.857,5.519,8.365,0.017,2.555,3.906,9.085,31.450,54.238,4.762,13.339,8.937
 3377.909,124.454,1138.965,39.004,-181.902,6.684,8.267,0.022,2.536,4.050,10.205,26.498,55.915,5.947,12.093,8.169
 3378.409,124.312,1139.600,37.107,-182.999,7.593,8.200,0.026,2.519,3.918,11.188,24.056,57.168,6.832,11.082,7.560
 3378.909,124.335,1147.021,33.177,-184.188,8.354,8.159,0.025,2.505,3.641,11.981,22.921,57.874,7.331,10.245,7.077
 3379.409,124.498,1147.461,29.552,-185.127,8.960,8.158,0.021,2.502,3.578,12.176,22.166,58.038,7.447,9.554,6.692
 3379.909,124.338,1147.461,27.121,-186.025,9.373,8.167,0.020,2.503,3.614,12.117,21.269,58.088,7.483,9.015,6.364
 3380.409,124.477,1132.910,27.988,-186.741,9.581,8.146,0.025,2.505,3.694,11.987,20.342,58.170,7.541,8.590,6.111
 3380.909,124.415,1128.076,30.016,-187.736,9.638,8.083,0.037,2.506,3.820,11.925,19.702,58.260,7.604,8.293,5.934
 3381.409,124.496,1139.990,32.926,-188.957,9.590,8.034,0.051,2.503,3.998,12.130,19.352,58.419,7.717,8.103,5.837
 3381.909,124.487,1142.578,35.782,-190.218,9.520,8.025,0.062,2.499,4.244,12.365,19.271,58.756,7.955,8.006,5.800
 3382.409,124.480,1139.746,35.788,-190.957,9.568,8.060,0.068,2.494,4.153,12.615,19.614,59.411,8.418,7.963,5.779
 3382.909,124.596,1133.350,35.189,-191.112,9.705,8.093,0.069,2.489,3.634,12.949,20.111,60.216,8.987,7.968,5.758
 3383.409,124.366,1137.695,35.095,-190.992,9.726,8.094,0.065,2.482,3.092,13.311,20.316,60.899,9.469,7.978,5.711
 3383.909,124.487,1141.846,35.295,-191.317,9.691,8.090,0.058,2.484,2.969,13.231,20.390,61.244,9.713,7.972,5.637
 3384.409,124.429,1144.336,35.461,-192.260,9.917,8.090,0.051,2.493,3.436,12.707,20.751,61.062,9.584,7.926,5.556
 3384.909,124.505,1148.438,33.245,-193.444,10.486,8.090,0.046,2.504,4.027,12.068,21.165,60.466,9.164,7.847,5.477
 3385.409,124.558,1141.650,30.148,-193.914,11.188,8.090,0.038,2.503,4.281,12.132,21.245,59.834,8.717,7.743,5.422
 3385.909,124.530,1136.475,27.698,-193.461,11.695,8.090,0.027,2.485,4.212,13.149,20.746,59.389,8.402,7.679,5.404
 3386.409,124.543,1136.572,26.768,-192.957,12.016,8.090,0.016,2.466,4.054,14.283,20.190,59.217,8.280,7.660,5.426
 3386.909,124.552,1142.578,26.409,-192.270,12.262,8.090,0.010,2.459,3.926,14.663,20.450,59.292,8.333,7.713,5.482
 3387.409,124.639,1134.570,25.015,-191.770,12.284,8.091,0.010,2.465,3.856,14.301,21.367,59.469,8.459,7.827,5.564
 3387.909,124.457,1132.813,24.375,-191.457,11.980,8.091,0.012,2.476,3.831,13.702,22.772,59.676,8.605,7.973,5.655
 3388.409,124.606,1132.813,25.447,-191.448,11.403,8.090,0.017,2.492,3.922,12.750,24.487,59.792,8.687,8.117,5.751
 3388.909,124.497,1142.578,30.362,-191.924,10.638,8.104,0.021,2.511,4.088,11.617,25.813,59.587,8.542,8.240,5.836
 3389.409,124.473,1147.070,35.576,-192.875,9.862,8.144,0.025,2.530,4.218,10.521,26.547,59.014,8.137,8.324,5.910
 3389.909,124.415,1143.164,39.902,-193.782,9.241,8.170,0.027,2.540,4.257,9.937,25.553,58.785,7.975,8.358,5.949
 3390.409,124.504,1156.641,42.731,-194.410,8.829,8.176,0.027,2.536,4.028,10.158,23.348,60.389,9.109,8.334,5.958
 3390.909,124.508,1157.227,44.625,-193.917,8.623,8.180,0.025,2.533,3.860,10.344,21.982,63.377,11.221,8.221,5.905
 3391.409,124.515,1157.031,47.270,-193.023,8.515,8.180,0.023,2.536,3.920,10.152,21.875,64.897,12.295,8.042,5.818
 3391.909,124.569,1140.332,48.414,-192.469,8.527,8.178,0.025,2.547,4.176,9.511,22.085,63.015,10.965,7.844,5.731
 3392.409,124.576,1142.578,49.487,-192.898,8.721,8.175,0.027,2.556,4.314,8.999,21.055,58.819,7.999,7.680,5.696
 3392.909,124.624,1145.459,49.691,-193.687,9.262,8.178,0.028,2.550,4.239,9.361,18.701,56.159,6.120,7.624,5.751
 3393.409,124.486,1147.461,48.560,-194.601,9.957,8.196,0.027,2.541,4.200,9.906,16.892,56.134,6.102,7.683,5.888
 3393.909,124.580,1153.613,45.882,-195.006,10.510,8.210,0.027,2.537,4.391,10.146,17.435,57.761,7.252,7.886,6.102
 3394.409,124.659,1152.344,42.103,-194.978,10.606,8.211,0.031,2.552,4.628,9.220,21.152,61.466,9.870,8.206,6.376
 3394.909,124.499,1149.023,38.687,-194.327,10.031,8.211,0.037,2.582,4.641,7.456,27.677,66.949,13.745,8.662,6.684
 3395.409,124.560,1147.461,36.706,-193.553,8.890,8.213,0.038,2.606,4.550,6.092,35.011,73.740,18.544,9.236,7.001
 3395.909,124.611,1147.461,36.475,-192.668,7.432,8.217,0.033,2.613,4.504,5.658,40.518,78.909,22.197,9.879,7.284
 3396.409,124.535,1156.006,36.731,-192.232,6.183,8.220,0.025,2.605,4.646,6.115,42.411,79.606,22.690,10.578,7.556
 3396.909,124.583,1148.535,36.883,-191.703,5.508,8.220,0.019,2.593,4.774,6.847,42.076,76.476,20.478,11.208,7.840
 3397.409,124.579,1148.926,37.558,-191.773,5.463,8.226,0.014,2.582,4.772,7.462,40.699,71.432,16.913,11.743,8.105
 3397.909,124.543,1132.080,38.765,-191.982,5.763,8.238,0.010,2.575,4.624,7.918,38.961,66.278,13.270,12.093,8.327
 3398.409,124.771,1142.578,37.837,-192.005,6.071,8.231,0.013,2.575,4.466,7.874,37.641,61.800,10.106,12.311,8.425
 3398.909,124.859,1146.826,34.625,-191.326,6.295,8.202,0.022,2.578,4.408,7.691,36.498,58.182,7.549,12.460,8.452
 3399.409,124.651,1144.531,31.818,-190.165,6.550,8.180,0.034,2.585,4.371,7.305,35.866,56.320,6.233,12.571,8.451
 3399.909,124.767,1147.461,30.950,-189.424,6.979,8.173,0.041,2.584,4.313,7.379,35.109,55.990,6.000,12.673,8.460
 3400.409,124.640,1137.695,31.070,-188.724,7.641,8.172,0.039,2.572,4.265,8.099,33.916,56.312,6.227,12.687,8.518
 3400.909,124.562,1137.695,30.843,-188.338,8.364,8.172,0.036,2.562,4.284,8.654,32.921,56.478,6.345,12.744,8.596
 3401.409,124.584,1142.480,31.167,-187.184,8.825,8.172,0.034,2.558,4.345,8.906,32.234,56.483,6.348,12.807,8.731
 3401.909,124.525,1147.461,31.111,-185.827,8.799,8.173,0.038,2.562,4.430,8.627,32.048,56.457,6.330,12.992,8.906
 3402.409,124.635,1150.098,30.365,-184.009,8.291,8.177,0.042,2.571,4.476,8.109,33.157,56.414,6.299,13.258,9.157
 3402.909,124.608,1147.119,29.094,-182.390,7.721,8.183,0.042,2.578,4.506,7.698,35.155,56.257,6.188,13.623,9.482
 3403.409,124.682,1142.578,29.651,-180.687,7.507,8.193,0.036,2.582,4.511,7.500,37.563,56.016,6.019,14.038,9.869
 3403.909,124.499,1144.189,31.265,-178.840,7.681,8.204,0.028,2.581,4.514,7.546,39.419,55.843,5.896,14.549,10.352
 3404.409,124.614,1154.102,30.272,-176.271,7.961,8.212,0.024,2.578,4.601,7.697,41.835,55.747,5.828,15.334,10.989
 3404.909,124.643,1150.781,29.995,-173.459,8.039,8.238,0.026,2.586,4.676,7.279,46.442,55.587,5.715,16.319,11.754
 3405.409,124.731,1145.947,30.049,-170.729,7.767,8.298,0.032,2.607,4.693,6.004,53.084,55.116,5.382,17.735,12.614
 3405.909,124.675,1162.109,30.564,-168.186,7.252,8.365,0.031,2.621,4.584,5.234,60.158,54.313,4.815,19.056,13.409
 3406.409,124.693,1151.416,33.767,-165.534,6.605,8.434,0.023,2.627,4.453,4.870,65.938,53.387,4.161,19.654,13.771
 3406.909,124.713,1140.234,39.436,-161.668,5.830,8.479,0.011,2.633,4.420,4.508,67.973,52.517,3.546,19.255,13.799
 3407.409,124.672,1147.461,45.478,-157.254,4.919,8.487,0.001,2.642,4.423,3.987,63.134,51.836,3.064,17.833,13.389
 3407.909,124.799,1150.830,49.537,-153.053,4.045,8.489,-0.003,2.645,4.459,3.781,50.190,52.162,3.294,16.521,13.074
 3408.409,124.644,1139.355,55.491,-149.904,3.742,8.493,0.012,2.642,4.423,3.996,33.427,54.473,4.928,15.715,13.099
 3408.909,124.778,1139.404,71.353,-148.573,4.756,8.532,0.035,2.635,4.278,4.414,20.729,58.118,7.504,15.381,13.304
 3409.409,124.605,1146.875,89.604,-149.444,7.084,8.572,0.044,2.621,4.282,5.209,18.438,60.926,9.488,15.526,13.659
 3409.909,124.713,1143.555,92.208,-152.374,9.297,8.426,0.034,2.613,4.368,5.653,27.687,60.483,9.175,15.473,13.387
 3410.409,124.755,1137.695,77.049,-156.517,9.926,8.253,0.014,2.599,4.519,6.491,41.078,57.561,7.110,15.422,12.777
 3410.909,124.728,1137.695,56.044,-160.708,8.808,8.214,0.008,2.591,4.677,6.981,50.809,54.651,5.054,15.511,12.302
 3411.409,124.772,1147.168,44.192,-164.235,7.338,8.208,0.009,2.580,4.664,7.624,53.338,53.406,4.174,15.842,11.972
 3411.909,124.755,1145.020,43.665,-167.663,6.801,8.213,0.007,2.560,4.648,8.791,49.689,53.884,4.511,16.588,12.025
 3412.409,124.729,1147.266,43.756,-170.658,7.080,8.221,0.008,2.550,4.568,9.351,44.566,54.730,5.110,17.117,11.990
 3412.909,124.769,1132.324,41.946,-173.703,7.515,8.217,0.021,2.564,4.526,8.524,40.338,55.223,5.458,16.989,11.842
 3413.409,124.816,1152.344,39.232,-177.134,7.844,8.210,0.036,2.588,4.553,7.110,37.887,55.391,5.577,16.421,11.669
 3413.909,124.819,1158.105,35.414,-180.626,8.162,8.210,0.040,2.598,4.618,6.561,36.347,55.504,5.657,15.606,11.348
 3414.409,124.798,1160.352,33.738,-183.360,8.415,8.210,0.036,2.590,4.654,7.020,34.920,55.734,5.819,14.959,11.048
 3414.909,124.789,1147.461,31.511,-184.692,8.522,8.209,0.030,2.570,4.613,8.196,33.576,56.111,6.085,14.548,10.767
 3415.409,124.778,1143.408,29.717,-185.393,8.498,8.209,0.034,2.562,4.606,8.660,32.749,56.438,6.316,14.291,10.625
 3415.909,124.782,1147.461,29.626,-186.356,8.448,8.209,0.036,2.559,4.591,8.856,32.407,56.750,6.537,14.190,10.646
 3416.409,124.733,1148.486,30.050,-187.834,8.515,8.209,0.028,2.544,4.537,9.689,32.670,56.872,6.623,14.221,10.824
 3416.909,124.740,1152.344,30.555,-189.656,8.578,8.229,0.017,2.534,4.389,10.295,34.472,57.591,7.131,14.424,11.124
 3417.409,124.782,1152.344,31.576,-191.264,8.401,8.302,0.009,2.537,4.277,10.127,38.061,60.603,9.260,14.834,11.567
 3417.909,124.805,1160.059,34.604,-192.405,7.937,8.392,0.011,2.557,4.248,8.949,43.045,65.073,12.419,15.503,12.141
 3418.409,124.780,1152.344,36.921,-192.724,7.429,8.429,0.016,2.578,4.299,7.691,48.732,69.041,15.223,16.361,12.877
 3418.909,124.747,1128.027,35.421,-192.569,7.113,8.422,0.016,2.590,4.423,7.012,55.044,70.634,16.349,17.423,13.761
 3419.409,124.850,1150.586,30.975,-192.368,6.817,8.416,0.012,2.590,4.456,6.996,60.696,70.116,15.983,18.553,14.724
 3419.909,124.706,1147.461,28.428,-191.907,6.298,8.426,0.009,2.593,4.366,6.841,64.042,71.252,16.786,19.595,15.612
 3420.409,124.841,1144.580,30.039,-191.118,5.533,8.438,0.007,2.597,4.139,6.618,65.293,77.211,20.997,20.341,16.164
 3420.909,124.672,1147.461,34.173,-189.923,4.712,8.450,0.007,2.610,3.948,5.876,65.386,85.552,26.892,20.632,16.359
 3421.409,124.810,1147.461,37.668,-189.556,4.060,8.469,0.007,2.618,3.929,5.396,65.242,92.391,31.725,20.427,16.248
 3421.909,124.808,1128.320,36.694,-190.303,3.658,8.486,0.005,2.611,4.031,5.771,62.598,95.114,33.650,19.858,15.926
 3422.409,124.656,1137.695,32.620,-191.573,3.614,8.473,0.003,2.595,3.943,6.725,57.067,93.900,32.792,19.177,15.586
 3422.909,124.774,1137.549,29.444,-192.654,3.933,8.423,0.003,2.582,3.881,7.497,51.047,91.458,31.066,18.537,15.212
 3423.409,124.769,1140.869,31.799,-192.639,4.606,8.389,0.008,2.582,3.802,7.457,45.847,86.624,27.650,18.002,14.869
 3423.909,124.731,1147.461,37.210,-192.159,5.310,8.387,0.012,2.581,3.727,7.560,43.862,80.293,23.175,17.617,14.565
 3424.409,124.851,1141.602,40.134,-191.703,5.699,8.383,0.011,2.574,3.859,7.945,44.357,74.487,19.072,17.240,14.252
 3424.909,124.855,1137.109,40.179,-191.933,5.647,8.354,0.005,2.562,4.037,8.641,45.808,70.253,16.080,16.975,13.975
 3425.409,124.828,1139.160,38.548,-192.631,5.240,8.329,-0.002,2.563,4.394,8.599,47.046,67.325,14.011,16.777,13.765
 3425.909,124.865,1157.227,36.584,-193.053,4.826,8.328,-0.006,2.571,4.552,8.148,47.366,64.418,11.956,16.640,13.547
 3426.409,124.814,1150.488,34.594,-192.974,4.688,8.326,-0.004,2.572,4.472,8.050,46.956,61.190,9.675,16.549,13.420
 3426.909,124.736,1149.121,32.466,-192.272,4.935,8.326,0.001,2.571,4.330,8.100,46.037,58.152,7.528,16.502,13.296
 3427.409,124.844,1137.695,29.696,-191.723,5.550,8.326,0.007,2.570,4.190,8.184,44.484,56.087,6.069,16.434,13.212
 3427.909,124.698,1140.332,27.597,-191.164,6.336,8.325,0.013,2.566,4.231,8.409,42.815,55.190,5.435,16.432,13.166
 3428.409,124.851,1147.461,25.052,-190.720,7.008,8.326,0.016,2.561,4.377,8.715,42.424,54.970,5.279,16.360,13.045
 3428.909,124.827,1145.947,25.103,-190.213,7.315,8.330,0.019,2.561,4.493,8.704,42.318,54.996,5.298,16.237,12.923
 3429.409,124.938,1146.680,26.676,-189.988,7.194,8.334,0.018,2.561,4.508,8.689,41.774,55.253,5.479,16.073,12.780
 3429.909,124.906,1147.461,28.274,-189.947,6.849,8.334,0.016,2.558,4.416,8.903,40.466,56.248,6.182,15.938,12.715
 3430.409,124.891,1138.770,30.684,-190.046,6.634,8.336,0.013,2.544,4.248,9.733,38.633,59.289,8.331,15.929,12.801
 3430.909,125.015,1146.582,31.032,-189.879,6.779,8.351,0.007,2.522,4.141,10.991,37.664,63.998,11.659,16.116,13.076
 3431.409,124.745,1152.344,32.723,-189.364,7.085,8.386,0.008,2.524,4.123,10.876,38.459,67.766,14.322,16.484,13.514
 3431.909,124.982,1147.461,35.862,-188.679,7.226,8.452,0.013,2.558,4.261,8.907,43.322,67.578,14.189,17.017,14.031
 3432.409,124.789,1147.461,38.730,-188.467,7.097,8.529,0.016,2.595,4.409,6.697,51.358,64.424,11.961,17.526,14.482
 3432.909,124.836,1147.461,40.825,-188.952,6.684,8.577,0.011,2.613,4.536,5.677,59.888,61.483,9.882,18.009,14.870
 3433.409,124.984,1142.578,39.275,-189.485,6.172,8.598,0.003,2.620,4.608,5.276,65.029,62.699,10.741,18.322,15.148
 3433.909,124.841,1142.578,34.995,-189.118,5.816,8.603,0.000,2.626,4.576,4.917,63.828,67.844,14.378,18.615,15.401
 3434.409,124.970,1138.867,30.466,-187.675,5.711,8.606,0.004,2.633,4.552,4.524,58.984,71.910,17.251,18.871,15.662
 3434.909,124.782,1152.344,28.376,-185.741,5.754,8.608,0.007,2.630,4.596,4.676,53.908,73.111,18.100,19.283,16.058
 3435.409,124.918,1157.227,29.576,-183.768,5.753,8.609,0.008,2.611,4.759,5.779,51.059,72.505,17.671,19.891,16.675
 3435.909,124.930,1160.400,30.369,-181.831,5.641,8.610,0.013,2.597,4.868,6.585,50.473,71.732,17.125,20.631,17.502
 3436.409,124.797,1159.619,28.810,-179.984,5.465,8.611,0.019,2.596,4.768,6.680,52.512,71.672,17.082,21.555,18.417
 3436.909,124.872,1157.715,26.183,-178.217,5.206,8.587,0.023,2.607,4.648,6.035,59.785,72.129,17.406,22.615,19.394
 3437.409,124.855,1152.344,24.754,-177.259,4.821,8.637,0.024,2.628,4.836,4.782,69.072,72.257,17.496,23.695,20.302
 3437.909,124.785,1156.006,25.179,-176.337,4.431,8.696,0.023,2.643,5.244,3.889,74.494,74.343,18.970,24.722,21.228
 3438.409,124.856,1163.037,26.796,-175.669,4.292,8.657,0.022,2.649,5.418,3.563,73.696,76.886,20.767,25.531,22.248
 3438.909,124.920,1152.344,28.115,-174.183,4.472,8.637,0.018,2.644,5.161,3.833,69.277,79.099,22.332,26.174,23.220
 3439.409,124.922,1150.586,27.865,-171.653,4.835,8.637,0.009,2.632,4.739,4.549,66.976,82.563,24.780,26.786,24.229
 3439.909,125.050,1153.125,27.333,-168.466,5.081,8.642,0.002,2.619,4.476,5.340,67.769,86.279,27.406,27.241,24.814
 3440.409,124.843,1154.150,26.669,-165.309,4.909,8.644,-0.001,2.609,4.513,5.921,70.958,90.900,30.671,27.541,25.185
 3440.909,124.956,1165.918,25.349,-162.722,4.414,8.639,0.003,2.611,4.569,5.789,74.274,95.017,33.581,27.782,25.481
 3441.409,124.989,1162.988,27.252,-160.471,3.863,8.628,0.013,2.629,4.377,4.755,72.327,95.976,34.259,27.863,26.060
 3441.909,124.818,1152.637,33.977,-158.112,3.477,8.591,0.024,2.654,4.196,3.301,63.009,96.283,34.476,28.291,27.214
 3442.409,124.892,1152.344,42.418,-155.522,3.430,8.552,0.030,2.679,4.127,1.840,50.164,97.735,35.502,28.990,29.011
 3442.909,125.009,1152.344,48.303,-153.338,3.620,8.541,0.031,2.695,4.250,0.868,42.545,99.593,36.815,30.291,31.197
 3443.409,124.987,1152.246,48.539,-151.583,3.862,8.540,0.028,2.696,4.314,0.839,45.473,100.277,37.298,32.078,33.794
 3443.909,124.872,1147.900,46.268,-150.582,3.884,8.539,0.023,2.686,4.120,1.416,60.395,96.952,34.948,34.177,36.152
 3444.409,125.053,1164.844,44.977,-150.399,3.510,8.538,0.020,2.685,3.958,1.482,96.408,91.137,30.839,37.004,39.095
 3444.909,124.953,1142.578,42.548,-150.697,2.922,8.533,0.020,2.699,4.025,0.668,141.701,87.621,28.354,40.416,42.185
 3445.409,124.996,1145.557,38.514,-151.732,2.286,8.527,0.019,2.709,4.446,0.036,178.972,88.570,29.025,45.151,46.035
 3445.909,125.050,1152.344,35.737,-153.177,1.760,8.526,0.017,2.708,4.923,0.132,193.658,91.847,31.340,50.885,50.644
 3446.409,124.995,1152.344,33.559,-155.339,1.407,8.521,0.016,2.699,5.107,0.650,185.532,92.923,32.101,56.604,55.151
 3446.909,125.057,1157.227,32.802,-157.305,1.194,8.506,0.015,2.691,4.941,1.098,176.232,88.284,28.823,61.101,59.745
 3447.409,124.871,1164.063,32.598,-158.756,1.108,8.496,0.016,2.685,4.537,1.438,176.759,79.987,22.959,63.449,62.450
 3447.909,125.121,1164.746,31.827,-159.417,1.108,8.495,0.016,2.679,4.265,1.786,184.720,73.306,18.237,63.684,63.189
 3448.409,125.059,1146.240,33.931,-160.159,1.166,8.495,0.016,2.677,4.274,1.931,190.593,71.289,16.812,63.751,63.115
 3448.909,125.084,1146.533,36.485,-161.977,1.235,8.495,0.017,2.684,4.426,1.501,187.348,73.713,18.525,62.995,61.735
 3449.409,124.868,1157.227,37.552,-164.283,1.282,8.495,0.016,2.692,4.597,1.076,178.004,76.856,20.746,62.510,60.698
 3449.909,125.096,1162.109,38.792,-166.632,1.370,8.495,0.012,2.690,4.670,1.170,166.516,80.170,23.088,60.833,58.236
 3450.409,125.011,1166.260,39.445,-168.757,1.564,8.492,0.008,2.684,4.623,1.504,154.270,82.859,24.988,58.685,55.684
 3450.909,124.991,1147.461,38.955,-169.981,1.857,8.482,0.007,2.673,4.603,2.143,140.843,82.879,25.003,56.303,52.907
 3451.409,125.129,1147.461,36.755,-170.886,2.165,8.473,0.008,2.654,4.400,3.301,128.297,79.679,22.741,53.969,50.200
 3451.909,124.924,1162.891,34.596,-171.418,2.338,8.471,0.014,2.637,3.944,4.294,122.064,75.333,19.670,52.246,47.771
 3452.409,125.037,1157.227,36.137,-171.491,2.309,8.471,0.022,2.642,3.614,3.995,121.062,71.290,16.812,50.542,45.370
 3452.909,124.950,1161.816,39.664,-171.077,2.061,8.471,0.027,2.663,3.673,2.766,118.748,67.095,13.848,49.510,43.665
 3453.409,124.953,1166.992,40.606,-170.063,1.762,8.475,0.030,2.692,4.140,1.056,109.970,64.338,11.900,48.549,42.149
 3453.909,124.968,1162.109,41.881,-169.393,1.641,8.484,0.030,2.710,4.636,0.003,95.314,64.252,11.839,47.661,40.911
 3454.409,125.180,1152.539,46.058,-169.947,1.722,8.490,0.025,2.711,4.771,-0.056,84.959,66.091,13.138,46.370,39.413
 3454.909,125.067,1157.227,49.489,-171.351,1.923,8.491,0.018,2.707,4.717,0.170,89.230,66.784,13.628,44.874,37.716
 3455.409,125.011,1157.666,48.551,-172.541,2.059,8.491,0.011,2.700,4.694,0.594,97.226,64.005,11.665,43.458,35.797
 3455.909,125.035,1156.152,41.620,-173.375,2.052,8.493,0.008,2.697,4.716,0.751,97.999,58.805,7.989,41.495,33.210
 3456.409,124.980,1162.109,34.383,-174.572,2.003,8.497,0.012,2.700,4.870,0.613,89.810,54.204,4.738,39.318,30.209
 3456.909,125.120,1158.887,31.030,-176.620,2.071,8.501,0.014,2.691,5.003,1.114,78.412,52.432,3.485,36.472,26.791
 3457.409,125.105,1162.109,30.847,-179.165,2.394,8.502,0.014,2.669,5.039,2.398,72.312,53.041,3.916,32.697,23.512
 3457.909,124.929,1158.643,33.127,-181.787,3.073,8.502,0.011,2.636,4.879,4.340,67.444,54.038,4.620,28.912,20.675
 3458.409,124.999,1158.350,35.357,-183.834,4.074,8.500,0.009,2.604,4.604,6.190,60.612,54.947,5.263,25.270,18.289
 3458.909,125.006,1162.109,36.647,-185.414,5.264,8.498,0.012,2.591,4.381,6.984,52.593,55.806,5.870,22.539,16.293
 3459.409,125.123,1166.992,36.155,-186.228,6.474,8.495,0.016,2.591,4.253,6.972,46.007,56.462,6.334,20.340,14.603
 3459.909,125.023,1159.180,35.242,-186.622,7.513,8.494,0.019,2.598,4.197,6.569,42.687,56.673,6.483,18.568,13.116
 3460.409,125.102,1160.449,33.538,-187.205,8.184,8.496,0.017,2.596,4.137,6.678,41.492,56.538,6.388,16.917,11.813
 3460.909,124.986,1171.143,30.573,-188.035,8.555,8.496,0.015,2.588,4.108,7.116,40.058,56.418,6.303,15.287,10.644
 3461.409,124.970,1162.109,27.966,-189.354,8.774,8.487,0.015,2.576,4.112,7.831,37.054,56.568,6.409,13.705,9.607
 3461.909,125.108,1166.504,26.239,-190.866,8.943,8.456,0.020,2.566,4.084,8.445,33.034,56.980,6.699,12.297,8.748
 3462.409,125.057,1157.227,27.433,-192.691,9.107,8.415,0.024,2.551,4.019,9.324,29.220,57.520,7.081,11.173,8.095
 3462.909,125.071,1157.227,29.216,-193.867,9.266,8.398,0.023,2.529,3.982,10.585,26.365,58.221,7.577,10.294,7.615
 3463.409,125.111,1154.639,30.295,-194.195,9.609,8.383,0.021,2.510,4.053,11.689,25.014,58.981,8.114,9.695,7.284
 3463.909,124.950,1152.393,31.251,-193.604,10.167,8.331,0.021,2.503,4.174,12.097,24.726,59.497,8.478,9.246,7.045
 3464.409,125.119,1162.500,31.189,-193.176,10.681,8.292,0.025,2.522,4.276,11.013,24.774,59.542,8.510,8.991,6.910
 3464.909,125.072,1171.484,32.846,-192.982,11.004,8.290,0.027,2.545,4.313,9.642,24.694,59.226,8.287,8.856,6.869
 3465.409,125.138,1162.109,36.063,-193.196,11.050,8.290,0.020,2.555,4.354,9.075,24.987,58.754,7.954,8.872,6.915
 3465.909,125.142,1161.670,37.304,-193.588,10.976,8.296,0.012,2.550,4.427,9.341,26.344,58.290,7.625,8.966,6.984
 3466.409,125.123,1157.227,38.327,-193.931,10.979,8.294,0.011,2.531,4.487,10.463,29.047,57.970,7.399,9.096,7.006
 3466.909,125.204,1161.426,38.190,-194.390,11.118,8.265,0.020,2.505,4.457,12.008,31.547,58.084,7.480,9.192,6.971
 3467.409,125.170,1166.895,36.389,-194.624,11.663,8.207,0.031,2.472,4.303,13.941,32.105,58.750,7.951,9.192,6.868
 3467.909,125.276,1170.020,34.649,-194.814,13.044,8.156,0.036,2.441,4.183,15.752,30.473,59.730,8.643,9.094,6.733
 3468.409,125.263,1162.109,33.216,-194.762,15.047,8.135,0.036,2.431,4.105,16.319,27.382,60.696,9.326,8.858,6.554
 3468.909,125.125,1162.109,33.276,-193.895,16.665,8.130,0.035,2.436,4.102,16.034,24.564,61.444,9.855,8.540,6.339
 3469.409,125.206,1169.531,33.813,-192.770,17.355,8.130,0.034,2.447,4.134,15.366,22.909,61.949,10.211,8.216,6.133
 3469.909,125.207,1163.477,32.659,-191.973,17.278,8.129,0.031,2.453,4.162,15.035,22.282,62.229,10.409,7.928,5.964
 3470.409,125.261,1166.992,30.002,-192.174,16.936,8.130,0.023,2.444,4.198,15.572,22.186,62.315,10.470,7.758,5.881
 3470.909,125.165,1170.264,26.656,-193.093,16.649,8.130,0.018,2.433,4.176,16.181,22.049,62.324,10.476,7.721,5.907
 3471.409,125.230,1171.143,25.054,-193.883,16.483,8.130,0.019,2.424,4.189,16.697,21.976,62.412,10.539,7.798,6.018
 3471.909,125.171,1173.730,25.565,-193.913,16.689,8.130,0.017,2.415,4.210,17.269,22.687,62.616,10.683,8.040,6.257
 3472.409,125.135,1167.969,27.474,-193.331,17.352,8.120,0.014,2.411,4.190,17.470,24.463,62.748,10.776,8.404,6.583
 3472.909,125.168,1166.992,27.054,-192.435,17.557,8.192,0.011,2.424,4.105,16.710,27.394,62.449,10.564,8.946,7.021
 3473.409,125.263,1166.992,24.732,-192.058,16.451,8.273,0.015,2.465,4.062,14.328,30.557,61.577,9.948,9.659,7.568
 3473.909,125.256,1166.992,24.720,-192.112,13.886,8.267,0.020,2.518,4.232,11.234,34.705,59.968,8.811,10.571,8.211
 3474.409,125.332,1166.992,27.164,-192.149,10.816,8.292,0.022,2.565,4.518,8.480,40.116,58.027,7.440,11.608,8.966
 3474.909,125.207,1167.188,31.847,-191.272,8.520,8.354,0.020,2.590,4.727,7.003,46.199,56.179,6.134,12.760,9.766
 3475.409,125.218,1171.631,34.328,-190.262,7.286,8.393,0.014,2.597,4.738,6.636,52.575,54.666,5.064,13.894,10.576
 3475.909,125.205,1169.775,34.008,-189.425,6.937,8.398,0.008,2.595,4.609,6.752,57.516,53.703,4.384,15.019,11.302
 3476.409,125.187,1166.992,34.154,-189.047,6.899,8.398,0.001,2.583,4.477,7.399,60.135,53.190,4.021,16.035,11.932
 3476.909,125.110,1166.992,34.674,-188.295,6.933,8.398,-0.001,2.578,4.454,7.728,59.646,53.331,4.121,16.907,12.446
 3477.409,125.308,1170.508,35.572,-187.228,6.941,8.388,0.001,2.577,4.486,7.760,56.395,54.066,4.640,17.612,12.873
 3477.909,125.314,1162.109,35.718,-186.264,6.972,8.374,0.003,2.581,4.482,7.566,52.193,55.112,5.380,18.124,13.271
 3478.409,125.236,1167.920,34.743,-185.805,7.142,8.373,0.003,2.583,4.404,7.399,49.130,55.974,5.989,18.566,13.648
 3478.909,125.347,1171.875,33.912,-185.681,7.459,8.394,0.002,2.580,4.288,7.586,47.276,56.390,6.283,18.895,14.063
 3479.409,125.245,1174.219,32.499,-185.418,7.748,8.422,0.002,2.577,4.155,7.776,46.580,56.301,6.220,19.402,14.510
 3479.909,125.362,1181.641,31.575,-184.648,7.921,8.441,0.005,2.581,4.170,7.539,47.260,55.807,5.871,19.875,15.000
 3480.409,125.112,1171.875,30.211,-183.308,7.881,8.477,0.012,2.597,4.410,6.608,49.402,55.233,5.465,20.555,15.610
 3480.909,125.207,1167.920,29.648,-181.955,7.567,8.538,0.017,2.612,4.666,5.730,53.001,55.327,5.531,21.334,16.399
 3481.409,125.173,1162.109,29.088,-180.869,7.034,8.584,0.017,2.617,4.807,5.442,58.436,55.577,5.708,22.220,17.432
 3481.909,125.211,1170.508,30.497,-180.171,6.394,8.610,0.013,2.619,4.738,5.343,65.792,55.214,5.452,23.418,18.761
 3482.409,125.273,1173.047,31.661,-179.026,5.852,8.639,0.011,2.627,4.634,4.853,74.068,54.258,4.776,24.802,20.304
 3482.909,125.169,1166.992,30.712,-177.119,5.500,8.657,0.014,2.641,4.610,4.023,80.911,53.104,3.960,26.758,22.145
 3483.409,125.370,1176.074,30.663,-174.573,5.190,8.658,0.016,2.647,4.605,3.675,86.234,52.869,3.794,28.972,24.357
 3483.909,125.329,1177.002,32.257,-171.677,4.766,8.659,0.014,2.646,4.568,3.770,93.226,54.912,5.238,31.872,27.011
 3484.409,125.319,1176.758,36.322,-168.884,4.163,8.659,0.009,2.650,4.553,3.495,106.964,59.552,8.517,35.273,30.393
 3484.909,125.134,1171.875,38.970,-166.090,3.407,8.658,0.006,2.662,4.592,2.783,126.476,64.168,11.779,39.297,34.138
 3485.409,125.313,1176.758,41.469,-163.601,2.591,8.659,0.004,2.671,4.598,2.286,147.870,67.073,13.833,43.597,38.186
 3485.909,125.170,1176.270,42.214,-161.862,1.931,8.659,0.004,2.676,4.667,2.014,167.158,66.334,13.311,48.224,42.326
 3486.409,125.297,1172.559,40.033,-160.311,1.537,8.662,0.010,2.683,4.702,1.579,180.426,62.707,10.747,52.782,46.351
 3486.909,125.296,1175.781,36.415,-159.528,1.330,8.666,0.018,2.691,4.742,1.124,183.905,60.998,9.540,56.911,50.489
 3487.409,125.262,1173.047,35.322,-158.426,1.263,8.668,0.023,2.693,4.744,0.982,174.804,65.803,12.935,60.354,54.267
 3487.909,125.294,1171.875,36.974,-157.015,1.293,8.668,0.022,2.692,4.639,1.031,161.373,76.019,20.155,62.465,57.185
 3488.409,125.327,1178.418,37.343,-154.895,1.433,8.668,0.018,2.693,4.564,1.017,153.387,86.187,27.341,64.098,58.886
 3488.909,125.329,1179.785,33.508,-152.774,1.578,8.668,0.016,2.699,4.510,0.637,152.225,88.871,29.238,64.522,59.562
 3489.409,125.313,1171.875,27.156,-151.477,1.620,8.669,0.018,2.700,4.414,0.593,150.913,83.183,25.218,64.256,59.615
 3489.909,125.212,1157.227,24.164,-150.762,1.550,8.671,0.016,2.681,4.124,1.697,142.995,77.388,21.122,63.660,60.029
 3490.409,125.378,1157.227,24.860,-150.493,1.436,8.675,0.016,2.660,3.752,2.925,130.905,77.421,21.146,62.577,60.788
 3490.909,125.235,1166.992,29.732,-150.124,1.390,8.677,0.019,2.655,3.401,3.218,122.995,83.378,25.355,62.356,62.097
 3491.409,125.364,1170.947,33.011,-149.411,1.395,8.679,0.022,2.665,3.371,2.623,121.947,89.381,29.598,61.798,63.124
 3491.909,125.328,1166.895,33.769,-148.010,1.389,8.680,0.024,2.688,3.832,1.299,123.700,89.647,29.786,62.088,63.226
 3492.409,125.423,1165.625,33.251,-145.683,1.376,8.680,0.021,2.707,4.470,0.172,121.380,86.685,27.692,60.921,61.920
 3492.909,125.284,1157.227,32.106,-143.406,1.417,8.680,0.018,2.711,4.878,-0.049,112.344,86.608,27.638,58.135,57.655
 3493.409,125.345,1157.227,32.068,-140.611,1.579,8.680,0.016,2.699,4.839,0.615,101.656,93.657,32.620,52.584,51.979
 3493.909,125.391,1162.109,30.167,-138.146,1.785,8.680,0.016,2.687,4.577,1.329,92.875,106.185,41.474,45.028,44.980
 3494.409,125.389,1162.109,30.007,-135.537,1.919,8.680,0.022,2.694,4.486,0.923,82.751,115.827,48.287,38.525,39.254
 3494.909,125.359,1159.570,38.017,-133.153,2.052,8.680,0.029,2.703,4.365,0.417,66.468,116.762,48.948,33.350,35.365
 3495.409,125.375,1171.875,53.847,-131.294,2.437,8.679,0.028,2.691,4.119,1.117,48.463,113.135,46.385,29.999,32.801
 3495.909,125.329,1166.699,95.902,-129.264,3.887,8.679,0.020,2.637,3.875,4.262,36.766,109.347,43.708,28.055,31.966
 3496.409,125.196,1167.480,203.467,-127.141,7.286,8.679,0.015,2.558,3.533,8.871,34.052,106.733,41.861,27.085,31.223
 3496.909,125.370,1176.758,349.562,-125.237,13.613,8.679,0.014,2.505,3.374,11.963,39.475,103.280,39.420,27.050,31.407
 3497.409,125.425,1166.016,418.376,-124.141,19.532,8.678,0.013,2.507,3.320,11.898,49.168,98.063,35.733,27.788,31.831
 3497.909,125.280,1157.227,352.452,-124.079,20.373,8.679,0.009,2.558,3.243,8.901,66.487,95.015,33.580,29.474,33.013
 3498.409,125.439,1165.527,207.092,-124.024,15.897,8.685,0.009,2.619,3.373,5.314,87.604,95.586,33.983,32.314,35.129
 3498.909,125.378,1160.498,93.566,-123.499,8.890,8.703,0.012,2.656,3.594,3.185,104.449,98.567,36.090,35.719,37.378
 3499.409,125.459,1162.109,48.681,-122.632,3.929,8.731,0.012,2.673,3.927,2.178,108.967,100.188,37.235,38.986,39.671
 3499.909,125.360,1162.109,32.555,-121.394,2.084,8.761,0.009,2.687,4.283,1.317,98.775,99.963,37.076,40.274,40.562
 3500.409,125.387,1166.992,27.894,-120.220,1.493,8.791,0.007,2.692,4.401,1.056,81.918,100.025,37.120,38.892,39.278
 3500.909,125.243,1163.232,29.247,-118.944,1.409,8.816,0.007,2.687,4.424,1.328,64.697,100.501,37.456,35.875,36.936
 3501.409,125.403,1163.525,33.987,-117.583,1.703,8.843,0.010,2.683,4.395,1.594,49.847,101.397,38.090,32.825,34.483
 3501.909,125.498,1166.992,43.465,-116.362,2.389,8.867,0.013,2.680,4.385,1.731,38.898,102.912,39.161,30.552,32.754
 3502.409,125.388,1165.332,53.816,-115.417,3.323,8.885,0.011,2.672,4.364,2.247,33.843,104.510,40.290,29.403,31.684
 3502.909,125.466,1162.109,58.230,-115.619,4.113,8.900,0.005,2.661,4.251,2.851,35.669,104.220,40.085,28.769,30.534
 3503.409,125.401,1165.918,52.401,-116.007,4.300,8.911,-0.001,2.657,4.121,3.086,44.279,100.848,37.702,28.774,29.364
 3503.909,125.444,1171.875,42.554,-116.301,3.894,8.921,-0.003,2.663,4.052,2.737,56.194,95.951,34.241,28.937,28.318
 3504.409,125.355,1176.758,38.814,-115.517,3.156,8.937,0.001,2.682,4.219,1.650,66.096,92.326,31.679,29.397,27.584
 3504.909,125.480,1167.383,41.566,-114.638,2.541,8.956,0.005,2.693,4.438,1.022,68.418,91.227,30.902,30.032,27.360
 3505.409,125.350,1162.012,47.348,-114.112,2.258,8.979,0.006,2.693,4.524,0.966,61.627,90.746,30.563,30.221,27.082
 3505.909,125.515,1166.992,52.459,-114.074,2.260,9.006,0.005,2.687,4.476,1.336,51.556,86.916,27.856,29.716,26.772
 3506.409,125.480,1172.168,56.212,-113.991,2.584,9.032,0.003,2.680,4.340,1.760,43.748,79.098,22.330,28.519,26.469
 3506.909,125.555,1166.992,58.339,-113.483,3.046,9.055,0.003,2.681,4.222,1.692,39.953,72.584,17.727,27.083,25.892
 3507.409,125.445,1166.992,60.686,-112.708,3.479,9.078,0.002,2.682,4.074,1.628,37.952,73.253,18.200,26.446,25.202
 3507.909,125.471,1171.875,65.274,-111.484,3.825,9.101,0.001,2.679,3.977,1.824,36.190,78.902,22.192,25.654,23.785
 3508.409,125.353,1171.875,66.991,-110.268,4.100,9.128,-0.001,2.675,3.942,2.050,36.136,83.658,25.553,23.956,21.133
 3508.909,125.541,1167.725,62.770,-109.468,4.279,9.152,-0.001,2.676,4.043,1.964,37.371,83.280,25.287,20.826,17.961
 3509.409,125.527,1171.875,55.236,-109.021,4.204,9.175,-0.000,2.682,4.184,1.638,37.084,78.715,22.060,16.817,14.509
 3509.909,125.325,1168.945,50.606,-108.790,3.978,9.208,0.009,2.683,4.290,1.600,32.065,74.411,19.019,13.352,11.845
 3510.409,125.454,1160.791,56.441,-108.377,4.080,9.265,0.036,2.663,4.241,2.755,22.552,72.357,17.567,10.825,9.993
 3510.909,125.443,1162.109,70.774,-108.423,5.447,9.422,0.068,2.630,3.832,4.692,13.855,73.257,18.203,9.076,8.772
 3511.409,125.335,1165.869,88.697,-108.748,8.880,9.633,0.080,2.603,3.288,6.251,9.072,75.342,19.676,7.874,7.954
 3511.909,125.493,1162.109,102.028,-109.089,13.787,9.614,0.065,2.603,2.863,6.271,7.811,77.031,20.870,6.961,7.223
 3512.409,125.364,1166.113,107.556,-109.400,18.242,9.515,0.034,2.609,2.726,5.889,8.055,78.095,21.622,6.301,6.603
 3512.909,125.400,1175.049,106.704,-109.802,20.419,9.524,0.015,2.606,2.763,6.090,8.491,77.977,21.539,5.867,6.133
 3513.409,125.615,1171.875,103.812,-110.447,20.430,9.548,0.013,2.599,2.738,6.464,8.766,77.011,20.856,5.658,5.859
 3513.909,125.415,1174.854,105.335,-111.360,19.660,9.573,0.014,2.593,2.624,6.867,8.788,75.698,19.928,5.647,5.794
 3514.409,125.569,1167.383,104.496,-112.178,19.164,9.589,0.018,2.595,2.499,6.744,8.743,74.261,18.912,5.738,5.831
 3514.909,125.441,1169.141,101.315,-112.634,19.063,9.610,0.025,2.606,2.414,6.097,8.722,73.824,18.603,5.837,5.906
 3515.409,125.334,1176.611,99.223,-112.244,18.906,9.632,0.030,2.620,2.412,5.244,8.705,73.931,18.679,5.841,5.930
 3515.909,125.550,1181.641,98.927,-110.728,18.642,9.647,0.032,2.635,2.507,4.362,8.725,74.228,18.889,5.714,5.833
 3516.409,125.558,1181.641,104.122,-108.727,18.532,9.661,0.030,2.641,2.683,4.008,8.632,74.863,19.338,5.514,5.671
 3516.909,125.414,1181.641,111.340,-106.824,18.987,9.673,0.028,2.636,2.863,4.300,8.244,76.100,20.212,5.293,5.467
 3517.409,125.487,1181.934,118.669,-105.113,20.394,9.680,0.031,2.635,2.882,4.388,7.616,77.920,21.499,5.105,5.305
 3517.909,125.487,1183.643,127.291,-103.446,22.813,9.680,0.035,2.635,2.761,4.401,6.913,79.933,22.921,4.956,5.195
 3518.409,125.505,1181.641,130.427,-102.423,25.179,9.672,0.035,2.638,2.693,4.221,6.465,81.619,24.113,4.839,5.107
 3518.909,125.398,1187.793,128.933,-103.095,26.507,9.666,0.028,2.628,2.756,4.782,6.448,84.889,26.423,4.755,5.033
 3519.409,125.473,1176.758,127.376,-104.963,26.581,9.666,0.021,2.605,2.862,6.145,6.784,90.031,30.057,4.654,4.895
 3519.909,125.411,1173.438,124.430,-107.417,25.640,9.668,0.023,2.572,2.945,8.068,7.204,95.774,34.116,4.538,4.741
 3520.409,125.353,1166.211,121.237,-109.465,24.489,9.726,0.047,2.533,2.969,10.333,7.330,99.979,37.088,4.355,4.580
 3520.909,125.469,1181.641,118.169,-110.625,24.186,10.245,0.090,2.502,2.912,12.191,7.065,99.088,36.458,4.200,4.498
 3521.409,125.488,1184.082,116.059,-111.290,25.120,11.181,0.134,2.476,2.869,13.705,6.550,94.839,33.455,4.092,4.560
 3521.909,125.509,1180.566,118.799,-112.111,26.457,11.074,0.169,2.448,2.819,15.301,5.985,91.581,31.153,4.108,4.745
 3522.409,125.562,1178.711,122.460,-113.125,28.112,10.352,0.177,2.366,2.815,20.112,5.584,93.052,32.192,4.269,5.126
 3522.909,125.601,1175.928,127.128,-114.056,32.347,10.256,0.164,2.254,2.761,26.639,5.756,97.454,35.303,4.578,5.584
 3523.409,125.564,1171.875,143.506,-114.273,39.057,10.434,0.121,2.210,2.800,29.265,8.468,95.255,33.749,5.035,6.086
 3523.909,125.471,1180.371,158.968,-114.015,42.123,9.971,0.067,2.293,3.278,24.396,17.171,84.550,26.184,5.644,6.560
 3524.409,125.478,1184.570,168.427,-114.363,35.509,9.302,0.029,2.471,4.042,13.950,36.936,70.520,16.269,6.567,7.136
 3524.909,125.499,1181.641,171.229,-114.942,22.197,9.187,0.010,2.623,4.760,5.104,64.947,61.018,9.554,8.045,8.255
 3525.409,125.557,1186.035,164.276,-115.924,10.048,9.176,0.009,2.682,4.970,1.665,92.333,59.122,8.213,10.837,10.436
 3525.909,125.505,1181.934,156.248,-116.281,3.773,9.169,0.008,2.685,4.886,1.477,110.415,59.427,8.429,15.525,14.347
 3526.409,125.469,1184.033,138.188,-116.635,2.007,9.167,0.011,2.684,4.759,1.506,115.853,59.433,8.433,23.341,20.763
 3526.909,125.608,1181.543,112.149,-117.035,1.531,9.167,0.016,2.690,4.639,1.197,113.156,61.081,9.598,31.612,28.540
 3527.409,125.600,1176.758,87.994,-117.472,1.573,9.168,0.021,2.700,4.615,0.595,104.942,66.738,13.596,34.533,32.958
 3527.909,125.551,1177.100,68.824,-117.869,1.762,9.169,0.021,2.700,4.590,0.583,96.126,73.801,18.587,31.850,30.008
 3528.409,125.641,1181.641,58.781,-117.550,1.936,9.168,0.018,2.696,4.643,0.836,87.386,79.844,22.858,27.572,24.155
 3528.909,125.526,1180.029,53.754,-116.620,1.997,9.168,0.017,2.696,4.643,0.821,76.113,82.822,24.963,23.460,19.247
 3529.409,125.681,1173.242,52.287,-115.135,2.025,9.168,0.017,2.697,4.583,0.762,58.707,84.142,25.896,19.732,16.085
 3529.909,125.472,1175.977,60.078,-113.656,2.302,9.170,0.017,2.688,4.376,1.262,38.250,86.532,27.585,16.530,13.834
 3530.409,125.630,1181.982,75.848,-113.010,3.290,9.174,0.014,2.664,3.945,2.686,22.482,89.944,29.996,13.784,12.026
 3530.909,125.473,1171.875,94.744,-112.708,5.202,9.177,0.010,2.640,3.623,4.100,14.980,92.421,31.747,11.510,10.442
 3531.409,125.562,1175.439,108.896,-112.826,7.689,9.179,0.008,2.623,3.572,5.085,12.805,92.253,31.627,9.796,9.176
 3531.909,125.482,1182.910,118.035,-112.877,10.037,9.186,0.009,2.611,3.669,5.778,11.727,89.788,29.885,8.623,8.318
 3532.409,125.607,1186.523,127.751,-113.538,11.984,9.193,0.011,2.596,3.539,6.687,10.292,86.981,27.902,7.998,7.871
 3532.909,125.651,1181.641,135.066,-115.966,14.295,9.198,0.014,2.589,3.199,7.069,8.858,85.495,26.852,7.807,7.754
 3533.409,125.624,1177.588,138.929,-119.943,17.076,9.186,0.014,2.596,2.951,6.645,8.682,84.025,25.813,7.876,7.709
 3533.909,125.726,1176.758,130.713,-125.438,18.499,9.107,0.008,2.603,3.167,6.285,12.562,79.806,22.831,8.065,7.608
 3534.409,125.487,1181.055,106.397,-131.552,17.120,9.008,0.001,2.605,3.776,6.116,21.267,72.229,17.476,8.274,7.427
 3534.909,125.668,1181.641,73.762,-137.818,13.010,8.965,-0.001,2.599,4.336,6.486,30.827,63.852,11.556,8.522,7.296
 3535.409,125.533,1195.264,44.749,-144.194,8.758,8.943,-0.000,2.584,4.595,7.378,36.355,57.515,7.078,8.872,7.308
 3535.909,125.546,1186.523,33.269,-149.913,6.849,8.927,0.003,2.558,4.563,8.877,35.327,55.159,5.412,9.301,7.417
 3536.409,125.437,1186.523,32.952,-154.286,6.935,8.918,0.009,2.533,4.416,10.344,31.964,55.350,5.548,9.661,7.531
 3536.909,125.526,1181.641,33.228,-158.342,8.137,8.915,0.018,2.526,4.341,10.770,30.826,56.421,6.304,9.764,7.532
 3537.409,125.618,1176.953,31.565,-160.715,9.168,8.907,0.031,2.540,4.337,9.932,31.084,57.064,6.759,9.578,7.426
 3537.909,125.575,1186.523,29.333,-161.987,9.533,8.886,0.039,2.557,4.357,8.931,30.018,57.270,6.905,9.280,7.290
 3538.409,125.650,1181.641,28.003,-162.732,9.586,8.848,0.040,2.561,4.357,8.716,27.083,57.347,6.959,9.067,7.212
 3538.909,125.705,1181.641,29.952,-162.020,9.654,8.811,0.035,2.557,4.359,8.935,23.926,57.436,7.022,9.079,7.294
 3539.409,125.625,1181.641,32.530,-162.147,9.657,8.825,0.028,2.552,4.399,9.214,22.999,57.301,6.926,9.309,7.564
 3539.909,125.729,1181.641,34.202,-161.183,9.134,8.854,0.023,2.564,4.480,8.560,26.517,56.512,6.369,9.790,8.070
 3540.409,125.565,1182.471,37.050,-159.028,7.913,8.859,0.021,2.592,4.666,6.875,33.817,55.095,5.368,10.535,8.826
 3540.909,125.650,1189.893,39.907,-155.686,6.153,8.859,0.017,2.629,4.778,4.723,42.551,53.287,4.090,11.627,9.856
 3541.409,125.656,1189.355,45.608,-151.431,4.347,8.859,0.014,2.664,4.856,2.703,50.104,51.673,2.949,13.130,11.196
 3541.909,125.576,1181.641,55.718,-146.812,2.889,8.859,0.008,2.671,4.932,2.269,54.712,50.658,2.232,15.092,12.850
 3542.409,125.657,1171.875,64.579,-142.200,2.008,8.859,0.006,2.669,4.948,2.419,57.518,50.293,1.974,17.303,14.678
 3542.909,125.716,1171.875,73.787,-137.976,1.638,8.859,0.009,2.669,4.949,2.414,60.355,50.418,2.062,19.321,16.284
 3543.409,125.585,1185.010,80.977,-134.230,1.543,8.859,0.013,2.675,4.903,2.036,60.898,53.257,4.068,20.419,17.091
 3543.909,125.658,1181.641,81.386,-130.998,1.617,8.860,0.015,2.681,4.741,1.706,55.487,59.695,8.619,20.118,16.943
 3544.409,125.703,1168.750,75.551,-127.510,2.034,8.862,0.014,2.673,4.428,2.136,43.424,67.461,14.107,18.573,15.981
 3544.909,125.550,1180.469,67.547,-123.755,2.940,8.865,0.012,2.657,4.042,3.111,29.979,74.166,18.845,16.458,14.789
 3545.409,125.631,1181.641,63.959,-119.690,4.492,8.867,0.012,2.642,3.862,3.982,21.370,77.569,21.250,14.495,13.673
 3545.909,125.500,1186.182,69.099,-116.362,6.334,8.868,0.017,2.638,3.946,4.184,17.577,79.323,22.490,13.085,12.944
 3546.409,125.691,1188.721,92.437,-113.913,8.025,8.869,0.026,2.634,3.979,4.464,15.493,85.196,26.640,12.373,12.761
 3546.909,125.722,1191.406,154.115,-112.129,10.072,8.869,0.034,2.597,3.832,6.604,14.541,93.223,32.313,12.254,13.006
 3547.409,125.722,1186.523,291.911,-110.669,15.493,8.848,0.037,2.507,3.523,11.847,18.459,99.511,36.757,12.704,13.686
 3547.909,125.737,1172.168,433.666,-109.953,25.634,8.806,0.031,2.416,3.251,17.193,28.614,101.441,38.121,13.624,14.564
 3548.409,125.741,1187.012,461.391,-110.084,34.782,8.779,0.019,2.408,3.361,17.686,49.106,96.146,34.379,15.210,15.922
 3548.909,125.816,1191.406,366.797,-110.632,35.379,8.774,0.015,2.497,3.761,12.470,75.730,87.884,28.540,17.624,17.889
 3549.409,125.714,1188.477,204.533,-111.273,25.216,8.775,0.019,2.618,4.346,5.405,100.636,76.225,20.300,21.150,20.671
 3549.909,125.720,1181.641,89.967,-111.977,12.211,8.775,0.021,2.687,4.784,1.354,114.895,64.476,11.997,25.389,23.820
 3550.409,125.710,1178.467,49.418,-112.289,4.438,8.774,0.016,2.690,4.878,1.171,113.199,55.650,5.759,28.236,26.058
 3550.909,125.710,1187.354,37.558,-112.200,2.156,8.775,0.009,2.676,4.848,1.972,98.541,51.178,2.599,28.790,27.096
 3551.409,125.747,1191.406,35.060,-112.298,1.914,8.777,0.012,2.675,4.756,2.052,74.710,51.350,2.721,27.078,26.975
 3551.909,125.721,1178.906,38.508,-112.667,2.213,8.772,0.019,2.667,4.521,2.516,50.240,53.914,4.533,25.048,25.838
 3552.409,125.810,1190.137,44.738,-113.472,3.024,8.758,0.022,2.646,4.249,3.762,33.235,57.483,7.055,23.074,23.913
 3552.909,125.599,1190.088,50.725,-113.912,4.265,8.737,0.020,2.627,4.077,4.829,28.524,60.995,9.537,20.743,20.933
 3553.409,125.826,1182.666,55.223,-114.319,5.240,8.720,0.017,2.631,4.149,4.614,31.695,63.782,11.507,18.232,18.040
 3553.909,125.804,1180.127,58.558,-115.362,5.382,8.718,0.021,2.657,4.377,3.090,33.312,65.987,13.065,16.098,16.025
 3554.409,125.616,1172.656,59.940,-117.144,4.950,8.718,0.028,2.680,4.572,1.776,29.960,68.846,15.085,14.811,15.118
 3554.909,125.683,1201.172,62.074,-118.039,4.932,8.718,0.033,2.681,4.618,1.724,22.855,73.941,18.686,14.435,15.351
 3555.409,125.819,1192.480,68.477,-118.918,6.166,8.718,0.032,2.663,4.447,2.758,17.080,80.544,23.353,14.763,16.122
 3555.909,125.681,1179.639,74.045,-120.426,8.449,8.710,0.029,2.655,4.322,3.213,18.649,84.136,25.891,15.369,16.960
 3556.409,125.740,1176.758,71.716,-122.737,10.280,8.693,0.027,2.669,4.246,2.390,26.793,82.879,25.003,16.070,17.338
 3556.909,125.826,1174.121,58.454,-125.267,10.119,8.682,0.025,2.691,4.211,1.084,37.505,78.572,21.959,16.886,17.637
 3557.409,125.727,1191.113,42.668,-127.205,8.308,8.682,0.027,2.715,4.235,-0.267,44.857,75.404,19.720,18.146,18.324
 3557.909,125.855,1188.916,36.112,-128.723,5.962,8.683,0.026,2.715,4.301,-0.321,45.355,75.684,19.918,20.304,19.812
 3558.409,125.736,1191.553,32.650,-129.903,4.394,8.683,0.024,2.710,4.458,0.005,41.921,78.586,21.969,22.860,21.809
 3558.909,125.721,1196.289,29.002,-130.462,3.935,8.683,0.022,2.711,4.510,-0.032,37.857,82.366,24.640,24.692,23.091
 3559.409,125.702,1231.055,26.961,-131.234,3.992,8.683,0.020,2.715,4.396,-0.291,34.824,84.610,26.226,24.508,23.019
 3559.909,125.607,1184.570,27.404,-131.916,4.212,8.682,0.014,2.713,4.244,-0.156,32.699,84.410,26.085,22.239,20.808
 3560.409,125.724,1185.889,28.584,-131.807,4.360,8.681,0.009,2.704,4.042,0.356,30.025,82.280,24.579,19.203,17.799
 3560.909,125.719,1191.162,29.403,-130.212,4.421,8.681,0.010,2.701,3.809,0.525,25.662,80.783,23.522,15.912,14.713
 3561.409,125.705,1181.641,31.278,-127.177,4.622,8.682,0.015,2.701,3.636,0.504,20.804,83.402,25.372,13.037,12.120
 3561.909,125.680,1188.477,35.306,-123.691,5.073,8.683,0.019,2.695,3.640,0.858,16.493,90.595,30.456,10.710,10.266
 3562.409,125.829,1176.758,41.658,-120.634,5.606,8.683,0.019,2.666,3.673,2.575,13.189,96.699,34.770,9.111,9.038
 3562.909,125.835,1176.758,50.046,-118.179,6.393,8.683,0.019,2.622,3.496,5.128,10.603,97.978,35.674,8.119,8.380
 3563.409,125.852,1182.568,59.987,-117.053,7.968,8.683,0.024,2.590,3.117,7.013,8.641,94.428,33.164,7.531,7.994
 3563.909,125.877,1171.875,67.399,-116.704,10.417,8.682,0.025,2.581,2.869,7.533,8.606,89.621,29.767,7.173,7.673
 3564.409,125.752,1186.523,68.767,-116.448,12.442,8.681,0.021,2.595,3.020,6.746,10.598,89.078,29.384,6.921,7.369
 3564.909,125.829,1182.422,71.263,-116.041,12.708,8.680,0.015,2.611,3.389,5.803,12.484,93.572,32.560,6.805,7.150
 3565.409,125.729,1181.641,85.303,-114.952,11.343,8.680,0.016,2.615,3.568,5.584,12.594,97.566,35.382,6.872,7.235
 3565.909,125.706,1168.604,111.782,-113.845,10.179,8.680,0.022,2.605,3.383,6.138,11.454,97.272,35.174,7.174,7.562
 3566.409,125.868,1191.406,134.078,-112.632,10.499,8.680,0.024,2.592,3.185,6.912,11.081,92.690,31.936,7.597,8.029
 3566.909,125.790,1182.227,135.400,-111.482,11.184,8.680,0.020,2.584,3.132,7.358,12.296,87.314,28.137,8.030,8.425
 3567.409,125.817,1179.395,113.060,-110.366,10.871,8.680,0.016,2.593,3.249,6.857,13.775,87.757,28.450,8.264,8.680
 3567.909,125.801,1176.758,86.530,-109.620,9.809,8.680,0.016,2.603,3.431,6.260,14.171,93.465,32.484,8.403,8.928
 3568.409,125.901,1174.268,76.517,-109.178,9.191,8.680,0.016,2.607,3.495,6.028,13.301,102.019,38.529,8.542,9.223
 3568.909,125.863,1166.992,76.895,-108.636,9.619,8.681,0.016,2.611,3.469,5.799,12.442,109.104,43.537,8.804,9.551
 3569.409,126.008,1177.930,80.296,-107.936,10.667,8.681,0.013,2.612,3.474,5.754,12.547,112.015,45.594,9.105,9.803
 3569.909,125.734,1194.727,79.377,-107.032,11.367,8.680,0.009,2.613,3.496,5.698,13.292,111.364,45.134,9.334,9.970
 3570.409,125.862,1176.758,77.061,-106.525,11.310,8.677,0.006,2.609,3.622,5.894,14.026,107.551,42.439,9.462,10.120
 3570.909,125.743,1186.523,78.085,-106.118,10.706,8.671,0.006,2.611,3.726,5.790,14.398,102.693,39.005,9.560,10.281
 3571.409,125.830,1186.523,79.107,-106.704,10.186,8.668,0.013,2.628,3.790,4.811,14.521,98.520,36.056,9.803,10.574
 3571.909,125.771,1176.758,81.997,-107.109,10.355,8.668,0.021,2.641,3.797,4.043,14.463,97.667,35.454,10.153,10.969
 3572.409,126.013,1180.176,85.973,-107.007,11.195,8.668,0.024,2.638,3.707,4.212,14.619,101.164,37.925,10.613,11.451
 3572.909,125.760,1185.010,89.621,-106.469,12.071,8.664,0.020,2.623,3.609,5.080,15.287,104.321,40.156,11.075,12.040
 3573.409,125.789,1192.627,91.194,-105.860,12.298,8.655,0.013,2.614,3.566,5.638,16.737,104.083,39.988,11.528,12.561
 3573.909,125.932,1186.523,84.812,-105.785,11.684,8.645,0.011,2.623,3.800,5.072,18.618,100.235,37.269,12.003,13.109
 3574.409,125.739,1182.617,75.894,-105.725,10.593,8.641,0.010,2.631,4.136,4.614,20.070,95.839,34.162,12.583,13.590
 3574.909,125.797,1186.523,70.372,-105.598,9.577,8.641,0.013,2.632,4.225,4.534,20.599,96.491,34.623,13.224,14.138
 3575.409,125.918,1186.523,70.380,-105.492,8.754,8.641,0.016,2.624,3.988,5.028,20.156,101.120,37.894,13.911,14.820
 3575.909,125.779,1191.406,73.410,-105.955,8.237,8.640,0.014,2.612,3.684,5.705,19.678,105.815,41.212,14.529,15.608
 3576.409,125.931,1195.752,74.802,-106.559,8.044,8.639,0.010,2.612,3.608,5.721,20.060,108.392,43.033,15.181,16.573
 3576.909,125.926,1181.934,74.755,-107.285,8.098,8.639,0.009,2.624,3.722,5.047,21.446,107.572,42.454,15.846,17.571
 3577.409,125.868,1185.059,76.344,-107.732,8.168,8.638,0.015,2.640,3.838,4.078,23.127,105.802,41.203,16.735,18.673
 3577.909,125.959,1181.641,82.415,-107.694,8.027,8.636,0.021,2.641,3.798,4.015,24.888,104.995,40.633,17.863,19.963
 3578.409,125.839,1196.143,84.909,-107.993,7.785,8.633,0.021,2.632,3.704,4.588,28.050,104.036,39.955,19.222,21.277
 3578.909,125.881,1193.994,79.986,-108.877,7.433,8.626,0.013,2.622,3.767,5.142,34.388,102.500,38.869,20.688,22.710
 3579.409,125.918,1200.391,72.937,-110.113,6.847,8.621,0.004,2.625,3.926,4.970,41.616,100.641,37.556,22.276,24.101
 3579.909,125.947,1178.906,69.629,-110.816,5.928,8.621,0.004,2.648,4.151,3.618,45.898,101.226,37.969,23.931,25.761
 3580.409,125.821,1177.197,70.132,-110.923,4.936,8.621,0.008,2.665,4.243,2.641,46.975,104.199,40.070,25.840,27.808
 3580.909,125.927,1190.576,70.485,-110.391,4.387,8.621,0.012,2.667,4.187,2.508,46.376,107.069,42.098,27.787,30.064
 3581.409,126.008,1196.289,68.772,-109.853,4.362,8.621,0.013,2.660,4.144,2.908,46.415,108.291,42.962,29.348,31.972
 3581.909,125.810,1193.066,64.954,-109.345,4.657,8.621,0.013,2.658,4.084,3.063,48.007,106.258,41.525,30.426,33.207
 3582.409,125.980,1191.406,61.686,-108.950,4.970,8.621,0.014,2.664,4.103,2.713,49.617,103.864,39.833,30.778,33.917
 3582.909,125.990,1191.406,61.453,-108.424,5.090,8.621,0.012,2.666,4.120,2.545,50.490,106.321,41.570,30.815,34.105
 3583.409,125.986,1179.004,64.844,-108.247,4.991,8.621,0.009,2.671,4.094,2.308,50.205,113.952,46.962,31.024,34.415
 3583.909,125.913,1190.186,68.726,-108.757,4.822,8.621,0.007,2.668,4.147,2.431,48.668,122.471,52.983,31.334,34.535
 3584.409,125.802,1191.406,68.489,-109.978,4.751,8.621,0.004,2.656,4.321,3.183,48.053,125.789,55.328,31.880,34.981
 3584.909,125.932,1195.313,66.385,-111.267,4.836,8.621,-0.000,2.635,4.505,4.412,48.920,121.439,52.254,32.427,35.834
 3585.409,125.989,1186.523,64.330,-111.434,4.964,8.621,-0.004,2.617,4.593,5.412,50.769,113.893,46.921,32.770,36.615
 3585.909,126.000,1186.523,64.050,-110.935,4.994,8.621,-0.005,2.616,4.581,5.517,52.290,107.593,42.469,33.139,37.532
 3586.409,125.855,1188.330,66.688,-110.343,4.946,8.621,-0.001,2.627,4.618,4.852,51.844,104.353,40.179,33.449,37.909
 3586.909,125.965,1191.406,70.754,-110.720,4.887,8.621,0.006,2.645,4.697,3.790,50.753,103.001,39.223,33.778,38.132
 3587.409,125.914,1196.289,76.193,-111.652,4.896,8.621,0.008,2.656,4.722,3.156,50.267,102.537,38.896,34.363,38.606
 3587.909,125.993,1187.012,80.588,-112.404,4.983,8.621,0.006,2.656,4.726,3.157,51.570,102.132,38.609,34.783,39.057
 3588.409,126.082,1191.113,77.176,-113.141,4.970,8.621,0.001,2.653,4.746,3.339,55.706,101.600,38.233,35.507,40.022
 3588.909,125.804,1186.621,70.884,-112.949,4.816,8.621,0.001,2.654,4.837,3.287,59.726,101.179,37.936,36.417,41.234
 3589.409,125.933,1186.523,67.536,-112.896,4.548,8.621,0.010,2.672,4.927,2.235,61.470,101.001,37.810,37.836,42.982
 3589.909,126.073,1196.094,68.508,-114.614,4.346,8.621,0.020,2.688,4.843,1.282,62.099,101.167,37.928,40.083,45.691
 3590.409,126.011,1191.406,71.993,-114.443,4.313,8.621,0.021,2.691,4.637,1.093,65.641,101.131,37.902,42.517,48.609
 3590.909,126.044,1192.285,70.509,-114.037,4.275,8.621,0.013,2.687,4.537,1.350,74.533,100.458,37.426,45.203,51.704
 3591.409,126.011,1195.215,64.618,-112.116,4.013,8.621,0.004,2.683,4.558,1.587,86.109,99.567,36.796,47.435,54.052
 3591.909,126.113,1192.090,63.387,-110.939,3.527,8.623,-0.000,2.683,4.584,1.567,95.418,98.861,36.297,49.401,55.633
 3592.409,126.040,1189.844,69.218,-111.606,3.028,8.624,-0.000,2.687,4.562,1.367,101.868,98.379,35.957,51.171,57.370
 3592.909,126.091,1191.406,71.661,-113.033,2.688,8.629,0.002,2.690,4.569,1.152,105.895,97.851,35.584,53.246,59.293
 3593.409,125.936,1205.273,66.400,-113.634,2.591,8.633,0.005,2.696,4.629,0.845,108.216,96.287,34.478,55.456,61.347
 3593.909,126.194,1194.043,56.185,-113.547,2.652,8.636,0.007,2.697,4.658,0.772,108.911,92.353,31.698,57.623,62.952
 3594.409,126.019,1186.523,50.651,-112.779,2.804,8.636,0.007,2.691,4.580,1.100,107.392,88.130,28.714,59.067,63.919
 3594.909,125.975,1199.805,52.475,-112.829,3.000,8.636,0.004,2.682,4.482,1.656,107.145,87.108,27.992,59.534,63.902
 3595.409,125.891,1188.379,55.948,-113.342,3.103,8.636,-0.001,2.672,4.542,2.226,109.997,89.834,29.918,59.414,63.381
 3595.909,126.140,1188.135,59.714,-113.430,3.040,8.636,-0.002,2.673,4.638,2.140,113.409,94.070,32.912,58.963,61.858
 3596.409,125.960,1195.557,62.582,-113.107,2.870,8.636,0.001,2.683,4.662,1.593,114.233,95.122,33.655,57.965,59.621
 3596.909,126.078,1196.289,64.075,-112.796,2.698,8.637,0.004,2.691,4.571,1.131,110.504,91.392,31.019,57.239,57.727
 3597.409,126.130,1196.289,64.160,-112.580,2.608,8.640,0.005,2.690,4.463,1.147,104.772,87.361,28.170,56.429,55.910
 3597.909,125.988,1196.289,64.156,-113.012,2.676,8.648,0.005,2.690,4.410,1.175,101.920,85.851,27.103,55.816,54.547
 3598.409,126.132,1196.289,63.216,-113.045,2.837,8.651,0.006,2.691,4.497,1.134,101.733,84.259,25.978,55.517,53.415
 3598.909,126.132,1201.172,62.834,-112.713,2.973,8.651,0.008,2.694,4.668,0.936,103.449,80.694,23.459,54.694,51.940
 3599.409,126.101,1201.172,64.178,-111.772,3.039,8.650,0.006,2.687,4.769,1.348,106.067,74.636,19.178,54.302,50.567
 3599.909,126.004,1188.867,65.331,-110.979,3.001,8.650,0.002,2.669,4.796,2.417,107.026,69.825,15.777,53.540,48.560
 3600.409,126.057,1196.289,64.556,-111.115,2.945,8.651,-0.003,2.652,4.660,3.409,106.903,68.620,14.926,52.860,46.240
 3600.909,126.211,1196.289,63.252,-111.512,2.888,8.650,-0.004,2.646,4.566,3.725,106.452,67.697,14.274,51.371,43.613
 3601.409,126.073,1192.285,60.814,-111.659,2.819,8.650,-0.004,2.653,4.536,3.337,106.058,64.782,12.214,49.761,40.845
 3601.909,126.242,1201.172,58.097,-110.726,2.797,8.650,-0.001,2.666,4.465,2.580,102.861,60.257,9.015,47.857,38.365
 3602.409,126.161,1201.172,56.274,-109.741,2.832,8.652,0.000,2.678,4.398,1.892,95.507,56.250,6.183,45.553,36.139
 3602.909,126.216,1194.629,57.039,-109.083,2.983,8.663,0.003,2.687,4.328,1.344,86.986,54.653,5.055,43.410,34.617
 3603.409,126.080,1191.406,61.171,-108.859,3.243,8.671,0.004,2.693,4.209,0.982,82.027,55.167,5.418,41.912,33.923
 3603.909,126.163,1194.873,66.533,-109.028,3.547,8.671,0.003,2.690,4.103,1.149,82.752,55.664,5.769,41.674,33.262
 3604.409,126.045,1196.289,66.717,-109.000,3.804,8.674,-0.000,2.687,4.158,1.330,86.699,55.844,5.897,42.953,32.293
 3604.909,126.138,1200.000,61.507,-108.480,3.823,8.681,-0.003,2.686,4.289,1.401,89.485,57.660,7.180,42.319,29.533
 3605.409,126.301,1201.172,56.120,-107.238,3.554,8.693,-0.004,2.687,4.379,1.318,87.710,61.524,9.911,36.197,24.562
 3605.909,126.198,1201.172,56.415,-105.513,3.159,8.710,-0.001,2.691,4.445,1.139,78.679,65.906,13.008,27.313,19.335
 3606.409,126.177,1199.561,62.876,-104.327,2.821,8.737,0.004,2.683,4.451,1.578,61.855,67.930,14.438,18.782,14.545
 3606.909,126.219,1196.289,70.247,-103.316,2.780,8.774,0.014,2.657,4.530,3.076,41.803,67.277,13.977,13.388,11.169
 3607.409,126.077,1196.289,76.092,-102.541,3.521,8.826,0.045,2.614,4.393,5.619,24.159,67.872,14.397,10.046,8.978
 3607.909,126.162,1200.732,84.909,-101.602,5.609,9.042,0.083,2.566,3.863,8.434,12.427,71.901,17.244,7.927,7.467
 3608.409,126.282,1201.172,98.272,-101.066,9.879,9.212,0.098,2.541,3.294,9.892,7.514,79.968,22.945,6.596,6.497
 3608.909,126.145,1187.256,112.793,-100.389,15.299,9.201,0.080,2.542,2.854,9.804,6.054,88.659,29.087,5.595,5.665
 3609.409,126.157,1196.289,126.551,-99.453,20.090,9.248,0.044,2.566,2.816,8.428,6.111,92.469,31.780,4.933,5.040
 3609.909,126.197,1191.406,134.290,-98.052,23.111,9.305,0.025,2.594,2.975,6.788,6.298,91.216,30.894,4.465,4.578
 3610.409,126.178,1190.820,133.814,-97.098,23.819,9.252,0.024,2.609,3.106,5.884,6.377,87.005,27.919,4.212,4.291
 3610.909,126.179,1183.105,126.321,-96.560,23.791,9.185,0.028,2.618,3.171,5.381,6.356,83.453,25.408,4.093,4.165
 3611.409,126.238,1205.371,119.171,-96.522,23.733,9.185,0.029,2.620,3.152,5.265,6.260,82.745,24.908,4.067,4.126
 3611.909,126.173,1196.289,119.128,-96.631,24.030,9.188,0.027,2.616,3.059,5.506,6.157,83.349,25.335,4.074,4.149
 3612.409,126.284,1196.289,121.170,-96.682,24.776,9.235,0.029,2.608,2.985,5.967,6.092,84.263,25.981,4.076,4.178
 3612.909,126.058,1200.439,124.530,-96.635,25.250,9.275,0.040,2.606,3.001,6.083,6.092,85.150,26.607,4.047,4.160
 3613.409,126.174,1196.289,127.872,-96.337,25.520,9.299,0.048,2.600,3.012,6.431,6.120,85.921,27.152,3.997,4.113
 3613.909,126.116,1203.027,130.529,-96.224,25.887,9.304,0.045,2.590,3.009,7.016,6.125,86.450,27.526,3.926,4.040
 3614.409,126.211,1210.938,130.276,-95.992,26.325,9.267,0.032,2.582,2.978,7.458,6.090,86.516,27.573,3.849,3.974
 3614.909,126.230,1193.750,125.389,-95.744,26.409,9.276,0.023,2.578,2.986,7.748,5.994,86.308,27.426,3.793,3.943
 3615.409,126.226,1197.412,118.537,-95.565,25.797,9.355,0.031,2.584,3.013,7.353,5.846,86.271,27.400,3.763,3.933
 3615.909,126.329,1194.873,115.392,-95.937,25.673,9.427,0.045,2.582,2.997,7.482,5.686,86.758,27.744,3.786,3.977
 3616.409,126.234,1199.316,119.627,-97.257,26.765,9.391,0.056,2.574,2.961,7.970,5.567,87.522,28.284,3.844,4.054
 3616.909,126.269,1210.938,124.892,-99.154,28.368,9.292,0.057,2.571,2.919,8.134,5.693,87.707,28.415,3.943,4.172
 3617.409,126.325,1202.539,128.249,-100.595,29.683,9.220,0.042,2.569,2.951,8.226,6.122,87.221,28.071,4.065,4.321
 3617.909,126.321,1202.002,127.436,-101.262,29.675,9.114,0.023,2.582,3.030,7.493,6.808,86.943,27.875,4.231,4.468
 3618.409,126.151,1210.938,123.745,-100.981,28.264,9.021,0.011,2.604,3.161,6.207,7.476,87.751,28.446,4.452,4.648
 3618.909,126.246,1206.055,120.067,-100.364,26.066,9.009,0.009,2.623,3.236,5.073,7.777,93.787,32.712,4.717,4.818
 3619.409,126.260,1201.367,114.577,-100.423,24.035,9.007,0.012,2.631,3.259,4.616,7.899,103.947,39.892,4.956,4.971
 3619.909,126.280,1203.516,111.591,-101.042,23.225,9.007,0.011,2.630,3.352,4.699,8.196,113.904,46.928,5.047,5.061
 3620.409,126.334,1196.338,111.465,-102.373,22.626,9.007,0.007,2.625,3.525,4.956,8.587,120.405,51.523,4.998,5.092
 3620.909,126.303,1201.172,113.911,-103.378,20.806,9.016,0.015,2.607,3.714,6.023,8.412,120.566,51.636,4.911,5.180
 3621.409,126.312,1210.938,122.931,-103.799,18.679,9.075,0.050,2.569,3.672,8.216,7.512,119.401,50.813,4.913,5.343
 3621.909,126.325,1205.273,130.936,-104.471,19.126,9.359,0.103,2.501,3.263,12.235,6.313,116.389,48.685,5.098,5.688
 3622.409,126.317,1200.684,133.762,-105.066,23.315,9.631,0.139,2.436,2.794,16.002,5.936,111.075,44.930,5.444,6.149
 3622.909,126.238,1202.441,126.858,-105.508,29.174,9.698,0.124,2.419,2.671,17.025,8.171,104.128,40.020,5.939,6.686
 3623.409,126.398,1206.055,108.843,-106.012,31.206,9.338,0.074,2.458,3.052,14.759,14.874,96.553,34.667,6.576,7.256
 3623.909,126.292,1199.512,85.349,-106.935,26.400,8.882,0.027,2.549,3.738,9.443,28.460,91.614,31.176,7.546,7.908
 3624.409,126.353,1210.938,63.438,-108.495,17.702,8.803,0.004,2.639,4.389,4.141,48.088,89.305,29.544,9.140,8.885
 3624.909,126.330,1200.391,50.746,-110.556,9.545,8.803,0.001,2.690,4.786,1.186,66.981,86.136,27.305,11.635,10.151
 3625.409,126.404,1201.172,45.415,-112.234,4.644,8.804,0.005,2.709,4.927,0.055,73.989,81.431,23.979,14.469,11.615
 3625.909,126.335,1201.172,42.270,-113.187,2.656,8.810,0.012,2.704,5.037,0.336,64.551,77.731,21.365,15.625,12.550
 3626.409,126.332,1201.172,42.818,-113.875,2.283,8.844,0.032,2.660,4.995,2.932,44.603,81.244,23.848,14.054,12.585
 3626.909,126.287,1197.168,49.220,-114.784,3.089,8.962,0.084,2.547,4.656,9.529,25.034,91.617,31.178,11.528,11.880
 3627.409,126.364,1199.609,59.703,-116.125,5.371,9.463,0.155,2.369,4.002,19.970,13.746,102.744,39.042,9.654,11.009
 3627.909,126.446,1197.559,71.756,-117.717,9.911,10.417,0.216,2.207,3.265,29.391,8.964,111.988,45.574,8.394,10.174
 3628.409,126.327,1196.289,78.959,-118.633,16.902,10.905,0.239,2.135,2.849,33.622,7.677,113.964,46.971,7.653,9.381
 3628.909,126.471,1196.289,82.176,-118.993,24.514,10.531,0.224,2.135,2.690,33.634,7.591,109.493,43.811,7.123,8.610
 3629.409,126.313,1209.375,80.666,-118.675,30.086,10.417,0.188,2.205,2.745,29.534,8.548,100.424,37.402,6.905,8.032
 3629.909,126.339,1201.172,74.552,-118.489,31.291,10.475,0.148,2.315,3.077,23.119,10.792,90.724,30.547,7.024,7.831
 3630.409,126.363,1198.779,65.763,-118.620,26.729,9.670,0.111,2.458,3.449,14.736,15.516,84.685,26.279,7.638,8.074
 3630.909,126.293,1196.387,54.993,-119.022,19.439,9.091,0.075,2.579,3.915,7.656,24.008,81.990,24.374,8.919,8.900
 3631.409,126.378,1203.467,45.706,-119.452,12.051,9.036,0.044,2.632,4.299,4.537,37.006,84.262,25.980,11.168,10.584
 3631.909,126.254,1201.172,38.105,-120.290,6.815,8.928,0.017,2.645,4.490,3.786,51.830,89.364,29.586,14.665,13.181
 3632.409,126.456,1204.004,33.932,-121.272,4.415,8.928,-0.001,2.649,4.647,3.562,64.756,92.707,31.949,19.514,17.353
 3632.909,126.307,1195.752,32.565,-122.373,3.241,8.928,-0.003,2.665,4.529,2.657,73.413,89.222,29.485,24.923,21.899
 3633.409,126.486,1191.406,31.512,-123.040,2.711,8.928,-0.002,2.680,4.441,1.776,77.612,81.629,24.120,29.367,26.614
 3633.909,126.270,1205.322,30.465,-123.125,2.391,8.928,-0.002,2.686,4.428,1.398,78.650,76.681,20.623,32.397,29.714
 3634.409,126.401,1204.492,30.968,-122.256,2.090,8.930,-0.003,2.678,4.377,1.892,76.748,76.589,20.557,33.425,29.979
 3634.909,126.287,1206.055,33.296,-120.973,1.846,8.937,-0.002,2.670,4.351,2.351,73.243,78.912,22.199,34.533,29.633
 3635.409,126.398,1198.926,35.342,-120.195,1.785,8.952,0.002,2.670,4.393,2.336,68.872,81.306,23.891,34.259,27.014
 3635.909,126.521,1206.055,34.490,-120.333,1.887,8.974,0.006,2.677,4.504,1.955,63.568,86.258,27.391,31.675,23.135
 3636.409,126.347,1202.295,31.147,-120.828,2.069,9.000,0.011,2.684,4.642,1.536,56.763,93.292,32.362,26.026,18.542
 3636.909,126.455,1207.520,29.677,-120.530,2.277,9.026,0.014,2.683,4.797,1.570,46.739,99.988,37.094,19.244,14.223
 3637.409,126.419,1210.938,34.924,-119.598,2.570,9.047,0.021,2.684,4.840,1.497,34.149,103.460,39.548,13.860,11.239
 3637.909,126.413,1204.102,50.414,-118.170,3.448,9.086,0.029,2.674,4.478,2.112,21.765,102.994,39.218,10.290,9.232
 3638.409,126.493,1204.150,70.886,-116.645,5.652,9.164,0.036,2.634,3.806,4.425,12.386,105.338,40.875,8.133,7.896
 3638.909,126.329,1206.055,93.034,-114.905,10.069,9.254,0.058,2.578,3.167,7.701,7.807,112.352,45.832,6.859,6.986
 3639.409,126.412,1206.055,110.391,-113.691,16.344,9.362,0.100,2.517,2.863,11.262,6.092,120.127,51.326,6.044,6.264
 3639.909,126.447,1206.055,118.450,-112.473,24.135,10.009,0.137,2.483,2.895,13.268,5.602,121.517,52.309,5.548,5.797
 3640.409,126.452,1201.318,123.265,-111.488,31.404,10.626,0.139,2.476,2.883,13.661,5.615,115.504,48.060,5.194,5.437
 3640.909,126.423,1196.289,121.100,-111.436,34.642,9.971,0.093,2.492,2.814,12.730,6.176,106.671,41.817,4.973,5.189
 3641.409,126.304,1191.504,116.864,-112.761,33.637,9.285,0.041,2.516,2.775,11.370,6.864,99.887,37.022,4.871,5.040
 3641.909,126.444,1209.082,109.466,-114.920,28.832,9.266,0.017,2.533,2.705,10.339,7.265,95.877,34.189,4.912,5.012
 3642.409,126.349,1215.234,101.852,-115.489,23.994,9.264,0.014,2.549,2.646,9.423,7.336,90.894,30.667,5.072,5.111
 3642.909,126.466,1203.174,100.911,-113.990,21.147,9.264,0.021,2.573,2.595,8.008,7.205,85.879,27.123,5.289,5.279
 3643.409,126.309,1201.172,102.355,-112.100,20.011,9.264,0.022,2.592,2.621,6.917,7.110,81.328,23.907,5.445,5.413
 3643.909,126.413,1195.020,106.594,-111.064,20.143,9.264,0.018,2.594,2.707,6.807,7.083,78.494,21.904,5.465,5.468
 3644.409,126.501,1201.172,108.181,-110.386,20.663,9.268,0.012,2.581,2.725,7.557,6.975,77.457,21.171,5.365,5.421
 3644.909,126.481,1201.172,109.678,-109.190,21.152,9.275,0.008,2.572,2.759,8.055,6.692,78.128,21.645,5.207,5.304
 3645.409,126.440,1206.055,116.073,-107.568,21.738,9.284,0.012,2.588,2.817,7.160,6.325,80.838,23.560,5.066,5.165
 3645.909,126.521,1198.926,128.465,-106.796,22.625,9.290,0.019,2.609,2.876,5.922,6.036,83.641,25.542,4.947,5.032
 3646.409,126.433,1198.730,143.156,-106.078,23.876,9.292,0.025,2.621,2.912,5.233,5.913,85.626,26.944,4.850,4.923
 3646.909,126.406,1202.246,151.728,-106.079,25.084,9.292,0.026,2.613,2.882,5.645,5.899,87.138,28.013,4.761,4.831
 3647.409,126.295,1215.820,152.954,-105.569,26.109,9.292,0.024,2.603,2.858,6.265,5.914,88.766,29.163,4.685,4.758
 3647.909,126.340,1211.768,152.336,-105.244,27.338,9.292,0.025,2.600,2.878,6.452,5.946,91.884,31.367,4.635,4.709
 3648.409,126.378,1201.172,152.095,-104.672,28.555,9.292,0.029,2.599,2.859,6.483,5.985,94.390,33.138,4.610,4.683
 3648.909,126.329,1201.172,151.608,-104.670,29.343,9.288,0.038,2.602,2.865,6.324,6.023,94.737,33.383,4.610,4.678
 3649.409,126.559,1197.266,150.361,-105.390,29.323,9.278,0.048,2.611,2.898,5.813,6.048,95.879,34.190,4.624,4.688
 3649.909,126.584,1191.406,144.926,-105.992,28.451,9.271,0.052,2.624,2.884,5.008,6.070,99.053,36.433,4.640,4.702
 3650.409,126.439,1195.801,136.008,-105.784,27.191,9.247,0.043,2.633,2.889,4.518,6.112,104.227,40.090,4.651,4.715
 3650.909,126.534,1205.908,129.766,-104.879,26.068,9.215,0.027,2.627,2.849,4.861,6.167,108.679,43.236,4.658,4.725
 3651.409,126.460,1206.055,128.552,-104.948,25.623,9.203,0.014,2.612,2.826,5.748,6.201,109.077,43.518,4.660,4.736
 3651.909,126.487,1191.309,129.882,-105.737,25.615,9.201,0.010,2.600,2.829,6.433,6.201,105.372,40.899,4.668,4.751
 3652.409,126.516,1186.523,126.828,-106.660,25.017,9.201,0.011,2.599,2.741,6.491,6.158,99.973,37.083,4.685,4.772
 3652.909,126.343,1202.539,121.079,-107.195,24.186,9.201,0.014,2.602,2.672,6.324,6.089,97.680,35.463,4.708,4.789
 3653.409,126.456,1226.465,117.584,-107.128,23.863,9.201,0.015,2.604,2.631,6.214,6.033,100.654,37.565,4.727,4.795
 3653.909,126.528,1228.857,114.641,-106.665,24.367,9.201,0.016,2.604,2.642,6.209,6.011,106.046,41.375,4.713,4.782
 3654.409,126.500,1215.820,117.070,-105.940,25.360,9.202,0.014,2.597,2.704,6.580,6.037,111.732,45.394,4.666,4.754
 3654.909,126.487,1215.820,123.041,-105.120,26.084,9.212,0.012,2.590,2.703,6.990,6.061,117.450,49.435,4.618,4.735
 3655.409,126.532,1205.713,129.241,-104.509,26.220,9.242,0.013,2.589,2.699,7.069,5.984,122.900,53.286,4.560,4.683
 3655.909,126.503,1206.055,130.512,-103.805,26.001,9.313,0.027,2.586,2.824,7.234,5.783,125.961,55.450,4.552,4.634
 3656.409,126.406,1206.055,126.312,-103.776,26.226,9.384,0.066,2.586,3.044,7.270,5.522,124.903,54.701,4.470,4.552
 3656.909,126.540,1212.207,123.949,-104.219,27.046,9.380,0.105,2.577,3.223,7.773,5.344,120.325,51.466,4.334,4.427
 3657.409,126.535,1200.586,125.797,-105.657,28.260,9.338,0.113,2.569,3.249,8.220,5.329,114.584,47.409,4.148,4.370
 3657.909,126.543,1199.316,127.081,-107.532,28.789,9.338,0.081,2.557,3.172,8.957,5.428,109.848,44.062,3.960,4.323
 3658.409,126.450,1202.002,120.844,-110.432,28.345,9.338,0.040,2.486,3.223,13.103,5.405,108.667,43.228,3.920,4.471
 3658.909,126.601,1215.820,109.421,-113.609,28.146,9.358,0.037,2.327,3.181,22.373,5.130,109.435,43.770,4.014,4.765
 3659.409,126.510,1220.117,96.143,-115.920,29.529,10.068,0.065,2.169,2.901,31.613,5.069,106.824,41.925,4.269,5.155
 3659.909,126.550,1220.703,86.465,-116.310,32.532,10.549,0.088,2.116,2.666,34.744,5.635,100.695,37.594,4.667,5.671
 3660.409,126.560,1211.621,81.968,-115.523,34.391,9.583,0.087,2.181,2.567,30.956,6.931,92.905,32.088,5.074,5.987
 3660.909,126.451,1208.252,73.603,-115.169,32.257,9.024,0.056,2.324,2.836,22.574,11.345,86.830,27.795,5.636,6.478
 3661.409,126.579,1210.938,59.916,-115.632,26.263,9.020,0.024,2.468,3.302,14.153,20.088,83.414,25.381,6.421,7.169
 3661.909,126.627,1208.496,44.148,-116.058,17.932,8.842,0.009,2.591,3.855,6.942,32.375,78.977,22.246,7.701,8.163
 3662.409,126.399,1215.820,30.616,-116.146,10.390,8.841,0.003,2.672,4.436,2.226,43.848,72.605,17.742,9.922,10.054
 3662.909,126.556,1210.449,25.794,-116.024,5.235,8.833,0.006,2.695,4.747,0.853,50.016,65.214,12.519,13.396,12.535
 3663.409,126.589,1215.820,27.970,-115.767,2.541,8.809,0.007,2.695,4.795,0.891,52.254,61.110,9.618,18.175,16.647
 3663.909,126.531,1215.820,31.004,-115.171,1.793,8.803,0.006,2.695,4.798,0.895,53.331,64.223,11.818,23.439,21.906
 3664.409,126.460,1202.930,33.630,-114.107,1.672,8.803,0.007,2.699,4.824,0.618,53.590,70.702,16.397,26.076,24.666
 3664.909,126.459,1212.695,33.914,-113.868,1.719,8.803,0.008,2.706,4.788,0.252,52.256,73.572,18.425,26.676,24.873
 3665.409,126.611,1211.768,32.206,-114.086,1.779,8.803,0.009,2.713,4.694,-0.166,48.465,71.497,16.959,25.016,22.257
 3665.909,126.551,1209.082,33.994,-114.763,1.971,8.805,0.007,2.711,4.489,-0.055,41.736,67.313,14.002,22.791,19.889
 3666.409,126.665,1210.938,38.084,-114.654,2.436,8.810,0.003,2.701,4.285,0.507,33.917,65.907,13.009,21.237,18.435
 3666.909,126.658,1203.711,44.962,-113.702,3.260,8.813,0.001,2.692,4.061,1.072,26.487,68.717,14.994,20.461,17.750
 3667.409,126.632,1210.938,51.016,-112.132,4.257,8.813,0.000,2.685,3.893,1.450,23.369,72.040,17.343,20.350,17.835
 3667.909,126.675,1210.938,51.021,-110.800,5.002,8.813,0.002,2.689,4.000,1.209,30.516,71.689,17.095,20.798,18.224
 3668.409,126.553,1210.596,46.119,-110.338,4.908,8.812,0.005,2.702,4.232,0.479,49.472,66.857,13.680,21.517,18.660
 3668.909,126.626,1216.650,38.993,-110.829,3.893,8.812,0.009,2.721,4.447,-0.657,73.965,60.247,9.009,22.809,19.130
 3669.409,126.547,1214.063,33.025,-111.168,2.448,8.812,0.013,2.738,4.467,-1.655,92.591,54.476,4.930,24.700,19.649
 3669.909,126.528,1206.641,30.561,-111.224,1.318,8.816,0.014,2.742,4.362,-1.877,95.373,51.422,2.772,25.958,19.231
 3670.409,126.622,1206.055,34.358,-110.511,0.908,8.828,0.015,2.737,4.394,-1.576,80.597,50.716,2.273,24.668,17.233
 3670.909,126.644,1206.055,42.160,-109.694,1.073,8.848,0.015,2.722,4.479,-0.720,58.034,51.649,2.932,19.719,14.168
 3671.409,126.476,1208.740,56.609,-108.808,1.833,8.886,0.015,2.697,4.456,0.777,36.277,54.290,4.798,14.317,11.045
 3671.909,126.605,1206.055,78.580,-107.822,3.199,8.953,0.012,2.658,4.188,3.038,20.601,58.766,7.962,10.008,8.628
 3672.409,126.660,1201.172,108.643,-107.436,5.613,9.037,0.010,2.608,3.802,5.944,12.259,65.004,12.370,7.431,6.897
 3672.909,126.610,1205.762,137.091,-108.095,9.330,9.109,0.021,2.537,3.513,10.090,7.573,72.409,17.603,5.709,5.663
 3673.409,126.575,1198.975,156.931,-110.300,14.678,9.249,0.068,2.442,3.265,15.686,5.613,80.038,22.995,4.656,4.806
 3673.909,126.459,1210.938,181.314,-112.659,20.808,9.820,0.126,2.349,2.988,21.101,4.678,86.762,27.747,3.928,4.175
 3674.409,126.683,1205.078,229.810,-113.922,27.046,10.331,0.166,2.298,2.756,24.078,4.215,91.456,31.064,3.437,3.739
 3674.909,126.622,1214.063,292.163,-114.532,32.089,10.277,0.176,2.274,2.632,25.516,3.993,93.291,32.361,3.100,3.429
 3675.409,126.627,1201.172,316.010,-114.747,35.132,10.145,0.154,2.249,2.638,26.935,4.003,92.577,31.857,2.881,3.255
 3675.909,126.709,1214.990,278.762,-114.912,36.593,10.582,0.134,2.233,2.805,27.917,4.112,91.011,30.750,2.806,3.224
 3676.409,126.647,1207.568,206.978,-115.247,36.218,10.415,0.139,2.243,2.945,27.339,4.202,88.041,28.651,2.856,3.332
 3676.909,126.574,1206.055,143.247,-115.611,35.171,10.235,0.154,2.279,3.049,25.231,4.308,84.622,26.234,3.073,3.584
 3677.409,126.528,1213.281,111.130,-115.795,34.857,10.617,0.162,2.324,3.137,22.547,4.671,81.517,24.040,3.418,3.948
 3677.909,126.730,1215.820,98.260,-115.040,34.242,10.029,0.142,2.383,3.216,19.109,5.943,78.028,21.575,3.814,4.332
 3678.409,126.727,1208.105,85.977,-113.969,31.527,9.401,0.090,2.459,3.463,14.669,8.538,73.727,18.535,4.151,4.667
 3678.909,126.603,1215.820,74.731,-113.260,25.682,9.171,0.049,2.521,3.774,11.074,10.895,69.120,15.279,4.384,4.982
 3679.409,126.708,1219.922,67.130,-113.845,18.723,9.109,0.049,2.516,3.923,11.341,11.286,66.969,13.759,4.586,5.392
 3679.909,126.768,1217.578,67.457,-115.069,15.272,9.338,0.095,2.423,3.733,16.784,9.450,69.114,15.275,4.928,6.181
 3680.409,126.698,1216.357,73.599,-116.913,17.409,10.021,0.153,2.305,3.263,23.665,6.978,73.108,18.097,5.408,7.285
 3680.909,126.737,1213.818,75.873,-118.566,23.589,10.402,0.166,2.253,2.805,26.702,6.291,75.395,19.714,5.860,8.230
 3681.409,126.590,1201.855,71.196,-119.212,28.968,9.803,0.131,2.278,2.765,25.261,7.046,75.529,19.808,6.242,8.735
 3681.909,126.699,1215.820,62.797,-119.157,29.381,9.077,0.088,2.366,2.895,20.144,8.574,73.360,18.275,6.420,8.593
 3682.409,126.819,1211.035,53.674,-119.059,25.668,8.979,0.053,2.455,3.079,14.902,12.510,69.177,15.320,6.805,8.564
 3682.909,126.707,1210.840,45.086,-119.564,20.304,8.912,0.034,2.543,3.370,9.785,21.083,63.201,11.096,7.808,9.219
 3683.409,126.669,1206.348,37.629,-120.178,15.013,8.705,0.015,2.625,3.643,4.977,31.708,57.327,6.945,9.586,10.298
 3683.909,126.808,1210.449,31.219,-120.595,10.204,8.693,0.000,2.683,4.044,1.567,42.575,53.932,4.546,12.832,12.675
 3684.409,126.791,1210.938,27.899,-121.291,6.337,8.693,-0.001,2.712,4.308,-0.135,50.364,52.575,3.587,17.446,16.220
 3684.909,126.772,1210.938,25.982,-121.671,4.194,8.693,0.001,2.712,4.418,-0.115,54.107,53.391,4.163,22.337,21.255
 3685.409,126.771,1211.572,24.175,-121.466,3.192,8.696,0.005,2.712,4.536,-0.141,54.349,55.854,5.904,26.843,26.959
 3685.909,126.711,1215.820,24.709,-120.475,2.663,8.705,0.013,2.719,4.535,-0.514,49.292,59.341,8.368,28.571,28.638
 3686.409,126.739,1219.873,26.913,-119.532,2.374,8.717,0.022,2.728,4.478,-1.024,42.752,62.480,10.586,28.642,28.077
 3686.909,126.711,1215.820,26.790,-118.185,2.481,8.724,0.026,2.730,4.340,-1.171,36.668,63.118,11.037,27.004,25.912
 3687.409,126.682,1217.969,26.543,-116.593,2.898,8.732,0.021,2.719,4.137,-0.506,32.537,61.383,9.811,24.846,23.476
 3687.909,126.713,1225.586,27.033,-114.680,3.408,8.746,0.019,2.711,4.041,-0.075,30.088,58.320,7.647,22.758,21.427
 3688.409,126.778,1220.703,28.371,-112.541,3.821,8.765,0.022,2.714,4.035,-0.223,27.941,56.242,6.178,21.148,19.645
 3688.909,126.826,1216.846,30.363,-110.728,4.089,8.780,0.025,2.717,4.029,-0.400,26.193,55.532,5.676,19.502,18.220
 3689.409,126.762,1219.141,32.002,-109.558,4.322,8.787,0.022,2.709,3.986,0.060,24.476,56.341,6.248,18.150,17.112
 3689.909,126.854,1203.516,35.288,-108.883,4.664,8.792,0.014,2.692,3.937,1.071,22.298,60.124,8.921,16.847,16.190
 3690.409,126.719,1206.592,38.857,-108.092,5.190,8.795,0.013,2.688,3.922,1.263,20.341,66.137,13.171,15.631,15.263
 3690.909,126.868,1215.820,41.429,-106.424,5.904,8.796,0.017,2.694,4.003,0.956,18.874,72.150,17.421,14.483,14.424
 3691.409,126.890,1215.820,41.705,-104.704,6.627,8.797,0.023,2.705,4.048,0.284,17.818,75.796,19.997,13.345,13.438
 3691.909,126.656,1206.641,42.643,-103.365,7.182,8.799,0.025,2.706,4.115,0.214,16.808,77.089,20.911,12.324,12.554
 3692.409,126.722,1215.430,47.441,-102.776,7.613,8.800,0.025,2.698,4.065,0.714,15.326,79.073,22.313,11.405,11.829
 3692.909,126.843,1220.703,53.990,-102.307,8.091,8.805,0.026,2.685,3.975,1.483,14.131,84.334,26.031,10.630,11.249
 3693.409,126.664,1227.979,60.058,-102.269,8.961,8.812,0.027,2.664,3.946,2.669,13.325,90.379,30.303,10.144,11.007
 3693.909,126.724,1225.586,65.823,-102.384,10.087,8.820,0.032,2.648,3.836,3.619,12.730,93.057,32.196,9.841,10.846
 3694.409,126.748,1222.852,66.561,-102.509,11.034,8.819,0.031,2.635,3.780,4.409,12.595,90.224,30.194,9.818,10.879
 3694.909,126.760,1220.703,63.401,-102.506,11.778,8.751,0.030,2.641,3.639,4.059,13.038,85.635,26.951,9.877,10.909
 3695.409,126.788,1220.703,61.393,-102.502,12.097,8.677,0.028,2.661,3.583,2.844,15.225,83.875,25.707,9.909,10.805
 3695.909,126.677,1221.338,59.009,-102.793,11.615,8.647,0.025,2.676,3.720,1.964,18.378,81.916,24.322,9.997,10.795
 3696.409,126.780,1219.238,58.012,-102.599,10.120,8.634,0.024,2.678,3.947,1.851,19.719,77.315,21.071,10.198,10.999
 3696.909,126.907,1217.578,60.754,-102.505,8.309,8.632,0.026,2.676,4.052,1.989,18.317,71.270,16.799,10.775,11.814
 3697.409,126.846,1222.168,67.116,-102.753,7.509,8.625,0.028,2.676,3.898,1.998,16.646,67.057,13.821,11.829,13.353
 3697.909,126.921,1214.697,72.253,-103.621,7.794,8.618,0.025,2.679,3.818,1.805,22.751,65.341,12.609,13.325,15.326
 3698.409,126.843,1210.938,69.397,-104.464,7.825,8.622,0.017,2.684,3.988,1.530,43.345,64.283,11.861,15.069,17.205
 3698.909,126.765,1224.268,60.343,-104.996,6.522,8.622,0.009,2.685,4.335,1.459,74.449,62.302,10.461,17.019,18.740
 3699.409,126.860,1216.797,52.247,-105.864,4.254,8.619,0.007,2.688,4.666,1.310,103.123,58.365,7.678,19.064,20.119
 3699.909,126.848,1215.820,49.819,-105.849,2.307,8.620,0.005,2.683,4.811,1.567,112.652,54.424,4.893,21.858,21.627
 3700.409,126.830,1215.820,48.298,-106.098,1.283,8.620,0.004,2.674,4.882,2.087,100.754,51.432,2.779,24.479,22.743
 3700.909,126.835,1215.820,44.757,-105.084,1.169,8.628,0.005,2.664,4.866,2.696,76.141,50.872,2.383,25.051,21.868
 3701.409,126.881,1228.857,42.901,-104.649,1.673,8.646,0.009,2.648,4.769,3.635,50.891,53.214,4.038,22.360,19.686
 3701.909,126.901,1224.316,46.416,-103.683,2.760,8.676,0.016,2.632,4.585,4.553,33.338,56.478,6.345,18.010,16.697
 3702.409,126.836,1215.820,52.617,-101.654,4.151,8.739,0.021,2.622,4.373,5.172,22.960,59.253,8.306,14.406,14.187
 3702.909,126.909,1222.705,58.508,-99.807,5.532,8.740,0.025,2.624,4.138,5.039,17.232,61.443,9.854,12.356,12.707
 3703.409,126.659,1215.967,65.349,-98.404,6.816,8.717,0.031,2.640,3.881,4.114,13.712,63.216,11.107,11.103,11.682
 3703.909,126.880,1220.801,69.295,-98.090,8.303,8.748,0.034,2.656,3.788,3.176,12.609,65.064,12.413,10.589,11.257
 3704.409,126.977,1216.211,69.833,-98.381,9.621,8.716,0.030,2.663,3.798,2.745,14.062,66.129,13.165,10.244,10.745
 3704.909,126.839,1225.586,65.594,-98.750,9.785,8.674,0.017,2.661,3.955,2.886,17.565,64.796,12.223,9.946,10.178
 3705.409,126.873,1226.025,57.121,-99.901,8.742,8.674,0.008,2.661,4.130,2.862,19.568,62.378,10.514,9.782,9.781
 3705.909,126.841,1227.490,52.941,-100.581,7.143,8.679,0.012,2.671,4.057,2.303,18.229,60.431,9.138,9.624,9.542
 3706.409,126.797,1215.820,52.945,-100.924,6.375,8.685,0.018,2.676,3.841,2.014,15.464,60.003,8.836,9.663,9.634
 3706.909,126.967,1219.043,56.364,-100.316,7.031,8.687,0.020,2.676,3.648,1.994,12.583,61.838,10.133,9.677,9.821
 3707.409,126.738,1228.613,59.970,-99.453,8.533,8.687,0.019,2.671,3.557,2.270,11.045,64.716,12.167,9.623,9.917
 3707.909,126.904,1264.648,59.820,-99.265,10.275,8.687,0.013,2.662,3.512,2.822,10.764,67.426,14.082,9.457,9.958
 3708.409,126.916,1234.229,58.049,-99.334,11.578,8.686,0.009,2.656,3.429,3.143,11.051,70.483,16.243,9.264,9.793
 3708.909,126.859,1223.145,55.287,-100.182,12.169,8.684,0.008,2.654,3.343,3.287,11.772,73.452,18.341,9.126,9.619
 3709.409,126.885,1220.703,52.542,-100.761,11.921,8.683,0.011,2.659,3.404,3.008,12.748,75.763,19.974,9.182,9.520
 3709.909,126.926,1220.703,51.838,-100.907,11.090,8.683,0.017,2.671,3.616,2.254,13.577,77.035,20.873,9.360,9.592
 3710.409,126.877,1225.586,54.228,-100.811,10.276,8.683,0.016,2.673,3.729,2.176,13.782,76.807,20.712,9.705,9.900
 3710.909,126.891,1217.285,58.544,-100.588,9.954,8.682,0.010,2.667,3.715,2.531,13.567,76.703,20.638,10.111,10.318
 3711.409,126.999,1224.316,61.223,-100.611,10.119,8.679,0.007,2.660,3.782,2.918,13.685,79.725,22.774,10.516,10.736
 3711.909,127.020,1230.469,61.089,-100.160,10.168,8.673,0.005,2.654,3.928,3.295,14.530,86.417,27.503,10.829,11.016
 3712.409,126.922,1222.754,57.322,-99.916,9.772,8.664,0.005,2.656,4.043,3.154,15.602,93.987,32.853,10.996,11.128
 3712.909,126.940,1220.947,52.370,-100.130,9.155,8.659,0.003,2.661,4.090,2.867,16.266,99.745,36.922,11.035,11.054
 3713.409,126.901,1220.703,48.546,-100.893,8.629,8.659,0.002,2.666,4.061,2.576,16.121,101.474,38.144,10.941,10.810
 3713.909,126.977,1215.869,48.502,-101.722,8.274,8.665,0.006,2.673,4.050,2.192,15.217,102.001,38.517,10.643,10.383
 3714.409,126.856,1230.273,52.799,-102.026,8.216,8.681,0.012,2.669,4.040,2.385,14.212,103.010,39.230,10.134,9.836
 3714.909,127.094,1225.586,55.260,-101.640,8.607,8.692,0.016,2.660,3.944,2.917,13.377,104.573,40.334,9.521,9.336
 3715.409,126.996,1220.020,57.915,-100.654,9.289,8.693,0.018,2.653,3.766,3.336,12.436,104.383,40.200,9.037,9.060
 3715.909,127.051,1225.586,62.110,-99.731,10.039,8.698,0.025,2.657,3.568,3.120,11.250,103.334,39.459,8.779,9.083
 3716.409,126.987,1219.629,67.424,-99.388,11.295,8.713,0.032,2.662,3.414,2.809,10.439,104.170,40.049,8.867,9.393
 3716.909,126.954,1222.070,70.576,-99.776,12.813,8.682,0.031,2.663,3.472,2.744,11.853,106.159,41.455,9.228,9.845
 3717.409,126.958,1230.469,64.644,-100.137,13.385,8.627,0.021,2.665,3.738,2.640,16.627,107.830,42.636,9.808,10.258
 3717.909,126.959,1225.586,53.946,-100.248,12.093,8.615,0.008,2.663,4.049,2.722,23.630,104.906,40.570,10.527,10.585
 3718.409,126.869,1218.652,45.125,-99.673,9.197,8.615,0.003,2.670,4.291,2.330,29.743,97.329,35.215,11.271,10.853
 3718.909,126.993,1218.066,41.908,-98.960,6.554,8.624,0.006,2.675,4.332,2.024,31.530,91.952,31.415,11.896,11.000
 3719.409,126.886,1225.586,45.006,-98.009,5.334,8.649,0.011,2.676,4.339,2.007,28.004,91.967,31.426,12.110,10.989
 3719.909,126.986,1229.102,50.380,-96.746,5.454,8.688,0.015,2.671,4.192,2.297,21.326,95.142,33.669,11.666,10.610
 3720.409,127.073,1225.586,55.606,-95.782,6.636,8.728,0.015,2.659,3.863,3.001,15.117,96.681,34.757,10.624,10.015
 3720.909,127.058,1230.469,62.868,-95.223,8.597,8.748,0.014,2.650,3.665,3.537,11.485,93.469,32.487,9.368,9.202
 3721.409,127.064,1234.619,75.229,-95.381,10.935,8.752,0.013,2.645,3.556,3.818,9.821,89.200,29.470,8.292,8.387
 3721.909,126.922,1229.785,89.888,-95.423,13.297,8.753,0.018,2.650,3.577,3.519,9.091,87.560,28.311,7.496,7.668
 3722.409,127.025,1233.887,99.067,-95.290,15.323,8.753,0.027,2.656,3.548,3.163,8.615,87.775,28.463,6.964,7.091
 3722.909,127.071,1225.586,96.655,-94.754,16.956,8.747,0.033,2.656,3.406,3.168,8.381,86.867,27.821,6.605,6.690
 3723.409,127.154,1225.586,86.685,-94.551,18.043,8.731,0.031,2.660,3.274,2.948,8.690,82.955,25.057,6.311,6.338
 3723.909,126.994,1225.586,76.648,-94.864,18.046,8.720,0.022,2.660,3.223,2.919,9.391,76.396,20.421,6.081,6.074
 3724.409,127.006,1225.586,71.990,-95.564,16.845,8.731,0.017,2.658,3.270,3.062,9.551,70.579,16.310,5.875,5.875
 3724.909,127.141,1225.586,76.779,-95.872,14.913,8.784,0.024,2.654,3.256,3.269,8.844,69.189,15.328,5.740,5.781
 3725.409,127.028,1230.469,87.762,-95.642,14.077,8.827,0.037,2.653,3.174,3.346,7.791,71.168,16.726,5.655,5.784
 3725.909,127.031,1233.252,97.464,-95.171,15.186,8.831,0.046,2.656,3.083,3.142,7.259,73.884,18.646,5.588,5.772
 3726.409,127.148,1230.029,103.101,-94.795,17.018,8.831,0.044,2.654,3.037,3.248,7.314,75.540,19.816,5.522,5.753
 3726.909,127.019,1225.586,104.873,-94.523,18.403,8.831,0.034,2.645,3.054,3.820,7.427,75.791,19.994,5.457,5.701
 3727.409,127.045,1225.586,106.567,-94.046,19.059,8.829,0.022,2.631,3.024,4.601,7.537,75.602,19.860,5.405,5.653
 3727.909,127.081,1235.400,107.988,-93.818,19.502,8.823,0.014,2.623,2.958,5.080,7.707,75.438,19.744,5.420,5.666
 3728.409,127.023,1235.352,107.084,-93.923,19.704,8.818,0.008,2.616,2.957,5.481,7.878,75.266,19.622,5.482,5.715
 3728.909,127.166,1231.885,105.661,-94.403,19.503,8.814,0.004,2.612,3.043,5.714,7.970,75.123,19.522,5.610,5.843
 3729.409,126.959,1219.531,100.062,-95.032,18.918,8.812,0.003,2.616,3.139,5.512,8.027,76.518,20.507,5.769,6.026
 3729.909,127.067,1215.820,94.706,-95.776,17.985,8.811,-0.000,2.616,3.195,5.470,8.220,80.146,23.071,5.926,6.213
 3730.409,127.113,1220.703,89.207,-95.877,16.906,8.810,-0.002,2.622,3.296,5.121,8.649,84.329,26.027,6.085,6.358
 3730.909,126.974,1232.568,82.348,-95.159,15.825,8.810,-0.002,2.626,3.393,4.908,9.173,87.542,28.298,6.183,6.359
 3731.409,127.126,1233.740,78.827,-94.505,15.111,8.814,-0.001,2.625,3.460,4.985,9.483,88.503,28.977,6.214,6.245
 3731.909,127.092,1226.270,80.451,-94.757,14.708,8.825,0.001,2.621,3.450,5.185,9.330,90.319,30.260,6.095,6.075
 3732.409,127.117,1215.820,86.388,-95.988,14.525,8.851,0.005,2.616,3.343,5.492,8.744,98.082,35.747,5.873,5.912
 3732.909,127.114,1220.264,93.222,-97.358,14.833,8.874,0.012,2.613,3.285,5.670,8.010,109.230,43.626,5.664,5.898
 3733.409,127.083,1223.486,97.160,-98.421,15.831,8.878,0.023,2.610,3.267,5.871,7.388,119.454,50.851,5.535,5.956
 3733.909,127.117,1220.703,100.660,-99.339,17.678,8.878,0.038,2.580,3.239,7.600,6.900,123.221,53.513,5.602,6.167
 3734.409,127.090,1235.547,107.861,-100.124,20.930,8.911,0.068,2.526,3.114,10.743,6.699,116.543,48.794,5.871,6.518
 3734.909,127.160,1225.586,106.804,-100.658,24.722,9.213,0.090,2.482,2.937,13.311,7.992,106.180,41.470,6.332,6.960
 3735.409,127.086,1225.586,93.772,-100.768,26.258,9.288,0.079,2.499,2.986,12.315,14.266,94.770,33.406,7.044,7.697
 3735.909,127.144,1225.586,74.002,-100.267,23.509,8.887,0.048,2.575,3.337,7.896,26.640,86.446,27.524,7.879,8.424
 3736.409,127.173,1225.586,55.965,-99.571,16.603,8.690,0.013,2.652,3.914,3.404,42.149,82.938,25.045,9.139,9.469
 3736.909,127.276,1225.098,49.106,-99.274,9.432,8.689,0.001,2.701,4.334,0.527,53.639,81.313,23.896,10.934,10.912
 3737.409,127.112,1223.730,50.435,-99.706,5.242,8.689,0.002,2.707,4.343,0.165,56.843,81.511,24.036,13.587,12.659
 3737.909,127.166,1230.469,52.543,-100.132,3.830,8.690,0.001,2.696,4.118,0.823,52.549,81.261,23.859,16.748,14.708
 3738.409,127.081,1230.469,54.768,-99.803,3.771,8.689,0.001,2.687,3.943,1.366,44.893,79.442,22.574,18.504,15.312
 3738.909,127.167,1216.748,56.141,-98.833,4.004,8.696,0.000,2.675,4.014,2.065,38.342,77.791,21.407,17.492,14.704
 3739.409,127.026,1220.703,58.725,-97.749,4.472,8.703,0.005,2.672,4.164,2.194,32.088,77.360,21.102,15.006,13.468
 3739.909,127.073,1224.414,71.437,-97.298,5.328,8.737,0.015,2.673,4.153,2.167,26.193,78.456,21.877,12.817,12.407
 3740.409,127.236,1220.703,93.724,-97.312,6.811,8.796,0.027,2.664,3.850,2.712,20.069,80.350,23.215,11.768,12.142
 3740.909,127.072,1220.703,119.576,-97.518,9.231,8.829,0.041,2.645,3.549,3.797,15.314,82.589,24.798,11.623,12.278
 3741.409,127.238,1224.658,146.775,-97.576,12.626,8.843,0.056,2.607,3.433,6.016,15.212,85.768,27.044,12.158,12.558
 3741.909,127.119,1225.586,178.872,-97.846,16.993,8.837,0.068,2.541,3.347,9.909,20.338,90.822,30.616,12.635,12.152
 3742.409,127.281,1221.387,217.984,-98.123,22.323,8.799,0.068,2.451,3.197,15.130,27.998,96.878,34.896,12.407,11.021
 3742.909,127.245,1231.543,256.717,-99.060,28.572,8.767,0.050,2.350,3.043,21.078,33.190,102.515,38.880,10.994,9.592
 3743.409,127.163,1225.586,288.786,-100.042,34.914,8.762,0.030,2.252,2.941,26.776,31.913,106.368,41.603,9.207,8.339
 3743.909,127.250,1220.703,296.213,-100.751,41.290,8.763,0.041,2.172,2.843,31.447,23.693,107.545,42.435,7.812,7.722
 3744.409,127.116,1225.391,270.945,-101.097,46.754,9.015,0.087,2.134,2.687,33.685,14.154,107.236,42.216,6.864,7.502
 3744.909,127.252,1225.586,213.955,-101.763,48.736,9.931,0.142,2.155,2.581,32.457,8.235,105.691,41.124,6.479,7.814
 3745.409,127.248,1225.635,149.199,-103.036,46.752,10.189,0.172,2.181,2.593,30.945,6.116,101.609,38.239,6.322,8.146
 3745.909,127.197,1230.469,104.372,-104.833,41.185,9.897,0.154,2.182,2.579,30.874,7.107,94.509,33.222,6.279,8.094
 3746.409,127.087,1225.830,77.317,-105.918,36.180,9.762,0.107,2.193,2.629,30.244,9.884,86.147,27.312,6.341,7.839
 3746.909,127.287,1233.301,64.075,-105.925,32.790,9.084,0.058,2.282,2.755,25.054,14.122,77.436,21.156,6.507,7.474
 3747.409,127.178,1225.586,56.019,-106.103,28.959,8.693,0.022,2.430,2.944,16.357,17.896,71.348,16.854,6.945,7.393
 3747.909,127.181,1225.586,53.127,-106.541,23.544,8.693,0.013,2.578,3.201,7.747,19.236,69.817,15.771,7.865,7.799
 3748.409,127.245,1224.121,53.539,-106.649,18.021,8.693,0.025,2.673,3.322,2.184,17.871,71.132,16.701,9.124,8.591
 3748.909,127.260,1215.820,53.081,-105.973,14.824,8.693,0.033,2.705,3.377,0.289,15.221,73.456,18.343,10.712,10.038
 3749.409,127.320,1226.563,54.837,-104.535,13.809,8.693,0.029,2.706,3.429,0.261,13.575,73.971,18.708,11.839,11.433
 3749.909,127.247,1230.469,55.548,-103.141,13.433,8.687,0.017,2.685,3.409,1.487,13.482,74.671,19.202,12.087,12.191
 3750.409,127.194,1230.469,54.088,-101.621,12.792,8.661,0.009,2.671,3.434,2.283,14.086,77.195,20.986,11.785,12.122
 3750.909,127.156,1234.229,52.099,-100.951,12.142,8.636,0.012,2.676,3.558,1.986,14.510,78.930,22.212,11.266,11.480
 3751.409,127.350,1230.469,51.257,-100.587,12.031,8.626,0.017,2.683,3.753,1.588,14.313,79.106,22.336,10.843,10.846
 3751.909,127.318,1234.473,55.270,-100.331,12.418,8.611,0.020,2.688,3.894,1.312,13.673,79.357,22.514,10.592,10.368
 3752.409,127.235,1230.469,60.608,-100.348,12.910,8.583,0.017,2.682,3.823,1.624,12.733,80.551,23.358,10.364,10.098
 3752.909,127.116,1230.469,66.816,-100.775,13.282,8.563,0.011,2.675,3.637,2.069,11.767,82.142,24.482,10.143,9.947
 3753.409,127.294,1230.469,73.744,-101.652,13.735,8.571,0.004,2.662,3.640,2.789,11.344,81.882,24.298,9.907,9.811
 3753.909,127.310,1226.025,77.958,-101.821,14.186,8.612,0.000,2.649,3.825,3.596,11.411,80.000,22.968,9.680,9.576
 3754.409,127.187,1221.289,79.648,-101.252,14.071,8.686,0.002,2.641,3.960,4.048,11.622,79.715,22.767,9.429,9.206
 3754.909,127.242,1234.570,77.773,-100.481,13.541,8.774,0.008,2.638,4.014,4.232,11.702,80.685,23.452,9.123,8.794
 3755.409,127.285,1225.586,74.829,-100.269,13.091,8.879,0.019,2.647,3.914,3.688,11.503,84.336,26.032,8.602,8.336
 3755.909,127.177,1225.684,74.443,-100.892,13.091,8.983,0.030,2.651,3.774,3.424,10.931,89.551,29.718,7.976,7.916
 3756.409,127.133,1235.352,79.343,-102.081,13.604,9.079,0.041,2.645,3.637,3.784,9.824,95.312,33.790,7.352,7.581
 3756.909,127.329,1220.703,86.336,-103.266,14.469,9.156,0.056,2.622,3.487,5.152,8.526,103.658,39.688,6.795,7.267
 3757.409,127.245,1220.703,89.489,-104.410,16.506,9.214,0.090,2.566,3.441,8.415,7.456,111.899,45.511,6.444,7.090
 3757.909,127.354,1235.889,86.633,-105.083,20.323,9.442,0.136,2.491,3.286,12.802,6.828,115.548,48.090,6.193,6.975
 3758.409,127.183,1240.234,81.375,-105.479,25.092,10.329,0.154,2.431,3.069,16.323,6.860,112.572,45.987,6.102,7.006
 3758.909,127.263,1226.318,78.843,-104.873,28.570,10.293,0.127,2.429,2.951,16.448,7.519,104.435,40.237,6.132,7.168
 3759.409,127.244,1233.789,75.490,-103.327,28.875,9.201,0.078,2.495,3.004,12.546,8.752,95.220,33.724,6.342,7.422
 3759.909,127.144,1233.398,70.803,-101.689,26.163,8.799,0.046,2.574,3.209,7.974,11.197,87.329,28.148,6.824,7.914
 3760.409,127.254,1229.150,63.890,-101.191,21.604,8.699,0.037,2.619,3.449,5.330,18.088,77.775,21.395,7.766,8.742
 3760.909,127.319,1230.469,56.434,-102.240,16.468,8.651,0.030,2.642,3.780,3.969,31.868,67.859,14.388,9.267,10.110
 3761.409,127.385,1230.469,49.739,-104.070,11.253,8.623,0.015,2.659,4.109,2.971,51.142,58.977,8.111,11.675,12.273
 3761.909,127.262,1236.816,43.667,-105.470,6.652,8.588,0.008,2.677,4.335,1.929,69.401,52.484,3.522,15.095,15.616
 3762.409,127.362,1240.234,39.593,-105.741,3.488,8.521,0.011,2.693,4.425,1.003,79.283,49.791,1.619,19.699,20.577
 3762.909,127.307,1225.586,38.073,-105.616,2.034,8.477,0.016,2.697,4.503,0.754,82.834,49.378,1.327,25.449,27.402
 3763.409,127.209,1234.082,37.342,-105.863,1.667,8.462,0.020,2.700,4.681,0.565,83.703,49.931,1.718,31.515,34.307
 3763.909,127.369,1233.447,37.537,-106.450,1.697,8.456,0.023,2.700,4.786,0.607,90.931,50.621,2.206,36.837,38.470
 3764.409,127.412,1234.961,37.834,-107.354,1.770,8.455,0.019,2.687,4.702,1.371,110.201,51.082,2.532,40.795,40.775
 3764.909,127.353,1240.234,37.175,-107.722,1.766,8.460,0.014,2.676,4.440,1.994,135.409,51.246,2.647,42.924,40.598
 3765.409,127.414,1240.234,37.519,-107.607,1.672,8.468,0.011,2.674,4.335,2.079,155.811,51.231,2.637,44.340,40.005
 3765.909,127.375,1232.959,38.960,-107.198,1.511,8.470,0.010,2.682,4.545,1.662,161.170,51.448,2.790,46.767,39.728
 3766.409,127.309,1230.469,41.313,-106.636,1.368,8.470,0.011,2.694,4.727,0.953,158.434,52.360,3.435,48.553,39.681
 3766.909,127.427,1238.379,40.287,-106.057,1.330,8.471,0.008,2.697,4.787,0.734,152.986,53.040,3.915,51.129,40.562
 3767.409,127.293,1231.348,38.884,-104.982,1.321,8.477,0.003,2.699,4.755,0.648,149.373,52.784,3.734,51.130,39.295
 3767.909,127.436,1245.117,38.461,-103.927,1.254,8.485,-0.000,2.696,4.678,0.812,143.874,51.558,2.868,46.993,34.782
 3768.409,127.422,1226.123,38.884,-103.419,1.128,8.498,-0.002,2.689,4.559,1.214,130.511,50.184,1.897,39.244,29.116
 3768.909,127.341,1233.545,41.274,-103.179,1.072,8.522,0.001,2.687,4.379,1.348,105.607,50.323,1.995,30.999,24.010
 3769.409,127.343,1235.352,42.535,-102.420,1.314,8.540,0.009,2.692,4.189,1.068,71.937,52.654,3.643,24.781,20.650
 3769.909,127.358,1235.352,46.100,-101.240,2.082,8.547,0.020,2.696,4.018,0.805,41.556,56.301,6.219,20.321,18.287
 3770.409,127.465,1235.352,53.847,-99.878,3.706,8.559,0.025,2.685,3.890,1.448,23.949,60.145,8.936,17.612,16.662
 3770.909,127.389,1238.916,68.382,-99.154,6.299,8.549,0.021,2.659,3.714,2.973,17.580,62.941,10.913,15.575,15.295
 3771.409,127.350,1225.586,80.466,-99.328,8.969,8.556,0.013,2.637,3.623,4.297,16.798,64.008,11.666,14.290,14.067
 3771.909,127.403,1225.586,80.599,-100.257,10.727,8.581,0.014,2.641,3.632,4.038,17.726,64.137,11.758,13.352,13.290
 3772.409,127.319,1241.211,72.828,-101.015,10.881,8.608,0.025,2.664,3.668,2.717,18.415,63.339,11.194,12.714,12.456
 3772.909,127.387,1242.725,62.630,-100.994,9.983,8.673,0.039,2.688,3.747,1.297,18.814,62.542,10.630,12.370,11.967
 3773.409,127.445,1240.234,57.839,-100.308,9.300,8.721,0.047,2.699,3.623,0.628,18.358,62.222,10.404,12.074,11.435
 3773.909,127.281,1235.986,54.738,-99.546,9.173,8.734,0.042,2.691,3.531,1.100,17.528,62.375,10.512,11.798,10.944
 3774.409,127.440,1236.328,55.712,-98.738,9.480,8.736,0.030,2.669,3.552,2.392,15.924,63.438,11.264,11.343,10.535
 3774.909,127.303,1230.469,60.457,-98.093,9.953,8.775,0.019,2.645,3.599,3.788,14.084,65.102,12.440,10.714,9.987
 3775.409,127.439,1220.703,68.188,-97.341,10.834,8.772,0.014,2.638,3.680,4.217,12.892,67.123,13.868,9.949,9.560
 3775.909,127.562,1230.176,78.018,-96.882,12.116,8.727,0.011,2.639,3.624,4.149,12.795,68.534,14.865,9.278,9.156
 3776.409,127.403,1235.254,83.833,-97.233,13.210,8.726,0.011,2.644,3.513,3.860,13.223,69.434,15.501,8.947,9.091
 3776.909,127.428,1220.996,91.088,-97.915,14.007,8.728,0.017,2.642,3.370,3.974,12.933,71.010,16.615,8.985,9.288
 3777.409,127.491,1235.352,107.680,-98.954,14.920,8.747,0.030,2.614,3.291,5.589,12.570,74.899,19.363,9.472,9.605
 3777.909,127.473,1231.152,140.430,-99.178,16.792,8.785,0.043,2.557,3.259,8.938,13.672,81.350,23.922,9.926,9.687
 3778.409,127.331,1237.354,199.193,-98.598,21.584,8.798,0.046,2.461,3.136,14.555,17.029,89.342,29.571,9.729,8.925
 3778.909,127.451,1235.889,266.611,-98.319,29.643,8.751,0.047,2.365,2.988,20.194,19.612,97.377,35.249,8.671,7.775
 3779.409,127.471,1237.109,304.099,-98.760,37.873,8.730,0.057,2.321,3.001,22.738,18.107,104.504,40.286,7.109,6.520
 3779.909,127.440,1235.352,286.343,-100.144,41.700,9.121,0.086,2.315,3.169,23.094,13.253,108.429,43.059,5.771,5.584
 3780.409,127.372,1228.613,217.925,-101.550,38.997,9.410,0.136,2.290,3.222,24.590,8.054,107.598,42.472,4.730,4.950
 3780.909,127.503,1231.494,145.696,-102.547,33.737,10.029,0.192,2.223,3.078,28.462,5.285,104.183,40.059,4.055,4.541
 3781.409,127.423,1235.352,105.122,-103.041,32.609,10.969,0.235,2.141,2.819,33.288,4.350,100.033,37.126,3.600,4.309
 3781.909,127.509,1236.621,95.340,-103.447,37.078,11.203,0.251,2.090,2.630,36.240,4.071,96.966,34.958,3.354,4.142
 3782.409,127.438,1236.426,93.391,-104.448,43.769,11.166,0.231,2.058,2.582,38.130,4.150,94.281,33.061,3.277,4.111
 3782.909,127.504,1230.469,87.872,-105.774,48.157,11.055,0.181,2.062,2.565,37.880,4.774,88.932,29.280,3.368,4.150
 3783.409,127.524,1234.521,79.835,-106.847,47.499,11.157,0.115,2.159,2.693,32.251,6.595,81.165,23.792,3.652,4.353
 3783.909,127.399,1230.469,68.819,-107.494,41.060,10.136,0.057,2.350,2.967,21.070,10.841,71.419,16.904,4.179,4.743
 3784.409,127.435,1230.469,57.366,-108.098,31.220,8.723,0.019,2.552,3.305,9.250,18.618,62.000,10.247,5.051,5.411
 3784.909,127.504,1237.305,44.454,-109.484,20.813,8.527,0.003,2.664,3.571,2.715,31.810,55.666,5.771,6.554,6.756
 3785.409,127.594,1244.775,32.157,-110.790,12.203,8.527,-0.002,2.704,3.768,0.376,48.617,51.969,3.158,8.992,8.957
 3785.909,127.482,1245.117,24.132,-111.418,7.304,8.530,-0.001,2.717,3.939,-0.421,61.282,50.784,2.321,13.346,13.423
 3786.409,127.343,1249.854,20.866,-111.317,4.453,8.541,0.006,2.733,4.071,-1.325,66.304,50.987,2.465,20.416,20.206
 3786.909,127.537,1245.117,24.052,-111.051,3.158,8.557,0.014,2.741,4.042,-1.830,62.814,52.705,3.678,29.753,26.986
 3787.409,127.654,1240.137,29.509,-111.222,2.747,8.568,0.019,2.741,3.897,-1.799,56.602,54.828,5.179,34.846,27.808
 3787.909,127.434,1246.094,34.271,-111.256,2.909,8.584,0.020,2.734,3.815,-1.428,49.548,56.612,6.440,25.209,19.643
 3788.409,127.446,1254.199,42.913,-111.131,3.277,8.607,0.022,2.726,3.852,-0.919,39.792,59.662,8.595,16.391,13.688
 3788.909,127.663,1242.236,55.350,-110.934,3.807,8.628,0.024,2.700,3.978,0.570,28.264,67.757,14.316,11.136,10.317
 3789.409,127.484,1240.234,69.900,-111.431,4.999,8.642,0.032,2.620,4.074,5.239,17.698,79.368,22.522,8.702,8.798
 3789.909,127.467,1240.234,91.079,-112.508,8.198,8.704,0.044,2.429,3.819,16.409,10.697,91.410,31.032,7.752,8.592
 3790.409,127.443,1239.404,124.089,-113.370,14.901,9.462,0.048,2.231,3.338,27.985,7.294,98.370,35.951,7.444,8.691
 3790.909,127.601,1231.982,152.038,-112.995,23.641,10.456,0.040,2.180,3.045,30.970,7.721,98.854,36.292,7.335,8.586
 3791.409,127.489,1232.520,153.964,-111.345,28.615,9.700,0.032,2.317,3.090,22.983,10.698,96.859,34.882,6.813,7.553
 3791.909,127.451,1229.395,129.847,-109.614,26.812,8.605,0.040,2.533,3.397,10.331,13.495,92.585,31.862,6.228,6.490
 3792.409,127.508,1235.352,99.664,-109.088,21.179,8.542,0.068,2.623,3.538,5.111,13.717,88.126,28.711,5.834,5.965
 3792.909,127.558,1235.352,84.515,-109.825,17.639,8.805,0.122,2.547,3.370,9.507,11.399,85.350,26.749,5.754,5.926
 3793.409,127.554,1243.604,79.740,-110.576,19.048,10.045,0.179,2.362,3.077,20.355,8.738,85.650,26.961,5.991,6.400
 3793.909,127.616,1240.234,74.617,-110.457,23.439,11.701,0.224,2.140,2.785,33.324,6.949,87.988,28.613,6.158,6.901
 3794.409,127.578,1237.109,73.175,-109.775,28.866,12.116,0.239,1.950,2.526,44.469,6.188,90.404,30.321,5.908,7.032
 3794.909,127.540,1235.938,74.133,-109.049,33.943,11.854,0.230,1.836,2.407,51.111,6.006,92.216,31.601,5.319,6.752
 3795.409,127.480,1235.352,76.019,-108.975,37.756,12.177,0.223,1.840,2.426,50.862,5.996,93.775,32.703,4.669,6.029
 3795.909,127.487,1235.352,77.488,-109.407,39.095,12.633,0.221,1.939,2.485,45.091,6.011,95.052,33.605,4.298,5.463
 3796.409,127.621,1235.352,76.773,-109.927,38.450,12.252,0.221,2.064,2.562,37.805,5.929,94.131,32.954,4.238,5.155
 3796.909,127.503,1244.922,78.065,-110.084,38.108,11.207,0.213,2.103,2.620,35.508,5.736,92.474,31.784,4.386,5.056
 3797.409,127.585,1242.676,78.250,-109.330,40.973,11.057,0.189,2.047,2.538,38.787,5.819,91.010,30.749,4.648,5.214
 3797.909,127.676,1240.088,75.584,-108.556,45.889,11.357,0.145,2.031,2.505,39.697,7.315,89.196,29.467,4.762,5.301
 3798.409,127.498,1240.723,63.876,-108.146,46.247,10.574,0.090,2.156,2.899,32.376,10.228,87.458,28.239,4.762,5.377
 3798.909,127.508,1245.117,50.346,-108.105,39.573,9.355,0.061,2.311,3.434,23.319,12.042,86.045,27.240,4.734,5.466
 3799.409,127.502,1248.047,47.208,-107.850,27.748,8.918,0.079,2.306,3.591,23.624,11.307,86.213,27.359,5.021,5.895
 3799.909,127.625,1241.406,54.123,-107.699,20.536,9.719,0.120,2.165,3.238,31.876,8.991,85.886,27.128,5.755,6.990
 3800.409,127.598,1246.826,65.688,-107.975,23.739,10.263,0.136,2.070,2.703,37.410,8.534,83.541,25.471,6.891,8.360
 3800.909,127.633,1244.287,72.162,-108.320,29.354,10.411,0.105,2.152,2.723,32.646,12.938,79.135,22.357,7.936,9.248
 3801.409,127.578,1236.865,70.611,-107.822,29.039,9.659,0.057,2.359,3.068,20.512,20.193,72.324,17.543,8.130,8.761
 3801.909,127.665,1240.234,64.601,-106.408,21.302,8.647,0.029,2.546,3.282,9.589,25.016,69.229,15.356,7.748,7.866
 3802.409,127.517,1243.848,59.140,-104.204,11.625,8.694,0.029,2.630,3.204,4.694,24.096,73.280,18.219,7.547,7.480
 3802.909,127.665,1245.117,59.890,-102.374,6.788,8.767,0.044,2.608,3.018,5.968,18.354,81.780,24.226,7.722,7.323
 3803.409,127.667,1245.117,66.153,-101.310,7.230,8.856,0.079,2.527,2.998,10.684,12.160,89.782,29.881,7.915,7.414
 3803.909,127.556,1246.631,73.725,-100.986,10.864,9.299,0.124,2.457,2.966,14.782,8.452,90.196,30.174,7.474,7.261
 3804.409,127.489,1254.102,79.503,-100.957,16.127,10.114,0.144,2.423,2.884,16.794,6.874,85.934,27.162,6.483,6.852
 3804.909,127.638,1251.367,82.825,-101.018,20.374,10.110,0.129,2.420,2.886,16.977,6.565,83.026,25.107,5.501,6.285
 3805.409,127.682,1240.771,83.303,-101.399,22.446,9.437,0.108,2.404,2.961,17.913,6.401,84.181,25.923,4.935,5.832
 3805.909,127.705,1235.352,79.651,-102.064,24.201,9.359,0.101,2.313,2.944,23.223,5.864,85.839,27.095,4.855,5.859
 3806.409,127.629,1239.893,72.609,-102.644,28.301,9.548,0.102,2.228,2.765,28.180,5.822,83.244,25.261,5.114,6.172
 3806.909,127.703,1245.117,64.896,-102.183,32.477,9.997,0.073,2.244,2.818,27.224,9.798,75.262,19.620,5.710,6.800
 3807.409,127.674,1245.117,54.516,-101.006,31.584,9.531,0.033,2.368,3.222,19.988,19.087,64.538,12.041,6.410,7.351
 3807.909,127.796,1242.627,41.677,-100.573,23.004,8.655,0.009,2.536,3.804,10.148,31.075,56.422,6.306,7.356,7.948
 3808.409,127.687,1244.971,33.488,-100.932,12.458,8.645,-0.003,2.636,4.217,4.334,39.481,52.000,3.181,8.708,9.085
 3808.909,127.672,1240.234,31.724,-102.216,5.870,8.653,-0.001,2.666,4.256,2.588,40.333,51.289,2.677,11.198,11.059
 3809.409,127.779,1240.234,33.228,-103.087,3.364,8.669,0.005,2.684,4.204,1.527,37.418,52.496,3.531,15.247,14.433
 3809.909,127.643,1243.164,34.499,-103.001,3.264,8.691,0.012,2.703,4.140,0.430,34.498,53.800,4.452,20.832,18.521
 3810.409,127.629,1245.117,35.744,-102.122,3.690,8.714,0.017,2.710,4.067,-0.024,32.072,55.030,5.322,23.939,21.948
 3810.909,127.730,1241.943,38.289,-101.018,4.148,8.746,0.017,2.701,3.947,0.511,28.643,57.216,6.866,22.944,23.290
 3811.409,127.639,1240.234,42.395,-100.343,4.598,8.790,0.017,2.678,3.804,1.848,24.689,60.692,9.323,20.243,21.824
 3811.909,127.738,1243.652,44.828,-100.058,5.252,8.808,0.021,2.657,3.708,3.112,21.836,65.031,12.390,18.504,19.786
 3812.409,127.622,1249.414,45.135,-99.726,6.228,8.807,0.028,2.646,3.673,3.727,20.485,68.890,15.117,17.709,18.026
 3812.909,127.654,1264.648,45.102,-98.915,7.443,8.770,0.034,2.641,3.696,4.033,19.670,71.329,16.841,17.224,17.045
 3813.409,127.772,1249.609,47.106,-98.312,8.769,8.734,0.036,2.627,3.627,4.845,18.544,72.586,17.729,16.691,16.435
 3813.909,127.654,1235.352,53.135,-97.904,10.180,8.746,0.036,2.611,3.419,5.765,17.440,73.840,18.615,16.094,16.047
 3814.409,127.701,1236.914,59.893,-99.900,11.583,8.744,0.033,2.602,3.168,6.320,17.144,75.503,19.790,15.487,15.609
 3814.909,127.805,1244.336,64.610,-102.557,12.597,8.746,0.023,2.602,3.059,6.309,17.743,80.307,23.185,14.944,15.050
 3815.409,127.715,1245.117,64.034,-102.172,12.786,8.736,0.013,2.609,3.122,5.910,17.867,87.653,28.377,14.564,14.498
 3815.909,127.670,1253.809,60.318,-100.597,12.282,8.674,0.008,2.612,3.207,5.753,16.770,94.241,33.032,14.142,13.901
 3816.409,127.737,1236.475,59.366,-96.526,11.709,8.624,0.011,2.619,3.292,5.345,15.003,96.674,34.752,13.685,13.330
 3816.909,127.854,1245.117,60.748,-95.396,11.354,8.589,0.013,2.625,3.402,4.975,13.966,93.281,32.354,13.077,12.642
 3817.409,127.775,1240.625,62.772,-94.985,10.798,8.574,0.012,2.634,3.608,4.417,14.375,91.826,31.326,12.254,11.801
 3817.909,127.847,1245.020,62.256,-94.388,9.754,8.573,0.011,2.642,3.758,3.965,14.581,94.489,33.208,11.445,11.050
 3818.409,127.805,1240.234,63.639,-93.661,8.616,8.576,0.016,2.637,3.698,4.244,13.237,98.202,35.831,10.706,10.535
 3818.909,127.802,1245.117,70.210,-93.624,8.427,8.613,0.026,2.631,3.545,4.634,11.298,98.708,36.189,10.116,10.249
 3819.409,127.737,1242.383,76.803,-94.146,9.717,8.693,0.027,2.619,3.560,5.315,10.562,90.535,30.413,9.721,10.026
 3819.909,127.711,1240.625,81.919,-94.901,11.186,8.676,0.025,2.614,3.776,5.608,10.996,81.505,24.032,9.451,9.788
 3820.409,127.823,1239.160,79.889,-95.208,11.671,8.676,0.035,2.620,3.942,5.283,11.147,77.193,20.984,9.301,9.506
 3820.909,127.880,1250.000,77.540,-94.893,11.384,8.771,0.051,2.624,3.818,5.048,10.596,77.533,21.225,9.306,9.397
 3821.409,127.690,1246.826,76.063,-94.356,11.106,8.898,0.058,2.634,3.569,4.430,10.628,77.831,21.435,9.414,9.429
 3821.909,127.771,1254.004,70.555,-93.769,11.122,8.885,0.044,2.645,3.540,3.829,11.897,74.262,18.913,9.566,9.576
 3822.409,127.855,1250.000,63.118,-93.552,10.973,8.724,0.023,2.649,3.724,3.587,13.001,69.629,15.639,9.865,9.941
 3822.909,127.663,1240.625,59.158,-93.498,10.392,8.695,0.015,2.647,3.788,3.680,12.727,67.021,13.796,10.365,10.532
 3823.409,127.769,1236.572,63.695,-93.871,9.999,8.715,0.015,2.636,3.589,4.305,11.794,67.135,13.876,11.307,11.277
 3823.909,127.849,1240.234,67.987,-94.681,10.114,8.710,0.012,2.629,3.427,4.716,12.368,66.474,13.409,12.396,11.613
 3824.409,127.796,1248.047,64.055,-95.937,10.130,8.703,0.004,2.632,3.541,4.571,14.566,63.919,11.604,12.446,10.713
 3824.909,127.781,1254.883,55.273,-97.348,9.284,8.706,-0.000,2.641,3.790,4.027,16.417,60.836,9.425,10.939,9.072
 3825.409,127.886,1254.883,48.596,-98.462,7.653,8.720,0.001,2.651,3.961,3.430,16.501,58.548,7.808,8.624,7.477
 3825.909,127.770,1240.234,49.269,-99.074,6.316,8.740,0.016,2.642,4.021,3.972,13.975,59.833,8.716,6.977,6.503
 3826.409,127.729,1244.580,57.938,-99.617,6.339,8.852,0.054,2.583,3.939,7.405,10.209,66.152,13.182,6.056,6.148
 3826.909,127.743,1249.219,77.475,-100.500,9.144,9.270,0.101,2.464,3.551,14.402,6.796,75.977,20.125,5.718,6.194
 3827.409,127.828,1241.113,99.580,-101.810,15.284,10.025,0.124,2.351,3.092,20.993,5.045,84.675,26.272,5.715,6.494
 3827.909,127.835,1240.234,107.958,-102.741,23.220,10.018,0.110,2.349,2.832,21.100,6.981,86.199,27.349,5.746,6.549
 3828.409,127.711,1235.400,98.511,-102.961,27.768,9.213,0.070,2.441,2.884,15.716,12.123,80.590,23.385,5.824,6.451
 3828.909,127.787,1250.098,78.292,-103.033,24.945,8.746,0.034,2.565,3.224,8.501,18.314,71.475,16.944,6.070,6.442
 3829.409,127.944,1254.297,61.742,-103.103,17.702,8.671,0.013,2.635,3.501,4.387,21.845,64.383,11.932,6.680,6.665
 3829.909,127.866,1242.969,59.469,-102.977,11.059,8.685,0.014,2.629,3.662,4.714,19.732,62.453,10.568,7.684,7.207
 3830.409,127.858,1240.234,69.438,-103.143,8.173,8.697,0.035,2.608,3.675,5.950,14.885,63.022,10.970,8.291,7.299
 3830.909,127.928,1243.213,83.671,-103.445,8.636,8.934,0.052,2.580,3.689,7.594,10.515,63.528,11.327,7.382,6.685
 3831.409,127.958,1249.365,99.452,-104.559,10.076,8.983,0.072,2.546,3.678,9.584,7.591,64.097,11.729,5.695,5.692
 3831.909,127.902,1245.117,123.505,-106.096,11.791,9.204,0.100,2.464,3.492,14.392,5.667,69.145,15.297,4.265,4.797
 3832.409,127.759,1243.750,153.538,-107.566,15.274,9.876,0.127,2.330,3.058,22.240,3.979,82.688,24.868,3.383,4.211
 3832.909,127.989,1256.299,169.073,-108.353,22.460,10.682,0.127,2.189,2.501,30.480,3.019,102.189,38.650,2.863,3.775
 3833.409,127.870,1245.117,159.059,-108.511,32.477,10.808,0.095,2.114,2.229,34.878,2.877,118.564,50.222,2.559,3.470
 3833.909,127.891,1241.455,128.745,-108.019,42.165,10.359,0.057,2.131,2.209,33.856,3.005,125.859,55.377,2.391,3.238
 3834.409,127.804,1247.852,101.164,-107.635,48.395,10.252,0.037,2.191,2.288,30.322,3.139,123.892,53.987,2.329,3.107
 3834.909,127.889,1254.883,92.254,-107.654,51.083,10.330,0.030,2.244,2.360,27.256,3.253,116.200,48.551,2.383,3.099
 3835.409,127.948,1238.574,97.996,-108.151,50.517,10.465,0.032,2.279,2.483,25.224,3.397,105.488,40.981,2.541,3.176
 3835.909,127.865,1257.568,108.928,-109.006,47.071,10.449,0.050,2.318,2.753,22.924,3.609,94.114,32.943,2.789,3.327
 3836.409,127.863,1254.346,113.874,-109.458,41.856,10.469,0.083,2.370,3.031,19.879,3.869,84.655,26.258,3.078,3.533
 3836.909,128.003,1240.723,113.098,-108.898,36.887,10.833,0.124,2.411,3.244,17.474,4.089,78.683,22.038,3.350,3.781
 3837.409,127.953,1235.352,109.155,-107.681,34.304,11.195,0.168,2.401,3.283,18.044,4.191,77.148,20.953,3.547,4.025
 3837.909,127.921,1244.629,105.703,-106.386,33.887,11.391,0.208,2.348,3.154,21.142,4.200,78.595,21.975,3.682,4.218
 3838.409,127.860,1252.295,103.349,-105.831,35.339,11.781,0.235,2.297,2.957,24.161,4.156,81.102,23.747,3.714,4.273
 3838.909,127.986,1254.883,102.790,-104.836,38.586,12.354,0.239,2.278,2.748,25.249,4.111,83.139,25.187,3.662,4.199
 3839.409,128.045,1250.195,106.731,-103.667,42.576,12.570,0.220,2.302,2.660,23.880,4.062,84.200,25.936,3.537,4.035
 3839.909,127.818,1250.000,105.886,-102.741,45.120,12.362,0.200,2.331,2.651,22.173,3.998,84.929,26.452,3.389,3.839
 3840.409,127.917,1244.434,103.911,-102.639,46.105,12.069,0.187,2.327,2.644,22.386,3.921,85.817,27.079,3.277,3.680
 3840.909,127.972,1241.553,104.302,-102.843,47.265,11.986,0.182,2.300,2.609,23.959,3.854,86.797,27.772,3.210,3.567
 3841.409,127.896,1254.883,106.332,-102.659,49.104,11.913,0.176,2.290,2.598,24.566,3.834,87.525,28.286,3.187,3.496
 3841.909,127.941,1253.516,109.508,-102.248,49.242,11.591,0.163,2.310,2.683,23.401,3.860,87.598,28.338,3.184,3.461
 3842.409,127.905,1245.117,110.097,-102.023,45.888,11.385,0.157,2.360,2.766,20.481,3.913,87.019,27.929,3.198,3.443
 3842.909,128.050,1245.117,109.867,-102.165,41.853,11.326,0.155,2.398,2.746,18.259,3.981,86.414,27.501,3.217,3.436
 3843.409,127.904,1248.584,112.744,-102.256,40.513,11.219,0.157,2.411,2.725,17.495,4.048,85.695,26.993,3.224,3.418
 3843.909,128.040,1250.000,114.415,-102.278,40.861,11.241,0.165,2.414,2.819,17.295,4.093,85.042,26.532,3.206,3.395
 3844.409,128.052,1250.000,114.242,-102.511,40.606,11.371,0.182,2.400,2.923,18.127,4.086,84.953,26.469,3.135,3.367
 3844.909,128.002,1244.336,113.692,-102.549,39.724,11.601,0.206,2.352,2.898,20.938,3.998,85.952,27.174,3.069,3.362
 3845.409,128.109,1250.928,111.566,-102.272,39.530,11.902,0.226,2.282,2.723,25.027,3.846,87.987,28.612,3.025,3.403
 3845.909,128.026,1248.389,111.555,-102.065,40.631,12.219,0.235,2.222,2.621,28.537,3.675,90.255,30.215,3.033,3.477
 3846.409,128.020,1249.268,108.784,-101.943,42.846,12.184,0.219,2.127,2.651,34.119,3.525,91.483,31.084,3.101,3.635
 3846.909,128.082,1245.117,104.613,-101.952,45.948,11.693,0.182,2.019,2.583,40.418,3.582,89.308,29.546,3.180,3.793
 3847.409,127.933,1253.906,99.866,-102.415,48.374,11.787,0.131,1.975,2.574,42.972,4.084,84.447,26.111,3.322,3.960
 3847.909,128.039,1245.801,94.302,-103.645,46.285,11.009,0.103,2.025,2.767,40.030,4.768,80.092,23.033,3.466,4.059
 3848.409,128.087,1240.234,91.753,-105.475,39.393,9.872,0.121,2.106,2.952,35.310,5.141,78.018,21.567,3.641,4.039
 3848.909,127.930,1242.529,90.728,-106.428,32.761,10.646,0.159,2.121,2.934,34.433,5.009,77.916,21.495,3.715,4.015
 3849.409,128.022,1254.883,94.118,-106.618,30.488,11.836,0.169,2.118,2.712,34.636,4.759,79.300,22.474,3.583,3.833
 3849.909,128.017,1254.883,97.236,-106.938,31.775,11.277,0.123,2.145,2.772,33.042,4.667,86.376,27.475,3.219,3.623
 3850.409,128.109,1240.479,97.091,-108.587,31.632,9.941,0.076,2.135,2.993,33.634,4.398,99.836,36.987,2.802,3.411
 3850.909,128.122,1250.684,93.105,-110.779,29.134,10.348,0.083,2.041,2.938,39.128,3.795,118.956,50.499,2.507,3.308
 3851.409,128.044,1254.883,90.425,-112.932,29.826,11.490,0.127,1.947,2.609,44.631,3.165,133.767,60.966,2.348,3.360
 3851.909,128.045,1260.938,90.305,-113.440,36.920,11.781,0.162,1.943,2.286,44.864,2.928,136.168,62.663,2.316,3.407
 3852.409,128.037,1254.883,92.769,-113.605,45.525,11.733,0.164,2.022,2.279,40.215,3.000,128.822,57.471,2.368,3.457
 3852.909,128.089,1254.883,96.887,-113.157,49.742,11.530,0.141,2.119,2.500,34.559,3.193,114.127,47.086,2.475,3.440
 3853.409,127.969,1253.955,99.086,-112.441,47.600,11.195,0.126,2.205,2.718,29.545,3.516,99.267,36.585,2.630,3.461
 3853.909,128.091,1250.000,102.555,-110.916,41.850,11.162,0.132,2.292,2.856,24.465,3.970,86.815,27.785,2.860,3.579
 3854.409,128.154,1258.594,104.086,-108.510,36.526,11.332,0.155,2.366,2.890,20.105,4.432,78.798,22.119,3.183,3.775
 3854.909,128.218,1254.883,103.463,-105.691,33.468,11.442,0.178,2.401,2.848,18.096,4.742,76.909,20.784,3.590,4.103
 3855.409,127.968,1253.467,100.789,-103.553,32.681,11.521,0.194,2.393,2.874,18.509,4.837,79.071,22.312,3.945,4.453
 3855.909,128.044,1253.955,97.682,-102.402,33.315,11.574,0.205,2.361,2.951,20.420,4.795,82.436,24.690,4.097,4.689
 3856.409,128.137,1245.117,100.638,-102.422,34.309,11.710,0.210,2.329,2.948,22.268,4.700,84.978,26.486,4.019,4.722
 3856.909,128.174,1253.516,107.516,-102.687,35.459,11.942,0.199,2.322,2.846,22.665,4.572,86.173,27.331,3.840,4.561
 3857.409,128.091,1259.082,108.313,-102.564,36.189,11.988,0.175,2.345,2.786,21.361,4.384,86.344,27.451,3.695,4.382
 3857.909,128.189,1250.000,104.165,-101.549,36.204,11.886,0.162,2.386,2.769,18.966,4.138,86.357,27.461,3.646,4.233
 3858.409,128.140,1256.982,96.566,-100.782,36.540,11.807,0.161,2.402,2.756,18.006,3.960,86.618,27.646,3.709,4.181
 3858.909,128.085,1269.043,90.847,-100.166,36.957,11.764,0.154,2.402,2.692,17.997,4.052,86.507,27.567,3.849,4.210
 3859.409,128.056,1255.469,88.348,-100.254,36.468,11.285,0.117,2.418,2.594,17.098,4.661,84.387,26.069,4.027,4.271
 3859.909,128.218,1250.000,87.679,-99.862,34.041,10.436,0.067,2.462,2.573,14.522,5.532,80.617,23.404,4.226,4.354
 3860.409,128.113,1252.881,89.568,-98.723,28.948,9.972,0.037,2.535,2.605,10.243,6.236,76.805,20.710,4.445,4.440
 3860.909,128.111,1259.766,89.113,-97.505,23.865,9.992,0.023,2.572,2.609,8.042,6.512,74.650,19.187,4.692,4.568
 3861.409,128.231,1254.199,83.381,-97.199,20.826,10.020,0.033,2.568,2.623,8.310,6.320,74.536,19.106,4.875,4.681
 3861.909,128.174,1250.000,78.568,-97.584,19.731,9.975,0.052,2.531,2.625,10.453,5.960,74.944,19.395,4.895,4.696
 3862.409,128.139,1253.027,80.409,-98.573,19.830,10.066,0.089,2.474,2.645,13.829,5.463,75.169,19.554,4.707,4.638
 3862.909,128.054,1253.418,83.982,-99.481,20.406,10.271,0.142,2.416,2.606,17.174,4.822,75.990,20.135,4.408,4.524
 3863.409,128.183,1245.117,89.489,-100.290,21.635,10.880,0.180,2.349,2.561,21.124,4.168,78.573,21.960,4.127,4.426
 3863.909,128.266,1263.721,93.629,-100.573,24.096,11.360,0.199,2.279,2.580,25.189,3.712,82.479,24.720,3.914,4.310
 3864.409,128.103,1256.250,98.583,-100.446,28.908,11.547,0.205,2.210,2.537,29.262,3.591,85.909,27.144,3.738,4.129
 3864.909,128.151,1252.539,104.163,-99.834,34.789,11.704,0.209,2.172,2.506,31.465,3.685,86.887,27.835,3.603,3.944
 3865.409,128.280,1245.117,102.801,-99.013,38.789,12.057,0.217,2.186,2.493,30.654,3.816,85.234,26.667,3.490,3.768
 3865.909,128.150,1250.000,97.972,-98.173,39.360,12.343,0.219,2.229,2.548,28.153,3.858,82.675,24.859,3.420,3.647
 3866.409,128.205,1250.000,92.592,-98.039,37.613,12.439,0.215,2.246,2.628,27.111,3.816,80.985,23.665,3.395,3.581
 3866.909,128.268,1248.438,89.143,-98.560,37.101,12.376,0.206,2.222,2.595,28.556,3.729,80.476,23.304,3.377,3.530
 3867.409,128.199,1242.285,90.342,-99.247,38.323,12.275,0.190,2.211,2.573,29.178,3.635,80.446,23.283,3.342,3.482
 3867.909,128.188,1245.947,92.757,-99.440,38.732,12.404,0.163,2.237,2.658,27.653,3.531,80.362,23.224,3.256,3.398
 3868.409,128.257,1254.883,92.080,-98.936,37.495,12.491,0.146,2.282,2.799,25.034,3.404,80.748,23.496,3.132,3.285
 3868.909,128.167,1254.883,86.289,-98.232,35.260,12.356,0.153,2.306,2.852,23.597,3.253,82.536,24.761,3.002,3.163
 3869.409,128.065,1240.820,81.987,-97.549,34.177,12.410,0.164,2.297,2.794,24.164,3.103,85.227,26.662,2.879,3.044
 3869.909,128.188,1257.422,85.365,-97.028,36.236,12.433,0.167,2.280,2.702,25.136,2.985,87.353,28.165,2.768,2.934
 3870.409,128.300,1254.785,96.987,-96.518,40.171,12.249,0.160,2.257,2.659,26.490,2.892,88.345,28.865,2.661,2.835
 3870.909,128.141,1250.293,111.882,-96.558,42.782,12.185,0.168,2.243,2.649,27.307,2.814,88.765,29.163,2.567,2.750
 3871.409,128.382,1250.000,124.005,-96.815,42.407,11.998,0.191,2.237,2.632,27.640,2.753,89.348,29.574,2.492,2.687
 3871.909,128.233,1247.168,128.589,-97.601,39.937,12.093,0.211,2.236,2.655,27.699,2.721,90.036,30.061,2.443,2.634
 3872.409,128.078,1254.395,126.938,-98.405,38.017,12.164,0.221,2.238,2.704,27.614,2.718,90.569,30.437,2.417,2.586
 3872.909,128.257,1250.000,119.699,-98.857,37.401,11.949,0.211,2.202,2.771,29.694,2.748,90.472,30.369,2.384,2.517
 3873.409,128.344,1253.418,112.006,-98.637,37.924,11.787,0.202,2.169,2.809,31.630,2.813,89.466,29.658,2.343,2.445
 3873.909,128.306,1251.660,107.903,-98.310,39.077,11.611,0.201,2.172,2.846,31.460,2.875,87.940,28.580,2.272,2.378
 3874.409,128.244,1252.930,108.026,-98.709,40.044,11.117,0.206,2.199,2.853,29.887,2.862,87.382,28.186,2.219,2.353
 3874.909,128.233,1255.664,116.630,-100.569,40.994,11.123,0.209,2.213,2.778,29.038,2.778,89.405,29.615,2.206,2.424
 3875.409,128.298,1259.766,138.107,-104.156,42.221,11.475,0.198,2.186,2.642,30.620,2.740,93.560,32.551,2.271,2.593
 3875.909,128.384,1259.766,166.717,-107.785,45.273,11.393,0.178,2.145,2.582,33.015,2.857,97.607,35.412,2.451,2.910
 3876.409,128.313,1250.635,180.387,-110.279,49.651,10.846,0.164,2.148,2.585,32.860,3.233,100.300,37.315,2.755,3.331
 3876.909,128.169,1240.234,165.941,-112.647,51.119,11.118,0.139,2.219,2.667,28.733,4.143,102.643,38.971,3.167,3.788
 3877.409,128.276,1248.438,129.407,-114.375,46.174,11.388,0.099,2.347,2.872,21.202,5.508,104.516,40.294,3.566,4.090
 3877.909,128.205,1254.883,96.069,-114.813,35.677,10.350,0.052,2.491,3.196,12.820,6.709,104.687,40.415,3.659,3.945
 3878.409,128.266,1254.883,83.790,-114.781,24.685,9.812,0.018,2.522,3.597,10.967,6.862,102.841,39.110,3.356,3.559
 3878.909,128.405,1254.883,83.702,-114.471,18.688,9.797,0.019,2.413,3.656,17.386,5.782,102.162,38.630,2.863,3.207
 3879.409,128.335,1241.211,86.852,-113.327,20.662,9.994,0.049,2.219,3.228,28.701,4.133,107.494,42.398,2.393,3.002
 3879.909,128.382,1254.883,88.109,-112.270,28.385,10.570,0.092,2.065,2.647,37.710,2.820,118.393,50.101,2.051,2.928
 3880.409,128.334,1259.668,88.866,-111.531,40.832,11.122,0.136,2.013,2.183,40.745,2.213,130.357,58.556,1.807,2.767
 3880.909,128.376,1259.766,90.280,-114.719,52.622,11.624,0.163,2.006,2.035,41.164,2.064,138.801,64.524,1.637,2.543
 3881.409,128.349,1254.590,93.879,-115.763,58.654,12.123,0.167,2.010,2.086,40.944,2.090,140.528,65.744,1.548,2.336
 3881.909,128.420,1250.586,101.858,-115.443,60.456,12.279,0.152,2.036,2.190,39.404,2.133,137.013,63.260,1.524,2.205
 3882.409,128.181,1259.766,113.633,-113.239,59.518,11.831,0.128,2.116,2.392,34.732,2.186,129.520,57.964,1.592,2.225
 3882.909,128.242,1268.994,123.099,-111.575,58.411,11.404,0.105,2.216,2.627,28.863,2.253,119.816,51.107,1.751,2.358
 3883.409,128.372,1261.572,121.682,-112.209,55.540,11.518,0.097,2.302,2.902,23.834,2.359,108.889,43.384,2.011,2.608
 3883.909,128.210,1259.033,112.996,-112.613,49.479,12.000,0.118,2.370,3.142,19.912,2.532,97.536,35.361,2.352,2.944
 3884.409,128.378,1254.883,102.164,-112.570,41.857,12.548,0.157,2.413,3.302,17.389,2.801,87.285,28.116,2.747,3.330
 3884.909,128.393,1250.000,95.154,-111.499,35.196,12.790,0.194,2.433,3.381,16.175,3.127,79.630,22.707,3.133,3.709
 3885.409,128.335,1253.564,93.567,-109.707,30.884,12.840,0.211,2.426,3.321,16.611,3.449,75.261,19.619,3.470,4.017
 3885.909,128.395,1252.441,97.231,-106.995,28.708,12.751,0.204,2.399,3.208,18.161,3.692,74.084,18.787,3.722,4.213
 3886.409,128.367,1256.006,105.677,-104.225,28.029,12.635,0.184,2.375,3.060,19.611,3.845,74.806,19.297,3.860,4.291
 3886.909,128.438,1254.883,113.608,-101.579,28.450,12.694,0.160,2.367,2.935,20.033,3.913,76.216,20.294,3.940,4.330
 3887.409,128.370,1254.883,116.360,-99.844,29.357,12.871,0.147,2.380,2.888,19.295,3.913,77.761,21.386,3.986,4.327
 3887.909,128.332,1254.883,112.156,-99.081,29.762,12.947,0.150,2.399,2.866,18.171,3.896,79.844,22.858,4.046,4.285
 3888.409,128.355,1254.883,103.204,-98.739,29.524,12.903,0.158,2.415,2.898,17.274,3.935,82.185,24.513,4.035,4.163
 3888.909,128.352,1241.064,95.675,-98.644,29.161,12.650,0.155,2.425,2.993,16.638,4.074,83.149,25.193,3.897,3.927
 3889.409,128.234,1250.000,91.288,-98.952,28.763,12.317,0.147,2.436,3.079,16.045,4.176,82.717,24.888,3.660,3.700
 3889.909,128.369,1257.617,89.756,-99.617,28.341,12.077,0.152,2.436,3.084,16.004,3.999,82.152,24.489,3.393,3.525
 3890.409,128.382,1245.410,91.263,-101.120,28.632,12.031,0.162,2.408,2.968,17.647,3.537,83.805,25.658,3.210,3.479
 3890.909,128.427,1249.902,97.004,-102.534,30.522,12.234,0.167,2.357,2.794,20.615,2.955,88.334,28.858,3.054,3.438
 3891.409,128.374,1254.883,108.993,-104.132,33.884,12.287,0.156,2.321,2.701,22.769,2.561,92.468,31.780,2.879,3.274
 3891.909,128.441,1254.883,128.242,-105.674,37.442,12.041,0.145,2.330,2.767,22.235,2.482,95.372,33.832,2.593,2.950
 3892.409,128.532,1254.883,148.251,-107.381,40.280,11.911,0.150,2.358,2.880,20.600,2.510,98.915,36.335,2.270,2.594
 3892.909,128.366,1254.883,161.511,-109.557,43.464,12.098,0.163,2.332,2.912,22.103,2.473,107.183,42.179,1.998,2.393
 3893.409,128.433,1254.883,159.772,-111.052,45.788,12.202,0.175,2.246,2.734,27.134,2.326,119.014,50.540,1.825,2.326
 3893.909,128.360,1254.883,143.888,-112.098,46.301,12.157,0.168,2.156,2.468,32.382,2.192,129.140,57.696,1.768,2.417
 3894.409,128.413,1263.867,126.967,-111.676,46.142,12.012,0.145,2.134,2.292,33.660,2.166,133.669,60.897,1.805,2.599
 3894.909,128.458,1259.766,117.484,-110.753,46.646,11.568,0.106,2.184,2.286,30.746,2.265,129.675,58.074,1.908,2.781
 3895.409,128.351,1253.857,113.170,-110.835,47.445,11.221,0.069,2.269,2.483,25.805,2.482,118.403,50.108,2.055,2.912
 3895.909,128.426,1257.129,105.557,-112.165,45.770,11.260,0.060,2.356,2.868,20.694,2.894,104.341,40.170,2.215,2.953
 3896.409,128.403,1260.986,96.662,-113.170,40.575,11.351,0.084,2.407,3.341,17.729,3.381,93.801,32.721,2.410,3.016
 3896.909,128.349,1260.840,92.319,-112.096,34.564,11.414,0.134,2.404,3.540,17.908,3.678,90.424,30.335,2.681,3.221
 3897.409,128.517,1235.352,94.069,-109.846,31.905,11.845,0.170,2.360,3.413,20.485,3.674,94.310,33.081,3.052,3.623
 3897.909,128.516,1243.457,100.631,-107.984,33.090,12.242,0.177,2.326,3.142,22.476,3.488,99.983,37.090,3.515,4.214
 3898.409,128.356,1241.943,103.791,-106.601,36.366,12.104,0.167,2.333,2.974,22.068,3.443,102.595,38.937,3.936,4.781
 3898.909,128.416,1245.117,99.362,-106.027,38.910,12.245,0.155,2.369,3.057,19.944,3.749,102.854,39.119,4.195,5.078
 3899.409,128.315,1250.977,88.091,-105.702,39.093,12.196,0.149,2.402,3.248,17.983,4.431,103.879,39.844,4.324,5.183
 3899.909,128.404,1249.609,75.473,-105.502,37.167,11.117,0.136,2.398,3.392,18.256,5.265,108.326,42.987,4.491,5.273
 3900.409,128.456,1252.197,67.845,-105.100,33.054,10.769,0.110,2.382,3.453,19.175,6.189,114.264,47.183,4.974,5.541
 3900.909,128.559,1254.883,67.711,-104.735,28.353,11.385,0.088,2.384,3.521,19.081,6.917,116.131,48.503,5.870,6.021
 3901.409,128.463,1257.275,73.028,-104.744,23.857,10.772,0.094,2.442,3.545,15.650,7.233,110.481,44.510,6.899,6.319
 3901.909,128.446,1259.473,80.781,-105.296,20.153,10.434,0.098,2.515,3.513,11.384,7.762,104.263,40.115,7.232,6.289
 3902.409,128.483,1245.117,84.202,-105.910,17.342,10.917,0.079,2.558,3.597,8.862,8.716,102.198,38.656,6.272,5.821
 3902.909,128.467,1254.883,84.593,-107.513,14.558,10.318,0.043,2.551,3.822,9.312,9.121,105.389,40.911,5.136,5.322
 3903.409,128.387,1254.883,91.658,-110.327,12.378,9.635,0.024,2.428,3.940,16.467,7.969,111.317,45.100,4.347,5.116
 3903.909,128.455,1245.117,102.215,-112.541,12.396,10.069,0.051,2.251,3.579,26.850,5.671,115.828,48.289,3.817,4.882
 3904.409,128.407,1245.117,114.052,-114.036,18.309,11.463,0.096,2.115,2.891,34.770,3.620,119.248,50.705,3.406,4.467
 3904.909,128.579,1258.984,119.235,-114.776,28.725,12.077,0.126,2.113,2.485,34.908,2.828,118.041,49.853,2.928,3.756
 3905.409,128.518,1258.252,120.194,-114.609,38.330,11.556,0.136,2.206,2.531,29.455,2.724,112.399,45.865,2.489,3.124
 3905.909,128.449,1259.766,127.126,-114.060,42.756,11.347,0.138,2.243,2.645,27.326,2.622,106.832,41.930,2.176,2.748
 3906.409,128.565,1263.330,136.695,-113.103,42.422,11.671,0.148,2.188,2.546,30.520,2.493,106.639,41.794,2.020,2.616
 3906.909,128.385,1241.699,140.282,-112.936,42.909,12.357,0.162,2.116,2.386,34.741,2.442,112.190,45.717,2.015,2.670
 3907.409,128.520,1259.766,135.785,-112.844,47.712,12.470,0.178,2.089,2.324,36.337,2.494,117.377,49.383,2.114,2.831
 3907.909,128.554,1260.938,125.149,-112.387,52.964,11.974,0.187,2.109,2.368,35.142,2.586,118.006,49.828,2.287,3.065
 3908.409,128.516,1270.361,118.863,-111.150,55.165,11.842,0.182,2.148,2.421,32.866,2.733,112.615,46.018,2.509,3.366
 3908.909,128.410,1266.113,120.900,-110.323,54.791,11.850,0.166,2.207,2.455,29.407,3.028,102.911,39.160,2.777,3.676
 3909.409,128.413,1255.469,125.568,-109.678,53.610,11.705,0.157,2.282,2.615,25.009,3.486,91.712,31.245,3.129,3.983
 3909.909,128.512,1264.648,128.547,-109.131,52.126,11.611,0.166,2.364,2.911,20.241,4.007,81.769,24.219,3.598,4.304
 3910.409,128.538,1264.648,124.455,-108.054,49.072,11.913,0.176,2.433,3.203,16.187,4.443,75.191,19.570,4.134,4.692
 3910.909,128.505,1254.883,118.889,-106.920,45.245,12.235,0.175,2.476,3.322,13.678,4.654,73.483,18.363,4.650,5.184
 3911.409,128.471,1254.883,120.947,-106.060,42.623,12.261,0.166,2.505,3.307,11.974,4.698,74.873,19.345,5.076,5.662
 3911.909,128.495,1257.324,132.169,-105.212,41.830,12.438,0.153,2.528,3.223,10.668,4.675,77.737,21.369,5.347,5.957
 3912.409,128.550,1259.766,144.524,-104.718,41.045,12.639,0.138,2.555,3.204,9.051,4.707,80.510,23.329,5.504,6.071
 3912.909,128.548,1257.080,148.386,-103.983,39.228,12.471,0.118,2.588,3.151,7.109,4.870,81.908,24.317,5.527,5.941
 3913.409,128.590,1254.883,146.235,-103.779,36.855,12.380,0.103,2.607,3.064,6.037,5.074,82.086,24.442,5.494,5.720
 3913.909,128.618,1254.883,143.504,-103.984,35.036,12.305,0.102,2.600,3.062,6.438,5.192,81.573,24.080,5.377,5.481
 3914.409,128.556,1250.000,140.513,-104.978,34.981,11.846,0.102,2.576,3.121,7.829,5.168,80.945,23.636,5.227,5.352
 3914.909,128.553,1256.250,134.837,-106.444,36.154,11.518,0.101,2.565,3.374,8.505,4.986,81.008,23.681,5.075,5.458
 3915.409,128.611,1259.766,127.807,-107.369,36.489,11.456,0.107,2.565,3.585,8.473,4.711,81.524,24.045,4.979,5.678
 3915.909,128.472,1259.766,123.739,-108.205,35.405,11.550,0.123,2.539,3.618,10.021,4.390,82.393,24.660,4.987,5.891
 3916.409,128.542,1254.883,125.184,-108.170,34.867,11.752,0.144,2.462,3.404,14.479,4.071,83.154,25.197,4.842,5.631
 3916.909,128.605,1254.883,124.382,-108.541,35.897,12.138,0.151,2.345,3.042,21.332,3.822,82.740,24.905,4.344,4.804
 3917.409,128.475,1241.504,129.560,-108.913,37.035,12.517,0.147,2.263,2.886,26.135,3.628,82.544,24.766,3.559,3.917
 3917.909,128.575,1245.117,146.832,-109.168,36.787,12.253,0.140,2.218,2.921,28.757,3.395,86.409,27.497,2.853,3.296
 3918.409,128.595,1248.145,171.416,-110.441,36.581,11.493,0.123,2.108,2.901,35.223,3.051,96.018,34.289,2.417,3.081
 3918.909,128.613,1258.936,188.206,-111.436,39.999,11.372,0.110,1.937,2.639,45.177,2.663,107.306,42.265,2.228,3.156
 3919.409,128.586,1245.117,180.805,-112.122,49.398,12.313,0.103,1.800,2.314,53.217,2.411,112.710,46.085,2.237,3.420
 3919.909,128.629,1240.820,160.862,-112.740,59.363,12.928,0.116,1.814,2.181,52.409,2.427,109.055,43.502,2.353,3.623
 3920.409,128.546,1249.121,138.387,-112.883,61.912,12.903,0.143,2.030,2.405,39.748,2.856,98.591,36.107,2.499,3.572
 3920.909,128.696,1254.883,120.619,-112.135,55.525,12.642,0.150,2.272,2.836,25.643,3.523,86.415,27.502,2.640,3.403
 3921.409,128.578,1256.104,111.184,-110.348,43.540,12.031,0.148,2.432,3.271,16.250,4.096,76.547,20.528,2.804,3.317
 3921.909,128.575,1264.746,115.392,-108.536,33.204,11.843,0.147,2.486,3.573,13.105,4.277,71.592,17.026,3.075,3.424
 3922.409,128.536,1262.207,145.919,-107.656,28.700,11.614,0.161,2.438,3.436,15.883,3.914,73.516,18.386,3.437,3.740
 3922.909,128.587,1259.326,207.762,-107.396,29.456,11.400,0.173,2.383,3.050,19.145,3.419,78.612,21.987,3.743,4.140
 3923.409,128.648,1255.859,300.021,-107.215,33.874,11.987,0.154,2.345,2.814,21.317,3.169,83.198,25.229,3.808,4.497
 3923.909,128.591,1263.965,367.772,-106.829,38.004,12.125,0.132,2.305,2.737,23.682,3.167,86.751,27.739,3.679,4.712
 3924.409,128.703,1257.813,355.056,-106.431,41.247,11.949,0.133,2.231,2.604,28.024,3.302,89.389,29.603,3.582,4.785
 3924.909,128.482,1264.648,279.055,-105.905,44.801,12.363,0.152,2.136,2.361,33.582,3.466,88.978,29.313,3.657,4.865
 3925.409,128.682,1261.475,189.929,-105.796,48.362,12.557,0.169,2.100,2.050,35.666,3.809,84.601,26.220,3.938,4.931
 3925.909,128.651,1259.766,142.394,-105.860,49.007,12.524,0.160,2.178,1.876,31.137,4.600,78.035,21.580,4.384,5.090
 3926.409,128.509,1259.766,130.360,-104.955,44.146,12.018,0.127,2.340,1.936,21.655,5.787,72.523,17.684,4.946,5.386
 3926.909,128.749,1262.500,125.225,-103.713,36.148,10.904,0.094,2.501,2.127,12.247,6.947,69.969,15.879,5.695,5.875
 3927.409,128.641,1254.883,125.536,-102.744,28.759,10.342,0.067,2.599,2.409,6.492,7.714,68.862,15.097,6.643,6.631
 3927.909,128.664,1256.201,134.439,-103.260,24.120,10.254,0.050,2.653,2.761,3.310,7.964,68.471,14.821,7.541,7.128
 3928.409,128.745,1259.766,144.480,-104.648,22.057,10.178,0.042,2.682,3.378,1.660,7.749,68.693,14.978,7.624,7.014
 3928.909,128.683,1269.531,149.379,-105.845,21.348,10.163,0.058,2.683,3.949,1.585,6.933,71.593,17.027,6.545,6.310
 3929.409,128.628,1265.430,146.515,-106.937,22.115,10.408,0.106,2.617,4.103,5.439,5.576,80.069,23.017,5.101,5.555
 3929.909,128.703,1261.523,135.588,-107.340,25.789,10.907,0.156,2.451,3.574,15.145,4.157,94.854,33.466,4.066,5.147
 3930.409,128.684,1264.648,120.606,-107.474,31.738,11.705,0.179,2.255,2.666,26.593,3.146,111.517,45.241,3.420,4.916
 3930.909,128.667,1257.764,108.188,-107.240,38.078,12.362,0.163,2.127,2.124,34.107,2.788,122.891,53.280,3.111,4.808
 3931.409,128.656,1245.801,105.393,-107.545,43.242,12.430,0.138,2.103,1.918,35.487,2.749,126.118,55.561,2.966,4.623
 3931.909,128.830,1259.766,110.597,-108.784,45.627,12.008,0.121,2.155,2.040,32.442,2.784,122.177,52.775,2.889,4.217
 3932.409,128.634,1264.551,115.931,-110.359,46.275,11.712,0.115,2.203,2.324,29.639,2.831,118.194,49.961,2.849,3.824
 3932.909,128.640,1267.139,113.518,-112.290,45.345,11.694,0.115,2.211,2.640,29.203,2.908,114.172,47.118,2.776,3.480
 3933.409,128.750,1269.531,109.191,-114.267,43.176,11.736,0.121,2.202,2.995,29.687,2.950,109.057,43.503,2.726,3.336
 3933.909,128.655,1266.846,107.922,-115.535,40.477,11.761,0.142,2.178,3.135,31.134,2.844,104.278,40.126,2.691,3.418
 3934.409,128.672,1254.883,107.718,-115.426,38.720,11.639,0.169,2.143,2.919,33.177,2.645,102.437,38.825,2.688,3.612
 3934.909,128.686,1257.813,108.455,-114.349,39.958,12.240,0.188,2.115,2.535,34.822,2.481,107.537,42.429,2.688,3.885
 3935.409,128.684,1266.553,107.826,-113.855,42.823,12.846,0.182,2.103,2.155,35.469,2.440,113.031,46.312,2.669,3.960
 3935.909,128.764,1279.297,113.010,-114.893,45.452,12.716,0.162,2.130,2.069,33.938,2.476,113.661,46.757,2.594,3.823
 3936.409,128.830,1264.648,124.173,-115.958,47.489,12.467,0.148,2.179,2.158,31.059,2.468,111.860,45.484,2.497,3.565
 3936.909,128.789,1254.395,133.140,-116.010,49.831,12.498,0.143,2.220,2.248,28.631,2.406,110.660,44.636,2.401,3.331
 3937.409,128.700,1253.223,136.028,-115.976,52.200,12.605,0.140,2.257,2.306,26.464,2.349,112.566,45.983,2.336,3.204
 3937.909,128.724,1268.311,129.255,-115.492,52.707,12.630,0.135,2.298,2.341,24.089,2.356,113.534,46.667,2.312,3.170
 3938.409,128.766,1268.213,120.810,-115.940,51.734,12.712,0.128,2.324,2.386,22.565,2.414,110.995,44.873,2.335,3.261
 3938.909,128.814,1264.648,115.978,-116.654,50.750,12.755,0.130,2.339,2.409,21.698,2.453,107.644,42.505,2.430,3.495
 3939.409,128.679,1256.445,111.363,-116.976,50.451,12.685,0.132,2.342,2.478,21.537,2.442,104.044,39.960,2.626,3.897
 3939.909,128.695,1255.664,106.302,-117.126,50.201,12.569,0.128,2.344,2.640,21.424,2.475,99.751,36.926,2.957,4.422
 3940.409,128.749,1256.689,97.105,-116.341,48.758,12.479,0.122,2.368,2.861,19.990,2.831,92.179,31.575,3.429,4.880
 3940.909,128.885,1255.420,84.036,-115.591,45.633,12.276,0.104,2.410,3.106,17.524,3.632,82.380,24.650,3.938,5.089
 3941.409,128.712,1264.648,74.645,-115.607,39.779,11.954,0.078,2.468,3.431,14.141,4.584,73.787,18.578,4.175,4.843
 3941.909,128.884,1269.238,69.292,-115.677,32.036,11.617,0.052,2.502,3.895,12.180,5.068,71.113,16.687,4.030,4.414
 3942.409,128.899,1252.637,71.362,-116.153,24.923,11.574,0.058,2.470,4.306,14.049,4.583,77.578,21.257,3.563,4.064
 3942.909,128.772,1250.000,79.171,-117.009,20.396,12.095,0.099,2.349,4.333,21.109,3.529,92.300,31.661,3.037,3.846
 3943.409,128.830,1262.354,87.897,-118.037,22.197,12.384,0.148,2.150,3.746,32.767,2.580,112.252,45.761,2.595,3.696
 3943.909,128.927,1269.531,97.919,-118.939,31.343,12.214,0.172,1.994,2.955,41.897,2.090,129.860,58.205,2.231,3.441
 3944.409,128.778,1266.797,104.889,-118.087,44.856,12.585,0.150,1.970,2.421,43.304,2.033,139.086,64.725,1.959,3.025
 3944.909,128.753,1254.883,109.352,-115.928,55.011,12.907,0.110,2.056,2.238,38.221,2.071,139.657,65.128,1.767,2.647
 3945.409,128.833,1254.883,111.039,-112.968,57.364,12.900,0.069,2.170,2.305,31.561,2.067,135.413,62.130,1.662,2.381
 3945.909,128.990,1260.400,116.988,-110.984,54.314,12.842,0.041,2.245,2.371,27.190,2.020,129.795,58.159,1.632,2.277
 3946.409,128.867,1264.648,124.392,-110.237,50.985,12.836,0.036,2.295,2.491,24.289,1.980,122.973,53.338,1.683,2.306
 3946.909,128.712,1269.531,126.025,-110.088,49.371,12.914,0.042,2.330,2.626,22.194,1.989,114.794,47.557,1.792,2.433
 3947.409,128.812,1259.277,121.132,-110.059,48.461,12.923,0.049,2.350,2.737,21.060,2.046,105.835,41.226,1.938,2.610
 3947.909,128.935,1258.643,113.756,-109.496,47.625,12.917,0.050,2.358,2.813,20.609,2.130,97.683,35.465,2.072,2.776
 3948.409,128.691,1254.883,112.469,-109.264,46.419,12.916,0.047,2.361,2.845,20.383,2.200,92.228,31.610,2.158,2.895
 3948.909,128.823,1262.012,116.488,-108.716,44.360,12.920,0.046,2.369,2.815,19.944,2.206,90.636,30.485,2.193,2.949
 3949.409,128.839,1250.977,122.170,-107.427,43.045,12.936,0.046,2.356,2.637,20.717,2.156,92.420,31.746,2.194,2.965
 3949.909,128.918,1254.688,124.933,-105.543,44.452,12.944,0.051,2.320,2.392,22.835,2.098,95.873,34.186,2.190,2.963
 3950.409,128.860,1272.949,126.298,-104.178,48.338,12.931,0.059,2.279,2.172,25.185,2.076,99.172,36.517,2.182,2.956
 3950.909,128.851,1274.414,127.269,-104.275,52.325,12.932,0.062,2.244,2.058,27.224,2.107,101.389,38.084,2.180,2.951
 3951.409,128.888,1257.031,126.558,-105.960,54.455,12.943,0.063,2.225,2.037,28.367,2.156,102.511,38.877,2.177,2.949
 3951.909,128.913,1241.016,124.168,-107.223,54.794,12.942,0.068,2.223,2.055,28.466,2.195,102.258,38.698,2.176,2.947
 3952.409,129.004,1235.352,118.891,-107.535,54.038,12.942,0.077,2.235,2.097,27.776,2.223,100.926,37.757,2.182,2.949
 3952.909,128.869,1266.650,111.983,-106.791,52.938,12.930,0.091,2.257,2.176,26.504,2.246,99.236,36.562,2.198,2.960
 3953.409,128.984,1259.912,107.416,-106.381,51.319,12.928,0.102,2.278,2.253,25.283,2.272,98.207,35.836,2.228,3.000
 3953.909,128.978,1264.746,105.383,-106.510,48.578,12.940,0.101,2.296,2.315,24.191,2.303,98.756,36.223,2.288,3.113
 3954.409,128.782,1260.156,103.699,-106.133,45.549,12.936,0.089,2.314,2.390,23.132,2.345,100.215,37.255,2.381,3.286
 3954.909,128.969,1269.531,102.829,-105.793,43.473,12.923,0.066,2.325,2.461,22.518,2.405,101.439,38.119,2.526,3.519
 3955.409,129.009,1260.645,101.683,-105.171,42.759,12.893,0.045,2.330,2.496,22.207,2.492,100.890,37.732,2.694,3.739
 3955.909,128.912,1272.510,98.097,-105.033,42.040,12.861,0.040,2.330,2.486,22.243,2.623,97.273,35.175,2.883,3.905
 3956.409,128.944,1264.648,94.913,-104.930,40.236,12.870,0.059,2.335,2.452,21.946,2.767,91.577,31.150,3.056,4.045
 3956.909,128.932,1258.203,91.832,-104.294,38.083,12.897,0.085,2.325,2.406,22.492,2.878,85.672,26.976,3.219,4.184
 3957.409,128.966,1258.887,89.795,-103.864,37.450,12.925,0.100,2.300,2.421,23.990,2.915,82.945,25.050,3.369,4.364
 3957.909,129.017,1254.883,92.311,-102.587,38.747,12.948,0.108,2.280,2.468,25.157,2.869,84.410,26.085,3.463,4.480
 3958.409,128.895,1264.648,95.091,-100.868,41.394,12.944,0.116,2.282,2.572,25.052,2.787,87.661,28.382,3.470,4.462
 3958.909,128.958,1264.648,95.802,-99.808,45.319,12.930,0.128,2.303,2.724,23.795,2.693,90.579,30.445,3.352,4.289
 3959.409,129.116,1263.281,93.412,-99.451,48.688,12.930,0.125,2.310,2.727,23.396,2.618,92.341,31.690,3.151,4.001
 3959.909,128.859,1259.766,90.205,-99.424,49.594,12.940,0.103,2.300,2.625,23.987,2.565,94.054,32.900,2.949,3.734
 3960.409,129.017,1259.766,93.449,-98.890,48.492,12.944,0.082,2.286,2.440,24.820,2.524,96.157,34.387,2.779,3.480
 3960.909,128.987,1268.066,99.443,-98.359,48.858,12.941,0.072,2.283,2.250,24.999,2.477,97.626,35.425,2.646,3.273
 3961.409,129.018,1273.145,106.386,-98.192,51.786,12.937,0.074,2.291,2.148,24.518,2.412,97.382,35.252,2.540,3.105
 3961.909,128.908,1279.297,113.009,-98.893,53.261,12.938,0.079,2.304,2.121,23.771,2.343,95.323,33.797,2.440,2.961
 3962.409,129.061,1270.313,118.564,-100.939,51.536,12.940,0.086,2.320,2.272,22.784,2.284,93.205,32.300,2.362,2.872
 3962.909,129.154,1260.010,122.220,-101.746,48.725,12.937,0.096,2.323,2.486,22.644,2.240,93.494,32.504,2.303,2.822
 3963.409,128.975,1262.061,117.347,-101.059,47.658,12.925,0.104,2.296,2.538,24.199,2.238,97.966,35.665,2.278,2.809
 3963.909,128.981,1269.482,109.690,-99.449,49.195,12.912,0.102,2.254,2.420,26.694,2.283,104.629,40.374,2.271,2.816
 3964.409,129.021,1269.531,107.693,-98.364,50.796,12.896,0.096,2.225,2.215,28.377,2.362,109.585,43.876,2.270,2.831
 3964.909,128.892,1269.336,108.392,-98.606,51.110,12.855,0.091,2.224,2.112,28.413,2.433,110.537,44.549,2.275,2.867
 3965.409,129.011,1264.648,109.908,-98.524,50.977,12.789,0.084,2.241,2.137,27.443,2.464,107.313,42.271,2.312,2.958
 3965.909,129.123,1274.414,108.656,-98.768,51.118,12.671,0.072,2.258,2.166,26.448,2.479,102.898,39.150,2.396,3.100
 3966.409,128.953,1274.414,106.521,-99.099,51.878,12.406,0.057,2.269,2.199,25.774,2.523,99.205,36.541,2.567,3.306
 3966.909,129.140,1269.531,104.541,-99.991,51.512,12.112,0.047,2.276,2.265,25.371,2.624,96.254,34.455,2.825,3.553
 3967.409,128.975,1269.531,103.211,-101.339,49.079,11.820,0.050,2.292,2.338,24.436,2.876,92.615,31.884,3.134,3.779
 3967.909,129.077,1262.549,102.429,-102.551,45.313,11.586,0.059,2.336,2.508,21.897,3.459,86.761,27.747,3.443,3.959
 3968.409,129.069,1267.480,98.197,-102.531,40.128,11.354,0.078,2.398,2.830,18.230,4.308,78.559,21.950,3.665,4.048
 3968.909,129.030,1263.525,94.615,-101.608,33.741,11.109,0.116,2.438,3.105,15.915,4.915,71.692,17.097,3.842,4.149
 3969.409,128.882,1267.188,89.636,-99.667,27.367,11.007,0.164,2.414,3.138,17.316,4.879,70.553,16.292,4.038,4.398
 3969.909,129.029,1264.648,85.442,-98.557,24.916,11.218,0.193,2.334,2.871,22.007,4.292,75.551,19.824,4.259,4.740
 3970.409,129.152,1260.693,84.557,-98.382,27.977,12.071,0.191,2.251,2.532,26.823,3.692,83.046,25.121,4.435,5.004
 3970.909,129.011,1264.648,80.110,-98.997,33.788,12.520,0.181,2.208,2.430,29.358,3.493,86.846,27.806,4.324,4.826
 3971.409,129.009,1264.648,76.700,-99.980,39.362,12.081,0.185,2.199,2.482,29.870,3.556,85.811,27.075,3.958,4.329
 3971.909,129.200,1274.414,77.584,-100.011,43.119,11.878,0.201,2.201,2.544,29.777,3.605,83.025,25.106,3.487,3.866
 3972.409,129.046,1265.625,82.129,-99.254,44.882,11.658,0.213,2.196,2.591,30.068,3.523,81.549,24.063,3.130,3.570
 3972.909,128.960,1279.297,89.575,-98.018,44.361,11.460,0.218,2.160,2.559,32.186,3.336,83.206,25.234,2.991,3.544
 3973.409,128.954,1270.020,92.463,-96.802,42.475,11.912,0.223,2.092,2.471,36.167,3.144,86.943,27.875,3.023,3.682
 3973.909,129.061,1276.709,89.745,-96.067,43.965,12.423,0.223,1.995,2.351,41.823,3.054,90.114,30.116,3.250,3.960
 3974.409,129.137,1279.297,86.954,-96.136,53.784,12.542,0.208,1.937,2.235,45.218,3.267,90.226,30.195,3.537,4.238
 3974.909,129.061,1271.875,79.045,-97.348,65.576,12.054,0.168,2.027,2.460,39.920,4.693,84.451,26.114,3.779,4.271
 3975.409,129.210,1269.531,69.779,-99.278,67.038,10.771,0.112,2.206,3.159,29.471,6.951,75.993,20.137,3.922,4.190
 3975.909,129.160,1272.314,67.262,-101.086,52.018,9.515,0.078,2.395,3.846,18.434,8.416,71.765,17.149,3.996,4.067
 3976.409,129.122,1249.561,74.946,-102.479,31.707,9.310,0.070,2.448,4.338,15.324,8.235,74.996,19.432,4.135,4.125
 3976.909,129.065,1245.117,95.548,-103.117,21.854,9.527,0.095,2.308,4.191,23.505,6.374,85.549,26.889,4.365,4.454
 3977.409,129.157,1259.766,113.332,-104.045,23.832,10.168,0.135,2.130,3.514,33.932,4.591,96.526,34.648,4.497,4.848
 3977.909,129.121,1263.037,120.299,-105.624,31.179,11.320,0.166,2.037,2.921,39.350,3.863,104.690,40.417,4.365,5.166
 3978.409,129.037,1262.793,118.557,-107.107,37.800,11.608,0.192,2.061,2.474,37.972,3.701,109.964,44.144,4.038,5.106
 3978.909,129.225,1251.416,112.126,-107.917,41.431,11.647,0.208,2.128,2.372,34.043,3.690,110.955,44.844,3.681,4.762
 3979.409,129.019,1259.766,106.490,-108.391,44.131,11.961,0.205,2.153,2.421,32.598,3.585,107.905,42.689,3.524,4.371
 3979.909,129.155,1259.766,102.285,-109.660,47.830,11.705,0.186,2.126,2.386,34.128,3.435,101.310,38.028,3.529,4.014
 3980.409,129.214,1266.699,96.875,-112.912,50.915,11.685,0.161,2.119,2.325,34.567,3.637,93.243,32.327,3.656,3.726
 3980.909,129.061,1267.676,86.425,-119.075,50.619,11.520,0.132,2.157,2.271,32.351,4.464,88.126,28.711,3.805,3.529
 3981.409,129.157,1261.475,69.810,-126.984,44.284,10.049,0.106,2.224,2.109,28.415,5.542,88.061,28.665,3.896,3.377
 3981.909,129.154,1253.516,52.056,-134.893,34.606,8.796,0.075,2.277,1.875,25.336,6.537,91.000,30.742,3.973,3.303
 3982.409,129.171,1254.883,40.181,-140.716,26.785,8.571,0.043,2.289,1.699,24.646,7.447,91.651,31.202,4.090,3.284
 3982.909,129.232,1263.770,33.845,-145.205,22.328,8.533,0.027,2.303,1.638,23.825,8.272,87.948,28.585,4.224,3.262
 3983.409,129.184,1259.766,28.021,-149.390,20.202,8.512,0.024,2.327,1.691,22.376,8.704,82.080,24.438,4.312,3.220
 3983.909,129.195,1259.766,22.804,-152.859,18.003,8.470,0.031,2.339,1.745,21.672,8.402,77.867,21.461,4.279,3.145
 3984.409,129.184,1254.883,22.495,-155.033,16.049,8.454,0.042,2.319,1.732,22.883,7.345,78.426,21.856,4.100,3.027
 3984.909,129.192,1259.766,25.812,-155.732,15.683,8.489,0.052,2.284,1.699,24.903,6.257,82.525,24.753,3.900,2.910
 3985.409,129.074,1259.766,30.580,-156.796,17.269,8.524,0.056,2.261,1.703,26.230,5.613,87.907,28.556,3.729,2.769
 3985.909,129.202,1259.766,32.592,-158.215,19.399,8.535,0.056,2.253,1.704,26.719,5.361,91.376,31.008,3.591,2.640
 3986.409,129.153,1259.766,31.738,-159.757,21.090,8.551,0.052,2.252,1.672,26.763,5.467,90.901,30.672,3.494,2.538
 3986.909,129.054,1263.672,30.775,-160.873,21.901,8.587,0.049,2.260,1.627,26.342,5.743,87.821,28.496,3.409,2.465
 3987.409,129.143,1251.855,30.635,-161.228,21.843,8.638,0.053,2.278,1.594,25.284,6.075,83.860,25.696,3.361,2.430
 3987.909,129.273,1252.197,32.312,-160.583,21.387,8.695,0.059,2.298,1.587,24.106,6.420,80.356,23.220,3.346,2.423
 3988.409,129.022,1258.105,33.190,-159.541,20.975,8.758,0.062,2.315,1.602,23.089,6.766,77.801,21.414,3.364,2.440
 3988.909,129.145,1262.793,32.485,-158.169,20.896,8.825,0.062,2.330,1.600,22.250,7.100,76.226,20.301,3.403,2.476
 3989.409,129.262,1254.883,29.290,-156.903,21.053,8.892,0.062,2.338,1.574,21.774,7.394,75.484,19.777,3.453,2.525
 3989.909,129.129,1258.594,26.006,-155.620,21.270,8.936,0.058,2.335,1.523,21.926,7.644,74.850,19.329,3.507,2.584
 3990.409,129.266,1258.643,25.830,-154.212,21.314,8.966,0.053,2.332,1.481,22.081,7.848,74.060,18.770,3.566,2.649
 3990.909,129.202,1259.766,28.258,-153.642,21.059,8.990,0.050,2.342,1.505,21.518,8.086,72.949,17.985,3.612,2.704
 3991.409,129.148,1263.721,32.064,-153.519,20.452,8.961,0.051,2.372,1.563,19.789,8.408,71.779,17.158,3.642,2.732
 3991.909,129.343,1259.766,34.307,-152.912,19.469,8.865,0.049,2.400,1.610,18.111,8.720,70.795,16.463,3.615,2.706
 3992.409,129.085,1255.566,34.196,-152.674,18.170,8.806,0.038,2.404,1.600,17.918,8.854,70.193,16.038,3.533,2.624
 3992.909,129.252,1258.691,31.362,-151.872,16.798,8.800,0.027,2.394,1.539,18.497,8.549,70.004,15.904,3.387,2.499
 3993.409,129.322,1264.648,30.562,-152.500,16.073,8.789,0.018,2.382,1.489,19.176,7.867,70.079,15.957,3.211,2.352
 3993.909,129.182,1256.982,33.202,-153.679,16.475,8.771,0.017,2.374,1.465,19.632,7.042,70.395,16.181,3.020,2.207
 3994.409,129.211,1259.766,36.381,-155.523,17.622,8.738,0.020,2.364,1.449,20.221,6.344,70.943,16.567,2.835,2.067
 3994.909,129.236,1259.766,36.292,-157.733,19.204,8.691,0.022,2.342,1.419,21.493,5.929,71.681,17.089,2.674,1.947
 3995.409,129.312,1264.648,30.087,-159.472,20.578,8.648,0.026,2.322,1.384,22.681,5.703,72.369,17.575,2.541,1.846
 3995.909,129.209,1264.648,24.379,-160.923,21.251,8.608,0.033,2.317,1.385,22.987,5.654,72.693,17.804,2.451,1.773
 3996.409,129.287,1255.371,22.312,-161.770,21.380,8.564,0.036,2.314,1.417,23.168,5.740,72.677,17.793,2.391,1.719
 3996.909,129.230,1261.816,22.474,-162.383,21.194,8.528,0.034,2.308,1.422,23.480,5.943,72.537,17.694,2.360,1.685
 3997.409,129.160,1269.531,23.312,-162.579,21.071,8.505,0.031,2.300,1.403,23.974,6.121,72.510,17.675,2.344,1.662
 3997.909,129.243,1263.379,22.871,-162.610,21.018,8.494,0.032,2.298,1.378,24.106,6.199,72.606,17.743,2.337,1.647
 3998.409,129.375,1268.066,22.823,-163.341,20.914,8.487,0.040,2.310,1.387,23.378,6.164,72.737,17.835,2.332,1.636
 3998.909,129.117,1259.766,23.715,-164.730,20.653,8.519,0.047,2.322,1.410,22.708,6.014,72.925,17.968,2.328,1.626
 3999.409,129.144,1261.719,23.961,-166.165,20.532,8.598,0.046,2.315,1.399,23.094,5.777,73.360,18.276,2.322,1.617
 3999.909,129.269,1273.047,23.913,-167.174,20.652,8.651,0.040,2.297,1.367,24.137,5.513,74.311,18.948,2.316,1.609
 4000.409,129.333,1270.752,23.960,-167.559,20.702,8.649,0.036,2.281,1.360,25.072,5.327,75.622,19.874,2.309,1.600
 4000.909,129.277,1267.285,24.592,-167.792,20.555,8.524,0.040,2.278,1.396,25.278,5.303,76.819,20.720,2.306,1.591
 4001.409,129.219,1274.414,25.215,-167.952,20.308,8.408,0.046,2.281,1.425,25.100,5.394,77.493,21.197,2.303,1.584
 4001.909,129.124,1274.414,25.955,-168.291,20.334,8.400,0.050,2.282,1.446,25.036,5.530,77.620,21.286,2.304,1.576
 4002.409,129.318,1263.086,26.201,-168.813,20.821,8.395,0.054,2.284,1.491,24.907,5.712,77.442,21.161,2.304,1.572
 4002.909,129.391,1269.531,26.052,-169.197,21.326,8.314,0.058,2.284,1.555,24.900,5.858,77.159,20.960,2.304,1.570
 4003.409,129.297,1276.563,26.270,-168.980,21.454,8.152,0.062,2.268,1.596,25.845,5.814,76.867,20.754,2.309,1.576
 4003.909,129.392,1264.648,25.366,-168.738,21.353,8.072,0.072,2.245,1.611,27.165,5.586,76.757,20.676,2.321,1.588
 4004.409,129.254,1264.648,23.391,-168.825,21.177,8.134,0.090,2.234,1.638,27.833,5.358,77.041,20.877,2.340,1.603
 4004.909,129.237,1274.023,21.401,-168.791,20.929,8.234,0.104,2.240,1.651,27.488,5.348,77.564,21.247,2.364,1.618
 4005.409,129.341,1272.021,20.177,-168.372,20.682,8.280,0.099,2.260,1.630,26.319,5.621,77.958,21.525,2.386,1.629
 4005.909,129.342,1269.482,20.917,-168.024,20.565,8.284,0.080,2.273,1.582,25.570,5.958,77.957,21.524,2.402,1.637
 4006.409,129.312,1269.824,22.017,-168.231,20.725,8.284,0.056,2.269,1.535,25.773,6.193,77.565,21.247,2.409,1.640
 4006.909,129.311,1269.531,21.516,-168.624,21.021,8.284,0.039,2.261,1.516,26.245,6.300,77.181,20.976,2.404,1.639
 4007.409,129.413,1269.531,20.189,-168.758,21.075,8.284,0.034,2.253,1.524,26.715,6.264,77.051,20.884,2.386,1.637
 4007.909,129.318,1278.223,20.206,-168.499,20.992,8.282,0.036,2.253,1.530,26.720,6.140,77.052,20.885,2.359,1.635
 4008.409,129.275,1269.531,22.118,-167.995,21.053,8.279,0.044,2.264,1.516,26.102,5.959,77.131,20.941,2.332,1.640
 4008.909,129.299,1266.113,22.933,-167.854,21.375,8.278,0.050,2.273,1.520,25.535,5.776,77.241,21.018,2.314,1.654
 4009.409,129.288,1277.734,22.546,-168.178,22.022,8.278,0.051,2.278,1.534,25.253,5.678,77.417,21.143,2.315,1.682
 4009.909,129.308,1277.344,21.626,-168.836,22.520,8.278,0.048,2.274,1.564,25.481,5.723,77.730,21.364,2.340,1.723
 4010.409,129.322,1276.660,21.503,-169.633,22.297,8.280,0.047,2.269,1.605,25.816,5.926,78.080,21.611,2.389,1.778
 4010.909,129.372,1279.297,21.221,-169.844,21.565,8.281,0.051,2.270,1.616,25.714,6.267,78.256,21.736,2.461,1.844
 4011.409,129.364,1271.777,21.509,-169.942,21.078,8.281,0.053,2.279,1.600,25.223,6.713,78.060,21.597,2.555,1.921
 4011.909,129.217,1272.949,22.481,-169.394,21.408,8.281,0.051,2.289,1.557,24.637,7.131,77.424,21.148,2.665,2.008
 4012.409,129.370,1269.531,23.231,-168.189,22.240,8.281,0.046,2.298,1.500,24.116,7.312,76.730,20.657,2.785,2.100
 4012.909,129.472,1269.531,21.633,-166.728,22.609,8.288,0.043,2.300,1.491,23.980,7.179,76.495,20.491,2.904,2.195
 4013.409,129.450,1269.531,19.070,-165.203,22.332,8.315,0.042,2.299,1.527,24.047,6.897,76.882,20.765,3.012,2.288
 4013.909,129.398,1264.648,18.347,-164.453,21.866,8.385,0.042,2.294,1.549,24.311,6.657,77.559,21.243,3.106,2.375
 4014.409,129.342,1273.633,20.012,-164.258,21.297,8.502,0.042,2.293,1.561,24.373,6.503,78.024,21.571,3.190,2.455
 4014.909,129.352,1267.383,26.215,-164.229,20.617,8.669,0.043,2.297,1.583,24.143,6.394,77.974,21.536,3.265,2.525
 4015.409,129.394,1264.648,32.950,-164.334,20.105,8.822,0.044,2.300,1.619,23.966,6.361,77.563,21.246,3.336,2.587
 4015.909,129.366,1269.531,38.349,-164.389,20.231,8.872,0.048,2.310,1.682,23.403,6.499,77.053,20.886,3.403,2.641
 4016.409,129.515,1274.414,40.515,-164.457,20.486,8.870,0.051,2.320,1.733,22.778,6.809,76.426,20.442,3.461,2.691
 4016.909,129.365,1271.777,38.046,-164.115,19.842,8.818,0.054,2.336,1.756,21.862,7.302,75.459,19.759,3.517,2.739
 4017.409,129.336,1273.828,34.438,-163.989,18.455,8.752,0.060,2.355,1.752,20.786,7.789,74.304,18.943,3.568,2.784
 4017.909,129.464,1264.648,30.555,-163.824,17.082,8.709,0.069,2.362,1.707,20.351,8.165,73.400,18.304,3.625,2.829
 4018.409,129.272,1260.840,28.367,-164.286,16.672,8.669,0.077,2.358,1.656,20.568,8.350,73.235,18.187,3.687,2.877
 4018.909,129.392,1263.379,28.993,-164.689,17.637,8.635,0.075,2.340,1.613,21.657,8.282,73.897,18.655,3.749,2.929
 4019.409,129.429,1262.109,31.514,-164.724,19.350,8.619,0.065,2.318,1.594,22.917,8.100,74.741,19.252,3.807,2.984
 4019.909,129.366,1274.414,34.394,-165.160,21.057,8.609,0.055,2.307,1.610,23.565,7.955,75.095,19.502,3.865,3.040
 4020.409,129.442,1269.531,35.948,-164.732,21.934,8.577,0.049,2.309,1.639,23.473,8.024,74.686,19.213,3.918,3.093
 4020.909,129.444,1265.967,35.196,-164.381,21.745,8.528,0.047,2.319,1.652,22.880,8.351,73.652,18.482,3.974,3.139
 4021.409,129.416,1264.648,33.914,-163.398,20.815,8.469,0.050,2.336,1.648,21.883,8.822,72.602,17.740,4.032,3.181
 4021.909,129.418,1268.457,34.135,-162.655,19.488,8.404,0.052,2.357,1.627,20.666,9.424,71.933,17.267,4.093,3.222
 4022.409,129.423,1270.996,33.213,-161.809,18.200,8.365,0.047,2.369,1.609,19.935,10.027,71.615,17.042,4.161,3.275
 4022.909,129.528,1266.309,32.991,-161.456,16.921,8.428,0.038,2.375,1.612,19.574,10.289,72.325,17.544,4.241,3.345
 4023.409,129.436,1274.414,34.567,-161.496,15.820,8.528,0.033,2.371,1.625,19.814,10.051,75.714,19.939,4.341,3.436
 4023.909,129.405,1265.918,34.257,-161.386,15.349,8.572,0.035,2.365,1.659,20.175,9.632,80.732,23.485,4.463,3.549
 4024.409,129.460,1271.484,34.338,-160.368,15.841,8.595,0.041,2.368,1.672,20.028,9.632,84.248,25.970,4.615,3.684
 4024.909,129.383,1274.414,33.740,-158.735,16.500,8.601,0.042,2.374,1.652,19.678,10.206,83.829,25.674,4.789,3.838
 4025.409,129.513,1271.240,35.283,-158.312,16.188,8.602,0.041,2.386,1.652,18.956,11.014,80.355,23.219,4.998,4.018
 4025.909,129.521,1274.561,45.321,-158.326,15.032,8.588,0.041,2.400,1.662,18.115,11.764,77.836,21.439,5.235,4.218
 4026.409,129.471,1272.021,54.416,-158.366,13.946,8.551,0.043,2.411,1.666,17.509,12.301,78.930,22.212,5.499,4.443
 4026.909,129.342,1264.844,57.276,-158.866,13.527,8.525,0.049,2.419,1.649,17.044,12.788,82.979,25.073,5.798,4.683
 4027.409,129.422,1274.414,53.652,-160.261,13.239,8.523,0.057,2.425,1.609,16.693,13.407,86.052,27.245,6.112,4.931
 4027.909,129.571,1265.332,44.788,-160.278,12.462,8.522,0.063,2.432,1.605,16.285,14.113,85.522,26.871,6.446,5.170
 4028.409,129.394,1280.176,39.163,-160.526,11.484,8.497,0.066,2.440,1.648,15.803,14.933,81.350,23.922,6.778,5.391
 4028.909,129.559,1264.648,35.598,-160.488,10.943,8.462,0.062,2.440,1.681,15.800,15.886,74.527,19.100,7.091,5.581
 4029.409,129.492,1261.523,33.274,-160.444,11.134,8.451,0.053,2.437,1.686,15.952,17.166,68.909,15.130,7.364,5.730
 4029.909,129.498,1261.328,33.919,-160.708,11.540,8.448,0.043,2.439,1.674,15.843,18.463,66.721,13.584,7.556,5.839
 4030.409,129.542,1269.531,36.175,-160.440,11.698,8.437,0.033,2.460,1.737,14.609,19.427,67.534,14.159,7.663,5.898
 4030.909,129.609,1280.322,38.608,-162.753,11.605,8.424,0.023,2.505,2.089,11.974,20.161,68.620,14.926,7.681,5.919
 4031.409,129.586,1277.051,39.033,-164.280,11.230,8.412,0.012,2.556,2.611,8.984,20.875,65.179,12.494,7.642,5.904
 4031.909,129.682,1273.145,35.805,-164.978,10.580,8.405,0.005,2.602,3.168,6.323,21.345,57.977,7.404,7.534,5.855
 4032.409,129.473,1265.723,30.021,-164.234,9.766,8.404,0.006,2.626,3.587,4.898,21.282,53.221,4.043,7.385,5.794
 4032.909,129.556,1274.414,23.899,-164.996,8.945,8.404,0.010,2.636,3.760,4.339,20.588,53.553,4.277,7.240,5.699
 4033.409,129.631,1274.414,20.139,-166.807,8.340,8.404,0.014,2.641,3.855,4.015,20.023,57.274,6.908,7.073,5.583
 4033.909,129.440,1275.879,19.419,-168.819,7.958,8.404,0.014,2.635,3.764,4.409,19.778,61.549,9.928,6.950,5.467
 4034.409,129.511,1269.531,19.958,-169.891,7.799,8.407,0.010,2.621,3.570,5.209,19.235,63.520,11.322,6.808,5.375
 4034.909,129.635,1276.367,21.434,-169.262,7.949,8.410,0.006,2.605,3.326,6.144,18.481,63.442,11.267,6.675,5.306
 4035.409,129.702,1279.297,22.679,-168.602,8.314,8.413,0.007,2.603,3.095,6.274,17.534,62.012,10.256,6.521,5.235
 4035.909,129.553,1281.494,21.949,-167.696,8.739,8.416,0.011,2.607,3.080,6.027,16.645,60.011,8.842,6.352,5.122
 4036.409,129.552,1284.180,20.793,-166.820,9.112,8.422,0.012,2.605,3.236,6.137,15.770,59.196,8.266,6.207,5.001
 4036.909,129.535,1286.621,18.507,-166.475,9.555,8.426,0.010,2.599,3.396,6.476,14.840,59.670,8.601,6.066,4.895
 4037.409,129.601,1279.297,16.468,-166.261,10.131,8.426,0.009,2.593,3.463,6.837,14.194,60.074,8.886,5.953,4.815
 4037.909,129.568,1276.611,16.129,-166.290,10.639,8.426,0.007,2.587,3.384,7.183,14.019,60.170,8.954,5.846,4.777
 4038.409,129.597,1279.297,16.737,-166.681,10.825,8.427,0.005,2.578,3.333,7.716,14.168,59.874,8.745,5.770,4.753
 4038.909,129.600,1279.297,18.338,-167.410,10.584,8.429,0.003,2.570,3.314,8.181,14.508,59.365,8.385,5.732,4.747
 4039.409,129.618,1274.414,20.462,-167.817,10.125,8.432,0.003,2.570,3.311,8.160,14.903,58.970,8.106,5.725,4.743
 4039.909,129.671,1274.414,21.421,-167.042,9.724,8.429,0.004,2.577,3.281,7.757,15.209,58.862,8.030,5.753,4.752
 4040.409,129.676,1274.414,21.165,-165.439,9.509,8.420,0.005,2.583,3.185,7.423,15.289,59.045,8.159,5.786,4.779
 4040.909,129.571,1274.414,20.312,-164.493,9.437,8.417,0.005,2.586,3.159,7.265,15.285,59.309,8.346,5.820,4.828
 4041.409,129.559,1275.439,19.781,-163.988,9.455,8.417,0.005,2.585,3.192,7.323,15.285,59.480,8.466,5.867,4.905
 4041.909,129.615,1282.910,20.880,-163.758,9.510,8.417,0.009,2.589,3.356,7.093,15.395,59.427,8.429,5.933,4.992
 4042.409,129.602,1284.180,22.028,-163.760,9.530,8.417,0.011,2.590,3.544,7.033,15.697,59.166,8.244,6.031,5.090
 4042.909,129.647,1276.465,22.732,-163.231,9.387,8.417,0.012,2.589,3.655,7.059,16.117,58.824,8.003,6.148,5.191
 4043.409,129.636,1279.297,20.975,-162.995,9.025,8.417,0.010,2.589,3.699,7.103,16.550,58.545,7.805,6.274,5.298
 4043.909,129.606,1279.297,18.978,-162.426,8.747,8.417,0.005,2.585,3.653,7.325,16.872,58.310,7.639,6.401,5.417
 4044.409,129.606,1276.172,19.279,-161.871,8.747,8.417,0.002,2.584,3.533,7.381,17.083,58.096,7.488,6.525,5.545
 4044.909,129.738,1287.891,20.038,-161.274,8.812,8.417,0.000,2.578,3.323,7.729,17.092,57.884,7.339,6.668,5.691
 4045.409,129.705,1289.063,20.149,-159.704,8.763,8.416,0.001,2.576,3.136,7.839,16.779,57.711,7.217,6.829,5.855
 4045.909,129.652,1279.980,19.926,-158.720,8.615,8.411,0.001,2.571,3.054,8.107,16.520,57.621,7.153,7.018,6.027
 4046.409,129.753,1277.100,19.585,-158.297,8.568,8.406,0.000,2.564,2.979,8.551,16.684,57.507,7.072,7.216,6.210
 4046.909,129.558,1274.414,21.096,-159.023,8.634,8.403,-0.000,2.565,3.037,8.457,17.019,57.289,6.918,7.428,6.397
 4047.409,129.679,1279.297,21.694,-159.489,8.566,8.400,-0.001,2.572,3.140,8.073,17.117,56.930,6.664,7.681,6.630
 4047.909,129.679,1284.180,20.441,-159.328,8.286,8.398,-0.001,2.583,3.264,7.419,17.086,56.512,6.369,8.002,6.917
 4048.409,129.666,1281.494,19.823,-158.499,7.867,8.396,-0.000,2.594,3.343,6.794,17.489,56.085,6.067,8.443,7.289
 4048.909,129.631,1280.322,19.534,-157.552,7.427,8.390,0.003,2.607,3.298,6.016,18.393,55.641,5.754,9.011,7.743
 4049.409,129.689,1293.945,19.292,-156.921,6.971,8.384,0.006,2.615,3.293,5.547,19.591,55.234,5.466,9.744,8.251
 4049.909,129.566,1283.594,19.532,-157.207,6.543,8.382,0.008,2.621,3.306,5.226,21.013,54.901,5.231,10.617,8.772
 4050.409,129.654,1282.471,20.511,-157.550,6.082,8.382,0.007,2.622,3.407,5.126,23.330,54.548,4.981,11.631,9.194
 4050.909,129.780,1274.414,21.858,-157.782,5.602,8.382,0.003,2.627,3.524,4.871,26.874,54.176,4.718,12.610,9.419
 4051.409,129.860,1281.152,23.384,-158.036,5.175,8.382,0.002,2.642,3.538,3.959,31.135,53.786,4.442,13.350,9.346
 4051.909,129.719,1284.180,24.214,-158.696,4.795,8.382,0.003,2.661,3.532,2.889,34.767,53.433,4.193,13.565,8.972
 4052.409,129.655,1284.180,24.787,-160.034,4.568,8.388,0.008,2.676,3.536,2.012,35.767,53.342,4.129,13.153,8.357
 4052.909,129.785,1287.744,23.656,-161.249,4.618,8.399,0.013,2.669,3.590,2.388,33.477,53.726,4.400,12.329,7.604
 4053.409,129.635,1288.037,21.523,-162.883,5.119,8.403,0.014,2.638,3.641,4.217,29.008,54.700,5.088,11.275,6.845
 4053.909,129.708,1289.063,20.975,-164.699,6.164,8.403,0.013,2.597,3.648,6.605,24.337,56.121,6.092,10.204,6.141
 4054.409,129.584,1293.164,23.118,-166.706,7.580,8.402,0.013,2.564,3.693,8.512,20.891,57.522,7.082,9.174,5.532
 4054.909,129.882,1293.945,25.254,-168.086,9.046,8.397,0.018,2.548,3.714,9.452,18.786,58.596,7.842,8.281,5.032
 4055.409,129.701,1293.945,23.958,-169.195,10.398,8.387,0.021,2.538,3.761,10.059,17.365,59.419,8.424,7.525,4.614
 4055.909,129.743,1293.945,20.713,-169.734,11.511,8.381,0.019,2.522,3.820,11.020,16.048,60.155,8.944,6.935,4.288
 4056.409,129.629,1293.945,18.542,-170.007,12.262,8.381,0.018,2.509,3.790,11.734,14.693,60.959,9.512,6.466,4.017
 4056.909,129.682,1281.934,18.035,-171.122,12.685,8.381,0.023,2.501,3.600,12.216,13.364,61.862,10.150,6.097,3.811
 4057.409,129.810,1293.652,18.067,-172.273,13.242,8.382,0.029,2.496,3.455,12.492,12.142,62.805,10.816,5.818,3.649
 4057.909,129.809,1293.945,18.004,-173.702,14.383,8.382,0.032,2.490,3.385,12.876,11.133,63.789,11.512,5.586,3.528
 4058.409,129.795,1294.092,18.433,-174.280,15.732,8.382,0.026,2.473,3.392,13.885,10.453,64.688,12.147,5.419,3.434
 4058.909,129.773,1293.457,18.847,-174.380,16.708,8.382,0.023,2.465,3.394,14.299,10.392,65.295,12.576,5.279,3.361
 4059.409,129.840,1288.281,18.160,-173.941,17.169,8.375,0.026,2.473,3.366,13.833,10.778,65.624,12.809,5.169,3.302
 4059.909,129.734,1291.016,17.506,-173.315,17.266,8.338,0.032,2.487,3.450,13.019,11.101,65.810,12.940,5.089,3.260
 4060.409,129.778,1293.945,17.108,-172.844,17.336,8.284,0.038,2.500,3.527,12.283,11.031,66.015,13.085,5.029,3.232
 4060.909,129.846,1300.293,16.762,-173.462,17.744,8.258,0.037,2.496,3.522,12.537,10.690,66.236,13.241,4.986,3.220
 4061.409,130.034,1302.051,16.885,-173.927,18.664,8.255,0.032,2.485,3.409,13.170,10.391,66.379,13.342,4.952,3.219
 4061.909,129.701,1293.945,15.688,-174.331,19.827,8.255,0.025,2.475,3.270,13.723,10.290,66.418,13.370,4.916,3.224
 4062.409,129.884,1290.137,15.493,-175.040,20.745,8.255,0.020,2.469,3.147,14.065,10.217,66.525,13.445,4.874,3.227
 4062.909,129.795,1290.283,17.885,-174.736,20.986,8.255,0.017,2.465,3.178,14.316,9.998,66.718,13.581,4.818,3.227
 4063.409,129.850,1293.018,19.736,-174.844,20.644,8.255,0.020,2.461,3.236,14.567,9.652,66.780,13.625,4.753,3.219
 4063.909,129.932,1299.854,21.620,-173.464,20.007,8.254,0.027,2.459,3.179,14.652,9.314,66.596,13.495,4.672,3.203
 4064.409,129.813,1298.828,23.036,-172.281,19.471,8.254,0.035,2.465,3.160,14.315,9.154,66.205,13.219,4.579,3.181
 4064.909,129.930,1294.727,25.376,-171.623,19.504,8.254,0.041,2.480,3.165,13.463,9.155,65.755,12.901,4.480,3.155
 4065.409,129.836,1288.525,27.691,-171.622,19.718,8.259,0.040,2.490,3.226,12.851,9.200,65.287,12.570,4.367,3.125
 4065.909,129.782,1287.988,26.947,-171.938,19.693,8.275,0.035,2.497,3.236,12.440,9.336,64.709,12.162,4.257,3.093
 4066.409,129.875,1291.064,23.810,-171.895,19.042,8.308,0.030,2.504,3.230,12.036,9.582,63.927,11.610,4.146,3.077
 4066.909,129.751,1303.125,20.365,-171.361,17.780,8.348,0.029,2.516,3.324,11.373,9.747,63.127,11.044,4.058,3.094
 4067.409,129.748,1298.828,19.799,-170.732,16.544,8.392,0.030,2.527,3.453,10.712,9.528,62.610,10.678,4.049,3.192
 4067.909,129.899,1293.994,22.414,-169.621,15.897,8.440,0.030,2.535,3.510,10.240,8.898,62.438,10.557,4.130,3.383
 4068.409,129.809,1291.553,27.244,-168.219,16.183,8.498,0.028,2.541,3.442,9.887,8.694,62.337,10.486,4.371,3.707
 4068.909,129.882,1293.945,32.490,-166.565,16.398,8.558,0.027,2.559,3.475,8.810,10.316,61.644,9.996,4.765,4.158
 4069.409,129.879,1296.680,34.824,-165.927,15.212,8.621,0.027,2.598,3.834,6.544,17.077,59.825,8.710,5.373,4.767
 4069.909,129.808,1289.063,34.868,-165.545,12.612,8.670,0.023,2.632,4.294,4.544,27.346,57.538,7.094,6.211,5.533
 4070.409,129.810,1292.041,34.586,-165.984,9.545,8.688,0.018,2.649,4.509,3.570,37.183,55.610,5.732,7.393,6.544
 4070.909,129.754,1293.311,34.752,-167.020,7.433,8.696,0.011,2.640,4.528,4.100,45.788,54.525,4.964,8.951,7.749
 4071.409,129.896,1295.410,31.755,-167.657,6.641,8.693,0.007,2.624,4.464,5.018,53.516,54.090,4.657,10.957,9.205
 4071.909,129.976,1297.949,25.554,-168.267,6.489,8.648,0.004,2.605,4.548,6.126,60.553,53.770,4.431,13.185,10.697
 4072.409,129.821,1290.527,19.119,-168.407,6.349,8.598,0.003,2.586,4.586,7.271,64.941,53.496,4.237,15.127,12.044
 4072.909,129.892,1293.945,15.809,-169.091,6.053,8.579,0.006,2.576,4.347,7.823,64.230,53.314,4.109,16.527,13.073
 4073.409,129.902,1286.621,17.873,-170.100,5.830,8.592,0.016,2.585,4.194,7.294,61.290,53.341,4.128,17.277,13.578
 4073.909,130.023,1292.627,19.618,-171.238,5.722,8.651,0.027,2.610,4.201,5.847,58.802,53.488,4.231,17.719,13.741
 4074.409,129.841,1289.063,18.491,-172.043,5.597,8.718,0.028,2.625,4.403,4.992,56.893,53.580,4.297,18.084,13.687
 4074.909,129.859,1295.508,14.827,-172.633,5.465,8.750,0.022,2.628,4.580,4.773,54.503,53.677,4.365,18.184,13.583
 4075.409,129.962,1298.828,11.280,-172.942,5.411,8.758,0.012,2.616,4.548,5.521,49.730,53.803,4.454,18.143,13.578
 4075.909,129.899,1298.828,12.215,-173.525,5.463,8.759,0.008,2.600,4.483,6.412,44.154,53.998,4.592,17.923,13.576
 4076.409,129.949,1294.482,14.638,-173.921,5.630,8.759,0.012,2.595,4.484,6.734,40.938,54.199,4.734,17.768,13.578
 4076.909,130.035,1298.828,15.043,-174.328,5.999,8.762,0.019,2.595,4.595,6.705,43.780,54.259,4.777,17.685,13.502
 4077.409,129.742,1294.238,13.248,-174.443,6.369,8.775,0.025,2.601,4.778,6.396,51.781,54.224,4.752,17.746,13.358
 4077.909,129.944,1293.945,12.475,-174.810,6.553,8.784,0.025,2.597,4.985,6.589,59.882,54.139,4.692,17.866,13.281
 4078.409,130.000,1293.945,13.987,-175.688,6.521,8.784,0.026,2.599,5.077,6.472,63.507,54.108,4.670,18.133,13.311
 4078.909,129.894,1291.455,15.698,-176.586,6.380,8.784,0.027,2.607,4.971,6.009,61.080,54.141,4.694,18.410,13.497
 4079.409,129.839,1289.258,16.091,-176.905,6.404,8.784,0.029,2.614,4.823,5.620,57.395,54.085,4.653,18.856,13.746
 4079.909,129.945,1293.945,15.391,-176.626,6.549,8.784,0.028,2.609,4.825,5.897,58.118,56.424,6.307,19.196,13.947
 4080.409,129.863,1298.389,14.720,-177.051,6.598,8.784,0.026,2.600,4.886,6.440,62.079,61.411,9.831,19.609,14.122
 4080.909,129.969,1299.902,14.927,-177.772,6.438,8.784,0.026,2.593,4.922,6.814,62.640,67.392,14.058,19.980,14.308
 4081.409,129.854,1302.441,16.365,-178.565,6.284,8.784,0.028,2.579,4.665,7.659,56.324,72.157,17.426,20.276,14.488
 4081.909,130.014,1300.391,17.450,-179.330,6.508,8.784,0.027,2.559,4.307,8.836,46.186,73.554,18.413,20.562,14.645
 4082.409,130.041,1293.945,17.408,-179.422,7.073,8.784,0.026,2.557,4.163,8.960,39.762,72.339,17.554,20.537,14.632
 4082.909,129.858,1297.412,16.646,-178.957,7.546,8.784,0.022,2.577,4.223,7.772,41.626,72.301,17.527,20.392,14.429
 4083.409,129.984,1297.705,16.367,-178.194,7.542,8.784,0.014,2.602,4.514,6.329,47.812,77.093,20.914,20.114,14.180
 4083.909,130.079,1293.945,17.483,-177.285,7.118,8.784,0.006,2.615,4.726,5.539,52.115,85.201,26.644,19.908,13.919
 4084.409,130.048,1293.945,17.605,-176.842,6.655,8.784,0.001,2.618,4.810,5.398,52.661,89.989,30.027,19.671,13.725
 4084.909,129.968,1293.945,17.041,-176.681,6.443,8.783,0.001,2.619,4.837,5.333,53.458,86.003,27.211,19.519,13.521
 4085.409,130.040,1293.945,16.650,-177.238,6.485,8.780,0.003,2.619,4.736,5.307,58.734,76.318,20.366,19.139,13.230
 4085.909,129.998,1285.645,16.498,-177.755,6.584,8.773,0.004,2.620,4.617,5.273,65.857,67.404,14.067,18.742,12.896
 4086.409,129.935,1287.256,18.065,-179.284,6.527,8.756,0.004,2.622,4.583,5.168,67.666,64.525,12.032,18.296,12.483
 4086.909,129.898,1284.180,19.191,-179.653,6.314,8.734,0.007,2.630,4.568,4.692,62.687,65.671,12.841,17.840,11.989
 4087.409,130.118,1281.348,17.811,-179.438,6.108,8.706,0.009,2.634,4.458,4.419,57.872,65.906,13.008,17.401,11.420
 4087.909,129.905,1293.457,15.436,-178.997,6.015,8.671,0.010,2.631,4.328,4.598,56.232,63.148,11.059,16.765,10.791
 4088.409,130.010,1293.945,14.821,-178.858,6.133,8.639,0.012,2.623,4.317,5.075,54.494,58.662,7.888,15.975,10.169
 4088.909,129.849,1279.443,15.943,-178.994,6.493,8.606,0.015,2.607,4.468,5.997,48.399,55.633,5.748,15.103,9.604
 4089.409,129.929,1279.297,17.534,-178.445,7.200,8.568,0.023,2.588,4.496,7.161,37.424,55.967,5.983,14.254,9.087
 4089.909,130.085,1279.883,17.315,-178.049,8.252,8.538,0.029,2.564,4.364,8.551,28.442,57.490,7.060,13.534,8.626
 4090.409,130.062,1288.379,15.662,-178.098,9.520,8.529,0.033,2.548,4.258,9.447,25.130,58.472,7.754,12.892,8.184
 4090.909,129.937,1274.414,15.078,-177.557,10.429,8.527,0.039,2.549,4.288,9.392,25.091,58.703,7.917,12.331,7.775
 4091.409,130.030,1286.328,15.105,-176.926,10.613,8.524,0.043,2.553,4.436,9.207,25.430,58.446,7.735,11.785,7.428
 4091.909,129.879,1280.664,15.001,-176.256,10.445,8.508,0.041,2.546,4.441,9.563,24.801,58.130,7.512,11.297,7.130
 4092.409,130.076,1289.063,14.891,-175.705,10.514,8.451,0.030,2.526,4.333,10.752,24.026,58.008,7.426,10.874,6.887
 4092.909,130.091,1293.018,14.738,-176.255,10.910,8.377,0.018,2.510,4.197,11.667,24.046,58.063,7.465,10.513,6.656
 4093.409,130.054,1282.129,14.895,-175.705,11.128,8.335,0.012,2.510,4.126,11.680,24.755,58.099,7.490,10.220,6.447
 4093.909,130.089,1281.543,15.615,-175.678,10.960,8.322,0.010,2.515,4.144,11.413,24.954,58.135,7.516,9.977,6.272
 4094.409,130.042,1292.773,16.412,-175.068,10.823,8.317,0.012,2.520,4.179,11.124,24.086,58.242,7.592,9.776,6.119
 4094.909,129.993,1293.945,18.722,-175.460,10.986,8.313,0.014,2.518,4.091,11.233,22.764,58.370,7.682,9.594,6.003
 4095.409,130.081,1286.035,21.832,-176.271,11.198,8.312,0.013,2.511,3.993,11.653,21.783,58.473,7.755,9.435,5.891
 4095.909,130.105,1285.791,23.312,-176.673,11.145,8.312,0.010,2.499,4.003,12.321,21.145,58.661,7.888,9.274,5.797
 4096.409,130.039,1284.912,22.677,-176.920,10.961,8.312,0.006,2.487,4.058,13.047,20.420,58.998,8.126,9.132,5.705
 4096.909,130.074,1289.746,19.434,-176.864,10.852,8.312,0.008,2.490,4.179,12.862,19.556,59.447,8.443,8.991,5.617
 4097.409,129.966,1294.434,15.627,-177.247,10.688,8.312,0.016,2.506,4.200,11.923,19.038,59.744,8.653,8.880,5.544
 4097.909,130.131,1289.063,13.317,-176.966,10.476,8.305,0.019,2.516,4.209,11.366,19.525,59.605,8.555,8.774,5.470
 4098.409,130.047,1293.701,12.821,-176.761,10.291,8.271,0.020,2.523,4.262,10.913,20.550,59.230,8.290,8.685,5.405
 4098.909,130.027,1291.650,14.176,-176.126,10.277,8.225,0.023,2.536,4.260,10.195,21.517,58.870,8.035,8.629,5.348
 4099.409,130.152,1289.063,15.225,-175.820,10.498,8.194,0.025,2.547,4.261,9.550,22.197,58.673,7.896,8.559,5.296
 4099.909,130.053,1286.523,15.678,-176.253,10.639,8.174,0.026,2.552,4.227,9.239,22.592,58.676,7.898,8.559,5.256
 4100.409,130.130,1289.063,16.730,-176.591,10.651,8.161,0.022,2.542,4.238,9.799,22.910,58.747,7.949,8.505,5.196
 4100.909,130.162,1289.063,17.752,-176.078,10.550,8.152,0.017,2.531,4.257,10.489,22.986,58.811,7.994,8.430,5.117
 4101.409,130.100,1284.180,18.048,-175.459,10.371,8.144,0.014,2.525,4.226,10.838,22.624,58.859,8.028,8.299,5.033
 4101.909,130.160,1284.180,17.649,-174.775,10.315,8.140,0.010,2.522,4.154,10.998,21.754,58.988,8.119,8.133,4.936
 4102.409,130.138,1285.547,16.894,-175.660,10.264,8.138,0.010,2.523,4.074,10.913,20.629,59.269,8.317,7.966,4.848
 4102.909,130.100,1290.674,16.070,-176.901,10.244,8.138,0.013,2.523,4.065,10.935,19.478,59.661,8.594,7.767,4.741
 4103.409,130.279,1289.063,15.353,-177.669,10.359,8.138,0.019,2.527,4.104,10.722,18.760,59.954,8.801,7.581,4.644
 4103.909,130.073,1289.063,14.886,-177.249,10.623,8.140,0.027,2.535,4.198,10.261,18.492,59.958,8.804,7.388,4.552
 4104.409,130.187,1283.008,14.802,-176.488,10.953,8.143,0.030,2.542,4.229,9.811,18.287,59.741,8.651,7.222,4.466
 4104.909,130.122,1279.297,15.108,-176.034,11.063,8.153,0.028,2.536,4.166,10.204,17.851,59.740,8.650,7.079,4.400
 4105.409,130.065,1285.596,15.881,-176.417,10.880,8.168,0.023,2.517,3.874,11.286,17.302,60.113,8.914,6.957,4.323
 4105.909,130.153,1285.107,17.227,-176.596,10.560,8.176,0.019,2.505,3.583,11.980,17.126,60.620,9.272,6.873,4.266
 4106.409,130.104,1287.402,18.189,-176.182,10.357,8.176,0.014,2.500,3.534,12.267,17.279,60.838,9.426,6.803,4.210
 4106.909,130.032,1293.945,17.378,-175.811,10.405,8.169,0.013,2.512,3.629,11.572,17.447,60.603,9.260,6.739,4.164
 4107.409,130.182,1279.297,15.844,-175.184,10.507,8.146,0.017,2.530,3.776,10.554,17.443,60.262,9.019,6.689,4.124
 4107.909,130.160,1292.627,15.723,-174.744,10.576,8.127,0.023,2.543,3.806,9.759,17.356,60.082,8.892,6.627,4.079
 4108.409,130.136,1284.180,17.310,-174.325,10.511,8.121,0.028,2.553,3.899,9.156,17.316,60.149,8.939,6.580,4.039
 4108.909,130.021,1284.180,18.573,-174.136,10.290,8.109,0.028,2.555,4.001,9.062,17.302,60.276,9.029,6.530,4.000
 4109.409,130.137,1291.602,17.229,-175.047,10.160,8.099,0.027,2.559,4.005,8.824,17.302,60.274,9.028,6.484,3.952
 4109.909,130.239,1293.945,15.504,-175.802,10.173,8.097,0.028,2.561,3.849,8.703,17.203,60.210,8.982,6.431,3.900
 4110.409,130.141,1289.063,14.819,-176.488,10.246,8.092,0.031,2.552,3.638,9.225,17.029,60.141,8.933,6.362,3.819
 4110.909,130.128,1279.541,15.784,-176.241,10.310,8.079,0.036,2.540,3.429,9.931,16.794,60.138,8.931,6.266,3.733
 4111.409,130.218,1281.396,17.868,-175.914,10.392,8.072,0.038,2.528,3.384,10.637,16.385,60.163,8.949,6.134,3.644
 4111.909,130.166,1279.785,18.344,-174.368,10.587,8.093,0.037,2.528,3.524,10.624,15.940,60.147,8.938,5.982,3.551
 4112.409,130.111,1290.234,17.889,-173.596,10.851,8.124,0.031,2.535,3.726,10.222,15.548,60.091,8.898,5.822,3.462
 4112.909,130.268,1293.945,16.284,-173.149,11.043,8.134,0.028,2.540,3.849,9.952,15.236,60.089,8.897,5.669,3.360
 4113.409,130.109,1290.674,15.043,-174.449,11.294,8.102,0.037,2.548,3.826,9.492,15.001,60.207,8.980,5.507,3.256
 4113.909,130.252,1288.135,15.229,-175.208,11.724,8.043,0.048,2.548,3.812,9.486,14.728,60.367,9.094,5.350,3.145
 4114.409,130.154,1284.180,16.208,-175.860,12.355,8.011,0.051,2.537,3.802,10.123,14.292,60.498,9.186,5.163,3.026
 4114.909,130.167,1286.523,17.628,-175.720,13.147,8.002,0.051,2.525,3.740,10.839,13.577,60.669,9.306,4.970,2.907
 4115.409,130.195,1293.945,19.810,-175.673,13.917,7.996,0.051,2.517,3.560,11.271,12.556,61.051,9.577,4.744,2.786
 4115.909,130.044,1293.945,20.727,-175.168,14.445,8.018,0.047,2.507,3.363,11.860,11.455,61.683,10.023,4.519,2.671
 4116.409,130.214,1286.035,21.600,-174.833,14.722,8.088,0.035,2.492,3.315,12.727,10.564,62.387,10.521,4.299,2.560
 4116.909,130.176,1290.625,20.619,-174.339,14.791,8.141,0.020,2.479,3.382,13.481,9.953,62.889,10.876,4.095,2.453
 4117.409,130.317,1284.180,17.498,-174.279,14.745,8.149,0.015,2.481,3.487,13.375,9.462,63.230,11.117,3.922,2.357
 4117.909,130.238,1295.850,14.678,-174.272,14.651,8.149,0.024,2.495,3.514,12.555,8.975,63.687,11.440,3.767,2.272
 4118.409,130.233,1294.385,13.759,-174.701,14.616,8.147,0.035,2.507,3.455,11.897,8.505,64.342,11.902,3.637,2.201
 4118.909,130.245,1293.945,15.733,-175.289,14.906,8.140,0.041,2.512,3.450,11.569,8.181,65.016,12.379,3.523,2.140
 4119.409,130.222,1284.570,18.498,-175.104,15.360,8.135,0.045,2.516,3.482,11.338,8.072,65.383,12.638,3.419,2.084
 4119.909,130.233,1279.297,19.166,-174.784,15.800,8.135,0.048,2.512,3.468,11.580,8.151,65.274,12.561,3.333,2.037
 4120.409,130.069,1289.111,19.311,-174.229,16.232,8.135,0.054,2.503,3.316,12.100,8.225,64.898,12.295,3.255,1.994
 4120.909,130.049,1293.945,19.740,-174.683,16.577,8.111,0.060,2.495,3.107,12.566,8.239,64.317,11.885,3.191,1.962
 4121.409,130.191,1293.457,19.054,-175.024,16.805,8.060,0.057,2.486,2.849,13.070,8.173,63.648,11.412,3.140,1.941
 4121.909,130.317,1289.844,17.755,-175.266,16.751,8.080,0.043,2.473,2.789,13.871,7.993,63.074,11.006,3.103,1.929
 4122.409,130.105,1284.180,16.495,-174.933,16.534,8.165,0.028,2.458,2.899,14.756,7.821,63.013,10.963,3.081,1.925
 4122.909,130.210,1284.180,16.122,-174.740,16.357,8.219,0.027,2.445,3.006,15.500,7.663,63.912,11.599,3.079,1.928
 4123.409,130.296,1289.795,15.895,-174.721,16.274,8.192,0.042,2.439,3.062,15.866,7.564,65.381,12.637,3.089,1.938
 4123.909,130.118,1293.945,16.722,-175.054,16.345,8.110,0.058,2.439,2.968,15.824,7.522,66.740,13.597,3.120,1.956
 4124.409,130.204,1297.852,18.037,-175.422,16.706,8.059,0.060,2.440,2.935,15.764,7.515,67.189,13.914,3.155,1.981
 4124.909,130.302,1286.914,18.725,-175.291,17.459,8.049,0.049,2.446,3.061,15.456,7.738,66.507,13.432,3.200,2.010
 4125.409,130.199,1289.063,18.716,-174.658,18.190,8.049,0.037,2.450,3.293,15.180,8.253,65.310,12.587,3.244,2.042
 4125.909,130.183,1292.822,17.206,-174.362,18.120,8.049,0.035,2.464,3.488,14.387,8.879,64.250,11.837,3.294,2.073
 4126.409,130.101,1291.895,16.342,-174.562,17.159,8.049,0.044,2.485,3.490,13.161,9.358,63.771,11.499,3.347,2.108
 4126.909,130.121,1298.828,16.848,-174.895,16.024,8.049,0.054,2.498,3.455,12.399,9.528,63.882,11.577,3.400,2.142
 4127.409,130.327,1287.402,17.444,-174.547,15.600,8.050,0.055,2.494,3.435,12.635,9.412,64.268,11.850,3.463,2.184
 4127.909,130.164,1284.180,18.325,-174.017,15.930,8.063,0.044,2.478,3.396,13.590,9.228,64.577,12.069,3.524,2.236
 4128.409,130.300,1286.084,17.049,-174.480,16.269,8.087,0.032,2.469,3.409,14.120,9.147,64.513,12.023,3.594,2.296
 4128.909,130.134,1293.506,15.798,-174.983,16.267,8.108,0.025,2.469,3.383,14.104,9.273,64.031,11.683,3.673,2.367
 4129.409,130.195,1293.945,15.763,-175.365,16.041,8.159,0.028,2.477,3.495,13.604,9.626,63.338,11.193,3.767,2.436
 4129.909,130.138,1289.258,16.728,-174.898,15.670,8.208,0.039,2.490,3.578,12.841,10.026,62.810,10.820,3.887,2.520
 4130.409,130.174,1294.043,17.567,-174.624,15.107,8.219,0.050,2.500,3.461,12.277,10.421,62.697,10.740,4.035,2.617
 4130.909,130.168,1289.063,17.608,-174.133,14.600,8.231,0.056,2.504,3.310,12.053,10.847,62.826,10.831,4.201,2.731
 4131.409,130.306,1294.238,18.294,-173.356,14.291,8.230,0.053,2.503,3.293,12.123,11.608,62.785,10.802,4.397,2.866
 4131.909,130.224,1285.059,20.128,-172.392,14.109,8.207,0.049,2.513,3.417,11.507,12.669,62.335,10.484,4.593,3.005
 4132.409,130.304,1298.828,21.898,-171.905,14.006,8.195,0.044,2.529,3.557,10.582,13.663,61.603,9.967,4.796,3.153
 4132.909,130.401,1293.408,21.618,-171.215,13.774,8.195,0.037,2.534,3.578,10.318,14.328,61.017,9.553,5.014,3.311
 4133.409,130.287,1292.139,19.230,-171.558,13.468,8.195,0.032,2.532,3.572,10.400,14.686,60.688,9.320,5.222,3.471
 4133.909,130.380,1293.213,17.452,-171.533,13.093,8.198,0.027,2.526,3.632,10.739,15.070,60.322,9.062,5.435,3.646
 4134.409,130.272,1282.422,17.686,-172.000,12.519,8.218,0.028,2.536,3.642,10.189,15.768,59.661,8.595,5.635,3.826
 4134.909,130.307,1284.180,18.226,-171.171,11.859,8.288,0.031,2.556,3.604,9.010,17.158,58.760,7.958,5.800,4.003
 4135.409,130.311,1294.873,18.079,-169.687,11.091,8.410,0.032,2.580,3.634,7.612,19.212,57.764,7.254,5.973,4.186
 4135.909,130.225,1293.945,18.580,-167.869,10.177,8.541,0.034,2.615,3.823,5.576,21.360,56.928,6.663,6.099,4.333
 4136.409,130.213,1293.945,20.584,-166.482,9.301,8.637,0.032,2.641,4.114,4.017,22.567,56.367,6.267,6.200,4.451
 4136.909,130.310,1290.527,23.299,-166.683,8.795,8.673,0.027,2.647,4.242,3.669,22.202,56.112,6.086,6.248,4.548
 4137.409,130.194,1297.949,24.660,-167.160,8.759,8.678,0.022,2.630,4.097,4.685,20.660,56.458,6.331,6.257,4.601
 4137.909,130.323,1293.945,25.418,-167.767,9.200,8.677,0.020,2.594,3.677,6.780,18.586,57.544,7.098,6.221,4.639
 4138.409,130.186,1289.697,26.355,-166.993,10.056,8.677,0.023,2.563,3.279,8.568,17.069,59.046,8.159,6.163,4.621
 4138.909,130.344,1292.041,27.363,-165.914,11.030,8.677,0.030,2.549,3.067,9.429,16.110,60.404,9.119,6.045,4.569
 4139.409,130.183,1289.063,29.522,-164.481,12.051,8.678,0.034,2.544,2.958,9.704,15.618,61.200,9.682,5.926,4.489
 4139.909,130.293,1291.797,32.305,-163.471,13.140,8.704,0.035,2.548,3.013,9.490,15.156,61.959,10.219,5.768,4.395
 4140.409,130.448,1293.799,33.984,-162.935,13.934,8.746,0.035,2.557,3.101,8.968,14.567,62.740,10.770,5.601,4.317
 4140.909,130.246,1293.945,32.166,-161.446,14.274,8.765,0.036,2.564,3.241,8.512,14.128,62.894,10.879,5.447,4.291
 4141.409,130.259,1293.994,28.999,-160.130,14.252,8.769,0.046,2.581,3.303,7.522,13.423,62.484,10.589,5.338,4.329
 4141.909,130.412,1298.828,26.979,-159.038,14.158,8.769,0.060,2.603,3.254,6.267,12.643,61.464,9.869,5.335,4.477
 4142.409,130.225,1293.945,27.314,-158.148,14.328,8.768,0.066,2.615,3.191,5.562,11.967,61.131,9.634,5.453,4.735
 4142.909,130.382,1293.945,30.777,-156.352,14.293,8.765,0.056,2.618,3.254,5.359,11.870,62.596,10.669,5.751,5.145
 4143.409,130.463,1293.945,34.462,-153.991,13.594,8.753,0.033,2.611,3.443,5.806,12.733,64.348,11.907,6.248,5.722
 4143.909,130.314,1297.021,36.423,-150.813,12.060,8.727,0.014,2.613,3.712,5.693,15.124,65.016,12.379,6.982,6.520
 4144.409,130.288,1298.828,36.770,-149.653,10.230,8.700,0.009,2.627,3.934,4.875,19.178,63.659,11.420,8.033,7.570
 4144.909,130.349,1298.828,35.616,-148.776,8.756,8.688,0.015,2.646,4.086,3.724,24.396,60.330,9.067,9.422,8.903
 4145.409,130.195,1298.828,33.466,-147.891,7.789,8.688,0.021,2.664,4.160,2.670,29.459,58.333,7.656,11.240,10.472
 4145.909,130.256,1302.393,31.948,-146.783,7.222,8.687,0.021,2.667,4.190,2.504,32.595,59.079,8.183,13.351,12.242
 4146.409,130.364,1303.711,31.489,-145.492,6.888,8.687,0.016,2.667,4.166,2.533,33.085,61.358,9.793,15.545,13.962
 4146.909,130.338,1296.094,32.975,-144.502,6.716,8.685,0.010,2.659,4.023,2.954,31.866,63.137,11.051,17.342,15.402
 4147.409,130.314,1289.063,34.640,-144.062,6.679,8.682,0.006,2.657,3.905,3.077,30.043,62.026,10.266,18.457,16.242
 4147.909,130.217,1289.063,34.678,-143.550,6.730,8.679,0.007,2.659,3.817,3.008,28.302,59.120,8.212,18.956,16.584
 4148.409,130.383,1302.002,34.917,-142.554,6.756,8.676,0.008,2.654,3.810,3.246,26.488,59.840,8.721,19.088,16.672
 4148.909,130.306,1298.828,34.258,-141.377,6.773,8.674,0.012,2.654,3.791,3.304,24.849,65.670,12.841,19.308,16.862
 4149.409,130.281,1296.875,35.933,-140.624,6.747,8.674,0.012,2.651,3.804,3.423,25.306,73.372,18.284,19.730,17.370
 4149.909,130.423,1302.930,38.211,-140.735,6.615,8.674,0.008,2.646,3.864,3.762,27.978,77.957,21.525,20.399,18.150
 4150.409,130.280,1301.514,41.227,-140.640,6.425,8.674,0.008,2.646,4.011,3.744,32.690,76.213,20.292,21.581,19.146
 4150.909,130.298,1298.828,42.815,-139.895,6.168,8.674,0.013,2.651,4.283,3.439,37.397,72.428,17.617,22.838,19.947
 4151.409,130.279,1303.711,40.027,-139.245,5.935,8.671,0.020,2.655,4.502,3.226,40.403,74.014,18.738,23.630,20.008
 4151.909,130.347,1303.613,37.733,-138.969,5.750,8.660,0.024,2.660,4.603,2.899,42.436,81.171,23.796,23.601,19.348
 4152.409,130.295,1301.465,35.954,-138.765,5.637,8.637,0.018,2.656,4.499,3.168,41.885,89.727,29.842,21.811,17.821
 4152.909,130.337,1298.828,38.425,-138.915,5.644,8.603,0.012,2.647,4.300,3.704,37.497,96.566,34.676,19.337,16.150
 4153.409,130.317,1295.947,43.877,-137.771,5.886,8.561,0.011,2.637,3.915,4.298,29.090,102.912,39.160,16.698,14.620
 4153.909,130.469,1289.600,47.445,-136.328,6.471,8.530,0.016,2.624,3.439,5.057,19.853,111.646,45.333,14.444,13.209
 4154.409,130.349,1293.945,50.476,-134.876,7.499,8.514,0.022,2.612,2.933,5.744,13.702,120.366,51.496,12.689,11.972
 4154.909,130.342,1302.930,50.906,-133.446,8.962,8.496,0.023,2.596,2.529,6.639,11.289,122.820,53.230,11.292,10.835
 4155.409,130.407,1298.828,50.461,-133.615,10.666,8.472,0.019,2.580,2.386,7.626,10.854,117.602,49.542,10.178,9.852
 4155.909,130.361,1300.879,49.029,-133.630,11.965,8.448,0.015,2.565,2.340,8.507,10.884,111.061,44.919,9.296,9.056
 4156.409,130.367,1305.029,43.056,-134.084,12.432,8.427,0.015,2.558,2.349,8.893,10.914,110.740,44.693,8.626,8.429
 4156.909,130.326,1293.945,37.996,-134.400,12.299,8.418,0.017,2.560,2.325,8.745,10.757,116.999,49.116,8.106,7.955
 4157.409,130.290,1305.371,35.434,-134.740,12.036,8.417,0.019,2.565,2.226,8.457,10.409,122.926,53.305,7.714,7.601
 4157.909,130.415,1300.342,35.603,-135.666,11.909,8.417,0.019,2.566,2.144,8.413,9.960,122.843,53.246,7.388,7.329
 4158.409,130.332,1303.711,38.808,-136.642,11.908,8.417,0.016,2.557,2.088,8.934,9.539,116.985,49.106,7.110,7.110
 4158.909,130.365,1302.002,40.835,-137.077,11.876,8.417,0.012,2.546,2.058,9.609,9.188,110.452,44.489,6.874,6.927
 4159.409,130.415,1298.828,43.791,-136.570,11.854,8.417,0.009,2.536,2.034,10.185,8.853,106.843,41.939,6.679,6.764
 4159.909,130.379,1298.828,46.645,-135.740,11.875,8.417,0.007,2.530,2.015,10.529,8.559,106.287,41.546,6.526,6.632
 4160.409,130.377,1307.910,47.200,-135.684,11.814,8.417,0.006,2.532,1.999,10.430,8.342,106.008,41.348,6.421,6.524
 4160.909,130.313,1301.025,45.252,-136.724,11.703,8.417,0.006,2.536,1.957,10.149,8.278,106.578,41.751,6.343,6.443
 4161.409,130.249,1303.711,42.360,-137.823,11.623,8.417,0.007,2.544,1.897,9.731,8.355,110.270,44.360,6.294,6.380
 4161.909,130.391,1298.828,43.410,-138.181,11.477,8.417,0.009,2.551,1.878,9.303,8.470,117.003,49.119,6.253,6.331
 4162.409,130.453,1303.711,45.623,-138.031,11.244,8.417,0.011,2.553,1.933,9.173,8.550,123.480,53.696,6.221,6.288
 4162.909,130.469,1309.082,44.915,-137.413,11.042,8.417,0.013,2.552,1.987,9.211,8.612,127.607,56.613,6.194,6.257
 4163.409,130.254,1299.170,42.506,-136.949,10.982,8.417,0.014,2.549,2.016,9.429,8.679,132.214,59.868,6.174,6.235
 4163.909,130.355,1303.711,37.540,-136.393,11.114,8.417,0.015,2.549,1.970,9.416,8.738,137.907,63.892,6.162,6.220
 4164.409,130.424,1299.414,35.912,-135.855,11.249,8.417,0.016,2.548,1.923,9.459,8.732,137.997,63.956,6.154,6.212
 4164.909,130.429,1297.461,38.426,-136.167,11.105,8.417,0.016,2.546,1.916,9.568,8.616,128.626,57.333,6.148,6.201
 4165.409,130.317,1293.945,41.118,-136.473,10.872,8.417,0.018,2.552,1.948,9.230,8.456,114.694,47.487,6.133,6.181
 4165.909,130.291,1297.314,42.478,-136.725,10.890,8.417,0.021,2.558,2.046,8.880,8.322,108.397,43.037,6.116,6.150
 4166.409,130.514,1307.568,41.022,-137.561,11.039,8.417,0.024,2.563,2.140,8.597,8.205,111.903,45.515,6.083,6.114
 4166.909,130.302,1303.711,41.668,-137.837,11.178,8.417,0.024,2.562,2.173,8.674,8.103,118.093,49.889,6.052,6.083
 4167.409,130.360,1295.215,44.263,-137.896,11.316,8.417,0.023,2.562,2.118,8.660,8.001,120.254,51.416,6.022,6.067
 4167.909,130.400,1306.543,45.431,-137.241,11.501,8.417,0.027,2.569,2.079,8.274,7.932,115.486,48.047,6.004,6.056
 4168.409,130.404,1308.594,45.360,-136.540,11.786,8.417,0.031,2.572,2.121,8.063,7.930,108.019,42.770,5.997,6.056
 4168.909,130.401,1332.910,43.836,-135.983,11.990,8.417,0.034,2.572,2.159,8.049,7.930,102.308,38.734,6.013,6.066
 4169.409,130.428,1308.594,44.574,-135.595,11.933,8.417,0.036,2.573,2.155,8.017,7.928,99.941,37.061,6.046,6.094
 4169.909,130.396,1308.594,46.760,-134.992,11.717,8.417,0.035,2.574,2.102,7.977,7.982,99.617,36.832,6.101,6.142
 4170.409,130.310,1304.590,47.479,-134.689,11.461,8.417,0.033,2.574,2.106,7.978,8.119,99.660,36.862,6.174,6.208
 4170.909,130.370,1298.828,47.408,-135.909,11.262,8.417,0.026,2.562,2.155,8.683,8.317,99.252,36.574,6.256,6.274
 4171.409,130.485,1309.082,44.072,-136.997,11.304,8.417,0.018,2.547,2.151,9.504,8.537,98.759,36.226,6.341,6.343
 4171.909,130.366,1298.926,40.570,-138.596,11.505,8.417,0.015,2.544,2.124,9.725,8.697,98.432,35.994,6.414,6.399
 4172.409,130.553,1303.711,37.902,-138.631,11.678,8.417,0.015,2.549,2.115,9.438,8.728,98.409,35.978,6.473,6.447
 4172.909,130.519,1303.564,37.769,-137.727,11.706,8.417,0.020,2.561,2.146,8.742,8.608,97.792,35.542,6.520,6.486
 4173.409,130.424,1298.828,41.005,-136.605,11.501,8.417,0.023,2.568,2.169,8.313,8.417,95.447,33.885,6.547,6.504
 4173.909,130.512,1298.486,43.245,-135.959,11.380,8.417,0.022,2.565,2.152,8.460,8.328,94.093,32.928,6.558,6.507
 4174.409,130.432,1299.805,41.629,-136.186,11.472,8.417,0.016,2.548,2.124,9.461,8.413,94.732,33.379,6.543,6.482
 4174.909,130.443,1313.477,38.319,-136.219,11.541,8.417,0.008,2.525,2.094,10.818,8.572,96.778,34.826,6.515,6.446
 4175.409,130.583,1313.477,36.020,-135.869,11.479,8.417,0.002,2.514,2.041,11.471,8.640,98.448,36.006,6.473,6.410
 4175.909,130.384,1303.711,35.734,-135.801,11.414,8.417,0.003,2.519,1.983,11.190,8.595,97.379,35.250,6.440,6.381
 4176.409,130.498,1303.711,38.587,-136.573,11.674,8.417,0.008,2.535,1.962,10.256,8.513,94.802,33.429,6.420,6.372
 4176.909,130.514,1309.668,42.541,-137.295,12.310,8.417,0.013,2.546,1.969,9.609,8.484,94.122,32.949,6.416,6.371
 4177.409,130.470,1313.477,44.466,-137.939,12.933,8.417,0.018,2.553,2.013,9.161,8.563,98.983,36.384,6.429,6.390
 4177.909,130.494,1313.477,44.432,-137.696,13.156,8.417,0.021,2.559,2.061,8.830,8.689,108.903,43.394,6.458,6.418
 4178.409,130.483,1309.619,43.368,-137.129,12.879,8.417,0.019,2.554,2.108,9.110,8.805,118.647,50.281,6.496,6.455
 4178.909,130.564,1310.107,43.445,-135.916,12.180,8.417,0.017,2.545,2.162,9.629,8.862,123.952,54.030,6.545,6.500
 4179.409,130.464,1313.477,44.102,-134.985,11.353,8.417,0.016,2.537,2.149,10.091,8.864,125.280,54.968,6.600,6.545
 4179.909,130.576,1311.719,43.032,-134.807,10.853,8.417,0.016,2.539,2.124,9.991,8.897,125.094,54.837,6.648,6.585
 4180.409,130.580,1312.939,41.405,-135.057,10.850,8.417,0.021,2.555,2.113,9.070,9.005,127.813,56.759,6.685,6.612
 4180.909,130.448,1313.477,43.094,-135.666,11.242,8.413,0.026,2.570,2.096,8.198,9.130,133.186,60.555,6.700,6.620
 4181.409,130.515,1313.477,46.258,-136.607,11.584,8.408,0.031,2.577,2.113,7.774,9.153,137.226,63.411,6.696,6.612
 4181.909,130.649,1313.477,50.433,-138.077,11.482,8.407,0.032,2.578,2.120,7.742,9.028,137.101,63.322,6.685,6.596
 4182.409,130.386,1308.691,52.544,-139.539,11.096,8.407,0.028,2.569,2.114,8.258,8.894,131.018,59.024,6.657,6.575
 4182.909,130.415,1310.986,50.363,-139.726,10.850,8.407,0.022,2.556,2.087,8.991,8.967,119.140,50.629,6.635,6.549
 4183.409,130.532,1308.594,46.431,-139.482,11.021,8.407,0.015,2.543,2.081,9.781,9.315,106.719,41.851,6.604,6.522
 4183.909,130.529,1311.279,43.719,-138.479,11.532,8.407,0.014,2.536,2.184,10.185,9.790,98.547,36.075,6.585,6.494
 4184.409,130.710,1308.984,45.292,-138.124,12.052,8.407,0.019,2.540,2.271,9.961,9.956,98.849,36.289,6.564,6.483
 4184.909,130.608,1313.477,47.694,-138.516,12.311,8.407,0.025,2.547,2.288,9.558,9.729,105.867,41.249,6.565,6.496
 4185.409,130.604,1317.725,49.671,-139.205,12.217,8.407,0.028,2.556,2.256,9.027,9.448,111.695,45.368,6.589,6.515
 4185.909,130.667,1313.477,48.315,-139.622,11.849,8.407,0.029,2.563,2.246,8.604,9.481,116.160,48.523,6.623,6.520
 4186.409,130.553,1314.307,43.661,-139.745,11.431,8.407,0.031,2.567,2.320,8.357,9.862,120.692,51.726,6.665,6.511
 4186.909,130.581,1311.523,40.488,-139.344,11.240,8.407,0.037,2.573,2.357,8.035,10.208,125.934,55.431,6.680,6.518
 4187.409,130.611,1313.477,37.513,-138.498,11.239,8.407,0.042,2.575,2.342,7.919,10.236,128.129,56.982,6.668,6.534
 4187.909,130.613,1317.139,36.358,-137.180,11.300,8.407,0.046,2.577,2.285,7.770,9.856,125.096,54.838,6.621,6.539
 4188.409,130.581,1317.041,40.048,-135.164,11.460,8.407,0.047,2.582,2.237,7.506,9.188,120.515,51.601,6.562,6.495
 4188.909,130.438,1313.477,44.080,-133.962,11.740,8.407,0.044,2.580,2.216,7.588,8.504,115.217,47.857,6.506,6.430
 4189.409,130.511,1305.273,44.597,-133.916,12.280,8.407,0.037,2.570,2.191,8.187,8.095,111.228,45.038,6.445,6.343
 4189.909,130.608,1320.898,42.275,-135.089,12.799,8.407,0.030,2.556,2.194,9.009,7.996,109.587,43.878,6.377,6.254
 4190.409,130.496,1321.436,38.327,-136.293,13.087,8.407,0.025,2.543,2.220,9.746,8.208,108.425,43.056,6.275,6.143
 4190.909,130.532,1318.359,35.840,-137.355,13.167,8.407,0.029,2.546,2.251,9.581,8.657,106.978,42.034,6.157,6.022
 4191.409,130.621,1313.477,34.199,-137.785,12.877,8.407,0.040,2.565,2.290,8.482,9.211,104.509,40.289,6.028,5.884
 4191.909,130.612,1308.887,31.700,-137.962,12.367,8.407,0.048,2.583,2.332,7.445,9.576,101.619,38.246,5.891,5.740
 4192.409,130.563,1313.477,31.902,-137.928,11.761,8.407,0.049,2.588,2.355,7.128,9.327,100.882,37.726,5.761,5.610
 4192.909,130.617,1327.979,33.486,-138.034,11.292,8.407,0.041,2.574,2.336,7.950,8.589,101.395,38.088,5.637,5.503
 4193.409,130.546,1323.145,36.033,-138.376,11.555,8.407,0.035,2.555,2.296,9.077,7.730,101.362,38.065,5.508,5.413
 4193.909,130.668,1318.359,39.000,-138.072,12.562,8.407,0.033,2.541,2.287,9.865,7.148,99.399,36.678,5.389,5.323
 4194.409,130.672,1318.359,41.779,-137.637,14.048,8.407,0.034,2.536,2.292,10.151,7.026,97.595,35.403,5.263,5.216
 4194.909,130.715,1313.867,45.544,-138.000,15.307,8.407,0.034,2.537,2.279,10.093,7.154,97.458,35.306,5.147,5.107
 4195.409,130.631,1315.381,46.661,-137.928,15.731,8.407,0.035,2.543,2.238,9.742,7.325,98.691,36.177,5.046,5.014
 4195.909,130.774,1314.746,43.348,-138.186,15.502,8.407,0.034,2.547,2.206,9.559,7.371,98.762,36.227,4.970,4.939
 4196.409,130.617,1323.242,39.490,-137.843,15.076,8.407,0.032,2.542,2.187,9.842,7.269,94.761,33.400,4.928,4.896
 4196.909,130.620,1318.359,38.806,-138.005,14.672,8.407,0.030,2.539,2.170,10.013,7.133,88.549,29.010,4.905,4.870
 4197.409,130.636,1314.941,40.317,-139.443,14.342,8.407,0.029,2.537,2.160,10.141,7.107,84.606,26.223,4.890,4.857
 4197.909,130.682,1307.080,40.832,-140.178,14.145,8.407,0.029,2.534,2.152,10.291,7.206,84.540,26.176,4.877,4.853
 4198.409,130.695,1329.346,39.692,-142.242,14.080,8.407,0.028,2.529,2.116,10.599,7.357,89.172,29.450,4.865,4.845
 4198.909,130.761,1331.689,37.978,-142.537,14.113,8.407,0.022,2.518,2.044,11.226,7.492,95.454,33.890,4.858,4.837
 4199.409,130.702,1320.313,38.835,-143.767,14.042,8.407,0.014,2.508,1.963,11.839,7.562,99.287,36.598,4.860,4.832
 4199.909,130.724,1318.359,40.496,-143.684,13.643,8.407,0.009,2.504,1.944,12.073,7.552,99.273,36.589,4.863,4.826
 4200.409,130.643,1314.209,40.573,-143.868,13.109,8.407,0.010,2.505,1.989,11.971,7.497,95.130,33.661,4.869,4.825
 4200.909,130.570,1318.359,40.155,-143.642,12.933,8.407,0.016,2.513,2.026,11.538,7.447,89.477,29.666,4.870,4.822
 4201.409,130.628,1318.359,39.915,-143.016,13.291,8.407,0.022,2.519,2.019,11.162,7.412,86.305,27.424,4.869,4.817
 4201.909,130.724,1325.293,41.434,-142.342,13.914,8.407,0.023,2.518,2.000,11.223,7.388,88.463,28.949,4.863,4.814
 4202.409,130.724,1318.945,43.100,-141.849,14.248,8.407,0.023,2.514,2.017,11.441,7.384,94.656,33.326,4.858,4.808
 4202.909,130.714,1318.359,42.738,-141.501,14.252,8.407,0.024,2.517,2.072,11.304,7.457,100.685,37.586,4.848,4.793
 4203.409,130.699,1313.525,41.278,-141.989,14.273,8.407,0.027,2.526,2.111,10.747,7.591,100.131,37.195,4.839,4.774
 4203.909,130.681,1318.359,39.073,-142.168,14.392,8.407,0.032,2.543,2.161,9.786,7.743,93.353,32.405,4.822,4.746
 4204.409,130.824,1318.750,38.840,-142.295,14.590,8.407,0.035,2.552,2.219,9.211,7.879,83.755,25.622,4.801,4.722
 4204.909,130.695,1328.125,39.733,-142.668,14.673,8.407,0.034,2.550,2.215,9.332,7.962,75.771,19.980,4.784,4.701
 4205.409,130.684,1313.477,40.753,-143.452,14.754,8.407,0.032,2.544,2.173,9.710,8.024,73.978,18.712,4.765,4.686
 4205.909,130.832,1316.455,38.360,-145.173,14.991,8.407,0.029,2.536,2.162,10.180,8.080,76.874,20.759,4.756,4.676
 4206.409,130.684,1318.994,33.172,-146.325,15.105,8.406,0.028,2.528,2.183,10.667,8.144,79.370,22.523,4.744,4.670
 4206.909,130.779,1323.242,31.768,-145.891,15.138,8.406,0.026,2.519,2.228,11.182,8.206,79.640,22.714,4.739,4.660
 4207.409,130.703,1327.246,32.981,-144.952,15.071,8.406,0.029,2.523,2.223,10.909,8.249,76.775,20.689,4.728,4.652
 4207.909,130.671,1319.775,33.972,-144.249,14.691,8.407,0.031,2.529,2.167,10.558,8.269,73.621,18.460,4.720,4.643
 4208.409,130.741,1317.236,34.685,-144.552,14.082,8.407,0.033,2.535,2.143,10.254,8.230,72.919,17.964,4.709,4.640
 4208.909,130.710,1317.139,36.278,-145.432,13.475,8.407,0.033,2.533,2.162,10.377,8.125,73.262,18.206,4.700,4.643
 4209.409,130.667,1321.094,42.153,-145.587,13.406,8.407,0.028,2.521,2.199,11.029,7.990,74.439,19.038,4.697,4.653
 4209.909,130.715,1328.125,47.556,-146.697,14.104,8.406,0.025,2.519,2.207,11.160,7.914,76.087,20.203,4.692,4.662
 4210.409,130.765,1334.570,47.576,-146.870,15.029,8.406,0.026,2.522,2.175,10.990,7.929,79.068,22.310,4.691,4.674
 4210.909,130.703,1318.604,42.578,-147.999,15.547,8.407,0.029,2.526,2.136,10.760,7.962,83.172,25.210,4.687,4.682
 4211.409,130.827,1315.283,36.722,-148.178,15.528,8.407,0.033,2.533,2.134,10.374,7.982,85.293,26.709,4.688,4.693
 4211.909,130.846,1327.148,32.919,-147.420,15.259,8.405,0.035,2.539,2.153,10.027,7.967,83.639,25.540,4.697,4.707
 4212.409,130.843,1323.242,33.434,-146.522,15.066,8.404,0.033,2.540,2.187,9.939,7.929,81.047,23.708,4.712,4.731
 4212.909,130.825,1327.881,38.025,-145.911,14.833,8.404,0.026,2.533,2.203,10.348,7.949,81.703,24.172,4.746,4.768
 4213.409,130.825,1330.420,41.941,-146.549,14.412,8.404,0.019,2.523,2.195,10.950,8.110,87.180,28.042,4.784,4.827
 4213.909,130.858,1333.008,44.774,-147.372,14.127,8.404,0.013,2.512,2.200,11.558,8.411,93.845,32.753,4.847,4.904
 4214.409,130.804,1325.586,40.594,-146.809,14.080,8.404,0.014,2.514,2.212,11.450,8.750,96.655,34.738,4.933,5.022
 4214.909,130.742,1333.008,34.487,-145.074,14.083,8.404,0.019,2.527,2.202,10.713,8.974,94.497,33.214,5.062,5.171
 4215.409,130.813,1324.658,30.861,-143.070,13.874,8.404,0.023,2.537,2.179,10.106,9.051,91.404,31.028,5.247,5.368
 4215.909,130.824,1332.568,29.685,-141.449,13.437,8.404,0.023,2.542,2.160,9.827,9.134,91.224,30.900,5.473,5.588
 4216.409,130.899,1328.125,32.205,-140.532,13.144,8.404,0.022,2.550,2.183,9.384,9.396,94.687,33.347,5.720,5.819
 4216.909,130.881,1328.125,33.058,-139.273,13.042,8.404,0.022,2.558,2.206,8.872,9.772,100.339,37.342,5.968,6.064
 4217.409,130.774,1328.125,34.566,-137.258,12.894,8.404,0.023,2.566,2.192,8.420,10.002,104.441,40.241,6.221,6.339
 4217.909,130.803,1318.359,37.479,-134.121,12.649,8.404,0.025,2.568,2.184,8.293,9.845,104.543,40.313,6.526,6.701
 4218.409,130.884,1328.760,41.514,-130.825,12.454,8.404,0.021,2.556,2.178,9.001,9.225,102.690,39.003,6.969,7.200
 4218.909,130.889,1330.762,49.974,-126.868,12.934,8.404,0.016,2.551,2.172,9.281,8.575,103.182,39.351,7.555,7.819
 4219.409,130.919,1323.242,57.645,-123.042,14.262,8.404,0.009,2.553,2.183,9.168,8.946,108.381,43.026,8.282,8.463
 4219.909,130.864,1326.758,58.618,-120.312,15.132,8.403,0.006,2.558,2.175,8.891,12.480,117.464,49.444,8.954,8.929
 4220.409,130.976,1331.152,50.389,-117.960,14.362,8.402,0.008,2.561,2.151,8.702,18.121,125.504,55.126,9.477,9.137
 4220.909,130.955,1331.396,39.047,-116.179,11.925,8.404,0.014,2.570,2.215,8.199,21.175,130.194,58.441,9.773,9.199
 4221.409,130.817,1332.275,38.186,-114.575,9.400,8.427,0.022,2.594,2.341,6.788,19.849,134.181,61.259,9.937,9.239
 4221.909,131.005,1328.125,50.520,-112.890,8.755,8.485,0.024,2.613,2.480,5.671,15.143,134.056,61.170,9.944,9.273
 4222.409,130.853,1328.125,68.609,-110.992,10.149,8.540,0.021,2.616,2.566,5.501,11.287,129.926,58.251,9.758,9.193
 4222.909,130.816,1326.025,84.365,-108.598,12.749,8.572,0.017,2.610,2.613,5.859,10.088,125.832,55.359,9.310,8.899
 4223.409,130.815,1327.881,91.696,-109.308,15.086,8.588,0.017,2.607,2.690,6.039,9.743,122.314,52.872,8.716,8.474
 4223.909,130.917,1330.420,92.541,-109.567,16.368,8.592,0.022,2.609,2.689,5.925,9.563,120.529,51.611,8.172,8.032
 4224.409,131.036,1328.125,88.760,-109.762,16.905,8.592,0.025,2.605,2.602,6.158,9.357,118.004,49.826,7.718,7.662
 4224.909,130.973,1323.242,84.943,-108.472,17.117,8.592,0.024,2.601,2.482,6.349,9.089,109.538,43.843,7.465,7.414
 4225.409,130.944,1327.881,82.731,-106.877,17.335,8.592,0.023,2.607,2.411,6.048,8.744,99.965,37.078,7.318,7.265
 4225.909,130.928,1331.592,79.450,-105.977,17.246,8.592,0.022,2.611,2.381,5.813,8.433,95.645,34.025,7.223,7.125
 4226.409,131.076,1337.451,74.344,-104.640,17.020,8.592,0.020,2.612,2.378,5.705,8.222,94.408,33.151,7.106,6.949
 4226.909,130.965,1333.008,68.961,-103.335,16.739,8.593,0.019,2.613,2.416,5.663,8.072,93.976,32.845,6.820,6.681
 4227.409,131.081,1328.125,66.382,-102.154,16.364,8.597,0.019,2.618,2.468,5.398,7.958,90.010,30.042,6.432,6.357
 4227.909,131.012,1328.125,67.813,-100.204,16.033,8.611,0.020,2.628,2.560,4.823,7.702,84.486,26.139,6.034,6.122
 4228.409,130.962,1323.242,74.563,-98.271,15.776,8.645,0.026,2.640,2.687,4.104,7.145,85.587,26.916,5.713,5.962
 4228.909,131.030,1323.242,84.895,-95.506,16.299,8.712,0.039,2.633,2.861,4.527,6.288,93.363,32.412,5.607,6.003
 4229.409,130.900,1331.836,93.360,-94.401,18.854,8.810,0.061,2.602,3.018,6.312,5.510,99.551,36.785,5.610,6.128
 4229.909,131.041,1331.836,92.350,-93.205,23.293,9.142,0.074,2.563,3.225,8.614,5.662,100.437,37.411,5.716,6.239
 4230.409,131.062,1342.773,82.443,-92.200,27.454,9.212,0.063,2.546,3.449,9.571,6.919,94.851,33.464,5.799,6.300
 4230.909,131.037,1330.908,71.086,-91.180,28.415,8.848,0.037,2.564,3.497,8.549,8.501,89.119,29.413,5.863,6.248
 4231.409,131.026,1329.736,64.645,-89.691,25.223,8.720,0.012,2.590,3.473,7.014,9.376,87.047,27.948,6.046,6.426
 4231.909,131.081,1333.008,64.487,-89.079,20.450,8.715,0.001,2.605,3.342,6.116,9.123,84.365,26.053,6.470,6.911
 4232.409,131.002,1331.152,64.700,-90.843,17.411,8.704,-0.001,2.606,3.256,6.087,8.632,79.318,22.486,7.279,7.865
 4232.909,131.103,1328.125,62.497,-91.971,16.737,8.686,-0.002,2.612,3.301,5.748,9.954,72.058,17.356,8.501,9.292
 4233.409,130.949,1328.125,55.417,-94.173,16.617,8.669,-0.005,2.616,3.435,5.488,17.404,64.650,12.120,9.991,10.798
 4233.909,131.074,1328.125,43.904,-92.717,15.250,8.664,-0.007,2.628,3.715,4.782,31.400,59.589,8.543,11.696,12.466
 4234.409,131.176,1328.125,33.262,-91.469,12.126,8.664,-0.007,2.644,4.091,3.878,46.838,56.613,6.440,13.646,14.168
 4234.909,131.019,1337.891,25.664,-89.444,8.655,8.664,-0.006,2.657,4.288,3.112,56.562,54.129,4.685,16.164,16.137
 4235.409,131.104,1333.008,24.153,-89.104,6.367,8.665,-0.005,2.662,4.209,2.836,56.180,52.622,3.620,19.906,18.982
 4235.909,130.914,1332.764,25.373,-88.324,5.396,8.666,-0.006,2.655,4.068,3.229,51.411,51.832,3.061,24.264,21.876
 4236.409,131.003,1328.125,25.592,-87.425,5.409,8.670,-0.007,2.657,4.100,3.123,47.832,52.021,3.195,28.169,24.652
 4236.909,131.109,1337.891,24.676,-87.230,5.621,8.674,-0.006,2.662,4.241,2.800,46.408,52.380,3.449,29.991,26.011
 4237.409,131.130,1337.891,23.843,-87.878,5.730,8.678,-0.006,2.661,4.367,2.857,45.596,52.505,3.537,29.573,25.652
 4237.909,131.154,1344.727,24.103,-88.653,5.736,8.684,-0.006,2.660,4.369,2.904,43.860,52.605,3.608,28.688,24.685
 4238.409,130.993,1334.668,23.433,-88.897,5.728,8.690,-0.007,2.656,4.314,3.141,40.958,52.792,3.740,27.847,23.521
 4238.909,131.070,1336.963,23.180,-88.565,5.771,8.696,-0.007,2.656,4.264,3.142,37.729,53.113,3.966,27.323,22.837
 4239.409,131.068,1340.039,23.267,-88.225,5.827,8.701,-0.007,2.661,4.104,2.872,35.018,53.591,4.304,27.031,22.824
 4239.909,131.095,1342.773,22.841,-88.516,5.878,8.710,-0.008,2.657,3.982,3.115,33.365,54.154,4.703,26.977,23.200
 4240.409,131.014,1339.014,23.375,-88.842,5.995,8.719,-0.009,2.653,3.898,3.345,33.145,54.664,5.063,27.456,23.889
 4240.909,131.117,1342.773,23.027,-88.531,6.242,8.723,-0.010,2.654,3.850,3.265,34.721,54.883,5.218,28.176,23.898
 4241.409,131.185,1342.773,22.201,-87.664,6.493,8.729,-0.010,2.659,3.785,2.997,37.248,55.118,5.384,27.489,22.461
 4241.909,130.972,1341.113,22.022,-86.239,6.546,8.745,-0.009,2.667,3.671,2.507,38.066,56.073,6.058,24.522,19.527
 4242.409,131.118,1333.691,23.116,-85.331,6.430,8.768,-0.007,2.674,3.705,2.120,35.396,57.032,6.737,19.779,16.191
 4242.909,131.221,1337.891,28.394,-84.811,6.470,8.799,-0.004,2.675,3.857,2.035,28.605,58.328,7.652,15.453,13.493
 4243.409,131.200,1342.334,37.228,-84.171,7.017,8.843,0.002,2.668,3.871,2.481,20.322,60.938,9.497,12.304,11.694
 4243.909,131.140,1345.557,55.407,-82.941,8.715,8.912,0.016,2.643,3.572,3.916,13.522,66.309,13.292,10.262,10.494
 4244.409,131.195,1342.773,77.714,-81.815,11.954,9.232,0.037,2.594,3.075,6.776,9.302,74.355,18.979,8.913,9.601
 4244.909,131.200,1335.547,98.210,-80.893,16.751,9.353,0.080,2.543,2.717,9.768,8.130,82.315,24.604,7.974,8.810
 4245.409,130.974,1337.891,113.455,-80.729,21.582,9.146,0.137,2.516,2.570,11.364,8.393,87.147,28.019,7.296,8.117
 4245.909,131.159,1340.479,117.960,-80.989,24.837,9.105,0.168,2.505,2.554,11.965,8.973,87.761,28.453,6.909,7.727
 4246.409,131.249,1342.773,120.429,-81.257,26.187,9.104,0.162,2.504,2.499,12.028,9.285,86.424,27.508,6.795,7.586
 4246.909,131.152,1345.605,123.043,-81.180,25.753,9.104,0.117,2.509,2.491,11.780,9.473,85.107,26.577,7.043,7.798
 4247.409,131.230,1346.680,127.872,-80.973,25.012,9.112,0.071,2.523,2.551,10.939,10.081,85.016,26.513,7.594,8.263
 4247.909,131.249,1344.043,136.042,-81.488,24.374,9.167,0.051,2.555,2.598,9.040,11.847,85.369,26.763,8.432,8.972
 4248.409,131.091,1342.773,142.837,-82.382,24.139,9.159,0.041,2.569,2.632,8.230,14.616,85.838,27.094,9.491,9.966
 4248.909,131.255,1336.230,143.265,-83.668,24.518,9.119,0.045,2.568,2.637,8.314,17.618,86.434,27.515,10.705,11.186
 4249.409,131.264,1341.797,140.071,-84.118,24.974,9.122,0.065,2.566,2.631,8.422,19.961,87.054,27.953,12.140,12.638
 4249.909,131.051,1337.891,136.346,-83.789,25.377,9.101,0.083,2.564,2.577,8.563,21.899,87.549,28.304,13.783,14.190
 4250.409,131.257,1343.994,137.242,-83.358,25.802,9.134,0.083,2.555,2.488,9.092,24.378,87.889,28.543,15.395,15.447
 4250.909,131.207,1347.656,142.610,-82.766,26.120,9.238,0.066,2.539,2.449,10.003,26.604,88.036,28.647,16.716,16.304
 4251.409,131.232,1344.824,144.765,-82.333,26.399,9.253,0.058,2.545,2.482,9.625,26.788,87.860,28.523,17.407,16.472
 4251.909,131.076,1333.887,141.349,-81.707,26.390,9.243,0.070,2.580,2.513,7.585,24.512,87.469,28.247,17.620,16.192
 4252.409,131.196,1342.773,137.658,-81.603,25.971,9.250,0.079,2.606,2.539,6.086,21.277,87.143,28.016,17.597,15.734
 4252.909,131.358,1334.277,140.234,-81.564,25.522,9.225,0.072,2.602,2.585,6.332,19.172,87.020,27.929,17.152,14.964
 4253.409,131.235,1342.773,151.044,-82.326,25.422,9.245,0.055,2.578,2.648,7.700,18.871,87.178,28.041,16.450,14.104
 4253.909,131.220,1351.660,160.152,-83.012,26.187,9.214,0.036,2.552,2.723,9.211,18.912,87.439,28.226,15.212,13.047
 4254.409,131.278,1348.242,162.156,-83.414,27.646,9.165,0.023,2.545,2.679,9.630,17.984,87.600,28.339,13.645,11.799
 4254.909,131.189,1342.773,158.135,-83.302,28.673,9.175,0.015,2.548,2.613,9.466,15.862,87.605,28.343,12.023,10.620
 4255.409,131.289,1333.008,153.952,-82.963,28.714,9.191,0.015,2.558,2.576,8.869,13.123,87.476,28.252,10.501,9.433
 4255.909,131.364,1347.607,154.864,-82.795,28.236,9.202,0.025,2.578,2.573,7.720,10.897,87.296,28.124,9.215,8.471
 4256.409,131.234,1347.949,158.910,-83.100,27.676,9.202,0.046,2.605,2.665,6.120,9.297,86.956,27.884,8.263,7.761
 4256.909,131.476,1351.953,159.455,-83.838,26.961,9.202,0.071,2.634,2.753,4.446,8.001,86.329,27.441,7.519,7.207
 4257.409,131.330,1348.438,157.365,-84.472,25.901,9.201,0.077,2.636,2.837,4.340,7.256,85.393,26.779,7.002,6.802
 4257.909,131.278,1352.539,154.564,-85.253,25.197,9.201,0.066,2.630,2.906,4.699,7.228,84.318,26.020,6.583,6.422
 4258.409,131.317,1346.387,151.247,-85.645,25.576,9.201,0.043,2.620,2.901,5.276,7.750,83.371,25.350,6.242,6.121
 4258.909,131.363,1348.389,152.367,-85.815,26.286,9.201,0.027,2.619,2.848,5.347,8.093,82.771,24.926,6.009,5.949
 4259.409,131.425,1352.539,152.145,-84.932,26.291,9.202,0.024,2.624,2.746,5.057,7.884,82.506,24.739,5.897,5.942
 4259.909,131.337,1351.563,153.613,-83.874,25.305,9.202,0.023,2.621,2.700,5.210,7.465,82.413,24.673,5.935,6.088
 4260.409,131.416,1344.092,156.592,-82.828,24.065,9.202,0.025,2.626,2.740,4.889,7.311,82.280,24.579,6.077,6.311
 4260.909,131.355,1347.656,156.855,-82.752,23.472,9.232,0.027,2.631,2.817,4.611,7.698,82.162,24.496,6.250,6.497
 4261.409,131.243,1343.896,157.481,-83.938,23.650,9.263,0.025,2.624,2.924,5.026,8.579,82.599,24.805,6.363,6.573
 4261.909,131.409,1354.492,157.497,-84.869,24.251,9.194,0.020,2.604,3.056,6.183,9.466,84.201,25.937,6.382,6.525
 4262.409,131.457,1347.656,162.426,-85.537,24.817,9.109,0.017,2.590,3.126,7.035,9.757,86.468,27.539,6.325,6.432
 4262.909,131.263,1349.365,167.880,-84.835,25.149,9.097,0.019,2.597,3.041,6.621,9.171,88.397,28.903,6.238,6.347
 4263.409,131.424,1348.291,168.982,-84.755,25.100,9.095,0.023,2.617,2.925,5.454,8.149,89.098,29.398,6.144,6.291
 4263.909,131.328,1345.752,166.333,-84.926,24.785,9.088,0.022,2.629,2.858,4.722,7.390,88.820,29.201,6.015,6.222
 4264.409,131.319,1351.758,159.846,-85.563,24.135,9.077,0.018,2.629,2.849,4.761,7.144,88.832,29.210,5.888,6.147
 4264.909,131.465,1347.070,153.126,-86.164,23.604,9.067,0.016,2.626,2.910,4.901,7.243,89.492,29.676,5.790,6.111
 4265.409,131.534,1352.539,145.705,-87.090,23.718,9.058,0.018,2.639,2.990,4.170,7.427,89.859,29.936,5.802,6.158
 4265.909,131.482,1347.852,139.934,-88.287,24.264,9.047,0.020,2.661,3.182,2.845,7.699,89.064,29.374,5.962,6.347
 4266.409,131.590,1347.656,129.575,-89.179,24.350,9.032,0.018,2.681,3.460,1.711,8.432,88.760,29.159,6.271,6.619
 4266.909,131.477,1342.383,116.461,-88.739,22.685,9.017,0.012,2.684,3.662,1.527,9.941,90.199,30.176,6.725,6.993
 4267.409,131.327,1347.363,103.495,-88.791,20.081,9.007,0.007,2.678,3.717,1.864,11.543,92.724,31.960,7.246,7.412
 4267.909,131.585,1342.773,93.439,-88.131,17.983,9.001,0.007,2.673,3.528,2.189,12.615,94.493,33.211,7.819,7.911
 4268.409,131.258,1352.539,92.226,-87.470,17.133,8.996,0.006,2.667,3.305,2.496,12.945,94.801,33.428,8.377,8.444
 4268.909,131.423,1340.234,92.169,-87.369,17.368,8.995,0.003,2.663,3.147,2.720,12.916,95.686,34.053,8.866,8.898
 4269.409,131.483,1333.789,96.287,-87.934,17.904,8.994,0.001,2.665,3.002,2.660,12.930,99.368,36.656,9.228,9.241
 4269.909,131.540,1337.891,102.416,-89.061,18.173,8.994,0.003,2.672,2.880,2.218,12.880,105.238,40.804,9.382,9.382
 4270.409,131.419,1345.605,107.740,-89.240,17.964,8.994,0.008,2.685,2.802,1.479,12.686,110.878,44.790,9.408,9.420
 4270.909,131.473,1337.891,112.865,-88.911,17.545,8.994,0.012,2.698,2.774,0.710,12.344,114.020,47.010,9.379,9.415
 4271.409,131.530,1343.994,112.870,-88.350,17.323,8.994,0.011,2.702,2.754,0.489,12.068,114.600,47.421,9.385,9.401
 4271.909,131.549,1333.008,109.533,-88.483,17.516,8.994,0.006,2.694,2.716,0.935,12.112,114.619,47.434,9.440,9.437
 4272.409,131.555,1335.938,105.499,-88.980,17.962,8.995,0.001,2.675,2.670,2.029,12.520,114.402,47.281,9.531,9.494
 4272.909,131.557,1342.773,100.834,-89.921,18.023,8.998,0.000,2.661,2.619,2.870,13.163,114.077,47.051,9.643,9.590
 4273.409,131.501,1337.891,95.830,-90.593,17.395,9.000,0.007,2.668,2.604,2.435,13.670,113.812,46.863,9.779,9.733
 4273.909,131.568,1342.139,94.094,-90.667,16.579,9.001,0.015,2.690,2.644,1.194,13.921,113.677,46.768,9.961,9.909
 4274.409,131.546,1340.820,98.803,-90.016,16.111,9.001,0.016,2.701,2.707,0.503,14.032,113.645,46.745,10.151,10.125
 4274.909,131.435,1337.891,106.835,-88.983,16.098,9.001,0.012,2.695,2.774,0.904,14.060,113.645,46.745,10.335,10.327
 4275.409,131.512,1340.088,111.707,-88.803,16.231,9.005,0.005,2.674,2.824,2.109,14.077,113.735,46.809,10.430,10.461
 4275.909,131.593,1342.773,112.074,-88.761,16.327,9.010,0.002,2.656,2.815,3.179,14.146,113.892,46.920,10.474,10.516
 4276.409,131.558,1352.539,110.659,-89.199,16.503,9.017,0.004,2.647,2.780,3.672,14.168,114.101,47.068,10.430,10.467
 4276.909,131.480,1337.988,112.024,-89.349,16.496,9.024,0.008,2.643,2.743,3.923,14.081,114.427,47.298,10.354,10.368
 4277.409,131.484,1342.773,118.281,-89.781,16.296,9.027,0.012,2.650,2.735,3.536,13.800,114.808,47.568,10.254,10.266
 4277.909,131.654,1342.773,121.296,-90.171,16.418,9.028,0.016,2.659,2.783,3.006,13.437,115.201,47.845,10.130,10.167
 4278.409,131.590,1339.893,119.336,-90.523,16.906,9.028,0.015,2.656,2.830,3.144,13.180,115.599,48.127,10.030,10.126
 4278.909,131.548,1328.125,114.278,-90.237,17.309,9.028,0.013,2.651,2.862,3.439,12.960,115.940,48.367,9.932,10.087
 4279.409,131.561,1331.250,109.758,-90.720,17.392,9.028,0.013,2.653,2.858,3.354,12.794,116.071,48.460,9.891,10.069
 4279.909,131.606,1341.992,112.889,-90.250,17.418,9.028,0.013,2.655,2.801,3.200,12.827,116.049,48.445,9.868,10.032
 4280.409,131.498,1337.891,118.661,-89.612,17.918,9.032,0.011,2.655,2.747,3.200,13.070,115.897,48.337,9.832,9.962
 4280.909,131.406,1340.723,123.636,-88.642,18.519,9.040,0.005,2.644,2.684,3.834,13.352,115.449,48.020,9.834,9.945
 4281.409,131.587,1329.443,123.959,-87.974,18.549,9.048,0.001,2.633,2.602,4.481,13.531,112.725,46.096,9.819,9.974
 4281.909,131.581,1333.008,119.387,-87.420,18.133,9.054,0.003,2.635,2.552,4.399,13.527,108.044,42.787,9.916,10.079
 4282.409,131.645,1329.199,113.688,-86.851,17.791,9.057,0.007,2.643,2.571,3.903,13.466,105.655,41.099,10.017,10.230
 4282.909,131.625,1349.512,108.730,-86.519,17.974,9.057,0.011,2.654,2.625,3.277,13.498,107.580,42.460,10.154,10.294
 4283.409,131.548,1342.773,108.267,-85.904,18.344,9.057,0.010,2.657,2.680,3.086,13.682,112.112,45.662,10.258,10.385
 4283.909,131.640,1337.646,112.788,-85.280,18.231,9.058,0.005,2.651,2.719,3.432,14.021,114.679,47.477,10.331,10.393
 4284.409,131.733,1332.422,116.220,-85.534,17.605,9.060,0.003,2.643,2.702,3.908,14.288,112.213,45.733,10.364,10.442
 4284.909,131.638,1338.867,116.403,-86.065,16.843,9.060,0.007,2.644,2.692,3.842,14.288,107.233,42.214,10.430,10.514
 4285.409,131.766,1338.574,116.148,-87.442,16.324,9.060,0.014,2.656,2.720,3.139,14.107,104.793,40.490,10.510,10.591
 4285.909,131.679,1340.088,118.458,-88.106,16.444,9.060,0.019,2.666,2.793,2.552,14.000,107.142,42.150,10.635,10.700
 4286.409,131.603,1342.773,122.838,-88.516,17.005,9.060,0.017,2.660,2.859,2.906,14.136,111.897,45.510,10.727,10.749
 4286.909,131.601,1337.891,121.440,-88.175,17.394,9.060,0.012,2.646,2.825,3.721,14.512,114.806,47.566,10.752,10.744
 4287.409,131.816,1342.773,120.024,-87.488,17.435,9.060,0.010,2.639,2.759,4.147,14.863,115.230,47.865,10.758,10.718
 4287.909,131.615,1340.088,120.580,-87.323,17.025,9.064,0.012,2.644,2.694,3.888,14.902,115.004,47.706,10.716,10.665
 4288.409,131.733,1333.350,119.960,-87.479,16.404,9.076,0.016,2.649,2.667,3.566,14.663,114.972,47.684,10.707,10.655
 4288.909,131.732,1337.891,118.633,-87.221,16.180,9.095,0.017,2.648,2.678,3.612,14.245,115.181,47.831,10.703,10.657
 4289.409,131.699,1329.883,117.684,-86.744,16.399,9.110,0.017,2.647,2.716,3.692,13.887,115.425,48.004,10.681,10.653
 4289.909,131.737,1336.523,119.908,-86.422,16.925,9.121,0.017,2.648,2.759,3.643,13.767,113.267,46.478,10.658,10.626
 4290.409,131.802,1333.008,122.036,-87.446,17.492,9.132,0.013,2.646,2.760,3.750,13.846,108.323,42.984,10.578,10.545
 4290.909,131.711,1336.377,120.541,-87.687,17.849,9.144,0.009,2.642,2.726,3.979,13.990,102.827,39.101,10.508,10.438
 4291.409,131.704,1344.824,121.221,-87.080,18.063,9.160,0.008,2.639,2.664,4.175,14.013,99.024,36.413,10.439,10.352
 4291.909,131.723,1352.539,125.949,-85.767,18.259,9.176,0.007,2.631,2.586,4.606,13.910,98.032,35.712,10.377,10.268
 4292.409,131.707,1328.125,129.791,-85.047,18.501,9.189,0.006,2.629,2.538,4.728,13.766,97.825,35.565,10.340,10.238
 4292.909,131.779,1339.697,130.764,-85.410,18.788,9.198,0.005,2.634,2.570,4.427,13.645,95.448,33.885,10.310,10.209
 4293.409,131.699,1341.260,127.986,-86.405,19.096,9.208,0.007,2.646,2.612,3.767,13.541,90.964,30.717,10.289,10.192
 4293.909,131.707,1337.891,124.232,-87.100,19.220,9.215,0.011,2.655,2.611,3.204,13.455,86.216,27.361,10.294,10.186
 4294.409,131.778,1342.773,118.170,-87.319,19.086,9.217,0.011,2.650,2.595,3.520,13.561,82.845,24.979,10.289,10.148
 4294.909,131.720,1338.477,110.178,-86.865,18.930,9.217,0.008,2.639,2.576,4.163,13.872,81.545,24.060,10.320,10.113
 4295.409,131.698,1335.010,105.147,-86.861,18.905,9.221,0.006,2.634,2.542,4.422,14.126,80.832,23.556,10.358,10.075
 4295.909,131.742,1337.891,105.446,-87.378,18.966,9.237,0.008,2.636,2.508,4.333,14.208,80.445,23.283,10.419,10.040
 4296.409,131.800,1340.088,109.770,-88.180,19.199,9.261,0.010,2.638,2.479,4.218,14.158,80.512,23.330,10.444,10.036
 4296.909,131.856,1337.988,113.690,-88.287,19.633,9.284,0.010,2.637,2.456,4.296,14.130,80.670,23.441,10.396,10.031
 4297.409,131.806,1342.773,116.842,-88.117,20.226,9.305,0.008,2.631,2.477,4.632,14.158,80.829,23.554,10.345,10.120
 4297.909,131.689,1337.744,119.751,-87.632,20.647,9.322,0.006,2.625,2.478,4.967,14.017,80.692,23.457,10.294,10.278
 4298.409,131.772,1335.693,123.304,-86.871,20.583,9.332,0.005,2.625,2.523,4.962,13.664,79.829,22.847,10.387,10.357
 4298.909,131.854,1338.232,123.795,-86.317,20.326,9.336,0.006,2.629,2.620,4.712,13.305,78.785,22.109,10.462,10.230
 4299.409,131.796,1339.844,122.892,-86.030,20.011,9.337,0.007,2.638,2.647,4.215,13.179,77.859,21.455,10.019,9.413
 4299.909,131.809,1337.891,119.588,-85.540,19.653,9.337,0.009,2.647,2.588,3.684,13.264,77.688,21.334,9.142,8.286
 4300.409,131.833,1328.369,118.497,-85.951,19.088,9.337,0.012,2.653,2.528,3.309,12.989,81.073,23.727,7.816,7.157
 4300.909,131.688,1337.891,122.183,-86.511,18.413,9.344,0.013,2.656,2.552,3.144,11.697,87.374,28.180,6.749,6.397
 4301.409,131.780,1337.891,128.024,-87.541,18.179,9.356,0.013,2.644,2.797,3.870,9.259,93.096,32.223,5.988,6.046
 4301.909,131.750,1338.965,139.993,-87.714,18.843,9.391,0.023,2.614,3.117,5.589,6.981,95.692,34.058,5.552,5.871
 4302.409,131.811,1335.547,156.067,-86.625,20.681,9.505,0.055,2.584,3.185,7.366,6.149,94.780,33.413,5.326,5.798
 4302.909,131.830,1337.891,171.867,-85.417,23.626,9.590,0.088,2.550,3.042,9.351,6.670,93.578,32.564,5.214,5.674
 4303.409,131.976,1341.748,180.099,-84.361,26.745,9.632,0.104,2.517,2.739,11.273,7.674,94.452,33.182,5.243,5.663
 4303.909,131.854,1334.521,182.065,-84.412,29.092,9.811,0.096,2.495,2.554,12.545,8.437,97.636,35.432,5.424,5.820
 4304.409,131.761,1337.891,183.246,-84.390,30.622,9.908,0.074,2.487,2.563,13.040,9.278,101.433,38.115,5.812,6.140
 4304.909,131.739,1344.141,184.160,-84.421,31.350,9.728,0.056,2.498,2.540,12.412,10.612,103.316,39.446,6.385,6.624
 4305.409,131.722,1337.891,184.597,-83.955,31.593,9.566,0.040,2.511,2.514,11.635,12.086,101.735,38.329,7.055,7.088
 4305.909,131.856,1342.773,187.703,-83.315,31.335,9.558,0.031,2.522,2.526,10.997,13.011,97.516,35.347,7.631,7.586
 4306.409,131.851,1342.773,196.899,-82.652,30.583,9.568,0.035,2.531,2.575,10.456,13.174,94.023,32.879,8.080,8.032
 4306.909,131.951,1345.410,214.260,-82.243,30.279,9.584,0.055,2.541,2.625,9.909,12.590,92.489,31.795,8.295,8.374
 4307.409,131.881,1342.773,228.350,-82.476,31.259,9.660,0.076,2.545,2.579,9.653,11.840,92.129,31.540,8.472,8.639
 4307.909,131.912,1345.166,228.364,-82.174,33.275,9.710,0.081,2.537,2.527,10.112,11.374,92.327,31.680,8.545,8.757
 4308.409,131.888,1337.891,226.355,-81.725,34.628,9.648,0.074,2.529,2.535,10.562,11.410,92.548,31.836,8.544,8.793
 4308.909,131.881,1337.891,227.867,-81.417,34.453,9.597,0.057,2.519,2.594,11.162,12.020,92.539,31.830,8.499,8.709
 4309.409,131.805,1338.281,232.849,-81.939,33.260,9.663,0.047,2.521,2.646,11.051,12.680,92.357,31.701,8.449,8.575
 4309.909,131.959,1342.773,235.259,-82.502,31.809,9.734,0.041,2.529,2.627,10.593,13.095,92.054,31.487,8.438,8.454
 4310.409,131.811,1351.904,237.567,-82.059,30.392,9.667,0.036,2.530,2.606,10.535,13.220,91.828,31.327,8.488,8.459
 4310.909,131.919,1344.482,241.420,-81.896,29.063,9.635,0.046,2.532,2.591,10.401,12.959,91.563,31.140,8.602,8.572
 4311.409,131.925,1323.242,241.674,-81.880,28.593,9.718,0.073,2.538,2.587,10.064,12.335,90.891,30.665,8.780,8.784
 4311.909,131.843,1330.078,229.309,-82.281,28.743,9.872,0.101,2.546,2.603,9.616,11.518,89.798,29.893,8.992,8.995
 4312.409,131.886,1341.699,211.923,-82.453,28.444,9.939,0.109,2.547,2.622,9.540,11.101,88.969,29.307,9.108,9.064
 4312.909,131.835,1337.891,208.600,-82.370,27.955,9.872,0.091,2.541,2.598,9.887,11.355,89.263,29.514,8.993,8.863
 4313.409,131.878,1349.902,220.571,-82.085,28.919,9.786,0.064,2.530,2.527,10.549,11.844,90.757,30.570,8.639,8.450
 4313.909,131.951,1342.773,245.053,-81.972,31.760,9.740,0.044,2.528,2.467,10.671,11.926,92.523,31.818,8.136,7.979
 4314.409,131.905,1342.773,266.288,-82.018,34.300,9.722,0.032,2.523,2.453,10.931,11.204,93.598,32.578,7.688,7.627
 4314.909,131.843,1342.773,268.933,-82.519,34.567,9.714,0.025,2.516,2.500,11.349,9.964,93.840,32.749,7.384,7.474
 4315.409,131.889,1342.773,249.293,-82.419,32.880,9.662,0.025,2.512,2.570,11.551,8.828,93.573,32.560,7.248,7.479
 4315.909,131.877,1347.119,228.972,-82.094,31.289,9.608,0.024,2.509,2.625,11.772,8.395,93.273,32.348,7.238,7.579
 4316.409,131.815,1348.535,228.691,-82.209,31.133,9.483,0.020,2.511,2.663,11.621,9.076,93.087,32.217,7.320,7.684
 4316.909,131.879,1338.184,252.980,-82.961,31.744,9.324,0.013,2.508,2.662,11.827,10.459,93.067,32.203,7.470,7.790
 4317.409,131.929,1335.645,287.130,-83.812,32.183,9.289,0.010,2.505,2.652,11.968,11.820,93.953,32.829,7.759,8.018
 4317.909,131.898,1342.676,317.236,-83.861,32.343,9.227,0.008,2.500,2.652,12.305,12.794,95.586,33.983,8.197,8.415
 4318.409,131.877,1342.773,334.889,-83.181,32.653,9.172,0.008,2.509,2.771,11.777,13.622,97.120,35.067,8.864,9.104
 4318.909,132.035,1347.656,333.185,-83.235,32.906,9.142,0.008,2.528,2.898,10.639,14.741,98.727,36.203,9.651,9.929
 4319.409,131.918,1344.922,315.468,-83.764,32.205,9.111,0.010,2.539,2.957,10.004,16.284,99.770,36.940,10.513,10.807
 4319.909,131.937,1342.383,289.477,-85.468,30.858,9.095,0.028,2.554,3.010,9.105,17.817,99.447,36.711,11.369,11.646
 4320.409,131.970,1340.869,259.054,-86.695,29.622,9.036,0.055,2.574,3.013,7.979,19.023,98.789,36.247,12.161,12.352
 4320.909,131.994,1339.160,235.697,-87.234,29.147,9.036,0.067,2.590,3.020,7.006,20.165,100.045,37.134,12.996,13.035
 4321.409,131.842,1347.656,227.225,-87.100,29.737,9.157,0.057,2.604,2.978,6.194,21.502,104.620,40.368,13.793,13.569
 4321.909,131.910,1346.777,230.487,-86.137,30.700,9.027,0.030,2.595,2.900,6.721,23.001,112.087,45.644,14.566,13.987
 4322.409,131.828,1339.355,239.468,-85.894,31.024,8.813,0.010,2.578,2.850,7.694,24.279,117.990,49.816,15.218,14.389
 4322.909,131.893,1337.891,243.311,-86.163,30.122,8.767,0.006,2.568,2.795,8.282,24.929,119.343,50.772,15.766,14.746
 4323.409,131.985,1337.891,247.540,-87.495,28.423,8.739,0.007,2.561,2.787,8.735,24.915,117.661,49.584,16.315,15.240
 4323.909,131.901,1341.846,257.397,-89.422,27.110,8.725,0.014,2.565,2.816,8.499,24.717,116.679,48.890,16.875,15.636
 4324.409,131.896,1352.539,265.814,-91.254,26.867,8.722,0.021,2.572,2.887,8.069,24.897,118.561,50.220,17.305,15.765
 4324.909,132.011,1347.656,275.260,-92.848,27.374,8.722,0.025,2.579,3.002,7.652,25.475,120.722,51.747,17.307,15.388
 4325.409,131.950,1339.355,282.512,-94.040,28.163,8.713,0.024,2.587,3.155,7.201,25.904,119.912,51.175,16.493,14.282
 4325.909,131.949,1337.891,289.425,-94.851,29.248,8.671,0.017,2.583,3.249,7.438,25.178,116.485,48.753,15.133,13.037
 4326.409,132.070,1333.545,291.804,-95.976,30.287,8.616,0.008,2.570,3.264,8.175,22.825,115.501,48.058,13.659,11.957
 4326.909,131.918,1348.926,287.906,-97.990,30.452,8.572,0.009,2.567,3.240,8.389,18.949,118.322,50.051,12.416,11.268
 4327.409,131.974,1357.422,280.796,-100.943,29.734,8.548,0.015,2.575,3.184,7.886,14.908,121.729,52.459,11.744,10.958
 4327.909,132.037,1347.949,261.425,-104.853,28.431,8.510,0.022,2.599,3.156,6.514,12.544,121.606,52.372,11.357,10.675
 4328.409,131.918,1342.773,222.878,-109.804,26.729,8.447,0.025,2.617,3.017,5.428,14.243,116.510,48.770,11.272,10.397
 4328.909,131.959,1347.656,160.631,-116.017,23.565,8.348,0.025,2.599,2.649,6.486,20.202,106.734,41.862,11.160,10.000
 4329.409,131.965,1352.148,97.697,-122.589,18.692,8.246,0.030,2.550,2.232,9.361,25.354,97.821,35.563,11.091,9.578
 4329.909,131.961,1345.508,55.084,-128.873,13.644,8.213,0.045,2.485,1.925,13.145,26.329,94.048,32.896,11.191,9.401
 4330.409,131.870,1347.217,36.361,-134.302,10.691,8.211,0.061,2.441,1.806,15.705,23.978,95.365,33.827,11.480,9.384
 4330.909,132.104,1342.773,32.994,-137.856,10.656,8.211,0.071,2.436,1.840,16.020,21.942,101.909,38.452,11.852,9.559
 4331.409,131.890,1337.891,32.605,-140.331,11.626,8.211,0.075,2.450,1.852,15.211,21.751,109.015,43.474,12.194,9.756
 4331.909,132.040,1337.891,30.862,-142.548,12.194,8.210,0.071,2.462,1.879,14.485,21.894,114.110,47.075,12.209,9.840
 4332.409,132.014,1350.781,28.788,-145.575,12.099,8.210,0.065,2.464,1.911,14.386,22.099,116.213,48.561,12.037,9.877
 4332.909,131.945,1339.307,28.817,-148.548,11.747,8.212,0.055,2.461,1.907,14.543,23.127,114.203,47.140,11.818,9.858
 4333.409,131.970,1342.773,31.581,-150.614,11.281,8.243,0.043,2.463,1.903,14.437,24.815,109.789,44.021,11.715,9.876
 4333.909,132.085,1346.436,32.800,-151.623,10.772,8.321,0.033,2.473,1.941,13.861,26.183,107.075,42.102,11.828,9.990
 4334.409,131.962,1347.656,33.219,-151.661,10.461,8.381,0.027,2.478,1.995,13.543,26.845,108.777,43.306,11.958,10.186
 4334.909,131.934,1347.656,33.098,-151.830,10.316,8.393,0.025,2.482,1.999,13.344,27.334,115.892,48.334,12.051,10.366
 4335.409,132.087,1347.656,32.541,-152.411,10.161,8.394,0.027,2.486,1.967,13.115,27.643,127.089,56.247,11.990,10.459
 4335.909,132.029,1347.656,33.209,-153.206,9.777,8.395,0.029,2.490,1.952,12.883,26.827,134.490,61.477,11.788,10.347
 4336.409,131.910,1342.773,31.801,-153.609,9.346,8.395,0.036,2.504,1.977,12.019,24.394,134.172,61.252,11.492,10.169
 4336.909,132.080,1347.168,28.846,-153.584,9.318,8.393,0.042,2.517,2.008,11.288,21.171,127.238,56.352,11.072,9.823
 4337.409,131.975,1335.059,28.043,-153.586,9.724,8.389,0.044,2.521,2.055,11.055,18.635,118.882,50.447,10.506,9.440
 4337.909,131.955,1337.891,29.199,-153.357,10.238,8.388,0.046,2.521,2.117,11.048,17.101,116.613,48.843,9.933,9.048
 4338.409,132.071,1342.480,29.393,-152.937,10.483,8.388,0.045,2.521,2.165,11.029,15.921,121.218,52.097,9.439,8.797
 4338.909,132.101,1342.822,28.941,-151.875,10.372,8.393,0.045,2.528,2.161,10.651,14.872,125.461,55.096,9.162,8.734
 4339.409,131.966,1347.656,26.789,-151.403,10.148,8.415,0.043,2.535,2.107,10.219,14.481,123.631,53.803,9.178,8.881
 4339.909,132.041,1347.461,24.433,-151.686,9.918,8.459,0.041,2.542,2.051,9.821,15.355,117.142,49.217,9.440,9.185
 4340.409,131.982,1345.557,23.205,-151.918,9.534,8.488,0.040,2.546,1.986,9.569,18.464,111.429,45.179,9.967,9.645
 4340.909,131.912,1347.656,21.277,-153.161,8.903,8.486,0.035,2.540,1.893,9.935,22.877,111.746,45.404,10.654,10.221
 4341.409,132.062,1347.656,20.004,-152.150,8.114,8.465,0.031,2.531,1.798,10.477,27.753,115.203,47.846,11.517,10.917
 4341.909,131.944,1344.141,19.238,-151.023,7.471,8.445,0.031,2.530,1.738,10.550,31.969,116.449,48.727,12.499,11.687
 4342.409,132.055,1352.539,18.035,-148.873,6.999,8.434,0.037,2.535,1.722,10.213,33.752,113.172,46.411,13.510,12.412
 4342.909,132.009,1350.439,18.226,-148.418,6.570,8.424,0.046,2.547,1.725,9.503,32.842,108.328,42.988,14.373,12.996
 4343.409,131.916,1362.305,19.092,-149.028,6.317,8.421,0.050,2.550,1.740,9.333,29.992,105.848,41.236,14.812,13.309
 4343.909,132.113,1347.656,19.097,-148.740,6.456,8.422,0.046,2.543,1.765,9.772,26.831,104.282,40.129,14.804,13.342
 4344.409,132.019,1343.945,19.488,-147.578,6.912,8.430,0.040,2.529,1.788,10.565,24.308,101.640,38.262,14.475,13.183
 4344.909,132.063,1345.508,20.316,-145.759,7.361,8.428,0.037,2.514,1.788,11.488,22.592,98.996,36.393,14.118,12.929
 4345.409,131.966,1352.539,21.748,-144.305,7.652,8.408,0.043,2.509,1.768,11.783,21.695,98.786,36.244,13.891,12.674
 4345.909,132.073,1352.539,22.737,-142.791,7.803,8.395,0.051,2.514,1.760,11.477,21.620,100.606,37.531,13.775,12.386
 4346.409,132.065,1344.238,22.618,-141.019,7.706,8.392,0.053,2.522,1.734,11.016,22.434,102.288,38.719,13.603,12.008
 4346.909,132.103,1342.773,21.447,-139.640,7.069,8.408,0.045,2.531,1.688,10.476,23.928,103.076,39.277,13.233,11.507
 4347.409,132.090,1347.168,18.281,-138.682,5.939,8.467,0.036,2.542,1.639,9.840,24.884,102.174,38.639,12.704,10.959
 4347.909,132.097,1355.322,15.578,-138.689,4.725,8.536,0.032,2.545,1.596,9.665,23.883,99.222,36.552,12.173,10.546
 4348.409,131.964,1347.900,14.588,-138.407,3.955,8.545,0.036,2.547,1.587,9.535,20.866,95.417,33.863,11.731,10.293
 4348.909,132.074,1349.951,15.649,-137.100,3.885,8.491,0.043,2.554,1.621,9.106,17.129,91.684,31.225,11.462,10.184
 4349.409,131.910,1352.539,18.365,-134.511,4.230,8.434,0.048,2.573,1.694,7.983,14.634,88.253,28.801,11.288,10.097
 4349.909,132.175,1347.656,23.228,-131.332,4.584,8.416,0.046,2.598,1.823,6.543,13.786,86.869,27.823,11.257,9.970
 4350.409,131.985,1338.135,28.612,-130.195,4.760,8.409,0.039,2.608,1.935,5.938,13.433,87.372,28.178,11.302,9.836
 4350.909,132.055,1348.340,31.243,-131.903,4.878,8.370,0.029,2.595,1.928,6.715,14.500,89.537,29.708,11.451,9.660
 4351.409,132.024,1357.422,29.018,-135.656,4.997,8.303,0.022,2.570,1.824,8.160,17.866,90.036,30.061,11.631,9.459
 4351.909,131.987,1360.449,23.544,-140.226,4.912,8.175,0.025,2.549,1.673,9.426,21.856,85.124,26.589,11.750,9.190
 4352.409,132.046,1344.141,18.598,-144.296,4.569,8.058,0.038,2.532,1.567,10.394,23.333,80.186,23.100,11.821,8.940
 4352.909,132.039,1355.811,15.674,-148.357,4.221,8.023,0.058,2.519,1.520,11.175,21.020,79.655,22.724,11.822,8.747
 4353.409,131.954,1356.494,16.139,-151.624,4.325,8.013,0.074,2.503,1.513,12.119,17.786,82.315,24.604,11.762,8.542
 4353.909,132.139,1349.072,17.138,-154.122,4.901,8.010,0.081,2.493,1.554,12.680,17.404,87.507,28.273,11.603,8.304
 4354.409,132.120,1352.539,17.585,-155.432,5.368,8.008,0.083,2.498,1.594,12.404,20.101,92.349,31.696,11.309,7.992
 4354.909,132.061,1352.539,16.648,-156.418,5.363,8.008,0.081,2.507,1.602,11.872,22.401,96.432,34.581,10.915,7.683
 4355.409,132.129,1348.291,13.684,-157.319,4.971,8.012,0.076,2.507,1.575,11.856,21.947,100.299,37.314,10.585,7.451
 4355.909,132.081,1349.756,11.527,-158.299,4.631,8.037,0.067,2.497,1.529,12.441,20.064,101.439,38.119,10.316,7.250
 4356.409,132.074,1352.539,11.085,-159.670,4.685,8.070,0.054,2.483,1.497,13.250,20.576,99.389,36.670,10.211,7.102
 4356.909,132.050,1360.938,11.339,-160.580,4.869,8.097,0.043,2.478,1.482,13.578,24.016,96.358,34.529,10.105,6.942
 4357.409,132.147,1347.656,11.841,-161.332,4.780,8.119,0.037,2.480,1.480,13.464,26.583,95.322,33.797,9.915,6.752
 4357.909,132.116,1347.656,11.710,-162.084,4.412,8.125,0.035,2.482,1.483,13.305,26.674,98.297,35.899,9.607,6.528
 4358.409,132.