~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                                   VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                     2342.0  : START DEPTH                    {F}
 STOP  .F                                     3161.0  : END DEPTH                      {F}
 STEP  .F                                        0.5  : STEP LENGTH                    {F}
 NULL  .                                     -999.25  : NULL VALUE                     {F}
 COMP  .          Pioneer Natural Resources USA Inc.  : Company                        {S}
 WELL  .                                 Newby 2-28R  : Well Name                      {S}
 FLD   .                             PANOMA GAS AREA  : Field                          {S}
 SEC   .                                          28  : Section                        {I}
 TOWN  .                                         31S  : Township (e.g. 42S)            {S}
 RANG  .                                         37E  : Range  (e.g. 25E)              {S}
 LOC   .                                  28-31S-37W  : Location (Sec Town Range)      {S}
 LOC1  .                                 SW NE SW SW  : Location 1 (quarter calls)     {S}
 LOC2  .           680 FSL, 4600 FEL, from SE corner  : Location 2 (footages)          {S}
 COUN  .                                     STEVENS  : County                         {S}
 STAT  .                                      Kansas  : State                          {S}
 CTRY  .                                         USA  : Country                        {S}
 PROV  .                                              : Province                       {S}
 SRVC  .                                 HALLIBURTON  : Service Company                {S}
 LIC   .                                              : License Number                 {S}
 DATE  .                                  13/06/2008  : Completion Date                {DD/MM/YYYY}
 API   .                                15-189-22225  : API-Number                     {S}
 UWI   .                              15189222250000  : Unique Well ID Number          {S}
 LATI  .DEG                                37.317145  : Latitude                       {F}
 LONG  .DEG                              -101.354533  : Longitude                      {F}
 GDAT  .                                       NAD27  : Geodetic Datum                 {S}
 X     .                                   291354.97  : X or East-West coordinate      {F}
 Y     .                                   4132451.5  : Y or North South coordinate    {F}
 HZCS  .                                         UTM  : Horizontal Co-ordinate System  {S}
 UTM   .                                        14.0  : UTM Location                   {F}
 STUS  .                                         GAS  : Well Status                    {S}

~Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                  GL  : Permanent Data                 {S}
 APD   .F               15.0  : Above Permanent Data           {F}
 DREF  .                  KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F             3119.0  : Elevation of Depth Reference   {F}
 RUN   .                   1  : Run Number                     {F}
 TDL   .F             3155.0  : Total Depth Logger             {F}
 TDD   .F             3150.0  : Total Depth Driller            {F}
 CSGL  .F            640.000  : Casing Bottom Logger           {F}
 CSGD  .F            639.000  : Casing Bottom Driller          {F}
 CSGS  .IN             8.625  : Casing Size                    {F}
 CSGW  .LB                    : Casing Weight                  {F}
 BS    .IN             7.875  : Bit Size                       {F}
 MUD   .            CHEMICAL  : Mud type                       {S}
 MUDS  .                      : Mud Source                     {S}
 MUDD  .GM/CC          8.900  : Mud Density                    {F}
 MUDV  .CC            40.000  : Mud Viscosity (Funnel)         {F}
 FL    .LB/S           6.400  : Fluid Loss                     {F}
 PH    .              11.000  : PH                             {F}
 RM    .OHM-M          0.750  : Resistivity of Mud             {F}
 RMT   .DEG-F         71.000  : Temperature of Mud             {F}
 RMF   .OHM-M          0.660  : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEG-F         74.000  : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M          1.100  : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F         74.000  : Temperature of Mud Cake        {F}
 TMAX  .DEG-F        101.000  : Maximum Recorded Temp.         {F}
 TIMC  .DATE                  : Date/Time Circulation Stopped  {S}
 TIML  .DATE       9/30/1997  : Date/Time Logger Tagged Bottom {M/DD/YYYY}
 UNIT  .               51781  : Logging Unit Number            {S}
 BASE  .               1 L18  : Home Base of Logging Unit      {S}
 ENG   .          MONTGOMERY  : Recording Engineer             {S}
 WIT   .             USELTON  : Witnessed By                   {S}

~Curve
#MNEM   .UNIT             VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT    .F         00 000 00 00  : Depth (MD)                     
 DPHI    .          00 001 00 00  :                                
 DRHO    .          00 002 00 00  :                                
 DT      .          00 003 00 00  :                                
 GR      .GAPI      00 004 00 00  : 9 GAMMA RAY                    
 ILD     .OHMM      00 005 00 00  : INDUCTION DEEP RESISTIVITY     
 ILM     .OHMM      00 006 00 00  : INDUCTION MEDIUM RESISTIVITY   
 ITT     .          00 007 00 00  :                                
 MBVI    .DEC       00 008 00 00  : bound water from mril          
 MCBWD   .          00 009 00 00  : Curve #  49                    
 MFFI    .DEC       00 010 00 00  : free fluid from mril           
 MINV    .          00 011 00 00  :                                
 MNOR    .          00 012 00 00  :                                
 MPERM   .MD        00 013 00 00  : Curve #   4                    
 MPERM16 .          00 014 00 00  : Curve #  51                    
 MPHI    .DEC       00 015 00 00  : eff. phi from mril             
 NPHI    .          00 016 00 00  :                                
 PE      .          00 017 00 00  : 14 PHOTOELECTRIC FACTOR        
 PMRI    .MD        00 018 00 00  : Curve #  46                    
 RHOB    .          00 019 00 00  :                                
 SGRD    .OHMM      00 020 00 00  : SHALLOW RESISTIVITY            
 SP      .MV        00 021 00 00  : 8 SPON. POTENTIAL              

~Core_Parameter
#MNEM .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 C_SRS .          Kansas Geological Survey Database  : Core Source                    {S}
 C_TY  .                                  Core Plug  : Core Type                      {S}
 C_DT  .                                             : Recovery Date (Date Core Cut)  {D/M/YYY}
 C_TP  .F                                    2810.0  : Core Top Depth                 {F}
 C_BS  .F                                    3057.0  : Core Base Depth                {F}
 C_RC  .F                                     247.0  : Recovered Amount (Length)      {F}
 C_FM  .                        COUNCIL GROVE GROUP  : Primary Formation Cored        {S}
 C_DI  .IN                                      2.0  : Core Diameter                  {F}
 C_AC  .                                    Pioneer  : Analyzing Company              {S}
 C_AD  .                                 06/07/2006  : Analysis Date                  {DD/MM/YYYY}

~Core_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOP   .F                     : Depth Top                      {F}
 CORR  .F                     : Depth Correction               {F}
 STU   .                      : Stratigraphic Unit             {S}
 STN   .                      : Stratigraphic Name             {S}
 ENV   .                      : Depositional Environment       {S}
 LITHO .                      : Lithofacies                    {S}
 PPLUG .PU                    : Core Plug Porosity Routine     {F}
 PINSI .PU                    : Core Plug Porosity Insitu      {F}
 KPLG  .MD                    : Core Plug Permeability Routine {F}
 GMCC  .GMCC                  : Grain Density (gm/cc)          {F}
 MAMB  .FRAC                  : Archie Cementation Ambient     {F}
 MINSI .FRAC                  : Archie Cementation Insitu      {F}
 NINSI .FRAC                  : Archie Saturation Insitu       {F}
 LTHCD .LU                    : Lithofacies Code               {I}

~Core_Data | Core_Definition 
 2810.0,6.0,"CHASE GROUP","WREFORD","Shoal","M-CG Pkst-Grnst",9.4,-999.95,0.39,2.73,-999.95,-999.95,-999.95,7.0
 2811.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",5.2,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 2812.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",10.7,-999.95,0.09,2.69,-999.95,-999.95,-999.95,5.0
 2813.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",9.2,-999.95,0.09,2.7,-999.95,-999.95,-999.95,5.0
 2814.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",10.5,-999.95,0.18,2.68,-999.95,-999.95,-999.95,5.0
 2815.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",13.5,-999.95,0.73,2.63,-999.95,-999.95,-999.95,5.0
 2816.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",14.5,-999.95,0.24,2.69,-999.95,-999.95,-999.95,5.0
 2817.0,6.0,"CHASE GROUP","WREFORD","Shoal","M-CG Packstone",11.9,-999.95,0.19,2.71,-999.95,-999.95,-999.95,7.0
 2818.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",9.2,-999.95,0.08,2.71,-999.95,-999.95,-999.95,5.0
 2819.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",6.6,-999.95,0.03,2.7,-999.95,-999.95,-999.95,5.0
 2820.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",6.2,-999.95,0.02,2.71,-999.95,-999.95,-999.95,5.0
 2821.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",5.9,-999.95,0.02,2.72,-999.95,-999.95,-999.95,5.0
 2822.0,6.0,"CHASE GROUP","WREFORD","Mid Shelf (Carb Dom)","Silty Wackestone",6.9,-999.95,0.03,2.71,-999.95,-999.95,-999.95,5.0
 2823.0,6.0,"CHASE GROUP","WREFORD","Shoal (transgressive)","M-CG Pkst-Grnst",8.7,-999.95,0.1,2.72,-999.95,-999.95,-999.95,7.0
 2824.0,6.0,"CHASE GROUP","WREFORD","Shoal (transgressive)","M-CG Packstone",7.1,-999.95,0.05,2.71,-999.95,-999.95,-999.95,7.0
 2825.0,6.0,"CHASE GROUP","WREFORD","Shoal (transgressive)","M-CG Pkst-Grnst",6.4,-999.95,0.03,2.71,-999.95,-999.95,-999.95,7.0
 2826.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",8.9,-999.95,0.29,2.77,-999.95,-999.95,-999.95,2.0
 2827.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",7.3,-999.95,-999.95,2.74,-999.95,-999.95,-999.95,2.0
 2828.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",7.4,-999.95,0.01,2.72,-999.95,-999.95,-999.95,2.0
 2829.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",7.0,-999.95,0.01,2.72,-999.95,-999.95,-999.95,2.0
 2830.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",7.4,-999.95,0.01,2.74,-999.95,-999.95,-999.95,2.0
 2831.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",5.8,-999.95,0.01,2.72,-999.95,-999.95,-999.95,2.0
 2832.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",6.5,-999.95,0.01,2.72,-999.95,-999.95,-999.95,1.0
 2833.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",7.7,-999.95,0.01,2.71,-999.95,-999.95,-999.95,1.0
 2834.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",6.1,-999.95,-999.95,2.7,-999.95,-999.95,-999.95,1.0
 2835.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",5.9,-999.95,0.01,2.68,-999.95,-999.95,-999.95,1.0
 2836.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",6.6,-999.95,0.01,2.73,-999.95,-999.95,-999.95,1.0
 2837.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",7.9,-999.95,0.01,2.7,-999.95,-999.95,-999.95,1.0
 2838.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",7.1,-999.95,0.01,2.69,-999.95,-999.95,-999.95,1.0
 2839.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",6.7,-999.95,0.01,2.69,-999.95,-999.95,-999.95,1.0
 2840.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",8.6,-999.95,0.01,2.71,-999.95,-999.95,-999.95,1.0
 2841.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",8.4,-999.95,-999.95,2.76,-999.95,-999.95,-999.95,2.0
 2842.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Tidal Flat","NM Silt",11.7,-999.95,0.05,2.7,-999.95,-999.95,-999.95,1.0
 2843.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Silt",11.9,-999.95,0.06,2.69,-999.95,-999.95,-999.95,1.0
 2844.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Tidal Flat","NM Silt",11.7,-999.95,0.04,2.7,-999.95,-999.95,-999.95,1.0
 2845.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Tidal Flat","V Silty Mdst-Wkst",12.6,-999.95,0.33,2.8,-999.95,-999.95,-999.95,4.0
 2846.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Tidal Flat","V Silty Mdst-Wkst",13.9,-999.95,0.07,2.78,-999.95,-999.95,-999.95,4.0
 2847.0,6.0,"COUNCIL GROVE GROUP","A1 SH","Coastal Plain","NM Shly Silt",1.7,-999.95,-999.95,2.7,-999.95,-999.95,-999.95,2.0
 2848.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","Wackestone-Packstone",1.6,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 2849.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","Fxln dolomite",17.8,-999.95,0.49,2.79,-999.95,-999.95,-999.95,6.0
 2850.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","Fxln dolomite",15.4,-999.95,0.19,2.8,-999.95,-999.95,-999.95,6.0
 2850.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","Fxln dolomite",15.4,15.2,0.129,2.8,-999.95,1.84,2.27,6.0
 2850.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","Fxln dolomite",15.4,15.2,0.129,2.8,-999.95,1.84,2.27,6.0
 2851.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","Fxln dolomite",8.8,-999.95,0.06,2.84,2.8,2.7,-999.95,6.0
 2852.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","Fxln dolomite",15.1,-999.95,0.12,2.8,-999.95,-999.95,-999.95,6.0
 2853.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","V Silty Mdst-Wkst",7.6,-999.95,0.01,2.8,-999.95,-999.95,-999.95,4.0
 2854.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","V Silty Mdst-Wkst",10.1,-999.95,-999.95,2.76,-999.95,-999.95,-999.95,4.0
 2855.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","Marine Silt or Sh",11.2,-999.95,-999.95,2.78,-999.95,-999.95,-999.95,3.0
 2856.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",9.9,-999.95,-999.95,2.71,-999.95,-999.95,-999.95,3.0
 2857.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.1,-999.95,-999.95,2.7,-999.95,-999.95,-999.95,3.0
 2858.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Shoal","M-CG Packstone",1.3,-999.95,0.01,2.64,-999.95,-999.95,-999.95,7.0
 2859.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",5.2,-999.95,0.01,2.68,-999.95,-999.95,-999.95,3.0
 2860.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.5,-999.95,0.43,2.7,-999.95,-999.95,-999.95,3.0
 2861.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Shoal (transgressive)","M-CG Packstone",6.3,-999.95,0.03,2.71,-999.95,-999.95,-999.95,7.0
 2862.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Shoal (transgressive)","M-CG Pkst-Grnst",1.3,-999.95,-999.95,2.57,-999.95,-999.95,-999.95,7.0
 2863.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","V Silty Mdst-Wkst",3.9,-999.95,0.01,2.66,-999.95,-999.95,-999.95,4.0
 2864.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","V Silty Mdst-Wkst",6.2,-999.95,0.01,2.67,-999.95,-999.95,-999.95,4.0
 2865.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.3,-999.95,0.01,2.67,-999.95,-999.95,-999.95,3.0
 2866.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",8.5,-999.95,0.97,2.7,-999.95,-999.95,-999.95,3.0
 2867.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.3,-999.95,0.01,2.65,-999.95,-999.95,-999.95,3.0
 2868.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.8,-999.95,0.01,2.66,-999.95,-999.95,-999.95,3.0
 2869.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",9.7,-999.95,-999.95,2.7,-999.95,-999.95,-999.95,3.0
 2870.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.4,-999.95,0.01,2.66,-999.95,-999.95,-999.95,3.0
 2871.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.3,-999.95,0.01,2.67,-999.95,-999.95,-999.95,3.0
 2872.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.4,-999.95,0.01,2.67,-999.95,-999.95,-999.95,3.0
 2873.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.2,-999.95,0.03,2.68,-999.95,-999.95,-999.95,3.0
 2874.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Silty Wackestone",8.2,-999.95,0.31,2.72,-999.95,-999.95,-999.95,5.0
 2875.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Silty Wackestone",8.1,-999.95,0.01,2.69,-999.95,-999.95,-999.95,5.0
 2876.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.3,-999.95,0.01,2.68,-999.95,-999.95,-999.95,3.0
 2877.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.5,-999.95,0.01,2.7,-999.95,-999.95,-999.95,3.0
 2878.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.4,-999.95,0.01,2.69,-999.95,-999.95,-999.95,3.0
 2879.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.2,-999.95,0.02,2.65,-999.95,-999.95,-999.95,3.0
 2880.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.2,-999.95,0.02,2.65,-999.95,-999.95,-999.95,3.0
 2881.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",9.8,-999.95,0.01,2.65,-999.95,-999.95,-999.95,3.0
 2882.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",10.9,-999.95,0.07,2.68,-999.95,-999.95,-999.95,3.0
 2883.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",5.4,-999.95,-999.95,2.68,-999.95,-999.95,-999.95,3.0
 2884.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",4.4,-999.95,0.01,2.69,-999.95,-999.95,-999.95,5.0
 2885.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Mid Shelf (Carb Dom)","Silty Wackestone",4.3,-999.95,0.43,2.68,-999.95,-999.95,-999.95,5.0
 2886.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Shoal (transgressive)","M-CG Pkst-Grnst",3.4,-999.95,0.01,2.68,-999.95,-999.95,-999.95,7.0
 2887.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Lagoon","V Silty Mdst-Wkst",4.1,-999.95,0.01,2.7,-999.95,-999.95,-999.95,4.0
 2888.0,6.0,"COUNCIL GROVE GROUP","A1 LM","Tidal Flat","V Silty Mdst-Wkst",6.6,-999.95,0.01,2.75,-999.95,-999.95,-999.95,4.0
 2889.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2890.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",10.2,-999.95,-999.95,2.62,-999.95,-999.95,-999.95,2.0
 2891.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",5.3,-999.95,-999.95,2.68,-999.95,-999.95,-999.95,2.0
 2892.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",5.8,-999.95,0.14,2.69,-999.95,-999.95,-999.95,2.0
 2893.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",5.0,-999.95,3.52,2.7,-999.95,-999.95,-999.95,2.0
 2894.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",3.3,-999.95,0.08,2.83,-999.95,-999.95,-999.95,2.0
 2895.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",6.2,-999.95,-999.95,2.69,-999.95,-999.95,-999.95,2.0
 2896.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Shly Silt",6.2,-999.95,1.43,2.68,-999.95,-999.95,-999.95,2.0
 2897.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",5.8,-999.95,0.04,2.69,-999.95,-999.95,-999.95,1.0
 2898.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",5.9,-999.95,0.01,2.68,-999.95,-999.95,-999.95,1.0
 2899.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",7.2,-999.95,0.02,2.66,-999.95,-999.95,-999.95,1.0
 2900.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",7.1,-999.95,0.02,2.7,-999.95,-999.95,-999.95,1.0
 2901.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",11.9,-999.95,0.07,2.75,-999.95,-999.95,-999.95,1.0
 2902.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",7.5,-999.95,0.68,2.71,-999.95,-999.95,-999.95,1.0
 2903.0,6.0,"COUNCIL GROVE GROUP","B1 SH","Coastal Plain","NM Silt",8.7,-999.95,0.03,2.74,-999.95,-999.95,-999.95,1.0
 2904.0,6.0,"COUNCIL GROVE GROUP","B1 LM","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2905.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","VF-FG Grainstone",14.0,-999.95,3.79,2.71,-999.95,-999.95,-999.95,7.0
 2906.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Packstone",7.2,-999.95,0.17,2.8,-999.95,-999.95,-999.95,7.0
 2907.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Packstone",9.2,-999.95,0.07,2.79,-999.95,-999.95,-999.95,7.0
 2908.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",4.9,-999.95,0.15,2.82,-999.95,-999.95,-999.95,7.0
 2909.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",8.6,-999.95,0.44,2.78,-999.95,-999.95,-999.95,7.0
 2910.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Lagoon","Dol Pkst-Grnst",11.4,-999.95,1.83,2.75,-999.95,-999.95,-999.95,7.0
 2911.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Lagoon","Fxln dolomite",17.6,-999.95,0.93,2.8,-999.95,-999.95,-999.95,6.0
 2911.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Lagoon","Fxln dolomite",17.6,17.2,0.891,2.8,-999.95,2.11,2.3,6.0
 2911.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Lagoon","Fxln dolomite",17.6,17.2,0.891,2.8,-999.95,2.11,2.3,6.0
 2912.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Fxln dolomite",8.8,-999.95,0.01,2.79,2.83,2.73,-999.95,6.0
 2913.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Fxln dolomite",7.4,-999.95,0.03,2.75,-999.95,2.75,-999.95,6.0
 2914.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Dol Mudstone",13.8,-999.95,0.57,2.75,-999.95,-999.95,-999.95,4.0
 2915.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",13.6,-999.95,0.9,2.75,-999.95,-999.95,-999.95,5.0
 2916.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","VF-FG Packstone",2.7,-999.95,0.01,2.72,-999.95,-999.95,-999.95,7.0
 2917.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",8.0,-999.95,0.06,2.71,-999.95,-999.95,-999.95,5.0
 2918.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",4.0,-999.95,0.03,2.75,-999.95,-999.95,-999.95,0.0
 2919.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",12.5,-999.95,4.24,2.71,-999.95,-999.95,-999.95,7.0
 2919.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",12.5,12.3,4.24,2.71,-999.95,2.02,2.06,7.0
 2919.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","M-CG Pkst-Grnst",12.5,12.3,4.24,2.71,-999.95,2.02,2.06,7.0
 2920.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal","VF-FG Packstone",14.5,-999.95,0.91,2.71,-999.95,-999.95,-999.95,7.0
 2921.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",14.8,-999.95,1.37,2.71,-999.95,-999.95,-999.95,5.0
 2922.0,5.5,"COUNCIL GROVE GROUP","B1 LM","Shoal (transgressive)","M-CG Packstone",6.3,-999.95,0.02,2.71,-999.95,-999.95,-999.95,7.0
 2923.0,5.0,"COUNCIL GROVE GROUP","B1 LM","Tidal Flat","Marine Silt or Sh",6.5,-999.95,1.42,2.66,-999.95,-999.95,-999.95,3.0
 2924.0,5.0,"COUNCIL GROVE GROUP","B2 SH","Coastal Plain","NM Shly Silt",5.2,-999.95,0.01,2.67,-999.95,-999.95,-999.95,2.0
 2925.0,5.0,"COUNCIL GROVE GROUP","B2 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2926.0,5.0,"COUNCIL GROVE GROUP","B2 SH","Coastal Plain","NM Silt",8.7,-999.95,0.03,2.67,-999.95,-999.95,-999.95,1.0
 2927.0,5.0,"COUNCIL GROVE GROUP","B2 SH","Coastal Plain","NM Silt",10.8,-999.95,0.03,2.66,-999.95,-999.95,-999.95,1.0
 2928.0,5.0,"COUNCIL GROVE GROUP","B2 SH","Coastal Plain","NM Shly Silt",6.3,-999.95,0.26,2.71,-999.95,-999.95,-999.95,2.0
 2929.0,4.5,"COUNCIL GROVE GROUP","B2 SH","Tidal Flat","Silty Wkst-Pkst",3.4,-999.95,0.07,2.71,-999.95,-999.95,-999.95,5.0
 2930.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Tidal Flat","Wackestone",6.8,-999.95,0.04,2.72,-999.95,-999.95,-999.95,5.0
 2931.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",16.8,-999.95,7.97,2.71,-999.95,-999.95,-999.95,8.0
 2932.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",8.9,-999.95,45.86,2.52,-999.95,-999.95,-999.95,8.0
 2932.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",8.9,14.9,43.8,2.52,-999.95,2.07,2.15,8.0
 2932.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",8.9,14.9,43.8,2.52,-999.95,2.07,2.15,8.0
 2933.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",7.1,-999.95,15.31,2.74,-999.95,-999.95,-999.95,8.0
 2934.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mound","PA Bafflestone",9.8,-999.95,10.87,2.77,-999.95,-999.95,-999.95,8.0
 2935.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","Wackestone",3.1,-999.95,0.02,2.74,-999.95,-999.95,-999.95,5.0
 2936.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","M-CG Pkst-Grnst",16.3,-999.95,3.78,2.71,-999.95,-999.95,-999.95,7.0
 2936.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","M-CG Pkst-Grnst",16.3,16.0,3.77,2.71,-999.95,2.04,2.05,7.0
 2936.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","M-CG Pkst-Grnst",16.3,16.0,3.77,2.71,-999.95,2.04,2.05,7.0
 2937.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","VF-FG Packstone",18.7,-999.95,4.3,2.7,-999.95,-999.95,-999.95,7.0
 2938.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Shoal","VF-FG Packstone",15.9,-999.95,1.5,2.71,-999.95,-999.95,-999.95,7.0
 2939.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",9.3,-999.95,0.08,2.72,-999.95,-999.95,-999.95,5.0
 2940.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",2.9,-999.95,0.01,2.69,-999.95,-999.95,-999.95,5.0
 2941.0,4.5,"COUNCIL GROVE GROUP","B2 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",1.7,-999.95,0.01,2.69,-999.95,-999.95,-999.95,5.0
 2942.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",6.2,-999.95,-999.95,2.66,-999.95,-999.95,-999.95,2.0
 2943.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",4.5,-999.95,1.64,2.67,-999.95,-999.95,-999.95,2.0
 2944.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",5.3,-999.95,0.09,2.68,-999.95,-999.95,-999.95,2.0
 2945.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",11.8,-999.95,-999.95,2.67,-999.95,-999.95,-999.95,2.0
 2946.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Silt",10.1,-999.95,0.1,2.65,-999.95,-999.95,-999.95,1.0
 2947.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Silt",5.1,-999.95,0.02,2.67,-999.95,-999.95,-999.95,1.0
 2948.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",8.1,-999.95,0.04,2.67,-999.95,-999.95,-999.95,2.0
 2949.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Silt",6.0,-999.95,0.01,2.68,-999.95,-999.95,-999.95,1.0
 2950.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Silt",9.4,-999.95,0.01,2.7,-999.95,-999.95,-999.95,1.0
 2951.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Silt",7.0,-999.95,0.01,2.7,-999.95,-999.95,-999.95,1.0
 2952.0,5.0,"COUNCIL GROVE GROUP","B3 SH","Coastal Plain","NM Shly Silt",6.5,-999.95,-999.95,2.72,-999.95,-999.95,-999.95,2.0
 2953.0,4.5,"COUNCIL GROVE GROUP","B3 LM","Tidal Flat","NM Shly Silt",10.1,-999.95,0.05,2.69,-999.95,-999.95,-999.95,2.0
 2954.0,4.5,"COUNCIL GROVE GROUP","B3 LM","Shoal","M-CG Pkst-Grnst",9.9,-999.95,0.41,2.71,-999.95,-999.95,-999.95,7.0
 2955.0,4.5,"COUNCIL GROVE GROUP","B3 LM","Shoal","VF-FG Pkst-Grnst",5.8,-999.95,0.07,2.76,-999.95,-999.95,-999.95,7.0
 2956.0,4.5,"COUNCIL GROVE GROUP","B3 LM","Shoal (transgressive)","M-CG Packstone",7.0,-999.95,0.03,2.72,-999.95,-999.95,-999.95,7.0
 2957.0,4.5,"COUNCIL GROVE GROUP","B3 LM","Tidal Flat","Dol Packstone",6.6,-999.95,0.04,2.76,-999.95,-999.95,-999.95,7.0
 2958.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Shly Silt",11.7,-999.95,0.09,2.64,-999.95,-999.95,-999.95,2.0
 2959.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",7.7,-999.95,0.01,2.73,-999.95,-999.95,-999.95,1.0
 2960.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",5.8,-999.95,0.01,2.67,-999.95,-999.95,-999.95,1.0
 2961.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Shly Silt",7.1,-999.95,-999.95,2.68,-999.95,-999.95,-999.95,2.0
 2962.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",9.4,-999.95,0.03,2.67,-999.95,-999.95,-999.95,1.0
 2963.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",6.6,-999.95,0.02,2.67,-999.95,-999.95,-999.95,1.0
 2964.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",7.0,-999.95,0.02,2.68,-999.95,-999.95,-999.95,1.0
 2965.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",7.0,-999.95,0.01,2.68,-999.95,-999.95,-999.95,1.0
 2966.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Silt",6.9,-999.95,0.02,2.67,-999.95,-999.95,-999.95,1.0
 2967.0,4.5,"COUNCIL GROVE GROUP","B4 SH","Coastal Plain","NM Shly Silt",9.0,-999.95,10.16,2.68,-999.95,-999.95,-999.95,2.0
 2968.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Shoal","Wackestone",2.2,-999.95,0.01,2.78,-999.95,-999.95,-999.95,5.0
 2969.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Shoal","M-CG Packstone",10.0,-999.95,1.85,2.71,-999.95,-999.95,-999.95,7.0
 2970.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Lagoon","Wackestone-Packstone",8.2,-999.95,0.39,2.8,-999.95,-999.95,-999.95,5.0
 2971.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Lagoon","Wackestone-Packstone",7.1,-999.95,0.1,2.77,-999.95,-999.95,-999.95,5.0
 2972.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Lagoon","Dol Mudstone",10.4,-999.95,0.29,2.8,-999.95,-999.95,-999.95,4.0
 2973.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Mid Shelf (Carb Dom)","Dol Wkst-Pkst",7.4,-999.95,0.02,2.78,-999.95,-999.95,-999.95,5.0
 2974.0,4.5,"COUNCIL GROVE GROUP","B4 LM","Tidal Flat","NM Silt",11.3,-999.95,0.04,2.8,-999.95,-999.95,-999.95,1.0
 2975.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Silt",13.4,-999.95,0.04,2.75,-999.95,-999.95,-999.95,1.0
 2976.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2977.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2978.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2979.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2980.0,4.5,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2981.0,4.0,"COUNCIL GROVE GROUP","B5 SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 2982.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Shoal","M-CG Grainstone",0.9,-999.95,0.01,2.7,-999.95,-999.95,-999.95,7.0
 2983.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Shoal","M-CG Grainstone",2.2,-999.95,0.03,2.73,-999.95,-999.95,-999.95,7.0
 2984.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",2.3,-999.95,0.04,2.71,-999.95,-999.95,-999.95,5.0
 2985.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Lagoon","Mudstone",2.2,-999.95,-999.95,2.71,-999.95,2.79,-999.95,4.0
 2986.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Lagoon","Mdst-Wkst",2.1,-999.95,0.14,2.71,-999.95,-999.95,-999.95,4.0
 2987.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Lagoon","Mdst-Wkst",3.4,-999.95,0.41,2.72,-999.95,-999.95,-999.95,4.0
 2988.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",9.8,-999.95,-999.95,2.71,-999.95,-999.95,-999.95,5.0
 2989.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Wackestone-Packstone",8.5,-999.95,1.83,2.71,-999.95,-999.95,-999.95,5.0
 2990.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",12.1,-999.95,11.54,2.71,-999.95,-999.95,-999.95,8.0
 2991.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",14.3,-999.95,118.62,2.71,-999.95,-999.95,-999.95,8.0
 2991.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",14.3,13.8,105.0,2.71,-999.95,1.99,2.2,8.0
 2991.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",14.3,13.8,105.0,2.71,-999.95,1.99,2.2,8.0
 2992.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",20.6,-999.95,1141.06,2.71,-999.95,-999.95,-999.95,8.0
 2993.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",12.8,-999.95,97.09,2.75,-999.95,-999.95,-999.95,8.0
 2994.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",13.4,-999.95,154.43,2.71,-999.95,-999.95,-999.95,8.0
 2995.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",9.7,-999.95,9.44,2.71,-999.95,-999.95,-999.95,8.0
 2996.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",15.4,-999.95,154.04,2.71,-999.95,-999.95,-999.95,8.0
 2997.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",15.3,-999.95,191.45,2.71,-999.95,-999.95,-999.95,8.0
 2997.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",15.3,14.8,181.0,2.71,-999.95,2.09,2.19,8.0
 2997.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",15.3,14.8,181.0,2.71,-999.95,2.09,2.19,8.0
 2998.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mound","PA Bafflestone",13.8,-999.95,17.83,2.7,-999.95,-999.95,-999.95,8.0
 2999.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Silty Wackestone",6.2,-999.95,0.46,2.71,-999.95,-999.95,-999.95,5.0
 3000.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Silty Wackestone",4.0,-999.95,0.01,2.75,-999.95,-999.95,-999.95,5.0
 3001.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Mid Shelf (Carb Dom)","Silty Wackestone",3.6,-999.95,0.01,2.74,-999.95,-999.95,-999.95,5.0
 3002.0,4.0,"COUNCIL GROVE GROUP","B5 LM","Shoal (transgressive)","M-CG Packstone",5.2,-999.95,0.01,2.73,-999.95,-999.95,-999.95,7.0
 3003.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3004.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3005.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3006.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3007.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3008.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Shly Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,2.0
 3009.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3010.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3011.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3012.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3013.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3014.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3015.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3016.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3017.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3018.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3019.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3020.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3021.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3022.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,-999.95,1.0
 3023.0,4.0,"COUNCIL GROVE GROUP","C SH","Coastal Plain","NM Silt",1.5,-999.95,0.01,2.71,-999.95,-999.95,-999.95,1.0
 3024.0,4.0,"COUNCIL GROVE GROUP","C LM","Shoal","M-CG Packstone",5.1,-999.95,0.01,2.71,-999.95,-999.95,-999.95,7.0
 3025.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",7.1,-999.95,0.03,2.72,-999.95,-999.95,-999.95,5.0
 3026.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",5.4,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3027.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",4.6,-999.95,0.01,2.73,-999.95,-999.95,-999.95,5.0
 3028.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",9.3,-999.95,6.64,2.72,-999.95,-999.95,-999.95,5.0
 3029.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",6.3,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3030.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",6.2,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3031.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",6.4,-999.95,0.85,2.72,-999.95,-999.95,-999.95,5.0
 3032.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",2.0,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3033.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",3.9,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3034.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",6.5,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3035.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",3.6,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3036.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",3.8,-999.95,-999.95,2.67,-999.95,-999.95,-999.95,5.0
 3037.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",3.8,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3038.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wackestone",4.7,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3039.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wackestone",5.3,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3040.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wackestone",5.6,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3041.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",3.0,-999.95,0.01,2.71,-999.95,-999.95,-999.95,5.0
 3042.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wackestone",6.7,-999.95,0.03,2.74,-999.95,-999.95,-999.95,5.0
 3043.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wackestone",5.4,-999.95,0.01,2.73,-999.95,-999.95,-999.95,5.0
 3044.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",3.5,-999.95,0.01,2.7,-999.95,-999.95,-999.95,3.0
 3045.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Silty Wkst-Pkst",7.9,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3046.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",4.9,-999.95,0.01,2.72,-999.95,-999.95,-999.95,5.0
 3047.0,4.0,"COUNCIL GROVE GROUP","C LM","Mound","PA Bafflestone",2.7,-999.95,0.01,2.7,-999.95,-999.95,-999.95,8.0
 3048.0,4.0,"COUNCIL GROVE GROUP","C LM","Mound","PA Bafflestone",1.5,-999.95,0.01,2.66,-999.95,-999.95,-999.95,8.0
 3049.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Silty Wackestone",3.5,-999.95,0.01,2.69,-999.95,-999.95,-999.95,5.0
 3050.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.3,-999.95,0.02,2.73,-999.95,-999.95,-999.95,3.0
 3051.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",3.7,-999.95,0.01,2.71,-999.95,-999.95,-999.95,3.0
 3052.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",8.0,-999.95,1.02,2.67,-999.95,-999.95,-999.95,3.0
 3053.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",8.5,-999.95,-999.95,2.66,-999.95,-999.95,-999.95,3.0
 3054.0,4.0,"COUNCIL GROVE GROUP","C LM","Lower Shelf (Silic Dom)","Marine Silt or Sh",7.3,-999.95,0.09,2.7,-999.95,-999.95,-999.95,3.0
 3055.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",2.8,-999.95,0.01,2.75,-999.95,-999.95,-999.95,5.0
 3056.0,4.0,"COUNCIL GROVE GROUP","C LM","Mid Shelf (Carb Dom)","Wackestone",3.7,-999.95,0.01,2.7,-999.95,-999.95,-999.95,5.0
 3057.0,4.0,"COUNCIL GROVE GROUP","C LM","Shoal (transgressive)","M-CG Packstone",3.3,-999.95,0.01,2.71,-999.95,-999.95,-999.95,7.0

~Tops_Parameter
#MNEM .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                                             : Profile Web App Saved Data Indicator {S}
 TOPS  .          Kansas Geological Survey Database  : Formation Source               {S}
 TOPDR .                                  Log Depth  : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 KID   .                      : Primary Key for the Stratigraphic Unit {S}
 KEY   .                      : User Define Primary Key        {S}
 ID    .                      : Stratigraphic Unit ID          {S}
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 TOPA  .                      : Alternate Name                 {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 GRP   .                      : Group                          {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
 "1029654393","100726064911_1","3120005000",728.0,0.0,"FORMATION","Poor","Day Creek Dolomite","DAY CREEK","Phanerozoic","Paleozoic","Permian","Guadalupian","-999.25","Day Creek Dolomite"
 "1029654384","100726064911_2","3130203000",1090.0,1170.0,"FORMATION","Poor","Blaine","BLAINE","Phanerozoic","Paleozoic","Permian","Cisuralian","Nippewalla","Blaine"
 "1029654387","100726064911_3","3130206000",1250.0,1412.0,"FORMATION","Poor","Cedar Hills Sandstone","CDHLLS","Phanerozoic","Paleozoic","Permian","Cisuralian","Nippewalla","Cedar Hills Sandstone"
 "1029654404","100726064911_4","3130403000",1690.0,1759.0,"FORMATION","Poor","Stone Corral","STNC","Phanerozoic","Paleozoic","Permian","Cisuralian","Sumner","Stone Corral"
 "1029654407","100726064911_5","3130407000",2182.0,2516.0,"FORMATION","Poor","Wellington","WLNGTN","Phanerozoic","Paleozoic","Permian","Cisuralian","Sumner","Wellington"
 "1029654399","100726064911_6","3130407400",2291.0,0.0,"MEMBER","Poor","Hutchinson Salt","HUTCH SALT","Phanerozoic","Paleozoic","Permian","Cisuralian","Sumner","Wellington"
 "1029654397","100726064911_7","3130407800",2496.0,0.0,"MEMBER","Poor","Hollenberg Limestone","HLLNBR","Phanerozoic","Paleozoic","Permian","Cisuralian","Sumner","Wellington"
 "1029654390","100726064911_8","3130600000",2516.0,2832.0,"GROUP","Poor","Chase","CHSE GRP","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","-999.25"
 "1029654398","100726064911_9","3130601300",2516.0,2536.0,"MEMBER","Poor","Herington Limestone","HRNGTN","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Nolans Limestone"
 "1029654403","100726064911_10","3130601500",2536.0,2538.0,"MEMBER","Poor","Paddock Shale","PADDOCK","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Nolans Limestone"
 "1029654400","100726064911_11","3130601700",2544.0,2580.0,"MEMBER","Poor","Krider Limestone","KRIDER","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Nolans Limestone"
 "1029654402","100726064911_12","3130603000",2580.0,2594.0,"FORMATION","Poor","Odell Shale","ODELL","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Odell Shale"
 "1029654406","100726064911_13","3130604000",2594.0,2629.0,"FORMATION","Poor","Winfield Limestone","WINF","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Winfield Limestone"
 "1029654396","100726064911_14","3130605300",2632.0,0.0,"MEMBER","Poor","Gage Shale","GAGE","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Doyle Shale"
 "1029654405","100726064911_15","3130605500",2655.0,2704.0,"MEMBER","Poor","Towanda Limestone","TWND","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Doyle Shale"
 "1029654395","100726064911_16","3130606300",2713.0,2756.0,"MEMBER","Poor","Fort Riley Limestone","FTRLY","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Barneston Limestone"
 "1029654394","100726064911_17","3130606700",2759.0,2789.0,"MEMBER","Poor","Florence Limestone","FLRNC","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Barneston Limestone"
 "1029654401","100726064911_18","3130607000",2784.0,2807.0,"FORMATION","Poor","Matfield Shale","MATFIELD","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Matfield Shale"
 "1029654408","100726064911_19","3130609000",2807.0,0.0,"FORMATION","Poor","Wreford Limestone","WREFORD","Phanerozoic","Paleozoic","Permian","Cisuralian","Chase","Wreford Limestone"
 "1029654368","100726064911_20","3130801000",2832.0,2853.5,"FORMATION","Poor","Speiser Shale","A1 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Speiser Shale"
 "1029654389","100726064911_21","3130800000",2832.0,0.0,"GROUP","Poor","Council Grove","CGRV GRP","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","-999.25"
 "1029654367","100726064911_22","3130801500",2852.0,2894.5,"FORMATION","Poor","Funston Limestone","A1 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Funston Limestone"
 "1029654375","100726064911_23","3130802000",2894.0,2910.5,"FORMATION","Poor","Blue Rapids Shale","B1 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Blue Rapids Shale"
 "1029654374","100726064911_24","3130802500",2910.0,2929.0,"FORMATION","Poor","Crouse Limestone","B1 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Crouse Limestone"
 "1029654377","100726064911_25","3130802700",2929.0,2933.5,"FORMATION","Poor","Easly Creek Shale","B2 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Easly Creek Shale"
 "1029654376","100726064911_26","3130803300",2935.0,2947.0,"MEMBER","Poor","Middleburg Limestone","B2 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Bader Limestone"
 "1029654379","100726064911_27","3130803500",2949.0,2957.5,"MEMBER","Poor","Hooser Shale","B3 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Bader Limestone"
 "1029654378","100726064911_28","3130803700",2958.0,2962.5,"MEMBER","Poor","Eiss Limestone","B3 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Bader Limestone"
 "1029654381","100726064911_29","3130804000",2962.0,2972.5,"FORMATION","Poor","Stearns Shale","B4 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Stearns Shale"
 "1029654380","100726064911_30","3130805300",2973.0,2979.0,"MEMBER","Poor","Morrill Limestone","B4 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Beattie Limestone"
 "1029654383","100726064911_31","3130805500",2980.0,2985.5,"MEMBER","Poor","Florena Shale","B5 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Beattie Limestone"
 "1029654382","100726064911_32","3130805700",2986.0,3007.0,"MEMBER","Poor","Cottonwood Limestone","B5 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Beattie Limestone"
 "1029654386","100726064911_33","3130806000",3008.0,3027.5,"FORMATION","Poor","Eskridge Shale","C SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Eskridge Shale"
 "1029654385","100726064911_34","3130807100",3027.0,0.0,"MEMBER","Poor","Neva Limestone","C LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Grenola Limestone"
 "1029654392","100726064911_35","3130808000",3072.0,3089.0,"FORMATION","Poor","Roca Shale","D SH","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Roca Shale"
 "1029654391","100726064911_36","3130809300",3089.0,0.0,"MEMBER","Poor","Howe Limestone","D LM","Phanerozoic","Paleozoic","Permian","Cisuralian","Council Grove","Red Eagle Limestone"

~Perforation_Parameter
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS    .                 YES  : Profile Web App Saved Data Indicator {S}
 PERFTYPE .                      : Charge Type                    {S}

~Perforation_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PERFT .F                     : Perforation Top Depth          {F}
 PERFB .F                     : Perforation Bottom Depth       {F}
 PERFD .SHOTS/FT              : Shot density per foot          {F}

~Perforation_Data | Perforation_Definition 
 3066.0,3072.0,-999.25
 2992.0,3002.0,-999.25

~IQ_Control_Parameter
#MNEM   .UNIT                    VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                               : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F                      2450.0  : Starting Display Depth         {F}
 IQSTOP  .F                      3100.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN                      50  : Plot Scale Feet/Inch           {F}
 IQGRP   .                          ALL  : LAS, ROCK or HORIZON           {S}
 IQORDR  .                      DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API                       0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API                      60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API                      70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API                     100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API                     150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                         NPHI  : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                          ILD  : Deep Induction Resistivity     {S}
 IQOHM_L .MMHO/M    -1.0007505629221916  : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M     461.46746654360874  : Conductivity Image Track Maximum Value {F}
 IQPHI   .                         NPHI  : Neutron porosity               {S}
 IQPHI_L .PU                    -0.0040  : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                      0.376  : Porosity Image Track Maximum Value {F}
 GRNL    .%                         0.0  : % GR Count Lower Limit         {F}
 GRNU    .%                       100.0  : % GR Count Upper Limit         {F}
 GRL     .API                       0.0  : GR (API) Lower Limit           {F}
 GRU     .API                     150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                         0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%                       100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU                       0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU                        0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
 "LAS","LITH","Lithology - Gamma Ray"
 "LAS","LAS","LAS - Reference - GR,SP,CAL Logs"
 "LAS","LAS","LAS - Induction Resistivity Logs"
 "LAS","LAS","LAS - Litho-Density - NPHI,RHOB,PE Logs"
 "LAS","LITH","Colorlith - Rhomaa-Umaa Track"
 "LAS","ROCK","Lithology - Rhomaa-Umaa Track"
 "LAS","PHI","Thin Porosity Track"
 "LAS","LITH","Colorlith - Porosity Imager Nonlinear"
 "LAS","GRAIN","Texture - by Gamma Ray"
 "LAS","LITH","Colorlith - Resistivity Imager Nonlinear"
 "TOPS","STRAT","Horizons - Stratigraphic Units"
 "ROCK","LAS","Data - Core Density & Porosity"
 "ROCK","LAS","Data - Core Plug Permeability"
 "ROCK","LAS","Data - Archie Constants"
 "ROCK","LITH","Lithology - Colorlith Track"
 "ROCK","ROCK","Lithology - Rock Column"
 "ROCK","PHI","Porosity Track"
 "ROCK","LITH","Rock Porosity Image Track"
 "ROCK","GRAIN","Texture - by User Input"
 "ROCK","ICON","Sedimentary Structures"
 "ROCK","DESC","Description"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT                      VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                            YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F                        2810.0  : Starting Display Depth         {F}
 GEOSTOP .F                        3057.0  : Ending Display Depth           {F}
 GEOSRC  .          Lithofacies Rock Data  : Source                         {S}
 GEOREF  .                      Log Depth  : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
 2810.0,2810.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2811.0,2811.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2812.0,2812.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2813.0,2813.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2814.0,2814.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2815.0,2815.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2816.0,2816.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2817.0,2817.0,-999.25,"M-CG Packstone, Shoal"
 2818.0,2818.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2819.0,2819.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2820.0,2820.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2821.0,2821.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2822.0,2822.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2823.0,2823.0,-999.25,"M-CG Pkst-Grnst, Shoal (transgressive)"
 2824.0,2824.0,-999.25,"M-CG Packstone, Shoal (transgressive)"
 2825.0,2825.0,-999.25,"M-CG Pkst-Grnst, Shoal (transgressive)"
 2826.0,2826.0,-999.25,"NM Shly Silt, Coastal Plain"
 2827.0,2827.0,-999.25,"NM Shly Silt, Coastal Plain"
 2828.0,2828.0,-999.25,"NM Shly Silt, Coastal Plain"
 2829.0,2829.0,-999.25,"NM Shly Silt, Coastal Plain"
 2830.0,2830.0,-999.25,"NM Shly Silt, Coastal Plain"
 2831.0,2831.0,-999.25,"NM Shly Silt, Coastal Plain"
 2832.0,2832.0,-999.25,"NM Silt, Coastal Plain"
 2833.0,2833.0,-999.25,"NM Silt, Coastal Plain"
 2834.0,2834.0,-999.25,"NM Silt, Coastal Plain"
 2835.0,2835.0,-999.25,"NM Silt, Coastal Plain"
 2836.0,2836.0,-999.25,"NM Silt, Coastal Plain"
 2837.0,2837.0,-999.25,"NM Silt, Coastal Plain"
 2838.0,2838.0,-999.25,"NM Silt, Coastal Plain"
 2839.0,2839.0,-999.25,"NM Silt, Coastal Plain"
 2840.0,2840.0,-999.25,"NM Silt, Coastal Plain"
 2841.0,2841.0,-999.25,"NM Shly Silt, Coastal Plain"
 2842.0,2842.0,-999.25,"NM Silt, Tidal Flat"
 2843.0,2843.0,-999.25,"NM Silt, Coastal Plain"
 2844.0,2844.0,-999.25,"NM Silt, Tidal Flat"
 2845.0,2845.0,-999.25,"V Silty Mdst-Wkst, Tidal Flat"
 2846.0,2846.0,-999.25,"V Silty Mdst-Wkst, Tidal Flat"
 2847.0,2847.0,-999.25,"NM Shly Silt, Coastal Plain"
 2848.0,2848.0,-999.25,"Wackestone-Packstone, Tidal Flat"
 2849.0,2849.0,-999.25,"Fxln dolomite, Tidal Flat"
 2850.0,2850.0,-999.25,"Fxln dolomite, Tidal Flat"
 2850.0,2850.0,-999.25,"Fxln dolomite, Tidal Flat"
 2850.0,2850.0,-999.25,"Fxln dolomite, Tidal Flat"
 2851.0,2851.0,-999.25,"Fxln dolomite, Lagoon"
 2852.0,2852.0,-999.25,"Fxln dolomite, Lagoon"
 2853.0,2853.0,-999.25,"V Silty Mdst-Wkst, Lagoon"
 2854.0,2854.0,-999.25,"V Silty Mdst-Wkst, Lagoon"
 2855.0,2855.0,-999.25,"Marine Silt or Sh, Lagoon"
 2856.0,2856.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2857.0,2857.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2858.0,2858.0,-999.25,"M-CG Packstone, Shoal"
 2859.0,2859.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2860.0,2860.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2861.0,2861.0,-999.25,"M-CG Packstone, Shoal (transgressive)"
 2862.0,2862.0,-999.25,"M-CG Pkst-Grnst, Shoal (transgressive)"
 2863.0,2863.0,-999.25,"V Silty Mdst-Wkst, Lower Shelf (Silic Dom)"
 2864.0,2864.0,-999.25,"V Silty Mdst-Wkst, Lower Shelf (Silic Dom)"
 2865.0,2865.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2866.0,2866.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2867.0,2867.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2868.0,2868.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2869.0,2869.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2870.0,2870.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2871.0,2871.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2872.0,2872.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2873.0,2873.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2874.0,2874.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 2875.0,2875.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 2876.0,2876.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2877.0,2877.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2878.0,2878.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2879.0,2879.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2880.0,2880.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2881.0,2881.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2882.0,2882.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2883.0,2883.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 2884.0,2884.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2885.0,2885.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 2886.0,2886.0,-999.25,"M-CG Pkst-Grnst, Shoal (transgressive)"
 2887.0,2887.0,-999.25,"V Silty Mdst-Wkst, Lagoon"
 2888.0,2888.0,-999.25,"V Silty Mdst-Wkst, Tidal Flat"
 2889.0,2889.0,-999.25,"NM Shly Silt, Coastal Plain"
 2890.0,2890.0,-999.25,"NM Shly Silt, Coastal Plain"
 2891.0,2891.0,-999.25,"NM Shly Silt, Coastal Plain"
 2892.0,2892.0,-999.25,"NM Shly Silt, Coastal Plain"
 2893.0,2893.0,-999.25,"NM Shly Silt, Coastal Plain"
 2894.0,2894.0,-999.25,"NM Shly Silt, Coastal Plain"
 2895.0,2895.0,-999.25,"NM Shly Silt, Coastal Plain"
 2896.0,2896.0,-999.25,"NM Shly Silt, Coastal Plain"
 2897.0,2897.0,-999.25,"NM Silt, Coastal Plain"
 2898.0,2898.0,-999.25,"NM Silt, Coastal Plain"
 2899.0,2899.0,-999.25,"NM Silt, Coastal Plain"
 2900.0,2900.0,-999.25,"NM Silt, Coastal Plain"
 2901.0,2901.0,-999.25,"NM Silt, Coastal Plain"
 2902.0,2902.0,-999.25,"NM Silt, Coastal Plain"
 2903.0,2903.0,-999.25,"NM Silt, Coastal Plain"
 2904.0,2904.0,-999.25,"NM Shly Silt, Coastal Plain"
 2905.0,2905.0,-999.25,"VF-FG Grainstone, Shoal"
 2906.0,2906.0,-999.25,"M-CG Packstone, Shoal"
 2907.0,2907.0,-999.25,"M-CG Packstone, Shoal"
 2908.0,2908.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2909.0,2909.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2910.0,2910.0,-999.25,"Dol Pkst-Grnst, Lagoon"
 2911.0,2911.0,-999.25,"Fxln dolomite, Lagoon"
 2911.0,2911.0,-999.25,"Fxln dolomite, Lagoon"
 2911.0,2911.0,-999.25,"Fxln dolomite, Lagoon"
 2912.0,2912.0,-999.25,"Fxln dolomite, Mid Shelf (Carb Dom)"
 2913.0,2913.0,-999.25,"Fxln dolomite, Mid Shelf (Carb Dom)"
 2914.0,2914.0,-999.25,"Dol Mudstone, Mid Shelf (Carb Dom)"
 2915.0,2915.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2916.0,2916.0,-999.25,"VF-FG Packstone, Shoal"
 2917.0,2917.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2918.0,2918.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2919.0,2919.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2919.0,2919.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2919.0,2919.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2920.0,2920.0,-999.25,"VF-FG Packstone, Shoal"
 2921.0,2921.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2922.0,2922.0,-999.25,"M-CG Packstone, Shoal (transgressive)"
 2923.0,2923.0,-999.25,"Marine Silt or Sh, Tidal Flat"
 2924.0,2924.0,-999.25,"NM Shly Silt, Coastal Plain"
 2925.0,2925.0,-999.25,"NM Shly Silt, Coastal Plain"
 2926.0,2926.0,-999.25,"NM Silt, Coastal Plain"
 2927.0,2927.0,-999.25,"NM Silt, Coastal Plain"
 2928.0,2928.0,-999.25,"NM Shly Silt, Coastal Plain"
 2929.0,2929.0,-999.25,"Silty Wkst-Pkst, Tidal Flat"
 2930.0,2930.0,-999.25,"Wackestone, Tidal Flat"
 2931.0,2931.0,-999.25,"PA Bafflestone, Mound"
 2932.0,2932.0,-999.25,"PA Bafflestone, Mound"
 2932.0,2932.0,-999.25,"PA Bafflestone, Mound"
 2932.0,2932.0,-999.25,"PA Bafflestone, Mound"
 2933.0,2933.0,-999.25,"PA Bafflestone, Mound"
 2934.0,2934.0,-999.25,"PA Bafflestone, Mound"
 2935.0,2935.0,-999.25,"Wackestone, Shoal"
 2936.0,2936.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2936.0,2936.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2936.0,2936.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2937.0,2937.0,-999.25,"VF-FG Packstone, Shoal"
 2938.0,2938.0,-999.25,"VF-FG Packstone, Shoal"
 2939.0,2939.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 2940.0,2940.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2941.0,2941.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2942.0,2942.0,-999.25,"NM Shly Silt, Coastal Plain"
 2943.0,2943.0,-999.25,"NM Shly Silt, Coastal Plain"
 2944.0,2944.0,-999.25,"NM Shly Silt, Coastal Plain"
 2945.0,2945.0,-999.25,"NM Shly Silt, Coastal Plain"
 2946.0,2946.0,-999.25,"NM Silt, Coastal Plain"
 2947.0,2947.0,-999.25,"NM Silt, Coastal Plain"
 2948.0,2948.0,-999.25,"NM Shly Silt, Coastal Plain"
 2949.0,2949.0,-999.25,"NM Silt, Coastal Plain"
 2950.0,2950.0,-999.25,"NM Silt, Coastal Plain"
 2951.0,2951.0,-999.25,"NM Silt, Coastal Plain"
 2952.0,2952.0,-999.25,"NM Shly Silt, Coastal Plain"
 2953.0,2953.0,-999.25,"NM Shly Silt, Tidal Flat"
 2954.0,2954.0,-999.25,"M-CG Pkst-Grnst, Shoal"
 2955.0,2955.0,-999.25,"VF-FG Pkst-Grnst, Shoal"
 2956.0,2956.0,-999.25,"M-CG Packstone, Shoal (transgressive)"
 2957.0,2957.0,-999.25,"Dol Packstone, Tidal Flat"
 2958.0,2958.0,-999.25,"NM Shly Silt, Coastal Plain"
 2959.0,2959.0,-999.25,"NM Silt, Coastal Plain"
 2960.0,2960.0,-999.25,"NM Silt, Coastal Plain"
 2961.0,2961.0,-999.25,"NM Shly Silt, Coastal Plain"
 2962.0,2962.0,-999.25,"NM Silt, Coastal Plain"
 2963.0,2963.0,-999.25,"NM Silt, Coastal Plain"
 2964.0,2964.0,-999.25,"NM Silt, Coastal Plain"
 2965.0,2965.0,-999.25,"NM Silt, Coastal Plain"
 2966.0,2966.0,-999.25,"NM Silt, Coastal Plain"
 2967.0,2967.0,-999.25,"NM Shly Silt, Coastal Plain"
 2968.0,2968.0,-999.25,"Wackestone, Shoal"
 2969.0,2969.0,-999.25,"M-CG Packstone, Shoal"
 2970.0,2970.0,-999.25,"Wackestone-Packstone, Lagoon"
 2971.0,2971.0,-999.25,"Wackestone-Packstone, Lagoon"
 2972.0,2972.0,-999.25,"Dol Mudstone, Lagoon"
 2973.0,2973.0,-999.25,"Dol Wkst-Pkst, Mid Shelf (Carb Dom)"
 2974.0,2974.0,-999.25,"NM Silt, Tidal Flat"
 2975.0,2975.0,-999.25,"NM Silt, Coastal Plain"
 2976.0,2976.0,-999.25,"NM Shly Silt, Coastal Plain"
 2977.0,2977.0,-999.25,"NM Shly Silt, Coastal Plain"
 2978.0,2978.0,-999.25,"NM Shly Silt, Coastal Plain"
 2979.0,2979.0,-999.25,"NM Shly Silt, Coastal Plain"
 2980.0,2980.0,-999.25,"NM Shly Silt, Coastal Plain"
 2981.0,2981.0,-999.25,"NM Shly Silt, Coastal Plain"
 2982.0,2982.0,-999.25,"M-CG Grainstone, Shoal"
 2983.0,2983.0,-999.25,"M-CG Grainstone, Shoal"
 2984.0,2984.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2985.0,2985.0,-999.25,"Mudstone, Lagoon"
 2986.0,2986.0,-999.25,"Mdst-Wkst, Lagoon"
 2987.0,2987.0,-999.25,"Mdst-Wkst, Lagoon"
 2988.0,2988.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2989.0,2989.0,-999.25,"Wackestone-Packstone, Mid Shelf (Carb Dom)"
 2990.0,2990.0,-999.25,"PA Bafflestone, Mound"
 2991.0,2991.0,-999.25,"PA Bafflestone, Mound"
 2991.0,2991.0,-999.25,"PA Bafflestone, Mound"
 2991.0,2991.0,-999.25,"PA Bafflestone, Mound"
 2992.0,2992.0,-999.25,"PA Bafflestone, Mound"
 2993.0,2993.0,-999.25,"PA Bafflestone, Mound"
 2994.0,2994.0,-999.25,"PA Bafflestone, Mound"
 2995.0,2995.0,-999.25,"PA Bafflestone, Mound"
 2996.0,2996.0,-999.25,"PA Bafflestone, Mound"
 2997.0,2997.0,-999.25,"PA Bafflestone, Mound"
 2997.0,2997.0,-999.25,"PA Bafflestone, Mound"
 2997.0,2997.0,-999.25,"PA Bafflestone, Mound"
 2998.0,2998.0,-999.25,"PA Bafflestone, Mound"
 2999.0,2999.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3000.0,3000.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3001.0,3001.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3002.0,3002.0,-999.25,"M-CG Packstone, Shoal (transgressive)"
 3003.0,3003.0,-999.25,"NM Shly Silt, Coastal Plain"
 3004.0,3004.0,-999.25,"NM Shly Silt, Coastal Plain"
 3005.0,3005.0,-999.25,"NM Shly Silt, Coastal Plain"
 3006.0,3006.0,-999.25,"NM Shly Silt, Coastal Plain"
 3007.0,3007.0,-999.25,"NM Shly Silt, Coastal Plain"
 3008.0,3008.0,-999.25,"NM Shly Silt, Coastal Plain"
 3009.0,3009.0,-999.25,"NM Silt, Coastal Plain"
 3010.0,3010.0,-999.25,"NM Silt, Coastal Plain"
 3011.0,3011.0,-999.25,"NM Silt, Coastal Plain"
 3012.0,3012.0,-999.25,"NM Silt, Coastal Plain"
 3013.0,3013.0,-999.25,"NM Silt, Coastal Plain"
 3014.0,3014.0,-999.25,"NM Silt, Coastal Plain"
 3015.0,3015.0,-999.25,"NM Silt, Coastal Plain"
 3016.0,3016.0,-999.25,"NM Silt, Coastal Plain"
 3017.0,3017.0,-999.25,"NM Silt, Coastal Plain"
 3018.0,3018.0,-999.25,"NM Silt, Coastal Plain"
 3019.0,3019.0,-999.25,"NM Silt, Coastal Plain"
 3020.0,3020.0,-999.25,"NM Silt, Coastal Plain"
 3021.0,3021.0,-999.25,"NM Silt, Coastal Plain"
 3022.0,3022.0,-999.25,"NM Silt, Coastal Plain"
 3023.0,3023.0,-999.25,"NM Silt, Coastal Plain"
 3024.0,3024.0,-999.25,"M-CG Packstone, Shoal"
 3025.0,3025.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3026.0,3026.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3027.0,3027.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 3028.0,3028.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3029.0,3029.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3030.0,3030.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3031.0,3031.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3032.0,3032.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 3033.0,3033.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 3034.0,3034.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3035.0,3035.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3036.0,3036.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3037.0,3037.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 3038.0,3038.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3039.0,3039.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3040.0,3040.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3041.0,3041.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3042.0,3042.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3043.0,3043.0,-999.25,"Silty Wackestone, Mid Shelf (Carb Dom)"
 3044.0,3044.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3045.0,3045.0,-999.25,"Silty Wkst-Pkst, Mid Shelf (Carb Dom)"
 3046.0,3046.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3047.0,3047.0,-999.25,"PA Bafflestone, Mound"
 3048.0,3048.0,-999.25,"PA Bafflestone, Mound"
 3049.0,3049.0,-999.25,"Silty Wackestone, Lower Shelf (Silic Dom)"
 3050.0,3050.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3051.0,3051.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3052.0,3052.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3053.0,3053.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3054.0,3054.0,-999.25,"Marine Silt or Sh, Lower Shelf (Silic Dom)"
 3055.0,3055.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3056.0,3056.0,-999.25,"Wackestone, Mid Shelf (Carb Dom)"
 3057.0,3057.0,-999.25,"M-CG Packstone, Shoal (transgressive)"

~IQ_Las_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .F           SELECTED  : Depth (MD)                     
 DPHI  .PU          SELECTED  : Density porosity               
 DRHO  .GM/CC       SELECTED  : Bulk Density Correction        
 DT    .USEC/FT     SELECTED  : Acoustic transit time          
 GR    .API         SELECTED  : Gamma Ray                      
 ILD   .OHM-M       SELECTED  : Deep Induction Resistivity     
 ILM   .OHM-M       SELECTED  : Medium Induction Resistivity   
 ITT   .USEC/FT               : Acoustic transit time          
 ?     .DEC                   : bound water from mril          
 ?     .                      : Curve #  49                    
 ?     .DEC                   : free fluid from mril           
 MINV  .OHM-M       SELECTED  : Micro Inverse Resistivity      
 MNOR  .OHM-M       SELECTED  : Micro Normal Resistivity       
 MPERM .MD          SELECTED  : Permeability                   
 ?     .                      : Curve #  51                    
 ?     .DEC                   : eff. phi from mril             
 NPHI  .PU          SELECTED  : Neutron porosity               
 PE    .BARNS/E     SELECTED  : Photoelectric factor           
 PMRI  .MD                    : Permeability                   
 RHOB  .GM/CC       SELECTED  : Bulk Density                   
 SGRD  .OHM-M       SELECTED  : Shallow Laterolog Resistivity  
 SP    .MV          SELECTED  : Spontaneous Potential          

~ASCII
 2342.000,0.022,0.082,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.013,2.384,-999.25,-999.25,-999.25,0.159,4.036,-999.25,2.672,-999.25,-999.25
 2342.500,-0.030,0.068,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.855,1.952,-999.25,-999.25,-999.25,0.117,4.178,-999.25,2.762,-999.25,-999.25
 2343.000,-0.063,0.073,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.580,4.134,-999.25,-999.25,-999.25,0.059,4.612,-999.25,2.818,-999.25,-999.25
 2343.500,-0.112,0.096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.146,12.431,-999.25,-999.25,-999.25,0.023,4.795,-999.25,2.901,-999.25,-999.25
 2344.000,-0.131,0.064,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,28.121,30.593,-999.25,-999.25,-999.25,0.010,5.006,-999.25,2.934,-999.25,-999.25
 2344.500,-0.132,0.049,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,24.607,37.963,-999.25,-999.25,-999.25,0.008,5.113,-999.25,2.935,-999.25,-999.25
 2345.000,-0.105,0.078,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,21.966,29.777,-999.25,-999.25,-999.25,0.016,4.943,-999.25,2.890,-999.25,-999.25
 2345.500,-0.012,0.122,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.269,27.071,-999.25,-999.25,-999.25,0.049,4.497,-999.25,2.731,-999.25,-999.25
 2346.000,0.074,0.085,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.464,4.614,-999.25,-999.25,-999.25,0.124,4.331,-999.25,2.584,-999.25,-999.25
 2346.500,0.090,0.076,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.199,1.188,-999.25,-999.25,-999.25,0.211,4.265,-999.25,2.556,-999.25,-999.25
 2347.000,0.076,0.094,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.706,2.133,-999.25,-999.25,-999.25,0.156,4.235,-999.25,2.581,-999.25,-999.25
 2347.500,-0.003,0.145,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.063,11.733,-999.25,-999.25,-999.25,0.092,4.316,-999.25,2.715,-999.25,-999.25
 2348.000,-0.082,0.118,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,41.069,29.412,-999.25,-999.25,-999.25,0.079,4.629,-999.25,2.850,-999.25,-999.25
 2348.500,-0.055,0.023,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,11.707,8.484,-999.25,-999.25,-999.25,0.106,4.663,-999.25,2.804,-999.25,-999.25
 2349.000,-0.066,0.028,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.975,2.092,-999.25,-999.25,-999.25,0.106,4.642,-999.25,2.822,-999.25,-999.25
 2349.500,-0.081,0.037,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,17.352,13.040,-999.25,-999.25,-999.25,0.059,4.587,-999.25,2.849,-999.25,-999.25
 2350.000,-0.102,0.034,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,30.666,27.728,-999.25,-999.25,-999.25,0.035,4.461,-999.25,2.884,-999.25,-999.25
 2350.500,-0.086,0.009,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,35.638,50.728,-999.25,-999.25,-999.25,0.039,4.197,-999.25,2.858,-999.25,-999.25
 2351.000,-0.048,0.004,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.658,23.700,-999.25,-999.25,-999.25,0.071,3.863,-999.25,2.792,-999.25,-999.25
 2351.500,0.013,0.066,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.298,4.932,-999.25,-999.25,-999.25,0.125,3.415,-999.25,2.687,-999.25,-999.25
 2352.000,0.126,0.082,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.952,2.798,-999.25,-999.25,-999.25,0.199,3.228,-999.25,2.494,-999.25,-999.25
 2352.500,0.171,0.064,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.323,2.092,-999.25,-999.25,-999.25,0.267,3.220,-999.25,2.417,-999.25,-999.25
 2353.000,0.166,0.079,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.611,0.940,-999.25,-999.25,-999.25,0.273,3.371,-999.25,2.427,-999.25,-999.25
 2353.500,0.147,0.105,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.215,2.620,-999.25,-999.25,-999.25,0.218,3.493,-999.25,2.458,-999.25,-999.25
 2354.000,0.043,0.184,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.746,4.300,-999.25,-999.25,-999.25,0.174,4.024,-999.25,2.637,-999.25,-999.25
 2354.500,0.035,0.087,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.290,4.319,-999.25,-999.25,-999.25,0.168,4.203,-999.25,2.650,-999.25,-999.25
 2355.000,0.014,0.059,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.143,2.883,-999.25,-999.25,-999.25,0.167,4.212,-999.25,2.687,-999.25,-999.25
 2355.500,-0.007,0.045,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.852,1.720,-999.25,-999.25,-999.25,0.105,4.295,-999.25,2.721,-999.25,-999.25
 2356.000,-0.077,0.065,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,27.141,20.033,-999.25,-999.25,-999.25,0.044,4.468,-999.25,2.842,-999.25,-999.25
 2356.500,-0.111,0.003,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,48.096,51.518,-999.25,-999.25,-999.25,0.014,4.832,-999.25,2.900,-999.25,-999.25
 2357.000,-0.132,-0.003,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,53.766,74.628,-999.25,-999.25,-999.25,0.005,5.089,-999.25,2.935,-999.25,-999.25
 2357.500,-0.128,-0.006,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,66.914,75.828,-999.25,-999.25,-999.25,0.004,5.088,-999.25,2.930,-999.25,-999.25
 2358.000,-0.133,-0.005,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,45.210,53.944,-999.25,-999.25,-999.25,0.006,5.077,-999.25,2.938,-999.25,-999.25
 2358.500,-0.134,-0.003,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,39.273,27.569,-999.25,-999.25,-999.25,0.006,5.078,-999.25,2.939,-999.25,-999.25
 2359.000,-0.131,-0.002,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,52.128,54.966,-999.25,-999.25,-999.25,0.005,5.073,-999.25,2.934,-999.25,-999.25
 2359.500,-0.130,-0.008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,47.226,54.450,-999.25,-999.25,-999.25,0.004,4.962,-999.25,2.931,-999.25,-999.25
 2360.000,-0.130,-0.010,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,53.482,49.816,-999.25,-999.25,-999.25,0.004,4.899,-999.25,2.933,-999.25,-999.25
 2360.500,-0.125,-0.005,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,50.236,51.311,-999.25,-999.25,-999.25,0.005,4.891,-999.25,2.924,-999.25,-999.25
 2361.000,-0.109,-0.001,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,52.896,72.590,-999.25,-999.25,-999.25,0.009,4.853,-999.25,2.896,-999.25,-999.25
 2361.500,-0.057,0.043,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,34.596,41.619,-999.25,-999.25,-999.25,0.023,4.414,-999.25,2.808,-999.25,-999.25
 2362.000,0.108,0.020,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.486,10.976,-999.25,-999.25,-999.25,0.060,3.939,-999.25,2.525,-999.25,-999.25
 2362.500,0.174,0.074,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.323,6.597,-999.25,-999.25,-999.25,0.135,3.702,-999.25,2.412,-999.25,-999.25
 2363.000,0.206,0.071,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,9.398,6.575,-999.25,-999.25,-999.25,0.212,3.747,-999.25,2.358,-999.25,-999.25
 2363.500,0.187,0.087,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.839,4.784,-999.25,-999.25,-999.25,0.231,3.743,-999.25,2.390,-999.25,-999.25
 2364.000,0.147,0.094,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.336,1.690,-999.25,-999.25,-999.25,0.190,3.950,-999.25,2.458,-999.25,-999.25
 2364.500,0.011,0.145,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.839,3.713,-999.25,-999.25,-999.25,0.153,4.227,-999.25,2.691,-999.25,-999.25
 2365.000,-0.037,0.099,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.639,4.492,-999.25,-999.25,-999.25,0.145,4.772,-999.25,2.774,-999.25,-999.25
 2365.500,-0.023,0.053,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.198,4.400,-999.25,-999.25,-999.25,0.140,4.800,-999.25,2.749,-999.25,-999.25
 2366.000,-0.048,0.060,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.593,3.089,-999.25,-999.25,-999.25,0.106,4.890,-999.25,2.792,-999.25,-999.25
 2366.500,-0.074,0.045,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,17.363,8.964,-999.25,-999.25,-999.25,0.056,5.002,-999.25,2.837,-999.25,-999.25
 2367.000,-0.113,0.043,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,40.920,34.031,-999.25,-999.25,-999.25,0.018,5.157,-999.25,2.904,-999.25,-999.25
 2367.500,-0.130,0.042,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,41.539,39.330,-999.25,-999.25,-999.25,0.006,5.152,-999.25,2.933,-999.25,-999.25
 2368.000,-0.113,0.025,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,63.604,63.869,-999.25,-999.25,-999.25,0.006,5.028,-999.25,2.903,-999.25,-999.25
 2368.500,-0.092,0.032,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,64.499,73.447,-999.25,-999.25,-999.25,0.015,4.727,-999.25,2.867,-999.25,-999.25
 2369.000,-0.076,0.121,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,27.535,23.312,-999.25,-999.25,-999.25,0.035,4.393,-999.25,2.841,-999.25,-999.25
 2369.500,0.030,0.107,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,26.921,19.779,-999.25,-999.25,-999.25,0.077,4.279,-999.25,2.659,-999.25,-999.25
 2370.000,0.045,0.096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,11.574,7.664,-999.25,-999.25,-999.25,0.140,4.189,-999.25,2.633,-999.25,-999.25
 2370.500,0.047,0.068,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.704,1.173,-999.25,-999.25,-999.25,0.151,4.126,-999.25,2.629,-999.25,-999.25
 2371.000,0.013,0.088,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,16.738,9.558,-999.25,-999.25,-999.25,0.073,4.191,-999.25,2.688,-999.25,-999.25
 2371.500,-0.082,0.070,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,25.933,19.808,-999.25,-999.25,-999.25,0.030,4.523,-999.25,2.850,-999.25,-999.25
 2372.000,-0.107,0.042,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,16.884,34.858,-999.25,-999.25,-999.25,0.022,4.490,-999.25,2.894,-999.25,-999.25
 2372.500,-0.011,0.092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,24.573,52.323,-999.25,-999.25,-999.25,0.040,4.232,-999.25,2.728,-999.25,-999.25
 2373.000,0.061,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,9.018,18.187,-999.25,-999.25,-999.25,0.106,4.204,-999.25,2.606,-999.25,-999.25
 2373.500,0.076,0.080,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.656,1.391,-999.25,-999.25,-999.25,0.191,4.265,-999.25,2.580,-999.25,-999.25
 2374.000,0.067,0.091,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.987,1.952,-999.25,-999.25,-999.25,0.115,4.294,-999.25,2.596,-999.25,-999.25
 2374.500,-0.013,0.140,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,9.466,6.047,-999.25,-999.25,-999.25,0.039,4.565,-999.25,2.732,-999.25,-999.25
 2375.000,-0.112,0.088,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,24.599,25.169,-999.25,-999.25,-999.25,0.008,4.957,-999.25,2.901,-999.25,-999.25
 2375.500,-0.166,0.058,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,28.568,38.842,-999.25,-999.25,-999.25,-0.001,5.113,-999.25,2.994,-999.25,-999.25
 2376.000,-0.157,0.017,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,29.714,30.737,-999.25,-999.25,-999.25,-0.004,4.972,-999.25,2.978,-999.25,-999.25
 2376.500,-0.169,0.020,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,42.096,44.872,-999.25,-999.25,-999.25,-0.004,4.897,-999.25,2.999,-999.25,-999.25
 2377.000,-0.156,-0.004,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,36.035,62.857,-999.25,-999.25,-999.25,-0.004,4.917,-999.25,2.976,-999.25,-999.25
 2377.500,-0.148,-0.010,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,59.392,75.042,-999.25,-999.25,-999.25,-0.003,4.817,-999.25,2.964,-999.25,-999.25
 2378.000,-0.149,-0.009,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,74.398,84.269,-999.25,-999.25,-999.25,-0.003,4.759,-999.25,2.965,-999.25,-999.25
 2378.500,-0.148,-0.008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,73.615,89.855,-999.25,-999.25,-999.25,-0.002,4.801,-999.25,2.963,-999.25,-999.25
 2379.000,-0.140,-0.008,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,60.138,82.733,-999.25,-999.25,-999.25,-0.001,4.546,-999.25,2.950,-999.25,-999.25
 2379.500,-0.109,0.052,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,53.085,79.262,-999.25,-999.25,-999.25,0.008,4.123,-999.25,2.896,-999.25,-999.25
 2380.000,0.012,0.100,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,46.916,56.702,-999.25,-999.25,-999.25,0.035,3.848,-999.25,2.689,-999.25,-999.25
 2380.500,0.127,0.135,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,17.734,41.715,-999.25,-999.25,-999.25,0.105,3.607,-999.25,2.494,-999.25,-999.25
 2381.000,0.197,0.115,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.045,2.270,-999.25,-999.25,-999.25,0.212,3.500,-999.25,2.374,-999.25,-999.25
 2381.500,0.204,0.113,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.146,1.177,-999.25,-999.25,-999.25,0.295,3.557,-999.25,2.360,-999.25,-999.25
 2382.000,0.150,0.138,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.810,1.095,-999.25,-999.25,-999.25,0.187,3.904,-999.25,2.453,-999.25,-999.25
 2382.500,0.070,0.092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,34.348,31.432,-999.25,-999.25,-999.25,0.069,4.296,-999.25,2.590,-999.25,-999.25
 2383.000,-0.064,0.066,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,56.672,65.165,-999.25,-999.25,-999.25,0.027,4.815,-999.25,2.819,-999.25,-999.25
 2383.500,-0.123,0.014,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,22.197,27.750,-999.25,-999.25,-999.25,0.014,5.068,-999.25,2.921,-999.25,-999.25
 2384.000,-0.141,0.019,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,39.582,30.221,-999.25,-999.25,-999.25,0.007,5.050,-999.25,2.951,-999.25,-999.25
 2384.500,-0.139,0.010,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,50.033,57.994,-999.25,-999.25,-999.25,0.003,5.063,-999.25,2.948,-999.25,-999.25
 2385.000,-0.117,0.053,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,55.408,81.241,-999.25,-999.25,-999.25,0.006,4.478,-999.25,2.910,-999.25,-999.25
 2385.500,0.000,0.022,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,56.970,89.117,-999.25,-999.25,-999.25,0.022,4.141,-999.25,2.710,-999.25,-999.25
 2386.000,0.024,0.067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,30.773,43.528,-999.25,-999.25,-999.25,0.073,3.900,-999.25,2.669,-999.25,-999.25
 2386.500,0.051,0.099,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.585,1.860,-999.25,-999.25,-999.25,0.128,3.934,-999.25,2.624,-999.25,-999.25
 2387.000,0.064,0.126,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,16.642,11.187,-999.25,-999.25,-999.25,0.162,3.857,-999.25,2.601,-999.25,-999.25
 2387.500,0.025,0.186,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.796,10.437,-999.25,-999.25,-999.25,0.169,3.984,-999.25,2.668,-999.25,-999.25
 2388.000,0.052,0.102,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.310,3.344,-999.25,-999.25,-999.25,0.164,4.170,-999.25,2.621,-999.25,-999.25
 2388.500,0.002,0.129,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.190,2.240,-999.25,-999.25,-999.25,0.134,4.308,-999.25,2.707,-999.25,-999.25
 2389.000,-0.030,0.076,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.225,7.472,-999.25,-999.25,-999.25,0.065,4.424,-999.25,2.761,-999.25,-999.25
 2389.500,-0.085,0.072,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,49.591,46.445,-999.25,-999.25,-999.25,0.023,4.569,-999.25,2.855,-999.25,-999.25
 2390.000,-0.117,0.113,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,59.659,74.274,-999.25,-999.25,-999.25,0.015,4.318,-999.25,2.910,-999.25,-999.25
 2390.500,0.062,0.130,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,47.539,62.436,-999.25,-999.25,-999.25,0.033,3.613,-999.25,2.603,-999.25,-999.25
 2391.000,0.198,0.080,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,25.336,39.558,-999.25,-999.25,-999.25,0.098,3.328,-999.25,2.372,-999.25,-999.25
 2391.500,0.223,0.069,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.943,2.510,-999.25,-999.25,-999.25,0.200,3.232,-999.25,2.329,-999.25,-999.25
 2392.000,0.200,0.159,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.199,1.276,-999.25,-999.25,-999.25,0.217,3.193,-999.25,2.369,-999.25,-999.25
 2392.500,0.207,0.168,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.229,30.782,-999.25,-999.25,-999.25,0.201,3.112,-999.25,2.356,-999.25,-999.25
 2393.000,0.128,0.138,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,11.588,24.996,-999.25,-999.25,-999.25,0.221,3.371,-999.25,2.490,-999.25,-999.25
 2393.500,0.164,0.096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.073,1.081,-999.25,-999.25,-999.25,0.273,3.269,-999.25,2.430,-999.25,-999.25
 2394.000,0.161,0.117,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.467,1.155,-999.25,-999.25,-999.25,0.343,3.305,-999.25,2.434,-999.25,-999.25
 2394.500,0.119,0.106,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.368,1.225,-999.25,-999.25,-999.25,0.338,3.493,-999.25,2.507,-999.25,-999.25
 2395.000,0.081,0.131,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.425,2.377,-999.25,-999.25,-999.25,0.232,3.638,-999.25,2.572,-999.25,-999.25
 2395.500,0.050,0.123,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.777,3.396,-999.25,-999.25,-999.25,0.167,3.940,-999.25,2.624,-999.25,-999.25
 2396.000,0.010,0.096,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.762,5.316,-999.25,-999.25,-999.25,0.134,4.268,-999.25,2.692,-999.25,-999.25
 2396.500,-0.015,0.104,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.694,7.317,-999.25,-999.25,-999.25,0.112,4.211,-999.25,2.736,-999.25,-999.25
 2397.000,-0.014,0.110,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.091,20.115,-999.25,-999.25,-999.25,0.116,4.081,-999.25,2.734,-999.25,-999.25
 2397.500,0.015,0.095,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.163,11.441,-999.25,-999.25,-999.25,0.160,4.061,-999.25,2.684,-999.25,-999.25
 2398.000,0.071,0.092,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.670,1.417,-999.25,-999.25,-999.25,0.246,3.742,-999.25,2.588,-999.25,-999.25
 2398.500,0.109,0.085,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.582,1.299,-999.25,-999.25,-999.25,0.322,3.631,-999.25,2.524,-999.25,-999.25
 2399.000,0.103,0.059,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.073,1.118,-999.25,-999.25,-999.25,0.296,3.736,-999.25,2.534,-999.25,-999.25
 2399.500,0.054,0.081,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.623,4.758,-999.25,-999.25,-999.25,0.163,3.835,-999.25,2.617,-999.25,-999.25
 2400.000,-0.000,0.125,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,38.791,46.766,-999.25,-999.25,-999.25,0.108,3.885,-999.25,2.711,-999.25,-999.25
 2400.500,0.022,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,24.691,34.120,-999.25,-999.25,-999.25,0.120,3.835,-999.25,2.672,-999.25,-999.25
 2401.000,0.069,0.045,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.970,2.919,-999.25,-999.25,-999.25,0.181,3.772,-999.25,2.592,-999.25,-999.25
 2401.500,0.094,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.959,1.686,-999.25,-999.25,-999.25,0.222,3.474,-999.25,2.550,-999.25,-999.25
 2402.000,0.098,0.095,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.537,1.948,-999.25,-999.25,-999.25,0.224,3.304,-999.25,2.542,-999.25,-999.25
 2402.500,0.093,0.099,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.317,2.115,-999.25,-999.25,-999.25,0.233,3.314,-999.25,2.551,-999.25,-999.25
 2403.000,0.081,0.115,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.808,1.587,-999.25,-999.25,-999.25,0.247,3.315,-999.25,2.571,-999.25,-999.25
 2403.500,0.094,0.114,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.621,1.915,-999.25,-999.25,-999.25,0.267,3.429,-999.25,2.549,-999.25,-999.25
 2404.000,0.097,0.088,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.300,1.852,-999.25,-999.25,-999.25,0.259,3.477,-999.25,2.544,-999.25,-999.25
 2404.500,0.082,0.057,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.050,1.753,-999.25,-999.25,-999.25,0.204,3.851,-999.25,2.570,-999.25,-999.25
 2405.000,0.023,0.065,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,9.344,2.960,-999.25,-999.25,-999.25,0.098,4.267,-999.25,2.671,-999.25,-999.25
 2405.500,-0.037,0.035,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,32.079,34.426,-999.25,-999.25,-999.25,0.042,4.677,-999.25,2.773,-999.25,-999.25
 2406.000,-0.111,0.046,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,30.151,57.333,-999.25,-999.25,-999.25,0.025,4.777,-999.25,2.899,-999.25,-999.25
 2406.500,-0.100,0.005,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,22.290,37.435,-999.25,-999.25,-999.25,0.026,4.843,-999.25,2.881,-999.25,-999.25
 2407.000,-0.095,-0.002,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,13.807,16.677,-999.25,-999.25,-999.25,0.032,4.804,-999.25,2.873,-999.25,-999.25
 2407.500,-0.099,-0.003,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.184,14.849,-999.25,-999.25,-999.25,0.026,4.678,-999.25,2.880,-999.25,-999.25
 2408.000,-0.112,-0.001,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,26.949,50.894,-999.25,-999.25,-999.25,0.015,4.687,-999.25,2.901,-999.25,-999.25
 2408.500,-0.130,0.001,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,34.996,64.341,-999.25,-999.25,-999.25,0.005,4.833,-999.25,2.933,-999.25,-999.25
 2409.000,-0.140,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,49.968,57.762,-999.25,-999.25,-999.25,0.001,5.016,-999.25,2.949,-999.25,-999.25
 2409.500,-0.145,0.002,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,38.664,56.329,-999.25,-999.25,-999.25,-0.001,4.971,-999.25,2.958,-999.25,-999.25
 2410.000,-0.149,0.007,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,45.185,58.762,-999.25,-999.25,-999.25,0.001,4.973,-999.25,2.965,-999.25,-999.25
 2410.500,-0.133,0.039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,41.207,60.808,-999.25,-999.25,-999.25,0.008,4.641,-999.25,2.937,-999.25,-999.25
 2411.000,-0.095,0.054,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,25.533,75.167,-999.25,-999.25,-999.25,0.029,4.459,-999.25,2.873,-999.25,-999.25
 2411.500,-0.067,0.042,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.143,29.504,-999.25,-999.25,-999.25,0.076,4.407,-999.25,2.825,-999.25,-999.25
 2412.000,-0.057,0.041,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.987,3.001,-999.25,-999.25,-999.25,0.094,4.358,-999.25,2.808,-999.25,-999.25
 2412.500,-0.093,0.116,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.344,8.259,-999.25,-999.25,-999.25,0.068,4.382,-999.25,2.869,-999.25,-999.25
 2413.000,-0.118,0.128,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,30.595,29.165,-999.25,-999.25,-999.25,0.047,4.441,-999.25,2.911,-999.25,-999.25
 2413.500,-0.106,0.125,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,31.122,32.602,-999.25,-999.25,-999.25,0.052,4.345,-999.25,2.892,-999.25,-999.25
 2414.000,0.008,0.164,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.129,9.632,-999.25,-999.25,-999.25,0.079,3.885,-999.25,2.696,-999.25,-999.25
 2414.500,0.148,0.167,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,26.082,27.101,-999.25,-999.25,-999.25,0.144,3.438,-999.25,2.457,-999.25,-999.25
 2415.000,0.222,0.168,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.857,6.161,-999.25,-999.25,-999.25,0.239,3.201,-999.25,2.330,-999.25,-999.25
 2415.500,0.253,0.201,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.949,1.192,-999.25,-999.25,-999.25,0.321,3.043,-999.25,2.278,-999.25,-999.25
 2416.000,0.251,0.202,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.836,0.933,-999.25,-999.25,-999.25,0.350,3.082,-999.25,2.281,-999.25,-999.25
 2416.500,0.201,0.155,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.239,0.955,-999.25,-999.25,-999.25,0.284,3.432,-999.25,2.366,-999.25,-999.25
 2417.000,0.092,0.138,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.098,1.542,-999.25,-999.25,-999.25,0.148,3.791,-999.25,2.553,-999.25,-999.25
 2417.500,-0.006,0.093,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.977,6.228,-999.25,-999.25,-999.25,0.061,4.190,-999.25,2.720,-999.25,-999.25
 2418.000,-0.098,0.081,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.035,14.558,-999.25,-999.25,-999.25,0.032,4.800,-999.25,2.877,-999.25,-999.25
 2418.500,-0.069,0.112,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.930,17.109,-999.25,-999.25,-999.25,0.034,4.316,-999.25,2.828,-999.25,-999.25
 2419.000,0.107,0.112,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,26.254,21.359,-999.25,-999.25,-999.25,0.069,3.727,-999.25,2.527,-999.25,-999.25
 2419.500,0.209,0.115,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,11.287,9.016,-999.25,-999.25,-999.25,0.140,3.359,-999.25,2.353,-999.25,-999.25
 2420.000,0.246,0.128,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.111,2.233,-999.25,-999.25,-999.25,0.236,3.222,-999.25,2.289,-999.25,-999.25
 2420.500,0.248,0.211,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.901,1.480,-999.25,-999.25,-999.25,0.306,3.137,-999.25,2.286,-999.25,-999.25
 2421.000,0.249,0.198,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.804,1.417,-999.25,-999.25,-999.25,0.325,3.391,-999.25,2.284,-999.25,-999.25
 2421.500,0.202,0.152,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.782,1.672,-999.25,-999.25,-999.25,0.305,3.546,-999.25,2.365,-999.25,-999.25
 2422.000,0.177,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.228,1.432,-999.25,-999.25,-999.25,0.203,3.818,-999.25,2.408,-999.25,-999.25
 2422.500,0.077,0.106,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.072,1.816,-999.25,-999.25,-999.25,0.108,4.082,-999.25,2.578,-999.25,-999.25
 2423.000,-0.079,0.122,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.277,2.938,-999.25,-999.25,-999.25,0.066,4.799,-999.25,2.846,-999.25,-999.25
 2423.500,-0.105,0.078,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.287,6.243,-999.25,-999.25,-999.25,0.058,4.930,-999.25,2.890,-999.25,-999.25
 2424.000,-0.093,0.053,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.421,7.583,-999.25,-999.25,-999.25,0.075,4.891,-999.25,2.869,-999.25,-999.25
 2424.500,-0.109,0.058,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.191,7.528,-999.25,-999.25,-999.25,0.091,4.880,-999.25,2.897,-999.25,-999.25
 2425.000,-0.098,0.037,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.069,5.737,-999.25,-999.25,-999.25,0.072,4.783,-999.25,2.878,-999.25,-999.25
 2425.500,-0.073,0.115,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,17.512,29.456,-999.25,-999.25,-999.25,0.059,4.339,-999.25,2.836,-999.25,-999.25
 2426.000,0.046,0.066,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,33.219,45.499,-999.25,-999.25,-999.25,0.080,3.961,-999.25,2.632,-999.25,-999.25
 2426.500,0.102,0.022,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,16.620,18.874,-999.25,-999.25,-999.25,0.149,3.837,-999.25,2.535,-999.25,-999.25
 2427.000,0.128,0.066,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.090,1.258,-999.25,-999.25,-999.25,0.207,3.488,-999.25,2.492,-999.25,-999.25
 2427.500,0.166,0.140,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.085,6.881,-999.25,-999.25,-999.25,0.214,3.224,-999.25,2.426,-999.25,-999.25
 2428.000,0.176,0.139,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.711,7.225,-999.25,-999.25,-999.25,0.232,3.200,-999.25,2.409,-999.25,-999.25
 2428.500,0.212,0.079,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.994,1.232,-999.25,-999.25,-999.25,0.276,3.151,-999.25,2.348,-999.25,-999.25
 2429.000,0.205,0.067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.121,1.125,-999.25,-999.25,-999.25,0.263,3.190,-999.25,2.359,-999.25,-999.25
 2429.500,0.128,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.743,1.801,-999.25,-999.25,-999.25,0.170,3.477,-999.25,2.490,-999.25,-999.25
 2430.000,-0.013,0.081,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,22.470,16.286,-999.25,-999.25,-999.25,0.065,4.037,-999.25,2.732,-999.25,-999.25
 2430.500,-0.085,0.030,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,44.991,44.041,-999.25,-999.25,-999.25,0.022,4.374,-999.25,2.856,-999.25,-999.25
 2431.000,-0.123,0.011,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,35.826,46.326,-999.25,-999.25,-999.25,0.013,4.661,-999.25,2.920,-999.25,-999.25
 2431.500,-0.113,0.039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,33.844,41.475,-999.25,-999.25,-999.25,0.022,4.311,-999.25,2.904,-999.25,-999.25
 2432.000,-0.051,0.064,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,22.369,27.071,-999.25,-999.25,-999.25,0.056,3.903,-999.25,2.798,-999.25,-999.25
 2432.500,0.026,0.077,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.509,7.841,-999.25,-999.25,-999.25,0.126,3.492,-999.25,2.665,-999.25,-999.25
 2433.000,0.069,0.067,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.545,2.602,-999.25,-999.25,-999.25,0.198,3.504,-999.25,2.593,-999.25,-999.25
 2433.500,0.058,0.076,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.309,2.211,-999.25,-999.25,-999.25,0.192,3.560,-999.25,2.611,-999.25,-999.25
 2434.000,0.027,0.075,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.894,3.292,-999.25,-999.25,-999.25,0.118,3.641,-999.25,2.664,-999.25,-999.25
 2434.500,-0.025,0.098,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.865,12.283,-999.25,-999.25,-999.25,0.071,3.743,-999.25,2.752,-999.25,-999.25
 2435.000,-0.060,0.093,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.012,19.409,-999.25,-999.25,-999.25,0.069,4.041,-999.25,2.813,-999.25,-999.25
 2435.500,-0.036,0.038,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.179,7.151,-999.25,-999.25,-999.25,0.095,4.162,-999.25,2.772,-999.25,-999.25
 2436.000,-0.037,0.038,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.437,3.532,-999.25,-999.25,-999.25,0.098,4.230,-999.25,2.773,-999.25,-999.25
 2436.500,-0.050,0.037,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.701,5.548,-999.25,-999.25,-999.25,0.059,4.213,-999.25,2.796,-999.25,-999.25
 2437.000,-0.100,0.049,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,12.619,14.166,-999.25,-999.25,-999.25,0.031,4.456,-999.25,2.881,-999.25,-999.25
 2437.500,-0.116,0.076,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,16.104,19.085,-999.25,-999.25,-999.25,0.029,4.522,-999.25,2.909,-999.25,-999.25
 2438.000,-0.065,0.033,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,17.509,19.683,-999.25,-999.25,-999.25,0.052,4.449,-999.25,2.821,-999.25,-999.25
 2438.500,-0.063,0.030,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.549,7.897,-999.25,-999.25,-999.25,0.091,4.379,-999.25,2.818,-999.25,-999.25
 2439.000,-0.066,0.035,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.468,3.049,-999.25,-999.25,-999.25,0.080,4.319,-999.25,2.823,-999.25,-999.25
 2439.500,-0.093,0.051,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.958,16.061,-999.25,-999.25,-999.25,0.047,4.272,-999.25,2.869,-999.25,-999.25
 2440.000,-0.106,0.070,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,14.908,21.547,-999.25,-999.25,-999.25,0.040,4.381,-999.25,2.892,-999.25,-999.25
 2440.500,-0.020,0.052,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.547,18.486,-999.25,-999.25,-999.25,0.066,3.942,-999.25,2.744,-999.25,-999.25
 2441.000,0.068,0.099,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.438,9.654,-999.25,-999.25,-999.25,0.139,3.628,-999.25,2.593,-999.25,-999.25
 2441.500,0.135,0.084,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.511,2.107,-999.25,-999.25,-999.25,0.255,3.311,-999.25,2.479,-999.25,-999.25
 2442.000,0.144,0.109,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.791,1.151,-999.25,-999.25,-999.25,0.324,3.136,-999.25,2.464,-999.25,-999.25
 2442.500,0.151,0.114,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.380,1.173,-999.25,-999.25,-999.25,0.294,3.211,-999.25,2.453,-999.25,-999.25
 2443.000,0.112,0.139,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.939,1.978,-999.25,-999.25,-999.25,0.254,3.143,-999.25,2.518,-999.25,-999.25
 2443.500,0.115,0.110,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.342,2.432,-999.25,-999.25,-999.25,0.243,3.224,-999.25,2.513,-999.25,-999.25
 2444.000,0.143,0.084,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.007,2.595,-999.25,-999.25,-999.25,0.259,3.059,-999.25,2.465,-999.25,-999.25
 2444.500,0.135,0.095,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.574,1.398,-999.25,-999.25,-999.25,0.262,3.107,-999.25,2.479,-999.25,-999.25
 2445.000,0.129,0.109,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.083,1.708,-999.25,-999.25,-999.25,0.232,3.022,-999.25,2.490,-999.25,-999.25
 2445.500,0.094,0.113,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,3.846,3.824,-999.25,-999.25,-999.25,0.190,3.135,-999.25,2.550,-999.25,-999.25
 2446.000,0.070,0.063,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.464,3.835,-999.25,-999.25,-999.25,0.157,3.400,-999.25,2.591,-999.25,-999.25
 2446.500,0.039,0.039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.434,3.440,-999.25,-999.25,-999.25,0.118,3.617,-999.25,2.644,-999.25,-999.25
 2447.000,-0.014,0.039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,11.453,9.322,-999.25,-999.25,-999.25,0.063,3.979,-999.25,2.734,-999.25,-999.25
 2447.500,-0.078,0.030,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,20.054,26.838,-999.25,-999.25,-999.25,0.027,4.403,-999.25,2.843,-999.25,-999.25
 2448.000,-0.114,0.029,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.296,24.243,-999.25,-999.25,-999.25,0.016,4.662,-999.25,2.906,-999.25,-999.25
 2448.500,-0.102,0.056,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.629,20.683,-999.25,-999.25,-999.25,0.021,4.411,-999.25,2.884,-999.25,-999.25
 2449.000,-0.052,0.055,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.119,19.601,-999.25,-999.25,-999.25,0.046,4.184,-999.25,2.799,-999.25,-999.25
 2449.500,-0.020,0.050,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,9.567,10.397,-999.25,-999.25,-999.25,0.096,4.008,-999.25,2.745,-999.25,-999.25
 2450.000,-0.006,0.055,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.168,3.274,-999.25,-999.25,-999.25,0.135,3.851,-999.25,2.721,-999.25,-999.25
 2450.500,-0.015,0.068,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,19.967,18.612,-999.25,-999.25,-999.25,0.111,3.791,-999.25,2.736,-999.25,-999.25
 2451.000,-0.026,0.052,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.333,20.107,-999.25,-999.25,-999.25,0.074,3.847,-999.25,2.754,-999.25,-999.25
 2451.500,-0.033,0.023,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,15.997,20.436,-999.25,-999.25,-999.25,0.058,3.932,-999.25,2.767,-999.25,-999.25
 2452.000,-0.033,0.033,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,22.346,26.945,-999.25,-999.25,-999.25,0.057,3.768,-999.25,2.766,-999.25,-999.25
 2452.500,-0.013,0.039,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,30.308,35.131,-999.25,-999.25,-999.25,0.065,3.644,-999.25,2.732,-999.25,-999.25
 2453.000,0.008,0.044,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,28.214,33.193,-999.25,-999.25,-999.25,0.084,3.491,-999.25,2.696,-999.25,-999.25
 2453.500,0.027,0.044,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,10.490,10.947,-999.25,-999.25,-999.25,0.113,3.467,-999.25,2.663,-999.25,-999.25
 2454.000,0.041,0.070,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.093,3.414,-999.25,-999.25,-999.25,0.152,3.350,-999.25,2.640,-999.25,-999.25
 2454.500,0.052,0.112,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.259,3.713,-999.25,-999.25,-999.25,0.179,3.500,-999.25,2.621,-999.25,-999.25
 2455.000,0.075,0.127,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.146,4.105,-999.25,-999.25,-999.25,0.208,3.481,-999.25,2.582,-999.25,-999.25
 2455.500,0.132,0.186,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,1.853,1.749,-999.25,-999.25,-999.25,0.229,3.272,-999.25,2.485,-999.25,-999.25
 2456.000,0.272,0.189,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.089,6.686,-999.25,-999.25,-999.25,0.254,3.045,-999.25,2.244,-999.25,-999.25
 2456.500,0.317,0.215,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,4.491,6.667,-999.25,-999.25,-999.25,0.300,2.844,-999.25,2.169,-999.25,-999.25
 2457.000,0.368,0.185,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.563,0.977,-999.25,-999.25,-999.25,0.329,2.688,-999.25,2.081,-999.25,-999.25
 2457.500,0.358,0.203,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.856,0.896,-999.25,-999.25,-999.25,0.328,2.631,-999.25,2.098,-999.25,-999.25
 2458.000,0.279,0.191,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,0.898,0.922,-999.25,-999.25,-999.25,0.317,3.034,-999.25,2.234,-999.25,-999.25
 2458.500,0.199,0.153,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,2.818,1.387,-999.25,-999.25,-999.25,0.275,3.339,-999.25,2.369,-999.25,-999.25
 2459.000,0.095,0.156,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.208,3.783,-999.25,-999.25,-999.25,0.215,3.540,-999.25,2.548,-999.25,-999.25
 2459.500,0.010,0.135,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.397,4.164,-999.25,-999.25,-999.25,0.180,3.721,-999.25,2.693,-999.25,-999.25
 2460.000,-0.004,0.086,73.686,33.564,7.114,6.172,0.000,0.047,0.048,0.005,6.245,3.880,0.067,0.000,0.053,0.157,3.690,0.000,2.717,11.958,145.850
 2460.500,-0.009,0.074,62.652,30.967,8.103,7.088,0.000,0.052,0.042,0.010,6.923,4.396,0.121,0.001,0.062,0.138,3.560,0.001,2.725,12.875,146.994
 2461.000,0.003,0.043,58.316,28.997,8.818,8.293,0.000,0.054,0.040,0.013,10.986,9.385,0.171,0.002,0.067,0.123,3.445,0.003,2.705,14.647,145.673
 2461.500,0.013,0.030,57.442,29.437,8.901,9.277,0.000,0.057,0.037,0.016,15.812,15.348,0.270,0.003,0.072,0.120,3.372,0.006,2.688,19.950,144.835
 2462.000,0.009,0.050,55.856,28.387,8.410,9.130,0.000,0.058,0.034,0.017,19.708,21.459,0.315,0.004,0.075,0.123,3.415,0.007,2.695,31.603,142.480
 2462.500,0.006,0.076,53.748,30.463,7.830,8.097,0.000,0.058,0.031,0.016,20.989,20.148,0.283,0.004,0.074,0.129,3.433,0.006,2.700,46.412,143.554
 2463.000,0.008,0.131,55.919,36.234,7.463,6.881,0.000,0.057,0.030,0.014,10.153,9.355,0.210,0.002,0.071,0.145,3.429,0.004,2.697,30.943,146.882
 2463.500,0.043,0.115,57.056,43.960,7.195,6.081,0.000,0.052,0.030,0.010,3.446,3.141,0.104,0.001,0.062,0.177,3.613,0.001,2.637,18.026,150.623
 2464.000,0.055,0.089,63.938,50.049,6.991,5.782,15.000,0.046,0.031,0.008,2.624,2.447,0.061,0.000,0.054,0.207,3.729,0.001,2.616,11.156,152.883
 2464.500,0.044,0.151,70.125,49.211,6.856,5.788,0.000,0.041,0.031,0.006,3.373,1.948,0.022,0.000,0.047,0.185,3.660,0.002,2.636,7.437,151.385
 2465.000,0.101,0.091,69.392,45.914,6.726,6.139,0.000,0.035,0.032,0.005,14.424,17.128,0.009,0.000,0.040,0.140,3.613,0.002,2.537,9.193,150.063
 2465.500,0.056,0.091,73.494,38.945,6.783,6.620,0.000,0.028,0.033,0.004,8.573,12.863,0.002,0.000,0.031,0.128,3.950,0.003,2.614,12.253,148.192
 2466.000,0.047,0.084,75.255,30.316,7.140,7.274,0.000,0.017,0.032,0.003,2.683,1.779,0.001,0.000,0.020,0.115,3.866,0.003,2.630,14.254,147.549
 2466.500,0.090,0.128,64.091,27.687,7.811,7.855,0.000,0.011,0.031,0.003,11.017,10.943,0.000,0.000,0.013,0.113,3.521,0.003,2.556,22.937,147.590
 2467.000,0.100,0.137,65.809,32.107,9.019,8.165,0.000,0.004,0.029,0.003,10.614,14.849,0.000,0.000,0.007,0.141,3.655,0.001,2.538,23.968,148.269
 2467.500,0.128,0.079,71.420,34.036,10.899,8.790,0.000,0.003,0.027,0.002,2.444,2.794,0.000,0.000,0.005,0.191,3.681,0.001,2.491,24.682,149.561
 2468.000,0.115,0.085,68.511,32.856,12.971,10.457,0.000,0.002,0.024,0.002,1.895,1.638,0.000,0.000,0.004,0.172,3.779,0.000,2.514,19.651,151.385
 2468.500,0.067,0.088,67.405,29.331,15.058,14.497,0.000,0.001,0.022,0.002,5.341,5.763,0.000,0.000,0.003,0.067,3.967,0.000,2.596,16.234,154.323
 2469.000,-0.103,0.117,70.597,22.786,16.294,20.261,0.000,0.001,0.019,0.001,11.346,15.758,0.000,0.000,0.002,0.019,4.471,0.000,2.885,22.604,155.551
 2469.500,-0.145,0.036,70.225,13.750,17.049,24.809,0.000,0.001,0.017,0.001,12.067,16.271,0.000,0.000,0.001,0.005,4.990,0.000,2.958,44.414,154.907
 2470.000,-0.146,0.034,59.714,10.428,17.604,25.713,0.000,0.001,0.016,0.001,12.044,15.130,0.000,0.000,0.001,0.004,4.954,0.000,2.960,220.988,153.232
 2470.500,-0.135,0.101,51.177,12.814,18.241,23.646,0.000,0.001,0.016,0.001,11.417,16.566,0.000,0.000,0.001,0.011,4.591,0.000,2.941,971.648,151.686
 2471.000,-0.068,0.083,49.406,19.644,17.816,20.310,0.000,0.001,0.018,0.001,12.509,17.216,0.000,0.000,0.001,0.033,4.493,0.000,2.826,516.159,151.863
 2471.500,-0.036,0.160,51.308,27.157,16.468,16.273,0.000,0.000,0.020,0.001,7.016,9.300,0.000,0.000,0.001,0.072,4.030,0.000,2.772,72.636,152.624
 2472.000,0.113,0.156,54.400,36.641,14.439,13.208,0.000,0.001,0.024,0.001,2.883,2.613,0.000,0.000,0.001,0.121,3.791,0.000,2.517,30.244,153.946
 2472.500,0.150,0.184,55.967,43.927,12.226,11.435,0.000,0.001,0.027,0.001,4.063,4.212,0.000,0.000,0.002,0.188,3.648,0.000,2.454,24.650,153.869
 2473.000,0.164,0.192,65.764,47.135,10.392,10.007,0.000,0.001,0.032,0.001,1.968,1.380,0.000,0.000,0.002,0.224,3.701,0.000,2.430,20.121,153.167
 2473.500,0.197,0.130,71.378,47.509,8.943,9.560,0.000,0.001,0.035,0.001,3.483,1.985,0.000,0.000,0.002,0.221,3.509,0.000,2.372,23.703,152.382
 2474.000,0.097,0.224,73.542,44.774,7.872,8.697,0.000,0.001,0.041,0.001,1.289,1.797,0.000,0.000,0.002,0.195,3.673,0.000,2.545,18.692,151.172
 2474.500,0.096,0.189,75.844,45.751,7.095,7.698,0.000,0.001,0.045,0.001,4.240,5.220,0.000,0.000,0.002,0.182,3.802,0.000,2.545,17.659,152.877
 2475.000,0.090,0.181,73.850,49.878,6.413,6.615,0.000,0.001,0.050,0.001,2.261,3.795,0.000,0.000,0.002,0.201,3.691,0.000,2.556,14.910,153.733
 2475.500,0.100,0.171,76.655,50.831,5.911,5.821,0.000,0.001,0.053,0.001,1.075,1.372,0.000,0.000,0.001,0.227,3.701,0.000,2.539,13.037,154.294
 2476.000,0.119,0.183,71.670,55.088,5.494,5.313,0.000,0.001,0.056,0.001,2.922,3.204,0.000,0.000,0.002,0.223,3.455,0.000,2.507,12.876,154.736
 2476.500,0.092,0.186,73.803,61.446,5.283,4.924,0.000,0.001,0.057,0.001,3.196,3.614,0.000,0.000,0.002,0.219,3.576,0.000,2.553,10.891,154.960
 2477.000,0.098,0.158,82.931,66.143,5.316,4.632,0.000,0.001,0.059,0.001,2.224,1.771,0.000,0.000,0.002,0.221,3.477,0.000,2.542,10.843,153.379
 2477.500,0.099,0.145,76.566,68.309,5.599,4.525,0.000,0.001,0.060,0.001,2.832,2.236,0.000,0.000,0.002,0.231,3.463,0.000,2.541,10.946,153.379
 2478.000,0.100,0.084,78.498,69.750,6.121,4.743,0.000,0.001,0.060,0.001,1.534,1.653,0.000,0.000,0.002,0.239,3.546,0.000,2.539,8.670,152.636
 2478.500,0.072,0.057,84.070,62.447,6.812,5.460,7.000,0.001,0.059,0.001,0.847,1.531,0.000,0.000,0.002,0.187,3.745,0.000,2.587,8.394,153.243
 2479.000,0.003,0.077,79.445,48.136,7.550,6.838,0.000,0.001,0.055,0.002,8.539,7.424,0.000,0.000,0.003,0.081,4.092,0.000,2.704,10.164,154.370
 2479.500,-0.075,0.074,75.833,33.833,8.424,8.888,0.000,0.001,0.051,0.002,10.223,12.254,0.000,0.000,0.003,0.034,4.496,0.000,2.838,16.405,153.556
 2480.000,-0.103,0.028,70.528,21.980,9.474,11.721,0.000,0.002,0.045,0.002,9.832,13.649,0.000,0.000,0.004,0.015,4.699,0.000,2.887,33.278,151.579
 2480.500,-0.114,0.091,58.922,17.478,10.883,13.321,0.000,0.001,0.043,0.002,10.333,13.893,0.000,0.000,0.004,0.017,4.550,0.000,2.905,101.801,151.550
 2481.000,-0.073,0.140,51.820,19.603,12.635,13.391,0.000,0.001,0.041,0.002,10.330,12.512,0.000,0.000,0.003,0.033,4.211,0.000,2.835,257.483,151.302
 2481.500,-0.022,0.119,50.550,28.256,13.941,12.663,0.000,0.001,0.040,0.001,8.272,9.149,0.000,0.000,0.002,0.074,4.175,0.000,2.748,116.552,152.830
 2482.000,-0.014,0.112,55.433,35.428,13.592,12.179,0.000,0.001,0.041,0.001,3.463,3.739,0.000,0.000,0.002,0.137,4.089,0.000,2.734,36.164,152.765
 2482.500,-0.032,0.133,61.445,36.861,11.256,12.158,0.000,0.002,0.042,0.001,5.375,4.156,0.000,0.000,0.003,0.148,4.147,0.000,2.764,18.604,151.450
 2483.000,-0.067,0.144,62.666,35.453,8.689,11.651,0.000,0.003,0.047,0.001,13.444,14.163,0.000,0.000,0.003,0.104,4.098,0.000,2.825,17.130,149.591
 2483.500,-0.049,0.112,66.636,32.473,6.910,9.246,0.000,0.006,0.050,0.001,10.716,15.352,0.000,0.000,0.006,0.090,4.009,0.000,2.793,20.846,148.995
 2484.000,0.069,0.130,66.083,33.442,6.006,6.910,0.000,0.015,0.053,0.001,4.986,5.190,0.000,0.000,0.015,0.118,3.705,0.000,2.592,32.527,147.909
 2484.500,0.178,0.115,59.281,42.267,5.665,5.378,0.000,0.019,0.054,0.001,3.519,3.008,0.000,0.000,0.019,0.192,3.294,0.001,2.406,29.640,146.050
 2485.000,0.204,0.115,61.167,57.074,5.731,4.715,0.000,0.014,0.054,0.001,1.267,1.454,0.000,0.000,0.015,0.286,3.195,0.001,2.362,16.140,146.682
 2485.500,0.210,0.116,71.663,66.925,5.977,4.662,0.000,0.008,0.053,0.002,0.946,1.000,0.000,0.000,0.010,0.304,3.239,0.000,2.351,9.980,147.266
 2486.000,0.154,0.119,80.234,66.558,6.242,5.148,0.000,0.004,0.052,0.002,2.340,1.834,0.000,0.000,0.006,0.246,3.492,0.000,2.447,7.332,148.753
 2486.500,0.027,0.087,90.025,57.017,6.548,6.035,0.000,0.003,0.051,0.002,2.630,2.251,0.000,0.000,0.005,0.142,3.936,0.000,2.664,7.061,151.149
 2487.000,-0.030,0.009,83.523,40.728,7.007,7.289,0.000,0.003,0.050,0.002,9.767,10.902,0.000,0.000,0.005,0.060,4.299,0.000,2.761,10.943,150.482
 2487.500,-0.103,0.026,76.908,24.381,7.774,8.763,0.000,0.003,0.049,0.002,12.754,16.637,0.000,0.000,0.005,0.022,4.616,0.000,2.886,20.023,150.181
 2488.000,-0.112,0.023,62.552,13.888,9.025,10.252,0.000,0.002,0.046,0.002,13.461,16.271,0.000,0.000,0.005,0.014,4.380,0.000,2.902,44.276,149.201
 2488.500,-0.088,0.037,51.036,11.364,10.423,11.715,0.000,0.002,0.043,0.002,12.157,16.891,0.000,0.000,0.004,0.021,4.311,0.000,2.861,270.629,145.991
 2489.000,-0.063,0.035,51.473,16.379,10.916,11.935,0.000,0.001,0.040,0.002,11.735,15.942,0.000,0.000,0.003,0.043,4.282,0.000,2.818,209.948,142.911
 2489.500,-0.050,0.067,53.316,22.338,9.925,10.578,0.000,0.001,0.041,0.002,6.774,5.711,0.000,0.000,0.003,0.068,4.024,0.000,2.795,40.767,143.123
 2490.000,-0.010,0.064,56.094,28.851,8.010,8.962,0.000,0.001,0.044,0.002,6.385,5.009,0.000,0.000,0.003,0.087,3.647,0.000,2.726,22.589,145.018
 2490.500,-0.000,0.149,59.100,34.183,6.341,6.962,0.000,0.001,0.049,0.001,3.395,5.009,0.000,0.000,0.002,0.119,3.500,0.000,2.711,15.970,146.127
 2491.000,0.102,0.181,64.805,40.638,5.291,5.338,0.000,0.001,0.052,0.001,3.978,2.683,0.000,0.000,0.002,0.167,3.322,0.000,2.535,12.167,144.433
 2491.500,0.187,0.195,66.247,50.546,4.569,4.308,0.000,0.005,0.057,0.001,2.779,2.528,0.000,0.000,0.006,0.241,3.020,0.000,2.390,12.092,142.675
 2492.000,0.227,0.200,71.723,60.021,4.168,3.781,0.000,0.011,0.058,0.001,0.552,1.280,0.000,0.000,0.011,0.316,2.949,0.001,2.322,7.989,144.050
 2492.500,0.224,0.210,79.528,64.539,3.916,3.609,0.000,0.020,0.059,0.001,0.876,1.221,0.000,0.000,0.020,0.332,3.050,0.008,2.328,6.593,144.351
 2493.000,0.193,0.216,79.209,66.176,3.784,3.591,0.000,0.026,0.059,0.001,2.511,1.347,0.000,0.000,0.026,0.293,3.221,0.014,2.379,5.249,144.192
 2493.500,0.145,0.169,85.233,65.443,3.806,3.602,7.000,0.034,0.058,0.001,3.111,1.827,0.000,0.000,0.034,0.258,3.251,0.015,2.463,5.218,143.655
 2494.000,0.124,0.101,86.230,62.333,3.992,3.688,0.000,0.037,0.055,0.001,2.996,2.447,0.002,0.000,0.037,0.235,3.314,0.008,2.498,5.826,143.849
 2494.500,0.110,0.076,79.775,60.241,4.374,3.904,0.000,0.042,0.050,0.001,3.122,2.347,0.008,0.000,0.042,0.207,3.282,0.004,2.522,5.863,143.283
 2495.000,0.104,0.057,75.016,59.623,4.986,4.372,0.000,0.046,0.046,0.001,8.131,5.164,0.019,0.000,0.046,0.168,3.209,0.001,2.533,6.700,143.242
 2495.500,0.085,0.061,75.328,57.188,5.761,5.084,0.000,0.048,0.037,0.001,10.254,7.934,0.048,0.000,0.049,0.131,3.245,0.001,2.565,9.074,140.881
 2496.000,0.071,0.049,76.366,50.765,6.827,5.967,0.000,0.050,0.030,0.001,7.129,5.763,0.083,0.000,0.050,0.116,3.263,0.000,2.588,10.801,138.480
 2496.500,0.063,0.043,72.117,43.764,8.287,7.225,0.000,0.056,0.018,0.001,9.209,7.546,0.144,0.000,0.057,0.107,3.335,0.001,2.603,14.068,135.895
 2497.000,0.054,0.047,67.825,38.904,9.974,8.884,0.000,0.062,0.010,0.002,7.875,8.177,0.172,0.000,0.064,0.093,3.400,0.000,2.617,15.185,133.670
 2497.500,0.045,0.057,66.863,38.603,11.520,11.494,0.000,0.070,0.003,0.004,9.429,10.415,0.181,0.000,0.074,0.080,3.495,0.000,2.633,21.344,133.198
 2498.000,0.051,0.047,64.791,38.164,12.363,13.889,0.000,0.074,0.002,0.005,11.236,12.568,0.173,0.000,0.079,0.076,3.483,0.001,2.624,30.347,131.788
 2498.500,0.054,0.038,62.372,37.594,12.258,15.375,0.000,0.078,0.003,0.006,9.035,9.717,0.150,0.000,0.084,0.075,3.508,0.001,2.617,41.470,130.832
 2499.000,0.055,0.041,59.539,38.969,11.282,15.227,0.000,0.077,0.005,0.006,7.565,8.816,0.125,0.000,0.083,0.076,3.398,0.001,2.615,44.345,131.322
 2499.500,0.059,0.044,60.405,40.899,10.067,13.260,0.000,0.071,0.006,0.007,7.959,9.455,0.081,0.001,0.077,0.080,3.280,0.001,2.609,41.794,132.012
 2500.000,0.061,0.038,62.284,44.611,9.001,10.347,0.000,0.065,0.006,0.006,9.122,9.905,0.050,0.000,0.071,0.090,3.251,0.002,2.606,39.254,134.048
 2500.500,0.060,0.027,63.920,51.319,8.285,8.506,0.000,0.054,0.004,0.005,7.720,7.373,0.019,0.000,0.059,0.110,3.223,0.008,2.607,26.066,137.046
 2501.000,0.057,0.022,66.422,55.015,7.804,7.506,0.000,0.048,0.004,0.004,4.744,3.473,0.008,0.000,0.052,0.139,3.200,0.012,2.613,15.501,140.710
 2501.500,0.045,0.028,69.805,53.989,7.485,7.154,0.000,0.040,0.004,0.003,5.428,3.883,0.004,0.000,0.043,0.155,3.168,0.018,2.634,9.800,142.740
 2502.000,0.029,0.033,71.356,52.312,7.335,7.183,0.000,0.037,0.005,0.003,6.149,4.607,0.003,0.000,0.040,0.140,3.245,0.016,2.661,7.558,142.498
 2502.500,0.020,0.021,71.016,47.599,7.370,7.427,0.000,0.034,0.009,0.003,8.807,7.908,0.004,0.000,0.037,0.117,3.305,0.005,2.676,9.427,141.518
 2503.000,0.006,0.024,67.022,43.178,7.594,7.854,0.000,0.033,0.013,0.003,7.892,7.133,0.004,0.000,0.035,0.106,3.389,0.001,2.700,11.049,139.719
 2503.500,-0.008,0.034,62.172,41.314,7.882,8.457,0.000,0.033,0.017,0.003,8.413,7.347,0.005,0.000,0.036,0.095,3.464,0.000,2.724,12.708,138.592
 2504.000,-0.022,0.046,58.827,40.199,7.947,9.007,0.000,0.033,0.017,0.004,11.571,12.479,0.005,0.000,0.036,0.084,3.531,0.000,2.748,15.870,135.193
 2504.500,-0.013,0.030,57.195,39.075,7.547,8.979,0.000,0.031,0.017,0.004,12.481,14.248,0.006,0.000,0.035,0.078,3.594,0.000,2.732,19.130,135.724
 2505.000,-0.011,0.045,56.784,39.035,6.777,8.125,0.000,0.030,0.019,0.004,11.695,14.831,0.007,0.000,0.034,0.085,3.470,0.000,2.729,27.199,134.420
 2505.500,0.002,0.066,56.617,46.386,5.802,6.854,0.000,0.030,0.026,0.004,7.827,8.140,0.005,0.000,0.034,0.101,3.449,0.001,2.707,23.610,134.308
 2506.000,0.030,0.077,58.384,57.563,4.936,5.580,0.000,0.032,0.032,0.003,6.180,5.190,0.004,0.000,0.035,0.124,3.268,0.001,2.658,15.948,134.508
 2506.500,0.077,0.082,60.503,67.250,4.215,4.505,0.000,0.036,0.041,0.002,4.643,3.573,0.002,0.000,0.038,0.150,3.107,0.002,2.579,10.483,136.615
 2507.000,0.132,0.116,65.217,75.871,3.734,3.676,0.000,0.036,0.046,0.002,5.186,3.507,0.002,0.000,0.038,0.180,2.948,0.005,2.484,8.009,139.825
 2507.500,0.192,0.092,71.638,82.001,3.396,3.176,0.000,0.031,0.055,0.002,3.593,2.705,0.001,0.000,0.033,0.219,2.822,0.005,2.381,6.410,141.542
 2508.000,0.196,0.083,79.250,80.821,3.138,2.934,0.000,0.026,0.061,0.002,1.489,1.476,0.001,0.000,0.028,0.278,2.745,0.004,2.375,5.558,144.658
 2508.500,0.189,0.083,84.909,80.512,2.917,2.860,7.000,0.020,0.072,0.002,1.763,1.461,0.001,0.000,0.023,0.264,2.685,0.001,2.387,4.293,146.139
 2509.000,0.149,0.097,86.144,79.779,2.762,2.808,0.000,0.014,0.095,0.002,3.846,2.713,0.001,0.000,0.017,0.222,2.742,0.000,2.456,4.625,146.646
 2509.500,0.122,0.069,89.500,80.170,2.694,2.698,0.000,0.012,0.100,0.002,3.398,2.776,0.001,0.000,0.015,0.212,2.834,0.000,2.501,5.256,146.888
 2510.000,0.110,0.059,88.264,82.636,2.698,2.590,0.000,0.012,0.102,0.002,2.801,2.225,0.000,0.000,0.013,0.229,2.770,0.000,2.523,5.798,147.685
 2510.500,0.107,0.064,80.988,84.517,2.724,2.539,0.000,0.013,0.101,0.001,2.148,1.672,0.000,0.000,0.014,0.243,2.798,0.000,2.527,5.257,147.927
 2511.000,0.105,0.115,80.689,85.705,2.738,2.544,0.000,0.014,0.098,0.001,2.616,1.934,0.000,0.000,0.014,0.244,2.837,0.000,2.531,4.372,147.703
 2511.500,0.139,0.112,81.941,85.624,2.718,2.550,0.000,0.011,0.095,0.001,3.080,2.392,0.000,0.000,0.012,0.241,2.842,0.000,2.472,4.518,146.044
 2512.000,0.133,0.186,82.614,83.231,2.724,2.521,0.000,0.005,0.091,0.001,2.171,1.989,0.000,0.000,0.006,0.257,2.989,0.000,2.483,4.755,144.976
 2512.500,0.187,0.210,83.055,80.235,2.785,2.502,0.000,0.003,0.088,0.001,1.734,1.365,0.000,0.000,0.004,0.282,3.014,0.000,2.390,4.871,145.218
 2513.000,0.211,0.252,79.475,76.889,2.907,2.548,0.000,0.002,0.084,0.001,1.740,1.420,0.000,0.000,0.003,0.307,3.156,0.000,2.349,4.711,145.513
 2513.500,0.214,0.261,84.547,70.946,3.073,2.695,0.000,0.002,0.080,0.001,1.033,1.195,0.000,0.000,0.003,0.328,3.278,0.000,2.345,4.129,145.915
 2514.000,0.204,0.226,89.348,66.151,3.256,2.954,0.000,0.002,0.074,0.002,1.633,1.092,0.000,0.000,0.003,0.320,3.284,0.000,2.362,3.925,144.988
 2514.500,0.170,0.206,87.433,60.860,3.427,3.288,0.000,0.002,0.069,0.002,2.371,1.646,0.000,0.000,0.004,0.272,3.377,0.000,2.420,4.088,145.431
 2515.000,0.089,0.174,87.566,54.673,3.602,3.623,0.000,0.004,0.055,0.005,3.446,2.517,0.000,0.000,0.010,0.215,3.564,0.004,2.557,4.786,146.269
 2515.500,-0.011,0.186,83.456,47.420,3.862,3.850,0.000,0.006,0.046,0.009,2.759,2.406,0.001,0.000,0.015,0.168,3.659,0.016,2.729,5.482,146.699
 2516.000,0.021,0.147,73.067,43.960,4.256,3.980,0.000,0.008,0.041,0.012,6.124,5.201,0.003,0.001,0.020,0.130,3.504,0.027,2.674,6.990,146.404
 2516.500,0.038,0.146,66.508,43.024,4.875,4.144,0.000,0.011,0.033,0.017,5.966,7.915,0.026,0.002,0.028,0.132,3.538,0.049,2.645,9.845,146.009
 2517.000,0.069,0.121,70.508,40.500,5.660,4.568,0.000,0.014,0.028,0.020,1.537,2.425,0.087,0.004,0.033,0.165,3.567,0.042,2.593,9.197,143.708
 2517.500,0.078,0.114,69.616,39.409,6.520,5.409,0.000,0.017,0.023,0.024,2.680,1.912,0.258,0.008,0.040,0.199,3.386,0.069,2.577,8.989,141.336
 2518.000,0.052,0.113,67.391,37.154,7.354,6.795,0.000,0.019,0.019,0.026,7.455,6.003,0.442,0.011,0.045,0.167,3.389,0.080,2.621,8.914,138.544
 2518.500,0.004,0.095,74.791,32.831,8.365,8.561,0.000,0.023,0.014,0.028,9.198,10.349,0.831,0.016,0.051,0.125,3.512,0.127,2.704,13.491,134.797
 2519.000,0.015,0.051,71.280,28.159,9.673,10.485,0.000,0.025,0.010,0.029,8.123,9.894,1.174,0.018,0.054,0.098,3.549,0.097,2.685,25.185,129.729
 2519.500,0.016,0.048,58.084,25.554,11.617,13.255,0.000,0.030,0.004,0.030,8.897,10.319,1.621,0.019,0.059,0.084,3.500,0.048,2.683,57.964,124.731
 2520.000,0.014,0.055,52.733,23.942,14.436,16.728,0.000,0.032,0.001,0.030,7.768,9.149,1.756,0.020,0.062,0.077,3.585,0.034,2.686,65.927,121.562
 2520.500,0.016,0.058,52.917,21.785,17.431,21.558,0.000,0.035,0.000,0.030,6.892,9.045,1.628,0.021,0.065,0.072,3.637,0.041,2.683,74.109,121.881
 2521.000,0.023,0.061,53.231,20.767,19.927,26.046,0.000,0.036,0.000,0.031,6.861,9.437,1.489,0.022,0.066,0.071,3.538,0.042,2.670,80.603,121.060
 2521.500,0.031,0.057,56.780,21.899,21.682,28.072,7.000,0.039,0.001,0.031,6.431,9.584,1.404,0.022,0.070,0.076,3.540,0.039,2.657,79.327,119.922
 2522.000,0.040,0.052,57.080,25.033,22.358,28.085,0.000,0.040,0.004,0.030,6.264,9.281,1.416,0.021,0.070,0.082,3.489,0.035,2.641,64.395,119.892
 2522.500,0.052,0.047,58.331,27.735,21.738,27.611,0.000,0.039,0.007,0.029,7.089,9.754,1.367,0.018,0.068,0.086,3.355,0.031,2.621,52.939,120.317
 2523.000,0.055,0.046,59.134,30.251,19.177,26.833,0.000,0.039,0.011,0.027,6.422,9.725,1.301,0.013,0.065,0.084,3.226,0.022,2.616,43.474,120.140
 2523.500,0.062,0.046,59.275,30.039,15.397,24.766,0.000,0.040,0.012,0.023,7.163,10.537,1.162,0.008,0.063,0.079,3.164,0.014,2.604,45.958,120.158
 2524.000,0.066,0.047,60.192,29.942,11.786,20.387,0.000,0.043,0.013,0.018,6.811,10.264,1.035,0.004,0.061,0.077,3.104,0.018,2.598,53.273,120.411
 2524.500,0.075,0.074,59.039,33.279,9.202,14.393,0.000,0.046,0.013,0.015,6.605,9.355,0.748,0.002,0.060,0.084,2.992,0.034,2.581,59.054,119.692
 2525.000,0.092,0.126,58.848,39.507,7.505,9.246,0.000,0.052,0.016,0.011,6.802,9.396,0.536,0.001,0.063,0.100,2.890,0.057,2.552,57.258,123.521
 2525.500,0.130,0.129,60.373,46.768,6.468,6.561,0.000,0.058,0.018,0.011,6.042,7.472,0.270,0.001,0.068,0.135,2.776,0.086,2.488,33.140,130.797
 2526.000,0.147,0.176,65.958,56.822,5.871,5.136,0.000,0.071,0.020,0.012,1.211,1.860,0.168,0.002,0.083,0.183,2.753,0.099,2.459,16.283,136.827
 2526.500,0.185,0.166,69.964,62.879,5.408,4.563,0.000,0.082,0.020,0.013,2.021,1.505,0.112,0.003,0.096,0.238,2.659,0.120,2.394,8.935,138.267
 2527.000,0.162,0.192,77.284,62.944,5.050,4.399,0.000,0.104,0.019,0.014,1.061,1.291,0.138,0.006,0.119,0.271,2.718,0.116,2.433,4.813,135.966
 2527.500,0.167,0.162,86.791,61.511,4.780,4.447,0.000,0.125,0.014,0.017,2.590,1.989,0.351,0.011,0.142,0.246,2.740,0.160,2.425,4.191,129.811
 2528.000,0.179,0.163,83.992,56.822,4.652,4.477,0.000,0.129,0.013,0.018,5.772,5.582,0.718,0.014,0.147,0.196,2.791,0.357,2.405,6.638,122.825
 2528.500,0.214,0.103,84.122,49.854,4.747,4.459,0.000,0.140,0.010,0.018,6.222,7.513,2.191,0.016,0.158,0.169,2.700,0.317,2.344,9.378,116.452
 2529.000,0.233,0.082,87.300,44.937,5.049,4.447,0.000,0.150,0.009,0.016,3.804,4.843,3.794,0.014,0.167,0.158,2.652,0.269,2.312,10.949,111.790
 2529.500,0.260,0.068,80.639,43.691,5.406,4.524,0.000,0.161,0.011,0.015,3.334,4.079,6.795,0.012,0.176,0.160,2.584,0.171,2.266,10.555,109.371
 2530.000,0.280,0.061,83.369,43.235,5.749,4.638,0.000,0.166,0.014,0.014,3.818,4.777,8.588,0.011,0.180,0.160,2.517,0.215,2.232,9.055,107.955
 2530.500,0.300,0.039,93.402,46.386,5.913,4.729,0.000,0.167,0.020,0.014,4.113,4.851,10.109,0.012,0.181,0.158,2.398,0.260,2.196,8.860,105.878
 2531.000,0.320,0.019,93.125,50.489,5.810,4.723,0.000,0.163,0.024,0.014,3.964,4.777,10.110,0.010,0.177,0.157,2.330,0.322,2.163,8.749,102.184
 2531.500,0.323,0.021,95.680,53.932,5.527,4.641,0.000,0.156,0.032,0.012,3.170,3.846,8.418,0.008,0.168,0.160,2.304,0.271,2.157,7.930,102.160
 2532.000,0.323,0.034,99.248,53.794,5.215,4.470,0.000,0.148,0.037,0.011,3.224,3.976,6.646,0.005,0.159,0.165,2.264,0.201,2.157,7.493,103.158
 2532.500,0.297,0.048,103.156,53.330,4.871,4.258,0.000,0.129,0.046,0.008,3.753,4.193,3.838,0.002,0.136,0.169,2.361,0.125,2.202,6.944,104.456
 2533.000,0.257,0.065,106.534,51.571,4.519,4.016,0.000,0.120,0.049,0.006,3.029,3.987,2.484,0.001,0.126,0.179,2.478,0.063,2.271,6.786,106.657
 2533.500,0.234,0.066,101.900,53.419,4.143,3.764,0.000,0.112,0.051,0.005,3.998,4.688,1.090,0.001,0.116,0.191,2.568,0.030,2.309,7.138,110.852
 2534.000,0.172,0.139,96.927,56.041,3.764,3.463,7.000,0.087,0.053,0.002,4.074,4.869,0.586,0.000,0.089,0.206,2.735,0.043,2.415,7.387,117.544
 2534.500,0.157,0.138,93.741,61.226,3.408,3.182,0.000,0.073,0.053,0.002,3.925,4.131,0.195,0.000,0.075,0.225,2.868,0.067,2.441,7.416,123.309
 2535.000,0.146,0.174,88.144,65.622,3.114,2.917,0.000,0.051,0.051,0.003,3.674,3.001,0.085,0.000,0.054,0.265,2.957,0.155,2.461,6.490,129.888
 2535.500,0.189,0.193,84.664,69.318,2.919,2.700,0.000,0.040,0.050,0.003,2.880,1.893,0.023,0.000,0.043,0.293,2.923,0.243,2.386,5.183,136.544
 2536.000,0.241,0.225,82.483,73.535,2.821,2.518,0.000,0.034,0.048,0.003,2.666,1.948,0.007,0.000,0.037,0.318,2.906,0.374,2.299,4.406,140.863
 2536.500,0.276,0.187,87.542,78.094,2.806,2.433,0.000,0.038,0.047,0.003,1.101,1.084,0.002,0.000,0.041,0.359,2.835,0.449,2.239,3.829,141.719
 2537.000,0.259,0.166,92.427,79.583,2.842,2.481,0.000,0.042,0.046,0.003,0.538,0.904,0.002,0.000,0.045,0.376,2.813,0.423,2.267,3.512,140.031
 2537.500,0.226,0.147,93.077,76.498,2.875,2.663,0.000,0.071,0.035,0.002,1.450,1.088,0.004,0.000,0.073,0.333,2.890,0.464,2.324,3.039,137.099
 2538.000,0.156,0.146,92.744,68.455,2.912,2.912,0.000,0.083,0.028,0.002,4.859,2.934,0.005,0.000,0.085,0.265,2.993,0.363,2.444,3.552,137.128
 2538.500,0.072,0.133,92.528,57.074,3.000,3.096,0.000,0.092,0.024,0.001,6.177,5.087,0.008,0.000,0.094,0.228,3.125,0.184,2.587,4.943,134.137
 2539.000,0.065,0.103,81.619,48.779,3.188,3.202,0.000,0.106,0.020,0.001,4.555,5.752,0.013,0.000,0.107,0.197,3.027,0.031,2.599,6.900,129.687
 2539.500,0.062,0.113,68.722,43.146,3.470,3.307,0.000,0.112,0.017,0.001,6.571,7.022,0.037,0.000,0.113,0.179,3.044,0.001,2.604,8.102,126.731
 2540.000,0.064,0.107,67.489,42.551,3.818,3.478,0.000,0.107,0.010,0.001,7.959,8.576,0.069,0.000,0.108,0.173,2.979,0.002,2.601,8.570,124.914
 2540.500,0.055,0.110,68.003,43.480,4.103,3.693,0.000,0.104,0.005,0.003,6.394,7.376,0.169,0.000,0.107,0.174,3.023,0.006,2.616,7.874,124.318
 2541.000,0.069,0.088,68.392,45.409,4.265,3.886,0.000,0.105,0.002,0.004,4.938,5.977,0.253,0.000,0.109,0.171,2.912,0.007,2.592,7.980,121.255
 2541.500,0.084,0.065,69.145,45.539,4.312,4.020,0.000,0.108,0.000,0.004,5.347,6.350,0.348,0.000,0.112,0.167,2.811,0.006,2.567,8.431,116.375
 2542.000,0.085,0.056,69.553,44.920,4.309,4.082,0.000,0.110,0.000,0.004,5.614,6.579,0.371,0.000,0.114,0.168,2.788,0.005,2.565,9.596,114.015
 2542.500,0.084,0.055,70.098,45.100,4.325,4.067,0.000,0.114,0.000,0.006,5.425,6.811,0.414,0.001,0.120,0.169,2.829,0.005,2.566,10.748,112.976
 2543.000,0.073,0.059,70.188,44.489,4.416,4.038,0.000,0.117,0.000,0.007,5.225,6.324,0.466,0.001,0.124,0.173,2.845,0.006,2.585,10.848,110.398
 2543.500,0.072,0.058,69.548,43.382,4.561,4.057,0.000,0.119,0.000,0.009,7.098,7.254,0.558,0.003,0.128,0.175,2.939,0.006,2.586,10.280,107.772
 2544.000,0.077,0.066,69.652,43.805,4.723,4.162,0.000,0.118,0.000,0.012,7.222,7.103,0.621,0.004,0.129,0.180,3.007,0.010,2.579,9.272,107.583
 2544.500,0.087,0.070,69.920,43.634,4.907,4.317,0.000,0.112,0.000,0.016,5.254,5.844,0.743,0.009,0.129,0.181,3.016,0.023,2.562,8.795,107.312
 2545.000,0.096,0.067,70.470,45.930,5.161,4.470,0.000,0.108,0.000,0.019,4.339,5.046,0.890,0.013,0.127,0.180,3.031,0.049,2.547,8.904,104.999
 2545.500,0.101,0.072,71.083,48.624,5.546,4.651,0.000,0.091,0.000,0.028,5.161,5.519,1.227,0.028,0.119,0.175,3.071,0.203,2.537,9.389,102.107
 2546.000,0.111,0.078,71.052,50.016,6.157,4.922,0.000,0.079,0.000,0.034,6.777,6.667,1.483,0.046,0.113,0.175,3.054,0.516,2.521,9.395,100.213
 2546.500,0.131,0.058,71.588,49.308,7.025,5.421,0.000,0.071,0.000,0.039,5.825,5.999,1.950,0.066,0.110,0.167,3.046,0.991,2.486,9.106,98.549
 2547.000,0.158,0.045,71.686,48.649,8.147,6.166,7.000,0.064,0.000,0.045,5.372,5.334,2.402,0.107,0.109,0.152,3.110,2.146,2.439,9.503,98.466
 2547.500,0.194,0.040,71.269,46.304,9.617,7.176,0.000,0.061,0.000,0.048,4.474,5.622,3.415,0.135,0.109,0.138,3.070,3.446,2.379,11.144,97.628
 2548.000,0.213,0.046,71.989,44.790,11.452,8.477,0.000,0.058,0.000,0.053,4.057,5.283,4.137,0.193,0.111,0.127,3.109,5.423,2.345,13.210,95.740
 2548.500,0.230,0.038,73.109,46.630,13.866,10.152,0.000,0.057,0.000,0.056,4.170,5.216,5.256,0.244,0.113,0.118,3.126,7.012,2.317,15.112,93.657
 2549.000,0.233,0.050,72.628,50.196,17.067,12.752,0.000,0.059,0.000,0.061,5.076,5.884,6.335,0.336,0.120,0.114,3.143,8.028,2.311,16.916,91.899
 2549.500,0.232,0.047,71.616,51.962,20.925,15.362,0.000,0.061,0.001,0.064,5.625,6.627,9.016,0.399,0.125,0.116,3.209,8.435,2.314,19.084,89.969
 2550.000,0.215,0.067,72.089,53.582,25.098,17.939,0.000,0.066,0.001,0.067,4.874,5.833,11.765,0.481,0.133,0.125,3.308,7.383,2.342,21.723,91.799
 2550.500,0.228,0.065,71.769,54.819,29.367,20.103,0.000,0.070,0.001,0.068,4.569,5.696,16.742,0.529,0.138,0.129,3.288,6.495,2.321,24.674,92.117
 2551.000,0.242,0.052,71.011,52.263,33.174,21.775,0.000,0.076,0.001,0.071,5.133,5.992,20.368,0.605,0.146,0.131,3.253,4.933,2.297,25.742,89.208
 2551.500,0.251,0.035,71.330,49.675,36.260,23.139,0.000,0.078,0.001,0.072,4.893,5.929,25.365,0.661,0.150,0.130,3.203,4.099,2.281,27.124,86.753
 2552.000,0.228,0.061,72.147,44.668,38.433,24.510,0.000,0.081,0.004,0.076,4.522,5.704,27.667,0.823,0.157,0.128,3.152,3.299,2.320,29.118,86.606
 2552.500,0.206,0.062,71.802,39.010,39.614,25.858,0.000,0.083,0.004,0.078,3.987,5.593,28.353,0.891,0.161,0.129,3.070,3.347,2.358,31.568,87.355
 2553.000,0.202,0.044,70.697,34.989,39.783,26.974,0.000,0.084,0.004,0.078,4.426,5.323,27.855,0.897,0.162,0.129,2.974,3.841,2.365,31.832,86.169
 2553.500,0.211,0.029,70.670,30.577,39.071,27.587,0.000,0.083,0.005,0.076,4.662,5.556,27.885,0.833,0.159,0.138,2.854,4.574,2.350,31.857,85.107
 2554.000,0.227,0.049,69.930,26.677,38.178,27.242,0.000,0.081,0.006,0.075,4.198,5.667,29.254,0.756,0.156,0.144,2.743,6.499,2.322,31.883,86.323
 2554.500,0.261,0.045,69.505,24.162,37.985,26.212,0.000,0.079,0.004,0.071,4.288,5.678,33.435,0.638,0.150,0.154,2.682,9.812,2.264,32.921,86.370
 2555.000,0.284,0.035,70.967,21.687,38.832,25.170,0.000,0.076,0.003,0.070,4.274,5.017,36.934,0.580,0.146,0.169,2.679,13.802,2.225,33.454,87.119
 2555.500,0.281,0.039,73.230,20.254,40.513,24.858,0.000,0.072,0.001,0.068,4.465,4.688,41.584,0.533,0.141,0.183,2.759,19.210,2.230,32.110,86.358
 2556.000,0.255,0.057,76.103,20.539,42.172,25.283,0.000,0.069,0.000,0.068,4.322,4.492,43.615,0.532,0.137,0.179,2.877,24.078,2.274,29.378,86.069
 2556.500,0.237,0.058,77.383,21.785,43.255,25.941,0.000,0.064,0.000,0.070,4.961,5.412,43.824,0.598,0.134,0.163,2.977,27.339,2.304,30.802,86.759
 2557.000,0.224,0.053,75.806,23.234,44.100,26.288,0.000,0.063,0.000,0.072,4.696,6.014,41.534,0.675,0.135,0.159,3.060,25.325,2.328,35.510,88.246
 2557.500,0.233,0.034,73.106,22.078,45.372,26.409,0.000,0.064,0.000,0.075,4.006,5.198,36.435,0.784,0.139,0.164,3.080,21.334,2.311,39.857,87.644
 2558.000,0.237,0.038,69.648,20.759,47.212,26.447,0.000,0.064,0.000,0.076,4.722,5.840,33.725,0.826,0.140,0.162,3.069,21.698,2.306,43.594,88.122
 2558.500,0.245,0.036,68.305,19.033,48.882,26.529,0.000,0.064,0.000,0.077,4.491,5.689,32.254,0.853,0.140,0.160,3.045,26.168,2.291,39.988,88.010
 2559.000,0.253,0.039,69.650,17.087,49.670,26.241,0.000,0.065,0.000,0.076,4.184,5.035,34.058,0.841,0.141,0.156,3.045,31.971,2.278,38.555,90.542
 2559.500,0.276,0.019,71.111,17.910,48.887,25.493,0.000,0.069,0.000,0.075,3.984,4.876,41.600,0.785,0.144,0.155,2.975,31.216,2.238,38.163,90.081
 2560.000,0.293,0.008,71.970,19.464,47.308,24.493,0.000,0.070,0.000,0.074,3.925,4.636,47.944,0.725,0.143,0.157,2.950,32.872,2.209,37.233,89.456
 2560.500,0.299,0.006,72.967,20.311,45.829,23.386,0.000,0.067,0.000,0.071,3.356,4.430,54.620,0.610,0.137,0.152,2.910,37.026,2.198,37.527,88.771
 2561.000,0.289,0.010,73.917,23.543,44.645,22.695,7.000,0.064,0.000,0.068,3.457,4.648,57.708,0.533,0.133,0.142,2.977,37.650,2.217,37.256,88.111
 2561.500,0.277,0.013,75.666,25.765,43.335,22.435,0.000,0.064,0.000,0.065,3.547,4.780,61.268,0.431,0.129,0.135,2.946,31.296,2.236,35.724,87.544
 2562.000,0.254,0.036,76.406,27.613,41.038,22.553,0.000,0.064,0.001,0.063,4.384,5.460,60.514,0.378,0.126,0.134,3.034,23.737,2.275,35.793,86.706
 2562.500,0.235,0.059,76.828,27.914,37.809,22.465,0.000,0.063,0.003,0.060,4.479,5.582,53.305,0.319,0.123,0.136,3.124,17.737,2.308,33.880,87.279
 2563.000,0.228,0.071,76.411,28.786,34.915,21.808,0.000,0.062,0.004,0.059,4.344,5.416,49.085,0.301,0.121,0.137,3.139,14.631,2.320,33.216,87.060
 2563.500,0.231,0.075,75.556,27.678,33.474,20.551,0.000,0.061,0.004,0.059,4.296,5.571,46.754,0.301,0.121,0.140,3.109,12.678,2.316,32.696,86.854
 2564.000,0.232,0.071,74.423,28.053,33.463,19.275,0.000,0.062,0.005,0.060,4.786,6.217,44.980,0.321,0.123,0.146,3.133,11.072,2.313,33.422,86.258
 2564.500,0.232,0.060,73.584,29.087,34.611,18.391,0.000,0.066,0.005,0.063,4.879,6.084,37.833,0.392,0.129,0.150,3.130,8.986,2.314,31.497,86.559
 2565.000,0.235,0.039,73.122,31.374,35.264,18.254,0.000,0.069,0.004,0.066,3.877,5.220,32.476,0.460,0.135,0.148,3.144,8.227,2.309,28.535,87.273
 2565.500,0.230,0.036,71.239,31.041,33.834,18.805,0.000,0.074,0.002,0.069,4.203,5.685,26.493,0.568,0.143,0.139,3.206,8.066,2.318,27.556,88.671
 2566.000,0.231,0.029,69.692,32.066,31.266,19.534,0.000,0.077,0.001,0.071,3.745,5.526,24.734,0.619,0.148,0.133,3.233,8.593,2.315,27.260,90.872
 2566.500,0.243,0.026,69.150,36.454,29.278,19.417,0.000,0.082,0.000,0.072,3.821,5.290,24.542,0.646,0.153,0.128,3.237,8.173,2.294,31.718,88.400
 2567.000,0.262,0.026,67.866,42.861,29.029,18.199,0.000,0.082,0.000,0.071,4.282,5.844,25.526,0.621,0.153,0.139,3.208,7.989,2.262,37.128,86.476
 2567.500,0.271,0.023,69.511,48.030,30.432,16.980,0.000,0.079,0.001,0.069,3.953,5.168,28.957,0.548,0.148,0.163,3.186,8.212,2.248,34.095,84.712
 2568.000,0.253,0.037,73.719,52.320,32.152,16.638,0.000,0.077,0.002,0.067,3.669,3.876,32.576,0.484,0.143,0.177,3.192,7.978,2.278,25.778,86.446
 2568.500,0.232,0.045,75.142,51.807,32.290,17.351,0.000,0.074,0.002,0.062,4.099,4.596,38.490,0.360,0.136,0.167,3.213,8.275,2.313,20.500,87.166
 2569.000,0.214,0.046,76.988,48.071,30.728,18.280,0.000,0.075,0.001,0.062,5.296,6.150,40.647,0.360,0.137,0.149,3.197,7.597,2.344,19.959,86.877
 2569.500,0.200,0.050,77.270,43.667,28.902,18.746,0.000,0.078,0.000,0.063,5.048,6.021,40.564,0.397,0.141,0.141,3.163,6.304,2.368,23.790,86.570
 2570.000,0.215,0.052,71.991,41.526,27.610,18.598,0.000,0.083,0.000,0.066,4.482,5.825,39.233,0.486,0.149,0.138,3.041,5.122,2.343,28.901,86.305
 2570.500,0.231,0.050,68.197,40.305,26.555,18.220,0.000,0.086,0.000,0.069,5.130,6.047,36.801,0.556,0.154,0.136,2.905,5.056,2.314,28.239,87.727
 2571.000,0.248,0.046,69.195,40.199,25.189,17.624,0.000,0.088,0.000,0.072,5.701,6.246,34.033,0.655,0.160,0.138,2.908,6.079,2.286,26.641,88.111
 2571.500,0.260,0.045,70.680,40.777,23.252,16.479,0.000,0.089,0.001,0.073,4.865,5.560,28.492,0.698,0.162,0.150,2.808,8.447,2.265,24.203,87.025
 2572.000,0.263,0.056,72.756,38.001,21.318,14.938,0.000,0.091,0.002,0.072,4.578,5.124,25.571,0.663,0.163,0.163,2.766,10.413,2.260,22.356,87.314
 2572.500,0.284,0.040,74.659,36.373,19.660,13.521,0.000,0.093,0.003,0.069,3.877,4.758,25.157,0.588,0.162,0.169,2.703,12.659,2.224,20.104,86.842
 2573.000,0.291,0.046,75.900,33.076,18.355,12.437,0.000,0.093,0.004,0.065,3.919,4.408,27.214,0.451,0.157,0.177,2.668,14.772,2.212,17.340,86.960
 2573.500,0.302,0.038,76.442,27.963,17.420,11.777,0.000,0.092,0.003,0.061,3.615,3.868,32.276,0.366,0.153,0.175,2.640,16.519,2.193,14.805,89.792
 2574.000,0.303,0.036,77.892,25.790,16.449,11.528,0.000,0.095,0.002,0.052,3.877,4.267,37.133,0.213,0.147,0.170,2.667,14.380,2.193,13.421,90.878
 2574.500,0.290,0.032,79.892,25.090,15.481,11.538,7.000,0.098,0.001,0.047,4.370,4.611,46.078,0.153,0.145,0.161,2.692,11.078,2.214,12.508,90.648
 2575.000,0.267,0.029,79.736,25.008,14.578,11.593,0.000,0.101,0.001,0.041,3.666,4.684,51.058,0.100,0.142,0.151,2.847,7.870,2.253,13.328,90.542
 2575.500,0.244,0.039,78.925,25.969,13.912,11.471,0.000,0.103,0.001,0.037,4.623,5.246,50.269,0.074,0.140,0.137,2.895,5.411,2.294,14.809,91.787
 2576.000,0.236,0.030,76.680,27.947,13.636,11.187,0.000,0.107,0.001,0.030,4.989,6.136,45.021,0.042,0.137,0.136,2.958,3.058,2.307,15.911,90.612
 2576.500,0.233,0.026,73.964,27.239,13.606,10.488,0.000,0.110,0.002,0.025,4.631,5.925,34.660,0.026,0.135,0.136,3.061,1.576,2.311,16.099,90.335
 2577.000,0.234,0.019,73.147,26.034,13.423,10.260,0.000,0.115,0.004,0.017,4.288,5.327,28.668,0.010,0.131,0.138,3.119,0.646,2.310,14.316,90.536
 2577.500,0.219,0.029,72.719,25.472,12.642,10.086,0.000,0.116,0.006,0.011,4.308,5.478,21.114,0.004,0.127,0.138,3.217,0.283,2.336,13.133,91.179
 2578.000,0.196,0.028,74.023,24.422,11.196,9.809,0.000,0.118,0.010,0.005,4.201,5.796,17.526,0.001,0.123,0.137,3.268,0.089,2.374,12.746,92.943
 2578.500,0.162,0.041,74.464,24.227,9.466,9.187,0.000,0.118,0.012,0.003,4.533,6.350,13.778,0.000,0.121,0.133,3.327,0.023,2.434,14.058,94.613
 2579.000,0.141,0.039,72.892,29.005,7.793,8.175,0.000,0.115,0.017,0.002,4.882,7.025,11.826,0.000,0.117,0.135,3.356,0.003,2.469,15.680,97.770
 2579.500,0.121,0.044,70.638,34.891,6.477,6.827,0.000,0.109,0.023,0.002,4.947,7.133,9.079,0.000,0.111,0.142,3.309,0.000,2.503,17.139,101.735
 2580.000,0.110,0.042,68.658,42.853,5.508,5.501,0.000,0.094,0.034,0.001,4.767,6.154,7.170,0.000,0.095,0.149,3.248,0.000,2.522,16.412,106.326
 2580.500,0.104,0.044,67.080,49.292,4.782,4.456,0.000,0.080,0.041,0.001,5.164,6.257,4.430,0.000,0.081,0.160,3.107,0.000,2.532,14.884,111.891
 2581.000,0.097,0.040,67.803,56.366,4.241,3.757,0.000,0.057,0.053,0.002,4.631,4.577,2.903,0.000,0.059,0.174,3.058,0.000,2.544,11.079,120.311
 2581.500,0.097,0.032,70.000,61.877,3.830,3.365,0.000,0.041,0.061,0.002,2.968,2.543,1.331,0.000,0.043,0.192,3.019,0.000,2.545,7.837,129.788
 2582.000,0.101,0.035,71.647,65.085,3.516,3.168,0.000,0.019,0.073,0.003,2.717,2.137,0.757,0.000,0.022,0.208,2.922,0.000,2.538,5.270,137.459
 2582.500,0.104,0.032,74.353,69.994,3.295,3.069,0.000,0.009,0.078,0.003,3.032,2.506,0.346,0.000,0.012,0.216,2.889,0.000,2.532,3.876,143.531
 2583.000,0.105,0.030,76.480,72.314,3.173,3.020,0.000,0.002,0.085,0.004,3.083,2.403,0.183,0.000,0.006,0.209,2.902,0.000,2.530,3.755,149.107
 2583.500,0.109,0.026,77.442,73.901,3.142,3.002,0.000,0.001,0.089,0.004,3.198,2.462,0.050,0.000,0.005,0.207,2.918,0.000,2.524,4.031,153.497
 2584.000,0.100,0.035,77.236,72.379,3.180,3.023,0.000,0.001,0.093,0.003,3.046,2.491,0.015,0.000,0.004,0.208,2.934,0.000,2.539,4.241,156.123
 2584.500,0.096,0.038,77.198,70.783,3.250,3.081,0.000,0.001,0.095,0.003,3.077,2.347,0.002,0.000,0.004,0.211,2.954,0.000,2.547,4.310,155.515
 2585.000,0.094,0.037,77.891,70.718,3.321,3.155,0.000,0.001,0.095,0.002,3.207,2.377,0.001,0.000,0.003,0.200,2.998,0.000,2.549,4.356,152.683
 2585.500,0.092,0.040,77.009,70.148,3.385,3.219,0.000,0.001,0.094,0.001,3.643,2.617,0.000,0.000,0.002,0.193,3.006,0.000,2.553,4.509,151.514
 2586.000,0.090,0.045,75.586,71.410,3.448,3.268,0.000,0.001,0.090,0.001,3.629,2.650,0.000,0.000,0.002,0.193,3.072,0.000,2.557,4.740,149.089
 2586.500,0.093,0.042,74.967,74.015,3.524,3.318,0.000,0.001,0.089,0.001,2.734,2.510,0.000,0.000,0.002,0.193,3.145,0.000,2.551,4.768,148.121
 2587.000,0.087,0.042,75.059,74.121,3.613,3.393,0.000,0.001,0.088,0.001,2.593,2.266,0.000,0.000,0.002,0.193,3.243,0.000,2.561,4.611,149.656
 2587.500,0.084,0.043,75.686,72.827,3.703,3.513,0.000,0.001,0.084,0.001,3.384,2.572,0.000,0.000,0.001,0.185,3.312,0.000,2.567,4.538,152.954
 2588.000,0.079,0.041,77.398,72.379,3.783,3.662,7.000,0.001,0.082,0.001,3.401,2.768,0.000,0.000,0.001,0.176,3.411,0.000,2.575,4.537,153.397
 2588.500,0.073,0.039,77.148,71.052,3.861,3.802,0.000,0.001,0.081,0.001,3.784,3.119,0.000,0.000,0.002,0.167,3.446,0.000,2.585,4.870,153.503
 2589.000,0.075,0.036,75.577,69.041,3.929,3.913,0.000,0.001,0.081,0.001,3.950,3.244,0.000,0.000,0.003,0.162,3.466,0.000,2.582,5.356,150.505
 2589.500,0.076,0.035,75.059,70.238,3.988,3.982,0.000,0.002,0.079,0.002,3.469,3.001,0.000,0.000,0.004,0.170,3.469,0.000,2.580,5.558,149.839
 2590.000,0.072,0.069,74.420,70.287,4.009,4.010,0.000,0.002,0.078,0.002,3.044,2.687,0.000,0.000,0.004,0.176,3.469,0.000,2.588,5.587,150.488
 2590.500,0.096,0.056,73.677,71.923,3.955,4.010,0.000,0.003,0.074,0.002,3.705,3.012,0.000,0.000,0.005,0.184,3.428,0.000,2.547,5.535,150.505
 2591.000,0.094,0.059,75.230,73.918,3.841,3.952,0.000,0.004,0.071,0.003,3.170,3.019,0.000,0.000,0.007,0.195,3.320,0.000,2.549,5.290,149.667
 2591.500,0.097,0.068,75.788,76.173,3.702,3.830,0.000,0.006,0.064,0.004,3.105,2.835,0.000,0.000,0.010,0.202,3.252,0.000,2.545,5.164,147.520
 2592.000,0.090,0.083,74.372,78.118,3.586,3.651,0.000,0.009,0.060,0.004,4.249,3.396,0.000,0.000,0.013,0.193,3.105,0.001,2.556,5.262,145.153
 2592.500,0.107,0.063,75.652,79.201,3.518,3.471,0.000,0.020,0.054,0.004,4.164,3.289,0.000,0.000,0.024,0.190,2.984,0.002,2.527,4.990,141.288
 2593.000,0.116,0.060,76.259,75.741,3.500,3.369,0.000,0.034,0.050,0.004,3.714,2.772,0.000,0.000,0.038,0.191,2.763,0.004,2.512,4.734,139.093
 2593.500,0.123,0.073,74.623,68.748,3.509,3.355,0.000,0.059,0.041,0.003,4.575,3.019,0.000,0.000,0.063,0.186,2.588,0.007,2.500,4.153,136.839
 2594.000,0.132,0.086,74.847,62.390,3.549,3.413,0.000,0.076,0.034,0.003,6.898,5.744,0.000,0.000,0.079,0.171,2.516,0.013,2.485,4.253,132.048
 2594.500,0.155,0.080,75.525,55.666,3.631,3.496,0.000,0.086,0.030,0.003,5.656,6.848,0.000,0.000,0.089,0.148,2.448,0.025,2.445,5.765,125.982
 2595.000,0.187,0.069,74.520,51.767,3.777,3.583,0.000,0.096,0.025,0.003,5.943,6.586,0.001,0.000,0.099,0.137,2.353,0.044,2.390,7.580,119.438
 2595.500,0.225,0.051,74.519,53.208,3.970,3.692,0.000,0.108,0.020,0.003,5.431,6.235,0.002,0.000,0.111,0.126,2.290,0.080,2.326,9.157,113.596
 2596.000,0.249,0.046,76.098,54.828,4.203,3.847,0.000,0.120,0.015,0.002,4.969,5.759,0.004,0.000,0.122,0.121,2.283,0.153,2.285,9.628,107.878
 2596.500,0.274,0.025,79.797,56.122,4.432,4.032,0.000,0.122,0.011,0.003,4.477,5.393,0.017,0.000,0.124,0.116,2.287,0.315,2.241,9.412,103.966
 2597.000,0.284,0.016,83.478,56.366,4.649,4.204,0.000,0.120,0.006,0.003,4.530,5.253,0.039,0.000,0.123,0.113,2.276,0.588,2.224,9.523,101.971
 2597.500,0.279,0.018,86.075,56.293,4.856,4.346,0.000,0.118,0.003,0.003,4.541,5.515,0.105,0.000,0.121,0.112,2.331,0.564,2.233,9.625,103.264
 2598.000,0.254,0.033,87.133,54.567,5.021,4.455,0.000,0.114,0.001,0.002,4.437,5.356,0.182,0.000,0.116,0.112,2.459,0.406,2.276,9.494,103.895
 2598.500,0.214,0.052,86.723,55.935,5.091,4.552,0.000,0.108,0.000,0.001,4.769,5.475,0.332,0.000,0.109,0.107,2.607,0.179,2.344,9.419,105.506
 2599.000,0.166,0.067,84.783,59.045,5.079,4.635,0.000,0.099,0.000,0.001,7.261,7.066,0.422,0.000,0.100,0.101,2.790,0.093,2.427,9.262,108.386
 2599.500,0.115,0.085,81.366,66.656,5.047,4.673,0.000,0.093,0.000,0.001,8.607,7.731,0.478,0.000,0.093,0.103,2.943,0.071,2.514,9.585,114.469
 2600.000,0.069,0.098,76.545,83.760,5.037,4.674,0.000,0.082,0.000,0.001,6.588,5.375,0.454,0.000,0.083,0.113,3.173,0.077,2.592,8.943,120.364
 2600.500,0.050,0.092,71.817,104.364,5.043,4.662,0.000,0.075,0.000,0.001,5.780,4.035,0.350,0.000,0.075,0.132,3.275,0.066,2.624,8.385,125.516
 2601.000,0.065,0.067,68.273,118.488,5.028,4.680,15.000,0.068,0.000,0.001,4.786,3.200,0.258,0.000,0.068,0.151,3.239,0.071,2.599,6.760,128.844
 2601.500,0.082,0.053,67.970,123.413,4.938,4.716,0.000,0.067,0.000,0.001,4.463,3.089,0.133,0.000,0.068,0.166,3.189,0.087,2.569,5.816,129.976
 2602.000,0.094,0.047,69.530,113.099,4.826,4.714,0.000,0.070,0.000,0.001,7.982,5.356,0.078,0.000,0.071,0.171,3.289,0.128,2.549,5.269,128.395
 2602.500,0.105,0.033,71.098,94.106,4.764,4.624,0.000,0.075,0.000,0.002,8.708,7.565,0.036,0.000,0.076,0.175,3.370,0.150,2.531,6.617,124.217
 2603.000,0.112,0.062,71.333,74.357,4.844,4.441,0.000,0.084,0.000,0.002,7.717,6.667,0.024,0.000,0.085,0.171,3.375,0.108,2.519,7.871,122.270
 2603.500,0.136,0.042,69.767,62.162,5.031,4.355,0.000,0.088,0.001,0.001,12.672,10.035,0.018,0.000,0.089,0.164,3.545,0.051,2.478,9.666,124.406
 2604.000,0.122,0.035,70.956,57.278,5.225,4.472,0.000,0.086,0.002,0.001,8.398,7.317,0.019,0.000,0.087,0.162,3.739,0.028,2.501,9.560,126.684
 2604.500,0.109,0.030,72.561,55.129,5.362,4.821,0.000,0.080,0.002,0.001,4.313,2.591,0.023,0.000,0.081,0.143,3.906,0.029,2.524,7.424,128.554
 2605.000,0.079,0.046,68.247,53.248,5.430,5.252,0.000,0.070,0.001,0.001,10.651,6.911,0.025,0.000,0.070,0.117,3.844,0.071,2.576,7.565,129.027
 2605.500,0.060,0.044,70.320,50.879,5.520,5.509,0.000,0.063,0.001,0.001,9.632,7.280,0.024,0.000,0.063,0.105,4.046,0.096,2.607,7.646,129.109
 2606.000,0.068,0.030,69.145,45.669,5.706,5.577,0.000,0.055,0.002,0.002,8.182,7.217,0.021,0.000,0.057,0.116,3.983,0.082,2.595,8.496,126.076
 2606.500,0.078,0.042,62.925,39.922,5.924,5.605,0.000,0.053,0.003,0.004,10.231,9.824,0.013,0.000,0.057,0.136,3.908,0.083,2.576,9.375,122.648
 2607.000,0.088,0.059,64.058,35.200,6.082,5.727,0.000,0.060,0.003,0.007,7.650,8.155,0.009,0.000,0.067,0.141,3.845,0.066,2.559,8.565,116.924
 2607.500,0.101,0.056,66.314,32.579,6.130,5.880,0.000,0.070,0.003,0.010,7.557,8.078,0.006,0.001,0.080,0.138,3.857,0.055,2.537,9.514,112.009
 2608.000,0.108,0.053,67.413,31.741,6.178,5.952,0.000,0.086,0.002,0.013,6.991,8.643,0.006,0.004,0.099,0.136,3.842,0.037,2.525,12.185,108.309
 2608.500,0.111,0.054,67.756,33.955,6.374,5.977,0.000,0.093,0.001,0.015,6.661,7.779,0.014,0.005,0.108,0.143,3.832,0.024,2.520,14.208,107.241
 2609.000,0.112,0.050,68.392,35.453,6.819,6.112,0.000,0.098,0.001,0.017,5.848,7.029,0.031,0.008,0.115,0.147,3.876,0.013,2.518,14.693,106.486
 2609.500,0.109,0.041,69.334,35.485,7.387,6.453,0.000,0.098,0.001,0.018,6.067,6.726,0.128,0.009,0.116,0.137,3.909,0.015,2.524,13.082,105.949
 2610.000,0.106,0.036,69.838,34.370,7.880,7.042,0.000,0.095,0.002,0.018,7.103,8.222,0.286,0.010,0.114,0.116,3.924,0.016,2.530,13.046,104.869
 2610.500,0.099,0.045,69.867,32.490,8.161,7.741,0.000,0.093,0.004,0.018,8.227,9.651,0.621,0.009,0.112,0.101,4.051,0.016,2.542,15.099,104.031
 2611.000,0.102,0.041,68.889,30.764,8.236,8.347,0.000,0.091,0.006,0.018,8.151,10.197,0.865,0.008,0.108,0.099,4.167,0.014,2.536,20.188,101.240
 2611.500,0.108,0.046,66.355,32.359,8.262,8.636,0.000,0.091,0.005,0.017,7.309,9.307,1.173,0.008,0.108,0.106,4.146,0.015,2.525,25.870,97.510
 2612.000,0.120,0.046,65.617,33.247,8.300,8.505,0.000,0.094,0.003,0.017,6.661,8.207,1.327,0.008,0.111,0.116,3.992,0.020,2.505,26.507,94.979
 2612.500,0.125,0.054,66.548,35.778,8.345,8.116,0.000,0.098,0.002,0.017,6.737,7.808,1.396,0.009,0.116,0.128,3.955,0.026,2.496,22.573,95.988
 2613.000,0.133,0.053,68.331,39.466,8.364,7.689,0.000,0.104,0.001,0.018,6.098,6.981,1.358,0.010,0.122,0.142,3.925,0.021,2.483,17.732,95.103
 2613.500,0.142,0.042,69.945,39.425,8.347,7.426,0.000,0.105,0.000,0.019,5.834,6.693,1.326,0.011,0.123,0.148,3.933,0.021,2.467,14.773,93.651
 2614.000,0.138,0.035,71.538,37.976,8.338,7.408,0.000,0.101,0.000,0.021,6.110,6.989,1.365,0.014,0.122,0.137,4.019,0.026,2.475,13.193,93.203
 2614.500,0.126,0.029,72.355,34.671,8.394,7.641,0.000,0.097,0.000,0.022,6.101,7.203,1.436,0.017,0.119,0.120,4.250,0.031,2.494,13.101,94.118
 2615.000,0.109,0.023,70.877,28.924,8.579,8.060,0.000,0.087,0.000,0.025,6.507,8.155,1.462,0.020,0.112,0.100,4.301,0.038,2.524,15.757,94.312
 2615.500,0.088,0.027,68.705,26.384,9.020,8.556,7.000,0.080,0.000,0.026,7.602,9.510,1.548,0.019,0.106,0.089,4.475,0.037,2.560,20.392,93.049
 2616.000,0.081,0.026,66.434,25.497,9.739,9.117,0.000,0.071,0.000,0.025,10.746,12.660,1.683,0.016,0.096,0.086,4.510,0.034,2.572,26.379,93.368
 2616.500,0.079,0.033,63.950,24.845,10.627,9.737,0.000,0.068,0.000,0.025,10.927,13.638,1.875,0.015,0.093,0.097,4.473,0.035,2.575,29.431,94.749
 2617.000,0.085,0.029,63.039,26.376,11.506,10.430,0.000,0.065,0.000,0.025,6.985,9.281,1.907,0.016,0.090,0.105,4.412,0.046,2.565,23.854,93.356
 2617.500,0.099,0.025,63.441,25.700,12.201,11.561,0.000,0.062,0.000,0.027,7.773,9.462,1.796,0.017,0.088,0.099,4.402,0.097,2.541,21.351,91.816
 2618.000,0.117,0.018,64.122,23.966,12.757,12.279,0.000,0.057,0.000,0.030,8.024,9.765,1.692,0.023,0.086,0.091,4.368,0.273,2.511,22.045,91.804
 2618.500,0.141,0.006,65.139,21.174,13.354,13.026,0.000,0.056,0.000,0.031,6.830,8.798,1.505,0.027,0.087,0.086,4.436,0.514,2.470,25.488,92.371
 2619.000,0.160,-0.002,64.984,18.724,14.093,13.899,0.000,0.056,0.000,0.035,6.847,9.067,1.343,0.039,0.090,0.089,4.489,0.795,2.437,33.377,91.144
 2619.500,0.176,-0.005,66.473,17.104,14.930,14.964,0.000,0.054,0.000,0.037,7.092,8.842,1.151,0.048,0.091,0.095,4.518,1.266,2.409,34.969,89.226
 2620.000,0.180,-0.003,68.217,15.573,15.764,16.071,0.000,0.049,0.000,0.040,6.008,8.229,1.152,0.065,0.090,0.099,4.464,2.273,2.402,31.826,87.680
 2620.500,0.180,-0.001,69.256,14.490,16.519,17.028,0.000,0.047,0.000,0.042,6.194,8.325,1.408,0.078,0.089,0.101,4.447,3.000,2.402,28.441,88.819
 2621.000,0.178,0.005,70.639,15.419,16.995,17.678,0.000,0.047,0.000,0.044,6.487,8.525,1.714,0.094,0.092,0.097,4.520,2.934,2.406,25.631,90.565
 2621.500,0.174,0.012,70.672,16.273,17.001,18.088,0.000,0.049,0.000,0.045,6.785,9.067,2.461,0.098,0.094,0.097,4.537,2.236,2.412,25.889,90.990
 2622.000,0.163,0.021,69.202,16.094,16.424,18.267,0.000,0.050,0.000,0.044,6.250,8.790,3.359,0.094,0.094,0.093,4.539,1.491,2.431,26.809,89.775
 2622.500,0.160,0.016,68.723,16.835,15.283,18.095,0.000,0.051,0.000,0.043,6.188,8.237,5.564,0.086,0.094,0.088,4.520,0.987,2.437,25.490,89.721
 2623.000,0.145,0.020,67.813,18.992,13.787,17.224,0.000,0.052,0.000,0.041,7.326,9.389,7.135,0.070,0.093,0.083,4.531,0.652,2.463,27.262,90.418
 2623.500,0.121,0.033,67.556,21.719,12.205,15.660,0.000,0.053,0.000,0.039,7.529,9.817,8.752,0.059,0.092,0.084,4.531,0.450,2.504,28.171,91.970
 2624.000,0.115,0.026,66.744,23.632,10.634,13.576,0.000,0.056,0.001,0.035,7.455,9.425,8.999,0.039,0.091,0.090,4.359,0.266,2.513,29.806,94.424
 2624.500,0.116,0.022,65.706,26.832,9.224,11.461,0.000,0.060,0.001,0.031,6.706,8.440,8.379,0.027,0.091,0.096,4.323,0.149,2.512,29.135,97.499
 2625.000,0.119,0.021,65.127,29.722,7.994,9.163,0.000,0.066,0.000,0.025,6.135,7.878,7.414,0.015,0.091,0.099,4.275,0.075,2.506,24.755,100.809
 2625.500,0.114,0.023,64.655,34.647,7.061,7.576,0.000,0.069,0.000,0.022,6.090,7.764,5.749,0.010,0.091,0.104,4.055,0.058,2.516,22.407,104.302
 2626.000,0.103,0.028,65.513,42.820,6.331,6.446,0.000,0.070,0.001,0.018,6.228,7.576,4.763,0.006,0.088,0.111,3.931,0.040,2.534,19.662,109.318
 2626.500,0.087,0.031,66.813,50.212,5.761,5.696,0.000,0.072,0.002,0.016,7.095,7.421,3.516,0.004,0.087,0.123,3.970,0.027,2.562,15.442,114.351
 2627.000,0.068,0.036,67.481,57.221,5.257,5.254,0.000,0.074,0.002,0.011,7.388,5.486,2.785,0.002,0.085,0.128,3.924,0.020,2.594,10.889,119.107
 2627.500,0.057,0.044,67.220,62.651,4.785,4.911,0.000,0.075,0.003,0.008,9.964,7.107,1.830,0.001,0.083,0.125,3.600,0.020,2.612,7.943,119.756
 2628.000,0.072,0.037,67.139,62.724,4.388,4.564,0.000,0.077,0.006,0.005,13.948,12.180,1.374,0.000,0.082,0.119,3.403,0.010,2.587,7.226,119.945
 2628.500,0.088,0.042,67.269,64.735,4.059,4.211,0.000,0.080,0.010,0.004,9.972,10.090,0.883,0.000,0.084,0.117,3.301,0.004,2.559,8.150,120.057
 2629.000,0.107,0.043,67.375,65.565,3.779,3.892,0.000,0.087,0.015,0.002,7.250,7.000,0.633,0.000,0.089,0.125,3.053,0.000,2.527,8.193,120.417
 2629.500,0.119,0.050,68.858,64.881,3.533,3.612,0.000,0.090,0.018,0.002,8.314,8.004,0.330,0.000,0.092,0.126,2.806,0.000,2.507,8.229,120.276
 2630.000,0.126,0.048,72.561,66.363,3.339,3.334,0.000,0.090,0.023,0.002,5.473,5.855,0.188,0.000,0.092,0.123,2.692,0.000,2.494,7.516,121.137
 2630.500,0.126,0.053,76.158,68.537,3.214,3.089,7.000,0.088,0.027,0.002,5.935,5.648,0.085,0.000,0.089,0.124,2.607,0.001,2.495,7.848,124.265
 2631.000,0.121,0.090,77.164,71.076,3.157,2.913,0.000,0.078,0.035,0.002,7.030,5.342,0.053,0.000,0.079,0.134,2.600,0.001,2.503,7.549,129.670
 2631.500,0.133,0.086,77.694,76.954,3.139,2.853,0.000,0.067,0.042,0.001,5.558,3.595,0.026,0.000,0.068,0.154,2.596,0.001,2.483,6.097,136.013
 2632.000,0.137,0.087,78.630,83.931,3.126,2.894,0.000,0.048,0.053,0.001,2.644,2.078,0.019,0.000,0.050,0.184,2.656,0.001,2.475,4.635,140.450
 2632.500,0.135,0.090,79.780,87.708,3.097,3.007,0.000,0.037,0.060,0.001,1.816,1.694,0.014,0.000,0.038,0.193,2.740,0.000,2.479,3.663,145.673
 2633.000,0.115,0.105,79.489,89.043,3.055,3.105,0.000,0.020,0.069,0.002,2.990,2.126,0.011,0.000,0.022,0.188,2.882,0.000,2.513,3.611,146.711
 2633.500,0.092,0.131,80.416,87.952,3.016,3.119,0.000,0.011,0.073,0.002,3.916,2.680,0.007,0.000,0.013,0.179,3.115,0.000,2.552,4.082,146.593
 2634.000,0.102,0.107,80.866,81.904,2.982,3.056,0.000,0.001,0.080,0.002,3.153,2.805,0.005,0.000,0.003,0.191,3.096,0.000,2.536,4.616,145.655
 2634.500,0.096,0.108,78.720,75.717,2.944,2.959,0.000,0.001,0.086,0.002,1.571,1.590,0.003,0.000,0.003,0.211,3.154,0.000,2.546,4.572,144.811
 2635.000,0.090,0.116,78.075,67.592,2.882,2.885,0.000,0.001,0.091,0.001,1.709,1.646,0.002,0.000,0.002,0.222,3.168,0.000,2.556,4.212,144.628
 2635.500,0.074,0.128,78.164,64.271,2.788,2.811,0.000,0.001,0.098,0.002,2.697,1.960,0.001,0.000,0.003,0.229,3.238,0.000,2.584,3.781,144.882
 2636.000,0.066,0.128,79.900,64.556,2.681,2.722,0.000,0.001,0.102,0.002,2.838,1.956,0.000,0.000,0.003,0.230,3.277,0.000,2.598,3.596,145.106
 2636.500,0.069,0.106,80.116,65.093,2.590,2.618,0.000,0.001,0.103,0.002,2.700,2.214,0.000,0.000,0.003,0.234,3.301,0.000,2.592,3.696,146.038
 2637.000,0.072,0.101,77.155,67.625,2.535,2.527,0.000,0.002,0.102,0.002,2.779,2.100,0.000,0.000,0.004,0.247,3.355,0.000,2.587,3.673,146.056
 2637.500,0.073,0.100,76.863,70.922,2.521,2.473,0.000,0.002,0.099,0.002,2.928,1.985,0.000,0.000,0.004,0.258,3.371,0.000,2.585,3.575,146.056
 2638.000,0.072,0.099,78.580,71.313,2.539,2.464,0.000,0.002,0.097,0.002,2.678,1.841,0.000,0.000,0.004,0.252,3.311,0.000,2.587,3.472,144.841
 2638.500,0.080,0.120,78.478,73.657,2.584,2.493,0.000,0.003,0.095,0.002,1.917,1.561,0.000,0.000,0.005,0.241,3.284,0.000,2.574,3.406,143.401
 2639.000,0.115,0.172,78.166,78.590,2.642,2.554,0.000,0.003,0.094,0.002,1.228,1.620,0.000,0.000,0.005,0.237,3.292,0.000,2.513,3.484,144.398
 2639.500,0.170,0.162,78.697,80.796,2.698,2.648,0.000,0.002,0.095,0.002,1.470,1.679,0.000,0.000,0.005,0.242,3.203,0.000,2.419,3.597,145.797
 2640.000,0.188,0.153,79.478,79.779,2.734,2.763,0.000,0.002,0.097,0.002,0.949,1.450,0.000,0.000,0.004,0.250,3.099,0.000,2.389,3.550,145.484
 2640.500,0.179,0.165,79.827,78.297,2.742,2.863,0.000,0.002,0.097,0.002,1.092,1.712,0.000,0.000,0.004,0.226,3.163,0.000,2.403,3.715,142.775
 2641.000,0.149,0.176,79.711,76.213,2.733,2.878,0.000,0.002,0.096,0.002,1.602,2.056,0.000,0.000,0.004,0.198,3.259,0.000,2.456,4.038,141.253
 2641.500,0.097,0.154,80.125,75.684,2.715,2.809,0.000,0.001,0.092,0.002,2.424,2.056,0.000,0.000,0.003,0.194,3.309,0.000,2.545,4.291,141.713
 2642.000,0.092,0.106,78.534,78.761,2.681,2.700,0.000,0.001,0.089,0.001,2.717,2.008,0.000,0.000,0.002,0.206,3.181,0.000,2.553,4.339,143.407
 2642.500,0.094,0.107,77.367,81.879,2.620,2.611,0.000,0.001,0.086,0.001,2.663,1.878,0.000,0.000,0.002,0.225,3.186,0.000,2.549,3.852,146.156
 2643.000,0.084,0.123,78.408,79.893,2.538,2.541,7.000,0.001,0.085,0.001,2.711,1.948,0.000,0.000,0.002,0.237,3.272,0.000,2.567,3.482,149.237
 2643.500,0.088,0.130,79.720,78.273,2.453,2.471,0.000,0.001,0.085,0.001,2.728,2.170,0.000,0.000,0.002,0.242,3.238,0.000,2.560,3.415,149.355
 2644.000,0.093,0.139,80.117,73.820,2.395,2.392,0.000,0.001,0.086,0.001,2.348,2.111,0.000,0.000,0.002,0.238,3.254,0.000,2.551,3.525,147.496
 2644.500,0.099,0.170,78.600,72.110,2.380,2.322,0.000,0.003,0.086,0.001,2.249,2.056,0.000,0.000,0.004,0.248,3.229,0.000,2.540,3.633,145.714
 2645.000,0.116,0.194,77.808,74.113,2.405,2.294,0.000,0.006,0.085,0.001,1.878,1.672,0.000,0.000,0.006,0.257,3.307,0.000,2.512,3.541,145.183
 2645.500,0.134,0.170,80.405,73.527,2.456,2.335,0.000,0.009,0.083,0.001,1.154,1.166,0.000,0.000,0.009,0.271,3.310,0.000,2.481,3.303,141.796
 2646.000,0.115,0.188,83.092,70.889,2.525,2.442,0.000,0.010,0.081,0.001,0.757,0.974,0.000,0.000,0.010,0.274,3.355,0.000,2.513,3.053,140.445
 2646.500,0.115,0.169,82.306,70.279,2.605,2.582,0.000,0.008,0.077,0.002,2.064,1.679,0.000,0.000,0.010,0.247,3.298,0.000,2.513,3.150,141.318
 2647.000,0.090,0.176,83.294,69.717,2.713,2.708,0.000,0.007,0.075,0.002,3.840,2.620,0.000,0.000,0.009,0.224,3.430,0.000,2.557,3.760,141.896
 2647.500,0.116,0.108,83.628,70.930,2.849,2.835,0.000,0.005,0.073,0.003,2.148,1.686,0.000,0.000,0.008,0.209,3.221,0.000,2.512,4.008,140.492
 2648.000,0.112,0.097,77.105,72.078,3.006,2.987,0.000,0.005,0.073,0.003,2.883,2.056,0.000,0.000,0.008,0.196,3.159,0.000,2.518,4.130,140.120
 2648.500,0.106,0.092,76.241,72.753,3.151,3.181,0.000,0.006,0.072,0.004,3.930,3.112,0.000,0.000,0.009,0.172,3.187,0.000,2.530,3.955,141.690
 2649.000,0.089,0.088,77.319,70.441,3.288,3.344,0.000,0.008,0.071,0.004,5.051,3.909,0.000,0.000,0.012,0.149,3.121,0.000,2.559,4.528,141.979
 2649.500,0.090,0.075,74.530,67.779,3.416,3.433,0.000,0.012,0.068,0.004,5.479,4.208,0.000,0.000,0.016,0.146,3.069,0.000,2.556,5.601,142.079
 2650.000,0.102,0.053,72.839,68.838,3.546,3.483,0.000,0.018,0.065,0.003,3.680,2.997,0.000,0.000,0.021,0.166,2.962,0.000,2.536,6.027,140.592
 2650.500,0.104,0.059,73.309,68.594,3.653,3.561,0.000,0.034,0.057,0.002,3.162,2.310,0.000,0.000,0.036,0.186,2.856,0.000,2.533,5.437,140.574
 2651.000,0.112,0.065,72.334,68.545,3.683,3.675,0.000,0.048,0.052,0.002,6.937,4.673,0.000,0.000,0.049,0.177,2.728,0.001,2.519,4.896,137.783
 2651.500,0.118,0.094,76.895,68.390,3.659,3.724,0.000,0.064,0.045,0.002,8.061,6.213,0.000,0.000,0.066,0.170,2.556,0.002,2.508,5.028,136.332
 2652.000,0.131,0.124,79.517,68.854,3.632,3.669,0.000,0.073,0.041,0.001,7.185,7.092,0.001,0.000,0.074,0.175,2.629,0.004,2.486,6.549,134.514
 2652.500,0.148,0.124,75.105,70.140,3.643,3.561,0.000,0.085,0.034,0.001,6.611,6.283,0.001,0.000,0.086,0.188,2.618,0.004,2.456,7.796,133.729
 2653.000,0.147,0.133,75.392,71.085,3.721,3.506,0.000,0.090,0.029,0.001,3.415,3.388,0.001,0.000,0.091,0.195,2.629,0.006,2.459,7.012,133.989
 2653.500,0.144,0.138,76.822,72.745,3.848,3.569,0.000,0.092,0.024,0.001,4.111,2.971,0.001,0.000,0.093,0.187,2.628,0.018,2.464,5.719,134.231
 2654.000,0.118,0.158,78.386,71.720,4.027,3.719,0.000,0.092,0.022,0.001,5.921,4.263,0.001,0.000,0.093,0.174,2.686,0.048,2.508,4.590,129.198
 2654.500,0.155,0.091,80.097,67.820,4.288,3.924,0.000,0.096,0.018,0.001,5.783,5.552,0.001,0.000,0.097,0.161,2.591,0.063,2.445,5.104,119.025
 2655.000,0.188,0.072,77.352,63.457,4.660,4.168,0.000,0.099,0.017,0.001,5.313,6.006,0.002,0.000,0.099,0.147,2.435,0.075,2.389,6.945,109.713
 2655.500,0.218,0.062,76.352,59.956,5.236,4.517,0.000,0.096,0.016,0.003,4.949,6.139,0.003,0.000,0.099,0.130,2.434,0.148,2.337,8.784,103.877
 2656.000,0.240,0.054,77.945,54.673,6.006,5.056,7.000,0.092,0.016,0.007,4.539,5.918,0.007,0.001,0.099,0.114,2.396,0.338,2.299,10.204,99.192
 2656.500,0.254,0.042,78.981,53.777,7.043,5.866,0.000,0.084,0.014,0.017,4.606,5.763,0.028,0.007,0.102,0.102,2.439,0.837,2.275,11.336,94.796
 2657.000,0.264,0.026,79.267,52.100,8.236,6.966,0.000,0.078,0.012,0.025,5.133,6.088,0.068,0.018,0.104,0.095,2.530,1.422,2.259,12.558,91.763
 2657.500,0.255,0.024,79.169,52.532,9.387,8.261,0.000,0.069,0.010,0.034,5.296,6.461,0.231,0.043,0.103,0.091,2.692,2.675,2.274,14.354,89.544
 2658.000,0.252,0.014,79.009,54.421,10.205,9.383,0.000,0.063,0.008,0.039,5.093,6.638,0.480,0.061,0.101,0.087,2.860,3.849,2.280,16.678,87.515
 2658.500,0.242,0.014,77.575,55.935,10.545,9.865,0.000,0.059,0.006,0.042,5.259,6.785,1.226,0.083,0.101,0.089,3.103,5.305,2.296,18.961,85.237
 2659.000,0.233,0.012,76.002,59.964,10.408,9.645,0.000,0.058,0.006,0.045,5.048,6.782,1.893,0.100,0.102,0.095,3.331,5.676,2.311,19.269,83.821
 2659.500,0.233,0.012,74.916,71.353,9.906,8.964,0.000,0.058,0.006,0.048,5.499,6.878,2.949,0.132,0.106,0.104,3.525,6.153,2.311,18.529,83.738
 2660.000,0.233,0.018,74.244,84.964,9.278,8.153,0.000,0.058,0.006,0.050,5.777,7.099,3.635,0.160,0.109,0.114,3.579,6.846,2.312,17.948,85.266
 2660.500,0.232,0.031,74.900,96.077,8.754,7.417,0.000,0.061,0.006,0.054,4.952,6.512,4.713,0.209,0.115,0.120,3.575,7.262,2.314,17.099,85.349
 2661.000,0.248,0.029,74.914,105.552,8.464,6.856,0.000,0.064,0.006,0.056,5.518,7.114,5.689,0.245,0.121,0.125,3.512,8.368,2.286,17.000,83.360
 2661.500,0.259,0.030,74.980,106.977,8.400,6.531,0.000,0.069,0.005,0.059,4.865,6.435,7.862,0.302,0.128,0.135,3.531,9.213,2.266,15.137,81.814
 2662.000,0.261,0.044,76.406,99.715,8.528,6.436,0.000,0.075,0.001,0.063,4.246,5.622,9.966,0.390,0.138,0.146,3.389,10.835,2.265,13.475,81.201
 2662.500,0.269,0.045,77.269,88.579,8.823,6.514,0.000,0.077,0.000,0.064,4.178,5.268,13.915,0.410,0.141,0.154,3.270,12.153,2.250,12.094,80.835
 2663.000,0.264,0.049,79.081,75.676,9.284,6.737,0.000,0.081,0.001,0.064,4.136,5.412,17.211,0.416,0.145,0.154,3.316,11.354,2.258,11.476,81.266
 2663.500,0.274,0.035,80.591,63.514,9.938,7.091,0.000,0.083,0.001,0.063,4.257,5.327,23.256,0.399,0.146,0.153,3.298,10.206,2.242,11.194,81.885
 2664.000,0.265,0.044,81.102,53.501,10.735,7.618,0.000,0.084,0.002,0.060,4.417,5.404,27.649,0.343,0.144,0.150,3.278,8.730,2.256,11.329,81.785
 2664.500,0.265,0.040,80.842,47.680,11.614,8.289,0.000,0.084,0.002,0.058,3.871,5.153,34.439,0.294,0.142,0.143,3.268,7.235,2.258,11.237,80.363
 2665.000,0.258,0.033,80.697,43.569,12.557,9.030,0.000,0.086,0.001,0.050,3.804,5.116,38.621,0.180,0.136,0.133,3.462,5.278,2.270,11.350,79.242
 2665.500,0.245,0.026,80.739,42.047,13.521,9.768,0.000,0.087,0.002,0.045,4.319,5.545,43.679,0.125,0.132,0.127,3.577,3.442,2.290,12.279,78.734
 2666.000,0.223,0.033,79.134,44.456,14.484,10.478,0.000,0.087,0.002,0.039,4.308,6.051,44.788,0.076,0.126,0.126,3.738,2.165,2.329,13.884,78.663
 2666.500,0.207,0.032,77.764,43.797,15.371,11.578,0.000,0.085,0.002,0.036,4.516,6.446,42.829,0.059,0.121,0.120,3.919,1.471,2.356,16.289,80.080
 2667.000,0.191,0.025,76.597,45.848,16.066,12.239,0.000,0.081,0.001,0.034,4.761,6.856,39.513,0.046,0.115,0.112,4.058,1.238,2.384,19.214,80.345
 2667.500,0.181,0.024,74.816,46.435,16.528,12.786,0.000,0.078,0.000,0.033,5.040,7.443,33.184,0.043,0.111,0.104,4.163,1.036,2.401,22.068,79.655
 2668.000,0.174,0.019,73.039,44.717,16.937,13.117,0.000,0.074,0.000,0.035,5.231,7.915,28.149,0.046,0.108,0.103,4.228,1.011,2.413,25.034,79.572
 2668.500,0.170,0.020,72.300,45.327,17.496,13.255,0.000,0.071,0.000,0.036,5.535,7.716,20.239,0.053,0.107,0.102,4.231,1.083,2.419,27.218,79.726
 2669.000,0.172,0.022,71.234,44.790,18.204,13.338,7.000,0.068,0.000,0.040,5.507,7.672,15.623,0.070,0.108,0.104,4.263,1.522,2.415,29.603,79.590
 2669.500,0.178,0.029,70.569,40.769,18.969,13.520,0.000,0.067,0.000,0.042,5.327,7.491,10.510,0.086,0.109,0.106,4.150,2.299,2.406,29.147,80.209
 2670.000,0.197,0.031,70.994,40.077,19.497,13.898,0.000,0.067,0.000,0.045,4.845,6.819,8.355,0.110,0.112,0.111,4.091,3.718,2.372,25.768,81.572
 2670.500,0.228,0.027,70.852,39.987,19.888,14.315,0.000,0.067,0.000,0.047,5.175,7.096,6.530,0.126,0.114,0.116,3.866,6.094,2.320,24.343,83.036
 2671.000,0.259,0.025,72.845,42.486,20.487,14.610,0.000,0.070,0.001,0.049,5.392,6.704,6.170,0.150,0.119,0.119,3.656,9.040,2.266,22.412,83.006
 2671.500,0.290,0.015,75.039,50.212,21.528,14.805,0.000,0.071,0.001,0.050,4.544,5.397,6.430,0.166,0.122,0.122,3.570,12.899,2.214,21.938,81.153
 2672.000,0.306,0.014,75.928,60.030,23.160,15.155,0.000,0.073,0.002,0.051,3.669,4.714,7.159,0.179,0.124,0.122,3.503,16.854,2.187,20.965,79.554
 2672.500,0.325,0.004,77.803,66.648,25.166,15.798,0.000,0.073,0.002,0.052,3.221,4.481,8.895,0.190,0.125,0.118,3.357,22.647,2.155,19.672,79.537
 2673.000,0.331,-0.001,79.127,67.397,27.275,16.741,0.000,0.072,0.001,0.054,3.455,4.504,10.343,0.214,0.126,0.114,3.296,29.272,2.144,19.761,80.138
 2673.500,0.331,-0.004,79.236,64.312,29.649,17.890,0.000,0.070,0.000,0.055,3.981,4.570,12.798,0.236,0.126,0.115,3.298,34.097,2.145,20.852,80.929
 2674.000,0.332,-0.005,79.366,60.078,32.680,19.390,0.000,0.066,0.000,0.058,4.077,4.699,14.439,0.271,0.124,0.116,3.325,39.699,2.142,22.909,81.661
 2674.500,0.328,-0.001,78.341,55.129,36.890,21.647,0.000,0.063,0.000,0.059,4.111,5.120,15.992,0.295,0.122,0.116,3.363,39.736,2.149,25.923,81.230
 2675.000,0.315,-0.003,77.625,55.324,42.447,24.581,0.000,0.059,0.000,0.061,4.437,5.641,16.421,0.329,0.119,0.120,3.430,36.559,2.171,29.007,80.215
 2675.500,0.291,0.005,77.997,54.518,48.446,27.892,0.000,0.057,0.001,0.061,5.347,6.472,16.886,0.348,0.118,0.129,3.543,28.019,2.213,32.564,80.003
 2676.000,0.256,0.017,77.347,53.655,52.924,30.410,0.000,0.056,0.001,0.062,5.104,6.512,17.377,0.354,0.118,0.138,3.741,19.306,2.272,34.795,80.056
 2676.500,0.212,0.029,77.311,54.478,53.381,30.994,0.000,0.058,0.001,0.061,3.936,5.482,18.420,0.347,0.119,0.134,3.899,12.917,2.347,35.213,80.026
 2677.000,0.189,0.032,75.675,51.490,49.585,29.453,0.000,0.061,0.000,0.061,5.662,6.172,19.819,0.329,0.121,0.128,3.848,9.271,2.387,35.706,80.451
 2677.500,0.193,0.021,73.325,49.422,42.653,26.532,0.000,0.064,0.000,0.060,4.409,5.792,22.759,0.315,0.124,0.127,3.822,7.388,2.380,35.715,81.059
 2678.000,0.196,0.027,72.642,50.065,34.853,23.236,0.000,0.072,0.000,0.059,3.018,4.444,25.570,0.296,0.131,0.129,3.736,5.591,2.375,33.164,81.873
 2678.500,0.235,0.005,72.353,50.708,27.836,19.891,0.000,0.078,0.000,0.058,2.979,3.883,30.288,0.284,0.136,0.135,3.605,5.470,2.308,28.186,82.617
 2679.000,0.258,0.014,73.348,51.042,22.622,16.811,0.000,0.089,0.000,0.053,2.689,3.636,33.098,0.215,0.142,0.141,3.435,4.791,2.268,23.143,83.756
 2679.500,0.268,0.023,76.161,50.269,18.888,14.082,0.000,0.097,0.000,0.047,3.072,3.894,34.849,0.159,0.145,0.146,3.398,4.567,2.252,19.831,84.151
 2680.000,0.278,0.019,78.678,47.924,16.396,11.994,0.000,0.106,0.001,0.040,4.147,4.415,34.805,0.095,0.145,0.147,3.284,3.601,2.235,17.417,83.496
 2680.500,0.282,0.023,80.197,47.013,14.932,10.182,0.000,0.110,0.003,0.035,5.042,4.788,33.459,0.067,0.145,0.149,3.232,2.629,2.228,15.533,82.959
 2681.000,0.269,0.025,81.308,47.664,14.187,9.367,0.000,0.108,0.006,0.031,4.786,5.150,32.015,0.048,0.139,0.146,3.267,1.893,2.250,14.124,82.475
 2681.500,0.249,0.021,81.856,46.956,14.042,9.073,0.000,0.102,0.006,0.032,5.307,5.648,29.521,0.046,0.134,0.135,3.481,1.684,2.285,13.841,82.776
 2682.000,0.229,0.019,80.709,46.972,14.369,9.250,7.000,0.087,0.004,0.036,5.561,6.246,27.760,0.058,0.123,0.125,3.738,2.555,2.318,14.828,82.699
 2682.500,0.209,0.020,77.961,44.644,15.105,9.819,0.000,0.077,0.002,0.041,5.986,7.103,25.119,0.080,0.117,0.114,4.021,3.298,2.353,17.774,82.334
 2683.000,0.203,0.009,75.775,37.797,16.332,10.699,0.000,0.066,0.002,0.046,6.464,7.343,22.904,0.117,0.112,0.105,4.368,4.236,2.364,21.836,80.546
 2683.500,0.205,0.000,73.516,31.846,18.072,12.293,0.000,0.066,0.003,0.047,6.095,7.465,18.792,0.124,0.112,0.102,4.549,3.459,2.359,26.193,79.454
 2684.000,0.216,-0.001,72.252,30.251,20.204,13.804,0.000,0.065,0.005,0.047,5.867,7.901,15.958,0.130,0.113,0.103,4.601,2.875,2.341,29.570,79.141
 2684.500,0.219,-0.002,73.084,30.055,22.199,15.484,0.000,0.065,0.005,0.047,5.896,7.838,12.643,0.129,0.112,0.103,4.587,2.973,2.335,29.085,78.799
 2685.000,0.221,-0.005,73.561,32.099,23.564,16.927,0.000,0.063,0.002,0.046,5.881,7.664,11.138,0.118,0.109,0.104,4.465,3.725,2.332,28.958,78.038
 2685.500,0.218,-0.005,73.347,37.578,23.988,17.471,0.000,0.062,0.001,0.045,6.343,7.845,9.684,0.107,0.107,0.104,4.312,4.044,2.337,28.569,78.628
 2686.000,0.211,-0.001,73.433,43.870,23.588,17.331,0.000,0.062,0.000,0.043,5.893,7.985,9.461,0.088,0.105,0.104,4.329,3.848,2.349,28.616,78.315
 2686.500,0.206,0.002,73.216,46.239,22.674,16.896,0.000,0.062,0.000,0.041,6.112,7.937,9.669,0.077,0.103,0.102,4.314,3.480,2.358,29.129,78.864
 2687.000,0.205,-0.000,73.150,51.050,21.552,16.422,0.000,0.060,0.000,0.040,6.141,7.417,9.781,0.065,0.099,0.102,4.260,3.531,2.360,28.926,80.799
 2687.500,0.199,0.008,73.163,52.817,20.467,15.994,0.000,0.059,0.000,0.038,5.800,7.173,9.736,0.057,0.097,0.102,4.290,3.488,2.369,28.829,80.823
 2688.000,0.195,0.020,73.177,50.578,19.513,15.594,0.000,0.061,0.000,0.037,5.758,7.295,9.640,0.051,0.098,0.105,4.236,3.203,2.377,28.257,79.265
 2688.500,0.202,0.016,73.297,48.690,18.677,15.212,0.000,0.063,0.000,0.036,5.822,7.365,9.315,0.048,0.099,0.107,4.199,2.885,2.365,27.806,78.716
 2689.000,0.208,0.008,73.545,46.858,17.970,14.826,0.000,0.066,0.000,0.035,5.577,7.003,8.792,0.043,0.101,0.110,4.090,2.368,2.354,26.923,78.610
 2689.500,0.205,0.012,73.742,45.205,17.388,14.362,0.000,0.068,0.000,0.034,5.569,6.830,7.556,0.041,0.102,0.113,4.211,2.040,2.360,25.625,78.905
 2690.000,0.203,0.008,73.533,44.285,16.954,13.854,0.000,0.069,0.000,0.034,6.019,7.181,6.784,0.041,0.102,0.112,4.197,1.787,2.364,24.202,79.295
 2690.500,0.196,0.006,73.608,42.788,16.681,13.444,0.000,0.066,0.000,0.035,6.690,7.672,6.225,0.044,0.101,0.111,4.254,1.647,2.375,23.535,80.038
 2691.000,0.180,0.008,73.709,43.211,16.579,13.214,0.000,0.061,0.000,0.036,6.977,8.141,6.166,0.049,0.098,0.110,4.365,1.759,2.402,24.003,80.917
 2691.500,0.167,0.009,73.109,44.432,16.593,13.246,0.000,0.058,0.000,0.037,6.754,8.041,5.985,0.051,0.095,0.108,4.504,1.768,2.425,24.878,80.758
 2692.000,0.155,0.019,72.355,43.471,16.631,13.540,0.000,0.056,0.000,0.038,6.501,7.838,5.827,0.052,0.093,0.105,4.541,1.772,2.445,26.207,81.567
 2692.500,0.162,0.015,71.403,42.543,16.582,14.039,0.000,0.054,0.001,0.038,6.836,8.137,5.726,0.053,0.092,0.102,4.413,1.740,2.433,28.586,82.894
 2693.000,0.173,0.019,70.245,44.383,16.469,14.488,0.000,0.053,0.002,0.038,7.292,8.314,5.651,0.052,0.091,0.100,4.307,1.829,2.414,31.112,83.012
 2693.500,0.183,0.035,69.209,48.388,16.441,14.689,0.000,0.052,0.002,0.037,7.151,8.022,5.405,0.050,0.089,0.101,4.202,2.010,2.397,33.438,82.753
 2694.000,0.190,0.054,67.753,54.453,16.627,14.589,0.000,0.052,0.003,0.037,6.585,7.734,5.191,0.046,0.088,0.104,4.174,2.001,2.385,32.770,84.800
 2694.500,0.195,0.055,68.623,60.583,16.971,14.454,0.000,0.052,0.003,0.036,6.126,7.059,4.989,0.043,0.088,0.106,4.067,1.575,2.376,28.803,85.874
 2695.000,0.186,0.059,69.213,66.510,17.203,14.476,0.000,0.053,0.002,0.035,6.312,6.811,4.903,0.041,0.088,0.106,4.134,1.178,2.392,25.736,85.939
 2695.500,0.160,0.069,69.125,67.535,16.962,14.687,0.000,0.053,0.002,0.035,6.706,7.380,4.689,0.040,0.088,0.106,4.239,0.858,2.436,24.492,84.340
 2696.000,0.121,0.082,70.192,61.886,16.081,14.937,7.000,0.053,0.001,0.035,6.777,7.897,4.471,0.039,0.088,0.102,4.472,0.701,2.503,25.583,84.582
 2696.500,0.117,0.067,69.778,56.187,14.762,14.936,0.000,0.056,0.001,0.034,6.647,7.605,4.199,0.036,0.090,0.096,4.499,0.530,2.510,27.645,83.532
 2697.000,0.125,0.055,68.255,52.426,13.351,14.403,0.000,0.066,0.003,0.031,6.847,7.897,4.060,0.030,0.097,0.092,4.417,0.247,2.496,31.540,83.821
 2697.500,0.126,0.056,67.091,50.985,12.114,13.311,0.000,0.073,0.005,0.029,7.385,8.056,3.783,0.026,0.102,0.098,4.184,0.163,2.495,30.938,83.402
 2698.000,0.149,0.049,66.975,51.889,11.073,11.860,0.000,0.085,0.005,0.024,6.107,7.380,3.515,0.018,0.110,0.109,3.910,0.084,2.455,28.057,83.573
 2698.500,0.172,0.043,66.691,55.495,10.135,10.103,0.000,0.093,0.004,0.020,6.583,7.524,3.157,0.012,0.113,0.117,3.646,0.076,2.417,24.649,84.334
 2699.000,0.178,0.039,67.769,59.883,9.169,8.982,0.000,0.103,0.002,0.016,5.758,6.944,3.019,0.007,0.118,0.122,3.319,0.051,2.405,18.788,86.016
 2699.500,0.179,0.035,71.213,59.606,8.230,8.148,0.000,0.108,0.001,0.014,5.544,6.401,3.025,0.005,0.121,0.122,3.365,0.041,2.404,15.702,88.181
 2700.000,0.168,0.036,72.283,55.227,7.415,7.500,0.000,0.111,0.000,0.011,5.915,6.523,3.133,0.003,0.122,0.119,3.375,0.028,2.423,13.683,90.955
 2700.500,0.141,0.060,73.058,52.898,6.671,6.890,0.000,0.112,0.000,0.008,7.033,7.162,3.338,0.002,0.120,0.115,3.390,0.032,2.470,13.571,93.067
 2701.000,0.126,0.069,72.545,50.025,6.050,6.301,0.000,0.110,0.000,0.006,8.049,8.957,3.429,0.001,0.115,0.119,3.398,0.029,2.495,15.813,95.504
 2701.500,0.112,0.076,71.314,47.574,5.497,5.714,0.000,0.108,0.001,0.005,8.086,8.613,3.432,0.001,0.113,0.127,3.320,0.029,2.519,16.568,99.924
 2702.000,0.114,0.075,69.869,49.805,4.921,5.166,0.000,0.104,0.003,0.005,6.797,7.317,3.236,0.001,0.109,0.141,3.182,0.050,2.514,15.948,104.521
 2702.500,0.116,0.083,68.534,55.316,4.363,4.638,0.000,0.100,0.005,0.005,6.290,6.630,2.652,0.001,0.105,0.153,2.922,0.163,2.512,14.173,107.430
 2703.000,0.122,0.109,69.788,61.772,3.917,4.015,0.000,0.095,0.007,0.004,4.401,5.781,2.226,0.000,0.100,0.172,2.824,0.388,2.501,13.015,110.522
 2703.500,0.204,0.100,70.766,72.045,3.642,3.444,0.000,0.092,0.009,0.004,4.798,5.504,1.833,0.000,0.095,0.197,2.708,0.475,2.361,13.100,115.484
 2704.000,0.238,0.076,72.666,78.216,3.504,3.084,0.000,0.084,0.014,0.003,3.975,3.651,1.608,0.000,0.087,0.249,2.642,0.438,2.303,11.137,124.507
 2704.500,0.231,0.082,81.166,80.894,3.459,2.970,0.000,0.078,0.020,0.003,0.755,0.988,1.223,0.000,0.081,0.272,2.733,0.287,2.315,7.525,132.172
 2705.000,0.220,0.083,83.566,80.495,3.405,3.083,0.000,0.066,0.032,0.003,3.359,1.993,0.996,0.000,0.069,0.237,2.776,0.119,2.334,4.925,136.798
 2705.500,0.140,0.114,84.569,76.555,3.296,3.257,0.000,0.056,0.040,0.003,5.614,4.326,0.800,0.000,0.059,0.196,2.886,0.056,2.470,4.183,137.831
 2706.000,0.101,0.060,89.820,73.657,3.179,3.338,0.000,0.041,0.051,0.003,5.217,4.204,0.681,0.000,0.044,0.171,2.851,0.015,2.538,5.186,140.268
 2706.500,0.081,0.095,78.934,74.789,3.090,3.251,0.000,0.034,0.057,0.003,4.575,3.267,0.443,0.000,0.036,0.167,2.854,0.006,2.572,6.279,141.400
 2707.000,0.097,0.147,71.100,81.049,3.069,3.069,0.000,0.029,0.061,0.002,4.201,3.185,0.294,0.000,0.031,0.183,2.931,0.002,2.545,6.428,142.651
 2707.500,0.147,0.125,71.209,85.095,3.101,2.916,0.000,0.029,0.060,0.002,2.990,2.369,0.135,0.000,0.030,0.226,2.782,0.003,2.459,5.612,145.962
 2708.000,0.163,0.119,75.798,84.631,3.136,2.832,0.000,0.037,0.060,0.001,1.166,1.280,0.088,0.000,0.038,0.262,2.656,0.004,2.431,4.684,147.443
 2708.500,0.164,0.123,78.917,84.826,3.122,2.834,0.000,0.047,0.060,0.001,1.650,1.236,0.047,0.000,0.049,0.254,2.633,0.004,2.430,3.746,145.384
 2709.000,0.142,0.134,79.995,79.486,3.059,2.881,0.000,0.063,0.062,0.002,4.375,2.643,0.028,0.000,0.064,0.232,2.633,0.004,2.467,3.355,141.170
 2709.500,0.142,0.083,87.155,73.991,2.994,2.907,7.000,0.072,0.062,0.002,5.867,4.803,0.012,0.000,0.074,0.212,2.505,0.002,2.468,3.868,138.456
 2710.000,0.137,0.076,84.742,69.546,2.981,2.906,0.000,0.084,0.057,0.003,6.495,6.302,0.006,0.000,0.087,0.198,2.466,0.001,2.476,5.078,136.703
 2710.500,0.140,0.087,77.791,67.983,3.065,2.913,0.000,0.092,0.050,0.003,5.327,6.136,0.003,0.000,0.095,0.196,2.512,0.000,2.471,6.323,134.697
 2711.000,0.130,0.121,77.544,64.702,3.269,2.964,0.000,0.097,0.034,0.004,5.203,5.692,0.002,0.000,0.102,0.192,2.631,0.004,2.488,7.193,132.425
 2711.500,0.122,0.134,78.725,63.367,3.608,3.097,0.000,0.095,0.024,0.006,6.791,6.826,0.002,0.001,0.101,0.188,2.853,0.014,2.502,7.740,131.487
 2712.000,0.116,0.134,79.064,56.244,4.098,3.358,0.000,0.087,0.011,0.009,7.391,6.209,0.002,0.002,0.096,0.192,3.105,0.062,2.511,7.205,131.405
 2712.500,0.116,0.126,77.327,47.517,4.740,3.830,0.000,0.080,0.006,0.013,5.501,4.249,0.003,0.003,0.093,0.187,3.436,0.092,2.512,6.090,130.124
 2713.000,0.108,0.119,74.147,38.449,5.510,4.588,0.000,0.069,0.002,0.020,6.253,6.974,0.006,0.009,0.090,0.154,3.746,0.216,2.526,7.069,125.226
 2713.500,0.113,0.085,72.106,29.836,6.379,5.633,0.000,0.061,0.001,0.026,6.171,8.244,0.013,0.016,0.087,0.120,4.152,0.315,2.517,10.310,117.614
 2714.000,0.116,0.053,69.109,22.338,7.510,6.974,0.000,0.050,0.000,0.034,5.420,7.912,0.025,0.035,0.084,0.100,4.432,0.561,2.511,17.167,112.445
 2714.500,0.107,0.063,65.847,20.230,8.956,8.612,0.000,0.046,0.000,0.039,6.357,9.333,0.056,0.055,0.084,0.091,4.567,0.785,2.528,28.992,107.441
 2715.000,0.118,0.051,65.128,20.173,10.666,10.526,0.000,0.046,0.000,0.042,6.774,10.253,0.090,0.079,0.088,0.088,4.608,0.918,2.509,36.336,105.506
 2715.500,0.139,0.032,65.352,19.692,12.474,12.722,0.000,0.047,0.000,0.045,6.129,8.632,0.188,0.104,0.093,0.091,4.501,1.462,2.473,36.867,103.529
 2716.000,0.163,0.019,65.688,21.264,14.046,13.831,0.000,0.049,0.000,0.050,6.281,8.111,0.314,0.154,0.099,0.098,4.444,2.637,2.432,33.202,99.452
 2716.500,0.183,0.020,66.094,24.951,15.290,14.179,0.000,0.050,0.000,0.053,5.715,8.081,0.768,0.198,0.104,0.106,4.279,5.392,2.397,28.194,94.678
 2717.000,0.221,-0.003,68.086,28.085,16.212,14.202,0.000,0.052,0.000,0.058,5.532,7.664,1.413,0.282,0.110,0.113,4.097,9.896,2.333,24.624,91.090
 2717.500,0.250,-0.010,70.153,31.073,16.893,14.363,0.000,0.053,0.000,0.061,4.744,7.062,2.820,0.346,0.115,0.116,3.893,16.487,2.282,23.071,91.037
 2718.000,0.274,-0.008,71.084,33.222,17.503,14.974,0.000,0.055,0.001,0.065,4.167,6.047,4.051,0.449,0.120,0.117,3.696,22.472,2.242,20.460,89.503
 2718.500,0.289,-0.003,72.947,33.165,18.222,16.026,0.000,0.055,0.002,0.067,4.437,5.962,6.402,0.513,0.122,0.117,3.494,28.660,2.215,19.465,87.196
 2719.000,0.292,-0.001,75.523,32.498,19.080,17.323,0.000,0.055,0.003,0.070,4.674,6.025,8.792,0.593,0.125,0.120,3.465,33.129,2.211,19.018,84.470
 2719.500,0.274,0.025,77.277,32.726,20.133,18.414,0.000,0.056,0.003,0.070,5.037,6.246,13.906,0.615,0.127,0.124,3.406,36.740,2.242,21.033,85.190
 2720.000,0.259,0.057,77.600,31.814,21.122,18.837,0.000,0.061,0.005,0.070,4.598,6.143,18.454,0.596,0.131,0.130,3.369,33.205,2.266,23.402,86.860
 2720.500,0.272,0.061,77.706,31.830,21.662,18.579,0.000,0.065,0.005,0.069,4.609,5.995,26.494,0.553,0.134,0.139,3.274,28.767,2.245,24.340,88.825
 2721.000,0.300,0.048,77.069,32.888,21.594,17.957,0.000,0.072,0.004,0.066,4.493,5.626,32.304,0.476,0.138,0.145,3.244,23.509,2.197,23.413,90.105
 2721.500,0.313,0.046,77.095,33.426,21.130,17.382,0.000,0.078,0.002,0.064,3.598,4.851,42.298,0.419,0.142,0.145,3.225,19.420,2.174,20.688,90.730
 2722.000,0.310,0.047,78.288,35.396,20.585,17.031,0.000,0.088,0.000,0.059,3.615,4.489,49.460,0.321,0.147,0.137,3.169,12.825,2.180,18.485,89.645
 2722.500,0.300,0.040,78.823,38.742,20.183,16.845,0.000,0.094,0.000,0.055,4.398,5.220,59.155,0.257,0.149,0.125,3.139,8.337,2.198,17.449,89.161
 2723.000,0.270,0.047,77.784,39.930,19.853,16.757,7.000,0.094,0.000,0.050,4.814,6.224,61.254,0.180,0.144,0.120,3.206,5.323,2.248,17.957,88.630
 2723.500,0.234,0.066,75.891,40.638,19.521,16.713,0.000,0.092,0.001,0.047,4.423,6.257,55.811,0.148,0.139,0.118,3.375,3.316,2.311,19.865,89.822
 2724.000,0.214,0.066,74.208,40.199,19.108,16.684,0.000,0.090,0.002,0.041,4.941,6.435,47.561,0.093,0.131,0.120,3.464,1.923,2.344,21.658,89.780
 2724.500,0.200,0.058,71.848,39.328,18.661,16.609,0.000,0.089,0.003,0.037,5.791,7.332,36.550,0.065,0.126,0.119,3.558,1.140,2.369,23.340,89.450
 2725.000,0.184,0.059,70.327,37.048,18.203,16.356,0.000,0.084,0.004,0.035,4.654,6.217,30.288,0.051,0.119,0.118,3.741,1.041,2.395,23.925,89.149
 2725.500,0.185,0.047,69.392,36.983,17.765,15.892,0.000,0.078,0.003,0.036,4.499,6.143,21.613,0.056,0.114,0.116,3.893,1.287,2.394,23.682,88.777
 2726.000,0.196,0.029,68.788,37.301,17.285,15.277,0.000,0.068,0.002,0.041,5.079,6.966,16.159,0.075,0.108,0.109,3.976,2.168,2.374,24.068,88.164
 2726.500,0.206,0.015,68.859,36.943,16.708,14.664,0.000,0.062,0.002,0.042,5.744,7.557,11.204,0.083,0.104,0.107,4.017,2.847,2.358,23.914,88.813
 2727.000,0.208,0.015,69.544,37.781,16.075,14.133,0.000,0.058,0.002,0.042,5.310,7.402,9.468,0.081,0.100,0.110,4.007,3.414,2.354,24.350,89.633
 2727.500,0.204,0.017,70.778,39.149,15.483,13.683,0.000,0.058,0.002,0.042,5.552,7.328,7.816,0.079,0.100,0.113,3.994,3.495,2.361,24.585,88.754
 2728.000,0.200,0.013,71.247,40.817,14.986,13.283,0.000,0.058,0.003,0.041,5.245,7.302,7.184,0.076,0.100,0.113,3.911,3.439,2.367,23.896,88.978
 2728.500,0.194,0.010,71.088,41.754,14.554,12.921,0.000,0.058,0.003,0.041,5.313,7.265,6.557,0.073,0.099,0.109,3.853,3.437,2.378,23.170,88.913
 2729.000,0.200,0.008,70.641,43.976,14.102,12.593,0.000,0.062,0.003,0.038,5.012,6.726,6.506,0.057,0.100,0.108,3.786,2.831,2.367,21.937,86.028
 2729.500,0.213,-0.001,70.023,44.969,13.621,12.242,0.000,0.065,0.003,0.036,5.597,6.841,6.891,0.047,0.101,0.107,3.814,2.280,2.346,21.569,81.891
 2730.000,0.209,0.001,70.209,44.350,13.149,11.842,0.000,0.071,0.002,0.033,5.304,7.014,7.444,0.038,0.104,0.108,3.894,1.673,2.353,20.629,80.003
 2730.500,0.207,0.007,71.208,43.072,12.772,11.441,0.000,0.075,0.002,0.031,5.406,7.037,7.809,0.034,0.106,0.110,3.979,1.481,2.356,19.978,80.286
 2731.000,0.205,0.016,71.494,42.193,12.484,10.708,0.000,0.078,0.002,0.030,5.828,7.450,7.562,0.032,0.108,0.106,4.046,1.335,2.360,20.194,80.398
 2731.500,0.205,0.017,72.070,42.201,12.292,10.455,0.000,0.078,0.002,0.030,6.124,7.638,7.057,0.031,0.108,0.103,4.061,1.237,2.359,20.605,82.216
 2732.000,0.208,0.018,72.434,41.892,12.200,10.312,0.000,0.077,0.003,0.031,5.684,6.730,7.091,0.034,0.108,0.104,4.082,1.151,2.355,21.112,82.983
 2732.500,0.207,0.014,71.806,42.169,12.253,10.296,0.000,0.074,0.003,0.032,5.924,6.461,7.204,0.037,0.107,0.109,4.080,1.016,2.356,20.454,81.708
 2733.000,0.196,0.015,71.800,41.916,12.452,10.438,0.000,0.068,0.004,0.035,6.273,6.601,7.141,0.046,0.103,0.109,4.122,1.130,2.375,18.816,82.151
 2733.500,0.184,0.011,72.403,43.569,12.756,11.141,0.000,0.064,0.003,0.037,6.523,7.077,7.074,0.052,0.101,0.105,4.191,1.265,2.395,18.381,82.818
 2734.000,0.166,0.016,72.163,43.439,13.092,11.588,0.000,0.062,0.002,0.038,6.143,7.347,7.182,0.057,0.100,0.102,4.162,1.365,2.427,19.879,81.968
 2734.500,0.166,0.007,71.550,41.680,13.405,12.074,0.000,0.063,0.001,0.038,6.642,8.026,7.487,0.057,0.100,0.101,4.126,1.227,2.426,22.265,82.251
 2735.000,0.170,0.003,69.819,41.762,13.687,12.547,0.000,0.062,0.000,0.038,5.777,8.059,7.699,0.055,0.100,0.105,4.115,1.159,2.419,24.737,82.104
 2735.500,0.170,0.000,69.372,40.199,13.871,12.927,0.000,0.062,0.000,0.037,5.324,7.181,7.840,0.051,0.098,0.107,3.974,1.144,2.420,24.527,81.767
 2736.000,0.172,-0.001,69.194,39.922,13.830,13.172,0.000,0.064,0.000,0.035,6.774,7.594,7.854,0.042,0.098,0.106,3.921,1.123,2.416,23.639,81.307
 2736.500,0.171,0.004,69.294,41.884,13.421,13.158,0.000,0.066,0.000,0.033,6.495,7.853,7.686,0.035,0.099,0.107,3.871,1.060,2.418,23.893,82.174
 2737.000,0.169,0.007,69.784,44.546,12.670,12.819,15.000,0.069,0.000,0.030,5.062,7.011,7.389,0.027,0.099,0.109,3.885,0.957,2.421,23.499,81.761
 2737.500,0.180,0.001,69.750,46.028,11.644,12.133,0.000,0.071,0.000,0.028,5.363,6.605,6.360,0.023,0.099,0.110,3.813,0.938,2.401,22.860,81.472
 2738.000,0.180,0.013,69.613,45.441,10.531,11.215,0.000,0.075,0.000,0.026,5.383,6.553,5.593,0.019,0.101,0.113,3.806,0.769,2.402,20.803,81.419
 2738.500,0.176,0.030,70.297,44.253,9.503,9.776,0.000,0.079,0.000,0.024,6.239,6.793,4.818,0.017,0.103,0.118,3.761,0.659,2.409,18.790,81.177
 2739.000,0.177,0.035,70.931,41.168,8.605,8.756,0.000,0.083,0.000,0.023,6.354,6.767,4.690,0.014,0.106,0.121,3.725,0.500,2.407,17.521,81.277
 2739.500,0.174,0.036,71.488,40.459,7.950,7.877,0.000,0.086,0.001,0.021,6.180,6.737,4.598,0.012,0.107,0.123,3.659,0.354,2.413,16.130,81.702
 2740.000,0.169,0.038,71.711,40.883,7.476,7.215,0.000,0.091,0.003,0.017,5.946,6.176,4.592,0.007,0.108,0.127,3.722,0.180,2.422,14.645,82.168
 2740.500,0.157,0.041,72.055,39.605,7.142,6.796,0.000,0.093,0.005,0.014,5.727,6.361,4.767,0.005,0.107,0.126,3.739,0.096,2.441,13.576,81.637
 2741.000,0.143,0.039,72.369,39.018,6.894,6.577,0.000,0.095,0.008,0.012,6.340,6.819,4.990,0.003,0.107,0.126,3.843,0.041,2.465,12.895,81.301
 2741.500,0.141,0.029,72.278,40.915,6.710,6.525,0.000,0.094,0.009,0.012,7.410,8.152,5.305,0.003,0.106,0.121,3.865,0.026,2.469,13.761,81.944
 2742.000,0.134,0.028,71.298,40.370,6.577,6.571,0.000,0.090,0.009,0.014,7.914,9.293,5.392,0.004,0.104,0.115,3.955,0.028,2.481,15.881,82.493
 2742.500,0.126,0.031,70.284,39.393,6.501,6.655,0.000,0.087,0.008,0.015,7.230,8.406,5.289,0.005,0.102,0.114,4.059,0.033,2.495,17.373,83.295
 2743.000,0.127,0.025,68.755,39.889,6.455,6.716,0.000,0.084,0.006,0.016,6.110,7.376,5.058,0.006,0.100,0.120,4.103,0.042,2.492,18.163,83.396
 2743.500,0.121,0.033,67.981,39.482,6.405,6.714,0.000,0.082,0.005,0.017,6.481,7.627,4.670,0.006,0.099,0.125,4.164,0.051,2.503,17.887,83.419
 2744.000,0.119,0.033,68.573,36.886,6.325,6.648,0.000,0.080,0.003,0.018,6.777,7.675,4.463,0.007,0.098,0.126,4.226,0.066,2.506,17.649,84.122
 2744.500,0.116,0.043,68.695,38.969,6.207,6.536,0.000,0.080,0.003,0.019,6.647,7.649,4.198,0.009,0.099,0.130,4.275,0.073,2.512,17.894,84.452
 2745.000,0.119,0.040,68.663,40.166,6.072,6.425,0.000,0.081,0.001,0.022,5.887,7.229,3.997,0.013,0.103,0.130,4.215,0.077,2.506,17.202,84.257
 2745.500,0.117,0.041,68.717,39.531,5.927,6.340,0.000,0.081,0.001,0.024,6.329,7.653,3.739,0.016,0.105,0.128,4.236,0.079,2.510,16.570,84.765
 2746.000,0.115,0.039,68.884,40.150,5.762,6.266,0.000,0.081,0.000,0.025,8.055,8.406,3.634,0.019,0.106,0.122,4.225,0.084,2.513,16.675,85.561
 2746.500,0.109,0.044,69.270,40.988,5.569,6.176,0.000,0.081,0.000,0.026,7.436,8.344,3.626,0.021,0.107,0.123,4.285,0.079,2.523,17.358,86.771
 2747.000,0.106,0.042,68.816,38.994,5.337,6.001,0.000,0.083,0.000,0.026,7.241,8.369,3.690,0.022,0.109,0.121,4.273,0.064,2.529,18.535,87.562
 2747.500,0.104,0.045,68.247,39.564,5.090,5.715,0.000,0.084,0.000,0.026,6.830,8.454,3.863,0.022,0.110,0.122,4.286,0.051,2.532,18.751,88.594
 2748.000,0.103,0.047,67.923,41.404,4.820,5.335,0.000,0.083,0.000,0.025,7.382,9.108,4.044,0.019,0.108,0.124,4.269,0.045,2.535,18.491,90.093
 2748.500,0.096,0.054,67.656,43.138,4.591,4.922,0.000,0.083,0.000,0.025,8.072,9.267,4.445,0.018,0.107,0.123,4.194,0.047,2.546,17.470,91.852
 2749.000,0.090,0.056,67.633,43.927,4.394,4.555,0.000,0.086,0.000,0.022,7.213,8.565,4.804,0.014,0.109,0.124,4.132,0.038,2.556,15.376,93.226
 2749.500,0.092,0.056,67.395,44.595,4.230,4.286,0.000,0.091,0.000,0.020,7.959,8.669,5.333,0.012,0.111,0.125,4.023,0.025,2.553,13.328,95.363
 2750.000,0.095,0.050,67.597,41.697,4.111,4.119,0.000,0.097,0.000,0.017,7.633,8.809,5.596,0.008,0.114,0.130,3.876,0.016,2.548,11.563,97.345
 2750.500,0.101,0.039,67.870,39.841,4.048,4.022,0.000,0.098,0.000,0.016,6.675,8.129,5.619,0.007,0.115,0.131,3.780,0.014,2.537,10.522,99.959
 2751.000,0.104,0.036,67.534,37.016,4.060,3.984,0.000,0.100,0.000,0.015,7.058,8.303,5.361,0.006,0.115,0.130,3.730,0.012,2.533,10.357,101.676
 2751.500,0.110,0.026,67.764,37.822,4.145,4.012,7.000,0.102,0.000,0.014,8.610,9.392,4.698,0.005,0.116,0.123,3.676,0.010,2.522,9.986,104.190
 2752.000,0.106,0.034,67.583,40.931,4.278,4.120,0.000,0.102,0.000,0.012,11.887,11.453,4.247,0.004,0.115,0.120,3.592,0.008,2.529,9.654,106.326
 2752.500,0.107,0.033,67.673,42.006,4.426,4.287,0.000,0.101,0.000,0.012,12.959,14.129,3.411,0.003,0.112,0.117,3.525,0.007,2.527,10.184,108.268
 2753.000,0.105,0.032,68.033,42.869,4.577,4.477,0.000,0.097,0.000,0.011,8.559,10.326,2.714,0.003,0.108,0.111,3.703,0.006,2.530,10.347,110.126
 2753.500,0.106,0.030,67.761,43.097,4.710,4.643,0.000,0.095,0.001,0.011,7.909,9.160,1.733,0.002,0.105,0.103,3.667,0.004,2.529,11.230,112.498
 2754.000,0.095,0.046,67.167,42.177,4.844,4.748,0.000,0.091,0.003,0.009,13.021,12.737,1.357,0.002,0.100,0.098,3.646,0.004,2.548,12.002,114.127
 2754.500,0.091,0.052,66.683,40.687,4.968,4.804,0.000,0.089,0.004,0.008,13.418,14.358,1.081,0.001,0.097,0.106,3.698,0.003,2.555,13.179,115.838
 2755.000,0.091,0.046,66.402,40.215,5.093,4.836,0.000,0.086,0.007,0.005,10.904,10.773,0.950,0.000,0.091,0.114,3.701,0.001,2.555,13.250,119.202
 2755.500,0.092,0.049,66.663,40.280,5.211,4.890,0.000,0.085,0.009,0.003,7.179,6.749,0.787,0.000,0.087,0.119,3.538,0.000,2.552,11.436,123.598
 2756.000,0.081,0.067,66.847,39.963,5.344,4.987,0.000,0.081,0.011,0.001,5.577,4.714,0.698,0.000,0.082,0.124,3.384,0.001,2.571,8.834,128.065
 2756.500,0.079,0.063,68.181,39.727,5.516,5.155,0.000,0.074,0.012,0.001,5.918,4.352,0.601,0.000,0.076,0.128,3.412,0.001,2.575,6.943,130.797
 2757.000,0.082,0.048,69.619,41.518,5.744,5.416,0.000,0.061,0.014,0.002,6.461,4.688,0.539,0.000,0.063,0.131,3.501,0.003,2.569,6.505,132.809
 2757.500,0.073,0.048,69.778,43.243,6.035,5.791,0.000,0.052,0.015,0.004,6.352,4.404,0.422,0.000,0.056,0.130,3.644,0.004,2.586,6.645,134.231
 2758.000,0.064,0.051,69.550,44.611,6.363,6.326,0.000,0.042,0.015,0.008,8.030,5.777,0.327,0.000,0.050,0.120,3.812,0.009,2.602,6.978,135.311
 2758.500,0.061,0.052,69.211,44.774,6.729,6.933,0.000,0.039,0.016,0.011,8.703,7.151,0.182,0.001,0.050,0.109,4.067,0.012,2.605,7.688,133.842
 2759.000,0.069,0.051,67.834,41.029,7.087,7.545,0.000,0.038,0.016,0.013,11.273,10.788,0.112,0.001,0.052,0.093,4.276,0.011,2.591,10.208,129.581
 2759.500,0.083,0.046,65.250,36.861,7.431,7.986,0.000,0.038,0.017,0.016,9.958,12.239,0.050,0.002,0.054,0.083,4.447,0.010,2.568,14.739,126.159
 2760.000,0.094,0.037,63.317,31.667,7.697,8.216,0.000,0.039,0.018,0.018,11.265,12.132,0.034,0.004,0.057,0.080,4.430,0.007,2.549,19.868,124.023
 2760.500,0.092,0.041,61.955,26.311,7.823,8.224,0.000,0.043,0.019,0.019,9.330,10.179,0.023,0.005,0.062,0.080,4.229,0.008,2.552,23.140,123.090
 2761.000,0.092,0.036,60.678,26.506,7.804,8.043,0.000,0.049,0.018,0.016,8.700,9.555,0.025,0.003,0.065,0.078,4.046,0.005,2.553,23.016,123.863
 2761.500,0.086,0.028,61.092,30.633,7.683,7.787,0.000,0.048,0.018,0.014,9.505,11.789,0.049,0.002,0.061,0.080,3.870,0.005,2.563,21.836,125.935
 2762.000,0.082,0.028,62.522,35.331,7.492,7.524,0.000,0.042,0.019,0.009,8.598,8.827,0.113,0.001,0.051,0.090,3.624,0.005,2.570,18.072,130.077
 2762.500,0.080,0.031,63.097,39.759,7.241,7.302,0.000,0.036,0.019,0.006,5.777,4.529,0.295,0.000,0.042,0.107,3.474,0.007,2.573,13.581,135.205
 2763.000,0.076,0.038,63.730,44.416,6.931,7.075,0.000,0.025,0.020,0.003,5.012,3.813,0.442,0.000,0.028,0.118,3.326,0.010,2.579,9.927,139.164
 2763.500,0.079,0.036,66.013,48.673,6.581,6.784,0.000,0.025,0.022,0.001,4.848,3.772,0.551,0.000,0.027,0.124,3.280,0.008,2.575,8.231,141.412
 2764.000,0.077,0.045,68.202,50.122,6.245,6.405,0.000,0.037,0.027,0.001,4.581,3.588,0.514,0.000,0.037,0.126,3.292,0.002,2.578,8.210,143.336
 2764.500,0.079,0.051,69.081,53.061,5.964,6.009,0.000,0.044,0.031,0.001,4.510,3.466,0.329,0.000,0.045,0.134,3.290,0.001,2.575,8.102,145.578
 2765.000,0.086,0.053,70.094,55.813,5.761,5.670,0.000,0.042,0.038,0.001,3.840,3.215,0.209,0.000,0.043,0.143,3.280,0.001,2.563,7.667,147.254
 2765.500,0.085,0.057,71.944,54.901,5.646,5.423,0.000,0.036,0.041,0.001,3.981,2.920,0.082,0.000,0.036,0.154,3.227,0.000,2.564,7.074,148.505
 2766.000,0.086,0.059,73.652,55.072,5.600,5.289,0.000,0.026,0.045,0.001,3.781,2.831,0.040,0.000,0.027,0.161,3.263,0.000,2.562,6.625,149.249
 2766.500,0.086,0.063,74.695,55.487,5.616,5.258,7.000,0.022,0.046,0.001,4.237,3.167,0.005,0.000,0.022,0.161,3.357,0.000,2.562,6.364,149.455
 2767.000,0.090,0.055,76.000,54.771,5.685,5.323,0.000,0.010,0.045,0.001,4.060,3.112,0.002,0.000,0.011,0.153,3.371,0.000,2.556,6.321,149.856
 2767.500,0.087,0.055,75.908,55.259,5.795,5.482,0.000,0.005,0.043,0.001,4.282,3.119,0.000,0.000,0.006,0.146,3.412,0.000,2.561,6.639,149.821
 2768.000,0.089,0.054,75.031,52.516,5.947,5.690,0.000,0.006,0.042,0.001,4.516,3.462,0.000,0.000,0.007,0.137,3.448,0.000,2.558,7.192,149.549
 2768.500,0.091,0.047,73.898,52.687,6.129,5.925,0.000,0.015,0.043,0.001,5.994,4.219,0.000,0.000,0.016,0.130,3.500,0.000,2.554,7.896,148.812
 2769.000,0.093,0.037,72.525,50.847,6.342,6.149,0.000,0.022,0.043,0.001,5.898,4.430,0.000,0.000,0.022,0.129,3.451,0.000,2.551,8.695,148.003
 2769.500,0.093,0.035,71.633,48.974,6.549,6.357,0.000,0.020,0.043,0.001,4.831,3.569,0.000,0.000,0.021,0.121,3.422,0.000,2.550,8.748,147.366
 2770.000,0.091,0.033,70.241,49.268,6.733,6.543,0.000,0.013,0.043,0.001,5.119,4.123,0.000,0.000,0.014,0.115,3.355,0.000,2.554,8.956,146.363
 2770.500,0.087,0.033,70.209,49.919,6.862,6.691,0.000,0.008,0.043,0.001,5.239,4.123,0.000,0.000,0.009,0.111,3.339,0.000,2.562,8.744,145.791
 2771.000,0.091,0.028,69.859,48.209,6.931,6.811,0.000,0.008,0.043,0.001,5.338,4.035,0.000,0.000,0.009,0.109,3.257,0.000,2.554,8.887,144.823
 2771.500,0.082,0.046,69.369,48.974,6.947,6.903,0.000,0.009,0.044,0.001,4.997,3.972,0.000,0.000,0.010,0.104,3.184,0.000,2.570,8.772,144.528
 2772.000,0.084,0.048,68.906,49.463,6.917,6.964,0.000,0.010,0.044,0.001,6.169,4.622,0.000,0.000,0.011,0.099,3.186,0.000,2.566,8.974,144.062
 2772.500,0.082,0.050,68.791,51.010,6.867,6.954,0.000,0.011,0.043,0.001,6.780,4.987,0.000,0.000,0.012,0.098,3.251,0.000,2.569,9.377,143.773
 2773.000,0.083,0.045,68.895,55.072,6.816,6.877,0.000,0.013,0.042,0.001,6.278,4.245,0.000,0.000,0.014,0.106,3.282,0.000,2.569,9.700,144.923
 2773.500,0.067,0.057,68.836,60.518,6.763,6.785,0.000,0.018,0.040,0.001,4.995,3.532,0.000,0.000,0.018,0.119,3.413,0.000,2.596,9.509,146.593
 2774.000,0.065,0.054,69.263,62.057,6.705,6.711,0.000,0.019,0.039,0.001,4.952,3.248,0.000,0.000,0.019,0.130,3.652,0.000,2.599,8.868,149.030
 2774.500,0.064,0.049,70.381,65.427,6.656,6.643,0.000,0.019,0.038,0.001,5.437,3.429,0.000,0.000,0.019,0.130,3.709,0.000,2.600,8.304,149.355
 2775.000,0.063,0.043,71.241,67.568,6.640,6.589,0.000,0.020,0.037,0.001,5.763,4.108,0.000,0.000,0.021,0.126,3.854,0.000,2.603,8.655,149.048
 2775.500,0.059,0.048,72.353,69.619,6.694,6.575,0.000,0.022,0.036,0.002,4.589,3.580,0.000,0.000,0.024,0.128,3.899,0.000,2.609,8.437,148.434
 2776.000,0.058,0.047,72.016,70.043,6.828,6.693,0.000,0.026,0.032,0.006,5.299,3.588,0.000,0.000,0.032,0.127,3.977,0.001,2.611,8.050,148.062
 2776.500,0.059,0.043,71.259,67.324,7.039,6.951,0.000,0.029,0.028,0.009,5.645,4.275,0.000,0.000,0.038,0.117,3.974,0.002,2.608,8.071,146.351
 2777.000,0.065,0.029,71.656,60.176,7.351,7.336,0.000,0.034,0.024,0.013,7.678,5.039,0.000,0.001,0.047,0.100,3.987,0.003,2.599,7.968,141.731
 2777.500,0.070,0.028,69.120,52.915,7.747,7.874,0.000,0.036,0.023,0.015,15.260,10.245,0.000,0.002,0.051,0.086,4.159,0.003,2.591,9.525,136.037
 2778.000,0.075,0.025,65.947,41.461,8.185,8.567,0.000,0.038,0.021,0.019,15.085,12.062,0.000,0.004,0.057,0.080,4.275,0.007,2.582,10.391,130.997
 2778.500,0.078,0.022,63.748,36.218,8.583,9.473,0.000,0.038,0.020,0.021,11.169,12.257,0.000,0.005,0.059,0.075,4.449,0.009,2.577,13.470,127.599
 2779.000,0.078,0.023,61.009,34.346,8.895,10.330,0.000,0.040,0.018,0.023,9.035,11.054,0.000,0.008,0.062,0.068,4.443,0.013,2.577,17.804,124.772
 2779.500,0.074,0.028,59.803,34.736,9.145,11.214,0.000,0.041,0.017,0.023,10.237,11.645,0.001,0.008,0.064,0.060,4.515,0.014,2.584,26.064,123.503
 2780.000,0.079,0.022,59.348,37.170,9.329,11.319,0.000,0.045,0.015,0.023,13.880,14.421,0.004,0.008,0.067,0.058,4.429,0.013,2.575,38.082,122.801
 2780.500,0.080,0.019,59.116,38.937,9.316,11.224,7.000,0.048,0.014,0.021,15.150,12.937,0.024,0.007,0.069,0.065,4.405,0.012,2.572,26.947,121.184
 2781.000,0.082,0.021,58.689,39.132,8.951,10.689,0.000,0.055,0.011,0.018,16.237,14.982,0.046,0.005,0.074,0.074,4.434,0.008,2.569,20.252,119.084
 2781.500,0.085,0.017,59.628,37.097,8.130,10.247,0.000,0.062,0.009,0.016,13.430,15.296,0.106,0.004,0.078,0.078,4.316,0.007,2.564,17.588,117.609
 2782.000,0.093,0.018,60.823,34.932,7.096,9.297,0.000,0.071,0.006,0.013,12.807,14.672,0.168,0.003,0.084,0.080,4.079,0.004,2.551,18.460,117.184
 2782.500,0.101,0.025,61.306,38.587,6.156,7.963,0.000,0.076,0.005,0.010,11.110,12.859,0.296,0.002,0.087,0.086,3.827,0.005,2.538,24.243,116.552
 2783.000,0.106,0.034,61.888,45.979,5.358,6.601,0.000,0.083,0.005,0.006,9.710,11.069,0.388,0.001,0.089,0.098,3.619,0.003,2.529,24.602,116.959
 2783.500,0.113,0.039,64.313,55.845,4.746,5.456,0.000,0.086,0.007,0.004,9.496,9.019,0.516,0.000,0.089,0.113,3.349,0.002,2.518,18.592,118.193
 2784.000,0.113,0.051,66.317,66.746,4.254,4.561,0.000,0.085,0.010,0.001,9.837,8.133,0.581,0.000,0.087,0.127,3.093,0.001,2.517,13.418,121.037
 2784.500,0.108,0.058,68.816,70.303,3.913,3.948,0.000,0.081,0.012,0.001,6.228,4.987,0.628,0.000,0.081,0.135,3.008,0.002,2.525,9.691,123.899
 2785.000,0.102,0.061,72.102,68.683,3.702,3.575,0.000,0.071,0.017,0.001,6.169,4.031,0.603,0.000,0.072,0.136,3.064,0.003,2.535,6.951,126.690
 2785.500,0.100,0.059,73.698,65.573,3.602,3.385,0.000,0.065,0.021,0.001,6.763,4.644,0.484,0.000,0.066,0.130,2.995,0.001,2.540,5.501,126.796
 2786.000,0.100,0.053,73.977,61.405,3.570,3.346,0.000,0.059,0.029,0.001,6.698,4.832,0.381,0.000,0.059,0.117,2.909,0.000,2.539,4.850,125.026
 2786.500,0.093,0.049,73.381,57.131,3.571,3.408,0.000,0.049,0.034,0.001,6.357,5.061,0.243,0.000,0.050,0.106,2.934,0.000,2.550,5.379,126.041
 2787.000,0.087,0.047,72.452,57.652,3.586,3.533,0.000,0.029,0.040,0.002,5.994,4.806,0.170,0.000,0.030,0.096,2.884,0.000,2.562,5.962,126.678
 2787.500,0.080,0.049,70.705,59.777,3.613,3.657,0.000,0.016,0.044,0.003,5.735,4.042,0.087,0.000,0.019,0.093,2.886,0.000,2.573,6.308,127.929
 2788.000,0.082,0.049,68.866,62.016,3.659,3.718,0.000,0.009,0.049,0.004,5.687,3.754,0.053,0.000,0.012,0.099,2.846,0.000,2.570,6.423,130.809
 2788.500,0.097,0.070,67.745,66.322,3.740,3.661,0.000,0.007,0.051,0.004,5.194,3.348,0.024,0.000,0.011,0.117,2.727,0.000,2.544,6.189,133.063
 2789.000,0.122,0.106,67.213,71.036,3.820,3.546,0.000,0.004,0.055,0.004,4.572,3.130,0.015,0.000,0.008,0.143,2.818,0.000,2.502,5.982,135.694
 2789.500,0.144,0.108,70.019,72.762,3.844,3.473,0.000,0.003,0.057,0.003,2.903,2.214,0.005,0.000,0.005,0.190,2.832,0.000,2.463,5.342,139.766
 2790.000,0.149,0.103,75.627,75.220,3.779,3.485,0.000,0.001,0.059,0.002,1.028,1.343,0.003,0.000,0.003,0.231,2.919,0.000,2.455,4.417,141.707
 2790.500,0.133,0.149,77.933,73.307,3.636,3.551,0.000,0.001,0.059,0.001,2.376,1.900,0.001,0.000,0.002,0.225,3.005,0.000,2.482,4.013,143.112
 2791.000,0.107,0.213,79.845,69.912,3.483,3.533,0.000,0.000,0.059,0.001,3.480,2.820,0.001,0.000,0.001,0.210,3.318,0.000,2.527,4.177,143.483
 2791.500,0.118,0.187,81.577,67.283,3.403,3.434,0.000,0.000,0.058,0.001,2.430,2.473,0.001,0.000,0.001,0.222,3.422,0.000,2.509,4.767,142.881
 2792.000,0.129,0.198,79.694,67.079,3.423,3.309,0.000,0.001,0.056,0.001,0.949,1.528,0.001,0.000,0.001,0.244,3.477,0.000,2.489,5.081,140.970
 2792.500,0.138,0.251,76.181,67.706,3.540,3.276,0.000,0.001,0.055,0.001,1.408,1.605,0.001,0.000,0.001,0.250,3.592,0.000,2.475,4.842,139.908
 2793.000,0.140,0.277,76.991,69.587,3.734,3.364,0.000,0.001,0.054,0.001,1.492,1.657,0.001,0.000,0.002,0.255,3.769,0.000,2.470,4.314,139.365
 2793.500,0.156,0.214,81.556,69.294,3.978,3.592,0.000,0.001,0.053,0.001,1.290,1.620,0.000,0.000,0.002,0.248,3.696,0.000,2.443,3.891,139.424
 2794.000,0.148,0.190,80.730,67.649,4.227,3.950,0.000,0.001,0.053,0.002,1.002,1.502,0.000,0.000,0.003,0.213,3.707,0.000,2.456,3.889,140.799
 2794.500,0.123,0.183,79.283,62.032,4.481,4.444,7.000,0.001,0.052,0.002,2.824,2.521,0.000,0.000,0.003,0.178,3.788,0.000,2.500,4.342,142.811
 2795.000,0.063,0.166,79.881,55.471,4.730,4.983,0.000,0.001,0.050,0.002,3.725,3.739,0.000,0.000,0.003,0.160,3.894,0.000,2.602,5.414,145.791
 2795.500,0.065,0.111,76.661,52.092,4.976,5.458,0.000,0.001,0.049,0.002,4.750,3.643,0.000,0.000,0.003,0.147,3.768,0.000,2.599,6.744,146.334
 2796.000,0.070,0.103,73.067,50.139,5.187,5.731,0.000,0.001,0.049,0.002,7.700,5.526,0.000,0.000,0.003,0.139,3.634,0.000,2.590,7.866,144.127
 2796.500,0.074,0.095,71.269,49.650,5.312,5.750,0.000,0.002,0.051,0.002,7.593,6.062,0.000,0.000,0.003,0.139,3.554,0.000,2.584,8.416,142.592
 2797.000,0.092,0.070,68.928,52.947,5.348,5.504,0.000,0.002,0.052,0.002,5.313,4.408,0.000,0.000,0.003,0.148,3.393,0.000,2.553,7.920,141.176
 2797.500,0.090,0.077,67.388,55.243,5.278,5.164,0.000,0.001,0.052,0.002,5.386,3.946,0.000,0.000,0.003,0.165,3.463,0.000,2.557,7.382,140.433
 2798.000,0.075,0.083,66.838,57.994,5.151,4.902,0.000,0.001,0.054,0.002,5.003,4.751,0.000,0.000,0.003,0.188,3.448,0.000,2.583,6.580,139.825
 2798.500,0.069,0.073,67.647,61.080,4.982,4.794,0.000,0.001,0.057,0.001,3.432,3.049,0.000,0.000,0.002,0.206,3.537,0.000,2.592,5.540,141.648
 2799.000,0.067,0.073,68.861,61.584,4.801,4.832,0.000,0.001,0.059,0.001,4.085,2.993,0.000,0.000,0.002,0.188,3.516,0.000,2.596,5.134,144.280
 2799.500,0.057,0.085,70.983,61.023,4.688,4.885,0.000,0.001,0.058,0.001,5.194,3.747,0.000,0.000,0.001,0.162,3.542,0.000,2.612,5.358,146.310
 2800.000,0.059,0.120,72.016,61.047,4.686,4.872,0.000,0.001,0.056,0.001,5.831,3.806,0.000,0.000,0.001,0.154,3.540,0.000,2.610,6.230,146.823
 2800.500,0.099,0.113,69.456,60.445,4.759,4.855,0.000,0.001,0.054,0.001,4.662,3.366,0.000,0.000,0.001,0.163,3.590,0.000,2.540,7.171,146.558
 2801.000,0.114,0.098,68.689,60.217,4.842,4.908,0.000,0.001,0.055,0.001,2.700,2.196,0.000,0.000,0.001,0.199,3.608,0.000,2.515,7.014,146.717
 2801.500,0.111,0.097,70.333,59.305,4.851,5.024,0.000,0.001,0.057,0.001,1.543,1.808,0.000,0.000,0.001,0.212,3.651,0.000,2.520,5.921,146.115
 2802.000,0.092,0.115,70.945,60.974,4.759,5.055,0.000,0.001,0.059,0.001,3.683,2.905,0.000,0.000,0.002,0.188,3.775,0.000,2.552,5.559,146.233
 2802.500,0.057,0.135,73.406,61.479,4.641,4.850,0.000,0.001,0.060,0.001,4.657,3.887,0.000,0.000,0.002,0.172,3.845,0.000,2.612,5.993,146.422
 2803.000,0.072,0.114,75.302,64.059,4.547,4.522,0.000,0.001,0.062,0.001,4.753,3.488,0.000,0.000,0.001,0.189,3.733,0.000,2.586,6.598,145.053
 2803.500,0.094,0.115,71.347,68.976,4.415,4.258,0.000,0.001,0.065,0.001,3.745,3.052,0.000,0.000,0.001,0.220,3.643,0.000,2.549,6.650,143.177
 2804.000,0.105,0.118,71.989,70.686,4.177,4.150,0.000,0.002,0.067,0.001,2.151,1.989,0.000,0.000,0.002,0.248,3.699,0.000,2.530,5.527,141.129
 2804.500,0.092,0.128,75.413,70.140,3.829,4.090,0.000,0.010,0.068,0.001,2.053,1.993,0.000,0.000,0.010,0.234,3.733,0.000,2.553,4.573,140.775
 2805.000,0.081,0.127,78.200,71.085,3.472,3.908,0.000,0.017,0.065,0.001,3.747,3.163,0.000,0.000,0.018,0.204,3.660,0.000,2.572,4.558,141.961
 2805.500,0.071,0.125,80.069,70.596,3.212,3.556,0.000,0.025,0.059,0.001,5.752,4.311,0.000,0.000,0.026,0.195,3.593,0.001,2.589,5.392,142.226
 2806.000,0.089,0.079,79.973,70.572,3.090,3.165,0.000,0.027,0.056,0.001,4.702,3.233,0.000,0.000,0.028,0.215,3.510,0.001,2.558,5.701,140.787
 2806.500,0.097,0.083,79.533,70.165,3.082,2.908,0.000,0.030,0.053,0.003,2.796,2.248,0.000,0.000,0.033,0.242,3.420,0.002,2.545,5.239,138.869
 2807.000,0.111,0.059,79.116,65.386,3.131,2.831,0.000,0.033,0.051,0.006,2.348,2.056,0.000,0.000,0.039,0.258,3.367,0.003,2.521,3.909,135.287
 2807.500,0.096,0.058,79.827,58.222,3.193,2.922,0.000,0.039,0.047,0.011,4.682,3.292,0.000,0.001,0.050,0.186,3.448,0.004,2.546,3.332,129.351
 2808.000,0.085,0.062,79.255,52.296,3.247,3.138,0.000,0.042,0.044,0.015,10.054,6.856,0.000,0.002,0.056,0.122,3.714,0.006,2.565,4.433,123.999
 2808.500,0.073,0.068,74.122,46.028,3.355,3.419,7.000,0.046,0.039,0.019,15.752,14.152,0.000,0.005,0.065,0.093,3.901,0.010,2.585,7.020,119.886
 2809.000,0.079,0.057,67.216,42.397,3.583,3.722,0.000,0.047,0.037,0.020,11.473,11.445,0.000,0.006,0.068,0.094,4.087,0.010,2.575,9.398,117.260
 2809.500,0.089,0.053,61.911,41.884,3.955,4.062,0.000,0.049,0.035,0.022,8.750,10.762,0.000,0.007,0.071,0.098,4.207,0.013,2.557,12.774,113.330
 2810.000,0.087,0.060,60.561,42.267,4.460,4.433,0.000,0.054,0.028,0.024,6.431,9.134,0.002,0.011,0.078,0.099,4.443,0.019,2.562,13.788,109.035
 2810.500,0.092,0.042,61.789,45.954,4.986,4.827,0.000,0.056,0.023,0.025,6.064,8.635,0.011,0.013,0.081,0.097,4.548,0.023,2.553,15.101,105.459
 2811.000,0.085,0.034,61.781,60.078,5.399,5.232,0.000,0.056,0.016,0.026,7.151,9.259,0.033,0.015,0.082,0.092,4.590,0.026,2.564,15.274,103.093
 2811.500,0.078,0.031,62.148,74.642,5.705,5.683,0.000,0.056,0.011,0.026,13.317,12.571,0.122,0.015,0.082,0.083,4.645,0.025,2.576,14.221,103.063
 2812.000,0.074,0.036,61.775,80.772,5.992,6.246,0.000,0.055,0.007,0.025,16.228,15.717,0.239,0.013,0.080,0.078,4.751,0.023,2.584,13.778,102.249
 2812.500,0.075,0.035,60.780,82.009,6.388,6.948,0.000,0.052,0.007,0.025,10.761,13.985,0.516,0.013,0.077,0.079,4.713,0.021,2.582,14.948,101.240
 2813.000,0.075,0.042,60.294,76.620,6.926,7.728,0.000,0.045,0.007,0.026,8.663,11.113,0.727,0.013,0.071,0.078,4.783,0.022,2.582,17.664,99.770
 2813.500,0.085,0.033,59.917,66.664,7.608,8.664,0.000,0.041,0.007,0.026,7.171,9.503,1.006,0.013,0.067,0.075,4.836,0.022,2.565,21.327,98.614
 2814.000,0.073,0.039,60.577,60.233,8.223,9.815,0.000,0.038,0.006,0.026,6.980,8.957,1.090,0.013,0.065,0.070,4.811,0.022,2.585,24.019,98.419
 2814.500,0.064,0.045,60.714,58.296,8.455,11.424,0.000,0.038,0.006,0.027,8.919,10.430,1.069,0.013,0.065,0.063,4.775,0.022,2.600,25.508,99.009
 2815.000,0.062,0.052,60.844,55.251,8.148,12.168,0.000,0.040,0.007,0.026,9.716,11.936,0.998,0.013,0.066,0.057,4.741,0.022,2.604,30.589,99.658
 2815.500,0.063,0.054,61.013,55.642,7.483,11.669,0.000,0.042,0.008,0.026,11.220,13.849,0.929,0.013,0.068,0.059,4.744,0.022,2.602,40.529,100.390
 2816.000,0.071,0.053,60.241,60.689,6.678,9.643,0.000,0.046,0.008,0.025,8.553,12.361,0.907,0.012,0.071,0.065,4.520,0.020,2.588,49.993,101.033
 2816.500,0.085,0.059,59.919,63.563,5.950,7.825,0.000,0.048,0.007,0.025,8.703,12.298,0.905,0.012,0.072,0.079,4.279,0.022,2.565,37.958,102.963
 2817.000,0.089,0.063,61.363,66.567,5.298,6.398,0.000,0.050,0.006,0.025,10.060,11.619,0.917,0.012,0.075,0.093,4.032,0.046,2.558,20.394,105.069
 2817.500,0.099,0.065,62.977,67.153,4.679,5.392,0.000,0.052,0.005,0.025,11.470,8.916,0.944,0.012,0.077,0.110,3.868,0.078,2.542,12.257,106.987
 2818.000,0.119,0.062,64.747,58.076,4.178,4.736,0.000,0.059,0.005,0.027,13.765,9.761,0.963,0.017,0.086,0.121,3.708,0.083,2.507,7.939,109.790
 2818.500,0.122,0.059,67.038,48.144,3.770,4.245,0.000,0.062,0.005,0.028,9.178,8.731,0.955,0.021,0.090,0.128,3.727,0.100,2.502,6.270,107.996
 2819.000,0.126,0.047,68.523,42.600,3.483,3.912,0.000,0.069,0.007,0.031,6.650,8.019,0.930,0.029,0.099,0.125,3.784,0.100,2.494,7.146,104.379
 2819.500,0.121,0.051,68.923,37.879,3.290,3.664,0.000,0.075,0.007,0.032,7.039,8.421,0.930,0.036,0.107,0.121,3.832,0.115,2.503,8.609,100.508
 2820.000,0.120,0.050,69.159,34.907,3.189,3.479,0.000,0.083,0.008,0.034,7.391,8.750,0.986,0.046,0.117,0.120,3.859,0.107,2.505,10.354,100.679
 2820.500,0.134,0.030,69.041,34.386,3.167,3.360,0.000,0.084,0.008,0.035,7.582,8.993,1.248,0.055,0.120,0.125,3.910,0.099,2.480,11.418,101.169
 2821.000,0.143,0.023,68.570,32.253,3.210,3.295,0.000,0.083,0.008,0.039,7.878,8.997,1.638,0.073,0.122,0.132,3.802,0.124,2.466,10.757,99.847
 2821.500,0.151,0.028,67.934,30.536,3.299,3.301,0.000,0.084,0.007,0.040,7.320,8.720,2.488,0.084,0.125,0.134,3.671,0.144,2.453,9.824,97.398
 2822.000,0.151,0.028,68.275,29.461,3.426,3.380,0.000,0.088,0.004,0.040,8.480,9.315,3.174,0.083,0.128,0.133,3.686,0.142,2.451,9.203,96.826
 2822.500,0.138,0.030,68.994,29.689,3.583,3.533,0.000,0.089,0.002,0.038,8.125,8.325,4.322,0.073,0.127,0.126,3.831,0.125,2.475,8.557,97.676
 2823.000,0.121,0.040,67.950,33.271,3.789,3.758,0.000,0.085,0.001,0.034,8.489,9.318,5.356,0.050,0.119,0.112,3.958,0.089,2.503,9.532,100.638
 2823.500,0.109,0.041,67.595,38.799,4.065,4.065,0.000,0.082,0.000,0.031,9.719,11.213,7.033,0.036,0.113,0.097,3.992,0.067,2.524,11.164,105.022
 2824.000,0.092,0.036,67.261,43.431,4.423,4.431,7.000,0.077,0.000,0.026,14.474,15.097,8.169,0.019,0.103,0.084,4.210,0.037,2.554,13.121,108.887
 2824.500,0.080,0.037,65.592,49.390,4.861,4.879,0.000,0.074,0.000,0.022,13.779,16.618,9.225,0.012,0.096,0.079,4.245,0.023,2.573,15.306,112.074
 2825.000,0.072,0.035,63.870,52.508,5.306,5.353,0.000,0.068,0.001,0.017,15.603,14.861,9.301,0.005,0.086,0.078,4.105,0.009,2.587,14.558,114.829
 2825.500,0.065,0.037,62.917,53.069,5.721,5.838,0.000,0.064,0.002,0.015,12.757,10.699,8.372,0.003,0.079,0.080,4.122,0.005,2.599,12.649,119.674
 2826.000,0.070,0.026,62.750,52.841,6.085,6.285,0.000,0.058,0.003,0.012,14.345,13.801,7.376,0.002,0.070,0.080,4.119,0.004,2.591,11.754,124.955
 2826.500,0.065,0.030,62.777,52.247,6.458,6.649,0.000,0.055,0.002,0.012,19.145,13.915,5.369,0.001,0.066,0.080,4.072,0.007,2.599,10.378,127.457
 2827.000,0.066,0.027,62.991,50.594,6.847,7.032,0.000,0.052,0.001,0.012,20.218,14.794,3.996,0.001,0.063,0.082,4.140,0.010,2.597,10.093,127.858
 2827.500,0.068,0.026,63.183,49.463,7.286,7.509,0.000,0.050,0.000,0.012,15.986,11.678,2.305,0.001,0.062,0.085,4.267,0.010,2.593,9.565,126.637
 2828.000,0.071,0.017,63.034,44.302,7.702,8.175,0.000,0.045,0.000,0.015,14.255,14.085,1.557,0.002,0.060,0.086,4.406,0.011,2.589,9.880,125.545
 2828.500,0.066,0.012,62.195,40.296,7.967,8.965,0.000,0.042,0.001,0.017,9.908,13.103,0.737,0.003,0.059,0.077,4.489,0.014,2.597,12.231,126.513
 2829.000,0.063,0.013,61.658,36.071,7.995,9.645,0.000,0.041,0.003,0.018,8.708,12.084,0.444,0.004,0.059,0.065,4.586,0.012,2.603,16.757,128.200
 2829.500,0.058,0.018,60.533,33.515,7.689,9.877,0.000,0.041,0.005,0.019,12.194,15.256,0.222,0.004,0.059,0.059,4.639,0.010,2.612,26.369,130.283
 2830.000,0.056,0.011,59.177,34.085,7.127,9.321,0.000,0.038,0.010,0.018,13.050,16.349,0.156,0.003,0.057,0.058,4.626,0.008,2.614,37.846,133.263
 2830.500,0.057,0.012,58.178,42.112,6.536,8.009,0.000,0.033,0.018,0.015,12.807,16.205,0.124,0.002,0.047,0.062,4.307,0.005,2.612,45.913,137.512
 2831.000,0.067,0.019,57.253,52.532,5.992,6.632,0.000,0.031,0.022,0.012,22.462,20.753,0.123,0.001,0.043,0.076,4.071,0.005,2.596,40.827,141.731
 2831.500,0.075,0.019,58.164,64.312,5.576,5.562,0.000,0.026,0.026,0.009,19.545,14.100,0.150,0.000,0.035,0.106,3.839,0.004,2.581,23.616,147.862
 2832.000,0.071,0.027,62.889,76.343,5.231,4.967,0.000,0.020,0.028,0.007,3.671,3.063,0.185,0.000,0.027,0.149,3.671,0.004,2.588,12.353,154.565
 2832.500,0.077,0.028,67.422,83.743,4.883,4.683,0.000,0.011,0.035,0.004,3.356,2.362,0.230,0.000,0.015,0.174,3.446,0.001,2.579,7.067,159.522
 2833.000,0.069,0.043,71.833,83.198,4.612,4.560,0.000,0.006,0.042,0.003,4.733,3.296,0.240,0.000,0.009,0.170,3.368,0.000,2.592,4.728,162.466
 2833.500,0.061,0.044,76.834,80.446,4.453,4.489,0.000,0.003,0.053,0.002,4.955,3.599,0.223,0.000,0.004,0.162,3.365,0.000,2.606,4.805,164.349
 2834.000,0.068,0.032,77.345,75.424,4.457,4.460,0.000,0.001,0.059,0.001,4.691,3.433,0.192,0.000,0.003,0.161,3.293,0.000,2.593,5.524,165.605
 2834.500,0.070,0.027,74.852,71.508,4.605,4.503,0.000,0.001,0.065,0.001,4.533,3.292,0.124,0.000,0.002,0.162,3.292,0.000,2.590,5.775,165.948
 2835.000,0.070,0.023,74.517,69.635,4.840,4.652,0.000,0.001,0.067,0.001,4.722,3.259,0.081,0.000,0.002,0.157,3.300,0.000,2.589,5.720,165.523
 2835.500,0.068,0.020,75.063,70.010,5.076,4.833,0.000,0.001,0.067,0.002,4.539,3.256,0.035,0.000,0.003,0.154,3.362,0.000,2.594,5.753,164.632
 2836.000,0.065,0.017,75.469,67.568,5.211,5.038,0.000,0.001,0.066,0.002,4.277,3.160,0.016,0.000,0.003,0.151,3.417,0.000,2.599,5.735,164.396
 2836.500,0.071,0.010,74.817,67.332,5.248,5.214,0.000,0.001,0.064,0.002,5.051,3.547,0.003,0.000,0.003,0.144,3.421,0.000,2.589,5.842,162.732
 2837.000,0.073,0.013,73.478,64.776,5.220,5.314,0.000,0.001,0.063,0.001,5.442,3.935,0.001,0.000,0.002,0.136,3.345,0.000,2.585,6.306,160.000
 2837.500,0.072,0.014,72.342,64.800,5.192,5.302,0.000,0.001,0.063,0.001,6.045,4.393,0.000,0.000,0.001,0.129,3.402,0.000,2.587,6.875,155.733
 2838.000,0.080,0.002,71.041,66.257,5.205,5.207,0.000,0.000,0.064,0.001,5.456,3.894,0.000,0.000,0.001,0.129,3.483,0.000,2.574,7.293,154.128
 2838.500,0.072,-0.001,70.302,66.550,5.246,5.143,7.000,-0.001,0.064,0.001,4.964,3.743,0.000,0.000,0.001,0.136,3.531,0.000,2.586,6.969,154.724
 2839.000,0.059,0.002,70.723,66.135,5.284,5.170,0.000,-0.001,0.061,0.001,4.184,4.024,0.000,0.000,0.001,0.138,3.485,0.000,2.608,6.125,156.707
 2839.500,0.046,0.010,70.917,65.541,5.287,5.278,0.000,0.001,0.055,0.001,4.569,3.628,0.000,0.000,0.001,0.127,3.496,0.000,2.632,5.583,157.191
 2840.000,0.050,0.003,71.791,63.074,5.264,5.402,0.000,0.001,0.051,0.001,5.924,3.780,0.000,0.000,0.001,0.105,3.489,0.000,2.625,5.850,157.964
 2840.500,0.052,0.009,71.345,59.712,5.254,5.486,0.000,0.001,0.049,0.001,6.329,4.537,0.000,0.000,0.002,0.089,3.378,0.000,2.620,6.500,155.303
 2841.000,0.060,0.017,69.680,57.864,5.267,5.533,0.000,0.001,0.049,0.002,5.988,4.245,0.000,0.000,0.003,0.082,3.292,0.000,2.607,7.121,151.025
 2841.500,0.069,0.024,68.738,54.803,5.285,5.540,0.000,0.002,0.049,0.002,5.839,3.939,0.000,0.000,0.004,0.079,3.259,0.000,2.592,7.255,146.363
 2842.000,0.072,0.025,67.258,51.807,5.279,5.506,0.000,0.003,0.049,0.002,6.431,4.260,0.000,0.000,0.005,0.078,3.296,0.000,2.586,6.984,141.465
 2842.500,0.068,0.033,67.255,52.622,5.218,5.424,0.000,0.003,0.050,0.002,6.138,4.190,0.000,0.000,0.005,0.081,3.321,0.000,2.593,6.676,140.669
 2843.000,0.071,0.036,67.423,53.664,5.088,5.292,0.000,0.003,0.051,0.002,5.600,3.946,0.000,0.000,0.005,0.086,3.363,0.000,2.588,6.404,140.043
 2843.500,0.072,0.037,67.586,55.796,4.889,5.124,0.000,0.002,0.052,0.002,5.707,3.887,0.000,0.000,0.005,0.093,3.292,0.000,2.586,6.123,142.067
 2844.000,0.078,0.033,68.725,58.540,4.630,4.912,0.000,0.002,0.053,0.002,5.977,3.935,0.000,0.000,0.004,0.099,3.242,0.000,2.577,5.918,142.563
 2844.500,0.086,0.025,69.002,60.958,4.361,4.664,0.000,0.002,0.055,0.002,5.851,3.994,0.000,0.000,0.004,0.107,3.291,0.000,2.564,5.843,143.212
 2845.000,0.088,0.020,68.969,66.567,4.101,4.383,0.000,0.001,0.057,0.002,5.065,3.724,0.000,0.000,0.003,0.125,3.322,0.000,2.560,5.705,143.224
 2845.500,0.086,0.021,69.645,70.889,3.889,4.098,0.000,0.001,0.061,0.002,4.167,3.200,0.000,0.000,0.003,0.142,3.237,0.000,2.563,5.497,145.655
 2846.000,0.093,0.018,70.983,71.573,3.724,3.822,0.000,0.001,0.065,0.002,3.714,2.680,0.000,0.000,0.003,0.156,3.138,0.000,2.552,5.247,148.658
 2846.500,0.103,0.018,73.050,72.534,3.599,3.580,0.000,0.002,0.070,0.002,3.868,2.524,0.000,0.000,0.003,0.166,3.184,0.000,2.533,5.096,149.042
 2847.000,0.113,0.012,75.239,67.991,3.489,3.412,0.000,0.002,0.072,0.002,3.564,2.628,0.000,0.000,0.004,0.174,3.066,0.000,2.517,4.673,145.932
 2847.500,0.116,-0.006,76.436,60.314,3.355,3.335,0.000,0.003,0.073,0.003,4.451,2.536,0.000,0.000,0.006,0.166,3.220,0.000,2.512,4.396,139.766
 2848.000,0.084,0.012,75.963,55.528,3.196,3.285,0.000,0.004,0.074,0.003,6.343,3.001,0.000,0.000,0.007,0.147,3.171,0.000,2.567,4.103,137.406
 2848.500,0.085,0.064,74.091,56.073,3.061,3.163,0.000,0.005,0.077,0.004,7.835,3.688,0.000,0.000,0.009,0.135,3.162,0.000,2.565,4.368,136.910
 2849.000,0.171,0.069,70.917,62.675,2.976,2.983,0.000,0.005,0.077,0.004,18.478,10.839,0.000,0.000,0.009,0.145,3.207,0.000,2.417,5.523,136.025
 2849.500,0.225,0.035,72.053,66.908,2.966,2.849,0.000,0.007,0.074,0.005,2.540,2.883,0.000,0.000,0.011,0.203,3.234,0.001,2.325,5.233,135.411
 2850.000,0.227,0.053,75.684,68.545,3.005,2.831,0.000,0.008,0.072,0.005,0.800,0.944,0.000,0.000,0.013,0.258,3.170,0.001,2.321,4.673,134.237
 2850.500,0.212,0.082,76.969,68.708,3.044,2.934,0.000,0.008,0.068,0.005,4.817,2.569,0.000,0.000,0.013,0.245,3.174,0.002,2.348,3.744,132.756
 2851.000,0.125,0.135,80.309,63.204,3.084,3.043,0.000,0.008,0.066,0.005,9.015,4.932,0.000,0.000,0.013,0.220,3.422,0.002,2.497,3.747,133.092
 2851.500,0.098,0.067,82.758,60.339,3.112,3.134,0.000,0.009,0.065,0.005,6.729,5.231,0.000,0.000,0.014,0.214,3.672,0.001,2.543,4.380,132.945
 2852.000,0.080,0.057,75.667,58.165,3.102,3.241,0.000,0.013,0.060,0.004,3.688,3.119,0.000,0.000,0.017,0.207,3.765,0.001,2.574,4.689,134.325
 2852.500,0.065,0.058,72.602,52.613,3.038,3.391,7.000,0.018,0.055,0.004,2.078,2.118,0.000,0.000,0.022,0.164,3.924,0.001,2.599,4.139,133.712
 2853.000,0.062,0.047,72.180,45.726,2.914,3.470,0.000,0.029,0.045,0.005,5.313,2.657,0.001,0.000,0.034,0.114,3.865,0.001,2.605,5.204,132.136
 2853.500,0.057,0.040,70.914,35.925,2.769,3.291,0.000,0.039,0.038,0.005,20.001,16.120,0.001,0.000,0.044,0.102,4.049,0.002,2.613,7.780,127.634
 2854.000,0.089,-0.004,72.244,26.628,2.642,2.957,0.000,0.051,0.034,0.004,12.030,13.945,0.001,0.000,0.056,0.125,4.280,0.001,2.558,9.810,122.860
 2854.500,0.096,-0.005,66.189,24.145,2.509,2.626,0.000,0.063,0.030,0.004,5.924,6.184,0.001,0.000,0.067,0.155,4.029,0.000,2.546,9.429,119.343
 2855.000,0.097,-0.001,62.947,24.365,2.371,2.394,0.000,0.104,0.021,0.002,5.487,5.083,0.001,0.000,0.106,0.162,3.937,0.000,2.545,6.352,120.028
 2855.500,0.086,0.001,66.622,23.282,2.241,2.235,0.000,0.116,0.018,0.002,8.123,6.453,0.001,0.000,0.118,0.151,4.088,0.000,2.563,4.833,119.874
 2856.000,0.071,0.008,69.206,25.700,2.167,2.119,0.000,0.128,0.016,0.002,14.305,11.597,0.002,0.000,0.130,0.148,4.101,0.000,2.589,5.849,119.396
 2856.500,0.071,0.011,68.617,28.208,2.170,2.052,0.000,0.130,0.018,0.002,12.613,11.696,0.010,0.000,0.131,0.153,3.737,0.000,2.588,6.660,121.161
 2857.000,0.077,0.016,68.198,28.354,2.251,2.069,0.000,0.125,0.023,0.002,9.291,7.184,0.021,0.000,0.126,0.165,3.708,0.000,2.578,6.544,126.530
 2857.500,0.083,0.011,66.881,31.716,2.388,2.174,0.000,0.114,0.025,0.001,5.955,4.116,0.047,0.000,0.115,0.173,3.628,0.000,2.567,5.339,133.883
 2858.000,0.082,0.013,68.619,35.526,2.543,2.369,0.000,0.088,0.031,0.001,4.051,2.613,0.065,0.000,0.089,0.173,3.338,0.000,2.569,3.848,142.209
 2858.500,0.079,0.016,71.713,39.116,2.704,2.610,0.000,0.067,0.035,0.001,2.914,2.344,0.078,0.000,0.068,0.172,3.200,0.000,2.575,3.552,149.254
 2859.000,0.072,0.021,73.495,44.570,2.874,2.839,0.000,0.039,0.040,0.001,3.463,2.584,0.072,0.000,0.040,0.176,3.170,0.002,2.587,3.851,154.807
 2859.500,0.068,0.033,73.639,54.421,3.098,3.054,0.000,0.026,0.044,0.001,4.840,2.982,0.050,0.000,0.026,0.179,3.132,0.001,2.594,4.371,158.035
 2860.000,0.077,0.031,74.994,61.723,3.395,3.242,0.000,0.008,0.051,0.002,3.866,2.757,0.034,0.000,0.010,0.186,3.052,0.000,2.579,4.684,159.298
 2860.500,0.076,0.039,76.880,66.811,3.787,3.444,0.000,0.003,0.052,0.002,3.590,2.310,0.015,0.000,0.005,0.195,3.071,0.000,2.579,4.683,159.209
 2861.000,0.076,0.041,78.077,74.178,4.253,3.728,0.000,0.003,0.051,0.001,3.263,2.070,0.007,0.000,0.004,0.194,3.246,0.000,2.580,4.515,161.965
 2861.500,0.079,0.027,79.820,82.180,4.786,4.188,0.000,0.002,0.053,0.001,3.373,2.111,0.002,0.000,0.004,0.171,3.481,0.000,2.575,4.428,164.614
 2862.000,0.065,0.025,80.933,85.673,5.311,4.947,0.000,0.002,0.054,0.001,3.959,2.377,0.001,0.000,0.003,0.123,3.593,0.000,2.599,4.529,162.997
 2862.500,0.055,0.017,78.294,87.065,5.772,6.010,0.000,0.002,0.055,0.001,14.176,6.937,0.001,0.000,0.004,0.071,3.770,0.000,2.616,6.042,159.622
 2863.000,0.052,0.011,72.473,84.207,6.201,7.195,0.000,0.004,0.052,0.001,58.387,44.384,0.000,0.000,0.005,0.040,3.805,0.000,2.620,10.687,156.973
 2863.500,0.053,0.013,66.286,83.450,6.668,8.046,0.000,0.005,0.045,0.001,70.017,81.038,0.000,0.000,0.006,0.034,3.923,0.000,2.619,21.843,156.701
 2864.000,0.064,0.012,58.481,90.427,7.242,8.293,0.000,0.005,0.040,0.001,44.428,43.469,0.000,0.000,0.006,0.051,3.860,0.000,2.601,52.898,156.707
 2864.500,0.068,0.018,55.266,100.831,7.909,8.189,0.000,0.003,0.034,0.002,13.469,13.705,0.000,0.000,0.004,0.085,3.774,0.000,2.594,32.957,156.872
 2865.000,0.072,0.016,58.280,108.345,8.512,8.066,0.000,0.003,0.032,0.001,5.000,3.543,0.000,0.000,0.004,0.121,3.889,0.000,2.587,17.517,157.698
 2865.500,0.066,0.023,63.552,107.758,8.841,8.228,0.000,0.005,0.031,0.001,4.082,2.761,0.000,0.000,0.006,0.131,3.882,0.000,2.597,11.500,158.094
 2866.000,0.059,0.023,70.102,92.633,8.827,8.762,0.000,0.007,0.032,0.001,4.102,2.764,0.000,0.000,0.008,0.112,3.771,0.000,2.610,9.115,157.185
 2866.500,0.053,0.021,72.344,70.466,8.612,9.654,0.000,0.006,0.035,0.001,9.832,5.452,0.000,0.000,0.007,0.072,3.743,0.000,2.620,10.131,154.801
 2867.000,0.049,0.021,69.100,55.674,8.395,10.537,7.000,0.007,0.037,0.001,30.466,38.174,0.000,0.000,0.008,0.044,3.736,0.000,2.627,15.101,151.650
 2867.500,0.047,0.024,64.214,49.357,8.304,11.281,0.000,0.011,0.040,0.001,54.822,62.824,0.000,0.000,0.012,0.035,3.647,0.000,2.629,27.309,149.951
 2868.000,0.053,0.026,59.792,46.825,8.278,10.515,0.000,0.012,0.041,0.001,34.202,35.161,0.000,0.000,0.013,0.043,3.592,0.000,2.619,39.541,149.095
 2868.500,0.067,0.017,57.206,48.112,8.133,9.663,0.000,0.008,0.041,0.002,10.310,8.122,0.000,0.000,0.010,0.066,3.761,0.000,2.595,26.145,148.487
 2869.000,0.079,0.017,58.203,51.661,7.692,8.621,0.000,0.006,0.041,0.002,8.384,5.659,0.000,0.000,0.008,0.094,3.716,0.000,2.576,16.012,148.116
 2869.500,0.085,0.021,62.253,49.732,7.034,7.602,0.000,0.006,0.043,0.002,5.783,3.791,0.000,0.000,0.008,0.117,3.648,0.000,2.565,11.149,147.596
 2870.000,0.092,0.020,67.116,51.466,6.328,6.702,0.000,0.007,0.045,0.002,4.747,3.115,0.000,0.000,0.009,0.133,3.637,0.000,2.553,9.418,148.847
 2870.500,0.096,0.022,70.167,54.673,5.712,5.975,0.000,0.009,0.048,0.002,4.308,2.809,0.000,0.000,0.011,0.146,3.639,0.000,2.546,7.924,149.561
 2871.000,0.098,0.025,73.158,56.960,5.267,5.427,0.000,0.009,0.050,0.002,3.854,2.476,0.000,0.000,0.011,0.150,3.580,0.000,2.542,7.158,150.104
 2871.500,0.096,0.031,74.378,58.670,4.939,5.031,0.000,0.009,0.054,0.002,4.004,2.720,0.000,0.000,0.011,0.158,3.631,0.000,2.546,6.833,150.617
 2872.000,0.096,0.035,75.623,61.194,4.739,4.758,0.000,0.009,0.056,0.002,4.434,2.857,0.000,0.000,0.011,0.162,3.647,0.000,2.546,6.472,151.426
 2872.500,0.099,0.031,77.264,60.770,4.633,4.580,0.000,0.016,0.058,0.002,3.866,2.547,0.000,0.000,0.017,0.166,3.684,0.000,2.541,6.355,151.857
 2873.000,0.104,0.025,77.691,60.990,4.581,4.479,0.000,0.020,0.058,0.001,3.567,2.044,0.000,0.000,0.021,0.166,3.710,0.000,2.533,6.207,152.459
 2873.500,0.107,0.018,78.500,63.652,4.551,4.433,0.000,0.024,0.057,0.001,3.854,2.355,0.000,0.000,0.025,0.168,3.630,0.000,2.527,6.070,152.441
 2874.000,0.108,0.025,79.109,66.982,4.512,4.421,0.000,0.021,0.056,0.001,3.891,2.484,0.000,0.000,0.022,0.168,3.542,0.000,2.525,6.067,152.582
 2874.500,0.116,0.025,79.559,68.447,4.439,4.420,0.000,0.022,0.054,0.001,3.728,2.273,0.000,0.000,0.023,0.171,3.473,0.000,2.512,6.013,151.680
 2875.000,0.123,0.025,79.600,71.394,4.353,4.393,0.000,0.031,0.053,0.001,3.767,2.259,0.000,0.000,0.031,0.173,3.385,0.001,2.499,6.016,149.785
 2875.500,0.119,0.038,79.780,73.087,4.270,4.316,0.000,0.048,0.049,0.001,3.249,2.203,0.000,0.000,0.048,0.171,3.316,0.001,2.506,5.912,148.493
 2876.000,0.123,0.041,79.738,71.866,4.217,4.206,0.000,0.053,0.046,0.001,3.609,2.517,0.000,0.000,0.053,0.172,3.254,0.002,2.501,5.768,147.319
 2876.500,0.123,0.040,79.684,71.834,4.201,4.106,0.000,0.048,0.043,0.001,3.930,2.761,0.000,0.000,0.048,0.175,3.275,0.003,2.500,5.586,147.048
 2877.000,0.122,0.033,80.036,70.271,4.212,4.056,0.000,0.043,0.040,0.001,3.764,2.672,0.000,0.000,0.044,0.180,3.271,0.005,2.501,5.414,146.811
 2877.500,0.117,0.028,80.288,69.652,4.239,4.069,0.000,0.040,0.036,0.001,3.722,2.591,0.000,0.000,0.040,0.179,3.423,0.006,2.510,5.372,147.832
 2878.000,0.113,0.020,80.369,66.786,4.280,4.145,0.000,0.034,0.035,0.001,3.528,2.454,0.000,0.000,0.035,0.170,3.521,0.006,2.517,5.324,148.204
 2878.500,0.100,0.023,80.289,64.067,4.356,4.269,0.000,0.021,0.035,0.001,3.683,2.410,0.000,0.000,0.022,0.159,3.543,0.004,2.540,5.417,148.794
 2879.000,0.091,0.029,78.581,60.241,4.480,4.420,0.000,0.015,0.036,0.002,5.555,3.433,0.000,0.000,0.017,0.142,3.517,0.002,2.554,6.024,150.122
 2879.500,0.093,0.027,77.583,58.255,4.655,4.599,0.000,0.017,0.038,0.002,4.859,3.156,0.000,0.000,0.019,0.135,3.427,0.001,2.551,6.368,149.420
 2880.000,0.092,0.038,75.195,56.798,4.864,4.793,0.000,0.020,0.038,0.002,4.665,2.908,0.000,0.000,0.022,0.127,3.366,0.001,2.552,6.691,147.514
 2880.500,0.096,0.037,72.541,58.003,5.051,4.984,15.000,0.022,0.037,0.002,6.960,4.016,0.000,0.000,0.024,0.114,3.324,0.001,2.545,6.914,143.773
 2881.000,0.102,0.027,71.275,60.754,5.135,5.147,0.000,0.022,0.035,0.002,11.177,5.530,0.000,0.000,0.024,0.110,3.346,0.001,2.535,7.520,142.404
 2881.500,0.092,0.029,70.588,64.483,5.099,5.232,0.000,0.025,0.034,0.002,7.658,4.426,0.000,0.000,0.026,0.117,3.417,0.001,2.553,7.687,142.657
 2882.000,0.082,0.037,69.983,65.378,4.937,5.198,0.000,0.028,0.033,0.001,5.780,3.728,0.000,0.000,0.030,0.123,3.484,0.001,2.569,7.697,144.327
 2882.500,0.092,0.029,69.864,65.842,4.708,4.995,0.000,0.032,0.034,0.001,7.123,4.304,0.000,0.000,0.033,0.124,3.415,0.001,2.552,7.640,145.313
 2883.000,0.101,0.027,72.025,67.381,4.471,4.674,0.000,0.034,0.035,0.001,6.794,4.204,0.000,0.000,0.035,0.128,3.313,0.002,2.537,7.380,145.224
 2883.500,0.105,0.038,73.816,67.079,4.237,4.308,0.000,0.038,0.037,0.001,5.028,3.285,0.000,0.000,0.039,0.135,3.177,0.002,2.531,7.150,144.339
 2884.000,0.110,0.045,74.584,65.288,4.013,4.005,0.000,0.042,0.038,0.001,4.296,2.783,0.000,0.000,0.043,0.146,2.991,0.002,2.521,6.391,142.156
 2884.500,0.121,0.041,75.814,65.264,3.803,3.778,0.000,0.047,0.039,0.001,4.082,2.572,0.001,0.000,0.048,0.154,2.859,0.002,2.503,5.362,140.386
 2885.000,0.123,0.042,78.097,63.400,3.624,3.597,0.000,0.044,0.039,0.001,4.029,2.550,0.001,0.000,0.045,0.154,2.893,0.004,2.499,4.917,140.356
 2885.500,0.124,0.043,78.017,64.108,3.508,3.461,0.000,0.034,0.038,0.002,4.043,2.635,0.000,0.000,0.036,0.154,2.838,0.007,2.498,4.860,140.197
 2886.000,0.131,0.035,78.298,66.770,3.487,3.372,0.000,0.029,0.037,0.002,4.142,2.595,0.000,0.000,0.031,0.158,2.781,0.010,2.486,4.833,140.439
 2886.500,0.132,0.040,77.495,69.725,3.585,3.356,0.000,0.030,0.035,0.002,3.967,2.776,0.000,0.000,0.032,0.164,2.884,0.010,2.485,4.825,142.799
 2887.000,0.130,0.031,77.936,71.003,3.801,3.453,0.000,0.030,0.035,0.002,3.350,2.340,0.001,0.000,0.032,0.174,3.081,0.007,2.488,4.710,144.770
 2887.500,0.117,0.027,79.228,69.774,4.146,3.702,0.000,0.023,0.035,0.001,3.131,2.281,0.001,0.000,0.024,0.176,3.331,0.003,2.510,4.580,147.520
 2888.000,0.097,0.023,79.966,64.393,4.623,4.146,0.000,0.016,0.035,0.001,3.162,2.469,0.001,0.000,0.017,0.152,3.610,0.001,2.543,4.709,148.564
 2888.500,0.070,0.034,78.659,60.941,5.261,4.826,0.000,0.008,0.035,0.001,4.972,2.927,0.001,0.000,0.010,0.119,3.983,0.000,2.591,5.702,149.827
 2889.000,0.054,0.026,76.847,56.895,6.090,5.758,0.000,0.005,0.036,0.001,9.299,5.763,0.001,0.000,0.006,0.088,4.345,0.000,2.618,7.827,149.160
 2889.500,0.041,0.014,73.823,54.201,7.176,7.033,0.000,0.002,0.037,0.001,10.119,6.974,0.002,0.000,0.003,0.068,4.526,0.000,2.640,10.287,148.835
 2890.000,0.037,0.012,68.336,53.143,8.374,8.671,0.000,0.001,0.039,0.001,15.108,8.484,0.002,0.000,0.002,0.050,4.458,0.000,2.648,12.608,147.673
 2890.500,0.030,0.015,63.091,52.703,9.153,10.354,0.000,0.001,0.043,0.001,44.270,34.906,0.001,0.000,0.002,0.039,4.271,0.000,2.659,17.514,146.882
 2891.000,0.033,0.008,61.520,51.938,8.848,11.466,0.000,0.001,0.047,0.001,26.873,26.251,0.001,0.000,0.002,0.040,4.096,0.000,2.654,21.551,146.145
 2891.500,0.040,0.005,60.131,56.106,7.717,10.139,0.000,0.001,0.052,0.001,13.176,10.736,0.000,0.000,0.002,0.051,4.026,0.000,2.642,24.926,146.882
 2892.000,0.047,0.021,58.430,61.495,6.389,8.140,0.000,0.001,0.055,0.002,6.763,4.718,0.000,0.000,0.003,0.072,3.693,0.000,2.630,19.137,146.865
 2892.500,0.062,0.069,60.206,68.773,5.316,6.128,0.000,0.002,0.058,0.002,8.587,5.512,0.000,0.000,0.003,0.100,3.375,0.000,2.604,14.086,146.410
 2893.000,0.145,0.134,64.092,78.574,4.551,4.660,0.000,0.002,0.060,0.002,6.977,5.249,0.000,0.000,0.003,0.139,3.201,0.000,2.463,10.247,145.661
 2893.500,0.226,0.164,68.830,85.477,4.076,3.758,0.000,0.002,0.062,0.002,2.219,2.137,0.000,0.000,0.003,0.201,3.043,0.000,2.324,7.726,145.171
 2894.000,0.285,0.208,74.675,88.636,3.831,3.322,0.000,0.001,0.063,0.002,0.895,1.413,0.000,0.000,0.003,0.279,2.952,0.000,2.222,5.522,144.947
 2894.500,0.317,0.215,81.367,88.978,3.715,3.249,7.000,0.001,0.063,0.002,0.839,1.081,0.000,0.000,0.003,0.316,2.932,0.001,2.169,3.824,143.790
 2895.000,0.301,0.221,87.984,84.663,3.690,3.434,0.000,0.001,0.063,0.002,0.847,1.136,0.000,0.000,0.003,0.303,3.097,0.001,2.196,3.356,142.858
 2895.500,0.240,0.203,91.531,76.482,3.758,3.781,0.000,0.001,0.064,0.002,3.930,2.259,0.000,0.000,0.003,0.248,3.383,0.000,2.299,3.584,143.985
 2896.000,0.188,0.150,88.856,69.359,3.942,4.166,0.000,0.001,0.066,0.002,5.330,3.041,0.000,0.000,0.003,0.181,3.501,0.000,2.389,4.797,146.174
 2896.500,0.067,0.145,83.270,63.074,4.270,4.493,0.000,0.001,0.066,0.002,4.564,3.673,0.000,0.000,0.003,0.144,3.948,0.000,2.595,6.038,148.328
 2897.000,0.054,0.072,76.694,59.012,4.739,4.808,0.000,0.001,0.063,0.001,5.155,4.075,0.000,0.000,0.002,0.132,3.995,0.000,2.618,7.099,149.514
 2897.500,0.036,0.070,70.455,59.948,5.240,5.134,0.000,0.002,0.055,0.001,4.555,3.765,0.000,0.000,0.003,0.124,4.067,0.000,2.649,7.558,151.031
 2898.000,0.062,0.027,70.200,61.894,5.622,5.446,0.000,0.003,0.050,0.001,4.417,3.717,0.000,0.000,0.004,0.127,3.977,0.000,2.604,7.461,152.223
 2898.500,0.071,0.014,71.367,63.848,5.798,5.639,0.000,0.003,0.044,0.001,4.189,3.551,0.000,0.000,0.004,0.131,3.813,0.000,2.589,7.274,153.969
 2899.000,0.073,0.019,72.619,65.134,5.753,5.665,0.000,0.002,0.042,0.001,3.598,3.366,0.000,0.000,0.003,0.141,3.750,0.000,2.585,6.853,152.813
 2899.500,0.078,0.021,72.889,65.866,5.568,5.562,0.000,0.002,0.042,0.001,3.770,3.636,0.000,0.000,0.003,0.146,3.705,0.000,2.577,6.388,153.668
 2900.000,0.076,0.025,73.809,64.987,5.356,5.409,0.000,0.002,0.043,0.001,3.716,3.348,0.000,0.000,0.003,0.149,3.679,0.000,2.580,6.102,151.036
 2900.500,0.079,0.026,73.573,63.131,5.171,5.261,0.000,0.001,0.045,0.001,4.187,3.134,0.000,0.000,0.002,0.146,3.628,0.000,2.574,6.039,149.119
 2901.000,0.073,0.034,72.036,61.308,5.040,5.147,0.000,0.001,0.046,0.001,4.009,2.997,0.000,0.000,0.002,0.140,3.643,0.000,2.586,6.050,148.776
 2901.500,0.072,0.036,71.272,59.077,4.959,5.066,0.000,0.001,0.047,0.001,3.652,2.975,0.000,0.000,0.002,0.138,3.542,0.000,2.587,6.074,148.352
 2902.000,0.075,0.030,71.242,54.868,4.914,5.002,0.000,0.001,0.046,0.002,4.569,3.418,0.000,0.000,0.003,0.123,3.350,0.000,2.582,6.050,146.086
 2902.500,0.079,0.028,70.211,52.060,4.880,4.952,0.000,0.001,0.047,0.002,6.839,4.640,0.000,0.000,0.003,0.110,3.219,0.000,2.575,6.188,142.988
 2903.000,0.079,0.028,69.925,50.253,4.817,4.906,0.000,0.002,0.049,0.002,6.467,4.038,0.000,0.000,0.004,0.098,3.095,0.000,2.575,6.122,138.922
 2903.500,0.081,0.031,69.050,49.943,4.697,4.854,0.000,0.006,0.053,0.003,5.389,3.595,0.000,0.000,0.008,0.091,3.090,0.000,2.572,6.105,137.317
 2904.000,0.082,0.034,67.728,49.528,4.538,4.753,0.000,0.008,0.057,0.003,5.282,3.555,0.000,0.000,0.011,0.087,3.151,0.000,2.570,5.977,136.544
 2904.500,0.079,0.042,68.502,50.383,4.411,4.547,0.000,0.009,0.062,0.003,5.988,3.843,0.000,0.000,0.012,0.088,3.262,0.000,2.575,5.945,135.936
 2905.000,0.080,0.043,69.134,51.742,4.301,4.297,0.000,0.009,0.065,0.003,8.764,5.368,0.000,0.000,0.012,0.097,3.297,0.000,2.574,6.038,134.774
 2905.500,0.083,0.036,69.708,54.388,4.208,4.095,0.000,0.007,0.067,0.003,4.955,4.389,0.000,0.000,0.009,0.116,3.365,0.000,2.568,5.777,136.001
 2906.000,0.079,0.037,70.636,57.359,4.108,3.980,0.000,0.005,0.067,0.003,4.936,2.872,0.000,0.000,0.008,0.136,3.313,0.000,2.574,5.242,137.217
 2906.500,0.074,0.040,71.155,60.119,3.981,3.944,0.000,0.004,0.065,0.004,4.598,3.023,0.000,0.000,0.007,0.146,3.264,0.000,2.584,4.836,138.509
 2907.000,0.071,0.041,72.139,60.583,3.884,3.919,0.000,0.004,0.061,0.005,4.423,3.270,0.000,0.000,0.008,0.157,3.220,0.000,2.589,4.718,139.506
 2907.500,0.085,0.041,72.463,62.390,3.897,3.853,0.000,0.005,0.055,0.007,4.392,2.860,0.000,0.000,0.011,0.167,3.064,0.003,2.564,4.928,139.731
 2908.000,0.134,0.067,70.875,64.393,4.037,3.790,7.000,0.005,0.053,0.008,4.530,3.034,0.000,0.000,0.013,0.172,3.017,0.009,2.481,5.286,138.904
 2908.500,0.192,0.039,71.016,63.970,4.292,3.880,0.000,0.006,0.052,0.009,4.614,3.274,0.000,0.000,0.015,0.196,3.133,0.019,2.381,5.271,138.421
 2909.000,0.198,0.041,75.886,58.906,4.616,4.216,0.000,0.009,0.048,0.014,1.292,1.579,0.000,0.001,0.023,0.214,3.387,0.082,2.371,4.648,135.423
 2909.500,0.202,0.039,75.898,49.154,4.904,4.884,0.000,0.012,0.045,0.018,7.897,5.390,0.000,0.003,0.030,0.170,3.665,0.158,2.364,4.719,130.301
 2910.000,0.149,0.073,74.842,37.284,5.168,5.646,0.000,0.018,0.036,0.024,14.165,14.240,0.000,0.009,0.042,0.112,3.980,0.273,2.456,7.337,125.610
 2910.500,0.105,0.042,79.623,24.569,5.531,6.240,0.000,0.022,0.030,0.028,10.704,12.889,0.000,0.015,0.050,0.086,4.538,0.208,2.530,12.083,119.739
 2911.000,0.088,0.040,69.053,18.186,6.101,6.608,0.000,0.028,0.023,0.031,11.952,13.893,0.001,0.023,0.060,0.083,4.628,0.121,2.560,21.495,114.221
 2911.500,0.073,0.040,60.477,15.891,6.932,7.055,0.000,0.032,0.019,0.033,15.924,16.493,0.005,0.028,0.064,0.088,4.588,0.047,2.585,24.408,109.654
 2912.000,0.065,0.037,60.684,15.679,7.904,7.850,0.000,0.037,0.013,0.034,12.875,14.395,0.020,0.032,0.070,0.087,4.564,0.054,2.599,21.118,107.719
 2912.500,0.066,0.033,59.764,15.777,8.564,9.013,0.000,0.040,0.009,0.034,11.408,13.277,0.163,0.033,0.074,0.076,4.532,0.056,2.598,20.529,106.545
 2913.000,0.064,0.030,59.336,14.621,8.484,10.194,0.000,0.044,0.004,0.034,12.760,15.832,0.386,0.032,0.078,0.063,4.512,0.055,2.600,24.266,104.733
 2913.500,0.060,0.038,59.120,13.929,7.699,11.153,0.000,0.045,0.001,0.033,12.489,15.230,0.973,0.031,0.079,0.057,4.565,0.053,2.608,31.981,103.854
 2914.000,0.061,0.046,58.581,14.002,6.660,9.900,0.000,0.048,0.000,0.032,15.612,19.871,1.464,0.029,0.080,0.059,4.431,0.055,2.606,47.477,104.290
 2914.500,0.070,0.051,57.927,15.638,5.742,8.040,0.000,0.051,0.000,0.032,21.972,26.956,2.188,0.028,0.083,0.071,4.138,0.053,2.590,60.039,105.954
 2915.000,0.088,0.044,58.822,18.496,5.101,6.183,0.000,0.059,0.000,0.028,13.717,18.645,2.487,0.019,0.087,0.096,3.931,0.037,2.559,47.612,106.975
 2915.500,0.086,0.047,60.627,23.274,4.611,4.893,0.000,0.066,0.000,0.024,7.785,9.466,2.569,0.013,0.090,0.119,3.792,0.025,2.564,26.129,107.347
 2916.000,0.081,0.043,63.045,29.046,4.242,4.117,0.000,0.074,0.001,0.020,5.079,5.552,2.419,0.008,0.094,0.136,3.619,0.014,2.571,14.237,108.061
 2916.500,0.069,0.043,65.700,33.507,3.957,3.745,0.000,0.077,0.002,0.018,7.334,6.117,2.173,0.007,0.095,0.129,3.597,0.011,2.592,8.358,111.802
 2917.000,0.050,0.040,68.789,35.925,3.766,3.628,0.000,0.078,0.004,0.017,10.476,6.501,2.070,0.006,0.095,0.123,3.740,0.010,2.625,5.442,116.670
 2917.500,0.043,0.042,70.352,37.309,3.731,3.691,0.000,0.077,0.003,0.017,11.318,8.004,1.970,0.006,0.094,0.117,3.797,0.010,2.636,5.098,115.950
 2918.000,0.064,0.027,68.519,37.936,3.865,3.884,0.000,0.077,0.003,0.017,11.428,10.703,1.885,0.006,0.094,0.114,3.882,0.010,2.601,6.428,113.626
 2918.500,0.078,0.022,66.838,37.016,4.194,4.203,0.000,0.071,0.004,0.020,8.987,10.212,1.736,0.009,0.092,0.104,4.028,0.015,2.576,8.252,110.793
 2919.000,0.085,0.019,65.431,34.728,4.695,4.660,0.000,0.066,0.004,0.024,7.250,8.329,1.598,0.013,0.090,0.091,4.165,0.022,2.564,10.993,108.622
 2919.500,0.085,0.014,64.661,33.393,5.285,5.251,0.000,0.056,0.004,0.030,7.878,9.075,1.312,0.022,0.085,0.073,4.279,0.038,2.565,14.074,107.099
 2920.000,0.076,0.010,63.734,32.481,5.876,5.967,0.000,0.049,0.004,0.032,7.346,9.326,1.118,0.029,0.081,0.060,4.425,0.050,2.580,15.699,107.436
 2920.500,0.070,0.006,62.478,30.699,6.404,6.821,0.000,0.044,0.002,0.033,15.012,15.315,0.938,0.031,0.078,0.054,4.765,0.053,2.591,19.873,107.400
 2921.000,0.057,0.009,60.484,30.511,6.813,7.750,0.000,0.043,0.001,0.034,19.711,20.739,0.950,0.032,0.077,0.052,4.800,0.054,2.612,22.327,106.745
 2921.500,0.048,0.007,59.058,29.421,7.022,8.524,0.000,0.041,0.002,0.033,12.348,14.203,1.199,0.031,0.075,0.051,4.696,0.053,2.628,25.888,105.122
 2922.000,0.057,0.016,55.906,30.479,6.954,8.928,0.000,0.039,0.002,0.033,19.663,19.985,1.470,0.030,0.072,0.049,4.734,0.051,2.613,31.229,103.458
 2922.500,0.071,0.020,56.567,32.091,6.633,8.739,0.000,0.036,0.004,0.033,32.544,32.569,1.836,0.029,0.069,0.057,4.735,0.067,2.588,38.244,104.220
 2923.000,0.093,0.016,58.680,32.140,6.179,8.108,0.000,0.037,0.004,0.034,14.488,17.065,2.019,0.031,0.070,0.070,4.636,0.135,2.550,31.587,104.869
 2923.500,0.125,0.010,59.480,32.994,5.715,7.280,7.000,0.040,0.003,0.036,7.709,10.219,2.169,0.040,0.076,0.080,4.487,0.267,2.496,28.661,104.733
 2924.000,0.154,0.001,62.530,31.586,5.331,6.457,0.000,0.043,0.004,0.038,8.041,10.097,2.158,0.049,0.080,0.085,4.499,0.416,2.447,22.911,105.376
 2924.500,0.164,-0.001,64.844,29.070,5.084,5.798,0.000,0.047,0.007,0.040,7.903,9.337,1.982,0.062,0.087,0.091,4.363,0.353,2.430,20.408,106.663
 2925.000,0.163,-0.002,66.678,29.974,4.930,5.335,0.000,0.051,0.009,0.041,7.058,8.775,1.852,0.069,0.091,0.096,4.335,0.221,2.431,19.074,107.141
 2925.500,0.150,-0.003,68.091,37.447,4.873,5.085,0.000,0.056,0.012,0.041,6.236,8.155,1.814,0.071,0.097,0.095,4.339,0.121,2.454,15.893,110.840
 2926.000,0.127,-0.003,67.697,52.597,4.865,4.992,0.000,0.061,0.014,0.038,6.754,8.255,1.983,0.058,0.099,0.086,4.275,0.098,2.494,14.543,117.249
 2926.500,0.095,0.015,66.261,68.187,4.836,4.972,0.000,0.063,0.019,0.031,15.400,13.347,2.688,0.030,0.094,0.072,4.097,0.051,2.548,15.210,123.633
 2927.000,0.076,0.018,64.695,80.259,4.721,4.965,0.000,0.062,0.021,0.029,23.461,15.743,3.444,0.022,0.090,0.070,3.942,0.037,2.579,15.409,131.481
 2927.500,0.070,0.022,64.111,86.519,4.477,4.882,0.000,0.061,0.023,0.026,11.588,7.734,4.662,0.015,0.087,0.088,3.720,0.032,2.590,13.255,140.822
 2928.000,0.063,0.101,64.467,86.096,4.136,4.605,0.000,0.049,0.028,0.018,4.215,3.233,5.197,0.004,0.067,0.115,3.417,0.076,2.602,9.655,145.679
 2928.500,0.133,0.161,66.784,83.410,3.792,4.099,0.000,0.027,0.037,0.008,4.108,2.805,5.246,0.000,0.035,0.156,3.245,0.069,2.483,7.150,146.912
 2929.000,0.190,0.186,71.250,84.517,3.514,3.508,0.000,0.022,0.041,0.005,2.734,2.362,4.605,0.000,0.027,0.203,3.179,0.085,2.385,5.848,144.150
 2929.500,0.230,0.210,76.527,85.038,3.328,3.041,0.000,0.016,0.050,0.002,0.937,1.642,2.822,0.000,0.019,0.273,3.124,0.028,2.317,5.321,140.905
 2930.000,0.251,0.246,80.758,87.366,3.165,2.804,0.000,0.013,0.055,0.002,0.921,1.162,1.602,0.000,0.014,0.323,3.143,0.011,2.281,4.361,138.474
 2930.500,0.237,0.245,87.695,85.738,3.034,2.768,0.000,0.008,0.060,0.002,0.887,1.007,0.488,0.000,0.010,0.330,3.196,0.003,2.305,3.329,137.299
 2931.000,0.210,0.200,91.944,80.202,2.924,2.847,0.000,0.006,0.062,0.003,0.893,1.000,0.213,0.000,0.009,0.280,3.119,0.003,2.351,2.916,136.467
 2931.500,0.176,0.186,93.523,76.124,2.868,2.926,0.000,0.005,0.061,0.004,1.979,1.365,0.042,0.000,0.008,0.211,3.093,0.003,2.409,3.219,136.686
 2932.000,0.090,0.260,92.627,74.504,2.931,2.921,0.000,0.004,0.060,0.004,3.029,2.262,0.015,0.000,0.008,0.192,3.464,0.002,2.557,3.688,138.816
 2932.500,0.139,0.249,84.328,73.975,3.150,2.903,0.000,0.004,0.057,0.004,2.506,2.244,0.002,0.000,0.008,0.198,3.493,0.003,2.473,4.149,140.327
 2933.000,0.176,0.216,75.750,71.247,3.510,2.997,0.000,0.003,0.054,0.005,1.810,1.849,0.001,0.000,0.008,0.227,3.603,0.004,2.409,4.464,139.719
 2933.500,0.178,0.207,75.328,66.705,4.039,3.319,0.000,0.005,0.048,0.007,1.143,1.361,0.000,0.000,0.012,0.245,3.924,0.015,2.405,4.049,137.057
 2934.000,0.165,0.195,70.405,59.427,4.609,4.021,0.000,0.007,0.044,0.009,2.182,1.302,0.000,0.000,0.016,0.196,4.166,0.043,2.427,3.851,133.157
 2934.500,0.138,0.146,71.656,49.007,5.162,5.010,0.000,0.013,0.036,0.015,9.426,6.412,0.000,0.001,0.028,0.136,4.264,0.181,2.474,5.253,130.968
 2935.000,0.107,0.081,78.181,39.466,5.757,6.134,0.000,0.016,0.030,0.019,15.764,15.071,0.000,0.004,0.036,0.098,4.598,0.364,2.526,8.663,126.902
 2935.500,0.124,0.026,63.073,32.319,6.553,6.962,0.000,0.020,0.021,0.028,10.279,13.192,0.000,0.015,0.047,0.082,4.678,0.775,2.498,15.132,119.969
 2936.000,0.160,0.005,56.788,26.099,7.690,7.781,0.000,0.022,0.017,0.033,6.622,9.492,0.001,0.030,0.054,0.075,4.707,0.834,2.437,22.468,113.537
 2936.500,0.174,-0.003,60.755,22.371,9.115,9.015,0.000,0.025,0.012,0.039,5.577,7.845,0.005,0.060,0.064,0.070,4.732,0.780,2.412,24.727,108.628
 2937.000,0.174,-0.003,63.675,19.977,10.244,11.278,0.000,0.027,0.010,0.041,6.543,8.724,0.017,0.077,0.068,0.060,4.719,0.651,2.412,23.636,104.137
 2937.500,0.158,-0.003,65.588,18.365,10.310,13.500,7.000,0.027,0.009,0.043,9.063,10.692,0.153,0.089,0.069,0.047,4.928,0.526,2.440,25.781,100.071
 2938.000,0.118,-0.000,65.748,16.509,9.205,14.890,0.000,0.026,0.009,0.042,11.231,14.148,0.463,0.088,0.069,0.036,4.989,0.400,2.508,32.532,98.443
 2938.500,0.082,0.010,64.648,14.849,7.597,13.905,0.000,0.026,0.008,0.042,12.360,14.510,1.593,0.080,0.068,0.032,5.030,0.484,2.569,38.366,97.269
 2939.000,0.092,0.002,61.055,15.720,6.113,10.366,0.000,0.027,0.006,0.042,20.409,21.126,2.900,0.081,0.069,0.036,4.974,0.715,2.553,53.530,95.717
 2939.500,0.116,0.002,59.033,17.869,5.010,7.306,0.000,0.029,0.003,0.044,19.621,24.272,5.228,0.097,0.073,0.053,4.888,1.193,2.512,55.547,94.295
 2940.000,0.153,-0.006,58.695,19.904,4.201,5.286,0.000,0.031,0.002,0.046,6.850,9.883,6.419,0.123,0.078,0.076,4.692,2.543,2.449,33.771,92.099
 2940.500,0.192,-0.007,59.936,22.420,3.649,4.097,0.000,0.037,0.000,0.052,5.479,7.151,6.865,0.190,0.089,0.097,4.566,4.085,2.382,20.420,91.238
 2941.000,0.212,-0.005,62.877,22.623,3.297,3.434,0.000,0.042,0.000,0.056,5.690,6.449,6.564,0.254,0.099,0.110,4.464,5.344,2.348,12.438,91.232
 2941.500,0.211,-0.002,68.780,20.938,3.087,3.079,0.000,0.051,0.000,0.061,6.709,7.277,6.266,0.338,0.112,0.113,4.374,4.315,2.349,9.680,92.648
 2942.000,0.201,-0.000,71.825,19.855,3.028,2.930,0.000,0.056,0.000,0.062,6.597,7.513,6.835,0.352,0.118,0.112,4.265,3.008,2.367,9.060,95.186
 2942.500,0.185,0.007,71.656,18.308,3.127,2.945,0.000,0.064,0.001,0.059,6.478,7.158,9.121,0.290,0.122,0.108,4.076,1.115,2.394,9.508,98.484
 2943.000,0.167,0.010,70.938,19.399,3.400,3.142,0.000,0.068,0.002,0.054,7.464,8.163,12.240,0.216,0.122,0.100,3.774,0.368,2.425,10.278,102.839
 2943.500,0.137,0.012,69.273,24.349,3.851,3.539,0.000,0.072,0.005,0.043,9.009,9.385,20.294,0.096,0.115,0.087,3.806,0.164,2.476,10.534,109.802
 2944.000,0.100,0.020,66.914,29.673,4.439,4.194,0.000,0.069,0.007,0.034,11.743,10.511,27.072,0.043,0.103,0.068,3.779,0.073,2.538,10.548,118.629
 2944.500,0.074,0.023,65.097,33.906,5.127,5.106,0.000,0.056,0.012,0.023,11.360,6.752,32.875,0.010,0.079,0.052,3.834,0.018,2.583,10.213,127.498
 2945.000,0.057,0.021,62.184,39.832,5.727,6.036,0.000,0.045,0.017,0.017,18.610,11.859,31.855,0.003,0.062,0.042,3.912,0.006,2.612,11.883,133.635
 2945.500,0.049,0.028,61.095,44.945,6.239,6.733,0.000,0.030,0.023,0.010,20.570,16.688,23.600,0.000,0.040,0.045,3.876,0.001,2.626,14.016,137.636
 2946.000,0.062,0.023,61.986,48.551,6.527,6.918,0.000,0.022,0.027,0.006,11.273,8.336,16.737,0.000,0.027,0.062,3.848,0.000,2.605,14.967,141.973
 2946.500,0.066,0.028,62.356,53.940,6.458,6.760,0.000,0.010,0.031,0.003,5.369,4.083,7.742,0.000,0.013,0.089,3.720,0.000,2.597,12.132,145.413
 2947.000,0.066,0.034,64.122,57.213,6.019,6.418,0.000,0.005,0.034,0.002,4.254,3.171,4.090,0.000,0.007,0.104,3.575,0.000,2.596,8.489,147.903
 2947.500,0.071,0.037,68.142,60.192,5.401,5.939,0.000,0.001,0.039,0.001,4.398,3.359,1.227,0.000,0.003,0.109,3.542,0.000,2.589,6.614,148.623
 2948.000,0.074,0.114,71.320,60.632,4.830,5.255,0.000,0.001,0.043,0.001,4.699,3.532,0.470,0.000,0.002,0.114,3.383,0.000,2.584,6.574,148.912
 2948.500,0.159,0.163,70.872,64.743,4.422,4.550,0.000,0.000,0.050,0.001,5.344,3.702,0.101,0.000,0.001,0.136,3.203,0.000,2.439,7.175,148.546
 2949.000,0.204,0.188,71.131,72.794,4.205,4.032,0.000,-0.001,0.055,0.001,3.809,2.968,0.024,0.000,0.001,0.175,3.119,0.000,2.361,7.038,148.440
 2949.500,0.230,0.186,74.822,78.411,4.119,3.767,0.000,0.000,0.062,0.001,0.735,1.221,0.003,0.000,0.001,0.213,3.029,0.000,2.317,5.886,146.381
 2950.000,0.221,0.194,75.959,83.393,4.057,3.747,0.000,0.001,0.066,0.001,0.676,1.169,0.000,0.000,0.001,0.212,3.054,0.000,2.332,4.717,145.242
 2950.500,0.169,0.209,80.091,82.254,3.983,3.839,0.000,0.001,0.069,0.001,1.641,1.720,0.000,0.000,0.002,0.188,3.251,0.000,2.422,3.863,145.165
 2951.000,0.086,0.188,83.270,75.888,3.919,3.940,0.000,0.001,0.068,0.001,1.689,2.100,0.000,0.000,0.002,0.159,3.448,0.000,2.564,3.846,145.808
 2951.500,0.110,0.091,79.688,72.241,3.882,3.980,0.000,0.002,0.067,0.002,4.206,2.698,0.000,0.000,0.004,0.139,3.262,0.000,2.522,4.579,146.841
 2952.000,0.102,0.068,76.772,67.991,3.883,3.993,7.000,0.002,0.067,0.003,3.345,3.082,0.000,0.000,0.005,0.137,3.248,0.000,2.536,4.940,146.853
 2952.500,0.095,0.072,75.848,65.419,3.897,4.006,0.000,0.003,0.071,0.003,2.621,2.325,0.000,0.000,0.006,0.134,3.269,0.000,2.548,5.082,145.832
 2953.000,0.090,0.071,73.975,64.930,3.876,3.988,0.000,0.004,0.075,0.003,4.260,3.071,0.000,0.000,0.006,0.123,3.253,0.000,2.557,5.240,143.773
 2953.500,0.102,0.042,74.178,61.877,3.799,3.888,0.000,0.004,0.078,0.003,6.512,4.175,0.000,0.000,0.007,0.120,3.202,0.000,2.536,5.283,142.250
 2954.000,0.089,0.043,72.925,59.818,3.678,3.730,0.000,0.004,0.078,0.003,6.797,4.673,0.000,0.000,0.006,0.128,3.241,0.000,2.559,5.541,140.079
 2954.500,0.091,0.047,70.519,60.599,3.528,3.565,0.000,0.004,0.077,0.003,6.853,3.950,0.000,0.000,0.006,0.141,3.244,0.000,2.555,5.455,138.049
 2955.000,0.087,0.062,69.286,65.687,3.388,3.419,0.000,0.004,0.076,0.002,5.800,3.555,0.000,0.000,0.006,0.148,3.236,0.000,2.561,5.084,138.816
 2955.500,0.086,0.065,70.072,73.128,3.303,3.305,0.000,0.003,0.073,0.002,4.933,3.267,0.000,0.000,0.006,0.156,3.231,0.000,2.562,4.767,140.964
 2956.000,0.086,0.064,72.781,77.695,3.317,3.228,0.000,0.004,0.068,0.003,3.038,2.580,0.000,0.000,0.007,0.171,3.333,0.000,2.562,4.419,143.318
 2956.500,0.089,0.062,74.361,77.239,3.448,3.237,0.000,0.005,0.064,0.004,3.196,2.458,0.000,0.000,0.009,0.189,3.379,0.000,2.558,4.223,143.784
 2957.000,0.085,0.060,75.648,72.517,3.696,3.402,0.000,0.008,0.057,0.007,3.120,2.587,0.000,0.000,0.015,0.197,3.529,0.001,2.564,3.981,143.011
 2957.500,0.082,0.051,78.427,59.533,4.030,3.762,0.000,0.011,0.052,0.010,2.782,2.336,0.000,0.000,0.021,0.184,3.858,0.002,2.569,3.782,142.167
 2958.000,0.092,0.020,76.422,46.109,4.410,4.352,0.000,0.016,0.047,0.016,6.309,3.418,0.000,0.002,0.031,0.157,4.031,0.005,2.553,4.315,139.943
 2958.500,0.072,0.022,71.448,34.907,4.798,5.118,0.000,0.018,0.045,0.019,10.977,9.754,0.000,0.003,0.037,0.098,4.266,0.006,2.586,7.040,135.930
 2959.000,0.069,0.017,68.711,27.060,5.142,5.837,0.000,0.019,0.044,0.022,9.367,11.689,0.001,0.005,0.041,0.065,4.372,0.009,2.592,12.853,131.894
 2959.500,0.060,0.017,62.752,23.803,5.308,6.328,0.000,0.020,0.043,0.024,7.731,9.555,0.010,0.008,0.044,0.061,4.370,0.013,2.607,26.509,128.702
 2960.000,0.049,0.024,57.966,23.738,5.181,6.339,0.000,0.028,0.042,0.026,7.227,8.643,0.034,0.010,0.054,0.070,4.236,0.018,2.626,33.617,126.991
 2960.500,0.050,0.030,57.389,25.301,4.758,5.833,0.000,0.032,0.041,0.024,11.248,10.330,0.172,0.009,0.056,0.087,3.979,0.015,2.625,22.693,126.371
 2961.000,0.057,0.042,58.261,30.731,4.246,4.958,0.000,0.034,0.039,0.020,20.170,15.987,0.376,0.005,0.054,0.104,3.640,0.008,2.613,17.149,128.130
 2961.500,0.072,0.054,59.881,40.117,3.833,4.071,0.000,0.035,0.039,0.016,15.752,16.478,0.775,0.002,0.051,0.124,3.405,0.004,2.587,14.228,129.652
 2962.000,0.105,0.046,62.567,51.026,3.571,3.433,0.000,0.035,0.041,0.010,7.576,8.037,0.957,0.001,0.045,0.141,3.188,0.002,2.531,11.107,133.670
 2962.500,0.125,0.039,66.497,59.948,3.419,3.120,0.000,0.033,0.043,0.008,3.415,2.617,0.891,0.000,0.041,0.166,3.052,0.002,2.496,7.504,138.025
 2963.000,0.119,0.044,70.270,66.640,3.321,3.047,0.000,0.028,0.049,0.005,2.652,1.830,0.690,0.000,0.033,0.178,2.962,0.001,2.507,4.663,140.704
 2963.500,0.111,0.043,75.386,67.560,3.256,3.142,0.000,0.024,0.056,0.004,4.753,2.801,0.356,0.000,0.028,0.143,2.883,0.000,2.520,3.407,141.595
 2964.000,0.094,0.045,78.956,64.702,3.252,3.295,0.000,0.021,0.067,0.002,5.276,3.577,0.202,0.000,0.023,0.117,3.009,0.000,2.550,3.943,143.059
 2964.500,0.084,0.039,76.564,62.968,3.338,3.443,0.000,0.021,0.071,0.001,5.102,3.580,0.064,0.000,0.022,0.106,3.165,0.000,2.567,4.829,143.826
 2965.000,0.085,0.033,72.172,63.921,3.501,3.571,0.000,0.018,0.074,0.001,5.110,3.496,0.030,0.000,0.018,0.109,3.238,0.000,2.565,5.391,146.127
 2965.500,0.088,0.035,71.630,66.192,3.710,3.685,0.000,0.013,0.074,0.001,4.947,3.455,0.010,0.000,0.014,0.119,3.208,0.000,2.559,5.345,148.552
 2966.000,0.083,0.046,72.664,67.731,3.902,3.766,7.000,0.009,0.074,0.001,4.575,3.244,0.005,0.000,0.010,0.132,3.252,0.000,2.569,5.206,150.364
 2966.500,0.084,0.043,73.716,69.530,4.018,3.816,0.000,0.008,0.073,0.001,3.733,2.945,0.002,0.000,0.010,0.144,3.264,0.000,2.566,4.947,151.444
 2967.000,0.084,0.037,75.328,69.579,4.067,3.862,0.000,0.008,0.070,0.001,3.519,2.672,0.001,0.000,0.009,0.146,3.137,0.000,2.566,4.646,149.266
 2967.500,0.084,0.036,75.948,66.404,4.049,3.926,0.000,0.006,0.069,0.001,3.837,2.735,0.000,0.000,0.007,0.129,3.100,0.000,2.566,4.483,147.579
 2968.000,0.083,0.033,75.091,63.734,4.006,3.987,0.000,0.003,0.068,0.002,3.494,2.886,0.000,0.000,0.005,0.110,3.076,0.000,2.568,4.606,145.726
 2968.500,0.077,0.034,74.348,61.194,3.966,4.026,0.000,0.002,0.068,0.002,4.871,3.160,0.000,0.000,0.004,0.100,3.152,0.000,2.578,4.983,144.127
 2969.000,0.077,0.036,72.414,61.348,3.922,4.045,0.000,0.002,0.068,0.002,5.577,3.584,0.000,0.000,0.004,0.099,3.195,0.000,2.578,5.256,144.622
 2969.500,0.084,0.029,70.377,63.164,3.867,4.049,0.000,0.001,0.067,0.002,5.099,3.588,0.000,0.000,0.003,0.106,3.210,0.000,2.566,5.245,145.407
 2970.000,0.087,0.026,69.970,67.600,3.811,4.007,0.000,0.001,0.064,0.002,4.795,3.418,0.000,0.000,0.003,0.114,3.237,0.000,2.562,5.097,146.139
 2970.500,0.090,0.028,70.884,72.688,3.793,3.900,0.000,0.001,0.061,0.003,4.707,3.396,0.000,0.000,0.004,0.126,3.171,0.000,2.557,5.032,147.266
 2971.000,0.081,0.090,71.317,76.588,3.865,3.768,0.000,0.002,0.058,0.005,4.767,3.418,0.000,0.000,0.007,0.146,3.187,0.000,2.572,5.077,147.030
 2971.500,0.096,0.113,72.855,76.677,4.030,3.759,0.000,0.003,0.056,0.007,3.866,2.960,0.000,0.000,0.010,0.174,3.351,0.001,2.545,4.819,148.009
 2972.000,0.107,0.102,75.755,72.127,4.266,3.974,0.000,0.006,0.050,0.013,2.376,2.133,0.000,0.001,0.019,0.195,3.592,0.009,2.527,4.291,147.378
 2972.500,0.099,0.111,78.111,60.078,4.530,4.485,0.000,0.009,0.045,0.017,1.478,1.609,0.000,0.003,0.027,0.176,3.869,0.021,2.540,3.785,145.053
 2973.000,0.082,0.118,76.023,48.917,4.803,5.277,0.000,0.014,0.037,0.025,11.594,11.862,0.000,0.010,0.039,0.131,4.264,0.053,2.571,5.109,137.594
 2973.500,0.046,0.117,74.731,39.401,5.109,6.063,0.000,0.017,0.032,0.029,11.929,17.777,0.002,0.019,0.046,0.100,4.684,0.074,2.632,9.008,129.121
 2974.000,0.069,0.032,69.817,33.800,5.440,6.737,0.000,0.022,0.026,0.033,9.350,11.803,0.010,0.033,0.056,0.085,4.898,0.056,2.592,16.739,123.220
 2974.500,0.070,0.016,61.353,34.663,5.726,7.116,0.000,0.026,0.024,0.036,9.936,12.054,0.085,0.041,0.061,0.085,4.748,0.070,2.591,31.055,120.122
 2975.000,0.051,0.027,57.719,36.283,5.844,7.234,0.000,0.031,0.022,0.036,8.221,10.600,0.287,0.040,0.067,0.077,4.751,0.067,2.622,28.391,117.974
 2975.500,0.043,0.020,57.980,34.451,5.665,6.965,0.000,0.035,0.022,0.034,7.545,10.515,0.883,0.031,0.068,0.072,4.472,0.052,2.637,24.701,117.473
 2976.000,0.049,0.010,58.077,30.674,5.252,6.324,0.000,0.038,0.025,0.028,9.485,13.956,1.536,0.016,0.066,0.076,4.297,0.027,2.626,22.523,115.850
 2976.500,0.042,0.020,57.692,26.596,4.662,5.484,0.000,0.040,0.029,0.023,8.536,11.825,2.757,0.008,0.063,0.088,4.161,0.014,2.638,19.269,114.865
 2977.000,0.036,0.025,58.339,23.771,4.068,4.727,0.000,0.043,0.036,0.014,9.049,9.359,3.454,0.002,0.058,0.091,4.045,0.003,2.648,16.244,116.322
 2977.500,0.042,0.022,59.427,25.204,3.552,4.040,0.000,0.043,0.042,0.010,12.084,8.883,3.400,0.001,0.053,0.091,3.829,0.001,2.638,11.973,121.137
 2978.000,0.046,0.026,61.388,29.990,3.167,3.478,0.000,0.042,0.050,0.004,9.283,5.785,2.697,0.000,0.046,0.099,3.547,0.000,2.632,8.685,126.365
 2978.500,0.058,0.028,63.820,37.464,2.893,3.042,0.000,0.039,0.056,0.002,4.795,3.004,1.389,0.000,0.041,0.119,3.400,0.000,2.611,6.378,129.746
 2979.000,0.076,0.035,65.930,47.607,2.711,2.705,0.000,0.030,0.066,0.001,4.251,2.111,0.794,0.000,0.031,0.154,3.172,0.000,2.581,4.661,131.499
 2979.500,0.103,0.089,68.689,57.506,2.575,2.494,0.000,0.023,0.074,0.001,3.241,1.893,0.275,0.000,0.023,0.196,2.964,0.000,2.534,3.707,133.659
 2980.000,0.143,0.129,73.992,68.773,2.459,2.369,0.000,0.014,0.088,0.001,1.019,1.228,0.127,0.000,0.014,0.237,2.895,0.000,2.466,3.183,137.205
 2980.500,0.157,0.175,79.478,80.039,2.362,2.305,7.000,0.011,0.097,0.001,0.597,1.022,0.032,0.000,0.011,0.255,2.945,0.000,2.441,2.925,140.468
 2981.000,0.173,0.191,83.080,84.281,2.283,2.272,0.000,0.009,0.109,0.001,0.650,0.966,0.012,0.000,0.009,0.263,2.951,0.000,2.415,2.956,143.843
 2981.500,0.153,0.244,88.789,85.404,2.224,2.240,0.000,0.007,0.116,0.001,0.783,1.158,0.002,0.000,0.008,0.265,3.149,0.000,2.449,3.057,146.794
 2982.000,0.136,0.258,92.505,88.929,2.189,2.198,0.000,0.004,0.121,0.001,1.275,1.446,0.001,0.000,0.005,0.262,3.300,0.000,2.478,3.115,147.573
 2982.500,0.132,0.250,90.347,89.450,2.179,2.144,0.000,0.003,0.122,0.002,1.329,1.505,0.000,0.000,0.005,0.264,3.256,0.000,2.485,3.158,146.823
 2983.000,0.136,0.252,89.323,90.915,2.202,2.093,0.000,0.003,0.120,0.002,1.318,1.498,0.000,0.000,0.005,0.265,3.340,0.000,2.478,3.124,146.894
 2983.500,0.130,0.284,89.459,97.249,2.276,2.064,0.000,0.003,0.117,0.002,1.320,1.439,0.000,0.000,0.005,0.272,3.432,0.000,2.487,3.051,146.410
 2984.000,0.152,0.294,89.422,100.163,2.419,2.087,0.000,0.003,0.114,0.003,0.991,1.332,0.000,0.000,0.005,0.282,3.498,0.000,2.450,2.917,144.788
 2984.500,0.161,0.287,90.481,100.424,2.631,2.208,0.000,0.002,0.110,0.003,0.836,1.173,0.000,0.000,0.005,0.299,3.479,0.000,2.435,2.799,143.601
 2985.000,0.170,0.245,91.780,94.188,2.914,2.483,0.000,0.002,0.104,0.002,0.847,1.077,0.000,0.000,0.005,0.288,3.533,0.000,2.420,2.725,142.238
 2985.500,0.164,0.207,90.920,81.301,3.269,2.970,0.000,0.002,0.096,0.002,0.940,1.247,0.000,0.000,0.004,0.248,3.655,0.000,2.430,2.855,141.713
 2986.000,0.133,0.152,87.461,64.214,3.727,3.695,0.000,0.002,0.091,0.001,9.981,8.052,0.000,0.000,0.003,0.167,3.801,0.000,2.483,3.672,141.306
 2986.500,0.087,0.104,81.806,48.356,4.364,4.581,0.000,0.001,0.082,0.001,13.193,13.893,0.000,0.000,0.002,0.112,4.130,0.000,2.561,5.912,141.884
 2987.000,0.073,0.049,73.866,36.535,5.253,5.464,0.000,0.001,0.079,0.001,10.800,10.581,0.000,0.000,0.001,0.086,4.438,0.000,2.585,9.968,141.737
 2987.500,0.054,0.026,63.269,33.580,6.271,6.386,0.000,0.001,0.076,0.001,20.325,12.221,0.000,0.000,0.001,0.085,4.613,0.000,2.618,14.254,142.162
 2988.000,0.055,0.015,58.028,34.972,7.357,7.425,0.000,0.001,0.060,0.001,15.690,9.278,0.000,0.000,0.002,0.084,4.699,0.000,2.616,13.917,141.430
 2988.500,0.048,0.020,57.841,37.317,8.263,8.544,0.000,0.001,0.051,0.001,10.561,5.796,0.000,0.000,0.002,0.076,4.621,0.000,2.627,11.396,141.477
 2989.000,0.040,0.032,59.448,38.172,8.809,9.631,0.000,0.001,0.045,0.001,15.102,10.319,0.000,0.000,0.002,0.067,4.675,0.000,2.642,10.877,140.734
 2989.500,0.033,0.033,60.713,38.058,9.056,10.607,0.000,0.002,0.039,0.003,18.424,16.005,0.000,0.000,0.005,0.061,4.754,0.000,2.654,11.738,138.934
 2990.000,0.031,0.022,60.611,35.152,9.061,12.073,0.000,0.003,0.036,0.004,13.728,11.294,0.000,0.000,0.008,0.052,4.816,0.000,2.658,12.324,136.556
 2990.500,0.024,0.026,58.402,32.921,8.864,13.179,0.000,0.005,0.032,0.009,13.742,12.139,0.000,0.000,0.014,0.038,4.827,0.000,2.669,13.867,133.659
 2991.000,0.022,0.027,56.163,30.870,8.462,13.791,0.000,0.008,0.029,0.014,21.271,29.899,0.000,0.001,0.022,0.030,4.922,0.002,2.672,17.159,129.215
 2991.500,0.035,0.023,55.948,30.259,7.842,13.298,0.000,0.012,0.024,0.024,17.239,22.969,0.000,0.010,0.036,0.031,4.915,0.017,2.650,23.938,123.887
 2992.000,0.062,0.019,53.872,31.220,7.018,11.693,0.000,0.015,0.020,0.032,12.895,12.361,0.003,0.034,0.047,0.048,4.926,0.059,2.604,33.661,117.668
 2992.500,0.089,0.014,52.966,34.061,6.030,9.261,0.000,0.019,0.015,0.046,6.067,9.067,0.037,0.156,0.065,0.070,4.845,0.266,2.558,28.850,111.590
 2993.000,0.112,0.009,55.508,35.493,5.060,7.307,0.000,0.022,0.011,0.055,5.476,7.749,0.166,0.348,0.077,0.084,4.832,0.594,2.519,20.736,106.586
 2993.500,0.123,0.016,58.694,36.739,4.148,5.730,0.000,0.026,0.006,0.069,6.487,8.857,0.952,0.883,0.094,0.091,4.894,2.313,2.499,17.148,102.562
 2994.000,0.146,0.014,61.344,37.545,3.485,4.492,0.000,0.028,0.004,0.077,7.227,9.267,2.353,1.426,0.105,0.098,4.821,5.760,2.461,15.742,98.496
 2994.500,0.172,-0.000,63.558,35.974,3.029,3.636,7.000,0.031,0.001,0.088,7.506,10.090,7.595,2.488,0.118,0.115,4.703,10.449,2.416,14.497,96.195
 2995.000,0.195,-0.003,65.106,35.917,2.713,3.072,0.000,0.033,0.000,0.094,5.718,7.915,13.652,3.169,0.127,0.133,4.695,15.574,2.377,11.469,94.477
 2995.500,0.208,-0.000,67.838,36.210,2.490,2.727,0.000,0.037,0.000,0.100,5.687,6.841,28.246,4.009,0.137,0.138,4.692,18.507,2.355,8.532,92.943
 2996.000,0.210,0.006,70.813,34.793,2.350,2.519,0.000,0.039,0.000,0.103,6.259,7.184,41.223,4.388,0.143,0.139,4.649,20.917,2.351,6.452,92.483
 2996.500,0.213,0.006,74.578,34.924,2.282,2.396,0.000,0.043,0.000,0.105,7.101,8.056,65.625,4.428,0.148,0.142,4.648,18.515,2.346,6.168,91.350
 2997.000,0.207,0.005,76.405,35.835,2.284,2.345,0.000,0.045,0.000,0.105,7.047,8.384,86.304,4.183,0.150,0.145,4.589,14.560,2.356,6.309,90.607
 2997.500,0.191,0.017,76.097,35.656,2.331,2.369,0.000,0.047,0.000,0.103,6.290,7.236,115.916,3.656,0.149,0.142,4.621,11.048,2.384,6.157,89.875
 2998.000,0.186,0.015,74.980,37.748,2.378,2.453,0.000,0.047,0.000,0.101,5.896,6.202,131.494,3.368,0.147,0.133,4.573,10.042,2.392,6.114,90.766
 2998.500,0.174,0.011,73.330,41.794,2.387,2.553,0.000,0.044,0.000,0.099,5.518,6.121,140.506,3.149,0.143,0.124,4.548,11.169,2.412,6.987,91.751
 2999.000,0.169,0.010,71.217,46.418,2.344,2.599,0.000,0.040,0.000,0.098,5.828,7.129,139.664,3.316,0.138,0.118,4.494,14.706,2.421,8.283,93.280
 2999.500,0.180,0.000,68.775,51.441,2.275,2.545,0.000,0.034,0.000,0.098,6.982,8.676,125.305,3.992,0.132,0.119,4.484,21.581,2.402,9.958,92.341
 3000.000,0.190,-0.001,68.055,54.217,2.216,2.409,0.000,0.031,0.000,0.100,6.380,8.473,115.247,4.527,0.131,0.132,4.513,25.387,2.385,9.812,91.686
 3000.500,0.201,-0.003,68.570,52.963,2.194,2.247,0.000,0.034,0.000,0.101,5.890,6.867,105.772,4.479,0.135,0.148,4.552,20.870,2.366,8.870,91.887
 3001.000,0.204,-0.005,70.448,50.391,2.224,2.126,0.000,0.037,0.000,0.100,5.414,5.600,101.023,4.021,0.137,0.162,4.556,14.017,2.362,6.944,93.940
 3001.500,0.194,-0.007,72.347,50.008,2.299,2.093,0.000,0.044,0.000,0.095,5.896,5.327,94.501,2.648,0.139,0.157,4.636,5.439,2.378,5.335,97.375
 3002.000,0.171,-0.006,72.645,60.827,2.429,2.174,0.000,0.049,0.000,0.088,6.118,6.099,94.140,1.704,0.136,0.133,4.652,3.049,2.418,4.976,100.720
 3002.500,0.133,-0.004,70.738,99.317,2.627,2.394,0.000,0.054,0.001,0.073,6.329,7.192,106.693,0.706,0.126,0.099,4.649,1.204,2.483,5.166,106.716
 3003.000,0.095,-0.004,67.252,166.941,2.919,2.782,0.000,0.052,0.004,0.060,10.153,10.633,112.197,0.329,0.112,0.070,4.590,0.561,2.548,7.610,112.652
 3003.500,0.059,0.000,63.608,235.250,3.366,3.353,0.000,0.046,0.010,0.042,22.273,16.496,98.519,0.073,0.087,0.058,4.553,0.125,2.610,11.240,120.040
 3004.000,0.031,0.007,60.908,285.478,3.973,4.130,0.000,0.041,0.017,0.029,12.731,9.621,73.398,0.018,0.070,0.061,4.439,0.030,2.658,13.826,127.882
 3004.500,0.026,0.005,58.772,305.870,4.630,5.023,0.000,0.027,0.030,0.016,6.856,5.279,34.387,0.002,0.043,0.070,4.307,0.003,2.666,12.983,134.762
 3005.000,0.026,0.010,59.081,291.372,5.058,5.730,0.000,0.016,0.039,0.010,8.289,5.556,16.853,0.000,0.027,0.075,4.185,0.001,2.666,11.158,140.014
 3005.500,0.038,0.039,61.022,252.419,5.012,5.819,0.000,0.006,0.052,0.006,8.038,6.058,4.266,0.000,0.012,0.080,3.853,0.000,2.645,9.749,143.979
 3006.000,0.100,0.086,62.177,208.532,4.678,5.254,0.000,0.003,0.060,0.004,6.808,4.600,1.307,0.000,0.007,0.103,3.621,0.000,2.539,10.038,147.773
 3006.500,0.151,0.116,64.309,169.074,4.284,4.539,0.000,0.002,0.071,0.003,4.432,3.178,0.198,0.000,0.004,0.149,3.404,0.000,2.452,8.914,151.615
 3007.000,0.165,0.160,69.698,136.528,3.935,3.993,0.000,0.001,0.078,0.002,1.864,1.919,0.031,0.000,0.003,0.190,3.376,0.000,2.428,6.605,153.562
 3007.500,0.176,0.192,75.108,108.532,3.644,3.670,0.000,0.001,0.085,0.001,0.887,1.284,0.004,0.000,0.002,0.238,3.276,0.000,2.409,4.901,153.344
 3008.000,0.144,0.236,81.605,89.165,3.415,3.489,0.000,0.001,0.087,0.001,0.780,1.339,0.001,0.000,0.001,0.248,3.363,0.000,2.464,3.660,152.936
 3008.500,0.115,0.230,87.972,80.398,3.262,3.379,0.000,0.001,0.091,0.001,0.819,1.391,0.000,0.000,0.002,0.250,3.546,0.000,2.513,3.579,152.246
 3009.000,0.109,0.226,89.384,78.077,3.172,3.313,7.000,0.002,0.096,0.001,1.016,1.395,0.000,0.000,0.003,0.252,3.608,0.000,2.523,3.834,150.641
 3009.500,0.115,0.215,89.247,76.319,3.136,3.263,0.000,0.003,0.101,0.002,1.166,1.317,0.000,0.000,0.004,0.252,3.610,0.000,2.514,4.012,151.031
 3010.000,0.120,0.229,88.595,72.355,3.145,3.211,0.000,0.004,0.101,0.002,0.952,1.310,0.000,0.000,0.005,0.252,3.674,0.000,2.505,4.142,151.715
 3010.500,0.134,0.218,87.786,74.772,3.192,3.161,0.000,0.005,0.095,0.002,1.073,1.930,0.000,0.000,0.007,0.252,3.723,0.000,2.480,4.167,152.523
 3011.000,0.138,0.218,87.961,75.057,3.277,3.142,0.000,0.007,0.090,0.002,1.123,1.856,0.000,0.000,0.008,0.253,3.753,0.000,2.474,4.198,151.703
 3011.500,0.141,0.187,87.355,71.988,3.382,3.198,0.000,0.013,0.082,0.001,0.940,1.472,0.000,0.000,0.014,0.246,3.786,0.000,2.470,4.151,151.650
 3012.000,0.127,0.161,87.255,71.052,3.480,3.330,0.000,0.015,0.077,0.001,1.281,1.483,0.000,0.000,0.015,0.231,3.677,0.000,2.494,4.008,152.146
 3012.500,0.104,0.129,86.381,68.968,3.546,3.503,0.000,0.014,0.072,0.001,2.438,2.144,0.000,0.000,0.015,0.211,3.658,0.000,2.532,4.022,152.795
 3013.000,0.083,0.092,83.692,64.849,3.583,3.653,0.000,0.017,0.070,0.001,3.218,2.713,0.000,0.000,0.018,0.189,3.625,0.000,2.568,4.520,153.550
 3013.500,0.073,0.079,80.936,65.223,3.618,3.742,0.000,0.024,0.067,0.001,1.875,3.030,0.000,0.000,0.024,0.179,3.612,0.000,2.585,5.018,155.143
 3014.000,0.081,0.058,77.094,66.607,3.676,3.773,0.000,0.024,0.065,0.001,2.624,2.968,0.000,0.000,0.024,0.189,3.522,0.000,2.572,5.443,156.088
 3014.500,0.084,0.061,75.183,68.594,3.758,3.768,0.000,0.018,0.060,0.001,3.452,2.665,0.000,0.000,0.018,0.208,3.455,0.000,2.566,5.335,155.610
 3015.000,0.104,0.048,76.469,73.445,3.859,3.761,0.000,0.015,0.057,0.001,3.111,2.742,0.000,0.000,0.015,0.230,3.451,0.000,2.533,5.010,154.896
 3015.500,0.095,0.072,77.775,76.767,3.947,3.782,0.000,0.012,0.054,0.001,2.551,2.321,0.000,0.000,0.013,0.239,3.440,0.000,2.547,4.629,154.801
 3016.000,0.095,0.096,79.550,78.769,4.016,3.861,0.000,0.012,0.052,0.001,3.179,2.609,0.000,0.000,0.013,0.237,3.448,0.001,2.547,4.325,155.686
 3016.500,0.099,0.104,80.389,80.332,4.059,4.001,0.000,0.012,0.053,0.001,3.232,2.764,0.000,0.000,0.013,0.224,3.582,0.000,2.541,4.280,155.379
 3017.000,0.108,0.090,80.098,77.141,4.105,4.170,0.000,0.010,0.055,0.001,3.708,2.883,0.000,0.000,0.011,0.206,3.705,0.000,2.525,4.510,153.710
 3017.500,0.092,0.094,79.938,71.915,4.181,4.334,0.000,0.004,0.059,0.001,3.142,3.444,0.000,0.000,0.006,0.187,3.745,0.000,2.553,4.996,153.273
 3018.000,0.086,0.083,77.266,68.447,4.283,4.448,0.000,0.002,0.060,0.001,3.899,3.322,0.000,0.000,0.003,0.174,3.783,0.000,2.562,5.510,153.267
 3018.500,0.060,0.093,75.445,64.995,4.378,4.508,0.000,0.001,0.061,0.001,4.930,3.606,0.000,0.000,0.002,0.166,3.838,0.000,2.608,5.812,152.146
 3019.000,0.078,0.041,73.953,64.474,4.405,4.497,0.000,0.001,0.061,0.001,3.542,3.658,0.000,0.000,0.001,0.164,3.736,0.000,2.577,5.776,151.432
 3019.500,0.076,0.042,73.042,64.963,4.293,4.423,0.000,0.000,0.062,0.001,3.322,3.348,0.000,0.000,0.001,0.167,3.552,0.000,2.580,5.501,151.792
 3020.000,0.076,0.046,73.163,66.298,4.060,4.266,0.000,-0.001,0.061,0.001,3.694,2.993,0.000,0.000,0.000,0.175,3.427,0.000,2.579,5.231,152.293
 3020.500,0.076,0.071,73.908,67.600,3.780,3.986,0.000,-0.001,0.063,0.001,3.567,2.790,0.000,0.000,0.000,0.180,3.375,0.000,2.580,5.096,152.075
 3021.000,0.118,0.133,73.798,67.438,3.513,3.619,0.000,-0.001,0.065,0.001,3.581,2.816,-0.010,0.000,0.000,0.198,3.257,0.000,2.509,5.150,150.411
 3021.500,0.166,0.179,74.156,68.870,3.316,3.273,15.000,0.001,0.068,0.001,1.785,2.336,-0.176,0.000,0.001,0.224,3.210,0.000,2.427,5.060,147.514
 3022.000,0.184,0.222,77.042,73.885,3.181,3.013,0.000,0.001,0.069,0.001,0.746,1.417,-0.416,0.000,0.002,0.245,3.300,0.000,2.396,4.510,144.858
 3022.500,0.199,0.281,79.123,77.890,3.094,2.869,0.000,0.001,0.069,0.001,0.656,1.144,-0.603,0.000,0.003,0.264,3.387,0.000,2.369,3.905,143.808
 3023.000,0.200,0.305,81.158,83.491,3.051,2.816,0.000,0.002,0.069,0.001,0.690,1.166,-0.462,0.000,0.003,0.263,3.363,0.000,2.367,3.387,142.669
 3023.500,0.167,0.291,87.031,87.985,3.059,2.833,0.000,0.002,0.068,0.002,0.577,1.125,-0.115,0.000,0.004,0.266,3.415,0.000,2.424,3.215,141.678
 3024.000,0.165,0.248,87.383,86.454,3.140,2.912,0.000,0.002,0.067,0.003,0.757,1.180,-0.012,0.000,0.005,0.260,3.437,0.000,2.428,3.305,141.542
 3024.500,0.148,0.227,85.048,86.291,3.327,3.055,0.000,0.002,0.065,0.003,1.163,1.553,0.000,0.000,0.005,0.251,3.434,0.001,2.456,3.466,140.887
 3025.000,0.109,0.235,86.070,82.189,3.675,3.262,0.000,0.002,0.063,0.004,1.301,1.819,0.000,0.000,0.006,0.250,3.589,0.002,2.524,3.704,140.244
 3025.500,0.162,0.206,83.955,77.076,4.185,3.585,0.000,0.003,0.059,0.006,1.692,1.819,0.000,0.000,0.009,0.251,3.534,0.009,2.433,4.367,138.922
 3026.000,0.174,0.183,84.594,72.452,4.892,4.150,0.000,0.004,0.057,0.008,0.960,1.110,0.000,0.000,0.011,0.259,3.769,0.016,2.413,4.878,137.170
 3026.500,0.181,0.137,84.214,63.107,5.662,5.149,0.000,0.007,0.051,0.011,0.684,1.073,0.000,0.000,0.018,0.230,3.840,0.034,2.401,5.130,134.898
 3027.000,0.160,0.122,75.855,49.235,6.399,6.584,0.000,0.009,0.046,0.013,5.873,3.075,0.001,0.001,0.022,0.146,3.899,0.042,2.436,6.542,133.529
 3027.500,0.086,0.134,75.473,37.708,7.113,8.036,0.000,0.013,0.040,0.016,27.042,24.413,0.003,0.002,0.029,0.094,4.259,0.039,2.563,10.346,132.803
 3028.000,0.049,0.068,68.130,26.376,7.779,8.780,0.000,0.017,0.036,0.017,18.250,25.022,0.008,0.002,0.034,0.073,4.474,0.019,2.627,16.356,132.260
 3028.500,0.067,0.002,53.630,19.570,8.254,8.897,0.000,0.021,0.034,0.017,9.499,11.678,0.024,0.002,0.038,0.073,4.465,0.004,2.595,19.484,132.402
 3029.000,0.068,0.004,56.159,17.323,8.248,8.942,0.000,0.023,0.034,0.016,7.115,8.026,0.041,0.002,0.039,0.072,4.339,0.003,2.595,15.852,132.237
 3029.500,0.060,0.018,58.263,17.096,7.784,8.735,0.000,0.023,0.034,0.014,11.915,11.755,0.077,0.001,0.037,0.062,4.144,0.002,2.607,13.329,134.225
 3030.000,0.058,0.024,58.938,19.538,7.176,7.981,0.000,0.023,0.035,0.012,20.967,17.453,0.095,0.001,0.034,0.057,3.928,0.001,2.611,15.183,136.692
 3030.500,0.059,0.032,58.930,25.627,6.704,7.003,0.000,0.023,0.036,0.007,17.385,17.072,0.102,0.000,0.030,0.066,3.661,0.000,2.610,18.208,140.822
 3031.000,0.066,0.044,60.244,33.051,6.432,6.203,0.000,0.025,0.038,0.004,5.831,5.312,0.091,0.000,0.029,0.091,3.540,0.000,2.597,14.705,145.342
 3031.500,0.073,0.045,62.478,42.690,6.259,5.788,0.000,0.021,0.040,0.002,4.187,3.669,0.066,0.000,0.023,0.125,3.391,0.000,2.584,10.146,149.349
 3032.000,0.077,0.041,67.188,47.379,6.114,5.662,0.000,0.015,0.040,0.002,3.967,3.392,0.046,0.000,0.017,0.138,3.368,0.000,2.577,6.623,151.255
 3032.500,0.069,0.048,72.873,47.900,6.042,5.712,0.000,0.006,0.040,0.004,5.012,3.292,0.020,0.000,0.009,0.129,3.474,0.000,2.593,5.453,151.473
 3033.000,0.067,0.035,75.786,45.197,6.129,5.854,0.000,0.004,0.041,0.003,6.194,4.411,0.008,0.000,0.008,0.112,3.596,0.000,2.595,6.459,150.423
 3033.500,0.068,0.025,74.936,40.541,6.482,6.075,0.000,0.004,0.044,0.003,6.780,4.899,0.001,0.000,0.007,0.103,3.713,0.000,2.594,7.477,150.016
 3034.000,0.071,0.013,72.914,38.913,7.094,6.465,0.000,0.004,0.045,0.003,6.661,4.784,0.001,0.000,0.007,0.098,3.842,0.000,2.588,8.426,151.514
 3034.500,0.070,0.008,71.042,39.629,7.909,7.148,0.000,0.004,0.045,0.003,6.191,4.249,0.000,0.000,0.007,0.092,4.097,0.000,2.591,8.384,152.624
 3035.000,0.055,0.020,69.500,38.847,8.630,8.129,7.000,0.003,0.042,0.003,5.943,3.854,0.000,0.000,0.006,0.082,4.005,0.000,2.616,8.265,152.535
 3035.500,0.055,0.015,67.688,37.805,9.141,9.237,0.000,0.003,0.038,0.003,20.361,11.157,0.000,0.000,0.005,0.065,4.158,0.000,2.616,10.662,152.482
 3036.000,0.050,0.014,66.173,35.038,9.522,10.001,0.000,0.002,0.034,0.003,21.448,15.252,0.000,0.000,0.005,0.052,4.183,0.000,2.624,14.291,151.650
 3036.500,0.051,0.014,63.542,33.442,9.987,10.105,0.000,0.001,0.029,0.002,13.967,8.846,0.000,0.000,0.004,0.048,4.081,0.000,2.623,19.775,150.653
 3037.000,0.057,0.015,59.780,36.210,10.580,9.955,0.000,0.001,0.026,0.002,11.963,8.410,0.000,0.000,0.004,0.058,3.887,0.000,2.613,20.919,149.249
 3037.500,0.061,0.011,60.486,40.899,11.223,10.028,0.000,0.002,0.021,0.002,7.253,5.574,0.000,0.000,0.004,0.075,3.926,0.000,2.605,15.091,148.210
 3038.000,0.061,0.010,63.111,43.309,11.568,10.577,0.000,0.004,0.020,0.002,5.358,3.706,0.000,0.000,0.006,0.087,3.873,0.000,2.607,11.109,148.611
 3038.500,0.061,0.013,64.055,43.276,11.483,11.872,0.000,0.014,0.021,0.001,11.363,6.313,0.000,0.000,0.015,0.080,3.675,0.000,2.606,10.573,148.316
 3039.000,0.053,0.017,65.858,38.847,11.185,12.634,0.000,0.023,0.021,0.001,18.711,12.217,0.000,0.000,0.024,0.056,3.814,0.000,2.619,12.890,146.257
 3039.500,0.051,0.013,66.613,35.266,10.967,12.856,0.000,0.032,0.022,0.001,22.481,14.805,0.000,0.000,0.032,0.041,4.023,0.000,2.623,18.796,145.018
 3040.000,0.049,0.018,62.319,31.521,10.930,12.464,0.000,0.031,0.021,0.001,18.886,13.587,0.000,0.000,0.031,0.039,3.937,0.000,2.626,24.677,146.216
 3040.500,0.045,0.023,58.358,34.321,11.023,11.901,0.000,0.026,0.022,0.001,14.049,10.349,0.000,0.000,0.027,0.049,3.917,0.000,2.633,22.872,147.874
 3041.000,0.049,0.018,58.631,37.350,11.043,11.366,0.000,0.023,0.022,0.001,8.528,6.228,0.000,0.000,0.023,0.064,4.049,0.000,2.627,17.109,148.658
 3041.500,0.052,0.018,60.288,39.694,10.849,10.563,0.000,0.019,0.024,0.001,6.391,4.245,0.000,0.000,0.019,0.076,4.010,0.000,2.621,13.341,148.298
 3042.000,0.060,0.016,62.627,43.081,10.572,10.209,0.000,0.018,0.026,0.001,7.388,5.116,0.000,0.000,0.019,0.081,3.913,0.000,2.608,11.492,147.655
 3042.500,0.064,0.015,64.848,46.272,10.349,9.943,0.000,0.019,0.030,0.001,7.585,4.873,0.000,0.000,0.020,0.079,3.756,0.000,2.600,11.296,148.275
 3043.000,0.069,0.013,65.584,47.770,10.223,9.866,0.000,0.021,0.031,0.001,7.382,4.958,0.000,0.000,0.021,0.079,3.795,0.000,2.592,11.798,149.060
 3043.500,0.073,0.003,65.528,49.968,10.183,10.055,0.000,0.021,0.033,0.001,7.005,4.840,0.000,0.000,0.021,0.076,3.944,0.000,2.586,11.483,149.632
 3044.000,0.060,0.015,65.273,51.091,10.192,10.344,0.000,0.021,0.034,0.001,7.413,4.921,0.000,0.000,0.021,0.073,4.031,0.000,2.608,11.754,149.833
 3044.500,0.049,0.024,64.211,50.212,10.163,10.487,0.000,0.018,0.035,0.001,13.742,8.883,0.000,0.000,0.019,0.065,4.088,0.000,2.626,14.133,149.190
 3045.000,0.045,0.030,63.725,50.407,10.088,10.304,0.000,0.015,0.037,0.001,13.759,10.973,0.000,0.000,0.016,0.065,4.120,0.000,2.634,16.677,149.443
 3045.500,0.042,0.035,63.748,50.993,9.874,9.897,0.000,0.009,0.039,0.001,6.433,5.722,0.000,0.000,0.011,0.073,4.191,0.000,2.637,16.473,149.420
 3046.000,0.049,0.033,62.750,49.186,9.393,9.459,0.000,0.007,0.040,0.001,10.893,6.656,0.000,0.000,0.009,0.083,4.184,0.000,2.627,14.919,150.334
 3046.500,0.048,0.038,61.419,48.649,8.716,8.963,0.000,0.006,0.039,0.001,8.413,6.815,0.000,0.000,0.007,0.089,4.077,0.000,2.627,11.999,151.007
 3047.000,0.053,0.033,64.097,47.118,8.115,8.350,0.000,0.006,0.038,0.001,6.644,4.300,0.000,0.000,0.007,0.092,3.996,0.000,2.620,11.102,152.140
 3047.500,0.064,0.023,65.181,48.616,7.746,7.629,0.000,0.005,0.037,0.002,10.595,6.859,0.000,0.000,0.007,0.093,3.853,0.000,2.600,12.407,152.128
 3048.000,0.068,0.019,64.197,55.324,7.733,7.075,0.000,0.004,0.038,0.002,8.041,6.239,0.000,0.000,0.006,0.098,3.933,0.000,2.594,11.173,152.199
 3048.500,0.069,0.013,67.366,60.502,8.081,6.875,0.000,0.003,0.039,0.002,4.567,3.171,0.000,0.000,0.005,0.111,3.908,0.000,2.592,10.060,152.435
 3049.000,0.063,0.012,68.144,69.163,8.694,7.220,0.000,0.003,0.039,0.003,4.843,3.215,0.000,0.000,0.006,0.126,3.973,0.000,2.603,8.599,152.240
 3049.500,0.047,0.015,68.300,77.532,9.522,8.170,0.000,0.003,0.039,0.005,5.865,3.950,0.000,0.000,0.008,0.113,4.159,0.000,2.629,7.548,151.432
 3050.000,0.040,0.004,70.977,76.881,10.516,9.790,0.000,0.003,0.038,0.005,10.780,5.002,0.000,0.000,0.009,0.083,4.372,0.000,2.642,9.499,151.367
 3050.500,0.028,0.006,68.738,70.401,11.582,12.555,7.000,0.003,0.036,0.006,28.633,28.245,0.000,0.000,0.010,0.052,4.352,0.000,2.663,14.853,151.874
 3051.000,0.017,0.012,62.848,63.204,12.618,15.196,0.000,0.004,0.035,0.007,40.984,48.852,0.000,0.000,0.010,0.031,4.254,0.000,2.682,25.069,151.963
 3051.500,0.025,0.013,58.009,53.891,13.138,17.297,0.000,0.003,0.035,0.007,48.045,55.901,0.001,0.000,0.010,0.021,4.156,0.000,2.667,56.751,152.400
 3052.000,0.033,0.011,53.667,56.203,12.790,16.991,0.000,0.003,0.036,0.006,38.290,45.570,0.001,0.000,0.009,0.021,4.161,0.000,2.654,123.412,153.544
 3052.500,0.033,0.023,50.769,78.232,11.854,14.218,0.000,0.002,0.040,0.005,22.287,23.165,0.003,0.000,0.008,0.029,4.057,0.000,2.653,84.757,154.134
 3053.000,0.055,0.019,51.228,112.928,10.529,11.351,0.000,0.002,0.044,0.004,16.225,12.110,0.003,0.000,0.007,0.047,4.083,0.000,2.616,40.330,154.199
 3053.500,0.075,0.005,54.166,144.155,9.184,8.990,0.000,0.002,0.046,0.004,13.123,9.732,0.003,0.000,0.006,0.079,4.127,0.000,2.581,20.853,154.276
 3054.000,0.079,-0.001,60.330,157.213,7.931,7.774,0.000,0.002,0.048,0.003,4.465,4.526,0.003,0.000,0.005,0.120,4.371,0.000,2.575,11.802,154.748
 3054.500,0.086,0.003,65.992,152.606,6.904,6.991,0.000,0.001,0.051,0.002,5.420,2.868,0.001,0.000,0.004,0.142,4.218,0.000,2.562,9.243,155.008
 3055.000,0.092,0.009,69.250,140.932,6.195,6.316,0.000,0.001,0.054,0.002,10.147,6.110,0.001,0.000,0.003,0.153,4.055,0.000,2.553,7.687,155.397
 3055.500,0.100,0.003,76.544,122.452,5.775,5.768,0.000,0.001,0.056,0.002,5.625,4.175,0.000,0.000,0.003,0.166,4.022,0.000,2.539,7.963,154.695
 3056.000,0.114,0.003,77.597,110.673,5.605,5.383,0.000,0.002,0.060,0.002,3.801,2.728,0.000,0.000,0.004,0.189,3.862,0.000,2.515,8.204,155.096
 3056.500,0.122,0.009,75.867,108.857,5.683,5.168,0.000,0.003,0.062,0.002,3.984,2.886,0.000,0.000,0.005,0.195,3.616,0.000,2.501,6.962,155.468
 3057.000,0.118,0.026,80.800,105.748,5.963,5.162,0.000,0.004,0.063,0.003,3.975,2.912,0.000,0.000,0.007,0.203,3.593,0.000,2.508,6.789,155.863
 3057.500,0.121,0.024,84.144,100.041,6.355,5.422,0.000,0.006,0.063,0.003,3.469,2.554,0.000,0.000,0.009,0.216,3.681,0.000,2.503,6.577,156.241
 3058.000,0.113,0.015,84.908,92.649,6.732,6.022,0.000,0.010,0.062,0.002,3.463,2.399,0.000,0.000,0.012,0.208,3.864,0.000,2.516,6.090,155.645
 3058.500,0.091,0.016,84.414,80.479,6.932,6.936,0.000,0.011,0.062,0.002,3.691,3.274,0.000,0.000,0.013,0.159,4.003,0.000,2.555,6.833,154.005
 3059.000,0.060,0.023,79.586,66.941,6.893,7.811,0.000,0.009,0.062,0.003,16.535,8.454,0.000,0.000,0.011,0.100,4.205,0.000,2.608,10.273,151.172
 3059.500,0.045,0.022,75.131,54.062,6.657,8.097,0.000,0.007,0.062,0.003,27.892,17.969,0.000,0.000,0.010,0.064,4.290,0.000,2.634,15.557,148.110
 3060.000,0.045,0.011,68.470,47.875,6.277,7.446,0.000,0.007,0.062,0.003,18.117,13.812,0.000,0.000,0.009,0.052,4.404,0.000,2.633,22.468,147.018
 3060.500,0.037,0.051,60.053,49.341,5.791,6.275,0.000,0.008,0.060,0.003,11.493,10.345,0.000,0.000,0.011,0.060,4.134,0.000,2.646,17.975,145.802
 3061.000,0.056,0.077,57.575,59.883,5.266,5.174,0.000,0.010,0.059,0.003,9.333,6.630,0.000,0.000,0.012,0.088,3.890,0.000,2.615,13.844,144.734
 3061.500,0.068,0.093,61.366,68.406,4.671,4.339,0.000,0.013,0.054,0.002,7.486,5.955,0.000,0.000,0.015,0.134,3.650,0.000,2.594,8.788,143.371
 3062.000,0.074,0.105,67.594,72.957,4.146,3.825,0.000,0.014,0.049,0.003,1.731,1.827,0.000,0.000,0.017,0.185,3.515,0.000,2.583,6.282,143.059
 3062.500,0.079,0.117,70.109,79.518,3.706,3.474,0.000,0.014,0.044,0.005,2.447,2.177,0.000,0.000,0.019,0.221,3.394,0.003,2.575,4.365,142.445
 3063.000,0.078,0.130,74.819,85.298,3.373,3.239,0.000,0.013,0.043,0.008,2.602,2.399,0.000,0.000,0.021,0.226,3.261,0.016,2.576,3.765,142.604
 3063.500,0.101,0.089,80.259,83.931,3.162,3.085,0.000,0.014,0.042,0.014,2.357,2.233,0.000,0.001,0.028,0.227,3.368,0.063,2.537,3.881,142.533
 3064.000,0.098,0.080,79.348,83.393,3.032,3.020,0.000,0.016,0.041,0.020,1.957,2.214,0.001,0.004,0.036,0.235,3.469,0.152,2.542,3.586,139.542
 3064.500,0.094,0.079,79.477,76.702,2.967,3.026,0.000,0.021,0.037,0.033,2.911,2.107,0.004,0.033,0.054,0.228,3.746,0.400,2.550,3.499,134.337
 3065.000,0.090,0.087,78.519,61.576,2.921,3.043,7.000,0.025,0.033,0.043,5.225,3.292,0.019,0.099,0.068,0.197,3.991,0.665,2.556,3.922,126.371
 3065.500,0.091,0.095,76.228,46.076,2.864,3.014,0.000,0.032,0.025,0.057,6.729,5.811,0.161,0.310,0.089,0.168,4.352,1.131,2.554,5.523,117.018
 3066.000,0.102,0.085,71.934,34.061,2.792,2.930,0.000,0.036,0.021,0.064,7.286,8.488,0.705,0.494,0.100,0.149,4.465,1.227,2.535,7.243,108.173
 3066.500,0.113,0.086,65.520,25.871,2.715,2.807,0.000,0.040,0.016,0.073,6.940,8.211,4.422,0.818,0.113,0.142,4.393,1.396,2.517,7.953,101.877
 3067.000,0.119,0.085,62.739,21.915,2.631,2.673,0.000,0.043,0.013,0.077,6.535,7.764,9.749,1.029,0.120,0.145,4.530,1.755,2.507,7.716,97.811
 3067.500,0.118,0.081,62.888,22.240,2.551,2.544,0.000,0.046,0.008,0.082,5.805,7.439,23.755,1.314,0.128,0.151,4.532,2.241,2.509,6.599,94.643
 3068.000,0.126,0.067,64.336,24.797,2.479,2.434,0.000,0.049,0.006,0.084,5.439,6.601,35.135,1.402,0.133,0.155,4.471,2.392,2.495,5.942,92.235
 3068.500,0.138,0.052,65.119,26.929,2.425,2.354,0.000,0.056,0.008,0.085,5.318,6.686,54.587,1.374,0.141,0.152,4.460,2.343,2.474,5.808,92.046
 3069.000,0.142,0.051,65.059,29.030,2.403,2.314,0.000,0.062,0.011,0.084,5.321,6.848,68.079,1.255,0.146,0.151,4.483,2.140,2.468,5.951,92.229
 3069.500,0.138,0.057,65.791,30.756,2.432,2.313,0.000,0.069,0.017,0.079,5.583,6.845,85.465,0.945,0.148,0.156,4.589,1.612,2.475,6.331,93.409
 3070.000,0.131,0.061,65.652,31.325,2.520,2.359,0.000,0.071,0.020,0.072,5.715,6.741,90.352,0.667,0.143,0.158,4.596,1.138,2.486,7.106,95.782
 3070.500,0.121,0.077,64.427,34.126,2.675,2.471,0.000,0.067,0.025,0.060,5.442,6.918,85.840,0.324,0.127,0.152,4.551,0.553,2.503,7.553,100.095
 3071.000,0.096,0.094,63.700,39.548,2.893,2.666,0.000,0.062,0.028,0.052,5.473,6.926,74.447,0.178,0.113,0.138,4.598,0.304,2.545,8.182,105.494
 3071.500,0.070,0.110,63.145,47.802,3.169,2.944,0.000,0.052,0.031,0.040,7.627,8.292,51.200,0.062,0.091,0.121,4.476,0.105,2.590,7.736,113.112
 3072.000,0.066,0.101,63.103,55.910,3.517,3.296,0.000,0.043,0.033,0.031,7.334,6.461,35.358,0.023,0.074,0.113,4.256,0.040,2.597,7.388,122.890
 3072.500,0.043,0.118,63.311,61.886,3.934,3.705,0.000,0.029,0.038,0.018,5.493,4.891,18.413,0.003,0.047,0.123,4.118,0.009,2.636,6.325,132.673
 3073.000,0.037,0.111,65.566,65.419,4.406,4.175,0.000,0.018,0.042,0.012,3.181,3.791,10.763,0.001,0.031,0.147,3.872,0.004,2.648,5.953,139.660
 3073.500,0.061,0.070,67.641,66.786,4.872,4.712,0.000,0.007,0.048,0.007,3.162,3.931,4.406,0.000,0.014,0.167,3.702,0.001,2.606,6.252,145.519
 3074.000,0.065,0.062,70.575,65.598,5.233,5.214,0.000,0.003,0.048,0.004,3.103,3.540,2.013,0.000,0.007,0.177,3.565,0.000,2.600,6.507,149.998
 3074.500,0.062,0.067,74.267,66.102,5.453,5.607,0.000,0.001,0.047,0.002,3.578,3.544,0.407,0.000,0.004,0.182,3.612,0.000,2.604,7.129,153.232
 3075.000,0.061,0.069,75.186,66.330,5.532,5.827,0.000,0.001,0.046,0.002,4.088,3.898,0.098,0.000,0.003,0.183,3.602,0.000,2.607,7.376,154.966
 3075.500,0.066,0.060,75.663,64.637,5.527,5.876,0.000,0.000,0.048,0.001,3.908,3.894,0.009,0.000,0.001,0.179,3.664,0.000,2.597,7.581,155.480
 3076.000,0.070,0.059,75.020,64.605,5.490,5.801,0.000,-0.001,0.049,0.001,3.584,3.507,0.001,0.000,0.001,0.181,3.624,0.000,2.591,7.474,155.899
 3076.500,0.063,0.064,74.633,65.793,5.462,5.691,0.000,-0.001,0.049,0.001,3.564,3.440,0.000,0.000,0.001,0.181,3.657,0.000,2.602,7.002,155.586
 3077.000,0.060,0.065,74.797,65.402,5.443,5.608,0.000,0.000,0.048,0.001,3.308,3.100,0.000,0.000,0.001,0.181,3.681,0.000,2.608,6.387,155.497
 3077.500,0.062,0.056,74.927,67.161,5.407,5.599,0.000,0.000,0.048,0.001,3.091,3.052,0.000,0.000,0.001,0.177,3.675,0.000,2.604,5.969,154.925
 3078.000,0.059,0.059,74.798,67.438,5.350,5.616,0.000,0.001,0.050,0.001,4.077,3.392,0.000,0.000,0.002,0.172,3.763,0.000,2.609,5.976,154.724
 3078.500,0.058,0.059,74.175,65.647,5.287,5.601,0.000,0.001,0.050,0.001,4.972,4.116,0.000,0.000,0.002,0.170,3.729,0.000,2.610,6.372,154.559
 3079.000,0.056,0.063,73.950,65.158,5.224,5.524,0.000,0.001,0.051,0.003,4.705,4.234,0.000,0.000,0.004,0.174,3.753,0.000,2.614,6.775,154.429
 3079.500,0.060,0.062,72.608,65.842,5.149,5.399,7.000,0.002,0.053,0.003,4.271,3.606,0.000,0.000,0.005,0.178,3.756,0.000,2.607,6.886,153.857
 3080.000,0.067,0.055,72.891,67.455,5.039,5.241,0.000,0.002,0.060,0.003,4.305,3.691,0.000,0.000,0.005,0.181,3.660,0.000,2.596,6.645,153.397
 3080.500,0.069,0.055,73.631,72.457,4.868,5.052,0.000,0.003,0.065,0.003,3.984,3.950,0.000,0.000,0.006,0.180,3.515,0.000,2.593,6.263,151.898
 3081.000,0.078,0.045,73.917,77.513,4.683,4.835,0.000,0.004,0.069,0.003,3.846,3.348,0.000,0.000,0.007,0.173,3.347,0.000,2.576,5.936,149.815
 3081.500,0.086,0.040,73.977,81.624,4.497,4.598,0.000,0.005,0.069,0.003,4.018,3.244,0.000,0.000,0.008,0.167,3.204,0.000,2.563,5.702,146.339
 3082.000,0.090,0.040,73.803,84.681,4.337,4.387,0.000,0.005,0.069,0.002,3.719,2.956,0.000,0.000,0.007,0.158,3.102,0.000,2.556,5.430,143.867
 3082.500,0.090,0.050,73.452,83.198,4.206,4.214,0.000,0.004,0.069,0.002,3.990,3.119,0.000,0.000,0.006,0.163,3.091,0.000,2.556,5.176,142.286
 3083.000,0.092,0.052,73.186,83.043,4.100,4.089,0.000,0.003,0.072,0.002,3.621,2.912,0.000,0.000,0.005,0.165,3.094,0.000,2.554,4.935,141.619
 3083.500,0.085,0.061,73.742,83.092,4.015,3.992,0.000,0.002,0.075,0.002,3.660,2.956,0.000,0.000,0.004,0.170,3.109,0.000,2.565,4.796,141.926
 3084.000,0.081,0.068,74.397,82.872,3.930,3.906,0.000,0.001,0.080,0.002,3.736,2.964,0.000,0.000,0.003,0.178,3.162,0.000,2.572,4.755,142.587
 3084.500,0.077,0.069,74.514,84.468,3.825,3.819,0.000,0.001,0.082,0.002,3.624,2.979,0.000,0.000,0.003,0.184,3.177,0.000,2.579,4.748,143.377
 3085.000,0.072,0.071,75.592,87.268,3.691,3.719,0.000,0.001,0.082,0.001,3.457,2.824,0.000,0.000,0.002,0.192,3.223,0.000,2.587,4.744,144.870
 3085.500,0.078,0.064,76.073,88.595,3.544,3.591,0.000,0.001,0.080,0.002,3.162,2.561,0.000,0.000,0.003,0.200,3.194,0.000,2.577,4.673,145.448
 3086.000,0.086,0.062,76.120,89.483,3.412,3.435,0.000,0.001,0.076,0.003,3.452,2.938,0.000,0.000,0.005,0.208,3.121,0.000,2.563,4.639,145.354
 3086.500,0.099,0.058,77.595,89.344,3.344,3.258,0.000,0.002,0.073,0.006,3.463,3.193,0.000,0.000,0.008,0.218,3.091,0.001,2.542,4.598,144.988
 3087.000,0.106,0.066,77.820,91.583,3.375,3.110,0.000,0.004,0.067,0.011,2.818,2.262,0.000,0.001,0.015,0.239,3.152,0.014,2.528,4.390,143.590
 3087.500,0.112,0.082,78.127,89.385,3.522,3.051,0.000,0.006,0.062,0.016,2.340,2.129,0.000,0.003,0.021,0.250,3.218,0.063,2.518,4.115,141.595
 3088.000,0.114,0.080,80.448,77.548,3.776,3.163,0.000,0.008,0.055,0.023,2.103,1.923,0.000,0.012,0.032,0.265,3.399,0.225,2.515,3.692,139.424
 3088.500,0.111,0.078,78.830,63.400,4.115,3.505,0.000,0.011,0.051,0.028,1.931,1.668,0.001,0.023,0.038,0.258,3.693,0.318,2.521,3.300,137.801
 3089.000,0.092,0.092,74.503,45.702,4.517,4.123,0.000,0.014,0.044,0.034,2.503,2.188,0.004,0.044,0.048,0.211,4.051,0.393,2.553,3.605,135.612
 3089.500,0.079,0.093,75.206,26.571,4.992,4.964,0.000,0.018,0.038,0.036,5.164,5.969,0.044,0.056,0.054,0.148,4.293,0.315,2.575,6.345,131.824
 3090.000,0.076,0.069,73.172,16.607,5.557,5.821,0.000,0.025,0.029,0.040,7.165,9.311,0.121,0.068,0.064,0.112,4.428,0.266,2.579,11.798,127.398
 3090.500,0.077,0.070,62.655,13.823,6.277,6.513,0.000,0.029,0.023,0.041,6.490,9.293,0.447,0.071,0.070,0.097,4.460,0.173,2.578,23.104,124.158
 3091.000,0.068,0.099,57.330,14.564,7.110,7.014,0.000,0.033,0.016,0.041,4.454,7.070,0.852,0.067,0.074,0.098,4.394,0.158,2.593,28.940,122.081
 3091.500,0.069,0.098,57.973,17.258,7.862,7.392,0.000,0.033,0.013,0.040,5.555,6.918,1.713,0.060,0.073,0.107,4.346,0.126,2.592,17.578,120.883
 3092.000,0.081,0.086,59.420,19.147,8.215,7.646,0.000,0.032,0.010,0.037,6.422,7.336,2.238,0.047,0.069,0.119,4.306,0.111,2.571,12.287,119.928
 3092.500,0.082,0.089,61.669,19.285,8.177,7.758,0.000,0.031,0.010,0.035,6.056,7.638,2.624,0.035,0.066,0.120,4.325,0.101,2.571,10.554,119.072
 3093.000,0.056,0.136,61.388,18.374,8.000,7.762,7.000,0.028,0.011,0.029,6.129,8.081,2.549,0.018,0.058,0.115,4.471,0.094,2.614,11.718,119.237
 3093.500,0.063,0.111,59.888,18.170,7.914,7.770,0.000,0.026,0.013,0.025,5.870,8.573,2.328,0.010,0.051,0.104,4.562,0.051,2.603,13.853,120.588
 3094.000,0.056,0.099,58.205,18.068,8.025,7.929,0.000,0.023,0.015,0.018,5.769,8.166,2.157,0.003,0.041,0.095,4.586,0.016,2.614,14.461,123.509
 3094.500,0.045,0.099,58.063,18.688,8.398,8.309,0.000,0.020,0.017,0.013,6.107,5.608,1.799,0.001,0.033,0.088,4.424,0.005,2.633,12.233,127.109
 3095.000,0.020,0.110,58.478,20.630,8.998,8.893,0.000,0.016,0.020,0.007,7.543,6.080,1.410,0.000,0.023,0.082,4.339,0.001,2.675,11.791,129.599
 3095.500,0.001,0.104,58.823,21.102,9.814,9.569,0.000,0.014,0.022,0.004,6.028,6.900,0.837,0.000,0.018,0.077,4.379,0.000,2.709,11.557,131.186
 3096.000,0.020,0.062,58.920,19.367,10.843,10.301,0.000,0.017,0.023,0.002,5.059,5.404,0.514,0.000,0.018,0.076,4.315,0.000,2.675,12.265,133.488
 3096.500,0.022,0.059,58.773,17.159,12.063,11.577,0.000,0.016,0.023,0.001,5.124,5.644,0.196,0.000,0.016,0.079,4.271,0.000,2.672,12.576,136.639
 3097.000,0.023,0.050,58.827,14.565,13.415,12.888,0.000,0.008,0.023,0.001,6.774,7.011,0.077,0.000,0.009,0.074,4.353,0.000,2.670,12.247,139.967
 3097.500,0.027,0.037,59.900,11.859,14.920,14.826,0.000,0.003,0.023,0.001,7.478,6.852,0.014,0.000,0.004,0.062,4.605,0.000,2.663,13.053,141.660
 3098.000,0.030,0.025,61.227,10.635,16.492,17.536,0.000,0.001,0.024,0.001,10.817,10.577,0.004,0.000,0.002,0.046,4.589,0.000,2.659,16.492,142.421
 3098.500,0.027,0.017,61.491,10.550,18.192,21.007,0.000,0.001,0.023,0.001,10.358,18.102,0.001,0.000,0.002,0.033,4.625,0.000,2.664,24.023,142.817
 3099.000,0.020,0.013,60.411,10.550,19.956,24.738,0.000,0.001,0.022,0.001,7.925,18.730,0.000,0.000,0.002,0.027,4.765,0.000,2.676,38.160,143.123
 3099.500,0.014,0.015,58.888,10.550,21.272,27.805,0.000,0.001,0.021,0.001,6.250,13.978,0.000,0.000,0.001,0.025,4.783,0.000,2.687,56.609,142.457
 3100.000,0.013,0.016,57.447,10.550,21.807,28.504,0.000,0.001,0.021,0.001,5.324,10.869,0.000,0.000,0.001,0.026,4.804,0.000,2.687,58.481,142.085
 3100.500,0.006,0.030,56.725,10.550,21.668,26.411,0.000,0.000,0.021,0.001,8.069,10.640,0.000,0.000,0.001,0.029,4.785,0.000,2.700,53.869,142.297
 3101.000,0.011,0.032,56.964,10.550,20.905,23.441,0.000,0.000,0.020,0.001,13.280,13.974,0.000,0.000,0.001,0.037,4.808,0.000,2.692,47.960,142.911
 3101.500,0.014,0.039,56.967,10.550,19.685,21.246,0.000,0.000,0.019,0.001,9.716,9.972,0.000,0.000,0.001,0.048,4.589,0.000,2.686,31.620,143.649
 3102.000,0.021,0.041,56.216,10.550,18.232,20.124,0.000,0.001,0.019,0.001,7.148,6.350,0.000,0.000,0.002,0.056,4.388,0.000,2.674,20.892,144.062
 3102.500,0.023,0.050,57.347,10.550,16.901,19.095,0.000,0.001,0.019,0.001,9.181,11.748,0.000,0.000,0.002,0.055,4.293,0.000,2.670,20.236,143.879
 3103.000,0.029,0.048,62.223,10.550,15.888,17.707,0.000,0.002,0.017,0.002,8.829,15.533,0.000,0.000,0.003,0.049,4.245,0.000,2.661,23.406,142.410
 3103.500,0.039,0.032,62.595,10.550,15.197,16.331,0.000,0.002,0.015,0.002,7.430,9.743,0.000,0.000,0.004,0.054,4.256,0.000,2.643,27.152,141.153
 3104.000,0.032,0.040,59.048,10.550,14.492,15.514,0.000,0.004,0.013,0.003,5.251,5.268,0.000,0.000,0.007,0.063,4.334,0.001,2.655,22.490,140.421
 3104.500,0.041,0.031,59.013,10.550,13.710,15.052,0.000,0.007,0.012,0.004,8.072,7.421,0.000,0.000,0.011,0.059,4.252,0.001,2.640,18.773,139.465
 3105.000,0.039,0.039,61.977,10.550,12.898,14.164,0.000,0.014,0.013,0.005,11.231,10.334,0.000,0.000,0.019,0.053,4.262,0.001,2.643,18.702,137.954
 3105.500,0.054,0.026,64.194,10.550,12.280,12.935,0.000,0.019,0.014,0.006,9.978,9.466,0.000,0.000,0.024,0.056,4.182,0.002,2.618,22.170,136.438
 3106.000,0.054,0.035,63.442,10.550,11.884,11.803,0.000,0.024,0.013,0.007,5.825,5.124,0.000,0.000,0.031,0.069,4.102,0.002,2.618,20.235,135.305
 3106.500,0.062,0.036,63.939,10.550,11.507,11.150,0.000,0.027,0.012,0.007,7.222,5.615,0.000,0.000,0.034,0.085,4.142,0.003,2.604,14.984,133.818
 3107.000,0.069,0.033,65.177,10.550,11.082,10.551,0.000,0.028,0.011,0.007,9.212,7.129,0.000,0.000,0.035,0.089,3.930,0.005,2.592,11.654,131.688
 3107.500,0.071,0.028,68.423,10.550,10.596,10.411,0.000,0.027,0.010,0.006,9.871,7.494,0.002,0.000,0.033,0.081,3.962,0.006,2.588,11.053,130.826
 3108.000,0.068,0.027,70.320,10.550,10.152,10.189,0.000,0.025,0.010,0.004,9.333,8.222,0.004,0.000,0.029,0.071,3.951,0.008,2.594,12.966,131.151
 3108.500,0.064,0.028,71.450,10.550,9.879,9.908,0.000,0.025,0.010,0.002,9.133,8.443,0.010,0.000,0.027,0.069,4.003,0.008,2.601,15.248,132.526
 3109.000,0.048,0.040,73.148,10.550,9.848,9.604,0.000,0.026,0.010,0.001,6.025,5.973,0.013,0.000,0.027,0.074,4.040,0.007,2.629,15.710,134.261
 3109.500,0.046,0.043,72.686,10.550,9.983,9.449,7.000,0.028,0.010,0.001,5.437,4.780,0.015,0.000,0.028,0.088,4.161,0.006,2.632,15.351,135.423
 3110.000,0.054,0.037,71.473,10.550,10.186,9.513,0.000,0.032,0.012,0.001,5.262,4.396,0.012,0.000,0.032,0.101,4.260,0.003,2.618,12.568,135.972
 3110.500,0.053,0.039,69.172,10.550,10.325,9.808,0.000,0.036,0.014,0.001,5.009,3.961,0.006,0.000,0.037,0.111,4.301,0.001,2.620,10.856,136.680
 3111.000,0.058,0.035,66.456,10.550,10.308,10.226,0.000,0.042,0.015,0.001,6.138,4.732,0.003,0.000,0.042,0.102,4.236,0.000,2.611,11.269,136.426
 3111.500,0.060,0.038,64.347,10.550,10.146,10.569,0.000,0.048,0.016,0.001,7.889,6.586,0.001,0.000,0.048,0.088,4.145,0.000,2.608,12.446,135.346
 3112.000,0.059,0.037,60.536,10.550,9.810,10.710,0.000,0.053,0.016,0.001,9.021,7.745,0.000,0.000,0.054,0.085,4.020,0.000,2.609,14.251,134.379
 3112.500,0.065,0.036,60.213,10.550,9.270,10.491,0.000,0.062,0.016,0.001,7.126,6.353,0.000,0.000,0.063,0.085,3.801,0.000,2.599,15.033,133.959
 3113.000,0.069,0.049,62.636,10.550,8.604,9.752,0.000,0.069,0.017,0.001,7.213,6.028,0.000,0.000,0.070,0.086,3.706,0.000,2.592,14.740,133.771
 3113.500,0.081,0.053,63.114,10.550,7.895,8.655,0.000,0.079,0.018,0.001,9.496,8.713,0.000,0.000,0.080,0.088,3.590,0.000,2.571,15.374,133.074
 3114.000,0.095,0.054,61.109,10.550,7.223,7.502,0.000,0.077,0.020,0.001,9.798,9.699,0.000,0.000,0.078,0.102,3.509,0.000,2.547,14.404,133.128
 3114.500,0.110,0.045,62.352,10.550,6.605,6.579,0.000,0.069,0.023,0.001,5.546,4.522,0.000,0.000,0.069,0.123,3.416,0.000,2.522,11.914,134.556
 3115.000,0.105,0.064,69.903,10.550,6.060,5.935,0.000,0.061,0.025,0.001,4.575,3.529,0.000,0.000,0.061,0.141,3.513,0.001,2.531,8.937,135.600
 3115.500,0.102,0.067,73.583,10.550,5.626,5.473,0.000,0.048,0.026,0.001,3.883,2.997,0.000,0.000,0.048,0.149,3.540,0.006,2.535,6.514,136.556
 3116.000,0.100,0.062,73.763,10.550,5.355,5.158,0.000,0.039,0.027,0.001,4.105,3.060,0.000,0.000,0.039,0.152,3.545,0.011,2.539,6.246,138.102
 3116.500,0.101,0.058,75.053,10.550,5.283,4.969,0.000,0.033,0.027,0.001,3.871,2.883,0.000,0.000,0.033,0.153,3.573,0.014,2.537,6.263,139.211
 3117.000,0.101,0.056,76.109,10.550,5.442,4.945,0.000,0.030,0.026,0.001,3.877,2.864,0.000,0.000,0.030,0.155,3.581,0.013,2.538,6.284,140.144
 3117.500,0.103,0.050,77.427,10.550,5.794,5.146,0.000,0.024,0.024,0.001,3.809,2.912,0.000,0.000,0.025,0.157,3.672,0.014,2.534,6.235,141.577
 3118.000,0.102,0.035,77.577,10.550,6.278,5.610,0.000,0.020,0.024,0.001,3.511,2.750,0.000,0.000,0.021,0.147,3.716,0.009,2.535,6.109,142.799
 3118.500,0.088,0.036,77.617,10.550,6.770,6.353,0.000,0.019,0.026,0.001,3.978,3.097,0.000,0.000,0.020,0.126,3.869,0.004,2.559,6.368,142.498
 3119.000,0.078,0.034,77.645,10.550,7.129,7.270,0.000,0.023,0.027,0.001,6.746,5.209,0.000,0.000,0.024,0.101,3.952,0.001,2.577,8.085,140.863
 3119.500,0.063,0.041,77.733,10.550,7.278,8.039,0.000,0.031,0.030,0.001,11.020,8.772,0.000,0.000,0.031,0.078,4.128,0.000,2.602,10.822,139.223
 3120.000,0.059,0.043,77.733,10.550,7.249,8.252,0.000,0.034,0.032,0.001,9.477,8.942,0.000,0.000,0.034,0.070,4.143,0.000,2.608,14.369,138.692
 3120.500,0.061,0.066,77.744,10.550,7.085,7.711,0.000,0.036,0.036,0.001,7.199,7.321,0.000,0.000,0.036,0.069,3.982,0.000,2.606,16.870,139.229
 3121.000,0.081,0.057,77.794,10.550,6.828,6.859,0.000,0.037,0.040,0.001,5.040,7.011,0.000,0.000,0.037,0.069,3.825,0.000,2.572,15.407,140.096
 3121.500,0.086,0.064,77.897,10.550,6.469,6.105,0.000,0.041,0.046,0.001,4.454,4.648,0.000,0.000,0.042,0.068,3.782,0.000,2.563,11.377,141.247
 3122.000,0.086,0.072,77.770,10.550,5.954,5.619,0.000,0.044,0.052,0.001,2.858,2.539,0.000,0.000,0.044,0.068,3.591,0.000,2.562,8.151,142.103
 3122.500,0.082,0.073,77.700,10.550,5.423,5.316,0.000,0.045,0.061,0.001,3.452,2.790,0.000,0.000,0.045,0.067,3.480,0.000,2.570,6.044,144.251
 3123.000,0.081,0.065,77.700,10.550,4.963,5.050,0.000,0.040,0.067,0.001,3.618,2.953,0.000,0.000,0.040,0.067,3.421,0.000,2.572,5.233,146.924
 3123.500,0.082,0.063,77.700,10.550,4.623,4.753,7.000,0.027,0.075,0.001,4.339,3.492,0.000,0.000,0.027,0.067,3.352,0.000,2.569,5.967,149.331
 3124.000,0.083,0.068,77.700,10.550,4.463,4.462,0.000,0.017,0.079,0.001,3.930,3.418,0.000,0.000,0.017,0.067,3.305,0.000,2.568,6.285,151.544
 3124.500,0.094,0.059,77.700,10.550,4.418,4.270,0.000,0.012,0.081,0.001,3.207,2.698,0.000,0.000,0.013,0.067,3.356,0.000,2.549,6.091,152.618
 3125.000,0.095,0.061,77.700,10.550,4.401,4.154,0.000,0.012,0.081,0.001,2.517,2.284,0.000,0.000,0.013,0.067,3.349,0.000,2.547,5.498,153.167
 3125.500,0.093,0.072,77.700,10.550,4.467,4.065,0.000,0.008,0.080,0.001,3.303,2.705,0.000,0.000,0.008,0.067,3.358,0.000,2.551,5.254,152.765
 3126.000,0.098,0.068,77.700,10.550,4.532,4.009,0.000,0.002,0.079,0.001,3.928,3.189,0.000,0.000,0.003,0.067,3.319,0.000,2.542,5.338,153.037
 3126.500,0.109,0.050,77.700,10.550,4.646,4.010,0.000,0.000,0.077,0.001,2.959,2.739,0.000,0.000,0.001,0.067,3.456,0.000,2.524,5.225,151.390
 3127.000,0.101,0.056,77.700,10.550,4.732,4.113,0.000,-0.001,0.076,0.001,2.790,2.510,0.000,0.000,0.000,0.067,3.521,0.000,2.538,4.939,149.532
 3127.500,0.087,0.063,77.700,10.550,4.771,4.307,0.000,-0.001,0.073,0.001,3.674,2.964,0.000,0.000,0.000,0.067,3.615,0.000,2.562,5.045,147.638
 3128.000,0.070,0.065,77.700,10.550,4.781,4.399,0.000,-0.001,0.070,0.001,4.232,3.477,-0.016,0.000,0.000,0.067,3.718,0.000,2.590,5.755,146.564
 3128.500,0.063,0.056,77.700,10.550,4.776,4.475,0.000,-0.001,0.065,0.001,3.829,3.436,-0.278,0.000,0.000,0.067,3.853,0.000,2.603,6.550,146.174
 3129.000,0.058,0.057,77.700,10.550,4.762,4.477,0.000,-0.001,0.062,0.001,3.640,3.503,-0.577,0.000,0.000,0.067,3.834,0.000,2.611,6.946,146.304
 3129.500,0.068,0.055,77.700,10.550,4.743,4.380,0.000,-0.001,0.058,0.001,3.553,3.230,-0.889,0.000,0.000,0.067,3.761,0.000,2.594,6.651,147.036
 3130.000,0.067,0.081,77.700,10.550,4.716,4.303,0.000,0.000,0.056,0.001,3.373,3.071,-0.780,0.000,0.001,0.067,3.638,0.000,2.596,6.293,147.779
 3130.500,0.088,0.072,77.700,10.550,4.682,4.150,0.000,0.001,0.055,0.001,3.024,2.687,-0.353,0.000,0.001,0.067,3.621,0.000,2.560,5.893,148.741
 3131.000,0.097,0.064,77.700,10.550,4.636,4.048,0.000,0.001,0.056,0.001,2.489,2.318,-0.115,0.000,0.002,0.067,3.633,0.000,2.544,5.286,148.818
 3131.500,0.092,0.068,77.700,10.550,4.576,4.028,0.000,0.001,0.059,0.001,2.247,2.177,0.000,0.000,0.002,0.067,3.762,0.000,2.553,4.874,148.535
 3132.000,0.065,0.087,77.700,10.550,4.505,4.044,0.000,0.001,0.061,0.001,3.497,2.824,0.000,0.000,0.002,0.067,3.865,0.000,2.598,5.094,148.015
 3132.500,0.061,0.074,77.700,10.550,4.456,4.076,0.000,0.001,0.064,0.001,4.322,3.699,0.000,0.000,0.002,0.067,3.996,0.000,2.606,6.054,147.638
 3133.000,0.052,0.082,77.700,10.550,4.450,4.116,0.000,0.001,0.064,0.001,4.505,4.153,0.000,0.000,0.002,0.068,3.959,0.000,2.620,7.310,146.634
 3133.500,0.050,0.119,77.700,10.550,4.475,4.159,0.000,0.001,0.064,0.001,3.933,4.648,0.000,0.000,0.002,0.068,3.816,0.000,2.625,7.947,145.596
 3134.000,0.071,0.136,77.700,10.550,4.503,4.201,0.000,0.001,0.063,0.001,3.314,3.935,0.000,0.000,0.002,0.066,3.794,0.000,2.588,7.449,143.767
 3134.500,0.084,0.172,77.700,10.550,4.492,4.242,0.000,0.001,0.061,0.001,1.878,2.092,0.000,0.000,0.002,0.064,3.705,0.000,2.566,6.175,142.091
 3135.000,0.102,0.188,77.700,10.550,4.435,4.284,0.000,0.002,0.058,0.001,1.349,1.598,0.000,0.000,0.003,0.065,3.698,0.000,2.535,4.990,140.563
 3135.500,0.111,0.181,77.700,10.550,4.375,4.334,0.000,0.002,0.057,0.001,1.641,1.845,0.000,0.000,0.004,0.066,3.760,0.000,2.521,4.375,140.250
 3136.000,0.104,0.161,77.700,10.550,4.385,4.404,0.000,0.003,0.055,0.001,2.078,2.081,0.000,0.000,0.004,0.067,3.824,0.000,2.533,4.430,141.878
 3136.500,0.085,0.146,77.700,10.550,4.533,4.538,7.000,0.003,0.055,0.002,2.717,2.875,0.000,0.000,0.004,0.068,3.882,0.000,2.565,5.124,143.159
 3137.000,0.051,0.156,77.700,10.550,4.939,4.840,0.000,0.002,0.049,0.002,3.933,4.758,0.000,0.000,0.004,0.067,3.832,0.000,2.623,5.913,142.587
 3137.500,0.054,0.119,77.700,10.550,5.528,5.317,0.000,0.002,0.042,0.003,4.783,6.376,0.000,0.000,0.005,0.067,3.690,0.000,2.618,6.265,140.651
 3138.000,0.059,0.117,77.700,10.550,6.158,6.122,0.000,0.003,0.030,0.005,4.744,6.394,0.000,0.000,0.008,0.067,3.341,0.000,2.609,6.075,138.202
 3138.500,0.062,0.129,77.700,10.550,6.763,7.252,0.000,0.004,0.026,0.007,4.713,6.390,0.000,0.000,0.011,0.067,3.058,0.001,2.604,5.697,136.149
 3139.000,0.063,0.134,77.700,10.550,7.086,8.512,0.000,0.007,0.024,0.011,4.713,6.390,0.000,0.000,0.018,0.067,2.864,0.003,2.602,5.352,134.868
 3139.500,0.061,0.137,77.700,10.550,7.287,9.766,0.000,0.011,0.023,0.014,4.713,6.390,0.002,0.001,0.025,0.067,2.729,0.005,2.606,6.485,134.019
 3140.000,0.067,0.126,77.700,10.550,7.378,10.552,0.000,0.020,0.019,0.019,4.713,6.390,0.006,0.003,0.038,0.067,2.544,0.006,2.595,9.783,133.706
 3140.500,0.068,0.124,77.700,10.550,7.377,11.573,0.000,0.026,0.018,0.018,4.713,6.390,0.029,0.003,0.044,0.067,2.535,0.005,2.594,10.976,133.511
 3141.000,0.068,0.124,77.700,10.550,7.377,12.178,0.000,0.035,0.022,0.011,4.713,6.390,0.095,0.001,0.046,0.067,2.535,0.001,2.594,11.640,133.310
 3141.500,0.068,0.124,77.700,10.550,7.375,12.624,0.000,-999.25,-999.25,-999.25,4.713,6.390,0.222,-999.25,-999.25,0.067,2.535,-999.25,2.594,8.827,130.797
 3142.000,0.068,0.124,77.700,10.550,7.374,12.856,0.000,-999.25,-999.25,-999.25,4.713,6.390,0.242,-999.25,-999.25,0.067,2.535,-999.25,2.594,6.682,128.189
 3142.500,-999.25,-999.25,77.700,10.550,7.373,12.845,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,0.148,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.065,126.466
 3143.000,-999.25,-999.25,77.700,10.550,7.372,12.781,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.781,126.466
 3143.500,-999.25,-999.25,77.700,10.550,7.368,12.728,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.722,126.466
 3144.000,-999.25,-999.25,77.700,10.550,7.363,12.725,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.680,126.466
 3144.500,-999.25,-999.25,77.700,10.550,7.358,12.728,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.537,126.466
 3145.000,-999.25,-999.25,77.700,10.550,7.354,12.729,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.410,126.466
 3145.500,-999.25,-999.25,77.700,10.550,7.352,12.729,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.392,126.466
 3146.000,-999.25,-999.25,77.700,10.550,7.351,12.728,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.607,126.466
 3146.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.187,126.466
 3147.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.450,126.466
 3147.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.642,126.466
 3148.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.895,126.466
 3148.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.383,126.466
 3149.000,-999.25,-999.25,77.700,10.550,7.350,12.727,7.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,8.198,126.466
 3149.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.736,126.466
 3150.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.856,126.466
 3150.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.049,126.466
 3151.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.056,126.466
 3151.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.259,126.466
 3152.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,7.134,126.466
 3152.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,6.747,126.466
 3153.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.537,126.466
 3153.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.055,126.466
 3154.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.210,126.466
 3154.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.384,126.466
 3155.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.399,126.466
 3155.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.400,126.466
 3156.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.402,126.466
 3156.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.404,126.466
 3157.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.406,126.466
 3157.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3158.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3158.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3159.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3159.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3160.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3160.500,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466
 3161.000,-999.25,-999.25,77.700,10.550,7.350,12.727,0.000,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,-999.25,5.407,126.466

