/*
 * Decompiled with CFR 0.152.
 */
package zeke.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import plot.plotSymbolStruct;
import plot.plotXYStruct;

public class zekeRelIncrPlotXY
extends Canvas {
    private plotXYStruct stPlot = null;
    private int iXBegin = 80;
    private int iYBegin = 60;
    private int iWidth = 300;
    private int iHeight = 300;
    private int iRows = 0;
    private int[] iX;
    private int[] iY;
    private plotSymbolStruct[] stSymbol;
    private int iLegend = 0;
    private plotSymbolStruct[] stLegend;
    private double dClusters = 0.0;
    private double dRsqrd = 0.0;
    private double dXMinimum = 0.0;
    private double dXMaximum = 0.0;
    private double dYMinimum = 0.0;
    private double dYMaximum = 0.0;
    private double dYIncrement = 0.0;
    private String sTitle = "Relative Increase Plot";
    private String sYAxis = "Relative Increase (%)";

    public zekeRelIncrPlotXY(plotXYStruct plotXYStruct2) {
        this.setBackground(Color.white);
        this.stPlot = plotXYStruct2;
        if (plotXYStruct2.iWidth != 0) {
            this.iWidth = plotXYStruct2.iWidth;
        }
        if (plotXYStruct2.iHeight != 0) {
            this.iHeight = plotXYStruct2.iHeight;
        }
        this.iRows = plotXYStruct2.iRows;
        if (plotXYStruct2.stSymbols != null) {
            this.stSymbol = plotXYStruct2.stSymbols;
        }
        this.iLegend = plotXYStruct2.iLegend;
        if (plotXYStruct2.stLegend != null) {
            this.stLegend = plotXYStruct2.stLegend;
        }
        this.convertDataToPixels();
    }

    public void close() {
        this.stPlot = null;
        this.iX = null;
        this.iY = null;
        this.stSymbol = null;
        this.stLegend = null;
    }

    public void setData(plotXYStruct plotXYStruct2) {
        this.stPlot = plotXYStruct2;
        if (plotXYStruct2.iWidth != 0) {
            this.iWidth = plotXYStruct2.iWidth;
        }
        if (plotXYStruct2.iHeight != 0) {
            this.iHeight = plotXYStruct2.iHeight;
        }
        this.iRows = plotXYStruct2.iRows;
        if (plotXYStruct2.stSymbols != null) {
            this.stSymbol = plotXYStruct2.stSymbols;
        }
        this.iLegend = plotXYStruct2.iLegend;
        if (plotXYStruct2.stLegend != null) {
            this.stLegend = plotXYStruct2.stLegend;
        }
        this.convertDataToPixels();
        this.repaint();
    }

    public void setLegend(int n, plotSymbolStruct[] plotSymbolStructArray) {
        this.iLegend = n;
        this.stLegend = plotSymbolStructArray;
    }

    public void setLegendFlag(int n) {
        this.iLegend = n;
        this.repaint();
    }

    public void setTitle1(String string) {
        this.stPlot.sTitle2 = new String(string);
        this.repaint();
    }

    public void setTitle2(String string) {
        this.stPlot.sTitle3 = new String(string);
        this.repaint();
    }

    public void setXAxis(String string, int n, double d, double d2, double d3, int n2) {
        this.stPlot.sXAxis = new String(string);
        this.stPlot.iXLog = n;
        this.stPlot.dXMaximum = d;
        this.stPlot.dXMinimum = d2;
        this.stPlot.dXIncrement = d3;
        this.stPlot.iXCycles = n2;
        this.convertDataToPixels();
        this.repaint();
    }

    public void setYAxis(String string, int n, double d, double d2, double d3, int n2) {
        this.stPlot.sYAxis = new String(string);
        this.stPlot.iYLog = n;
        this.stPlot.dYMaximum = d;
        this.stPlot.dYMinimum = d2;
        this.stPlot.dYIncrement = d3;
        this.stPlot.iYCycles = n2;
        this.convertDataToPixels();
        this.repaint();
    }

    public void setValues(double d, double d2) {
        this.dClusters = d;
        this.dRsqrd = d2;
        this.repaint();
    }

    public void setXYMinMax(double d, double d2, double d3, double d4) {
        this.dXMinimum = d;
        this.dXMaximum = d2;
        this.dYMinimum = d3;
        this.dYMaximum = d4;
        this.repaint();
    }

    public int getPlotWidth() {
        return 425;
    }

    public int getPlotHeight() {
        return 450;
    }

    public void delete() {
        this.stPlot.delete();
        this.stPlot = null;
        this.iX = null;
        this.iY = null;
        this.stSymbol = null;
        this.stLegend = null;
    }

    private void convertDataToPixels() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        this.iRows = this.stPlot.iRows;
        this.iX = new int[this.iRows];
        this.iY = new int[this.iRows];
        if (this.stPlot.iXLog == 0) {
            for (n = 0; n < this.iRows; ++n) {
                n3 = (int)((double)this.iWidth * (this.stPlot.dX[n] - this.stPlot.dXMinimum) / (this.stPlot.dXMaximum - this.stPlot.dXMinimum));
                this.iX[n] = this.iXBegin + n3;
            }
        } else {
            d = Math.log(this.stPlot.dXMinimum) / Math.log(10.0);
            d2 = Math.log(this.stPlot.dXMaximum) / Math.log(10.0);
            for (n = 0; n < this.iRows; ++n) {
                n3 = (int)((double)this.iWidth * (Math.log(this.stPlot.dX[n]) / Math.log(10.0) - d) / (d2 - d));
                this.iX[n] = this.iXBegin + n3;
            }
        }
        if (this.stPlot.iYLog == 0) {
            for (n = 0; n < this.iRows; ++n) {
                n2 = n + 1;
                d7 = this.stPlot.dY[n];
                d6 = n2 < this.iRows ? this.stPlot.dY[n2] : 100.0;
                d5 = 100.0 * (d6 - d7) / d7;
                n3 = (int)((double)this.iHeight * (d5 - this.stPlot.dYMinimum) / (this.stPlot.dYMaximum - this.stPlot.dYMinimum));
                this.iY[n] = this.iHeight + this.iYBegin - n3;
            }
        } else {
            d3 = Math.log(this.stPlot.dYMinimum) / Math.log(10.0);
            d4 = Math.log(this.stPlot.dYMaximum) / Math.log(10.0);
            for (n = 0; n < this.iRows; ++n) {
                n3 = (int)((double)this.iHeight * (Math.log(this.stPlot.dY[n]) / Math.log(10.0) - d3) / (d4 - d3));
                this.iY[n] = this.iHeight + this.iYBegin - n3;
            }
        }
    }

    public void drawTitles(Graphics graphics) {
        int n = 0;
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Monospaced", 1, 14));
        if (this.sTitle != null) {
            n = Math.abs(this.iWidth - 6 * this.sTitle.length());
            graphics.drawString(this.sTitle, n / 2, 10);
        }
        if (this.stPlot.sTitle2 != null) {
            n = Math.abs(this.iWidth - 6 * this.stPlot.sTitle2.length());
            graphics.drawString(this.stPlot.sTitle2, n / 2, 30);
        }
        if (this.stPlot.sTitle3 != null) {
            n = Math.abs(this.iWidth - 6 * this.stPlot.sTitle3.length());
            graphics.drawString(this.stPlot.sTitle3, n / 2, 50);
        }
    }

    public void drawLabels(Graphics graphics) {
        int n;
        graphics.setColor(Color.black);
        if (this.stPlot.sXAxis != null) {
            n = (this.iWidth + 100) / 2 - 3 * this.stPlot.sXAxis.length();
            graphics.drawString(this.stPlot.sXAxis, n, this.iYBegin + this.iHeight + 35);
        }
        if (this.sYAxis != null) {
            n = (this.iHeight + 100) / 2 - 3 * this.sYAxis.length();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.rotate(1.5707963267948966);
            graphics2D.drawString(this.sYAxis, n, -10);
            graphics2D.rotate(-1.5707963267948966);
        }
    }

    public void drawGrid(Graphics graphics) {
        this.drawLinearXAxisGrid(graphics);
        this.drawLinearYAxisGrid(graphics);
    }

    public void drawLinearXAxisGrid(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        n6 = (int)((double)this.iWidth * this.stPlot.dXIncrement / (this.stPlot.dXMaximum - this.stPlot.dXMinimum));
        n3 = this.iXBegin;
        while (n3 < this.iXBegin + this.iWidth + 5) {
            d = this.stPlot.dXMinimum + (double)n * this.stPlot.dXIncrement;
            n5 = (int)((double)this.iWidth * (d - this.stPlot.dXMinimum) / (this.stPlot.dXMaximum - this.stPlot.dXMinimum));
            n3 = this.iXBegin + n5;
            if (n3 < this.iXBegin + this.iWidth + 5) {
                graphics.setColor(Color.darkGray);
                graphics.drawLine(n3, this.iYBegin, n3, this.iYBegin + this.iHeight);
                graphics.setColor(Color.black);
                graphics.setFont(new Font("Monospaced", 1, 10));
                d = (double)Math.round(d * 1000.0) / 1000.0;
                graphics.drawString("" + d, n3, this.iYBegin + this.iHeight + 15);
                for (n2 = 1; n2 < 5; ++n2) {
                    n4 = n3 + n2 * n6 / 5;
                    if (n4 >= this.iXBegin + this.iWidth) continue;
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n4, this.iYBegin, n4, this.iYBegin + this.iHeight);
                }
            }
            ++n;
        }
    }

    public void drawLinearYAxisGrid(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        n6 = (int)((double)this.iHeight * this.stPlot.dYIncrement / (this.stPlot.dYMaximum - this.stPlot.dYMinimum));
        n3 = this.iYBegin + this.iHeight;
        while (n3 > this.iYBegin - 5) {
            d = this.dYMinimum + (double)n * this.stPlot.dYIncrement;
            n5 = (int)((double)this.iHeight * (d - this.stPlot.dYMinimum) / (this.stPlot.dYMaximum - this.stPlot.dYMinimum));
            n3 = this.iHeight + this.iYBegin - n5;
            if (n3 > this.iYBegin - 5) {
                graphics.setColor(Color.darkGray);
                graphics.drawLine(this.iXBegin, n3, this.iXBegin + this.iWidth, n3);
                graphics.setColor(Color.black);
                graphics.setFont(new Font("Monospaced", 1, 10));
                d = (double)Math.round(d * 1000.0) / 1000.0;
                graphics.drawString("" + d, this.iXBegin - 45, n3);
                for (n2 = 1; n2 < 5; ++n2) {
                    n4 = n3 - n2 * n6 / 5;
                    if (n4 <= this.iYBegin) continue;
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(this.iXBegin, n4, this.iXBegin + this.iWidth, n4);
                }
            }
            ++n;
        }
    }

    public void drawValues(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if (this.dClusters > 0.0) {
            n2 = (int)((double)this.iWidth * (this.dClusters - this.stPlot.dXMinimum) / (this.stPlot.dXMaximum - this.stPlot.dXMinimum));
            n = this.iXBegin + n2;
            graphics.setColor(Color.red);
            graphics.drawLine(n, this.iYBegin, n, this.iYBegin + this.iHeight);
        }
        if (this.dRsqrd > 0.0) {
            n2 = (int)((double)this.iHeight * (this.dRsqrd - this.stPlot.dYMinimum) / (this.stPlot.dYMaximum - this.stPlot.dYMinimum));
            n = this.iHeight + this.iYBegin - n2;
            graphics.setColor(Color.green);
            graphics.drawLine(this.iXBegin, n, this.iXBegin + this.iWidth, n);
        }
    }

    public void drawPlotData(Graphics graphics) {
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        for (int i = 0; i < this.iRows; ++i) {
            n = this.iX[i];
            n2 = this.iY[i];
            if (n < this.iXBegin || n > this.iXBegin + this.iWidth || n2 < this.iYBegin || n2 > this.iYBegin + this.iHeight || !(bl = true)) continue;
            graphics.setColor(new Color(this.stSymbol[i].iRed, this.stSymbol[i].iGreen, this.stSymbol[i].iBlue));
            graphics.fillRect(this.iX[i] - 2, this.iY[i] - 2, 4, 4);
        }
    }

    public void drawLegend(Graphics graphics) {
        for (int i = 0; i < this.iLegend; ++i) {
            graphics.setColor(new Color(this.stLegend[i].iRed, this.stLegend[i].iGreen, this.stLegend[i].iBlue));
            graphics.drawString(this.stLegend[i].symbol, this.iXBegin + this.iWidth + 10, this.iYBegin + i * 13);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 425, 450);
        this.drawTitles(graphics);
        this.drawLabels(graphics);
        this.drawGrid(graphics);
        if (this.stPlot.bLegend) {
            this.drawLegend(graphics);
        }
        this.drawPlotData(graphics);
    }
}

