/*
 * Decompiled with CFR 0.152.
 */
package zeke.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import las.lasFileDataStruct;
import lith.plot.lithPlotColorlith;
import zeke.math.zekeZoneStatStruct;
import zeke.plot.zekeLASPlotTrack;

public class zekePlot
extends Canvas {
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int[] iStart = null;
    private int[] iWide = null;
    private int iButtons = 0;
    private int[] iLog = null;
    private int[] iZone = null;
    private int nLogs = 0;
    private int[] iOrder = null;
    private boolean[] bLog = null;
    private String[] sGroup = null;
    private zekeLASPlotTrack plotLAS = null;
    private lithPlotColorlith plotColorlith = null;
    private zekeZoneStatStruct stZone = null;
    private lasFileDataStruct stLAS = null;
    private int iWidth = 650;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    public static final int PLOT_TITLES = 100;
    public static final int DEPTH_TRACK = 50;
    public static final int LABELSTART = 50;
    private String sTitle1 = "";
    private String sTitle2 = "";
    private String sTitle3 = "";
    private String sTitle4 = "";
    private String sTitle5 = "";
    private String sTitle6 = "";

    public zekePlot(double d, double d2, int n, int n2, int[] nArray, boolean[] blArray, lasFileDataStruct lasFileDataStruct2, zekeZoneStatStruct zekeZoneStatStruct2) {
        this.nLogs = n2;
        this.iOrder = nArray;
        this.bLog = blArray;
        this.stZone = zekeZoneStatStruct2;
        this.stLAS = lasFileDataStruct2;
        this.setPlotWidth();
        this.setPlotHeight(n, d2, d);
        this.plotLAS = new zekeLASPlotTrack(d, d2, n, nArray, blArray, lasFileDataStruct2, zekeZoneStatStruct2);
        this.plotColorlith = new lithPlotColorlith(0, d, d2, n);
        this.plotColorlith.setLASFileData(lasFileDataStruct2);
        this.setBackground(Color.white);
    }

    public void close() {
        this.iStart = null;
        this.iWide = null;
        this.iLog = null;
        this.iZone = null;
        this.iOrder = null;
        this.bLog = null;
        this.sGroup = null;
        this.stZone = null;
        this.stLAS = null;
        this.sTitle1 = null;
        this.sTitle2 = null;
        this.sTitle3 = null;
        this.sTitle4 = null;
        this.sTitle5 = null;
        this.sTitle6 = null;
        if (this.plotLAS != null) {
            this.plotLAS.close();
        }
        this.plotLAS = null;
        if (this.plotColorlith != null) {
            this.plotColorlith.close();
        }
        this.plotColorlith = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setPlotWidth() {
        int n = 0;
        int n2 = 100;
        int n3 = 0;
        this.iWidth = 50;
        this.iButtons = 1;
        for (n = 0; n < this.nLogs; ++n) {
            if (!this.bLog[n]) continue;
            ++this.iButtons;
        }
        this.iLog = new int[this.iButtons];
        this.iZone = new int[this.iButtons];
        this.iLog[0] = -1;
        this.iZone[0] = -1;
        n3 = 1;
        for (n = 0; n < this.nLogs; ++n) {
            if (!this.bLog[n]) continue;
            this.iLog[n3] = this.iOrder[n];
            this.iZone[n3] = n;
            ++n3;
        }
        if (this.iButtons > 0) {
            this.iStart = new int[this.iButtons];
            this.iWide = new int[this.iButtons];
            for (n = 0; n < this.iButtons; ++n) {
                this.iStart[n] = this.iWidth;
                this.iWide[n] = n2;
                this.iWidth += n2;
            }
        }
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setScale(int n, double d, double d2) {
        this.setPlotHeight(n, d, d2);
        if (this.plotLAS != null) {
            this.plotLAS.setPlotHeight(n, d, d2);
        }
        if (this.plotColorlith != null) {
            this.plotColorlith.setPlotHeight(n, d, d2);
        }
        this.repaint();
    }

    public void setTitles(String string, String string2, String string3, String string4, String string5) {
        this.sTitle1 = new String(string);
        this.sTitle2 = new String(string2);
        this.sTitle3 = new String(string3);
        this.sTitle4 = new String(string4);
        this.sTitle5 = new String(string5);
        this.repaint();
    }

    public void setGroupName(String[] stringArray) {
        this.plotLAS.setGroup(stringArray);
        this.repaint();
    }

    public void drawTitles(Graphics graphics) {
        String string = "";
        String string2 = "";
        int n = 0;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        string = this.sTitle1;
        n = 10;
        if (6 * string.length() < this.iWidth) {
            n = (this.iWidth - 6 * string.length()) / 2;
        }
        graphics.drawString(string, n, 10);
        string = this.sTitle2;
        if (this.sTitle3.length() > 0 && 6 * (string2 = string + " " + this.sTitle3).length() < this.iWidth) {
            string = new String(string + " " + this.sTitle3);
        }
        n = 10;
        if (6 * string.length() < this.iWidth) {
            n = (this.iWidth - 6 * string.length()) / 2;
        }
        graphics.drawString(string, n, 23);
        string = this.sTitle4;
        n = 10;
        if (6 * string.length() < this.iWidth) {
            n = (this.iWidth - 6 * string.length()) / 2;
        }
        graphics.drawString(string, n, 36);
        string = this.sTitle5;
        n = 10;
        if (6 * string.length() < this.iWidth) {
            n = (this.iWidth - 6 * string.length()) / 2;
        }
        graphics.drawString(string, n, 49);
    }

    public void drawDepth(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        int n5 = 0;
        int n6 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n = 0; n <= this.iLogHeight; n += this.iIncrementY) {
            int n7 = (int)(this.depthStart + (double)n * this.dIncrementDepth / (double)this.iIncrementY);
            n5 = n + 100;
            int n8 = this.iIncrementY / 5;
            for (n2 = 0; n2 < 5; ++n2) {
                n6 = n + n2 * n8 + 100;
                if (n6 < 100 || n6 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n3, n6, n3 + n4, n6);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n3, n5, n3 + n4, n5);
            graphics.drawString("" + n7, this.iStartDepthLabel, n5);
        }
        graphics.drawLine(n3, 100, n3 + n4, 100);
    }

    public void drawTrackLabels(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        String string = "";
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n = string.length();
        graphics.drawString(string, this.iWidth / 2 - n * 4, 14);
        graphics.drawLine(n2, 50, n3, 50);
        graphics.setColor(Color.black);
        graphics.drawString("Depth", this.iStartDepthLabel, 60);
    }

    public void plotTable(Graphics graphics, int n, int n2, double d, String[] stringArray, String[][] stringArray2) {
        int n3 = 0;
        int n4 = 30;
        int n5 = 100;
        int n6 = 13;
        int n7 = 0;
        int n8 = 0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (n2 > 0 && stringArray != null) {
            int n9;
            n3 = stringArray.length;
            n7 = 10;
            n8 = n;
            for (n9 = 0; n9 < n3; ++n9) {
                graphics.drawString(stringArray[n9], n7, n8);
                if (n9 == 2) {
                    n7 += n5;
                    continue;
                }
                n7 += n4;
            }
            n8 += n6;
            for (int i = 0; i < n2; ++i) {
                n7 = 10;
                for (n9 = 0; n9 < n3; ++n9) {
                    graphics.drawString(stringArray2[i][n9], n7, n8);
                    if (n9 == 2) {
                        n7 += n5;
                        continue;
                    }
                    n7 += n4;
                }
                n8 += n6;
            }
        }
    }

    public void draw(Graphics graphics) {
        int n = -1;
        boolean bl = false;
        int n2 = 50;
        boolean bl2 = false;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.drawTitles(graphics);
        this.drawTrackLabels(graphics);
        this.drawDepth(graphics);
        for (int i = 0; i < this.iButtons; ++i) {
            this.plotLAS.draw(graphics, this.iLog[i], this.iZone[i], this.iStart[i], this.iWide[i]);
        }
        if (this.stLAS != null) {
            if (this.stLAS.iGR > -1 && this.stLAS.iNPHI > -1 && this.stLAS.iRHOB > -1) {
                n = this.stLAS.iPE > -1 ? 22 : 23;
                this.plotColorlith.draw(graphics, n, this.iWidth, 25);
            }
            if (this.stLAS.iTh > -1 && this.stLAS.iU > -1 && this.stLAS.iK > -1) {
                n = 31;
                this.plotColorlith.draw(graphics, n, this.iWidth + 25, 25);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.draw(graphics);
    }
}

