/*
 * Decompiled with CFR 0.152.
 */
package zeke.plot;

import cmn.cmnString;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import las.lasFileDataStruct;
import las.lasStandardTools;
import zeke.math.zekeZoneStatStruct;

public class zekeLASPlotTrack
extends Canvas {
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int[] iOrder = null;
    private boolean[] bLog = null;
    private String[] sGroup = null;
    private lasFileDataStruct stLAS = null;
    private zekeZoneStatStruct stZone = null;
    public static final Color cRED = new Color(180, 0, 0);
    public static final Color cGREEN = new Color(0, 180, 0);
    public static final Color cBLUE = new Color(0, 0, 180);
    public static final Color cCYAN = new Color(0, 180, 180);
    public static final Color cMAGENTA = new Color(180, 0, 180);
    public static final Color cYELLOW = new Color(180, 180, 0);
    public static final Color cORANGE = new Color(204, 102, 0);
    public static final Color cBROWN = new Color(102, 102, 0);
    public static final int _RED = 3;
    public static final int _GREEN = 7;
    public static final int _BLUE = 0;
    public static final int _CYAN = 2;
    public static final int _MAGENTA = 4;
    public static final int _YELLOW = 6;
    public static final int _ORANGE = 5;
    public static final int _BROWN = 1;
    public static final Color[] COLORS = new Color[]{cBLUE, cBROWN, cCYAN, cRED, cMAGENTA, cORANGE, cYELLOW, cGREEN};
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 50;

    public zekeLASPlotTrack(double d, double d2, int n, int[] nArray, boolean[] blArray, lasFileDataStruct lasFileDataStruct2, zekeZoneStatStruct zekeZoneStatStruct2) {
        this.iOrder = nArray;
        this.bLog = blArray;
        this.stLAS = lasFileDataStruct2;
        this.stZone = zekeZoneStatStruct2;
        this.setPlotHeight(n, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.iOrder = null;
        this.bLog = null;
        this.sGroup = null;
        this.stLAS = null;
        this.stZone = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setGroup(String[] stringArray) {
        this.sGroup = stringArray;
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n3 / 4;
        int n9 = n2 + n3;
        boolean bl2 = false;
        int n10 = 0;
        int n11 = 0;
        double d3 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
        double d4 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
        if (lasStandardTools.LAS_TOOLS[n][3].equals("OHM-M") || lasStandardTools.LAS_TOOLS[n][3].equals("MD") || lasStandardTools.LAS_TOOLS[n][3].equals("LOG_RATIO")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n10 = n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n11 = n4 + n5 * n6 + 100;
                if (n11 < 100 || n11 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n2, n11, n9, n11);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n10, n9, n10);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n9, 50, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 <= n3; n4 += n8) {
                if (n4 == 0 || n4 == n3) {
                    graphics.drawLine(n4 + n2, 50, n4 + n2, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
            }
        } else {
            n8 = n3 / n7;
            graphics.drawLine(n9, 50, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 < n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0) {
                    graphics.drawLine(n4 + n2, 50, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                graphics.setColor(Color.lightGray);
                for (n5 = 1; n5 < 5; ++n5) {
                    d = (double)n5 * 2.0;
                    d2 = (double)n8 * Math.log(d) / Math.log(10.0);
                    n6 = n4 + n2 + (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 50, n9, 50);
        graphics.drawLine(n2, 100, n9, 100);
        graphics.drawLine(n2, 50, n2, 100 + this.iLogHeight);
        graphics.drawLine(n9, 50, n9, 100 + this.iLogHeight);
    }

    public void drawTrackLabels(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = false;
        int n5 = -1;
        int n6 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        int n7 = n2 + n3;
        bl = true;
        if (this.stLAS != null) {
            if (!this.stLAS.checkData(n)) {
                bl = false;
            } else {
                ++n5;
            }
        }
        if (n > -1 && bl) {
            string = new String(lasStandardTools.LAS_TOOLS[n][1]);
            n6 = string.length();
            string3 = new String(lasStandardTools.LAS_TOOLS[n][3]);
            if (string3.equals("PU") || string3.equals("USEC/FT")) {
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
                d = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
                if ((n == 8 || n == 7) && this.stLAS != null) {
                    d = this.stLAS.dPHIMax;
                }
            } else {
                d = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
                if (this.stLAS != null) {
                    if (n == 2) {
                        d = this.stLAS.dSPMin;
                        d2 = this.stLAS.dSPMax;
                    }
                    if (n == 40) {
                        d = this.stLAS.dTEMPMin;
                        d2 = this.stLAS.dTEMPMax;
                    }
                    if (n == 54) {
                        d = this.stLAS.dRXRTMin;
                        d2 = this.stLAS.dRXRTMax;
                    }
                }
            }
            if (n == 5) {
                d = this.stLAS.dRhoMin;
                d2 = this.stLAS.dRhoMax;
            }
            if (n == 37) {
                d = this.stLAS.dGRNMinP;
                d2 = this.stLAS.dGRNMaxP;
            }
            if (n == 38) {
                d = this.stLAS.dNEUTMinP;
                d2 = this.stLAS.dNEUTMaxP;
            }
            Font font = new Font("Serif", 1, 10);
            graphics.setFont(font);
            if (n5 > -1) {
                graphics.setColor(COLORS[n4]);
                graphics.drawString(string, n2 + n3 / 2 - n6 * 4, 50 + (n5 + 2) * 14);
                graphics.drawString("" + d, n2 + 1, 50 + (n5 + 2) * 14);
                string2 = new String("" + d2);
                n6 = string2.length();
                graphics.drawString("" + d2, n7 - n6 * 5, 50 + (n5 + 2) * 14);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 50, n7, 50);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawTrackCurves(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        double[] dArray = null;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n10 = n2 + n3;
        int n11 = 0;
        if (this.stLAS == null) return;
        if (n == 2) {
            d2 = this.stLAS.dSPMin;
            d3 = this.stLAS.dSPMax;
        }
        if (lasStandardTools.LAS_TOOLS[n][3].equals("OHM-M") || lasStandardTools.LAS_TOOLS[n][3].equals("MD") || lasStandardTools.LAS_TOOLS[n][3].equals("LOG_RATIO")) {
            bl2 = true;
        }
        dArray = null;
        if (n <= -1) return;
        n5 = this.stLAS.iRows - 1;
        dArray = this.stLAS.getData(n);
        if (dArray == null) return;
        for (int i = 0; i < n5 - 1; ++i) {
            if (this.stLAS == null) continue;
            d4 = this.stLAS.depths[i];
            d5 = this.stLAS.depths[i + 1];
            d6 = dArray[i];
            d7 = dArray[i + 1];
            d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
            d3 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
            string = new String(lasStandardTools.LAS_TOOLS[n][3]);
            if (n == 2) {
                d2 = this.stLAS.dSPMin;
                d3 = this.stLAS.dSPMax;
            }
            if (n == 40) {
                d2 = this.stLAS.dTEMPMin;
                d3 = this.stLAS.dTEMPMax;
            }
            if (n == 54) {
                d2 = this.stLAS.dRXRTMin;
                d3 = this.stLAS.dRXRTMax;
            }
            if (n == 8 || n == 7) {
                d3 = this.stLAS.dPHIMax;
            }
            if (n == 5) {
                d2 = this.stLAS.dRhoMin;
                d3 = this.stLAS.dRhoMax;
            }
            if (n == 37) {
                d2 = this.stLAS.dGRNMinP;
                d3 = this.stLAS.dGRNMaxP;
            }
            if (n == 38) {
                d2 = this.stLAS.dNEUTMinP;
                d3 = this.stLAS.dNEUTMaxP;
            }
            if (bl2) {
                if (d6 <= 0.0) {
                    d6 = 1.0E-5;
                }
                if (d7 <= 0.0) {
                    d7 = 1.0E-5;
                }
                d6 = Math.log(d6) / Math.log(10.0);
                d7 = Math.log(d7) / Math.log(10.0);
                d2 = Math.log(d2) / Math.log(10.0);
                d3 = Math.log(d3) / Math.log(10.0);
            }
            d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
            n8 = 100 + (int)d;
            d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
            n9 = 100 + (int)d;
            bl = false;
            if (n8 > 100 && n9 > 100 && n8 < this.iHeight && n9 < this.iHeight) {
                bl = true;
            }
            if (string.equals("PU") || string.equals("USEC/FT")) {
                d = (double)n3 * (d3 - d6) / (d3 - d2);
                n6 = n2 + (int)d;
                d = (double)n3 * (d3 - d7) / (d3 - d2);
                if (n6 < n2 && n7 < n2) {
                    while (n6 < n2) {
                        n6 += n3;
                    }
                    while (n7 < n2) {
                        n7 += n3;
                    }
                } else if (n6 >= n2 && n7 < n2) {
                    graphics.setColor(COLORS[n4]);
                    for (n7 = n2 + (int)d; n7 < n2; n7 += n3) {
                    }
                    if (bl) {
                        graphics.drawLine(n10, n8, n7, n9);
                    }
                    n7 = n2;
                } else if (n6 < n2 && n7 >= n2) {
                    graphics.setColor(COLORS[n4]);
                    while (n6 < n2) {
                        n6 += n3;
                    }
                    if (bl) {
                        graphics.drawLine(n6, n8, n10, n9);
                    }
                    n6 = n2;
                }
            } else {
                d = (double)n3 * (d6 - d2) / (d3 - d2);
                n6 = n2 + (int)d;
                d = (double)n3 * (d7 - d2) / (d3 - d2);
                n11 = 0;
                if (n6 > n10 && n7 > n10) {
                    while (n6 > n10) {
                        n6 -= n3;
                    }
                    while (n7 > n10) {
                        n7 -= n3;
                    }
                } else if (n6 <= n10 && n7 > n10) {
                    graphics.setColor(COLORS[n4]);
                    for (n7 = n2 + (int)d; n7 > n10; n7 -= n3) {
                    }
                    if (bl) {
                        graphics.drawLine(n2, n8, n7, n9);
                    }
                    n7 = n10;
                } else if (n6 > n10 && n7 <= n10) {
                    graphics.setColor(COLORS[n4]);
                    while (n6 > n10) {
                        n6 -= n3;
                    }
                    if (bl) {
                        graphics.drawLine(n6, n8, n2, n9);
                    }
                    n6 = n10;
                }
                if (n6 < n2 && n7 < n2) {
                    while (n6 < n2) {
                        n6 += n3;
                    }
                    while (n7 < n2) {
                        n7 += n3;
                    }
                    n11 = 2;
                } else if (n6 >= n2 && n7 < n2) {
                    graphics.setColor(COLORS[n4]);
                    while (n7 < n2) {
                        n7 += n3;
                    }
                    if (bl) {
                        graphics.drawLine(n10, n8, n7, n9);
                    }
                    n7 = n2;
                    n11 = 1;
                } else if (n6 < n2 && n7 >= n2) {
                    graphics.setColor(COLORS[n4]);
                    while (n6 < n2) {
                        n6 += n3;
                    }
                    if (bl) {
                        graphics.drawLine(n6, n8, n10, n9);
                    }
                    n6 = n2;
                    n11 = 1;
                }
            }
            if (n6 < n2 || n7 < n2 || n6 > n10 || n7 > n10) continue;
            graphics.setColor(COLORS[n4]);
            if (!bl) continue;
            graphics.drawLine(n6, n8, n7, n9);
            if (n11 != 2) continue;
            graphics.setColor(new Color(213, 237, 255));
            graphics.drawLine(n6, n8, n10, n9);
        }
    }

    public void drawMean(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 7;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl3 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        Object var22_19 = null;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n11 = n3 + n4;
        int n12 = 0;
        String string2 = "";
        if (this.stLAS != null && this.stZone != null) {
            if (n == 2) {
                d2 = this.stLAS.dSPMin;
                d3 = this.stLAS.dSPMax;
            }
            if (lasStandardTools.LAS_TOOLS[n][3].equals("OHM-M") || lasStandardTools.LAS_TOOLS[n][3].equals("MD") || lasStandardTools.LAS_TOOLS[n][3].equals("LOG_RATIO")) {
                bl3 = true;
            }
            n12 = this.stZone.minDepth.length;
            for (int i = 0; i < n12; ++i) {
                d4 = this.stZone.minDepth[i];
                d5 = this.stZone.maxDepth[i];
                d6 = this.stZone.logMeans[n2][i];
                d7 = 0.0;
                d8 = 0.0;
                string2 = new String("" + this.stZone.logStdvs[n2][i]);
                if (!string2.equals("NaN")) {
                    d7 = this.stZone.logMeans[n2][i] - this.stZone.logStdvs[n2][i];
                    d8 = this.stZone.logMeans[n2][i] + this.stZone.logStdvs[n2][i];
                }
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
                d3 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
                string = new String(lasStandardTools.LAS_TOOLS[n][3]);
                if (n == 2) {
                    d2 = this.stLAS.dSPMin;
                    d3 = this.stLAS.dSPMax;
                }
                if (n == 8 || n == 7) {
                    d3 = this.stLAS.dPHIMax;
                }
                if (n == 5) {
                    d2 = this.stLAS.dRhoMin;
                    d3 = this.stLAS.dRhoMax;
                }
                if (bl3) {
                    if (d6 <= 0.0) {
                        d6 = 1.0E-5;
                    }
                    d6 = Math.log(d6) / Math.log(10.0);
                    d7 = Math.log(d7) / Math.log(10.0);
                    d8 = Math.log(d8) / Math.log(10.0);
                    d2 = Math.log(d2) / Math.log(10.0);
                    d3 = Math.log(d3) / Math.log(10.0);
                }
                d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                n9 = 100 + (int)d;
                d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                n10 = 100 + (int)d;
                bl2 = false;
                if (n9 >= 100 && n10 >= 100 && n9 <= this.iHeight && n10 <= this.iHeight) {
                    bl2 = true;
                }
                if (string.equals("PU") || string.equals("USEC/FT")) {
                    d = (double)n4 * (d3 - d6) / (d3 - d2);
                    n6 = n3 + (int)d;
                    d = (double)n4 * (d3 - d7) / (d3 - d2);
                    n8 = n3 + (int)d;
                    d = (double)n4 * (d3 - d8) / (d3 - d2);
                    n7 = n3 + (int)d;
                } else {
                    d = (double)n4 * (d6 - d2) / (d3 - d2);
                    n6 = n3 + (int)d;
                    d = (double)n4 * (d7 - d2) / (d3 - d2);
                    n7 = n3 + (int)d;
                    d = (double)n4 * (d8 - d2) / (d3 - d2);
                    n8 = n3 + (int)d;
                }
                if (n6 < n3 || n6 > n11) continue;
                graphics.setColor(Color.yellow);
                if (bl2) {
                    graphics.fillRect(n7, n9, n8 - n7, n10 - n9);
                }
                graphics.setColor(COLORS[n5]);
                if (!bl2) continue;
                graphics.drawLine(n6, n9, n6, n10);
            }
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = n2 / 4;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        String string = "Groups";
        int n10 = 0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n10 = string.length();
        graphics.drawString(string, n + n2 / 2 - 9 * n10 / 4, 64);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n7, 50, n7, 100 + this.iLogHeight);
            for (n3 = 0; n3 <= n2; n3 += n6) {
                if (n3 == 0 || n3 == n2) {
                    graphics.drawLine(n3 + n, 50, n3 + n, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 50, n7, 50);
        graphics.drawLine(n, 100, n7, 100);
        graphics.drawLine(n, 50, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 50, n7, 100 + this.iLogHeight);
    }

    public void drawFlowUnits(Graphics graphics, int n, int n2, int n3) {
        int n4 = 3;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n7 = n2 + n3;
        String string = "";
        int n8 = 0;
        int n9 = 0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stZone != null && this.sGroup != null) {
            n9 = this.sGroup.length;
            for (int i = 0; i < n9; ++i) {
                d2 = this.stZone.minDepth[i];
                d3 = this.stZone.maxDepth[i];
                d = (double)this.iLogHeight * (d2 - this.depthStart) / (this.depthEnd - this.depthStart);
                n5 = 100 + (int)d;
                d = (double)this.iLogHeight * (d3 - this.depthStart) / (this.depthEnd - this.depthStart);
                n6 = 100 + (int)d;
                if (n5 < 100 || n6 < 100 || n5 > this.iHeight || n6 > this.iHeight) continue;
                graphics.setColor(COLORS[n4]);
                graphics.drawLine(n2, n5, n7, n5);
                if (i == n9 - 1) {
                    graphics.drawLine(n2, n6, n7, n6);
                }
                n8 = i + 1;
                if (n == -1) {
                    graphics.drawString("(" + n8 + ")", n2 - 15, n5 + 10);
                }
                if (n != -1 || this.sGroup == null || this.sGroup[i] == null) continue;
                graphics.setColor(Color.black);
                string = "  " + this.sGroup[i];
                n8 = string.length();
                graphics.drawString(string, n2 + (n3 - 6 * n8) / 2, n5 + 10);
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n != -1) {
            this.drawMean(graphics, n, n2, n3, n4);
            this.drawGrid(graphics, n, n3, n4);
            this.drawTrackLabels(graphics, n, n3, n4);
            this.drawTrackCurves(graphics, n, n3, n4);
            this.drawFlowUnits(graphics, n, n3, n4);
        } else {
            this.drawGrid(graphics, n3, n4);
            this.drawFlowUnits(graphics, n, n3, n4);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

