/*
 * Decompiled with CFR 0.152.
 */
package zeke.gui;

import cmn.cmnString;
import gui.guiSearchDirectoryFrame;
import iqstrat.io.iqstratIO_Files;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kgs.io.kgsIOUser;
import las.lasFileDataStruct;
import las.lasStandardTools;
import plot.plotSymbol;
import plot.plotSymbolStruct;
import plot.plotXYStruct;
import zeke.gui.zekeBlockResultsFrame;
import zeke.gui.zekeRelIncrPlotXYFrame;
import zeke.gui.zekeScreePlotXYFrame;
import zeke.gui.zekeZonationFrameFocusAdapter;
import zeke.gui.zekeZonationFrameObservable;
import zeke.math.zekeCluster;
import zeke.math.zekeClusterStruct;
import zeke.math.zekeZoneStatStruct;
import zeke.plot.zekePlotBuffered;

public class zekeZonationFrame
extends JFrame
implements ActionListener,
Observer {
    public static final int _ZONATION = 0;
    public static final int _PFEFFER = 1;
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private iqstratHeadersStruct stHeader = null;
    private lasFileDataStruct stLAS = null;
    private int iAPP = 0;
    private Observable notifier = null;
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private int iScale = 6;
    private static final int _NUMBER = 0;
    private static final int _RSQUARED = 1;
    private int iStop = 0;
    private double dRsqrd = 25.0;
    private int nData = 0;
    private int nLogs = 0;
    private int[] iOrder = null;
    private boolean[] bLog = null;
    private int nLevels = 0;
    private int NSave = 50;
    private int NBlock = 7;
    private double[] depth = null;
    private double[][] dLogMat = null;
    private String[] sColumns = null;
    private String[][] sOMTable = null;
    private zekeClusterStruct ClusterRes = null;
    private zekeZoneStatStruct ZoneStats = null;
    private int iOGroups = 7;
    private double dORsq = 25.0;
    private zekeBlockResultsFrame pBlock = null;
    private guiSearchDirectoryFrame pSearch = null;
    private zekeRelIncrPlotXYFrame plotRelXY = null;
    private zekeScreePlotXYFrame plotXY = null;
    private plotXYStruct stPlotXY = null;
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private JRadioButton rbGroups = new JRadioButton();
    private JRadioButton rbRsqrd = new JRadioButton();
    private JTextField txtGroups = new JTextField();
    private JTextField txtRsqrd = new JTextField();
    private JButton btnCompute = new JButton();
    private JButton btnScree = new JButton();
    private int[] iSelected = null;
    private JCheckBox[] cb = null;
    private JMenuItem mExit = null;

    public zekeZonationFrame(Observable observable, iqstratStruct iqstratStruct2, iqstratHeadersStruct iqstratHeadersStruct2, lasFileDataStruct lasFileDataStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stHeader = iqstratHeadersStruct2;
            this.stLAS = lasFileDataStruct2;
            if (lasFileDataStruct2 != null) {
                this.dStart = lasFileDataStruct2.depthStart;
                this.dEnd = lasFileDataStruct2.depthEnd;
                double d = this.dEnd - this.dStart;
                this.iScale = d < 10.0 ? 0 : (d < 20.0 ? 1 : (d < 50.0 ? 2 : (d < 100.0 ? 3 : (d < 200.0 ? 4 : (d < 500.0 ? 5 : 6)))));
            }
            this.jbInit();
            this.addWindowListener(new zekeZonationFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public zekeZonationFrame(Observable observable, iqstratStruct iqstratStruct2, iqstratHeadersStruct iqstratHeadersStruct2, lasFileDataStruct lasFileDataStruct2, int n) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stHeader = iqstratHeadersStruct2;
            this.stLAS = lasFileDataStruct2;
            this.iAPP = n;
            if (lasFileDataStruct2 != null) {
                this.dStart = lasFileDataStruct2.depthStart;
                this.dEnd = lasFileDataStruct2.depthEnd;
                double d = this.dEnd - this.dStart;
                this.iScale = d < 10.0 ? 0 : (d < 20.0 ? 1 : (d < 50.0 ? 2 : (d < 100.0 ? 3 : (d < 200.0 ? 4 : (d < 500.0 ? 5 : 6)))));
            }
            this.jbInit();
            this.addWindowListener(new zekeZonationFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Zonation Data Panal");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Starting Depth");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Ending Depth");
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Stop Clustering when");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        this.mExit = new JMenuItem("Exit");
        this.mExit.addActionListener(this);
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.mExit);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.notifier = new zekeZonationFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("Zonation By Depth-Constrained Cluster Analysis");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(titledBorder);
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel5.setBorder(titledBorder2);
        jPanel5.setLayout(new BorderLayout());
        this.txtStart.setText("" + this.dStart);
        this.txtStart.setColumns(11);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new zekeZonationFrameFocusAdapter(this));
        jPanel6.setBorder(titledBorder3);
        jPanel6.setLayout(new BorderLayout());
        this.txtEnd.setText("" + this.dEnd);
        this.txtEnd.setColumns(11);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new zekeZonationFrameFocusAdapter(this));
        jPanel7.setBorder(titledBorder4);
        jPanel7.setLayout(new GridLayout(2, 1));
        jPanel8.setLayout(new BorderLayout());
        this.rbGroups.setFont(new Font("Monospaced", 1, 11));
        this.rbGroups.setPreferredSize(new Dimension(215, 25));
        this.rbGroups.setHorizontalAlignment(2);
        this.rbGroups.setSelected(true);
        this.rbGroups.setText("Number of groups equals   ");
        this.rbGroups.addActionListener(this);
        this.txtGroups.setText("" + this.NBlock);
        this.txtGroups.setColumns(6);
        this.txtGroups.setHorizontalAlignment(11);
        this.txtGroups.addFocusListener(new zekeZonationFrameFocusAdapter(this));
        jPanel11.setLayout(new BorderLayout());
        this.rbRsqrd.setFont(new Font("Monospaced", 1, 11));
        this.rbRsqrd.setText("R-squared equals or exceeds");
        this.rbRsqrd.addActionListener(this);
        this.txtRsqrd.setText("" + this.dRsqrd);
        this.txtRsqrd.setColumns(6);
        this.txtRsqrd.setHorizontalAlignment(11);
        this.txtRsqrd.addFocusListener(new zekeZonationFrameFocusAdapter(this));
        jPanel13.setLayout(new BorderLayout());
        jLabel.setText("%");
        jPanel15 = this.curvesPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        this.btnScree.setFont(new Font("Dialog", 1, 11));
        this.btnScree.setText("Scree");
        this.btnScree.addActionListener(this);
        this.btnCompute.setFont(new Font("Dialog", 1, 11));
        this.btnCompute.setText("Compute");
        this.btnCompute.addActionListener(this);
        jLabel3.setText("");
        jLabel2.setText("");
        this.setButtons();
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)jPanel15, null);
        jPanel.add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel4, "West");
        jPanel4.add((Component)jPanel5, null);
        jPanel5.add((Component)this.txtStart, "Center");
        jPanel4.add((Component)jPanel6, null);
        jPanel6.add((Component)this.txtEnd, "Center");
        jPanel3.add((Component)jPanel7, "Center");
        jPanel7.add((Component)jPanel8, null);
        jPanel8.add((Component)this.rbGroups, "West");
        jPanel8.add((Component)jPanel9, "Center");
        jPanel9.add((Component)this.txtGroups, null);
        jPanel8.add((Component)jPanel10, "East");
        jPanel7.add((Component)jPanel11, null);
        jPanel11.add((Component)this.rbRsqrd, "West");
        jPanel11.add((Component)jPanel12, "Center");
        jPanel12.add((Component)this.txtRsqrd, null);
        jPanel11.add((Component)jPanel13, "East");
        jPanel13.add((Component)jLabel, "West");
        buttonGroup.add(this.rbGroups);
        buttonGroup.add(this.rbRsqrd);
        jPanel3.add((Component)jPanel2, "East");
        jPanel2.add((Component)this.btnScree, null);
        jPanel2.add((Component)jLabel2, null);
        jPanel2.add((Component)this.btnCompute, null);
        this.getContentPane().add((Component)jPanel14, "South");
        this.setSize(new Dimension(575, 650));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 4, (dimension.height - this.getSize().height) / 2);
        this.setResizable(true);
        this.setVisible(true);
    }

    private JPanel curvesPanel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "0";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        double[] dArray = new double[]{this.dStart, this.dEnd};
        JPanel jPanel = new JPanel();
        JPanel[] jPanelArray = null;
        JPanel[] jPanelArray2 = null;
        JPanel[] jPanelArray3 = null;
        JPanel[] jPanelArray4 = null;
        JLabel[] jLabelArray = null;
        JLabel[] jLabelArray2 = null;
        JLabel[] jLabelArray3 = null;
        JLabel[] jLabelArray4 = null;
        JLabel jLabel = new JLabel();
        this.nLogs = 0;
        for (n = 0; n < 78; ++n) {
            if (!this.stLAS.checkData(n)) continue;
            ++this.nLogs;
        }
        if (this.nLogs > 1) {
            if (this.nLogs > 11) {
                jPanel.setLayout(new GridLayout(this.nLogs + 1, 1));
                jPanel.setPreferredSize(new Dimension(240, 20 * (this.nLogs + 1)));
            } else {
                jPanel.setLayout(new GridLayout(12, 1));
                jPanel.setPreferredSize(new Dimension(240, 220));
            }
            jPanelArray = new JPanel[this.nLogs + 1];
            jPanelArray2 = new JPanel[this.nLogs];
            jPanelArray4 = new JPanel[this.nLogs];
            jPanelArray3 = new JPanel[this.nLogs];
            this.cb = new JCheckBox[this.nLogs];
            jLabelArray = new JLabel[this.nLogs];
            jLabelArray2 = new JLabel[this.nLogs];
            jLabelArray3 = new JLabel[this.nLogs];
            jLabelArray4 = new JLabel[this.nLogs];
            this.bLog = new boolean[this.nLogs];
            this.iOrder = new int[this.nLogs];
            for (n = 0; n < 78; ++n) {
                bl = false;
                if (this.stLAS.checkData(n) && n2 < this.nLogs) {
                    this.bLog[n2] = false;
                    this.iOrder[n2] = n;
                    string = lasStandardTools.LAS_TOOLS[n][0];
                    string2 = lasStandardTools.LAS_TOOLS[n][1];
                    string3 = lasStandardTools.LAS_TOOLS[n][3];
                    string4 = lasStandardTools.LAS_TOOLS[n][2];
                    dArray = this.getDepthRange(n);
                    string5 = new String("" + dArray[0] + " - " + dArray[1]);
                    bl = true;
                }
                if (!bl || n2 >= this.nLogs) continue;
                if (!bl2 && n >= 51) {
                    bl2 = true;
                    jPanelArray[n3] = new JPanel();
                    jPanelArray[n3].setLayout(new BorderLayout());
                    jLabel.setText("Computed Curves");
                    jLabel.setFont(new Font("Dialog", 1, 11));
                    jPanel.add((Component)jPanelArray[n3], null);
                    jPanelArray[n3].add((Component)jLabel, "Center");
                    ++n3;
                }
                jPanelArray[n3] = new JPanel();
                jPanelArray[n3].setLayout(new BorderLayout());
                this.cb[n2] = new JCheckBox();
                this.cb[n2].setText("");
                this.cb[n2].addActionListener(this);
                jPanelArray2[n2] = new JPanel();
                jPanelArray2[n2].setLayout(new BorderLayout());
                jPanelArray4[n2] = new JPanel();
                jPanelArray4[n2].setPreferredSize(new Dimension(90, 35));
                jLabelArray[n2] = new JLabel();
                jLabelArray[n2].setFont(new Font("Dialog", 0, 11));
                jLabelArray[n2].setText(string2);
                jPanelArray3[n2] = new JPanel();
                jPanelArray3[n2].setLayout(new BorderLayout());
                jLabelArray2[n2] = new JLabel();
                jLabelArray2[n2].setFont(new Font("Dialog", 0, 11));
                jLabelArray2[n2].setText("." + string3);
                jLabelArray3[n2] = new JLabel();
                jLabelArray3[n2].setFont(new Font("Dialog", 0, 11));
                jLabelArray3[n2].setHorizontalAlignment(10);
                jLabelArray3[n2].setText(" : " + string4);
                jLabelArray4[n2] = new JLabel();
                jLabelArray4[n2].setFont(new Font("Dialog", 0, 11));
                jLabelArray4[n2].setHorizontalAlignment(10);
                jLabelArray4[n2].setText(" : " + string5);
                jPanel.add((Component)jPanelArray[n3], null);
                jPanelArray[n3].add((Component)this.cb[n2], "West");
                jPanelArray[n3].add((Component)jPanelArray2[n2], "Center");
                jPanelArray2[n2].add((Component)jPanelArray4[n2], "West");
                jPanelArray4[n2].add((Component)jLabelArray[n2], null);
                jPanelArray2[n2].add((Component)jPanelArray3[n2], "Center");
                jPanelArray3[n2].add((Component)jLabelArray2[n2], "West");
                jPanelArray3[n2].add((Component)jLabelArray3[n2], "Center");
                jPanelArray3[n2].add((Component)jLabelArray4[n2], "East");
                ++n2;
                ++n3;
                string = "0";
                string2 = "";
                string3 = "";
                string4 = "";
                string5 = "";
            }
            this.nLogs = n2;
        }
        return jPanel;
    }

    private double[] getDepthRange(int n) {
        double[] dArray = new double[]{this.dStart, this.dEnd};
        double[] dArray2 = null;
        boolean bl = false;
        if (this.stLAS.checkData(n)) {
            dArray2 = this.stLAS.getData(n);
            for (int i = 0; i < this.stLAS.iRows; ++i) {
                if (dArray2[i] != this.stLAS.dNull && !bl) {
                    dArray[0] = this.stLAS.depths[i];
                    dArray[1] = this.stLAS.depths[i];
                    bl = true;
                }
                if (dArray2[i] == this.stLAS.dNull) continue;
                dArray[1] = this.stLAS.depths[i];
            }
        }
        return dArray;
    }

    public String[][] getData() {
        return this.sOMTable;
    }

    private void setButtons() {
        this.btnCompute.setEnabled(false);
        this.btnScree.setEnabled(false);
        if (this.nLogs > 0 && this.dEnd > this.dStart) {
            for (int i = 0; i < this.nLogs; ++i) {
                if (this.cb[i] == null || !this.cb[i].isSelected()) continue;
                this.btnCompute.setEnabled(true);
                this.btnScree.setEnabled(true);
            }
        }
    }

    private void doCompute() {
        this.checkData();
        this.loadData();
        this.Cluster();
        this.Block();
        this.setButtons();
    }

    private void Compute() {
        this.doCompute();
        if (this.plotXY != null) {
            this.PlotScree();
        }
        if (this.plotRelXY != null) {
            this.PlotRelativeIncrease();
        }
        this.ShowClusterAnalysis();
    }

    private void checkData() {
        double[] dArray = null;
        for (int i = 0; i < this.nLogs; ++i) {
            if (!this.stLAS.checkData(this.iOrder[i])) continue;
            dArray = this.stLAS.getData(this.iOrder[i]);
            for (int j = 0; j < this.stLAS.iRows; ++j) {
                if (!(this.stLAS.depths[j] >= this.dStart) || !(this.stLAS.depths[j] <= this.dEnd) || this.cb[i] == null || !this.cb[i].isSelected() || dArray[j] != this.stLAS.dNull) continue;
                this.bLog[i] = false;
                this.cb[i].setSelected(false);
            }
        }
    }

    private void loadData() {
        int n = 0;
        double[] dArray = null;
        if (this.depth != null) {
            this.depth = null;
        }
        if (this.dLogMat != null) {
            this.dLogMat = null;
        }
        this.nData = 0;
        if (this.stLAS != null) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.stLAS.iRows; ++n3) {
                if (!(this.stLAS.depths[n3] >= this.dStart) || !(this.stLAS.depths[n3] <= this.dEnd)) continue;
                ++this.nData;
            }
            this.NSave = 50;
            if (this.NBlock > this.NSave) {
                this.NSave = this.NBlock;
            }
            if (this.nData < this.NSave) {
                this.NSave = this.nData;
            }
            this.depth = new double[this.nData];
            this.dLogMat = new double[this.nLogs][this.nData];
            for (n3 = 0; n3 < this.nData; ++n3) {
                for (n2 = 0; n2 < this.nLogs; ++n2) {
                    this.dLogMat[n2][n3] = this.stLAS.dNull;
                }
            }
            n = 0;
            for (n2 = 0; n2 < this.stLAS.iRows; ++n2) {
                if (!(this.stLAS.depths[n2] >= this.dStart) || !(this.stLAS.depths[n2] <= this.dEnd) || n >= this.nData) continue;
                this.depth[n] = this.stLAS.depths[n2];
                ++n;
            }
            for (n3 = 0; n3 < this.nLogs; ++n3) {
                dArray = this.stLAS.getData(this.iOrder[n3]);
                if (dArray == null) continue;
                n = 0;
                for (n2 = 0; n2 < this.stLAS.iRows; ++n2) {
                    if (!(this.stLAS.depths[n2] >= this.dStart) || !(this.stLAS.depths[n2] <= this.dEnd) || n >= this.nData) continue;
                    this.dLogMat[n3][n] = dArray[n2];
                    ++n;
                }
            }
        }
    }

    private void Cluster() {
        int n = 0;
        double d = -999.25;
        if (this.stLAS != null) {
            d = this.stLAS.dNull;
        }
        int n2 = 0;
        for (n = 0; n < this.nLogs; ++n) {
            if (!this.bLog[n]) continue;
            ++n2;
        }
        double[][] dArray = new double[n2][this.nData];
        int n3 = 0;
        for (n = 0; n < this.nLogs; ++n) {
            if (!this.bLog[n]) continue;
            dArray[n3] = this.dLogMat[n];
            ++n3;
        }
        if (n3 > 0) {
            this.ClusterRes = zekeCluster.zekeHDCCA(dArray, this.NSave, d);
            this.nLevels = this.ClusterRes.nclus.length;
            dArray = null;
        } else {
            String string = "All Curves Selected have a Null value present within the \ndepth range selected. Please increase the Starting \nDepth or decrease the Ending Depth to clip Null Values.";
            JOptionPane.showMessageDialog(null, string, "ERROR", 0);
        }
    }

    private void Block() {
        int n = 0;
        double d = this.dRsqrd / 100.0;
        int n2 = this.NBlock;
        double d2 = -999.25;
        int n3 = 0;
        if (this.stLAS != null) {
            d2 = this.stLAS.dNull;
        }
        if (this.ClusterRes != null) {
            if (this.iStop == 0) {
                n = this.NSave - this.NBlock;
            } else {
                for (int i = this.ClusterRes.Rsq.length - 1; i >= 0; --i) {
                    if (!(this.ClusterRes.Rsq[i] > d)) continue;
                    n = i;
                    n2 = this.NSave - i;
                }
            }
            this.iOGroups = n2;
            n3 = (int)(this.ClusterRes.Rsq[n] * 10000.0);
            this.dORsq = (double)n3 / 100.0;
            int[] nArray = this.ClusterRes.jclus[n];
            this.ZoneStats = zekeCluster.zekeZoneStats(this.depth, this.dLogMat, nArray);
        }
    }

    private void computeXY() {
        int n = 0;
        int n2 = 0;
        int n3 = 255;
        int n4 = 255;
        int n5 = 255;
        double d = 0.0;
        if (this.stPlotXY != null) {
            this.stPlotXY.delete();
        }
        this.stPlotXY = null;
        this.stPlotXY = new plotXYStruct();
        this.stPlotXY.sTitle1 = new String("Scree Plot");
        if (this.stHeader != null) {
            this.stPlotXY.sTitle2 = this.stHeader.sAPI.length() > 3 ? new String(this.stHeader.sName + " (" + this.stHeader.sAPI + ")") : new String(this.stHeader.sName);
        }
        this.stPlotXY.iXLog = 0;
        this.stPlotXY.iXCycles = 1;
        this.stPlotXY.dXMaximum = 20.0;
        this.stPlotXY.dXMinimum = 0.0;
        this.stPlotXY.dXIncrement = 5.0;
        this.stPlotXY.sXAxis = new String("Number of Clusters");
        this.stPlotXY.iYLog = 0;
        this.stPlotXY.iYCycles = 1;
        this.stPlotXY.dYMaximum = 100.0;
        this.stPlotXY.dYMinimum = 0.0;
        this.stPlotXY.dYIncrement = 10.0;
        this.stPlotXY.sYAxis = new String("R-Squared (%)");
        if (this.ClusterRes != null && this.ClusterRes.Rsq != null && this.ClusterRes.nclus != null) {
            this.stPlotXY.iRows = n2 = this.ClusterRes.Rsq.length;
            this.stPlotXY.dX = new double[n2];
            this.stPlotXY.dY = new double[n2];
            this.stPlotXY.stSymbols = new plotSymbolStruct[n2];
            n2 = 0;
            for (n = 0; n < this.stPlotXY.iRows; ++n) {
                if (n2 >= this.stPlotXY.iRows) continue;
                this.stPlotXY.dX[n2] = this.ClusterRes.nclus[n];
                this.stPlotXY.dY[n2] = 100.0 * this.ClusterRes.Rsq[n];
                this.stPlotXY.stSymbols[n2] = plotSymbol.getPlotSymbolStructure(1, 1, 0, 0, 0, "NONE");
                ++n2;
            }
        }
    }

    private void ShowClusterAnalysis() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        if (this.pBlock != null) {
            this.pBlock.close();
        }
        this.pBlock = null;
        this.sColumns = null;
        this.sOMTable = null;
        for (n = 0; n < this.nLogs; ++n) {
            if (!this.bLog[n]) continue;
            ++n2;
        }
        if (this.ZoneStats != null) {
            n3 = this.ZoneStats.minDepth.length;
            this.sColumns = new String[n2 + 3];
            this.sOMTable = new String[n3][n2 + 3];
            this.sColumns[0] = new String("Start");
            this.sColumns[1] = new String("End");
            this.sColumns[2] = new String("Group (edit)");
            n4 = 3;
            for (n = 0; n < this.nLogs; ++n) {
                if (n4 >= n2 + 3 || !this.bLog[n]) continue;
                this.sColumns[n4] = new String(lasStandardTools.LAS_TOOLS[this.iOrder[n]][1]);
                ++n4;
            }
            for (n = 0; n < n3; ++n) {
                n5 = n + 1;
                this.sOMTable[n][0] = new String("" + this.ZoneStats.minDepth[n]);
                this.sOMTable[n][1] = new String("" + this.ZoneStats.maxDepth[n]);
                this.sOMTable[n][2] = new String("Group " + n5);
                n4 = 3;
                for (int i = 0; i < this.ZoneStats.logMeans.length; ++i) {
                    if (!this.bLog[i]) continue;
                    n5 = (int)(this.ZoneStats.logMeans[i][n] * 1000.0);
                    d = (double)n5 / 1000.0;
                    this.sOMTable[n][n4] = new String("" + d);
                    ++n4;
                }
            }
            this.pBlock = new zekeBlockResultsFrame(this.notifier, this.iOGroups, this.dORsq, this.sColumns, this.sOMTable, this.dStart, this.dEnd, this.iScale, this.nLogs, this.iOrder, this.bLog, this.stLAS, this.ZoneStats, this.iAPP);
            this.pBlock.setHeaders(this.stHeader);
        }
    }

    private void PlotScree() {
        if (this.plotXY != null) {
            this.plotXY.close();
        }
        this.plotXY = null;
        this.computeXY();
        if (this.stPlotXY != null) {
            this.plotXY = new zekeScreePlotXYFrame(this.stPlotXY);
            this.plotXY.setValues(this.iOGroups, this.dORsq);
        }
    }

    private void PlotRelativeIncrease() {
        if (this.plotRelXY != null) {
            this.plotRelXY.close();
        }
        this.plotRelXY = null;
        if (this.stPlotXY != null) {
            this.plotRelXY = new zekeRelIncrPlotXYFrame(this.stPlotXY);
            this.plotRelXY.setValues(this.iOGroups, this.dORsq);
        }
    }

    private void createPDF() {
        BufferedImage bufferedImage = zekePlotBuffered.makePlotImage(this.pBlock.getStartingDepth(), this.pBlock.getEndingDepth(), this.pBlock.getScale(), this.nLogs, this.iOrder, this.bLog, this.pBlock.getGroup(), this.iOGroups, this.dORsq, this.sColumns, this.sOMTable, this.stHeader, this.stLAS, this.ZoneStats);
        iqstratIO_Files.createImage(this.stStruct, bufferedImage);
        iqstratIO_Files.createHTML(this.stStruct);
        this.stStruct.sDirectory = new String("");
        this.stStruct.sName = new String("");
    }

    public void close() {
        this.pNotifier = null;
        this.stStruct = null;
        this.stHeader = null;
        this.stLAS = null;
        this.notifier = null;
        this.ClusterRes = null;
        this.ZoneStats = null;
        this.iOrder = null;
        this.bLog = null;
        this.depth = null;
        this.dLogMat = null;
        this.sColumns = null;
        this.sOMTable = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.rbGroups = null;
        this.rbRsqrd = null;
        this.txtGroups = null;
        this.txtRsqrd = null;
        this.btnCompute = null;
        this.btnScree = null;
        this.iSelected = null;
        if (this.nLogs > 0) {
            for (int i = 0; i < this.nLogs; ++i) {
                this.cb[i] = null;
            }
        }
        this.mExit = null;
        if (this.pBlock != null) {
            this.pBlock.close();
        }
        this.pBlock = null;
        if (this.pSearch != null) {
            this.pSearch.close();
        }
        this.pSearch = null;
        if (this.stPlotXY != null) {
            this.stPlotXY.delete();
        }
        this.stPlotXY = null;
        if (this.plotXY != null) {
            this.plotXY.close();
        }
        this.plotXY = null;
        if (this.plotRelXY != null) {
            this.plotRelXY.close();
        }
        this.plotRelXY = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.nLogs; ++i) {
            if (this.cb[i] == null || actionEvent.getSource() != this.cb[i]) continue;
            this.bLog[i] = this.cb[i].isSelected();
        }
        if (actionEvent.getSource() == this.rbGroups) {
            this.iStop = 0;
        }
        if (actionEvent.getSource() == this.rbRsqrd) {
            this.iStop = 1;
        }
        this.setButtons();
        if (actionEvent.getSource() == this.btnScree) {
            this.doCompute();
            this.PlotScree();
            this.PlotRelativeIncrease();
        }
        if (actionEvent.getSource() == this.btnCompute) {
            this.Compute();
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtGroups) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("Number of Groups Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtRsqrd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("R-squared Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                }
                if (focusEvent.getSource() == this.txtGroups) {
                    this.NBlock = cmnString.stringToInt(this.txtGroups.getText());
                    if (this.NBlock < 2) {
                        this.NBlock = 2;
                        this.txtGroups.setText("" + this.NBlock);
                    }
                }
                if (focusEvent.getSource() == this.txtRsqrd) {
                    this.dRsqrd = cmnString.stringToDouble(this.txtRsqrd.getText());
                }
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        String string2 = "";
        if (string.equals("Create PDF")) {
            string2 = kgsIOUser.getHomeDir();
            this.stStruct.sDirectory = new String(string2);
            this.stStruct.sName = new String("Zonation");
            this.pSearch = new guiSearchDirectoryFrame(this.notifier, string2, "Zonation", ".png");
        }
        if (string.equals("Directory Path Selected")) {
            if (this.pSearch != null) {
                this.stStruct.sDirectory = new String(this.pSearch.getPath());
                this.stStruct.sName = new String(this.pSearch.getFile());
            }
            this.createPDF();
            if (this.pSearch != null) {
                this.pSearch.close();
            }
            this.pSearch = null;
        }
        if (string.equals("Transfer Cluster Analysis") && this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("Transfer Cluster Analysis"));
        }
    }

    public class zekeZonationFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            zekeZonationFrame.this.close();
        }
    }
}

