/*
 * Decompiled with CFR 0.152.
 */
package zeke.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import plot.plotSymbolStruct;
import plot.plotXYStruct;
import zeke.plot.zekeScreePlotXY;

public class zekeScreePlotXYFrame
extends JFrame {
    private plotXYStruct stPlot = null;
    private zekeScreePlotXY panel = null;

    public zekeScreePlotXYFrame(plotXYStruct plotXYStruct2) {
        try {
            this.stPlot = plotXYStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane = new JScrollPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Scree Plot");
        this.panel = new zekeScreePlotXY(this.stPlot);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.panel, null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                zekeScreePlotXYFrame.this.close();
            }
        });
        this.setSize(new Dimension(425, 500));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(3 * (dimension.width - this.getSize().width) / 4, (dimension.height - this.getSize().height) / 2);
        this.setResizable(true);
        this.setVisible(true);
    }

    public void refresh() {
        this.panel.repaint();
    }

    public void setLegend(int n, plotSymbolStruct[] plotSymbolStructArray) {
        this.panel.setLegend(n, plotSymbolStructArray);
    }

    public void setData(plotXYStruct plotXYStruct2) {
        if (this.panel != null) {
            this.panel.setData(plotXYStruct2);
        }
    }

    public void setTitle1(String string) {
        this.panel.setTitle1(string);
    }

    public void setTitle2(String string) {
        this.panel.setTitle2(string);
    }

    public void setXAxis(String string, int n, double d, double d2, double d3, int n2) {
        this.panel.setXAxis(string, n, d, d2, d3, n2);
    }

    public void setYAxis(String string, int n, double d, double d2, double d3, int n2) {
        this.panel.setYAxis(string, n, d, d2, d3, n2);
    }

    public void setValues(double d, double d2) {
        this.panel.setValues(d, d2);
    }

    public void setXYMinMax(double d, double d2, double d3, double d4) {
        this.panel.setXYMinMax(d, d2, d3, d4);
    }

    public void close() {
        this.stPlot = null;
        if (this.panel != null) {
            this.panel.close();
        }
        this.panel = null;
        this.dispose();
    }
}

