/*
 * Decompiled with CFR 0.152.
 */
package zeke.gui;

import iqstrat.iqstratHeadersStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import las.lasFileDataStruct;
import zeke.gui.zekePlotPanel;
import zeke.math.zekeZoneStatStruct;

public class zekePlotFrame
extends JFrame
implements ActionListener {
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int[] iLog = null;
    private int[] iZone = null;
    private int nLogs = 0;
    private int[] iOrder = null;
    private boolean[] bLog = null;
    private String[] sGroup = null;
    private lasFileDataStruct stLAS = null;
    private zekeZoneStatStruct stZone = null;
    private zekePlotPanel plot = null;

    public zekePlotFrame(double d, double d2, int n, int n2, int[] nArray, boolean[] blArray, lasFileDataStruct lasFileDataStruct2, zekeZoneStatStruct zekeZoneStatStruct2) {
        try {
            this.depthStart = d;
            this.depthEnd = d2;
            this.iScale = n;
            this.nLogs = n2;
            this.iOrder = nArray;
            this.bLog = blArray;
            this.stLAS = lasFileDataStruct2;
            this.stZone = zekeZoneStatStruct2;
            this.jbInit();
            this.addWindowListener(new zekePlotFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Plot - Cluster Analysis - Group Means");
        this.getContentPane().setLayout(new BorderLayout());
        this.plot = new zekePlotPanel(this, this.depthStart, this.depthEnd, this.iScale, this.nLogs, this.iOrder, this.bLog, this.stLAS, this.stZone);
        this.getContentPane().add((Component)this.plot, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.plot.getPlotWidth();
        int n2 = this.plot.getPlotHeight() - 50;
        if (n2 > dimension.height) {
            n2 = dimension.height - 50;
        }
        this.setSize(n + 50, dimension.height - 50);
        this.setLocation(dimension.width - this.getSize().width, 10);
        this.setResizable(true);
        this.setVisible(true);
    }

    public void close() {
        this.iLog = null;
        this.iZone = null;
        this.iOrder = null;
        this.bLog = null;
        this.sGroup = null;
        this.stLAS = null;
        this.stZone = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public int getPlotWidth() {
        return this.plot.getPlotWidth();
    }

    public int getPlotHeight() {
        return this.plot.getPlotHeight();
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this.plot != null) {
            bufferedImage = this.plot.getImage();
        }
        return bufferedImage;
    }

    public void setScale(int n, double d, double d2) {
        this.iScale = n;
        this.depthStart = d2;
        this.depthEnd = d;
        if (this.plot != null) {
            this.plot.setScale(n, d, d2);
            this.plot.updateUI();
        }
    }

    public void setGroupName(String[] stringArray) {
        this.plot.setGroupName(stringArray);
    }

    public void setHeaders(iqstratHeadersStruct iqstratHeadersStruct2) {
        String string = "Depth-Constrained Cluster Analysis";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (iqstratHeadersStruct2 != null) {
            string2 = iqstratHeadersStruct2.sAPI.length() > 3 ? new String(iqstratHeadersStruct2.sName + " (" + iqstratHeadersStruct2.sAPI + ")") : new String(iqstratHeadersStruct2.sName);
            if (iqstratHeadersStruct2.iTownship > 0 && iqstratHeadersStruct2.iRange > 0 && iqstratHeadersStruct2.iSection > 0) {
                string3 = new String(" T: " + iqstratHeadersStruct2.iTownship + iqstratHeadersStruct2.sTownship + " R: " + iqstratHeadersStruct2.iRange + iqstratHeadersStruct2.sRange + " S: " + iqstratHeadersStruct2.iSection);
            }
            string4 = new String("");
            if (iqstratHeadersStruct2.dLatitude != 0.0) {
                string4 = new String(string4 + "Latitude: " + iqstratHeadersStruct2.dLatitude + " ");
            }
            if (iqstratHeadersStruct2.dLongitude != 0.0) {
                string4 = new String(string4 + "Longitude: " + iqstratHeadersStruct2.dLongitude + " ");
            }
            if (iqstratHeadersStruct2.dGL > 0.0) {
                string5 = new String(string5 + "Elevation (GL): " + iqstratHeadersStruct2.dGL + " ");
            } else if (iqstratHeadersStruct2.dKB > 0.0) {
                string5 = new String(string5 + "Elevation (KB): " + iqstratHeadersStruct2.dKB + " ");
            }
            if (iqstratHeadersStruct2.depth > 0.0) {
                string5 = new String(string5 + "Total Depth: " + iqstratHeadersStruct2.depth + " ");
            }
        }
        if (this.plot != null) {
            this.plot.setTitles(string, string2, string3, string4, string5);
        }
    }

    public class zekePlotFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            zekePlotFrame.this.close();
            System.exit(0);
        }
    }
}

