/*
 * Decompiled with CFR 0.152.
 */
package pfeffer.math;

import las.lasFileDataStruct;
import pfeffer.math.pfefferSwModels;
import pfeffer.pfefferDataStruct;
import pfeffer.pfefferStruct;

public class pfefferMath {
    public static final int _NONE = -1;
    public static final int _RHOB = 0;
    public static final int _NPHI = 1;
    public static final int _PHIAvg = 2;
    public static final int _SPHI = 3;
    public static final String[] PHI_TYPE = new String[]{"RHOB", "NPHI", "AVERAGE", "SPHI"};
    public static final String[] UNITS = new String[]{"[gm/cc]", "[gm/cc]", "[gm/cc]", "[usec/ft]"};
    public static final int _NO = 0;
    public static final int _YES = 1;
    public static final int[] LITHOLOGY = new int[]{7, 19, 22};
    public static final int _LITHOLOGY = 0;
    public static final int _DENSITY = 1;
    public static final int _SONIC = 2;
    public static final int _QUARTZ = 0;
    public static final int _CALCITE = 1;
    public static final int _DOLOMITE = 2;
    public static final String[][] MATRIX = new String[][]{{"Quartz", "2.65", "55.5"}, {"Calcite", "2.71", "47.5"}, {"Dolomite", "2.87", "43.5"}};
    public static final int _FRESH = 0;
    public static final int _SALT = 1;
    public static final int _OIL = 2;
    public static final String[][] FLUID = new String[][]{{"Fresh Water", "1.0", "189.0"}, {"Salty Water", "1.1", "185.0"}, {"Oil Mud", "0.985", "204.5"}};

    public static int getRowCount(double d, double d2, double d3) {
        int n = 0;
        if (d2 > 0.0 && d3 > 0.0) {
            n = (int)((d2 - d) / d3);
        }
        return n;
    }

    public static double[] getDepth(double d, double d2, double d3, lasFileDataStruct lasFileDataStruct2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double[] dArray = null;
        if (d2 > 0.0 && d3 > 0.0 && lasFileDataStruct2 != null && (n2 = pfefferMath.getRowCount(d, d2, d3)) > 0) {
            dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = 0.0;
            }
            for (n = 0; n < lasFileDataStruct2.iRows; ++n) {
                if (!(lasFileDataStruct2.depths[n] >= d) || !(lasFileDataStruct2.depths[n] < d2) || n3 >= n2) continue;
                dArray[n3] = lasFileDataStruct2.depths[n];
                ++n3;
            }
        }
        return dArray;
    }

    public static double[] getThickness(double d, double d2, double d3) {
        int n = 0;
        int n2 = 0;
        double[] dArray = null;
        if (d2 > 0.0 && d3 > 0.0 && (n2 = pfefferMath.getRowCount(d, d2, d3)) > 0) {
            dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = 0.0;
            }
            for (n = 0; n < n2; ++n) {
                dArray[n] = d3;
            }
        }
        return dArray;
    }

    public static double[] getRt(double d, double d2, double d3, int n, lasFileDataStruct lasFileDataStruct2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double[] dArray = null;
        double[] dArray2 = null;
        if (d2 > 0.0 && d3 > 0.0 && lasFileDataStruct2 != null && n != -1) {
            dArray = lasFileDataStruct2.getData(n);
            n3 = pfefferMath.getRowCount(d, d2, d3);
            if (n3 > 0) {
                dArray2 = new double[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = 0.0;
                }
                for (n2 = 0; n2 < lasFileDataStruct2.iRows; ++n2) {
                    if (!(lasFileDataStruct2.depths[n2] >= d) || !(lasFileDataStruct2.depths[n2] < d2) || n4 >= n3) continue;
                    dArray2[n4] = dArray[n2];
                    ++n4;
                }
            }
        }
        return dArray2;
    }

    public static double[] getVsh(double d, double d2, double d3, int n, double d4, double d5, lasFileDataStruct lasFileDataStruct2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double[] dArray = null;
        double[] dArray2 = null;
        if (d2 > 0.0 && d3 > 0.0) {
            n3 = pfefferMath.getRowCount(d, d2, d3);
            dArray2 = new double[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = 0.0;
            }
        }
        if (lasFileDataStruct2 != null && n != -1) {
            dArray = lasFileDataStruct2.getData(n);
            if (n3 > 0) {
                for (n2 = 0; n2 < lasFileDataStruct2.iRows; ++n2) {
                    if (!(lasFileDataStruct2.depths[n2] >= d) || !(lasFileDataStruct2.depths[n2] < d2) || n4 >= n3) continue;
                    n5 = (int)(1000.0 * (dArray[n2] - d4) / (d5 - d4));
                    dArray2[n4] = (double)n5 / 1000.0;
                    ++n4;
                }
            }
        }
        return dArray2;
    }

    public static double[] getPHIt(double d, double d2, double d3, int n, int n2, int n3, double d4, double d5, double d6, double d7, int n4, double[] dArray, lasFileDataStruct lasFileDataStruct2) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        double d8 = 0.0;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        if (d2 > 0.0 && d3 > 0.0 && lasFileDataStruct2 != null) {
            n6 = pfefferMath.getRowCount(d, d2, d3);
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    dArray2 = lasFileDataStruct2.getData(n2);
                    if (n2 != 7 && n2 != 9) break;
                    n9 = 1;
                    break;
                }
                case 2: {
                    dArray2 = lasFileDataStruct2.getData(n2);
                    dArray3 = lasFileDataStruct2.getData(n3);
                    if (n3 != 5) break;
                    for (n5 = 0; n5 < lasFileDataStruct2.iRows; ++n5) {
                        dArray3[n5] = pfefferMath.computePHI(dArray3[n5], d4, d5);
                        d7 = pfefferMath.computePHI(d7, d4, d5);
                    }
                    break;
                }
            }
            if (n6 > 0) {
                dArray4 = new double[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    dArray4[n5] = 0.0;
                }
                for (n5 = 0; n5 < lasFileDataStruct2.iRows; ++n5) {
                    if (!(lasFileDataStruct2.depths[n5] >= d) || !(lasFileDataStruct2.depths[n5] < d2) || n7 >= n6) continue;
                    switch (n9) {
                        case 0: 
                        case 3: {
                            d8 = pfefferMath.computePHI(dArray2[n5], d4, d5, n4, d6, dArray[n7]);
                            break;
                        }
                        case 1: {
                            if (n4 == 0) {
                                d8 = dArray2[n5];
                                break;
                            }
                            d8 = dArray2[n5] - dArray[n7] * d6;
                            break;
                        }
                        case 2: {
                            d8 = n4 == 0 ? Math.sqrt(dArray2[n5] * dArray2[n5] + dArray3[n5] * dArray3[n5]) / 2.0 : (dArray2[n5] - d6 / d7 * dArray3[n5]) / (1.0 - d6 / d7);
                        }
                    }
                    n8 = (int)(1000.0 * d8);
                    dArray4[n7] = (double)n8 / 1000.0;
                    ++n7;
                }
            }
        }
        return dArray4;
    }

    public static double[] get2ndPHI(int n, double[] dArray, double[] dArray2) {
        double[] dArray3 = null;
        int n2 = 0;
        if (n > 0) {
            dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray2[i] - dArray[i];
                n2 = (int)(1000.0 * dArray3[i]);
                dArray3[i] = (double)n2 / 1000.0;
                if (!(dArray3[i] < 0.0)) continue;
                dArray3[i] = 0.0;
            }
        }
        return dArray3;
    }

    public static double getPHI(double d, double d2, int n, int n2, int n3, double d3, double d4, double d5, double d6, int n4, double d7, lasFileDataStruct lasFileDataStruct2) {
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (d2 > 0.0 && lasFileDataStruct2 != null) {
            for (n5 = 0; n5 < lasFileDataStruct2.iRows; ++n5) {
                if (!(lasFileDataStruct2.depths[n5] >= d) || !(lasFileDataStruct2.depths[n5] < d2)) continue;
                switch (n) {
                    case 0: 
                    case 1: 
                    case 3: {
                        d9 = lasFileDataStruct2.getRow(n2, n5);
                        if (n2 != 7 && n2 != 9) break;
                        n7 = 1;
                        break;
                    }
                    case 2: {
                        d9 = lasFileDataStruct2.getRow(n2, n5);
                        d10 = lasFileDataStruct2.getRow(n3, n5);
                        if (n3 != 5) break;
                        d10 = pfefferMath.computePHI(d10, d3, d4);
                        d6 = pfefferMath.computePHI(d6, d3, d4);
                    }
                }
                switch (n7) {
                    case 0: 
                    case 3: {
                        d8 = pfefferMath.computePHI(d9, d3, d4, n4, d5, d7);
                        break;
                    }
                    case 1: {
                        if (n4 == 0) {
                            d8 = d9;
                            break;
                        }
                        d8 = d9 - d7 * d5;
                        break;
                    }
                    case 2: {
                        d8 = n4 == 0 ? Math.sqrt(d9 * d9 + d10 * d10) / 2.0 : (d9 - d5 / d6 * d10) / (1.0 - d5 / d6);
                    }
                }
                n6 = (int)(1000.0 * d8);
                d11 = (double)n6 / 1000.0;
            }
        }
        return d11;
    }

    public static double computePHI(double d, double d2, double d3) {
        double d4 = 0.0;
        d4 = (d2 - d) / (d2 - d3);
        return d4;
    }

    public static double computePHI(double d, double d2, double d3, int n, double d4, double d5) {
        double d6 = 0.0;
        d6 = n == 0 ? (d2 - d) / (d2 - d3) : (d2 - d - d5 * (d2 - d4)) / (d2 - d3);
        return d6;
    }

    public static pfefferDataStruct compute(pfefferDataStruct pfefferDataStruct2, double d) {
        int n = 0;
        pfefferStruct pfefferStruct2 = new pfefferStruct();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n2 = 0;
        int n3 = 0;
        if (pfefferDataStruct2 != null) {
            if (pfefferDataStruct2.iRows > 0) {
                pfefferStruct2.A = pfefferDataStruct2.A;
                pfefferStruct2.M = pfefferDataStruct2.M;
                pfefferStruct2.N = pfefferDataStruct2.N;
                pfefferStruct2.Rw = pfefferDataStruct2.Rw;
                pfefferStruct2.Rsh = pfefferDataStruct2.Rsh;
                pfefferStruct2.Phish = pfefferDataStruct2.Phish;
                pfefferStruct2.Rtc = 0.0;
                pfefferStruct2.Rwa = 0.0;
                pfefferStruct2.Ro = 0.0;
                pfefferStruct2.Ma = 0.0;
                pfefferStruct2.Sw = 0.0;
                pfefferStruct2.BVW = 0.0;
                pfefferDataStruct2.Rtc = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.Rwa = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.Ro = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.Ma = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.Sw = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.BVW = new double[pfefferDataStruct2.iRows];
                pfefferDataStruct2.Pay = new double[pfefferDataStruct2.iRows];
                for (n = 0; n < pfefferDataStruct2.iRows; ++n) {
                    pfefferDataStruct2.Rtc[n] = 0.0;
                    pfefferDataStruct2.Rwa[n] = 0.0;
                    pfefferDataStruct2.Ro[n] = 0.0;
                    pfefferDataStruct2.Ma[n] = 0.0;
                    pfefferDataStruct2.Sw[n] = 0.0;
                    pfefferDataStruct2.BVW[n] = 0.0;
                    pfefferDataStruct2.Pay[n] = 0.0;
                }
                pfefferDataStruct2.dThickness = 0.0;
                pfefferDataStruct2.dHydroCarbon = 0.0;
                pfefferDataStruct2.dPay = 0.0;
                pfefferDataStruct2.dPorosity = 0.0;
                pfefferDataStruct2.dSaturation = 0.0;
                for (n = 0; n < pfefferDataStruct2.iRows; ++n) {
                    d2 = pfefferDataStruct2.Rt[n];
                    d3 = pfefferDataStruct2.PHIt[n];
                    d4 = pfefferDataStruct2.Vsh[n];
                    d5 = pfefferDataStruct2.thick[n];
                    if (d2 != d && d3 != d && d4 != d) {
                        switch (pfefferDataStruct2.iWaterModel) {
                            case 0: {
                                pfefferStruct2 = pfefferSwModels.pfefferArchie(pfefferStruct2, d2, d3);
                                break;
                            }
                            case 1: {
                                pfefferStruct2 = pfefferSwModels.pfefferSimandoux(pfefferStruct2, d2, d3, d4);
                                break;
                            }
                            case 2: {
                                pfefferStruct2 = pfefferSwModels.pfefferDualWater(pfefferStruct2, d2, d3, d4);
                            }
                        }
                        n2 = (int)(1000.0 * pfefferStruct2.Rtc);
                        pfefferDataStruct2.Rtc[n] = (double)n2 / 1000.0;
                        n2 = (int)(1000.0 * pfefferStruct2.Rwa);
                        pfefferDataStruct2.Rwa[n] = (double)n2 / 1000.0;
                        n2 = (int)(1000.0 * pfefferStruct2.Ro);
                        pfefferDataStruct2.Ro[n] = (double)n2 / 1000.0;
                        n2 = (int)(1000.0 * pfefferStruct2.Ma);
                        pfefferDataStruct2.Ma[n] = (double)n2 / 1000.0;
                        n2 = (int)(1000.0 * pfefferStruct2.Sw);
                        pfefferDataStruct2.Sw[n] = (double)n2 / 1000.0;
                        n2 = (int)(1000.0 * pfefferStruct2.BVW);
                        pfefferDataStruct2.BVW[n] = (double)n2 / 1000.0;
                        d6 += d5;
                        if (d3 > pfefferDataStruct2.dPhiCut && pfefferStruct2.Sw < pfefferDataStruct2.dSwCut && d4 < pfefferDataStruct2.dVshCut && pfefferStruct2.BVW < pfefferDataStruct2.dBvwCut) {
                            d11 = d5 * d3 * (1.0 - pfefferStruct2.Sw);
                            n2 = (int)(1000.0 * d11);
                            pfefferDataStruct2.Pay[n] = (double)n2 / 1000.0;
                            d9 += d5;
                            d10 += pfefferDataStruct2.Pay[n];
                            d7 += d3;
                            d8 += pfefferDataStruct2.Sw[n];
                            ++n3;
                        }
                    }
                    pfefferStruct2.Rtc = 0.0;
                    pfefferStruct2.Rwa = 0.0;
                    pfefferStruct2.Ro = 0.0;
                    pfefferStruct2.Ma = 0.0;
                    pfefferStruct2.Sw = 0.0;
                    pfefferStruct2.BVW = 0.0;
                }
            }
            pfefferDataStruct2.dThickness = d6;
            n2 = (int)(100.0 * d10);
            pfefferDataStruct2.dHydroCarbon = d10 = (double)n2 / 100.0;
            pfefferDataStruct2.dPay = d9;
            if (n3 > 0) {
                n2 = (int)(100.0 * d7 / (double)n3);
                pfefferDataStruct2.dPorosity = d7 = (double)n2 / 100.0;
                n2 = (int)(100.0 * d8 / (double)n3);
                pfefferDataStruct2.dSaturation = d8 = (double)n2 / 100.0;
            }
        }
        return pfefferDataStruct2;
    }
}

