/*
 * Decompiled with CFR 0.152.
 */
package math;

public class mathLAS {
    public static final int _DENSITY = 0;
    public static final int _SONIC = 1;
    public static final int _U = 2;
    public static final int _QUARTZ = 0;
    public static final int _CALCITE = 1;
    public static final int _DOLOMITE = 2;
    public static final double[][] MATRIX = new double[][]{{2.65, 55.5, 4.8}, {2.71, 47.5, 13.8}, {2.87, 43.5, 9.0}};
    public static final int _FRESH = 0;
    public static final int _SALT = 1;
    public static final int _OIL = 2;
    public static final double[][] FLUID = new double[][]{{1.0, 189.0, 0.398}, {1.1, 185.0, 1.36}, {0.985, 204.5, 0.136}};

    public static double[] computeLogMinMax(double[] dArray, double d) {
        int n;
        double[] dArray2 = new double[]{0.0, 0.0};
        boolean bl = false;
        int n2 = dArray.length;
        boolean bl2 = false;
        double d2 = 0.1;
        double d3 = 1000.0;
        for (n = 0; n < n2; ++n) {
            if (dArray[n] == d || !(dArray[n] < d2) || !(d2 > 0.01)) continue;
            d2 = 0.01;
        }
        for (n = 0; n < n2; ++n) {
            if (dArray[n] == d || !(dArray[n] > d3) || !(d3 < 10000.0)) continue;
            d3 *= 10.0;
        }
        dArray2[0] = d2;
        dArray2[1] = d3;
        return dArray2;
    }

    public static double[] computeCurveMinMax(double[] dArray, double d) {
        double[] dArray2 = new double[]{0.0, 0.0};
        boolean bl = false;
        int n = dArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bl && dArray[i] != d) {
                bl = true;
                dArray2[0] = dArray[i];
                dArray2[1] = dArray[i];
                continue;
            }
            if (dArray[i] == d) continue;
            if (dArray2[0] > dArray[i] && dArray[i] != 0.0) {
                dArray2[0] = dArray[i];
            }
            if (!(dArray2[1] < dArray[i])) continue;
            dArray2[1] = dArray[i];
        }
        n2 = (int)(1000.0 * dArray2[0]);
        dArray2[0] = (double)n2 / 1000.0;
        n2 = (int)(1000.0 * dArray2[1]);
        dArray2[1] = (double)n2 / 1000.0;
        return dArray2;
    }

    public static double[] convertPotassium(int n, double[] dArray, double d) {
        int n2 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(dArray[n2] > 1.0)) continue;
            bl = true;
        }
        if (!bl) {
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray[n2] == d) continue;
                dArray[n2] = dArray[n2] * 100.0;
            }
        }
        return dArray;
    }

    public static double[] computeGR(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, double[] dArray3, int n5, double[] dArray4, double d) {
        if (n > 0 && n2 == -1 && n4 > -1 && n5 > -1 && n3 > -1) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d;
                if (dArray4[i] == d || dArray3[i] == d || dArray2[i] == d) continue;
                dArray[i] = 8.0 * dArray4[i] + 4.0 * dArray3[i] + 16.0 * dArray2[i];
            }
        }
        return dArray;
    }

    public static double[] computeCGR(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, double[] dArray3, double d) {
        if (n > 0 && n2 == -1 && n4 > -1 && n3 > -1) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d;
                if (dArray3[i] == d || dArray2[i] == d) continue;
                dArray[i] = 4.0 * dArray3[i] + 16.0 * dArray2[i];
            }
        }
        return dArray;
    }

    public static double[] computeGR(double[] dArray, double d, double d2, double d3) {
        int n = 0;
        double[] dArray2 = null;
        int n2 = 0;
        boolean bl = false;
        double d4 = 0.0;
        double d5 = 0.0;
        if (dArray != null) {
            n2 = dArray.length;
            dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                if (!bl && dArray[n] != d) {
                    bl = true;
                    d4 = dArray[n];
                    d5 = dArray[n];
                    continue;
                }
                if (d4 < dArray[n]) {
                    d4 = dArray[n];
                }
                if (d5 > dArray[n]) {
                    d5 = dArray[n];
                }
                if (!(d5 < 0.0)) continue;
                d5 = 0.0;
            }
            for (n = 0; n < n2; ++n) {
                dArray2[n] = d2 - (d2 - d3) * (d4 - dArray[n]) / (d4 - d5);
            }
        }
        return dArray2;
    }

    public static double[] computeGR(double[] dArray, double d, double d2, double d3, double d4, double d5) {
        int n = 0;
        double[] dArray2 = null;
        int n2 = 0;
        if (dArray != null) {
            n2 = dArray.length;
            dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray2[n] = d4 - (d4 - d5) * (d2 - dArray[n]) / (d2 - d3);
            }
        }
        return dArray2;
    }

    public static double[] computeNPHI(double[] dArray, double d, double d2, double d3) {
        int n = 0;
        double[] dArray2 = null;
        int n2 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        boolean bl = false;
        double d6 = 0.0;
        double d7 = 0.0;
        if (dArray != null) {
            n2 = dArray.length;
            dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                if (!bl && dArray[n] != d) {
                    bl = true;
                    d6 = dArray[n];
                    d7 = dArray[n];
                    continue;
                }
                if (d6 < dArray[n]) {
                    d6 = dArray[n];
                }
                if (d7 > dArray[n]) {
                    d7 = dArray[n];
                }
                if (!(d7 < 0.0)) continue;
                d7 = 0.0;
            }
            for (n = 0; n < n2; ++n) {
                d4 = Math.log(d2 / d3) / Math.log(10.0) / (d7 - d6);
                d5 = d2 * Math.pow(10.0, d4 * d7);
                dArray2[n] = d5 * Math.pow(10.0, d4 * dArray[n]);
            }
        }
        return dArray2;
    }

    public static double[] computeNPHI(double[] dArray, double d, double d2, double d3, double d4, double d5) {
        int n = 0;
        double[] dArray2 = null;
        int n2 = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (dArray != null) {
            n2 = dArray.length;
            dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                d6 = Math.log(d4 / d5) / Math.log(10.0) / (d3 - d2);
                d7 = d4 * Math.pow(10.0, d6 * d3);
                dArray2[n] = d7 * Math.pow(10.0, d6 * dArray[n]);
            }
        }
        return dArray2;
    }

    public static double[] convertPorosity(int n, double[] dArray, double d) {
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(dArray[n2] > 2.0)) continue;
            n3 = 1;
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray[n2] == d) continue;
                dArray[n2] = dArray[n2] / 100.0;
            }
        }
        return dArray;
    }

    public static double[] computePHI(int n, double[] dArray, int n2, int n3, int n4, double d) {
        double[] dArray2 = null;
        double d2 = MATRIX[n3][n2];
        double d3 = FLUID[n4][n2];
        if (n > 0) {
            dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d;
                if (!(dArray[i] > d)) continue;
                dArray2[i] = (d2 - dArray[i]) / (d2 - d3);
            }
        }
        return dArray2;
    }

    public static double[] computeLOG(int n, double[] dArray, int n2, int n3, int n4, double d) {
        double[] dArray2 = null;
        double d2 = MATRIX[n3][n2];
        double d3 = FLUID[n4][n2];
        if (n > 0) {
            dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d;
                if (!(dArray[i] > d)) continue;
                dArray2[i] = d2 - dArray[i] * (d2 - d3);
            }
        }
        return dArray2;
    }

    public static double computePHI(double d, int n, int n2, int n3) {
        double d2 = 0.0;
        double d3 = MATRIX[n2][n];
        double d4 = FLUID[n3][n];
        d2 = (d3 - d) / (d3 - d4);
        return d2;
    }

    public static double computeAvgPHI(double d, double d2) {
        double d3 = 0.0;
        d3 = (d + d2) / 2.0;
        return d3;
    }

    public static double computeRhomaa(int n, double d, double d2) {
        double d3 = 0.0;
        double d4 = FLUID[n][0];
        d3 = (d - d4 * d2) / (1.0 - d2);
        return d3;
    }

    public static double computeUmaa(int n, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = FLUID[n][2];
        d4 = (d2 * d - d5 * d3) / (1.0 - d3);
        return d4;
    }

    public static double computeUmaa(double d, double d2) {
        double d3 = 0.0;
        d3 = d / (1.0 - d2);
        return d3;
    }

    public static double computeDTMAA(int n, double d, double d2) {
        double d3 = 0.0;
        double d4 = FLUID[n][1];
        d3 = (d - d4 * d2) / (1.0 - d2);
        return d3;
    }

    public static double[][] computeRhomaaUmaa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double d) {
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[][] dArray4 = null;
        if (n2 > 0) {
            dArray4 = new double[2][n2];
            for (n4 = 0; n4 < 2; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray4[n4][n3] = d;
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d) || !(dArray3[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d3 = mathLAS.computePHI(dArray2[n3], 0, 1, n);
                d4 = mathLAS.computeAvgPHI(dArray[n3], d3);
                dArray4[0][n3] = mathLAS.computeRhomaa(n, dArray2[n3], d4);
                dArray4[1][n3] = mathLAS.computeUmaa(n, dArray2[n3], dArray3[n3], d4);
            }
        }
        return dArray4;
    }

    public static double[] computeRhomaa(int n, int n2, double[] dArray, double[] dArray2, double d) {
        int n3 = 0;
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray3 = null;
        if (n2 > 0) {
            dArray3 = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3[n3] = d;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d3 = mathLAS.computePHI(dArray2[n3], 0, 1, n);
                d4 = mathLAS.computeAvgPHI(dArray[n3], d3);
                dArray3[n3] = mathLAS.computeRhomaa(n, dArray2[n3], d4);
            }
        }
        return dArray3;
    }

    public static double[] computeDTmaa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double d) {
        int n3 = 0;
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray4 = null;
        if (n2 > 0) {
            dArray4 = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray4[n3] = d;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d) || !(dArray3[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d3 = mathLAS.computePHI(dArray2[n3], 0, 1, n);
                d4 = mathLAS.computeAvgPHI(dArray[n3], d3);
                dArray4[n3] = mathLAS.computeDTMAA(n, dArray3[n3], d4);
            }
        }
        return dArray4;
    }

    public static double[] computeDTmaa(int n, int n2, double[] dArray, double[] dArray2, double d) {
        int n3 = 0;
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray3 = null;
        if (n2 > 0) {
            dArray3 = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3[n3] = d;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d3 = dArray[n3];
                dArray3[n3] = mathLAS.computeDTMAA(n, dArray2[n3], d3);
            }
        }
        return dArray3;
    }

    public static double[] computePHIt(int n, int n2, double[] dArray, double[] dArray2, double d) {
        int n3 = 0;
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray3 = null;
        if (n2 > 0) {
            dArray3 = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3[n3] = d;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d3 = mathLAS.computePHI(dArray2[n3], 0, 1, n);
                dArray3[n3] = mathLAS.computeAvgPHI(dArray[n3], d3);
            }
        }
        return dArray3;
    }

    public static double[][] computePorosityDifference(int n, int n2, double[] dArray, double[] dArray2, double d) {
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double[][] dArray3 = null;
        dArray3 = new double[2][n2];
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3[n4][n3] = d;
            }
        }
        if (n2 > 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(dArray[n3] > d) || !(dArray2[n3] > d)) continue;
                if (dArray[n3] == 1.0) {
                    dArray[n3] = 0.99;
                }
                d2 = mathLAS.computePHI(dArray2[n3], 0, 1, n);
                dArray3[0][n3] = dArray[n3];
                dArray3[1][n3] = dArray[n3] - d2;
            }
        }
        return dArray3;
    }

    public static double[][] computeSpectralGR(int n, double[] dArray, double[] dArray2, double[] dArray3, double d) {
        int n2 = 0;
        int n3 = 0;
        double[][] dArray4 = null;
        dArray4 = new double[2][n];
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray4[n3][n2] = d;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (!(dArray[n2] > d) || !(dArray2[n2] > d) || !(dArray3[n2] > d)) continue;
            if (dArray2[n2] == 0.0) {
                dArray2[n2] = 1.0E-4;
            }
            if (dArray3[n2] == 0.0) {
                dArray3[n2] = 1.0E-4;
            }
            dArray4[0][n2] = dArray[n2] / dArray2[n2];
            dArray4[1][n2] = dArray[n2] / dArray3[n2];
        }
        return dArray4;
    }

    public static double[] computeTempDiff(int n, double[] dArray, double d) {
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = null;
        dArray2 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = d;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            d2 = dArray[n2];
            d3 = dArray[n2 + 1];
            if (!(d2 > d) || !(d3 > d)) continue;
            dArray2[n2] = d3 - d2;
        }
        return dArray2;
    }
}

