/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnString;
import iqstrat.iqstratHeadersStruct;
import las.lasFileDataStruct;
import las3.las3Constants;
import las3.las3ListStruct;
import las3.las3Parameters;
import las3.las3Struct;
import las3.las3Utility;
import math.mathLAS;

public class las3LoadLogData {
    public static final int _NONE = -1;
    public static final int _START_DEPTH = 0;
    public static final int _END_DEPTH = 1;
    public static final int _STEP_BY = 2;
    public static final int _NULL_VALUE = 3;
    public static final int _WELL_ROWS = 4;
    public static final int _WELL_COLS = 5;
    public static final String[][] WELL = new String[][]{{"STRT", "First Index Value", "", "", ""}, {"STOP", "Last Index Value", "", "", ""}, {"STEP", "STEP of index", "", "", ""}, {"NULL", "NULL VALUE", "", "", ""}};
    public static final int _PDAT = 0;
    public static final int _APD = 1;
    public static final int _DREF = 2;
    public static final int _EREF = 3;
    public static final int _TDL = 4;
    public static final int _TDD = 5;
    public static final int _CSGL = 6;
    public static final int _CSGD = 7;
    public static final int _CSGS = 8;
    public static final int _CSGW = 9;
    public static final int _BS = 10;
    public static final int _MUD = 11;
    public static final int _MUDS = 12;
    public static final int _MUDD = 13;
    public static final int _MUDV = 14;
    public static final int _FL = 15;
    public static final int _PH = 16;
    public static final int _RM = 17;
    public static final int _RMT = 18;
    public static final int _RMF = 19;
    public static final int _RMFT = 20;
    public static final int _RMC = 21;
    public static final int _RMCT = 22;
    public static final int _TMAX = 23;
    public static final int _TIMC = 24;
    public static final int _TIML = 25;
    public static final int _T_UNIT = 26;
    public static final int _BASE = 27;
    public static final int _ENG = 28;
    public static final int _WIT = 29;
    public static final int _GL = 30;
    public static final int _KB = 31;
    public static final int _DF = 32;
    public static final int _RT = 33;
    public static final int _PARAM_STD = 30;
    public static final int _PARAM_ROWS = 34;
    public static final int _PARAM_COLS = 5;
    public static final String[][] PARAM = new String[][]{{"PDAT", "Permanent Data", "PDAT2", "LMF", ""}, {"APD", "Above Permanent Data", "APD2", "", ""}, {"DREF", "Depth Reference (KB,DF,CB)", "", "", ""}, {"EREF", "Elevation of Depth Reference", "", "", ""}, {"TDL", "Total Depth Logger", "", "", ""}, {"TDD", "Total Depth Driller", "TD", "DRDP", ""}, {"CSGL", "Casing Bottom Logger", "CBD1", "CASL", ""}, {"CSGD", "Casing Bottom Driller", "CBL1", "CASD", ""}, {"CSGS", "Casing Size", "", "", ""}, {"CSGW", "Casing Weight", "", "", ""}, {"BS", "Bit Size", "", "", ""}, {"MUD", "Mud type", "FTYP", "", ""}, {"MUDS", "Mud Source", "", "", ""}, {"MUDD", "Mud Density", "DFD", "", ""}, {"MUDV", "Mud Viscosity (Funnel)", "DFV", "", ""}, {"FL", "Fluid Loss", "DFL", "", ""}, {"PH", "PH", "DFPH", "FPH", ""}, {"RM", "Resistivity of Mud", "MRS", "", ""}, {"RMT", "Temperature of Mud", "MST", "MTP", ""}, {"RMF", "Resistivity of Mud Filtrate", "MFRS", "", ""}, {"RMFT", "Temperature of Mud Filtrate", "MFTP", "", ""}, {"RMC", "Resistivity of Mud Cake", "MCRS", "", ""}, {"RMCT", "Temperature of Mud Cake", "MCTP", "", ""}, {"TMAX", "Maximum Recorded Temp.", "MRT", "", ""}, {"TIMC", "Date/Time Circulation Stopped", "TNOC", "", ""}, {"TIML", "Date/Time Logger Tagged Bottom", "", "", ""}, {"UNIT", "Logging Unit Number", "LOGU", "", ""}, {"BASE", "Home Base of Logging Unit", "", "", ""}, {"ENG", "Recording Engineer", "RECB", "", ""}, {"WIT", "Witnessed By", "", "", ""}, {"GL", "Ground Level", "EGL", "EGL2", "G.L."}, {"KB", "Kelly Bushing", "EKB", "EKB2", "K.B."}, {"EDF", "Drilling Rig Floor", "EDF2", "DFE", "D.F."}, {"RT", "Rotary Table", "ERT", "R.T.", ""}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;

    public static lasFileDataStruct getData(las3ListStruct las3ListStruct2) {
        int n;
        int n2;
        int n3;
        lasFileDataStruct lasFileDataStruct2 = new lasFileDataStruct();
        las3Struct las3Struct2 = null;
        las3Struct las3Struct3 = null;
        int n4 = -1;
        int n5 = -1;
        if (las3ListStruct2 != null) {
            for (n3 = 0; n3 < las3ListStruct2.iCount; ++n3) {
                if (las3Utility.isData(1, 0, las3ListStruct2)) {
                    las3Struct2 = las3Utility.getData(1, 0, las3ListStruct2);
                }
                if (!las3Utility.isData(2, 0, las3ListStruct2)) continue;
                las3Struct3 = las3Utility.getData(2, 0, las3ListStruct2);
            }
        }
        if (las3Struct2 != null) {
            for (n3 = 0; n3 < las3Struct2.iParamRows; ++n3) {
                n4 = -1;
                for (n2 = 0; n2 < 4; ++n2) {
                    block43: for (n = 0; n < 5; ++n) {
                        if (!las3Struct2.sParams[n3][0].toUpperCase().equals(WELL[n2][n])) continue;
                        n4 = n2;
                        switch (n4) {
                            case -1: {
                                continue block43;
                            }
                            case 0: {
                                if (!cmnString.isNumeric(las3Struct2.sParams[n3][2])) continue block43;
                                lasFileDataStruct2.depthStart = cmnString.stringToDouble(las3Struct2.sParams[n3][2]);
                                continue block43;
                            }
                            case 1: {
                                if (!cmnString.isNumeric(las3Struct2.sParams[n3][2])) continue block43;
                                lasFileDataStruct2.depthEnd = cmnString.stringToDouble(las3Struct2.sParams[n3][2]);
                                continue block43;
                            }
                            case 2: {
                                if (!cmnString.isNumeric(las3Struct2.sParams[n3][2])) continue block43;
                                lasFileDataStruct2.depthStep = cmnString.stringToDouble(las3Struct2.sParams[n3][2]);
                                continue block43;
                            }
                            case 3: {
                                if (!cmnString.isNumeric(las3Struct2.sParams[n3][2])) continue block43;
                                lasFileDataStruct2.dNull = cmnString.stringToDouble(las3Struct2.sParams[n3][2]);
                            }
                        }
                    }
                }
            }
        }
        if (las3Struct3 != null) {
            for (n3 = 0; n3 < las3Struct3.iParamRows; ++n3) {
                n5 = -1;
                for (n2 = 0; n2 < 34; ++n2) {
                    block46: for (n = 0; n < 5; ++n) {
                        if (!las3Struct3.sParams[n3][0].toUpperCase().equals(PARAM[n2][n])) continue;
                        n5 = n2;
                        switch (n5) {
                            case -1: {
                                continue block46;
                            }
                            case 0: {
                                lasFileDataStruct2.sPDAT = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 1: {
                                lasFileDataStruct2.dAPD = las3LoadLogData.convertMtoF(las3Struct3.sParams[n3][2], las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 2: {
                                lasFileDataStruct2.sDREF = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 3: {
                                lasFileDataStruct2.dElevation = las3LoadLogData.convertMtoF(las3Struct3.sParams[n3][2], las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 4: {
                                if (lasFileDataStruct2.dTLD != 0.0) continue block46;
                                lasFileDataStruct2.dTLD = las3LoadLogData.convertMtoF(las3Struct3.sParams[n3][2], las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 5: {
                                if (lasFileDataStruct2.dTDD != 0.0) continue block46;
                                lasFileDataStruct2.dTDD = las3LoadLogData.convertMtoF(las3Struct3.sParams[n3][2], las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 6: {
                                lasFileDataStruct2.dCSGL = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sCSGL = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 7: {
                                lasFileDataStruct2.dCSGD = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sCSGD = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 8: {
                                lasFileDataStruct2.dCSGS = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sCSGS = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 9: {
                                lasFileDataStruct2.dCSGW = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sCSGW = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 10: {
                                lasFileDataStruct2.dBS = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sBS = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 11: {
                                lasFileDataStruct2.sMUD = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 12: {
                                lasFileDataStruct2.sMUDS = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 13: {
                                lasFileDataStruct2.dMUDD = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sMUDD = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 14: {
                                lasFileDataStruct2.dMUDV = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sMUDV = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 15: {
                                lasFileDataStruct2.dFL = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sFL = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 16: {
                                lasFileDataStruct2.dPH = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 17: {
                                lasFileDataStruct2.dRM = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRM = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 18: {
                                lasFileDataStruct2.dRMT = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRMT = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 19: {
                                lasFileDataStruct2.dRMF = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRMF = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 20: {
                                lasFileDataStruct2.dRMFT = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRMFT = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 21: {
                                lasFileDataStruct2.dRMC = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRMC = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 22: {
                                lasFileDataStruct2.dRMCT = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sRMCT = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 23: {
                                lasFileDataStruct2.dTMAX = las3LoadLogData.stringToDouble(las3Struct3.sParams[n3][2]);
                                lasFileDataStruct2.sTMAX = new String(las3Struct3.sParams[n3][1]);
                                continue block46;
                            }
                            case 24: {
                                lasFileDataStruct2.sTIMC = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 25: {
                                lasFileDataStruct2.sTIML = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 26: {
                                lasFileDataStruct2.sUNIT = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 27: {
                                lasFileDataStruct2.sBASE = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 28: {
                                lasFileDataStruct2.sENG = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                            case 29: {
                                lasFileDataStruct2.sWIT = new String(las3Struct3.sParams[n3][2]);
                                continue block46;
                            }
                        }
                    }
                }
            }
        }
        return lasFileDataStruct2;
    }

    public static lasFileDataStruct initData(int n, lasFileDataStruct lasFileDataStruct2) {
        int n2 = 0;
        if (lasFileDataStruct2 != null && n > 0) {
            lasFileDataStruct2.iRows = n;
            lasFileDataStruct2.depths = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dGR = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dCGR = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dSP = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dCAL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dNPHI = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dPE = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRHOB = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dDPHI = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRHO = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dDT = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dSPHI = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dCOND = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dCILD = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dCILM = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRES = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRMED = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRDEP = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRSHAL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dILD = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dILM = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dSFLU = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dMLL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLL8 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLN = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dSN = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dMNOR = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dMSFL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dMINV = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dAHT10 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dAHT20 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dAHT30 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dAHT60 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dAHT90 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dTh = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dU = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dK = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dGRN = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dNEUT = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dPERM = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dTEMP = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dTEMPDIFF = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dUmaa = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRhomaa = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dDTmaa = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dNeutron = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.delta = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dThU = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dThK = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLIN_1 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLIN_2 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLIN_3 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLIN_4 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLOG_1 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLOG_2 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLOG_3 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dLOG_4 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dPHI = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dGMCC = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRT = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRWA = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRO = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dRXRT = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dMA = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dPHIT = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dPHIE = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dSW = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dBVW = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT1 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT2 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT3 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT4 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT5 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dATT6 = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dVCAL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dVQTZ = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dVDOL = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dVSH = new double[lasFileDataStruct2.iRows];
            lasFileDataStruct2.dVANH = new double[lasFileDataStruct2.iRows];
            for (n2 = 0; n2 < lasFileDataStruct2.iRows; ++n2) {
                lasFileDataStruct2.depths[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dGR[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dCGR[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dSP[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dCAL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dNPHI[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dPE[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRHOB[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dDPHI[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRHO[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dDT[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dSPHI[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dCOND[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dCILD[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dCILM[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRES[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRMED[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRDEP[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRSHAL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dILD[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dILM[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dSFLU[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dMLL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLL8[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLN[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dSN[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dMNOR[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dMSFL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dMINV[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dAHT10[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dAHT20[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dAHT30[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dAHT60[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dAHT90[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dTh[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dU[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dK[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dGRN[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dNEUT[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dPERM[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dTEMP[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dTEMPDIFF[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dUmaa[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRhomaa[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dDTmaa[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dNeutron[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.delta[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLIN_1[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLIN_2[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLIN_3[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLIN_4[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLOG_1[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLOG_2[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLOG_3[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dLOG_4[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dPHI[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dGMCC[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRT[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRWA[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRO[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dRXRT[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dMA[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dPHIT[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dPHIE[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dSW[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dBVW[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT1[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT2[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT3[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT4[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT5[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dATT6[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dVCAL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dVQTZ[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dVDOL[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dVSH[n2] = lasFileDataStruct2.dNull;
                lasFileDataStruct2.dVANH[n2] = lasFileDataStruct2.dNull;
            }
            if (lasFileDataStruct2.depthStep > 0.0) {
                for (n2 = 0; n2 < lasFileDataStruct2.iRows; ++n2) {
                    lasFileDataStruct2.depths[n2] = lasFileDataStruct2.depthStart + (double)n2 * lasFileDataStruct2.depthStep;
                }
            }
        }
        return lasFileDataStruct2;
    }

    public static lasFileDataStruct addData(String[] stringArray, int n, lasFileDataStruct lasFileDataStruct2, lasFileDataStruct lasFileDataStruct3) {
        int n2 = -1;
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0};
        double d2 = 0.0;
        if (stringArray != null) {
            int n3;
            n2 = -1;
            d = las3LoadLogData.stringToDouble(stringArray[0], lasFileDataStruct3.dNull);
            for (n3 = 0; n3 < lasFileDataStruct3.iRows; ++n3) {
                d2 = Math.abs(d - lasFileDataStruct3.depths[n3]);
                if (!(d2 < 1.0E-5)) continue;
                n2 = n3;
            }
            if (n2 > -1) {
                for (n3 = 1; n3 < n; ++n3) {
                    d = las3LoadLogData.stringToDouble(stringArray[n3], lasFileDataStruct3.dNull);
                    if (n3 == 0) {
                        lasFileDataStruct3.depths[n2] = d;
                    }
                    if (lasFileDataStruct2.iGR == n3) {
                        lasFileDataStruct3.dGR[n2] = d;
                    }
                    if (lasFileDataStruct2.iCGR == n3) {
                        lasFileDataStruct3.dCGR[n2] = d;
                    }
                    if (lasFileDataStruct2.iSP == n3) {
                        lasFileDataStruct3.dSP[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dSP, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dSPMin = dArray[0];
                        lasFileDataStruct3.dSPMax = dArray[1];
                    }
                    if (lasFileDataStruct2.iCAL == n3) {
                        lasFileDataStruct3.dCAL[n2] = d;
                    }
                    if (lasFileDataStruct2.iNPHI == n3) {
                        lasFileDataStruct3.dNPHI[n2] = d;
                        if (lasFileDataStruct3.dNPHI[n2] > 0.5) {
                            lasFileDataStruct3.dPHIMax = 0.7;
                        }
                    }
                    if (lasFileDataStruct2.iPE == n3) {
                        lasFileDataStruct3.dPE[n2] = d;
                    }
                    if (lasFileDataStruct2.iDPHI == n3) {
                        lasFileDataStruct3.dDPHI[n2] = d;
                    }
                    if (lasFileDataStruct2.iRHOB == n3) {
                        lasFileDataStruct3.dRHOB[n2] = d;
                    }
                    if (lasFileDataStruct2.iRHO == n3) {
                        lasFileDataStruct3.dRHO[n2] = d;
                    }
                    if (lasFileDataStruct2.iDT == n3) {
                        lasFileDataStruct3.dDT[n2] = d;
                    }
                    if (lasFileDataStruct2.iSPHI == n3) {
                        lasFileDataStruct3.dSPHI[n2] = d;
                    }
                    if (lasFileDataStruct2.iCOND == n3) {
                        lasFileDataStruct3.dCOND[n2] = d;
                    }
                    if (lasFileDataStruct2.iCILD == n3) {
                        lasFileDataStruct3.dCILD[n2] = d;
                    }
                    if (lasFileDataStruct2.iCILM == n3) {
                        lasFileDataStruct3.dCILM[n2] = d;
                    }
                    if (lasFileDataStruct2.iRES == n3) {
                        lasFileDataStruct3.dRES[n2] = d;
                    }
                    if (lasFileDataStruct2.iRDEP == n3) {
                        lasFileDataStruct3.dRDEP[n2] = d;
                    }
                    if (lasFileDataStruct2.iRMED == n3) {
                        lasFileDataStruct3.dRMED[n2] = d;
                    }
                    if (lasFileDataStruct2.iRSHAL == n3) {
                        lasFileDataStruct3.dRSHAL[n2] = d;
                    }
                    if (lasFileDataStruct2.iILD == n3) {
                        lasFileDataStruct3.dILD[n2] = d;
                    }
                    if (lasFileDataStruct2.iILM == n3) {
                        lasFileDataStruct3.dILM[n2] = d;
                    }
                    if (lasFileDataStruct2.iSFLU == n3) {
                        lasFileDataStruct3.dSFLU[n2] = d;
                    }
                    if (lasFileDataStruct2.iLL == n3) {
                        lasFileDataStruct3.dLL[n2] = d;
                    }
                    if (lasFileDataStruct2.iMLL == n3) {
                        lasFileDataStruct3.dMLL[n2] = d;
                    }
                    if (lasFileDataStruct2.iLL8 == n3) {
                        lasFileDataStruct3.dLL8[n2] = d;
                    }
                    if (lasFileDataStruct2.iLN == n3) {
                        lasFileDataStruct3.dLN[n2] = d;
                    }
                    if (lasFileDataStruct2.iSN == n3) {
                        lasFileDataStruct3.dSN[n2] = d;
                    }
                    if (lasFileDataStruct2.iMNOR == n3) {
                        lasFileDataStruct3.dMNOR[n2] = d;
                    }
                    if (lasFileDataStruct2.iMSFL == n3) {
                        lasFileDataStruct3.dMSFL[n2] = d;
                    }
                    if (lasFileDataStruct2.iMINV == n3) {
                        lasFileDataStruct3.dMINV[n2] = d;
                    }
                    if (lasFileDataStruct2.iAHT10 == n3) {
                        lasFileDataStruct3.dAHT10[n2] = d;
                    }
                    if (lasFileDataStruct2.iAHT20 == n3) {
                        lasFileDataStruct3.dAHT20[n2] = d;
                    }
                    if (lasFileDataStruct2.iAHT30 == n3) {
                        lasFileDataStruct3.dAHT30[n2] = d;
                    }
                    if (lasFileDataStruct2.iAHT60 == n3) {
                        lasFileDataStruct3.dAHT60[n2] = d;
                    }
                    if (lasFileDataStruct2.iAHT90 == n3) {
                        lasFileDataStruct3.dAHT90[n2] = d;
                    }
                    if (lasFileDataStruct2.iTh == n3) {
                        lasFileDataStruct3.dTh[n2] = d;
                    }
                    if (lasFileDataStruct2.iU == n3) {
                        lasFileDataStruct3.dU[n2] = d;
                    }
                    if (lasFileDataStruct2.iK == n3) {
                        lasFileDataStruct3.dK[n2] = d;
                    }
                    if (lasFileDataStruct2.iGRN == n3) {
                        lasFileDataStruct3.dGRN[n2] = d;
                    }
                    if (lasFileDataStruct2.iNEUT == n3) {
                        lasFileDataStruct3.dNEUT[n2] = d;
                    }
                    if (lasFileDataStruct2.iPERM == n3) {
                        lasFileDataStruct3.dPERM[n2] = d;
                    }
                    if (lasFileDataStruct2.iTEMP == n3) {
                        lasFileDataStruct3.dTEMP[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dTEMP, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dTEMPMin = dArray[0];
                        lasFileDataStruct3.dTEMPMax = dArray[1];
                        lasFileDataStruct3.dTEMPDIFF = mathLAS.computeTempDiff(lasFileDataStruct3.iRows, lasFileDataStruct3.dTEMP, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.iTEMPDIFF = 610;
                    }
                    if (lasFileDataStruct2.iTEMPDIFF == n3) {
                        lasFileDataStruct3.dTEMPDIFF[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dTEMPDIFF, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dTEMPDIFFMin = dArray[0];
                        lasFileDataStruct3.dTEMPDIFFMax = dArray[1];
                        if (lasFileDataStruct3.dTEMPDIFFMin == 0.0) {
                            lasFileDataStruct3.dTEMPDIFFMin = -1.0;
                        }
                        if (lasFileDataStruct3.dTEMPDIFFMax == 0.0) {
                            lasFileDataStruct3.dTEMPDIFFMax = 1.0;
                        }
                    }
                    if (lasFileDataStruct2.iLIN_1 == n3) {
                        lasFileDataStruct3.dLIN_1[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dLIN_1, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLIN_1Min = dArray[0];
                        lasFileDataStruct3.dLIN_1Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLIN_2 == n3) {
                        lasFileDataStruct3.dLIN_2[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dLIN_2, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLIN_2Min = dArray[0];
                        lasFileDataStruct3.dLIN_2Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLIN_3 == n3) {
                        lasFileDataStruct3.dLIN_3[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dLIN_3, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLIN_3Min = dArray[0];
                        lasFileDataStruct3.dLIN_3Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLIN_4 == n3) {
                        lasFileDataStruct3.dLIN_4[n2] = d;
                        dArray = mathLAS.computeCurveMinMax(lasFileDataStruct3.dLIN_4, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLIN_4Min = dArray[0];
                        lasFileDataStruct3.dLIN_4Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLOG_1 == n3) {
                        lasFileDataStruct3.dLOG_1[n2] = d;
                        dArray = mathLAS.computeLogMinMax(lasFileDataStruct3.dLOG_1, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLOG_1Min = dArray[0];
                        lasFileDataStruct3.dLOG_1Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLOG_2 == n3) {
                        lasFileDataStruct3.dLOG_2[n2] = d;
                        dArray = mathLAS.computeLogMinMax(lasFileDataStruct3.dLOG_2, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLOG_2Min = dArray[0];
                        lasFileDataStruct3.dLOG_2Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLOG_3 == n3) {
                        lasFileDataStruct3.dLOG_3[n2] = d;
                        dArray = mathLAS.computeLogMinMax(lasFileDataStruct3.dLOG_3, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLOG_3Min = dArray[0];
                        lasFileDataStruct3.dLOG_3Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iLOG_4 == n3) {
                        lasFileDataStruct3.dLOG_4[n2] = d;
                        dArray = mathLAS.computeLogMinMax(lasFileDataStruct3.dLOG_4, lasFileDataStruct3.dNull);
                        lasFileDataStruct3.dLOG_4Min = dArray[0];
                        lasFileDataStruct3.dLOG_4Max = dArray[1];
                    }
                    if (lasFileDataStruct2.iPHI == n3) {
                        lasFileDataStruct3.dPHI[n2] = d;
                    }
                    if (lasFileDataStruct2.iGMCC == n3) {
                        lasFileDataStruct3.dGMCC[n2] = d;
                    }
                    if (lasFileDataStruct2.iRT == n3) {
                        lasFileDataStruct3.dRT[n2] = d;
                    }
                    if (lasFileDataStruct2.iRWA == n3) {
                        lasFileDataStruct3.dRWA[n2] = d;
                    }
                    if (lasFileDataStruct2.iRO == n3) {
                        lasFileDataStruct3.dRO[n2] = d;
                    }
                    if (lasFileDataStruct2.iRXRT == n3) {
                        lasFileDataStruct3.dRXRT[n2] = d;
                    }
                    if (lasFileDataStruct2.iMA == n3) {
                        lasFileDataStruct3.dMA[n2] = d;
                    }
                    if (lasFileDataStruct2.iPHIT == n3) {
                        lasFileDataStruct3.dPHIT[n2] = d;
                    }
                    if (lasFileDataStruct2.iPHIE == n3) {
                        lasFileDataStruct3.dPHIE[n2] = d;
                    }
                    if (lasFileDataStruct2.iSW == n3) {
                        lasFileDataStruct3.dSW[n2] = d;
                    }
                    if (lasFileDataStruct2.iBVW == n3) {
                        lasFileDataStruct3.dBVW[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT1 == n3) {
                        lasFileDataStruct3.dATT1[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT2 == n3) {
                        lasFileDataStruct3.dATT2[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT3 == n3) {
                        lasFileDataStruct3.dATT3[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT4 == n3) {
                        lasFileDataStruct3.dATT4[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT5 == n3) {
                        lasFileDataStruct3.dATT5[n2] = d;
                    }
                    if (lasFileDataStruct2.iATT6 == n3) {
                        lasFileDataStruct3.dATT6[n2] = d;
                    }
                    if (lasFileDataStruct2.iVCAL == n3) {
                        lasFileDataStruct3.dVCAL[n2] = d;
                    }
                    if (lasFileDataStruct2.iVQTZ == n3) {
                        lasFileDataStruct3.dVQTZ[n2] = d;
                    }
                    if (lasFileDataStruct2.iVDOL == n3) {
                        lasFileDataStruct3.dVDOL[n2] = d;
                    }
                    if (lasFileDataStruct2.iVSH == n3) {
                        lasFileDataStruct3.dVSH[n2] = d;
                    }
                    if (lasFileDataStruct2.iVANH != n3) continue;
                    lasFileDataStruct3.dVANH[n2] = d;
                }
            }
        }
        return lasFileDataStruct3;
    }

    public static lasFileDataStruct modifyLogData(lasFileDataStruct lasFileDataStruct2) {
        boolean bl = false;
        boolean bl2 = false;
        double[] dArray = new double[]{0.0, 0.0};
        boolean bl3 = false;
        if (lasFileDataStruct2 != null) {
            lasFileDataStruct2.dK = mathLAS.convertPotassium(lasFileDataStruct2.iRows, lasFileDataStruct2.dK, lasFileDataStruct2.dNull);
            if (lasFileDataStruct2.iGR == -1 && lasFileDataStruct2.iTh > -1 && lasFileDataStruct2.iU > -1 && lasFileDataStruct2.iK > -1) {
                lasFileDataStruct2.dGR = mathLAS.computeGR(lasFileDataStruct2.iRows, lasFileDataStruct2.iGR, lasFileDataStruct2.dGR, lasFileDataStruct2.iK, lasFileDataStruct2.dK, lasFileDataStruct2.iTh, lasFileDataStruct2.dTh, lasFileDataStruct2.iU, lasFileDataStruct2.dU, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iGR = 100;
            }
            if (lasFileDataStruct2.iGR == -1 && lasFileDataStruct2.iGRN > -1) {
                dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dGRN, lasFileDataStruct2.dNull);
                lasFileDataStruct2.dGRNMinP = (int)dArray[0];
                lasFileDataStruct2.dGRNMaxP = (int)(dArray[1] + 1.0);
                lasFileDataStruct2.dGR = mathLAS.computeGR(lasFileDataStruct2.dGRN, lasFileDataStruct2.dNull, 150.0, 0.0);
                if (lasFileDataStruct2.dGR != null) {
                    lasFileDataStruct2.iGR = 100;
                }
            }
            if (lasFileDataStruct2.iCGR == -1 && lasFileDataStruct2.iTh > -1 && lasFileDataStruct2.iK > -1) {
                lasFileDataStruct2.dCGR = mathLAS.computeCGR(lasFileDataStruct2.iRows, lasFileDataStruct2.iCGR, lasFileDataStruct2.dCGR, lasFileDataStruct2.iK, lasFileDataStruct2.dK, lasFileDataStruct2.iTh, lasFileDataStruct2.dTh, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iCGR = 110;
            }
            lasFileDataStruct2.dNPHI = mathLAS.convertPorosity(lasFileDataStruct2.iRows, lasFileDataStruct2.dNPHI, lasFileDataStruct2.dNull);
            if (lasFileDataStruct2.iNPHI == -1 && lasFileDataStruct2.iNEUT > -1) {
                dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dNEUT, lasFileDataStruct2.dNull);
                lasFileDataStruct2.dNEUTMinP = (int)dArray[0];
                lasFileDataStruct2.dNEUTMaxP = (int)(dArray[1] + 1.0);
                lasFileDataStruct2.dNPHI = mathLAS.computeNPHI(lasFileDataStruct2.dNEUT, lasFileDataStruct2.dNull, 0.4, 0.01);
                if (lasFileDataStruct2.dNPHI != null) {
                    lasFileDataStruct2.iNPHI = 400;
                }
            }
            lasFileDataStruct2.dSPHI = mathLAS.convertPorosity(lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, lasFileDataStruct2.dNull);
            lasFileDataStruct2.dDPHI = mathLAS.convertPorosity(lasFileDataStruct2.iRows, lasFileDataStruct2.dDPHI, lasFileDataStruct2.dNull);
            if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iDPHI == -1) {
                lasFileDataStruct2.dDPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dRHOB, 0, 1, 0, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iDPHI = 200;
            } else if (lasFileDataStruct2.iRHOB == -1 && lasFileDataStruct2.iDPHI > -1) {
                lasFileDataStruct2.dRHOB = mathLAS.computeLOG(lasFileDataStruct2.iRows, lasFileDataStruct2.dDPHI, 0, 1, 0, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iRHOB = 210;
            }
            if (lasFileDataStruct2.iDT > -1 && lasFileDataStruct2.iSPHI == -1) {
                lasFileDataStruct2.dSPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iSPHI = 220;
            }
        } else if (lasFileDataStruct2.iDT == -1 && lasFileDataStruct2.iSPHI > -1) {
            lasFileDataStruct2.dDT = mathLAS.computeLOG(lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, 1, 1, 0, lasFileDataStruct2.dNull);
            lasFileDataStruct2.iDT = 210;
        }
        if (lasFileDataStruct2.iTEMP > -1) {
            dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dTEMP, lasFileDataStruct2.dNull);
            lasFileDataStruct2.dTEMPMin = (int)dArray[0];
            lasFileDataStruct2.dTEMPMax = (int)dArray[1];
            lasFileDataStruct2.dTEMPDIFF = mathLAS.computeTempDiff(lasFileDataStruct2.iRows, lasFileDataStruct2.dTEMP, lasFileDataStruct2.dNull);
            lasFileDataStruct2.iTEMPDIFF = 610;
        }
        if (lasFileDataStruct2.iTEMPDIFF > -1) {
            dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dTEMPDIFF, lasFileDataStruct2.dNull);
            lasFileDataStruct2.dTEMPDIFFMin = (int)dArray[0];
            lasFileDataStruct2.dTEMPDIFFMax = (int)dArray[1];
            if (lasFileDataStruct2.dTEMPDIFFMin == 0.0) {
                lasFileDataStruct2.dTEMPDIFFMin = -1.0;
            }
            if (lasFileDataStruct2.dTEMPDIFFMax == 0.0) {
                lasFileDataStruct2.dTEMPDIFFMax = 1.0;
            }
        }
        if (lasFileDataStruct2.iRXRT > -1) {
            dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dRXRT, lasFileDataStruct2.dNull);
            lasFileDataStruct2.dRXRTMin = dArray[0];
            lasFileDataStruct2.dRXRTMax = dArray[1];
        }
        return lasFileDataStruct2;
    }

    public static las3Struct setData(lasFileDataStruct lasFileDataStruct2, double d) {
        las3Struct las3Struct2 = null;
        if (lasFileDataStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 2;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadLogData.addParameters(lasFileDataStruct2, las3Struct2);
        }
        return las3Struct2;
    }

    public static las3Struct addParameters(lasFileDataStruct lasFileDataStruct2, las3Struct las3Struct2) {
        String[] stringArray = new String[]{"", ""};
        if (lasFileDataStruct2 != null && las3Struct2 != null) {
            int n;
            las3Struct2.iParamRows = 31;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (n = 0; n < las3Struct2.iParamRows; ++n) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sParams[n][i] = new String("");
                }
            }
            block35: for (n = 0; n < las3Struct2.iParamRows; ++n) {
                las3Struct2.sParams[n][0] = new String(las3Parameters.LOG_PARAMETERS[n][0]);
                las3Struct2.sParams[n][1] = new String(las3Parameters.LOG_PARAMETERS[n][1]);
                las3Struct2.sParams[n][2] = new String("");
                las3Struct2.sParams[n][3] = new String(las3Parameters.LOG_PARAMETERS[n][3]);
                las3Struct2.sParams[n][4] = new String(las3Parameters.LOG_PARAMETERS[n][4]);
                switch (n) {
                    case 0: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sPDAT);
                        continue block35;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dAPD);
                        continue block35;
                    }
                    case 2: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sDREF);
                        continue block35;
                    }
                    case 3: {
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dElevation);
                        continue block35;
                    }
                    case 4: {
                        las3Struct2.sParams[n][2] = new String("1");
                        continue block35;
                    }
                    case 5: {
                        if (!(lasFileDataStruct2.dTLD > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dTLD);
                        continue block35;
                    }
                    case 6: {
                        if (!(lasFileDataStruct2.dTDD > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dTDD);
                        continue block35;
                    }
                    case 7: {
                        if (!(lasFileDataStruct2.dCSGL > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dCSGL);
                        continue block35;
                    }
                    case 8: {
                        if (!(lasFileDataStruct2.dCSGD > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dCSGD);
                        continue block35;
                    }
                    case 9: {
                        if (!(lasFileDataStruct2.dCSGS > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dCSGS);
                        continue block35;
                    }
                    case 10: {
                        if (!(lasFileDataStruct2.dCSGW > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dCSGW);
                        continue block35;
                    }
                    case 11: {
                        if (!(lasFileDataStruct2.dBS > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dBS);
                        continue block35;
                    }
                    case 12: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sMUD);
                        continue block35;
                    }
                    case 13: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sMUDS);
                        continue block35;
                    }
                    case 14: {
                        if (!(lasFileDataStruct2.dMUDD > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dMUDD);
                        continue block35;
                    }
                    case 15: {
                        if (!(lasFileDataStruct2.dMUDV > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dMUDV);
                        continue block35;
                    }
                    case 16: {
                        if (!(lasFileDataStruct2.dFL > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dFL);
                        continue block35;
                    }
                    case 17: {
                        if (!(lasFileDataStruct2.dPH > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dPH);
                        continue block35;
                    }
                    case 18: {
                        if (!(lasFileDataStruct2.dRM > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRM);
                        continue block35;
                    }
                    case 19: {
                        if (!(lasFileDataStruct2.dRMT > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRMT);
                        continue block35;
                    }
                    case 20: {
                        if (!(lasFileDataStruct2.dRMF > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRMF);
                        continue block35;
                    }
                    case 21: {
                        if (!(lasFileDataStruct2.dRMFT > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRMFT);
                        continue block35;
                    }
                    case 22: {
                        if (!(lasFileDataStruct2.dRMC > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRMC);
                        continue block35;
                    }
                    case 23: {
                        if (!(lasFileDataStruct2.dRMCT > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dRMCT);
                        continue block35;
                    }
                    case 24: {
                        if (!(lasFileDataStruct2.dTMAX > 0.0)) continue block35;
                        las3Struct2.sParams[n][2] = new String("" + lasFileDataStruct2.dTMAX);
                        continue block35;
                    }
                    case 25: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sTIMC);
                        continue block35;
                    }
                    case 26: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sTIML);
                        continue block35;
                    }
                    case 27: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sUNIT);
                        continue block35;
                    }
                    case 28: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sBASE);
                        continue block35;
                    }
                    case 29: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sENG);
                        continue block35;
                    }
                    case 30: {
                        las3Struct2.sParams[n][2] = new String(lasFileDataStruct2.sWIT);
                    }
                }
            }
        }
        return las3Struct2;
    }

    public static lasFileDataStruct mergeLogData(lasFileDataStruct lasFileDataStruct2, lasFileDataStruct lasFileDataStruct3) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        block74: for (n = 0; n < 78; ++n) {
            switch (n) {
                case 0: {
                    if (lasFileDataStruct2.iGR <= -1) continue block74;
                    lasFileDataStruct3.iGR = lasFileDataStruct2.iGR;
                    continue block74;
                }
                case 1: {
                    if (lasFileDataStruct2.iCGR <= -1) continue block74;
                    lasFileDataStruct3.iCGR = lasFileDataStruct2.iCGR;
                    continue block74;
                }
                case 2: {
                    if (lasFileDataStruct2.iSP <= -1) continue block74;
                    lasFileDataStruct3.iSP = lasFileDataStruct2.iSP;
                    continue block74;
                }
                case 3: {
                    if (lasFileDataStruct2.iCAL <= -1) continue block74;
                    lasFileDataStruct3.iCAL = lasFileDataStruct2.iCAL;
                    continue block74;
                }
                case 4: {
                    if (lasFileDataStruct2.iPE <= -1) continue block74;
                    lasFileDataStruct3.iPE = lasFileDataStruct2.iPE;
                    continue block74;
                }
                case 5: {
                    if (lasFileDataStruct2.iRHOB <= -1) continue block74;
                    lasFileDataStruct3.iRHOB = lasFileDataStruct2.iRHOB;
                    continue block74;
                }
                case 7: {
                    if (lasFileDataStruct2.iDPHI <= -1) continue block74;
                    lasFileDataStruct3.iDPHI = lasFileDataStruct2.iDPHI;
                    continue block74;
                }
                case 6: {
                    if (lasFileDataStruct2.iRHO <= -1) continue block74;
                    lasFileDataStruct3.iRHO = lasFileDataStruct2.iRHO;
                    continue block74;
                }
                case 8: {
                    if (lasFileDataStruct2.iNPHI <= -1) continue block74;
                    lasFileDataStruct3.iNPHI = lasFileDataStruct2.iNPHI;
                    continue block74;
                }
                case 10: {
                    if (lasFileDataStruct2.iDT <= -1) continue block74;
                    lasFileDataStruct3.iDT = lasFileDataStruct2.iDT;
                    continue block74;
                }
                case 9: {
                    if (lasFileDataStruct2.iSPHI <= -1) continue block74;
                    lasFileDataStruct3.iSPHI = lasFileDataStruct2.iSPHI;
                    continue block74;
                }
                case 11: {
                    if (lasFileDataStruct2.iCOND <= -1) continue block74;
                    lasFileDataStruct3.iCOND = lasFileDataStruct2.iCOND;
                    continue block74;
                }
                case 12: {
                    if (lasFileDataStruct2.iCILD <= -1) continue block74;
                    lasFileDataStruct3.iCILD = lasFileDataStruct2.iCILD;
                    continue block74;
                }
                case 13: {
                    if (lasFileDataStruct2.iCILM <= -1) continue block74;
                    lasFileDataStruct3.iCILM = lasFileDataStruct2.iCILM;
                    continue block74;
                }
                case 14: {
                    if (lasFileDataStruct2.iRES <= -1) continue block74;
                    lasFileDataStruct3.iRES = lasFileDataStruct2.iRES;
                    continue block74;
                }
                case 15: {
                    if (lasFileDataStruct2.iRDEP <= -1) continue block74;
                    lasFileDataStruct3.iRDEP = lasFileDataStruct2.iRDEP;
                    continue block74;
                }
                case 16: {
                    if (lasFileDataStruct2.iRMED <= -1) continue block74;
                    lasFileDataStruct3.iRMED = lasFileDataStruct2.iRMED;
                    continue block74;
                }
                case 17: {
                    if (lasFileDataStruct2.iRSHAL <= -1) continue block74;
                    lasFileDataStruct3.iRSHAL = lasFileDataStruct2.iRSHAL;
                    continue block74;
                }
                case 18: {
                    if (lasFileDataStruct2.iILD <= -1) continue block74;
                    lasFileDataStruct3.iILD = lasFileDataStruct2.iILD;
                    continue block74;
                }
                case 19: {
                    if (lasFileDataStruct2.iILM <= -1) continue block74;
                    lasFileDataStruct3.iILM = lasFileDataStruct2.iILM;
                    continue block74;
                }
                case 20: {
                    if (lasFileDataStruct2.iSFLU <= -1) continue block74;
                    lasFileDataStruct3.iSFLU = lasFileDataStruct2.iSFLU;
                    continue block74;
                }
                case 21: {
                    if (lasFileDataStruct2.iLL <= -1) continue block74;
                    lasFileDataStruct3.iLL = lasFileDataStruct2.iLL;
                    continue block74;
                }
                case 22: {
                    if (lasFileDataStruct2.iMLL <= -1) continue block74;
                    lasFileDataStruct3.iMLL = lasFileDataStruct2.iMLL;
                    continue block74;
                }
                case 23: {
                    if (lasFileDataStruct2.iLL8 <= -1) continue block74;
                    lasFileDataStruct3.iLL8 = lasFileDataStruct2.iLL8;
                    continue block74;
                }
                case 24: {
                    if (lasFileDataStruct2.iLN <= -1) continue block74;
                    lasFileDataStruct3.iLN = lasFileDataStruct2.iLN;
                    continue block74;
                }
                case 25: {
                    if (lasFileDataStruct2.iSN <= -1) continue block74;
                    lasFileDataStruct3.iSN = lasFileDataStruct2.iSN;
                    continue block74;
                }
                case 26: {
                    if (lasFileDataStruct2.iMNOR <= -1) continue block74;
                    lasFileDataStruct3.iMNOR = lasFileDataStruct2.iMNOR;
                    continue block74;
                }
                case 27: {
                    if (lasFileDataStruct2.iMSFL <= -1) continue block74;
                    lasFileDataStruct3.iMSFL = lasFileDataStruct2.iMSFL;
                    continue block74;
                }
                case 28: {
                    if (lasFileDataStruct2.iMINV <= -1) continue block74;
                    lasFileDataStruct3.iMINV = lasFileDataStruct2.iMINV;
                    continue block74;
                }
                case 29: {
                    if (lasFileDataStruct2.iAHT10 <= -1) continue block74;
                    lasFileDataStruct3.iAHT10 = lasFileDataStruct2.iAHT10;
                    continue block74;
                }
                case 30: {
                    if (lasFileDataStruct2.iAHT20 <= -1) continue block74;
                    lasFileDataStruct3.iAHT20 = lasFileDataStruct2.iAHT20;
                    continue block74;
                }
                case 31: {
                    if (lasFileDataStruct2.iAHT30 <= -1) continue block74;
                    lasFileDataStruct3.iAHT30 = lasFileDataStruct2.iAHT30;
                    continue block74;
                }
                case 32: {
                    if (lasFileDataStruct2.iAHT60 <= -1) continue block74;
                    lasFileDataStruct3.iAHT60 = lasFileDataStruct2.iAHT60;
                    continue block74;
                }
                case 33: {
                    if (lasFileDataStruct2.iAHT90 <= -1) continue block74;
                    lasFileDataStruct3.iAHT90 = lasFileDataStruct2.iAHT90;
                    continue block74;
                }
                case 34: {
                    if (lasFileDataStruct2.iTh <= -1) continue block74;
                    lasFileDataStruct3.iTh = lasFileDataStruct2.iTh;
                    continue block74;
                }
                case 35: {
                    if (lasFileDataStruct2.iU <= -1) continue block74;
                    lasFileDataStruct3.iU = lasFileDataStruct2.iU;
                    continue block74;
                }
                case 36: {
                    if (lasFileDataStruct2.iK <= -1) continue block74;
                    lasFileDataStruct3.iK = lasFileDataStruct2.iK;
                    continue block74;
                }
                case 37: {
                    if (lasFileDataStruct2.iGRN <= -1) continue block74;
                    lasFileDataStruct3.iGRN = lasFileDataStruct2.iGRN;
                    continue block74;
                }
                case 38: {
                    if (lasFileDataStruct2.iNEUT <= -1) continue block74;
                    lasFileDataStruct3.iNEUT = lasFileDataStruct2.iNEUT;
                    continue block74;
                }
                case 39: {
                    if (lasFileDataStruct2.iPERM <= -1) continue block74;
                    lasFileDataStruct3.iPERM = lasFileDataStruct2.iPERM;
                    continue block74;
                }
                case 40: {
                    if (lasFileDataStruct2.iTEMP <= -1) continue block74;
                    lasFileDataStruct3.iTEMP = lasFileDataStruct2.iTEMP;
                    continue block74;
                }
                case 77: {
                    if (lasFileDataStruct2.iTEMPDIFF <= -1) continue block74;
                    lasFileDataStruct3.iTEMPDIFF = lasFileDataStruct2.iTEMPDIFF;
                    continue block74;
                }
                case 41: {
                    if (lasFileDataStruct2.iLIN_1 <= -1) continue block74;
                    lasFileDataStruct3.iLIN_1 = lasFileDataStruct2.iLIN_1;
                    lasFileDataStruct3.sUnknown[0][0] = new String(lasFileDataStruct2.sUnknown[0][0]);
                    continue block74;
                }
                case 42: {
                    if (lasFileDataStruct2.iLIN_2 <= -1) continue block74;
                    lasFileDataStruct3.iLIN_2 = lasFileDataStruct2.iLIN_2;
                    lasFileDataStruct3.sUnknown[1][0] = new String(lasFileDataStruct2.sUnknown[1][0]);
                    continue block74;
                }
                case 43: {
                    if (lasFileDataStruct2.iLIN_3 <= -1) continue block74;
                    lasFileDataStruct3.iLIN_3 = lasFileDataStruct2.iLIN_3;
                    lasFileDataStruct3.sUnknown[2][0] = new String(lasFileDataStruct2.sUnknown[2][0]);
                    continue block74;
                }
                case 44: {
                    if (lasFileDataStruct2.iLIN_4 <= -1) continue block74;
                    lasFileDataStruct3.iLIN_4 = lasFileDataStruct2.iLIN_4;
                    lasFileDataStruct3.sUnknown[3][0] = new String(lasFileDataStruct2.sUnknown[3][0]);
                    continue block74;
                }
                case 45: {
                    if (lasFileDataStruct2.iLOG_1 <= -1) continue block74;
                    lasFileDataStruct3.iLOG_1 = lasFileDataStruct2.iLOG_1;
                    lasFileDataStruct3.sUnknown[0][1] = new String(lasFileDataStruct2.sUnknown[0][1]);
                    continue block74;
                }
                case 46: {
                    if (lasFileDataStruct2.iLOG_2 <= -1) continue block74;
                    lasFileDataStruct3.iLOG_2 = lasFileDataStruct2.iLOG_2;
                    lasFileDataStruct3.sUnknown[1][1] = new String(lasFileDataStruct2.sUnknown[1][1]);
                    continue block74;
                }
                case 47: {
                    if (lasFileDataStruct2.iLOG_3 <= -1) continue block74;
                    lasFileDataStruct3.iLOG_3 = lasFileDataStruct2.iLOG_3;
                    lasFileDataStruct3.sUnknown[2][1] = new String(lasFileDataStruct2.sUnknown[2][1]);
                    continue block74;
                }
                case 48: {
                    if (lasFileDataStruct2.iLOG_4 <= -1) continue block74;
                    lasFileDataStruct3.iLOG_4 = lasFileDataStruct2.iLOG_4;
                    lasFileDataStruct3.sUnknown[3][1] = new String(lasFileDataStruct2.sUnknown[3][1]);
                    continue block74;
                }
                case 49: {
                    if (lasFileDataStruct2.iPHI <= -1) continue block74;
                    lasFileDataStruct3.iPHI = lasFileDataStruct2.iPHI;
                    continue block74;
                }
                case 50: {
                    if (lasFileDataStruct2.iGMCC <= -1) continue block74;
                    lasFileDataStruct3.iGMCC = lasFileDataStruct2.iGMCC;
                    continue block74;
                }
                case 51: {
                    if (lasFileDataStruct2.iRT <= -1) continue block74;
                    lasFileDataStruct3.iRT = lasFileDataStruct2.iRT;
                    continue block74;
                }
                case 52: {
                    if (lasFileDataStruct2.iRWA <= -1) continue block74;
                    lasFileDataStruct3.iRWA = lasFileDataStruct2.iRWA;
                    continue block74;
                }
                case 53: {
                    if (lasFileDataStruct2.iRO <= -1) continue block74;
                    lasFileDataStruct3.iRO = lasFileDataStruct2.iRO;
                    continue block74;
                }
                case 54: {
                    if (lasFileDataStruct2.iRXRT <= -1) continue block74;
                    lasFileDataStruct3.iRXRT = lasFileDataStruct2.iRXRT;
                    continue block74;
                }
                case 55: {
                    if (lasFileDataStruct2.iMA <= -1) continue block74;
                    lasFileDataStruct3.iMA = lasFileDataStruct2.iMA;
                    continue block74;
                }
                case 56: {
                    if (lasFileDataStruct2.iPHIT <= -1) continue block74;
                    lasFileDataStruct3.iPHIT = lasFileDataStruct2.iPHIT;
                    continue block74;
                }
                case 57: {
                    if (lasFileDataStruct2.iPHIE <= -1) continue block74;
                    lasFileDataStruct3.iPHIE = lasFileDataStruct2.iPHIE;
                    continue block74;
                }
                case 58: {
                    if (lasFileDataStruct2.iSW <= -1) continue block74;
                    lasFileDataStruct3.iSW = lasFileDataStruct2.iSW;
                    continue block74;
                }
                case 59: {
                    if (lasFileDataStruct2.iBVW <= -1) continue block74;
                    lasFileDataStruct3.iBVW = lasFileDataStruct2.iBVW;
                    continue block74;
                }
                case 60: {
                    if (lasFileDataStruct2.iATT1 <= -1) continue block74;
                    lasFileDataStruct3.iATT1 = lasFileDataStruct2.iATT1;
                    continue block74;
                }
                case 61: {
                    if (lasFileDataStruct2.iATT2 <= -1) continue block74;
                    lasFileDataStruct3.iATT2 = lasFileDataStruct2.iATT2;
                    continue block74;
                }
                case 62: {
                    if (lasFileDataStruct2.iATT3 <= -1) continue block74;
                    lasFileDataStruct3.iATT3 = lasFileDataStruct2.iATT3;
                    continue block74;
                }
                case 63: {
                    if (lasFileDataStruct2.iATT4 <= -1) continue block74;
                    lasFileDataStruct3.iATT4 = lasFileDataStruct2.iATT4;
                    continue block74;
                }
                case 64: {
                    if (lasFileDataStruct2.iATT5 <= -1) continue block74;
                    lasFileDataStruct3.iATT5 = lasFileDataStruct2.iATT5;
                    continue block74;
                }
                case 65: {
                    if (lasFileDataStruct2.iATT6 <= -1) continue block74;
                    lasFileDataStruct3.iATT6 = lasFileDataStruct2.iATT6;
                    continue block74;
                }
                case 66: {
                    if (lasFileDataStruct2.iVCAL <= -1) continue block74;
                    lasFileDataStruct3.iVCAL = lasFileDataStruct2.iVCAL;
                    continue block74;
                }
                case 67: {
                    if (lasFileDataStruct2.iVQTZ <= -1) continue block74;
                    lasFileDataStruct3.iVQTZ = lasFileDataStruct2.iVQTZ;
                    continue block74;
                }
                case 68: {
                    if (lasFileDataStruct2.iVDOL <= -1) continue block74;
                    lasFileDataStruct3.iVDOL = lasFileDataStruct2.iVDOL;
                    continue block74;
                }
                case 69: {
                    if (lasFileDataStruct2.iVSH <= -1) continue block74;
                    lasFileDataStruct3.iVSH = lasFileDataStruct2.iVSH;
                    continue block74;
                }
                case 70: {
                    if (lasFileDataStruct2.iVANH <= -1) continue block74;
                    lasFileDataStruct3.iVANH = lasFileDataStruct2.iVANH;
                }
            }
        }
        if (lasFileDataStruct2 != null && lasFileDataStruct3 != null) {
            for (n = 0; n < lasFileDataStruct3.iRows; ++n) {
                d = lasFileDataStruct3.depths[n];
                for (int i = 0; i < lasFileDataStruct2.iRows - 1; ++i) {
                    d2 = lasFileDataStruct2.depths[i];
                    d4 = lasFileDataStruct2.depths[i + 1];
                    if (!(d >= d2) || !(d < d4)) continue;
                    for (int j = 0; j < 78; ++j) {
                        if (!lasFileDataStruct2.checkData(j)) continue;
                        d3 = lasFileDataStruct2.getRow(j, i);
                        d5 = lasFileDataStruct2.getRow(j, i + 1);
                        if (d3 > lasFileDataStruct2.dNull && d5 > lasFileDataStruct2.dNull) {
                            d6 = d5 - (d5 - d3) * (d4 - d) / (d4 - d2);
                            n2 = (int)(d6 * 1000.0);
                            lasFileDataStruct3.setRow(j, n, (double)n2 / 1000.0);
                            continue;
                        }
                        lasFileDataStruct3.setRow(j, n, lasFileDataStruct2.dNull);
                    }
                }
            }
        }
        return lasFileDataStruct3;
    }

    public static boolean isDepth(double d, int n, double[] dArray) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (d != dArray[i]) continue;
            bl = true;
        }
        return bl;
    }

    public static double stringToDouble(String string) {
        double d = 0.0;
        if (string != null && cmnString.isNumeric(string)) {
            d = cmnString.stringToDouble(string);
        }
        return d;
    }

    public static double stringToDouble(String string, double d) {
        double d2 = d;
        if (string != null && cmnString.isNumeric(string)) {
            d2 = cmnString.stringToDouble(string);
        }
        return d2;
    }

    public static double convertMtoF(String string, String string2) {
        double d = 0.0;
        double d2 = 3.281;
        int n = 0;
        if (string.length() > 0 && cmnString.isNumeric(string.trim())) {
            d = cmnString.stringToDouble(string.trim());
            if (string2.equals("M")) {
                d = d2 * d;
            }
            n = (int)(d * 1000.0);
            d = (double)n / 1000.0;
        }
        return d;
    }

    public static lasFileDataStruct normalizeDepth(iqstratHeadersStruct iqstratHeadersStruct2, lasFileDataStruct lasFileDataStruct2) {
        double d = 0.0;
        if (iqstratHeadersStruct2 != null && lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.sPDAT.length() == 0) {
                if (iqstratHeadersStruct2.dGL > 0.0 && iqstratHeadersStruct2.dKB > 0.0) {
                    d = Math.abs(iqstratHeadersStruct2.dKB - iqstratHeadersStruct2.dGL);
                    lasFileDataStruct2.sPDAT = new String("GL");
                    lasFileDataStruct2.dAPD = d;
                    lasFileDataStruct2.sDREF = new String("KB");
                    lasFileDataStruct2.dElevation = iqstratHeadersStruct2.dKB;
                } else if (iqstratHeadersStruct2.dGL > 0.0 && iqstratHeadersStruct2.dDF > 0.0) {
                    d = Math.abs(iqstratHeadersStruct2.dDF - iqstratHeadersStruct2.dGL);
                    lasFileDataStruct2.sPDAT = new String("GL");
                    lasFileDataStruct2.dAPD = d;
                    lasFileDataStruct2.sDREF = new String("DF");
                    lasFileDataStruct2.dElevation = iqstratHeadersStruct2.dDF;
                } else if (iqstratHeadersStruct2.dGL > 0.0) {
                    lasFileDataStruct2.sPDAT = new String("GL");
                    lasFileDataStruct2.dAPD = 0.0;
                    lasFileDataStruct2.sDREF = new String("GL");
                    lasFileDataStruct2.dElevation = iqstratHeadersStruct2.dGL;
                } else if (iqstratHeadersStruct2.dKB > 0.0) {
                    lasFileDataStruct2.sPDAT = new String("GL");
                    lasFileDataStruct2.dAPD = 15.0;
                    lasFileDataStruct2.sDREF = new String("KB");
                    lasFileDataStruct2.dElevation = iqstratHeadersStruct2.dKB - lasFileDataStruct2.dAPD;
                } else if (iqstratHeadersStruct2.dDF > 0.0) {
                    lasFileDataStruct2.sPDAT = new String("GL");
                    lasFileDataStruct2.dAPD = 15.0;
                    lasFileDataStruct2.sDREF = new String("DF");
                    lasFileDataStruct2.dElevation = iqstratHeadersStruct2.dDF - lasFileDataStruct2.dAPD;
                }
            }
            if (iqstratHeadersStruct2.depth > 0.0 && lasFileDataStruct2.dTLD == 0.0) {
                lasFileDataStruct2.dTLD = iqstratHeadersStruct2.depth;
            }
        }
        return lasFileDataStruct2;
    }
}

