/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnLASCurveListStruct;
import cmn.cmnString;
import dst.dstParameters;
import dst.dstStandardTools;
import dst.dstStruct;
import las3.las3Constants;
import las3.las3Struct;

public class las3LoadDSTData {
    public static final int _NONE = -1;
    public static final int _ID = 0;
    public static final int _FORM = 1;
    public static final int _STRT = 2;
    public static final int _STOP = 3;
    public static final int _DEV = 4;
    public static final int _WHIP = 5;
    public static final int _SERL = 6;
    public static final int _READ = 7;
    public static final int _PRES = 8;
    public static final int _DEPT = 9;
    public static final int _CMMNT = 10;
    public static final int _HOLE = 11;
    public static final int _COND = 12;
    public static final int _MUD = 23;
    public static final int _MUDD = 24;
    public static final int _MUDV = 25;
    public static final int _FL = 26;
    public static final int _RM = 27;
    public static final int _MSAL = 28;
    public static final int _CAKE = 29;
    public static final int _CSHT = 30;
    public static final int _CSHL = 31;
    public static final int _CSHV = 32;
    public static final int _GCSHT = 33;
    public static final int _GCSHP = 34;
    public static final int _OAPI = 35;
    public static final int _WSAL = 36;
    public static final int _CAP = 13;
    public static final int _STIM = 14;
    public static final int _ETIM = 15;
    public static final int _TIMC = 16;
    public static final int _TIMON = 17;
    public static final int _TIMOF = 18;
    public static final int _TYPE = 19;
    public static final int _UNITa = 20;
    public static final int _BASE = 21;
    public static final int _ENG = 22;
    public static final int _m = 37;
    public static final int _q = 38;
    public static final int _h = 39;
    public static final int _u = 40;
    public static final int _Pr = 41;
    public static final int _degR = 42;
    public static final int _beta = 43;
    public static final int _Z = 44;
    public static final int _KHU = 45;
    public static final int _KH = 46;
    public static final int _K = 47;
    public static final int _Pif = 48;
    public static final int _Pwf = 49;
    public static final int _tf = 50;
    public static final int _rw = 51;
    public static final int _re = 52;
    public static final int _PHI = 53;
    public static final int _c = 54;
    public static final int _G = 55;
    public static final int _Pwfc = 56;
    public static final int _DR = 57;
    public static final int _S = 58;
    public static final int _Ps = 59;
    public static final int _Pt = 60;
    public static final int _PI = 61;
    public static final int _RI = 62;
    public static final int _qa = 63;
    public static final int _qAOF = 64;
    public static final int _ELP1 = 65;
    public static final int _EUP1 = 66;
    public static final int _M1 = 67;
    public static final int _P1 = 68;
    public static final int _ELP2 = 69;
    public static final int _EUP2 = 70;
    public static final int _M2 = 71;
    public static final int _P2 = 72;
    public static final int _RECTL = 73;
    public static final int _RECTV = 74;
    public static final int _RECC = 75;
    public static final int _TOTAL = 76;
    public static final int _PARAM_ROWS = 76;
    public static final int _PARAM_COLS = 5;
    public static final String[][] PARAM = dstParameters.PARAMETERS;
    public static final int _TYPE_ = 0;
    public static final int _CNT_R = 1;
    public static final int _CNT_G = 2;
    public static final int _CNT_1 = 3;
    public static final int _CNT_2 = 4;
    public static final int _PARAM2_ROWS = 5;
    public static final int _PARAM2_COLS = 3;
    public static final String[][] PARAM2 = new String[][]{{"TYPE_D", "Type of DST Test, FLUID or GAS"}, {"CNT_R ", "Total number of Recovery Pressure Data"}, {"CNT_G ", "Total number of Gas Rates Data"}, {"CNT_1 ", "Total number of Shut In 1 Pressure-Temperature-Time Data"}, {"CNT_2 ", "Total number of Shut In 2 Pressure-Temperature-Time Data"}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;
    public static final int _INITIAL_HYDRO = 0;
    public static final int _FLOW_1 = 1;
    public static final int _SHUT_IN_1 = 2;
    public static final int _END_SHUT_IN_1 = 3;
    public static final int _FLOW_2 = 4;
    public static final int _SHUT_IN_2 = 5;
    public static final int _END_SHUT_IN_2 = 6;
    public static final int _FINAL_HYDRO = 7;
    public static final int _TIME = 0;
    public static final int _PRESSURE = 1;
    public static final int _TEMPERATURE = 2;

    public static dstStruct getData(las3Struct las3Struct2) {
        int n;
        int n2;
        dstStruct dstStruct2 = null;
        int n3 = -1;
        if (las3Struct2 != null) {
            for (n2 = 0; n2 < las3Struct2.iParamRows; ++n2) {
                n3 = -1;
                block88: for (n = 0; n < 76; ++n) {
                    if (!las3Struct2.sParams[n2][0].trim().toUpperCase().equals(PARAM[n][0].trim())) continue;
                    n3 = n;
                    if (dstStruct2 == null) {
                        dstStruct2 = new dstStruct();
                    }
                    switch (n3) {
                        case -1: {
                            continue block88;
                        }
                        case 0: {
                            dstStruct2.sKEY = new String(cmnString.UniqueName());
                            dstStruct2.sID = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 1: {
                            dstStruct2.sFormation = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 2: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.depthStart = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 3: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.depthEnd = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 4: {
                            if (las3Struct2.sParams[n2][2].toUpperCase().equals("NO")) {
                                dstStruct2.iDeviated = 0;
                                continue block88;
                            }
                            dstStruct2.iDeviated = 1;
                            continue block88;
                        }
                        case 5: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dWhipstock = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 6: {
                            dstStruct2.serialNo = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 7: {
                            dstStruct2.sReading = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 8: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dPressure = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 9: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.depth = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 10: {
                            dstStruct2.sTestRemark = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 11: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.diameter_hole = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 12: {
                            dstStruct2.sCondition_hole = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 23: {
                            dstStruct2.sMudType = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 24: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dMudWeight = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 25: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dViscosity = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 26: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dWaterLoss = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 27: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dOHM_M = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 28: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dSalinity = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 29: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dFilterCake = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 30: {
                            dstStruct2.sCushionType = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 31: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dCushionLength = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 32: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dCushionVolume = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 33: {
                            dstStruct2.sGasCushionType = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 34: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dGasCushionPres = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 35: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dOil_API = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 36: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dWaterSalinity = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 13: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dCapacity = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 14: {
                            dstStruct2.sDateStart = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 15: {
                            dstStruct2.sDateEnd = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 16: {
                            dstStruct2.sDateCalib = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 17: {
                            dstStruct2.sTimeOnBtm = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 18: {
                            dstStruct2.sTimeOffBtm = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 19: {
                            dstStruct2.sTestType = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 20: {
                            dstStruct2.sUnitNo = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 21: {
                            dstStruct2.sCompany = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 22: {
                            dstStruct2.sTester = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 73: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dLength = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 74: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dVolume = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 75: {
                            dstStruct2.sComments = new String(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 37: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.m2 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 38: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.q = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 39: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.h = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 40: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.mu = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 41: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dPressure = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 42: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.degF = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 43: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.beta = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 44: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.Z = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 45: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.KHU = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 46: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.KH = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 47: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.K = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 48: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.P2 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 49: {
                            continue block88;
                        }
                        case 50: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.Tf = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 51: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.rw = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 52: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.re = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 53: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.phi = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 54: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.c = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 55: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.G = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 56: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.Pwfc = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 57: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.DR = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 58: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.S = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 59: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dPs = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 60: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.dPt = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 61: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.PI = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 62: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.RI = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 63: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.qs = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 64: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.qAOF = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 65: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.lpt1 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 66: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.upt1 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 67: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.m1 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 68: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.P1 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 69: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.lpt2 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 70: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.upt2 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 71: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.m2 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block88;
                        }
                        case 72: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block88;
                            dstStruct2.P2 = cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                        }
                    }
                }
                n3 = -1;
                block89: for (n = 0; n < 5; ++n) {
                    if (!las3Struct2.sParams[n2][0].trim().toUpperCase().equals(PARAM2[n][0].trim())) continue;
                    n3 = n;
                    switch (n3) {
                        case -1: {
                            continue block89;
                        }
                        case 0: {
                            if (las3Struct2.sParams[n2][2].equals("FLUID")) {
                                dstStruct2.iDSTType = 0;
                                continue block89;
                            }
                            dstStruct2.iDSTType = 1;
                            continue block89;
                        }
                        case 1: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block89;
                            dstStruct2.iRecovery = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block89;
                        }
                        case 2: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block89;
                            dstStruct2.iGasRates = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block89;
                        }
                        case 3: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block89;
                            dstStruct2.iShut_In_1 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                            continue block89;
                        }
                        case 4: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[n2][2])) continue block89;
                            dstStruct2.iShut_In_2 = (int)cmnString.stringToDouble(las3Struct2.sParams[n2][2]);
                        }
                    }
                }
            }
        }
        if (dstStruct2 != null) {
            if (dstStruct2.iRecovery > 0) {
                dstStruct2.sRecovery = new String[dstStruct2.iRecovery][dstStruct2.jRecovery];
                for (n2 = 0; n2 < dstStruct2.iRecovery; ++n2) {
                    for (n = 0; n < dstStruct2.jRecovery; ++n) {
                        dstStruct2.sRecovery[n2][n] = n == 1 ? new String("") : new String("0.0");
                    }
                }
            }
            if (dstStruct2.iGasRates > 0) {
                dstStruct2.dGasRates = new double[dstStruct2.iGasRates][dstStruct2.jGasRates];
                for (n2 = 0; n2 < dstStruct2.iGasRates; ++n2) {
                    for (n = 0; n < dstStruct2.jGasRates; ++n) {
                        dstStruct2.dGasRates[n2][n] = 0.0;
                    }
                }
            }
            if (dstStruct2.iShut_In_1 > 0) {
                dstStruct2.dShut_In_1 = new double[dstStruct2.iShut_In_1][3];
                for (n2 = 0; n2 < dstStruct2.iShut_In_1; ++n2) {
                    for (n = 0; n < 3; ++n) {
                        dstStruct2.dShut_In_1[n2][n] = 0.0;
                    }
                }
            }
            if (dstStruct2.iShut_In_2 > 0) {
                dstStruct2.dShut_In_2 = new double[dstStruct2.iShut_In_2][3];
                for (n2 = 0; n2 < dstStruct2.iShut_In_2; ++n2) {
                    for (n = 0; n < 3; ++n) {
                        dstStruct2.dShut_In_2[n2][n] = 0.0;
                    }
                }
            }
        }
        return dstStruct2;
    }

    public static dstStruct loadData(double d, las3Struct las3Struct2, cmnLASCurveListStruct cmnLASCurveListStruct2, dstStruct dstStruct2) {
        int n = -1;
        String string = "";
        String string2 = "";
        int n2 = -1;
        String string3 = new String("" + d);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string4 = "";
        int n7 = -1;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        String string5 = "0.0";
        String string6 = "0.0";
        String string7 = "";
        if (las3Struct2 != null && dstStruct2 != null && cmnLASCurveListStruct2 != null && cmnLASCurveListStruct2.iCount > 0 && las3Struct2.iRows > 0) {
            for (int i = 0; i < las3Struct2.iRows; ++i) {
                block13: for (int j = 0; j < las3Struct2.iColumns; ++j) {
                    n = -1;
                    for (int k = 0; k < cmnLASCurveListStruct2.iCount; ++k) {
                        if (!las3Struct2.sCurves[j][0].equals(cmnLASCurveListStruct2.stItem[k].sMnemonic)) continue;
                        n = k;
                    }
                    if (n <= -1) continue;
                    string = new String(cmnLASCurveListStruct2.stItem[n].sMnemonic);
                    string2 = new String(las3Struct2.sData[i][j]);
                    n2 = dstStandardTools.getRow(1, string);
                    switch (n2) {
                        case 0: {
                            if (string2.equals(string3)) continue block13;
                            string4 = new String(string2);
                            continue block13;
                        }
                        case 1: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            n7 = (int)cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 2: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            d2 = cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 3: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            d3 = cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 4: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            d4 = cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 5: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            d5 = cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 6: {
                            if (string2.equals(string3) || !cmnString.isNumeric(string2)) continue block13;
                            d6 = cmnString.stringToDouble(string2);
                            continue block13;
                        }
                        case 7: {
                            if (string2.equals(string3)) continue block13;
                            string5 = new String(string2);
                            continue block13;
                        }
                        case 8: {
                            if (string2.equals(string3)) continue block13;
                            string6 = new String(string2);
                            continue block13;
                        }
                        case 9: {
                            if (string2.equals(string3)) continue block13;
                            string7 = new String(string2);
                        }
                    }
                }
                if (string4.equals(dstStandardTools.DATA_TYPE[0])) {
                    if (string7.equals(dstStruct.ANNOTATION[0].trim())) {
                        dstStruct2.dSummary[0][0] = d2;
                        dstStruct2.dSummary[0][1] = d3;
                        dstStruct2.dSummary[0][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[1].trim())) {
                        dstStruct2.dSummary[1][0] = d2;
                        dstStruct2.dSummary[1][1] = d3;
                        dstStruct2.dSummary[1][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[2].trim())) {
                        dstStruct2.dSummary[2][0] = d2;
                        dstStruct2.dSummary[2][1] = d3;
                        dstStruct2.dSummary[2][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[3].trim())) {
                        dstStruct2.dSummary[3][0] = d2;
                        dstStruct2.dSummary[3][1] = d3;
                        dstStruct2.dSummary[3][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[4].trim())) {
                        dstStruct2.dSummary[4][0] = d2;
                        dstStruct2.dSummary[4][1] = d3;
                        dstStruct2.dSummary[4][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[5].trim())) {
                        dstStruct2.dSummary[5][0] = d2;
                        dstStruct2.dSummary[5][1] = d3;
                        dstStruct2.dSummary[5][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[6].trim())) {
                        dstStruct2.dSummary[6][0] = d2;
                        dstStruct2.dSummary[6][1] = d3;
                        dstStruct2.dSummary[6][2] = d4;
                    }
                    if (string7.equals(dstStruct.ANNOTATION[7].trim())) {
                        dstStruct2.dSummary[7][0] = d2;
                        dstStruct2.dSummary[7][1] = d3;
                        dstStruct2.dSummary[7][2] = d4;
                    }
                }
                if (string4.equals(dstStandardTools.DATA_TYPE[1]) && dstStruct2.iRecovery > 0 && n3 < dstStruct2.iRecovery) {
                    dstStruct2.sRecovery[n3][0] = new String(string5);
                    dstStruct2.sRecovery[n3][1] = new String(string7);
                    dstStruct2.sRecovery[n3][2] = new String(string6);
                    ++n3;
                }
                if (string4.equals(dstStandardTools.DATA_TYPE[2]) && dstStruct2.iGasRates > 0 && n4 < dstStruct2.iGasRates) {
                    dstStruct2.dGasRates[n4][0] = n7;
                    dstStruct2.dGasRates[n4][1] = d2;
                    dstStruct2.dGasRates[n4][2] = d6;
                    dstStruct2.dGasRates[n4][3] = d3;
                    dstStruct2.dGasRates[n4][4] = d5;
                    ++n4;
                }
                if (string4.equals(dstStandardTools.DATA_TYPE[3]) && dstStruct2.iShut_In_1 > 0 && n5 < dstStruct2.iShut_In_1) {
                    dstStruct2.dShut_In_1[n5][0] = d2;
                    dstStruct2.dShut_In_1[n5][1] = d3;
                    dstStruct2.dShut_In_1[n5][2] = d4;
                    ++n5;
                }
                if (string4.equals(dstStandardTools.DATA_TYPE[4]) && dstStruct2.iShut_In_2 > 0 && n6 < dstStruct2.iShut_In_2) {
                    dstStruct2.dShut_In_2[n6][0] = d2;
                    dstStruct2.dShut_In_2[n6][1] = d3;
                    dstStruct2.dShut_In_2[n6][2] = d4;
                    ++n6;
                }
                string4 = new String("");
                n7 = -1;
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                d5 = 0.0;
                d6 = 0.0;
                string5 = new String("0.0");
                string6 = new String("0.0");
                string7 = new String("");
            }
        }
        return dstStruct2;
    }

    public static las3Struct setData(dstStruct dstStruct2, double d) {
        las3Struct las3Struct2 = null;
        if (dstStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 7;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadDSTData.addParameters(dstStruct2, las3Struct2);
            las3Struct2 = las3LoadDSTData.addCurves(dstStruct2, las3Struct2, d);
        }
        return las3Struct2;
    }

    public static las3Struct addParameters(dstStruct dstStruct2, las3Struct las3Struct2) {
        String[] stringArray = new String[]{"", ""};
        int n = 0;
        if (dstStruct2 != null && las3Struct2 != null) {
            int n2;
            las3Struct2.iParamRows = 81;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (n2 = 0; n2 < las3Struct2.iParamRows; ++n2) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sParams[n2][i] = new String("");
                }
            }
            for (n2 = 0; n2 < 76; ++n2) {
                las3Struct2.sParams[n][0] = new String(PARAM[n2][0]);
                las3Struct2.sParams[n][1] = new String(PARAM[n2][1]);
                las3Struct2.sParams[n][2] = new String("");
                las3Struct2.sParams[n][3] = new String(PARAM[n2][3]);
                las3Struct2.sParams[n][4] = new String(PARAM[n2][4]);
                switch (n2) {
                    case 0: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sID);
                        break;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sFormation);
                        break;
                    }
                    case 4: {
                        if (dstStruct2.iDeviated == 0) {
                            las3Struct2.sParams[n][2] = new String("NO");
                            break;
                        }
                        las3Struct2.sParams[n][2] = new String("YES");
                        break;
                    }
                    case 2: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.depthStart);
                        break;
                    }
                    case 3: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.depthEnd);
                        break;
                    }
                    case 5: {
                        if (!(dstStruct2.dWhipstock > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dWhipstock);
                        break;
                    }
                    case 6: {
                        dstStruct2.serialNo = las3LoadDSTData.removeChars(dstStruct2.serialNo, ':');
                        dstStruct2.serialNo = las3LoadDSTData.replaceChars(dstStruct2.serialNo, '.', ',');
                        dstStruct2.serialNo = las3LoadDSTData.replaceChars(dstStruct2.serialNo, '\n', ' ');
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.serialNo);
                        break;
                    }
                    case 7: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sReading);
                        break;
                    }
                    case 8: {
                        if (!(dstStruct2.dPressure > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dPressure);
                        break;
                    }
                    case 9: {
                        if (!(dstStruct2.depth > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.depth);
                        break;
                    }
                    case 10: {
                        dstStruct2.sTestRemark = las3LoadDSTData.removeChars(dstStruct2.sTestRemark, ':');
                        dstStruct2.sTestRemark = las3LoadDSTData.replaceChars(dstStruct2.sTestRemark, '.', ',');
                        dstStruct2.sTestRemark = las3LoadDSTData.replaceChars(dstStruct2.sTestRemark, '\n', ' ');
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sTestRemark);
                        break;
                    }
                    case 11: {
                        if (!(dstStruct2.diameter_hole > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.diameter_hole);
                        break;
                    }
                    case 12: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sCondition_hole);
                        break;
                    }
                    case 23: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sMudType);
                        break;
                    }
                    case 24: {
                        if (!(dstStruct2.dMudWeight > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dMudWeight);
                        break;
                    }
                    case 25: {
                        if (!(dstStruct2.dViscosity > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dViscosity);
                        break;
                    }
                    case 26: {
                        if (!(dstStruct2.dWaterLoss > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dWaterLoss);
                        break;
                    }
                    case 27: {
                        if (!(dstStruct2.dOHM_M > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dOHM_M);
                        break;
                    }
                    case 28: {
                        if (!(dstStruct2.dSalinity > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dSalinity);
                        break;
                    }
                    case 29: {
                        if (!(dstStruct2.dFilterCake > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dFilterCake);
                        break;
                    }
                    case 30: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sCushionType);
                        break;
                    }
                    case 31: {
                        if (!(dstStruct2.dCushionLength > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dCushionLength);
                        break;
                    }
                    case 32: {
                        if (!(dstStruct2.dCushionVolume > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dCushionVolume);
                        break;
                    }
                    case 33: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sGasCushionType);
                        break;
                    }
                    case 34: {
                        if (!(dstStruct2.dGasCushionPres > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dGasCushionPres);
                        break;
                    }
                    case 35: {
                        if (!(dstStruct2.dOil_API > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dOil_API);
                        break;
                    }
                    case 36: {
                        if (!(dstStruct2.dWaterSalinity > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dWaterSalinity);
                        break;
                    }
                    case 13: {
                        if (!(dstStruct2.dCapacity > 0.0)) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dCapacity);
                        break;
                    }
                    case 14: {
                        las3Struct2.sParams[n][2] = new String(dstStruct2.sDateStart);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        break;
                    }
                    case 15: {
                        las3Struct2.sParams[n][2] = new String(dstStruct2.sDateEnd);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        break;
                    }
                    case 16: {
                        las3Struct2.sParams[n][2] = new String(dstStruct2.sDateCalib);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        break;
                    }
                    case 17: {
                        las3Struct2.sParams[n][2] = new String(dstStruct2.sTimeOnBtm);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        break;
                    }
                    case 18: {
                        las3Struct2.sParams[n][2] = new String(dstStruct2.sTimeOffBtm);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        break;
                    }
                    case 19: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sTestType);
                        break;
                    }
                    case 20: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sUnitNo);
                        break;
                    }
                    case 21: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sCompany);
                        break;
                    }
                    case 22: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sTester);
                        break;
                    }
                    case 73: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dLength);
                        break;
                    }
                    case 74: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dVolume);
                        break;
                    }
                    case 75: {
                        dstStruct2.sComments = las3LoadDSTData.removeChars(dstStruct2.sComments, ':');
                        dstStruct2.sComments = las3LoadDSTData.replaceChars(dstStruct2.sComments, '.', ',');
                        dstStruct2.sComments = las3LoadDSTData.replaceChars(dstStruct2.sComments, '\n', ' ');
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.sComments);
                        break;
                    }
                    case 37: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.m2);
                        break;
                    }
                    case 38: {
                        if (dstStruct2.q == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.q);
                        break;
                    }
                    case 39: {
                        if (dstStruct2.h == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.h);
                        break;
                    }
                    case 40: {
                        if (dstStruct2.mu == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.mu);
                        break;
                    }
                    case 41: {
                        if (dstStruct2.dPressure == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dPressure);
                        break;
                    }
                    case 42: {
                        if (dstStruct2.degF == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.degF);
                        break;
                    }
                    case 43: {
                        if (dstStruct2.beta == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.beta);
                        break;
                    }
                    case 44: {
                        if (dstStruct2.Z == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.Z);
                        break;
                    }
                    case 45: {
                        if (dstStruct2.KHU == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.KHU);
                        break;
                    }
                    case 46: {
                        if (dstStruct2.KH == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.KH);
                        break;
                    }
                    case 47: {
                        if (dstStruct2.K == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.K);
                        break;
                    }
                    case 48: {
                        if (dstStruct2.P2 == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.P2);
                        break;
                    }
                    case 49: {
                        if (dstStruct2.dSummary[5][1] == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dSummary[5][1]);
                        break;
                    }
                    case 50: {
                        if (dstStruct2.Tf == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.Tf);
                        break;
                    }
                    case 51: {
                        if (dstStruct2.rw == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.rw);
                        break;
                    }
                    case 52: {
                        if (dstStruct2.re == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.re);
                        break;
                    }
                    case 53: {
                        if (dstStruct2.phi == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.phi);
                        break;
                    }
                    case 54: {
                        if (dstStruct2.c == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.c);
                        break;
                    }
                    case 55: {
                        if (dstStruct2.G == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.G);
                        break;
                    }
                    case 56: {
                        if (dstStruct2.Pwfc == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.Pwfc);
                        break;
                    }
                    case 57: {
                        if (dstStruct2.DR == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.DR);
                        break;
                    }
                    case 58: {
                        if (dstStruct2.S == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.S);
                        break;
                    }
                    case 59: {
                        if (dstStruct2.dPs == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dPs);
                        break;
                    }
                    case 60: {
                        if (dstStruct2.dPt == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.dPt);
                        break;
                    }
                    case 61: {
                        if (dstStruct2.PI == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.PI);
                        break;
                    }
                    case 62: {
                        if (dstStruct2.RI == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.RI);
                        break;
                    }
                    case 63: {
                        if (dstStruct2.qs == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.qs);
                        break;
                    }
                    case 64: {
                        if (dstStruct2.qAOF == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.qAOF);
                        break;
                    }
                    case 65: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.lpt1);
                        break;
                    }
                    case 66: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.upt1);
                        break;
                    }
                    case 67: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.m1);
                        break;
                    }
                    case 68: {
                        if (dstStruct2.P1 == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.P1);
                        break;
                    }
                    case 69: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.lpt2);
                        break;
                    }
                    case 70: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.upt2);
                        break;
                    }
                    case 71: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.m2);
                        break;
                    }
                    case 72: {
                        if (dstStruct2.P2 == 0.0) break;
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.P2);
                    }
                }
                ++n;
            }
            for (n2 = 0; n2 < 5; ++n2) {
                las3Struct2.sParams[n][0] = new String(PARAM2[n2][0]);
                las3Struct2.sParams[n][3] = new String(PARAM2[n2][1]);
                las3Struct2.sParams[n][4] = new String("F");
                switch (n2) {
                    case 0: {
                        switch (dstStruct2.iDSTType) {
                            case 0: {
                                las3Struct2.sParams[n][2] = new String("FLUID");
                                break;
                            }
                            case 1: {
                                las3Struct2.sParams[n][2] = new String("GAS");
                            }
                        }
                        break;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.iRecovery);
                        break;
                    }
                    case 2: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.iGasRates);
                        break;
                    }
                    case 3: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.iShut_In_1);
                        break;
                    }
                    case 4: {
                        las3Struct2.sParams[n][2] = new String("" + dstStruct2.iShut_In_2);
                    }
                }
                ++n;
            }
        }
        return las3Struct2;
    }

    public static las3Struct addCurves(dstStruct dstStruct2, las3Struct las3Struct2, double d) {
        int n;
        int n2;
        int n3 = 0;
        String string = "";
        las3Struct2.iCurveRows = 10;
        las3Struct2.iCurveCols = 6;
        las3Struct2.sCurves = new String[las3Struct2.iCurveRows][las3Struct2.iCurveCols];
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 6; ++n) {
                las3Struct2.sCurves[n3][n] = new String("");
            }
            las3Struct2.sCurves[n3][0] = new String(dstStandardTools.CURVES[n2][1]);
            las3Struct2.sCurves[n3][1] = new String(dstStandardTools.CURVES[n2][3]);
            las3Struct2.sCurves[n3][3] = new String(dstStandardTools.CURVES[n2][2]);
            las3Struct2.sCurves[n3][4] = new String(dstStandardTools.CURVES[n2][4]);
            ++n3;
        }
        las3Struct2.iRows = 8 + dstStruct2.iRecovery + dstStruct2.iGasRates + dstStruct2.iShut_In_1 + dstStruct2.iShut_In_2;
        las3Struct2.iColumns = las3Struct2.iCurveRows;
        las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
        for (n2 = 0; n2 < las3Struct2.iRows; ++n2) {
            for (n = 0; n < las3Struct2.iColumns; ++n) {
                las3Struct2.sData[n2][n] = new String("" + d);
            }
        }
        n3 = 0;
        if (dstStruct2.iRecovery > 0) {
            for (n = 0; n < dstStruct2.iRecovery; ++n) {
                las3Struct2.sData[n3][0] = new String(dstStandardTools.DATA_TYPE[1]);
                las3Struct2.sData[n3][7] = new String(dstStruct2.sRecovery[n][0]);
                las3Struct2.sData[n3][9] = new String(dstStruct2.sRecovery[n][1]);
                las3Struct2.sData[n3][8] = new String(dstStruct2.sRecovery[n][2]);
                ++n3;
            }
        }
        if (dstStruct2.iGasRates > 0) {
            for (n = 0; n < dstStruct2.iGasRates; ++n) {
                las3Struct2.sData[n3][0] = new String(dstStandardTools.DATA_TYPE[2]);
                las3Struct2.sData[n3][1] = new String("" + (int)dstStruct2.dGasRates[n][0]);
                las3Struct2.sData[n3][2] = new String("" + dstStruct2.dGasRates[n][1]);
                las3Struct2.sData[n3][6] = new String("" + dstStruct2.dGasRates[n][2]);
                las3Struct2.sData[n3][3] = new String("" + dstStruct2.dGasRates[n][3]);
                las3Struct2.sData[n3][5] = new String("" + dstStruct2.dGasRates[n][4]);
                las3Struct2.sData[n3][9] = new String(dstStandardTools.DATA_TYPE[2]);
                ++n3;
            }
        }
        for (n = 0; n < 8; ++n) {
            las3Struct2.sData[n3][0] = new String(dstStandardTools.DATA_TYPE[0]);
            las3Struct2.sData[n3][2] = new String("" + dstStruct2.dSummary[n][0]);
            las3Struct2.sData[n3][3] = new String("" + dstStruct2.dSummary[n][1]);
            las3Struct2.sData[n3][4] = new String("" + dstStruct2.dSummary[n][2]);
            las3Struct2.sData[n3][9] = new String(dstStruct.ANNOTATION[n].trim());
            ++n3;
        }
        for (n = 0; n < dstStruct2.iShut_In_1; ++n) {
            las3Struct2.sData[n3][0] = new String(dstStandardTools.DATA_TYPE[3]);
            las3Struct2.sData[n3][2] = new String("" + dstStruct2.dShut_In_1[n][0]);
            las3Struct2.sData[n3][3] = new String("" + dstStruct2.dShut_In_1[n][1]);
            las3Struct2.sData[n3][4] = new String("" + dstStruct2.dShut_In_1[n][2]);
            las3Struct2.sData[n3][9] = new String(dstStandardTools.DATA_TYPE[3]);
            ++n3;
        }
        for (n = 0; n < dstStruct2.iShut_In_2; ++n) {
            las3Struct2.sData[n3][0] = new String(dstStandardTools.DATA_TYPE[4]);
            las3Struct2.sData[n3][2] = new String("" + dstStruct2.dShut_In_2[n][0]);
            las3Struct2.sData[n3][3] = new String("" + dstStruct2.dShut_In_2[n][1]);
            las3Struct2.sData[n3][4] = new String("" + dstStruct2.dShut_In_2[n][2]);
            las3Struct2.sData[n3][9] = new String(dstStandardTools.DATA_TYPE[4]);
            ++n3;
        }
        return las3Struct2;
    }

    public static String removeChars(String string, char c) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null && string.length() > 0) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == c) continue;
                string2 = new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    public static String replaceChars(String string, char c, char c2) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null && string.length() > 0) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                string2 = cArray[i] == c ? new String(string2 + c2) : new String(string2 + cArray[i]);
            }
        }
        return string2;
    }
}

