/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnLASCurveListStruct;
import cmn.cmnString;
import iqstrat.iqstratControlStandardTools;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratControlUtility;
import iqstrat.iqstratTracksStruct;
import las.lasStandardTools;
import las3.las3Constants;
import las3.las3Struct;

public class las3LoadControlData {
    public static final int _NONE = -1;
    public static final int _IQ_KGS = 0;
    public static final int _IQSTRT = 1;
    public static final int _IQSTOP = 2;
    public static final int _IQSCLE = 3;
    public static final int _IQGRP = 4;
    public static final int _IQORDR = 5;
    public static final int _IQSHMIN = 6;
    public static final int _IQSHLY = 7;
    public static final int _IQSH = 8;
    public static final int _IQSHHOT = 9;
    public static final int _IQSHMAX = 10;
    public static final int _IQTHN = 11;
    public static final int _IQOHM = 12;
    public static final int _IQOHM_L = 13;
    public static final int _IQOHM_U = 14;
    public static final int _IQPHI = 15;
    public static final int _IQPHI_L = 16;
    public static final int _IQPHI_U = 17;
    public static final int _GRNL = 18;
    public static final int _GRNU = 19;
    public static final int _GRL = 20;
    public static final int _GRU = 21;
    public static final int _NEUTL = 22;
    public static final int _NEUTU = 23;
    public static final int _NPHIL = 24;
    public static final int _NPHIU = 25;
    public static final int _PARAM_ROWS = 26;
    public static final int _PARAM_COLS = 4;
    public static final String[][] PARAM = new String[][]{{"IQKGS", "Profile Web App Saved Data Indicator", "", ""}, {"IQSTRT", "Starting Display Depth", "F", "F"}, {"IQSTOP", "Ending Display Depth", "F", "F"}, {"IQSCLE", "Plot Scale Feet/Inch", "FT/IN", "F"}, {"IQGRP", "LAS, ROCK or HORIZON", "", "S"}, {"IQORDR", "DEFAULT or MODIFIED", "", "S"}, {"IQSHMIN", "Gamma Ray Minimum Value (Default)", "API", "F"}, {"IQSHLY", "Gamma Ray Shaly Value (Default)", "API", "F"}, {"IQSH", "Gamma Ray Shale Value (Default)", "API", "F"}, {"IQSHHOT", "Gamma Ray Hot Shale Value (Default)", "API", "F"}, {"IQSHMAX", "Gamma Ray Maximum Value (Default)", "API", "F"}, {"IQTHN", "Thin Porosity Track Curve Mnemonic", "", "S"}, {"IQOHM", "Conductivity Image Track Curve Mnemonic", "", "S"}, {"IQOHM_L", "Conductivity Image Track Minimum Value", "MMHO/M", "F"}, {"IQOHM_U", "Conductivity Image Track Maximum Value", "MMHO/M", "F"}, {"IQPHI", "Porosity Image Track Curve Mnemonic", "", "S"}, {"IQPHI_L", "Porosity Image Track Minimum Value", "PU", "F"}, {"IQPHI_U", "Porosity Image Track Maximum Value", "PU", "F"}, {"GRNL", "% GR Count Lower Limit", "%", "F"}, {"GRNU", "% GR Count Upper Limit", "%", "F"}, {"GRL", "GR (API) Lower Limit", "API", "F"}, {"GRU", "GR (API) Upper Limit", "API", "F"}, {"NEUTL", "% Neutron Count Upper PHI Limit", "%", "F"}, {"NEUTU", "% Neutron Count Lower PHI Limit", "%", "F"}, {"NPHIL", "Neutron Porosity Lower Limit", "PU", "F"}, {"NPHIU", "Neutron Porosity Upper Limit", "PU", "F"}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;
    public static final int _SOURCE = 1;
    public static final int _TYPE = 2;
    public static final int _DESCR = 3;
    public static final int _STATUS = 4;

    public static iqstratControlStruct getData(las3Struct las3Struct2) {
        iqstratControlStruct iqstratControlStruct2 = new iqstratControlStruct();
        int n = -1;
        int n2 = 0;
        String string = "";
        if (las3Struct2 != null) {
            for (int i = 0; i < las3Struct2.iParamRows; ++i) {
                n = -1;
                block26: for (int j = 0; j < 26; ++j) {
                    if (!las3Struct2.sParams[i][0].toUpperCase().equals(PARAM[j][0])) continue;
                    n = j;
                    switch (n) {
                        case -1: {
                            continue block26;
                        }
                        case 0: {
                            iqstratControlStruct2.sKGS = new String("YES");
                            continue block26;
                        }
                        case 1: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[i][2])) continue block26;
                            iqstratControlStruct2.depthStart = cmnString.stringToDouble(las3Struct2.sParams[i][2]);
                            continue block26;
                        }
                        case 2: {
                            if (!cmnString.isNumeric(las3Struct2.sParams[i][2])) continue block26;
                            iqstratControlStruct2.depthEnd = cmnString.stringToDouble(las3Struct2.sParams[i][2]);
                            continue block26;
                        }
                        case 3: {
                            int n3;
                            if (!cmnString.isNumeric(las3Struct2.sParams[i][2])) continue block26;
                            for (n3 = 0; n3 < iqstratTracksStruct.SCALE.length; ++n3) {
                                n2 = cmnString.stringToInt(las3Struct2.sParams[i][2]);
                                if (n2 != iqstratTracksStruct.SCALE[n3]) continue;
                                iqstratControlStruct2.iScale = n3;
                            }
                            continue block26;
                        }
                        case 4: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (string.equals("ALL")) {
                                iqstratControlStruct2.iConfig = 0;
                            }
                            if (string.equals("LAS")) {
                                iqstratControlStruct2.iConfig = 1;
                            }
                            if (string.equals("ROCK")) {
                                iqstratControlStruct2.iConfig = 2;
                            }
                            if (!string.equals("HORIZON")) continue block26;
                            iqstratControlStruct2.iConfig = 3;
                            continue block26;
                        }
                        case 5: {
                            string = new String(las3Struct2.sParams[i][2]);
                            iqstratControlStruct2.iPanel = 0;
                            if (!string.equals("MODIFIED")) continue block26;
                            iqstratControlStruct2.iPanel = 1;
                            continue block26;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            continue block26;
                        }
                        case 11: {
                            string = new String(las3Struct2.sParams[i][2]);
                            iqstratControlStruct2.iThin = 1;
                            if (string.equals("NPHI")) {
                                iqstratControlStruct2.iTHINPHI = 0;
                            }
                            if (string.equals("AVERAGE")) {
                                iqstratControlStruct2.iTHINPHI = 1;
                            }
                            if (string.equals("DPHI")) {
                                iqstratControlStruct2.iTHINPHI = 3;
                            }
                            if (!string.equals("SPHI")) continue block26;
                            iqstratControlStruct2.iTHINPHI = 2;
                            continue block26;
                        }
                        case 12: {
                            int n3;
                            string = new String(las3Struct2.sParams[i][2]);
                            iqstratControlStruct2.iOHM = 1;
                            for (n3 = 0; n3 < 78; ++n3) {
                                if (!string.equals(lasStandardTools.LAS_TOOLS[n3][1])) continue;
                                iqstratControlStruct2.iOHMTool = n3;
                            }
                            continue block26;
                        }
                        case 13: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dOHMMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 14: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dOHMMax = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 15: {
                            int n3;
                            string = new String(las3Struct2.sParams[i][2]);
                            iqstratControlStruct2.iPHI = 1;
                            for (n3 = 0; n3 < 78; ++n3) {
                                if (!string.equals(lasStandardTools.LAS_TOOLS[n3][1])) continue;
                                iqstratControlStruct2.iPHITool = n3;
                            }
                            continue block26;
                        }
                        case 16: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dPHIMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 17: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dPHIMax = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 18: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dGRNMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 19: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dGRNMax = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 20: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dGRCMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 21: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dGRCMax = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 22: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dNEUTMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 23: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dNEUTMax = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 24: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dNPHICMin = cmnString.stringToDouble(string);
                            continue block26;
                        }
                        case 25: {
                            string = new String(las3Struct2.sParams[i][2]);
                            if (!cmnString.isNumeric(string)) continue block26;
                            iqstratControlStruct2.dNPHICMax = cmnString.stringToDouble(string);
                        }
                    }
                }
            }
        }
        return iqstratControlStruct2;
    }

    public static iqstratControlStruct loadData(double d, las3Struct las3Struct2, cmnLASCurveListStruct cmnLASCurveListStruct2, iqstratControlStruct iqstratControlStruct2) {
        iqstratControlStruct iqstratControlStruct3 = null;
        String string = "0";
        int n = -1;
        if (las3Struct2 != null && iqstratControlStruct2 != null && cmnLASCurveListStruct2 != null) {
            iqstratControlStruct3 = iqstratControlUtility.copy(iqstratControlStruct2);
            iqstratControlStruct2.delete();
            iqstratControlStruct2 = null;
            if (iqstratControlStruct3 == null) {
                iqstratControlStruct3 = new iqstratControlStruct();
            }
            if (las3Struct2.iCurveRows > 0) {
                iqstratControlStruct3.iTracks = new int[las3Struct2.iRows];
                iqstratControlStruct3.iCount = 0;
                for (int i = 0; i < las3Struct2.iRows; ++i) {
                    for (int j = 0; j < las3Struct2.iColumns; ++j) {
                        n = -1;
                        for (int k = 0; k < cmnLASCurveListStruct2.iCount; ++k) {
                            if (!las3Struct2.sCurves[j][0].equals(cmnLASCurveListStruct2.stItem[k].sMnemonic)) continue;
                            n = k;
                        }
                        if (n <= -1) continue;
                        iqstratControlStruct3 = las3LoadControlData.addControlData(d, cmnLASCurveListStruct2.stItem[n].sMnemonic, las3Struct2.sData[i][j], iqstratControlStruct3);
                    }
                }
            }
        }
        return iqstratControlStruct3;
    }

    public static iqstratControlStruct addControlData(double d, String string, String string2, iqstratControlStruct iqstratControlStruct2) {
        int n = iqstratControlStandardTools.getRow(1, string);
        String string3 = "";
        String string4 = new String("" + d);
        if (iqstratControlStruct2 != null) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    for (int i = 0; i < 72; ++i) {
                        if (!string2.equals(iqstratTracksStruct.TRACK[i][3])) continue;
                        iqstratControlStruct2.iTracks[iqstratControlStruct2.iCount] = i;
                        ++iqstratControlStruct2.iCount;
                    }
                    break;
                }
            }
        }
        return iqstratControlStruct2;
    }

    public static las3Struct setData(iqstratControlStruct iqstratControlStruct2, double d) {
        las3Struct las3Struct2 = null;
        if (iqstratControlStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 9;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadControlData.addParameters(iqstratControlStruct2, las3Struct2);
            las3Struct2 = las3LoadControlData.addCurves(iqstratControlStruct2, las3Struct2, d);
        }
        return las3Struct2;
    }

    public static las3Struct addParameters(iqstratControlStruct iqstratControlStruct2, las3Struct las3Struct2) {
        String string = "";
        if (iqstratControlStruct2 != null && las3Struct2 != null) {
            int n;
            las3Struct2.iParamRows = 26;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (n = 0; n < las3Struct2.iParamRows; ++n) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sParams[n][i] = new String("");
                }
            }
            block42: for (n = 0; n < las3Struct2.iParamRows; ++n) {
                las3Struct2.sParams[n][0] = new String(PARAM[n][0]);
                las3Struct2.sParams[n][3] = new String(PARAM[n][1]);
                las3Struct2.sParams[n][1] = new String(PARAM[n][2]);
                las3Struct2.sParams[n][4] = new String(PARAM[n][3]);
                switch (n) {
                    case 0: {
                        continue block42;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.depthStart);
                        continue block42;
                    }
                    case 2: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.depthEnd);
                        continue block42;
                    }
                    case 3: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratTracksStruct.SCALE[iqstratControlStruct2.iScale]);
                        continue block42;
                    }
                    case 4: {
                        switch (iqstratControlStruct2.iConfig) {
                            case 0: {
                                string = new String("ALL");
                                break;
                            }
                            case 1: {
                                string = new String("LAS");
                                break;
                            }
                            case 2: {
                                string = new String("ROCK");
                                break;
                            }
                            case 3: {
                                string = new String("HORIZON");
                            }
                        }
                        las3Struct2.sParams[n][2] = new String(string);
                        continue block42;
                    }
                    case 5: {
                        string = "DEFAULT";
                        if (iqstratControlStruct2.iPanel != 0) {
                            string = "MODIFIED";
                        }
                        las3Struct2.sParams[n][2] = new String(string);
                        continue block42;
                    }
                    case 6: {
                        las3Struct2.sParams[n][2] = new String("0.0");
                        continue block42;
                    }
                    case 7: {
                        las3Struct2.sParams[n][2] = new String("60.0");
                        continue block42;
                    }
                    case 8: {
                        las3Struct2.sParams[n][2] = new String("70.0");
                        continue block42;
                    }
                    case 9: {
                        las3Struct2.sParams[n][2] = new String("100.0");
                        continue block42;
                    }
                    case 10: {
                        las3Struct2.sParams[n][2] = new String("150.0");
                        continue block42;
                    }
                    case 11: {
                        if (iqstratControlStruct2.iThin != 1) continue block42;
                        switch (iqstratControlStruct2.iTHINPHI) {
                            case 0: {
                                string = "NPHI";
                                break;
                            }
                            case 1: {
                                string = "AVERAGE";
                                break;
                            }
                            case 2: {
                                string = "SPHI";
                                break;
                            }
                            case 3: {
                                string = "DPHI";
                                break;
                            }
                            default: {
                                string = "";
                            }
                        }
                        las3Struct2.sParams[n][2] = new String(string);
                        continue block42;
                    }
                    case 12: {
                        if (iqstratControlStruct2.iOHM != 1) continue block42;
                        string = lasStandardTools.LAS_TOOLS[iqstratControlStruct2.iOHMTool][1];
                        las3Struct2.sParams[n][2] = new String(string);
                        string = lasStandardTools.LAS_TOOLS[iqstratControlStruct2.iOHMTool][2];
                        las3Struct2.sParams[n][3] = new String(string);
                        continue block42;
                    }
                    case 13: {
                        if (iqstratControlStruct2.iOHM != 1) continue block42;
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dOHMMin);
                        continue block42;
                    }
                    case 14: {
                        if (iqstratControlStruct2.iOHM != 1) continue block42;
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dOHMMax);
                        continue block42;
                    }
                    case 15: {
                        if (iqstratControlStruct2.iPHI != 1) continue block42;
                        string = lasStandardTools.LAS_TOOLS[iqstratControlStruct2.iPHITool][1];
                        las3Struct2.sParams[n][2] = new String(string);
                        string = lasStandardTools.LAS_TOOLS[iqstratControlStruct2.iPHITool][2];
                        las3Struct2.sParams[n][3] = new String(string);
                        continue block42;
                    }
                    case 16: {
                        if (iqstratControlStruct2.iPHI != 1) continue block42;
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dPHIMin);
                        continue block42;
                    }
                    case 17: {
                        if (iqstratControlStruct2.iPHI != 1) continue block42;
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dPHIMax);
                        continue block42;
                    }
                    case 18: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dGRNMin);
                        continue block42;
                    }
                    case 19: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dGRNMax);
                        continue block42;
                    }
                    case 20: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dGRCMin);
                        continue block42;
                    }
                    case 21: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dGRCMax);
                        continue block42;
                    }
                    case 22: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dNEUTMin);
                        continue block42;
                    }
                    case 23: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dNEUTMax);
                        continue block42;
                    }
                    case 24: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dNPHICMin);
                        continue block42;
                    }
                    case 25: {
                        las3Struct2.sParams[n][2] = new String("" + iqstratControlStruct2.dNPHICMax);
                    }
                }
            }
        }
        return las3Struct2;
    }

    public static las3Struct addCurves(iqstratControlStruct iqstratControlStruct2, las3Struct las3Struct2, double d) {
        int n = 0;
        String string = "";
        if (iqstratControlStruct2 != null && las3Struct2 != null && iqstratControlStruct2.iTracks != null) {
            int n2;
            las3Struct2.iCurveRows = 3;
            las3Struct2.iCurveCols = 6;
            las3Struct2.sCurves = new String[las3Struct2.iCurveRows][las3Struct2.iCurveCols];
            for (n2 = 0; n2 < 3; ++n2) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sCurves[n][i] = new String("");
                }
                las3Struct2.sCurves[n][0] = new String(iqstratControlStandardTools.CURVES[n2][1]);
                las3Struct2.sCurves[n][1] = new String("");
                las3Struct2.sCurves[n][3] = new String(iqstratControlStandardTools.CURVES[n2][2]);
                las3Struct2.sCurves[n][4] = new String("S");
                ++n;
            }
            las3Struct2.iRows = iqstratControlStruct2.iTracks.length;
            las3Struct2.iColumns = las3Struct2.iCurveRows;
            las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
            for (n2 = 0; n2 < iqstratControlStruct2.iTracks.length; ++n2) {
                if (iqstratControlStruct2.iTracks[n2] == -1) continue;
                las3Struct2.sData[n2][0] = new String(iqstratTracksStruct.TRACK[iqstratControlStruct2.iTracks[n2]][1]);
                las3Struct2.sData[n2][1] = new String(iqstratTracksStruct.TRACK[iqstratControlStruct2.iTracks[n2]][2]);
                las3Struct2.sData[n2][2] = new String(iqstratTracksStruct.TRACK[iqstratControlStruct2.iTracks[n2]][3]);
            }
        }
        return las3Struct2;
    }
}

