/*
 * Decompiled with CFR 0.152.
 */
package las3.gui;

import brine.brineListStruct;
import brine.brineStandardTools;
import cmn.cmnLASCurveListStruct;
import cmn.cmnLASCurveStruct;
import cmn.cmnLASCurveUtility;
import cmn.cmnStruct;
import dst.dstStandardTools;
import dst.dstStruct;
import horizon.bio.bioStandardTools;
import horizon.bio.bioStratListStruct;
import horizon.env.envListStruct;
import horizon.env.envStandardTools;
import horizon.regions.regionsListStruct;
import horizon.regions.regionsStandardTools;
import horizon.seq.seqListStruct;
import horizon.seq.seqStandardTools;
import horizon.strat.stratListStruct;
import horizon.strat.stratStandardTools;
import iqstrat.iqstratControlStandardTools;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkStandardTools;
import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratShaleStandardTools;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las.lasStandardTools;
import las3.gui.las3ToolsFrame;
import las3.io.las3ReadFile;
import las3.las3LoadBioData;
import las3.las3LoadBrineData;
import las3.las3LoadControlData;
import las3.las3LoadCoreData;
import las3.las3LoadDSTData;
import las3.las3LoadEnvData;
import las3.las3LoadImageData;
import las3.las3LoadLogData;
import las3.las3LoadPerfData;
import las3.las3LoadPfefferData;
import las3.las3LoadRemarksData;
import las3.las3LoadSeqData;
import las3.las3LoadShaleData;
import las3.las3LoadTopsData;
import las3.las3Map;
import las3.las3Struct;
import las3.las3Utility;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferStandardTools;
import rock.rockDataListStruct;
import rock.rockImagesListStruct;
import rock.rockImagesStandardTools;
import rock.rockStandardTools;

public class las3CurvesLogPanel
extends JPanel
implements ActionListener {
    private Observable notifier = null;
    private iqstratStruct stStruct = null;
    private cmnStruct stCMN = null;
    private las3Struct stLAS3 = null;
    private lasFileDataStruct stLAS = null;
    private double dVersion = 0.0;
    private int iqstrato = -1;
    private static final int OFF = 0;
    private static final int ON = 1;
    private int iAction = 1;
    private int iCurve = -1;
    private int iArray = 0;
    private int iType = -1;
    private String sType = "";
    private String sLabel = "";
    private int iTotal = 0;
    private int iStandard = 0;
    private int[] iSelected = null;
    private cmnLASCurveListStruct stCurves = null;
    private rockDataListStruct stRock = null;
    private las3ToolsFrame pTools = null;
    public static final int _IGNORE = 0;
    public static final int _CHECK = 1;
    public static final int _LAS_TYPE = 0;
    public static final int _CORE_TYPE = 1;
    public static final int _TOPS_TYPE = 2;
    public static final int _PERF_TYPE = 3;
    public static final int _CNTRL_TYPE = 4;
    public static final int _SEQ_TYPE = 5;
    public static final int _FLOW_TYPE = 6;
    public static final int _GEO_TYPE = 13;
    public static final int _SHALE_TYPE = 14;
    public static final int _IMAGES_TYPE = 15;
    public static final int _BRINE_TYPE = 16;
    public static final int _BIO_TYPE = 17;
    public static final int _ENV_TYPE = 18;
    public static final int _DST_TYPE = 19;
    private int iData = 0;
    public static final int _NONE = -1;
    public static final int _VERSION = 0;
    public static final int _WELL = 1;
    public static final int _LOG = 2;
    public static final int _CORE = 3;
    public static final int _DRILLING = 4;
    public static final int _INCLINOMETRY = 5;
    public static final int _TOPS = 6;
    public static final int _TEST = 7;
    public static final int _PERFORATION = 8;
    public static final int _IQ_CONTROL = 9;
    public static final int _IQ_LOG = 10;
    public static final int _IQ_CORE = 11;
    public static final int _IQ_SEQ_STRAT = 12;
    public static final int _IQ_FLOW = 13;
    public static final int _IQ_GEO_REPORT = 15;
    public static final int _IQ_SHALE = 16;
    public static final int _IQ_IMAGES = 17;
    public static final int _IQ_BRINE = 18;
    public static final int _IQ_BIO = 19;
    public static final int _IQ_ENV = 20;
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;
    private JLabel lblCurve = new JLabel();
    private JTextArea txtSelected = new JTextArea();
    private JCheckBox[] cb = null;
    private JButton[] btnMnem = null;
    private JLabel[] lblUnit = null;
    private JLabel[] lblDesc = null;
    private JRadioButton rbOFF = new JRadioButton();
    private JRadioButton rbON = new JRadioButton();

    public las3CurvesLogPanel(Observable observable, iqstratStruct iqstratStruct2, lasFileDataStruct lasFileDataStruct2, double d, int n, las3Struct las3Struct2) {
        try {
            this.notifier = observable;
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.stLAS = lasFileDataStruct2;
            this.stLAS3 = las3Struct2;
            this.dVersion = d;
            this.iqstrato = n;
            if (las3Struct2 != null && las3Struct2.iqstrat > -1) {
                this.iqstrato = -1;
            }
            this.loadData(las3Struct2);
            this.jbInit();
            this.setButtons();
            this.setDefault();
            this.setDefinition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n;
        String string = "0";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "0.0";
        String string6 = "0.0";
        String string7 = "0.0";
        String string8 = "0.0";
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JPanel jPanel14 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JPanel jPanel18 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel[] jPanelArray = null;
        JPanel[] jPanelArray2 = null;
        JPanel[] jPanelArray3 = null;
        JPanel[] jPanelArray4 = null;
        JTextField jTextField = new JTextField();
        JTextField jTextField2 = new JTextField();
        JTextField jTextField3 = new JTextField();
        JTextField jTextField4 = new JTextField();
        JPanel jPanel19 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Start Depth:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "End Depth");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Step Depth");
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Null Value");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        this.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(350, 10));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel19.setLayout(new GridLayout());
        this.rbOFF.setFont(new Font("Dialog", 1, 11));
        this.rbOFF.setHorizontalAlignment(0);
        this.rbOFF.setText("Do NOT Add this Data");
        this.rbOFF.addActionListener(this);
        this.rbON.setFont(new Font("Dialog", 1, 11));
        this.rbON.setHorizontalAlignment(0);
        this.rbON.setSelected(true);
        this.rbON.setText("Add this Data");
        this.rbON.addActionListener(this);
        jPanel3.setLayout(new GridLayout());
        if (this.stLAS != null) {
            string5 = new String("" + this.stLAS.depthStart);
            string6 = new String("" + this.stLAS.depthEnd);
            string7 = new String("" + this.stLAS.depthStep);
            string8 = new String("" + this.stLAS.dNull);
        }
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(titledBorder);
        jTextField.setEditable(false);
        jTextField.setText(string5);
        jTextField.setHorizontalAlignment(11);
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(titledBorder2);
        jTextField2.setEditable(false);
        jTextField2.setText(string6);
        jTextField2.setHorizontalAlignment(11);
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(titledBorder3);
        jTextField3.setEditable(false);
        jTextField3.setText(string7);
        jTextField3.setHorizontalAlignment(11);
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(titledBorder4);
        jTextField4.setEditable(false);
        jTextField4.setText(string8);
        jTextField4.setHorizontalAlignment(11);
        jPanel8.setLayout(new BorderLayout());
        jPanel15.setPreferredSize(new Dimension(21, 25));
        jLabel4.setFont(new Font("Dialog", 1, 11));
        jLabel4.setPreferredSize(new Dimension(7, 15));
        jLabel4.setText("X");
        jPanel16.setLayout(new BorderLayout());
        jLabel5.setFont(new Font("Dialog", 1, 11));
        jLabel5.setPreferredSize(new Dimension(120, 15));
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setText("MNEM   ");
        jPanel17.setLayout(new BorderLayout());
        jLabel6.setFont(new Font("Dialog", 1, 11));
        jLabel6.setText(".UNITS   ");
        jLabel7.setFont(new Font("Dialog", 1, 11));
        jLabel7.setText(": DESCRIPTION");
        jPanel9.setLayout(new BorderLayout());
        this.iTotal = 0;
        if (this.stCurves != null) {
            this.sLabel = this.stLAS3.iArray > 0 ? new String("~" + this.stLAS3.sType + "_Definition[" + this.stLAS3.iArray + "]") : new String("~" + this.stLAS3.sType + "_Definition");
            this.iTotal = this.stCurves.iCount;
            this.lblCurve.setText(this.sLabel);
            switch (this.iData) {
                case 0: {
                    this.iStandard = 78;
                    break;
                }
                case 1: {
                    this.iStandard = 45;
                    break;
                }
                case 2: {
                    this.iStandard = 20;
                    break;
                }
                case 5: {
                    this.iStandard = 4;
                    break;
                }
                case 18: {
                    this.iStandard = 11;
                    break;
                }
                case 3: {
                    this.iStandard = 3;
                    break;
                }
                case 19: {
                    this.iStandard = 10;
                    break;
                }
                case 4: {
                    this.iStandard = 3;
                    break;
                }
                case 17: {
                    this.iStandard = 36;
                    break;
                }
                case 6: {
                    this.iStandard = 41;
                    break;
                }
                case 13: {
                    this.iStandard = 4;
                    break;
                }
                case 14: {
                    this.iStandard = 7;
                    break;
                }
                case 15: {
                    this.iStandard = 14;
                    break;
                }
                case 16: {
                    this.iStandard = 78;
                }
            }
            this.iSelected = new int[this.iStandard];
            for (n = 0; n < this.iStandard; ++n) {
                this.iSelected[n] = -1;
            }
        }
        if (this.iTotal > 0) {
            if (this.iTotal > 11) {
                jPanel18.setLayout(new GridLayout(this.iTotal, 1));
                jPanel18.setPreferredSize(new Dimension(240, 30 * this.iTotal));
            } else {
                jPanel18.setLayout(new GridLayout(11, 1));
                jPanel18.setPreferredSize(new Dimension(240, 330));
            }
            jPanelArray = new JPanel[this.iTotal];
            jPanelArray2 = new JPanel[this.iTotal];
            jPanelArray4 = new JPanel[this.iTotal];
            jPanelArray3 = new JPanel[this.iTotal];
            this.lblUnit = new JLabel[this.iTotal];
            this.lblDesc = new JLabel[this.iTotal];
            this.cb = new JCheckBox[this.iTotal];
            this.btnMnem = new JButton[this.iTotal];
            for (n = 0; n < this.iTotal; ++n) {
                if (this.stCurves != null) {
                    string = this.stCurves.stItem[n].sToolKID;
                    string2 = this.stCurves.stItem[n].sMnemonic;
                    string3 = this.stCurves.stItem[n].sCurveUnits;
                    string4 = this.stCurves.stItem[n].sCurveDescription;
                }
                jPanelArray[n] = new JPanel();
                jPanelArray[n].setLayout(new BorderLayout());
                this.cb[n] = new JCheckBox();
                this.cb[n].setText("");
                if (n == 0 && this.stLAS3.iType == 2) {
                    this.cb[n].setSelected(true);
                }
                this.cb[n].addActionListener(this);
                jPanelArray2[n] = new JPanel();
                jPanelArray2[n].setLayout(new BorderLayout());
                jPanelArray4[n] = new JPanel();
                jPanelArray4[n].setPreferredSize(new Dimension(120, 35));
                this.btnMnem[n] = new JButton();
                this.btnMnem[n].setPreferredSize(new Dimension(120, 25));
                this.btnMnem[n].setFont(new Font("Dialog", 0, 11));
                if (this.iData == 0 && n == 0) {
                    this.btnMnem[n].setEnabled(false);
                    this.btnMnem[n].setText("DEPT");
                } else if (string.length() > 1) {
                    this.btnMnem[n].setText(string2);
                } else {
                    this.btnMnem[n].setText("? ( " + string2 + " )");
                }
                this.btnMnem[n].addActionListener(this);
                jPanelArray3[n] = new JPanel();
                jPanelArray3[n].setLayout(new BorderLayout());
                this.lblUnit[n] = new JLabel();
                this.lblUnit[n].setFont(new Font("Dialog", 0, 11));
                this.lblUnit[n].setText("." + string3);
                this.lblDesc[n] = new JLabel();
                this.lblDesc[n].setFont(new Font("Dialog", 0, 11));
                this.lblDesc[n].setHorizontalAlignment(10);
                this.lblDesc[n].setText(" : " + string4);
                jPanel18.add((Component)jPanelArray[n], null);
                jPanelArray[n].add((Component)this.cb[n], "West");
                jPanelArray[n].add((Component)jPanelArray2[n], "Center");
                jPanelArray2[n].add((Component)jPanelArray4[n], "West");
                jPanelArray4[n].add((Component)this.btnMnem[n], null);
                jPanelArray2[n].add((Component)jPanelArray3[n], "Center");
                jPanelArray3[n].add((Component)this.lblUnit[n], "West");
                jPanelArray3[n].add((Component)this.lblDesc[n], "Center");
                string = "0";
                string2 = "";
                string3 = "";
                string4 = "";
            }
        }
        jPanel10.setBorder(BorderFactory.createEtchedBorder());
        jPanel10.setLayout(new BorderLayout());
        jPanel11.setLayout(new BorderLayout());
        jPanel13.setLayout(new BorderLayout());
        this.lblCurve.setFont(new Font("Dialog", 1, 11));
        this.lblCurve.setHorizontalAlignment(10);
        jPanel12.setLayout(new BorderLayout());
        jLabel.setFont(new Font("Dialog", 1, 11));
        jLabel.setText("MNEM . UNITS");
        jLabel2.setFont(new Font("Dialog", 1, 11));
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setText(" : DESCRIPTION");
        jLabel3.setFont(new Font("Dialog", 1, 11));
        jLabel3.setText(" | ASSOCIATIONS");
        jPanel14.setLayout(new BorderLayout());
        this.txtSelected.setText("");
        this.add((Component)jPanel, "West");
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel4, null);
        jPanel4.add((Component)jTextField, "Center");
        jPanel3.add((Component)jPanel7, null);
        jPanel7.add((Component)jTextField2, "Center");
        jPanel3.add((Component)jPanel6, null);
        jPanel6.add((Component)jTextField3, "Center");
        jPanel3.add((Component)jPanel5, null);
        jPanel5.add((Component)jTextField4, "Center");
        jPanel2.add((Component)jPanel19, "Center");
        jPanel19.add((Component)this.rbOFF, null);
        jPanel19.add((Component)this.rbON, null);
        buttonGroup.add(this.rbOFF);
        buttonGroup.add(this.rbON);
        jPanel2.add((Component)jPanel8, "South");
        jPanel8.add((Component)jPanel15, "West");
        jPanel15.add((Component)jLabel4, null);
        jPanel8.add((Component)jPanel16, "Center");
        jPanel16.add((Component)jLabel5, "West");
        jPanel16.add((Component)jPanel17, "Center");
        jPanel17.add((Component)jLabel6, "West");
        jPanel17.add((Component)jLabel7, "Center");
        jPanel.add((Component)jPanel9, "Center");
        jPanel9.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)jPanel18, null);
        this.add((Component)jPanel10, "Center");
        jPanel10.add((Component)jPanel11, "North");
        jPanel11.add((Component)jPanel13, "North");
        jPanel13.add((Component)this.lblCurve, "West");
        jPanel11.add((Component)jPanel12, "South");
        jPanel12.add((Component)jLabel, "West");
        jPanel12.add((Component)jLabel2, "Center");
        jPanel12.add((Component)jLabel3, "East");
        jPanel10.add((Component)jPanel14, "Center");
        jPanel14.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.txtSelected, null);
    }

    private void loadData(las3Struct las3Struct2) {
        if (las3Struct2 != null) {
            this.iArray = las3Struct2.iArray;
            this.iType = las3Struct2.iType;
            this.sType = new String(las3Struct2.sType);
            switch (las3Struct2.iType) {
                case -1: 
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS("http://www.kgs.ku.edu/software/gemini/data/las_standard_tools.xml", this.stCurves);
                    this.iData = 0;
                    break;
                }
                case 3: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(3, this.stCurves);
                    this.iData = 1;
                    break;
                }
                case 6: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(6, this.stCurves);
                    this.iData = 2;
                    break;
                }
                case 8: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(8, this.stCurves);
                    this.iData = 3;
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 7: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(7, this.stCurves);
                    this.iData = 19;
                    break;
                }
                case 9: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(9, this.stCurves);
                    this.iData = 4;
                    break;
                }
                case 19: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(19, this.stCurves);
                    this.iData = 17;
                    break;
                }
                case 12: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(12, this.stCurves);
                    this.iData = 5;
                    break;
                }
                case 20: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(20, this.stCurves);
                    this.iData = 18;
                    break;
                }
                case 13: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(13, this.stCurves);
                    this.iData = 6;
                }
                case 10: 
                case 11: {
                    break;
                }
                case 15: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(15, this.stCurves);
                    this.iData = 13;
                    break;
                }
                case 16: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(16, this.stCurves);
                    this.iData = 14;
                    break;
                }
                case 17: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(17, this.stCurves);
                    this.iData = 15;
                    break;
                }
                case 18: {
                    this.stCurves = las3Map.getLASCurves(las3Struct2);
                    this.stCurves = las3Map.mapToKGS(18, this.stCurves);
                    this.iData = 16;
                }
            }
        }
    }

    public int getArray() {
        return this.iArray;
    }

    public int getTypeID() {
        return this.iType;
    }

    public String getType() {
        return this.sType;
    }

    public String getLabel() {
        return this.sLabel;
    }

    public int getDataType() {
        return this.iData;
    }

    public las3Struct getLAS3() {
        String string = "";
        if (this.stLAS3 != null) {
            this.stLAS3.iSelectRows = this.stLAS3.iCurveRows;
            this.stLAS3.select = new String[this.stLAS3.iCurveRows][6];
            for (int i = 0; i < this.stLAS3.iCurveRows; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.stLAS3.select[i][j] = new String("");
                }
                if (this.stLAS3.select == null) continue;
                this.stLAS3.select[i][0] = new String(this.btnMnem[i].getText());
                string = new String(las3CurvesLogPanel.removeChar(this.lblUnit[i].getText(), '.').trim());
                this.stLAS3.select[i][1] = new String(string);
                this.stLAS3.select[i][2] = new String("");
                if (this.cb[i].isSelected()) {
                    this.stLAS3.select[i][2] = new String("SELECTED");
                }
                string = new String(las3CurvesLogPanel.removeChar(this.lblDesc[i].getText(), ':').trim());
                this.stLAS3.select[i][3] = new String(string);
            }
        }
        return this.stLAS3;
    }

    public lasFileDataStruct getLAS(double d, int n, lasFileDataStruct lasFileDataStruct2) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = -1;
        Object var10_7 = null;
        Object var11_8 = null;
        String string = "0";
        String string2 = "0";
        Object var14_11 = null;
        int n3 = -1;
        int n4 = -1;
        if (this.iData == 0) {
            if (d == 2.0) {
                lasFileDataStruct2.iParamRows = this.stLAS3.iParamRows;
                lasFileDataStruct2.iParamCols = this.stLAS3.iParamCols;
                lasFileDataStruct2.sParams = new String[lasFileDataStruct2.iParamRows][lasFileDataStruct2.iParamCols];
                for (int i = 0; i < lasFileDataStruct2.iParamRows; ++i) {
                    for (int j = 0; j < lasFileDataStruct2.iParamCols; ++j) {
                        lasFileDataStruct2.sParams[i][j] = new String(this.stLAS3.sParams[i][j]);
                    }
                }
            }
            this.getLAS3();
            lasFileDataStruct2.stLAS3[n] = las3Utility.copyWOData(this.stLAS3);
        }
        return lasFileDataStruct2;
    }

    public lasFileDataStruct getLASData(String string, String string2, double d, int n, lasFileDataStruct lasFileDataStruct2) {
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        lasFileDataStruct lasFileDataStruct3 = null;
        String string3 = "0";
        String string4 = "0";
        String[] stringArray = null;
        int n5 = -1;
        int n6 = -1;
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n7 = 0;
        int n8 = 0;
        las3ReadFile las3ReadFile2 = null;
        if (this.iData == 0) {
            int n9;
            for (n9 = 0; n9 < this.iStandard; ++n9) {
                if (this.iSelected[n9] <= -1) continue;
                ++n2;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n2;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n2];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string4 = this.stCurves.stItem[i].sToolKID;
                    if (!this.cb[i].isSelected()) continue;
                    n4 = -1;
                    for (n9 = 0; n9 < this.iStandard; ++n9) {
                        if (this.iSelected[n9] <= -1 || !string4.equals(string3 = lasStandardTools.LAS_TOOLS[n9][0])) continue;
                        n4 = n9;
                    }
                    if (n4 <= -1 && i != 0 || n3 >= n2) continue;
                    this.stCurves.stItem[i].iCurveNumber = i;
                    cmnLASCurveListStruct2.stItem[n3] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n3;
                }
            }
            lasFileDataStruct3 = new lasFileDataStruct();
            lasFileDataStruct3 = lasFileDataUtility.findCurves(cmnLASCurveListStruct2, lasFileDataStruct3);
            this.stLAS = lasFileDataUtility.findCurves(cmnLASCurveListStruct2, this.stLAS);
            lasFileDataStruct2 = lasFileDataUtility.findCurves(cmnLASCurveListStruct2, lasFileDataStruct2);
            n6 = 1;
            if (lasFileDataStruct2.sReadMethod.equals("URL")) {
                n6 = 0;
            }
            las3ReadFile2 = new las3ReadFile();
            las3ReadFile2.Open(n6, lasFileDataStruct2.sDirectory, lasFileDataStruct2.sFilename);
            n5 = las3ReadFile2.ReadFile(2, n, d);
            if (n5 == 1) {
                while (n5 == 1) {
                    stringArray = las3ReadFile2.getNextLine(string, string2, d, this.stLAS3.iColumns);
                    if (stringArray == null) {
                        n5 = -1;
                        continue;
                    }
                    d2 = las3LoadLogData.stringToDouble(stringArray[0], this.stLAS.dNull);
                    if (d2 == this.stLAS.dNull) continue;
                    if (!bl) {
                        d3 = d2;
                        d4 = d2;
                        stringArray = las3ReadFile2.getNextLine(string, string2, d, this.stLAS3.iColumns);
                        if (stringArray != null) {
                            d2 = las3LoadLogData.stringToDouble(stringArray[0], this.stLAS.dNull);
                            n7 = (int)(Math.abs(d2 - d3) * 100.0);
                            d5 = (double)n7 / 100.0;
                        }
                        bl = true;
                    }
                    if (!(d4 < d2)) continue;
                    d4 = d2;
                }
            }
            n8 = (int)(Math.abs(d4 - d3) / d5) + 1;
            lasFileDataStruct2.depthStart = d3;
            lasFileDataStruct2.depthEnd = d4;
            lasFileDataStruct2.depthStep = d5;
            lasFileDataStruct2 = las3LoadLogData.initData(n8, lasFileDataStruct2);
            las3ReadFile2.Close();
            if (las3ReadFile2 != null) {
                las3ReadFile2.delete();
            }
            las3ReadFile2 = null;
            las3ReadFile2 = new las3ReadFile();
            las3ReadFile2.Open(n6, lasFileDataStruct2.sDirectory, lasFileDataStruct2.sFilename);
            n5 = las3ReadFile2.ReadFile(2, n, d);
            if (n5 == 1) {
                while (n5 == 1) {
                    stringArray = las3ReadFile2.getNextLine(string, string2, d, this.stLAS3.iColumns);
                    if (stringArray == null) {
                        n5 = -1;
                    }
                    lasFileDataStruct2 = las3LoadLogData.addData(stringArray, this.stLAS3.iColumns, lasFileDataStruct3, lasFileDataStruct2);
                }
            }
            las3ReadFile2.Close();
            lasFileDataStruct3.delete();
            lasFileDataStruct3 = null;
            if (las3ReadFile2 != null) {
                las3ReadFile2.delete();
            }
            las3ReadFile2 = null;
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return lasFileDataStruct2;
    }

    public rockDataListStruct getRockData() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        rockDataListStruct rockDataListStruct2 = new rockDataListStruct();
        String string = "0";
        String string2 = "0";
        if (this.iData == 1) {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.iStandard; ++n5) {
                if (this.iSelected[n5] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (n4 = 0; n4 < this.stCurves.iCount; ++n4) {
                    string2 = this.stCurves.stItem[n4].sToolKID;
                    n3 = -1;
                    for (n5 = 0; n5 < this.iStandard; ++n5) {
                        if (this.iSelected[n5] <= -1 || !string2.equals(string = rockStandardTools.ROCK_TOOLS[n5][6])) continue;
                        n3 = n5;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[n4]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            rockDataListStruct2 = las3LoadCoreData.getData(this.stLAS3);
            rockDataListStruct2 = las3LoadCoreData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, rockDataListStruct2);
            if (this.dVersion == 2.0) {
                rockDataListStruct2.iParamRows = this.stLAS3.iParamRows;
                rockDataListStruct2.iParamCols = this.stLAS3.iParamCols;
                rockDataListStruct2.sParams = new String[rockDataListStruct2.iParamRows][rockDataListStruct2.iParamCols];
                for (n4 = 0; n4 < rockDataListStruct2.iParamRows; ++n4) {
                    for (n5 = 0; n5 < rockDataListStruct2.iParamCols; ++n5) {
                        rockDataListStruct2.sParams[n4][n5] = new String(this.stLAS3.sParams[n4][n5]);
                    }
                }
            }
            this.getLAS3();
            rockDataListStruct2.stLAS3 = new las3Struct[1];
            rockDataListStruct2.iLogs = 1;
            rockDataListStruct2.stLAS3[0] = las3Utility.copyWOData(this.stLAS3);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return rockDataListStruct2;
    }

    public brineListStruct getBrine() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        brineListStruct brineListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 16) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = brineStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            brineListStruct2 = las3LoadBrineData.getData(this.stLAS3);
            brineListStruct2 = las3LoadBrineData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, brineListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return brineListStruct2;
    }

    public rockImagesListStruct getImages() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        rockImagesListStruct rockImagesListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 15) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = rockImagesStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            rockImagesListStruct2 = las3LoadImageData.getData(this.stLAS3);
            rockImagesListStruct2 = las3LoadImageData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, rockImagesListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return rockImagesListStruct2;
    }

    public stratListStruct getTops() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        stratListStruct stratListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.iStandard; ++n5) {
                if (this.iSelected[n5] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (n4 = 0; n4 < this.stCurves.iCount; ++n4) {
                    string2 = this.stCurves.stItem[n4].sToolKID;
                    n3 = -1;
                    for (n5 = 0; n5 < this.iStandard; ++n5) {
                        if (this.iSelected[n5] <= -1 || !string2.equals(string = stratStandardTools.CURVES[n5][0])) continue;
                        n3 = n5;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[n4]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            stratListStruct2 = las3LoadTopsData.getData(this.stLAS3);
            stratListStruct2 = las3LoadTopsData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, stratListStruct2);
            if (this.dVersion == 2.0) {
                stratListStruct2.iParamRows = this.stLAS3.iParamRows;
                stratListStruct2.iParamCols = this.stLAS3.iParamCols;
                stratListStruct2.sParams = new String[stratListStruct2.iParamRows][stratListStruct2.iParamCols];
                for (n4 = 0; n4 < stratListStruct2.iParamRows; ++n4) {
                    for (n5 = 0; n5 < stratListStruct2.iParamCols; ++n5) {
                        stratListStruct2.sParams[n4][n5] = new String(this.stLAS3.sParams[n4][n5]);
                    }
                }
            }
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return stratListStruct2;
    }

    public regionsListStruct getPerf() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        regionsListStruct regionsListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 3) {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.iStandard; ++n5) {
                if (this.iSelected[n5] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (n4 = 0; n4 < this.stCurves.iCount; ++n4) {
                    string2 = this.stCurves.stItem[n4].sToolKID;
                    n3 = -1;
                    for (n5 = 0; n5 < this.iStandard; ++n5) {
                        if (this.iSelected[n5] <= -1 || !string2.equals(string = regionsStandardTools.CURVES[n5][0])) continue;
                        n3 = n5;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[n4]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            regionsListStruct2 = las3LoadPerfData.getData(this.stLAS3);
            regionsListStruct2 = las3LoadPerfData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, regionsListStruct2);
            if (this.dVersion == 2.0) {
                regionsListStruct2.iParamRows = this.stLAS3.iParamRows;
                regionsListStruct2.iParamCols = this.stLAS3.iParamCols;
                regionsListStruct2.sParams = new String[regionsListStruct2.iParamRows][regionsListStruct2.iParamCols];
                for (n4 = 0; n4 < regionsListStruct2.iParamRows; ++n4) {
                    for (n5 = 0; n5 < regionsListStruct2.iParamCols; ++n5) {
                        regionsListStruct2.sParams[n4][n5] = new String(this.stLAS3.sParams[n4][n5]);
                    }
                }
            }
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return regionsListStruct2;
    }

    public dstStruct getDST() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        dstStruct dstStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 19) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = dstStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            dstStruct2 = las3LoadDSTData.getData(this.stLAS3);
            dstStruct2 = las3LoadDSTData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, dstStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return dstStruct2;
    }

    public iqstratControlStruct getControl() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        iqstratControlStruct iqstratControlStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 4) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = iqstratControlStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            iqstratControlStruct2 = las3LoadControlData.getData(this.stLAS3);
            iqstratControlStruct2 = las3LoadControlData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, iqstratControlStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return iqstratControlStruct2;
    }

    public bioStratListStruct getBio() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        bioStratListStruct bioStratListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 17) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = bioStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            bioStratListStruct2 = las3LoadBioData.getData(this.stLAS3);
            bioStratListStruct2 = las3LoadBioData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, bioStratListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return bioStratListStruct2;
    }

    public seqListStruct getSeq() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        seqListStruct seqListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 5) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = seqStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            seqListStruct2 = las3LoadSeqData.getData(this.stLAS3);
            seqListStruct2 = las3LoadSeqData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, seqListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return seqListStruct2;
    }

    public envListStruct getEnv() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        envListStruct envListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 18) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = envStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            envListStruct2 = las3LoadEnvData.getData(this.stLAS3);
            envListStruct2 = las3LoadEnvData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, envListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return envListStruct2;
    }

    public pfefferDataListStruct getPfeffer() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        pfefferDataListStruct pfefferDataListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 6) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = pfefferStandardTools.P_CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            pfefferDataListStruct2 = las3LoadPfefferData.getData(this.stLAS3);
            pfefferDataListStruct2 = las3LoadPfefferData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, this.stLAS, this.stStruct.stSymbols, pfefferDataListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return pfefferDataListStruct2;
    }

    public iqstratRemarkListStruct getRemarks() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        iqstratRemarkListStruct iqstratRemarkListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 13) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = iqstratRemarkStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            iqstratRemarkListStruct2 = las3LoadRemarksData.getData(this.stLAS3);
            iqstratRemarkListStruct2 = las3LoadRemarksData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, iqstratRemarkListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return iqstratRemarkListStruct2;
    }

    public iqstratShaleListStruct getShale() {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        cmnLASCurveListStruct cmnLASCurveListStruct2 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        String string = "0";
        String string2 = "0";
        if (this.iData == 14) {
            int n4;
            for (n4 = 0; n4 < this.iStandard; ++n4) {
                if (this.iSelected[n4] <= -1) continue;
                ++n;
            }
            if (this.stCurves != null && this.stCurves.iCount > 0) {
                cmnLASCurveListStruct2 = new cmnLASCurveListStruct();
                cmnLASCurveListStruct2.iCount = n;
                cmnLASCurveListStruct2.stItem = new cmnLASCurveStruct[n];
                for (int i = 0; i < this.stCurves.iCount; ++i) {
                    string2 = this.stCurves.stItem[i].sToolKID;
                    n3 = -1;
                    for (n4 = 0; n4 < this.iStandard; ++n4) {
                        if (this.iSelected[n4] <= -1 || !string2.equals(string = iqstratShaleStandardTools.CURVES[n4][0])) continue;
                        n3 = n4;
                    }
                    if (n3 <= -1 || n2 >= n) continue;
                    cmnLASCurveListStruct2.stItem[n2] = cmnLASCurveUtility.copy(this.stCurves.stItem[i]);
                    ++n2;
                }
                cmnLASCurveListStruct2.iCount = n2;
            }
            iqstratShaleListStruct2 = las3LoadShaleData.getData(this.stLAS3);
            iqstratShaleListStruct2 = las3LoadShaleData.loadData(this.stLAS.dNull, this.stLAS3, cmnLASCurveListStruct2, iqstratShaleListStruct2);
            if (cmnLASCurveListStruct2 != null) {
                cmnLASCurveListStruct2.delete();
            }
            cmnLASCurveListStruct2 = null;
        }
        return iqstratShaleListStruct2;
    }

    public boolean isCurve() {
        boolean bl = false;
        if (this.iCurve > -1) {
            bl = true;
        }
        return bl;
    }

    public void getCurve() {
        cmnLASCurveStruct cmnLASCurveStruct2 = new cmnLASCurveStruct();
        if (this.isCurve()) {
            if (this.pTools != null) {
                cmnLASCurveStruct2 = cmnLASCurveUtility.copy(this.pTools.getCurve(cmnLASCurveStruct2));
                this.cb[this.iCurve].setSelected(false);
                if (cmnLASCurveStruct2.sCurveUnits.equals("UNI") || cmnLASCurveStruct2.sCurveUnits.equals("UNL")) {
                    this.stCurves.stItem[this.iCurve].sToolKID = new String(cmnLASCurveStruct2.sToolKID);
                    this.stCurves.stItem[this.iCurve].sCurveName = new String("(" + this.stCurves.stItem[this.iCurve].sCurveUnits + ") " + this.stCurves.stItem[this.iCurve].sCurveName);
                    this.stCurves.stItem[this.iCurve].sCurveUnits = new String(cmnLASCurveStruct2.sCurveUnits);
                    this.stCurves.stItem[this.iCurve].sMnemonic = las3CurvesLogPanel.resetMnemonic(this.stCurves.stItem[this.iCurve].sMnemonic);
                    this.btnMnem[this.iCurve].setText(this.stCurves.stItem[this.iCurve].sMnemonic);
                    this.lblUnit[this.iCurve].setText("." + this.stCurves.stItem[this.iCurve].sCurveUnits);
                    this.lblDesc[this.iCurve].setText(" : " + this.stCurves.stItem[this.iCurve].sCurveName);
                } else {
                    this.stCurves.stItem[this.iCurve] = cmnLASCurveUtility.copy(cmnLASCurveStruct2);
                    this.btnMnem[this.iCurve].setText(this.stCurves.stItem[this.iCurve].sMnemonic);
                    this.lblUnit[this.iCurve].setText("." + this.stCurves.stItem[this.iCurve].sCurveUnits);
                    this.lblDesc[this.iCurve].setText(" : " + this.stCurves.stItem[this.iCurve].sCurveName);
                }
            }
            this.pTools.close();
            this.pTools = null;
            this.iCurve = -1;
        }
        this.setButtons();
    }

    public static String resetMnemonic(String string) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '?' || cArray[i] == '(' || cArray[i] == ')') continue;
                string2 = new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    public int getAction() {
        return this.iAction;
    }

    private void setButtons() {
        String string = "0";
        if (this.cb != null && this.cb.length > 0) {
            this.cb[0].setEnabled(false);
        }
        if (this.btnMnem != null && this.btnMnem.length > 0) {
            this.btnMnem[0].setEnabled(false);
        }
        this.setCBColor();
        for (int i = 1; i < this.iTotal; ++i) {
            if (this.stCurves != null) {
                string = this.stCurves.stItem[i].sToolKID;
            }
            this.cb[i].setEnabled(false);
            this.btnMnem[i].setEnabled(false);
            if (this.iAction != 1) continue;
            if (this.iData != 0) {
                this.cb[0].setEnabled(true);
                this.btnMnem[0].setEnabled(true);
            }
            this.btnMnem[i].setEnabled(true);
            if (string.length() <= 1) continue;
            this.cb[i].setEnabled(true);
        }
    }

    private void setCBColor() {
        int n = -1;
        String string = "";
        String string2 = "0";
        String string3 = "0";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        for (int i = 0; i < this.iTotal; ++i) {
            if (this.stCurves != null) {
                string3 = this.stCurves.stItem[i].sToolKID;
                string4 = this.stCurves.stItem[i].sMnemonic;
                string5 = this.stCurves.stItem[i].sCurveUnits;
                string6 = this.stCurves.stItem[i].sCurveDescription;
                n = -1;
                for (int j = 0; j < this.iStandard; ++j) {
                    switch (this.iData) {
                        case 0: {
                            string2 = lasStandardTools.LAS_TOOLS[j][0];
                            break;
                        }
                        case 1: {
                            string2 = rockStandardTools.ROCK_TOOLS[j][6];
                            break;
                        }
                        case 2: {
                            string2 = stratStandardTools.CURVES[j][0];
                            break;
                        }
                        case 5: {
                            string2 = seqStandardTools.CURVES[j][0];
                            break;
                        }
                        case 18: {
                            string2 = envStandardTools.CURVES[j][0];
                            break;
                        }
                        case 3: {
                            string2 = regionsStandardTools.CURVES[j][0];
                            break;
                        }
                        case 19: {
                            string2 = dstStandardTools.CURVES[j][0];
                            break;
                        }
                        case 4: {
                            string2 = iqstratControlStandardTools.CURVES[j][0];
                            break;
                        }
                        case 17: {
                            string2 = bioStandardTools.CURVES[j][0];
                            break;
                        }
                        case 6: {
                            string2 = pfefferStandardTools.P_CURVES[j][0];
                            break;
                        }
                        case 13: {
                            string2 = iqstratRemarkStandardTools.CURVES[j][0];
                            break;
                        }
                        case 14: {
                            string2 = iqstratShaleStandardTools.CURVES[j][0];
                            break;
                        }
                        case 15: {
                            string2 = rockImagesStandardTools.CURVES[j][0];
                            break;
                        }
                        case 16: {
                            string2 = brineStandardTools.CURVES[j][0];
                        }
                    }
                    if (!string3.equals(string2)) continue;
                    n = j;
                }
            }
            if (this.cb[i].isSelected()) {
                if (string5.equals("OHM-M") || string5.equals("OHMM") || string5.equals("MV")) {
                    this.cb[i].setBackground(new Color(255, 165, 0));
                    continue;
                }
                if (string5.equals("PU")) {
                    this.cb[i].setBackground(new Color(0, 255, 255));
                    continue;
                }
                if (string5.equals("BARNS/E")) {
                    this.cb[i].setBackground(new Color(173, 255, 47));
                    continue;
                }
                if (string5.equals("GM/CC") || string5.equals("GMCC")) {
                    this.cb[i].setBackground(new Color(0, 255, 0));
                    continue;
                }
                if (string5.equals("USEC/FT")) {
                    this.cb[i].setBackground(new Color(34, 139, 34));
                    continue;
                }
                if (string5.equals("PPM") || string5.equals("%") || string5.equals("API")) {
                    this.cb[i].setBackground(new Color(255, 0, 0));
                    continue;
                }
                if (string5.equals("MD")) {
                    this.cb[i].setBackground(new Color(0, 0, 255));
                    continue;
                }
                if (string5.equals("F") || string5.equals("FT") || string5.equals("IN")) {
                    this.cb[i].setBackground(new Color(165, 42, 42));
                    continue;
                }
                if (string5.equals("FRAC")) {
                    this.cb[i].setBackground(new Color(255, 255, 128));
                    continue;
                }
                if (string5.equals("UNI")) {
                    this.cb[i].setBackground(new Color(148, 0, 211));
                    continue;
                }
                if (string5.equals("UNL")) {
                    this.cb[i].setBackground(new Color(148, 130, 238));
                    continue;
                }
                this.cb[i].setBackground(new Color(255, 255, 0));
                continue;
            }
            this.cb[i].setBackground(new Color(220, 220, 220));
        }
    }

    private void setDefault() {
        String string = "0";
        boolean bl = false;
        for (int i = 0; i < this.iTotal; ++i) {
            if (this.stCurves == null) continue;
            for (int j = 0; j < this.iStandard; ++j) {
                switch (this.iData) {
                    case 0: {
                        string = lasStandardTools.LAS_TOOLS[j][0];
                        break;
                    }
                    case 1: {
                        string = rockStandardTools.ROCK_TOOLS[j][6];
                        break;
                    }
                    case 2: {
                        string = stratStandardTools.CURVES[j][0];
                        break;
                    }
                    case 5: {
                        string = seqStandardTools.CURVES[j][0];
                        break;
                    }
                    case 18: {
                        string = envStandardTools.CURVES[j][0];
                        break;
                    }
                    case 3: {
                        string = regionsStandardTools.CURVES[j][0];
                        break;
                    }
                    case 19: {
                        string = dstStandardTools.CURVES[j][0];
                        break;
                    }
                    case 4: {
                        string = iqstratControlStandardTools.CURVES[j][0];
                        break;
                    }
                    case 17: {
                        string = bioStandardTools.CURVES[j][0];
                        break;
                    }
                    case 6: {
                        string = pfefferStandardTools.P_CURVES[j][0];
                        break;
                    }
                    case 13: {
                        string = iqstratRemarkStandardTools.CURVES[j][0];
                        break;
                    }
                    case 14: {
                        string = iqstratShaleStandardTools.CURVES[j][0];
                        break;
                    }
                    case 15: {
                        string = rockImagesStandardTools.CURVES[j][0];
                        break;
                    }
                    case 16: {
                        string = brineStandardTools.CURVES[j][0];
                    }
                }
                if (!this.stCurves.stItem[i].sToolKID.equals(string) || this.iqstrato != -1) continue;
                bl = true;
                if (this.stLAS3.iSelectRows > 0 && !this.stLAS3.select[i][2].equals("SELECTED")) {
                    bl = false;
                }
                if (!bl) continue;
                this.cb[i].setSelected(true);
                this.setCheckBox(i, 0);
            }
        }
        this.setButtons();
    }

    private boolean isLogCurve(int n) {
        boolean bl = false;
        if (this.stCurves != null) {
            for (int i = 1; i < this.iTotal; ++i) {
                if (i == n || !this.stCurves.stItem[n].sToolKID.equals(this.stCurves.stItem[i].sToolKID) || !this.cb[i].isSelected()) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void setCheckBox(int n, int n2) {
        if (this.isLogCurve(n)) {
            this.cb[n].setSelected(false);
            if (n2 == 1) {
                JOptionPane.showMessageDialog(null, "Duplicate Curve Type Selected", "ERROR", 0);
            }
        }
    }

    private void setDefinition() {
        int n;
        int n2 = -1;
        String string = "";
        String string2 = "0";
        String string3 = "0";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.stCurves != null) {
            for (n = 0; n < this.iStandard; ++n) {
                this.iSelected[n] = -1;
            }
        }
        for (n = 0; n < this.iTotal; ++n) {
            if (this.stCurves != null) {
                int n3;
                string3 = this.stCurves.stItem[n].sToolKID;
                string4 = this.stCurves.stItem[n].sMnemonic;
                string5 = this.stCurves.stItem[n].sCurveUnits;
                string6 = this.stCurves.stItem[n].sCurveDescription;
                string7 = "";
                if (this.stCurves.stItem[n].iAssoc > 0) {
                    string7 = new String("| ");
                    for (n3 = 0; n3 < this.stCurves.stItem[n].iAssoc; ++n3) {
                        if (n3 > 0) {
                            string7 = new String(string7 + ", ");
                        }
                        string7 = new String(string7 + this.stCurves.stItem[n].sAssoc[n3]);
                    }
                }
                n2 = -1;
                for (n3 = 0; n3 < this.iStandard; ++n3) {
                    switch (this.iData) {
                        case 0: {
                            string2 = lasStandardTools.LAS_TOOLS[n3][0];
                            break;
                        }
                        case 1: {
                            string2 = rockStandardTools.ROCK_TOOLS[n3][6];
                            break;
                        }
                        case 2: {
                            string2 = stratStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 5: {
                            string2 = seqStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 18: {
                            string2 = envStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 3: {
                            string2 = regionsStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 19: {
                            string2 = dstStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 4: {
                            string2 = iqstratControlStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 17: {
                            string2 = bioStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 6: {
                            string2 = pfefferStandardTools.P_CURVES[n3][0];
                            break;
                        }
                        case 13: {
                            string2 = iqstratRemarkStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 14: {
                            string2 = iqstratShaleStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 15: {
                            string2 = rockImagesStandardTools.CURVES[n3][0];
                            break;
                        }
                        case 16: {
                            string2 = brineStandardTools.CURVES[n3][0];
                        }
                    }
                    if (!string3.equals(string2)) continue;
                    n2 = n3;
                }
            }
            if (!this.cb[n].isSelected()) continue;
            if (n2 > -1) {
                this.iSelected[n2] = n;
            }
            string = new String(string + string4 + " ." + string5 + "     : " + string6 + "  {F}  " + string7 + "\n");
        }
        this.txtSelected.setText(string);
    }

    private void setCurve(int n) {
        this.iCurve = n;
        if (this.pTools != null) {
            this.pTools.close();
        }
        this.pTools = null;
        this.pTools = new las3ToolsFrame(this.notifier, this.iData);
    }

    public static String removeChar(String string, char c) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == c) continue;
                string2 = new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    public void close() {
        this.notifier = null;
        this.stStruct = null;
        this.stCMN = null;
        this.stLAS3 = null;
        this.stLAS = null;
        this.iArray = 0;
        this.iType = -1;
        this.sType = null;
        this.sLabel = null;
        this.iSelected = null;
        if (this.stCurves != null) {
            this.stCurves.delete();
        }
        this.stCurves = null;
        if (this.stRock != null) {
            this.stRock.delete();
        }
        this.stRock = null;
        if (this.pTools != null) {
            this.pTools.close();
        }
        this.pTools = null;
        this.lblCurve = null;
        this.txtSelected = null;
        for (int i = 0; i < this.iTotal; ++i) {
            this.cb[i] = null;
            this.btnMnem[i] = null;
            this.lblUnit[i] = null;
            this.lblDesc[i] = null;
        }
        this.iTotal = 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbOFF) {
            this.iAction = 0;
        }
        if (actionEvent.getSource() == this.rbON) {
            this.iAction = 1;
        }
        for (int i = 0; i < this.iTotal; ++i) {
            if (actionEvent.getSource() == this.cb[i]) {
                this.setCheckBox(i, 1);
            }
            if (actionEvent.getSource() != this.btnMnem[i]) continue;
            this.setCurve(i);
        }
        this.setButtons();
        this.setDefinition();
        if (this.pTools != null) {
            this.pTools.toFront();
        }
    }
}

