/*
 * Decompiled with CFR 0.152.
 */
package las;

import cmn.cmnLASCurveListStruct;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratShaleUtility;
import iqstrat.iqstratTracksStruct;
import las.lasFileDataStruct;
import las.lasStandardTools;
import las3.las3Struct;
import las3.las3Utility;
import math.mathLAS;

public class lasFileDataUtility {
    public static final int _RT = 0;
    public static final int _PHIT = 1;
    public static final int _MMHOS_M = 16;
    public static final int[][] MMHOS_M = iqstratTracksStruct.MMHOS_M;
    public static final int _PU = 16;
    public static final int[][] PU = iqstratTracksStruct.PU;
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;

    public static lasFileDataStruct addConversionData(iqstratControlStruct iqstratControlStruct2, lasFileDataStruct lasFileDataStruct2) {
        double[] dArray = new double[]{0.0, 0.0};
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 100.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (iqstratControlStruct2 != null && lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.iGRN > -1) {
                lasFileDataStruct2.dGRNMin = iqstratControlStruct2.dGRNMin;
                lasFileDataStruct2.dGRNMax = iqstratControlStruct2.dGRNMax;
                lasFileDataStruct2.dGRCMin = iqstratControlStruct2.dGRCMin;
                lasFileDataStruct2.dGRCMax = iqstratControlStruct2.dGRCMax;
                dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dGRN, lasFileDataStruct2.dNull);
                d2 = dArray[0];
                d3 = dArray[1];
                d4 = lasFileDataStruct2.dGRNMin;
                d5 = lasFileDataStruct2.dGRNMax;
                n = (int)((d2 + d3 * d4 / 100.0) * 1000.0);
                d6 = d = (double)n / 1000.0;
                n = (int)(d3 * d5 / 100.0 * 1000.0);
                d7 = d = (double)n / 1000.0;
                lasFileDataStruct2.dGR = mathLAS.computeGR(lasFileDataStruct2.dGRN, lasFileDataStruct2.dNull, d7, d6, lasFileDataStruct2.dGRCMax, lasFileDataStruct2.dGRCMin);
            }
            if (lasFileDataStruct2.iNEUT > -1) {
                lasFileDataStruct2.dNEUTMin = iqstratControlStruct2.dNEUTMin;
                lasFileDataStruct2.dNEUTMax = iqstratControlStruct2.dNEUTMax;
                lasFileDataStruct2.dNPHICMin = iqstratControlStruct2.dNPHICMin;
                lasFileDataStruct2.dNPHICMax = iqstratControlStruct2.dNPHICMax;
                dArray = mathLAS.computeCurveMinMax(lasFileDataStruct2.dNEUT, lasFileDataStruct2.dNull);
                d2 = dArray[0];
                d3 = dArray[1];
                d4 = lasFileDataStruct2.dNEUTMin;
                d5 = lasFileDataStruct2.dNEUTMax;
                n = (int)((d2 + d3 * d4 / 100.0) * 1000.0);
                d6 = d = (double)n / 1000.0;
                n = (int)(d3 * d5 / 100.0 * 1000.0);
                d7 = d = (double)n / 1000.0;
                lasFileDataStruct2.dNPHI = mathLAS.computeNPHI(lasFileDataStruct2.dNEUT, lasFileDataStruct2.dNull, d7, d6, lasFileDataStruct2.dNPHICMax, lasFileDataStruct2.dNPHICMin);
            }
        }
        return lasFileDataStruct2;
    }

    public static lasFileDataStruct copy(lasFileDataStruct lasFileDataStruct2, lasFileDataStruct lasFileDataStruct3) {
        if (lasFileDataStruct2 != null && lasFileDataStruct3 != null) {
            int n;
            int n2;
            lasFileDataStruct3.iSource = lasFileDataStruct2.iSource;
            lasFileDataStruct3.sPDAT = new String(lasFileDataStruct2.sPDAT);
            lasFileDataStruct3.dAPD = lasFileDataStruct2.dAPD;
            lasFileDataStruct3.sDREF = new String(lasFileDataStruct2.sDREF);
            lasFileDataStruct3.dElevation = lasFileDataStruct2.dElevation;
            lasFileDataStruct3.dTDD = lasFileDataStruct2.dTDD;
            lasFileDataStruct3.dTLD = lasFileDataStruct2.dTLD;
            lasFileDataStruct3.dCSGL = lasFileDataStruct2.dCSGL;
            lasFileDataStruct3.dCSGD = lasFileDataStruct2.dCSGD;
            lasFileDataStruct3.dCSGS = lasFileDataStruct2.dCSGS;
            lasFileDataStruct3.dCSGW = lasFileDataStruct2.dCSGW;
            lasFileDataStruct3.dBS = lasFileDataStruct2.dBS;
            lasFileDataStruct3.sMUD = new String(lasFileDataStruct2.sMUD);
            lasFileDataStruct3.sMUDS = new String(lasFileDataStruct2.sMUDS);
            lasFileDataStruct3.dMUDD = lasFileDataStruct2.dMUDD;
            lasFileDataStruct3.dMUDV = lasFileDataStruct2.dMUDV;
            lasFileDataStruct3.dFL = lasFileDataStruct2.dFL;
            lasFileDataStruct3.dPH = lasFileDataStruct2.dPH;
            lasFileDataStruct3.dRM = lasFileDataStruct2.dRM;
            lasFileDataStruct3.dRMT = lasFileDataStruct2.dRMT;
            lasFileDataStruct3.dRMF = lasFileDataStruct2.dRMF;
            lasFileDataStruct3.dRMFT = lasFileDataStruct2.dRMFT;
            lasFileDataStruct3.dRMC = lasFileDataStruct2.dRMC;
            lasFileDataStruct3.dRMCT = lasFileDataStruct2.dRMCT;
            lasFileDataStruct3.dTMAX = lasFileDataStruct2.dTMAX;
            lasFileDataStruct3.sTIMC = new String(lasFileDataStruct2.sTIMC);
            lasFileDataStruct3.sTIML = new String(lasFileDataStruct2.sTIML);
            lasFileDataStruct3.sUNIT = new String(lasFileDataStruct2.sUNIT);
            lasFileDataStruct3.sBASE = new String(lasFileDataStruct2.sBASE);
            lasFileDataStruct3.sENG = new String(lasFileDataStruct2.sENG);
            lasFileDataStruct3.sWIT = new String(lasFileDataStruct2.sWIT);
            lasFileDataStruct3.sCSGL = new String(lasFileDataStruct2.sCSGL);
            lasFileDataStruct3.sCSGD = new String(lasFileDataStruct2.sCSGD);
            lasFileDataStruct3.sCSGS = new String(lasFileDataStruct2.sCSGS);
            lasFileDataStruct3.sCSGW = new String(lasFileDataStruct2.sCSGW);
            lasFileDataStruct3.sBS = new String(lasFileDataStruct2.sBS);
            lasFileDataStruct3.sMUDD = new String(lasFileDataStruct2.sMUDD);
            lasFileDataStruct3.sMUDV = new String(lasFileDataStruct2.sMUDV);
            lasFileDataStruct3.sFL = new String(lasFileDataStruct2.sFL);
            lasFileDataStruct3.sRM = new String(lasFileDataStruct2.sRM);
            lasFileDataStruct3.sRMT = new String(lasFileDataStruct2.sRMT);
            lasFileDataStruct3.sRMF = new String(lasFileDataStruct2.sRMF);
            lasFileDataStruct3.sRMFT = new String(lasFileDataStruct2.sRMFT);
            lasFileDataStruct3.sRMC = new String(lasFileDataStruct2.sRMC);
            lasFileDataStruct3.sRMCT = new String(lasFileDataStruct2.sRMCT);
            lasFileDataStruct3.sTMAX = new String(lasFileDataStruct2.sTMAX);
            lasFileDataStruct3.sUnknown = new String[4][2];
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 2; ++n) {
                    lasFileDataStruct3.sUnknown[n2][n] = new String(lasFileDataStruct2.sUnknown[n2][n]);
                }
            }
            lasFileDataStruct3.iParamRows = lasFileDataStruct2.iParamRows;
            lasFileDataStruct3.iParamCols = lasFileDataStruct2.iParamCols;
            lasFileDataStruct3.sParams = new String[lasFileDataStruct3.iParamRows][lasFileDataStruct3.iParamCols];
            for (n2 = 0; n2 < lasFileDataStruct3.iParamRows; ++n2) {
                for (n = 0; n < lasFileDataStruct3.iParamCols; ++n) {
                    lasFileDataStruct3.sParams[n2][n] = new String(lasFileDataStruct2.sParams[n2][n]);
                }
            }
            lasFileDataStruct3.sUnknown = new String[4][2];
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 2; ++n) {
                    lasFileDataStruct3.sUnknown[n2][n] = new String(lasFileDataStruct2.sUnknown[n2][n]);
                }
            }
        }
        return lasFileDataStruct3;
    }

    public static lasFileDataStruct copy(lasFileDataStruct lasFileDataStruct2) {
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null) {
            int n;
            int n2;
            lasFileDataStruct3 = new lasFileDataStruct();
            lasFileDataStruct3.iSource = lasFileDataStruct2.iSource;
            lasFileDataStruct3.sKID = new String(lasFileDataStruct2.sKID);
            lasFileDataStruct3.sKEY = new String(lasFileDataStruct2.sKEY);
            lasFileDataStruct3.iType = lasFileDataStruct2.iType;
            lasFileDataStruct3.sAPI = new String(lasFileDataStruct2.sAPI);
            lasFileDataStruct3.sName = new String(lasFileDataStruct2.sName);
            lasFileDataStruct3.state = new String(lasFileDataStruct2.state);
            lasFileDataStruct3.sCounty = new String(lasFileDataStruct2.sCounty);
            lasFileDataStruct3.dLatitude = lasFileDataStruct2.dLatitude;
            lasFileDataStruct3.dLongitude = lasFileDataStruct2.dLongitude;
            lasFileDataStruct3.dKB = lasFileDataStruct2.dKB;
            lasFileDataStruct3.dGL = lasFileDataStruct2.dGL;
            lasFileDataStruct3.dTD = lasFileDataStruct2.dTD;
            lasFileDataStruct3.status = new String(lasFileDataStruct2.status);
            lasFileDataStruct3.sReadMethod = new String(lasFileDataStruct2.sReadMethod);
            lasFileDataStruct3.sDirectory = new String(lasFileDataStruct2.sDirectory);
            lasFileDataStruct3.sFilename = new String(lasFileDataStruct2.sFilename);
            lasFileDataStruct3.sVersion = new String(lasFileDataStruct2.sVersion);
            lasFileDataStruct3.dNull = lasFileDataStruct2.dNull;
            lasFileDataStruct3.depthStart = lasFileDataStruct2.depthStart;
            lasFileDataStruct3.depthEnd = lasFileDataStruct2.depthEnd;
            lasFileDataStruct3.depthStep = lasFileDataStruct2.depthStep;
            lasFileDataStruct3.iProprietary = lasFileDataStruct2.iProprietary;
            lasFileDataStruct3.sPDAT = new String(lasFileDataStruct2.sPDAT);
            lasFileDataStruct3.dAPD = lasFileDataStruct2.dAPD;
            lasFileDataStruct3.sDREF = new String(lasFileDataStruct2.sDREF);
            lasFileDataStruct3.dElevation = lasFileDataStruct2.dElevation;
            lasFileDataStruct3.dTDD = lasFileDataStruct2.dTDD;
            lasFileDataStruct3.dTLD = lasFileDataStruct2.dTLD;
            lasFileDataStruct3.dCSGL = lasFileDataStruct2.dCSGL;
            lasFileDataStruct3.dCSGD = lasFileDataStruct2.dCSGD;
            lasFileDataStruct3.dCSGS = lasFileDataStruct2.dCSGS;
            lasFileDataStruct3.dCSGW = lasFileDataStruct2.dCSGW;
            lasFileDataStruct3.dBS = lasFileDataStruct2.dBS;
            lasFileDataStruct3.sMUD = new String(lasFileDataStruct2.sMUD);
            lasFileDataStruct3.sMUDS = new String(lasFileDataStruct2.sMUDS);
            lasFileDataStruct3.dMUDD = lasFileDataStruct2.dMUDD;
            lasFileDataStruct3.dMUDV = lasFileDataStruct2.dMUDV;
            lasFileDataStruct3.dFL = lasFileDataStruct2.dFL;
            lasFileDataStruct3.dPH = lasFileDataStruct2.dPH;
            lasFileDataStruct3.dRM = lasFileDataStruct2.dRM;
            lasFileDataStruct3.dRMT = lasFileDataStruct2.dRMT;
            lasFileDataStruct3.dRMF = lasFileDataStruct2.dRMF;
            lasFileDataStruct3.dRMFT = lasFileDataStruct2.dRMFT;
            lasFileDataStruct3.dRMC = lasFileDataStruct2.dRMC;
            lasFileDataStruct3.dRMCT = lasFileDataStruct2.dRMCT;
            lasFileDataStruct3.dTMAX = lasFileDataStruct2.dTMAX;
            lasFileDataStruct3.sTIMC = new String(lasFileDataStruct2.sTIMC);
            lasFileDataStruct3.sTIML = new String(lasFileDataStruct2.sTIML);
            lasFileDataStruct3.sUNIT = new String(lasFileDataStruct2.sUNIT);
            lasFileDataStruct3.sBASE = new String(lasFileDataStruct2.sBASE);
            lasFileDataStruct3.sENG = new String(lasFileDataStruct2.sENG);
            lasFileDataStruct3.sWIT = new String(lasFileDataStruct2.sWIT);
            lasFileDataStruct3.sCSGL = new String(lasFileDataStruct2.sCSGL);
            lasFileDataStruct3.sCSGD = new String(lasFileDataStruct2.sCSGD);
            lasFileDataStruct3.sCSGS = new String(lasFileDataStruct2.sCSGS);
            lasFileDataStruct3.sCSGW = new String(lasFileDataStruct2.sCSGW);
            lasFileDataStruct3.sBS = new String(lasFileDataStruct2.sBS);
            lasFileDataStruct3.sMUDD = new String(lasFileDataStruct2.sMUDD);
            lasFileDataStruct3.sMUDV = new String(lasFileDataStruct2.sMUDV);
            lasFileDataStruct3.sFL = new String(lasFileDataStruct2.sFL);
            lasFileDataStruct3.sRM = new String(lasFileDataStruct2.sRM);
            lasFileDataStruct3.sRMT = new String(lasFileDataStruct2.sRMT);
            lasFileDataStruct3.sRMF = new String(lasFileDataStruct2.sRMF);
            lasFileDataStruct3.sRMFT = new String(lasFileDataStruct2.sRMFT);
            lasFileDataStruct3.sRMC = new String(lasFileDataStruct2.sRMC);
            lasFileDataStruct3.sRMCT = new String(lasFileDataStruct2.sRMCT);
            lasFileDataStruct3.sTMAX = new String(lasFileDataStruct2.sTMAX);
            lasFileDataStruct3.iParamRows = lasFileDataStruct2.iParamRows;
            lasFileDataStruct3.iParamCols = lasFileDataStruct2.iParamCols;
            lasFileDataStruct3.sParams = new String[lasFileDataStruct3.iParamRows][lasFileDataStruct3.iParamCols];
            for (n2 = 0; n2 < lasFileDataStruct3.iParamRows; ++n2) {
                for (n = 0; n < lasFileDataStruct3.iParamCols; ++n) {
                    lasFileDataStruct3.sParams[n2][n] = new String(lasFileDataStruct2.sParams[n2][n]);
                }
            }
            lasFileDataStruct3.iLogs = lasFileDataStruct2.iLogs;
            if (lasFileDataStruct2.iLogs > 0) {
                lasFileDataStruct3.stLAS3 = new las3Struct[lasFileDataStruct2.iLogs];
                for (n2 = 0; n2 < lasFileDataStruct2.iLogs; ++n2) {
                    lasFileDataStruct3.stLAS3[n2] = las3Utility.copyWOData(lasFileDataStruct2.stLAS3[n2]);
                }
            }
            lasFileDataStruct3.sUnknown = new String[4][2];
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 2; ++n) {
                    lasFileDataStruct3.sUnknown[n2][n] = new String(lasFileDataStruct2.sUnknown[n2][n]);
                }
            }
            lasFileDataStruct3.iColorlithDefault = lasFileDataStruct2.iColorlithDefault;
            lasFileDataStruct3.iGR = lasFileDataStruct2.iGR;
            lasFileDataStruct3.iCGR = lasFileDataStruct2.iCGR;
            lasFileDataStruct3.iSP = lasFileDataStruct2.iSP;
            lasFileDataStruct3.iCAL = lasFileDataStruct2.iCAL;
            lasFileDataStruct3.iNPHI = lasFileDataStruct2.iNPHI;
            lasFileDataStruct3.iPE = lasFileDataStruct2.iPE;
            lasFileDataStruct3.iRHOB = lasFileDataStruct2.iRHOB;
            lasFileDataStruct3.iDPHI = lasFileDataStruct2.iDPHI;
            lasFileDataStruct3.iRHO = lasFileDataStruct2.iRHO;
            lasFileDataStruct3.iDT = lasFileDataStruct2.iDT;
            lasFileDataStruct3.iSPHI = lasFileDataStruct2.iSPHI;
            lasFileDataStruct3.iCOND = lasFileDataStruct2.iCOND;
            lasFileDataStruct3.iCILD = lasFileDataStruct2.iCILD;
            lasFileDataStruct3.iCILM = lasFileDataStruct2.iCILM;
            lasFileDataStruct3.iRES = lasFileDataStruct2.iRES;
            lasFileDataStruct3.iRMED = lasFileDataStruct2.iRMED;
            lasFileDataStruct3.iRDEP = lasFileDataStruct2.iRDEP;
            lasFileDataStruct3.iRSHAL = lasFileDataStruct2.iRSHAL;
            lasFileDataStruct3.iILD = lasFileDataStruct2.iILD;
            lasFileDataStruct3.iILM = lasFileDataStruct2.iILM;
            lasFileDataStruct3.iSFLU = lasFileDataStruct2.iSFLU;
            lasFileDataStruct3.iLL = lasFileDataStruct2.iLL;
            lasFileDataStruct3.iMLL = lasFileDataStruct2.iMLL;
            lasFileDataStruct3.iLL8 = lasFileDataStruct2.iLL8;
            lasFileDataStruct3.iLN = lasFileDataStruct2.iLN;
            lasFileDataStruct3.iSN = lasFileDataStruct2.iSN;
            lasFileDataStruct3.iMNOR = lasFileDataStruct2.iMNOR;
            lasFileDataStruct3.iMSFL = lasFileDataStruct2.iMSFL;
            lasFileDataStruct3.iMINV = lasFileDataStruct2.iMINV;
            lasFileDataStruct3.iAHT10 = lasFileDataStruct2.iAHT10;
            lasFileDataStruct3.iAHT20 = lasFileDataStruct2.iAHT20;
            lasFileDataStruct3.iAHT30 = lasFileDataStruct2.iAHT30;
            lasFileDataStruct3.iAHT60 = lasFileDataStruct2.iAHT60;
            lasFileDataStruct3.iAHT90 = lasFileDataStruct2.iAHT90;
            lasFileDataStruct3.iTh = lasFileDataStruct2.iTh;
            lasFileDataStruct3.iU = lasFileDataStruct2.iU;
            lasFileDataStruct3.iK = lasFileDataStruct2.iK;
            lasFileDataStruct3.iGRN = lasFileDataStruct2.iGRN;
            lasFileDataStruct3.iNEUT = lasFileDataStruct2.iNEUT;
            lasFileDataStruct3.iPERM = lasFileDataStruct2.iPERM;
            lasFileDataStruct3.iTEMP = lasFileDataStruct2.iTEMP;
            lasFileDataStruct3.iTEMPDIFF = lasFileDataStruct2.iTEMPDIFF;
            lasFileDataStruct3.iLIN_1 = lasFileDataStruct2.iLIN_1;
            lasFileDataStruct3.iLIN_2 = lasFileDataStruct2.iLIN_2;
            lasFileDataStruct3.iLIN_3 = lasFileDataStruct2.iLIN_3;
            lasFileDataStruct3.iLIN_4 = lasFileDataStruct2.iLIN_4;
            lasFileDataStruct3.iLOG_1 = lasFileDataStruct2.iLOG_1;
            lasFileDataStruct3.iLOG_2 = lasFileDataStruct2.iLOG_2;
            lasFileDataStruct3.iLOG_3 = lasFileDataStruct2.iLOG_3;
            lasFileDataStruct3.iLOG_4 = lasFileDataStruct2.iLOG_4;
            lasFileDataStruct3.iUmaa = lasFileDataStruct2.iUmaa;
            lasFileDataStruct3.iRhomaa = lasFileDataStruct2.iRhomaa;
            lasFileDataStruct3.iDTmaa = lasFileDataStruct2.iDTmaa;
            lasFileDataStruct3.iNeutron = lasFileDataStruct2.iNeutron;
            lasFileDataStruct3.iDelta = lasFileDataStruct2.iDelta;
            lasFileDataStruct3.iThU = lasFileDataStruct2.iThU;
            lasFileDataStruct3.iThK = lasFileDataStruct2.iThK;
            lasFileDataStruct3.iPHI = lasFileDataStruct2.iPHI;
            lasFileDataStruct3.iGMCC = lasFileDataStruct2.iGMCC;
            lasFileDataStruct3.iRT = lasFileDataStruct2.iRT;
            lasFileDataStruct3.iRWA = lasFileDataStruct2.iRWA;
            lasFileDataStruct3.iRO = lasFileDataStruct2.iRO;
            lasFileDataStruct3.iRXRT = lasFileDataStruct2.iRXRT;
            lasFileDataStruct3.iMA = lasFileDataStruct2.iMA;
            lasFileDataStruct3.iPHIT = lasFileDataStruct2.iPHIT;
            lasFileDataStruct3.iPHIE = lasFileDataStruct2.iPHIE;
            lasFileDataStruct3.iSW = lasFileDataStruct2.iSW;
            lasFileDataStruct3.iBVW = lasFileDataStruct2.iBVW;
            lasFileDataStruct3.iATT1 = lasFileDataStruct2.iATT1;
            lasFileDataStruct3.iATT2 = lasFileDataStruct2.iATT2;
            lasFileDataStruct3.iATT3 = lasFileDataStruct2.iATT3;
            lasFileDataStruct3.iATT4 = lasFileDataStruct2.iATT4;
            lasFileDataStruct3.iATT5 = lasFileDataStruct2.iATT5;
            lasFileDataStruct3.iATT6 = lasFileDataStruct2.iATT6;
            lasFileDataStruct3.iVCAL = lasFileDataStruct2.iVCAL;
            lasFileDataStruct3.iVQTZ = lasFileDataStruct2.iVQTZ;
            lasFileDataStruct3.iVDOL = lasFileDataStruct2.iVDOL;
            lasFileDataStruct3.iVSH = lasFileDataStruct2.iVSH;
            lasFileDataStruct3.iVANH = lasFileDataStruct2.iVANH;
            lasFileDataStruct3.iRows = lasFileDataStruct2.iRows;
            lasFileDataStruct3.depths = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dGR = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dCGR = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dSP = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dCAL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dNPHI = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dPE = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRHOB = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dDPHI = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRHO = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dDT = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dSPHI = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dCOND = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dCILD = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dCILM = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRES = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRMED = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRDEP = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRSHAL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dILD = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dILM = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dSFLU = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dMLL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLL8 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLN = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dSN = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dMNOR = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dMSFL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dMINV = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dAHT10 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dAHT20 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dAHT30 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dAHT60 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dAHT90 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dTh = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dU = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dK = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dGRN = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dNEUT = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dPERM = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dTEMP = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dTEMPDIFF = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLIN_1 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLIN_2 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLIN_3 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLIN_4 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLOG_1 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLOG_2 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLOG_3 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dLOG_4 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dUmaa = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRhomaa = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dDTmaa = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dNeutron = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.delta = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dThU = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dThK = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dPHI = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dGMCC = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRT = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRWA = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRO = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dRXRT = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dMA = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dPHIT = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dPHIE = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dSW = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dBVW = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT1 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT2 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT3 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT4 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT5 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dATT6 = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dVCAL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dVQTZ = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dVDOL = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dVSH = new double[lasFileDataStruct3.iRows];
            lasFileDataStruct3.dVANH = new double[lasFileDataStruct3.iRows];
            for (n2 = 0; n2 < lasFileDataStruct2.iRows; ++n2) {
                lasFileDataStruct3.depths[n2] = lasFileDataStruct2.depths[n2];
                lasFileDataStruct3.dGR[n2] = lasFileDataStruct2.dGR[n2];
                lasFileDataStruct3.dCGR[n2] = lasFileDataStruct2.dCGR[n2];
                lasFileDataStruct3.dSP[n2] = lasFileDataStruct2.dSP[n2];
                lasFileDataStruct3.dCAL[n2] = lasFileDataStruct2.dCAL[n2];
                lasFileDataStruct3.dPE[n2] = lasFileDataStruct2.dPE[n2];
                lasFileDataStruct3.dNPHI[n2] = lasFileDataStruct2.dNPHI[n2];
                lasFileDataStruct3.dRHOB[n2] = lasFileDataStruct2.dRHOB[n2];
                lasFileDataStruct3.dDPHI[n2] = lasFileDataStruct2.dDPHI[n2];
                lasFileDataStruct3.dRHO[n2] = lasFileDataStruct2.dRHO[n2];
                lasFileDataStruct3.dDT[n2] = lasFileDataStruct2.dDT[n2];
                lasFileDataStruct3.dSPHI[n2] = lasFileDataStruct2.dSPHI[n2];
                lasFileDataStruct3.dCOND[n2] = lasFileDataStruct2.dCOND[n2];
                lasFileDataStruct3.dCILD[n2] = lasFileDataStruct2.dCILD[n2];
                lasFileDataStruct3.dCILM[n2] = lasFileDataStruct2.dCILM[n2];
                lasFileDataStruct3.dRES[n2] = lasFileDataStruct2.dRES[n2];
                lasFileDataStruct3.dRMED[n2] = lasFileDataStruct2.dRMED[n2];
                lasFileDataStruct3.dRDEP[n2] = lasFileDataStruct2.dRDEP[n2];
                lasFileDataStruct3.dRSHAL[n2] = lasFileDataStruct2.dRSHAL[n2];
                lasFileDataStruct3.dILD[n2] = lasFileDataStruct2.dILD[n2];
                lasFileDataStruct3.dILM[n2] = lasFileDataStruct2.dILM[n2];
                lasFileDataStruct3.dSFLU[n2] = lasFileDataStruct2.dSFLU[n2];
                lasFileDataStruct3.dLL[n2] = lasFileDataStruct2.dLL[n2];
                lasFileDataStruct3.dMLL[n2] = lasFileDataStruct2.dMLL[n2];
                lasFileDataStruct3.dLL8[n2] = lasFileDataStruct2.dLL8[n2];
                lasFileDataStruct3.dLN[n2] = lasFileDataStruct2.dLN[n2];
                lasFileDataStruct3.dSN[n2] = lasFileDataStruct2.dSN[n2];
                lasFileDataStruct3.dMNOR[n2] = lasFileDataStruct2.dMNOR[n2];
                lasFileDataStruct3.dMSFL[n2] = lasFileDataStruct2.dMSFL[n2];
                lasFileDataStruct3.dMINV[n2] = lasFileDataStruct2.dMINV[n2];
                lasFileDataStruct3.dAHT10[n2] = lasFileDataStruct2.dAHT10[n2];
                lasFileDataStruct3.dAHT20[n2] = lasFileDataStruct2.dAHT20[n2];
                lasFileDataStruct3.dAHT30[n2] = lasFileDataStruct2.dAHT30[n2];
                lasFileDataStruct3.dAHT60[n2] = lasFileDataStruct2.dAHT60[n2];
                lasFileDataStruct3.dAHT90[n2] = lasFileDataStruct2.dAHT90[n2];
                lasFileDataStruct3.dTh[n2] = lasFileDataStruct2.dTh[n2];
                lasFileDataStruct3.dU[n2] = lasFileDataStruct2.dU[n2];
                lasFileDataStruct3.dK[n2] = lasFileDataStruct2.dK[n2];
                lasFileDataStruct3.dGRN[n2] = lasFileDataStruct2.dGRN[n2];
                lasFileDataStruct3.dNEUT[n2] = lasFileDataStruct2.dNEUT[n2];
                lasFileDataStruct3.dPERM[n2] = lasFileDataStruct2.dPERM[n2];
                lasFileDataStruct3.dTEMP[n2] = lasFileDataStruct2.dTEMP[n2];
                lasFileDataStruct3.dTEMPDIFF[n2] = lasFileDataStruct2.dTEMPDIFF[n2];
                lasFileDataStruct3.dLIN_1[n2] = lasFileDataStruct2.dLIN_1[n2];
                lasFileDataStruct3.dLIN_2[n2] = lasFileDataStruct2.dLIN_2[n2];
                lasFileDataStruct3.dLIN_3[n2] = lasFileDataStruct2.dLIN_3[n2];
                lasFileDataStruct3.dLIN_4[n2] = lasFileDataStruct2.dLIN_4[n2];
                lasFileDataStruct3.dLOG_1[n2] = lasFileDataStruct2.dLOG_1[n2];
                lasFileDataStruct3.dLOG_2[n2] = lasFileDataStruct2.dLOG_2[n2];
                lasFileDataStruct3.dLOG_3[n2] = lasFileDataStruct2.dLOG_3[n2];
                lasFileDataStruct3.dLOG_4[n2] = lasFileDataStruct2.dLOG_4[n2];
                lasFileDataStruct3.dUmaa[n2] = lasFileDataStruct2.dUmaa[n2];
                lasFileDataStruct3.dRhomaa[n2] = lasFileDataStruct2.dRhomaa[n2];
                lasFileDataStruct3.dDTmaa[n2] = lasFileDataStruct2.dDTmaa[n2];
                lasFileDataStruct3.dNeutron[n2] = lasFileDataStruct2.dNeutron[n2];
                lasFileDataStruct3.delta[n2] = lasFileDataStruct2.delta[n2];
                lasFileDataStruct3.dThU[n2] = lasFileDataStruct2.dThU[n2];
                lasFileDataStruct3.dThK[n2] = lasFileDataStruct2.dThK[n2];
                lasFileDataStruct3.dPHI[n2] = lasFileDataStruct2.dPHI[n2];
                lasFileDataStruct3.dGMCC[n2] = lasFileDataStruct2.dGMCC[n2];
                lasFileDataStruct3.dRT[n2] = lasFileDataStruct2.dRT[n2];
                lasFileDataStruct3.dRWA[n2] = lasFileDataStruct2.dRWA[n2];
                lasFileDataStruct3.dRO[n2] = lasFileDataStruct2.dRO[n2];
                lasFileDataStruct3.dRXRT[n2] = lasFileDataStruct2.dRXRT[n2];
                lasFileDataStruct3.dMA[n2] = lasFileDataStruct2.dMA[n2];
                lasFileDataStruct3.dPHIT[n2] = lasFileDataStruct2.dPHIT[n2];
                lasFileDataStruct3.dPHIE[n2] = lasFileDataStruct2.dPHIE[n2];
                lasFileDataStruct3.dSW[n2] = lasFileDataStruct2.dSW[n2];
                lasFileDataStruct3.dBVW[n2] = lasFileDataStruct2.dBVW[n2];
                lasFileDataStruct3.dATT1[n2] = lasFileDataStruct2.dATT1[n2];
                lasFileDataStruct3.dATT2[n2] = lasFileDataStruct2.dATT2[n2];
                lasFileDataStruct3.dATT3[n2] = lasFileDataStruct2.dATT3[n2];
                lasFileDataStruct3.dATT4[n2] = lasFileDataStruct2.dATT4[n2];
                lasFileDataStruct3.dATT5[n2] = lasFileDataStruct2.dATT5[n2];
                lasFileDataStruct3.dATT6[n2] = lasFileDataStruct2.dATT6[n2];
                lasFileDataStruct3.dVCAL[n2] = lasFileDataStruct2.dVCAL[n2];
                lasFileDataStruct3.dVQTZ[n2] = lasFileDataStruct2.dVQTZ[n2];
                lasFileDataStruct3.dVDOL[n2] = lasFileDataStruct2.dVDOL[n2];
                lasFileDataStruct3.dVSH[n2] = lasFileDataStruct2.dVSH[n2];
                lasFileDataStruct3.dVANH[n2] = lasFileDataStruct2.dVANH[n2];
            }
            if (lasFileDataStruct2.dSPMin != 0.0) {
                lasFileDataStruct3.dSPMin = lasFileDataStruct2.dSPMin;
            }
            if (lasFileDataStruct2.dSPMax != 0.0) {
                lasFileDataStruct3.dSPMax = lasFileDataStruct2.dSPMax;
            }
            lasFileDataStruct3.dPHIMin = lasFileDataStruct2.dPHIMin;
            lasFileDataStruct3.dPHIMax = lasFileDataStruct2.dPHIMax;
            lasFileDataStruct3.dRhoMin = lasFileDataStruct2.dRhoMin;
            lasFileDataStruct3.dRhoMax = lasFileDataStruct2.dRhoMax;
            lasFileDataStruct3.dGRNMin = lasFileDataStruct2.dGRNMin;
            lasFileDataStruct3.dGRNMax = lasFileDataStruct2.dGRNMax;
            lasFileDataStruct3.dGRMin = lasFileDataStruct2.dGRMin;
            lasFileDataStruct3.dGRMax = lasFileDataStruct2.dGRMax;
            lasFileDataStruct3.dGRCMin = lasFileDataStruct2.dGRCMin;
            lasFileDataStruct3.dGRCMax = lasFileDataStruct2.dGRCMax;
            lasFileDataStruct3.dGRNMinP = lasFileDataStruct2.dGRNMinP;
            lasFileDataStruct3.dGRNMaxP = lasFileDataStruct2.dGRNMaxP;
            lasFileDataStruct3.dNEUTMin = lasFileDataStruct2.dNEUTMin;
            lasFileDataStruct3.dNEUTMax = lasFileDataStruct2.dNEUTMax;
            lasFileDataStruct3.dNPHIMin = lasFileDataStruct2.dNPHIMin;
            lasFileDataStruct3.dNPHIMax = lasFileDataStruct2.dNPHIMax;
            lasFileDataStruct3.dNPHICMin = lasFileDataStruct2.dNPHICMin;
            lasFileDataStruct3.dNPHICMax = lasFileDataStruct2.dNPHICMax;
            lasFileDataStruct3.dNEUTMinP = lasFileDataStruct2.dNEUTMinP;
            lasFileDataStruct3.dNEUTMaxP = lasFileDataStruct2.dNEUTMaxP;
            lasFileDataStruct3.dTEMPMin = lasFileDataStruct2.dTEMPMin;
            lasFileDataStruct3.dTEMPMax = lasFileDataStruct2.dTEMPMax;
            lasFileDataStruct3.dTEMPDIFFMin = lasFileDataStruct2.dTEMPDIFFMin;
            lasFileDataStruct3.dTEMPDIFFMax = lasFileDataStruct2.dTEMPDIFFMax;
            lasFileDataStruct3.dRXRTMin = lasFileDataStruct2.dRXRTMin;
            lasFileDataStruct3.dRXRTMax = lasFileDataStruct2.dRXRTMax;
            lasFileDataStruct3.dLIN_1Min = lasFileDataStruct2.dLIN_1Min;
            lasFileDataStruct3.dLIN_2Min = lasFileDataStruct2.dLIN_2Min;
            lasFileDataStruct3.dLIN_3Min = lasFileDataStruct2.dLIN_3Min;
            lasFileDataStruct3.dLIN_4Min = lasFileDataStruct2.dLIN_4Min;
            lasFileDataStruct3.dLIN_1Max = lasFileDataStruct2.dLIN_1Max;
            lasFileDataStruct3.dLIN_2Max = lasFileDataStruct2.dLIN_2Max;
            lasFileDataStruct3.dLIN_3Max = lasFileDataStruct2.dLIN_3Max;
            lasFileDataStruct3.dLIN_4Max = lasFileDataStruct2.dLIN_4Max;
            lasFileDataStruct3.dLOG_1Min = lasFileDataStruct2.dLOG_1Min;
            lasFileDataStruct3.dLOG_2Min = lasFileDataStruct2.dLOG_2Min;
            lasFileDataStruct3.dLOG_3Min = lasFileDataStruct2.dLOG_3Min;
            lasFileDataStruct3.dLOG_4Min = lasFileDataStruct2.dLOG_4Min;
            lasFileDataStruct3.dLOG_1Max = lasFileDataStruct2.dLOG_1Max;
            lasFileDataStruct3.dLOG_2Max = lasFileDataStruct2.dLOG_2Max;
            lasFileDataStruct3.dLOG_3Max = lasFileDataStruct2.dLOG_3Max;
            lasFileDataStruct3.dLOG_4Max = lasFileDataStruct2.dLOG_4Max;
            lasFileDataStruct3.stList = iqstratShaleUtility.copyList(lasFileDataStruct2.stList);
        }
        return lasFileDataStruct3;
    }

    public static lasFileDataStruct transfer(lasFileDataStruct lasFileDataStruct2) {
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null) {
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            lasFileDataStruct2.delete();
            lasFileDataStruct2 = null;
        }
        return lasFileDataStruct3;
    }

    public static lasFileDataStruct computeMath(lasFileDataStruct lasFileDataStruct2) {
        int n = 0;
        boolean bl = false;
        if (lasFileDataStruct2 != null) {
            double[][] dArray;
            if (lasFileDataStruct2.iPE > -1 && lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iNPHI > -1) {
                dArray = null;
                lasFileDataStruct2.iColorlithDefault = 0;
                dArray = mathLAS.computeRhomaaUmaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dNPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dPE, lasFileDataStruct2.dNull);
                if (dArray != null) {
                    for (n = 0; n < lasFileDataStruct2.iRows; ++n) {
                        lasFileDataStruct2.dRhomaa[n] = dArray[0][n];
                        lasFileDataStruct2.dUmaa[n] = dArray[1][n];
                    }
                }
                lasFileDataStruct2.iUmaa = 1;
                lasFileDataStruct2.iRhomaa = 1;
            } else if (lasFileDataStruct2.iPE > -1 && lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iDT > -1) {
                dArray = null;
                lasFileDataStruct2.iColorlithDefault = 0;
                if (lasFileDataStruct2.iSPHI == -1) {
                    lasFileDataStruct2.dSPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                    lasFileDataStruct2.iSPHI = 1;
                }
                if ((dArray = mathLAS.computeRhomaaUmaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dPE, lasFileDataStruct2.dNull)) != null) {
                    for (n = 0; n < lasFileDataStruct2.iRows; ++n) {
                        lasFileDataStruct2.dRhomaa[n] = dArray[0][n];
                        lasFileDataStruct2.dUmaa[n] = dArray[1][n];
                    }
                }
                lasFileDataStruct2.iUmaa = 1;
                lasFileDataStruct2.iRhomaa = 1;
            } else if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iNPHI > -1) {
                lasFileDataStruct2.iColorlithDefault = 5;
                lasFileDataStruct2.dRhomaa = mathLAS.computeRhomaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dNPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iRhomaa = 1;
            } else if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iDT > -1) {
                if (lasFileDataStruct2.iSPHI == -1) {
                    lasFileDataStruct2.dSPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                    lasFileDataStruct2.iSPHI = 1;
                }
                lasFileDataStruct2.dRhomaa = mathLAS.computeRhomaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iRhomaa = 1;
            } else if (lasFileDataStruct2.iRHOB > -1) {
                if (lasFileDataStruct2.iDPHI == -1) {
                    lasFileDataStruct2.dDPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                    lasFileDataStruct2.iDPHI = 1;
                }
                lasFileDataStruct2.dRhomaa = mathLAS.computeRhomaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dDPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iRhomaa = 1;
            }
            if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iNPHI > -1 && lasFileDataStruct2.iDT > -1) {
                lasFileDataStruct2.dDTmaa = mathLAS.computeDTmaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dNPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dDT, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iDTmaa = 1;
            } else if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iDT > -1) {
                if (lasFileDataStruct2.iSPHI == -1) {
                    lasFileDataStruct2.dSPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                    lasFileDataStruct2.iSPHI = 1;
                }
                lasFileDataStruct2.dDTmaa = mathLAS.computeDTmaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dDT, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iDTmaa = 1;
            } else if (lasFileDataStruct2.iDT > -1) {
                if (lasFileDataStruct2.iSPHI == -1) {
                    lasFileDataStruct2.dSPHI = mathLAS.computePHI(lasFileDataStruct2.iRows, lasFileDataStruct2.dDT, 1, 1, 0, lasFileDataStruct2.dNull);
                    lasFileDataStruct2.iSPHI = 1;
                }
                lasFileDataStruct2.dDTmaa = mathLAS.computeDTmaa(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dSPHI, lasFileDataStruct2.dDT, lasFileDataStruct2.dNull);
                lasFileDataStruct2.iDTmaa = 1;
            }
            if (lasFileDataStruct2.iRHOB > -1 && lasFileDataStruct2.iNPHI > -1) {
                dArray = null;
                dArray = mathLAS.computePorosityDifference(0, lasFileDataStruct2.iRows, lasFileDataStruct2.dNPHI, lasFileDataStruct2.dRHOB, lasFileDataStruct2.dNull);
                if (dArray != null) {
                    for (n = 0; n < lasFileDataStruct2.iRows; ++n) {
                        lasFileDataStruct2.dNeutron[n] = dArray[0][n];
                        lasFileDataStruct2.delta[n] = dArray[1][n];
                    }
                }
                lasFileDataStruct2.iNeutron = 1;
                lasFileDataStruct2.iDelta = 1;
            }
            if (lasFileDataStruct2.iTh > -1 && lasFileDataStruct2.iU > -1 && lasFileDataStruct2.iK > -1) {
                dArray = null;
                if (lasFileDataStruct2.iColorlithDefault == -1) {
                    lasFileDataStruct2.iColorlithDefault = 2;
                }
                if ((dArray = mathLAS.computeSpectralGR(lasFileDataStruct2.iRows, lasFileDataStruct2.dTh, lasFileDataStruct2.dU, lasFileDataStruct2.dK, lasFileDataStruct2.dNull)) != null) {
                    for (n = 0; n < lasFileDataStruct2.iRows; ++n) {
                        lasFileDataStruct2.dThU[n] = dArray[0][n];
                        lasFileDataStruct2.dThK[n] = dArray[1][n];
                    }
                }
                lasFileDataStruct2.iThU = 1;
                lasFileDataStruct2.iThK = 1;
            }
        }
        return lasFileDataStruct2;
    }

    public static lasFileDataStruct findCurves(cmnLASCurveListStruct cmnLASCurveListStruct2, lasFileDataStruct lasFileDataStruct2) {
        if (cmnLASCurveListStruct2 != null) {
            for (int i = 0; i < cmnLASCurveListStruct2.iCount; ++i) {
                if (cmnLASCurveListStruct2.stItem[i] == null) continue;
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[0][0]) && lasFileDataStruct2.iGR == -1) {
                    lasFileDataStruct2.iGR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[1][0]) && lasFileDataStruct2.iCGR == -1) {
                    lasFileDataStruct2.iCGR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[2][0]) && lasFileDataStruct2.iSP == -1) {
                    lasFileDataStruct2.iSP = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[3][0]) && lasFileDataStruct2.iCAL == -1) {
                    lasFileDataStruct2.iCAL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[4][0]) && lasFileDataStruct2.iPE == -1) {
                    lasFileDataStruct2.iPE = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[8][0]) && lasFileDataStruct2.iNPHI == -1) {
                    lasFileDataStruct2.iNPHI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[7][0]) && lasFileDataStruct2.iDPHI == -1) {
                    lasFileDataStruct2.iDPHI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[5][0]) && lasFileDataStruct2.iRHOB == -1) {
                    lasFileDataStruct2.iRHOB = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[6][0]) && lasFileDataStruct2.iRHO == -1) {
                    lasFileDataStruct2.iRHO = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[11][0]) && lasFileDataStruct2.iCOND == -1) {
                    lasFileDataStruct2.iCOND = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[12][0]) && lasFileDataStruct2.iCILD == -1) {
                    lasFileDataStruct2.iCILD = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[13][0]) && lasFileDataStruct2.iCILM == -1) {
                    lasFileDataStruct2.iCILM = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[14][0]) && lasFileDataStruct2.iRES == -1) {
                    lasFileDataStruct2.iRES = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[15][0]) && lasFileDataStruct2.iRDEP == -1) {
                    lasFileDataStruct2.iRDEP = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[16][0]) && lasFileDataStruct2.iRMED == -1) {
                    lasFileDataStruct2.iRMED = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[17][0]) && lasFileDataStruct2.iRSHAL == -1) {
                    lasFileDataStruct2.iRSHAL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[18][0]) && lasFileDataStruct2.iILD == -1) {
                    lasFileDataStruct2.iILD = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[19][0]) && lasFileDataStruct2.iILM == -1) {
                    lasFileDataStruct2.iILM = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[20][0]) && lasFileDataStruct2.iSFLU == -1) {
                    lasFileDataStruct2.iSFLU = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[21][0]) && lasFileDataStruct2.iLL == -1) {
                    lasFileDataStruct2.iLL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[22][0]) && lasFileDataStruct2.iMLL == -1) {
                    lasFileDataStruct2.iMLL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[23][0]) && lasFileDataStruct2.iLL8 == -1) {
                    lasFileDataStruct2.iLL8 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[24][0]) && lasFileDataStruct2.iLN == -1) {
                    lasFileDataStruct2.iLN = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[25][0]) && lasFileDataStruct2.iSN == -1) {
                    lasFileDataStruct2.iSN = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[26][0]) && lasFileDataStruct2.iMNOR == -1) {
                    lasFileDataStruct2.iMNOR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[27][0]) && lasFileDataStruct2.iMSFL == -1) {
                    lasFileDataStruct2.iMSFL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[28][0]) && lasFileDataStruct2.iMINV == -1) {
                    lasFileDataStruct2.iMINV = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[29][0]) && lasFileDataStruct2.iAHT10 == -1) {
                    lasFileDataStruct2.iAHT10 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[30][0]) && lasFileDataStruct2.iAHT20 == -1) {
                    lasFileDataStruct2.iAHT20 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[31][0]) && lasFileDataStruct2.iAHT30 == -1) {
                    lasFileDataStruct2.iAHT30 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[32][0]) && lasFileDataStruct2.iAHT60 == -1) {
                    lasFileDataStruct2.iAHT60 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[33][0]) && lasFileDataStruct2.iAHT90 == -1) {
                    lasFileDataStruct2.iAHT90 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[10][0]) && lasFileDataStruct2.iDT == -1) {
                    lasFileDataStruct2.iDT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[9][0]) && lasFileDataStruct2.iSPHI == -1) {
                    lasFileDataStruct2.iSPHI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[36][0]) && lasFileDataStruct2.iK == -1) {
                    lasFileDataStruct2.iK = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[35][0]) && lasFileDataStruct2.iU == -1) {
                    lasFileDataStruct2.iU = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[34][0]) && lasFileDataStruct2.iTh == -1) {
                    lasFileDataStruct2.iTh = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[37][0]) && lasFileDataStruct2.iGRN == -1) {
                    lasFileDataStruct2.iGRN = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[38][0]) && lasFileDataStruct2.iNEUT == -1) {
                    lasFileDataStruct2.iNEUT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[39][0]) && lasFileDataStruct2.iPERM == -1) {
                    lasFileDataStruct2.iPERM = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[40][0]) && lasFileDataStruct2.iTEMP == -1) {
                    lasFileDataStruct2.iTEMP = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[41][0]) && lasFileDataStruct2.iLIN_1 == -1) {
                    lasFileDataStruct2.iLIN_1 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[0][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[42][0]) && lasFileDataStruct2.iLIN_2 == -1) {
                    lasFileDataStruct2.iLIN_2 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[1][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[43][0]) && lasFileDataStruct2.iLIN_3 == -1) {
                    lasFileDataStruct2.iLIN_3 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[2][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[44][0]) && lasFileDataStruct2.iLIN_4 == -1) {
                    lasFileDataStruct2.iLIN_4 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[3][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[45][0]) && lasFileDataStruct2.iLOG_1 == -1) {
                    lasFileDataStruct2.iLOG_1 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[0][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[46][0]) && lasFileDataStruct2.iLOG_2 == -1) {
                    lasFileDataStruct2.iLOG_2 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[1][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[47][0]) && lasFileDataStruct2.iLOG_3 == -1) {
                    lasFileDataStruct2.iLOG_3 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[2][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[48][0]) && lasFileDataStruct2.iLOG_4 == -1) {
                    lasFileDataStruct2.iLOG_4 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    lasFileDataStruct2.sUnknown[3][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[49][0]) && lasFileDataStruct2.iPHI == -1) {
                    lasFileDataStruct2.iPHI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[50][0]) && lasFileDataStruct2.iGMCC == -1) {
                    lasFileDataStruct2.iGMCC = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[51][0]) && lasFileDataStruct2.iRT == -1) {
                    lasFileDataStruct2.iRT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[52][0]) && lasFileDataStruct2.iRWA == -1) {
                    lasFileDataStruct2.iRWA = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[53][0]) && lasFileDataStruct2.iRO == -1) {
                    lasFileDataStruct2.iRO = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[54][0]) && lasFileDataStruct2.iRXRT == -1) {
                    lasFileDataStruct2.iRXRT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[55][0]) && lasFileDataStruct2.iMA == -1) {
                    lasFileDataStruct2.iMA = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[56][0]) && lasFileDataStruct2.iPHIT == -1) {
                    lasFileDataStruct2.iPHIT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[57][0]) && lasFileDataStruct2.iPHIE == -1) {
                    lasFileDataStruct2.iPHIE = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[58][0]) && lasFileDataStruct2.iSW == -1) {
                    lasFileDataStruct2.iSW = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[59][0]) && lasFileDataStruct2.iBVW == -1) {
                    lasFileDataStruct2.iBVW = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[60][0]) && lasFileDataStruct2.iATT1 == -1) {
                    lasFileDataStruct2.iATT1 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[61][0]) && lasFileDataStruct2.iATT2 == -1) {
                    lasFileDataStruct2.iATT2 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[62][0]) && lasFileDataStruct2.iATT3 == -1) {
                    lasFileDataStruct2.iATT3 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[63][0]) && lasFileDataStruct2.iATT4 == -1) {
                    lasFileDataStruct2.iATT4 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[64][0]) && lasFileDataStruct2.iATT5 == -1) {
                    lasFileDataStruct2.iATT5 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[65][0]) && lasFileDataStruct2.iATT6 == -1) {
                    lasFileDataStruct2.iATT6 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[66][0]) && lasFileDataStruct2.iVCAL == -1) {
                    lasFileDataStruct2.iVCAL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[67][0]) && lasFileDataStruct2.iVQTZ == -1) {
                    lasFileDataStruct2.iVQTZ = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[68][0]) && lasFileDataStruct2.iVDOL == -1) {
                    lasFileDataStruct2.iVDOL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[69][0]) && lasFileDataStruct2.iVSH == -1) {
                    lasFileDataStruct2.iVSH = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                }
                if (!cmnLASCurveListStruct2.stItem[i].sToolKID.equals(lasStandardTools.LAS_TOOLS[70][0]) || lasFileDataStruct2.iVANH != -1) continue;
                lasFileDataStruct2.iVANH = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
            }
        }
        return lasFileDataStruct2;
    }

    public static lasFileDataStruct copyHeader(lasFileDataStruct lasFileDataStruct2, lasFileDataStruct lasFileDataStruct3) {
        if (lasFileDataStruct2 != null && lasFileDataStruct3 != null) {
            int n;
            int n2;
            lasFileDataStruct3.sKID = new String(lasFileDataStruct2.sKID);
            lasFileDataStruct3.sKEY = new String(lasFileDataStruct2.sKEY);
            lasFileDataStruct3.iType = lasFileDataStruct2.iType;
            lasFileDataStruct3.sAPI = new String(lasFileDataStruct2.sAPI);
            lasFileDataStruct3.sName = new String(lasFileDataStruct2.sName);
            lasFileDataStruct3.state = new String(lasFileDataStruct2.state);
            lasFileDataStruct3.sCounty = new String(lasFileDataStruct2.sCounty);
            lasFileDataStruct3.dLatitude = lasFileDataStruct2.dLatitude;
            lasFileDataStruct3.dLongitude = lasFileDataStruct2.dLongitude;
            lasFileDataStruct3.dKB = lasFileDataStruct2.dKB;
            lasFileDataStruct3.dGL = lasFileDataStruct2.dGL;
            lasFileDataStruct3.dTD = lasFileDataStruct2.dTD;
            lasFileDataStruct3.status = new String(lasFileDataStruct2.status);
            lasFileDataStruct3.sReadMethod = new String(lasFileDataStruct2.sReadMethod);
            lasFileDataStruct3.sDirectory = new String(lasFileDataStruct2.sDirectory);
            lasFileDataStruct3.sFilename = new String(lasFileDataStruct2.sFilename);
            lasFileDataStruct3.sVersion = new String(lasFileDataStruct2.sVersion);
            lasFileDataStruct3.dNull = lasFileDataStruct2.dNull;
            lasFileDataStruct3.depthStart = lasFileDataStruct2.depthStart;
            lasFileDataStruct3.depthEnd = lasFileDataStruct2.depthEnd;
            lasFileDataStruct3.depthStep = lasFileDataStruct2.depthStep;
            lasFileDataStruct3.iProprietary = lasFileDataStruct2.iProprietary;
            lasFileDataStruct3.sPDAT = new String(lasFileDataStruct2.sPDAT);
            lasFileDataStruct3.dAPD = lasFileDataStruct2.dAPD;
            lasFileDataStruct3.sDREF = new String(lasFileDataStruct2.sDREF);
            lasFileDataStruct3.dElevation = lasFileDataStruct2.dElevation;
            lasFileDataStruct3.dTDD = lasFileDataStruct2.dTDD;
            lasFileDataStruct3.dTLD = lasFileDataStruct2.dTLD;
            lasFileDataStruct3.dCSGL = lasFileDataStruct2.dCSGL;
            lasFileDataStruct3.dCSGD = lasFileDataStruct2.dCSGD;
            lasFileDataStruct3.dCSGS = lasFileDataStruct2.dCSGS;
            lasFileDataStruct3.dCSGW = lasFileDataStruct2.dCSGW;
            lasFileDataStruct3.dBS = lasFileDataStruct2.dBS;
            lasFileDataStruct3.sMUD = new String(lasFileDataStruct2.sMUD);
            lasFileDataStruct3.sMUDS = new String(lasFileDataStruct2.sMUDS);
            lasFileDataStruct3.dMUDD = lasFileDataStruct2.dMUDD;
            lasFileDataStruct3.dMUDV = lasFileDataStruct2.dMUDV;
            lasFileDataStruct3.dFL = lasFileDataStruct2.dFL;
            lasFileDataStruct3.dPH = lasFileDataStruct2.dPH;
            lasFileDataStruct3.dRM = lasFileDataStruct2.dRM;
            lasFileDataStruct3.dRMT = lasFileDataStruct2.dRMT;
            lasFileDataStruct3.dRMF = lasFileDataStruct2.dRMF;
            lasFileDataStruct3.dRMFT = lasFileDataStruct2.dRMFT;
            lasFileDataStruct3.dRMC = lasFileDataStruct2.dRMC;
            lasFileDataStruct3.dRMCT = lasFileDataStruct2.dRMCT;
            lasFileDataStruct3.dTMAX = lasFileDataStruct2.dTMAX;
            lasFileDataStruct3.sTIMC = new String(lasFileDataStruct2.sTIMC);
            lasFileDataStruct3.sTIML = new String(lasFileDataStruct2.sTIML);
            lasFileDataStruct3.sUNIT = new String(lasFileDataStruct2.sUNIT);
            lasFileDataStruct3.sBASE = new String(lasFileDataStruct2.sBASE);
            lasFileDataStruct3.sENG = new String(lasFileDataStruct2.sENG);
            lasFileDataStruct3.sWIT = new String(lasFileDataStruct2.sWIT);
            lasFileDataStruct3.sCSGL = new String(lasFileDataStruct2.sCSGL);
            lasFileDataStruct3.sCSGD = new String(lasFileDataStruct2.sCSGD);
            lasFileDataStruct3.sCSGS = new String(lasFileDataStruct2.sCSGS);
            lasFileDataStruct3.sCSGW = new String(lasFileDataStruct2.sCSGW);
            lasFileDataStruct3.sBS = new String(lasFileDataStruct2.sBS);
            lasFileDataStruct3.sMUDD = new String(lasFileDataStruct2.sMUDD);
            lasFileDataStruct3.sMUDV = new String(lasFileDataStruct2.sMUDV);
            lasFileDataStruct3.sFL = new String(lasFileDataStruct2.sFL);
            lasFileDataStruct3.sRM = new String(lasFileDataStruct2.sRM);
            lasFileDataStruct3.sRMT = new String(lasFileDataStruct2.sRMT);
            lasFileDataStruct3.sRMF = new String(lasFileDataStruct2.sRMF);
            lasFileDataStruct3.sRMFT = new String(lasFileDataStruct2.sRMFT);
            lasFileDataStruct3.sRMC = new String(lasFileDataStruct2.sRMC);
            lasFileDataStruct3.sRMCT = new String(lasFileDataStruct2.sRMCT);
            lasFileDataStruct3.sTMAX = new String(lasFileDataStruct2.sTMAX);
            lasFileDataStruct3.iParamRows = lasFileDataStruct2.iParamRows;
            lasFileDataStruct3.iParamCols = lasFileDataStruct2.iParamCols;
            lasFileDataStruct3.sParams = new String[lasFileDataStruct3.iParamRows][lasFileDataStruct3.iParamCols];
            for (n2 = 0; n2 < lasFileDataStruct3.iParamRows; ++n2) {
                for (n = 0; n < lasFileDataStruct3.iParamCols; ++n) {
                    lasFileDataStruct3.sParams[n2][n] = new String(lasFileDataStruct2.sParams[n2][n]);
                }
            }
            lasFileDataStruct3.iLogs = lasFileDataStruct2.iLogs;
            if (lasFileDataStruct2.iLogs > 0) {
                lasFileDataStruct3.stLAS3 = new las3Struct[lasFileDataStruct2.iLogs];
                for (n2 = 0; n2 < lasFileDataStruct2.iLogs; ++n2) {
                    lasFileDataStruct3.stLAS3[n2] = las3Utility.copyWOData(lasFileDataStruct2.stLAS3[n2]);
                }
            }
            lasFileDataStruct3.sUnknown = new String[4][2];
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 2; ++n) {
                    lasFileDataStruct3.sUnknown[n2][n] = new String(lasFileDataStruct2.sUnknown[n2][n]);
                }
            }
        }
        return lasFileDataStruct3;
    }

    public static double[][] setData(int n, int n2, double d, double d2, lasFileDataStruct lasFileDataStruct2) {
        int n3 = 0;
        int n4 = 0;
        double[][] dArray = null;
        double[] dArray2 = null;
        if (n2 > -1 && lasFileDataStruct2 != null && lasFileDataStruct2.checkData(n2)) {
            dArray2 = lasFileDataStruct2.getData(n2);
            dArray = new double[lasFileDataStruct2.iRows][3];
            for (n3 = 0; n3 < lasFileDataStruct2.iRows; ++n3) {
                dArray[n3][0] = lasFileDataStruct2.depths[n3];
                dArray[n3][1] = dArray2[n3];
                dArray[n3][2] = 0.0;
            }
            dArray = lasFileDataUtility.trim(lasFileDataStruct2.iRows, 3, 1, lasFileDataStruct2.dNull, d, d2, dArray);
            n4 = dArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                switch (n) {
                    case 0: {
                        dArray[n3][1] = dArray[n3][1] > lasFileDataStruct2.dNull ? 1000.0 / dArray[n3][1] : lasFileDataStruct2.dNull;
                    }
                }
            }
            dArray = lasFileDataUtility.bubbleSort(1, n4, dArray);
            block9: for (n3 = 0; n3 < n4; ++n3) {
                switch (n) {
                    case 0: {
                        dArray[n3][2] = 0.0;
                        if (dArray[n3][1] > lasFileDataStruct2.dNull) {
                            dArray[n3][2] = 16 * n3 / n4;
                        }
                        if (!(dArray[n3][2] > 15.0)) continue block9;
                        dArray[n3][2] = 15.0;
                        continue block9;
                    }
                    case 1: {
                        dArray[n3][2] = 16 * n3 / n4;
                        if (!(dArray[n3][2] > 15.0)) continue block9;
                        dArray[n3][2] = 15.0;
                    }
                }
            }
            dArray = lasFileDataUtility.bubbleSort(0, n4, dArray);
        }
        return dArray;
    }

    public static double[][] trim(int n, int n2, int n3, double d, double d2, double d3, double[][] dArray) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double[][] dArray2 = null;
        for (n4 = 0; n4 < n; ++n4) {
            if (!(dArray[n4][n3] > d) || !(dArray[n4][0] >= d2) || !(dArray[n4][0] <= d3)) continue;
            ++n7;
        }
        dArray2 = new double[n7][n2];
        for (n4 = 0; n4 < n; ++n4) {
            if (!(dArray[n4][n3] > d) || !(dArray[n4][0] >= d2) || !(dArray[n4][0] <= d3) || n6 >= n7) continue;
            for (n5 = 0; n5 < n2; ++n5) {
                dArray2[n6][n5] = dArray[n4][n5];
            }
            ++n6;
        }
        return dArray2;
    }

    public static double[][] bubbleSort(int n, int n2, double[][] dArray) {
        boolean bl = true;
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        if (n2 > 1) {
            while (bl) {
                bl = false;
                for (int i = 0; i < n2 - 1; ++i) {
                    if (!(dArray[i][n] > dArray[i + 1][n])) continue;
                    bl = true;
                    dArray2[0] = dArray[i][0];
                    dArray2[1] = dArray[i][1];
                    dArray2[2] = dArray[i][2];
                    dArray[i][0] = dArray[i + 1][0];
                    dArray[i][1] = dArray[i + 1][1];
                    dArray[i][2] = dArray[i + 1][2];
                    dArray[i + 1][0] = dArray2[0];
                    dArray[i + 1][1] = dArray2[1];
                    dArray[i + 1][2] = dArray2[2];
                }
            }
        }
        return dArray;
    }

    public static void print(lasFileDataStruct lasFileDataStruct2) {
        if (lasFileDataStruct2 != null) {
            System.out.println("Start Depth: " + lasFileDataStruct2.depthStart + "\n" + "End Depth:   " + lasFileDataStruct2.depthEnd + "\n" + "Step By:     " + lasFileDataStruct2.depthStep + "\n" + "NULL Value:  " + lasFileDataStruct2.dNull + "\n\n");
            for (int i = 0; i < lasFileDataStruct2.iRows; ++i) {
                System.out.print("<" + lasFileDataStruct2.depths[i] + "> ");
                if (lasFileDataStruct2.iGR > -1) {
                    System.out.print("<GR=" + lasFileDataStruct2.dGR[i] + "> ");
                }
                if (lasFileDataStruct2.iCGR > -1) {
                    System.out.print("<CGR=" + lasFileDataStruct2.dCGR[i] + "> ");
                }
                if (lasFileDataStruct2.iSP > -1) {
                    System.out.print("<SP=" + lasFileDataStruct2.dSP[i] + "> ");
                }
                if (lasFileDataStruct2.iCAL > -1) {
                    System.out.print("<CAL=" + lasFileDataStruct2.dCAL[i] + "> ");
                }
                if (lasFileDataStruct2.iNPHI > -1) {
                    System.out.print("<NPHI=" + lasFileDataStruct2.dNPHI[i] + "> ");
                }
                if (lasFileDataStruct2.iPE > -1) {
                    System.out.print("<PE=" + lasFileDataStruct2.dPE[i] + "> ");
                }
                if (lasFileDataStruct2.iRHOB > -1) {
                    System.out.print("<RHOB=" + lasFileDataStruct2.dRHOB[i] + "> ");
                }
                if (lasFileDataStruct2.iDPHI > -1) {
                    System.out.print("<DPHI=" + lasFileDataStruct2.dDPHI[i] + "> ");
                }
                if (lasFileDataStruct2.iRHO > -1) {
                    System.out.print("<RHO=" + lasFileDataStruct2.dRHO[i] + "> ");
                }
                if (lasFileDataStruct2.iDT > -1) {
                    System.out.print("<DT=" + lasFileDataStruct2.dDT[i] + "> ");
                }
                if (lasFileDataStruct2.iSPHI > -1) {
                    System.out.print("<SPHI=" + lasFileDataStruct2.dSPHI[i] + "> ");
                }
                if (lasFileDataStruct2.iCOND > -1) {
                    System.out.print("<COND=" + lasFileDataStruct2.dCOND[i] + "> ");
                }
                if (lasFileDataStruct2.iCILD > -1) {
                    System.out.print("<CILD=" + lasFileDataStruct2.dCILD[i] + "> ");
                }
                if (lasFileDataStruct2.iCILM > -1) {
                    System.out.print("<CILM=" + lasFileDataStruct2.dCILM[i] + "> ");
                }
                if (lasFileDataStruct2.iRES > -1) {
                    System.out.print("<RES=" + lasFileDataStruct2.dRES[i] + "> ");
                }
                if (lasFileDataStruct2.iRMED > -1) {
                    System.out.print("<RMED=" + lasFileDataStruct2.dRMED[i] + "> ");
                }
                if (lasFileDataStruct2.iRDEP > -1) {
                    System.out.print("<RDEP=" + lasFileDataStruct2.dRDEP[i] + "> ");
                }
                if (lasFileDataStruct2.iRSHAL > -1) {
                    System.out.print("<RSHAL=" + lasFileDataStruct2.dRSHAL[i] + "> ");
                }
                if (lasFileDataStruct2.iILD > -1) {
                    System.out.print("<ILD=" + lasFileDataStruct2.dILD[i] + "> ");
                }
                if (lasFileDataStruct2.iILM > -1) {
                    System.out.print("<ILM=" + lasFileDataStruct2.dILM[i] + "> ");
                }
                if (lasFileDataStruct2.iSFLU > -1) {
                    System.out.print("<SFLU=" + lasFileDataStruct2.dSFLU[i] + "> ");
                }
                if (lasFileDataStruct2.iLL > -1) {
                    System.out.print("<LL=" + lasFileDataStruct2.dLL[i] + "> ");
                }
                if (lasFileDataStruct2.iMLL > -1) {
                    System.out.print("<MLL=" + lasFileDataStruct2.dMLL[i] + "> ");
                }
                if (lasFileDataStruct2.iLL8 > -1) {
                    System.out.print("<LL8=" + lasFileDataStruct2.dLL8[i] + "> ");
                }
                if (lasFileDataStruct2.iLN > -1) {
                    System.out.print("<LN=" + lasFileDataStruct2.dLN[i] + "> ");
                }
                if (lasFileDataStruct2.iSN > -1) {
                    System.out.print("<SN=" + lasFileDataStruct2.dSN[i] + "> ");
                }
                if (lasFileDataStruct2.iMNOR > -1) {
                    System.out.print("<MNOR=" + lasFileDataStruct2.dMNOR[i] + "> ");
                }
                if (lasFileDataStruct2.iMSFL > -1) {
                    System.out.print("<MSFL=" + lasFileDataStruct2.dMSFL[i] + "> ");
                }
                if (lasFileDataStruct2.iMINV > -1) {
                    System.out.print("<MINV=" + lasFileDataStruct2.dMINV[i] + "> ");
                }
                if (lasFileDataStruct2.iAHT10 > -1) {
                    System.out.print("<AHT10=" + lasFileDataStruct2.dAHT10[i] + "> ");
                }
                if (lasFileDataStruct2.iAHT20 > -1) {
                    System.out.print("<AHT20=" + lasFileDataStruct2.dAHT20[i] + "> ");
                }
                if (lasFileDataStruct2.iAHT30 > -1) {
                    System.out.print("<AHT30=" + lasFileDataStruct2.dAHT30[i] + "> ");
                }
                if (lasFileDataStruct2.iAHT60 > -1) {
                    System.out.print("<AHT60=" + lasFileDataStruct2.dAHT60[i] + "> ");
                }
                if (lasFileDataStruct2.iAHT90 > -1) {
                    System.out.print("<AHT90=" + lasFileDataStruct2.dAHT90[i] + "> ");
                }
                if (lasFileDataStruct2.iTh > -1) {
                    System.out.print("<Th=" + lasFileDataStruct2.dTh[i] + "> ");
                }
                if (lasFileDataStruct2.iU > -1) {
                    System.out.print("<U=" + lasFileDataStruct2.dU[i] + "> ");
                }
                if (lasFileDataStruct2.iK > -1) {
                    System.out.print("<K=" + lasFileDataStruct2.dK[i] + "> ");
                }
                if (lasFileDataStruct2.iLIN_1 > -1) {
                    System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_1[i] + "> ");
                }
                if (lasFileDataStruct2.iLIN_2 > -1) {
                    System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_2[i] + "> ");
                }
                if (lasFileDataStruct2.iLIN_3 > -1) {
                    System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_3[i] + "> ");
                }
                if (lasFileDataStruct2.iLIN_4 > -1) {
                    System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_4[i] + "> ");
                }
                if (lasFileDataStruct2.iLOG_1 > -1) {
                    System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_1[i] + "> ");
                }
                if (lasFileDataStruct2.iLOG_2 > -1) {
                    System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_2[i] + "> ");
                }
                if (lasFileDataStruct2.iLOG_3 > -1) {
                    System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_3[i] + "> ");
                }
                if (lasFileDataStruct2.iLOG_4 > -1) {
                    System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_4[i] + "> ");
                }
                System.out.println("");
            }
        }
    }

    public static void print(int n, lasFileDataStruct lasFileDataStruct2) {
        int n2 = 0;
        if (lasFileDataStruct2 != null && n < lasFileDataStruct2.iRows && n > -1) {
            n2 = n;
            System.out.print("<" + lasFileDataStruct2.depths[n2] + "> ");
            if (lasFileDataStruct2.iGR > -1) {
                System.out.print("<GR=" + lasFileDataStruct2.dGR[n2] + "> ");
            }
            if (lasFileDataStruct2.iCGR > -1) {
                System.out.print("<CGR=" + lasFileDataStruct2.dCGR[n2] + "> ");
            }
            if (lasFileDataStruct2.iSP > -1) {
                System.out.print("<SP=" + lasFileDataStruct2.dSP[n2] + "> ");
            }
            if (lasFileDataStruct2.iCAL > -1) {
                System.out.print("<CAL=" + lasFileDataStruct2.dCAL[n2] + "> ");
            }
            if (lasFileDataStruct2.iNPHI > -1) {
                System.out.print("<NPHI=" + lasFileDataStruct2.dNPHI[n2] + "> ");
            }
            if (lasFileDataStruct2.iPE > -1) {
                System.out.print("<PE=" + lasFileDataStruct2.dPE[n2] + "> ");
            }
            if (lasFileDataStruct2.iRHOB > -1) {
                System.out.print("<RHOB=" + lasFileDataStruct2.dRHOB[n2] + "> ");
            }
            if (lasFileDataStruct2.iDPHI > -1) {
                System.out.print("<DPHI=" + lasFileDataStruct2.dDPHI[n2] + "> ");
            }
            if (lasFileDataStruct2.iRHO > -1) {
                System.out.print("<RHO=" + lasFileDataStruct2.dRHO[n2] + "> ");
            }
            if (lasFileDataStruct2.iDT > -1) {
                System.out.print("<DT=" + lasFileDataStruct2.dDT[n2] + "> ");
            }
            if (lasFileDataStruct2.iSPHI > -1) {
                System.out.print("<SPHI=" + lasFileDataStruct2.dSPHI[n2] + "> ");
            }
            if (lasFileDataStruct2.iCOND > -1) {
                System.out.print("<COND=" + lasFileDataStruct2.dCOND[n2] + "> ");
            }
            if (lasFileDataStruct2.iCILD > -1) {
                System.out.print("<CILD=" + lasFileDataStruct2.dCILD[n2] + "> ");
            }
            if (lasFileDataStruct2.iCILM > -1) {
                System.out.print("<CILM=" + lasFileDataStruct2.dCILM[n2] + "> ");
            }
            if (lasFileDataStruct2.iRES > -1) {
                System.out.print("<RES=" + lasFileDataStruct2.dRES[n2] + "> ");
            }
            if (lasFileDataStruct2.iRMED > -1) {
                System.out.print("<RMED=" + lasFileDataStruct2.dRMED[n2] + "> ");
            }
            if (lasFileDataStruct2.iRDEP > -1) {
                System.out.print("<RDEP=" + lasFileDataStruct2.dRDEP[n2] + "> ");
            }
            if (lasFileDataStruct2.iRSHAL > -1) {
                System.out.print("<RSHAL=" + lasFileDataStruct2.dRSHAL[n2] + "> ");
            }
            if (lasFileDataStruct2.iILD > -1) {
                System.out.print("<ILD=" + lasFileDataStruct2.dILD[n2] + "> ");
            }
            if (lasFileDataStruct2.iILM > -1) {
                System.out.print("<ILM=" + lasFileDataStruct2.dILM[n2] + "> ");
            }
            if (lasFileDataStruct2.iSFLU > -1) {
                System.out.print("<SFLU=" + lasFileDataStruct2.dSFLU[n2] + "> ");
            }
            if (lasFileDataStruct2.iLL > -1) {
                System.out.print("<LL=" + lasFileDataStruct2.dLL[n2] + "> ");
            }
            if (lasFileDataStruct2.iMLL > -1) {
                System.out.print("<MLL=" + lasFileDataStruct2.dMLL[n2] + "> ");
            }
            if (lasFileDataStruct2.iLL8 > -1) {
                System.out.print("<LL8=" + lasFileDataStruct2.dLL8[n2] + "> ");
            }
            if (lasFileDataStruct2.iLN > -1) {
                System.out.print("<LN=" + lasFileDataStruct2.dLN[n2] + "> ");
            }
            if (lasFileDataStruct2.iSN > -1) {
                System.out.print("<SN=" + lasFileDataStruct2.dSN[n2] + "> ");
            }
            if (lasFileDataStruct2.iMNOR > -1) {
                System.out.print("<MNOR=" + lasFileDataStruct2.dMNOR[n2] + "> ");
            }
            if (lasFileDataStruct2.iMSFL > -1) {
                System.out.print("<MSFL=" + lasFileDataStruct2.dMSFL[n2] + "> ");
            }
            if (lasFileDataStruct2.iMINV > -1) {
                System.out.print("<MINV=" + lasFileDataStruct2.dMINV[n2] + "> ");
            }
            if (lasFileDataStruct2.iAHT10 > -1) {
                System.out.print("<AHT10=" + lasFileDataStruct2.dAHT10[n2] + "> ");
            }
            if (lasFileDataStruct2.iAHT20 > -1) {
                System.out.print("<AHT20=" + lasFileDataStruct2.dAHT20[n2] + "> ");
            }
            if (lasFileDataStruct2.iAHT30 > -1) {
                System.out.print("<AHT30=" + lasFileDataStruct2.dAHT30[n2] + "> ");
            }
            if (lasFileDataStruct2.iAHT60 > -1) {
                System.out.print("<AHT60=" + lasFileDataStruct2.dAHT60[n2] + "> ");
            }
            if (lasFileDataStruct2.iAHT90 > -1) {
                System.out.print("<AHT90=" + lasFileDataStruct2.dAHT90[n2] + "> ");
            }
            if (lasFileDataStruct2.iTh > -1) {
                System.out.print("<Th=" + lasFileDataStruct2.dTh[n2] + "> ");
            }
            if (lasFileDataStruct2.iU > -1) {
                System.out.print("<U=" + lasFileDataStruct2.dU[n2] + "> ");
            }
            if (lasFileDataStruct2.iK > -1) {
                System.out.print("<K=" + lasFileDataStruct2.dK[n2] + "> ");
            }
            if (lasFileDataStruct2.iLIN_1 > -1) {
                System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_1[n2] + "> ");
            }
            if (lasFileDataStruct2.iLIN_2 > -1) {
                System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_2[n2] + "> ");
            }
            if (lasFileDataStruct2.iLIN_3 > -1) {
                System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_3[n2] + "> ");
            }
            if (lasFileDataStruct2.iLIN_4 > -1) {
                System.out.print("<Linear 1=" + lasFileDataStruct2.dLIN_4[n2] + "> ");
            }
            if (lasFileDataStruct2.iLOG_1 > -1) {
                System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_1[n2] + "> ");
            }
            if (lasFileDataStruct2.iLOG_2 > -1) {
                System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_2[n2] + "> ");
            }
            if (lasFileDataStruct2.iLOG_3 > -1) {
                System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_3[n2] + "> ");
            }
            if (lasFileDataStruct2.iLOG_4 > -1) {
                System.out.print("<Log 1=" + lasFileDataStruct2.dLOG_4[n2] + "> ");
            }
            System.out.println("");
        }
    }

    public static void printHeader(lasFileDataStruct lasFileDataStruct2) {
        if (lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.sAPI.length() > 0) {
                System.out.println(lasFileDataStruct2.sAPI);
            }
            if (lasFileDataStruct2.sName.length() > 0) {
                System.out.println(lasFileDataStruct2.sName);
            }
            if (lasFileDataStruct2.state.length() > 0) {
                System.out.println(lasFileDataStruct2.state);
            }
            if (lasFileDataStruct2.sCounty.length() > 0) {
                System.out.println(lasFileDataStruct2.sCounty);
            }
            System.out.println("Lat: " + lasFileDataStruct2.dLatitude + " " + "Long: " + lasFileDataStruct2.dLongitude);
            System.out.println("KB: " + lasFileDataStruct2.dKB + " " + "GL: " + lasFileDataStruct2.dGL + " " + "TD: " + lasFileDataStruct2.dTD);
            System.out.println("Status: " + lasFileDataStruct2.status);
            if (lasFileDataStruct2.sReadMethod.length() > 0) {
                System.out.println("RD " + lasFileDataStruct2.sReadMethod);
            }
            if (lasFileDataStruct2.sDirectory.length() > 0) {
                System.out.println("Dir " + lasFileDataStruct2.sDirectory);
            }
            if (lasFileDataStruct2.sFilename.length() > 0) {
                System.out.println("File " + lasFileDataStruct2.sFilename);
            }
            if (lasFileDataStruct2.sVersion.length() > 0) {
                System.out.println("VER " + lasFileDataStruct2.sVersion);
            }
            System.out.println("Start Depth: " + lasFileDataStruct2.depthStart + "\n" + "End Depth:   " + lasFileDataStruct2.depthEnd + "\n" + "Step By:     " + lasFileDataStruct2.depthStep + "\n" + "NULL Value:  " + lasFileDataStruct2.dNull + "\n\n");
            if (lasFileDataStruct2.sPDAT.length() > 0) {
                System.out.println("PERM " + lasFileDataStruct2.sPDAT);
            }
            System.out.println("Above: " + lasFileDataStruct2.dAPD);
            if (lasFileDataStruct2.sDREF.length() > 0) {
                System.out.println("REF " + lasFileDataStruct2.sDREF);
            }
            System.out.println("Elev: " + lasFileDataStruct2.dElevation);
            if (lasFileDataStruct2.dTDD > 0.0) {
                System.out.println("TDD " + lasFileDataStruct2.dTDD);
            }
            if (lasFileDataStruct2.dTLD > 0.0) {
                System.out.println("TDL " + lasFileDataStruct2.dTLD);
            }
            if (lasFileDataStruct2.dCSGL > 0.0) {
                System.out.println("CSGL " + lasFileDataStruct2.dCSGL);
            }
            if (lasFileDataStruct2.dCSGD > 0.0) {
                System.out.println("CSGD " + lasFileDataStruct2.dCSGD);
            }
            if (lasFileDataStruct2.dCSGS > 0.0) {
                System.out.println("CSGS " + lasFileDataStruct2.dCSGS);
            }
            if (lasFileDataStruct2.dCSGW > 0.0) {
                System.out.println("CSGW " + lasFileDataStruct2.dCSGW);
            }
            if (lasFileDataStruct2.dBS > 0.0) {
                System.out.println("BS " + lasFileDataStruct2.dBS);
            }
            if (lasFileDataStruct2.sMUD.length() > 0) {
                System.out.println("MUD " + lasFileDataStruct2.sMUD);
            }
            if (lasFileDataStruct2.sMUDS.length() > 0) {
                System.out.println("MUDS " + lasFileDataStruct2.sMUDS);
            }
            if (lasFileDataStruct2.dMUDD > 0.0) {
                System.out.println("MUDD " + lasFileDataStruct2.dMUDD);
            }
            if (lasFileDataStruct2.dMUDV > 0.0) {
                System.out.println("MUDV " + lasFileDataStruct2.dMUDV);
            }
            if (lasFileDataStruct2.dFL > 0.0) {
                System.out.println("FL " + lasFileDataStruct2.dFL);
            }
            if (lasFileDataStruct2.dPH > 0.0) {
                System.out.println("PH " + lasFileDataStruct2.dPH);
            }
            if (lasFileDataStruct2.dRM > 0.0) {
                System.out.println("RM " + lasFileDataStruct2.dRM);
            }
            if (lasFileDataStruct2.dRMT > 0.0) {
                System.out.println("RMT " + lasFileDataStruct2.dRMT);
            }
            if (lasFileDataStruct2.dRMF > 0.0) {
                System.out.println("RMF " + lasFileDataStruct2.dRMF);
            }
            if (lasFileDataStruct2.dRMFT > 0.0) {
                System.out.println("RMFT " + lasFileDataStruct2.dRMFT);
            }
            if (lasFileDataStruct2.dRMC > 0.0) {
                System.out.println("RMC " + lasFileDataStruct2.dRMC);
            }
            if (lasFileDataStruct2.dRMCT > 0.0) {
                System.out.println("RMCT " + lasFileDataStruct2.dRMCT);
            }
            if (lasFileDataStruct2.dTMAX > 0.0) {
                System.out.println("TMAX " + lasFileDataStruct2.dTMAX);
            }
            if (lasFileDataStruct2.sTIMC.length() > 0) {
                System.out.println("TIMC " + lasFileDataStruct2.sTIMC);
            }
            if (lasFileDataStruct2.sTIML.length() > 0) {
                System.out.println("TIML " + lasFileDataStruct2.sTIML);
            }
            if (lasFileDataStruct2.sUNIT.length() > 0) {
                System.out.println("UNIT " + lasFileDataStruct2.sUNIT);
            }
            if (lasFileDataStruct2.sBASE.length() > 0) {
                System.out.println("BASE " + lasFileDataStruct2.sBASE);
            }
            if (lasFileDataStruct2.sENG.length() > 0) {
                System.out.println("ENG " + lasFileDataStruct2.sENG);
            }
            if (lasFileDataStruct2.sWIT.length() > 0) {
                System.out.println("WIT " + lasFileDataStruct2.sWIT);
            }
        }
    }

    public static void printParameters(int n, int n2, String[][] stringArray) {
        int n3 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl = false;
        int n4 = 5;
        int n5 = 8;
        int n6 = 10;
        int n7 = 0;
        int n8 = 15;
        if (n > 0) {
            string = new String("~Log_Parameter A\n");
            n8 = 10;
            if (n > 0) {
                for (n3 = 0; n3 < n; ++n3) {
                    n7 = stringArray[n3][0].length();
                    if (n4 < n7) {
                        n4 = n7;
                    }
                    if (n5 < (n7 = stringArray[n3][1].length())) {
                        n5 = n7;
                    }
                    if (n6 >= (n7 = stringArray[n3][2].length())) continue;
                    n6 = n7;
                }
            }
            string2 = String.format("%-" + n4 + "s ", "#MNEM");
            string3 = String.format(".%-" + n5 + "s ", "UNIT");
            string4 = String.format(" %" + n6 + "s ", "VALUE");
            string5 = String.format(" : %-30s ", "DESCRIPTION");
            string6 = String.format("{%s}", "FORMAT");
            string7 = String.format(" | %s", "ASSOCIATION");
            string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            for (n3 = 0; n3 < n; ++n3) {
                string2 = String.format(" %-" + n4 + "s ", stringArray[n3][0]);
                string3 = String.format(".%-" + n5 + "s ", stringArray[n3][1]);
                string4 = String.format(" %" + n6 + "s ", stringArray[n3][2]);
                string5 = String.format(" : %-30s ", stringArray[n3][3]);
                string6 = new String("");
                if (stringArray[n3][4].length() > 0) {
                    string6 = String.format("{%s}", stringArray[n3][4]);
                }
                string7 = new String("");
                if (stringArray[n3][5].length() > 0) {
                    string7 = String.format(" | %s", stringArray[n3][5]);
                }
                string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            }
            string = new String(string + "\n");
            System.out.println(string);
        }
    }

    public static void printParameters(las3Struct las3Struct2) {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 10;
        int n6 = 0;
        int n7 = 15;
        if (las3Struct2 != null && las3Struct2.iParamRows > 0) {
            string = las3Struct2.iType == 2 ? new String("~Parameter\n") : new String("~" + las3Struct2.sType + "_Parameter\n");
            n2 = las3Struct2.iArray + 1;
            string = new String("~" + las3Struct2.sType + "_Parameter[" + n2 + "]\n");
            n7 = 10;
            if (las3Struct2.iParamRows > 0) {
                for (n = 0; n < las3Struct2.iParamRows; ++n) {
                    n6 = las3Struct2.sParams[n][0].length();
                    if (n3 < n6) {
                        n3 = n6;
                    }
                    if (n4 < (n6 = las3Struct2.sParams[n][1].length())) {
                        n4 = n6;
                    }
                    if (n5 >= (n6 = las3Struct2.sParams[n][2].length())) continue;
                    n5 = n6;
                }
            }
            string2 = String.format("%-" + n3 + "s ", "#MNEM");
            string3 = String.format(".%-" + n4 + "s ", "UNIT");
            string4 = String.format(" %" + n5 + "s ", "VALUE");
            string5 = String.format(" : %-30s ", "DESCRIPTION");
            string6 = String.format("{%s}", "FORMAT");
            string7 = String.format(" | %s", "ASSOCIATION");
            string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            for (n = 0; n < las3Struct2.iParamRows; ++n) {
                string2 = String.format(" %-" + n3 + "s ", las3Struct2.sParams[n][0]);
                string3 = String.format(".%-" + n4 + "s ", las3Struct2.sParams[n][1]);
                string4 = String.format(" %" + n5 + "s ", las3Struct2.sParams[n][2]);
                string5 = String.format(" : %-30s ", las3Struct2.sParams[n][3]);
                string6 = new String("");
                if (las3Struct2.sParams[n][4].length() > 0) {
                    string6 = String.format("{%s}", las3Struct2.sParams[n][4]);
                }
                string7 = new String("");
                if (las3Struct2.sParams[n][5].length() > 0) {
                    string7 = String.format(" | %s", las3Struct2.sParams[n][5]);
                }
                string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            }
            string = new String(string + "\n");
            System.out.println(string);
        }
    }

    public static void printCurvesIQ(las3Struct las3Struct2) {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 10;
        int n6 = 0;
        String string8 = "";
        int n7 = 15;
        if (las3Struct2 != null && las3Struct2.iSelectRows > 0) {
            if (las3Struct2.sType.equals("Log")) {
                string8 = "Las";
            } else if (las3Struct2.sType.equals("Core")) {
                string8 = "Rock";
            }
            n2 = las3Struct2.iArray + 1;
            string = new String("~IQ_" + string8 + "_Parameter[" + n2 + "]\n");
            n7 = 10;
            if (las3Struct2.iSelectRows > 0) {
                for (n = 0; n < las3Struct2.iSelectRows; ++n) {
                    n6 = las3Struct2.select[n][0].length();
                    if (n3 < n6) {
                        n3 = n6;
                    }
                    if (n4 < (n6 = las3Struct2.select[n][1].length())) {
                        n4 = n6;
                    }
                    if (n5 >= (n6 = las3Struct2.select[n][2].length())) continue;
                    n5 = n6;
                }
            }
            string2 = String.format("%-" + n3 + "s ", "#MNEM");
            string3 = String.format(".%-" + n4 + "s ", "UNIT");
            string4 = String.format(" %" + n5 + "s ", "VALUE");
            string5 = String.format(" : %-30s ", "DESCRIPTION");
            string6 = String.format("{%s}", "FORMAT");
            string7 = String.format(" | %s", "ASSOCIATION");
            string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            for (n = 0; n < las3Struct2.iSelectRows; ++n) {
                string2 = String.format(" %-" + n3 + "s ", las3Struct2.select[n][0]);
                string3 = String.format(".%-" + n4 + "s ", las3Struct2.select[n][1]);
                string4 = String.format(" %" + n5 + "s ", las3Struct2.select[n][2]);
                string5 = String.format(" : %-30s ", las3Struct2.select[n][3]);
                string6 = new String("");
                if (las3Struct2.select[n][4].length() > 0) {
                    string6 = String.format("{%s}", las3Struct2.select[n][4]);
                }
                string7 = new String("");
                if (las3Struct2.select[n][5].length() > 0) {
                    string7 = String.format(" | %s", las3Struct2.select[n][5]);
                }
                string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            }
            string = new String(string + "\n");
            System.out.println(string);
        }
    }

    public static void printCurves(las3Struct las3Struct2) {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 10;
        int n6 = 0;
        int n7 = 15;
        if (las3Struct2 != null && las3Struct2.iCurveRows > 0) {
            n2 = las3Struct2.iArray + 1;
            string = new String("~" + las3Struct2.sType + "_Definition[" + n2 + "]\n");
            n7 = 10;
            for (n = 0; n < las3Struct2.iCurveRows; ++n) {
                n6 = las3Struct2.sCurves[n][0].length();
                if (n3 < n6) {
                    n3 = n6;
                }
                if (n4 < (n6 = las3Struct2.sCurves[n][1].length())) {
                    n4 = n6;
                }
                if (n5 >= (n6 = las3Struct2.sCurves[n][2].length())) continue;
                n5 = n6;
            }
            string2 = String.format("%-" + n3 + "s ", "#MNEM");
            string3 = String.format(".%-" + n4 + "s ", "UNIT");
            string4 = String.format(" %" + n5 + "s ", "VALUE");
            string5 = String.format(" : %-30s ", "DESCRIPTION");
            string6 = String.format("{%s}", "FORMAT");
            string7 = String.format(" | %s", "ASSOCIATION");
            string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            for (n = 0; n < las3Struct2.iCurveRows; ++n) {
                string2 = String.format(" %-" + n3 + "s ", las3Struct2.sCurves[n][0]);
                string3 = String.format(".%-" + n4 + "s ", las3Struct2.sCurves[n][1]);
                string4 = String.format(" %" + n5 + "s ", las3Struct2.sCurves[n][2]);
                string5 = String.format(" : %-30s ", las3Struct2.sCurves[n][3]);
                string6 = new String("");
                if (las3Struct2.sCurves[n][4].length() > 0) {
                    string6 = String.format("{%s}", las3Struct2.sCurves[n][4]);
                }
                string7 = new String("");
                if (las3Struct2.sCurves[n][5].length() > 0) {
                    string7 = String.format(" | %s", las3Struct2.sCurves[n][5]);
                }
                string = new String(string + string2 + string3 + string4 + string5 + string6 + string7 + "\n");
            }
            string = new String(string + "\n");
            System.out.println(string);
        }
    }
}

