/*
 * Decompiled with CFR 0.152.
 */
package kgs.gui;

import cmn.cmnLASFileListStruct;
import cmn.cmnString;
import cmn.cmnStruct;
import horizon.regions.io.ReadRegionsXMLFile;
import horizon.regions.regionsListStruct;
import horizon.strat.gui.stratKGSFrame;
import horizon.strat.stratListStruct;
import iqstrat.io.iqstratIOHeaders;
import iqstrat.iqstratHeadersListStruct;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.net.URL;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kgs.gui.kgsSearchKGSFrameFocusAdapter;
import kgs.gui.kgsWellListTable;
import kgs.io.kgsIORead;
import las.gui.lasFilesFrame;
import las.lasFileDataStruct;
import las3.las3ListStruct;
import rock.gui.rockImageFrame;
import rock.rockDataListStruct;
import rock.rockImagesListStruct;
import util.SwingWorker;
import util.utilWaitAnimation;

public class kgsSearchKGSFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private iqstratStruct stStruct = null;
    private cmnStruct stCMN = null;
    private int iTownship = 0;
    private String sTownship = "S";
    private int iRange = 0;
    private String sRange = "E";
    private int iSection = 0;
    private String sPath = "";
    private iqstratHeadersListStruct stList = null;
    private iqstratHeadersStruct stHeader = null;
    private stratListStruct stTops = null;
    private regionsListStruct stPerf = null;
    private rockDataListStruct stCore = null;
    private rockImagesListStruct stImages = null;
    private kgsWellListTable pTable = null;
    private lasFilesFrame pLASFiles = null;
    private stratKGSFrame pTopsFrame = null;
    private rockImageFrame pImages = null;
    private static final int _API = 0;
    private static final int _LEASE = 1;
    private static final int _TRS = 2;
    private int iSearch = 0;
    private JPanel pnlKGSTextSearch = new JPanel();
    private CardLayout cardLayout2 = new CardLayout();
    private JButton btnSelect = new JButton();
    private JRadioButton rbAPI = new JRadioButton();
    private JRadioButton rbLease = new JRadioButton();
    private JRadioButton rbTRS = new JRadioButton();
    private TitledBorder titledBorderText = null;
    private JPanel pnlKGSText = new JPanel();
    private JTextField txtText = new JTextField();
    private JTextField txtTownship = new JTextField();
    private JRadioButton rbNorth = new JRadioButton();
    private JRadioButton rbSouth = new JRadioButton();
    private JTextField txtRange = new JTextField();
    private JRadioButton rbEast = new JRadioButton();
    private JRadioButton rbWest = new JRadioButton();
    private JTextField txtSection = new JTextField();
    private JButton btnLAS = new JButton();
    private JButton btnTops = new JButton();
    private JButton btnCore = new JButton();
    private JButton btnImage = new JButton();
    private JButton btnClose = new JButton();
    private JButton btnSearch = new JButton();

    public kgsSearchKGSFrame(iqstratStruct iqstratStruct2, Observable observable) {
        try {
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.notifier = observable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Search for Data in Kansas Geological Survey Database:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "List of Oil & Gas Wells:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Search By:");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        this.titledBorderText = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Enter API-Number:");
        this.titledBorderText.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Township:");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Range:");
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Section:");
        titledBorder6.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder7 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Data Loaded:");
        titledBorder7.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder8 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Load Data:");
        titledBorder8.setTitleFont(new Font("Dialog", 1, 11));
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Search for Data on KGS Server");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        jPanel11.setLayout(new BorderLayout());
        this.btnSearch.setFont(new Font("Dialog", 1, 11));
        this.btnSearch.setActionCommand("btnSearch");
        this.btnSearch.setText("Search");
        this.btnSearch.addActionListener(this);
        jPanel2.setBorder(titledBorder3);
        jPanel2.setLayout(new BorderLayout());
        jPanel3.setLayout(new BorderLayout());
        this.rbAPI.setFont(new Font("Dialog", 1, 11));
        this.rbAPI.setSelected(true);
        this.rbAPI.setText("API-Number");
        this.rbAPI.addActionListener(this);
        this.rbLease.setFont(new Font("Dialog", 1, 11));
        this.rbLease.setHorizontalAlignment(0);
        this.rbLease.setText("Lease name");
        this.rbLease.addActionListener(this);
        this.rbTRS.setFont(new Font("Dialog", 1, 11));
        this.rbTRS.setText("Township Range Section");
        this.rbTRS.addActionListener(this);
        this.pnlKGSTextSearch.setLayout(this.cardLayout2);
        this.pnlKGSText.setBorder(this.titledBorderText);
        this.pnlKGSText.setLayout(new BorderLayout());
        this.txtText.setText("");
        this.txtText.setColumns(50);
        this.txtText.addFocusListener(new kgsSearchKGSFrameFocusAdapter(this));
        jPanel4.setLayout(new GridLayout());
        jPanel5.setBorder(titledBorder4);
        jPanel5.setLayout(new BorderLayout());
        this.txtTownship.setText("0");
        this.txtTownship.setColumns(4);
        this.txtTownship.setHorizontalAlignment(11);
        this.txtTownship.addFocusListener(new kgsSearchKGSFrameFocusAdapter(this));
        this.rbNorth.setText("N");
        this.rbNorth.addActionListener(this);
        this.rbSouth.setSelected(true);
        this.rbSouth.setText("S");
        this.rbSouth.addActionListener(this);
        jPanel6.setBorder(titledBorder5);
        jPanel6.setLayout(new BorderLayout());
        this.txtRange.setText("0");
        this.txtRange.setColumns(4);
        this.txtRange.setHorizontalAlignment(11);
        this.txtRange.addFocusListener(new kgsSearchKGSFrameFocusAdapter(this));
        this.rbEast.setSelected(true);
        this.rbEast.setText("E");
        this.rbEast.addActionListener(this);
        this.rbWest.setText("W");
        this.rbWest.addActionListener(this);
        jPanel7.setBorder(titledBorder6);
        jPanel7.setLayout(new BorderLayout());
        this.txtSection.setText("0");
        this.txtSection.setColumns(4);
        this.txtSection.setHorizontalAlignment(11);
        this.txtSection.addFocusListener(new kgsSearchKGSFrameFocusAdapter(this));
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(titledBorder2);
        this.pTable = new kgsWellListTable();
        jScrollPane = this.pTable.getScrollPane();
        jPanel10.setLayout(new GridLayout());
        jPanel10.setBorder(titledBorder8);
        this.btnLAS.setFont(new Font("Dialog", 1, 11));
        this.btnLAS.setText("LAS File Data");
        this.btnLAS.addActionListener(this);
        this.btnTops.setFont(new Font("Dialog", 1, 11));
        this.btnTops.setText("Top Picks");
        this.btnTops.addActionListener(this);
        this.btnCore.setFont(new Font("Dialog", 1, 11));
        this.btnCore.setText("Core Data");
        this.btnCore.addActionListener(this);
        this.btnImage.setFont(new Font("Dialog", 1, 11));
        this.btnImage.setText("Core Images");
        this.btnImage.addActionListener(this);
        jPanel9.setBorder(BorderFactory.createEtchedBorder());
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this);
        this.setWidgets();
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add((Component)this.rbAPI, "West");
        jPanel3.add((Component)this.rbLease, "Center");
        jPanel3.add((Component)this.rbTRS, "East");
        jPanel2.add((Component)this.pnlKGSTextSearch, "Center");
        this.pnlKGSTextSearch.add((Component)this.pnlKGSText, "TEXT");
        this.pnlKGSText.add((Component)this.txtText, "Center");
        this.pnlKGSTextSearch.add((Component)jPanel4, "TRS");
        jPanel4.add((Component)jPanel7, null);
        jPanel7.add((Component)this.txtSection, "East");
        jPanel4.add((Component)jPanel5, null);
        jPanel5.add((Component)this.txtTownship, "West");
        jPanel5.add((Component)this.rbNorth, "Center");
        jPanel5.add((Component)this.rbSouth, "East");
        jPanel4.add((Component)jPanel6, null);
        jPanel6.add((Component)this.txtRange, "West");
        jPanel6.add((Component)this.rbEast, "East");
        jPanel6.add((Component)this.rbWest, "Center");
        jPanel2.add((Component)jPanel11, "South");
        jPanel11.add((Component)this.btnSearch, "Center");
        buttonGroup.add(this.rbAPI);
        buttonGroup.add(this.rbLease);
        buttonGroup.add(this.rbTRS);
        buttonGroup2.add(this.rbNorth);
        buttonGroup2.add(this.rbSouth);
        buttonGroup3.add(this.rbEast);
        buttonGroup3.add(this.rbWest);
        this.getContentPane().add((Component)jPanel8, "Center");
        jPanel8.add((Component)jScrollPane, "Center");
        jPanel8.add((Component)jPanel10, "South");
        if (this.stStruct.bLAS != null) {
            if (this.stStruct.bLAS[2]) {
                jPanel10.add((Component)this.btnLAS, null);
            }
            if (this.stStruct.bLAS[6]) {
                jPanel10.add((Component)this.btnTops, null);
            }
            if (this.stStruct.bLAS[3]) {
                jPanel10.add((Component)this.btnCore, null);
            }
            if (this.stStruct.bLAS[17]) {
                jPanel10.add((Component)this.btnImage, null);
            }
        }
        this.getContentPane().add((Component)jPanel9, "South");
        jPanel9.add((Component)this.btnClose, null);
        this.setSize(new Dimension(500, 500));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public iqstratHeadersStruct getWellHeader() {
        return this.stHeader;
    }

    public las3ListStruct getLAS3Data() {
        return this.pLASFiles.getLAS3();
    }

    public lasFileDataStruct getLASData() {
        return this.pLASFiles.getLASDataStructure();
    }

    public double getStartingDepth() {
        return this.pLASFiles.getStartingDepth();
    }

    public double getEndingDepth() {
        return this.pLASFiles.getEndingDepth();
    }

    public int getColorlith() {
        return this.pLASFiles.getColorlith();
    }

    public stratListStruct getTops() {
        return this.pTopsFrame.getDownloadData();
    }

    public regionsListStruct getPerf() {
        ReadRegionsXMLFile readRegionsXMLFile = null;
        regionsListStruct regionsListStruct2 = null;
        int n = 1;
        this.stHeader = this.pTable.getRowData();
        if (this.stHeader != null) {
            readRegionsXMLFile = new ReadRegionsXMLFile(n);
            regionsListStruct2 = readRegionsXMLFile.Process("http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_perfs_dst_pkg.getXML?sAPI=" + this.stHeader.sAPI);
        }
        return regionsListStruct2;
    }

    public rockDataListStruct getRockData() {
        return this.stCore;
    }

    public rockImagesListStruct getRockImages() {
        return this.pImages.getData();
    }

    public void closeLASFile() {
        if (this.pLASFiles != null) {
            this.pLASFiles.close();
        }
        this.pLASFiles = null;
    }

    public void closeTops() {
        if (this.pTopsFrame != null) {
            this.pTopsFrame.close();
        }
        this.pTopsFrame = null;
    }

    public void closeCoreImages() {
        if (this.pImages != null) {
            this.pImages.close();
        }
        this.pImages = null;
    }

    private void setWidgets() {
        this.btnLAS.setEnabled(false);
        this.btnTops.setEnabled(false);
        this.btnCore.setEnabled(false);
        this.btnImage.setEnabled(false);
        if (this.pTable.getTotalRows() > 0) {
            this.btnLAS.setEnabled(true);
            this.btnTops.setEnabled(true);
            this.btnCore.setEnabled(true);
            this.btnImage.setEnabled(true);
        }
        if (this.rbAPI.isSelected()) {
            this.titledBorderText.setTitle("Enter API-Number :");
            this.pnlKGSText.updateUI();
            this.pnlKGSTextSearch.updateUI();
        } else if (this.rbLease.isSelected()) {
            this.titledBorderText.setTitle("Enter Lease (Drop Well Number, Not Case Sensitive):");
            this.pnlKGSText.updateUI();
            this.pnlKGSTextSearch.updateUI();
        }
    }

    private void WaitWellList() {
        URL uRL = null;
        try {
            uRL = new URL("http://www.kgs.ku.edu/stratigraphic/IQSTRAT//");
        }
        catch (Exception exception) {
            System.out.println("Wrong Image Directory" + exception);
        }
        final utilWaitAnimation utilWaitAnimation2 = new utilWaitAnimation(uRL);
        utilWaitAnimation2.startAnimation();
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                kgsSearchKGSFrame.this.search();
                return "OK";
            }

            @Override
            public void finished() {
                utilWaitAnimation2.stopAnimation();
            }
        };
        swingWorker.start();
    }

    private void loadLASData() {
        cmnLASFileListStruct cmnLASFileListStruct2 = null;
        String string = "";
        int n = 0;
        this.closeLASFile();
        this.stHeader = this.pTable.getRowData();
        if (this.stHeader != null) {
            if (this.stHeader.iLAS > 0) {
                cmnLASFileListStruct2 = kgsIORead.ReadLASFileInformation(this.stHeader.sAPI, 1);
                this.pLASFiles = new lasFilesFrame(this.stStruct, this.notifier, cmnLASFileListStruct2);
            } else {
                string = "There are no digital LAS Files for this well in the KGS Server.";
                n = -1;
            }
        } else {
            string = "No Well Record Exists";
            n = -1;
        }
        if (n == -1) {
            JOptionPane.showMessageDialog(null, string, "ERROR", 0);
        }
    }

    private void loadTOPSData() {
        String string = "";
        int n = 0;
        stratListStruct stratListStruct2 = null;
        this.closeTops();
        this.stHeader = this.pTable.getRowData();
        if (this.stHeader != null) {
            if (this.stHeader.iTops > 0) {
                this.stTops = kgsIORead.ReadWellRegions(this.stHeader.sAPI, this.stHeader.sKID, 1);
            } else {
                string = "There are no well tops for this well in the KGS Server.";
                n = -1;
            }
        } else {
            string = "No Well Record Exists";
            n = -1;
        }
        if (this.stTops != null) {
            this.pTopsFrame = new stratKGSFrame(this.notifier, this.stTops, stratListStruct2);
        }
    }

    public void loadCoreData() {
        String string = "";
        int n = 0;
        this.stHeader = this.pTable.getRowData();
        if (this.stHeader != null) {
            if (this.stHeader.iCore > 0) {
                this.stCore = kgsIORead.ReadCoreData(this.stHeader.sAPI, 1);
            } else {
                string = "There are no core data for this well in the KGS Server.";
                n = -1;
            }
        } else {
            string = "No Well Record Exists";
            n = -1;
        }
        if (this.stCore != null) {
            this.notifier.notifyObservers(new String("KGS Rock Data Loaded"));
        }
    }

    public void loadImages() {
        String string = "";
        int n = 0;
        this.closeCoreImages();
        this.stHeader = this.pTable.getRowData();
        if (this.stHeader != null) {
            if (this.stHeader.images > 0) {
                this.stImages = kgsIORead.ReadCoreImages(this.stHeader.sAPI, 1);
            } else {
                string = "There are no core images for this well in the KGS Server.";
                n = -1;
            }
        } else {
            string = "No Well Record Exists";
            n = -1;
        }
        if (this.stImages != null) {
            this.pImages = new rockImageFrame(this.stCMN, this.notifier, this.stImages);
        }
    }

    private void search() {
        this.stList = iqstratIOHeaders.getData(1, this.sPath);
        System.out.println(this.sPath);
        this.pTable.repopulateList(this.stList);
    }

    public void close() {
        this.notifier = null;
        this.stStruct = null;
        this.stCMN = null;
        this.sTownship = null;
        this.sRange = null;
        this.sPath = null;
        this.stList = null;
        this.stHeader = null;
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        if (this.stHeader != null) {
            this.stHeader.delete();
        }
        this.stHeader = null;
        if (this.stTops != null) {
            this.stTops.delete();
        }
        this.stTops = null;
        if (this.stPerf != null) {
            this.stPerf.delete();
        }
        this.stPerf = null;
        if (this.stCore != null) {
            this.stCore.delete();
        }
        this.stCore = null;
        if (this.stImages != null) {
            this.stImages.delete();
        }
        this.stImages = null;
        if (this.pTable != null) {
            this.pTable.close();
        }
        this.pTable = null;
        this.pnlKGSTextSearch = null;
        this.cardLayout2 = null;
        this.rbAPI = null;
        this.rbLease = null;
        this.rbTRS = null;
        this.titledBorderText = null;
        this.pnlKGSText = null;
        this.txtText = null;
        this.txtTownship = null;
        this.rbNorth = null;
        this.rbSouth = null;
        this.txtRange = null;
        this.rbEast = null;
        this.rbWest = null;
        this.txtSection = null;
        this.btnLAS = null;
        this.btnTops = null;
        this.btnCore = null;
        this.btnImage = null;
        this.closeLASFile();
        this.closeTops();
        this.closeCoreImages();
        this.btnClose = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSearch) {
            this.search();
        }
        if (actionEvent.getSource() == this.rbAPI) {
            this.iSearch = 0;
            this.cardLayout2.show(this.pnlKGSTextSearch, "TEXT");
        }
        if (actionEvent.getSource() == this.rbLease) {
            this.iSearch = 1;
            this.cardLayout2.show(this.pnlKGSTextSearch, "TEXT");
        }
        if (actionEvent.getSource() == this.rbTRS) {
            this.iSearch = 2;
            this.cardLayout2.show(this.pnlKGSTextSearch, "TRS");
        }
        if (actionEvent.getSource() == this.rbNorth || actionEvent.getSource() == this.rbSouth || actionEvent.getSource() == this.rbEast || actionEvent.getSource() == this.rbWest) {
            if (actionEvent.getSource() == this.rbNorth) {
                this.sTownship = "N";
            }
            if (actionEvent.getSource() == this.rbSouth) {
                this.sTownship = "S";
            }
            if (actionEvent.getSource() == this.rbEast) {
                this.sRange = "E";
            }
            if (actionEvent.getSource() == this.rbWest) {
                this.sRange = "W";
            }
            if (this.iTownship > 0 && this.iRange > 0 && this.iSection > 0) {
                this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange + "&iSection=" + this.iSection;
            } else if (this.iTownship > 0 && this.iRange > 0) {
                this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange;
            }
        }
        if (actionEvent.getSource() == this.btnLAS) {
            this.loadLASData();
        }
        if (actionEvent.getSource() == this.btnTops) {
            this.loadTOPSData();
        }
        if (actionEvent.getSource() == this.btnCore) {
            this.loadCoreData();
        }
        if (actionEvent.getSource() == this.btnImage) {
            this.loadImages();
        }
        this.setWidgets();
        if (actionEvent.getSource() == this.btnClose) {
            this.close();
        }
        if (this.pLASFiles != null) {
            this.pLASFiles.toFront();
        }
        if (this.pTopsFrame != null) {
            this.pTopsFrame.toFront();
        }
        if (this.pImages != null) {
            this.pImages.toFront();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtText && this.txtText.getText().length() > 0) {
            if (this.rbAPI.isSelected()) {
                string2 = cmnString.convertToAPI(this.txtText.getText());
                this.txtText.setText(string2);
                this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?sAPI=" + string2;
            } else if (this.rbLease.isSelected()) {
                this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?sLease=" + this.txtText.getText();
            }
        }
        if (focusEvent.getSource() == this.txtTownship) {
            bl = true;
            string2 = this.txtTownship.getText();
            string = new String("Township Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtRange) {
            bl = true;
            string2 = this.txtRange.getText();
            string = new String("Range Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtSection) {
            bl = true;
            string2 = this.txtSection.getText();
            string = new String("Section Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtTownship) {
                    this.iTownship = cmnString.stringToInt(this.txtTownship.getText());
                }
                if (focusEvent.getSource() == this.txtRange) {
                    this.iRange = cmnString.stringToInt(this.txtRange.getText());
                }
                if (focusEvent.getSource() == this.txtSection) {
                    this.iSection = cmnString.stringToInt(this.txtSection.getText());
                }
                if (this.iTownship > 0 && this.iRange > 0 && this.iSection > 0) {
                    this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange + "&iSection=" + this.iSection;
                } else if (this.iTownship > 0 && this.iRange > 0) {
                    this.sPath = "http://chasm.kgs.ku.edu/pls/abyss/iqstrat.kgs_well_headers_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange;
                }
            }
        }
    }
}

