/*
 * Decompiled with CFR 0.152.
 */
package horizon.regions.io;

import cmn.cmnString;
import horizon.regions.regionsListStruct;
import horizon.regions.regionsStruct;
import horizon.stratigraphicChartStruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadRegionsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final String ROOTNAME = "regions";
    public static final String RECORDS = "records";
    public static final String WELL = "well";
    public static final String KID = "kid";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public static final String API_NUMBER = "api";
    public static final String WELL_STATUS = "status";
    public static final String ERROR_VAL = "error";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String DEPTH = "depth";
    public static final String GROUND_LEVEL = "gl";
    public static final String REGION = "region";
    public static final String ID = "id";
    public static final String RANK = "rank";
    public static final String SEQUENCE = "sequence";
    public static final String SYSTEM = "system";
    public static final String SERIES = "series";
    public static final String NAME = "name";
    public static final String NAME2 = "alt_name";
    public static final String SOURCE = "source";
    public static final String DEPTH_START = "top";
    public static final String DEPTH_END = "base";
    public static final String SHOTS = "shots";
    private static final int SYSTEM_TOTAL = 12;
    private static final String[][] SYSTEM_ID = new String[][]{{"1029095988", "Quaternary", "100500", "10101000"}, {"1027710578", "Cretaceous", "101000", "10201000"}, {"1027710665", "Jurassic", "120000", "10202000"}, {"1027710667", "Triassic", "122000", "10203000"}, {"1027710669", "Permian", "124000", "10301000"}, {"1027710965", "Pennsylvanian", "194000", "10303000"}, {"1027711178", "Mississippian", "358000", "10304000"}, {"1027711206", "Devonian", "387000", "10305000"}, {"1027711209", "Silurian", "390000", "10306000"}, {"1027711210", "Ordovician", "391000", "10307000"}, {"1027711222", "Cambrian", "405000", "10308000"}, {"1027711226", "Precambrian", "409000", "20000000"}};
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iError = 0;
    private String sError = "";
    private regionsListStruct stList = new regionsListStruct();

    public ReadRegionsXMLFile() {
        this.iType = 0;
    }

    public ReadRegionsXMLFile(int n) {
        this.iType = n;
    }

    public regionsListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        if (this.stList != null) {
            for (int i = 0; i < this.stList.iCount; ++i) {
                if (!this.stList.stItem[i].sKEY.equals("0") || this.stList.stItem[i].sKID.equals("0")) continue;
                this.stList.stItem[i].sKEY = new String(this.stList.stItem[i].sKID);
            }
        }
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(REGION)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new regionsStruct();
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new regionsStruct[this.iRows];
                    }
                }
                if (string4.equals(WELL)) {
                    this.ParseData(string5, string7.trim());
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows || !string4.equals(REGION)) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private regionsStruct ParseData(String string, String string2, regionsStruct regionsStruct2) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string3 = "0";
        String string4 = "0";
        if (string.equals(KID)) {
            regionsStruct2.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            regionsStruct2.sKEY = new String(string2);
        }
        if (string.equals(ID)) {
            regionsStruct2.sID = new String(string2);
            if (regionsStruct2.sID.equals("TOPS")) {
                regionsStruct2.id = 0;
            }
            if (regionsStruct2.sID.equals("PERF")) {
                regionsStruct2.id = 1;
            }
            if (regionsStruct2.sID.equals("DST")) {
                regionsStruct2.id = 2;
            }
        }
        if (string.equals(SYSTEM)) {
            regionsStruct2.system = new String(string2);
            for (n = 0; n < 12; ++n) {
                if (!regionsStruct2.system.equals(SYSTEM_ID[n][2])) continue;
                regionsStruct2.system = new String(SYSTEM_ID[n][3]);
            }
            n3 = -1;
            for (n = 0; n < 76; ++n) {
                if (!regionsStruct2.system.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                n3 = n;
            }
            if (n3 > -1) {
                regionsStruct2.systemName = new String(stratigraphicChartStruct.CHART[n3][2]);
                n3 = -1;
                for (n2 = 0; n2 < 51; ++n2) {
                    if (!regionsStruct2.system.equals(stratigraphicChartStruct.ISC[n2][2])) continue;
                    n3 = n2;
                }
                if (n3 > -1) {
                    string3 = new String(stratigraphicChartStruct.ISC[n3][0]);
                    string4 = new String(stratigraphicChartStruct.ISC[n3][1]);
                    if (!string3.equals("0")) {
                        for (n = 0; n < 76; ++n) {
                            if (!string3.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                            regionsStruct2.sEon = new String(stratigraphicChartStruct.CHART[n][2]);
                        }
                    }
                    if (!string4.equals("0")) {
                        for (n = 0; n < 76; ++n) {
                            if (!string4.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                            regionsStruct2.sEra = new String(stratigraphicChartStruct.CHART[n][2]);
                        }
                    }
                }
            }
        }
        if (string.equals(SERIES)) {
            regionsStruct2.series = new String(string2);
            n3 = -1;
            for (n = 0; n < 76; ++n) {
                if (!regionsStruct2.series.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                n3 = n;
            }
            if (n3 > -1) {
                regionsStruct2.seriesName = new String(stratigraphicChartStruct.CHART[n3][2]);
                n3 = -1;
                for (n2 = 0; n2 < 51; ++n2) {
                    if (!regionsStruct2.system.equals(stratigraphicChartStruct.ISC[n2][3])) continue;
                    n3 = n2;
                }
                if (n3 > -1) {
                    string3 = new String(stratigraphicChartStruct.ISC[n3][0]);
                    string4 = new String(stratigraphicChartStruct.ISC[n3][1]);
                    if (regionsStruct2.system.length() < 2) {
                        regionsStruct2.system = new String(stratigraphicChartStruct.ISC[n3][2]);
                    }
                    if (!string3.equals("0")) {
                        for (n = 0; n < 76; ++n) {
                            if (!string3.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                            regionsStruct2.sEon = new String(stratigraphicChartStruct.CHART[n][2]);
                        }
                    }
                    if (!string4.equals("0")) {
                        for (n = 0; n < 76; ++n) {
                            if (!string4.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                            regionsStruct2.sEra = new String(stratigraphicChartStruct.CHART[n][2]);
                        }
                    }
                    if (regionsStruct2.system.length() > 1) {
                        for (n = 0; n < 76; ++n) {
                            if (!regionsStruct2.system.equals(stratigraphicChartStruct.CHART[n][0])) continue;
                            regionsStruct2.systemName = new String(stratigraphicChartStruct.CHART[n][2]);
                        }
                    }
                }
            }
        }
        if (string.equals(SEQUENCE)) {
            regionsStruct2.sequence = new String(string2);
        }
        if (string.equals(RANK)) {
            regionsStruct2.sRank = new String(string2);
        }
        if (string.equals(NAME)) {
            regionsStruct2.sName = new String(string2);
        }
        if (string.equals(NAME2)) {
            regionsStruct2.sName2 = new String(string2);
        }
        if (string.equals(SOURCE)) {
            regionsStruct2.source = new String(string2);
        }
        if (string.equals(DEPTH_START)) {
            regionsStruct2.depth_top = 0.0;
            if (cmnString.isNumeric(string2)) {
                regionsStruct2.depth_top = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals(DEPTH_END)) {
            regionsStruct2.depth_base = 0.0;
            if (cmnString.isNumeric(string2)) {
                regionsStruct2.depth_base = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals(SHOTS)) {
            regionsStruct2.shots = 0;
            if (cmnString.isNumeric(string2)) {
                regionsStruct2.shots = cmnString.stringToInt(string2);
            }
        }
        return regionsStruct2;
    }

    private void ParseData(String string, String string2) {
        if (string.equals(KID)) {
            this.stList.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            this.stList.sKEY = new String(string2);
        }
        if (string.equals(TYPE)) {
            if (string2.equals("WELL")) {
                this.stList.iType = 0;
            }
            if (string2.equals("OUTCROP")) {
                this.stList.iType = 1;
            }
        }
        if (string.equals(API_NUMBER)) {
            this.stList.sAPI = new String(string2);
        }
        if (string.equals(NAME)) {
            this.stList.sName = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(WELL_STATUS)) {
            this.stList.status = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
        }
        if (string.equals(LATITUDE)) {
            this.stList.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE)) {
            this.stList.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH)) {
            this.stList.depth = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL)) {
            this.stList.dGL = cmnString.stringToDouble(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

