/*
 * Decompiled with CFR 0.152.
 */
package xml;

import cmn.cmnLASFileListStruct;
import cmn.cmnLASFileStruct;
import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadLASFileXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private cmnLASFileListStruct stList = new cmnLASFileListStruct();

    public ReadLASFileXMLFile() {
        this.iType = 0;
    }

    public ReadLASFileXMLFile(int n) {
        this.iType = n;
    }

    public cmnLASFileListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals("las")) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new cmnLASFileStruct();
                this.stList.stItem[this.iCount].iLog = new int[11];
                for (n = 0; n < 11; ++n) {
                    this.stList.stItem[this.iCount].iLog[n] = 0;
                }
            }
        }
        if (attributes != null) {
            for (n = 0; n < attributes.getLength(); ++n) {
                String string5 = attributes.getLocalName(n);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(n);
                }
                String string6 = new String(attributes.getValue(n));
                String string7 = this.removeExcess(string6);
                if (string5.equals("records")) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new cmnLASFileStruct[this.iRows];
                    }
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private cmnLASFileStruct ParseData(String string, String string2, cmnLASFileStruct cmnLASFileStruct2) {
        if (string.equals("key")) {
            cmnLASFileStruct2.sKID = new String(string2);
        }
        if (string.equals("well_key")) {
            cmnLASFileStruct2.sWellKID = new String(string2);
        }
        if (string.equals("location")) {
            cmnLASFileStruct2.iType = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iType = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("path")) {
            cmnLASFileStruct2.sDirectory = new String(string2);
        }
        if (string.equals("filename")) {
            cmnLASFileStruct2.sFilename = new String(string2);
        }
        if (string.equals("ver")) {
            cmnLASFileStruct2.sVersion = new String(string2);
        }
        if (string.equals("log_null")) {
            cmnLASFileStruct2.dNull = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.dNull = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("start")) {
            cmnLASFileStruct2.depthStart = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.depthStart = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("end")) {
            cmnLASFileStruct2.depthEnd = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.depthEnd = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("proprietary")) {
            cmnLASFileStruct2.iProprietary = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iProprietary = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("ohm")) {
            cmnLASFileStruct2.iLog[0] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[0] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("density")) {
            cmnLASFileStruct2.iLog[1] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[1] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("neutron")) {
            cmnLASFileStruct2.iLog[2] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[2] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("sonic")) {
            cmnLASFileStruct2.iLog[3] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[3] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("sp")) {
            cmnLASFileStruct2.iLog[4] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[4] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("gamma")) {
            cmnLASFileStruct2.iLog[5] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[5] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("caliper")) {
            cmnLASFileStruct2.iLog[6] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[6] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("pe")) {
            cmnLASFileStruct2.iLog[7] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[7] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("th")) {
            cmnLASFileStruct2.iLog[8] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[8] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("u")) {
            cmnLASFileStruct2.iLog[9] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[9] = cmnString.stringToInt(string2);
            }
        }
        if (string.equals("p")) {
            cmnLASFileStruct2.iLog[10] = 0;
            if (cmnString.isNumeric(string2)) {
                cmnLASFileStruct2.iLog[10] = cmnString.stringToInt(string2);
            }
        }
        return cmnLASFileStruct2;
    }
}

