/*
 * Decompiled with CFR 0.152.
 */
package rock.sedimentary.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import mask.maskSymbolsListStruct;
import mask.maskSymbolsUtility;
import mask.plot.maskPlotSymbol;
import rock.sedimentary.sedimentaryListStruct;

public class sedimentaryPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private sedimentaryListStruct stStruct = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public sedimentaryPlotTrack(int n, double d, double d2, int n2, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.iDataType = n;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stStruct = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public sedimentaryListStruct getData() {
        return this.stStruct;
    }

    private int getNextDepth(int n, double d) {
        int n2 = -1;
        int n3 = (int)d;
        d = n3;
        if (n > -1 && this.stStruct != null) {
            for (int i = n; i < this.stStruct.iCount; ++i) {
                if (n2 != -1 || !(this.stStruct.stItem[i].depthStart >= this.stStruct.stItem[n].depthEnd + d)) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setData(sedimentaryListStruct sedimentaryListStruct2) {
        this.stStruct = sedimentaryListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n + n2;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n3 = n2 / 20;
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n7 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n8 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n8 < 100 || n8 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n8, n9, n8);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n7, n9, n7);
        }
        this.plot.drawSymbol(graphics, this.stSymbols.stItem[7].iRows, 0, this.stSymbols.stItem[7].symbol, n + 10 * (n3 - 1) + 1, 29);
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n9, 25);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Sedimentary", 45, -1 * (n + 5 * (n3 - 1) + 12));
        graphics2D.drawString("Structures", 45, -1 * (n + 5 * (n3 - 1) + 3));
        graphics2D.rotate(-1.5707963267948966);
    }

    public void drawStructures(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n11 = -1;
        double d5 = (double)iqstratTracksStruct.SCALE[this.iScale] / 10.0;
        if (this.stStruct != null) {
            for (int i = 0; i < this.stStruct.iCount; ++i) {
                d2 = this.stStruct.stItem[i].depthStart;
                d3 = this.stStruct.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                if (n6 == n7) {
                    n6 -= 5;
                    n7 -= 5;
                }
                if ((n9 = (n8 = Math.abs(n7 - n6)) / 10) == 0) {
                    n9 = 1;
                }
                if (n6 >= 100 && n7 > 100 && n6 < this.iHeight && n7 <= this.iHeight) {
                    int n12;
                    int n13;
                    for (n13 = 0; n13 < n9; ++n13) {
                        n10 = n;
                        n8 = n6 + n13 * 10;
                        for (n12 = 0; n12 < this.stStruct.stItem[i].iTotal; ++n12) {
                            n5 = -1;
                            for (int j = 0; j < this.stSymbols.iCount; ++j) {
                                if (!this.stStruct.stItem[i].sID[n12].equals(this.stSymbols.stItem[j].sID) || this.stSymbols.stItem[j].iGroup == maskSymbolsUtility.getGroupID(0, "B", this.stSymbols.stGroups)) continue;
                                n5 = j;
                            }
                            if (n5 <= -1) continue;
                            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n5].iRows, 0, this.stSymbols.stItem[n5].symbol, n10, n8);
                            n10 += 20;
                        }
                    }
                    n10 = n;
                    for (n13 = 0; n13 < this.stStruct.stItem[i].iTotal; ++n13) {
                        n5 = -1;
                        for (n12 = 0; n12 < this.stSymbols.iCount; ++n12) {
                            if (!this.stStruct.stItem[i].sID[n13].equals(this.stSymbols.stItem[n12].sID) || this.stSymbols.stItem[n12].iGroup != maskSymbolsUtility.getGroupID(0, "B", this.stSymbols.stGroups)) continue;
                            n5 = n12;
                        }
                        if (n5 <= -1) continue;
                        for (n12 = 0; n12 < n2 / 20; ++n12) {
                            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n5].iRows, 0, this.stSymbols.stItem[n5].symbol, n10, n6);
                            n10 += 20;
                        }
                    }
                }
                if ((n11 = this.getNextDepth(i, d5)) <= 0 || n11 - 1 <= i) continue;
                i = n11 - 1;
            }
        }
    }

    public void drawBedStructures(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n10 = -1;
        double d5 = (double)iqstratTracksStruct.SCALE[this.iScale] / 10.0;
        if (this.stStruct != null) {
            for (int i = 0; i < this.stStruct.iCount; ++i) {
                d2 = this.stStruct.stItem[i].depthStart;
                d3 = this.stStruct.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                if (n6 == n7) {
                    n6 -= 5;
                    n7 -= 5;
                }
                n8 = Math.abs(n7 - n6);
                if (n6 < 100 || n7 <= 100 || n6 >= this.iHeight || n7 > this.iHeight) continue;
                n9 = n;
                for (int j = 0; j < this.stStruct.stItem[i].iTotal; ++j) {
                    int n11;
                    n5 = -1;
                    for (n11 = 0; n11 < this.stSymbols.iCount; ++n11) {
                        if (!this.stStruct.stItem[i].sID[j].equals(this.stSymbols.stItem[n11].sID) || this.stSymbols.stItem[n11].iGroup != maskSymbolsUtility.getGroupID(0, "B", this.stSymbols.stGroups)) continue;
                        n5 = n11;
                    }
                    if (n5 <= -1) continue;
                    for (n11 = 0; n11 < n2 / 20; ++n11) {
                        this.plot.drawSymbol(graphics, this.stSymbols.stItem[n5].iRows, 0, this.stSymbols.stItem[n5].symbol, n9, n6);
                        n9 += 20;
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1;
        if (n == 79) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawStructures(graphics, n2, n3);
            this.drawBedStructures(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

