/*
 * Decompiled with CFR 0.152.
 */
package rock.sedimentary.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;

public class sedimentaryPlotLegend
extends Canvas {
    private static final int NO = 0;
    private static final int YES = 1;
    private int[] iSelected = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private int iWidth = 300;
    private int iHeight = 1000;
    private static final int TEXT = 15;
    private static final int ROW = 18;
    private static final int X_START = 10;
    private static final int X_IMAGE = 10;
    private static final int X_DESC = 45;
    private static final int X_ABBREV = 320;

    public sedimentaryPlotLegend(int[] nArray, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.iSelected = nArray;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.computeHeight();
    }

    public void close() {
        this.iSelected = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public int countMembers(int n, int n2) {
        int n3 = n;
        boolean bl = false;
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (this.stSymbols.stItem[i].iGroup != n2 || this.iSelected == null || this.iSelected[i] <= -1) continue;
            if (!bl) {
                n3 += 15;
                bl = true;
            }
            n3 += 18;
        }
        return n3;
    }

    private void computeHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = 10;
        int n4 = 0;
        boolean bl = false;
        n3 += 15;
        if (this.stSymbols != null && this.stSymbols.stGroups != null) {
            for (n = 0; n < this.stSymbols.stGroups.iGroups; ++n) {
                n4 = -1;
                for (n2 = 0; n2 < this.stSymbols.iCount; ++n2) {
                    if (this.stSymbols.stItem[n2].iGroup != n || this.iSelected == null || this.iSelected[n2] <= -1) continue;
                    n4 = n2;
                }
                if (n4 <= -1) continue;
                if (this.stSymbols.stGroups.sGroups[this.stSymbols.stItem[n4].iGroup][0].length() < 3 && !bl) {
                    n3 += 10;
                    n3 += 15;
                    bl = true;
                }
                n3 = this.countMembers(n3 + 10, n);
            }
        }
        this.iHeight = n3 + 50;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public int drawStructureGroup(Graphics graphics, int n, int n2) {
        int n3 = n;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        String string = "";
        int n5 = 0;
        boolean bl3 = false;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 < this.stSymbols.iCount; ++n4) {
            if (this.stSymbols.stItem[n4].iGroup != n2 || this.iSelected[n4] <= -1) continue;
            if (!bl3) {
                string = new String(this.stSymbols.stGroups.sGroups[n2][1]);
                n5 = string.length();
                graphics.setColor(Color.black);
                graphics.drawString(string, this.iWidth / 2 - 4 * n5, n);
                n3 += 15;
                bl3 = true;
            }
            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n4].iRows, 0, this.stSymbols.stItem[n4].symbol, 10, n3);
            graphics.setColor(Color.black);
            graphics.drawString(this.stSymbols.stItem[n4].sName, 45, n3 + 10);
            graphics.drawString(this.stSymbols.stItem[n4].sAbrev, 320, n3 + 10);
            n3 += 18;
        }
        return n3;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 10;
        String string = "Sedimentary Structure Symbols";
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        graphics.setFont(new Font("Serif", 1, 14));
        graphics.setColor(Color.black);
        graphics.drawString(string, 0, 14);
        n3 += 15;
        if (this.stSymbols != null && this.stSymbols.stGroups != null) {
            for (n = 0; n < this.stSymbols.stGroups.iGroups; ++n) {
                n5 = -1;
                for (n2 = 0; n2 < this.stSymbols.iCount; ++n2) {
                    if (this.stSymbols.stItem[n2].iGroup != n || this.iSelected == null || this.iSelected[n2] <= -1) continue;
                    n5 = n2;
                }
                if (n5 <= -1) continue;
                if (this.stSymbols.stGroups.sGroups[this.stSymbols.stItem[n5].iGroup][0].length() < 3 && !bl) {
                    graphics.setFont(new Font("Serif", 1, 12));
                    string = new String(this.stSymbols.stGroups.sGroups[0][1]);
                    n4 = string.length();
                    graphics.setColor(Color.black);
                    graphics.drawString(string, this.iWidth / 2 - 4 * n4, n3 += 10);
                    n3 += 15;
                    bl = true;
                }
                n3 = this.drawStructureGroup(graphics, n3 + 10, n);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

