/*
 * Decompiled with CFR 0.152.
 */
package rock.sedimentary.gui;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mask.maskSymbolsListStruct;
import rock.sedimentary.gui.sedimentaryPlotSymbolFrameFocusAdapter;
import rock.sedimentary.gui.sedimentaryPlotSymbolPanel;
import rock.sedimentary.sedimentaryStruct;

public class sedimentaryPlotSymbolFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private sedimentaryPlotSymbolPanel plot = null;
    private sedimentaryStruct stStruct = null;
    private String sKEY = "0";
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private JButton btnAdd = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnCancel = new JButton();
    private JMenuItem mExit = null;
    private int iXStart = 0;
    private int iYStart = 0;
    private int iWidth = 0;
    private int iHeight = 0;

    public sedimentaryPlotSymbolFrame(maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
            this.addWindowListener(new sedimentaryPlotSymbolFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public sedimentaryPlotSymbolFrame(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public sedimentaryPlotSymbolFrame(Observable observable, int n, int n2, int n3, int n4, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.iXStart = n;
            this.iYStart = n2;
            this.iWidth = n3;
            this.iHeight = n4;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Starting Depth:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Ending Depth:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setTitle("Sedimentary Structures");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout());
        jPanel5.setLayout(new GridLayout(2, 1));
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(this);
        jPanel6.setLayout(new GridLayout());
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel2.setPreferredSize(new Dimension(100, 10));
        jPanel2.setLayout(new GridLayout());
        jPanel3.setBorder(titledBorder);
        jPanel3.setLayout(new BorderLayout());
        this.txtStart.setText("0.0");
        this.txtStart.setEditable(false);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new sedimentaryPlotSymbolFrameFocusAdapter(this));
        jPanel4.setBorder(titledBorder2);
        jPanel4.setLayout(new BorderLayout());
        this.txtEnd.setText("0.0");
        this.txtEnd.setEditable(false);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new sedimentaryPlotSymbolFrameFocusAdapter(this));
        this.plot = new sedimentaryPlotSymbolPanel(this, this.notifier, this.stSymbols);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)jPanel3, null);
        jPanel3.add((Component)this.txtStart, "Center");
        jPanel2.add((Component)jPanel4, null);
        jPanel4.add((Component)this.txtEnd, "Center");
        jPanel.add((Component)jPanel5, "South");
        jPanel5.add((Component)this.btnAdd, null);
        jPanel5.add((Component)jPanel6, null);
        jPanel6.add((Component)this.btnClear, null);
        this.getContentPane().add((Component)this.plot, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(450, dimension.height - 50));
        int n = (dimension.width - this.getSize().width) / 2;
        if (this.iWidth > 0) {
            n = this.iXStart + this.iWidth;
        }
        this.setLocation(n, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public sedimentaryStruct getData() {
        if (this.stStruct == null) {
            this.stStruct = new sedimentaryStruct();
            this.stStruct.sKEY = new String(cmnString.UniqueName());
        }
        if (this.dEnd == 0.0) {
            this.dEnd = this.dStart;
        }
        if (this.plot != null) {
            this.stStruct = this.plot.getData();
        }
        this.stStruct.sKEY = new String(this.sKEY);
        this.stStruct.depthStart = this.dStart;
        this.stStruct.depthEnd = this.dEnd;
        return this.stStruct;
    }

    public void setData(sedimentaryStruct sedimentaryStruct2) {
        this.stStruct = sedimentaryStruct2;
        if (sedimentaryStruct2 != null) {
            this.sKEY = new String(sedimentaryStruct2.sKEY);
            this.dStart = sedimentaryStruct2.depthStart;
            this.dEnd = sedimentaryStruct2.depthEnd;
            this.txtStart.setText("" + this.dStart);
            this.txtEnd.setText("" + this.dEnd);
        }
        if (this.plot != null) {
            this.plot.setData(sedimentaryStruct2);
        }
        this.btnAdd.setText("Modify");
    }

    public void setDepthRange(double d, double d2) {
        this.dStart = d;
        this.txtStart.setText("" + this.dStart);
        this.dEnd = d2;
        this.txtEnd.setText("" + this.dEnd);
    }

    private void add() {
        this.notifier.notifyObservers(new String("ADD or MODIFY Sed Struct Data"));
    }

    public void cancel() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Cancel Edit"));
        }
    }

    public void clear() {
        if (this.stStruct != null) {
            this.stStruct.delete();
        }
        this.stStruct = null;
        if (this.plot != null) {
            this.plot.setData(this.stStruct);
        }
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.btnAdd = null;
        this.btnClear = null;
        this.btnCancel = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnClear) {
            this.clear();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.cancel();
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                }
            }
        }
    }

    public class sedimentaryPlotSymbolFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (sedimentaryPlotSymbolFrame.this.notifier != null) {
                sedimentaryPlotSymbolFrame.this.notifier.notifyObservers(new String("Cancel Edit"));
            }
        }
    }
}

