/*
 * Decompiled with CFR 0.152.
 */
package rock.plot;

import cmn.cmnString;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import rock.rockDataListStruct;
import rock.rockStandardTools;

public class rockPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    public static final Color cRED = new Color(180, 0, 0);
    public static final Color cGREEN = new Color(0, 180, 0);
    public static final Color cBLUE = new Color(0, 0, 180);
    public static final Color cCYAN = new Color(0, 180, 180);
    public static final Color cMAGENTA = new Color(180, 0, 180);
    public static final Color cYELLOW = new Color(180, 180, 0);
    public static final Color cORANGE = new Color(204, 102, 0);
    public static final Color cBROWN = new Color(102, 102, 0);
    public static final Color[] COLORS = new Color[]{cRED, cGREEN, cBLUE, cBROWN, cMAGENTA, cORANGE, cYELLOW, cCYAN};
    private rockDataListStruct stRock = null;
    private double[][] dLIMITS = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public rockPlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stRock = null;
        this.dLIMITS = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setRockData(rockDataListStruct rockDataListStruct2) {
        this.stRock = rockDataListStruct2;
    }

    public void setPlotLimits(double[][] dArray) {
        this.dLIMITS = dArray;
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n3 / 4;
        int n9 = n2 + n3;
        int n10 = n - 65;
        int n11 = iqstratTracksStruct.ROCK_TRACK[n10][0];
        boolean bl2 = false;
        int n12 = 0;
        int n13 = 0;
        double d3 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][4]);
        double d4 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][5]);
        if (this.dLIMITS != null) {
            d3 = this.dLIMITS[n11][0];
            d4 = this.dLIMITS[n11][1];
        }
        if (rockStandardTools.ROCK_TOOLS[n11][2].equals("MD")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        if (rockStandardTools.ROCK_TOOLS[n11][2].equals("UNL")) {
            if (n11 == 41) {
                d3 = this.stRock.dLOG_1Min;
                d4 = this.stRock.dLOG_1Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 42) {
                d3 = this.stRock.dLOG_2Min;
                d4 = this.stRock.dLOG_2Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 43) {
                d3 = this.stRock.dLOG_3Min;
                d4 = this.stRock.dLOG_3Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 44) {
                d3 = this.stRock.dLOG_4Min;
                d4 = this.stRock.dLOG_4Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n12 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n13 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n13 < 100 || n13 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n2, n13, n9, n13);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n12, n9, n12);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 <= n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0 || n4 == n3) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                } else {
                    graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(new Color(230, 230, 230));
                for (n5 = 1; n5 < 5; ++n5) {
                    d2 = (double)n8 / 5.0;
                    n6 = n4 + n2 + n5 * (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        } else {
            n8 = n3 / n7;
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 < n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                graphics.setColor(Color.lightGray);
                for (n5 = 1; n5 < 5; ++n5) {
                    d = (double)n5 * 2.0;
                    d2 = (double)n8 * Math.log(d) / Math.log(10.0);
                    n6 = n4 + n2 + (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n9, 25);
        graphics.drawLine(n2, 100, n9, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
    }

    public void drawTrackLabels(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        boolean bl = false;
        int n7 = -1;
        int n8 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        int n9 = n2 + n3;
        int n10 = n - 65;
        double[] dArray = null;
        Font font = new Font("Serif", 1, 10);
        graphics.setFont(font);
        for (n4 = 0; n4 < 5; ++n4) {
            n6 = iqstratTracksStruct.ROCK_TRACK[n10][n4];
            bl = true;
            if (this.stRock != null) {
                if (!this.stRock.checkData(n6)) {
                    bl = false;
                } else {
                    ++n7;
                }
            }
            if (n6 <= -1 || !bl) continue;
            string = new String(rockStandardTools.ROCK_TOOLS[n6][0]);
            n8 = string.length();
            string3 = new String(rockStandardTools.ROCK_TOOLS[n6][2]);
            if (string3.equals("PU") || string3.equals("USEC/FT")) {
                d2 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n6][4]);
                d = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n6][5]);
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n6][1];
                    d2 = this.dLIMITS[n6][0];
                }
                if (this.stRock != null) {
                    dArray = this.stRock.getData(n6);
                    if (string3.equals("PU")) {
                        for (n5 = 0; n5 < this.stRock.iCount; ++n5) {
                            if (!(dArray[n5] > 2.0) || n6 < 7 || n6 > 11) continue;
                            d = 30.0;
                            d2 = -10.0;
                            if (this.dLIMITS == null) continue;
                            d = this.dLIMITS[n6][1];
                            d2 = this.dLIMITS[n6][0];
                        }
                    }
                }
            } else {
                d = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n6][4]);
                d2 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n6][5]);
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n6][0];
                    d2 = this.dLIMITS[n6][1];
                }
            }
            if (string3.equals("UNI")) {
                if (n6 == 37) {
                    string = new String(this.stRock.sUnknown[0][0]);
                    n8 = string.length();
                    d = this.stRock.dLIN_1Min;
                    d2 = this.stRock.dLIN_1Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 38) {
                    string = new String(this.stRock.sUnknown[1][0]);
                    n8 = string.length();
                    d = this.stRock.dLIN_2Min;
                    d2 = this.stRock.dLIN_2Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 39) {
                    string = new String(this.stRock.sUnknown[2][0]);
                    n8 = string.length();
                    d = this.stRock.dLIN_3Min;
                    d2 = this.stRock.dLIN_3Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 40) {
                    string = new String(this.stRock.sUnknown[3][0]);
                    n8 = string.length();
                    d = this.stRock.dLIN_4Min;
                    d2 = this.stRock.dLIN_4Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
            }
            if (string3.equals("UNL")) {
                if (n6 == 41) {
                    string = new String(this.stRock.sUnknown[0][1]);
                    n8 = string.length();
                    d = this.stRock.dLOG_1Min;
                    d2 = this.stRock.dLOG_1Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 42) {
                    string = new String(this.stRock.sUnknown[1][1]);
                    n8 = string.length();
                    d = this.stRock.dLOG_2Min;
                    d2 = this.stRock.dLOG_2Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 43) {
                    string = new String(this.stRock.sUnknown[2][1]);
                    n8 = string.length();
                    d = this.stRock.dLOG_3Min;
                    d2 = this.stRock.dLOG_3Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
                if (n6 == 44) {
                    string = new String(this.stRock.sUnknown[3][1]);
                    n8 = string.length();
                    d = this.stRock.dLOG_4Min;
                    d2 = this.stRock.dLOG_4Max;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n6][0];
                        d2 = this.dLIMITS[n6][1];
                    }
                }
            }
            if (n7 <= -1) continue;
            graphics.setColor(COLORS[n4]);
            graphics.drawString(string, n2 + n3 / 2 - n8 * 4, 25 + (n7 + 2) * 14);
            graphics.drawString("" + d, n2 + 1, 25 + (n7 + 2) * 14);
            string2 = new String("" + d2);
            n8 = string2.length();
            graphics.drawString("" + d2, n9 - n8 * 5, 25 + (n7 + 2) * 14);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n9, 25);
        string = new String(iqstratTracksStruct.ROCK_TRACK_DESC[n10]);
        n8 = string.length();
        graphics.drawString(string, n2 + n3 / 2 - 9 * n8 / 4, 39);
    }

    public void drawTrackCurves(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        boolean bl2 = false;
        int n7 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string = "";
        double[] dArray = null;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n9 = n2 + n3;
        int n10 = n - 65;
        int n11 = iqstratTracksStruct.ROCK_TRACK[n10][0];
        if (rockStandardTools.ROCK_TOOLS[n11][2].equals("MD")) {
            bl4 = true;
            d4 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][4]);
            d5 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][5]);
            if (this.dLIMITS != null) {
                d4 = this.dLIMITS[n11][0];
                d5 = this.dLIMITS[n11][1];
            }
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            d5 = Math.round(Math.log(d5) / Math.log(10.0));
        }
        if (rockStandardTools.ROCK_TOOLS[n11][2].equals("UNL")) {
            if (n11 == 41) {
                d4 = this.stRock.dLOG_1Min;
                d5 = this.stRock.dLOG_1Max;
            }
            if (n11 == 42) {
                d4 = this.stRock.dLOG_2Min;
                d5 = this.stRock.dLOG_2Max;
            }
            if (n11 == 43) {
                d4 = this.stRock.dLOG_3Min;
                d5 = this.stRock.dLOG_3Max;
            }
            if (n11 == 44) {
                d4 = this.stRock.dLOG_4Min;
                d5 = this.stRock.dLOG_4Max;
            }
            if (this.dLIMITS != null) {
                d4 = this.dLIMITS[n11][0];
                d5 = this.dLIMITS[n11][1];
            }
            bl4 = true;
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            d5 = Math.round(Math.log(d5) / Math.log(10.0));
        }
        if (this.stRock != null) {
            for (int i = 0; i < 5; ++i) {
                dArray = null;
                n11 = iqstratTracksStruct.ROCK_TRACK[n10][i];
                if (n11 <= -1 || !this.stRock.checkData(n11)) continue;
                n8 = i;
                n5 = this.stRock.iCount;
                dArray = this.stRock.getData(n11);
                if (dArray == null) continue;
                d2 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][4]);
                d3 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n11][5]);
                string = new String(rockStandardTools.ROCK_TOOLS[n11][2]);
                if (string.equals("PU")) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (!(dArray[n4] > 2.0) || n11 < 7 || n11 > 11) continue;
                        d2 = -10.0;
                        d3 = 30.0;
                    }
                }
                if (n11 == 37) {
                    d2 = this.stRock.dLIN_1Min;
                    d3 = this.stRock.dLIN_1Max;
                }
                if (n11 == 38) {
                    d2 = this.stRock.dLIN_2Min;
                    d3 = this.stRock.dLIN_2Max;
                }
                if (n11 == 39) {
                    d2 = this.stRock.dLIN_3Min;
                    d3 = this.stRock.dLIN_3Max;
                }
                if (n11 == 40) {
                    d2 = this.stRock.dLIN_4Min;
                    d3 = this.stRock.dLIN_4Max;
                }
                if (this.dLIMITS != null) {
                    d2 = this.dLIMITS[n11][0];
                    d3 = this.dLIMITS[n11][1];
                }
                if (bl4) {
                    d2 = d4;
                    d3 = d5;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    if (dArray[n4] == -999.95) continue;
                    d6 = this.stRock.stItem[n4].dTOP;
                    if (this.stRock.stItem[n4].dCORR != -999.95) {
                        d6 = this.stRock.stItem[n4].dTOP + this.stRock.stItem[n4].dCORR;
                    }
                    d7 = dArray[n4];
                    if (bl4) {
                        if (d7 <= 0.0) {
                            d7 = 1.0E-5;
                        }
                        d7 = Math.log(d7) / Math.log(10.0);
                    }
                    d = (double)this.iLogHeight * (d6 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n7 > 100 && n7 < this.iHeight) {
                        bl = true;
                    }
                    if (string.equals("PU") || string.equals("USEC/FT")) {
                        d = (double)n3 * (d3 - d7) / (d3 - d2);
                        n6 = n2 + (int)d;
                    } else {
                        d = (double)n3 * (d7 - d2) / (d3 - d2);
                        n6 = n2 + (int)d;
                    }
                    if (n6 < n2 || n6 > n9) continue;
                    graphics.setColor(COLORS[n8]);
                    if (!bl) continue;
                    graphics.fillRect(n6 - 2, n7 - 2, 4, 4);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1;
        graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
        graphics.fillRect(n2, 25, n3, 20);
        this.drawGrid(graphics, n, n2, n3);
        this.drawTrackLabels(graphics, n, n2, n3);
        this.drawTrackCurves(graphics, n, n2, n3);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

