/*
 * Decompiled with CFR 0.152.
 */
package rock.plot;

import cmn.cmnStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import rock.rockImagesListStruct;
import util.BrowserControl;
import util.utilBrowser;

public class rockPlotImageTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private cmnStruct stCMN = null;
    private rockImagesListStruct stImages = null;
    private utilBrowser pBrowser = null;
    private int[] iSelectedImage = null;
    private int iTotal = 0;
    private int[] iYMouse = null;
    private int[] iYMouse2 = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    private double dIncrementDepth = 0.0;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public rockPlotImageTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.stImages = this.stImages;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stImages = null;
        this.iSelectedImage = null;
        this.iYMouse = null;
        this.iYMouse2 = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public rockImagesListStruct getData() {
        return this.stImages;
    }

    public String getKEY(int n, int n2, int n3, int n4, int n5) {
        String string = "0";
        boolean bl = false;
        for (int i = 0; i < this.iTotal; ++i) {
            bl = false;
            if (n <= n4 || n >= n4 + n5 || n2 <= this.iYMouse[i] || n2 >= this.iYMouse2[i]) continue;
            if (this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) {
                bl = true;
            }
            if (!bl) continue;
            string = this.stImages.stItem[i].sKID;
        }
        return string;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
        this.convertCoreToPixels();
    }

    public void setData(rockImagesListStruct rockImagesListStruct2) {
        this.stImages = rockImagesListStruct2;
        this.convertCoreToPixels();
    }

    public void setCommon(cmnStruct cmnStruct2) {
        this.stCMN = cmnStruct2;
    }

    private void convertCoreToPixels() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        if (this.stImages != null) {
            this.iTotal = this.stImages.iCount;
            this.iYMouse = new int[this.iTotal];
            this.iYMouse2 = new int[this.iTotal];
            this.iSelectedImage = new int[this.iTotal];
            for (int i = 0; i < this.iTotal; ++i) {
                this.iSelectedImage[i] = 0;
                d = this.stImages.stItem[i].depthStart;
                d2 = this.stImages.stItem[i].depthEnd;
                d3 = (double)this.iLogHeight * (d - this.depthStart) / (this.depthEnd - this.depthStart);
                this.iYMouse[i] = 100 + (int)d3;
                if (this.iDataType == 1) {
                    this.iYMouse[i] = this.iHeight - (int)d3;
                }
                d3 = (double)this.iLogHeight * (d2 - this.depthStart) / (this.depthEnd - this.depthStart);
                this.iYMouse2[i] = 100 + (int)d3;
                if (this.iDataType == 1) {
                    this.iYMouse2[i] = this.iHeight - (int)d3;
                }
                if (this.iYMouse2[i] - this.iYMouse[i] < 10) {
                    this.iYMouse2[i] = this.iYMouse[i] + 10;
                    if (this.iDataType == 1) {
                        this.iYMouse2[i] = this.iYMouse[i] - 10;
                    }
                }
                if (this.iYMouse2[i] >= this.iYMouse[i]) continue;
                n = this.iYMouse[i];
                this.iYMouse[i] = this.iYMouse2[i];
                this.iYMouse2[i] = n;
            }
        }
    }

    public double computeMouseDepth(int n) {
        double d = 0.0;
        if (n > 100) {
            d = this.iDataType == 1 ? this.depthStart + (this.depthEnd - this.depthStart) * (double)(this.iHeight - n) / (double)this.iLogHeight : this.depthStart + (this.depthEnd - this.depthStart) * (double)(n - 100) / (double)this.iLogHeight;
        }
        return d;
    }

    public void displayCore(int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        block7: for (int i = 0; i < this.iTotal; ++i) {
            if (n <= n4 || n >= n4 + n5 || n2 <= this.iYMouse[i] || n2 >= this.iYMouse2[i]) continue;
            switch (n3) {
                case 0: {
                    if (!this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) continue block7;
                    n6 = i;
                    continue block7;
                }
                case 1: {
                    if (!this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) continue block7;
                    n6 = i;
                    continue block7;
                }
                case 2: {
                    if (!this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) continue block7;
                    n6 = i;
                    continue block7;
                }
                case 3: {
                    if (!this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) continue block7;
                    n6 = i;
                    continue block7;
                }
                case 4: {
                    if (!this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n3])) continue block7;
                    n6 = i;
                }
            }
        }
        if (n6 > -1) {
            this.iSelectedImage[n6] = 1;
            String string = new String(this.stImages.stItem[n6].sURL + this.stImages.stItem[n6].sFilename);
            if (!this.stCMN.bStandalone) {
                this.pBrowser = new utilBrowser(this.stCMN.appletContext, "http://chasm.kgs.ku.edu/ords/iqstrat.rock_catalog_image_pkg.build_web_page?iKID=" + this.stImages.stItem[n6].sKID);
            } else {
                BrowserControl.displayURL("http://chasm.kgs.ku.edu/ords/iqstrat.rock_catalog_image_pkg.build_web_page?iKID=" + this.stImages.stItem[n6].sKID);
            }
        }
    }

    public void drawCores(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 + n3;
        boolean bl = false;
        for (int i = 0; i < this.iTotal; ++i) {
            bl = false;
            if (this.stImages.stItem[i].sType.equals(cmnStruct.CORE_IMAGES[n])) {
                bl = true;
            }
            switch (n) {
                case 0: {
                    if (this.iSelectedImage[i] == 0) {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    graphics.setColor(Color.cyan);
                    break;
                }
                case 1: {
                    if (this.iSelectedImage[i] == 0) {
                        graphics.setColor(Color.green);
                        break;
                    }
                    graphics.setColor(Color.yellow);
                    break;
                }
                case 2: {
                    if (this.iSelectedImage[i] == 0) {
                        graphics.setColor(Color.red);
                        break;
                    }
                    graphics.setColor(Color.pink);
                    break;
                }
                case 3: {
                    if (this.iSelectedImage[i] == 0) {
                        graphics.setColor(Color.gray);
                        break;
                    }
                    graphics.setColor(Color.lightGray);
                    break;
                }
                case 4: {
                    if (this.iSelectedImage[i] == 0) {
                        graphics.setColor(new Color(51, 51, 0));
                        break;
                    }
                    graphics.setColor(new Color(102, 102, 0));
                }
            }
            if (bl) {
                bl = this.iYMouse[i] >= 100 && this.iYMouse2[i] > 100 && this.iYMouse[i] < this.iHeight && this.iYMouse2[i] <= this.iHeight;
            }
            if (!bl) continue;
            graphics.fill3DRect(n2, this.iYMouse[i], n3, this.iYMouse2[i] - this.iYMouse[i], true);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n2 + 1, this.iYMouse[i] + 1, n2 + n3 - 1, this.iYMouse[i] + 1);
            graphics.drawLine(n2 + 1, this.iYMouse[i] + 1, n2 + 1, this.iYMouse2[i] - 1);
            graphics.drawLine(n2 + 1, this.iYMouse2[i] - 1, n2 + n3 - 1, this.iYMouse2[i] - 1);
            graphics.drawLine(n2 + n3 - 1, this.iYMouse[i] + 1, n2 + n3 - 1, this.iYMouse2[i] - 1);
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        String string = "";
        int n7 = n2 + n3;
        graphics.setColor(Color.black);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            d = this.depthStart + (double)n4 * this.dIncrementDepth / (double)this.iIncrementY;
            n5 = (int)(10.0 * d);
            d = (double)n5 / 10.0;
            n6 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n6, n2 + n3, n6);
        }
        switch (n) {
            case 0: {
                string = "Core Box";
                break;
            }
            case 1: {
                string = "Core Slab";
                break;
            }
            case 2: {
                string = "Thin Section";
                break;
            }
            case 3: {
                string = "Core SEM";
                break;
            }
            case 4: {
                string = "Rock Image";
            }
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(string, 39, -1 * (n2 + 2 * n3 / 3));
        graphics2D.rotate(-1.5707963267948966);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n7, 25);
        graphics.drawLine(n2, 100, n7, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = -1;
        int n5 = 1;
        if (n == 60 || n == 61 || n == 62 || n == 63 || n == 64) {
            switch (n) {
                case 60: {
                    n4 = 0;
                    break;
                }
                case 61: {
                    n4 = 1;
                    break;
                }
                case 62: {
                    n4 = 2;
                    break;
                }
                case 63: {
                    n4 = 3;
                    break;
                }
                case 64: {
                    n4 = 4;
                }
            }
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n5][0], iqstratTracksStruct.COLORS[n5][1], iqstratTracksStruct.COLORS[n5][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n4, n2, n3);
            this.drawCores(graphics, n4, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

