/*
 * Decompiled with CFR 0.152.
 */
package rock.phi.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.phi.phiListStruct;

public class phiPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private phiListStruct stPHI = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public phiPlotTrack(int n, double d, double d2, int n2, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.iDataType = n;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stPHI = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    private boolean isOverlap(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n3; ++i) {
            d2 = this.stPHI.stItem[i].depthStart;
            d3 = this.stPHI.stItem[i].depthEnd;
            d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
            d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
            n5 = 100 + (int)d;
            n4 = 100 + (int)d;
            if (n5 - n4 >= 10 || n >= n4 + 10) continue;
            bl = true;
        }
        return bl;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    private int getNextDepth(int n, double d) {
        int n2 = -1;
        int n3 = (int)d;
        d = n3;
        if (n > -1 && this.stPHI != null) {
            for (int i = n; i < this.stPHI.iCount; ++i) {
                if (n2 != -1 || !(this.stPHI.stItem[i].depthStart >= this.stPHI.stItem[n].depthEnd + d)) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setPHIData(phiListStruct phiListStruct2) {
        this.stPHI = phiListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n7 = n2 / 6;
        int n8 = n + n2;
        int n9 = 0;
        int n10 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n9 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n10 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n10 < 100 || n10 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n10, n8, n10);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n9, n8, n9);
        }
        if (!bl) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
            for (n3 = 0; n3 <= n2; n3 += n7) {
                if (n3 == 0 || n3 == n2) {
                    graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
            }
        } else {
            n7 = n2 / n6;
            graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
            for (n3 = 0; n3 < n2; n3 += n7) {
                graphics.setColor(Color.lightGray);
                if (n3 == 0) {
                    graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
                graphics.setColor(Color.lightGray);
                for (n4 = 1; n4 < 5; ++n4) {
                    d = (double)n4 * 2.0;
                    d2 = (double)n7 * Math.log(d) / Math.log(10.0);
                    n5 = n3 + n + (int)d2;
                    if (n5 > n8) continue;
                    graphics.drawLine(n5, 100, n5, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n8, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
    }

    public void drawRockPorosity(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n4 = n;
        n5 = n + n2;
        if (this.stPHI != null) {
            for (int i = 0; i < this.stPHI.iCount; ++i) {
                d2 = this.stPHI.stItem[i].depthStart;
                d3 = this.stPHI.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n8 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n8 = this.iHeight - (int)d;
                }
                n9 = Math.abs(n8 - n7);
                if (n7 < 100 || n8 <= 100 || n7 >= this.iHeight || n8 > this.iHeight) continue;
                n6 = (int)((double)n2 * this.stPHI.stItem[i].dPHI / 30.0);
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > n2) {
                    n6 = n2;
                }
                if (n6 <= 0) continue;
                graphics.fillRect(n4, n7, n6, n9);
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Porosity", 39, -1 * (n4 + 2 * n2 / 3));
        graphics2D.rotate(-1.5707963267948966);
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.drawString("0", n4 + 1, 99);
        string = new String("30");
        n3 = string.length();
        graphics.drawString("30", n5 - n3 * 5, 99);
        graphics.drawLine(n4, 25, n5, 25);
        graphics.drawLine(n4, 100, n5, 100);
        graphics.drawLine(n4, 25, n4, 100 + this.iLogHeight);
        graphics.drawLine(n5, 25, n5, 100 + this.iLogHeight);
    }

    public void drawLithology(Graphics graphics, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int n8 = -1;
        boolean bl2 = true;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.stPHI != null && this.stPHI.iCount > 0) {
            n12 = -1;
            for (n4 = 0; n4 < this.stPHI.iCount; ++n4) {
                if (this.stPHI.stItem[n4] == null) continue;
                d2 = this.stPHI.stItem[n4].depthStart;
                d3 = this.stPHI.stItem[n4].depthEnd;
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n9 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n9 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n10 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n10 = this.iHeight - (int)d4;
                }
                n11 = Math.abs(n10 - n9);
                if (n9 < 100 || n10 <= 100 || n9 >= this.iHeight || n10 > this.iHeight) continue;
                if (this.iDataType == 1) {
                    n9 = n10;
                }
                if ((n13 = n11 / 5) == 0) {
                    n13 = 1;
                }
                for (n5 = 0; n5 < n13; ++n5) {
                    if (this.stPHI.stItem[n4].iRockType == -1) continue;
                    ++n12;
                    for (n3 = 0; n3 < 3; ++n3) {
                        n8 = this.stPHI.stItem[n4].iRockType;
                        n6 = this.stSymbols.stModifiers[n8].iColumns;
                        n7 = this.stSymbols.stModifiers[n8].iRows;
                        nArray = this.stSymbols.stModifiers[n8].iRGB;
                        maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n + n3 * n6, n9 + n5 * n7, n6, n7);
                        this.plot.drawSymbol(graphics, n7, this.plot.getOrder(n12), this.stSymbols.stModifiers[n8].symbol, n + n3 * n6, n9 + n5 * n7);
                    }
                }
            }
        }
    }

    public void drawPorosityGrid(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Porosity", 39, -1 * (n3 + 2 * n2 / 3));
        graphics2D.drawString("Type", 45, -1 * (n3 + 5));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n3, 25, n4, 25);
        graphics.drawLine(n3, 100, n4, 100);
        graphics.drawLine(n3, 25, n3, 100 + this.iLogHeight);
        graphics.drawLine(n4, 25, n4, 100 + this.iLogHeight);
    }

    public void drawPorosity(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n12 = -1;
        double d5 = (double)iqstratTracksStruct.SCALE[this.iScale] / 10.0;
        if (this.stPHI != null) {
            for (int i = 0; i < this.stPHI.iCount; ++i) {
                d2 = this.stPHI.stItem[i].depthStart;
                d3 = this.stPHI.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                if (n6 == n7) {
                    n6 -= 5;
                    n7 -= 5;
                }
                if ((n9 = (n8 = Math.abs(n7 - n6)) / 10) == 0) {
                    n9 = 1;
                }
                if (n6 < 100 || n7 <= 100 || n6 >= this.iHeight || n7 > this.iHeight) continue;
                for (int j = 0; j < n9; ++j) {
                    n10 = n;
                    n8 = n6 + j * 10;
                    for (int k = 0; k < this.stPHI.stItem[i].iTotal; ++k) {
                        n5 = -1;
                        for (int i2 = 0; i2 < this.stSymbols.iCount; ++i2) {
                            if (!this.stPHI.stItem[i].sID[k].equals(this.stSymbols.stItem[i2].sID)) continue;
                            n5 = i2;
                        }
                        if (n5 <= -1 || n10 >= n + 30) continue;
                        if (!this.isOverlap(n8, n8 + 10, n11)) {
                            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n5].iRows, 0, this.stSymbols.stItem[n5].symbol, n10, n8);
                            n11 = i + 1;
                        }
                        n10 += 10;
                    }
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n3, 25, n3, 100 + this.iLogHeight);
        graphics.drawLine(n4, 25, n4, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        if (n == 82) {
            n4 = 1;
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawLithology(graphics, n2, n3);
            this.drawGrid(graphics, n2, n3);
            this.drawRockPorosity(graphics, n2, n3);
        }
        if (n == 83) {
            n4 = 1;
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawPorosityGrid(graphics, n2, n3);
            this.drawPorosity(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

