/*
 * Decompiled with CFR 0.152.
 */
package rock.gui;

import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import lith.gui.lithologyEntryFrame;
import lith.lithology.lithologyListStruct;
import lith.lithology.lithologyStruct;
import lith.lithology.lithologyUtility;
import lith.lithology.plot.lithologyPlotData;
import lith.rock.rockColumnListStruct;
import lith.texture.textureListStruct;
import lith.texture.textureStruct;
import parse.parseTextureUtility;
import rock.color.gui.rockColorChartPlotFrame;
import rock.color.rockColorListStruct;
import rock.color.rockColorStruct;
import rock.color.rockColorUtility;
import rock.fossil.fossilListStruct;
import rock.fossil.fossilStruct;
import rock.fossil.fossilUtility;
import rock.fossil.gui.fossilPlotDataEntryPanel;
import rock.fossil.gui.fossilPlotSymbolFrame;
import rock.gui.rockObsEntryPanelObservable;
import rock.phi.gui.phiPlotDataEntryPanel;
import rock.phi.gui.phiPlotSymbolFrame;
import rock.phi.phiListStruct;
import rock.phi.phiStruct;
import rock.phi.phiUtility;
import rock.sedimentary.gui.sedimentaryPlotDataEntryPanel;
import rock.sedimentary.gui.sedimentaryPlotSymbolFrame;
import rock.sedimentary.sedimentaryListStruct;
import rock.sedimentary.sedimentaryStruct;
import rock.sedimentary.sedimentaryUtility;

public class rockObsEntryPanel
extends Panel
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private Observable notifier = null;
    private lithologyPlotData plotComp = null;
    private phiPlotDataEntryPanel plotPhi = null;
    private sedimentaryPlotDataEntryPanel plotSed = null;
    private fossilPlotDataEntryPanel plotFossil = null;
    private lithologyEntryFrame pLithology = null;
    private phiPlotSymbolFrame pPHI = null;
    private sedimentaryPlotSymbolFrame pStruct = null;
    private fossilPlotSymbolFrame pFossils = null;
    private rockColorChartPlotFrame pColors = null;
    private rockColumnListStruct stColumn = null;
    private lithologyStruct stLithology = null;
    private textureStruct stTexture = null;
    private phiStruct stPhi = null;
    private sedimentaryStruct stSedStruct = null;
    private fossilStruct stFossil = null;
    private rockColorStruct stColor = null;
    private static final int _NONE = 0;
    private static final int _TRACE = 1;
    private static final int _POOR = 2;
    private static final int _FAIR = 3;
    private static final int _GOOD = 4;
    private static final int _EXCELLENT = 5;
    private int iPHI = 0;
    private static final String[] PHI = new String[]{"No Visible Porosity", "Trace Porosity", "Poor Porosity", "Fair Porosity", "Good Porosity", "Excellent Porosity"};
    private JLabel lblPhi = new JLabel();
    private JTextArea txtTexture = new JTextArea();
    private JButton btnPrimary = new JButton();
    private JTextField txtPrimaryMunsell = new JTextField();
    private JTextField txtPrimary = new JTextField();
    private JButton btnSecondary = new JButton();
    private JTextField txtSecondaryMunsell = new JTextField();
    private JTextField txtSecondary = new JTextField();
    private JButton btnStreaks = new JButton();
    private JTextField txtStreaksMunsell = new JTextField();
    private JTextField txtStreaks = new JTextField();
    private JButton btnEditLithology = new JButton();
    private JButton btnEditPhi = new JButton();
    private JButton btnEditSedStruct = new JButton();
    private JButton btnEditFossil = new JButton();
    private JButton btnEditColor = new JButton();

    public rockObsEntryPanel(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JPanel jPanel18 = new JPanel();
        JPanel jPanel19 = new JPanel();
        JPanel jPanel20 = new JPanel();
        JPanel jPanel21 = new JPanel();
        JPanel jPanel22 = new JPanel();
        JPanel jPanel23 = new JPanel();
        JPanel jPanel24 = new JPanel();
        JPanel jPanel25 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Lithology/Texture:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Porosity Types:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Sedimentary Structures:");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Fossils:");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Rock Color:");
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Primary:");
        titledBorder6.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder7 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Secondary:");
        titledBorder7.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder8 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Streaks:");
        titledBorder8.setTitleFont(new Font("Dialog", 1, 11));
        this.notifier = new rockObsEntryPanelObservable();
        this.notifier.addObserver(this);
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setPreferredSize(new Dimension(10, 30));
        this.plotComp = new lithologyPlotData(this.stStruct.stSymbols);
        this.btnEditLithology.setFont(new Font("Dialog", 1, 11));
        this.btnEditLithology.setText("Edit");
        this.btnEditLithology.addActionListener(this);
        jPanel7.setLayout(new BorderLayout());
        this.txtTexture.setText("");
        this.txtTexture.setFont(new Font("Dialog", 0, 11));
        this.txtTexture.setLineWrap(true);
        this.txtTexture.setWrapStyleWord(true);
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(titledBorder2);
        this.plotPhi = new phiPlotDataEntryPanel(this.stStruct.stPorosity);
        jPanel6.setLayout(new BorderLayout());
        this.lblPhi.setFont(new Font("Dialog", 1, 11));
        this.lblPhi.setHorizontalAlignment(0);
        this.lblPhi.setText(PHI[this.iPHI]);
        this.btnEditPhi.setFont(new Font("Dialog", 1, 11));
        this.btnEditPhi.setText("Edit");
        this.btnEditPhi.addActionListener(this);
        jPanel8.setLayout(new GridLayout(2, 1));
        jPanel8.setPreferredSize(new Dimension(300, 10));
        jPanel9.setLayout(new BorderLayout());
        jPanel9.setBorder(titledBorder3);
        this.plotSed = new sedimentaryPlotDataEntryPanel(this.stStruct.stSedStruct);
        this.btnEditSedStruct.setFont(new Font("Dialog", 1, 11));
        this.btnEditSedStruct.setText("Edit Sedimenary Structure");
        this.btnEditSedStruct.addActionListener(this);
        jPanel10.setLayout(new BorderLayout());
        jPanel10.setBorder(titledBorder4);
        this.plotFossil = new fossilPlotDataEntryPanel(this.stStruct.stFossils);
        this.btnEditFossil.setFont(new Font("Dialog", 1, 11));
        this.btnEditFossil.setText("Edit Fossil");
        this.btnEditFossil.addActionListener(this);
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setBorder(titledBorder5);
        jPanel11.setLayout(new GridLayout(3, 1));
        jPanel13.setBorder(titledBorder6);
        jPanel13.setLayout(new GridLayout(2, 1));
        jPanel16.setLayout(new BorderLayout());
        this.btnPrimary.setBackground(Color.white);
        this.btnPrimary.setText("");
        jPanel17.setLayout(new BorderLayout());
        this.txtPrimaryMunsell.setEditable(false);
        this.txtPrimaryMunsell.setText("");
        this.txtPrimaryMunsell.setColumns(8);
        jPanel18.setLayout(new BorderLayout());
        this.txtPrimary.setEditable(false);
        this.txtPrimary.setText("");
        jPanel15.setBorder(titledBorder7);
        jPanel15.setLayout(new GridLayout(2, 1));
        jPanel19.setLayout(new BorderLayout());
        this.btnSecondary.setBackground(Color.white);
        this.btnSecondary.setText("");
        jPanel20.setLayout(new BorderLayout());
        this.txtSecondaryMunsell.setEditable(false);
        this.txtSecondaryMunsell.setText("");
        this.txtSecondaryMunsell.setColumns(8);
        jPanel21.setLayout(new BorderLayout());
        this.txtSecondary.setEditable(false);
        this.txtSecondary.setText("");
        jPanel14.setBorder(titledBorder8);
        jPanel14.setLayout(new GridLayout(2, 1));
        jPanel22.setLayout(new BorderLayout());
        this.btnStreaks.setBackground(Color.white);
        this.btnStreaks.setText("");
        jPanel23.setLayout(new BorderLayout());
        this.txtStreaksMunsell.setEditable(false);
        this.txtStreaksMunsell.setText("");
        this.txtStreaksMunsell.setColumns(8);
        jPanel24.setLayout(new BorderLayout());
        this.txtStreaks.setEditable(false);
        this.txtStreaks.setText("");
        jPanel25.setLayout(new BorderLayout());
        this.btnEditColor.setFont(new Font("Dialog", 1, 11));
        this.btnEditColor.setText("Edit Color");
        this.btnEditColor.addActionListener(this);
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)jPanel3, null);
        jPanel3.add((Component)jPanel4, "North");
        jPanel4.add((Component)this.plotComp, "Center");
        jPanel4.add((Component)this.btnEditLithology, "East");
        jPanel3.add((Component)jPanel7, "Center");
        jPanel7.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.txtTexture, null);
        jPanel2.add((Component)jPanel5, null);
        jPanel5.add((Component)this.plotPhi, "Center");
        jPanel5.add((Component)jPanel6, "South");
        jPanel6.add((Component)this.lblPhi, "West");
        jPanel6.add((Component)this.btnEditPhi, "East");
        jPanel.add((Component)jPanel8, "East");
        jPanel8.add((Component)jPanel9, null);
        jPanel9.add((Component)this.plotSed, "Center");
        jPanel9.add((Component)this.btnEditSedStruct, "South");
        jPanel8.add((Component)jPanel10, null);
        jPanel10.add((Component)this.plotFossil, "Center");
        jPanel10.add((Component)this.btnEditFossil, "South");
        this.add((Component)jPanel12, "East");
        jPanel12.add((Component)jPanel11, "Center");
        jPanel11.add((Component)jPanel13, null);
        jPanel13.add((Component)jPanel16, null);
        jPanel16.add((Component)this.btnPrimary, "Center");
        jPanel16.add((Component)jPanel17, "East");
        jPanel17.add((Component)this.txtPrimaryMunsell, "Center");
        jPanel13.add((Component)jPanel18, null);
        jPanel18.add((Component)this.txtPrimary, "Center");
        jPanel11.add((Component)jPanel15, null);
        jPanel15.add((Component)jPanel19, null);
        jPanel19.add((Component)this.btnSecondary, "Center");
        jPanel19.add((Component)jPanel20, "East");
        jPanel20.add((Component)this.txtSecondaryMunsell, "Center");
        jPanel15.add((Component)jPanel21, null);
        jPanel21.add((Component)this.txtSecondary, "Center");
        jPanel11.add((Component)jPanel14, null);
        jPanel14.add((Component)jPanel22, null);
        jPanel22.add((Component)this.btnStreaks, "Center");
        jPanel22.add((Component)jPanel23, "East");
        jPanel23.add((Component)this.txtStreaksMunsell, "Center");
        jPanel14.add((Component)jPanel24, null);
        jPanel24.add((Component)this.txtStreaks, "Center");
        jPanel12.add((Component)jPanel25, "South");
        jPanel25.add((Component)this.btnEditColor, "Center");
    }

    public String getData() {
        int n;
        String string = "";
        String string2 = "";
        if (this.txtTexture.getText().length() > 0) {
            string = new String(this.txtTexture.getText() + "; ");
        }
        if (this.stColor != null) {
            for (int i = 0; i < 3; ++i) {
                if (i == 0 && this.stColor.sColor[i].length() > 0) {
                    string = new String(string + "1st: " + this.stColor.sColor[i] + " (" + this.stColor.sMunsell[i] + ")");
                }
                if (i == 1 && this.stColor.sColor[i].length() > 0) {
                    string = new String(string + ", 2nd: " + this.stColor.sColor[i] + " (" + this.stColor.sMunsell[i] + ")");
                }
                if (i != 2 || this.stColor.sColor[i].length() <= 0) continue;
                string = new String(string + ", other: " + this.stColor.sColor[i] + " (" + this.stColor.sMunsell[i] + ")");
            }
            if (this.stColor.sColor[0].length() > 0) {
                string = new String(string + "; ");
            }
        }
        if (this.stFossil != null) {
            if (this.stFossil.sEnvironment.length() > 0 && !this.stFossil.sEnvironment.equals("None")) {
                string = new String(string + this.stFossil.sEnvironment + ", ");
            }
            for (n = 0; n < this.stFossil.iTotal; ++n) {
                if (n > 0) {
                    string = new String(string + ", ");
                }
                string = this.stFossil.sMod[n].length() > 0 ? new String(string + this.stFossil.sMod[n] + " " + this.stFossil.sText[n]) : new String(string + this.stFossil.sText[n]);
            }
            string = new String(string + "; ");
        }
        if (this.stSedStruct != null) {
            for (n = 0; n < this.stSedStruct.iTotal; ++n) {
                if (n > 0) {
                    string = new String(string + ", ");
                }
                string = new String(string + this.stSedStruct.sText[n]);
            }
            string = new String(string + "; ");
        }
        if (this.stPhi != null) {
            string2 = new String("No Visible Porosity");
            if (this.stPhi.dPHI > 0.0 && this.stPhi.dPHI < 1.0) {
                string2 = new String("Trace Porosity");
            }
            if (this.stPhi.dPHI >= 1.0 && this.stPhi.dPHI < 5.0) {
                string2 = new String("Poor Porosity");
            }
            if (this.stPhi.dPHI >= 5.0 && this.stPhi.dPHI < 10.0) {
                string2 = new String("Fair Porosity");
            }
            if (this.stPhi.dPHI >= 10.0 && this.stPhi.dPHI < 15.0) {
                string2 = new String("Good Porosity");
            }
            if (this.stPhi.dPHI >= 15.0) {
                string2 = new String("Excellent Porosity");
            }
            string = new String(string + string2 + " (" + this.stPhi.dPHI + "%) ");
            for (n = 0; n < this.stPhi.iTotal; ++n) {
                string = new String(string + ", ");
                string = new String(string + this.stPhi.sText[n] + " porosity");
            }
            string = new String(string + "; ");
        }
        return string;
    }

    public void setData(rockColumnListStruct rockColumnListStruct2) {
        this.stColumn = rockColumnListStruct2;
    }

    public void setData(lithologyListStruct lithologyListStruct2) {
        if (lithologyListStruct2 != null && lithologyListStruct2.iCount > 0) {
            this.stLithology = lithologyListStruct2.stItem[0];
            if (this.plotComp != null) {
                this.plotComp.setData(this.stLithology);
            }
        }
    }

    public void setData(String string, textureListStruct textureListStruct2) {
        String string2 = "";
        if (textureListStruct2 != null && string != null) {
            string2 = parseTextureUtility.parse(string, this.stStruct.stSymbols, this.stStruct.stParseTexture);
            if (textureListStruct2.iCount > 0) {
                this.stTexture = textureListStruct2.stItem[0];
                string2 = new String(string2 + " ( Energy: " + this.stTexture.iEnergy + " )");
            }
            this.txtTexture.setText(string2);
        }
    }

    public void setData(phiListStruct phiListStruct2) {
        if (phiListStruct2 != null && phiListStruct2.iCount > 0) {
            this.stPhi = phiListStruct2.stItem[0];
            if (this.plotPhi != null) {
                this.iPHI = 0;
                if (this.stPhi.dPHI > 0.0 && this.stPhi.dPHI < 1.0) {
                    this.iPHI = 1;
                }
                if (this.stPhi.dPHI >= 1.0 && this.stPhi.dPHI < 5.0) {
                    this.iPHI = 2;
                }
                if (this.stPhi.dPHI >= 5.0 && this.stPhi.dPHI < 10.0) {
                    this.iPHI = 3;
                }
                if (this.stPhi.dPHI >= 10.0 && this.stPhi.dPHI < 15.0) {
                    this.iPHI = 4;
                }
                if (this.stPhi.dPHI >= 15.0) {
                    this.iPHI = 5;
                }
                this.lblPhi.setText(PHI[this.iPHI]);
                this.plotPhi.setData(this.stPhi);
            }
        }
    }

    public void setData(sedimentaryListStruct sedimentaryListStruct2) {
        if (sedimentaryListStruct2 != null && sedimentaryListStruct2.iCount > 0) {
            this.stSedStruct = sedimentaryListStruct2.stItem[0];
            if (this.plotSed != null) {
                this.plotSed.setData(this.stSedStruct);
            }
        }
    }

    public void setData(fossilListStruct fossilListStruct2) {
        if (fossilListStruct2 != null && fossilListStruct2.iCount > 0) {
            this.stFossil = fossilListStruct2.stItem[0];
            if (this.plotFossil != null) {
                this.plotFossil.setData(this.stFossil);
            }
        }
    }

    public void setData(rockColorListStruct rockColorListStruct2) {
        if (rockColorListStruct2 != null && rockColorListStruct2.iCount > 0) {
            this.stColor = rockColorUtility.copy(rockColorListStruct2.stItem[0]);
            this.btnPrimary.setBackground(Color.white);
            if (this.stColor.iRGB[0][0] > -1) {
                this.btnPrimary.setBackground(new Color(this.stColor.iRGB[0][0], this.stColor.iRGB[0][1], this.stColor.iRGB[0][2]));
            }
            this.txtPrimaryMunsell.setText(this.stColor.sMunsell[0]);
            this.txtPrimary.setText(this.stColor.sColor[0]);
            this.btnSecondary.setBackground(Color.white);
            if (this.stColor.iRGB[1][0] > -1) {
                this.btnSecondary.setBackground(new Color(this.stColor.iRGB[1][0], this.stColor.iRGB[1][1], this.stColor.iRGB[1][2]));
            }
            this.txtSecondaryMunsell.setText(this.stColor.sMunsell[1]);
            this.txtSecondary.setText(this.stColor.sColor[1]);
            this.btnStreaks.setBackground(Color.white);
            if (this.stColor.iRGB[2][0] > -1) {
                this.btnStreaks.setBackground(new Color(this.stColor.iRGB[2][0], this.stColor.iRGB[2][1], this.stColor.iRGB[2][2]));
            }
            this.txtStreaksMunsell.setText(this.stColor.sMunsell[2]);
            this.txtStreaks.setText(this.stColor.sColor[2]);
        }
    }

    public void clear() {
        this.closeData();
        this.iPHI = 0;
        this.lblPhi.setText(PHI[this.iPHI]);
        this.txtTexture.setText("");
        if (this.plotComp != null) {
            this.plotComp.setData(this.stLithology);
        }
        if (this.plotPhi != null) {
            this.plotPhi.setData(this.stPhi);
        }
        if (this.plotSed != null) {
            this.plotSed.setData(this.stSedStruct);
        }
        if (this.plotFossil != null) {
            this.plotFossil.setData(this.stFossil);
        }
        this.btnPrimary.setBackground(Color.white);
        this.txtPrimaryMunsell.setText("");
        this.txtPrimary.setText("");
        this.btnSecondary.setBackground(Color.white);
        this.txtSecondaryMunsell.setText("");
        this.txtSecondary.setText("");
        this.btnStreaks.setBackground(Color.white);
        this.txtStreaksMunsell.setText("");
        this.txtStreaks.setText("");
    }

    public void displayLithology() {
        this.closeLith();
        this.pLithology = new lithologyEntryFrame(this.notifier, this.stStruct);
    }

    public void displayPHI() {
        this.closePHI();
        this.pPHI = new phiPlotSymbolFrame(this.notifier, this.stStruct.stPorosity);
        if (this.stPhi != null) {
            this.pPHI.setData(this.stPhi);
        }
    }

    public void displaySedStructs() {
        this.closeSedStruct();
        this.pStruct = new sedimentaryPlotSymbolFrame(this.notifier, this.stStruct.stSedStruct);
        if (this.stSedStruct != null) {
            this.pStruct.setData(this.stSedStruct);
        }
    }

    public void displayFossils() {
        this.closeFossils();
        this.pFossils = new fossilPlotSymbolFrame(this.notifier, this.stStruct.stFossils);
        if (this.stFossil != null) {
            this.pFossils.setData(this.stFossil);
        }
    }

    public void displayColors() {
        this.closeColors();
        this.pColors = new rockColorChartPlotFrame(this.notifier, this.stStruct);
        if (this.stColor != null) {
            this.pColors.setData(this.stColor);
        }
    }

    public void closeLith() {
        if (this.pLithology != null) {
            this.pLithology.close();
        }
        this.pLithology = null;
    }

    public void closePHI() {
        if (this.pPHI != null) {
            this.pPHI.close();
        }
        this.pPHI = null;
    }

    public void closeSedStruct() {
        if (this.pStruct != null) {
            this.pStruct.close();
        }
        this.pStruct = null;
    }

    public void closeFossils() {
        if (this.pFossils != null) {
            this.pFossils.close();
        }
        this.pFossils = null;
    }

    public void closeColors() {
        if (this.pColors != null) {
            this.pColors.close();
        }
        this.pColors = null;
    }

    public void closeData() {
        if (this.stLithology != null) {
            this.stLithology.delete();
        }
        this.stLithology = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        if (this.stPhi != null) {
            this.stPhi.delete();
        }
        this.stPhi = null;
        if (this.stSedStruct != null) {
            this.stSedStruct.delete();
        }
        this.stSedStruct = null;
        if (this.stFossil != null) {
            this.stFossil.delete();
        }
        this.stFossil = null;
        if (this.stColor != null) {
            this.stColor.delete();
        }
        this.stColor = null;
    }

    public void close() {
        this.pNotifier = null;
        this.stStruct = null;
        this.notifier = null;
        this.closeData();
        this.closeLith();
        this.closePHI();
        this.closeSedStruct();
        this.closeFossils();
        this.closeColors();
        if (this.plotComp != null) {
            this.plotComp.close();
        }
        this.plotComp = null;
        if (this.plotPhi != null) {
            this.plotPhi.close();
        }
        this.plotPhi = null;
        if (this.plotSed != null) {
            this.plotSed.close();
        }
        this.plotSed = null;
        if (this.plotFossil != null) {
            this.plotFossil.close();
        }
        this.plotFossil = null;
        this.lblPhi = null;
        this.txtTexture = null;
        this.btnPrimary = null;
        this.txtPrimaryMunsell = null;
        this.txtPrimary = null;
        this.btnSecondary = null;
        this.txtSecondaryMunsell = null;
        this.txtSecondary = null;
        this.btnStreaks = null;
        this.txtStreaksMunsell = null;
        this.txtStreaks = null;
        this.btnEditLithology = null;
        this.btnEditPhi = null;
        this.btnEditSedStruct = null;
        this.btnEditFossil = null;
        this.btnEditColor = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnEditLithology) {
            this.displayLithology();
        }
        if (actionEvent.getSource() == this.btnEditPhi) {
            this.displayPHI();
        }
        if (actionEvent.getSource() == this.btnEditSedStruct) {
            this.displaySedStructs();
        }
        if (actionEvent.getSource() == this.btnEditFossil) {
            this.displayFossils();
        }
        if (actionEvent.getSource() == this.btnEditColor) {
            this.displayColors();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Object object2;
        Object object3;
        String string = new String((String)object);
        if (string.equals("ADD or MODIFY Porosity Data")) {
            object3 = new phiListStruct();
            object2 = null;
            object2 = phiUtility.copy(this.pPHI.getData());
            if (object2 != null) {
                object3 = phiUtility.add((phiStruct)object2, (phiListStruct)object3);
            }
            this.closePHI();
            this.setData((phiListStruct)object3);
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Rock Description"));
            }
        }
        if (string.equals("ADD or MODIFY Lithology Data")) {
            object3 = new lithologyListStruct();
            object2 = null;
            object2 = lithologyUtility.copy(this.pLithology.getData());
            this.txtTexture.setText(this.pLithology.getText());
            if (object2 != null) {
                object3 = lithologyUtility.add((lithologyStruct)object2, (lithologyListStruct)object3);
            }
            this.closeLith();
            this.setData((lithologyListStruct)object3);
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Rock Description"));
            }
        }
        if (string.equals("ADD or MODIFY Sed Struct Data")) {
            object3 = new sedimentaryListStruct();
            object2 = null;
            object2 = sedimentaryUtility.copy(this.pStruct.getData());
            if (object2 != null) {
                object3 = sedimentaryUtility.add((sedimentaryStruct)object2, (sedimentaryListStruct)object3);
            }
            this.closeSedStruct();
            this.setData((sedimentaryListStruct)object3);
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Rock Description"));
            }
        }
        if (string.equals("ADD or MODIFY Fossil Data")) {
            object3 = new fossilListStruct();
            object2 = null;
            object2 = fossilUtility.copy(this.pFossils.getData());
            if (object2 != null) {
                object3 = fossilUtility.add((fossilStruct)object2, (fossilListStruct)object3);
            }
            this.closeFossils();
            this.setData((fossilListStruct)object3);
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Rock Description"));
            }
        }
        if (string.equals("ADD or MODIFY Rock Color Data")) {
            object3 = new rockColorListStruct();
            object2 = null;
            object2 = rockColorUtility.copy(this.pColors.getData());
            if (object2 != null) {
                object3 = rockColorUtility.add((rockColorStruct)object2, (rockColorListStruct)object3);
            }
            this.closeColors();
            this.setData((rockColorListStruct)object3);
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Rock Description"));
            }
        }
    }
}

