/*
 * Decompiled with CFR 0.152.
 */
package rock.gui;

import cmn.cmnString;
import iqstrat.iqstratControlPlotData;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import lith.lithology.lithologyListStruct;
import lith.rock.rockColumnListStruct;
import lith.rock.rockColumnUtility;
import lith.texture.textureListStruct;
import parse.parseColorUtility;
import parse.parseFossilUtility;
import parse.parseMineralsUtility;
import parse.parsePHIUtility;
import parse.parseRockColumnSymbolsUtility;
import parse.parseSedStructUtility;
import parse.parseTextureUtility;
import rock.color.rockColorListStruct;
import rock.color.rockColorUtility;
import rock.fossil.fossilListStruct;
import rock.fossil.fossilUtility;
import rock.gui.rockEnterDataTable;
import rock.gui.rockObsEntryFrameFocusAdapter;
import rock.gui.rockObsEntryFrameObservable;
import rock.gui.rockObsEntryPanel;
import rock.gui.rockObsEntryPlotPanel;
import rock.phi.phiListStruct;
import rock.phi.phiUtility;
import rock.sedimentary.sedimentaryListStruct;
import rock.sedimentary.sedimentaryUtility;

public class rockObsEntryFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private Observable notifier = null;
    public static final int _ADD = 0;
    public static final int _MODIFY = 1;
    public static final int _REMOVE = 2;
    public static final int _REMOVE_ALL = 3;
    private int iAction = 0;
    private String sKEY = "0";
    private double dStart = 0.0;
    private double dEnd = 20.0;
    private double dThickness = 20.0;
    private int iScale = 4;
    private rockEnterDataTable pTable = null;
    private rockObsEntryPlotPanel plot = null;
    private int[] iSelected = new int[]{75, 76, 79, 80, 82, 83};
    private rockObsEntryPanel panel = null;
    private iqstratRemarkListStruct stRemarks = null;
    private iqstratRemarkStruct stRemark = null;
    private iqstratRemarkListStruct stTemp = null;
    private phiListStruct stPHI = null;
    private rockColumnListStruct stColumn = null;
    private lithologyListStruct stLithology = null;
    private textureListStruct stTexture = null;
    private sedimentaryListStruct stSedimentary = null;
    private fossilListStruct stFossil = null;
    private rockColorListStruct stRockColor = null;
    private lithologyListStruct stPlotLithology = null;
    private textureListStruct stPlotTexture = null;
    public static final int _HEADERS = 0;
    public static final int _LAS3 = 1;
    public static final int _LAS = 2;
    public static final int _ROCK = 3;
    public static final int _ROCK_IMAGES = 4;
    public static final int _TOPS = 5;
    public static final int _SEQ_STRAT = 6;
    public static final int _PERFORATION = 7;
    public static final int _ROCK_COLUMN = 20;
    public static final int _LITHOLOGY = 8;
    public static final int _TEXTURE = 9;
    public static final int _ROCK_PHI = 10;
    public static final int _SED_STRUCT = 11;
    public static final int _FOSSILS = 12;
    public static final int _ROCK_COLOR = 13;
    public static final int _REMARKS = 14;
    public static final int _PFEFFER = 15;
    public static final int _SHALE = 16;
    private static final int _BY_PLOT = 0;
    private static final int _BY_TRACK = 1;
    private static final String[] BUTTONS = new String[]{"Parse & Plot Description", "Enter Description by Image Tracks"};
    private static final String[] PANEL = new String[]{"Plot Description", "Enter Description by Image Track"};
    private int iPanel = 0;
    private JTextArea txtRemarks = new JTextArea();
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private JTextField txtThickness = new JTextField();
    private JButton btnAdd = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnCancel = new JButton();
    private JButton btnModify = new JButton();
    private JButton btnRemove = new JButton();
    private JButton btnRemoveAll = new JButton();
    private JPanel pnlData = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private TitledBorder titledBorderEntry = null;
    private JRadioButton rbByPlot = new JRadioButton();
    private JRadioButton rbByData = new JRadioButton();
    private JMenuItem mHelp = null;
    private JMenuItem mExit = null;

    public rockObsEntryFrame(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
            this.addWindowListener(new rockObsEntryFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Comments/Remarks/Notes:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Start Depth:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "End Depth:");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Thickness:");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        this.titledBorderEntry = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Plot Description");
        this.titledBorderEntry.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        JMenu jMenu2 = new JMenu("Help");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        this.mHelp = new JMenuItem("Help");
        this.mHelp.addActionListener(this);
        jMenu2.add(this.mHelp);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.notifier = new rockObsEntryFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("Enter Core / Rock / Bed Description");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(10, 250));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridLayout());
        this.rbByPlot.setFont(new Font("Monospaced", 1, 11));
        this.rbByPlot.setHorizontalAlignment(0);
        this.rbByPlot.setSelected(true);
        this.rbByPlot.setText(BUTTONS[0]);
        this.rbByPlot.addActionListener(this);
        this.rbByData.setFont(new Font("Monospaced", 1, 11));
        this.rbByData.setHorizontalAlignment(0);
        this.rbByData.setText(BUTTONS[1]);
        this.rbByData.addActionListener(this);
        this.pnlData.setBorder(this.titledBorderEntry);
        this.pnlData.setLayout(this.cardLayout);
        this.plot = new rockObsEntryPlotPanel(this.stStruct, this.dStart, this.dEnd, this.iScale, this.iSelected);
        this.panel = new rockObsEntryPanel(this.notifier, this.stStruct);
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        this.txtRemarks.setText("");
        this.txtRemarks.setRows(7);
        this.txtRemarks.setFont(new Font("Dialog", 0, 14));
        this.txtRemarks.setLineWrap(true);
        this.txtRemarks.setWrapStyleWord(true);
        this.txtRemarks.addFocusListener(new rockObsEntryFrameFocusAdapter(this));
        jPanel5.setPreferredSize(new Dimension(10, 60));
        jPanel5.setLayout(new BorderLayout());
        jPanel6.setLayout(new GridLayout());
        jPanel7.setBorder(titledBorder2);
        jPanel7.setLayout(new BorderLayout());
        this.txtStart.setText("0.0");
        this.txtStart.setColumns(8);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new rockObsEntryFrameFocusAdapter(this));
        jPanel8.setBorder(titledBorder3);
        jPanel8.setLayout(new BorderLayout());
        this.txtEnd.setText("20.0");
        this.txtEnd.setColumns(8);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new rockObsEntryFrameFocusAdapter(this));
        jPanel9.setBorder(titledBorder4);
        jPanel9.setLayout(new BorderLayout());
        this.txtThickness.setText("20.0");
        this.txtThickness.setColumns(8);
        this.txtThickness.setHorizontalAlignment(11);
        this.txtThickness.addFocusListener(new rockObsEntryFrameFocusAdapter(this));
        jPanel10.setLayout(new GridLayout(2, 1));
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(this);
        jPanel11.setLayout(new GridLayout());
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel13.setLayout(new GridLayout());
        this.btnModify.setFont(new Font("Dialog", 1, 11));
        this.btnModify.setPreferredSize(new Dimension(98, 25));
        this.btnModify.setText("Modify");
        this.btnModify.addActionListener(this);
        this.btnRemove.setFont(new Font("Dialog", 1, 11));
        this.btnRemove.setPreferredSize(new Dimension(98, 25));
        this.btnRemove.setText("Remove");
        this.btnRemove.addActionListener(this);
        this.btnRemoveAll.setFont(new Font("Dialog", 1, 11));
        this.btnRemoveAll.setPreferredSize(new Dimension(98, 25));
        this.btnRemoveAll.setText("Remove All");
        this.btnRemoveAll.addActionListener(this);
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setPreferredSize(new Dimension(10, 200));
        this.pTable = new rockEnterDataTable(this.stStruct.stSymbols);
        jScrollPane = this.pTable.getScrollPane();
        this.setButtons();
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.rbByPlot, null);
        jPanel2.add((Component)this.rbByData, null);
        buttonGroup.add(this.rbByPlot);
        buttonGroup.add(this.rbByData);
        jPanel.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)this.plot, "BY_PLOT");
        this.pnlData.add((Component)this.panel, "BY_TRACK");
        this.getContentPane().add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)this.txtRemarks, null);
        jPanel3.add((Component)jPanel5, "North");
        jPanel5.add((Component)jPanel6, "West");
        jPanel6.add((Component)jPanel7, null);
        jPanel7.add((Component)this.txtStart, "Center");
        jPanel6.add((Component)jPanel8, null);
        jPanel8.add((Component)this.txtEnd, "Center");
        jPanel6.add((Component)jPanel9, null);
        jPanel9.add((Component)this.txtThickness, "Center");
        jPanel5.add((Component)jPanel10, "East");
        jPanel10.add((Component)this.btnAdd, null);
        jPanel10.add((Component)jPanel11, null);
        jPanel11.add((Component)this.btnCancel, null);
        jPanel11.add((Component)this.btnClear, null);
        this.getContentPane().add((Component)jPanel12, "South");
        jPanel12.add((Component)jScrollPane, "Center");
        jPanel12.add((Component)jPanel13, "South");
        jPanel13.add((Component)this.btnModify, null);
        jPanel13.add((Component)this.btnRemove, null);
        jPanel13.add((Component)this.btnRemoveAll, null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(770, 780));
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public iqstratRemarkListStruct getRemarks() {
        return this.stRemarks;
    }

    private void getData(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 16: {
                break;
            }
            case 10: {
                this.stPHI = phiUtility.copyList(parsePHIUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stParsePorosity));
                break;
            }
            case 20: {
                this.stColumn = rockColumnUtility.copyList(parseRockColumnSymbolsUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stParseRock));
                break;
            }
            case 8: {
                this.stLithology = parseMineralsUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stSymbols, this.stStruct.stParseTexture, this.stStruct.stMinerals);
                this.stPlotLithology = iqstratControlPlotData.getPlotLithology(this.stLithology, this.stPlotLithology);
                break;
            }
            case 9: {
                this.stTexture = parseTextureUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stSymbols, this.stStruct.stParseTexture);
                this.stPlotTexture = iqstratControlPlotData.getPlotTexture(this.stTexture, this.stPlotTexture);
                break;
            }
            case 11: {
                this.stSedimentary = sedimentaryUtility.copyList(parseSedStructUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stParseSedStruct));
                this.modifyWidths();
                break;
            }
            case 12: {
                this.stFossil = fossilUtility.copyList(parseFossilUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct.stParseFossils, this.stStruct.stBio, this.stStruct.stKSBio));
                this.modifyWidths();
                break;
            }
            case 13: {
                this.stRockColor = rockColorUtility.copyList(parseColorUtility.parse(iqstratRemarkUtility.copyList(this.stTemp), this.stStruct));
            }
        }
    }

    private void getGeoReportData() {
        this.getData(20);
        this.getData(10);
        this.getData(8);
        this.getData(9);
        this.getData(13);
        this.getData(12);
        this.getData(11);
        this.plotData();
    }

    private iqstratRemarkStruct getRemark() {
        iqstratRemarkStruct iqstratRemarkStruct2 = new iqstratRemarkStruct();
        iqstratRemarkStruct2.depthStart = this.dStart;
        iqstratRemarkStruct2.depthEnd = this.dEnd;
        iqstratRemarkStruct2.sText = this.txtRemarks.getText();
        if (iqstratRemarkStruct2.sNote.length() == 0 && iqstratRemarkStruct2.sText.length() > 0) {
            iqstratRemarkStruct2.sNote = iqstratRemarkStruct2.sText.length() < 41 ? new String(iqstratRemarkStruct2.sText) : new String(iqstratRemarkStruct2.sText.substring(0, 40));
        }
        return iqstratRemarkStruct2;
    }

    private void getTextArea() {
        this.closeData();
        iqstratRemarkStruct iqstratRemarkStruct2 = this.getRemark();
        iqstratRemarkStruct2.depthStart = 0.0;
        iqstratRemarkStruct2.depthEnd = 20.0;
        this.stTemp = iqstratRemarkUtility.add(iqstratRemarkStruct2, this.stTemp);
        this.getGeoReportData();
    }

    private void setButtons() {
        this.btnCancel.setEnabled(false);
        if (this.iAction == 1) {
            this.btnCancel.setEnabled(true);
        }
        this.btnModify.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnRemoveAll.setEnabled(false);
        if (this.pTable.getTotalRows() > 0 && this.iAction == 0) {
            this.btnModify.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnRemoveAll.setEnabled(true);
        }
    }

    private void setBorders(int n) {
        this.iPanel = n;
        switch (n) {
            case 0: {
                this.getTextArea();
                this.cardLayout.show(this.pnlData, "BY_PLOT");
                break;
            }
            case 1: {
                this.cardLayout.show(this.pnlData, "BY_TRACK");
            }
        }
        this.titledBorderEntry.setTitle(PANEL[n]);
        this.pnlData.updateUI();
    }

    public void setRemarksData(iqstratRemarkListStruct iqstratRemarkListStruct2) {
        this.stRemarks = iqstratRemarkListStruct2;
        if (this.pTable != null) {
            this.pTable.setRemarksData(iqstratRemarkListStruct2);
        }
        this.setButtons();
    }

    private void setDepth() {
        int n = (int)(this.dStart / 10.0);
        double d = this.dStart;
        double d2 = 0.0;
        this.setScale();
        switch (this.iScale) {
            case 6: {
                d2 = d + 100.0;
                break;
            }
            case 5: {
                d2 = d + 50.0;
                break;
            }
            case 4: {
                d2 = d + 20.0;
                break;
            }
            case 3: {
                d2 = d + 10.0;
                break;
            }
            case 2: {
                d2 = d + 5.0;
                break;
            }
            case 1: {
                d2 = d + 4.0;
                break;
            }
            case 0: {
                d2 = d + 2.0;
            }
        }
        if (this.plot != null) {
            this.plot.setScale(4, 20.0, 0.0);
        }
    }

    private void setScale() {
        if (this.dThickness <= 100.0) {
            this.iScale = 6;
        }
        if (this.dThickness <= 50.0) {
            this.iScale = 5;
        }
        if (this.dThickness <= 20.0) {
            this.iScale = 4;
        }
        if (this.dThickness <= 10.0) {
            this.iScale = 3;
        }
        if (this.dThickness <= 5.0) {
            this.iScale = 2;
        }
        if (this.dThickness <= 2.0) {
            this.iScale = 1;
        }
        if (this.dThickness <= 1.0) {
            this.iScale = 0;
        }
    }

    private void modifyWidths() {
        int n = 0;
        int n2 = 0;
        n2 = sedimentaryUtility.computeWidth(this.stSedimentary);
        n = fossilUtility.computeWidth(this.stFossil);
        if (this.plot != null) {
            this.plot.modifyWidths(n, n2);
        }
    }

    public void clear() {
        this.sKEY = new String("0");
        this.txtRemarks.setText("");
        this.dStart = 0.0;
        this.dEnd = 20.0;
        this.dThickness = 20.0;
        this.txtStart.setText("" + this.dStart);
        this.txtEnd.setText("" + this.dEnd);
        this.txtThickness.setText("" + this.dThickness);
        this.setDepth();
        this.closeData();
        if (this.plot != null) {
            this.plot.setPHI(this.stPHI);
            this.plot.setRockColumn(this.stColumn);
            this.plot.setStructures(this.stSedimentary);
            this.plot.setFossils(this.stFossil);
            this.plot.setRockColorData(this.stRockColor);
        }
        this.modifyWidths();
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void cancel() {
        this.iAction = 0;
        this.btnAdd.setText("Add");
        this.txtRemarks.setText("");
        this.dStart = 0.0;
        this.dEnd = 20.0;
        this.dThickness = 20.0;
        this.txtStart.setText("" + this.dStart);
        this.txtEnd.setText("" + this.dEnd);
        this.txtThickness.setText("" + this.dThickness);
        this.setDepth();
        this.closeData();
        if (this.plot != null) {
            this.plot.setPHI(this.stPHI);
            this.plot.setRockColumn(this.stColumn);
            this.plot.setStructures(this.stSedimentary);
            this.plot.setFossils(this.stFossil);
            this.plot.setRockColorData(this.stRockColor);
        }
        this.modifyWidths();
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    private void plotData() {
        if (this.plot != null) {
            this.plot.setPHI(this.stPHI);
            this.plot.setRockColumn(this.stColumn);
            this.plot.setStructures(this.stSedimentary);
            this.plot.setFossils(this.stFossil);
            this.plot.setRockColorData(this.stRockColor);
        }
        this.modifyWidths();
        if (this.panel != null) {
            this.panel.setData(this.stPHI);
            this.panel.setData(this.stColumn);
            this.panel.setData(this.stLithology);
            this.panel.setData(this.txtRemarks.getText(), this.stTexture);
            this.panel.setData(this.stSedimentary);
            this.panel.setData(this.stFossil);
            this.panel.setData(this.stRockColor);
        }
    }

    private void add() {
        if (this.stRemark == null) {
            this.stRemark = new iqstratRemarkStruct();
            this.stRemark.sKEY = new String(cmnString.UniqueName());
        }
        this.stRemark.depthStart = this.dStart;
        this.stRemark.depthEnd = this.dEnd;
        this.stRemark.dThickness = this.dThickness;
        this.stRemark.sText = new String(this.txtRemarks.getText());
        this.stRemark.sNote = this.stRemark.sText.length() < 41 ? new String(this.stRemark.sText) : new String(this.stRemark.sText.substring(0, 40));
        switch (this.iAction) {
            case 0: {
                this.stRemarks = iqstratRemarkUtility.add(this.stRemark, this.stRemarks);
                break;
            }
            case 1: {
                this.stRemarks = iqstratRemarkUtility.modify(this.stRemark.sKEY, this.stRemark, this.stRemarks);
            }
        }
        this.stRemarks = iqstratRemarkUtility.bubbleSort(this.stRemarks);
        this.setRemarksData(this.stRemarks);
        this.clear();
        if (this.stRemark != null) {
            this.stRemark.delete();
        }
        this.stRemark = null;
        if (this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("ADD or MODIFY Remarks Data"));
        }
    }

    private void modify() {
        int n = 0;
        if (this.stRemark != null) {
            this.stRemark.delete();
        }
        this.stRemark = null;
        this.closeData();
        this.iAction = 1;
        this.btnAdd.setText("Modify");
        this.stRemark = iqstratRemarkUtility.copy(this.pTable.getRemarkData());
        this.sKEY = new String(this.stRemark.sKEY);
        this.txtRemarks.setText(this.stRemark.sText);
        this.dStart = this.stRemark.depthStart;
        this.dEnd = this.stRemark.depthEnd;
        n = (int)(10.0 * Math.abs(this.dEnd - this.dStart));
        this.dThickness = (double)n / 10.0;
        this.txtStart.setText("" + this.dStart);
        this.txtEnd.setText("" + this.dEnd);
        this.txtThickness.setText("" + this.dThickness);
        this.setDepth();
        this.getTextArea();
    }

    private void removeRow() {
        iqstratRemarkStruct iqstratRemarkStruct2 = this.pTable.getRemarkData();
        this.stRemarks = iqstratRemarkUtility.remove(iqstratRemarkStruct2.sKEY, this.stRemarks);
        this.setRemarksData(this.stRemarks);
        if (this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("REMOVE Remarks Data"));
        }
    }

    private void removeAllRows() {
        if (this.stRemarks != null) {
            this.stRemarks.delete();
        }
        this.stRemarks = null;
        this.setRemarksData(this.stRemarks);
        this.clear();
        if (this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("REMOVE All Remarks Data"));
        }
    }

    private void closeData() {
        if (this.stTemp != null) {
            this.stTemp.delete();
        }
        this.stTemp = null;
        if (this.stPHI != null) {
            this.stPHI.delete();
        }
        this.stPHI = null;
        if (this.stColumn != null) {
            this.stColumn.delete();
        }
        this.stColumn = null;
        if (this.stLithology != null) {
            this.stLithology.delete();
        }
        this.stLithology = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        if (this.stSedimentary != null) {
            this.stSedimentary.delete();
        }
        this.stSedimentary = null;
        if (this.stFossil != null) {
            this.stFossil.delete();
        }
        this.stFossil = null;
        if (this.stRockColor != null) {
            this.stRockColor.delete();
        }
        this.stRockColor = null;
        if (this.stPlotLithology != null) {
            this.stPlotLithology.delete();
        }
        this.stPlotLithology = null;
        if (this.stPlotTexture != null) {
            this.stPlotTexture.delete();
        }
        this.stPlotTexture = null;
    }

    public void close() {
        this.pNotifier = null;
        this.stStruct = null;
        this.sKEY = null;
        this.notifier = null;
        if (this.pTable != null) {
            this.pTable.close();
        }
        this.pTable = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        if (this.panel != null) {
            this.panel.close();
        }
        this.panel = null;
        this.stRemarks = null;
        this.closeData();
        this.txtRemarks = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.txtThickness = null;
        this.btnAdd = null;
        this.btnClear = null;
        this.btnCancel = null;
        this.btnModify = null;
        this.btnRemove = null;
        this.btnRemoveAll = null;
        this.pnlData = null;
        this.cardLayout = null;
        this.titledBorderEntry = null;
        this.rbByPlot = null;
        this.rbByData = null;
        this.mHelp = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbByPlot) {
            this.setBorders(0);
        }
        if (actionEvent.getSource() == this.rbByData) {
            this.setBorders(1);
        }
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnClear) {
            this.clear();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.cancel();
        }
        if (actionEvent.getSource() == this.btnModify) {
            this.modify();
        }
        if (actionEvent.getSource() == this.btnRemove) {
            this.removeRow();
        }
        if (actionEvent.getSource() == this.btnRemoveAll) {
            this.removeAllRows();
        }
        this.setButtons();
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        int n = 0;
        String string = new String("");
        String string2 = new String("");
        double d = 0.0;
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtThickness) {
            bl = true;
            string2 = this.txtThickness.getText();
            string = new String("Bed Thickness Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtRemarks) {
            this.getTextArea();
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                d = cmnString.stringToDouble(this.txtStart.getText());
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                    if (this.dThickness > 0.0) {
                        n = (int)(10.0 * (d + this.dThickness));
                        this.dEnd = (double)n / 10.0;
                        this.txtEnd.setText("" + this.dEnd);
                    }
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                    if (this.dEnd == this.dStart) {
                        this.dEnd = this.dStart + 10.0;
                        this.txtEnd.setText("" + this.dEnd);
                    }
                    n = (int)(10.0 * Math.abs(this.dEnd - d));
                    this.dThickness = (double)n / 10.0;
                    this.txtThickness.setText("" + this.dThickness);
                }
                if (focusEvent.getSource() == this.txtThickness) {
                    this.dThickness = cmnString.stringToDouble(this.txtThickness.getText());
                    if (this.dThickness <= 0.0) {
                        this.dThickness = 10.0;
                        this.txtThickness.setText("" + this.dThickness);
                    }
                    n = (int)(10.0 * (d + this.dThickness));
                    this.dEnd = (double)n / 10.0;
                    this.txtEnd.setText("" + this.dEnd);
                }
                this.setDepth();
                this.getTextArea();
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("Rock Description")) {
            this.txtRemarks.setText("" + this.dStart + "; " + this.dEnd + "; " + this.panel.getData());
        }
    }

    public class rockObsEntryFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            rockObsEntryFrame.this.close();
        }
    }
}

