/*
 * Decompiled with CFR 0.152.
 */
package rock.fossil.plot;

import cmn.cmnString;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.fossil.fossilStruct;

public class fossilPlotSymbol
extends Canvas
implements MouseListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private static final int NO = 0;
    private static final int YES = 1;
    private static final int _GENERAL = 0;
    private static final int _RARE = 1;
    private static final int _MANY = 2;
    private static final int _BROKEN = 3;
    private static final String[] MOD = new String[]{"G", "R", "A", "B"};
    private fossilStruct st = null;
    private int[] iSelected = null;
    private int[][] iMod = null;
    private int iWidth = 300;
    private int iHeight = 950;
    private static final int _START = 10;
    private static final int _SELECTED = 10;
    private static final int _SELECT_GEN = 22;
    private static final int _SELECT_RARE = 34;
    private static final int _SELECT_MANY = 46;
    private static final int _SELECT_BROK = 58;
    private static final int _IMAGE_START = 90;
    private static final int _DESC_START = 105;
    private static final int _DESCRIPTION = 115;
    private static final int _SEP = 15;

    public fossilPlotSymbol(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.notifier = observable;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.iSelected = new int[maskSymbolsListStruct2.iCount];
        this.iMod = new int[maskSymbolsListStruct2.iCount][4];
        for (int i = 0; i < maskSymbolsListStruct2.iCount; ++i) {
            this.iSelected[i] = 0;
            for (int j = 0; j < 4; ++j) {
                this.iMod[i][j] = 0;
            }
        }
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.st = null;
        this.iSelected = null;
        this.iMod = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public fossilStruct getData() {
        return this.st;
    }

    public void setData(fossilStruct fossilStruct2) {
        int n = 0;
        this.st = fossilStruct2;
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            this.iSelected[i] = 0;
            if (this.isSelected(i)) {
                this.iSelected[i] = 1;
            }
            for (int j = 0; j < 4; ++j) {
                this.iMod[i][j] = 0;
            }
            if (this.iSelected[i] != 1 || (n = this.getModification(i)) <= -1) continue;
            this.iMod[i][n] = 1;
        }
        this.repaint();
    }

    private boolean isSelected(int n) {
        boolean bl = false;
        if (this.st != null && this.st.iTotal > 0) {
            for (int i = 0; i < this.st.iTotal; ++i) {
                if (!this.st.sID[i].equals(this.stSymbols.stItem[n].sID)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private int getModification(int n) {
        int n2 = -1;
        if (this.st != null && this.st.iTotal > 0) {
            for (int i = 0; i < this.st.iTotal; ++i) {
                if (!this.st.sID[i].equals(this.stSymbols.stItem[n].sID)) continue;
                n2 = 0;
                if (this.st.sMod[i].equals("Broken")) {
                    n2 = 3;
                }
                if (this.st.sMod[i].equals("Abundant")) {
                    n2 = 2;
                }
                if (!this.st.sMod[i].equals("Rare")) continue;
                n2 = 1;
            }
        }
        return n2;
    }

    private void toggleFossil(int n) {
        this.iSelected[n] = this.iSelected[n] == 0 ? 1 : 0;
    }

    private void modifyFossilList() {
        int n = 0;
        int n2 = 0;
        if (this.st == null) {
            this.st = new fossilStruct();
            this.st.sKEY = new String(cmnString.UniqueName());
        }
        for (n = 0; n < this.stSymbols.iCount; ++n) {
            if (this.iSelected[n] != 1) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.st.iTotal = n2;
            this.st.sID = new String[n2];
            this.st.sMod = new String[n2];
            this.st.sText = new String[n2];
            n2 = 0;
            for (n = 0; n < this.stSymbols.iCount; ++n) {
                if (this.iSelected[n] != 1 || n2 >= this.st.iTotal) continue;
                this.st.sID[n2] = new String(this.stSymbols.stItem[n].sID);
                this.st.sMod[n2] = new String("");
                block8: for (int i = 0; i < 4; ++i) {
                    if (this.iMod[n][i] != 1) continue;
                    switch (i) {
                        case 0: {
                            this.st.sMod[n2] = new String("");
                            continue block8;
                        }
                        case 1: {
                            this.st.sMod[n2] = new String("Rare");
                            continue block8;
                        }
                        case 2: {
                            this.st.sMod[n2] = new String("Abundant");
                            continue block8;
                        }
                        case 3: {
                            this.st.sMod[n2] = new String("Broken");
                        }
                    }
                }
                this.st.sText[n2] = new String(this.stSymbols.stItem[n].sName);
                ++n2;
            }
        } else {
            this.st.iTotal = 0;
            this.st.sID = null;
            this.st.sMod = null;
            this.st.sText = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int[] nArray = new int[]{0, 0, 0, 0};
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (n2 < 10 + i * 15 || n2 >= 10 + (i + 1) * 15) continue;
            this.toggleFossil(i);
            for (int j = 0; j < 4; ++j) {
                this.iMod[i][j] = 0;
            }
            if (!this.isSelected(i)) {
                if (n >= 10 && n < 34) {
                    this.iMod[i][0] = 1;
                }
                if (n >= 34 && n < 46) {
                    this.iMod[i][1] = 1;
                } else if (n >= 46 && n < 58) {
                    this.iMod[i][2] = 1;
                } else if (n >= 58 && n < 90) {
                    this.iMod[i][3] = 1;
                }
            }
            this.modifyFossilList();
            this.repaint();
            this.notifier.notifyObservers(new String("Fossils Changed"));
        }
    }

    public void draw(Graphics graphics) {
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (this.notifier != null) {
                if (this.isSelected(i)) {
                    graphics.setColor(Color.red);
                    graphics.drawLine(10, 10 + i * 15, 20, 10 + i * 15 + 10);
                    graphics.drawLine(20, 10 + i * 15, 10, 10 + i * 15 + 10);
                }
                for (int j = 0; j < 4; ++j) {
                    if (this.iMod[i][j] == 0) {
                        graphics.setColor(Color.lightGray);
                        graphics.drawRect(10 + (j + 1) * 12, 10 + i * 15, 10, 10);
                        continue;
                    }
                    graphics.setColor(Color.red);
                    graphics.drawString(MOD[j], 10 + (j + 1) * 12, 10 + i * 15 + 8);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(10, 10 + i * 15, 10, 10);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(105, 10 + i * 15 + 6, 110, 10 + i * 15 + 6);
            graphics.drawString(this.stSymbols.stItem[i].sName, 115, 10 + i * 15 + 8);
            this.plot.drawSymbol(graphics, this.stSymbols.stItem[i].iRows, 0, this.stSymbols.stItem[i].symbol, 90, 10 + i * 15);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

