/*
 * Decompiled with CFR 0.152.
 */
package rock.fossil.gui;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mask.maskSymbolsListStruct;
import rock.fossil.fossilStruct;
import rock.fossil.gui.fossilPlotSymbolFrameFocusAdapter;
import rock.fossil.gui.fossilPlotSymbolPanel;

public class fossilPlotSymbolFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private fossilPlotSymbolPanel plot = null;
    private fossilStruct stFossil = null;
    private String sKEY = "0";
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private int iEnvironment = 0;
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private JButton btnAdd = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnCancel = new JButton();
    private JRadioButton rbGeneral = new JRadioButton();
    private JRadioButton rbFresh = new JRadioButton();
    private JRadioButton rbBrackish = new JRadioButton();
    private JRadioButton rbMarine = new JRadioButton();
    private JMenuItem mExit = null;
    private int iXStart = 0;
    private int iYStart = 0;
    private int iWidth = 0;
    private int iHeight = 0;

    public fossilPlotSymbolFrame(maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
            this.addWindowListener(new fossilPlotSymbolFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public fossilPlotSymbolFrame(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public fossilPlotSymbolFrame(Observable observable, int n, int n2, int n3, int n4, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.iXStart = n;
            this.iYStart = n2;
            this.iWidth = n3;
            this.iHeight = n4;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Starting Depth:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Ending Depth:");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Fossils");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setTitle("Fossils");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(100, 120));
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel4.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        this.txtStart.setText("0.0");
        this.txtStart.setEditable(false);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new fossilPlotSymbolFrameFocusAdapter(this));
        jPanel5.setBorder(titledBorder2);
        jPanel5.setLayout(new BorderLayout());
        this.txtEnd.setText("0.0");
        this.txtEnd.setEditable(false);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new fossilPlotSymbolFrameFocusAdapter(this));
        jPanel6.setBorder(titledBorder3);
        jPanel6.setLayout(new GridLayout(4, 1));
        this.rbGeneral.setFont(new Font("Dialog", 1, 11));
        this.rbGeneral.setSelected(true);
        this.rbGeneral.setText("General");
        this.rbGeneral.addActionListener(this);
        this.rbFresh.setFont(new Font("Dialog", 1, 11));
        this.rbFresh.setText("Fresh Water");
        this.rbFresh.addActionListener(this);
        this.rbBrackish.setFont(new Font("Dialog", 1, 11));
        this.rbBrackish.setText("Brackish Water");
        this.rbBrackish.addActionListener(this);
        this.rbMarine.setFont(new Font("Dialog", 1, 11));
        this.rbMarine.setText("Marine");
        this.rbMarine.addActionListener(this);
        jPanel7.setLayout(new GridLayout(2, 1));
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(this);
        jPanel8.setLayout(new GridLayout());
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.plot = new fossilPlotSymbolPanel(this, this.notifier, this.stSymbols);
        this.getContentPane().add((Component)jPanel, "West");
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel4, null);
        jPanel4.add((Component)this.txtStart, "Center");
        jPanel3.add((Component)jPanel5, null);
        jPanel5.add((Component)this.txtEnd, "Center");
        jPanel2.add((Component)jPanel6, "Center");
        jPanel6.add((Component)this.rbGeneral, null);
        jPanel6.add((Component)this.rbFresh, null);
        jPanel6.add((Component)this.rbBrackish, null);
        jPanel6.add((Component)this.rbMarine, null);
        buttonGroup.add(this.rbGeneral);
        buttonGroup.add(this.rbFresh);
        buttonGroup.add(this.rbBrackish);
        buttonGroup.add(this.rbMarine);
        jPanel2.add((Component)jPanel7, "South");
        jPanel7.add((Component)this.btnAdd, null);
        jPanel7.add((Component)jPanel8, null);
        jPanel8.add((Component)this.btnClear, null);
        this.getContentPane().add((Component)this.plot, "Center");
        this.setSize(new Dimension(470, 750));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getSize().width) / 2;
        if (this.iWidth > 0) {
            n = this.iXStart + this.iWidth;
        }
        this.setLocation(n, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public fossilStruct getData() {
        if (this.stFossil == null) {
            this.stFossil = new fossilStruct();
            this.sKEY = new String(cmnString.UniqueName());
        }
        if (this.plot != null) {
            this.stFossil = this.plot.getData();
        }
        if (this.dEnd == 0.0) {
            this.dEnd = this.dStart;
        }
        this.stFossil.sKEY = new String(this.sKEY);
        this.stFossil.depthStart = this.dStart;
        this.stFossil.depthEnd = this.dEnd;
        this.stFossil.sEnvironment = new String(this.stSymbols.stBackground.sColors[this.iEnvironment]);
        return this.stFossil;
    }

    public void setData(fossilStruct fossilStruct2) {
        this.stFossil = fossilStruct2;
        if (fossilStruct2 != null) {
            this.sKEY = new String(fossilStruct2.sKEY);
        }
        if (this.plot != null) {
            this.plot.setData(fossilStruct2);
        }
        this.dStart = fossilStruct2.depthStart;
        this.dEnd = fossilStruct2.depthEnd;
        this.txtStart.setText("" + this.dStart);
        this.txtEnd.setText("" + this.dEnd);
        for (int i = 0; i < this.stSymbols.stBackground.iColors; ++i) {
            if (!fossilStruct2.sEnvironment.equals(this.stSymbols.stBackground.sColors[i])) continue;
            this.iEnvironment = i;
        }
        this.setButtons();
        this.btnAdd.setText("Modify");
    }

    public void setDepthRange(double d, double d2) {
        this.dStart = d;
        this.txtStart.setText("" + this.dStart);
        this.dEnd = d2;
        this.txtEnd.setText("" + this.dEnd);
    }

    private void setButtons() {
        this.rbGeneral.setSelected(false);
        this.rbFresh.setSelected(false);
        this.rbBrackish.setSelected(false);
        this.rbMarine.setSelected(false);
        switch (this.iEnvironment) {
            case 0: {
                this.rbGeneral.setSelected(true);
                break;
            }
            case 1: {
                this.rbFresh.setSelected(true);
                break;
            }
            case 2: {
                this.rbBrackish.setSelected(true);
                break;
            }
            case 3: {
                this.rbMarine.setSelected(true);
            }
        }
    }

    public void clear() {
        fossilStruct fossilStruct2 = new fossilStruct();
        this.setData(fossilStruct2);
        this.setButtons();
    }

    public void add() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("ADD or MODIFY Fossil Data"));
        }
    }

    public void cancel() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Cancel Edit"));
        }
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        this.stFossil = null;
        this.sKEY = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.btnAdd = null;
        this.btnClear = null;
        this.btnCancel = null;
        this.rbGeneral = null;
        this.rbFresh = null;
        this.rbBrackish = null;
        this.rbMarine = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnClear) {
            this.clear();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.cancel();
        }
        if (actionEvent.getSource() == this.rbGeneral) {
            this.iEnvironment = 0;
        }
        if (actionEvent.getSource() == this.rbFresh) {
            this.iEnvironment = 1;
        }
        if (actionEvent.getSource() == this.rbBrackish) {
            this.iEnvironment = 2;
        }
        if (actionEvent.getSource() == this.rbMarine) {
            this.iEnvironment = 3;
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                }
            }
        }
    }

    public class fossilPlotSymbolFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (fossilPlotSymbolFrame.this.notifier != null) {
                fossilPlotSymbolFrame.this.notifier.notifyObservers(new String("Cancel Edit"));
            }
        }
    }
}

