/*
 * Decompiled with CFR 0.152.
 */
package pfeffer.plot;

import cmn.cmnString;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import las.lasFileDataStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsUtility;
import lith.lithology.plot.lithologyPlotSymbol;
import lith.texture.textureListStruct;
import lith.texture.textureUtility;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import pfeffer.pfefferStandardTools;

public class pfefferPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    public static final Color cRED = new Color(180, 0, 0);
    public static final Color cGREEN = new Color(0, 180, 0);
    public static final Color cBLUE = new Color(0, 0, 180);
    public static final Color cCYAN = new Color(0, 180, 180);
    public static final Color cMAGENTA = new Color(180, 0, 180);
    public static final Color cYELLOW = new Color(180, 180, 0);
    public static final Color cORANGE = new Color(204, 102, 0);
    public static final Color cBROWN = new Color(102, 102, 0);
    public static final Color[] COLORS = new Color[]{cRED, cGREEN, cBLUE, cBROWN, cMAGENTA, cORANGE, cYELLOW, cCYAN};
    public static final Color cFlow = new Color(255, 255, 220);
    public static final Color cBVW = new Color(0, 255, 255);
    public static final Color cCBW = new Color(65, 105, 225);
    public static final Color cBVH = new Color(0, 0, 0);
    public static final Color c2nd = new Color(255, 204, 0);
    private double dNull = 0.0;
    private String sZone = "";
    private pfefferDataStruct stData = null;
    private pfefferDataListStruct stList = null;
    private textureListStruct stTexture = null;
    private lithologySymbolsListStruct stLithology = null;
    private lithologyPlotSymbol plotLith = null;
    private double[][] dLIMITS = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public pfefferPlotTrack(int n, double d, double d2, int n2, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.iDataType = n;
        this.stLithology = lithologySymbolsListStruct2;
        this.plotLith = new lithologyPlotSymbol(lithologySymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.builidDataStructure();
        this.setBackground(Color.white);
    }

    public void close() {
        this.stLithology = null;
        this.stData = null;
        this.stList = null;
        this.dLIMITS = null;
        this.sZone = null;
        if (this.plotLith != null) {
            this.plotLith.close();
        }
        this.plotLith = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setZone(String string) {
        this.sZone = new String(string);
    }

    public void setData(pfefferDataStruct pfefferDataStruct2) {
        this.stData = pfefferDataStruct2;
    }

    public void setData(pfefferDataListStruct pfefferDataListStruct2) {
        this.stList = pfefferDataListStruct2;
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        if (lasFileDataStruct2 != null) {
            this.dNull = lasFileDataStruct2.dNull;
        }
        this.builidDataStructure();
        this.stTexture = textureUtility.computeLASPlotTexture(lasFileDataStruct2, this.stTexture, this.stLithology);
        this.stTexture = textureUtility.fillEmptySpaces(this.stTexture);
    }

    public void setPlotLimits(double[][] dArray) {
        this.dLIMITS = dArray;
    }

    private void builidDataStructure() {
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        this.stTexture = textureUtility.buildNew(0, this.depthStart, this.depthEnd);
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n3 / 4;
        int n9 = n2 + n3;
        int n10 = n - 44;
        int n11 = iqstratTracksStruct.PFEFFER_TRACK[n10][0];
        boolean bl2 = false;
        int n12 = 0;
        int n13 = 0;
        double d3 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n11][4]);
        double d4 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n11][5]);
        if (this.dLIMITS != null) {
            d3 = this.dLIMITS[n11][0];
            d4 = this.dLIMITS[n11][1];
        }
        if (pfefferStandardTools.CURVES[n11][3].equals("OHM-M")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n12 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n13 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n13 < 100 || n13 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n2, n13, n9, n13);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n12, n9, n12);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 <= n3; n4 += n8) {
                if (n4 == 0 || n4 == n3) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
            }
        } else {
            n8 = n3 / n7;
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 < n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                graphics.setColor(Color.lightGray);
                for (n5 = 1; n5 < 5; ++n5) {
                    d = (double)n5 * 2.0;
                    d2 = (double)n8 * Math.log(d) / Math.log(10.0);
                    n6 = n4 + n2 + (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n9, 25);
        graphics.drawLine(n2, 100, n9, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
    }

    public void drawTrackLabels(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = -1;
        boolean bl = true;
        int n6 = -1;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n2 + n3;
        int n9 = n - 44;
        for (n4 = 0; n4 < 5; ++n4) {
            n6 = n4;
            n5 = iqstratTracksStruct.PFEFFER_TRACK[n9][n4];
            if (n5 <= -1 || !bl) continue;
            string = new String(pfefferStandardTools.CURVES[n5][1]);
            n7 = string.length();
            string3 = new String(pfefferStandardTools.CURVES[n5][3]);
            if (string3.equals("PU")) {
                d2 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n5][4]);
                d = cmnString.stringToDouble(pfefferStandardTools.CURVES[n5][5]);
                if (this.dLIMITS != null) {
                    d2 = this.dLIMITS[n5][0];
                    d = this.dLIMITS[n5][1];
                }
            } else {
                d = cmnString.stringToDouble(pfefferStandardTools.CURVES[n5][4]);
                d2 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n5][5]);
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            Font font = new Font("Serif", 1, 10);
            graphics.setFont(font);
            if (n6 <= -1) continue;
            graphics.setColor(COLORS[n4]);
            graphics.drawString(string, n2 + n3 / 2 - n7 * 4, 25 + (n6 + 2) * 14);
            graphics.drawString("" + d, n2 + 1, 25 + (n6 + 2) * 14);
            string2 = new String("" + d2);
            n7 = string2.length();
            graphics.drawString("" + d2, n8 - n7 * 5, 25 + (n6 + 2) * 14);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n8, 25);
        string = new String(iqstratTracksStruct.PFEFFER_DESC[n9]);
        n7 = string.length();
        graphics.drawString(string, n2 + n3 / 2 - 9 * n7 / 4, 39);
    }

    public void drawTrackLabelM(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        Font font = new Font("Serif", 1, 10);
        graphics.setFont(font);
        graphics.setColor(COLORS[1]);
        if (this.stData != null && this.stList != null) {
            for (int i = 0; i < this.stList.iCount; ++i) {
                if (this.depthStart != this.stList.stItem[i].depthStart || this.depthEnd != this.stList.stItem[i].depthEnd || !this.stList.stItem[i].sZone.equals(this.sZone)) continue;
                d = this.stList.stItem[i].Mp;
                d2 = this.stList.stItem[i].M;
                string = new String("M = " + d + " * PHI + " + d2);
                n4 = string.length();
                graphics.drawString(string, n2 + 4, 95);
            }
        }
    }

    public void drawTrackCurves(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        double[] dArray = null;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n10 = n2 + n3;
        int n11 = n - 44;
        int n12 = iqstratTracksStruct.PFEFFER_TRACK[n11][0];
        if (pfefferStandardTools.CURVES[n12][3].equals("OHM-M")) {
            bl2 = true;
        }
        if (this.stData != null) {
            for (int i = 0; i < 5; ++i) {
                dArray = null;
                n12 = iqstratTracksStruct.PFEFFER_TRACK[n11][i];
                if (n12 <= -1) continue;
                n9 = i;
                n4 = this.stData.iRows - 1;
                dArray = this.stData.getData(n12);
                if (dArray == null) continue;
                for (int j = 0; j < n4 - 1; ++j) {
                    if (this.stData == null) continue;
                    d4 = this.stData.depth[j];
                    d5 = this.stData.depth[j + 1];
                    d6 = dArray[j];
                    d7 = dArray[j + 1];
                    if (this.stList != null) {
                        for (int k = 0; k < this.stList.iCount; ++k) {
                            if (!(d4 >= this.stList.stItem[k].depthStart) || !(d5 <= this.stList.stItem[k].depthEnd) || !this.stList.stItem[k].sZone.equals(this.sZone)) continue;
                            for (int i2 = 0; i2 < this.stList.stItem[k].iRows - 1; ++i2) {
                                if (d4 != this.stList.stItem[k].depth[i2]) continue;
                                d6 = this.stList.stItem[k].getData(n12, i2);
                                d7 = this.stList.stItem[k].getData(n12, i2 + 1);
                            }
                        }
                    }
                    d2 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n12][4]);
                    d3 = cmnString.stringToDouble(pfefferStandardTools.CURVES[n12][5]);
                    string = new String(pfefferStandardTools.CURVES[n12][3]);
                    if (this.dLIMITS != null) {
                        d2 = this.dLIMITS[n12][0];
                        d3 = this.dLIMITS[n12][1];
                    }
                    if (bl2) {
                        if (d6 <= 0.0) {
                            d6 = 1.0E-5;
                        }
                        if (d7 <= 0.0) {
                            d7 = 1.0E-5;
                        }
                        d6 = Math.log(d6) / Math.log(10.0);
                        d7 = Math.log(d7) / Math.log(10.0);
                        d2 = Math.log(d2) / Math.log(10.0);
                        d3 = Math.log(d3) / Math.log(10.0);
                    }
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n8 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n8 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n7 > 100 && n8 > 100 && n7 < this.iHeight && n8 < this.iHeight) {
                        bl = true;
                    }
                    if (string.equals("PU")) {
                        d = (double)n3 * (d3 - d6) / (d3 - d2);
                        n5 = n2 + (int)d;
                        d = (double)n3 * (d3 - d7) / (d3 - d2);
                        if (n5 < n2 && n6 < n2) {
                            while (n5 < n2) {
                                n5 += n3;
                            }
                            while (n6 < n2) {
                                n6 += n3;
                            }
                        } else if (n5 >= n2 && n6 < n2) {
                            graphics.setColor(COLORS[n9]);
                            for (n6 = n2 + (int)d; n6 < n2; n6 += n3) {
                            }
                            if (bl) {
                                graphics.drawLine(n10, n7, n6, n8);
                            }
                            n6 = n2;
                        } else if (n5 < n2 && n6 >= n2) {
                            graphics.setColor(COLORS[n9]);
                            while (n5 < n2) {
                                n5 += n3;
                            }
                            if (bl) {
                                graphics.drawLine(n5, n7, n10, n8);
                            }
                            n5 = n2;
                        }
                    } else {
                        d = (double)n3 * (d6 - d2) / (d3 - d2);
                        n5 = n2 + (int)d;
                        d = (double)n3 * (d7 - d2) / (d3 - d2);
                        if (n5 > n10 && n6 > n10) {
                            while (n5 > n10) {
                                n5 -= n3;
                            }
                            while (n6 > n10) {
                                n6 -= n3;
                            }
                        } else if (n5 <= n10 && n6 > n10) {
                            graphics.setColor(COLORS[n9]);
                            for (n6 = n2 + (int)d; n6 > n10; n6 -= n3) {
                            }
                            if (bl) {
                                graphics.drawLine(n2, n7, n6, n8);
                            }
                            n6 = n10;
                        } else if (n5 > n10 && n6 <= n10) {
                            graphics.setColor(COLORS[n9]);
                            while (n5 > n10) {
                                n5 -= n3;
                            }
                            if (bl) {
                                graphics.drawLine(n5, n7, n2, n8);
                            }
                            n5 = n10;
                        }
                    }
                    if (n5 < n2 || n6 < n2 || n5 > n10 || n6 > n10) continue;
                    graphics.setColor(COLORS[n9]);
                    if (!bl) continue;
                    graphics.drawLine(n5, n7, n6, n8);
                }
            }
        }
    }

    public void drawTexture(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int n14 = -1;
        String[][] stringArray = null;
        textureListStruct textureListStruct2 = this.stTexture;
        boolean bl2 = false;
        int n15 = 0;
        if (textureListStruct2 != null && textureListStruct2.iCount > 0 && textureListStruct2.stItem[0] != null) {
            d2 = textureListStruct2.stItem[0].depthEnd;
            d = textureListStruct2.stItem[0].depthStart;
            d3 = d2 - d;
            n5 = (int)(5.0 / d3 * ((double)iqstratTracksStruct.SCALE[this.iScale] / 100.0));
            if (n5 < 1) {
                n5 = 1;
            }
            n6 = -1;
            for (n3 = 0; n3 < textureListStruct2.iCount; ++n3) {
                int n16;
                if (textureListStruct2.stItem[n3] == null) continue;
                d = textureListStruct2.stItem[n3].depthStart;
                d2 = d + d3 * (double)n5;
                for (n16 = 1; n16 < n5; ++n16) {
                    if (n3 >= textureListStruct2.iCount - 1) continue;
                    ++n3;
                }
                n14 = textureListStruct2.stItem[n3].iSymbol;
                d4 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n8 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n8 = this.iHeight - (int)d4;
                }
                n9 = Math.abs(n8 - n7);
                if (!bl2) {
                    n15 = n9;
                    bl2 = true;
                }
                if (n9 > n15) {
                    n15 = n9;
                }
                if (n9 < n15) {
                    n9 = n15;
                    n8 = n7 + n15;
                }
                if (n7 < 100 || n8 <= 100 || n7 >= this.iHeight || n8 >= this.iHeight) continue;
                if (this.iDataType == 1) {
                    n7 = n8;
                }
                if ((n10 = n9 / 5) == 0) {
                    n10 = 1;
                }
                n12 = 5;
                n13 = 10;
                n11 = 10;
                if (n14 <= -1) continue;
                nArray = textureListStruct2.stItem[n3].iRGB;
                stringArray = lithologySymbolsUtility.getSymbol(n14, this.stLithology);
                for (n4 = 0; n4 < n10; ++n4) {
                    ++n6;
                    for (n16 = 0; n16 < n11; ++n16) {
                        this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n16 * n13, n7 + n4 * 5, n13, n12);
                        this.plotLith.drawLithologySymbolMask(graphics, n12, this.plotLith.getOrder(n6), stringArray, n + n16 * n13, n7 + n4 * 5);
                    }
                }
            }
        }
    }

    public void drawFluid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n6 = n + n2;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        Font font = new Font("Serif", 1, 10);
        String string = "";
        int n13 = 0;
        graphics.setFont(font);
        if (this.stData != null) {
            dArray = this.stData.getData(3);
            dArray2 = this.stData.getData(13);
            dArray3 = this.stData.getData(4);
            dArray4 = this.stData.getData(5);
            dArray5 = this.stData.getData(12);
            if (dArray2 != null && dArray3 != null && dArray4 != null) {
                n3 = this.stData.iRows - 1;
                d2 = 0.0;
                d3 = 0.5;
                if (this.dLIMITS != null) {
                    d2 = this.dLIMITS[4][0];
                    d3 = this.dLIMITS[4][1];
                }
                for (int i = 0; i < n3 - 1; ++i) {
                    if (!(dArray[i] > this.dNull) || !(dArray3[i] > this.dNull)) continue;
                    d4 = this.stData.depth[i];
                    d5 = this.stData.depth[i + 1];
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n4 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n4 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n5 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n5 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n4 > 100 && n5 > 100 && n4 < this.iHeight && n5 < this.iHeight) {
                        bl = true;
                        nArray2[0] = n4;
                        nArray2[1] = n4;
                        nArray2[2] = n5;
                        nArray2[3] = n5;
                    }
                    if (!bl) continue;
                    d10 = dArray3[i];
                    d11 = dArray4[i];
                    d12 = dArray5[i];
                    d9 = dArray2[i];
                    d15 = dArray3[i + 1];
                    d16 = dArray4[i + 1];
                    d17 = dArray5[i + 1];
                    d14 = dArray2[i + 1];
                    if (this.stList != null) {
                        for (int j = 0; j < this.stList.iCount; ++j) {
                            if (!(d4 >= this.stList.stItem[j].depthStart) || !(d5 <= this.stList.stItem[j].depthEnd) || !this.stList.stItem[j].sZone.equals(this.sZone)) continue;
                            for (int k = 0; k < this.stList.stItem[j].iRows - 1; ++k) {
                                if (d4 != this.stList.stItem[j].depth[k]) continue;
                                d10 = this.stList.stItem[j].getData(4, k);
                                d11 = this.stList.stItem[j].getData(5, k);
                                d12 = this.stList.stItem[j].getData(12, k);
                                d9 = this.stList.stItem[j].getData(13, k);
                                d15 = this.stList.stItem[j].getData(4, k + 1);
                                d16 = this.stList.stItem[j].getData(5, k + 1);
                                d17 = this.stList.stItem[j].getData(12, k + 1);
                                d14 = this.stList.stItem[j].getData(13, k + 1);
                            }
                        }
                    }
                    if (d11 > 1.0) {
                        d11 = 1.0;
                    }
                    if (d12 > 1.0) {
                        d12 = 1.0;
                        d9 = d10;
                    }
                    if (d16 > 1.0) {
                        d16 = 1.0;
                    }
                    if (d17 > 1.0) {
                        d17 = 1.0;
                        d14 = d15;
                    }
                    if (d12 + d11 > 1.0) {
                        if (d12 <= d11) {
                            d11 -= d12;
                            d16 -= d17;
                        } else {
                            d11 = 1.0 - d12;
                            d16 = 1.0 - d17;
                        }
                    }
                    d18 = d10 * d11;
                    d19 = d15 * d16;
                    d20 = d10 - d9 - d18;
                    d21 = d15 - d14 - d19;
                    if (d20 > 0.0 && d21 > 0.0) {
                        d6 = d20 + d18 + d9;
                        d7 = d21 + d19 + d14;
                        d = (double)n2 * (d3 - d6) / (d3 - d2);
                        n11 = n + (int)d;
                        d = (double)n2 * (d3 - d7) / (d3 - d2);
                        n12 = n + (int)d;
                        if (n11 >= n && n12 >= n && n11 <= n6 && n12 <= n6) {
                            nArray[0] = n11;
                            nArray[1] = n6;
                            nArray[2] = n6;
                            nArray[3] = n12;
                            graphics.setColor(cBVH);
                            graphics.fillPolygon(nArray, nArray2, 4);
                        }
                    }
                    d6 = d18 + d9;
                    d7 = d19 + d14;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n9 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n10 = n + (int)d;
                    if (n9 < n) {
                        n9 = n;
                    }
                    if (n10 < n) {
                        n10 = n;
                    }
                    if (n9 >= n && n10 >= n && n9 <= n6 && n10 <= n6) {
                        nArray[0] = n9;
                        nArray[1] = n6;
                        nArray[2] = n6;
                        nArray[3] = n10;
                        graphics.setColor(cCBW);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    d6 = d9;
                    d7 = d14;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n7 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n8 = n + (int)d;
                    if (n7 < n || n8 < n || n7 > n6 || n8 > n6) continue;
                    nArray[0] = n7;
                    nArray[1] = n6;
                    nArray[2] = n6;
                    nArray[3] = n8;
                    graphics.setColor(cBVW);
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setColor(cBVH);
        graphics.fillRect(n, 70, n2, 30);
        graphics.setColor(Color.white);
        string = new String("BVH");
        n13 = string.length();
        graphics.drawString(string, n + n2 / 2 - n13 * 4, 79);
        graphics.setColor(cCBW);
        graphics.fillRect(n, 80, n2, 20);
        graphics.setColor(Color.lightGray);
        string = new String("CBW");
        n13 = string.length();
        graphics.drawString(string, n + n2 / 2 - n13 * 4, 89);
        graphics.setColor(cBVW);
        graphics.fillRect(n, 90, n2, 10);
        graphics.setColor(Color.black);
        string = new String("BVW");
        n13 = string.length();
        graphics.drawString(string, n + n2 / 2 - n13 * 4, 99);
    }

    public void draw2ndPhi(Graphics graphics, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.5;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n6 = n + n2;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        Font font = new Font("Serif", 1, 10);
        String string = "";
        int n11 = 0;
        graphics.setFont(font);
        if (this.dLIMITS != null) {
            d2 = this.dLIMITS[4][0];
            d3 = this.dLIMITS[4][1];
        }
        if (this.stData != null) {
            dArray = this.stData.getData(4);
            dArray2 = this.stData.getData(6);
            dArray3 = this.stData.getData(7);
            if (dArray != null && dArray2 != null && dArray3 != null) {
                n3 = this.stData.iRows - 1;
                for (int i = 0; i < n3 - 1; ++i) {
                    if (!(dArray2[i] > this.dNull) || !(dArray[i] > this.dNull) || !(dArray3[i] > this.dNull)) continue;
                    d4 = this.stData.depth[i];
                    d5 = this.stData.depth[i + 1];
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n4 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n4 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n5 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n5 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n4 > 100 && n5 > 100 && n4 < this.iHeight && n5 < this.iHeight) {
                        bl = true;
                    }
                    if (!bl) continue;
                    d8 = dArray[i];
                    d9 = dArray2[i];
                    d11 = dArray[i + 1];
                    d12 = dArray2[i + 1];
                    if (this.stList != null) {
                        for (int j = 0; j < this.stList.iCount; ++j) {
                            if (!(d4 >= this.stList.stItem[j].depthStart) || !(d5 <= this.stList.stItem[j].depthEnd) || !this.stList.stItem[j].sZone.equals(this.sZone)) continue;
                            for (int k = 0; k < this.stList.stItem[j].iRows - 1; ++k) {
                                if (d4 != this.stList.stItem[j].depth[k]) continue;
                                d8 = this.stList.stItem[j].getData(4, k);
                                d9 = this.stList.stItem[j].getData(6, k);
                                d11 = this.stList.stItem[j].getData(4, k + 1);
                                d12 = this.stList.stItem[j].getData(6, k + 1);
                            }
                        }
                    }
                    d6 = d9;
                    d7 = d12;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n7 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n8 = n + (int)d;
                    d6 = d8;
                    d7 = d11;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n9 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n10 = n + (int)d;
                    if (n9 < n) {
                        n9 = n;
                    }
                    if (n10 < n) {
                        n10 = n;
                    }
                    if (n7 < n) {
                        n7 = n;
                    }
                    if (n8 < n) {
                        n8 = n;
                    }
                    if (n9 > n6) {
                        n9 = n6;
                    }
                    if (n10 > n6) {
                        n10 = n6;
                    }
                    if (n7 > n6) {
                        n7 = n6;
                    }
                    if (n8 > n6) {
                        n8 = n6;
                    }
                    if (n9 >= n7) continue;
                    nArray[0] = n9;
                    nArray2[0] = n4;
                    nArray[1] = n7;
                    nArray2[1] = n4;
                    nArray[2] = n8;
                    nArray2[2] = n5;
                    nArray[3] = n10;
                    nArray2[3] = n5;
                    graphics.setColor(c2nd);
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setColor(c2nd);
        graphics.fillRect(n, 90, n2, 10);
        graphics.setColor(Color.black);
        string = new String("2nd Porosity");
        n11 = string.length();
        graphics.drawString(string, n + n2 / 2 - n11 * 2, 99);
    }

    public void drawPHIr(Graphics graphics, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.5;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n6 = n + n2;
        double[] dArray = null;
        double[] dArray2 = null;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        Font font = new Font("Serif", 1, 10);
        String string = "";
        int n11 = 0;
        graphics.setFont(font);
        if (this.dLIMITS != null) {
            d2 = this.dLIMITS[4][0];
            d3 = this.dLIMITS[4][1];
        }
        if (this.stData != null) {
            dArray = this.stData.getData(4);
            dArray2 = this.stData.getData(15);
            if (dArray != null && dArray2 != null) {
                n3 = this.stData.iRows - 1;
                for (int i = 0; i < n3 - 1; ++i) {
                    if (!(dArray2[i] > this.dNull) || !(dArray[i] > this.dNull)) continue;
                    d4 = this.stData.depth[i];
                    d5 = this.stData.depth[i + 1];
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n4 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n4 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n5 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n5 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n4 > 100 && n5 > 100 && n4 < this.iHeight && n5 < this.iHeight) {
                        bl = true;
                    }
                    if (!bl) continue;
                    d8 = dArray[i];
                    d9 = dArray2[i];
                    d10 = dArray[i + 1];
                    d11 = dArray2[i + 1];
                    if (this.stList != null) {
                        for (int j = 0; j < this.stList.iCount; ++j) {
                            if (!(d4 >= this.stList.stItem[j].depthStart) || !(d5 <= this.stList.stItem[j].depthEnd) || !this.stList.stItem[j].sZone.equals(this.sZone)) continue;
                            for (int k = 0; k < this.stList.stItem[j].iRows - 1; ++k) {
                                if (d4 != this.stList.stItem[j].depth[k]) continue;
                                d8 = this.stList.stItem[j].getData(4, k);
                                d9 = this.stList.stItem[j].getData(15, k);
                                d10 = this.stList.stItem[j].getData(4, k + 1);
                                d11 = this.stList.stItem[j].getData(15, k + 1);
                            }
                        }
                    }
                    d6 = d9;
                    d7 = d11;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n7 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n8 = n + (int)d;
                    d6 = d8;
                    d7 = d10;
                    d = (double)n2 * (d3 - d6) / (d3 - d2);
                    n9 = n + (int)d;
                    d = (double)n2 * (d3 - d7) / (d3 - d2);
                    n10 = n + (int)d;
                    if (n9 < n) {
                        n9 = n;
                    }
                    if (n10 < n) {
                        n10 = n;
                    }
                    if (n7 < n) {
                        n7 = n;
                    }
                    if (n8 < n) {
                        n8 = n;
                    }
                    if (n9 > n6) {
                        n9 = n6;
                    }
                    if (n10 > n6) {
                        n10 = n6;
                    }
                    if (n7 > n6) {
                        n7 = n6;
                    }
                    if (n8 > n6) {
                        n8 = n6;
                    }
                    if (n7 >= n9) continue;
                    nArray[0] = n7;
                    nArray2[0] = n4;
                    nArray[1] = n9;
                    nArray2[1] = n4;
                    nArray[2] = n10;
                    nArray2[2] = n5;
                    nArray[3] = n8;
                    nArray2[3] = n5;
                    graphics.setColor(c2nd);
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setColor(c2nd);
        graphics.fillRect(n, 90, n2, 10);
        graphics.setColor(Color.black);
        string = new String("OHM Porosity");
        n11 = string.length();
        graphics.drawString(string, n + n2 / 2 - n11 * 2, 99);
    }

    public void drawFlowUnits(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = n + n2;
        String string = "";
        boolean bl = false;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stList != null) {
            for (int i = 0; i < this.stList.iCount; ++i) {
                if (this.stList.stItem[i] == null) continue;
                d2 = this.stList.stItem[i].depthStart;
                d3 = this.stList.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (d2 - this.depthStart) / (this.depthEnd - this.depthStart);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (d3 - this.depthStart) / (this.depthEnd - this.depthStart);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                if (n3 < 100 || n4 < 100 || n3 > this.iHeight || n4 > this.iHeight) continue;
                graphics.drawLine(n, n3, n5, n3);
                if (this.stList.stItem[i].sZone == null) continue;
                graphics.drawString("  " + this.stList.stItem[i].sZone, n, n3 + 10);
            }
        }
    }

    public void drawBackground(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = n + n2;
        if (this.stList != null) {
            for (int i = 0; i < this.stList.iCount; ++i) {
                d2 = this.stList.stItem[i].depthStart;
                d3 = this.stList.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (d2 - this.depthStart) / (this.depthEnd - this.depthStart);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (d3 - this.depthStart) / (this.depthEnd - this.depthStart);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                if (n3 < 100 || n4 < 100 || n3 > this.iHeight || n4 > this.iHeight) continue;
                graphics.setColor(cFlow);
                graphics.fillRect(n, n3, n2, n4 - n3);
            }
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = n2 / 4;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        String string = "Flow Units";
        int n10 = 0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n10 = string.length();
        graphics.drawString(string, n + n2 / 2 - 9 * n10 / 4, 39);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
            for (n3 = 0; n3 <= n2; n3 += n6) {
                if (n3 == 0 || n3 == n2) {
                    graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n7, 25);
        graphics.drawLine(n, 100, n7, 100);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 3;
        switch (n) {
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
                graphics.fillRect(n2, 25, n3, 20);
                this.drawBackground(graphics, n2, n3);
            }
        }
        switch (n) {
            case 45: {
                this.drawTexture(graphics, n2, n3);
                this.drawFluid(graphics, n2, n3);
                break;
            }
            case 46: {
                this.draw2ndPhi(graphics, n2, n3);
                break;
            }
            case 47: {
                this.drawPHIr(graphics, n2, n3);
                break;
            }
            case 44: 
            case 48: 
            case 49: {
                break;
            }
        }
        switch (n) {
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.drawGrid(graphics, n, n2, n3);
                this.drawTrackLabels(graphics, n, n2, n3);
                this.drawTrackCurves(graphics, n, n2, n3);
                break;
            }
            case 50: {
                this.drawGrid(graphics, n2, n3);
                this.drawFlowUnits(graphics, n2, n3);
            }
        }
        switch (n) {
            case 49: {
                this.drawTrackLabelM(graphics, n, n2, n3);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

