/*
 * Decompiled with CFR 0.152.
 */
package parse.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import parse.parseMineralsListStruct;
import parse.parseMineralsStruct;
import parse.parseMineralsUtility;

public class ReadParseMineralsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "minerals";
    public static final String RECORDS = "records";
    public static final String DATA = "data";
    public static final String MINERAL = "mineral";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String GROUP = "group";
    public static final String MIN_CLASS = "class";
    public static final String FORMULA = "formula";
    public static final String OCCURANCE = "occ";
    public static final String MOL_WT = "mol_wt";
    public static final String RHOB = "rhob";
    public static final String RHOE = "rhoe";
    public static final String RHOL = "rhol";
    public static final String GR = "gr";
    public static final String PE_C = "pe_calc";
    public static final String PE_M = "pe";
    public static final String U = "u";
    public static final String SIGMA_C = "sigma_calc";
    public static final String SIGMA_M = "sigma_meas";
    public static final String LS = "ls";
    public static final String LD = "ld";
    public static final String CNL_C = "cnl_calc";
    public static final String CNL_M = "cnl_meas";
    public static final String CNL_T_C = "cnl_therm_calc";
    public static final String CNL_T_M = "cnl_therm_meas";
    public static final String BMOD = "bmod";
    public static final String SMOD = "smod";
    public static final String DT_COMP = "dt_comp";
    public static final String DT_SHEAR = "dt_shear";
    public static final String PR = "pr";
    public static final String EPT = "ept";
    private static final int _NONE = 0;
    private static final int _DATA = 1;
    private static final int _MINERAL = 2;
    private int iData = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iRow = 0;
    private parseMineralsListStruct stList = new parseMineralsListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadParseMineralsXMLFile() {
        this.iType = 0;
    }

    public ReadParseMineralsXMLFile(int n) {
        this.iType = n;
    }

    public parseMineralsListStruct Process(String string) {
        this.Read(string);
        this.stList = parseMineralsUtility.computeRhomaaUmaa(this.stList);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadParseMineralsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadParseMineralsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        boolean bl = false;
        boolean bl2 = false;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(MINERAL)) {
            this.iData = 2;
            ++this.iCount;
            this.stList.stItem[this.iCount] = new parseMineralsStruct();
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                    this.stList.stItem = new parseMineralsStruct[this.iRows];
                }
                if (this.iCount <= -1) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private parseMineralsStruct ParseData(String string, String string2, parseMineralsStruct parseMineralsStruct2) {
        String string3 = "";
        if (string.equals(ID) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.id = cmnString.stringToInt(string2);
        }
        if (string.equals(NAME)) {
            parseMineralsStruct2.sName = new String(string2);
        }
        if (string.equals(GROUP)) {
            parseMineralsStruct2.sGroup = new String(string2);
        }
        if (string.equals(MIN_CLASS)) {
            parseMineralsStruct2.sClass = new String(string2);
        }
        if (string.equals(FORMULA)) {
            parseMineralsStruct2.sFormula = new String(string2);
        }
        if (string.equals(OCCURANCE)) {
            parseMineralsStruct2.sOccurrence = new String(string2);
        }
        if (string.equals(MOL_WT) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dMolWt = cmnString.stringToDouble(string2);
        }
        if (string.equals(RHOB) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dRHOB = cmnString.stringToDouble(string2);
        }
        if (string.equals(RHOE) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dRHOE = cmnString.stringToDouble(string2);
        }
        if (string.equals(RHOL) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dRHOL = cmnString.stringToDouble(string2);
        }
        if (string.equals(GR) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dGR = cmnString.stringToDouble(string2);
        }
        if (string.equals(PE_C) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dPECalc = cmnString.stringToDouble(string2);
        }
        if (string.equals(PE_M) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dPE = cmnString.stringToDouble(string2);
        }
        if (string.equals(U) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dU = cmnString.stringToDouble(string2);
        }
        if (string.equals(SIGMA_C) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dSigmaCalc = cmnString.stringToDouble(string2);
        }
        if (string.equals(SIGMA_M) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dSigma = cmnString.stringToDouble(string2);
        }
        if (string.equals(LS) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dLs = cmnString.stringToDouble(string2);
        }
        if (string.equals(LD) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dLd = cmnString.stringToDouble(string2);
        }
        if (string.equals(CNL_C) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dCNLCalc = cmnString.stringToDouble(string2);
        }
        if (string.equals(CNL_M) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dCNL = cmnString.stringToDouble(string2);
        }
        if (string.equals(CNL_T_C) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dCNL_TCalc = cmnString.stringToDouble(string2);
        }
        if (string.equals(CNL_T_M) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dCNL_T = cmnString.stringToDouble(string2);
        }
        if (string.equals(BMOD) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dBulk = cmnString.stringToDouble(string2);
        }
        if (string.equals(SMOD) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dShear = cmnString.stringToDouble(string2);
        }
        if (string.equals(DT_COMP) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dt_comp = cmnString.stringToDouble(string2);
        }
        if (string.equals(DT_SHEAR) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dt_shear = cmnString.stringToDouble(string2);
        }
        if (string.equals(PR) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dPoisson = cmnString.stringToDouble(string2);
        }
        if (string.equals(EPT) && cmnString.isNumeric(string2)) {
            parseMineralsStruct2.dEPT = cmnString.stringToDouble(string2);
        }
        return parseMineralsStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

