/*
 * Decompiled with CFR 0.152.
 */
package parse.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import parse.parseColorListStruct;
import parse.parseColorStruct;

public class ReadParseColorXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "sed_struct";
    public static final String RECORDS = "records";
    public static final String MODIFIERS = "modifiers";
    public static final String MODIFIER = "modifier";
    public static final String ID = "id";
    public static final String WORD = "word";
    public static final String MODIFY = "modify";
    public static final String PHRASE = "phrase";
    public static final String TYPE = "type";
    public static final String ABBREVIATION = "abbreviation";
    public static final String WORDS = "words";
    public static final String ABBREV = "abbrev";
    public static final String DATA = "data";
    public static final String HUE = "hue";
    public static final String NBS_ISCC = "nbs_iscc";
    public static final String COLOR = "color";
    public static final String RED = "r";
    public static final String GREEN = "g";
    public static final String BLUE = "b";
    public static final String MUNSELL = "munsell";
    public static final String HEX = "hex";
    public static final String ROCK_COLOR = "rc";
    public static final String SOIL_COLOR = "sc";
    public static final String DESCRIPTORS = "descriptors";
    public static final String DESCRIPTOR = "descriptor";
    public static final String KEYWORDS = "keywords";
    private static final int _NONE = 0;
    private static final int _MODIFIERS = 3;
    private static final int _MODIFIER = 4;
    private static final int _ABBREV = 5;
    private static final int _WORDS = 6;
    private static final int _DATA = 7;
    private static final int _HUE = 8;
    private static final int _DESCRIPTORS = 9;
    private static final int _DESCRIPTOR = 10;
    private static final int _KEYWORDS = 11;
    private static final int _WORD = 12;
    private static final int _NBS_ISCC = 13;
    private static final int _COLOR = 14;
    private int iData = 0;
    private int iLevel = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iRow = 0;
    private parseColorListStruct stList = new parseColorListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadParseColorXMLFile() {
        this.iType = 0;
    }

    public ReadParseColorXMLFile(int n) {
        this.iType = n;
    }

    public parseColorListStruct Process(String string) {
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadParseColorXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadParseColorXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        boolean bl = false;
        boolean bl2 = false;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(MODIFIERS)) {
            this.iData = 3;
            this.iRow = -1;
        }
        if (string4.equals(MODIFIER)) {
            this.iData = 4;
            ++this.iRow;
        }
        if (string4.equals(ABBREVIATION)) {
            this.iData = 5;
            this.iRow = -1;
        }
        if (string4.equals(WORDS)) {
            this.iData = 6;
            ++this.iRow;
        }
        if (string4.equals(DATA)) {
            this.iData = 7;
            this.iCount = -1;
        }
        if (string4.equals(HUE)) {
            this.iData = 8;
            ++this.iCount;
            this.stList.stItem[this.iCount] = new parseColorStruct();
        }
        if (string4.equals(DESCRIPTORS)) {
            this.iData = 9;
            this.iRow = -1;
        }
        if (string4.equals(DESCRIPTOR)) {
            this.iData = 10;
            ++this.iRow;
            this.stList.stItem[this.iCount].descriptors[this.iRow] = new parseColorStruct();
        }
        if (string4.equals(KEYWORDS)) {
            this.iData = 11;
            this.iRow = -1;
        }
        if (string4.equals(WORD)) {
            this.iData = 12;
            ++this.iRow;
        }
        if (string4.equals(NBS_ISCC)) {
            this.iData = 13;
            this.iCount = -1;
            this.iRow = -1;
        }
        if (string4.equals(COLOR)) {
            this.iData = 14;
            ++this.iCount;
            this.stList.stColors[this.iCount] = new parseColorStruct();
        }
        if (attributes != null) {
            block29: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 3: {
                            this.stList.iModifiers = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sModifier = new String[this.iRows][3];
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            this.stList.iAbbrev = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sAbbrev = new String[this.iRows][2];
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new parseColorStruct[this.iRows];
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            if (this.iCount <= -1 || this.stList.stItem[this.iCount] == null) break;
                            this.stList.stItem[this.iCount].iCount = this.iRows;
                            this.stList.stItem[this.iCount].descriptors = new parseColorStruct[this.iRows];
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 11: {
                            this.stList.iKeywords = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sKeywords = new String[this.iRows][2];
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 13: {
                            this.stList.iColors = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stColors = new parseColorStruct[this.iRows];
                            break;
                        }
                    }
                }
                switch (this.iData) {
                    case 0: {
                        continue block29;
                    }
                    case 3: {
                        continue block29;
                    }
                    case 4: {
                        this.parseModifier(string5, string7.trim());
                        continue block29;
                    }
                    case 5: {
                        continue block29;
                    }
                    case 6: {
                        this.parseAbbreviation(string5, string7.trim());
                        continue block29;
                    }
                    case 7: {
                        continue block29;
                    }
                    case 8: {
                        this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
                        continue block29;
                    }
                    case 9: {
                        continue block29;
                    }
                    case 10: {
                        this.stList.stItem[this.iCount].descriptors[this.iRow] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount].descriptors[this.iRow]);
                        continue block29;
                    }
                    case 11: {
                        continue block29;
                    }
                    case 12: {
                        this.parseKeywords(string5, string7.trim());
                        continue block29;
                    }
                    case 13: {
                        continue block29;
                    }
                    case 14: {
                        this.stList.stColors[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stColors[this.iCount]);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private void parseModifier(String string, String string2) {
        if (string.equals(ID)) {
            // empty if block
        }
        if (string.equals(WORD) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][0] = new String(string2);
        }
        if (string.equals(MODIFY) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][1] = new String(string2);
        }
        if (string.equals(PHRASE) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][2] = new String(string2);
        }
    }

    private void parseAbbreviation(String string, String string2) {
        if (string.equals(ABBREV) && this.iRow > -1) {
            this.stList.sAbbrev[this.iRow][0] = new String(string2);
        }
        if (string.equals(WORD) && this.iRow > -1) {
            this.stList.sAbbrev[this.iRow][1] = new String(string2);
        }
    }

    private void parseKeywords(String string, String string2) {
        if (string.equals(PHRASE) && this.iRow > -1) {
            this.stList.sKeywords[this.iRow][0] = new String(string2);
        }
        if (string.equals(TYPE) && this.iRow > -1) {
            this.stList.sKeywords[this.iRow][1] = new String(string2);
        }
    }

    private parseColorStruct ParseData(String string, String string2, parseColorStruct parseColorStruct2) {
        String string3 = "";
        if (string.equals(ID)) {
            parseColorStruct2.sID = new String(string2);
        }
        if (string.equals(PHRASE)) {
            parseColorStruct2.sPhrase = new String(string2);
        }
        if (string.equals(RED) && cmnString.isNumeric(string2)) {
            parseColorStruct2.iRGB[0] = cmnString.stringToInt(string2);
        }
        if (string.equals(GREEN) && cmnString.isNumeric(string2)) {
            parseColorStruct2.iRGB[1] = cmnString.stringToInt(string2);
        }
        if (string.equals(BLUE) && cmnString.isNumeric(string2)) {
            parseColorStruct2.iRGB[2] = cmnString.stringToInt(string2);
        }
        if (string.equals(MUNSELL)) {
            parseColorStruct2.sMunsell = new String(string2);
        }
        if (string.equals(HEX)) {
            parseColorStruct2.sHex = new String(string2);
        }
        if (string.equals(ROCK_COLOR) && string2.equals("yes")) {
            parseColorStruct2.iRockColor = 1;
        }
        if (string.equals(SOIL_COLOR) && string2.equals("yes")) {
            parseColorStruct2.iSoilColor = 1;
        }
        return parseColorStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

