/*
 * Decompiled with CFR 0.152.
 */
package parse.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import parse.parseGrainsTextureListStruct;
import parse.parseGrainsTextureStruct;

public class ReadGrainsTexturesXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "grains ";
    public static final String RECORDS = "records";
    public static final String MODIFIERS = "modifiers";
    public static final String MODIFIER = "modifier";
    public static final String ID = "id";
    public static final String WORD = "word";
    public static final String MODIFY = "modify";
    public static final String PHRASE = "phrase";
    public static final String ABBREV_MAIN = "abbrev_main";
    public static final String WORDS = "words";
    public static final String ABBREV = "abbrev";
    public static final String ABBREV_DESC = "abbrev_desc";
    public static final String ROCKS = "rocks";
    public static final String COLUMN = "column";
    public static final String NAME = "name";
    public static final String ABREV = "abrv";
    public static final String CYCLE = "cycle";
    public static final String WEATHER = "wthr";
    public static final String THESAURUS = "thesaurus";
    public static final String KEYWORDS = "keywords";
    public static final String TYPE = "type";
    private static final int _NONE = 0;
    private static final int _MODIFIERS = 1;
    private static final int _MODIFIER = 2;
    private static final int _ABBREV_MAIN = 3;
    private static final int _WORDS_MAIN = 4;
    private static final int _ABBREV_DESC = 5;
    private static final int _WORDS_DESC = 6;
    private static final int _ROCKS = 7;
    private static final int _COLUMN = 8;
    private static final int _KEYWORDS = 9;
    private static final int _KEYWORD = 10;
    private int iRows = 0;
    private int iCount = -1;
    private int iRow = 0;
    private int iData = 0;
    private int iCNTR = 0;
    private parseGrainsTextureListStruct stList = new parseGrainsTextureListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadGrainsTexturesXMLFile() {
        this.iType = 0;
    }

    public ReadGrainsTexturesXMLFile(int n) {
        this.iType = n;
    }

    public parseGrainsTextureListStruct Process(String string) {
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadGrainsTexturesXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadGrainsTexturesXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(ROOTNAME)) {
            this.iRow = -1;
            this.iData = 0;
        }
        if (string4.equals(MODIFIERS)) {
            this.iData = 1;
            this.iRow = -1;
        }
        if (string4.equals(MODIFIER)) {
            this.iData = 2;
            ++this.iRow;
        }
        if (string4.equals(ABBREV_MAIN)) {
            this.iData = 3;
            this.iCNTR = 3;
            this.iRow = -1;
        }
        if (string4.equals(ABBREV_DESC)) {
            this.iData = 5;
            this.iCNTR = 5;
            this.iRow = -1;
        }
        if (string4.equals(WORDS)) {
            this.iData = this.iCNTR == 3 ? 4 : 6;
            ++this.iRow;
        }
        if (string4.equals(ROCKS)) {
            this.iData = 7;
            this.iRow = -1;
        }
        if (string4.equals(COLUMN)) {
            this.iData = 8;
            ++this.iRow;
            this.stList.stItem[this.iRow] = new parseGrainsTextureStruct();
        }
        if (string4.equals(KEYWORDS)) {
            this.iData = 9;
            this.iCount = -1;
        }
        if (string4.equals(WORD)) {
            this.iData = 10;
            ++this.iCount;
        }
        if (attributes != null) {
            block25: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.stList.iModifiers = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sModifier = new String[this.iRows][3];
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            this.stList.iAbbrev_main = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sAbbrev_main = new String[this.iRows][2];
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            this.stList.iAbbrev_desc = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sAbbrev_desc = new String[this.iRows][2];
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new parseGrainsTextureStruct[this.iRows];
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.stList.iKeywords = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sKeywords = new String[this.iRows][2];
                            break;
                        }
                    }
                }
                switch (this.iData) {
                    case 0: {
                        continue block25;
                    }
                    case 1: {
                        continue block25;
                    }
                    case 2: {
                        this.parseModifier(string5, string7.trim());
                        continue block25;
                    }
                    case 3: {
                        continue block25;
                    }
                    case 4: {
                        this.parseAbbreviation(string5, string7.trim());
                        continue block25;
                    }
                    case 5: {
                        continue block25;
                    }
                    case 6: {
                        this.parseAbbrev_desc(string5, string7.trim());
                        continue block25;
                    }
                    case 7: {
                        continue block25;
                    }
                    case 8: {
                        this.stList.stItem[this.iRow] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iRow]);
                        continue block25;
                    }
                    case 9: {
                        continue block25;
                    }
                    case 10: {
                        this.parseKeywords(string5, string7.trim());
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private parseGrainsTextureStruct ParseData(String string, String string2, parseGrainsTextureStruct parseGrainsTextureStruct2) {
        String string3 = "";
        int n = -1;
        if (string.equals(ID)) {
            parseGrainsTextureStruct2.sID = new String(string2);
        }
        if (string.equals(ABREV)) {
            parseGrainsTextureStruct2.sAbrev = new String(string2);
        }
        if (string.equals(NAME)) {
            parseGrainsTextureStruct2.sName = new String(string2);
        }
        if (string.equals(CYCLE)) {
            parseGrainsTextureStruct2.sCycle = new String(string2);
        }
        if (string.equals(WEATHER) && cmnString.isNumeric(string2)) {
            parseGrainsTextureStruct2.iWeather = cmnString.stringToInt(string2);
        }
        return parseGrainsTextureStruct2;
    }

    private void parseModifier(String string, String string2) {
        if (string.equals(ID)) {
            // empty if block
        }
        if (string.equals(WORD) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][0] = new String(string2);
        }
        if (string.equals(MODIFY) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][1] = new String(string2);
        }
        if (string.equals(PHRASE) && this.iRow > -1) {
            this.stList.sModifier[this.iRow][2] = new String(string2);
        }
    }

    private void parseAbbreviation(String string, String string2) {
        if (string.equals(ABBREV) && this.iRow > -1) {
            this.stList.sAbbrev_main[this.iRow][0] = new String(string2);
        }
        if (string.equals(WORD) && this.iRow > -1) {
            this.stList.sAbbrev_main[this.iRow][1] = new String(string2);
        }
    }

    private void parseAbbrev_desc(String string, String string2) {
        if (string.equals(ABBREV) && this.iRow > -1) {
            this.stList.sAbbrev_desc[this.iRow][0] = new String(string2);
        }
        if (string.equals(WORD) && this.iRow > -1) {
            this.stList.sAbbrev_desc[this.iRow][1] = new String(string2);
        }
    }

    private void parseKeywords(String string, String string2) {
        if (string.equals(PHRASE) && this.iCount > -1) {
            this.stList.sKeywords[this.iCount][0] = new String(string2);
        }
        if (string.equals(TYPE) && this.iCount > -1) {
            this.stList.sKeywords[this.iCount][1] = new String(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

