/*
 * Decompiled with CFR 0.152.
 */
package lith.texture;

import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratTracksStruct;
import las.lasFileDataStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.math.lithMath;
import lith.math.lithMathRules;
import lith.texture.textureConstants;
import lith.texture.textureListStruct;
import lith.texture.textureStruct;

public class textureUtility {
    public static final double GAMMA_MAX = 150.0;
    public static final double GAMMA_MIN = 0.0;
    public static final double CLEAN = 60.0;

    public static textureListStruct buildNew(int n, double d, double d2) {
        textureListStruct textureListStruct2 = null;
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        n3 = 1 + (int)(iqstratTracksStruct._SCALE_FACTOR[n] * Math.abs(d2 - d));
        d5 = iqstratTracksStruct._SCALE[n];
        textureListStruct2 = new textureListStruct();
        textureListStruct2.iCount = n3;
        textureListStruct2.iUnit = n;
        textureListStruct2.depthStart = d;
        textureListStruct2.depthEnd = d2;
        textureListStruct2.stItem = new textureStruct[n3];
        for (int i = 0; i < n3; ++i) {
            if (n2 >= n3) continue;
            d3 = d + (double)i * d5;
            d4 = d + (double)(i + 1) * d5;
            textureListStruct2.stItem[n2] = new textureStruct();
            textureListStruct2.stItem[n2].depthStart = textureUtility.getDepth(n, d3);
            textureListStruct2.stItem[n2].depthEnd = textureUtility.getDepth(n, d4);
            ++n2;
        }
        textureListStruct2.iCount = n2;
        return textureListStruct2;
    }

    public static textureListStruct computeDepthRange(textureListStruct textureListStruct2) {
        double d = 0.0;
        double d2 = 0.0;
        if (textureListStruct2 != null) {
            for (int i = 0; i < textureListStruct2.iCount; ++i) {
                d = textureListStruct2.stItem[i].depthStart;
                d2 = textureListStruct2.stItem[i].depthEnd;
                if (i == 0) {
                    textureListStruct2.depthStart = d;
                    textureListStruct2.depthEnd = d2;
                }
                if (textureListStruct2.depthStart > d) {
                    textureListStruct2.depthStart = d;
                }
                if (!(textureListStruct2.depthEnd < d2)) continue;
                textureListStruct2.depthEnd = d2;
            }
            textureListStruct2.depthStart = Math.floor(textureListStruct2.depthStart);
            textureListStruct2.depthEnd = Math.ceil(textureListStruct2.depthEnd);
        }
        return textureListStruct2;
    }

    public static int getUnit(double d) {
        int n = 1;
        if (d <= 0.5) {
            n = 0;
        }
        if (d <= 0.16667) {
            n = 8;
        }
        if (d <= 0.08333) {
            n = 7;
        }
        if (d <= 0.04167) {
            n = 6;
        }
        if (d <= 0.25) {
            n = 9;
        }
        if (d <= 0.1) {
            n = 10;
        }
        return n;
    }

    public static int getUnit(int n, double d) {
        int n2;
        int n3 = n2 = (int)d;
        double d2 = 0.0;
        double d3 = Math.abs(d - (double)n2);
        if (d3 == 0.0) {
            d3 = 0.5;
        }
        if (d3 <= 0.5) {
            n = 0;
        }
        if (d3 <= 0.16667) {
            n = 8;
        }
        if (d3 <= 0.1) {
            n = 10;
        }
        return n;
    }

    public static double getDepth(int n, double d) {
        int n2;
        int n3 = n2 = (int)d;
        double d2 = 0.0;
        double d3 = Math.abs(d - (double)n2);
        int n4 = 1;
        if (d < 0.0) {
            n3 = (int)Math.abs(d);
            if (n3 == 0) {
                n3 = 1;
            }
            n4 = n2 / n3;
        }
        switch (n) {
            case 6: {
                if (d3 <= 0.020835) {
                    d2 = 0.0;
                }
                if (d3 > 0.020835 && d3 <= 0.0625) {
                    d2 = 0.04167;
                }
                if (d3 > 0.0625 && d3 <= 0.104165) {
                    d2 = 0.08333;
                }
                if (d3 > 0.104165 && d3 <= 0.145835) {
                    d2 = 0.125;
                }
                if (d3 > 0.145835 && d3 <= 0.1875) {
                    d2 = 0.16667;
                }
                if (d3 > 0.1875 && d3 <= 0.229165) {
                    d2 = 0.20833;
                }
                if (d3 > 0.229165 && d3 <= 0.270835) {
                    d2 = 0.25;
                }
                if (d3 > 0.270835 && d3 <= 0.3125) {
                    d2 = 0.29167;
                }
                if (d3 > 0.3125 && d3 <= 0.354165) {
                    d2 = 0.33333;
                }
                if (d3 > 0.354165 && d3 <= 0.395835) {
                    d2 = 0.375;
                }
                if (d3 > 0.395835 && d3 <= 0.4375) {
                    d2 = 0.41667;
                }
                if (d3 > 0.4375 && d3 <= 0.479165) {
                    d2 = 0.45833;
                }
                if (d3 > 0.479165 && d3 <= 0.520835) {
                    d2 = 0.5;
                }
                if (d3 > 0.520835 && d3 <= 0.5625) {
                    d2 = 0.54167;
                }
                if (d3 > 0.5625 && d3 <= 0.604165) {
                    d2 = 0.58333;
                }
                if (d3 > 0.604165 && d3 <= 0.645835) {
                    d2 = 0.625;
                }
                if (d3 > 0.645835 && d3 <= 0.6875) {
                    d2 = 0.66667;
                }
                if (d3 > 0.6875 && d3 <= 0.729165) {
                    d2 = 0.70833;
                }
                if (d3 > 0.729165 && d3 <= 0.790835) {
                    d2 = 0.75;
                }
                if (d3 > 0.790835 && d3 <= 0.8125) {
                    d2 = 0.79167;
                }
                if (d3 > 0.8125 && d3 <= 0.854165) {
                    d2 = 0.83333;
                }
                if (d3 > 0.854165 && d3 <= 0.915835) {
                    d2 = 0.875;
                }
                if (d3 > 0.915835 && d3 <= 0.9375) {
                    d2 = 0.91667;
                }
                if (d3 > 0.9375 && d3 <= 0.979165) {
                    d2 = 0.95833;
                }
                if (!(d3 > 0.979165)) break;
                d2 = 1.0;
                break;
            }
            case 7: {
                if (d3 <= 0.04167) {
                    d2 = 0.0;
                }
                if (d3 > 0.04167 && d3 <= 0.125) {
                    d2 = 0.08333;
                }
                if (d3 > 0.125 && d3 <= 0.20833) {
                    d2 = 0.16667;
                }
                if (d3 > 0.20833 && d3 <= 0.29167) {
                    d2 = 0.25;
                }
                if (d3 > 0.29167 && d3 <= 0.375) {
                    d2 = 0.33333;
                }
                if (d3 > 0.375 && d3 <= 0.45833) {
                    d2 = 0.41667;
                }
                if (d3 > 0.45833 && d3 <= 0.54167) {
                    d2 = 0.5;
                }
                if (d3 > 0.54167 && d3 <= 0.625) {
                    d2 = 0.58333;
                }
                if (d3 > 0.625 && d3 <= 0.70833) {
                    d2 = 0.66667;
                }
                if (d3 > 0.70833 && d3 <= 0.79167) {
                    d2 = 0.75;
                }
                if (d3 > 0.79167 && d3 <= 0.875) {
                    d2 = 0.83333;
                }
                if (d3 > 0.875 && d3 <= 0.95833) {
                    d2 = 0.91667;
                }
                if (!(d3 > 0.95833)) break;
                d2 = 1.0;
                break;
            }
            case 8: {
                if (d3 <= 0.08333) {
                    d2 = 0.0;
                }
                if (d3 > 0.08333 && d3 <= 0.25) {
                    d2 = 0.16667;
                }
                if (d3 > 0.25 && d3 <= 0.41667) {
                    d2 = 0.33333;
                }
                if (d3 > 0.41667 && d3 <= 0.58333) {
                    d2 = 0.5;
                }
                if (d3 > 0.58333 && d3 <= 0.75) {
                    d2 = 0.66667;
                }
                if (d3 > 0.75 && d3 <= 0.91667) {
                    d2 = 0.83333;
                }
                if (!(d3 > 0.91667)) break;
                d2 = 1.0;
                break;
            }
            case 10: {
                if (d3 <= 0.05) {
                    d2 = 0.0;
                }
                if (d3 > 0.05 && d3 <= 0.105) {
                    d2 = 0.1;
                }
                if (d3 > 0.105 && d3 <= 0.205) {
                    d2 = 0.2;
                }
                if (d3 > 0.205 && d3 <= 0.305) {
                    d2 = 0.3;
                }
                if (d3 > 0.305 && d3 <= 0.405) {
                    d2 = 0.4;
                }
                if (d3 > 0.405 && d3 <= 0.505) {
                    d2 = 0.5;
                }
                if (d3 > 0.505 && d3 <= 0.605) {
                    d2 = 0.6;
                }
                if (d3 > 0.605 && d3 <= 0.705) {
                    d2 = 0.7;
                }
                if (d3 > 0.705 && d3 <= 0.805) {
                    d2 = 0.8;
                }
                if (d3 > 0.805 && d3 <= 0.905) {
                    d2 = 0.9;
                }
                if (!(d3 > 0.905)) break;
                d2 = 1.0;
                break;
            }
            case 9: {
                if (d3 <= 0.125) {
                    d2 = 0.0;
                }
                if (d3 > 0.125 && d3 <= 0.375) {
                    d2 = 0.25;
                }
                if (d3 > 0.375 && d3 <= 0.625) {
                    d2 = 0.5;
                }
                if (d3 > 0.625 && d3 <= 0.875) {
                    d2 = 0.75;
                }
                if (!(d3 > 0.75)) break;
                d2 = 1.0;
                break;
            }
            case 0: {
                if (d3 <= 0.25) {
                    d2 = 0.0;
                }
                if (d3 > 0.25 && d3 <= 0.75) {
                    d2 = 0.5;
                }
                if (!(d3 > 0.75)) break;
                d2 = 1.0;
                break;
            }
            case 1: {
                if (d3 <= 0.5) {
                    d2 = 0.0;
                }
                if (!(d3 > 0.5)) break;
                d2 = 1.0;
            }
        }
        d = (double)n4 * ((double)n3 + d2);
        return d;
    }

    public static textureListStruct fillEmptySpaces(textureListStruct textureListStruct2) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (textureListStruct2 != null) {
            for (n = 0; n < textureListStruct2.iCount - 2; ++n) {
                bl2 = false;
                if (textureListStruct2.stItem[n].iTexture != -1) {
                    bl2 = true;
                }
                bl3 = false;
                bl4 = false;
                if (!bl2) continue;
                if (textureListStruct2.stItem[n + 1].iTexture != -1) {
                    bl3 = true;
                }
                if (textureListStruct2.stItem[n + 2].iTexture != -1) {
                    bl4 = true;
                }
                if (bl3 || !bl4) continue;
                textureListStruct2.stItem[n + 1] = textureUtility.copy(textureListStruct2.stItem[n]);
            }
        }
        return textureListStruct2;
    }

    public static textureListStruct addHeaderData(iqstratHeadersStruct iqstratHeadersStruct2, textureListStruct textureListStruct2) {
        if (iqstratHeadersStruct2 != null && textureListStruct2 != null) {
            textureListStruct2.sKID = new String(iqstratHeadersStruct2.sKID);
            textureListStruct2.sKEY = new String(iqstratHeadersStruct2.sKEY);
            textureListStruct2.iType = iqstratHeadersStruct2.iType;
            textureListStruct2.sAPI = new String(iqstratHeadersStruct2.sAPI);
            textureListStruct2.sName = new String(iqstratHeadersStruct2.sName);
            textureListStruct2.status = new String(iqstratHeadersStruct2.status);
            textureListStruct2.dLatitude = iqstratHeadersStruct2.dLatitude;
            textureListStruct2.dLongitude = iqstratHeadersStruct2.dLongitude;
            textureListStruct2.depth = iqstratHeadersStruct2.depth;
            textureListStruct2.dGL = iqstratHeadersStruct2.dGL;
        }
        return textureListStruct2;
    }

    public static textureListStruct addRecord(textureStruct textureStruct2, textureListStruct textureListStruct2) {
        double d = 0.0;
        double d2 = 0.0;
        if (textureStruct2 != null && textureListStruct2 != null) {
            d = textureStruct2.depthStart;
            d2 = textureStruct2.depthEnd;
            for (int i = 0; i < textureListStruct2.iCount; ++i) {
                if (d >= textureListStruct2.stItem[i].depthStart && d < textureListStruct2.stItem[i].depthEnd) {
                    textureStruct2.depthStart = textureListStruct2.stItem[i].depthStart;
                    textureStruct2.depthEnd = textureListStruct2.stItem[i].depthEnd;
                    textureListStruct2.stItem[i] = textureUtility.copy(textureStruct2);
                    continue;
                }
                if (d2 > textureListStruct2.stItem[i].depthStart && d2 <= textureListStruct2.stItem[i].depthEnd) {
                    textureStruct2.depthStart = textureListStruct2.stItem[i].depthStart;
                    textureStruct2.depthEnd = textureListStruct2.stItem[i].depthEnd;
                    textureListStruct2.stItem[i] = textureUtility.copy(textureStruct2);
                    continue;
                }
                if (!(textureListStruct2.stItem[i].depthStart >= d) || !(textureListStruct2.stItem[i].depthEnd <= d2)) continue;
                textureStruct2.depthStart = textureListStruct2.stItem[i].depthStart;
                textureStruct2.depthEnd = textureListStruct2.stItem[i].depthEnd;
                textureListStruct2.stItem[i] = textureUtility.copy(textureStruct2);
            }
        }
        return textureListStruct2;
    }

    public static textureListStruct add(textureStruct textureStruct2, textureListStruct textureListStruct2) {
        int n = 0;
        int n2 = 0;
        textureListStruct textureListStruct3 = new textureListStruct();
        String string = "YES";
        String string2 = "";
        String string3 = "";
        textureListStruct3.stItem = new textureStruct[1];
        if (textureListStruct2 != null) {
            string = new String(textureListStruct2.sKGS);
            string2 = new String(textureListStruct2.source);
            string3 = new String(textureListStruct2.sCreated);
            textureListStruct3.depthStart = textureListStruct2.depthStart;
            textureListStruct3.depthEnd = textureListStruct2.depthEnd;
            textureListStruct3.iUnit = textureListStruct2.iUnit;
            if (textureListStruct2.iCount > 0) {
                textureListStruct3.stItem = new textureStruct[textureListStruct2.iCount + 1];
            }
            for (n = 0; n < textureListStruct2.iCount; ++n) {
                textureListStruct3.stItem[n2] = new textureStruct();
                textureListStruct3.stItem[n2] = textureUtility.copy(textureListStruct2.stItem[n]);
                ++n2;
            }
            textureListStruct2.delete();
            textureListStruct2 = null;
        }
        if (textureStruct2 != null) {
            textureListStruct3.stItem[n2] = new textureStruct();
            textureListStruct3.stItem[n2] = textureUtility.copy(textureStruct2);
            ++n2;
        }
        textureListStruct2 = new textureListStruct();
        textureListStruct2.iCount = n2;
        textureListStruct2.stItem = new textureStruct[textureListStruct2.iCount];
        textureListStruct2.depthStart = textureListStruct3.depthStart;
        textureListStruct2.depthEnd = textureListStruct3.depthEnd;
        textureListStruct2.iUnit = textureListStruct3.iUnit;
        textureListStruct2.sKGS = new String(string);
        textureListStruct2.source = new String(string2);
        textureListStruct2.sCreated = new String(string3);
        for (n = 0; n < textureListStruct2.iCount; ++n) {
            textureListStruct2.stItem[n] = new textureStruct();
            textureListStruct2.stItem[n] = textureUtility.copy(textureListStruct3.stItem[n]);
        }
        textureListStruct3.delete();
        textureListStruct3 = null;
        return textureListStruct2;
    }

    public static textureListStruct modify(textureStruct textureStruct2, textureListStruct textureListStruct2) {
        int n = 0;
        int n2 = 0;
        textureListStruct textureListStruct3 = new textureListStruct();
        String string = "YES";
        String string2 = "";
        String string3 = "";
        textureListStruct3.stItem = new textureStruct[1];
        if (textureListStruct2 != null) {
            string = new String(textureListStruct2.sKGS);
            string2 = new String(textureListStruct2.source);
            string3 = new String(textureListStruct2.sCreated);
            textureListStruct3.depthStart = textureListStruct2.depthStart;
            textureListStruct3.depthEnd = textureListStruct2.depthEnd;
            textureListStruct3.iUnit = textureListStruct2.iUnit;
            if (textureListStruct2.iCount > 0) {
                textureListStruct3.stItem = new textureStruct[textureListStruct2.iCount];
            }
            for (n = 0; n < textureListStruct2.iCount; ++n) {
                if (textureListStruct2.stItem[n].sKEY.equals(textureStruct2.sKEY)) {
                    textureListStruct3.stItem[n2] = new textureStruct();
                    textureListStruct3.stItem[n2] = textureUtility.copy(textureStruct2);
                    ++n2;
                    continue;
                }
                textureListStruct3.stItem[n2] = new textureStruct();
                textureListStruct3.stItem[n2] = textureUtility.copy(textureListStruct2.stItem[n]);
                ++n2;
            }
            textureListStruct2.delete();
            textureListStruct2 = null;
            textureListStruct2 = new textureListStruct();
            textureListStruct2.iCount = n2;
            textureListStruct2.stItem = new textureStruct[textureListStruct2.iCount];
            textureListStruct2.depthStart = textureListStruct3.depthStart;
            textureListStruct2.depthEnd = textureListStruct3.depthEnd;
            textureListStruct2.iUnit = textureListStruct3.iUnit;
            textureListStruct2.sKGS = new String(string);
            textureListStruct2.source = new String(string2);
            textureListStruct2.sCreated = new String(string3);
            for (n = 0; n < textureListStruct2.iCount; ++n) {
                textureListStruct2.stItem[n] = new textureStruct();
                textureListStruct2.stItem[n] = textureUtility.copy(textureListStruct3.stItem[n]);
            }
            textureListStruct3.delete();
            textureListStruct3 = null;
        }
        return textureListStruct2;
    }

    public static textureListStruct remove(String string, textureListStruct textureListStruct2) {
        int n = 0;
        int n2 = 0;
        textureListStruct textureListStruct3 = null;
        String string2 = "YES";
        String string3 = "";
        String string4 = "";
        if (textureListStruct2 != null) {
            string2 = new String(textureListStruct2.sKGS);
            string3 = new String(textureListStruct2.source);
            string4 = new String(textureListStruct2.sCreated);
            if (textureListStruct2.iCount < 2) {
                textureListStruct2.iCount = 0;
                textureListStruct2.delete();
                textureListStruct2 = null;
            } else {
                textureListStruct3 = new textureListStruct();
                textureListStruct3.stItem = new textureStruct[textureListStruct2.iCount - 1];
                textureListStruct3.depthStart = textureListStruct2.depthStart;
                textureListStruct3.depthEnd = textureListStruct2.depthEnd;
                textureListStruct3.iUnit = textureListStruct2.iUnit;
                for (n = 0; n < textureListStruct2.iCount; ++n) {
                    if (textureListStruct2.stItem[n] == null || textureListStruct2.stItem[n].sKEY.equals(string)) continue;
                    textureListStruct3.stItem[n2] = new textureStruct();
                    textureListStruct3.stItem[n2] = textureUtility.copy(textureListStruct2.stItem[n]);
                    ++n2;
                }
                textureListStruct2.delete();
                textureListStruct2 = null;
                textureListStruct2 = new textureListStruct();
                textureListStruct2.iCount = n2;
                textureListStruct2.stItem = new textureStruct[textureListStruct2.iCount];
                textureListStruct2.depthStart = textureListStruct3.depthStart;
                textureListStruct2.depthEnd = textureListStruct3.depthEnd;
                textureListStruct2.iUnit = textureListStruct3.iUnit;
                textureListStruct2.sKGS = new String(string2);
                textureListStruct2.source = new String(string3);
                textureListStruct2.sCreated = new String(string4);
                for (n = 0; n < textureListStruct2.iCount; ++n) {
                    textureListStruct2.stItem[n] = new textureStruct();
                    textureListStruct2.stItem[n] = textureUtility.copy(textureListStruct3.stItem[n]);
                }
                if (textureListStruct3 != null) {
                    textureListStruct3.delete();
                }
                textureListStruct3 = null;
            }
        }
        return textureListStruct2;
    }

    public static textureListStruct copyList(textureListStruct textureListStruct2) {
        textureListStruct textureListStruct3 = null;
        if (textureListStruct2 != null) {
            textureListStruct3 = new textureListStruct();
            textureListStruct3.depthStart = textureListStruct2.depthStart;
            textureListStruct3.depthEnd = textureListStruct2.depthEnd;
            textureListStruct3.iUnit = textureListStruct2.iUnit;
            textureListStruct3.sKGS = new String(textureListStruct2.sKGS);
            textureListStruct3.source = new String(textureListStruct2.source);
            textureListStruct3.sCreated = new String(textureListStruct2.sCreated);
            textureListStruct3.iCount = textureListStruct2.iCount;
            textureListStruct3.stItem = new textureStruct[textureListStruct2.iCount];
            for (int i = 0; i < textureListStruct2.iCount; ++i) {
                textureListStruct3.stItem[i] = textureUtility.copy(textureListStruct2.stItem[i]);
            }
        }
        return textureListStruct3;
    }

    public static textureStruct copy(textureStruct textureStruct2) {
        int n = 0;
        int n2 = 0;
        textureStruct textureStruct3 = new textureStruct();
        if (textureStruct2 != null) {
            textureStruct3.sKEY = new String(textureStruct2.sKEY);
            textureStruct3.depthStart = textureStruct2.depthStart;
            textureStruct3.depthEnd = textureStruct2.depthEnd;
            textureStruct3.iType = textureStruct2.iType;
            textureStruct3.sType = new String(textureStruct2.sType);
            textureStruct3.iEnergy = textureStruct2.iEnergy;
            textureStruct3.iRGB[0] = textureStruct2.iRGB[0];
            textureStruct3.iRGB[1] = textureStruct2.iRGB[1];
            textureStruct3.iRGB[2] = textureStruct2.iRGB[2];
            textureStruct3.id = textureStruct2.id;
            textureStruct3.iSymbol = textureStruct2.iSymbol;
            textureStruct3.iTexture = textureStruct2.iTexture;
            textureStruct3.sTexture = new String(textureStruct2.sTexture);
            textureStruct3.iComposition = textureStruct2.iComposition;
            textureStruct3.sComposition = new String(textureStruct2.sComposition);
            textureStruct3.dClay = textureStruct2.dClay;
            textureStruct3.dQuartz = textureStruct2.dQuartz;
            textureStruct3.dFeldspar = textureStruct2.dFeldspar;
            textureStruct3.dRock = textureStruct2.dRock;
            textureStruct3.dVolcanic = textureStruct2.dVolcanic;
            textureStruct3.dMetamorphic = textureStruct2.dMetamorphic;
            textureStruct3.dSedimentary = textureStruct2.dSedimentary;
            textureStruct3.dChert = textureStruct2.dChert;
            textureStruct3.dCarbonate = textureStruct2.dCarbonate;
            textureStruct3.dSilicate = textureStruct2.dSilicate;
            textureStruct3.sOther = new String(textureStruct2.sOther);
            textureStruct3.iAlloType = textureStruct2.iAlloType;
            textureStruct3.sAlloType = new String(textureStruct2.sAlloType);
            textureStruct3.iMatrix = textureStruct2.iMatrix;
            textureStruct3.sMatrix = new String(textureStruct2.sMatrix);
            textureStruct3.sPrefix = new String(textureStruct2.sPrefix);
            textureStruct3.dIntraclasts = textureStruct2.dIntraclasts;
            textureStruct3.dOoids = textureStruct2.dOoids;
            textureStruct3.dBioclasts = textureStruct2.dBioclasts;
            textureStruct3.dPeloids = textureStruct2.dPeloids;
            textureStruct3.iData = textureStruct2.iData;
            textureStruct3.iRows = textureStruct2.iRows;
            textureStruct3.iDesCols = textureStruct2.iDesCols;
            textureStruct3.sDesc = new String[textureStruct3.iRows][textureStruct3.iDesCols];
            textureStruct3.iColumns = textureStruct3.iColumns;
            textureStruct3.data = new double[textureStruct3.iRows][textureStruct3.iColumns];
            for (n = 0; n < textureStruct3.iRows; ++n) {
                for (n2 = 0; n2 < textureStruct3.iDesCols; ++n2) {
                    textureStruct3.sDesc[n][n2] = new String(textureStruct2.sDesc[n][n2]);
                }
                for (n2 = 0; n2 < textureStruct3.iColumns; ++n2) {
                    textureStruct3.data[n][n2] = textureStruct2.data[n][n2];
                }
            }
            textureStruct3.iClass = textureStruct2.iClass;
            textureStruct3.dSize = textureStruct2.dSize;
            textureStruct3.dPhi = textureStruct2.dPhi;
            textureStruct3.sClass = new String(textureStruct2.sClass);
            textureStruct3.iSorted = textureStruct2.iSorted;
            textureStruct3.dSorted = textureStruct2.dSorted;
            textureStruct3.sorted = new String(textureStruct2.sorted);
            textureStruct3.iSkewed = textureStruct2.iSkewed;
            textureStruct3.dSkewed = textureStruct2.dSkewed;
            textureStruct3.skewed = new String(textureStruct2.skewed);
            for (n = 0; n < 10; ++n) {
                textureStruct3.iLithology[n] = textureStruct2.iLithology[n];
            }
        }
        return textureStruct3;
    }

    public static textureListStruct computeLASPlotTexture(lasFileDataStruct lasFileDataStruct2, textureListStruct textureListStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double d3 = 0.0;
        double d4 = 60.0;
        double d5 = 70.0;
        double d6 = 100.0;
        boolean bl = false;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        double[] dArray2 = null;
        double[][] dArray3 = null;
        if (lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.depthStep == 2.0) {
                textureListStruct2 = textureUtility.buildNew(2, lasFileDataStruct2.depthStart, lasFileDataStruct2.depthEnd);
            } else if (lasFileDataStruct2.depthStep == 1.0) {
                textureListStruct2 = textureUtility.buildNew(1, lasFileDataStruct2.depthStart, lasFileDataStruct2.depthEnd);
            }
            for (n = 0; n < lasFileDataStruct2.iRows - 1; ++n) {
                double d7;
                d = lasFileDataStruct2.depths[n];
                d2 = lasFileDataStruct2.depths[n + 1];
                if (textureListStruct2 != null) {
                    for (n2 = 0; n2 < textureListStruct2.iCount; ++n2) {
                        if (textureListStruct2.stItem[n2].depthStart == d) {
                            n7 = n2;
                            continue;
                        }
                        if (!(textureListStruct2.stItem[n2].depthStart > d) || !(textureListStruct2.stItem[n2].depthStart < d2)) continue;
                        n7 = n2;
                    }
                }
                if (!((d7 = lasFileDataStruct2.dGR[n]) > lasFileDataStruct2.dNull)) continue;
                if (d7 > 150.0) {
                    d7 = 150.0;
                }
                if (d7 < 0.0) {
                    d7 = 0.0;
                }
                d4 = 60.0;
                d5 = 70.0;
                d6 = 100.0;
                if (lasFileDataStruct2.stList != null) {
                    for (n4 = 0; n4 < lasFileDataStruct2.stList.iCount; ++n4) {
                        if (!(d >= lasFileDataStruct2.stList.stItem[n4].depthStart) || !(d <= lasFileDataStruct2.stList.stItem[n4].depthEnd)) continue;
                        d4 = lasFileDataStruct2.stList.stItem[n4].dShaly;
                        d5 = lasFileDataStruct2.stList.stItem[n4].dShale;
                        d6 = lasFileDataStruct2.stList.stItem[n4].dHotShale;
                    }
                }
                if ((n6 = lithMathRules.getLithology(0, d4, d5, d6, d7, lasFileDataStruct2.dNPHI[n], lasFileDataStruct2.dRHOB[n], lasFileDataStruct2.dPE[n], lasFileDataStruct2.dDT[n], lasFileDataStruct2.dNull)) == 22 || n6 == 19 || n6 == 7 || n6 == 18 || n6 == 32 || n6 == 31 || n6 == 21 || n6 == 24 || n6 == 15 || n6 == 12) {
                    if (n6 == 32) {
                        nArray = lithMath._ANHY;
                        nArray2 = lithMath._ANHY_LITH;
                    } else if (n6 == 31) {
                        nArray = lithMath._GYP;
                        nArray2 = lithMath._GYP_LITH;
                    } else {
                        nArray = lithMath._RU;
                        nArray2 = lithMath._RU_LITH;
                    }
                    if (lasFileDataStruct2.iPE != -1) {
                        nArray3 = lithMath._RU_COL;
                        dArray2 = lithMath.getRU(1, 0, lasFileDataStruct2.dRHOB[n], lasFileDataStruct2.dPE[n], lasFileDataStruct2.dNPHI[n]);
                    } else {
                        nArray3 = lithMath._PD_COL;
                        dArray2 = lithMath.getPD(1, 0, lasFileDataStruct2.dRHOB[n], lasFileDataStruct2.dNPHI[n]);
                    }
                    for (n4 = 0; n4 < 3; ++n4) {
                        dArray[0] = 0.0;
                    }
                    dArray3 = lithMath.getMatrix(nArray, nArray3);
                    dArray = lithMath.composition(dArray2, dArray3);
                    d3 = 0.0;
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (dArray[n4] < 0.0) {
                            dArray[n4] = 0.0;
                        }
                        d3 += dArray[n4];
                    }
                    int n9 = (int)(10.0 * dArray[0] / d3);
                    int n10 = (int)(10.0 * dArray[1] / d3);
                    int n11 = (int)(10.0 * dArray[2] / d3);
                    if (d7 >= d5) {
                        if (n6 == 12 || n6 == 15) {
                            textureListStruct2.stItem[n7].iEnergy = 2;
                            textureListStruct2.stItem[n7].iRGB = textureConstants.SIO2_COLOR[1];
                            textureListStruct2.stItem[n7].id = textureConstants.SIO2_TEXTURE[1][0];
                            textureListStruct2.stItem[n7].iType = 0;
                            textureListStruct2.stItem[n7].iTexture = 0;
                        }
                        if (n6 == 18) {
                            textureListStruct2.stItem[n7].iEnergy = 6;
                            textureListStruct2.stItem[n7].iRGB = textureConstants.SIO2_COLOR[7];
                            textureListStruct2.stItem[n7].id = 18;
                            textureListStruct2.stItem[n7].iType = 0;
                            textureListStruct2.stItem[n7].iTexture = 4;
                        }
                    } else if (d7 < d5 && (n6 != 34 || n6 != 44)) {
                        textureListStruct2.stItem[n7].iType = n6 == 32 || n6 == 31 ? 2 : 0;
                        if (n9 + n10 > n11) {
                            textureListStruct2.stItem[n7].iType = 1;
                        }
                        n8 = (int)(10.0 * (d5 - d7) / d5);
                        switch (textureListStruct2.stItem[n7].iType) {
                            case 0: {
                                for (n3 = 9; n3 > 0; --n3) {
                                    if (n8 > textureConstants.SiO2_CELLS[n3]) continue;
                                    textureListStruct2.stItem[n7].iTexture = n3;
                                }
                                textureListStruct2.stItem[n7].iEnergy = n8 = textureConstants.SiO2_CELLS[textureListStruct2.stItem[n7].iTexture];
                                textureListStruct2.stItem[n7].iRGB = textureConstants.SIO2_COLOR[n8 - 1];
                                textureListStruct2.stItem[n7].id = textureConstants.SIO2_TEXTURE[n8 - 1][0];
                                break;
                            }
                            case 1: {
                                for (n3 = 5; n3 > -1; --n3) {
                                    if (n8 > textureConstants.CaCO3_CELLS[n3]) continue;
                                    textureListStruct2.stItem[n7].iTexture = n3;
                                }
                                textureListStruct2.stItem[n7].iEnergy = n8 = textureConstants.CaCO3_CELLS[textureListStruct2.stItem[n7].iTexture];
                                if (n10 >= n9) {
                                    textureListStruct2.stItem[n7].iRGB = textureConstants.LIMESTONE_COLOR[n8 - 1];
                                    textureListStruct2.stItem[n7].id = textureConstants.LIMESTONE_TEXTURE[n8 - 1][0];
                                    break;
                                }
                                textureListStruct2.stItem[n7].iRGB = textureConstants.DOLOMITE_COLOR[n8 - 1];
                                textureListStruct2.stItem[n7].id = textureConstants.DOLOMITE_TEXTURE[n8 - 1][0];
                                break;
                            }
                            case 2: {
                                textureListStruct2.stItem[n7].id = n6;
                                textureListStruct2.stItem[n7].iEnergy = n8 + 1;
                                textureListStruct2.stItem[n7].iType = 2;
                                textureListStruct2.stItem[n7].iTexture = 2;
                            }
                        }
                    }
                    for (n5 = 0; n5 < lithologySymbolsListStruct2.iCount; ++n5) {
                        if (textureListStruct2.stItem[n7].id != lithologySymbolsListStruct2.stItem[n5].id) continue;
                        textureListStruct2.stItem[n7].iSymbol = n5;
                        if (textureListStruct2.stItem[n7].id != 18 && textureListStruct2.stItem[n7].id != 32 && textureListStruct2.stItem[n7].id != 31) continue;
                        textureListStruct2.stItem[n7].iSymbol = n5;
                        textureListStruct2.stItem[n7].iRGB = lithologySymbolsListStruct2.stItem[n5].iRGB;
                    }
                    continue;
                }
                n8 = (int)(10.0 * (d5 - d7) / d5);
                textureListStruct2.stItem[n7].id = n6;
                textureListStruct2.stItem[n7].iEnergy = n8 + 1;
                textureListStruct2.stItem[n7].iType = 4;
                if (n6 == 34) {
                    textureListStruct2.stItem[n7].iType = 2;
                    textureListStruct2.stItem[n7].iTexture = 2;
                } else if (n6 == 44) {
                    textureListStruct2.stItem[n7].iType = 3;
                    textureListStruct2.stItem[n7].iTexture = 3;
                }
                for (n5 = 0; n5 < lithologySymbolsListStruct2.iCount; ++n5) {
                    if (textureListStruct2.stItem[n7].id != lithologySymbolsListStruct2.stItem[n5].id) continue;
                    textureListStruct2.stItem[n7].iSymbol = n5;
                    textureListStruct2.stItem[n7].iRGB = lithologySymbolsListStruct2.stItem[n5].iRGB;
                }
            }
        }
        return textureListStruct2;
    }

    public static textureListStruct setLegend(textureListStruct textureListStruct2) {
        textureListStruct textureListStruct3 = null;
        int n = -1;
        if (textureListStruct2 != null && textureListStruct2.iCount > 0) {
            textureListStruct3 = new textureListStruct();
            for (int i = 0; i < textureListStruct2.iCount; ++i) {
                n = -1;
                for (int j = 0; j < textureListStruct3.iCount; ++j) {
                    if (!textureListStruct2.stItem[i].sTexture.equals(textureListStruct3.stItem[j].sTexture)) continue;
                    n = 1;
                }
                if (n != -1) continue;
                textureListStruct3 = textureUtility.add(textureListStruct2.stItem[i], textureListStruct3);
            }
        }
        return textureListStruct3;
    }

    public static textureListStruct legendSort(textureListStruct textureListStruct2) {
        boolean bl = true;
        textureStruct textureStruct2 = null;
        if (textureListStruct2 != null && textureListStruct2.iCount > 1) {
            while (bl) {
                bl = false;
                for (int i = 0; i < textureListStruct2.iCount - 1; ++i) {
                    if (10 * textureListStruct2.stItem[i].iType + textureListStruct2.stItem[i].iEnergy <= 10 * textureListStruct2.stItem[i + 1].iType + textureListStruct2.stItem[i + 1].iEnergy) continue;
                    bl = true;
                    textureStruct2 = textureUtility.copy(textureListStruct2.stItem[i]);
                    textureListStruct2.stItem[i] = textureUtility.copy(textureListStruct2.stItem[i + 1]);
                    textureListStruct2.stItem[i + 1] = textureUtility.copy(textureStruct2);
                }
            }
        }
        return textureListStruct2;
    }

    public static textureListStruct bubbleSort(textureListStruct textureListStruct2) {
        boolean bl = true;
        textureStruct textureStruct2 = null;
        if (textureListStruct2 != null && textureListStruct2.iCount > 1) {
            while (bl) {
                bl = false;
                for (int i = 0; i < textureListStruct2.iCount - 1; ++i) {
                    if (!(textureListStruct2.stItem[i].depthStart > textureListStruct2.stItem[i + 1].depthStart)) continue;
                    bl = true;
                    textureStruct2 = textureUtility.copy(textureListStruct2.stItem[i]);
                    textureListStruct2.stItem[i] = textureUtility.copy(textureListStruct2.stItem[i + 1]);
                    textureListStruct2.stItem[i + 1] = textureUtility.copy(textureStruct2);
                }
            }
        }
        return textureListStruct2;
    }

    public static double[][] getOrder(double d, double d2, double d3, double d4) {
        Object object = new double[][]{{0.0, d}, {1.0, d2}, {2.0, d3}, {3.0, d4}};
        object = textureUtility.Sort(4, 2, 1, object);
        return object;
    }

    public static double[][] Sort(int n, int n2, int n3, double[][] dArray) {
        int n4 = 0;
        boolean bl = true;
        double[] dArray2 = null;
        dArray2 = new double[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            dArray2[n4] = 0.0;
        }
        if (dArray != null) {
            while (bl) {
                bl = false;
                for (int i = 0; i < n - 1; ++i) {
                    if (!(dArray[i][n3] > dArray[i + 1][n3])) continue;
                    bl = true;
                    for (n4 = 0; n4 < n2; ++n4) {
                        dArray2[n4] = dArray[i][n4];
                    }
                    for (n4 = 0; n4 < n2; ++n4) {
                        dArray[i][n4] = dArray[i + 1][n4];
                    }
                    for (n4 = 0; n4 < n2; ++n4) {
                        dArray[i + 1][n4] = dArray2[n4];
                    }
                }
            }
        }
        return dArray;
    }

    public static void print(textureListStruct textureListStruct2) {
        System.out.println("-------------------------------------------------");
        if (textureListStruct2 != null) {
            System.out.println("TEXTURE: " + textureListStruct2.iUnit + " " + textureListStruct2.depthStart + " " + textureListStruct2.depthEnd);
            for (int i = 0; i < textureListStruct2.iCount; ++i) {
                if (textureListStruct2.stItem[i] == null) continue;
                System.out.print(i + " " + textureListStruct2.stItem[i].sKEY + " " + textureListStruct2.stItem[i].depthStart + " " + textureListStruct2.stItem[i].depthEnd + " " + textureListStruct2.stItem[i].iEnergy + " " + textureListStruct2.stItem[i].sType + " " + textureListStruct2.stItem[i].sTexture);
                System.out.println("");
            }
        }
        System.out.println("-------------------------------------------------");
    }
}

