/*
 * Decompiled with CFR 0.152.
 */
package lith.rock.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import lith.rock.plot.rockColumnPlotSymbol;
import lith.rock.rockColumnListStruct;
import lith.rock.rockColumnUtility;
import parse.parseRockColumnSymbolsListStruct;
import parse.parseRockColumnSymbolsUtility;

public class rockColumnPlotTrack
extends Canvas {
    private int iUnits = 0;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private rockColumnListStruct stList = null;
    private rockColumnListStruct stColumn = null;
    private parseRockColumnSymbolsListStruct stSymbols = null;
    private rockColumnPlotSymbol plotLith = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public rockColumnPlotTrack(int n, double d, double d2, int n2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        this.iDataType = n;
        this.stSymbols = parseRockColumnSymbolsListStruct2;
        this.plotLith = new rockColumnPlotSymbol(parseRockColumnSymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stList = null;
        this.stSymbols = null;
        if (this.stColumn != null) {
            this.stColumn.delete();
        }
        this.stColumn = null;
        if (this.plotLith != null) {
            this.plotLith.close();
        }
        this.plotLith = null;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        if (this.stColumn != null) {
            this.stColumn.delete();
        }
        this.stColumn = null;
        this.stColumn = rockColumnUtility.getData(this.stList, n);
    }

    public void setRockColumn(rockColumnListStruct rockColumnListStruct2) {
        this.stList = rockColumnListStruct2;
        this.stColumn = rockColumnUtility.getData(this.stList, this.iScale);
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = n2 / 10;
        int n5 = n + n2;
        int n6 = 0;
        int n7 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (int i = 0; i <= this.iLogHeight; i += this.iIncrementY) {
            n6 = this.iDataType == 1 ? this.iHeight - i : i + 100;
            n3 = this.iIncrementY / 5;
            for (int j = 0; j < 5; ++j) {
                n7 = this.iDataType == 1 ? this.iHeight - (i + j * n3) : i + j * n3 + 100;
                if (n7 < 100 || n7 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n7, n5, n7);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n6, n5, n6);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.setColor(Color.black);
        graphics.drawString("Lithology", n + 3 * n4, 39);
        graphics.drawString("Rock Column", n + 2 * n4, 53);
        graphics.drawLine(n, 25, n5, 25);
        graphics.drawLine(n, 100, n5, 100);
    }

    public void drawColumn(Graphics graphics, int n, int n2) {
        rockColumnListStruct rockColumnListStruct2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        int n8 = -1;
        String string2 = "";
        int n9 = -1;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int[] nArray2 = new int[]{255, 255, 255};
        int n16 = -1;
        int n17 = 0;
        int n18 = 0;
        boolean bl = false;
        rockColumnListStruct2 = this.stColumn;
        if (rockColumnListStruct2 != null && rockColumnListStruct2.iCount > 0) {
            for (int i = 0; i < rockColumnListStruct2.iCount; ++i) {
                int n19;
                int n20;
                int n21;
                d = rockColumnListStruct2.stItem[i].depthStart;
                d2 = rockColumnListStruct2.stItem[i].depthEnd;
                d4 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n5 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n5 = this.iHeight - (int)d4;
                }
                n6 = Math.abs(n5 - n4);
                string = rockColumnListStruct2.stItem[i].sPrimary;
                n8 = parseRockColumnSymbolsUtility.getID(string, this.stSymbols);
                if (n8 <= -1) continue;
                n11 = this.stSymbols.stItem[n8].iWeather;
                n12 = this.stSymbols.stItem[n8].iRows;
                n13 = this.stSymbols.stItem[n8].iColumns;
                nArray = this.stSymbols.stItem[n8].iRGB;
                n17 = this.stSymbols.stItem[n8].iOrder;
                n10 = n6 / n12;
                n7 = n6 - n10 * n12;
                for (n21 = 0; n21 < n10; ++n21) {
                    if (n4 + n21 * n12 < 100 || n4 + n21 * n12 >= this.iHeight) continue;
                    for (n20 = 0; n20 < n11; ++n20) {
                        this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n20 * n13, n4 + n21 * n12, n13, n12);
                        this.plotLith.drawSymbolMask(graphics, n12, this.plotLith.getOrder(n3), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n + n20 * n13, n4 + n21 * n12);
                    }
                    if (rockColumnListStruct2.stItem[i].iSecondary > 0) {
                        for (n19 = 0; n19 < rockColumnListStruct2.stItem[i].iSecondary; ++n19) {
                            string2 = rockColumnListStruct2.stItem[i].secondary[n19];
                            n9 = parseRockColumnSymbolsUtility.getID(string2, this.stSymbols);
                            if (n9 <= -1) continue;
                            n14 = this.stSymbols.stItem[n9].iRows;
                            n15 = this.stSymbols.stItem[n9].iColumns;
                            n18 = this.stSymbols.stItem[n9].iOrder;
                            nArray2 = n17 == 0 && (n18 == 1 || n18 == 2) ? this.stSymbols.stItem[n9].iRGB : nArray;
                            for (n20 = 0; n20 < n11; ++n20) {
                                bl = true;
                                if (!bl) continue;
                                this.plotLith.drawSymbolMask(graphics, n14, this.plotLith.getOrder(n3), nArray2, parseRockColumnSymbolsUtility.getSymbol(string2, this.stSymbols), n + n20 * n15, n4 + n21 * n14);
                            }
                        }
                    }
                    if (n17 > 3) {
                        for (n20 = 0; n20 < n11; ++n20) {
                            this.plotLith.drawSymbolMask(graphics, n12, this.plotLith.getOrder(n3), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n + n20 * n13, n4 + n21 * n12);
                        }
                    }
                    ++n3;
                }
                if (n4 + n10 * n12 < 100 || n4 + n10 * n12 >= this.iHeight || n7 <= 0) continue;
                for (n20 = 0; n20 < n11; ++n20) {
                    this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n20 * n13, n4 + n10 * n12, n13, n7);
                    this.plotLith.drawSymbolMask(graphics, n7, this.plotLith.getOrder(n3), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n + n20 * n13, n4 + n10 * n12);
                }
                if (rockColumnListStruct2.stItem[i].iSecondary > 0) {
                    for (n19 = 0; n19 < rockColumnListStruct2.stItem[i].iSecondary; ++n19) {
                        string2 = rockColumnListStruct2.stItem[i].secondary[n19];
                        n9 = parseRockColumnSymbolsUtility.getID(string2, this.stSymbols);
                        if (n9 <= -1) continue;
                        n14 = this.stSymbols.stItem[n9].iRows;
                        n15 = this.stSymbols.stItem[n9].iColumns;
                        n18 = this.stSymbols.stItem[n9].iOrder;
                        nArray2 = n17 == 0 && (n18 == 1 || n18 == 2) ? this.stSymbols.stItem[n9].iRGB : nArray;
                        for (n20 = 0; n20 < n11; ++n20) {
                            bl = true;
                            if (n7 > n14) {
                                n7 = n14;
                            }
                            if (!bl) continue;
                            this.plotLith.drawSymbolMask(graphics, n7, this.plotLith.getOrder(n3), nArray2, parseRockColumnSymbolsUtility.getSymbol(string2, this.stSymbols), n + n20 * n15, n4 + n10 * n14);
                        }
                    }
                }
                if (n17 <= 3) continue;
                for (n20 = 0; n20 < n11; ++n20) {
                    this.plotLith.drawSymbolMask(graphics, n7, this.plotLith.getOrder(n3), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n + n20 * n13, n4 + n21 * n12);
                }
            }
        }
    }

    public void drawTextureGrid(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n2 / 14;
        int n6 = n + n2;
        int n7 = 0;
        int n8 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n7 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n4 = this.iIncrementY / 5;
            for (int i = 0; i < 5; ++i) {
                n8 = this.iDataType == 1 ? this.iHeight - (n3 + i * n4) : n3 + i * n4 + 100;
                if (n8 < 100 || n8 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n8, n6, n8);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n7, n6, n7);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        for (n3 = 0; n3 <= n2; n3 += 2 * n5) {
            if (n3 == 0 || n3 == n2) {
                graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
        }
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(new Color(0, 157, 118));
        graphics.fillRect(n, 56, 60, 11);
        graphics.setColor(new Color(105, 156, 160));
        graphics.fillRect(n + 6 * n5, 56, 20, 11);
        graphics.setColor(new Color(0, 180, 204));
        graphics.fillRect(n + 8 * n5, 56, 20, 11);
        graphics.setColor(new Color(128, 255, 255));
        graphics.fillRect(n + 10 * n5, 56, 20, 11);
        graphics.setColor(new Color(186, 132, 195));
        graphics.fillRect(n + 12 * n5, 56, 20, 11);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 60, 56, n + 60, 67);
        graphics.drawLine(n + 80, 45, n + 80, 67);
        graphics.drawLine(n + 100, 56, n + 100, 67);
        graphics.drawLine(n + 120, 45, n + 120, 67);
        graphics.drawString("Mud", n + 5 * n5, 56);
        graphics.drawString("Grain", n + 9 * n5, 56);
        graphics.drawString("Mdst", n + 2 * n5, 67);
        graphics.drawString("Wk", n + 6 * n5 + 2, 67);
        graphics.drawString("Pk", n + 8 * n5 + 2, 67);
        graphics.drawString("Gn", n + 10 * n5 + 2, 67);
        graphics.drawString("Bd", n + 12 * n5 + 2, 67);
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(new Color(127, 127, 127));
        graphics.fillRect(n, 89, 20, 11);
        graphics.setColor(new Color(190, 190, 190));
        graphics.fillRect(n + 2 * n5, 89, 20, 11);
        graphics.setColor(new Color(229, 229, 229));
        graphics.fillRect(n + 4 * n5, 89, 20, 11);
        graphics.setColor(new Color(255, 204, 51));
        graphics.fillRect(n + 6 * n5, 89, 20, 11);
        graphics.setColor(new Color(255, 230, 0));
        graphics.fillRect(n + 8 * n5, 89, 20, 11);
        graphics.setColor(new Color(255, 255, 52));
        graphics.fillRect(n + 10 * n5, 89, 20, 11);
        graphics.setColor(new Color(204, 255, 0));
        graphics.fillRect(n + 12 * n5, 89, 20, 11);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 20, 89, n + 20, 100);
        graphics.drawLine(n + 40, 89, n + 40, 100);
        graphics.drawLine(n + 60, 78, n + 60, 100);
        graphics.drawLine(n + 80, 89, n + 80, 100);
        graphics.drawLine(n + 100, 89, n + 100, 100);
        graphics.drawLine(n + 120, 78, n + 120, 100);
        graphics.setColor(Color.black);
        graphics.drawString("Mud", n + 2 * n5, 89);
        graphics.drawString("Sand", n + 8 * n5, 89);
        graphics.drawString("Clay", n, 100);
        graphics.drawString("Shle", n + 2 * n5, 100);
        graphics.drawString("Silt", n + 4 * n5 + 2, 100);
        graphics.drawString("Fn", n + 6 * n5 + 2, 100);
        graphics.drawString("Med", n + 8 * n5 + 2, 100);
        graphics.drawString("Crs", n + 10 * n5 + 2, 100);
        graphics.drawString("Grv", n + 12 * n5 + 2, 100);
        graphics.setColor(Color.black);
        graphics.drawString("Texture", n + 3 * n5, 39);
        graphics.drawLine(n, 25, n6, 25);
        graphics.drawLine(n, 100, n6, 100);
    }

    public void drawColumn(Graphics graphics, int n, int n2, int n3) {
        rockColumnListStruct rockColumnListStruct2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string = "";
        int n9 = -1;
        String string2 = "";
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int[] nArray2 = new int[]{255, 255, 255};
        int n17 = -1;
        int n18 = 0;
        int n19 = 0;
        boolean bl = false;
        rockColumnListStruct2 = this.stColumn;
        if (rockColumnListStruct2 != null && rockColumnListStruct2.iCount > 0) {
            for (int i = 0; i < rockColumnListStruct2.iCount; ++i) {
                int n20;
                int n21;
                int n22;
                d = rockColumnListStruct2.stItem[i].depthStart;
                d2 = rockColumnListStruct2.stItem[i].depthEnd;
                d4 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n5 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n5 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d4;
                }
                n7 = Math.abs(n6 - n5);
                string = rockColumnListStruct2.stItem[i].sPrimary;
                n9 = parseRockColumnSymbolsUtility.getID(string, this.stSymbols);
                if (n9 <= -1) continue;
                n12 = n == 76 ? this.stSymbols.stItem[n9].iWeather : rockColumnListStruct2.stItem[i].iTexture;
                n13 = this.stSymbols.stItem[n9].iRows;
                n14 = this.stSymbols.stItem[n9].iColumns;
                nArray = this.stSymbols.stItem[n9].iRGB;
                n18 = this.stSymbols.stItem[n9].iOrder;
                n11 = n7 / n13;
                n8 = n7 - n11 * n13;
                for (n22 = 0; n22 < n11; ++n22) {
                    if (n5 + n22 * n13 < 100 || n5 + n22 * n13 >= this.iHeight) continue;
                    for (n21 = 0; n21 < n12; ++n21) {
                        this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n2 + n21 * n14, n5 + n22 * n13, n14, n13);
                        this.plotLith.drawSymbolMask(graphics, n13, this.plotLith.getOrder(n4), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n2 + n21 * n14, n5 + n22 * n13);
                    }
                    if (rockColumnListStruct2.stItem[i].iSecondary > 0) {
                        for (n20 = 0; n20 < rockColumnListStruct2.stItem[i].iSecondary; ++n20) {
                            string2 = rockColumnListStruct2.stItem[i].secondary[n20];
                            n10 = parseRockColumnSymbolsUtility.getID(string2, this.stSymbols);
                            if (n10 <= -1) continue;
                            n15 = this.stSymbols.stItem[n10].iRows;
                            n16 = this.stSymbols.stItem[n10].iColumns;
                            n19 = this.stSymbols.stItem[n10].iOrder;
                            nArray2 = n18 == 0 && (n19 == 1 || n19 == 2) ? this.stSymbols.stItem[n10].iRGB : nArray;
                            for (n21 = 0; n21 < n12; ++n21) {
                                bl = true;
                                if (!bl) continue;
                                this.plotLith.drawSymbolMask(graphics, n15, this.plotLith.getOrder(n4), nArray2, parseRockColumnSymbolsUtility.getSymbol(string2, this.stSymbols), n2 + n21 * n16, n5 + n22 * n15);
                            }
                        }
                    }
                    if (n18 > 3) {
                        for (n21 = 0; n21 < n12; ++n21) {
                            this.plotLith.drawSymbolMask(graphics, n13, this.plotLith.getOrder(n4), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n2 + n21 * n14, n5 + n22 * n13);
                        }
                    }
                    ++n4;
                }
                if (n5 + n11 * n13 < 100 || n5 + n11 * n13 >= this.iHeight || n8 <= 0) continue;
                for (n21 = 0; n21 < n12; ++n21) {
                    this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n2 + n21 * n14, n5 + n11 * n13, n14, n8);
                    this.plotLith.drawSymbolMask(graphics, n8, this.plotLith.getOrder(n4), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n2 + n21 * n14, n5 + n11 * n13);
                }
                if (rockColumnListStruct2.stItem[i].iSecondary > 0) {
                    for (n20 = 0; n20 < rockColumnListStruct2.stItem[i].iSecondary; ++n20) {
                        string2 = rockColumnListStruct2.stItem[i].secondary[n20];
                        n10 = parseRockColumnSymbolsUtility.getID(string2, this.stSymbols);
                        if (n10 <= -1) continue;
                        n15 = this.stSymbols.stItem[n10].iRows;
                        n16 = this.stSymbols.stItem[n10].iColumns;
                        n19 = this.stSymbols.stItem[n10].iOrder;
                        nArray2 = n18 == 0 && (n19 == 1 || n19 == 2) ? this.stSymbols.stItem[n10].iRGB : nArray;
                        for (n21 = 0; n21 < n12; ++n21) {
                            bl = true;
                            if (n8 > n15) {
                                n8 = n15;
                            }
                            if (!bl) continue;
                            this.plotLith.drawSymbolMask(graphics, n8, this.plotLith.getOrder(n4), nArray2, parseRockColumnSymbolsUtility.getSymbol(string2, this.stSymbols), n2 + n21 * n16, n5 + n11 * n15);
                        }
                    }
                }
                if (n18 <= 3) continue;
                for (n21 = 0; n21 < n12; ++n21) {
                    this.plotLith.drawSymbolMask(graphics, n8, this.plotLith.getOrder(n4), parseRockColumnSymbolsUtility.getSymbol(string, this.stSymbols), n2 + n21 * n14, n5 + n22 * n13);
                }
            }
        }
    }

    public void drawGrainsizeGrid(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n2 / 8;
        int n6 = n + n2;
        int n7 = 0;
        int n8 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n7 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n4 = this.iIncrementY / 5;
            for (int i = 0; i < 5; ++i) {
                n8 = this.iDataType == 1 ? this.iHeight - (n3 + i * n4) : n3 + i * n4 + 100;
                if (n8 < 100 || n8 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n8, n6, n8);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n, n7, n6, n7);
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        graphics.setColor(Color.lightGray);
        for (n3 = 0; n3 <= n2; n3 += n5) {
            if (n3 == 0 || n3 == n2) {
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n3 + n, 45, n3 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.gray);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Crypto", 55, -1 * n);
        graphics2D.drawString("Micro", 55, -1 * (n + n5));
        graphics2D.drawString("Very Fine", 45, -1 * (n + 2 * n5));
        graphics2D.drawString("Fine", 55, -1 * (n + 3 * n5));
        graphics2D.drawString("Medium", 55, -1 * (n + 4 * n5));
        graphics2D.drawString("Coarse", 55, -1 * (n + 5 * n5));
        graphics2D.drawString("Very Coarse", 45, -1 * (n + 6 * n5));
        graphics2D.drawString("Extr Coarse", 45, -1 * (n + 7 * n5));
        graphics2D.rotate(-1.5707963267948966);
        graphics.setColor(Color.black);
        graphics.drawString("Grainsize", n + n5, 39);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        graphics.drawLine(n, 25, n6, 25);
        graphics.drawLine(n, 45, n6, 45);
        graphics.drawLine(n, 100, n6, 100);
    }

    public void drawGrainsize(Graphics graphics, int n, int n2) {
        rockColumnListStruct rockColumnListStruct2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = "";
        int n6 = -1;
        int[] nArray = new int[]{255, 255, 255};
        int n7 = n2 / 8;
        rockColumnListStruct2 = this.stColumn;
        if (rockColumnListStruct2 != null && rockColumnListStruct2.iCount > 0) {
            for (int i = 0; i < rockColumnListStruct2.iCount; ++i) {
                d = rockColumnListStruct2.stItem[i].depthStart;
                d2 = rockColumnListStruct2.stItem[i].depthEnd;
                d4 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d4;
                }
                n5 = Math.abs(n4 - n3);
                if (n3 < 100 || n4 <= 100 || n3 >= this.iHeight || n4 >= this.iHeight || (n6 = parseRockColumnSymbolsUtility.getID(string = rockColumnListStruct2.stItem[i].sPrimary, this.stSymbols)) <= -1) continue;
                nArray = this.stSymbols.stItem[n6].iRGB;
                for (int j = 0; j < 8; ++j) {
                    if (rockColumnListStruct2.stItem[i].igrains[j] <= -1) continue;
                    graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                    graphics.fillRect(n + j * n7, n3, n7, n5);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = -1;
        if (n == 76) {
            n4 = 1;
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawColumn(graphics, n2, n3);
        }
        if (n == 77) {
            n4 = 1;
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawTextureGrid(graphics, n2, n3);
            this.drawColumn(graphics, n, n2, n3);
        }
        if (n == 78) {
            n4 = 1;
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrainsize(graphics, n2, n3);
            this.drawGrainsizeGrid(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

