/*
 * Decompiled with CFR 0.152.
 */
package lith.math;

import lith.math.Inverse;
import math.mathLAS;

public class lithMath {
    public static final int _QUARTZ = 0;
    public static final int _CALCITE = 1;
    public static final int _DOLOMITE = 2;
    public static final int _ANHYDRITE = 3;
    public static final int _GYPSUM = 4;
    public static final int _HALITE = 5;
    public static final int _HIGH_Z_CLAY = 6;
    public static final int _LOW_Z_CLAY = 7;
    public static final int _COAL = 8;
    public static final int _FELDSPAR = 9;
    public static final int _Na_PLAGIOCLASE = 10;
    public static final int _Ca_PLAGIOCLASE = 11;
    public static final int _ULTRA_MAFIC = 12;
    public static final int _SIO2 = 13;
    public static final int _MICA = 14;
    public static final int _SHALE = 15;
    public static final int _CaCO3 = 16;
    public static final int _ROWS = 17;
    public static final String[] MINERALS = new String[]{"Quartz", "Calcite", "Dolomite", "Anhydrite", "Gypsum", "Halite", "High Z Clay", "Low Z Clay", "Coal", "Feldspar", "Anorthite", "Ultramafic", "QUARTZ No Porosity", "Biotite", "SHALE"};
    public static final int _RHOB = 0;
    public static final int _RHOMAA = 1;
    public static final int _NPHI = 2;
    public static final int _UMAA = 3;
    public static final int _PHI_DIFF = 4;
    public static final int _GR = 5;
    public static final int _TH = 6;
    public static final int _U = 7;
    public static final int _K = 8;
    public static final int _DTC = 9;
    public static final int _COLUMNS = 11;
    public static final double[][] _MINERAL = new double[][]{{2.64, 2.65, 18.0, 4.8, 20.0, 14.83, 2.0, 0.7, 0.08, 55.5}, {2.71, 2.71, 0.1, 13.8, -10.0, 4.9, 0.0, 0.0, 0.3, 47.5}, {2.85, 2.88, 18.0, 9.0, 20.0, 1.14, 0.0, 0.0, 0.07, 43.5}, {2.98, 2.98, 1.0, 14.9, -10.0, 0.0, 0.0, 0.0, 0.0, 50.0}, {2.35, 3.1, 51.0, 18.38, -30.0, 0.0, 0.0, 0.0, 0.0, 52.5}, {2.04, 2.04, -2.0, 13.8, 40.0, 0.0, 0.0, 0.0, 0.0, 67.0}, {2.52, 3.006, 30.0, 13.0, 3.1, 234.34, 17.5, 6.95, 6.7, 106.0}, {2.12, 3.08, 44.0, 7.0, 15.0, 132.16, 17.0, 4.85, 1.6, 211.7}, {1.24, 1.5, 60.0, 0.42, 40.0, 0.0, 0.0, 0.0, 0.0, 105.0}, {2.54, 2.614, -1.1, 7.59, -11.0, 171.0, 1.1, 0.4, 10.2, 69.0}, {2.58, 2.631, -1.3, 4.491, -8.9, 8.0, 0.0, 0.0, 0.5, 47.2}, {2.74, 2.73, -1.6, 8.7, 0.2, 1.0, 0.0, 0.1, 0.0, 45.0}, {3.09, 3.02, 24.0, 13.95, 20.0, 15.0, 2.0, 0.35, 0.54, 49.4}, {2.64, 2.65, -2.1, 4.85, -6.2, 1.0, 0.0, 0.1, 0.0, 50.5}, {2.83, 3.06, 16.5, 7.35, 23.5, 130.0, 0.0, 0.7, 7.8, 47.2}, {2.12, 3.02, 44.0, 6.0, 15.0, 132.16, 17.0, 4.85, 1.6, 55.5}, {2.71, 2.71, 0.1, 13.8, -10.0, 0.0, 0.0, 0.0, 0.3, 52.5}};
    public static final int _FRESH_H2O = 0;
    public static final int _SALTY_H2O = 1;
    public static final int _OIL_MUD = 2;
    public static final double[] RHO_f = new double[]{1.0, 1.1, 0.985};
    public static final double[] DT_f = new double[]{189.0, 185.0, 204.5};
    public static final double[] U_f = new double[]{0.398, 1.36, 0.0};
    public static final int[] _RU = new int[]{2, 1, 0};
    public static final int[] _RU_COL = new int[]{1, 3};
    public static final int[] _RU_LITH = new int[]{22, 19, 7};
    public static final int[] _PD_COL = new int[]{1, 2};
    public static final int[] _PDGR_COL = new int[]{1, 2, 5};
    public static final int[] _RT_COL = new int[]{1, 9};
    public static final int[] _RTGR_COL = new int[]{1, 9, 5};
    public static final int[] _RUo = new int[]{15, 2, 1, 0};
    public static final int[] _RUo_LITH = new int[]{12, 22, 19, 7};
    public static final int[] _RUGR = new int[]{7, 6, 1, 0};
    public static final int[] _RUGR_COL = new int[]{1, 3, 5};
    public static final int[] _RUGR_LITH = new int[]{10, 12, 19, 7};
    public static final int[] _ARKOSE = new int[]{6, 1, 13, 9};
    public static final int[] _ARKOSE_LITH = new int[]{12, 19, 7, 95};
    public static final int[] _ARKOSE_RT = new int[]{6, 13, 9};
    public static final int[] _ARKOSE_RT_LITH = new int[]{12, 7, 95};
    public static final int[] _GRANITE = new int[]{14, 10, 13, 9};
    public static final int[] _GRANITE_LITH = new int[]{231, 171, 7, 95};
    public static final int[] _IGNEOUS = new int[]{12, 11, 13, 9};
    public static final int[] _IGNEOUS_LITH = new int[]{172, 171, 7, 95};
    public static final int[] _ANHY = new int[]{2, 1, 3};
    public static final int[] _ANHY_LITH = new int[]{22, 19, 32};
    public static final int[] _GYP = new int[]{2, 1, 4};
    public static final int[] _GYP_LITH = new int[]{22, 19, 31};
    public static final int[] _SALT_COAL = new int[]{1, 0, 5, 8};
    public static final int[] _SALT_COAL_LITH = new int[]{19, 7, 34, 44};
    public static final int[] _SALT = new int[]{1, 0, 5};
    public static final int[] _SALT_LITH = new int[]{19, 7, 34};
    public static final int[] _BLK_COAL = new int[]{1, 0, 8};
    public static final int[] _BLK_COAL_LITH = new int[]{19, 7, 44};

    public static double[] getLog(int n, int n2, double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d5 = 0.0;
        double d6 = 0.0;
        d5 = mathLAS.computePHI(d, 0, n, n2);
        d6 = mathLAS.computeAvgPHI(d3, d5);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d6);
        dArray[1] = d2 > 0.0 ? mathLAS.computeUmaa(n2, d, d2, d6) : 100.0 * d3;
        dArray[2] = d4;
        dArray[3] = 1.0;
        return dArray;
    }

    public static double[] getRU(int n, int n2, double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d4 = 0.0;
        double d5 = 0.0;
        d4 = mathLAS.computePHI(d, 0, n, n2);
        d5 = mathLAS.computeAvgPHI(d3, d4);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d5);
        dArray[1] = mathLAS.computeUmaa(n2, d, d2, d5);
        dArray[2] = 1.0;
        return dArray;
    }

    public static double[] getRT(int n, int n2, double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        d3 = mathLAS.computePHI(d, 0, n, n2);
        d4 = mathLAS.computePHI(d2, 1, n, n2);
        d5 = Math.sqrt(d4 * d4 + d3 * d3);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d5);
        dArray[1] = mathLAS.computeDTMAA(n2, d2, d5);
        dArray[2] = 1.0;
        return dArray;
    }

    public static double[] getRT(int n, int n2, double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d4 = 0.0;
        double d5 = 0.0;
        d4 = mathLAS.computePHI(d, 0, n, n2);
        d5 = mathLAS.computeAvgPHI(d3, d4);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d5);
        dArray[1] = mathLAS.computeDTMAA(n2, d2, d5);
        dArray[2] = 1.0;
        return dArray;
    }

    public static double[] getPD(int n, int n2, double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = mathLAS.computePHI(d, 0, n, n2);
        d4 = mathLAS.computeAvgPHI(d2, d3);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d4);
        dArray[1] = 100.0 * d2;
        dArray[2] = 1.0;
        return dArray;
    }

    public static double[] getRUGR(int n, int n2, double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d5 = 0.0;
        double d6 = 0.0;
        d5 = mathLAS.computePHI(d, 0, n, n2);
        d6 = mathLAS.computeAvgPHI(d3, d5);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d6);
        dArray[1] = mathLAS.computeUmaa(n2, d, d2, d6);
        dArray[2] = d4;
        dArray[3] = 1.0;
        return dArray;
    }

    public static double[] getPDGR(int n, int n2, double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d4 = 0.0;
        double d5 = 0.0;
        d4 = mathLAS.computePHI(d, 0, n, n2);
        d5 = mathLAS.computeAvgPHI(d2, d4);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d5);
        dArray[1] = 100.0 * d2;
        dArray[2] = d3;
        dArray[3] = 1.0;
        return dArray;
    }

    public static double[] getRTGR(int n, int n2, double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d5 = 0.0;
        double d6 = 0.0;
        d5 = mathLAS.computePHI(d, 0, n, n2);
        d6 = mathLAS.computeAvgPHI(d3, d5);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d6);
        dArray[1] = mathLAS.computeDTMAA(n2, d2, d6);
        dArray[2] = d4;
        dArray[3] = 1.0;
        return dArray;
    }

    public static double[] getRTGR(int n, int n2, double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        d4 = mathLAS.computePHI(d, 0, n, n2);
        d5 = mathLAS.computePHI(d2, 1, n, n2);
        d6 = Math.sqrt(d5 * d5 + d4 * d4);
        dArray[0] = mathLAS.computeRhomaa(n2, d, d6);
        dArray[1] = mathLAS.computeDTMAA(n2, d2, d6);
        dArray[2] = d3;
        dArray[3] = 1.0;
        return dArray;
    }

    public static double[][] getMatrix(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        double[][] dArray = null;
        dArray = new double[n3][n3];
        for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n][n2] = 1.0;
            }
        }
        for (n = 0; n < n3 - 1; ++n) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n][n2] = _MINERAL[nArray[n2]][nArray2[n]];
            }
        }
        return dArray;
    }

    public static double[] composition(double[] dArray, double[][] dArray2) {
        double[] dArray3 = null;
        double[][] dArray4 = null;
        int n = 0;
        if (dArray != null && dArray2 != null) {
            n = dArray.length;
            dArray3 = new double[n];
            dArray4 = new double[n][n];
            dArray4 = Inverse.invert(dArray2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray3[i] = dArray3[i] + dArray4[i][j] * dArray[j];
                }
            }
        }
        return dArray3;
    }

    public static double[] computeComposition(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3, 1.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        Object object = new double[][]{{1.0, -2.0, 0.0, 100.0}, {2.87, 2.65, 2.71, 1.0}, {9.0, 4.79, 13.77, 0.5}, {1.0, 1.0, 1.0, 1.0}};
        object = Inverse.invert(object);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray2[i] = dArray2[i] + object[i][j] * dArray[j];
            }
        }
        return dArray2;
    }

    public static double[] compositionByCore(double d, double d2) {
        double d3 = mathLAS.computePHI(d2, 0, 1, 0);
        double d4 = d - d3;
        double d5 = d2;
        double[] dArray = new double[]{d, d5, d4, 1.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        Object object = new double[][]{{1.0, -2.0, 0.0, 100.0}, {2.87, 2.65, 2.71, 1.0}, {20.0, 20.0, -10.0, 100.0}, {1.0, 1.0, 1.0, 1.0}};
        object = Inverse.invert(object);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray2[i] = dArray2[i] + object[i][j] * dArray[j];
            }
        }
        return dArray2;
    }

    public static double[] compositionByRock(double d, double d2) {
        double d3 = mathLAS.computePHI(d2, 0, 1, 0);
        double d4 = d - d3;
        double d5 = mathLAS.computeRhomaa(0, d2, d);
        double[] dArray = new double[]{d, d5, d4, 1.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        Object object = new double[][]{{1.0, -2.0, 0.0, 100.0}, {2.87, 2.65, 2.71, 1.0}, {20.0, 20.0, -10.0, 100.0}, {1.0, 1.0, 1.0, 1.0}};
        object = Inverse.invert(object);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray2[i] = dArray2[i] + object[i][j] * dArray[j];
            }
        }
        return dArray2;
    }
}

