/*
 * Decompiled with CFR 0.152.
 */
package lith.lithology.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import lith.lithology.lithologyListStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.plot.lithologyPlotSymbol;

public class lithologyPlotTrack
extends Canvas {
    private int iUnits = 0;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int iFocus = 0;
    private int iColorlith = 0;
    private lithologyListStruct stLASLithology = null;
    private lithologySymbolsListStruct stSymbols = null;
    private lithologyPlotSymbol plot = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public lithologyPlotTrack(int n, double d, double d2, int n2, int n3, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.iDataType = n;
        this.iUnits = n3;
        this.stSymbols = lithologySymbolsListStruct2;
        this.plot = new lithologyPlotSymbol(lithologySymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stSymbols = null;
        this.stLASLithology = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setMethod(int n) {
        this.iColorlith = n;
    }

    public void setLASRockColumn(lithologyListStruct lithologyListStruct2) {
        this.stLASLithology = lithologyListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 / 10;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = 10;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
        for (n3 = 0; n3 <= n2; n3 += n6) {
            if (n3 == 0 || n3 == n2) {
                graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        switch (this.iFocus) {
            case 0: {
                switch (this.iColorlith) {
                    case 0: {
                        graphics.drawString("Rhomaa-Umaa", n + 2 * n6, 39);
                        graphics.drawString("Computed", n + 3 * n6, 53);
                        graphics.drawString("Rock Column", n + 2 * n6, 67);
                        break;
                    }
                    case 1: 
                    case 5: {
                        graphics.drawString("Rhomaa-NPHI", n + 2 * n6, 39);
                        graphics.drawString("Computed", n + 3 * n6, 53);
                        graphics.drawString("Rock Column", n + 2 * n6, 67);
                    }
                }
                break;
            }
            case 2: {
                graphics.drawString("Rhomaa-NPHI", n + 2 * n6, 39);
                graphics.drawString("Computed", n + 3 * n6, 53);
                graphics.drawString("Rock Column", n + 2 * n6, 67);
                break;
            }
            case 3: {
                switch (this.iColorlith) {
                    case 0: {
                        graphics.drawString("Rhomaa-Umaa", n + 2 * n6, 39);
                        graphics.drawString("Computed", n + 3 * n6, 53);
                        graphics.drawString("Rock Column", n + 2 * n6, 67);
                        break;
                    }
                    case 1: 
                    case 5: {
                        graphics.drawString("Rhomaa-NPHI", n + 2 * n6, 39);
                        graphics.drawString("Computed", n + 3 * n6, 53);
                        graphics.drawString("Rock Column", n + 2 * n6, 67);
                    }
                }
                break;
            }
            case 4: {
                graphics.drawString("Rhomaa-DT", n + 2 * n6, 39);
                graphics.drawString("Computed", n + 3 * n6, 53);
                graphics.drawString("Rock Column", n + 2 * n6, 67);
            }
        }
        for (n3 = 0; n3 <= 4; ++n3) {
            n10 = 10 + n3 * 20;
            graphics.drawString("" + n10, n + 2 * n3 * n6, 100);
        }
        graphics.drawString("Percent", n + 7 * n6 / 2, 86);
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n7, 25);
        graphics.drawLine(n, 100, n7, 100);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void drawLithology(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        lithologyListStruct lithologyListStruct2 = this.stLASLithology;
        lithologyListStruct2 = this.stLASLithology;
        if (lithologyListStruct2 != null && lithologyListStruct2.iCount > 0) {
            if (lithologyListStruct2.stItem[0] != null) {
                d2 = lithologyListStruct2.stItem[0].depthStart;
                d3 = lithologyListStruct2.stItem[0].depthEnd;
                d = d3 - d2;
            }
            if ((n7 = (int)(5.0 / d * ((double)iqstratTracksStruct.SCALE[this.iScale] / 100.0))) < 1) {
                n7 = 1;
            }
            n11 = -1;
            for (n5 = 0; n5 < lithologyListStruct2.iCount; ++n5) {
                if (lithologyListStruct2.stItem[n5] == null) continue;
                d2 = lithologyListStruct2.stItem[n5].depthStart;
                d3 = d2 + d * (double)n7;
                for (n3 = 1; n3 < n7; ++n3) {
                    if (n5 >= lithologyListStruct2.iCount - 1) continue;
                    ++n5;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n8 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n8 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n9 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n9 = this.iHeight - (int)d4;
                }
                n10 = Math.abs(n9 - n8);
                if (n8 < 100 || n9 <= 100 || n8 >= this.iHeight || n9 >= this.iHeight) continue;
                if (this.iDataType == 1) {
                    n8 = n9;
                }
                if ((n12 = n10 / 5) == 0) {
                    n12 = 1;
                }
                for (n6 = 0; n6 < n12; ++n6) {
                    ++n11;
                    for (n4 = 0; n4 < 10; ++n4) {
                        if (lithologyListStruct2.stItem[n5] == null || lithologyListStruct2.stItem[n5].iLithology == null) continue;
                        this.plot.drawCell(graphics, lithologyListStruct2.stItem[n5].iLithology[n4], n11, n + n4 * 10, n8 + n6 * 5);
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = -1;
        switch (n) {
            case 32: {
                n4 = 0;
                graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
                graphics.fillRect(n2, 25, n3, 20);
                this.iFocus = 3;
                this.drawLithology(graphics, n2, n3);
                this.drawGrid(graphics, n2, n3);
                break;
            }
            case 33: {
                n4 = 0;
                graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
                graphics.fillRect(n2, 25, n3, 20);
                this.iFocus = 3;
                this.drawLithology(graphics, n2, n3);
                this.drawGrid(graphics, n2, n3);
                break;
            }
            case 34: {
                this.iColorlith = 6;
                n4 = 0;
                graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
                graphics.fillRect(n2, 25, n3, 20);
                this.iFocus = 4;
                this.drawLithology(graphics, n2, n3);
                this.drawGrid(graphics, n2, n3);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

