/*
 * Decompiled with CFR 0.152.
 */
package lith.lithology.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsUtility;

public class lithologyPlotSymbolLegend
extends Canvas {
    public static final int WIDTH = 250;
    private static final int TEXT = 18;
    private static final int ROW = 25;
    private static final int X_START = 30;
    private static final int Y_START = 30;
    private static final int _ROW = 60;
    private static final int X_DESC = 50;
    private static final int X_ABBREV = 290;
    private int iWidth = 250;
    private int iHeight = 950;
    private int TOTAL = 0;
    private lithologySymbolsListStruct stSymbols = null;
    private static final int _TOTAL = 13;
    private static final int[] _SYMBOLS = new int[]{10, 12, 7, 15, 18, 19, 21, 22, 24, 31, 32, 33, 44};
    private static final String[] SYMBOLS = new String[]{"Clay", "Shale", "Sandstone", "Sandstone", "Arkose", "Limestone", "Carbonate", "Dolomite", "Dolomite", "Gypsum", "Anhydrite", "Salt", "Coal"};
    private static final String[] SYMBOLS2 = new String[]{"", "", "", "Shaly", "", "", "Shaly", "", "Shaly", "", "", "", ""};

    public lithologyPlotSymbolLegend(lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.stSymbols = lithologySymbolsListStruct2;
        this.setBackground(Color.white);
    }

    public void close() {
        this.stSymbols = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public int getOrder(int n) {
        int n2 = 0;
        if (n > 1) {
            while (n > 1) {
                n -= 2;
            }
        }
        n2 = n;
        return n2;
    }

    public void drawCell(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawBlock(graphics, n, n3, n4, 10, 5);
        this.drawLithologySymbolMask(graphics, 5, this.getOrder(n2), lithologySymbolsUtility.getSymbol(n, this.stSymbols), n3, n4);
    }

    public void drawBlock(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{255, 255, 255};
        if (this.stSymbols != null) {
            nArray = this.stSymbols.stItem[n].iRGB;
        }
        graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void drawLithologySymbolMask(Graphics graphics, int n, int n2, String[][] stringArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int[] nArray = null;
        int n7 = 0;
        char[] cArray = null;
        for (n5 = 0; n5 < n; ++n5) {
            if (stringArray != null) {
                cArray = stringArray[n5][n2].toCharArray();
            }
            for (n6 = 0; n6 < cArray.length; ++n6) {
                if (this.stSymbols != null && cArray != null) {
                    n7 = lithologySymbolsUtility.getColor(cArray[n6], this.stSymbols.stForeground);
                }
                if (n7 <= -1) continue;
                if (this.stSymbols != null) {
                    nArray = lithologySymbolsUtility.getRGB(n7, this.stSymbols.stForeground);
                }
                graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                graphics.fillRect(n3 + n6, n4 + n5, 1, 1);
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = 1;
        boolean bl = false;
        int n7 = -1;
        int n8 = 0;
        Font font = new Font("Serif", 1, 10);
        graphics.setFont(font);
        if (n == 32 || n == 33) {
            for (int i = 0; i < 13; ++i) {
                int n9;
                for (n9 = 0; n9 < this.stSymbols.iCount; ++n9) {
                    if (_SYMBOLS[i] != this.stSymbols.stItem[n9].id) continue;
                    n5 = n9;
                }
                if (n4 < 650) {
                    n6 = 2;
                    if (i == 7) {
                        n7 = -1;
                        n8 = 60;
                    }
                    ++n7;
                } else {
                    ++n7;
                }
                for (n9 = 0; n9 < 4; ++n9) {
                    for (int j = 0; j < 4; ++j) {
                        this.drawCell(graphics, n5, this.getOrder(n9), 30 + n2 + n7 * 50 + j * 10, 30 + n8 + n3 + n9 * 5);
                    }
                }
                graphics.setColor(Color.black);
                graphics.drawString(SYMBOLS[i], 30 + n2 + n7 * 50, 30 + n8 + n3 - 5);
                graphics.drawString(SYMBOLS2[i], 30 + n2 + n7 * 50, 30 + n8 + n3 - 17);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

