/*
 * Decompiled with CFR 0.152.
 */
package lith.lithology.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsUtility;

public class lithologyPlotSymbol
extends Canvas
implements MouseListener {
    private Observable notifier = null;
    private lithologySymbolsListStruct stSymbols = null;
    private int iLithology = 0;
    private int iTotal = 0;
    private int TOTAL = 0;
    private int iGroup = -1;
    public static final int _NO_BACKGROUND = 0;
    public static final int _BACKGROUND = 1;
    private int iBackground = 1;
    public static final int _LAS = 0;
    public static final int _ROCK = 1;
    public static final int _TEXTURE_NO = 2;
    public static final int _TEXTURE = 3;
    private int iPanel = 1;
    private int iCount = 0;
    private int[][] iRow = null;
    public static final int WIDTH = 250;
    private static final int TEXT = 18;
    private static final int ROW = 25;
    private static final int X_START = 10;
    private static final int X_DESC = 50;
    private static final int X_ABBREV = 290;
    private int iWidth = 250;
    private int iHeight = 950;

    public lithologyPlotSymbol(lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.stSymbols = lithologySymbolsListStruct2;
        this.setBackground(Color.white);
        if (lithologySymbolsListStruct2 != null && lithologySymbolsListStruct2.stGroups != null && lithologySymbolsListStruct2.iCount > 0) {
            this.TOTAL = lithologySymbolsListStruct2.stGroups.iGroups + lithologySymbolsListStruct2.iCount;
            this.iRow = new int[lithologySymbolsListStruct2.iCount][2];
        }
        this.iHeight = (this.TOTAL + 5) * 25;
    }

    public lithologyPlotSymbol(Observable observable, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.notifier = observable;
        this.stSymbols = lithologySymbolsListStruct2;
        this.iPanel = 1;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        if (lithologySymbolsListStruct2 != null && lithologySymbolsListStruct2.stGroups != null && lithologySymbolsListStruct2.iCount > 0) {
            this.TOTAL = lithologySymbolsListStruct2.stGroups.iGroups + lithologySymbolsListStruct2.iCount;
            this.iRow = new int[lithologySymbolsListStruct2.iCount][2];
        }
        this.iHeight = (this.TOTAL + 5) * 25;
    }

    public lithologyPlotSymbol(Observable observable, int n, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.notifier = observable;
        this.stSymbols = lithologySymbolsListStruct2;
        this.iPanel = n;
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.iBackground = 0;
                break;
            }
            case 3: {
                this.iBackground = 1;
            }
        }
        this.iCount = 0;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        if (lithologySymbolsListStruct2 != null && lithologySymbolsListStruct2.stGroups != null && lithologySymbolsListStruct2.iCount > 0) {
            this.TOTAL = lithologySymbolsListStruct2.stGroups.iGroups + lithologySymbolsListStruct2.iCount;
            this.iRow = new int[lithologySymbolsListStruct2.iCount][2];
        }
        this.iHeight = (this.TOTAL + 5) * 25;
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        this.iRow = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public int getOrder(int n) {
        int n2 = 0;
        if (n > 1) {
            while (n > 1) {
                n -= 2;
            }
        }
        n2 = n;
        return n2;
    }

    public int getLithID() {
        return this.iLithology;
    }

    public void setGroup(int n) {
        this.iGroup = n;
        this.iTotal = 0;
        this.iCount = 0;
        this.iRow = null;
        if (this.stSymbols != null && this.stSymbols.stGroups != null && this.stSymbols.iCount > 0) {
            if (n == -1) {
                this.TOTAL = this.stSymbols.stGroups.iGroups + this.stSymbols.iCount;
                this.iRow = new int[this.stSymbols.iCount][2];
                this.iTotal = this.stSymbols.iCount;
            } else {
                this.TOTAL = 1;
                for (int i = 0; i < this.stSymbols.iCount; ++i) {
                    if (this.stSymbols.stItem[i].iGroup != n) continue;
                    ++this.TOTAL;
                    ++this.iTotal;
                }
                this.iRow = new int[this.iTotal][2];
            }
        }
        this.iHeight = (this.TOTAL + 5) * 25;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.iLithology = -1;
        if (this.iRow != null) {
            for (int i = 0; i < this.iCount; ++i) {
                if (this.iRow[i] == null || n2 < this.iRow[i][0] || n2 >= this.iRow[i][0] + 25) continue;
                this.iLithology = this.iRow[i][1];
            }
        }
        if (this.iLithology > -1) {
            switch (this.iPanel) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.notifier == null) break;
                    this.notifier.notifyObservers(new String("Litholgy Symbol Selected"));
                    break;
                }
            }
        }
    }

    public void drawCell(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (n != this.stSymbols.stItem[i].id) continue;
            n5 = i;
        }
        this.drawBlock(graphics, n5, n3, n4, 10, 5);
        this.drawLithologySymbolMask(graphics, 5, this.getOrder(n2), lithologySymbolsUtility.getSymbol(n5, this.stSymbols), n3, n4);
    }

    public void drawCell(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int[] nArray = new int[]{248, 248, 255};
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (n2 != this.stSymbols.stItem[i].id) continue;
            n6 = i;
        }
        if (n == 1 && this.stSymbols != null) {
            nArray = this.stSymbols.stItem[n6].iRGB;
        }
        this.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n4, n5, 10, 5);
        this.drawLithologySymbolMask(graphics, 5, this.getOrder(n3), lithologySymbolsUtility.getSymbol(n6, this.stSymbols), n4, n5);
    }

    public void drawBlock(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{255, 255, 255};
        if (this.stSymbols != null) {
            nArray = this.stSymbols.stItem[n].iRGB;
        }
        graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void drawBlock(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setColor(new Color(n, n2, n3));
        graphics.fillRect(n4, n5, n6, n7);
    }

    public void drawLithologySymbolMask(Graphics graphics, int n, int n2, String[][] stringArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int[] nArray = null;
        int n7 = 0;
        char[] cArray = null;
        for (n5 = 0; n5 < n; ++n5) {
            if (stringArray != null) {
                cArray = stringArray[n5][n2].toCharArray();
            }
            for (n6 = 0; n6 < cArray.length; ++n6) {
                if (this.stSymbols != null && cArray != null) {
                    n7 = lithologySymbolsUtility.getColor(cArray[n6], this.stSymbols.stForeground);
                }
                if (n7 <= -1) continue;
                if (this.stSymbols != null) {
                    nArray = lithologySymbolsUtility.getRGB(n7, this.stSymbols.stForeground);
                }
                graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                graphics.fillRect(n3 + n6, n4 + n5, 1, 1);
            }
        }
    }

    public int drawLithologyGroup(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        int n8 = 0;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        if (this.stSymbols != null && this.stSymbols.stGroups != null) {
            string = new String(this.stSymbols.stGroups.sGroups[n2][1]);
        }
        n8 = string.length();
        graphics.setColor(Color.black);
        graphics.drawString(string, (250 - 4 * n8) / 2, n);
        n3 += 18;
        for (n5 = 0; n5 < this.stSymbols.iCount; ++n5) {
            n4 = this.stSymbols.stItem[n5].id;
            if (this.stSymbols.stItem[n5].iGroup != n2) continue;
            if (this.iCount < this.iTotal) {
                this.iRow[this.iCount][0] = n3;
                this.iRow[this.iCount][1] = n4;
                ++this.iCount;
            }
            for (n6 = 0; n6 < 3; ++n6) {
                for (n7 = 0; n7 < 3; ++n7) {
                    this.drawCell(graphics, this.iBackground, n4, this.getOrder(n6), 10 + n7 * 10, n3 + n6 * 5);
                }
            }
            graphics.setColor(Color.black);
            graphics.drawString(this.stSymbols.stItem[n5].sName, 50, n3 + 10);
            n3 += 25;
        }
        return n3;
    }

    public void draw(Graphics graphics) {
        int n = 10;
        if (this.stSymbols != null && this.stSymbols.stGroups != null) {
            if (this.iGroup == -1) {
                for (int i = 0; i < this.stSymbols.stGroups.iGroups; ++i) {
                    n = this.drawLithologyGroup(graphics, n + 10, i);
                }
            } else {
                n = this.drawLithologyGroup(graphics, n + 10, this.iGroup);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

