/*
 * Decompiled with CFR 0.152.
 */
package lith.lithology.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lith.lithology.lithologyColorsStruct;
import lith.lithology.lithologyGroupsStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsStruct;
import lith.lithology.lithologySymbolsUtility;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadLithologySymbolsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "lithology";
    public static final String RECORDS = "records";
    public static final String BACKGROUND = "background";
    public static final String FOREGROUND = "foreground";
    public static final String COLOR = "color";
    public static final String SYMBOL = "symbol";
    public static final String RED = "r";
    public static final String GREEN = "g";
    public static final String BLUE = "b";
    public static final String GROUPS = "groups";
    public static final String GROUP = "group";
    public static final String MNEMONIC = "mnemonic";
    public static final String DESCRIPTION = "desc";
    public static final String MINERALS = "minerals";
    public static final String TYPE = "type";
    public static final String ROWS = "rows";
    public static final String WORDS = "words";
    public static final String MINERAL = "mineral";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String ID = "id";
    public static final String SHOW = "show";
    public static final String ORDER = "order";
    public static final String ABREV = "abrv";
    public static final String NAME = "name";
    public static final String SYMBOLS = "symbols";
    public static final String ROW = "row";
    public static final String LEFT = "l";
    public static final String RIGHT = "r";
    public static final String THESAURUS = "thesaurus";
    public static final String WORD = "word";
    public static final String PHRASE = "phrase";
    private static final int _NONE = 0;
    private static final int _BACKGROUND = 1;
    private static final int _FOREGROUND = 2;
    private static final int _COLOR = 3;
    private static final int _GROUPS = 4;
    private static final int _GROUP = 5;
    private static final int _MINERALS = 6;
    private static final int _MINERAL = 7;
    private static final int _COLUMN = 8;
    private static final int _SYMBOLS = 9;
    private static final int _SYMBOL = 10;
    private static final int _THESAURUS = 11;
    private static final int _WORD = 12;
    private int iRows = 0;
    private int iLines = 0;
    private int iColumns = 0;
    private int iCount = -1;
    private int iRow = 0;
    private int iData = 0;
    private int iColor = 0;
    private lithologySymbolsListStruct stList = new lithologySymbolsListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadLithologySymbolsXMLFile() {
        this.iType = 0;
    }

    public ReadLithologySymbolsXMLFile(int n) {
        this.iType = n;
    }

    public lithologySymbolsListStruct Process(String string) {
        this.Read(string);
        this.stList = lithologySymbolsUtility.setHierarchy(this.stList);
        this.stList = lithologySymbolsUtility.bubbleSort(this.stList);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadLithologySymbolsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadLithologySymbolsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        int n = 0;
        int n2 = 0;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(BACKGROUND)) {
            this.iRow = -1;
            this.iData = 1;
            this.iColor = 1;
            this.stList.stBackground = new lithologyColorsStruct();
        }
        if (string4.equals(FOREGROUND)) {
            this.iRow = -1;
            this.iData = 2;
            this.iColor = 2;
            this.stList.stForeground = new lithologyColorsStruct();
        }
        if (string4.equals(COLOR)) {
            this.iData = 3;
            ++this.iRow;
        }
        if (string4.equals(GROUPS)) {
            this.iRow = -1;
            this.iColor = 0;
            this.iData = 4;
            this.stList.stGroups = new lithologyGroupsStruct();
        }
        if (string4.equals(GROUP)) {
            this.iData = 5;
            ++this.iRow;
        }
        if (string4.equals(MINERALS)) {
            this.iRow = -1;
            this.iData = 6;
        }
        if (string4.equals(MINERAL)) {
            this.iData = 7;
            ++this.iRow;
            this.stList.stItem[this.iRow] = new lithologySymbolsStruct();
        }
        if (string4.equals(COLUMN)) {
            this.iData = 8;
        }
        if (string4.equals(SYMBOLS)) {
            this.iData = 9;
            this.iCount = -1;
        }
        if (string4.equals(SYMBOL)) {
            this.iData = 10;
        }
        if (string4.equals(THESAURUS)) {
            this.iData = 11;
            this.iCount = -1;
        }
        if (string4.equals(WORD)) {
            this.iData = 12;
            ++this.iCount;
        }
        if (attributes != null) {
            block21: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.stList.stBackground.iColors = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stBackground.sColors = new String[this.iRows];
                            this.stList.stBackground.iRGB = new int[this.iRows][3];
                            for (n = 0; n < this.iRows; ++n) {
                                this.stList.stBackground.sColors[n] = new String("");
                                for (n2 = 0; n2 < 3; ++n2) {
                                    this.stList.stBackground.iRGB[n][n2] = 255;
                                }
                            }
                            break;
                        }
                        case 2: {
                            this.stList.stForeground.iColors = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stForeground.colors = new char[this.iRows];
                            this.stList.stForeground.iRGB = new int[this.iRows][3];
                            for (n = 0; n < this.iRows; ++n) {
                                this.stList.stForeground.colors[n] = 32;
                                for (n2 = 0; n2 < 3; ++n2) {
                                    this.stList.stForeground.iRGB[n][n2] = 255;
                                }
                            }
                            break;
                        }
                        case 4: {
                            this.stList.stGroups.iGroups = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stGroups.sGroups = new String[this.iRows][2];
                            for (n = 0; n < this.iRows; ++n) {
                                for (n2 = 0; n2 < 2; ++n2) {
                                    this.stList.stGroups.sGroups[n][n2] = new String("");
                                }
                            }
                            break;
                        }
                        case 6: {
                            this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new lithologySymbolsStruct[this.iRows];
                            break;
                        }
                        case 9: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem[this.iRow].symbol = new String[this.iRows][2];
                            for (n = 0; n < this.iRows; ++n) {
                                for (n2 = 0; n2 < 2; ++n2) {
                                    this.stList.stItem[this.iRow].symbol[n][n2] = new String("..........");
                                }
                            }
                            break;
                        }
                        case 11: {
                            this.stList.stItem[this.iRow].iThesaurus = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem[this.iRow].sThesaurus = new String[this.iRows];
                            for (n = 0; n < this.iRows; ++n) {
                                this.stList.stItem[this.iRow].sThesaurus[n] = new String("");
                            }
                            break;
                        }
                    }
                }
                switch (this.iData) {
                    case 3: {
                        switch (this.iColor) {
                            case 2: {
                                this.stList.stForeground = this.ParseData(string5, string7.trim(), this.stList.stForeground);
                                break;
                            }
                            case 1: {
                                this.stList.stBackground = this.ParseData(string5, string7.trim(), this.stList.stBackground);
                            }
                        }
                        continue block21;
                    }
                    case 5: {
                        this.stList.stGroups = this.ParseData(string5, string7.trim(), this.stList.stGroups);
                        continue block21;
                    }
                    case 6: {
                        if (string5.equals(ROWS) && cmnString.isNumeric(string7.trim())) {
                            this.iLines = cmnString.stringToInt(string7.trim());
                        }
                        if (!string5.equals(COLUMNS) || !cmnString.isNumeric(string7.trim())) continue block21;
                        this.iColumns = cmnString.stringToInt(string7.trim());
                        continue block21;
                    }
                    case 8: {
                        this.stList.stItem[this.iRow] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iRow]);
                        continue block21;
                    }
                    case 10: {
                        this.stList.stItem[this.iRow] = this.ParseSymbol(string5, string7.trim(), this.stList.stItem[this.iRow]);
                        continue block21;
                    }
                    case 12: {
                        if (!string5.equals(PHRASE)) continue block21;
                        this.stList.stItem[this.iRow].sThesaurus[this.iCount] = new String(string7.trim());
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private lithologyColorsStruct ParseData(String string, String string2, lithologyColorsStruct lithologyColorsStruct2) {
        char[] cArray = null;
        if (string.equals(SYMBOL)) {
            switch (this.iColor) {
                case 1: {
                    lithologyColorsStruct2.sColors[this.iRow] = new String(string2);
                    break;
                }
                case 2: {
                    cArray = string2.toCharArray();
                    if (cArray.length <= 0) break;
                    lithologyColorsStruct2.colors[this.iRow] = cArray[0];
                }
            }
        }
        if (string.equals("r") && this.iRow > -1 && cmnString.isNumeric(string2)) {
            lithologyColorsStruct2.iRGB[this.iRow][0] = cmnString.stringToInt(string2);
        }
        if (string.equals(GREEN) && this.iRow > -1 && cmnString.isNumeric(string2)) {
            lithologyColorsStruct2.iRGB[this.iRow][1] = cmnString.stringToInt(string2);
        }
        if (string.equals(BLUE) && this.iRow > -1 && cmnString.isNumeric(string2)) {
            lithologyColorsStruct2.iRGB[this.iRow][2] = cmnString.stringToInt(string2);
        }
        return lithologyColorsStruct2;
    }

    private lithologyGroupsStruct ParseData(String string, String string2, lithologyGroupsStruct lithologyGroupsStruct2) {
        if (string.equals(MNEMONIC)) {
            lithologyGroupsStruct2.sGroups[this.iRow][0] = new String(string2);
        }
        if (string.equals(DESCRIPTION)) {
            lithologyGroupsStruct2.sGroups[this.iRow][1] = new String(string2);
        }
        return lithologyGroupsStruct2;
    }

    private lithologySymbolsStruct ParseData(String string, String string2, lithologySymbolsStruct lithologySymbolsStruct2) {
        String string3 = "";
        int n = -1;
        if (string.equals(ID) && cmnString.isNumeric(string2)) {
            lithologySymbolsStruct2.id = cmnString.stringToInt(string2);
        }
        if (string.equals(SHOW) && string2.equals("yes")) {
            lithologySymbolsStruct2.iShow = 1;
            lithologySymbolsStruct2.iExtend = 1;
        }
        if (string.equals(ORDER) && cmnString.isNumeric(string2)) {
            lithologySymbolsStruct2.iOrder = cmnString.stringToInt(string2);
        }
        if (string.equals(GROUP) && this.stList.stGroups != null) {
            lithologySymbolsStruct2.iGroup = lithologySymbolsUtility.getGroupID(0, string2, this.stList.stGroups);
            lithologySymbolsStruct2.sGroup = new String(lithologySymbolsUtility.getGroup(1, lithologySymbolsStruct2.iGroup, this.stList.stGroups));
        }
        if (string.equals(COLOR)) {
            n = lithologySymbolsUtility.getColor(string2, this.stList.stBackground);
            lithologySymbolsStruct2.iRGB = lithologySymbolsUtility.getRGB(n, this.stList.stBackground);
        }
        if (string.equals(MNEMONIC)) {
            lithologySymbolsStruct2.sMnemonic = new String(string2);
        }
        if (string.equals(ABREV)) {
            lithologySymbolsStruct2.sAbrev = new String(string2);
        }
        if (string.equals(NAME)) {
            lithologySymbolsStruct2.sName = new String(string2);
        }
        return lithologySymbolsStruct2;
    }

    private lithologySymbolsStruct ParseSymbol(String string, String string2, lithologySymbolsStruct lithologySymbolsStruct2) {
        if (string.equals(ROW)) {
            lithologySymbolsStruct2.iRows = this.iLines;
            lithologySymbolsStruct2.iColumns = this.iColumns;
            if (cmnString.isNumeric(string2)) {
                this.iCount = cmnString.stringToInt(string2);
            }
        }
        if (string.equals(LEFT)) {
            lithologySymbolsStruct2.symbol[this.iCount][0] = new String(string2);
        }
        if (string.equals("r")) {
            lithologySymbolsStruct2.symbol[this.iCount][1] = new String(string2);
        }
        return lithologySymbolsStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

