/*
 * Decompiled with CFR 0.152.
 */
package lith.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import lith.lithConstants;

public class lithChemicalTexturePanel
extends JPanel
implements ActionListener {
    private Observable notifier = null;
    public static final String[] XLN = lithConstants.XLN;
    public static final int[][] XLN_COLOR = lithConstants.XLN_COLOR;
    public static final String[] XLN2 = lithConstants.XLN2;
    public static final int[][] XLN_COLOR2 = lithConstants.XLN_COLOR2;
    public static final int[][] PRIMARY_SIZE = lithConstants.PRIMARY_SIZE;
    private int iRock = -1;
    private int iTexture = -1;
    private String sTexture = "";
    private JRadioButton[] rb = null;
    private JRadioButton[] rbP = null;

    public lithChemicalTexturePanel(Observable observable) {
        try {
            this.notifier = observable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        int[][] nArray = null;
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
        jPanel4.setLayout(new GridLayout(7, 1));
        jPanel4.setBackground(new Color(255, 255, 255));
        this.rb = new JRadioButton[14];
        nArray = XLN_COLOR;
        stringArray = XLN;
        for (n = 13; n > -1; --n) {
            this.rb[n] = new JRadioButton();
            this.rb[n].setFont(new Font("Monospaced", 1, 11));
            this.rb[n].setHorizontalAlignment(2);
            this.rb[n].setBackground(new Color(nArray[n][0], nArray[n][1], nArray[n][2]));
            if (n == 0 || n == 1) {
                this.rb[n].setForeground(new Color(255, 255, 255));
            }
            this.rb[n].setText(stringArray[n]);
            if (stringArray[n].length() == 0) {
                this.rb[n].setEnabled(false);
            }
            this.rb[n].addActionListener(this);
            if (n == 0 || n == 1 || n == 2 || n == 3 || n == 5 || n == 7 || n == 9) {
                jPanel4.add((Component)this.rb[n], null);
            }
            buttonGroup.add(this.rb[n]);
        }
        this.rbP = new JRadioButton[85];
        for (n = 0; n < 85; ++n) {
            this.rbP[n] = new JRadioButton();
            this.rbP[n].setFont(new Font("Monospaced", 1, 11));
            this.rbP[n].setHorizontalAlignment(2);
            this.rbP[n].setBackground(new Color(255, 255, 255));
            this.rbP[n].setText(lithConstants.PRIMARY[n][0]);
            this.rbP[n].addActionListener(this);
            buttonGroup2.add(this.rbP[n]);
        }
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(new Color(255, 255, 255));
        jPanel3 = this.buildPanel();
        this.add((Component)jPanel4, "West");
        this.add((Component)jPanel2, "Center");
        jPanel2.add((Component)jPanel3, "Center");
    }

    private JPanel buildPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Carbonates");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Sulfates");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Chlorides");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Phosphates");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder5 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Iron Minerals");
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        jPanel.setLayout(new GridLayout(5, 1));
        jPanel.setBackground(new Color(255, 255, 255));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.setBorder(titledBorder);
        jPanel2.setBackground(new Color(255, 255, 255));
        jPanel2.add((Component)this.rbP[20], null);
        jPanel2.add((Component)this.rbP[23], null);
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.setBorder(titledBorder2);
        jPanel3.setBackground(new Color(255, 255, 255));
        jPanel3.add((Component)this.rbP[37], null);
        jPanel3.add((Component)this.rbP[38], null);
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.setBorder(titledBorder3);
        jPanel4.setBackground(new Color(255, 255, 255));
        jPanel4.add((Component)this.rbP[40], null);
        jPanel4.add((Component)this.rbP[41], null);
        jPanel4.add((Component)this.rbP[42], null);
        jPanel5.setLayout(new GridLayout());
        jPanel5.setBorder(titledBorder4);
        jPanel5.setBackground(new Color(255, 255, 255));
        jPanel5.add((Component)this.rbP[39], null);
        jPanel6.setLayout(new GridLayout(4, 1));
        jPanel6.setBorder(titledBorder5);
        jPanel6.setBackground(new Color(255, 255, 255));
        jPanel6.add((Component)this.rbP[46], null);
        jPanel6.add((Component)this.rbP[43], null);
        jPanel6.add((Component)this.rbP[45], null);
        jPanel6.add((Component)this.rbP[44], null);
        jPanel.add((Component)jPanel2, null);
        jPanel.add((Component)jPanel3, null);
        jPanel.add((Component)jPanel4, null);
        jPanel.add((Component)jPanel5, null);
        jPanel.add((Component)jPanel6, null);
        return jPanel;
    }

    public int getLithology() {
        return this.iRock;
    }

    public int getTexture() {
        return this.iTexture;
    }

    public String getTextureDesc() {
        return this.sTexture;
    }

    private void setTextureBTNS(int n) {
        int[][] nArray = null;
        String[] stringArray = null;
        this.iRock = n;
        switch (n) {
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                stringArray = XLN2;
                nArray = XLN_COLOR2;
                break;
            }
            default: {
                stringArray = XLN;
                nArray = XLN_COLOR;
            }
        }
        if (n > -1) {
            for (int i = 13; i > -1; --i) {
                if (PRIMARY_SIZE[n][i] != 1 && PRIMARY_SIZE[n][i] != 2) continue;
                this.rb[i].setBackground(new Color(nArray[i][0], nArray[i][1], nArray[i][2]));
                if (PRIMARY_SIZE[n][i] == 2) {
                    this.rb[i].setSelected(true);
                    this.setTexture(i);
                }
                this.rb[i].setText(stringArray[i]);
            }
        }
    }

    private void setTexture(int n) {
        String[] stringArray = null;
        switch (this.iRock) {
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                stringArray = XLN2;
                break;
            }
            default: {
                stringArray = XLN;
            }
        }
        this.sTexture = new String(stringArray[n]);
        this.iTexture = n + 1;
    }

    public void close() {
        int n = 0;
        this.notifier = null;
        this.sTexture = null;
        for (n = 0; n < 14; ++n) {
            this.rb[n] = null;
        }
        for (n = 0; n < 85; ++n) {
            this.rbP[n] = null;
        }
        this.rb = null;
        this.rbP = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        for (n = 0; n < 14; ++n) {
            if (actionEvent.getSource() != this.rb[n]) continue;
            this.setTexture(n);
        }
        for (n = 0; n < 85; ++n) {
            if (actionEvent.getSource() != this.rbP[n]) continue;
            this.setTextureBTNS(n);
        }
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Primary Chemical Selected"));
        }
    }
}

